c
c--   To be added:
c---  if some of the fractions become too small fix them to zero.
c---  small could be 0.1 or 0.05. Would of course be better if we could
c---  make a probabilistic decision
c
      subroutine refine_ls_parameters(
     &     nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
c
c---  Initialise ls scale parameters
c-------------------------------------------------------------------
c
c---  inputs
      implicit none
      include 'agreem.fh'
      include 'twin_refmac.fh'
      include 'celsym.fh'
      include 'ls_params_save.fh'


      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
c---  Outputs. Scale parameters are in agreem.fh
      integer ierr
c
c---  locals
      integer num_p,np1,np2,np3,np0,np6
      real, allocatable :: dfdp1(:) 
      real, allocatable :: dfdp1dp2(:,:)
      real, allocatable :: shift(:)
      real, allocatable :: par0(:)
      real toler

      integer i,ncycle_ls,j,k,j1
      integer ip
c---  locals for line minimisation
      logical abnormal_exit
      real fold,g2p
      real r1,r2,tmp,tst,a,b
      real d1,d2,f_value,rfac_i,rfac_w_i,rfac_f
      real lambd,lambd2,lambdmin,lam0,l12
      real f1,f2,d2p
      real tol_conv,al0,tol_conv1,tol1
      parameter (tol_conv = 1.0e-8)
      parameter (tol_conv1 = 1.0e-6)
      parameter (al0 = 1.0e-4)
      real dot_r
      external dot_r
c
c---  testing
      integer nwork,info,nt
      real, allocatable :: workspace(:)
      real, allocatable :: evalue(:)
c
c---- body
c--------------------------------------------------------------
      toler = 1.0E-8
      tol1  = 1.0e-5
c
c--   The number of parmaters: ntwin_domain-1 + 2 (overall scale) + 5 (aniso b 
c---  with trace zero) + 2 (Babinet) +2*npart (partials, solvent etc)
      num_p = ntwin_domain+2*npart_act+8
c
c--   allocate memory    
      if(.not.allocated(dfdp1)) allocate(dfdp1(num_p))
      if(.not.allocated(dfdp1dp2)) allocate(dfdp1dp2(num_p,num_p))
      if(.not.allocated(shift)) allocate(shift(num_p))
      allocate(par0(num_p))
c------------------------------
c      write(*,*)scale_ls_bulk,bulk_ls_flag
      ncycle_ls = 40
c      write(*,*)'Problem here'
      do i = 1,ncycle_ls
         call copy_ls_params_twin(num_p,npart_act,par0)
c
        call derivative_df_dp(nasym,hkl_asym,fcalc,npart_act,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        num_p,dfdp1,dfdp1dp2,f_value,
     &        ierr)
        call fix_params_ls_twin(npart_act,num_p,dfdp1,dfdp1dp2)
         fold = f_value
c
c--   Fix parameters if necesary
         np0 = num_p-7
         np1 = num_p-2
         np2 = num_p-1
         np3 = num_p 
         shift(1:np3) = 0.0
c         write(*,*)dfdp1(1:num_p)
         
c         call print_ls_scale
         call eigen_filter_r90(toler,dfdp1dp2(1:np0,1:np0),np0,np0,
     &        dfdp1(1:np0),shift(1:np0),ierr)
         np6 = num_p-6
c         do k=np6,np1
c            write(*,*)dfdp1dp2(np6:np1,k)
c         enddo
         call eigen_filter_r90(tol1,dfdp1dp2(np6:np1,np6:np1),5,5,
     &        dfdp1(np6:np1),shift(np6:np1),ierr)
         if(bulk_ls_flag) then
            call eigen_filter_r90(tol1,dfdp1dp2(np2:np3,np2:np3),2,2,
     &           dfdp1(np2:np3),shift(np2:np3),ierr)
         endif

c
c---  Find initial shift length. make sure that parameters are reasonable
         call init_lambd_ls_twin(num_p,npart_act,shift,lambd)
c         write(*,*)shift(1:num_p)
         shift(1:num_p) = shift(1:num_p)*lambd
         g2p = dot_product(shift,dfdp1)
         tst = 0.0
c
c---  Line minimisation
         do  j=1,num_p
            tst = max(tst,abs(shift(j))/max(abs(par0(j)),1.0))
         enddo
         lambdmin = tol_conv1/tst
         lambd = 1.0      
         call save_params_ls_twin(npart_act)
         abnormal_exit = .FALSE.
c         write(*,*)'Before line min'
         f1 = 1.0e32
         j=0
         do while(lambd.gt.lambdmin.and.f1.gt.fold-al0*g2p.and.j.le.100)
            j = j + 1
            call add_shift_ls0_twin(num_p,npart_act,lambd,shift)
            call  fvalue_ls_intens(nasym,hkl_asym,fcalc,npart_act,fpart,
     &           num_blocks,block_start,ref_2_asym_start,
     &           nobs,iobs,obs_start,
     &           ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &           num_asym_ref,block_2_asym,
     &           f1,
     &           ierr)     
c---  Shifts are too small or convergence have been reached
c
c---  Try new point and use interpolations
c            write(*,*)f1,fold,g2p
            if(j.eq.1) then
               tmp = g2p/(2.0*(f1-fold+g2p))
            else
c               write(*,*)'line min',f1,fold,g2p,lambd,lambd2
c               stop
               l12 = lambd-lambd2
               r1 = f1-fold+lambd*g2p
               r2 = f2-fold+lambd2*g2p
               a  = (r1/lambd**2-r2/lambd2**2)/l12
               b = (-lambd2*r1/lambd**2+lambd*r2/lambd2**2)/l12
               if(a.eq.0.0) then
                  tmp = g2p/(2.0*b)
               else
                  d1 = max(0.0,b**2+3.0*a*g2p)
                  tmp = (-b+sqrt(d1))/(3.0*a)
               endif
            endif
c            write(*,*)tmp
            tmp = min(tmp,0.5*lambd)
            lambd2 = lambd
            f2 = f1
            lambd = max(tmp,0.1*lambd)
c            write(*,*)j,f1,fold,g2p,tmp,lambd
c            stop
         enddo
c         write(*,*)f1,fold
         if(j.gt.100) abnormal_exit = .TRUE.
         if(abnormal_exit) write(*,*)'Abnormal exit from linmin'
 20      continue
c
c---  Check the convergence
         tst = 0.0
         do  j=1,num_p
            tst = max(tst,abs(shift(j))*lambd/max(abs(par0(j)),1.0))
         enddo
         tst = g2p*lambd/num_p
         if(tst.lt.tol_conv.or.f1.ge.fold.or.abnormal_exit) then 
            if(f1.gt.fold.or.abnormal_exit) then
               call restore_params_ls_twin(npart_act)
            endif
            goto 30
         endif
      enddo
 30   continue
c
c      write(*,*)'Problem here'
      deallocate (dfdp1)
      deallocate (dfdp1dp2)
      deallocate (shift)
      deallocate (par0)
c      write(*,*)i
c      stop
c----------------------
      return 
      end
c
      subroutine derivative_df_dp(
     &        nasym,hkl_asym,fcalc,npart_act,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        num_p,dfdp1,dfdp1dp2,f_value,
     &        ierr)
      implicit none
      include 'agreem.fh'
      include 'twin_refmac.fh'
      include 'celsym.fh'
c---  inputs

      integer nasym
      integer npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
      integer num_p
c
c---  Outputs
      integer ierr
      real dfdp1(num_p)
      real dfdp1dp2(num_p,num_p)
      real f_value
c
c---  locals
      integer i,j,m,k,is,jc,jal,ia,ii
      integer maxpart_l,maxcont_l
      parameter (maxpart_l = 3)
      parameter (maxcont_l = 48)
      real Ict,Ict0,fct
      real Ic(maxcont_l)
      real dsdandb(6),dIct_dp(maxcont_l)
      real dfh_dp(48)
c
      integer il
      integer o_s,o_f,c_s,c_f
      integer c_1,c_n,ip,ip1
      integer obs_contributor_start,obs_contributor_finish
      integer contri_number_obs,obs_num
      real w,fh1,fh2,fh,dfh_dIct
      real rsq,ss,ss1
      real expb,expbs,expbsres,expbulk,expbulks,expbulksres
      real bulk_cont,expbs_bulk,expban,bans,exp1
      real ss_v(6),hkl_this(3),hkl_sym(3),s_this(3)
      real a_all,b_all,a_part(maxpart_l),b_part(maxpart_l)
      real falp,Ic1,Ic2,Ic3
      real part_expb(maxpart_l)
      real part_expbs(maxpart_l)
      real part_expbsres(maxpart_l)
      real dIc_dps(maxcont_l,maxpart_l),dIc_dpb(maxcont_l,maxpart_l)
      real dIc_dan(maxcont_l,6),dIc_dalpha(maxcont_l)
      real dIc_dovs(maxcont_l),dIc_dovb(maxcont_l)
      real dIc_dbulks(maxcont_l),dIc_dbulkb(maxcont_l)
      real dIct_dalpha(maxcont_l),dIct_danis(6)
      real dIct_dps(maxpart_l),dIct_dpb(maxpart_l)
      real dIct_dovs,dIct_dovb,dIct_dbulks,dIct_dbulkb

      integer ierror
      logical error
c
      real lstlsq_r
c
c---  Body
      dfdp1(1:num_p)            = 0.0
      dfdp1dp2(1:num_p,1:num_p) = 0.0
      f_value                   = 0.0
c      write(*,*)nsym
c      write(*,*)rfr
c      stop
c     
      do i=1,num_blocks
c     
c---  Define necessary pointers to contributors and observations
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
c
c---  Calculate all necessary properties of contributors to the reflections
         jc = 0
         Ic(1:maxcont_l) = 0.0
         do m=c_s,c_f
            jc            = jc + 1
            c_n           = block_2_asym(m)
            a_all         = fcalc(1,c_n)
            b_all         = fcalc(2,c_n)
            ss = lstlsq_r(1,hkl_asym(1:3,c_n))
            expb        = exp(-ss*b_ls_over)
            expbs       = expb*scale_ls_over
            expbsres    = -expbs*ss
            expbulk     = -exp(-ss*b_ls_bulk)
            expbulks    = scale_ls_bulk*expbulk
            expbulksres = -ss*expbulks
            bulk_cont   = 1.0+expbulks
            expbs_bulk  = bulk_cont*expbs

            hkl_this(1:3) = hkl_asym(1:3,c_n)
            expban        = 0.0
            dsdandb(1:6)  = 0.0
            do  is=1,nsym
               hkl_sym = matmul(transpose(rot(1:3,1:3,is)),hkl_this)
               s_this  = matmul(transpose(rfr),hkl_sym)
               ss_v(1) = s_this(1)*s_this(1)
               ss_v(2) = s_this(2)*s_this(2)
               ss_v(3) = s_this(3)*s_this(3)
               ss_v(4) = 2.0*s_this(1)*s_this(2)
               ss_v(5) = 2.0*s_this(1)*s_this(3)
               ss_v(6) = 2.0*s_this(2)*s_this(3)
               bans    = ss_v(1)*b_ls_aniso_over(1)+
     &                   ss_v(2)*b_ls_aniso_over(2)+
     &                   ss_v(3)*b_ls_aniso_over(3)+
     &                   ss_v(4)*b_ls_aniso_over(4)+
     &                   ss_v(5)*b_ls_aniso_over(5)+
     &                   ss_v(6)*b_ls_aniso_over(6)
               exp1         = exp(-bans/4.0)
               expban       = expban + exp1
               dsdandb(1:6) = dsdandb(1:6) - ss_v(1:6)*exp1
               ss1 = sum(s_this**2)
            enddo
            expban = expban/nsym
            dsdandb(1:6) = dsdandb(1:6)/(4*nsym) 
c
c---  Calculate anisotropic scales and derivatives wrt them.
            do ip=1,npart_act
               part_expb(ip)  = exp(-b_ls_part(ip)*ss)
               part_expbs(ip) = part_expb(ip)*scale_ls_part(ip)
               part_expbsres(ip) = -ss*part_expbs(ip)
               a_part(ip) = fpart(ip,1,c_n)
               b_part(ip) = fpart(ip,2,c_n)
               a_all = a_all + a_part(ip)*part_expbs(ip)
               b_all = b_all + b_part(ip)*part_expbs(ip)
            enddo
C     
C---  Derivatives corresponding to contributors
            Ic(jc) = a_all**2+b_all**2
            do  ip=1,npart_act
               falp  = 2.0*(a_all*a_part(ip)+ b_all*b_part(ip))
               falp = falp*expbs_bulk*expban
               dIc_dps(jc,ip) = falp*part_expb(ip)
               dIc_dpb(jc,ip) = falp*part_expbsres(ip)
            enddo
            Ic1 = Ic(jc)*expbs_bulk
            dIc_dan(jc,1:6) = Ic1*dsdandb(1:6)

            Ic2 = Ic(jc)*expban
            Ic3 = Ic2*bulk_cont
            dIc_dovs(jc) = Ic3*expb
            dIc_dovb(jc) = Ic3*expbsres

            Ic3 = Ic2*expbs
            dIc_dbulks(jc) = Ic3*expbulk
            dIc_dbulkb(jc) = Ic3*expbulksres
            Ic(jc) = Ic(jc)*expban*expbs_bulk
         enddo
c     
c---  go through each observation in that block
         do j=o_s,o_f
            obs_contributor_start    = obs_start(j)+1
            obs_contributor_finish   = obs_start(j+1)
            Ict0                     = 0.0
            dIct_dalpha(1:maxcont_l) = 0.0
            dIct_danis(1:6)          = 0.0
            dIct_dps(1:npart_act)    = 0.0
            dIct_dpb(1:npart_act)    = 0.0
            dIct_dovs                = 0.0
            dIct_dovb                = 0.0
            dIct_dbulks              = 0.0
            dIct_dbulkb              = 0.0
            do k=obs_contributor_start,obs_contributor_finish
c     
c---  Find position of this contributor and domain number (alpha)
               jc   = ref_2_asym(k)
               jal  = comp_numb(k)
               Ict0 = Ict0 + Ic(jc)*twin_frac(jal)
               dIct_dalpha(jal) = dIct_dalpha(jal) + Ic(jc)
               dIct_danis(1:6)  = dIct_danis(1:6) + 
     &              twin_frac(jal)*dIc_dan(jc,1:6)
               dIct_dps(1:npart_act)  = dIct_dps(1:npart_act) + 
     &              twin_frac(jal)*dIc_dps(jc,1:npart_act)
               dIct_dpb(1:npart_act)  = dIct_dpb(1:npart_act) + 
     &              twin_frac(jal)*dIc_dpb(jc,1:npart_act)
               dIct_dovs = dIct_dovs + twin_frac(jal)*dIc_dovs(jc)
               dIct_dovb = dIct_dovb + twin_frac(jal)*dIc_dovb(jc)
               dIct_dbulks = dIct_dbulks + twin_frac(jal)*dIc_dbulks(jc)
               dIct_dbulkb = dIct_dbulkb + twin_frac(jal)*dIc_dbulkb(jc)
            enddo
            Ict = Ict0
            w   = 1.0
c     w=2.0*iobs(2,j)**2.0+ c0*(max(0.0,iobs(1,j))+Ict)
            fct = sqrt(Ict)
            fh1 = Ict - max(-3.0*iobs(2,j),iobs(1,j))
            fh2 = fct+sqrt(max(0.001*iobs(2,j),iobs(1,j)))
            fh = fh1/fh2
c            fh = fct - sqrt(max(0.000*iobs(2,j),iobs(1,j)))
c            dfh_dIct = 0.5/fct
            dfh_dIct = 0.0
c            if(iobs(1,j).gt.2.0*iobs(2,j)) then
               if(fct.gt.0.0) then
                  dfh_dIct = 1/fh2 - 0.5*fh1/(fct*fh2**2)
               else
                  dfh_dIct = 0.0
               endif
               f_value=f_value+0.5*fh**2
c            endif
c     
c---  Calculate derivatise
c     
c---  twin
            if(ntwin_domain.gt.1) then
               do ia=1,ntwin_domain-1
                  dIct_dp(ia) =
     &                 (dIct_dalpha(ia+1)-dIct_dalpha(1))
               enddo
            endif
c     
c---  Overall scales
            ip = ntwin_domain
            dIct_dp(ip) = dIct_dovs
            ip = ip + 1
            dIct_dp(ip) = dIct_dovb
            ip = ip + 1
c     
c---  Partials
            do  ii=1,npart_act
               dIct_dp(ip) = dIct_dps(ii)
               ip = ip + 1
               dIct_dp(ip) = dIct_dpb(ii)
               ip = ip + 1
            enddo
c     
c---  aniso
            dIct_dp(ip) = (dIct_danis(1)-dIct_danis(3))
            ip = ip +1
            dIct_dp(ip) = (dIct_danis(2)-dIct_danis(3))
            ip = ip +1 
            dIct_dp(ip:(ip+2)) = dIct_danis(4:6)
            ip = ip + 3
c     
c---  Bulk solvent
            dIct_dp(ip) = dIct_dbulks
            ip = ip + 1
            dIct_dp(ip) = dIct_dbulkb
c
c---  Compute derivatives of the function           
            dfh_dp(1:num_p) = dfh_dIct*dIct_dp(1:num_p)
            dfdp1(1:num_p) = dfdp1(1:num_p)+fh*dfh_dp(1:num_p)
            do ip=1,num_p
               dfdp1dp2(ip,1:num_p)=dfdp1dp2(ip,1:num_p)+
     &              dfh_dp(ip)*dfh_dp(1:num_p)
            enddo
c     
c---  end of observations in block
         enddo 
c     
c---  end of blocks      
      enddo

      return 
      end
c
      subroutine fvalue_ls_intens(
     &        nasym,hkl_asym,fcalc,npart_act,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        f_value,
     &        ierr)
      implicit none
      include 'agreem.fh'
      include 'twin_refmac.fh'
      include 'celsym.fh'
c---  inputs

      integer nasym
      integer npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
c
c---  Outputs
      integer ierr
      real f_value
c
c---  locals
      integer i,j,m,k,is,jc,jal,ia,ii
      integer maxpart_l,maxcont_l
      parameter (maxpart_l = 3)
      parameter (maxcont_l = 48)
      real Ict,Ict0,fct
      real Ic(maxcont_l)
c
      integer il
      integer o_s,o_f,c_s,c_f
      integer c_1,c_n,ip,ip1
      integer obs_contributor_start,obs_contributor_finish
      integer contri_number_obs,obs_num
      real w,fh1,fh2,fh,dfh_dIct
      real rsq,ss
      real expb,expbs,expbsres,expbulk,expbulks,expbulksres
      real bulk_cont,expbs_bulk,expban,bans,exp1
      real part_expbs
      real ss_v(6),hkl_this(3),hkl_sym(3),s_this(3)
      real a_all,b_all
      integer ierror
      logical error
c
      real lstlsq_r
c
c---  Body

      f_value                   = 0.0
c     
      do i=1,num_blocks
c     
c---  Define necessary pointers to contributors and observations
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
c
c---  Calculate all necessary properties of contributors to the reflections
         jc = 0
         Ic(1:maxcont_l) = 0.0
         do m=c_s,c_f
            jc            = jc + 1
            c_n           = block_2_asym(m)
            a_all         = fcalc(1,c_n)
            b_all         = fcalc(2,c_n)
            ss = lstlsq_r(1,hkl_asym(1:3,c_n))
            expbs        = scale_ls_over*exp(-ss*b_ls_over)
            bulk_cont     = 1.0-scale_ls_bulk*exp(-ss*b_ls_bulk)
            expbs_bulk = expbs*bulk_cont
            hkl_this(1:3) = hkl_asym(1:3,c_n)
            expban        = 0.0
            do  is=1,nsym
               hkl_sym=matmul(transpose(rot(1:3,1:3,is)),hkl_this)
               s_this=matmul(transpose(rfr),hkl_sym)
               ss_v(1) = s_this(1)*s_this(1)
               ss_v(2) = s_this(2)*s_this(2)
               ss_v(3) = s_this(3)*s_this(3)
               ss_v(4) = 2.0*s_this(1)*s_this(2)
               ss_v(5) = 2.0*s_this(1)*s_this(3)
               ss_v(6) = 2.0*s_this(2)*s_this(3)
               bans    = ss_v(1)*b_ls_aniso_over(1)+
     &                   ss_v(2)*b_ls_aniso_over(2)+
     &                   ss_v(3)*b_ls_aniso_over(3)+
     &                   ss_v(4)*b_ls_aniso_over(4)+
     &                   ss_v(5)*b_ls_aniso_over(5)+
     &                   ss_v(6)*b_ls_aniso_over(6)
               exp1         = exp(-bans/4.0)
               expban       = expban + exp1
            enddo
            expban = expban/nsym
c
c---  Calculate anisotropic scales and derivatives wrt them.
            do ip=1,npart_act
               part_expbs  = scale_ls_part(ip)*exp(-b_ls_part(ip)*ss)
               a_all = a_all + fpart(ip,1,c_n)*part_expbs
               b_all = b_all + fpart(ip,2,c_n)*part_expbs
            enddo
C     
C---  Derivatives corresponding to contributors
            Ic(jc) = a_all**2+b_all**2
            Ic(jc) = Ic(jc)*expbs_bulk*expban
         enddo
c     
c---  go through each observation in that block
         do j=o_s,o_f
            obs_contributor_start    = obs_start(j)+1
            obs_contributor_finish   = obs_start(j+1)
            Ict                      = 0.0
            do k=obs_contributor_start,obs_contributor_finish
c     
c---  Find position of this contributor and domain number (alpha)
               jc   = ref_2_asym(k)
               jal  = comp_numb(k)
               Ict  = Ict  + Ic(jc)*twin_frac(jal)
            enddo
            fct = sqrt(Ict)
            fh1 = Ict - max(-3.0*iobs(2,j),iobs(1,j))
            fh2 = fct+sqrt(max(0.001*iobs(2,j),iobs(1,j)))
            fh = fh1/fh2
c            fh = fct - sqrt(max(0.00*iobs(2,j),iobs(1,j)))
c            dfh_dIct = 0.5/fct

c            if(fct.gt.0.0) then
c               dfh_dIct = 1/fh2 - 0.5*fh1/(fct*fh2**2)
c            else
c               dfh_dIct = 0.0
c            endif
c            fh1 = Ict - max(-3.0*iobs(2,j),iobs(1,j))
c            fh2 = fct+max(0.01*iobs(2,j),iobs(1,j))
c            fh = fh1/fh2
c            if(iobs(1,j).gt.2.0*iobs(2,j)) then
               f_value=f_value+0.5*fh**2
c            endif
c     
c---  end of observations in block
         enddo 
c     
c---  end of blocks      
      enddo

      return 
      end
c
      subroutine save_params_ls_twin(npart_act)
      implicit none
      include 'agreem.fh'
      include 'twin_refmac.fh'
      include 'ls_params_save.fh'
      integer npart_act
c
c--locals
      
c
c---  body
      scale_ov0                  = scale_ls_over
      b_ov0                      = b_ls_over
      baniso_ov0(1:6)            = b_ls_aniso_over(1:6)
      scale_part0(1:npart_act)   = scale_ls_part(1:npart_act)
      b_part0(1:npart_act)       = b_ls_part(1:npart_act)
      twin_frac0(1:ntwin_domain) = twin_frac(1:ntwin_domain)
      scale_bulk0                = scale_ls_bulk
      b_bulk0                    = b_ls_bulk

      return
      end
c
      subroutine restore_params_ls_twin(npart_act)
      implicit none
      include 'agreem.fh'
      include 'twin_refmac.fh'
      include 'ls_params_save.fh'
      integer npart_act
c
c--locals
      
c
c---  body
      scale_ls_over          = scale_ov0
      b_ls_over              = b_ov0
      b_ls_aniso_over(1:6)   = baniso_ov0(1:6) 
      scale_ls_part(1:npart_act) = scale_part0(1:npart_act)
      b_ls_part(1:npart_act)     = b_part0(1:npart_act)
      twin_frac(1:ntwin_domain)       = twin_frac0(1:ntwin_domain)
      scale_ls_bulk          = scale_bulk0
      b_ls_bulk              = b_bulk0

      return
      end
c
      subroutine copy_ls_params_twin(num_p,npart_act,par0)
      implicit none
      include 'agreem.fh'
      include 'twin_refmac.fh'
      include 'ls_params_save.fh'
c
c---inputs
      integer num_p,npart_act
c
c--outputs
      real par0(num_p)
c
c--locals
      integer ip,i
c
      if(ntwin_domain.gt.1) then
         par0(1:ntwin_domain-1) = twin_frac0(2:ntwin_domain)
      endif
      ip = ntwin_domain
      par0(ip) = scale_ls_over
      ip = ip + 1
      par0(ip) = b_ls_over
      ip = ip + 1
      par0(ip:ip+4) = b_ls_aniso_over(2:6)
      ip = ip + 5
      do  i=1,npart_act
         par0(ip) = scale_ls_part(i)
         ip = ip + 1
         par0(ip) = b_ls_part(i)
         ip = ip + 1
      enddo
      par0(ip) = scale_ls_bulk
      ip = ip + 1
      par0(ip) = b_ls_bulk

      return
      end
c
      subroutine init_lambd_ls_twin(num_p,npart_act,shift,lambda)
      implicit none 
      include 'agreem.fh'
      include 'twin_refmac.fh'
c
c--inputs
      integer num_p,npart_act
      real lambda
      real shift(num_p)
c
c--locals
      real d1
      integer count
      integer ip,i,ipa,ishift
      real a_loc,shft3,alpha_sum
c
c---body
      lambda = 1.0
      count = 1

      ishift = 0
      do while(count.gt.0)
         ipa = 1
         ishift = ishift + 1
c
c---  Twin fractions
         count = 0
         if(ntwin_domain.gt.1) then
            alpha_sum = 0.0
            do ip=2,ntwin_domain
               a_loc = twin_frac(ip)-shift(ipa)*lambda
               ipa = ipa + 1
               alpha_sum = alpha_sum+a_loc
               if(a_loc.lt.0.0.or.a_loc.gt.1.0) count = count + 1
            enddo
            a_loc=1.0-alpha_sum
            if(a_loc.lt.0.0.or.a_loc.gt.1.0) count = count + 1
         endif
c
c--Overall scale and B
         a_loc      = scale_ls_over - shift(ipa)*lambda
         ipa = ipa + 1
         if(a_loc.le.0.0) count = count + 1
         a_loc  = b_ls_over     - shift(ipa)*lambda
         ipa = ipa + 1
         if(a_loc.gt.500.0.or.a_loc.lt.-100.0) count = count + 1
C
C---  Scale and B for partials
         do  ip=1,npart_act
            a_loc = scale_ls_part(ip)-shift(ipa)*lambda
            ipa = ipa + 1
            if(a_loc.lt.0.0) count = count + 1
            a_loc = b_ls_part(ip) - shift(ipa)*lambda
            ipa = ipa + 1
            if(a_loc.gt.500.0.or.a_loc.lt.-50.0) count = count + 1
         enddo
c
c---  Aniso B
         if(abs(maxval(shift(ipa:(ipa+4)))).gt.5.0) then
            d1 = 5.0/abs(maxval(shift(ipa:(ipa+4))))
c            write(*,*)maxval(shift(ipa:(ipa+4)))
            shift(ipa:(ipa+4))=d1*shift(ipa:(ipa+4))
c            write(*,*)maxval(shift(ipa:(ipa+4)))
c            stop
         endif
         shft3 = 0.0
         a_loc = b_ls_aniso_over(1) - shift(ipa)*lambda
         shft3 = shift(ipa)
         ipa = ipa + 1
         a_loc = b_ls_aniso_over(2) - shift(ipa)*lambda
         shft3 = shft3 + shift(ipa)
         ipa = ipa + 1
         a_loc = b_ls_aniso_over(3) + shft3
         a_loc = b_ls_aniso_over(4) - shift(ipa)*lambda
         ipa = ipa + 1
         a_loc = b_ls_aniso_over(5) - shift(ipa)*lambda
         ipa = ipa + 1
         a_loc = b_ls_aniso_over(6) - shift(ipa)*lambda
         ipa = ipa + 1
c
c---  Babinet's B
         a_loc = scale_ls_bulk - shift(ipa)*lambda
         ipa = ipa + 1
c         if(a_loc.lt.0.0.or.a_loc.gt.0.999) count = count + 1
         a_loc  = b_ls_bulk     - shift(ipa)*lambda
c         if(a_loc.lt.-50.0.or.a_loc.gt.500.0) count = count + 1
         if(count.gt.0) lambda = lambda/2.0
      enddo
c
      return
      end
c
      subroutine fix_params_ls_twin(npart_act,num_p,dfdp1,dfdp1dp2)
      implicit none 
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      include 'twin_refmac.fh'
c
      integer npart_act
      integer num_p
      real dfdp1(num_p),dfdp1dp2(num_p,num_p)
c
c---  body
      if(.not.BULK_LS_FLAG) then
         dfdp1(num_p-1:num_p) = 0.0
c         dfdp1(num_p)   = 0.0
         dfdp1dp2(1:num_p,(num_p-1):num_p) = 0.0
         dfdp1dp2((num_p-1):num_p,1:num_p) = 0.0
      endif
      if(.not.b_ls_over_flag) then
         dfdp1(ntwin_domain+1:ntwin_domain+1) = 0.0
         dfdp1dp2(ntwin_domain+1,1:num_p) = 0.0
         dfdp1dp2(1:num_p,ntwin_domain+1) = 0.0
      endif
c      dfdp1(ntwin_domain+2) = 0.0
c      dfdp1(ntwin_domain+3) = 0.0
c      dfdp1dp2(1:num_p,(ntwin_domain+2):(ntwin_domain+3))=0.0
c      dfdp1dp2((ntwin_domain+2):(ntwin_domain+3),1:num_p)=0.0

      return
      end

      subroutine add_shift_ls0_twin(num_p,npart_act,lambda,shift)
      implicit none 
      include 'agreem.fh'
      include 'twin_refmac.fh'
      include 'ls_params_save.fh'
      integer num_p,npart_act
      real lambda,shift (num_p)
c
c--   locals
      real alpha_sum,shft3
      real d1
      integer ip,ipa,j
c     add shift to alpha 2 to alpha n
c
c---Here we just apply.
      alpha_sum=0.0      
c
c---  Twin fractions
       do ip=1,ntwin_domain-1
          twin_frac(ip+1)=twin_frac0(ip+1)-shift(ip)*lambda
       enddo
       
       do ip=2,ntwin_domain
          alpha_sum=alpha_sum+twin_frac(ip)
       enddo
       twin_frac(1)=1.0-alpha_sum
c
c--Overall scale and B
       ipa = ntwin_domain
       scale_ls_over      = scale_ov0 - shift(ipa)*lambda
       ipa = ipa + 1
       b_ls_over          = b_ov0     - shift(ipa)*lambda
       ipa = ipa + 1
C
C---  Scale and B for partials
       do  ip=1,npart_act
          scale_ls_part(ip) = scale_part0(ip)-shift(ipa)*lambda
          ipa = ipa + 1
          b_ls_part(ip) = b_part0(ip) -shift(ipa)*lambda
          ipa = ipa + 1
       enddo

c
c---  Aniso B
       if(b_ls_aniso_over_flag) then
          d1 = 1.0
          if(abs(maxval(shift(ipa:(ipa+4)))).gt.5.0) then
             d1 = 5.0/abs(maxval(shift(ipa:(ipa+4))))
          endif
          shft3 = 0.0
          b_ls_aniso_over(1) = baniso_ov0(1) - d1*shift(ipa)*lambda
          shft3 = shift(ipa)
          ipa = ipa + 1
          b_ls_aniso_over(2) = baniso_ov0(2) - d1*shift(ipa)*lambda
          shft3 = shft3 + shift(ipa)
          ipa = ipa + 1
          b_ls_aniso_over(3) = baniso_ov0(3) + d1*shft3*lambda
          b_ls_aniso_over(4) = baniso_ov0(4) - d1*shift(ipa)*lambda
          ipa = ipa + 1
          b_ls_aniso_over(5) = baniso_ov0(5) - d1*shift(ipa)*lambda
          ipa = ipa + 1
          b_ls_aniso_over(6) = baniso_ov0(6) - d1*shift(ipa)*lambda
          ipa = ipa + 1
       else
          ipa = ipa + 5
       endif
c
c---  Babinet's B
       scale_ls_bulk = scale_bulk0 - shift(ipa)*lambda
       scale_ls_bulk = max(0.0,min(0.99,scale_ls_bulk))
       ipa = ipa + 1
       b_ls_bulk     = b_bulk0     - shift(ipa)*lambda
       b_ls_bulk  = max(5.0,min(500.0,b_ls_bulk))
       return
       end
c
      subroutine init_ls_params(nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr) 
c
c---Initialise ls scale parameters
c-------------------------------------------------------------------
c
c---  inputs
      implicit none
      include 'agreem.fh'
      include 'celsym.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym
      integer npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
c---Outputs
      integer ierr
c
c---locals
      integer i,j,o_s,o_f,c_1,num_obs_all
      integer nasym_1
      real sumal,iover,icover
      real rsq,ssqmax_loc,ssqmin_loc
      real twin_sum
      real eps
c
      real lstlsq_r
c
c---body
c---------------------------------------------------------------
c
c---If twin fractions have not been set then deal with it
      eps = 0.1e-3
      if(sum(twin_frac(1:ntwin_domain)).le.eps) twin_frac_set=.FALSE.
      if(twin_frac_set) then
         if(twin_frac(ntwin_domain).eq.eps) then
            do i=ntwin_domain,2,-1
               twin_frac(i) = twin_frac(i-1)
            enddo
            twin_frac(1) = 1.0 - sum(twin_frac(2:ntwin_domain))
         endif
      else
         twin_frac(1:ntwin_domain) = 1.0/ntwin_domain
         twin_frac(1) = twin_frac(1)*1.1
      endif
c
c--   Make sure that sum of all twin fractions is 1
      twin_sum = sum(twin_frac(1:ntwin_domain))
      twin_frac(1:ntwin_domain) = twin_frac(1:ntwin_domain)/twin_sum
      twin_frac_set = .TRUE.
c
c---anisotropic B values are 0. Initialise all others
      do  i=1,6
         b_ls_aniso_over(i) = 0.0
      enddo
      b_ls_over = 0.0
      if(bulk_ls_flag) then
         scale_ls_bulk = 0.4
         b_ls_bulk     = 150.0
      else
         scale_ls_bulk = 0.0
         b_ls_bulk = 200.0
      endif

      do   i=1,npart_act
         scale_ls_part(i) = 0.33
         b_ls_part(i) = 100.0
      enddo
c
c---  Initialise overall scale parameters: average observation/average calculated
      iover = 0.0
      icover = 0.0
      num_obs_all = 0
      ssqmax_loc = -1.0e32
      ssqmin_loc =  1.0e32
c

      do  i=1,num_blocks
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_1 = block_2_asym(ref_2_asym_start(i)+1)
         rsq = 4.0*lstlsq_r(1,hkl_asym(1:3,c_1))
         ssqmax_loc = max(ssqmax_loc,rsq)
         ssqmin_loc = min(ssqmin_loc,rsq)
         do j=o_s,o_f
            num_obs_all = num_obs_all + 1
            iover = iover + max(0.0,iobs(1,j))
         enddo
      enddo
      iover = iover/num_obs_all
      nasym_1 = 0
      do  i=1,nasym
         rsq = 4.0*lstlsq_r(1,hkl_asym(1:3,i))
         if(rsq.le.ssqmax_loc.and.rsq.ge.ssqmin_loc) then
            icover = icover + fcalc(1,i)**2+fcalc(2,i)**2
            nasym_1 = nasym_1 + 1
         endif
      enddo
      icover = icover/nasym_1
      if(icover.gt.0.0) then
         scale_ls_over = iover/icover
      else
         scale_ls_over = 1.0
      endif
c
c---Do initial scaling of observations. It should not affect the results
c      do  i=1,num_blocks
c         o_s = block_start(i)+1
c         o_f = block_start(i+1)
c         do j=o_s,o_f
c            iobs(1:2,j) = iobs(1:2,j)/scale_ls_over
c         enddo
c      enddo
      scale_ls_init = scale_ls_over
c      stop
c      scale_ls_over = sqrt(scale_ls_over)
      scale_ls_over = 1.0
c      stop
      return
      end
