module align_refmac

contains
  subroutine sequence_align_r(sequence1,sequence2,sim_table,nalign_in,align_in,nlen_align,align_out,         &
       pen1,pen2,align_score,ierr)
    implicit none
    !
    !---  Subroutine for alignment of two sequences
    integer ierr
    integer nlen_align
    real pen1,pen2
    integer, intent(in) :: sequence1(:),sequence2(:)
    real, intent(in) ::  sim_table(:,:)
    integer, intent(in) ::  nalign_in
    integer, intent(in) :: align_in(:,:)
    integer, intent(out) :: align_out(:,:)
    real align_score
    !
    integer ncases,nseq1,nseq2
    integer i,j,i1,j1,i2
    integer nalign,nlead,nlead1,ntrail,ntrail1
    !
    ierr = 0
    nseq1 = size(sequence1)
    nseq2 = size(sequence2)
    if(nseq1.eq.nseq2.and.nseq1.eq.1) then
       if(sequence1(1).eq.sequence2(1)) then 
          align_score = 1.0
          nlen_align = 1
       else
          align_score = 0.0
       endif
       return
    endif

    call  align_r(sequence1,sequence2,sim_table,nalign_in,align_in,nlen_align,align_out,pen1,pen2,ierr)
    if(ierr.gt.0) return
    !
    ! Should we compress alignment?

    if(minval(align_out(1:2,2)).eq.0.or.minval(align_out(1:2,3)).eq.0) then
       align_out(1:2,1) = 0
       align_out(1:2,2) = 0
    endif
    do i=2,nlen_align-1
       if(minval(align_out(1:2,i-1)).eq.0.and.minval(align_out(1:2,i+1)).eq.0) then
          align_out(1:2,i) = 0
       else if(i.ge.3) then
          if(minval(align_out(1:2,i-2)).eq.0.and.minval(align_out(1:2,i+1)).eq.0) then
             align_out(1:2,i) = 0
          endif
       else if(i.le.nlen_align-2) then
          if(minval(align_out(1:2,i-1)).eq.0.and.minval(align_out(1:2,i+2)).eq.0) then
             align_out(1:2,i) = 0
          endif
       endif
    enddo
!
    if(nlen_align.gt.2) then
       if(minval(align_out(1:2,nlen_align-1)).eq.0.or.minval(align_out(1:2,nlen_align-2)).eq.0) then
          align_out(1:2,nlen_align) = 0
          align_out(1:2,nlen_align-1) = 0
       endif
    endif

    ntrail = 0
    do i=1,nlen_align
       if(minval(align_out(1:2,i)).eq.0) then
          ntrail = ntrail + 1
       endif
    enddo
    if(ntrail.gt.0) then
       do i=ntrail,nlen_align-1
          align_out(1:2,i-ntrail+1) = align_out(1:2,i+1)
       enddo
       nlen_align = nlen_align-ntrail
    endif

    nalign = 0
    do i=1,nlen_align
       if(align_out(1,i).gt.0.and.align_out(2,i).gt.0) then
          i1 = align_out(1,i)
          i2 = align_out(2,i)
          if(sequence1(i1).eq.sequence2(i2)) then
             nalign = nalign + 1
          endif
       endif
    enddo
    !
    !  Trim add a little bit correction at the end of the alignment.
    align_score = 0.0
    if(nlen_align.gt.0) then
       if(min(align_out(1,nlen_align),align_out(1,1),align_out(2,nlen_align)-align_out(2,2)).gt.0) then
          align_score = real(nalign)/real(max(nlen_align,min(align_out(1,nlen_align)-align_out(1,1),       &
               align_out(2,nlen_align)-align_out(2,1))))
       endif
    endif

    align_out(1:2,nlen_align+1:) = 0.0

    return
  end subroutine sequence_align_r
  !
  !----
  subroutine align_r(sequence1,sequence2,sim_table,nalign_in,align_in,nlen_align,align_out,pen1,pen2,ierr)
    implicit none
    !
    !---  Subroutine for alignment of two sequences
    integer ierr
    integer nlen_align
    real pen1,pen2
    integer, intent(in) :: sequence1(:),sequence2(:)
    real, intent(in) :: sim_table(:,:)
    integer nalign_in
    integer, intent(in) :: align_in(:,:)
    integer, intent(out) :: align_out(:,:)
    !
    integer ncases,nseq1,nseq2
    
    integer i,j,i1,i2,j1
    real, allocatable :: table1(:,:)
    real tbmn
    !  data pen1/0.0/,pen2/0.0/
  
    nseq1 = size(sequence1)
    nseq2 = size(sequence2)
    ncases = size(sim_table(1,:))
    !
    ! body
    ierr = 0
    if(minval(sequence1).gt.0.and.maxval(sequence1).le.ncases.and.            &
         minval(sequence2).gt.0.and.maxval(sequence2).le.ncases) then
       allocate(table1(nseq1,nseq2))
       do i=1,nseq1
          i1 = sequence1(i)
          do j=1,nseq2
             j1 = sequence2(j)
             table1(i,j) = sim_table(i1,j1)
          enddo
       enddo
       
       !
       !  Remove already aligned residues from the table
       if(nalign_in.gt.0) then
          tbmn = minval(sim_table)
          do i=1,nalign_in
             i1 = align_in(1,i)
             i2 = align_in(2,i)
             table1(i1,i2) = tbmn
          enddo
       endif
       call align_real(pen1,pen2,table1,nlen_align,align_out,ierr)
       
       deallocate(table1)
    else
       ierr = 1
    endif
    return
  end subroutine align_r
!
  subroutine align_real(pen1,pen2,table1,nlen_align,align_out,ierr)
    implicit none
    integer ierr
    real pen1,pen2
    real, intent(in) :: table1(:,:)
    integer nlen_align
    integer, intent(out) :: align_out(:,:)
    !
    integer nseq1,nseq2
    integer i,j,n1,nl,n2,n12
    real a,b,c
    real, allocatable :: f(:,:)
    !
    !---- 
    real eps,am,am2
    
    !
    !---  Foward step
    nseq1 = size(table1(:,1)); nseq2 = size(table1(1,:))
    eps = 1.0e-5
    allocate(f(nseq1,nseq2))
    !
    do i=1,nseq1
       f(i,1) = table1(i,1)
    enddo
    do j=1,nseq2
       f(1,j) = table1(1,j)
    enddo
    !
    do i=2,nseq1
       do j=2,nseq2
          a = f(i-1,j-1) + table1(i-1,j-1)
          b = f(i-1,j) + pen1
          c = f(i,j-1) + pen1
          f(i,j) = max(a,max(b,c))
       enddo
    enddo
    n1 = 1
    am = f(1,1)
    do i=nseq1,1,-1
       if(f(i,nseq2).ge.am) then
          n1 = i
          am = f(i,nseq2)
       endif
    enddo
    n2 = 1
    am2 = f(1,1)
    do i=nseq2,1,-1
       if(f(nseq1,i).ge.am2) then
          n2 = i
          am2 = f(nseq1,i)
       endif
    enddo
    if(am.gt.am2) then
       n2 = nseq2
    else
       n1 = nseq1
    endif
    align_out = 0
    !
    !---  Backward step
    n12 = nseq1 + nseq2
    i = n1
    j = n2
    align_out(1,n12) = i
    align_out(2,n12) = j
    do while (i.gt.1.and.j.gt.1)
       if(abs(f(i,j)-f(i-1,j-1)-table1(i-1,j-1)).lt.eps) then
          n12 = n12 - 1
          i = i - 1
          j = j - 1
          align_out(1,n12) = i
          align_out(2,n12) = j
       else if(abs(f(i,j)-f(i-1,j)-pen1).lt.eps) then
          n12 = n12 - 1
          i = i - 1
          align_out(1,n12) = i
          align_out(2,n12) = 0
       else if(abs(f(i,j)-f(i,j-1)-pen1).lt.eps) then
          n12 = n12 - 1
          j = j - 1
          align_out(1,n12) = 0
          align_out(2,n12) = j
       else
          stop 'Helll'
       endif
    enddo
    
    do while(n12.le.nseq1+nseq2.and.(align_out(1,n12).eq.0.or.align_out(2,n12).eq.0))
       n12 = n12 + 1
    enddo
    i=1
    do while(n12.le.nseq1+nseq2)       
       align_out(1:2,i) = align_out(1:2,n12)
       i = i + 1
       n12 = n12 + 1
    enddo
    do while(align_out(1,i).eq.0.or.align_out(2,i).eq.0)
       i = i-1
    enddo
    nlen_align = i-1
    align_out(1:2,i:) = 0


    deallocate(f)
    return
  end subroutine align_real
end module align_refmac
