module ncs_generate

contains
  subroutine ncs_rest_generate(number_ncsr,ich_type,ires_first,nres_chain,    &
       iratm_first,natm_res,asm_group_id,xyz_crd,occup,res_num_pdb,res_name_pdb,atm_name,sigs,  &
       ncsr_level,align_rms_level,align_iter_flag,ncs_rest_file)
    use align_refmac
    implicit none
    !
    !  This subroutine aligns chains with each other and if a pair of chains are similar enough
    !  then it generates atom pairs that are ncs related. 
    integer gdupl_flag
    integer number_ncsr

    integer, intent(in) :: ires_first(:)
    integer, intent(in) :: nres_chain(:)
    integer, intent(in) :: ich_type(:)
    integer, intent(in) :: iratm_first(:)
    integer, intent(in) :: natm_res(:)
    real, intent(in) :: xyz_crd(:,:)
    real, intent(in) :: occup(:)
    character(len=*), intent(in) :: res_name_pdb(:)
    character(len=*), intent(in) :: res_num_pdb(:)
    character(len=*), intent(in) :: asm_group_id(:)
    
    character(len=*), intent(in) :: atm_name(:)
    character(len=*), intent(in) :: ncs_rest_file

    real, intent(in) :: sigs(:)
    real, intent(in) :: ncsr_level
    real, intent(in) :: align_rms_level
    character(len=*) :: align_iter_flag
    !
    !  body

    real, allocatable :: sim_table(:,:)
    
    real, allocatable :: ncs_table(:,:)
    integer, allocatable :: ires_names(:)
    integer, allocatable :: sequence1(:)
    integer, allocatable :: sequence2(:)
    integer, allocatable :: align_out(:,:)
    integer, allocatable :: align_in(:,:)
    !
    integer, allocatable :: number_of_copies(:)
    integer, allocatable :: number_of_pairs(:)
    integer, allocatable :: chain_pairs(:,:)
    
    integer n_group,n_residue
    real pen1,pen2
    real ncs_level,align_score
    integer nlen_align,nalign_in,n_pass
    integer maxdiff_res,ir1,ir2,nres1,nres2
    integer i,j,k,l,m,i1,i2,ia1,ia2,ib1,ib2,j0,j1,ierr
    integer iweight
    real sigx,sigb,weight_b
    real rms_glob,rms_loc_ave
    real align_rms_loc,ncs_level_loc
    real, allocatable :: rms_loc(:)
    !
    integer incs_file,incs_real
    !
    character file_temp*512
    character ch1*14,ch2*14
    logical align_flag

    !
    !---  body
    if(ncsr_level.gt.0.0) then
       ncs_level_loc = ncsr_level
    else
       ncs_level_loc = 0.8
    endif
    if(align_rms_level.gt.0.0) then
       align_rms_loc = align_rms_level
    else
       align_rms_loc = 2.0
    endif
    gdupl_flag = 0
    if(align_iter_flag.eq.'Y') gdupl_flag = 1
    n_residue = size(iratm_first)
    pen1 = -0.1
    pen2 = 0.0

    if(number_ncsr.gt.0) return
    number_ncsr = 0
    n_group = size(ich_type)
    if(n_group.le.1) return
    !
    !---  Convert monomers to integers
    allocate(ires_names(n_residue))
    call convert_resname_to_integer(ires_names,res_name_pdb(1:n_residue))

    maxdiff_res = maxval(ires_names(1:n_residue))

    allocate(sim_table(maxdiff_res,maxdiff_res))
    sim_table(1:maxdiff_res,1:maxdiff_res) = 0.0
    do i=1,maxdiff_res
       sim_table(i,i) = 1.0
    enddo
    allocate(number_of_copies(n_group))
    number_of_copies(1:n_group) = 1
    allocate(number_of_pairs(n_group*(n_group-1)/2+4*n_group))
    allocate(chain_pairs(2,n_group*(n_group-1)/2+4*n_group))
    number_of_pairs = 0
    chain_pairs = 0
    call find_unique_file_name(file_temp,'.ncsr_temp')
    call open_unform_file(incs_file,file_temp,ierr)
    nalign_in = 0
    do i=1,n_group
       if(nres_chain(i).gt.0.and.ich_type(i).ne.9) then
          allocate(sequence1(nres_chain(i)))
          ir1 = ires_first(i)
          ir2 = ir1 + nres_chain(i) -1
          nres1 = nres_chain(i)
          sequence1(1:nres1) = ires_names(ir1:ir2)
          !
          do j=i,n_group
             if(nres_chain(j).gt.0.and.ich_type(j).ne.9.and.       &
                  ich_type(i).eq.ich_type(j).and.(gdupl_flag.eq.1.or.i.ne.j)) then
                nres2 = nres_chain(j)
                allocate(align_in(2,2*(nres1+nres2)))
                if(i.eq.j) then
                   nalign_in = nres_chain(i)
                   do k=1,nalign_in
                      align_in(1,k) = k
                      align_in(2,k) = k
                   enddo
                else
                   nalign_in = 0
                endif
                !
                !--   IF the numbers of residues in two chains are too different then do not 
                !--   consider them
                allocate(sequence2(nres_chain(j)))
                ir1 = ires_first(j)
                ir2 = ir1 + nres_chain(j) -1
                sequence2(1:nres2) = ires_names(ir1:ir2)
                align_score = 0
                allocate(align_out(2,nres1+nres2))
                align_score = 1.0
                n_pass = 1
                align_flag = .TRUE.
                do while(align_score.gt.ncs_level_loc.and.align_flag.and.(gdupl_flag.eq.1.or.n_pass.eq.1))
                   n_pass = n_pass + 1
                   call sequence_align_r(sequence1,sequence2,                          &    
                        sim_table,nalign_in,align_in,nlen_align,align_out,pen1,pen2,align_score,ierr)
                   align_flag = .TRUE.

                   if(nlen_align.le.10.or.align_score.le.ncs_level_loc) then
                      align_flag = .FALSE.
                      align_score = 0.0
                      cycle
                   endif
                   call calc_aligned_rms(i,j,ich_type,ires_first,nres_chain,    &
                        iratm_first,natm_res,asm_group_id,xyz_crd,occup,res_num_pdb,res_name_pdb,atm_name, &
                        nlen_align,align_out,rms_glob)
                   allocate(rms_loc(nlen_align))
                   call calc_aligned_rms_loc(i,j,ich_type,ires_first,nres_chain,    &
                        iratm_first,natm_res,asm_group_id,xyz_crd,occup,res_num_pdb,res_name_pdb,atm_name, &
                        nlen_align,align_out,rms_loc)
                   rms_loc_ave = sum(rms_loc(1:nlen_align-5))/(nlen_align-5)
                   deallocate(rms_loc)

                   if(rms_loc_ave.gt.align_rms_loc) then
                      align_flag = .FALSE.
                      align_score = 0.0
                      cycle
                   endif
                   !
                   !   If a chain pair are similar then generate ncs related pairs of atoms
                   !   Use procrustes distances to decide if alignment gave correct results
                   if(align_score.gt.ncs_level_loc.and.align_flag) then
                      number_ncsr = number_ncsr + 1
                      if(number_ncsr.eq.1) then
                         write(*,*)
                         write(*,*)
                         write(*,'(45x,a)')'********* Alignment results *********'
                         write(*,'(1x,130a)')('-',k=1,119)
                         write(*,'(a3,7(a14,a3))')':  ','Ncsr group',' : ','Chain 1',' : ','Chain 2',      &
                              ' : ','No of aligned',' : ','Score',' : ','RMS ',' : ','Ave(RmsLoc)',' : '
                         write(*,'(1x,130a)')('-',k=1,119)
                      endif
                      i1 = ires_first(i) + align_out(1,1)-1
                      i2 = ires_first(i) + align_out(1,nlen_align)-1
                      write(ch1,'(a)')asm_group_id(i)(1:1)//'('//res_num_pdb(i1)(3:7)//'-'//res_num_pdb(i2)(3:7)//')'
                      i1 = ires_first(j) + align_out(2,1)-1
                      i2 = ires_first(j) + align_out(2,nlen_align)-1
                      write(ch2,'(a)')asm_group_id(j)(1:1)//'('//res_num_pdb(i1)(3:7)//'-'//res_num_pdb(i2)(3:7)//')'
                      write(*,'(a3,i14,a3,2(a14,a3),i14,a3,3(f14.4,a3))')':  ',number_ncsr,' : ',             &
                           ch1,' : ',ch2,' : ',nlen_align,' : ',align_score,' : ',rms_glob,' : ',rms_loc_ave,' : '
                      number_of_copies(i) = number_of_copies(i) + 1
                      number_of_copies(j) = number_of_copies(j) + 1
                      chain_pairs(1,number_ncsr) = i
                      chain_pairs(2,number_ncsr) = j
                      !
                      !   Check if this alignment is real. E.g. PolyAla models may produce high identity
                      do k=1,nlen_align
                         i1 = align_out(1,k)
                         i2 = align_out(2,k)
                         if(i1.gt.0.and.i2.gt.0) then
                            ir1 = ires_first(i) + i1-1
                            ir2 = ires_first(j) + i2-1
                            ia1 = iratm_first(ir1)
                            ia2 = ia1 + natm_res(ir1) - 1
                            do l=ia1,ia2
                               if(occup(l).le.0.00001) cycle
                               ib1 = iratm_first(ir2)
                               ib2 = ib1+natm_res(ir2) - 1
                               do m=ib1,ib2
                                  if(occup(m).le.0.00001) cycle
                                  if(atm_name(l).eq.atm_name(m)) then
                                     iweight = 1
                                     write(incs_file)iweight,sigs(1),sigs(4),l,m,1.0
                                     number_of_pairs(number_ncsr) = number_of_pairs(number_ncsr) + 1
                                     exit
                                  endif
                               enddo
                            enddo
                         endif
                      enddo
                      if(gdupl_flag.eq.1) then
                         do k=1,nlen_align
                            if(minval(align_out(1:2,k)).gt.0) then
                               nalign_in = nalign_in + 1
                               align_in(1,nalign_in) = align_out(1,k)
                               align_in(2,nalign_in) = align_out(2,k)
                            endif
                         enddo
                         if(i.eq.j) then
                            do k=1,nlen_align
                               if(minval(align_out(1:2,k)).gt.0) then
                                  nalign_in = nalign_in + 1
                                  align_in(1,nalign_in) = align_out(2,k)
                                  align_in(2,nalign_in) = align_out(1,k)
                               endif
                            enddo
                         endif
                      endif
                   endif
100                continue
                enddo
                deallocate(align_out)
                deallocate(sequence2)
                deallocate(align_in)
             endif
             !
             !   Now check if this alignment produces sufficiently good match. If yes then keep it
             !   If not then remove them from consideration
          enddo
          deallocate(sequence1)
       endif
    enddo

    !
    !   Now read generated pairs of atoms and write them as ncs restraint functions
    if(number_ncsr.gt.0) then
       write(*,'(1x,130a)')('-',k=1,119)
       write(*,*)
       rewind(incs_file)
       if(len_trim(ncs_rest_file).le.0) then
          call find_unique_file_name(ncs_rest_file,'.ncs_rest')
       endif
       call open_unform_file(incs_real,ncs_rest_file,ierr)
       write(incs_real)number_ncsr
       j0 = 1
       do i=1,number_ncsr
          !
          !   Write info about ncs
          write(incs_real)number_of_pairs(i),2
          j1 = j0 + number_of_pairs(i)-1
          do j=j0,j1
             read(incs_file)iweight,sigx,sigb,ia1,ia2,weight_b
             sigx = sigx*sqrt(real(number_of_copies(chain_pairs(1,i))-1))
             sigb = sigb*sqrt(real(number_of_copies(chain_pairs(1,i))-1)) 
             write(incs_real)iweight,sigx,sigb,ia1,ia2,weight_b
          enddo
          j0 = j1+1
       enddo
       close(incs_real)
    endif
    !
    !   Add neighbouring atoms like ligands, waters etc. They may be important. 
    close(incs_file,status='DELETE')
    deallocate(sim_table)
    deallocate(ires_names)
    deallocate(number_of_copies)
    deallocate(number_of_pairs)
    deallocate(chain_pairs)
    !    stop
  end subroutine ncs_rest_generate

  subroutine convert_resname_to_integer(ires_names,res_name_pdb)
    implicit none
    !      include 'atom_com.fh'
    character(len=*):: res_name_pdb(:)
    integer  :: ires_names(:)

    integer i
    integer nkeys,ires_t,n_res
    integer, allocatable :: index_c(:)
    character(len=8), allocatable :: cnames(:)
    !
    n_res = size(ires_names)
    allocate(index_c(n_res))
    allocate(cnames(n_res))
    do i=1,n_res
       index_c(i) = i
       cnames(i) = res_name_pdb(i)
    enddo
      
    nkeys = 1
    call cheap_sort_r(n_res,nkeys,cnames,index_c)
    ires_t = 1
    ires_names(index_c(1)) = 1
    do i=2,n_res
       if(cnames(i).ne.cnames(i-1)) ires_t = ires_t + 1
       ires_names(index_c(i)) = ires_t
    enddo
    deallocate(index_c)
    deallocate(cnames)
    
    return
  end subroutine convert_resname_to_integer

  subroutine ncs_rest_add_neighbours(dlim,xyz_crd,occup,belongs_chain,belongs_shell,i_resid,res_num_pdb,res_name, &
       atm_name,rot,tr,cell,ncsr_file_name,all_contacts_file)
    implicit none
    !
    !   Add neighbouring atoms to ncs definitions.
    real dlim
    integer, intent(in) :: belongs_chain(:)
    integer, intent(in) :: belongs_shell(:)
    integer, intent(in) :: i_resid(:)
    real, intent(in) :: xyz_crd(:,:)
    real, intent(in) :: occup(:)
    real, intent(in) :: rot(:,:,:)
    real, intent(in) :: tr(:,:)
    real, intent(in) :: cell(6)
    character(len=*) :: res_num_pdb(:)
    character(len=*) :: res_name(:)
    character(len=*) :: atm_name(:)

    character(len=*) :: ncsr_file_name
    character(len=*) :: all_contacts_file
    integer ierr
    !
    !   locals
    integer i,j,k,i1,i2,j1,ian,jan,ic,jc,il,is,isave,jsave
    integer nvdw,nmax_c
    integer n_change,n_neigb,n_step,ns,ns1,iw,n_moved
    integer iat_l(2)
    integer nchn,ncs_loc
    real sigx_l,sigb_l,ww

    real dist_tol,weight_b
    integer, allocatable :: pairs(:,:)
    integer, allocatable :: symm_flag(:)
    integer, allocatable :: nvdw_per_atom(:)
    integer, allocatable :: vdw_per_atom(:,:)
    integer, allocatable :: pairs_ncs(:)
    integer, allocatable :: ncs_defined(:)
    integer, allocatable :: iat(:,:)
    real, allocatable :: sigx(:)
    real, allocatable :: sigb(:)
    integer, allocatable :: iww(:)
    integer, allocatable :: iat_t(:,:)

    real, allocatable :: xyz_r(:,:)
    real, allocatable :: xyz_t(:,:)
    integer ifile,ifile_out
    integer number_ncsr
    integer maxatom,n_atom,maxsym,nsym
    real dlim_f,dist,dist_p,dist_cur
    real tmp(3)
    real rot_p(3,3),tr_p(3)
    character ncsr_interm_file*512
    logical lexists
    !
    !  body
    if(dlim.le.0.0) dlim=3.5
    n_atom = size(xyz_crd(1,:))
    maxatom = n_atom
    nsym = size(rot(1,1,:))
    maxsym = nsym
    !
    !  Check if ncsr file exists

    
    if(len_trim(ncsr_file_name).le.0) then
       write(*,*)'Error==> NCS restraints have not been defined yet'
       return
    endif
    !
    !   If all contacts file does not exist or distance limit is less than dlim then 
    !   do calculations

    call check_all_contacts_file(dlim,maxatom,n_atom,xyz_crd,occup,maxsym,nsym,rot,tr,cell,     &
               all_contacts_file,ierr)
    call open_unform_file(ifile,all_contacts_file,ierr)
    read(ifile)nvdw,dlim_f
    close(ifile)
    if(nvdw.le.0) then
       return
    endif
    allocate(pairs(2,nvdw))
    allocate(symm_flag(nvdw))
    call read_all_contacts_file(nvdw,pairs,symm_flag,all_contacts_file,ierr)

    allocate(nvdw_per_atom(n_atom))
    nvdw_per_atom(1:n_atom) = 0
    do i=1,nvdw
       if(symm_flag(i).eq.0) then
          nvdw_per_atom(pairs(1:2,i)) = nvdw_per_atom(pairs(1:2,i)) + 1
       endif
    enddo
    nmax_c = maxval(nvdw_per_atom(1:n_atom))
    allocate(vdw_per_atom(nmax_c,n_atom))
    nvdw_per_atom(1:n_atom) = 0
    do i=1,nvdw
       if(symm_flag(i).eq.0) then
          i1 = pairs(1,i)
          i2 = pairs(2,i)
          nvdw_per_atom(i1) = nvdw_per_atom(i1) + 1
          vdw_per_atom(nvdw_per_atom(i1),i1) = i2
          nvdw_per_atom(i2) = nvdw_per_atom(i2) + 1
          vdw_per_atom(nvdw_per_atom(i2),i2) = i1
       endif
    enddo
    deallocate(pairs)
    deallocate(symm_flag)
    call open_unform_file(ifile,ncsr_file_name,ierr)
    read(ifile)ncs_loc
    allocate(pairs_ncs(n_atom))
    allocate(ncs_defined(n_atom))
    allocate(iww(n_atom))
    allocate(iat_t(n_atom,2))
    allocate(sigx(n_atom))
    allocate(sigb(n_atom))
    dist_tol = 0.8

    number_ncsr = 0
    call find_unique_file_name(ncsr_interm_file,'.ncsr.int')
    call open_unform_file(ifile_out,ncsr_interm_file,ierr)
    do il=1,ncs_loc
       read(ifile)ns,nchn
       allocate(iat(ns,nchn))
       sigx = 0.0
       iww = 0
       sigb = 0.0
       do is=1,ns
          read(ifile)iww(is),sigx(is),sigb(is),(iat(is,k),k=1,nchn),weight_b
       enddo
       sigx = sigx*(nchn-1)
       sigb = sigb*(nchn-1)
       do ic=1,nchn-1
          do jc=ic+1,nchn
             number_ncsr = number_ncsr + 1
             iat_t(1:ns,1:2) = 0
             iat_t(1:ns,1) = iat(1:ns,ic)
             iat_t(1:ns,2) = iat(1:ns,jc)
             pairs_ncs(1:n_atom) = 0
             pairs_ncs(iat(1:ns,ic)) = iat(1:ns,jc)
             ncs_defined(1:n_atom)  = 0
             ncs_defined(iat(1:ns,jc)) = 1
             ns1 = ns
             n_change = 1
             n_step   = 0
             n_moved  = 0
             do while(n_change.gt.0)
                n_change = 0
                n_step = n_step + 1
                do is=1,ns1
                   ian = iat_t(is,1)
                   jan = pairs_ncs(ian)
                   if(nvdw_per_atom(ian).gt.3) then
                      !
                      !   Find all neighbours of atoms that have ncs equivalent
                      n_neigb = 1
                      do k=1,nvdw_per_atom(ian)
                         i1 = vdw_per_atom(k,ian)
                         if(pairs_ncs(i1).gt.0) then
                            n_neigb = n_neigb + 1
                         endif
                      enddo
                      !
                      !   If all neigbours have ncs mate then do not do calculations
                      !   Or if the number of neighbours is less than four then do not do calculationss
                      if(n_neigb.gt.3.and.n_neigb.lt.nvdw_per_atom(ian)) then
                         allocate(xyz_t(3,n_neigb))
                         allocate(xyz_r(3,n_neigb))
                         n_neigb = 1
                         xyz_r(1:3,n_neigb) = xyz_crd(1:3,ian)
                         xyz_t(1:3,n_neigb) = xyz_crd(1:3,jan)
                         do k=1,nvdw_per_atom(ian)
                            i1 = vdw_per_atom(k,ian)
                            if(pairs_ncs(i1).gt.0) then
                               n_neigb = n_neigb + 1
                               j1 = pairs_ncs(i1)
                               xyz_r(1:3,n_neigb) = xyz_crd(1:3,i1)
                               xyz_t(1:3,n_neigb) = xyz_crd(1:3,j1)
                            endif
                         enddo
                         !
                         !   Calculate transformation matrix and translation
                         call procrust_rot(n_neigb,xyz_r,xyz_t,rot_p,tr_p,dist_p)
                         do k=1,nvdw_per_atom(jan)
                            j1 = vdw_per_atom(k,jan)
                            if(ncs_defined(j1).gt.0) cycle
                            !
                            !  Apply to the neighbours that have no ncs mate. If After application
                            !  we find an atom with the same  from residue with the same name then compare them
                            !  If they match then add them to ncs
                            dist_cur = 1.0e32
                            jsave = 0
                            isave = 0
                            if(belongs_chain(j1).eq.belongs_chain(jan)) then
                               do j=1,nvdw_per_atom(ian)
                                  i1 = vdw_per_atom(j,ian)
                                  if(pairs_ncs(i1).le.0) then
                                     if(belongs_chain(i1).eq.belongs_chain(ian)) then
                                        if(res_name(i_resid(j1)).eq.res_name(i_resid(i1)).and.     &
                                             atm_name(j1).eq.atm_name(i1)) then
                                           tmp = matmul(rot_p,xyz_crd(1:3,j1)) + tr_p
                                           dist = sqrt(sum((tmp-xyz_crd(1:3,i1))**2))
                                           !write(*,*)'Found ',res_name(i_resid(j1)),atm_name(j1)
                                           !write(*,*)dist
                                           if(dist_cur.gt.dist) then
                                              jsave = j1
                                              isave = i1
                                              dist_cur = dist
                                           endif
                                        endif
                                     endif
                                  endif
                               enddo
                               
                               if(dist_cur.le.dist_tol.and.jsave.gt.0.and.isave.gt.0) then
                                  pairs_ncs(isave) = jsave
                                  ncs_defined(jsave) = 1
                                  ns1 = ns1 + 1
                                  iat_t(ns1,1) = isave
                                  iat_t(ns1,2) = jsave
                                  n_change = n_change + 1
                                  ww = 1.0+0.5*(real(belongs_shell(isave)+belongs_shell(jsave)))/2
                                  sigx(ns1) = sigx(ian)*ww
                                  sigb(ns1) = sigb(ian)*ww
                                  iww(ns1) = iww(ian)
                                  exit
                               endif
                            endif
                         enddo
                         deallocate(xyz_r)
                         deallocate(xyz_t)
                      endif
                   endif
                enddo
                n_moved = n_moved + n_change
             enddo
             write(*,*)'The number of assigned atoms = ',n_moved,' in round ',n_step
             write(ifile_out)ns1,2
             do is = 1,ns1
                write(ifile_out)iww(is),sigx(is),sigb(is),iat_t(is,1:2),1.0
             enddo
          enddo
       enddo
       deallocate(iat)
    enddo
    rewind(ifile_out)
    rewind(ifile)
    write(ifile)number_ncsr
    do i=1,number_ncsr
       read(ifile_out)ns,nchn
       write(ifile)ns,nchn
       do is=1,ns
          read(ifile_out)iw,sigx_l,sigb_l,iat_l(1:2),weight_b
          write(ifile)iw,sigx_l,sigb_l,iat_l(1:2),weight_b
       enddo
    enddo
    close(ifile)
    close(ifile_out,status='DELETE')
    !
    !  Deallocate memory
    deallocate(nvdw_per_atom)
    deallocate(vdw_per_atom)
    deallocate(iat_t)
    deallocate(iww)
    deallocate(sigx)
    deallocate(sigb)
    deallocate(ncs_defined)
    deallocate(pairs_ncs)

  end subroutine ncs_rest_add_neighbours

  subroutine calc_aligned_rms(nref,ntar,ich_type,ires_first,nres_chain,iratm_first,natm_res,asm_group_id,  &
       xyz_crd,occup,res_num_pdb,res_name_pdb,atm_name,nlen_align,align_out,rms_glob)
    implicit none
    !
    !   Calculate rms deviation between aligned residues. Theere are two types of rms 
    !   1) rms local is calculated 5 residue moving rms and the result is averal over all aligned
    !   2) rms global is calculated using all aligned residues
    integer nref,ntar
    integer, intent(in) :: ires_first(:)
    integer, intent(in) :: nres_chain(:)
    integer, intent(in) :: ich_type(:)
    integer, intent(in) :: iratm_first(:)
    integer, intent(in) :: natm_res(:)
    real, intent(in) :: xyz_crd(:,:)
    real, intent(in) :: occup(:)
    character(len=*), intent(in) :: res_name_pdb(:)
    character(len=*), intent(in) :: res_num_pdb(:)
    character(len=*), intent(in) :: asm_group_id(:)
    
    character(len=*), intent(in) :: atm_name(:)

    integer nlen_align
    integer, intent(in) :: align_out(:,:)
    real rms_glob
    !
    !  locals
    integer i,k,l,m,i1,i2,ir1,ir2,ia1,ia2,ib1,ib2,na
    real, allocatable :: xyz_r(:,:),xyz_t(:,:)

    !
    !   body
    na = 0
    do k=1,nlen_align
       i1 = align_out(1,k)
       i2 = align_out(2,k)
       if(i1.gt.0.and.i2.gt.0) then
          ir1 = ires_first(nref) + i1-1
          ir2 = ires_first(ntar) + i2-1
          ia1 = iratm_first(ir1)
          ia2 = ia1 + natm_res(ir1) - 1
          do l=ia1,ia2
             if(occup(l).le.0.00001) cycle
             ib1 = iratm_first(ir2)
             ib2 = ib1+natm_res(ir2) - 1
             do m=ib1,ib2
                if(occup(m).le.0.00001) cycle
                if(atm_name(l).eq.atm_name(m)) then
                   na = na + 1
                   exit
                endif
             enddo
          enddo
       endif
    enddo

    allocate(xyz_t(3,na))
    allocate(xyz_r(3,na))
    na = 0
    do k=1,nlen_align
       i1 = align_out(1,k)
       i2 = align_out(2,k)
       if(i1.gt.0.and.i2.gt.0) then
          ir1 = ires_first(nref) + i1-1
          ir2 = ires_first(ntar) + i2-1
          ia1 = iratm_first(ir1)
          ia2 = ia1 + natm_res(ir1) - 1
          do l=ia1,ia2
             if(occup(l).le.0.00001) cycle
             ib1 = iratm_first(ir2)
             ib2 = ib1+natm_res(ir2) - 1
             do m=ib1,ib2
                if(occup(m).le.0.00001) cycle
                if(atm_name(l).eq.atm_name(m)) then
                   na = na + 1
                   xyz_r(1:3,na) = xyz_crd(1:3,l)
                   xyz_t(1:3,na) = xyz_crd(1:3,m)
                   exit
                endif
             enddo
          enddo
       endif
    enddo

    call procrust_dist(na,xyz_t,xyz_r,rms_glob)
    deallocate(xyz_t)
    deallocate(xyz_r)

  end subroutine calc_aligned_rms


  subroutine calc_aligned_rms_loc(nref,ntar,ich_type,ires_first,nres_chain,iratm_first,natm_res,asm_group_id,  &
       xyz_crd,occup,res_num_pdb,res_name_pdb,atm_name,nlen_align,align_out,rms_loc)
    implicit none
    !
    !   Calculate rms deviation between aligned residues. Theere are two types of rms 
    !   1) rms local is calculated 5 residue moving rms and the result is averal over all aligned
    !   2) rms global is calculated using all aligned residues
    integer nref,ntar
    integer, intent(in) :: ires_first(:)
    integer, intent(in) :: nres_chain(:)
    integer, intent(in) :: ich_type(:)
    integer, intent(in) :: iratm_first(:)
    integer, intent(in) :: natm_res(:)
    real, intent(in) :: xyz_crd(:,:)
    real, intent(in) :: occup(:)
    character(len=*), intent(in) :: res_name_pdb(:)
    character(len=*), intent(in) :: res_num_pdb(:)
    character(len=*), intent(in) :: asm_group_id(:)
    
    character(len=*), intent(in) :: atm_name(:)

    integer nlen_align
    integer, intent(in) :: align_out(:,:)
    real, intent(out) :: rms_loc(:)
    !
    !  locals
    integer ifr,ist,ien
    integer i,k,l,m,i1,i2,ir1,ir2,ia1,ia2,ib1,ib2,na,na1
    real, allocatable :: xyz_r(:,:),xyz_t(:,:)

    !
    !   body
    rms_loc = 0.0
    do ifr = 1,nlen_align-5
       ist = ifr
       ien = ist + 5
       na = 0
       do k=ist,ien
          i1 = align_out(1,k)
          i2 = align_out(2,k)
          if(i1.gt.0.and.i2.gt.0) then
             ir1 = ires_first(nref) + i1-1
             ir2 = ires_first(ntar) + i2-1
             ia1 = iratm_first(ir1)
             ia2 = ia1 + natm_res(ir1) - 1
             do l=ia1,ia2
                if(occup(l).le.0.00001) cycle
                ib1 = iratm_first(ir2)
                ib2 = ib1+natm_res(ir2) - 1
                do m=ib1,ib2
                   if(occup(m).le.0.00001) cycle
                   if(atm_name(l).eq.atm_name(m)) then
                      na = na + 1
                      exit
                   endif
                enddo
             enddo
          endif
       enddo
       allocate(xyz_t(3,na))
       allocate(xyz_r(3,na))
       na1 = na
       na = 0
       do k=ist,ien
          i1 = align_out(1,k)
          i2 = align_out(2,k)

          if(i1.gt.0.and.i2.gt.0) then
             ir1 = ires_first(nref) + i1-1
             ir2 = ires_first(ntar) + i2-1
             ia1 = iratm_first(ir1)
             ia2 = ia1 + natm_res(ir1) - 1
             do l=ia1,ia2
                if(occup(l).le.0.00001) cycle
                ib1 = iratm_first(ir2)
                ib2 = ib1+natm_res(ir2) - 1
                do m=ib1,ib2
                   if(occup(m).le.0.00001) cycle
                   if(atm_name(l).eq.atm_name(m)) then
                      na = na + 1
                      xyz_r(1:3,na) = xyz_crd(1:3,l)
                      xyz_t(1:3,na) = xyz_crd(1:3,m)
                      exit
                   endif
                enddo
             enddo
          endif
          if(na1.eq.0) return
       enddo
       call procrust_dist(na,xyz_t,xyz_r,rms_loc(ifr))
       deallocate(xyz_t)
       deallocate(xyz_r)
    enddo
  end subroutine calc_aligned_rms_loc

end module ncs_generate
