C ============================================================================
C             HIERARCHY OF CRYSTAL STRUCTURE DESCRIPTION
C
C   Level of Hierarchy                               
C                         variable & pointer        !     constatnt         
C
C   CRYSTAL - UNIT CELL - is the contents of the unit cell and is generated
C          !              by the cryst. symmetrical operators from the 
C          !              contents of the asymmetrical part of unit cell.
C          !              Cell parameters, the list and the description of 
C          !              the links between symm.related chains.
C          !              Space group id and the cryst.symm. operators 
C          !              define the "crystal".
C          !  
C          !               cell parameters            !
C          !                                          !
C          !               space group id and list of ! symmetry operators
C          !               subgroups (Wyckoff symbol) !
C          !                                          !
C          !               list of links between      ! descriptions of links  
C          !               symm.related chains        !
C          !
C          v
C  ASYM.PART OF UNIT CELL - is the contents of asym. part of unit cell and
C          !                consists unit structural elements - "groups"/chains/
C          !                The list of the "groups" and list of links between
C          !                "groups", defines the asym. part of unit cell.
C          !
C          !                list of chains/groups/    !
C          !                                          !
C          !                list of links between     ! descriptions of links
C          !                chains                    !
C          !                          
C          v
C        CHAIN/GROUP/ - is numbered set of "monomers". The list of "monomers",
C          !            the links between monomers (for example:
C          !            disulfide bridges, peptide bond), the description of
C          !            some modification of monomers (for example: terminus
C          !            of polypeptide chain) define the chain. The polymer
C          !            is lenear covalet bonded set of monomers. A set
C          !            of water molecule is a chain. Chain may contain only
C          !            one monomer. 
C          !                                        
C          !            list of residue           !         
C          !                                      !
C          !            list of modifications     !descriptions of modifications
C          !                                      !
C          !            list of links inside chain! descriptions of links
C          !                                      !
C          v
C    RESIDUE or MONOMER  - is a set of atoms connected by bonds, or a single
C          !	          atom.
C          !          
C          !                                       !  descrioptions of residues
C          !                                       !    list of atoms
C          !                                       !    list of bonds
C          !                                       !    list of bonds
C          !                                       !    . . . . . . .
C          v
C         ATOM     - the  atom's type, their coordinates, B-factors, occupancies
C          !         multyplicity define the atom.
C          !                          
C          !                atomic name             descrioptions of atoms  
C          !                coordinates
C          !                . . . . . . 
C ===================================================================

C ==================================================================
C
C   Parameters
C
C  symmetry,NCS,atomic types,atoms,residues,chains,
C  links,modifications,internal angles
C
C ------------------------------------------------------------------
      INTEGER MAXATOM
      PARAMETER (MAXATOM = 150000)
      INTEGER MAXATSD
      PARAMETER (MAXATSD   = 1    )
      INTEGER MAXNSO
      PARAMETER (MAXNSO    = 192  )
      INTEGER   MAXNSF
      PARAMETER (MAXNSF    = 300  )
      INTEGER MAXNCS
      PARAMETER (MAXNCS    = 100   )
      INTEGER MAXRESID
      PARAMETER (MAXRESID  =100000 )
      INTEGER MAXCHAIN
      PARAMETER (MAXCHAIN  =1500  )
      INTEGER MAXMODIF
      PARAMETER (MAXMODIF  = MAXRESID )
      INTEGER MAXLINK
      PARAMETER (MAXLINK   = 3000 )
C ---
c      INTEGER MAXPHI
c      PARAMETER (MAXPHI    = 1    )
C -----------------------------------------------------------------
C  MAXATOM   - max. number of atoms
C  MAXATSD   - max. number of sigmas of atoms
C  MAXNSYM   - max. number of cryst. symm. operators 
C  MAXNSF    - max. number of atomic types 
C  MAXNCS    - max. number of NCS operators
C  MAXRESID  - max. number of residue /monomers/
C  MAXCHAIN  - max. number of chains
C  MAXMODIF  - max. number of modifications 
C  MAXLINK   - max. number of links
C  MAXPHI    - max. number of internal variable angles Phi
C===================================================================

C===================================================================
C
C
C      Common arrays for informations about crystal structure.
C
C
C===================================================================
C
C  I.  CELL and SPACE GROUP
C           General information about structure in coordinate file:
C           cell parameters, symmetry and NCS description,
C           atomic scattering coefficients, matrix to frac.coord system
C           and from.
C
C ---------------------------------------------------------
      COMMON /CRST_CRD/ CS_CELL
     *                 ,CS_ORT_TO_FRAC,CS_FRAC_TO_ORT
     *                 ,CS_M_CS,CS_V_CS,CS_M_NCS,CS_V_NCS
     *                 ,CS_A,CS_B,CS_C,CS_FI,CS_FII,CS_RADIUS
     *                 ,CS_NSYM,CS_NSYMOP,CS_NSPGR,CS_SETT,CS_NUMB_CS
     *                 ,CS_NSFATM,CS_NELEC,CS_NCS
     *                 ,CS_SPGR,CS_ATYPE,CS_ELEMENT

C    *                 ,CS_SPGR,CS_SYMOP,CS_ATYPE,CS_ELEMENT

      REAL      CS_CELL       (6)
      REAL      CS_ORT_TO_FRAC(3,3)
      REAL      CS_FRAC_TO_ORT(3,3)

C   ??? (3,3,MAXNSO) 
      REAL      CS_M_CS       (3,3,MAXNSO)
      REAL      CS_V_CS       (3  ,MAXNSO)
      REAL      CS_M_NCS      (3,3,MAXNCS)
      REAL      CS_V_NCS      (3  ,MAXNCS)

C !!!! (5,MAXNSF)
      REAL      CS_A     (5,MAXNSF)
      REAL      CS_B     (5,MAXNSF)

      REAL      CS_C     (MAXNSF)
      REAL      CS_FI    (MAXNSF)
      REAL      CS_FII   (MAXNSF)
      REAL      CS_RADIUS(MAXNSF)
      INTEGER*4 CS_NELEC (MAXNSF)
      INTEGER*4 CS_NSYM
      INTEGER*4 CS_NSYMOP
      INTEGER*4 CS_NSPGR
      INTEGER*4 CS_SETT
      INTEGER*4 CS_NUMB_CS(MAXNSO)
      INTEGER*4 CS_NSFATM
      INTEGER*4 CS_NCS
      CHARACTER CS_SPGR         *24

C     CHARACTER CS_SYMOP(MAXNSO)*24

      CHARACTER CS_ATYPE(MAXNSF)*4
      CHARACTER CS_ELEMENT(MAXNSF)*4
C ------------------------------------------------------------------
C  CS_CELL     -  Unit cell parameters  
C
C ---
C  Standard Ortogonal coord. system.         Fractional coord. system.
C
C    X                            | 11  12  13 |  X                 
C    Y  (Cartesian) = FRAC_TO_ORT | 21  22  23 |  Y  (fractional)
C    Z                            | 31  32  33 |  Z                 
C
C  CS_FRAC_TO_ORT 
C ---
C     Fractional coord. system.         Standard Ortogonal coord. system.
C
C    X                             | 11  12  13 |    X              
C    Y  (fractional) = ORT_TO_FRAC | 21  22  23 |    Y  (Cartesian)  
C    Z                             | 31  32  33 |    Z                  
C
C  CS_ORT_TO_FRAC 
C ---  
C   atomic scattering factors
C
C  CS_NSFATM
C  CS_ELEMENT - atom's type ( full name )
C  CS_ATYPE   - short name
C  CS_A     
C  CS_B     
C  CS_C     
C  CS_FI    
C  CS_FII   
C  CS_RADIUS
C ---  
C    crystallographical symmetry
C
C  CS_NSPGR    -  Space group number
C  CS_SETT     -  Setting number
C  CS_SPGR     -  Symbilic name of space group,i.e. 'P 21 21 21'
C  CS_NSYM     -  number or cryst. symmetry operators
C-----------  CS_SYMOP    -  cryst. symm. operators, symbolic representation
C ---
C  CS_NCS      -  number of non-cryst. symmetry operators
C
C    X                       | 11  12  13 |    X                  V_NCS(1)
C    Y  (Cartesian) =  M_NCS | 21  22  23 |    Y  (Cartesian)  +  V_NCS(2)
C    Z                       | 31  32  33 |    Z                  V_NCS(3)
C
C  CS_M_NCS    - NCS matrix
C  CS_V_NCS    - NCS vector
C ---
C===================================================================
C
C  II. Additional information about structure 
C      Information from PDB coordinate file:
C
C ------------------------------------------------------------------
C
c---Additional common block used in refmac. Some refinement flags
      INTEGER MAXNSF_AA
      PARAMETER ( MAXNSF_AA = (MAXNSF+1)*MAXNSF/2 )
      COMMON /CRST_REFM/ NGAUS,NGAUS2,CS_AA,CS_BB,ATOM_REF_FLAG
     *                  ,OCCUP_REF
      INTEGER NGAUS
      INTEGER NGAUS2
      INTEGER ATOM_REF_FLAG(MAXATOM)
      INTEGER OCCUP_REF(MAXATOM)
      REAL CS_AA(25,MAXNSF_AA)
      REAL CS_BB(25,MAXNSF_AA)
C
      COMMON /CRST_PDB/ CS_SCALE,CS_U
     *                 ,CS_TEMPER,CS_WAVEL
     *                 ,CS_RES_MIN,CS_RES_MAX 
     *                 ,CS_RFAC_ALL,CS_RFAC_OBS
     *                 ,CS_SIGMA_I,CS_SIGMA_F 
     *                 ,CS_MODEL_PDB
     *                 ,CS_CD_PDB,CS_CD_NDB,CS_CD_CSD
     *                 ,CS_NAME_PDB
     *                 ,CS_DATE_PDB,CS_DATE_NDB
     *                 ,CS_DATE_CREAT,CS_TITLE
     *                 ,CS_RESL_PDB,CS_RFAC_PDB
     *                 ,CS_PROGRAM,CS_METHOD
      REAL  CS_SCALE(3,3)
      REAL  CS_U(3)
      REAL  CS_TEMPER
      REAL  CS_WAVEL
      REAL  CS_RES_MIN
      REAL  CS_RES_MAX 
      REAL  CS_RFAC_ALL
      REAL  CS_RFAC_OBS
      REAL  CS_SIGMA_I
      REAL  CS_SIGMA_F 
      INTEGER*4 CS_MODEL_PDB
      CHARACTER CS_CD_PDB    *8
      CHARACTER CS_CD_NDB    *8
      CHARACTER CS_CD_CSD    *8
      CHARACTER CS_NAME_PDB  *80
      CHARACTER CS_DATE_PDB  *9
      CHARACTER CS_DATE_NDB  *10
      CHARACTER CS_DATE_CREAT*20
      CHARACTER CS_TITLE     *80
      CHARACTER CS_RESL_PDB  *40
      CHARACTER CS_RFAC_PDB  *40
      CHARACTER CS_PROGRAM   *40
      CHARACTER CS_METHOD    *40
C ------------------------------------------------------
C   PDB scale matrix and U vectors
C
C       Fractional coord. system.        Ortogonal coord system of data_PDB
C
C        X                     | 11  12  13 |    X                  U(1)
C        Y  (fract)   =  SCALE | 21  22  23 |    Y  (Cartesian)  +  U(2)
C        Z                     | 31  32  33 |    Z                  U(3)
C
C  CS_SCALE 
C  CS_U
C ---
C  CS_MODEL_PDB -  serial number of model
C  CS_CD_PDB    -  PDB code /_database_2.code_PDB/
C  CS_CD_NDB    -  NDB code /_database_2.code_NDB/
C  CS_CD_CSD    -  NDB code /_database_2.code_CSD/
C  CS_NAME_PDB  -  PDB name /_struct_keywords.text/  (PROTEIN,DNA,RNA,...)
C  CS_DATE_PDB  -  PDB creating date /_database_PDB_rev.data_original /
C  CS_DATE_NDB  -  NDB creating date 
C  CS_DATE_CREAT-  file creation date /_audit.creation_date /
C  CS_TITLE     -  title /_struct.title '5"-D(*CP*GP*CP*G)-3",SPERMIN' /
C  CS_RESL_PDB  -  resolution from PDB_remark
C  CS_RFAC_PDB  -  R-factor   from PDB_remark
C  CS_PROGRAM   -  refinement program name / _computing.structure_refinement / 
C  CS_METHOD    -   /_expt.method 'X_RAY DIFFRACTION'/ 
C  CS_TEMPER    -   /_diffrn.ambient_temp 293 /
C  CS_WAVEL     -   /_diffrn_radiation.wavelength  1.5418 /
C  CS_RES_MIN   -   /_refine.ls_d_res_low  /
C  CS_RES_MAX   -   /_refine.ls_d_res_high /
C  CS_RFAC_ALL  -   /_refine.ls_R_factor_all/
C  CS_RFAC_OBS  -  t.e. with cutoff /_refine.ls_R_factor_obs/
C  CS_SIGMA_I   -   / ? _reflns.observed_criterion  '>2sigma(I)' /
C  CS_SIGMA_F   -
C ===================================================================
C
C  II.a  More additional information about structure 
C
C -------------------------------------------------------------------
      COMMON /CRST_PDB_2/ CS_RFAC_CUT  ,CS_NMODEL     ,CS_RMERG_ALL
     *                   ,CS_RES_RMIN  ,CS_RES_RMAX   ,CS_RMERG_OBS
     *                   ,CS_SIGMAR_I  ,CS_SIGMAR_F 
     *                   ,CS_RMERG_IOBS
     *                   ,CS_RFREE_ALL ,CS_RFREE_OBS  ,CS_RFREE_CUT
     *                   ,CS_DPI       ,CS_ERR_CRD_MIN,CS_ERR_CRD_MAX
     *                   ,CS_NDB_TITLE ,CS_NAME_NDB 
     *                   ,CS_INFO_FLAG
      REAL  CS_DPI
      REAL  CS_ERR_CRD_MIN
      REAL  CS_ERR_CRD_MAX
C      REAL  CS_RMEGR_ALL??????????????????
      REAL  CS_RMERG_ALL
      REAL  CS_RMERG_OBS,CS_RMERG_IOBS
      REAL  CS_RES_RMIN
      REAL  CS_RES_RMAX 
      REAL  CS_SIGMAR_I
      REAL  CS_SIGMAR_F 
      REAL  CS_RFAC_CUT
      REAL  CS_RFREE_OBS
      REAL  CS_RFREE_ALL
C -------------------CAT?????????????????
      REAL  CS_RFREE_CUT
      INTEGER CS_NMODEL
      CHARACTER CS_NDB_TITLE  *80
      CHARACTER CS_NAME_NDB   *80
      CHARACTER CS_INFO_FLAG  *1
C ------------------------------------------
C    CS_RFAC_CUT  
C    CS_NMODEL
C    CS_RMEGR_ALL
C    CS_RMERG_OBS
C    CS_RMERG_IOBS
C    CS_RES_RMIN  
C    CS_RES_RMAX 
C    CS_RFREE_ALL 
C    CS_FREE_OBS
C    CS_FREE_CUT
C    CS_DPI
C    CS_ERR_CRD_MIN
C    CS_ERR_CRD_MAX
C    CS_NDB_TITLE 
C    CS_NAME_NDB
C    CS_INFO_FLAG
C =================================================================
C
C   III. CHAIN and ASYM.PART of unit cell
C            Information about asymm. part of unit cell and chains.
C
      COMMON /CIF_ENTITY_LIST/  N_CHN_ENT
     *                    ,ENT_NRES_CHAIN,ENT_IRES_FIRST
     *                    ,ENT_IGROUP_FIRST
     *                    ,ENT_IRES_START_TREE,ENT_IRES_END_TREE 
     *                    ,ENT_ITERM_S_TYPE   ,ENT_ITERM_F_TYPE
     *                    ,ENT_ICHAIN_TYPE
     *                    ,ENT_RES_START_TREE,ENT_RES_END_TREE 
     *                    ,ENT_TERM_S_TYPE   ,ENT_TERM_F_TYPE
     *                    ,ENT_CHAIN_ID      , ENT_CHAIN_TYPE 

      INTEGER*4  N_CHN_ENT
      INTEGER*4  ENT_NRES_CHAIN      (MAXCHAIN)   
      INTEGER*4  ENT_IRES_FIRST      (MAXCHAIN)   
      INTEGER*4  ENT_IGROUP_FIRST    (MAXCHAIN)   
      INTEGER*4  ENT_IRES_START_TREE (MAXCHAIN)   
      INTEGER*4  ENT_IRES_END_TREE   (MAXCHAIN)   
      INTEGER*4  ENT_ITERM_S_TYPE    (MAXCHAIN)
      INTEGER*4  ENT_ITERM_F_TYPE    (MAXCHAIN)
      INTEGER*4  ENT_ICHAIN_TYPE     (MAXCHAIN)

      CHARACTER  ENT_RES_START_TREE (MAXCHAIN)*5   
      CHARACTER  ENT_RES_END_TREE   (MAXCHAIN)*5   
      CHARACTER  ENT_TERM_S_TYPE    (MAXCHAIN)*8
      CHARACTER  ENT_TERM_F_TYPE    (MAXCHAIN)*8
      CHARACTER  ENT_CHAIN_ID       (MAXCHAIN)*4
      CHARACTER  ENT_CHAIN_TYPE     (MAXCHAIN)*16
C -------------------------------------------------------------------
C  N_CHN_ENT
C  ENT_CHAIN_TYPE
C  ENT_CHAIN_ID
C -----------------------------------------------------------------
      COMMON /CIF_ENT_POLY_SEQ/ ENT_NRESIDUE
     *                  ,ENT_IRES_SERIAL
     *                  ,ENT_IRES_BACK,ENT_IRES_FORW,ENT_ICHAIN
     *                  ,ENT_IRES_TYPE,ENT_ICONN_TYPE,ENT_MOD_ID
     *                  ,ENT_RES_NAME,ENT_RES_AUTH_NUM
     *                  ,ENT_RES_AUTH_BNUM,ENT_RES_AUTH_FNUM
      INTEGER*4 ENT_NRESIDUE
      INTEGER*4 ENT_IRES_SERIAL  (MAXRESID  )   
      INTEGER*4 ENT_IRES_BACK    (MAXRESID  )   
      INTEGER*4 ENT_IRES_FORW    (MAXRESID  )   
      INTEGER*4 ENT_ICHAIN       (MAXRESID  )
      INTEGER*4 ENT_IRES_TYPE    (MAXRESID  )
      INTEGER*4 ENT_ICONN_TYPE   (MAXRESID  )
      CHARACTER ENT_MOD_ID       (MAXRESID  )*8
      CHARACTER ENT_RES_NAME     (MAXRESID  )*8
      CHARACTER ENT_RES_AUTH_NUM (MAXRESID  )*5
      CHARACTER ENT_RES_AUTH_BNUM(MAXRESID  )*5
      CHARACTER ENT_RES_AUTH_FNUM(MAXRESID  )*5
C -----------------------------------------------------------------------
C  ENT_ICHAIN - pointer to ENT_CHAIN
C -----------------------------------------------------------------------
      COMMON /CIF_ENT_LINK/  ENT_LN_N,ENT_LN_DIST
     *                      ,ENT_LN_ICHAIN
     *                      ,ENT_LN_1IRES,ENT_LN_2IRES
     *                      ,ENT_LN_1RNAM,ENT_LN_2RNAM
     *                      ,ENT_LN_ATOM1,ENT_LN_ATOM2,ENT_LN_ID
     *                      ,ENT_LN_AUTH_NUM1,ENT_LN_AUTH_NUM2
     *                      ,ENT_LN_USED
      INTEGER*4 ENT_LN_N
      INTEGER*4 ENT_LN_ICHAIN   (MAXLINK)
      INTEGER*4 ENT_LN_1IRES    (MAXLINK)
      INTEGER*4 ENT_LN_2IRES    (MAXLINK)
      CHARACTER ENT_LN_1RNAM    (MAXLINK)*8
      CHARACTER ENT_LN_2RNAM    (MAXLINK)*8
      CHARACTER ENT_LN_ID       (MAXLINK)*8
      CHARACTER ENT_LN_AUTH_NUM1(MAXLINK)*5
      CHARACTER ENT_LN_AUTH_NUM2(MAXLINK)*5
      CHARACTER ENT_LN_ATOM1    (MAXLINK)*5
      CHARACTER ENT_LN_ATOM2    (MAXLINK)*5
      CHARACTER ENT_LN_USED     (MAXLINK)*1
      REAL      ENT_LN_DIST     (MAXLINK)
C -----------------------------------------------------------------------
C  ENT_LN_ICHN - pointer to ENT_CHAIN
C -----------------------------------------------------------------------
      COMMON /CIF_ASYM_PART/  N_GRP_ASM
     *                      ,ASM_CHAIN_POINTER,ASM_GROUP_POINTER
     *                      ,ASM_GROUP_ID,ASM_CHAIN_ID
      INTEGER*4  N_GRP_ASM
      INTEGER*4  ASM_CHAIN_POINTER (MAXCHAIN)
      INTEGER*4  ASM_GROUP_POINTER (MAXCHAIN)
      CHARACTER  ASM_GROUP_ID      (MAXCHAIN)*4
      CHARACTER  ASM_CHAIN_ID      (MAXCHAIN)*4
C -------------------------------------------------------------------
C  N_GRP_ASM
C  ASM_CHAIN_POINTER    pointer to  ENT_CHAIN
C  ASM_GROUP_POINTER    pointer to  GROUP / in common ASYM_PART/
C  ASM_GROUP_ID         = GROUP_ID / in common ASYM_PART/  
C  ASM_CHAIN_ID         = ENT_CHAIN_ID
C -------------------------------------------------------------------
      COMMON /ASYM_PART/  N_GROUP,I_GRP,I_NCS
     *                   ,NRES_CHAIN,NATM_CHAIN
     *                   ,IATOM_FIRST,IRES_FIRST
     *                   ,IRES_START_TREE,IRES_END_TREE
     *                   ,IGROUP_ASM,ICHAIN_GRP,MULT_FLAG
     *                   ,ITERM_S_TYPE,ITERM_F_TYPE,ICH_TYPE
     *                   ,NCS_FLAG,GROUP_ID,CHAIN_ID
      INTEGER*4 N_GROUP,I_GRP
      INTEGER*4 I_NCS           (MAXCHAIN)   
      INTEGER*4 NRES_CHAIN      (MAXCHAIN)   
      INTEGER*4 NATM_CHAIN      (MAXCHAIN)   
      INTEGER*4 IATOM_FIRST     (MAXCHAIN)   
      INTEGER*4 IRES_FIRST      (MAXCHAIN)   
      INTEGER*4 IRES_START_TREE (MAXCHAIN)   
      INTEGER*4 IRES_END_TREE   (MAXCHAIN)   
      INTEGER*4 ICHAIN_GRP      (MAXCHAIN)   
      INTEGER*4 IGROUP_ASM      (MAXCHAIN)   
      INTEGER*4 MULT_FLAG       (MAXCHAIN)   
      INTEGER*4 ITERM_S_TYPE    (MAXCHAIN)
      INTEGER*4 ITERM_F_TYPE    (MAXCHAIN)
      INTEGER*4 ICH_TYPE        (MAXCHAIN)
      CHARACTER NCS_FLAG        (MAXCHAIN)*1
      CHARACTER GROUP_ID        (MAXCHAIN)*4
      CHARACTER CHAIN_ID        (MAXCHAIN)*4
C -----------------------------------------------------------------
C N_GROUP      - number of groups in the structure. 
C I_GRP        - current pointer of group.
C I_NCS        - pointer to NCS matrix.
C NRES_CHAIN   - number of residues of chain.
C NATM_CHAIN   - number of atoms of chain.
C IATOM_FIRST  - pointer to first atom in arrays of coordinats.
C IRES_FIRST   - pointer to first residue of chain in arrays /RESID_INF/
C ICHAIN_GRP   - group's number with NCS oparator = 0
C IGROUP_ASM   - pointer to COMMON /CIF_ASYM_PART/
C MULT_FLAG    - 1, 2=>1/2, 3=>1/3, 4=>1/4, 6=>1/6, 8=>1/8, 12=>1/12 
C ITERM_S_TYPE - pointer to type of terminus of chain / "NH3",... /
C ITERM_F_TYPE - pointer to type of terminus of chain / "COO",... /
C ICH_TYPE     - pointer to type of chain /"polymer","non-poly","solvent",.../
C NCS_FLAG     - <"N">,"Y","C" 
C GROUP_ID     - 
C CHAIN_ID     - 
C===================================================================
C
C   IV.  Information about modifications.
C
C -------------------------------------------------------------------
      COMMON /MOD_INF/  MOD_N,MOD_IRES,MOD_ICHN,MOD_RNAM,MOD_ID
     * ,MOD_RNAM_NEW,MOD_SEQ,MOD_CHN,MOD_USED
      INTEGER*4 MOD_N
      INTEGER*4 MOD_IRES     (MAXMODIF)
      INTEGER*4 MOD_ICHN     (MAXMODIF)
      CHARACTER MOD_RNAM     (MAXMODIF)*8
      CHARACTER MOD_SEQ      (MAXMODIF)*5
      CHARACTER MOD_CHN      (MAXMODIF)*4
      CHARACTER MOD_ID       (MAXMODIF)*8
      CHARACTER MOD_RNAM_NEW (MAXMODIF)*8
      CHARACTER MOD_USED     (MAXMODIF)*1
C -----------------------------------------------------------------
C MOD_N    - number of modifications.
C MOD_IRES - serial number of residue which was modified. 
C MOD_ICHN - chain's number of residue which was modified. 
C MOD_RNAM - standard residue name
C MOD_RNAM_NEW - actual residue name
C MOD_ID   - ID of modifications.
C===================================================================
C
C   V.  Information about links.
C
C -------------------------------------------------------------------
      COMMON /LINK_INF/ LN_N,LN_DIST
     *                      ,LN_1IRES,LN_1ICHN,LN_2IRES,LN_2ICHN
     *                      ,LN_1RNAM,LN_2RNAM,LN_ID
     *                      ,LN_SEQ1,LN_SEQ2,LN_1CHN,LN_2CHN
     *                      ,LN_ATOM1,LN_ATOM2,LN_SYMM1,LN_SYMM2
     *                      ,LN_ALT1,LN_ALT2,LN_USED,LN_ENT
      INTEGER*4 LN_N
      INTEGER*4 LN_1IRES (MAXLINK)
      INTEGER*4 LN_1ICHN (MAXLINK)
      INTEGER*4 LN_2IRES (MAXLINK)
      INTEGER*4 LN_2ICHN (MAXLINK)
      CHARACTER LN_1RNAM (MAXLINK)*8
      CHARACTER LN_2RNAM (MAXLINK)*8
      CHARACTER LN_ID    (MAXLINK)*8
      CHARACTER LN_SEQ1  (MAXLINK)*5
      CHARACTER LN_SEQ2  (MAXLINK)*5
      CHARACTER LN_1CHN  (MAXLINK)*4
      CHARACTER LN_2CHN  (MAXLINK)*4
      CHARACTER LN_ATOM1 (MAXLINK)*5
      CHARACTER LN_ATOM2 (MAXLINK)*5
      CHARACTER LN_ALT1  (MAXLINK)*1
      CHARACTER LN_ALT2  (MAXLINK)*1
      CHARACTER LN_SYMM1 (MAXLINK)*8
      CHARACTER LN_SYMM2 (MAXLINK)*8
      CHARACTER LN_USED  (MAXLINK)*1
      CHARACTER LN_ENT   (MAXLINK)*1
      REAL      LN_DIST  (MAXLINK)
C -----------------------------------------------------------------------
C LN_N     - number of links.
C LN_1IRES - serial number of first residue which links with second one. 
C LN_1ICHN - chain's number of first residue. 
C LN_2IRES - serial number of second residue which links with second one. 
C LN_2ICHN - chain's number of second residue. 
C LN_1RNAM - residue's name of first residue. 
C LN_2RNAM - residue's name of second residue. 
C LINK_ID  - ID of links. For example, "SS  ".
C LN_SYMM2 - symmetry index of atom_2: 'nnn_ttt'
C ====================================================================


C ====================================================================
C
C  VI. ATOM. Part I. 
C             Information about atoms :
C             atom's names, types, symbols,alternative positions.
C
C --------------------------------------------------------------------
      COMMON /ATOM_INF/ N_ATOM,N_ANISO,I_ATM,I_ATOLD,I_RESID
     *                 ,ID_SF,B_FLAG,corr_id,belongs_chain,belongs_shell
     *                 ,ATM_NAME,ATM_NAME_INP,ATM_CHEM,ATM_TYPE
     *                 ,ID_ALT,ID_CORR,SEG_ID
      INTEGER*4 N_ATOM,I_ATM,N_ANISO
      INTEGER*4 I_ATOLD  (MAXATOM)
      INTEGER*4 I_RESID  (MAXATOM)
      INTEGER*4 ID_SF    (MAXATOM) 
      INTEGER*4 B_FLAG   (MAXATOM) 
      integer   corr_id  (maxatom)
      integer   belongs_chain(maxatom)
      integer   belongs_shell(maxatom)
      CHARACTER ATM_NAME (MAXATOM)*4  
      CHARACTER ATM_NAME_INP(MAXATOM)*4  
      CHARACTER ATM_CHEM (MAXATOM)*4  
      CHARACTER ATM_TYPE (MAXATOM)*1  
      CHARACTER ID_ALT   (MAXATOM)*1 
      CHARACTER ID_CORR  (MAXATOM)*1  
      CHARACTER SEG_ID   (MAXATOM)*8  
C ------------------------------------------------------------
C N_ATOM     - total number of atoms in structure.
C I_ATM      - current pointer
C I_ATOLD    - old (from file) global serial number of atom. 
C I_RESID    - pointer to residue.
C ID_ALT     - ID of alternative position.           
C ID_CORR    - ID of correlated alt. positions.      
C                      
C ATM_NAME   - atom's name - 4 chars.                
C ID_SF      - pointer to arrays A,B,C,FI,FII,RADIUS 
C ATM_TYPE   - atom's type: "M" missing,"R" rebuild,"D" dummy, "U" unknown/ 
C
C B_FLAG     - = 0 - B_iso, # 0 - U_ANISO  
C =============================================================
C
C  VII.  ATOM. Part II.
C             Information about atomic coordinates :
C             X Y Z, thermal factors,occupancies.
C
C -------------------------------------------------------------
      COMMON /ATOM_CRD/ XYZ_CRD,SD_CRD,U_ANISO,SD_ANISO
     *                 ,OCCUP,SD_OCC,MULT_FACTOR

      REAL   XYZ_CRD    (3,MAXATOM)  
      REAL   SD_CRD     (3,MAXATSD)  

      REAL   U_ANISO  (6,MAXATOM)  
      REAL   SD_ANISO (6,MAXATSD)  

      REAL   OCCUP      (MAXATOM)  
      REAL   SD_OCC     (MAXATSD)
      INTEGER*4 MULT_FACTOR(MAXATOM)
C --------------------------------------------------------------
C XYZ_CRD  - coordinates.                             
C SD_CRD   - sd of coords.                            
C B_ISO    - iso.temp.factor                          
C SD_ISO   - sd iso.temp.factor                       
C OCCUP    - occupancy.                               
C SD_OCC   - sd occupancy.                           
C MULT_FACTOR  - 1, 2=>1/2, 3=>1/3, 4=>1/4, 6=>1/6, 8=>1/8, 12=>1/12 
C U_ANISO  - aniso.temp.factor                        
C SD_ANISO - sd aniso                                  
C N_ANISO  - number of aniso.temp.factors
C===================================================================
C
C  IX. RESIDUE
C                Information about residues.
C
C -----------------------------------------------------------------
      COMMON /RESID_INF/ N_RESIDUE,I_RESIDUE
     *                  ,NATM_RES,IRES_SERIAL
     *                  ,IRES_GLOBAL,IRES_BACK,IRES_FORW
     *                  ,IRATM_FIRST,I_CHAIN,IRES_TYPE,ICONN_TYPE
     *                  ,RES_NAME,RES_NAME_PDB,RES_NUM_PDB
     *                  ,MOD_FLAG,LINK_FLAG
      INTEGER*4 N_RESIDUE,I_RESIDUE
      INTEGER*4 NATM_RES    (MAXRESID  )  
      INTEGER*4 IRES_SERIAL (MAXRESID  )   
      INTEGER*4 IRES_GLOBAL (MAXRESID  )   
      INTEGER*4 IRES_BACK   (MAXRESID  )   
      INTEGER*4 IRES_FORW   (MAXRESID  )   
      INTEGER*4 IRATM_FIRST (MAXRESID  )
      INTEGER*4 I_CHAIN     (MAXRESID  )
      INTEGER*4 IRES_TYPE   (MAXRESID  )
      INTEGER*4 ICONN_TYPE  (MAXRESID  )
      CHARACTER RES_NAME    (MAXRESID  )*8
      CHARACTER RES_NAME_PDB(MAXRESID  )*3
      CHARACTER RES_NUM_PDB (MAXRESID  )*12
      CHARACTER MOD_FLAG    (MAXRESID  )*1
      CHARACTER LINK_FLAG   (MAXRESID  )*1
C ----------------------------------------------------------------
C N_RESIDUE   - total number of residues in structure.
C I_RESIDUE   - current pointer to residue.
C NATM_RES    - number of atoms of each residue. 
C IRES_SERIAL - serial number of residue in the chain (1,2,....)
C IRES_GLOBAL - for special application
C IRATM_FIRST - pointer to first atom of residue.
C I_CHAIN     - pointer to chain
C RES_NAME    - 8 letters code of residue.            
C RES_NAME_PDB- 3 letters code of residue from PDB file.            
C RES_NUM_PDB -   chainID    +  residue's number + insertion code PDB 
C               (PDB_ID + ' ')   _atom_site.auth_seq.id
C 
C IRES_TYPE    - pointer to type of residue: "pept","DNA","RNA,"solv",...
C      standard res types:
C      RES_TYPE( 1) =  '.               '
C      RES_TYPE( 2) =  'non-polymer     '
C      RES_TYPE( 3) =  'L-peptide       '
C      RES_TYPE( 4) =  'D-peptide       '
C      RES_TYPE( 5) =  'DNA             '
C      RES_TYPE( 6) =  'RNA             '
C      RES_TYPE( 7) =  'D-pyranose      '
C      RES_TYPE( 8) =  'L-pyranose      '
C      RES_TYPE( 9) =  'solvent         '
C      RES_TYPE(10) =  'polymer         '
C      RES_TYPE(11) =  'D-furanose      '
C      RES_TYPE(12) =  'L-furanose      '
C      RES_TYPE(13) =  'D-saccharide    '
C      RES_TYPE(14) =  'L-saccharide    '
C ICONN_TYPE   - pointer to type of connectivity with previous residue:
C                                                          "CIS","TRANS",...
C MOD_FLAG    - flag of modification. If "Y",there is information in /MOD_INF/
C LINK_FLAG   - flag of links. If "Y",there is information in /LINK_INF/
C ----------------------------------------------------------------
      COMMON /RESID_INF_2/CENTER_RES,RADIUS_RES,IFLAG_RES
      REAL                CENTER_RES(3,MAXRESID  )
      REAL                RADIUS_RES(MAXRESID  )
      INTEGER             IFLAG_RES (MAXRESID  )
C ===================================================================



C ==============================================================
C
C  X. restraints / only numbers /. All details in rstr-com.fh
C
C --------------------------------------------------------------
      COMMON /RESTR_COM/ RB_NUMB,RA_NUMB,RT_NUMB,RC_NUMB,RP_NUMB
     *                  ,RH_NUMB,RV_NUMB
      INTEGER*4 RB_NUMB
      INTEGER*4 RA_NUMB
      INTEGER*4 RT_NUMB
      INTEGER*4 RC_NUMB
      INTEGER*4 RP_NUMB
      INTEGER*4 RH_NUMB
      INTEGER*4 RV_NUMB
C ==============================================================

C ==============================================================
C
C  XI.  program and library file.
C
      COMMON /COM_DICT_FILE/ PROG_NAME_LB,LIB_NAME,LIB_VERS,LIB_DATE 
     *                      ,PROG_NAME_CRD 
      CHARACTER PROG_NAME_LB *8
      CHARACTER LIB_NAME     *10
      CHARACTER LIB_VERS     *10
      CHARACTER LIB_DATE     *10
      CHARACTER PROG_NAME_CRD*8
C
C LIB_NAME   -
C LIB_VERS   - library information
C LIB_DATE   -
C ==============================================================

C ==============================================================
C
C  XII.  CIF_types.
C
C -------------------------------------------------------------------
C
C     initialization in subroutine INIT_ATM_INF (make_subr.f)
C
      COMMON /COM_OUT_CIF/ OUT_CIF_MULT,OUT_CIF_CORR,OUT_CIF_INS 
      INTEGER*4            OUT_CIF_MULT,OUT_CIF_CORR,OUT_CIF_INS 
C -------------------------------------------------------------------
C
C     initialization in SET_CIF_TYPES ( call start() - make_subr.f)
C
      INTEGER   MAXTYPES 
      INTEGER   MAXTYPES2 
      PARAMETER (MAXTYPES =  20)
      PARAMETER (MAXTYPES2 = 40)
      COMMON /CIF_TYPES/ 
     *                   N_RES_TYPE,N_STERM_TYPE,N_FTERM_TYPE
     *                  ,N_CONN_TYPE,N_CH_TYPE
     *                  ,RES_TYPE,RES_LTYPE
     *                  ,TERM_S_TYPE,TERM_F_TYPE,CONN_TYPE
     *                  ,CH_TYPE

C     *                  ,N_LINK_TYPE
C     *                  ,LINK_TP_ID,LINK_TP_MON1,LINK_TP_MON2
C     *                  ,LINK_TP_ATOM1,LINK_TP_ATOM2,LINK_TP_GRP

      INTEGER*4 N_RES_TYPE
      INTEGER*4 N_STERM_TYPE
      INTEGER*4 N_FTERM_TYPE
      INTEGER*4 N_CONN_TYPE
      INTEGER*4 N_CH_TYPE

      CHARACTER RES_TYPE    (MAXTYPES )*16
      CHARACTER RES_LTYPE   (MAXTYPES )*8
      CHARACTER TERM_S_TYPE (MAXTYPES )*8
      CHARACTER TERM_F_TYPE (MAXTYPES )*8
      CHARACTER CONN_TYPE   (MAXTYPES2)*8
      CHARACTER CH_TYPE     (MAXTYPES )*8

C      CHARACTER LINK_TP_ID   (MAXTYPES )*8
C      CHARACTER LINK_TP_MON1 (MAXTYPES )*8
C      CHARACTER LINK_TP_MON2 (MAXTYPES )*8
C      CHARACTER LINK_TP_ATOM1(MAXTYPES )*4
C      CHARACTER LINK_TP_ATOM2(MAXTYPES )*4
C      CHARACTER LINK_TP_GRP  (MAXTYPES )*1
C      INTEGER*4 N_LINK_TYPE
C -----------------------------------------------------------------
C N_RES_TYPE   - number of types of monomers.
C N_STERM_TYPE - number of types of N-terminus.
C N_FTERM_TYPE - number of types of C-terminus.
C N_CONN_TYPE  - number of types of connections.
C RES_TYPE    _ type of each residue: "pept","DNA","RNA,"solv",...
C TERM_S_TYPE - type of terminus of chain: "NH3"
C TERM_F_TYPE - type of terminus of chain: "COO"
C CONN_TYPE   - type of connectivity with previous residue:"CIS","TRNS",...
C===================================================================
      INTEGER MAXMODREC
      PARAMETER (MAXMODREC = 20)
      COMMON /COM_MOD_REC/ 
     *  N_MOD_REC,MOD_REC_IRTYPE,MOD_REC_DETAIL
     * ,MOD_REC_FUNC,MOD_REC_ID               

      INTEGER*4   N_MOD_REC 
      INTEGER*4   MOD_REC_IRTYPE(MAXMODREC)   
      CHARACTER   MOD_REC_DETAIL(MAXMODREC)*48
      CHARACTER   MOD_REC_FUNC  (MAXMODREC)*3
      CHARACTER   MOD_REC_ID    (MAXMODREC)*8
C===================================================================
