C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE LIBCHECK(MDOC,LIST,MON,H_FLAG,FILE_L
     * ,FILE_SMILE,FILE_MOL
     * ,FILE_PDB,FILE_CIF,FILE_CSD,FILE_PDB_D,FILE_O,VANGLE
     * ,IND_FLAG,PROG_LIB_PATH,LIBS_PATH,LIBS_NAME,LIBS_EXT
     * ,FILE_L2,PROG_NAME,REF,ITEST,COOR,LCOOR,NODIST,SRCH,IERR)
C -------------------------------------------------------
C                   ---    LIBCHECK    ---
C                                             /Vers 2.0 20.03.98/
C
C     LIBCHECK - reads library of monomers, gives information about some
C                monomer, creates PostScript file with picture and information
C                about bonds, angles, ...
C                can read additional library, add two libraries and write to
C                a new library file ;
C                can create description of new monomer reading coordinates
C                from PDB file of CIFile.
C
C                                  
C       It is possible to use subroutine LIBCHECK instead of program.
C       Use all subroutines without "main_libcheck.f" which just
C       prepares parameters for subroutine "libcheck".
C
C        SUBROUTINE LIBCHECK(MDOC,MON,H_FLAG,FILE_L
C     * ,FILE_PDB,FILE_CIF,FILE_PDB_D,FILE_O,VANGLE,IERR)
C 
C      input parameters:
C 
C         MDOC         -  =999 with  DOC-file: "libcheck.doc",  
C                        if = -999 without this file.
C                        It must be 999 or -999 !!!!
C
C      MON: < > - give info about this monomer 
C                 / don't foget about capital letters !!!/ 
C      ANGLE  <0.0> rotation angle for picture ( around X )
C                   Cooordinate system: X from top to bottom of page
C                                       Y from left to right
C
C      FILE_O: < > output file /new library/, " " means without this file
C
C      FILE_L: < > additional library, " " means without this file
C
C      FILE_PDB: < > input PDB_file ," " means without this file
C                    this file
C
C      FILE_CIF: < > input CIFile  ," " means without this file
C                   
C      H_FLAG: <Y>/A/N - Y - hydrogen atoms where they are
C                        A - with all hydrogen atoms
C                        N - without hydrogen atoms
C
C      output:
C
C         IERR          - signal of error, 0 means OK.
C ---
C      INTEGER*4 IERR,MDOC
C      CHARACTER MON*3,FILE_L*(*),FILE_O*(*)
C      CHARACTER H_FLAG*1,FILE_PDB*(*),FILE_CIF*(*)
C 
C ---------------------------------------------------------------------
C -------------------------------------------------------
C  LIBCHECK - 
C
C
C            SETPARM_LBC
C            GETLIB         --> make_lib.f
C            READ_LIB       --> make_lib.f
C
C            for PDB:
C              INITCRD_LBC
C              GET_PDB      --> make_PDB.f (use GET_SYMMC from make_subr.f)
C              PRE_DESCR    --> make_crd.f
C              CHECK_DESCR_STRUCTURE
C                           --> make_crd.f (use CHECK_COMPL from make_crd.f
C                                               MODIF       from make_lib.f
C                                               CREAT_NEW   from make_new.f)
C            for PDB_dict
C              GET_PDB_DICT --> make_DPDB.f (use RING from make_new.f)
C
C            for CIF
C              INITCRD_LBC
C              READ_ATOMS   --> make_CIF.f
C              PRE_DESCR    --> make_crd.f
C              CHECK_DESCR_STRUCTURE
C                           --> make_crd.f(use CHECK_COMPL  from make_crd.f 
C                                               MODIF       from make_lib.f
C                                               CREAT_NEW   from make_new.f)
C
C            WRT_LIB        --> make_lib.f
C
C
C            for MON from dictionary
C              CHECK_MON----------+
C                                 !
C                                 V
C                              CP_MLIB                --> make_lib.f 
C                              CREAT_NEW(MODE='CONN') --> make_new.f
C                              CPL_MLIB               --> make_lib.f
C                              SET_NUML       !
C                              CREATE_BLCRD   !
C                              CALC_VVOBSL    !
C                              GRAPH_NEWL     !---> make_new.f
C                              CP_VOBS_VLIB   !
C -----------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      INTEGER*4 IERR,MDOC
      CHARACTER MON*8,FILE_L*(*),FILE_O*(*),FILE_CSD*(*),IND_FLAG*1
      CHARACTER FILE_SMILE*(*),FILE_MOL*(*)
      CHARACTER FILE_PDB*(*),FILE_CIF*(*),FILE_PDB_D*(*)
      CHARACTER LIBS_PATH*(*),LIBS_NAME*(*),LIBS_EXT*(*),FILE_L2*(*)
      CHARACTER COOR*1,NODIST*1,H_FLAG*1
C ---------
      CHARACTER LIB_PATH*256
      CHARACTER MOD*1
      INTEGER*4 M,LEN,NOSPGR_INPUT
      REAL      CELL_INPUT(6)
      CHARACTER LINE*256,EXT*256,PATH*256
      CHARACTER LIBM_PATH*256    ,LIBE_PATH*256 
      CHARACTER LIBM_NAME(20)*256,LIBE_NAME*256
      CHARACTER LIBM_EXT*256     ,LIBE_EXT*256 ,FILE_LIB_OUT*256 
      CHARACTER LIB_IND*256
      CHARACTER NAMEO*256

      integer   natommax
      parameter ( natommax = 500 )
      integer   natom
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      real      xyz_sdf(3,natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      character latom_symb(natommax)*2
      integer   ntorsmax
      parameter ( ntorsmax = 100 )
      integer   ntors,ltors_period(ntorsmax)
      integer   ltors_atom(4,ntorsmax)
      real      ltors(2,ntorsmax)

      CHARACTER CH1*1,CHAR1*1,MODE*4,LIST*1,REF*1,SRCH*1,LCOOR*1
      CHARACTER PROG_LIB_PATH*(*),PROG_NAME*(*)
      CHARACTER LIBCHECK_LIB_FLAG*1
c
      integer nmodes
      character*4 modes(5)
C ---
      INCLUDE 'libcheck_version.fh'
C -----------------------------------------------

      IERR = 0
      NOSPGR_INPUT = 0
      DO I=1,6
        CELL_INPUT(I) = 0.0
      ENDDO
C -----------------------------
      CALL SET_PATH_PROG_PARM(PROG_LIB_PATH,PROG_NAME
     *                         ,LIBS_PATH,LIBS_NAME,LIBS_EXT)
C ------------------------------
C ------------------------------
      IF(ABS(MDOC).GE.997) THEN
        MDOC_C=1
        IF(MDOC.LT.0) THEN
          MDOC=0
        ELSE      
C   
C         MDOC=999
C         IF(MSG.EQ.'Y') MDOC=999 do not keep old contents
C         IF(MSG.EQ.'A') MDOC=998 keep old contents
C         IF(MSG.EQ.'#') MDOC=997 batch mode, "_DOC " will be read
C          
C         for subroutine case:
C
C         MDOC=999 do not keep old contents
C         MDOC=998 keep old contents
C
C         MDOC=-999 without DOC-file
C
        ENDIF
        CALL START(0,MDOC,PROG_NAME)
      ELSE
        MDOC_C=0
      ENDIF
C ---------------------------
      IF(MDOC.GT.0) THEN
        M=-1
        CALL MSGDOC(M,' ')
        CALL MSGDOC(M,VERSION)
        CALL MSGDOC(M,' ')
      ENDIF
      CALL CLOSE_BATCH(M)
C ------------------------------------------
      M=0
      CALL SETPARM_LBC(MDOC,LIB_PATH,IERR)
      IF(IERR.NE.0) GO TO 100
C ------------------------------------------
      IF(NODIST.EQ.'y') NODIST = 'Y' 
      IF(NODIST.NE.'Y') NODIST = 'N'
      
      IF(SRCH.EQ.'y') SRCH = 'Y' 
      IF(SRCH.EQ.'a') SRCH = 'A' 
      IF(SRCH.EQ.'n') SRCH = 'N' 
      IF(SRCH.EQ.'g') SRCH = 'G' 
      IF(SRCH.NE.'Y'.AND.SRCH.NE.'A'.AND.SRCH.NE.'G'.AND.
     *   SRCH.NE.'0') SRCH = 'N'
      if(nodist.eq.'Y') SRCH = '0'

      IF(COOR.EQ.'y') COOR = 'Y' 
      IF(COOR.EQ.'a') COOR = 'A' 
      IF(COOR.NE.'Y'.AND.COOR.NE.'A') COOR = 'N'

      IF(LCOOR.EQ.'n') LCOOR = 'N' 
      IF(LCOOR.NE.'N') LCOOR = 'Y'

      IF(REF.EQ.'n') REF = 'N' 
      IF(REF.EQ.'t') REF = 'T' 
      IF(REF.EQ.'s') REF = 'S' 
      IF(REF.NE.'N'.AND.REF.NE.'S'.AND.REF.NE.'T'.AND.REF.NE.'0') 
     *REF = 'Y'

      IF(LIST.EQ.'s') LIST = 'S' 
      IF(LIST.EQ.'l') LIST = 'L' 
      IF(LIST.EQ.'t') LIST = 'T' 
      IF(LIST.NE.'S'.AND.LIST.NE.'L'.AND.LIST.NE.'T') LIST = 'M'


      IF(H_FLAG    .EQ.'n') H_FLAG     = 'N' 
      IF(H_FLAG    .EQ.'a') H_FLAG     = 'A' 
      IF(H_FLAG .NE.'A'.AND.H_FLAG .NE.'N') H_FLAG  = 'Y' 
   
      IF(IND_FLAG .EQ.'y') IND_FLAG  = 'Y' 
      IF(IND_FLAG .NE.'Y') IND_FLAG  = 'N' 
      CALL LENSTR_BL(MON,L)
      IF(L.GT.0.AND.MON(1:1).NE.' '.AND.MON(1:1).NE.',') THEN
        LINE = 'MON   : '//MON
        CALL MSGDOC(MDOC,LINE)
      ENDIF 
      CALL MSGDOC(MDOC,'-------------')
C ---
      LIB_PATH     = PROG_LIB_PATH
      LIBM_PATH    = LIB_PATH
C ---
      LIB_PATH     = PROG_LIB_PATH 
      LIBE_PATH    = LIB_PATH      
c      LIBE_NAME    = 'ener_lib'
c      LIBE_EXT     = 'cif'
C ---
C    ener_lib,mods,links and only list of monomers 
C 
C ---
      FILE_LIB_OUT = ' '
      CRO_FILE     = ' '
      CALL LENSTR_BL(FILE_O,L)
      IF(L.GT.0.AND.FILE_O(1:1).NE.' '.AND.FILE_O(1:1).NE.',') THEN
        CRO_FILE = FILE_O 
        IF(L.GT.65 ) L = 65
        LINE = 'Output file   :'//FILE_O(1:L)  
        CALL MSGDOC(MDOC,LINE)
      ELSE
        CRO_FILE = ' '
      ENDIF

      CALL LENSTR_BL(FILE_L,L)
      IF(L.LE.0.OR.FILE_L(1:1).EQ.' '.OR.FILE_L(1:1).EQ.',') THEN
        FILE_L = ' '
        NODIST = 'N'
      ELSE
C--- 16.12.2009 
C       nodist = 'Y'
C---
        IF(L.GT.65 ) L = 65
        LINE = 'Input user lib:'//FILE_L(1:L)  
        CALL MSGDOC(MDOC,LINE)
        NAMEO = FILE_O 


C--- 16.12.2009
        CALL LENSTR_BL(FILE_L2,L)
        IF(L.LE.0.OR.FILE_L2(1:1).EQ.' '.OR.FILE_L2(1:1).EQ.',') THEN
c         nodist = 'Y'
C---
          CALL LENSTR_BL(NAMEO,L)
          IF(L.LE.0.OR.NAMEO(1:1).EQ.',') THEN
            NAMEO = 'libcheck_pdb.lib'
          ENDIF
          CALL pdb2lib_sub(FILE_L,NAMEO,coor,LIBCHECK_LIB_FLAG,IERR)
          IF(IERR.NE.0) THEN
            CALL MSGERR(MDOC,'ERROR: in pdb2lib_sub')       
            GO TO 100
          ENDIF
          IF(LIBCHECK_LIB_FLAG.EQ.'N') THEN
            FILE_L = NAMEO
          ENDIF
C--- 16.12.2009
        ENDIF
C---

      ENDIF
      CALL LENSTR_BL(FILE_PDB  ,LEN_PDB)
      IF(LEN_PDB.GT.0.AND.FILE_PDB(1:1).NE.' '.AND.
     *  FILE_PDB(1:1).NE.',') THEN
        L = LEN_PDB
        IF(L.GT.65 ) L = 65
        LINE = 'Input PDB file:'//FILE_PDB(1:L)  
        CALL MSGDOC(MDOC,LINE)
        IF(NODIST.NE.'N') THEN
          SRCH = '0'
        ENDIF
      ENDIF

      CALL LENSTR_BL(FILE_SMILE,LEN_SMILE)
      IF(LEN_SMILE.GT.0.AND.FILE_SMILE(1:1).NE.' '.AND.
     *  FILE_SMILE(1:1).NE.',') THEN
        L = LEN_SMILE
        IF(L.GT.63 ) L = 63
        LINE = 'Input SMILE file:'//FILE_SMILE(1:L)  
        CALL MSGDOC(MDOC,LINE)
        NODIST = 'Y'
        IF(NODIST.NE.'N') THEN
          SRCH = '0'
        ENDIF
      ENDIF
c
      CALL LENSTR_BL(FILE_MOL,LEN_MOL)
      IF(LEN_MOL.GT.0.AND.FILE_MOL(1:1).NE.' '.AND.
     &   FILE_MOL(1:1).NE.',') THEN
         L = LEN_MOL
         IF(L.GT.63) L = 63
         LINE = 'INPUT file:'//FILE_MOL(1:L)
         CALL MSGDOC(MDOC,LINE)
         NODIST = 'Y'
         COOR   = 'Y'
         LCOOR  = 'Y'
         REF    = '0'
         IF(NODIST.NE.'N') THEN
            SRCH = '0'
         ENDIF
      ENDIF
c
      CALL LENSTR_BL(FILE_L2,L2)
      IF(L2.LE.0.OR.FILE_L2(1:1).EQ.' '.OR.FILE_L2(1:1).EQ.',') THEN
        FILE_L2 = ' '
      ENDIF
C ---
      IF(NODIST.NE.'N') THEN
        IF(SRCH.NE.'0') SRCH = '0'
      ENDIF

      CALL MSGDOC(MDOC,'-------------')
      CALL MSGDOC(MDOC,'Keywords:')
      LINE = 'HFLAG : '//H_FLAG
      CALL MSGDOC(MDOC,LINE)
      LINE = 'COOR  : '//COOR
      CALL MSGDOC(MDOC,LINE)
      LINE = 'LCOOR : '//LCOOR
      CALL MSGDOC(MDOC,LINE)
      LINE = 'SRCH  : '//SRCH
      CALL MSGDOC(MDOC,LINE)
      LINE = 'REF   : '//REF
      CALL MSGDOC(MDOC,LINE)
      LINE = 'NODIST: '//NODIST
      CALL MSGDOC(MDOC,LINE)

      ntors = 0
c
c----Read energy parameters
      mode = 'ALL '
      call rd_enrlib(mdoc,mode,ierr)
c
c---Now start dealing with various forms of intput files and formats
C ---------------------------- 
      CALL LENSTR_BL(FILE_SMILE,LEN_SMILE)
      IF(LEN_SMILE.GT.0) THEN
        NAMEO = FILE_O 
        CALL CREAT_MIN_FROM_SMILE(MDOC,LIST
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *       ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *       ,MON,FILE_SMILE,NAMEO,IERR)

        IF(IERR.NE.0) GO TO 100
        FILE_L = NAMEO
      ENDIF
c
c-------------
      CALL LENSTR_BL(FILE_MOL,LEN_MOL)
      IF(LEN_MOL.GT.0) THEN
        NAMEO = FILE_O 
        CALL molfile_2_dict(MDOC,LIST
     *     ,natommax,natom,latom_charge,latom_nhydr
     *     ,latom_weight,xyz_sdf,latom_name,latom_symb,latom_chiral
     *     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *     ,MON,FILE_MOL,NAMEO,IERR)
        IF(IERR.NE.0) GO TO 100
        FILE_L = NAMEO
      ENDIF
C ---------------------------- 
      IADD = 1
 
      CALL LENSTR_BL(FILE_L2,L2)
      IF(L2.GT.0.AND.FILE_L2(1:1).NE.' '.AND.FILE_L2(1:1).NE.',') THEN
        CALL GETLIB_FOR_ADD(MDOC,LIST,NUMB_LIB,NODIST
     *                   ,LIBE_PATH,LIBE_NAME,LIBE_EXT,LIB_IND
     *                   ,FILE_L,FILE_L2,FILE_LIB_OUT ,IERR)
        IF(IERR.NE.0) GO TO 100 
c
        CALL LENSTR_BL(FILE_L,L)
        CALL LENSTR_BL(FILE_L2,L2)
        IF((L .GT.0.AND.FILE_L (1:1).NE.' '.AND.FILE_L (1:1).NE.',')
     *    .AND.
     *     (L2.GT.0.AND.FILE_L2(1:1).NE.' '.AND.FILE_L2(1:1).NE.','))
     *    THEN  
          CH1   = 'R'
          CHAR1 = ' '
          CALL SSET_FUSE(CH1,CHAR1)
C
C         add FILE_L to FILE_L2
C
          MOD='M'

          CALL READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
C--- 16.12.2009
          IF(IERR.EQ.333) IERR = 0
C---
          IF(IERR.NE.0) GO TO 100    
 
          CALL LENSTR_BL(FILE_O,L)
          IF(L.GT.0.AND.FILE_O(1:1).NE.' '.AND.FILE_O(1:1).NE.',') THEN
            LMO_FILE = FILE_O
            LMO_PATH = ' '
            LMO_EXT  = 'lib'
          ELSE
            LMO_FILE = 'libcheck'
            LMO_PATH = ' '
            LMO_EXT  = 'lib'
          ENDIF
          GO TO 200
        ELSE
          IERR = 1
          GO TO 100
        ENDIF
      ELSE

         CALL GETLIB(MDOC,LIST,NODIST,NUMB_LIB
     *        ,LIBM_PATH,LIBE_PATH,LIBS_PATH
     *        ,LIBM_NAME,LIBE_NAME,LIBS_NAME
     *        ,LIBM_EXT ,LIBE_EXT ,LIBS_EXT
     *        ,FILE_L   ,LIB_IND  ,FILE_LIB_OUT ,IERR)
         IF(IERR.NE.0) GO TO 100 
      ENDIF
C     ----------------------------------------------
      CALL LENSTR_BL(FILE_CIF  ,LEN_CIF)
      CALL LENSTR_BL(FILE_PDB  ,LEN_PDB)
      CALL LENSTR_BL(FILE_CSD  ,LEN_CSD)
      CALL LENSTR_BL(FILE_PDB_D,LEN_DIC)
C -----------------------------------
      
      IF(LEN_PDB.GT.0.AND.FILE_PDB(1:1).NE.' '.AND.
     *  FILE_PDB(1:1).NE.',') THEN
C
C       read PDB_file.
         CALL CHECK_PDB_MON(MDOC,LIST,COOR,SRCH
     *        ,REF,ITEST,VANGLE,LCOOR,NODIST
     *        ,FILE_PDB,H_FLAG,MON,PROG_NAME,FILE_O,IERR)
         IF(IERR.NE.0) GO TO 100
         GO TO 100

C ----
      ELSE IF(LEN_CIF.GT.0.AND.FILE_CIF(1:1).NE.' '.AND.
     *        FILE_CIF(1:1).NE.',') THEN
C
C     read CIFile.
C     
         CALL CHECK_CIF_MON(MDOC,LIST,COOR,SRCH
     *        ,REF,ITEST,VANGLE,LCOOR,NODIST
     *        ,FILE_CIF,H_FLAG,PROG_NAME,FILE_O,IERR)
         IF(IERR.NE.0) GO TO 100
         GO TO 100
C ----
      ELSE IF(LEN_CSD.GT.0.AND.FILE_CSD(1:1).NE.' '.AND.
     *        FILE_CSD(1:1).NE.',') THEN
C     
C       read CSD CIFile.
C
         CALL CHECK_CSD_MON(MDOC,LIST,COOR,SRCH
     *        ,REF,ITEST,VANGLE,LCOOR,NODIST
     *        ,FILE_CSD,H_FLAG,PROG_NAME,FILE_O,IERR)
         IF(IERR.NE.0) GO TO 100
         GO TO 100
         
      ELSE IF(MON(1:1).NE.' '.AND.MON(1:1).NE.',') THEN
C     
C       one monomer checking
C
         IF(MON(1:1).EQ.'?') THEN
            CALL CHECK_ALL_MON(MDOC,LIST,REF,ITEST,MON,VANGLE,FILE_O
     *           ,natommax,natom,latom_charge,latom_nhydr
     *          ,latom_weight,latom_name,latom_chiral
     *           ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *           ,COOR,LCOOR,SRCH,NODIST,IERR)
            GO TO 100
         ENDIF  
         CALL CHECK_ONE_MON(MDOC,LIST,REF,ITEST,MON,VANGLE,FILE_O
     *        ,natommax,natom,latom_charge,latom_nhydr
     *        ,latom_weight,latom_name,latom_chiral
     *        ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *        ,COOR,LCOOR,SRCH,NODIST,IERR)
         IF(IERR.NE.0) GO TO 100
         IF(MON(1:1).EQ.'*') GO TO 100  
         GO TO 100
      ELSE
C
C     read libraries only.
C     set LML_FUSE(I) = 'Y'
C     ----
         CH1   = 'R'
         CHAR1 = ' '
         CALL SSET_FUSE(CH1,CHAR1)
C
C       read mon_lib.cif
         CALL MSGDOC(MDOC,' I am reading library. Please wait.')
         CALL MSGDOC(MDOC,'     - monomer"s description')
         MOD='M'
         CALL READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
         IF(IERR.NE.0) GO TO 100    
         
         IF(IND_FLAG.EQ.'Y') THEN
            CALL CREAT_INDEX(MDOC,IERR)
            IF(IERR.NE.0) GO TO 100    
         ENDIF 
         
         CALL LENSTR_BL(FILE_O,L)
         IF(L.GT.0.AND.FILE_O(1:1).NE.' '.AND.FILE_O(1:1).NE.',') THEN
            LMO_FILE = FILE_O
            LMO_PATH = ' '
            LMO_EXT  = 'lib'
         ELSE
            LMO_FILE = 'libcheck'
            LMO_PATH = ' '
            LMO_EXT  = 'lib'
         ENDIF
         IADD = 0
      ENDIF
C -----------------------------------
C      WRT_LIB - writes library to the file.
C
C     MODE:  TITC - titles only for new
C            TITA - all
C            TITL - 'Y', 'C', except 'N' & '?'
C
 200  CONTINUE
      IF(IADD.EQ.1) THEN 
         nmodes = 6
         modes(1) = 'TITA'
         modes(2) = 'LINA'
         modes(3) = 'MONA'
         modes(4) = 'MODA'
         modes(5) = 'STOP'
         call write_lib_all(mdoc,nmodes,modes,ierr)
      ELSE
        CALL WRT_LIB_MON_NEW_STYLE(MDOC,IERR)
      ENDIF
C ---------------------------
 100  CONTINUE
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(''--end of libcheck ierr:'',i4)') IERR
        CALL MSGDOC(MDOC,LINE)       
      ENDIF
 
      IF(MDOC_C.EQ.1) CALL FINISH
      RETURN
      END     

      SUBROUTINE CHECK_ONE_MON(MDOC,LIST,REF,ITEST,MON,VANGLE,FILE_O
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *                 ,COOR,LCOOR,SRCH,NODIST,IERR)
C -----------------------------------------------------
C
C       one monomer checking
C
C -------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      INTEGER*4 IERR,MDOC
      CHARACTER MON*8,FILE_O*(*)
      integer   natommax,natom
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      integer   ntorsmax
      integer   ntors,ltors_period(ntorsmax)
      integer   ltors_atom(4,ntorsmax)
      real      ltors(2,ntorsmax)
C ---------
      CHARACTER LINE*256,LCOOR*1
      CHARACTER CH1*1,CHAR1*1,MODE*4,LIST*1,REF*1,SRCH*1,NODIST*1,COOR*1
C -----------------------------------------------
      integer nmodes
      character*4 modes(5)
c----------------------------------
      IERR = 0
C
C     set LML_FUSE(I) = 'N'
C ----
      CH1   = 'N'
      CHAR1 = ' '
      CALL SSET_FUSE(CH1,CHAR1)

      CALL LENSTR_BL(FILE_O,L)
      IF(L.GT.0.AND.FILE_O(1:1).NE.' '.AND.FILE_O(1:1).NE.',') THEN
        LMO_FILE = FILE_O
        LMO_PATH = ' '
        LMO_EXT  = 'lib'
      ELSE
        LMO_FILE = 'libcheck'
        LMO_PATH = ' '
        LMO_EXT  = 'lib'
      ENDIF
C ----
      CALL CHECK_MON(MDOC,LIST,REF,ITEST,MON,VANGLE,SRCH,NODIST
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *              ,COOR,LCOOR,IERR)
      IF(IERR.NE.0) GO TO 100
      IF(MON(1:1).EQ.'*') GO TO 100  
C ---    
      nmodes = 5
      modes(1) = 'TITC'
      modes(2) = 'MODC'
      modes(3) = 'LINC'
      modes(4) = 'MONC'
      modes(5) = 'STOP'
      call write_lib_all(mdoc,nmodes,modes,ierr)
 
C ---

 100  CONTINUE
      RETURN
      END

      SUBROUTINE CHECK_PDB_MON(MDOC,LIST,COOR,SRCH
     *               ,REF,ITEST,VANGLE,LCOOR,NODIST
     *               ,FILE_PDB,H_FLAG,MON,PROG_NAME,FILE_O,IERR)
C -----------------------------------------------------
C     read PDB_file.
C     make_PDB.f   
C -----------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      INTEGER*4 IERR,MDOC,ITEST
      REAL      VANGLE
      CHARACTER MON*8
      CHARACTER FILE_O*(*)
      CHARACTER REF*1,LCOOR*1,H_FLAG*1,COOR*1,LIST*1,SRCH*1
      CHARACTER FILE_PDB*(*)
C ---------
      CHARACTER FLAG*1,DNEW*1,NEW_FLAG*1,PEPT_FLAG*1,CHECK*1
      CHARACTER LINE*256
      CHARACTER CH1*1,CHAR1*1,NEW_CHAIN_DESCR*1,MODE*4
      CHARACTER PROG_NAME*(*),NODIST*1,NEW_FLAG_OUT*1,SEG_FLAG*1
      character hflag_remove*1
      INTEGER*4 NOSPGR_INPUT
      character spgr_input*24
      REAL      CELL_INPUT(6)
c
      integer nmodes
      character*4 modes(5)
C -----------------------------------------------
      IERR = 0
C     NOSPGR_INPUT = 0
      NOSPGR_INPUT = 1
      spgr_input = 'P 1'
      DO I=1,6
        CELL_INPUT(I) = 0.0
      ENDDO
C -----------------------------
      CALL INITCRD_LBC(MDOC,H_FLAG,IERR)
      NMNEW = 0
      DNEW  = 'N'
C
C     read PDB_file.
C
      CALL MSGDOC(MDOC,' I am reading PDB_file')
      PEPT_FLAG = 'N'
      SEG_FLAG  = 'N'
      IERR = 1
      if(h_flag.eq.'Y') hflag_remove = 'N'
      if(h_flag.eq.'N') hflag_remove = 'Y'
      if(h_flag.eq.'A') hflag_remove = 'A'
      CALL GET_PDB(MDOC,FILE_PDB    
     *     ,NOSPGR_INPUT,spgr_input,CELL_INPUT,PEPT_FLAG,SEG_FLAG,
     *            hflag_remove,IERR)    
      IF(IERR.GE.7) IERR = 0
      IF(IERR.NE.0) GO TO 100

      CALL LENSTR_BL(FILE_O,L)
      IF(L.GT.0.AND.FILE_O(1:1).NE.' '.AND.FILE_O(1:1).NE.',') THEN
        LMO_FILE = FILE_O
        LMO_PATH = ' '
        LMO_EXT  = 'lib'
      ELSE
        LMO_FILE = 'libcheck'
        LMO_PATH = ' '
        LMO_EXT  = 'lib'
      ENDIF

C  ---
C       PRE_DESCR - create/correct res_name, res_type 
C                                (use list of modifications)   
C                 create new description of monomer which can not be found
C                                in mon_lib.cif ( type of new monomers is  
C                                                            non-polymer )
C ----
C     output:
C             NMNEW    - number of new monomers
C             KERR = 2 - number of monomer in the library = 0
C             KERR = 0 and IERR = 0 - OK
C ----
C     make_new.f
      KERR  = 0
      FLAG  = 'P'
      CHECK = 'Y'

      IF(SRCH.NE.'0') THEN
        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MDOC,' --- pre_descr ---')
        ENDIF      
        CALL PRE_DESCR(MDOC,LIST,CHECK,COOR,SRCH
     *   ,PROG_NAME,NMNEW,NEW_FLAG_OUT,LIB2,KERR,IERR)
      ELSE
        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MDOC,' --- pre_descr lib ---')
        ENDIF      
        CALL PRE_DESCR_LIB(MDOC,LIST,CHECK,COOR,SRCH
     *             ,ITEST,LCOOR,REF,PROG_NAME,NMNEW,KERR,IERR)
      ENDIF  
      IF(KERR.NE.0) GO TO 100
      IF(IERR.NE.0) GO TO 100
C ---
C ---
      IF(NMNEW.GT.0) THEN
         nmodes = 5
         modes(1) = 'TITC'
         modes(2) = 'MONC'
         modes(3) = 'MODC'
         modes(4) = 'LINC'
         modes(5) = 'STOP'
         call write_lib_all(mdoc,nmodes,modes,ierr)
      ENDIF
C ---

 100  CONTINUE
      RETURN
      END

      SUBROUTINE PRE_DESCR_LIB(MMDOC,LIST,CHECK,COOR,SRCH
     *                   ,ITEST,LCOOR,REF,NAME,NMNEW,KERR,IERR)
C ----------------------------------------------------------
C -I-
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER NAME*(*)
C ----------------------------------------------------------------
      CHARACTER LINE*256
      CHARACTER CH12*12,NEW_FLAG*1,MOD_FLG*1,LIST*1,RES*5,CHAIN*4
      CHARACTER MON*8,AMON*8,MOD*8,TYPE*16,CORR_MON*8,CORR_TYPE*16
      CHARACTER CTYPE*4,MODE*4,ASYMB*4,ALT_NAME*4,MON_NEW*8,COOR*1
      CHARACTER MODT*8,MON_OLD*8,MTYPE*1,CHECK*1,DNEW*1,ELEMENT*4
      CHARACTER CH8*8,SRCH*1,EL_D*4,EL_F*4,ASYMB_INP*4,ALT_FOR_COPY*1
      CHARACTER LCOOR*1,REF*1,PRSNT*1,MON_INPUT*8
C==================================================================
      IERR = 0

      MDOC = MMDOC
      MD   = -ABS(MDOC)-1
      M    = 99

      IF(LIST.EQ.'S') THEN
        MDOC = 999
        MD   = 999
      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' --- PRE_DESCR_LIB --- ')
        CALL PRINT_INFO_TEST(MDoc)
      ENDIF
C --------
      IF(N_ATOM.LE.0.OR.N_GROUP.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: number of atoms = 0...')
        IERR=1
        RETURN
      ENDIF 
C---------
      JERR      = 0
      KERR      = 0
      NMUSE     = 0
      NMNEW     = 0
      DNEW      = 'N'
      NEW_FLAG  = 'N'
      TYPE      = '?'
      AMON      = '   '
      MOD       = ' '
      MON_INPUT = ' '
C ----
      CALL SET_LINK_CORR
C ----
      DO IG=1,N_GROUP   

        IRS     = IRES_FIRST(IG)
        NRES    = NRES_CHAIN(IG)
        IRF     = IRS + NRES - 1
C ===
        ITS      = ITERM_S_TYPE(IG)
        ITF      = ITERM_F_TYPE(IG)
        IRS_TREE = IRES_START_TREE(IG)
        IRF_TREE = IRES_END_TREE  (IG)
c ===
        DO IR=IRS,IRF

          IRES  = IRES_SERIAL(IR)
          NATMR = NATM_RES   (IR)
          IAS   = IRATM_FIRST(IR)
          IAF   = IAS + NATMR - 1
          CH12  = RES_NUM_PDB(IR)
          RES   = CH12(3:7)
          CHAIN = CH12(8:11)

          CR_RNAME  = RES_NAME(IR)
          MON       = CR_RNAME
          L1L_PRSNT = 'M'
          C1_NATOM  = 0
          C1_PNUM   = ' ' 
          L1L_MNAME = MON 
          L1L_MNAME2= MON
          L1L_NAME  = '.'
          L1L_CODE1 = 'x'

c         L1L_TYPE  = 'non-polymer'
          CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE,IERR)
          IF(ITYPE.LE.1) ITYPE = 2
          L1L_TYPE  =  RES_TYPE(ITYPE) 
          L1L_MODE  = '.'
          L1L_FORM  = '.'
          L1L_FUSE  = '?'
          L1L_PRSNT = 'N'
          L1L_HFLAG = '.'
          L1L_NATM  = 0
          L1L_NHATM = 0
          L1A_NATOM = 0
          L1A_NHATOM= 0
          L1N_NCONN = 0
          L1B_NBOND = 0
          L1G_NANGL = 0
          L1T_NTORS = 0
          L1C_NCHIR = 0
          L1P_NPLAN = 0
          AMON      = '.'
          MOD       = '.'
          TYPE      = L1L_TYPE

C     check unique atom names
          NA =IAF-IAS+1
          IF(NA.GT.1) THEN
            DO IA=IAS,IAF-1
            DO JA=IA+1,IAF
              IF((ATM_NAME(IA).EQ.ATM_NAME(JA)).AND.
     *           (ID_ALT(IA)  .EQ.ID_ALT(JA)  )     ) THEN 
                LINE = ' ERROR : '//MON//
     *          ' : duplicated atom_name : "'//ATM_NAME(IA)//'".'
                CALL MSGERR(MDOC,LINE)
                IERR = 1
              ENDIF           
            ENDDO
            ENDDO
            IF(IERR.NE.0) RETURN
          ENDIF

          CALL GET_ALT_FOR_COPY(MDOC,IAS,IAF,ALT_FOR_COPY,IERR)

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) 'GET_ALT_FOR_COPY:',ALT_FOR_COPY,';'
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          DO IA=IAS,IAF

            INSF      = ID_SF    (IA)  
            ASYMB     = CS_ATYPE (INSF)      
            ASYMB_INP = ASYMB
            CALL SET_CTYPE(ASYMB,CTYPE)
            CR_ANAME = ATM_NAME (IA)
            CR_ANAME_INP = ATM_NAME_INP(IA)
            ST_CHEM  = ATM_CHEM(IA)
            CR_ATYPE = CTYPE(1:1)
            CR_ALT   = ID_ALT   (IA) 
            CR_SEG   = SEG_ID   (IA) 
            CR_CORR  = ID_CORR  (IA) 

            IF(ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN 
              CR_XYZ(1)= XYZ_CRD  (1,IA)
              CR_XYZ(2)= XYZ_CRD  (2,IA)
              CR_XYZ(3)= XYZ_CRD  (3,IA)
              CR_ANAME = ATM_NAME (IA)
              CR_ASYMB = ASYMB
              CR_SF_ID = INSF
              CR_OCC   = OCCUP    (IA)
              CALL LPUT_NEW(MDOC,LIST,ALT_FOR_COPY,ITYPE,IERR)
              IF(IERR.NE.0) RETURN
            ENDIF
          ENDDO

          L1L_PRSNT = 'N'
          PRSNT = 'N'
          MODE = 'COOR'
          IF(COOR.EQ.'Y') MODE = 'TEST'
          VANGLE       = 0.0
          IF(LIST.EQ.'T') THEN
            LINE = '-- create new --'
            CALL MSGERR(MDOC,LINE)
          ENDIF
          ITER = 0
          IF(ITYPE.EQ.3) THEN
            MOD = 'AA-STAND'
            CALL MODIF(MDOC,MOD,IERR)
            IERR = 0
            ITER = 2
          ENDIF
          IF(ITYPE.EQ.5) THEN
             MOD = 'NA-STAND'
            CALL MODIF(MDOC,MOD,IERR)
            IERR = 0
            ITER = 4
          ENDIF
          IF(ITER.GT.0) THEN
            MOD = TERM_S_TYPE(ITER)
            CALL MODIF(MDOC,MOD,IERR)
            IERR=0
            MOD = TERM_F_TYPE(ITER)
            CALL MODIF(MDOC,MOD,IERR)
            IERR=0
          ENDIF
          CALL CREAT_NEW(MDOC,LIST,MODE,C1_PNUM,NAME,VANGLE,IERR)
          IF(IERR.NE.0) RETURN
          L1L_FUSE = 'C'
          CALL CPL_MLIB(MDOC,IERR)
          IF(IERR.NE.0) RETURN
          NMNEW   = NMNEW + 1

          CALL CREATE_NEW_COORDINATE(MDOC,LIST,MON,PRSNT,REF
     *                         ,MON_INPUT,NAME,ITEST,LCOOR,IERR)
          IF(IERR.NE.0) RETURN

        ENDDO

      ENDDO

      IF(NMNEW.GT.0) THEN
        WRITE(LINE,'(A,I6)')
     *  ' number of new kinds of monomers            :', NMNEW
        CALL MSGDOC(MD,LINE)
      ENDIF


      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' --- END PRE_DESCR --- ')
        CALL PRINT_INFO_TEST(MDOC)
      ENDIF


      RETURN
      END

      SUBROUTINE CHECK_CIF_MON(MDOC,LIST,COOR,SRCH
     * ,REF,ITEST,VANGLE,LCOOR,NODIST
     * ,FILE_CIF,H_FLAG,PROG_NAME,FILE_O,IERR)
C ----------------------------------------------
C
C     read CIFile.
C
C ----------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      INTEGER*4 IERR,MDOC
      CHARACTER H_FLAG*1,FILE_CIF*(*),LIST*1,FILE_O*(*),COOR*1
      CHARACTER REF*1,LCOOR*1,NODIST*1
C ---------
      CHARACTER FLAG*1,DNEW*1,NEW_FLAG*1,MON*8,CHECK*1
      CHARACTER LINE*256,EXT*80,PATH*80
      CHARACTER NEW_CHAIN_DESCR*1,MODE*4,SRCH*1,NEW_FLAG_OUT*1
      CHARACTER PROG_NAME*(*)
      INTEGER*4 NOSPGR_INPUT
      character spgr_input*24
      REAL      CELL_INPUT(6)
c
      integer nmodes
      character*4 modes(5)
C ---
      INCLUDE 'libcheck_version.fh'
C -----------------------------------------------
      IERR = 0
C     NOSPGR_INPUT = 0
      NOSPGR_INPUT = 1
      spgr_input = 'P 1'
      DO I=1,6
        CELL_INPUT(I) = 0.0
      ENDDO

      CALL INITCRD_LBC(MDOC,H_FLAG,IERR)

      NMNEW = 0
      DNEW  = 'N'

      CALL MSGDOC(MDOC,' I am reading CIFile')
      EXT  = ' '
      PATH = ' '
      IERR = 1
      CALL READ_ATOMS(MDOC,PATH,FILE_CIF,EXT    
     *               ,NOSPGR_INPUT,spgr_input,CELL_INPUT,IERR)
      IF(IERR.GE.7) IERR = 0
      IF(IERR.NE.0) GO TO 100

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' --- pre_descr ---')
      ENDIF      

      CALL LENSTR_BL(FILE_O,L)
      IF(L.GT.0.AND.FILE_O(1:1).NE.' '.AND.FILE_O(1:1).NE.',') THEN
        LMO_FILE = FILE_O
        LMO_PATH = ' '
        LMO_EXT  = 'lib'
      ELSE
        LMO_FILE = 'libcheck'
        LMO_PATH = ' '
        LMO_EXT  = 'lib'
      ENDIF
C  ---
C     creat new description of coordinats
      KERR  = 0
      FLAG  = 'C'
      MON   = ' '
      CHECK = 'Y'
      IF(SRCH.NE.'0') THEN
        CALL PRE_DESCR(MDOC,LIST,CHECK,COOR,SRCH
     *   ,PROG_NAME,NMNEW,NEW_FLAG_OUT,LIB2,KERR,IERR)
      ELSE
        CALL PRE_DESCR_LIB(MDOC,LIST,CHECK,COOR,SRCH
     *             ,ITEST,LCOOR,REF,PROG_NAME,NMNEW,KERR,IERR)
      ENDIF  
      IF(KERR.NE.0) GO TO 100
      IF(IERR.NE.0) GO TO 100
C ---
      IF(NMNEW.GT.0) THEN
         nmodes = 5
         modes(1) = 'TITC'
         modes(2) = 'MONC'
         modes(3) = 'MODC'
         modes(4) = 'LINC'
         modes(5) = 'STOP'
         call write_lib_all(mdoc,nmodes,modes,ierr)
      ENDIF
C ---
 100  CONTINUE
      END

      SUBROUTINE CHECK_CSD_MON(MDOC,LIST,COOR,SRCH
     * ,REF,ITEST,VANGLE,LCOOR,NODIST
     * ,FILE_CSD,H_FLAG,PROG_NAME,FILE_O,IERR)
C -----------------------------------------------------
C
C       read CSD CIFile.
C
C -----------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      INTEGER*4 IERR,MDOC
      CHARACTER FILE_CSD*(*),FILE_O*(*)
      CHARACTER H_FLAG*1,COOR*1,SRCH*1
      CHARACTER REF*1,LCOOR*1,NODIST*1
C ---------
      CHARACTER FLAG*1,LIST*1,CHECK*1
      CHARACTER LINE*256,EXT*80,PATH*80
      CHARACTER MODE*4,MON*8,NEW_FLAG_OUT*1
      CHARACTER PROG_NAME*(*)
      INTEGER*4 NOSPGR_INPUT
      character spgr_input*24
      REAL      CELL_INPUT(6)
c
      integer nmodes
      character*4 modes(5)
C ---
      INCLUDE 'libcheck_version.fh'
C -----------------------------------------------
      IERR = 0
      NOSPGR_INPUT = 0
      spgr_input = ' '
      DO I=1,6
        CELL_INPUT(I) = 0.0
      ENDDO

      CALL INITCRD_LBC(MDOC,H_FLAG,IERR)

      NMNEW = 0
C
      CALL MSGDOC(MDOC,' I am reading CSD CIFile')
      EXT  = ' '
      PATH = ' '
      IERR = 1
      CALL READ_ATOMS(MDOC,PATH,FILE_CSD,EXT    
     *               ,NOSPGR_INPUT,spgr_input,CELL_INPUT,IERR)
      IF(IERR.GE.7) IERR = 0
      IF(IERR.NE.0) GO TO 100


      EXT  = ' '
      PATH = ' '
      LINE = 'new_CSD.crd'
      CALL WRITE_ATOMS(MDOC,PATH,LINE,EXT,IERR)
      CALL MSGDOC(MDOC,' New CIFile is created : new_CSD.crd')
C  ---
      CALL LENSTR_BL(FILE_O,L)
      IF(L.GT.0.AND.FILE_O(1:1).NE.' '.AND.FILE_O(1:1).NE.',') THEN
        LMO_FILE = FILE_O
        LMO_PATH = ' '
        LMO_EXT  = 'lib'
      ELSE
        LMO_FILE = 'libcheck'
        LMO_PATH = ' '
        LMO_EXT  = 'lib'
      ENDIF
C     creat new description of coordinats
      KERR = 0
      FLAG = 'C'
      MON = ' '
      CHECK = ' '
      IF(SRCH.NE.'0') THEN
        CALL PRE_DESCR(MDOC,LIST,CHECK,COOR,SRCH
     *   ,PROG_NAME,NMNEW,NEW_FLAG_OUT,LIB2,KERR,IERR)
      ELSE
        CALL PRE_DESCR_LIB(MDOC,LIST,CHECK,COOR,SRCH
     *             ,ITEST,LCOOR,REF,PROG_NAME,NMNEW,KERR,IERR)
      ENDIF  
      IF(KERR.NE.0) GO TO 100
      IF(IERR.NE.0) GO TO 100
C ---
      IF(NMNEW.GT.0) THEN
         nmodes = 5
         modes(1) = 'TITC'
         modes(2) = 'MONC'
         modes(3) = 'MODC'
         modes(4) = 'LINC'
         modes(5) = 'STOP'
         call write_lib_all(mdoc,nmodes,modes,ierr)
      ENDIF

 100  CONTINUE
      RETURN
      END

      SUBROUTINE CREAT_INDEX(MDOC,IERR)
C -------------------------------------------------------
C -----------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER CTYPE*4,ASYMB*4,MODE*4,MODT*8
      CHARACTER NAMEO*80,PATH*80,EXT*80
      CHARACTER LINE*256,MON*8,CH2*2,FORM*1
C -----------------------------------
      IERR = 0
      M    = 99
C ----
      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomers in library = 0')
        IERR=1
        RETURN
      ENDIF

      NAMEO = 'libcheck_ind'
      PATH  = ' '
      EXT   = 'cif'
      IUN   = CRO_IUN
      CALL OPENFW(IUN,M,PATH,NAMEO,EXT,IERR)
      CRO_IUN = IUN
      IF(IERR.NE.0) THEN
        IERR=1  
        CALL MSGERR(MDOC,' ERROR: OPEN OUTPUT_FILE_IND ')
        RETURN
      ENDIF

      DO   L=1,LML_NMON

        LB_PASS   =  LML_PASS (L)

        C_INDEX   = '.'
        C_CONTENT = '.'
        C_PAIR    = '.'

        MON = LML_MNAME(L)

        IF(LML_FUSE(L).EQ.'N'.OR.LML_FUSE(L).EQ.'R') GO TO 100

        CALL CP_MLIB(MDOC,MON,IERR)
 
        IF(IERR.NE.0) THEN
          LINE = ' ERROR : copy monomer '//MON//' from dictionary'
          CALL MSGERR(MDOC,LINE)
          IERR = 0
          GO TO 100
        ENDIF

        IF(L1A_NATOM.LE.0) THEN
          WRITE(LINE,
     *'('' ERROR : number of atoms in monomer (lib) '',A,'' = '',I6)')
     *    L1L_MNAME,L1A_NATOM
          CALL MSGERR(MDOC,LINE)         
          GO TO 100
        ENDIF

        CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE,IERR)
        IF(IERR.NE.0) RETURN

        ITER = 0
        IF(ITYPE.EQ.3) THEN
          MODT = 'AA-STAND'
          CALL MODIF(MDOC,MODT,IERR)
          IERR = 0
          ITER = 2
        ENDIF
        IF(ITYPE.EQ.5) THEN
          MODT = 'NA-STAND'
          CALL MODIF(MDOC,MODT,IERR)
          IERR = 0
          ITER = 4
        ENDIF

        L1A_NHATOM = 0
        DO I=1,L1A_NATOM
          L1A_INEW (I) = I 
          L1A_IOLD (I) = I
          L1A_ICHEM(I) = 0              
          L1A_ICR  (I) = 0
          L1A_NDIST(I) = 0
          L1A_IBACK(I) = 0
          L1A_IFORW(I) = 0
          L1A_BACK (I) = '.'
          L1A_TYPE (I) = '.' 
          L1A_FORW (I) = '.'
          L1A_COOR_FLAG(I) = 'N' 
C         L1A_CHEM (I) = L1A_SYMB(I) 
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,I) = 0
            L1A_LENCON (J,I) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_TEXTR (J,I) = 0
            L1A_IEXTR (J,I) = 0
          ENDDO
          ASYMB = L1A_SYMB(I)
          IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *       ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *       ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
            CTYPE='C   '
          ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
            CTYPE='H   '
            L1A_NHATOM   = L1A_NHATOM + 1
          ELSE
            CTYPE='$   '
          ENDIF
          L1A_ATYPE(I)=CTYPE(1:1)
        ENDDO

        MODE=' '

        CALL LIB_CONN(MDOC,MODE,IERR)
        IF(IERR.NE.0) THEN
          LINE = ' ERROR : monomer '//MON//' in subroutine LIB_CONN'
          CALL MSGERR(MDOC,LINE)
          IERR = 0
          GO TO 100
        ENDIF

C        IF(MON.EQ.'ALA') THEN
C        DO I=1,L1A_NATOM
C          N = L1A_NDIST(I)
C         WRITE(*,'(I3,A4,10I4)') 
C     *   I,L1A_ANAME(I),N,(L1A_CONN(J,I),J=1,N)
C        ENDDO
C        ENDIF

        CALL CALC_INDEX(MDOC,MON,N,C_CONTENT,C_INDEX,C_PAIR,IERR)
 
 100    CONTINUE

C        write(*,'(4I4,'';'',A3,'';'',A24,'';'',A24,'';'')')
C     *  L,LB_PASS,L1A_NHATOM,N,MON,C_CONTENT,C_INDEX

C        ICH2 = LB_PASS -5
        WRITE(CH2,'(I2)') ITYPE
C        IF(LB_PASS.EQ.1) CH2 = 'co'
C        IF(LB_PASS.EQ.2) CH2 = 'pr'
C        IF(LB_PASS.EQ.3) CH2 = 'na'
C        IF(LB_PASS.EQ.4) CH2 = 'su'
C        IF(LB_PASS.EQ.5) CH2 = 'me'

        WRITE(LINE,'(I4,1X,A2,1X,A8,1X,I4,1X,A30,1X,A24)')
     *               L,CH2,MON,N,C_CONTENT,C_INDEX
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN
        WRITE(LINE,'(17X,A24)')
     *               C_PAIR
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN
        
      ENDDO

      END FILE IUN
      CLOSE(IUN,ERR=200)
 200  CONTINUE

C --------------------------------------
C       write(*,*) '----create index2'   

      MEMORY = 0
      NMON   = 0

      DO   L=1,LML_NMON
        IF(LML_FUSE(L).EQ.'N'.OR.LML_FUSE(L).EQ.'R') GO TO 300
 
        MON = LML_MNAME(L)

        CALL CP_MLIB(MDOC,MON,IERR)
        IF(IERR.NE.0) THEN
          LINE = ' ERROR : copy monomer '//MON//' from dictionary'
          CALL MSGERR(MDOC,LINE)
          IERR = 0
          GO TO 300
        ENDIF

        IF(L1A_NATOM.LE.0) THEN
          WRITE(LINE,
     *'('' ERROR : number of atoms in monomer (lib) '',A,'' = '',I6)')
     *    L1L_MNAME,L1A_NATOM
          CALL MSGERR(MDOC,LINE)         
          GO TO 300
        ENDIF

        CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE,IERR)
        IF(IERR.NE.0) RETURN

        ITER = 0
        IF(ITYPE.EQ.3) THEN
          MODT = 'AA-STAND'
          CALL MODIF(MDOC,MODT,IERR)
          IERR = 0
          ITER = 2
        ENDIF
        IF(ITYPE.EQ.5) THEN
          MODT = 'NA-STAND'
          CALL MODIF(MDOC,MODT,IERR)
          IERR = 0
          ITER = 4
        ENDIF

        L1A_NHATOM = 0
        DO I=1,L1A_NATOM
          L1A_INEW (I) = I 
          L1A_IOLD (I) = I
          L1A_ICHEM(I) = 0              
          L1A_ICR  (I) = 0
          L1A_NDIST(I) = 0
          L1A_IBACK(I) = 0
          L1A_IFORW(I) = 0
          L1A_BACK (I) = '.'
          L1A_TYPE (I) = '.' 
          L1A_FORW (I) = '.'
          L1A_COOR_FLAG(I) = 'N' 
C         L1A_CHEM (I) = L1A_SYMB(I) 
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,I) = 0
            L1A_LENCON (J,I) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_TEXTR (J,I) = 0
            L1A_IEXTR (J,I) = 0
          ENDDO
          ASYMB = L1A_SYMB(I)
          IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *       ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *       ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
            CTYPE='C   '
          ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
            CTYPE='H   '
            L1A_NHATOM   = L1A_NHATOM + 1
          ELSE
            CTYPE='$   '
          ENDIF
          L1A_ATYPE(I)=CTYPE(1:1)
        ENDDO

        CALL LIB_CREATE_INDEX2(MDOC,L,NMON,MEMORY,IERR)
        IF(IERR.NE.0) THEN 
          IERR = 0
          GO TO 410
        ENDIF
 300    CONTINUE
      ENDDO

 410  CONTINUE

      WRITE(LINE,
     *'('' INFO  : INDEX2: N_monomers, memory (int2) :'',I6,I10)')
     *    NMON,MEMORY
      CALL MSGDOC(MDOC,LINE)         
C ------
      IF(NMON.GT.0) THEN
        NAMEO = 'libcheck_ind2'
        PATH  = ' '
        EXT   = 'cif'
        IUN   = CRO_IUN

        FORM = 'F'

c        IF(FORM.EQ.'U') THEN
c          EXT   = 'dat'
c          CALL OPENUW(IUN,M,PATH,NAMEO,EXT,IERR)
c        ELSE
        CALL OPENFW(IUN,M,PATH,NAMEO,EXT,IERR)
c        ENDIF
        CRO_IUN = IUN
        IF(IERR.NE.0) THEN
          IERR=1  
          CALL MSGERR(MDOC,' ERROR: OPEN OUTPUT_FILE_IND2 ')
          RETURN
        ENDIF
        CALL LIB_WRITE_INDEX2(MDOC,IUN,FORM,MEMORY,IERR)
        END FILE IUN
        CLOSE(IUN,ERR=400)
 400    CONTINUE
      ENDIF
      CALL MSGDOC(MDOC,'  --- end create index2 ----')         
C ------
C       write(*,*) '----read index2'
C        NAMEO = 'libcheck_ind2'
C        PATH  = ' '
C        EXT   = 'cif'
C        IUN   = CRO_IUN
C        IF(FORM.EQ.'U') THEN
C          EXT   = 'dat'
C          CALL OPENUR(IUN,M,PATH,NAMEO,EXT,IERR)
C        ELSE
C          CALL OPENFR(IUN,M,PATH,NAMEO,EXT,IERR)
C        ENDIF
C        CRO_IUN = IUN
C        IF(IERR.NE.0) THEN
C          IERR=1  
C          CALL MSGERR(MDOC,' ERROR: OPEN INPUT_FILE_IND2 ')
C          RETURN
C        ENDIF
C        CALL LIB_READ_INDEX2(MDOC,IUN,FORM,IERR)
C        CLOSE(IUN)
C        WRITE(*,*) ' -------- end --'
C ------
      RETURN
      END


      SUBROUTINE SETPARM_LBC(MDOC,LIB_PATH,IERR)
C -------------------------------------------------------
C -P- SETPARM_LBC - 
C -S-
C -------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LINE*256,LIB_PATH*(*)
C -----------------------------------
      MD   = -ABS(MDOC)-1
      M    = 99
      IERR = 0
C ---
C     initialization names of files
      CRI_PATH = ' '
      CRI_EXT  = 'pdb'
      CRO_PATH = ' '
      CRO_EXT  = 'crd'
      CRS_PATH = ' '
      CRS_EXT  = 'str'
      CRR_PATH = ' '
      CRR_EXT  = 'rst'
c      CRI_IUN  = 0
c      CRO_IUN  = 0
c      CRS_IUN  = 0
c      CRR_IUN  = 0
C -----------------------------------
C      CALL GET_PATH(M,'MAKECIF',LINE,IERR)
C      IF(IERR.NE.0) RETURN
C
C      CALL LENSTR_BL(LINE,LEN)
C      IF(LEN.GT.0) THEN
C       LIB_PATH = LINE(1:LEN)//'/dic/'
C      ELSE
C        LIB_PATH = ' '
C      ENDIF
C -----------------------------------
      RETURN
      END     


C ******
      SUBROUTINE INITCRD_LBC(MDOC,H_FLAG,IERR)
C -------------------------------------------------------
C -P- INITCRD - initialization of common blocks /CRDINF/ /CRDATM/ /CRDMLN/
C -S-
C -------------------------------------------------------
      INCLUDE 'crd_com.fh'
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER H_FLAG*1
C ******
C -----------------------------------
      PI=4.0*ATAN(1.0)
C ---
      CR_CELL(1)    = 1.0
      CR_CELL(2)    = 1.0
      CR_CELL(3)    = 1.0
      CR_CELL(4)    = PI/2.0
      CR_CELL(5)    = PI/2.0
      CR_CELL(6)    = PI/2.0
      CR_SCALE(1,1) = 1.0
      CR_SCALE(1,2) = 0.0
      CR_SCALE(1,3) = 0.0
      CR_SCALE(2,1) = 0.0
      CR_SCALE(2,2) = 1.0
      CR_SCALE(2,3) = 0.0
      CR_SCALE(3,1) = 0.0
      CR_SCALE(3,2) = 0.0
      CR_SCALE(3,3) = 1.0
      CR_U(1)       = 0.0
      CR_U(2)       = 0.0
      CR_U(3)       = 0.0
      CR_ORT_TO_FRAC(1,1)=1.0
      CR_ORT_TO_FRAC(1,2)=0.0
      CR_ORT_TO_FRAC(1,3)=0.0
      CR_ORT_TO_FRAC(2,1)=0.0
      CR_ORT_TO_FRAC(2,2)=1.0
      CR_ORT_TO_FRAC(2,3)=0.0
      CR_ORT_TO_FRAC(3,1)=0.0
      CR_ORT_TO_FRAC(3,2)=0.0
      CR_ORT_TO_FRAC(3,3)=1.0
      CR_NAME_PDB = '----'
      CR_DATE_PDB = 'XX-XXX-XX'
      CR_CD_PDB   = 'xxxx'
      CR_TITLE    = '---'
      CR_RFAC_PDB = '.'
      CR_RESL_PDB = '.'
      CR_MODEL    = 0
      CR_NSPGR    = 1
      CR_SETT     = 1
      CR_SPGR     = 'P 1'
      CR_PDB_REC  = ' '
      CR_NSYM     = 1
      CR_NCS      = 0
      CR_SYMOP    = 'X,Y,Z'
      CR_IA       = 0
      CR_IRES     = 0
      CR_IGRES    = 0
      CR_ICH      = 0
      CR_IGROUP   = 0
      CR_B_FLAG   = 0
      CR_MULT_FLAG= 0
      CR_SF_ID    = 0
      CR_MULT_FACTOR= 1
      CR_RTYPE    = ' '
      CR_ATYPE    = ' '
      CR_TERM     = ' '
      CR_RNAME    = ' '
      CR_ANAME    = ' '
      CR_ANAME_INP= ' '
      ST_CHEM     = ' '
      CR_CHAIN    = '  '
      CR_GROUP    = '    '
      RS_NATOM    = 0 
      RS_NBOND    = 0 
      RS_NANGL    = 0 
      RS_NTORS    = 0 
      RS_NCHIR    = 0 
      RS_NPLAN    = 0 
      RS_NVDW     = 0 
      RS_NHB      = 0 
C --------------------
      CR_TEMPER     = 0.0
      CR_WAVEL      = 0.0
      CR_RES_MIN    = 0.0
      CR_RES_MAX    = 0.0
      CR_RFAC_ALL   = 0.0
      CR_RFAC_OBS   = 0.0
      CR_SIGMA_I    = 0.0
      CR_SIGMA_F    = 0.0
      CR_CD_NDB     = '?'
      CR_CD_CSD     = '?'
      CR_DATE_NDB   = '?'
      CR_DATE_CREAT = '?'
      CR_PROGRAM    = '?'
      CR_METHOD     = '?'
C ---
      CRI_FILE  = ' '
      CRI_PATH  = ' '
      CRI_EXT   = ' '
c     CRO_FILE  = ' '
      CRO_PATH  = ' '
      CRO_EXT   = ' '
      CRRO_FILE = ' '
      CRRO_PATH = ' '
      CRRO_EXT  = ' '
      CRSO_FILE = ' '
      CRSO_PATH = ' '
      CRSO_EXT  = ' '
      CRS_FILE  = ' '
      CRS_PATH  = ' '
      CRS_EXT   = ' '
      CRR_FILE  = ' '
      CRR_PATH  = ' '
      CRR_EXT   = ' '

C      CRI_IUN   = 0
C      CRO_IUN   = 0
C      CRS_IUN   = 0
C      CRR_IUN   = 0
C      CRSO_IUN  = 0
C      CRRO_IUN  = 0

      CR_HFLAG  = H_FLAG

      RETURN
      END     

      SUBROUTINE CHECK_MON(MDOC,LIST,REF,ITEST,MON,VANGLE,SRCH
     *                    ,NODIST
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *                    ,COOR,LCOOR,IERR)
C -----------------------------------------
C -P- CHKMON - looks for monomer's name in the library list
C              , set use_flag = "Y".
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,SRCH*1,NODIST*1,COOR*1,LCOOR*1
C -----------------------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C -----------------------------------------------
C ---
      INCLUDE 'atom_com.fh'
      INCLUDE 'lib_com.fh'
C ---
      integer   natommax,natom
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      integer   ntorsmax
      integer   ntors,ltors_period(ntorsmax)
      integer   ltors_atom(4,ntorsmax)
      real      ltors(2,ntorsmax)

      CHARACTER LINE*256
      CHARACTER MODE*4,NAME*80,MOD*1,PRSNT*1,PNUM*12,LIST*1
      CHARACTER REF*1,DUMMY_FLAG*1,ASYMB*4,CTYPE*4,MODT*8
      CHARACTER AMON*8,MON_INPUT*8
C --------------------------------
      NAME      = ' '
      MON_INPUT = MON
      IF(MON(1:1).EQ.'*') THEN
        CALL WRITE_LIST_MON(MDOC,IERR)
        RETURN
      ENDIF
C ---
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '---check_mon:',mon,';',ref,itest,srch
        CALL MSGDOC(MDOC,line)
      ENDIF

      NUMB_P = 0
      IERR   = 0
      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC
     *   ,' ERROR: number of monomers in the library = 0')
        IERR = 1
        RETURN
      ENDIF

C --
      AMON = MON
      CALL LOOK_MON_LIB_LIBCHECK(MDOC,AMON,L,IERR)
      IF(IERR.NE.0) THEN
C       monomer is not found.
        WRITE(LINE,
     *  '('' WARNING : monomer:'',A,'' - not found in the library .'')')
     *  MON
        CALL MSGERR(MDOC,LINE)
        RETURN
      ENDIF
C =========
      IF(LML_FUSE(L).EQ.'N') THEN
C       read mon_lib.cif
        LML_FUSE(L) = 'R'
        CALL MSGDOC(MDOC,' I am reading library. Please wait.')
        CALL MSGDOC(MDOC,'     - monomer"s description')
        MOD='M'
        CALL READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
C =========

      CALL CP_MLIB(MDOC,MON,IERR)

      IF(IERR.NE.0) RETURN

      CALL GET_INI_RES_TYPE(MDOC,LINE,MON,IT,IERR)
      IF(IERR.NE.0) RETURN

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '---type:',it
        CALL MSGDOC(MDOC,line)
      ENDIF

      ITER = 0
      IF(IT.EQ.3) THEN
        MODT = 'AA-STAND'
        CALL MODIF(MDOC,MODT,IERR)
        IERR = 0
        ITER = 2
      ENDIF
      IF(IT.EQ.5) THEN
        MODT = 'NA-STAND'
        CALL MODIF(MDOC,MODT,IERR)
        IERR = 0
        ITER = 4
      ENDIF
      IF(ITER.GT.0) THEN
        MODT = TERM_S_TYPE(ITER)
        CALL MODIF(MDOC,MODT,IERR)
        IERR=0
        MODT = TERM_F_TYPE(ITER)
        CALL MODIF(MDOC,MODT,IERR)
        IERR=0
      ENDIF

      CALL PRECHECK_L1_MON_DESCRIPTION(MDOC,LIST,IERR)

C     ierr 10  - add 'dummy' bonds    
C     ierr 100 - remove some bonds
C     ierr 1   - 
      IERR = 0
C     IF(IERR.NE.0) RETURN

      PRSNT = 'N'
      L1L_MNAME = MON

C     write(*,*) l,L1L_MNAME,LML_MNAME(L),LML_PRSNT(L)
C     write(*,*) MON,AMON

      IF(LML_PRSNT(L).EQ.'M') THEN
        PRSNT = 'M'
C
C       monomer is with minimal description.
C
        WRITE(LINE,
     *  '('' WARNING : monomer:'',A
     *  ,'' - has the minimal description.'')')
     *  MON
        CALL MSGERR(MDOC,LINE)

        CALL CP_MLIB(MDOC,MON,IERR)
        IF(IERR.NE.0) RETURN

        CALL GET_INI_RES_TYPE(MDOC,LINE,MON,IT,IERR)
        IF(IERR.NE.0) RETURN

        IF(LIST.EQ.'T') THEN
          WRITE(LINE,*) '---type2:',it
          CALL MSGDOC(MDOC,line)
        ENDIF

        ITER = 0
        IF(IT.EQ.3) THEN
          MODT = 'AA-STAND'
          CALL MODIF(MDOC,MODT,IERR)
          IERR = 0
          ITER = 2
        ENDIF
        IF(IT.EQ.5) THEN
          MODT = 'NA-STAND'
          CALL MODIF(MDOC,MODT,IERR)
          IERR = 0
          ITER = 4
        ENDIF
        IF(ITER.GT.0) THEN
          MODT = TERM_S_TYPE(ITER)
          CALL MODIF(MDOC,MODT,IERR)
          IERR=0
          MODT = TERM_F_TYPE(ITER)
          CALL MODIF(MDOC,MODT,IERR)
          IERR=0
        ENDIF

        LB_PASS = LML_PASS (L)

        IF(LB_PASS.GT.1.AND.SRCH.NE.'N'.AND.SRCH.NE.'0') THEN

          IF(L1A_NATOM.LE.0) THEN
            WRITE(LINE,
     *'('' ERROR : number of atoms in monomer (lib) '',A,'' = '',I6)')
     *      L1L_MNAME,L1A_NATOM
            CALL MSGERR(MDOC,LINE)         
            IERR =0
            RETURN
          ENDIF

          L1L_MNAME = MON
          L1A_NHATOM = 0
          DO I=1,L1A_NATOM
            L1A_INEW (I) = I 
            L1A_IOLD (I) = I
            L1A_ICHEM(I) = 0              
            L1A_ICR  (I) = 0
            L1A_NDIST(I) = 0
            L1A_IBACK(I) = 0
            L1A_IFORW(I) = 0
            L1A_BACK (I) = '.'
            L1A_TYPE (I) = '.' 
            L1A_FORW (I) = '.'
C           L1A_COOR_FLAG(I) = 'N' 
C           L1A_CHEM (I) = L1A_SYMB(I) 
            DO  J=1,MAX1BRN 
              L1A_CONN   (J,I) = 0
              L1A_LENCON (J,I) = 0
            ENDDO
            DO  J=1,MAX1EXT 
              L1A_TEXTR (J,I) = 0
              L1A_IEXTR (J,I) = 0
            ENDDO
            ASYMB = L1A_SYMB(I)
            IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *         ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *         ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
              CTYPE='C   '
            ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
              CTYPE='H   '
              L1A_NHATOM   = L1A_NHATOM + 1
            ELSE
              CTYPE='$   '
            ENDIF
            L1A_ATYPE(I)=CTYPE(1:1)
          ENDDO

          MODE=' '

          CALL LIB_CONN(MDOC,MODE,IERR)
          IF(IERR.NE.0) THEN
            LINE = ' ERROR : monomer '//MON//' in subroutine LIB_CONN'
            CALL MSGERR(MDOC,LINE)
            IERR = 1
            RETURN
          ENDIF

          IMON = L
          CALL LIB_CREATE_TEST_INDEX2(MDOC,IMON
     *            ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
          IF(IERR.NE.0) THEN
            LINE = ' ERROR : monomer '//MON//
     *      ' in subroutine LIB_CREATE_TEST_INDEX2'
            CALL MSGERR(MDOC,LINE)
            IERR = 1
            RETURN
          ENDIF


          IF(LIST.EQ.'T') THEN
          WRITE(LINE,'(I4,1X,2X,1X,A8,1X,I4,1X,A30,1X,A24)')
     *               L,MON,NAC,C_CONTENT,C_INDEX
          CALL MSGDOC(MDOC,LINE)
          WRITE(LINE,'(17X,A24)') C_PAIR
          CALL MSGDOC(MDOC,LINE)

          CALL MSGDOC(MDOC,'--- test_gm ---')
          ENDIF

          CALL TEST_GM(MDOC,LIST,SRCH
     *              ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)

          IF(IERR.NE.0) THEN
            IERR = 0 
            CALL CP_MLIB(MDOC,MON,IERR)
          ELSE
            PRSNT = 'N'
            IF(L1L_PRSNT.EQ.'M') PRSNT = 'M'
            IF(PRSNT.NE.'M')GO TO 200
          ENDIF
 
        ENDIF

        L1A_NHATOM = 0
        ICOOR = 0
        COOR_SUM = 0.0
        DO I=1,L1A_NATOM
          L1A_INEW (I) = I 
          L1A_IOLD (I) = I
          L1A_ICHEM(I) = 0              
          L1A_ICR  (I) = 0
          L1A_NDIST(I) = 0
          L1A_IBACK(I) = 0
          L1A_IFORW(I) = 0
          L1A_BACK (I) = '.'
          L1A_TYPE (I) = '.' 
          L1A_FORW (I) = '.'

          IF(L1A_COOR_FLAG(I).EQ.'N'.OR.L1A_COOR_FLAG(I).EQ.'.') THEN
            ICOOR=2 
          ELSE
            COOR_SUM = COOR_SUM + 
     *                 ABS(L1A_X(I)) + ABS(L1A_Y(I)) + ABS(L1A_Z(I)) 
          ENDIF

C         L1A_CHEM (I) = L1A_SYMB(I) 
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,I) = 0
            L1A_LENCON (J,I) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_TEXTR (J,I) = 0
            L1A_IEXTR (J,I) = 0
          ENDDO
          ASYMB = L1A_SYMB(I)
          IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *       ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *       ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
            CTYPE='C   '
          ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
            CTYPE='H   '
            L1A_NHATOM   = L1A_NHATOM + 1
          ELSE
            CTYPE='$   '
          ENDIF
          L1A_ATYPE(I)=CTYPE(1:1)
        ENDDO

        IF(COOR_SUM.LT.0.001) ICOOR = 1
        IF(LCOOR.EQ.'N')      ICOOR = 1
        IF(ICOOR.EQ.1) THEN
          DO I=1,L1A_NATOM
            L1A_COOR_FLAG(I) = 'N'
          ENDDO
        ENDIF

        MODE=' '

        CALL LIB_CONN(MDOC,MODE,IERR)
        IF(IERR.NE.0) THEN
          LINE = ' ERROR : monomer '//MON//' in subroutine LIB_CONN'
          CALL MSGERR(MDOC,LINE)
          IERR = 1
          RETURN
        ENDIF

        MODE = 'CONN'
        IF(COOR.EQ.'Y') MODE = 'TEST'
        PNUM = ' '
        NAME = '?'

C        IF(REF.EQ.'0'.AND.ICOOR.EQ.0) NAME = 'libcheck'


        CALL CREAT_NEW(MDOC,LIST,MODE,PNUM,NAME,VANGLE,IERR)

        IF(IERR.NE.0) RETURN

        MON = L1L_MNAME
        WRITE(LINE,
     *  '('' now monomer:'',A
     *  ,'' - has complete description.'')')
     *  MON
        CALL MSGDOC(MDOC,LINE)
        IF(REF.NE.'0'.OR.ICOOR.EQ.1) THEN
          WRITE(LINE,
     *    '('' I will check it.'')')
          CALL MSGDOC(MDOC,LINE)
        ENDIF

c       smile tortions
        IF(NTORS.GT.0) THEN
          CALL SMILE_TORSION_CORRECTION(MDOC
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *       ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *       ,IERR)
          IF(IERR.NE.0) RETURN
        ENDIF

        L1L_FUSE = 'C'

        CALL CPL_MLIB(MDOC,IERR)
        IF(IERR.NE.0) RETURN

      ELSE

        L1L_FUSE = 'C'

        CALL CPL_MLIB(MDOC,IERR)
        IF(IERR.NE.0) RETURN

      ENDIF

 200  CONTINUE

c      IF(REF.NE.'0'.OR.ICOOR.EQ.1) THEN
        CALL CREATE_NEW_COORDINATE(MDOC,LIST,MON,PRSNT,REF
     *                        ,MON_INPUT,NAME,ITEST,LCOOR,IERR)
        IF(IERR.NE.0) RETURN

c      ENDIF

      RETURN
      END     

      SUBROUTINE LOOK_MON_LIB_LIBCHECK(MDOC,MON,LIND,IERR)
C -----------------------------------------
C -P- CHKMON - looks for monomer's name in the library list
C              , set use_flag = "Y".
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER AMON*8,MON2*8
C     CHARACTER LINE*256
C --------------------------------
      IERR = 0
      LIND = 0

      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomer in the library = 0')
        IERR = 2
        RETURN
      ENDIF

      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          LIND = L
          GO TO 100
        ENDIF
      ENDDO

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            MON  = LMS_MNAME(LL)
            DO L=1,LML_NMON
              IF(MON.EQ.LML_MNAME(L)) THEN
                LIND = L
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON) THEN
            AMON = LDR_SMNAME(LL)
            DO L=1,LML_NMON
              IF(AMON.EQ.LML_MNAME(L)) THEN
               MON  = AMON 
               LIND = L
               GO TO 100
              ENDIF
            ENDDO
            MON2 = AMON
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON2) THEN
                AMON = LDR_SMNAME(LLL)
                DO L=1,LML_NMON
                  IF(AMON.EQ.LML_MNAME(L)) THEN
                    MON  = AMON 
                    LIND = L
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

C     monomer is not found.
      IERR=1
      RETURN

  100 CONTINUE

      RETURN
      END     

      SUBROUTINE CHECK_BOND_ORDERS(MDOC,LIST,MON,IERR)
C ---------------------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,PNUM*12,DUMMY_FLAG*1,MOD*1,REF*1
C ---------------------------------------------------------------
      M   = 99
C ----
      IF(LIST.EQ.'T') THEN
        call msgdoc(mdoc,' --- CHECK_BOND_ORDERS ---')
      ENDIF
      IF(L1B_NBOND.LE.0) RETURN
      IT = 0
      DO IB=1,L1B_NBOND
        IF(L1B_TYPE(IB)(1:3).EQ.'cov'.OR.L1B_TYPE(IB)(1:1).EQ.'.')  
     *  IT=1

        IF(LIST.EQ.'T') THEN
         WRITE(*,*) '>>',L1B_I1ATM(IB),L1B_I2ATM(IB),L1B_VOBS(IB),
     *   L1B_TYPE(IB)
        ENDIF

      ENDDO 
      IF(IT.EQ.0) RETURN
C ---
      IF(LIST.EQ.'T') THEN
        call msgdoc(mdoc,' -CHECK_BOND_ORDERS:')
      ENDIF
C     bond_order from coords
      CALL ADD_TYPE_USING_COORD_libcheck(MDOC,LIST,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: in subroutine ADD_TYPE_USING_COORD')
c        RETURN
        IERR = 0
      ENDIF

C     CALL CHECK_OXYGENS_BOND(MDOC,LIST,IERR) 
C ----
      IF(LIST.EQ.'T') THEN
      DO IB=1,L1B_NBOND
       WRITE(*,*) '>>>',L1B_I1ATM(IB),L1B_I2ATM(IB),L1B_VOBS(IB),
     * L1B_TYPE(IB)
      ENDDO 
      ENDIF

      RETURN
      END     
C
      SUBROUTINE ADD_TYPE_USING_COORD_libcheck(MDOC,LIST,IERR)
C --------------------------------------------
      IMPLICIT NONE
      INCLUDE 'lib_com.fh'
C
C--defines bond orders using coordinates
C
C----Alternative way is loop over atoms and their neibours.
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C ------------------------------
C        L1A_NATOM 
C        L1A_COOR_FLAG()  'Y' 
C        L1A_X        () 
C        L1A_Y        () 
C        L1A_Z        ()
C        L1A_CHARG    ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C        L1A_ATYPE    ()  'H' for H and D
C                         'C' for C,N,O,B,F,LI  
C                         'P' for P,S  
C                         '$' other heavy atoms'   
C
C --- connection         
c
C    DO IC=1,L1A_NDIST(IA)  for each  IA - L1A_NDIST number of connected atoms
C    IAC = L1A_CONN(IC,IA)  connection:  IA --> IAC
C
C    number of connections with H-atoms
C    N_HATOM     = L1A_LENCON(1,IA)
C
C    only for H-atom:  
C    ICONN_H defines connection for H-atom
c    ICONN_H  = ABS(L1A_CONN(1,I))
C    i.e H-atom I is connected with atom ICONN_H 
C    ring
CC
c        DO I=1,L1A_NRING(IA)
c          L1A_RING_ID  (I,IA) - ring number
c          L1A_RING_ORD (I,IA) = 4,5,6 
c          L1A_RING_FLAT(I,IA) = 1 flat, 0 not flat
c
C --- chirality
C
C     L1A_ICHIR() : > 0 chir
C     L1A_ICHIR() = 1 user, 2 (ndist>3 or 
C                              ndist>2 ( coords--> volume >  RLIMC(=0.5))
c
C ---
C        L1B_NBOND
C        L1B_1ATM     ()
C        L1B_2ATM     ()
C        L1B_TYPE     () 
C        L1B_VOBS     () 
C
C ---------------------
C
      INTEGER IB,IA1,IA2,IB1,IB2,IEB1,IEB2,ILB,IL1,IL2,IBB,IA3,NBOND
      REAL    DIST,DIFF_DIST,DIFF_PREV,DIST1,DIST_BOND,VAL
      CHARACTER BOND_ORDER*8,BOND_ORDER1*8,ASYMB1*4,ASYMB2*4
      CHARACTER CHEM1*4,CHEM2*4,ECHEM1*4,ECHEM2*4
      CHARACTER LINE*256
C
      INTEGER L1A_NDIST1(MAX1ATM)
C
C -----------------------------------------------------------
      IERR = 0
      IF(L1B_NBOND.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
C
      DO   IA1 = 1,L1A_NATOM
        L1A_NDIST1(IA1) = 0
      ENDDO

      DO   IB=1,L1B_NBOND
        IA1 = L1B_I1ATM(IB)
        IA2 = L1B_I2ATM(IB)
        L1A_NDIST1(IA1) = L1A_NDIST1(IA1) + 1
        L1A_NDIST1(IA2) = L1A_NDIST1(IA2) + 1
      ENDDO
cd        IF(L1A_SYMB(IA1)(1:2).EQ.'H ') THEN
cd          L1A_LENCON(1,IA2) = L1A_LENCON(1,IA2)+1
cd        ELSE IF(L1A_SYMB(IA2)(1:2).EQ.'H ') THEN
cd          L1A_LENCON(1,IA1) = L1A_LENCON(1,IA1)+1
cd        ENDIF
cd      ENDDO
C
      DO IB=1,L1B_NBOND
C
C---loop over all energetic type pairs and find 
C---closest distance for these element pairs.
        IA1    = L1B_I1ATM(IB)
        IA2    = L1B_I2ATM(IB)
        ASYMB1 = L1A_SYMB(IA1)
        ASYMB2 = L1A_SYMB(IA2)
cd        NBOND1 = L1A_NDIST(IA1)
cd        NBOND2 = 
        CHEM1  = L1A_CHEM (IA1)
        CHEM2  = L1A_CHEM (IA2)
        IF(ASYMB1(1:2).EQ.'H '.OR.
     &     ASYMB1(1:2).EQ.'D '    ) CHEM1 = 'H'
        IF(ASYMB2(1:2).EQ.'H '.OR.
     &     ASYMB2(1:2).EQ.'D '    ) CHEM2 = 'H'
C        DIST   = L1B_VOBS(IB)
C !!!
        DIST   = L1B_VAL(IB)
C !!!
C----Now check and define
C
C---Values should be read from the library
        BOND_ORDER = '.'
        DIFF_PREV  = 1.0E32

C        WRITE(*,*) IB,'>>>>>>>>>>>>>>>>>>>>'
C 
C---Define obvious ones first
C
cd        WRITE(*,*)ASYMB1,ASYMB2,L1A_NDIST1(IA1),L1A_NDIST1(IA2)
cd     &            L1A_LENCON(1,IA1),L1A_LENCON(1,IA2)
        IF(ASYMB1(1:2).EQ.'H '.OR.
     &     ASYMB1(1:2).EQ.'D '.OR.
     &     ASYMB2(1:2).EQ.'H '.OR.
     &     ASYMB2(1:2).EQ.'D '.OR.

     &     ASYMB1(1:2).EQ.'F '.OR.
     &     ASYMB2(1:2).EQ.'F '.OR.

     &     ASYMB1(1:2).EQ.'CL'.OR.
     &     ASYMB2(1:2).EQ.'CL'.OR.

     &     ASYMB1(1:2).EQ.'I '.OR.
     &     ASYMB2(1:2).EQ.'I '.OR.

     &     ASYMB1(1:2).EQ.'CL'.OR.
     &     ASYMB2(1:2).EQ.'CL'.OR.

     &     ASYMB1(1:2).EQ.'BR'.OR.
     &     ASYMB2(1:2).EQ.'BR'.OR.

     &     ASYMB1(1:2).EQ.'B '.OR.
     &     ASYMB2(1:2).EQ.'B '
     &                                        )THEN
          BOND_ORDER = 'single'
        ELSEIF(ASYMB1(1:2).EQ.'O ') THEN
          IF(L1A_NDIST1(IA1).EQ.2) BOND_ORDER = 'single'
        ELSEIF(ASYMB2(1:2).EQ.'O ') THEN
          IF(L1A_NDIST1(IA2).EQ.2) BOND_ORDER = 'single'
        ELSEIF(ASYMB1(1:2).EQ.'C ') THEN
          IF(L1A_NDIST1(IA1).EQ.4) BOND_ORDER = 'single'
        ELSEIF(ASYMB2(1:2).EQ.'C ') THEN
          IF(L1A_NDIST1(IA2).EQ.4) BOND_ORDER = 'single'
        ELSEIF(ASYMB1(1:2).EQ.'N ') THEN
          IF(L1A_NDIST1(IA1).EQ.4) BOND_ORDER = 'single'
        ELSEIF(ASYMB2(1:2).EQ.'N ') THEN
          IF(L1A_NDIST1(IA2).EQ.4) BOND_ORDER = 'single'
        ELSEIF(ASYMB1(1:2).EQ.'S ') THEN
          IF(L1A_NDIST1(IA1).EQ.2) BOND_ORDER = 'single'
        ELSEIF(ASYMB2(1:2).EQ.'S ') THEN
          IF(L1A_NDIST1(IA2).EQ.2) BOND_ORDER = 'single'
        ELSE IF(ASYMB1(1:2).EQ.'SE') THEN
          IF(L1A_NDIST1(IA1).EQ.2) BOND_ORDER = 'single'
        ELSE IF(ASYMB2(1:2).EQ.'SE') THEN
          IF(L1A_NDIST1(IA2).EQ.2) BOND_ORDER = 'single'
        ENDIF
C
C---Still have not been defined
        IF(BOND_ORDER(1:1).EQ.'.') THEN
          DO   ILB=1,LEB_NBOND
            IB1 = LEB_I1ATM(ILB)
            IB2 = LEB_I2ATM(ILB)
            ECHEM1 = LEB_1ATM(ILB)
            ECHEM2 = LEB_2ATM(ILB)
            IF(LEA_ENAME(IB1)(1:2).EQ.'H ') ECHEM1='H'
            IF(LEA_ENAME(IB2)(1:2).EQ.'H ') ECHEM2='H'

C
C--Make sure that we are not considering single bonds between sp1
C--atoms. They are much shorter.
            IF((CHEM1.EQ.ECHEM1.AND.
     &          CHEM2.EQ.ECHEM2).OR.
     &         (CHEM2.EQ.ECHEM1.AND.
     &          CHEM1.EQ.ECHEM2)) THEN

C          WRITE(*,*) '>>',CHEM1,CHEM2
C     *                   ,' ',ECHEM1,ECHEM2 


              IF((LEB_1ATM(ILB)(1:3).NE.'CSP'.AND.
     &            LEB_2ATM(ILB)(1:3).NE.'CSP'.AND.
     &            LEB_1ATM(ILB)(1:2).NE.'NS'.AND.
     &            LEB_2ATM(ILB)(1:2).NE.'NS').OR.
     &            LEB_TYPE(ILB)(1:4).EQ.'trip') THEN
                DIFF_DIST = ABS(DIST-LEB_LENGTH(ILB))
                IF(DIFF_DIST.LT.DIFF_PREV) THEN
                  DIFF_PREV  = DIFF_DIST
                  BOND_ORDER = LEB_TYPE(ILB)
                ENDIF
              ENDIF
            ENDIF
          ENDDO
        ENDIF
cd        WRITE(*,*)BOND_ORDER
C
C---There is no pair. Look for "covalent diameter" of atoms

        BOND_ORDER1 = '.'
        IF(BOND_ORDER(1:1).EQ.'.') THEN
          DO   IEB1=1,LEB_NBOND
            IF(LEB_2ATM(IEB1)(1:1).EQ.'.') THEN
            IL1 = LEB_I1ATM(IEB1)
            IF(ASYMB1(1:2).EQ.LEA_ENAME(IL1)(1:2)) THEN
              BOND_ORDER1 = LEB_TYPE(IEB1)
              DO  IEB2=1,LEB_NBOND
                IF(LEB_2ATM(IEB2)(1:1).EQ.'.') THEN
                IF(BOND_ORDER1(1:4).EQ.LEB_TYPE(IEB2)(1:4)) THEN
                  IL2 = LEB_I1ATM(IEB2)
                  IF(ASYMB2(1:2).EQ.LEA_ENAME(IL2)(1:2)) THEN
                    DIST_BOND = (LEB_LENGTH(IEB1)+LEB_LENGTH(IEB2))/2.0
                    DIFF_DIST = ABS(DIST_BOND-DIST)
                    IF(DIFF_DIST.LT.DIFF_PREV) THEN
                      DIFF_PREV  = DIFF_DIST
                      BOND_ORDER = BOND_ORDER1
                    ENDIF
                  ENDIF
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
            ENDIF
          ENDDO
        ENDIF
C
C---Still no bond order. If one of the atoms can have metal bond

        IF(BOND_ORDER(1:1).EQ.'.') THEN
          DO   IEB1=1,LEB_NBOND
            IB1 = LEB_I1ATM(IEB1)
            IB2 = LEB_I2ATM(IEB1)
            IF((ASYMB1(1:2).EQ.LEA_ENAME(IB1)(1:2) .OR.
     &          ASYMB2(1:2).EQ.LEA_ENAME(IB1)(1:2) .OR.
     &          ASYMB1(1:2).EQ.LEA_ENAME(IB2)(1:2) .OR.
     &          ASYMB2(1:2).EQ.LEA_ENAME(IB2)(1:2)).AND.
     &          LEB_TYPE(IEB1)(1:5).EQ.'metal'         ) THEN
              BOND_ORDER = 'metal'
              GOTO 100
            ENDIF
          ENDDO
        ENDIF
C
c---Could not find from the energetic library. Something is wrong.
C---All atoms should be in the energetic library. Either library is not full
C---or element name is not correct.
        IF(BOND_ORDER.EQ.'.') THEN
          IERR = 1
          BOND_ORDER = 'single'
        ENDIF
 100    CONTINUE
C
c---Now define bond orders.
        L1B_TYPE(IB) = BOND_ORDER
C
C--Print to make sure things are all right.
      ENDDO
C
C---Check if element name is not correct.
C
      IF(IERR.NE.0) THEN
        DO   IA1=1,L1A_NATOM
          ASYMB1 = L1A_SYMB(IA1)
          DO   IL1=1,LEA_NATOM
            IF(ASYMB1(1:2).EQ.LEA_ENAME(IL1)) GOTO 200
          ENDDO
          LINE = 'ERROR: Atom '//L1A_ANAME(IA1)(1:4)//
     &    ' with element name '//ASYMB1(1:2)
          CALL MSGERR(MDOC,LINE)
          LINE = '       does not exist in the'//
     &        'energetic library "ener_lib.cif"'
          CALL MSGERR(MDOC,LINE)
 200      CONTINUE
        ENDDO
        LINE = 'ERROR: Energetic library - "ener_lib.cif" is incomplete'
        CALL MSGERR(MDOC,LINE)
        RETURN
      ENDIF
C
C--Can we correct some bond orders?
C
C--First see if we have triple bond. Then another bond must be single
      DO   IB=1,L1B_NBOND
        IA1    = L1B_I1ATM(IB)
        IA2    = L1B_I2ATM(IB)
        IF(L1B_TYPE(IB).EQ.'trip') THEN
C
          ASYMB1 = L1A_SYMB(IA1)
          ASYMB2 = L1A_SYMB(IA2)
          NBOND = L1A_NDIST(IA1)
          DO   IBB=1,NBOND
            IA3 = L1A_CONN(IBB,IA1)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.NE.IA2.AND.IA3.GT.0) THEN
              CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,IERR)
              IF(L1B_TYPE(IB1)(1:4).NE.'meta') L1B_TYPE(IB1) = 'single'
            ENDIF
          ENDDO
          NBOND = L1A_NDIST(IA2)
          DO   IBB=1,NBOND
            IA3 = L1A_CONN(IBB,IA2)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.NE.IA1.AND.IA3.GT.0) THEN
              CALL SRCH_BOND(MDOC,L1L_MNAME,IA2,IA3,VAL,IB1,IERR)
              IF(L1B_TYPE(IB1)(1:4).NE.'meta') L1B_TYPE(IB1) = 'single'
            ENDIF
          ENDDO
        ENDIF
C
C--If one of the atoms is Hydrogen then bond order is single
        IF((L1A_SYMB(IA1)(1:2).EQ.'H '.OR.
     &      L1A_SYMB(IA2)(1:2).EQ.'H ').AND.
     &     L1B_TYPE(IB)(1:4).NE.'meta') THEN
          L1B_TYPE(IB) = 'single'
        ENDIF

      ENDDO

      
      RETURN
      END

      SUBROUTINE CREATE_NEW_COORDINATE(MDOC,LIST,MON,PRSNT,REFR
     *                           ,MON_INPUT,NAME,ITESTR,LCOOR,IERR)
C ---------------------------------------------------------------
      INTEGER*4 MDOC,IERR,ITEST
      CHARACTER MON*8,SRCH*1,PRSNT*1,REFR*1,LIST*1,LCOOR*1,NAME*(*)
      CHARACTER MON_INPUT*8,MODT*8
C ---
      INCLUDE 'atom_com.fh'
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,PNUM*12,DUMMY_FLAG*1,MOD*1,REF*1
C ---------------------------------------------------------------
      M     = 99
      REF   = REFR
      ITEST = ITESTR

      CALL LENSTR_BL(MON_INPUT,L)
      IF(L.GT.0.AND.MON_INPUT(1:1).NE.'?'.AND.
     *     MON_INPUT(1:1).NE.' '      ) THEN
      ELSE
        MON_INPUT = MON
      ENDIF
      CALL CP_MLIB(MDOC,MON,IERR)
  
      IF(IERR.NE.0) RETURN

      CALL GET_INI_RES_TYPE(MDOC,LINE,MON,IT,IERR)
      IF(IERR.NE.0) RETURN

      ITER = 0
      IF(IT.EQ.3) THEN
        MODT = 'AA-STAND'
        CALL MODIF(MDOC,MODT,IERR)
        IERR = 0
        ITER = 2
      ENDIF
      IF(IT.EQ.5) THEN
        MODT = 'NA-STAND'
        CALL MODIF(MDOC,MODT,IERR)
        IERR = 0
        ITER = 4
      ENDIF
      IF(ITER.GT.0) THEN
        MODT = TERM_S_TYPE(ITER)
        CALL MODIF(MDOC,MODT,IERR)
        IERR=0
        MODT = TERM_F_TYPE(ITER)
        CALL MODIF(MDOC,MODT,IERR)
        IERR=0
      ENDIF

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(''start crt new coords:'',5i4)')
     *  L1A_NATOM,L1B_NBOND,L1G_NANGL,L1T_NTORS,L1C_NCHIR
        CALL MSGdoc(MDOC,line)
      ENDIF

      ICOOR = 0
      COOR_SUM = 0.0
      DO I=1,L1A_NATOM
        IF(L1A_COOR_FLAG(I).EQ.'N'.OR.L1A_COOR_FLAG(I).EQ.'.') THEN
          ICOOR=1 
        ELSE
          COOR_SUM = COOR_SUM +  
     *                 ABS(L1A_X(I)) + ABS(L1A_Y(I)) + ABS(L1A_Z(I)) 
        ENDIF
      ENDDO
      IF(COOR_SUM.LT.0.001) ICOOR = 1

c      IF(PRSNT.EQ.'M'.OR.LCOOR.EQ.'N') ICOOR = 1
      if(lcoor.eq.'N') icoor = 1
      PNUM = ' '
      CALL SET_NUM(MDOC,MON,PNUM,IERR)
      IF(IERR.NE.0) RETURN

      CALL SET_NUM_LIB(MDOC,LIST)

      IPRSNT = 0
      CALL RING(MDOC,LIST,NRING,IPRSNT,IERR)

      IANGL = 0
      IF(PRSNT.NE.'M') IANGL = 1
      CALL CHECK_METAL_CHIR(MDOC,MON,IANGL,LIST,IERR)
      IF(IERR.NE.0) THEN
        IF(ICOOR.GT.0) RETURN     
        GO TO 200
      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL PRINT_LIB_LBC(MDOC,IERR)
      ENDIF

      IF(PRSNT.EQ.'N'.AND.ICOOR.EQ.0) GO TO 200
      IF(ICOOR.EQ.1) THEN
        DO I=1,L1A_NATOM
          L1A_COOR_FLAG(I) = 'N'
        ENDDO
      ENDIF

      IF(PRSNT.NE.'M') THEN
c       CALL TORSION_CORRECTION(MDOC,LIST,NRING,IERR)
        IF(IERR.NE.0) THEN
          WRITE(LINE,
     *    '('' ERROR : '',A,'' /subroutine TORSION_CORRECTION/'')')
     *    MON
          CALL MSGERR(MDOC,LINE)
          RETURN         
        ENDIF
      ENDIF
      
      DUMMY_FLAG = 'Y'

      IF(LIST.EQ.'T') THEN
        write(*,*) '--1--'
        CALL PRINT_LIB_LBC(MDOC,IERR)
      ENDIF
  
      CALL CREATE_BLCRD(MDOC,LIST,MON,DUMMY_FLAG,PRSNT,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,'ERRROR: in subroutine CREATE_BLCRD') 
        RETURN
      ENDIF

      CALL CHECK_BOND_ORDERS(MDOC,LIST,MON,IERR)
      IF(IERR.NE.0) RETURN

      ICOOR = 0
      IF(REF.EQ.'0') GO TO 200

      IF(LIST.EQ.'T') THEN
        write(line,*) ' --- before angle corr ---',NRING
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      IFIN = 0
      IF(L1A_IFINISH.GT.0) THEN
        IF(L1A_NDIST(L1A_IFINISH).GT.0.AND.
     *     L1A_IFORW(L1A_IFINISH).LT.0     ) THEN
          IFIN = 1
          L1A_IFORW(L1A_IFINISH) = 
     *        L1A_CONN(L1A_NDIST(L1A_IFINISH),L1A_IFINISH)
        ENDIF  
      ENDIF

      IMODE = 0
      CALL ANGLE_CORRECTION(IMODE,L1A_NATOM,L1A_NDUMMY
     *   ,L1A_IFORW,L1A_IBACK,L1A_LENGTH,L1A_THETA,L1A_PHI
     *   ,L1A_NDIST,L1A_CONN,MAX1BRN,L1A_X,L1A_Y,L1A_Z,L1A_ID_PSI)

      MMM = M
      IF(LIST.EQ.'T') THEN
        MMM = MDOC
      ENDIF  

      NA     = L1A_NATOM
      NA     = L1A_NATOM + L1A_NDUMMY        

      write(line,*) ' --- crd after angle corr ---'
      CALL MSGDOC(MMM,LINE)
      DO    IA=1,NA
        CALL W_CRD_LBC(MMM,IA)
      ENDDO

      IF(REF.EQ.'T') GO TO 210

C     imode = 0 calc all (dl,theta,psi); # 0 only psi
      IMODE = 0
      CALL CRTOANG(IMODE,NA,L1A_IFORW,L1A_IBACK
     *  ,L1A_LENGTH,L1A_THETA,L1A_PHI,L1A_X,L1A_Y,L1A_Z,L1A_ID_PSI)
      CALL MSGDOC(MMM,LINE)

      write(line,*) ' --- CRTOANG ---',IMODE
      CALL MSGDOC(MMM,LINE)
      DO    IA=1,NA
        CALL W_CRD_LBC(MMM,IA)
      ENDDO

      CALL ANGTOCR(MMM,LIST,L1A_ISTART,L1A_IFINISH
     * ,L1A_X,L1A_Y,L1A_Z,L1A_NDIST
     * ,L1A_LENGTH,L1A_THETA,L1A_PHI,L1A_CONN,MAX1BRN,IERR)


      write(line,*) ' --- ANGTOCRD ---',NA
      CALL MSGDOC(MMM,LINE)
      DO    IA=1,NA
        CALL W_CRD_LBC(MMM,IA)
      ENDDO


      MT = 999
      IF(LIST.EQ.'L'.OR.LIST.EQ.'T') MT = MDOC
      IERR_REF = 0 

      IF(REF.NE.'N') THEN
        IT     = ITEST

        IT     =-1 
    
        NCYCLE = 30
        REF    = 'S'
        IMODE  = 0
C       it = 0 ref all; =-1 not vdw
C       imode = 0 calc all (dl,theta,psi); # 1 only psi (VAR)

        CALL REF_MON(MT,LIST,NCYCLE,REF,IT,IMODE,IERR)
        IF(IERR.EQ.99) THEN
          IERR = 0
          IF(LIST.EQ.'T') THEN
            CALL MSGERR(MDOC,'WARNING: refinement is not possible') 
            write(*,*) 'Natom:',L1A_NATOM
          ENDIF
          IERR_REF = 99 
          IF(REFR.NE.'Y'.OR.L1A_NATOM.LE.3) GO TO 210
        ELSE IF(IERR.EQ.98) THEN
          IERR = 0
          GO TO 210
        ENDIF
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,'ERRROR: in subroutine REF_MON') 
          RETURN
        ENDIF
C ---
        IF(REFR.EQ.'Y') THEN
C ITEST:  BOND,  1,3,8,9,10,11,12,13 
C         ANGLE, 2,3,8,9,10,11,12,13 
C         3 only BOND and ANGLE 
C        13 only BOND and ANGLE and VDW and HB
C         TORS   5,8,12,#9,#10,#11,#13
C         5 only tors   
C         CHIR   6,8,9,#10,#11,#12,#13
C         6 only chir
C         PLAN   7,8,9,10,11,12,#13
C         7 only plan
C         VDW and HB  4,11,13  
C       4 only VDW and HB 4  
C       8 whitout VDW and HB   
C       9 whitout tors, 
C      10 whitout tors and chir, 
C      11 whitout tors,chir
C      12 whitout chir,VDW,NB
          IT     = ITEST
c          IT     = 8
          IT     = 3
          NCYCLE = 30
          IF(ITESTR.EQ.0) THEN
            IT = 0
            NCYCLE = 50
          ENDIF
          REF    = 'Y'
          IMODE  = 0
          CALL REF_MON(MT,LIST,NCYCLE,REF,IT,IMODE,IERR)
          IF(IERR.NE.0) THEN
            CALL MSGERR(MDOC,'ERRROR: in subroutine REF_MON') 
            RETURN
          ENDIF
c          IF(ITESTR.EQ.20) THEN
          IF(ITESTR.EQ.2.OR.ITESTR.EQ.3) THEN
            IT = 1
            CALL H_ATOM_COORS_REBUILD(MDOC,LIST,IT,IERR)

            IT     = 0
c           IT     = 13
            NCYCLE = 50
            IF(ITESTR.EQ.3) THEN
              IT = 13
              NCYCLE = 30
            ENDIF
            REF    = 'Y'
            IMODE  = 0
            CALL REF_MON(MT,LIST,NCYCLE,REF,IT,IMODE,IERR)
            IF(IERR.NE.0) THEN
              CALL MSGERR(MDOC,'ERRROR: in subroutine REF_MON') 
              RETURN
            ENDIF
          ENDIF
C ---          
          IT = 1
          if(itestr.ne.1) IT = 2
c         it = 3 

          IF(IT.EQ.2.AND.IERR_REF.EQ.0) THEN

C           imode = 0 calc all (dl,theta,psi); # 0 only psi
            IMODE = 0

            NNN = L1A_NATOM+L1A_NDUMMY
        
            CALL CRTOANG(IMODE,NNN,L1A_IFORW,L1A_IBACK
     *      ,L1A_LENGTH,L1A_THETA,L1A_PHI,L1A_X,L1A_Y,L1A_Z
     *      ,L1A_ID_PSI)
            CALL ANGTOCR(MMM,LIST,L1A_ISTART,L1A_IFINISH
     *      ,L1A_X,L1A_Y,L1A_Z,L1A_NDIST
     *      ,L1A_LENGTH,L1A_THETA,L1A_PHI,L1A_CONN,MAX1BRN,IERR)

            CALL MSGDOC(MMM,LINE)
            DO    IA=1,NNN
              CALL W_CRD_LBC(MMM,IA)
            ENDDO

c            IF(L1A_NDUMMY.GT.0) THEN
c              DO I=L1A_NATOM+1,L1A_NATOM+L1A_NDUMMY
c                IA       = L1A_IEXTR(1,I)
c                L1A_X(I) = L1A_X(IA)
c                L1A_Y(I) = L1A_Y(IA)
c                L1A_Z(I) = L1A_Z(IA)             
c              ENDDO
c            ENDIF 

            IT     = 0

            NCYCLE = 30
            REF    = 'S'
            IMODE  = 0
C           it = 0 ref all; =1 not vdw
C           imode = 0 calc all (dl,theta,psi); # 1 only psi (VAR)

            CALL REF_MON(MT,LIST,NCYCLE,REF,IT,IMODE,IERR)
            IF(IERR.EQ.99) THEN
              IERR = 0
              IF(LIST.EQ.'T') THEN
              CALL MSGERR(MDOC,'WARNING: refinement is not possible') 
              ENDIF
              GO TO 210
            ENDIF
            IF(IERR.NE.0) THEN
              CALL MSGERR(MDOC,'ERRROR: in subroutine REF_MON') 
              RETURN
            ENDIF
          ENDIF

          IF(ITESTR.EQ.3) THEN
C ITEST: 1 only BOND, 2 only ANGLE, 3 only BOND and ANGLE, 4 only VDW and HB
C        5 only tors,  6 only chir, 7 only plan, 8 whitout VDW and HB   
C        9 whitout tors, 10 whitout tors and chir, 11 whitout tors,chir,VDW,NB
C       12 whitout chir
            IT     = ITEST
            IT     = 0 
         
            REF    = 'Y'
            IMODE  = 0
            NCYCLE = 30
            CALL REF_MON(MT,LIST,NCYCLE,REF,IT,IMODE,IERR)
            IF(IERR.NE.0) THEN
              CALL MSGERR(MDOC,'ERRROR: in subroutine REF_MON') 
              RETURN
            ENDIF
          ENDIF
C ---
        ENDIF

      ENDIF

 210  CONTINUE

      IF(IFIN.GT.0) L1A_IFORW(L1A_IFINISH) = -1

 200  CONTINUE

      IT = 1
      CALL H_ATOM_COORS_REBUILD(MDOC,LIST,IT,IERR)

      IF(LIST.EQ.'T') THEN
        write(*,*) '--2--'
        CALL PRINT_LIB_LBC(MDOC,IERR)
      ENDIF

c      IMODE = 3
cC     change chiralities only
c
      IMODE = 0
      CALL CP_VOBS_VLIB(MT,LIST,IMODE,IERR)

      IF(LIST.EQ.'T') THEN
        write(*,*) '--3--'
        CALL PRINT_LIB_LBC(MDOC,IERR)
      ENDIF

C ---
C ---   Create PostScript file ---

      NAME = 'libcheck'

      MOD  = 'L'

      IF(LIST.EQ.'T') THEN
        JCOOR = 0
        DO I=1,L1A_NATOM
          IF(L1A_COOR_FLAG(I).EQ.'N'.OR.L1A_COOR_FLAG(I).EQ.'.')
     *    JCOOR=1 
        ENDDO
        write(*,*) 'PRSNT,Jcoor:',PRSNT,JCOOR,ICOOR
        L1A_NATOM = L1A_NATOM + L1A_NDUMMY        
      ENDIF

      VANGLE = 0.0

      CALL GRAPH_NEWL(MDOC,MOD,MON_INPUT,NAME,VANGLE,IERR)
      IERR=0 
C ---
      IF(PRSNT.NE.'M'.OR.ICOOR.EQ.0) THEN     
        L1L_FUSE   = 'C'
        CALL CPL_MLIB(MDOC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      RETURN
      END     

      SUBROUTINE WRITE_LIST_MON(MDOC,IERR)
C -----------------------------------------
C -P- WRITE_LIST_MON - write monomer's list of the library
C            
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256,NAME*48,MON*8,PRSNT*1,TYPE*16
C --------------------------------
      NUMB   = 0
      NUMB_C = 0
      IERR   = 0
      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC
     *   ,' ERROR: number of monomers in the library = 0')
        IERR = 1
        RETURN
      ENDIF
C ------------------
c '_lib_name   '  mon_lib
c '_lib_version'  2.1
c '_lib_update '  06/11/98
      CALL MSGDOC(MDOC,' ------------------------------')
      CALL MSGDOC(MDOC,' ---  LIBRARY OF MONOMERS   ---')
      CALL LENSTR_BL(LB_NAME,LL)
      IF(LL.GT.60) LL=60
      WRITE(LINE,'(A,6X,A)') '_lib_name   ',LB_NAME(1:LL)
      CALL MSGDOC(MDOC,LINE)
      CALL LENSTR_BL(LB_VERS,LL)
      IF(LL.GT.60) LL=60
      WRITE(LINE,'(A,6X,A)') '_lib_version',LB_VERS(1:LL)
      CALL MSGDOC(MDOC,LINE)
      CALL LENSTR_BL(LB_DATE,LL)
      IF(LL.GT.60) LL=60
      WRITE(LINE,'(A,6X,A)') '_lib_update ',LB_DATE(1:LL)
      CALL MSGDOC(MDOC,LINE)
      CALL MSGDOC(MDOC,' ------------------------------')
C ------------------
      CALL MSGDOC(MDOC,'-list-begin -------------------')
      DO L=1,LML_NMON
C2345678 123456789 123456789 123456789 123456789 12345678 123456789 112341234
C         12341234
cE     .'ferrum                                          'non-polymer   1   1 .
        MON   = LML_MNAME(L)
        PRSNT = LML_PRSNT(L)
C       all atoms
        NATM  = LML_NATM (L)
C       non-H atoms
        NHATM = LML_NHATM(L)
        TYPE  = LML_TYPE (L)
        NAME  = LML_NAME (L)
        NUMB  = NUMB + 1
        IF(PRSNT.NE.'M') NUMB_C = NUMB_C + 1

        CALL LENSTR_BL(MON,LEN)
        IF(LML_FUSE(L).NE.'?'.AND.LEN.GT.0.AND.
     *              MON(1:1).NE.'?') THEN


          WRITE(LINE,'(A8,1X,A48,1X,A11,2I4,A)') 
     *    MON,NAME,TYPE(1:11),NATM,NHATM,PRSNT
          CALL MSGDOC(MDOC,LINE)

        ENDIF  


      ENDDO

      IF(LDR_NDER.GT.0) THEN
        DO L=1,LDR_NDER
          MON   = LDR_MNAME(L)
          PRSNT = 'R'
C         all atoms
          NATM  = 0
C         non-H atoms
          NHATM = 0
          TYPE  = LDR_TYPE (L)
          NAME  = LDR_NAME (L)
          NUMB  = NUMB + 1
          IF(PRSNT.NE.'M') NUMB_C = NUMB_C + 1
          WRITE(LINE,'(A8,1X,A48,1X,A11,2I4,A)') 
     *    MON,NAME,TYPE(1:11),NATM,NHATM,PRSNT
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
      CALL MSGDOC(MDOC,'-list-end   -------------------')
C --------------------------------------------
      CALL MSGDOC(MDOC,' ------------------------------')
      WRITE(LINE,'(
     *'' NUMBER OF MONOMERS IN THE LIBRARY          :'',I6)') NUMB
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(
     *''               with complete description    :'',I6)') NUMB_C
      CALL MSGDOC(MDOC,LINE)
      CALL MSGDOC(MDOC,' ------------------------------')
C ---
      RETURN
      END     


C ******
      SUBROUTINE CREATE_BLCRD(MDOC,LIST,MON,DUMMY_FLAG,PRSNT,IERR)
C -----------------------------------------------
C -P- CONNECT - 
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,LIST*1,DUMMY_FLAG*1,PRSNT*1
C ---
      INCLUDE 'lib_com.fh'
C ******
      PARAMETER ( NSTLIM = 10 )
      INTEGER*4 NSTCK,ISTACK(NSTLIM),ICSTACK(NSTLIM)
C --------------------------------------
      REAL      V_1(3),V_0(3)
      INTEGER*4 IC
      CHARACTER LINE*256
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      IERR = 0
C ---
      ISTART  = L1A_ISTART
      IFINISH = L1A_IFINISH
      ISTART2 = 0
      L1A_NDUMMY = 0
      L1L_NATM   = L1A_NATOM
      L1L_NHATM  = L1A_NHATOM
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        write(line,*) ' --- create_blcrd ---'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH,DUMMY_FLAG
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     * '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3,A)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      do  i=1,l1a_natom
         if(l1a_coor_flag(i).eq.'N') goto 350
      enddo
      return
 350  continue
      I        = ISTART
      IC       = 1
      NSTCK    = 0
c      goto 500
      L1A_X(I) = 0.0
      L1A_Y(I) = 0.0
      L1A_Z(I) = 0.0
      
      L1A_LENGTH(I)    = 1.0
      L1A_THETA (I)    =90.0
      L1A_PHI   (I)    = 0.0
      L1A_COOR_FLAG(I) = 'Y'

C     coord initial dummy atoms -1, -2
      V_1(1) = -1.0
      V_1(2) =  1.0
      V_1(3) =  0.0

      V_0(1) = -1.0
      V_0(2) =  0.0
      V_0(3) =  0.0

  400 CONTINUE
      N  = L1A_NDIST(I)
      NE = L1A_NEXTR(I)
      NT = N + NE

      IF(IC.EQ.1.AND.NT.GT.0) THEN

        CALL CALC_POLCRD_MN(MDOC,LIST,MON,I,N,V_0,V_1
     *                  ,ISTART,ISTART2,DUMMY_FLAG,PRSNT,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,'ERRROR: in subroutine CALC_POLCRD') 
          RETURN
        ENDIF

      ENDIF

      IF(N.LE.0.AND.NSTCK.LE.0) GO TO 500
        IF(N.EQ.0) THEN
          I     = ISTACK (NSTCK)
          IC    = ICSTACK(NSTCK)
          NSTCK = NSTCK-1
        ELSE IF(N.EQ.1) THEN
          INEXT = L1A_CONN(1,I)
          IC    = 1
          I     = INEXT
        ELSE IF(N.GT.1) THEN
  410     CONTINUE
          INEXT = L1A_CONN(IC,I)

          IF(IC.LT.N) THEN
            IC    = IC+1
            NSTCK = NSTCK+1
            IF(NSTCK.GT.NSTLIM) THEN
              WRITE(LINE,
     *        '('' ERR: '',A,'' : N-stack > '',I6)')
     *        MON,NSTLIM
              CALL MSGERR(MDOC,LINE)
              IERR=1
              GO TO 2000
            ENDIF
            ISTACK(NSTCK)  = I
            ICSTACK(NSTCK) = IC
          ENDIF   
          I  = INEXT
          IC = 1
        ELSE
          WRITE(LINE,
     *    '('' WARNING: '',A,'' : bad tree structure'')')
     *    MON
          CALL MSGERR(MDOC,LINE)
          IERR = 1
          GO TO 2000
        ENDIF
      GO TO 400
  500 CONTINUE

C ---

C      IF(L1A_NDUMMY.GT.0) THEN
C        L1A_NATOM = L1A_NATOM + L1A_NDUMMY 
C        CALL CORR_DUMMY_ATOM(MDOC,L1L_NATM,IERR)
C      ENDIF

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM + L1A_NDUMMY
        write(line,*) ' --- create_blcrd after---'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     * '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3,A)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        write(line,*) ' --- crd ---',NA
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          CALL W_CRD_LBC(MDOC,IA)
        ENDDO
      ENDIF

      RETURN
C ------------------
 2000 CONTINUE
      WRITE(LINE,
     *'('' WARNING: '',A,'' : wrong tree structure'')')
     *MON
      CALL MSGERR(MDOC,LINE)
      RETURN    
      END

      SUBROUTINE GET_VECTOR(I,V_0,V_1,V1,V2,I1,I2)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C --------------------------------------
      REAL      V_1(3),V_0(3),V1(3),V2(3)
C --------------------------------------------------
        IB = L1A_IBACK(I)
        IF(IB.LE.0) THEN
          V2(1) = V_0(1)
          V2(2) = V_0(2)
          V2(3) = V_0(3)
          V1(1) = V_1(1)
          V1(2) = V_1(2)
          V1(3) = V_1(3)
          I1    = 0
          I2    = 0
        ELSE
          V2(1) = L1A_X(IB)
          V2(2) = L1A_Y(IB)
          V2(3) = L1A_Z(IB)
          I2    = IB
          IBB   = L1A_IBACK(IB)
          IF(IBB.LE.0) THEN
            V1(1) = V_0(1)
            V1(2) = V_0(2)
            V1(3) = V_0(3)
            I1    = 0
          ELSE
            V1(1) = L1A_X(IBB)
            V1(2) = L1A_Y(IBB)
            V1(3) = L1A_Z(IBB)
            I1    = IBB
          ENDIF
        ENDIF

        V1(1) = V2(1)-V1(1)
        V1(2) = V2(2)-V1(2)
        V1(3) = V2(3)-V1(3)
        V2(1) = L1A_X(I)-V2(1)
        V2(2) = L1A_Y(I)-V2(2)
        V2(3) = L1A_Z(I)-V2(3)

      RETURN
      END

      SUBROUTINE DEF_TYPE_II(MDOC,LIST,MON,NT,NHT,II,I2,I4,THETA_D,IERR)
C ----------------------------------------------------------
      CHARACTER LIST*1,MON*8
C --------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------------
      INTEGER   I4(*)
      CHARACTER LINE*256
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
C ----------------------------------------------------------      
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR = 0
      IF(IS_IT_METAL(L1A_SYMB(II))) THEN
        THETA_D = 90.0*PI180           
        RETURN
      ENDIF
      IF(NT.LE.2) THEN
        ITYPE   = 1
        THETA_D = 120.0*PI180   
        IF(NT.EQ.2) THEN
          I=0
          CALL SRCH_ANGL(MDOC,MON,I2,II,I4(1),VAL,LG,IERR)
          IF(IERR.NE.0) THEN
            IF(I2.GT.0) THEN
              WRITE(LINE,
     *      '(''WARNING: no angle '',A4,'' - '',A4,'' - '',A4)')
     *        L1A_ANAME(I2),L1A_ANAME(II),L1A_ANAME(I4(1))
              CALL MSGERR(MDOC,LINE)
            ENDIF
            IERR = 0
          ELSE
            A1 = VAL*PI180
            I  = I+1
          ENDIF
          CALL SRCH_ANGL(MDOC,MON,I2,II,I4(2),VAL,LG,IERR)
          IF(IERR.NE.0) THEN
            IF(I2.GT.0) THEN
              WRITE(LINE,
     *      '(''WARNING: no angle '',A4,'' - '',A4,'' - '',A4)')
     *        L1A_ANAME(I2),L1A_ANAME(II),L1A_ANAME(I4(2))
              CALL MSGERR(MDOC,LINE)
            ENDIF
            IERR=0
          ELSE
            A2 = VAL*PI180
            I  = I+1
          ENDIF
          CALL SRCH_ANGL(MDOC,MON,I4(1),II,I4(2),VAL,LG,IERR)
          IF(IERR.NE.0) THEN
            WRITE(LINE,
     *      '(''WARNING: no angle '',A4,'' - '',A4,'' - '',A4)')
     *      L1A_ANAME(I4(1)),L1A_ANAME(II),L1A_ANAME(I4(2))
            CALL MSGERR(MDOC,LINE)
            IERR=0
          ELSE
            A3 = VAL*PI180
            I  = I+1
          ENDIF
          IF(I.EQ.3) THEN
            S = A1+A2+A3
            IF(S.GT. PI) S = S - TWOPI
            IF(S.LE.-PI) S = S + TWOPI
C                       10 grad 
            IF(ABS(S).GT.0.175) ITYPE=2
          ENDIF
          CALL SRCH_CHIR(MDOC,MON,II,I2,I4(1),I4(2),VOL,LC,IS,IERR)
          IF(IERR.NE.0.AND.ITYPE.EQ.2.AND.NHT.LE.0.AND.I2.GT.0) THEN
C            WRITE(LINE
C     *      ,'(''WARNING: missing chirality for atom "'',A4,''"'')')
C     *      L1A_ANAME(II)
C            CALL MSGERR(MDOC,LINE)
          ELSE
            IF(I.NE.3) ITYPE = 2
          ENDIF
          IERR = 0
          IF(ITYPE.EQ.2) THETA_D = 109.0*PI180   
        ENDIF
      ELSE IF(NT.EQ.3) THEN
        IF(I2.GT.0) THEN
        IF(NHT.EQ.1) THEN
          CALL SRCH_CHIR(MDOC,MON,II,I2,I4(2),I4(3),VOL,LC,IS,IERR)
          IF(IERR.NE.0) THEN
C            WRITE(LINE
C     *      ,'(''WARNING: missing chirality  for atom "'',A4,''"'')')
C     *      L1A_ANAME(II)
C            CALL MSGERR(MDOC,LINE)
          ENDIF
          IERR = 0
        ELSE IF(NHT.EQ.0) THEN
          I = 0
          CALL SRCH_CHIR(MDOC,MON,II,I4(1),I4(2),I4(3),VOL,LC,IS,IERR)
          IF(IERR.EQ.0) THEN
            I = 1
          ELSE
            IERR = 0
            CALL SRCH_CHIR(MDOC,MON,II,I2,I4(2),I4(3),VOL,LC,IS,IERR)
            IF(IERR.EQ.0) THEN
              I = 1
            ELSE
              IERR = 0
              CALL SRCH_CHIR(MDOC,MON,II,I2,I4(1),I4(2),VOL,LC,IS,IERR)
              IF(IERR.EQ.0) I = 1
            ENDIF
          ENDIF
          IERR = 0
          IF(I.EQ.0) THEN
C            WRITE(LINE
C     *      ,'(''WARNING: missing chirality for atom "'',A4,''"'')')
C     *      L1A_ANAME(II)
C            CALL MSGERR(MDOC,LINE)
          ENDIF
        ENDIF
        ITYPE   = 2
        THETA_D = 109.0*PI180   

        ELSE
C       --- I2=0 ---
          ITYPE   = 2
          THETA_D = 109.0*PI180   
          I       = 0
          CALL SRCH_ANGL(MDOC,MON,I4(3),II,I4(1),VAL,LG,IERR)
          IF(IERR.NE.0) THEN
            WRITE(LINE,
     *    '(''WARNING: no angle '',A4,'' - '',A4,'' - '',A4)')
     *      L1A_ANAME(I4(3)),L1A_ANAME(II),L1A_ANAME(I4(1))
            CALL MSGERR(MDOC,LINE)
            IERR=0
          ELSE
            A1 = VAL*PI180
            I  = I+1
          ENDIF
          CALL SRCH_ANGL(MDOC,MON,I4(3),II,I4(2),VAL,LG,IERR)
          IF(IERR.NE.0) THEN
            WRITE(LINE,
     *    '(''WARNING: no angle '',A4,'' - '',A4,'' - '',A4)')
     *      L1A_ANAME(I4(3)),L1A_ANAME(II),L1A_ANAME(I4(2))
            CALL MSGERR(MDOC,LINE)
            IERR = 0
          ELSE
            A2 = VAL*PI180
            I  = I+1
          ENDIF
          CALL SRCH_ANGL(MDOC,MON,I4(1),II,I4(2),VAL,LG,IERR)
          IF(IERR.NE.0) THEN
            WRITE(LINE,
     *    '(''WARNING: no angle '',A4,'' - '',A4,'' - '',A4)')
     *      L1A_ANAME(I4(1)),L1A_ANAME(II),L1A_ANAME(I4(2))
            CALL MSGERR(MDOC,LINE)
            IERR=0
          ELSE
            A3 = VAL*PI180
            I  = I+1
          ENDIF
          IF(I.EQ.3) THEN
            S = A1+A2+A3
            IF(S.GT. PI) S = S - TWOPI
            IF(S.LE.-PI) S = S + TWOPI
C                       10 grad 
            IF(ABS(S).LT.0.175) THEN
              ITYPE   = 1
              THETA_D = 120.0*PI180   
           ENDIF
          ENDIF

        ENDIF
      ELSE
        ITYPE   = 3
        THETA_D = 90.0*PI180   
        IF(I2.LE.0) THEN
          ITYPE   = 2
          THETA_D = 109.0*PI180   
        ENDIF      
      ENDIF
C --------------------
      RETURN
      END

      SUBROUTINE PUT_TO_BOND_LIST(MDOC,I1,I2,VAL,TYPE,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,I1,I2,IERR
C ---
      INCLUDE 'lib_com.fh'
C ------------------------------------------------
      CHARACTER LINE*256,TYPE*8
C --------------------------------------------------------
      M=-ABS(MDOC)-1
      IERR  = 0
      IF(I1.LE.0.OR.I2.LE.0) THEN
        RETURN
      ENDIF

      IF(L1B_NBOND.GE.MAX1BND) THEN
        WRITE(LINE
     * ,'('' ERROR: number of bonds of monomer >'',I6)') 
     *  MAX1BND
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC
     * ,'         Change parameter MAX1BND in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF
      L1B_NBOND   = L1B_NBOND+1
      L           = L1B_NBOND
      L1B_1ATM(L) = L1A_ANAME(I1)
      L1B_2ATM(L) = L1A_ANAME(I2)
      L1B_I1ATM(L)= I1
      L1B_I2ATM(L)= I2
      L1B_TYPE(L) = TYPE
      L1B_VAL(L)  = VAL
      L1B_VOBS(L) = 0.0
      L1B_EVAL(L) = 0.0
      L1B_DEV (L) = 0.02
      RETURN
      END

      SUBROUTINE PUT_TO_ANGLE_LIST(MDOC,I1,I2,I3,VAL,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VAL
      INTEGER*4 MDOC,I1,I2,I3,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256
C --------------------------------------------------------
      IERR  = 0
      IF(I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) THEN
        RETURN
      ENDIF
      IF(L1G_NANGL.GE.MAX1ANG) THEN
        WRITE(LINE
     * ,'('' ERROR: number of angles of monomer >'',I6)') 
     *    MAX1ANG
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ANG in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF
      L1G_NANGL   = L1G_NANGL+1
      L           = L1G_NANGL
      L1G_1ATM(L) = L1A_ANAME(I1)
      L1G_2ATM(L) = L1A_ANAME(I2)
      L1G_3ATM(L) = L1A_ANAME(I3)
      L1G_I1ATM(L)= I1
      L1G_I2ATM(L)= I2
      L1G_I3ATM(L)= I3
      L1G_VAL(L)  = VAL
      L1G_VOBS(L) = 0.0
      L1G_EVAL(L) = 0.0
      L1G_DEV (L) = 3.0
      RETURN
      END


      SUBROUTINE W_CRD_LBC(MDOC,I)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
      CHARACTER LINE*256
C -----------------------------------------------
      write(LINE,
     *'(''>'',i3,''<'',a4,''>'',3f8.3,''<'',a1,''>'',3f8.2,''<'',a,
     *''>'')') 
     *     I
     *    ,L1A_ANAME (I) 
     *    ,L1A_X     (I)
     *    ,L1A_Y     (I) 
     *    ,L1A_Z     (I) 
     *    ,L1A_COOR_FLAG(I) 
     *    ,L1A_LENGTH(I)  
     *    ,L1A_THETA (I) 
     *    ,L1A_PHI   (I) 
     *    ,L1A_ID_PSI(I)
      CALL MSGDOC(MDOC,LINE)
      RETURN
      END

      SUBROUTINE ADD_DUMMY_ATOM(MDOC,LIST,ID,J,II,V3,AV3,ANG2
     *                         ,PH,IPHI0,IERR)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------------
      REAL      V3(3)
      CHARACTER LINE*80,CH8*8,LIST*1
C --------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
C ---------------------------
      L1A_NDUMMY = L1A_NDUMMY + 1
      IA = L1A_NATOM + L1A_NDUMMY

      IF(IA.GE.MAX1ATM) THEN
        WRITE(LINE
     * ,'('' ERROR : number of atoms of monomer >'',I6)') 
     *  MAX1ATM
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ATM in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF

C           I4(J),J,II,V3,AV3,ANG2,PH,IPHI0( =J FORW)
C           ID = ? ?I4(J)?
C            L1A_X     (ID)    = L1A_X(II)+V3(1)
C            L1A_LENGTH(ID)    = AV3
C            L1A_THETA (ID)    = ANG2/PI180
C            IF(PH.GT. PI) PH  = PH - TWOPI
C            IF(PH.LE.-PI) PH  = PH + TWOPI
C            L1A_PHI   (ID)    = PH  /PI180
C            L1A_ID_PSI(ID)    = 'Const'
C            L1A_COOR_FLAG(ID) = 'Y'

      L1A_COOR_FLAG(IA) = 'Y'
      L1A_CHARG    (IA) = 0.0
      L1A_X(IA) = L1A_X(II) + V3(1)
      L1A_Y(IA) = L1A_Y(II) + V3(2)
      L1A_Z(IA) = L1A_Z(II) + V3(3)
      L1A_LENGTH(IA) = AV3
      L1A_THETA (IA) = ANG2/PI180

      IF(LIST.EQ.'T') THEN
        WRITE(line,*)'add:',ia,L1A_X(ia),L1A_Y(ia),L1A_Z(ia)
        CALL MSGDOC(MDOC,LINE)
      ENDIF



      IF(PH.GE. TWOPI) PH  = PH - TWOPI
      IF(PH.LE.-TWOPI) PH  = PH + TWOPI
      IF(PH.GT.  PI  ) PH  = PH - TWOPI
      IF(PH.LE. -PI  ) PH  = PH + TWOPI
      L1A_PHI   (IA) = PH  /PI180
      L1A_ID_PSI(IA) = 'Const'
      L1A_INEW (IA) = IA 
      L1A_IOLD (IA) = IA
      L1A_ICR  (IA) = 0
      L1A_NDIST(IA) = 0

      L1A_IBACK(IA) = II
C      IF(IPHI0.EQ.J)  L1A_IBACK(IA) =-II

      L1A_IFORW(IA) = 0
      L1A_BACK (IA) = L1A_ANAME(II)
      L1A_TYPE (IA) = 'DUMMY'
      L1A_FORW (IA) = '.'
      L1A_ANAME(IA) = L1A_ANAME(ID)
      L1A_SYMB (IA) = L1A_SYMB (ID) 
      L1A_SF_ID(IA) = L1A_SF_ID(ID)
      L1A_CHEM (IA) = L1A_CHEM (ID)
      L1A_ATYPE(IA) = 'D'
      DO  JJ=1,MAX1BRN 
        L1A_CONN   (JJ,IA) = 0
        L1A_LENCON (JJ,IA) = 0
      ENDDO
      L1A_NEXTR(IA) = 1
      DO  JJ=1,MAX1EXT 
        L1A_IEXTR (JJ,IA) = 0
        L1A_TEXTR (JJ,IA) = 0
      ENDDO
      L1A_IEXTR (1,IA) = ID

      L1A_NRING(IA) = L1A_NRING(ID)
      IF(L1A_NRING(ID).GT.0) THEN
        DO IR=1,L1A_NRING(ID)
          L1A_RING_ID (IR,IA) = L1A_RING_ID (IR,ID) 
          L1A_RING_ORD(IR,IA) = L1A_RING_ORD(IR,ID)
        ENDDO
      ENDIF 
C      CH8 = 'dummy'
C      CALL PUT_TO_BOND_LIST(MDOC,IA,II,AV3,CH8,IERR)
C      IF(IERR.NE.0) RETURN

      RETURN
      END

      SUBROUTINE CP_VOBS_VLIB(MDOC,LIST,IMODE,IERR)
C -----------------------------------------------
C -P- 
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
      CHARACTER LINE*256,LIST*1
      CHARACTER SIGN*8,LABEL*8
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------------
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,'--CP_VOBS_VLIB--')
      ENDIF
      IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
c          IF(L1B_FLAG(IB).EQ.'C') THEN
            I1 = L1B_I1ATM(IB)
            I2 = L1B_I2ATM(IB)
            IF(I1.GT.0.AND.I2.GT.0) THEN
              CALL CALC_DOBS(I1,I2,DOBS)
              L1B_VOBS(IB) = DOBS
            ENDIF
            DEV  = ABS(L1B_VAL (IB) - L1B_VOBS(IB))
            TEST = L1B_DEV(IB)
            IF(LIST.EQ.'T'.OR.LIST.EQ.'L') TEST = -1.0
            IF(DEV.GT.TEST.AND.L1B_VAL(IB).GT.0.0) THEN
              WRITE(LINE,'(
     *     '' WARNING: bond '',A4,'' - '',A4,
     *     ''  delta (lib-coord) :'',F8.3)')
     *        L1B_1ATM(IB),L1B_2ATM(IB),DEV
              CALL MSGDOC(MDOC,LINE)
            ENDIF
            IF(IMODE.EQ.1) L1B_VAL (IB) = L1B_VOBS(IB)
c          ENDIF
        ENDDO 
      ENDIF
C ---
      IF(L1G_NANGL.GT.0) THEN
        DO IG=1,L1G_NANGL
c          IF(L1G_FLAG(IG).EQ.'C') THEN
            I1 = L1G_I1ATM(IG)
            I2 = L1G_I2ATM(IG)
            I3 = L1G_I3ATM(IG)
            IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0) THEN
              CALL CALC_ANGOBS(I1,I2,I3,DOBS)
              L1G_VOBS(IG) = DOBS
            ENDIF
            TEST = L1G_DEV(IG)
            IF(LIST.EQ.'T'.OR.LIST.EQ.'L') TEST = -1.0
            ITEMP=ABS(L1G_VOBS(IG))*10.0 +0.5
            DEV=ABS(L1G_VAL(IG) - L1G_VOBS(IG))
            TEMP=ITEMP/10.0
            IF(L1G_VOBS(IG).LT.0.0) TEMP=-TEMP
            IF(DEV.GT. 360.0) DEV=DEV-360.0
            IF(DEV.GT. 180.0) DEV=DEV-360.0
            IF(DEV.LE.-180.0) DEV=DEV+360.0
            DEV=ABS(DEV)
            IF(DEV.GT.TEST.AND.L1G_VAL(IG).GT.0.0) THEN
              WRITE(LINE,'(
     *     '' WARNING: angle '',A4,'' - '',A4,'' - '',A4,
     *     ''  delta (lib-coord) :'',F8.3)')
     *        L1G_1ATM(IG),L1G_2ATM(IG),L1G_3ATM(IG),DEV
              CALL MSGDOC(MDOC,LINE)
            ENDIF
            IF(IMODE.EQ.1) L1G_VAL(IG)  = TEMP
c          ENDIF
        ENDDO
      ENDIF
C ---
      IF(L1T_NTORS.GT.0) THEN
        DO IT=1,L1T_NTORS
c          IF(L1T_FLAG(IT).EQ.'C') THEN
            I1  = L1T_I1ATM(IT)
            I2  = L1T_I2ATM(IT)
            I3  = L1T_I3ATM(IT)
            I4  = L1T_I4ATM(IT)
            VAL = L1T_VAL(IT)
            LABEL = L1T_LABEL(IT)
            IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0.AND.I4.GT.0) THEN
              CALL CALC_TRSOBS(I1,I2,I3,I4,DOBS)
              IF(LIST.EQ.'T') THEN
                WRITE(LINE,'(I4,'' '',A,'' val,vobs:'',2F8.3)')
     *          IT,LABEL,VAL,DOBS
                CALL MSGDOC(MDOC,LINE)
              ENDIF
              IF(DOBS.LE.-359.9) DOBS = DOBS + 360.0
              IF(DOBS.LE.-179.9) DOBS = DOBS + 360.0
              IF(VAL.LE.-359.9)  VAL = VAL + 360.0
              IF(VAL.LE.-179.9)  VAL = VAL + 360.0
              IF(VAL.GT. 180.0) VAL = VAL - 360.0
              DEV = ABS(VAL - DOBS)
              IF(DEV.GT.90.0.AND.LABEL(1:6).EQ.'CONST_') THEN
                IF(ABS(ABS(VAL)-180.0).LT.90.0) THEN
                  VAL = 0.0
                ELSE IF(ABS(VAL).LT.90.0) THEN
                  VAL = 180.0
                ENDIF
              ENDIF
            ELSE
              DOBS = VAL
            ENDIF

C           L1T_VAL(IT)  = VAL
            L1T_VOBS(IT) = DOBS

            IPRD  = L1T_PRD (IT)
            ITEMP = ABS(L1T_VOBS(IT))*10.0 +0.5
            TEMP  = ITEMP/10.0
            IF(L1T_VOBS(IT).LT.0.0) TEMP=-TEMP
            IF(L1T_VAL(IT) .GT.-359.9) THEN
              DEV = ABS(L1T_VAL(IT) - L1T_VOBS(IT))
              IF(DEV.GT. 360.0) DEV=DEV-360.0
              IF(DEV.GT. 180.0) DEV=DEV-360.0
              IF(DEV.LE.-180.0) DEV=DEV+360.0
              DEV  = ABS(DEV)
              TEST = L1T_DEV(IT)
              IF(LIST.EQ.'T'.OR.LIST.EQ.'L') TEST = -1.0
              IF(DEV.GT.TEST) THEN
                WRITE(LINE,'(
     *       '' WARNING: tors '',A4,'' - '',A4,'' - '',A4,'' - '',A4,
     *       '' delta (lib-coord) :'',F8.3)')
     *          L1T_1ATM(IT),L1T_2ATM(IT),L1T_3ATM(IT),L1T_4ATM(IT),DEV
                CALL MSGDOC(MDOC,LINE)
              ENDIF
            ENDIF

            IF(IMODE.EQ.1.OR.IMODE.EQ.2) L1T_VAL(IT)  = TEMP

c          ENDIF
        ENDDO
      ENDIF
C ---
      IF(L1C_NCHIR.GT.0) THEN
        DO IC=1,L1C_NCHIR
c          IF(L1C_FLAG(IC).EQ.'C') THEN
          IF(L1C_SIGN(IC)(1:4).NE.'star'.AND.
     *       L1C_SIGN(IC)(1:4).NE.'cros'     ) THEN

            I1 = L1C_I1ATM(IC)
            I2 = L1C_I2ATM(IC)
            I3 = L1C_I3ATM(IC)
            I4 = L1C_I4ATM(IC)
            IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0.AND.I4.GT.0) THEN
              CALL CALC_OVOL(IC,DOBS,IERR)
              IERR = 0
              L1C_VOBS(IC) = DOBS
            ENDIF
            DEV  = 1.0
            VOL  = L1C_VOL(IC)
            SIGN = L1C_SIGN(IC) 
            IF(SIGN(1:3).EQ.'neg') VOL=-VOL
            DEV = ABS( VOL- L1C_VOBS(IC) ) 
c           L1C_VOL(IC) = L1C_VOBS(IC) 
            IF(IMODE.EQ.1.OR.IMODE.EQ.2.OR.IMODE.EQ.3) THEN
              IF(SIGN(1:3).EQ.'bot'.OR.SIGN(1:3).EQ.'neg'.OR.
     *                                 SIGN(1:3).EQ.'pos'     ) THEN
                IF(L1C_VOBS(IC).GE.0.0) THEN
                  L1C_SIGN(IC) = 'positiv'    
                ELSE
                  L1C_SIGN(IC) = 'negativ'
                ENDIF
              ENDIF    
            ENDIF
            TEST = 1.0
            IF(LIST.EQ.'T'.OR.LIST.EQ.'L') TEST = -1.0
            IF(DEV.GT.TEST) THEN
              WRITE(LINE,'(
     *     '' WARNING: chiral centre  '',A4,
     *     ''   has volume delta (lib-coord) :'',F8.3)')
     *        L1C_1ATM(IC),DEV
              CALL MSGDOC(MDOC,LINE)

            ENDIF
          ENDIF
        ENDDO
      ENDIF
      IF(L1P_NPLAN.GT.0) THEN
        DEV  = 0.02
        TEST = DEV
        IF(LIST.EQ.'T'.OR.LIST.EQ.'L') TEST = -1.0
        CALL PLAN_RSTR(MDOC,IERR)
        DO  IP=1,L1P_NPLAN
          DO  I = 1,L1P_NATOM(IP)
            IF(ABS(L1P_DOBS(I,IP)).GT.TEST) THEN
              IATOM=L1P_ATOM(I,IP)
              WRITE(LINE,'(
     *     '' WARNING: atom '',A4,'' '',A,
     *     ''    displacement :'',F8.3,I4)')
     *        L1P_LABEL(IP),L1P_ATOM(I,IP),L1P_DOBS(I,IP)
     *        ,L1P_IATOM(I,IP)
              CALL MSGDOC(MDOC,LINE)
            ENDIF
          ENDDO
        ENDDO
      ENDIF
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,'--END CP_VOBS_VLIB--')
      ENDIF
      RETURN
      END


      SUBROUTINE ADD_VBOND(MDOC,MON,I1,I2,IERR)
C -----------------------------------------------
C -P- SET_VBOND - 
C -S-
      INTEGER*4 MDOC,I1,I2,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
      CHARACTER CHEM1*4,CHEM2*4,LINE*256,BTYPE*8
      CHARACTER ECHEM1*4,ECHEM2*4
      REAL      DLIM1(4),DLIM2(4),DEFD(4)
      INTEGER*4 ICH4
      CHARACTER CIATOM*1,CJATOM*1
      CHARACTER ASYMB*4,CTYPE*4,CH4*4
      EQUIVALENCE (ICH4,CH4)
      DATA DLIM1/ 0.75 , 1.10 , 1.50 , 1.8 /
      DATA DLIM2/ 1.2  , 1.90 , 2.50 , 3.0 /
      DATA DEFD / 0.96 , 1.45 , 1.80 , 2.5 /
C --------------------------------------------------------
      M     =-ABS(MDOC)-1
      ICOOR = 0
      IF(I1.LE.0.OR.I2.LE.0) RETURN
      IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y') THEN
        CALL CALC_DOBS(I1,I2,DOBS)
        ICOOR = 1
      ELSE
        DOBS = 0.0
      ENDIF
      CALL SRCH_BOND(MDOC,MON,I1,I2,VAL,L,IERR)
      IF(IERR.NE.0) THEN
        IF(L1B_NBOND.GE.MAX1BND) THEN
          WRITE(LINE
     * ,'('' ERROR: number of bonds of monomer >'',I6)') 
     *    MAX1BND
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1BND in "lib_com.fh"')
          IERR = 1
          RETURN
        ENDIF
        L1B_NBOND   = L1B_NBOND+1
        L           = L1B_NBOND
        L1B_1ATM(L) = L1A_ANAME(I1)
        L1B_2ATM(L) = L1A_ANAME(I2)
        L1B_TYPE(L) = 'coval'
        BTYPE       = 'coval'
        L1B_DEV (L) = 0.02
        L1B_VAL (L) = 0.0
        L1B_EVAL(L) = 0.0
        IERR        = 0
      ELSE
        BTYPE       = L1B_TYPE(L)
      ENDIF
      L1B_I1ATM(L)= I1
      L1B_I2ATM(L)= I2
      L1B_VOBS(L) = DOBS

      IF(ICOOR.EQ.1) L1B_FLAG(L)='C'

      CHEM1 = L1A_CHEM(I1)
      CHEM2 = L1A_CHEM(I2)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '


      IDEF_TYPE = 0
      DIST1     = 0.0
      DIST2     = 0.0
      DIST3     = 0.0
      DO J=1,LEB_NBOND

        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEB_2ATM(J) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '

        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2).OR.
     *     (ECHEM1.EQ.CHEM2.AND.ECHEM2.EQ.CHEM1)) THEN
          IF((BTYPE.EQ.'.'.AND.LEB_TYPE(J).EQ.'.').OR.
     *       (BTYPE(1:4).EQ.LEB_TYPE(J)(1:4)     )    ) THEN
            L1B_EVAL(L) = LEB_LENGTH(J) 
            GO TO 100
          ENDIF
          IF(LEB_TYPE(J).EQ.'.') THEN
            DIST1     = LEB_LENGTH(J)
            IDEF_TYPE = 1 
          ELSE IF(LEB_TYPE(J)(1:4).EQ.'sing') THEN
            DIST2     = LEB_LENGTH(J)
            IDEF_TYPE = 2 
          ELSE
            DIST3     = LEB_LENGTH(J)
            IDEF_TYPE = 3 
          ENDIF     
        ENDIF
      ENDDO

      IF(IDEF_TYPE.GT.0) THEN
        IF(IDEF_TYPE.EQ.1) DIST3 = DIST1
        IF(IDEF_TYPE.EQ.2) DIST3 = DIST2
        L1B_EVAL(L)= DIST3
        GO TO 100
      ENDIF


      D1 = 0.0
      D2 = 0.0
      DO J=1,LEB_NBOND
        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        IF(ECHEM1.EQ.CHEM1.AND.LEB_2ATM(J)(1:1).EQ.'.') THEN
          D1 = LEB_LENGTH(J) 
        ENDIF
        IF(ECHEM1.EQ.CHEM2.AND.LEB_2ATM(J)(1:1).EQ.'.') THEN
          D2 = LEB_LENGTH(J) 
        ENDIF
      ENDDO
      IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
        VAL         = (D1+D2)/2.0
        L1B_EVAL(L) = VAL 
      ENDIF

  100 CONTINUE
      RETURN
      END

      SUBROUTINE ADD_VANGL(MDOC,MON,I1,I2,I3,IERR)
C -----------------------------------------------
C -P- SET_VANGL - 
C -S-
      INTEGER*4 MDOC,I1,I2,I3,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,LINE*256
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
      M     =-ABS(MDOC)-1  
      ICOOR = 0
      IF(I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) RETURN
      IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *   L1A_COOR_FLAG(I3).EQ.'Y') THEN
        CALL CALC_ANGOBS(I1,I2,I3,ANGOBS)
        ICOOR = 1
      ELSE
        ANGOBS = 0.0
      ENDIF
      CALL SRCH_ANGL(MDOC,MON,I1,I2,I3,VAL,L,IERR)
      IF(IERR.NE.0) THEN
        IF(L1G_NANGL.GE.MAX1ANG) THEN
          WRITE(LINE
     * ,'('' ERROR: number of angles of monomer >'',I6)') 
     *    MAX1ANG
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ANG in "lib_com.fh"')
          IERR = 1
          RETURN
        ENDIF
        L1G_NANGL   = L1G_NANGL+1
        L           = L1G_NANGL
        L1G_1ATM(L) = L1A_ANAME(I1)
        L1G_2ATM(L) = L1A_ANAME(I2)
        L1G_3ATM(L) = L1A_ANAME(I3)
        L1G_VAL(L)  = 0.0
        L1G_EVAL(L) = 0.0
        L1G_DEV(L)  = 3.0
        IERR        = 0
      ENDIF
      L1G_I1ATM(L)= I1
      L1G_I2ATM(L)= I2
      L1G_I3ATM(L)= I3
      L1G_VOBS(L) = ANGOBS

      IF(ICOOR.EQ.1) L1G_FLAG(L) = 'C'

      CHEM1 = L1A_CHEM(I1)
      CHEM2 = L1A_CHEM(I2)
      CHEM3 = L1A_CHEM(I3)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '

      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2.AND.
     *                               ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM1.EQ.CHEM3.AND.ECHEM2.EQ.CHEM2.AND. 
     *                               ECHEM3.EQ.CHEM1)) THEN
          L1G_EVAL(L) = LEG_ANGLE(I) 
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF(ECHEM1(1:1).EQ.'.'  .AND.
     *     ECHEM2     .EQ.CHEM2.AND.
     *     ECHEM3(1:1).EQ.'.') THEN
          VAL = LEG_ANGLE(I) 
          IF(VAL.GT.0.0) THEN
            L1G_EVAL(L) = VAL
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
  100 CONTINUE
      RETURN
      END            

      SUBROUTINE ADD_VTORS(MDOC,I1,I2,I3,I4,IPERIOD,NV,NC,IERR)
C -----------------------------------------------
C -P- SET_VANGL - 
C -S-
      INTEGER*4 MDOC,I1,I2,I3,I4,NV,IERR
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
      INTEGER   IRING(4)
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,CHEM4*4,LINE*256
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4,ECHEM4*4
      CHARACTER RING1*3,RING2*3,RING3*3,RING4*3,LABEL*8,MON*8
C --------------------------------------------------------
      INEW = 0
      IOBS = 0
      INV  = 1
     
      IF(I1.LE.0 .OR.I2.LE.0 .OR.I3.LE.0 .OR.I4.LE.0 .OR.
     *   I1.EQ.I2.OR.I1.EQ.I3.OR.I1.EQ.I4.OR.I2.EQ.I3.OR.
     *               I2.EQ.I4.OR.I3.EQ.I4 ) RETURN

      IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *   L1A_COOR_FLAG(I3).EQ.'Y'.AND.L1A_COOR_FLAG(I4).EQ.'Y') THEN
        CALL CALC_TRSOBS(I1,I2,I3,I4,ANGOBS)
        IOBS = 1
      ELSE
        ANGOBS =180.0
      ENDIF

      MON = ' '
      CALL SRCH_TORS(MDOC,MON,I1,I2,I3,I4,VAL,L,INV,IERR)
      IF(IERR.NE.0) THEN
        IF(L1T_NTORS.GE.MAX1TOR) THEN
          WRITE(LINE
     * ,'('' ERROR: number of tors. angles of monomer >'',I6)') 
     *    MAX1TOR
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1TOR in "lib_com.fh"')
          IERR = 1
          RETURN
        ENDIF
C       IF(L1T_NTORS <
        L1T_NTORS   = L1T_NTORS+1
        L           = L1T_NTORS
        L1T_1ATM(L) = L1A_ANAME(I1)
        L1T_2ATM(L) = L1A_ANAME(I2)
        L1T_3ATM(L) = L1A_ANAME(I3)
        L1T_4ATM(L) = L1A_ANAME(I4)
        L1T_I1ATM(L) = I1
        L1T_I2ATM(L) = I2
        L1T_I3ATM(L) = I3
        L1T_I4ATM(L) = I4
        L1T_VAL (L) =-360.0
        L1T_DEV (L) = 20.0
        L1T_PRD (L) = 1
        NV          = NV+1
        WRITE(CHEM1,'(I4)') NV
        N = 4
        IF(CHEM1(1:1).EQ.' ') N=3 
        IF(CHEM1(2:2).EQ.' ') N=2 
        IF(CHEM1(3:3).EQ.' ') N=1 
        LINE(1:4)    = 'var_'
        LINE(5:N+4)  = CHEM1(5-N:4)
        L1T_LABEL(L) = LINE(1:N+4)
        INEW         = 1
        IERR         = 0
        L1T_VOBS(L)  = ANGOBS
      ELSE

        IF(INV.LT.0) THEN
          L1T_1ATM(L) = L1A_ANAME(I1)
          L1T_2ATM(L) = L1A_ANAME(I2)
          L1T_3ATM(L) = L1A_ANAME(I3)
          L1T_4ATM(L) = L1A_ANAME(I4)
        ENDIF
        IF(L1T_PRD (L).GT.0) THEN

          NV = NV+1
          IF(L1T_LABEL(L)(1:4).EQ.'var_') THEN
            WRITE(CHEM1,'(I4)') NV
            N = 4
            IF(CHEM1(1:1).EQ.' ') N=3 
            IF(CHEM1(2:2).EQ.' ') N=2 
            IF(CHEM1(3:3).EQ.' ') N=1 
            LINE(1:4)    = 'var_'
            LINE(5:N+4)  = CHEM1(5-N:4)
            L1T_LABEL(L) = LINE(1:N+4)
          ENDIF
        ELSE
          NC = NC+1
        ENDIF
        L1T_I1ATM(L) = I1
        L1T_I2ATM(L) = I2
        L1T_I3ATM(L) = I3
        L1T_I4ATM(L) = I4
      ENDIF
      IPRD         = L1T_PRD (L)
      VAL          = L1T_VAL (L)
      LABEL        = L1T_LABEL(L)
C --
      CHEM1 = L1A_CHEM(I1)
      CALL CHECK_RING(CHEM1,RING1)
      CHEM2 = L1A_CHEM(I2)
      CALL CHECK_RING(CHEM2,RING2)
      CHEM3 = L1A_CHEM(I3)
      CALL CHECK_RING(CHEM3,RING3)
      CHEM4 = L1A_CHEM(I4)
      CALL CHECK_RING(CHEM4,RING4)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '
      IF(L1A_SYMB(I4).EQ.'H   '.OR.L1A_SYMB(I4).EQ.'D   ') CHEM4='H   '
      IS = 1
      DO I=1,LET_NTORS

        ECHEM1 = LET_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LET_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LET_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '
        ECHEM4 = LET_4ATM(I) 
        CALL LENSTR_BL(ECHEM4,LN)
        IF(ECHEM4(1:1).EQ.'H'.AND.LN.GT.2) ECHEM4='H   '

        IF((ECHEM2.EQ.CHEM2.AND.ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM2.EQ.CHEM3.AND.ECHEM3.EQ.CHEM2)) THEN

          IF(ECHEM2.EQ.CHEM3.AND.ECHEM3.EQ.CHEM2) IS=-1
          L1T_VAL(L) = LET_ANGLE(I)*IS
          L1T_PRD(L) = LET_PRD  (I) 
          IF(LET_CONST(I).GT.2.0) THEN
            L1T_LABEL(L)='CONST'
            IF(RING2(1:1).EQ.'R'.AND.RING3(1:1).EQ.'R') THEN
              IF(RING2(2:2).EQ.'R'.AND.RING2(2:2).EQ.RING3(2:2)) THEN 
                L1T_VAL(L) = 180.0
                IF(RING2(3:3).EQ.'5'.AND.RING1(2:2).EQ.RING4(2:2)) 
     *          L1T_VAL(L) = 0.0
              ELSE IF(RING2(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING4(1:1).EQ.'R') THEN 
                  L1T_VAL(L) = 180.0
                ELSE
                  L1T_VAL(L) = 0.0
                ENDIF
              ELSE IF(RING3(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING1(1:1).EQ.'R') THEN 
                  L1T_VAL(L) = 180.0
                ELSE
                  L1T_VAL(L) = 0.0
                ENDIF
              ELSE
                IF(RING1(1:1).EQ.RING4(1:1)) THEN 
                  L1T_VAL(L) = 0.0
                ELSE
                  L1T_VAL(L) = 180.0
                ENDIF
              ENDIF
            ENDIF
            IF(IOBS.EQ.1) THEN
              DEL = ABS(L1T_VAL(L)-ANGOBS)
              IF(DEL.GT.90.0.AND.DEL.LT.270.0) THEN
                L1T_VAL(L) = L1T_VAL(L) + 180.0
                IF(L1T_VAL(L).GE.360.0) L1T_VAL(L) = L1T_VAL(L)-360.0
              ENDIF
            ENDIF
          ELSE
            L1T_VAL(L) = 0.0 
C            NV=NV+1
            WRITE(CHEM1,'(I4)') NV
            N = 4
            IF(CHEM1(1:1).EQ.' ') N=3 
            IF(CHEM1(2:2).EQ.' ') N=2 
            IF(CHEM1(3:3).EQ.' ') N=1 
            LINE(1:4)    = 'var_'
            LINE(5:N+4)  = CHEM1(5-N:4)
            L1T_LABEL(L) = LINE(1:N+4)
          ENDIF
          GO TO 100
        ENDIF
      ENDDO
      L1T_VAL(L) = 0.0
      L1T_PRD(L) = 1 
C      NV=NV+1
      WRITE(CHEM1,'(I4)') NV
      N = 4
      IF(CHEM1(1:1).EQ.' ') N=3 
      IF(CHEM1(2:2).EQ.' ') N=2 
      IF(CHEM1(3:3).EQ.' ') N=1 
      LINE(1:4)    = 'var_'
      LINE(5:N+4)  = CHEM1(5-N:4)
      L1T_LABEL(L) = LINE(1:N+4)
C ---
 100  CONTINUE
      L1T_EVAL(L) = L1T_VAL(L)
      IF(L1T_EVAL(L).LE.-180.0) L1T_EVAL(L) = L1T_EVAL(L)+360.0
      L1T_VAL  (L) = VAL
      L1T_VOBS (L) = ANGOBS
      L1T_LABEL(L) = LABEL
      L1T_PRD  (L) = IPRD

      IF(IOBS.EQ.1) L1T_FLAG(L) = 'C'

      CALL CHECK_RING_ID(MDOC,I1,I2,I3,I4,ID,PHI,IERR)
      LINE = L1T_LABEL(L)
      IF(LINE(1:5).EQ.'CONST') THEN
        IF(ABS(ID).GT.0) THEN
          L1T_VAL(L) = PHI
          IF(IOBS.EQ.0) L1T_VOBS(L) = PHI
        ENDIF
        IPERIOD = 0
      ELSE
        IF(IOBS.EQ.0) THEN
          IF(ID.GT.0) THEN
            L1T_VAL(L)  = PHI
            L1T_VOBS(L) = PHI
          ENDIF
        ENDIF
        IPERIOD = 1
      ENDIF

      RETURN
      END            

      SUBROUTINE GETLIB_FOR_ADD(MMDOC,LIST,NUMB_LIB,NODIST
     *            ,LIBE_PATH,LIBE_NAME,LIBE_EXT,LIB_IND
     *            ,LIB2_NAME,LIBA_NAME,FILE_LIB_OUT,IERR)
C -------------------------------------------------------
C ---
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      CHARACTER LIBE_NAME*(*),LIBE_PATH*(*),LIBE_EXT*(*),LIB_IND*(*)
      CHARACTER LIB2_NAME*(*),LIBA_NAME*(*),FILE_LIB_OUT*(*)
      INTEGER*4 MDOC,IERR,NUMB_LIB
      CHARACTER MOD*1,CHAR1*1,LIST*1,NODIST*1
C ----------------------------------------------
      IERR = 0
      MDOC = MMDOC
      MMM  = MDOC
      IF(LIST.EQ.'S') THEN
        MDOC = 999
        MMM  = MDOC
      ELSE IF(LIST.EQ.'M') THEN
        MMM = 999
      ENDIF
C ---
C
      CALL INITLIB_FOR_ADD(MMM,NUMB_LIB
     *            ,LIBE_PATH,LIBE_NAME,LIBE_EXT,LIB_IND
     *            ,LIB2_NAME,LIBA_NAME,FILE_LIB_OUT,IERR)
      IF(IERR.NE.0) RETURN
C ---
C     read list of all monomers in the library. 

      LB_TFLAG = 'N'
      CALL GET_LLIST(MDOC,IERR)    
      IF(IERR.NE.0) RETURN
      MOD   = 'N'
      CHAR1 = 'N'
      CALL SSET_FUSE(MOD,CHAR1)
C  ---
C     read ener_lib.cif
      CALL MSGDOC(MDOC,' I am reading libraries. Please wait.')
      MOD = 'E'
      CALL READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
      IF(IERR.NE.0) RETURN
C     read mon_lib.cif (links & mod )
      CALL MSGDOC(MDOC,'     - monomer"s description (links & mod )')
      MOD = 'N'
      CALL READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
      IF(IERR.NE.0) RETURN
C ---
      RETURN
      END

      SUBROUTINE INITLIB_FOR_ADD(MDOC,NUMB_LIB
     *            ,LIBE_PATH,LIBE_NAME,LIBE_EXT,LIB_IND
     *            ,LIB2_NAME,LIBA_NAME,FILE_LIB_OUT,IERR)
C -------------------------------------------------------
C -P- INITLIB - initialization of common blocks of library.
C -S-
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,NUMB_LIB
      CHARACTER LIB2_NAME*(*),LIBA_NAME*(*),FILE_LIB_OUT*(*)
      CHARACTER LIBE_NAME*(*),LIBE_PATH*(*),LIBE_EXT*(*),LIB_IND*(*)
C ******
      CHARACTER LINE*256
      INTEGER*4 IL,I,LEN
C -----------------------------------
      IERR=0
C -----------------------------------
      IS = LMB_TOTAL * 4
      WRITE(LINE,'('' Size of lib_com.fh(bytes) :'',I10)') IS
      CALL MSGDOC(MDOC,LINE)
C -----------------------------------
      NUMB_LIB     = 1
      LB_NUMB_LIB  = 1

      LMI_FILE(1)  = LIBA_NAME
      LMI_FILE(2)  = 'Y'
      LMI_PATH     = ' '
      LMI_EXT      = ' '

      LEI_FILE = ' '
      LEI_PATH = ' '
      LEI_EXT  = ' '

      LIBE_NAME    = 'ener_lib'
      LIBE_EXT     = 'cif'

      CALL LENSTR_BL(LIBE_NAME,LEN)
      IF(LEN.GT.0.AND.LIBE_NAME(1:1).NE.','.AND.
     *                LIBE_NAME(1:1).NE.' ') THEN
        LEI_FILE = LIBE_NAME
        LEI_PATH = LIBE_PATH
        LEI_EXT  = LIBE_EXT
      ENDIF

      LMI2_FILE = LIB2_NAME
      LMI2_PATH = ' '
      LMI2_EXT  = ' '

      LIN_FILE = ' '
      LIN_PATH = ' '
      LIN_EXT  = ' '
      CALL LENSTR_BL(LIB_IND,LEN)
      IF(LEN.GT.0.AND.LIB_IND(1:1).NE.','.AND.
     *                LIB_IND(1:1).NE.' ') THEN
        LIN_FILE = LIB_IND
      ENDIF

      LMO_FILE = FILE_LIB_OUT
      LMO_PATH = ' '
      LMO_EXT  = 'lib'

      LEO_FILE = ' '
      LEO_PATH = ' '
      LEO_EXT  = ' '
      LMI_IUN  = 0
      LMI2_IUN = 0
      LMO_IUN  = 0
      LEI_IUN  = 0
      LEO_IUN  = 0
      LSI_IUN  = 0
      LSI_PATH = ' '
      LSI_FILE = ' '
      LSI_EXT  = ' '
      IERR=0
C -----------------------------------
C     initialization counters of library
      LB_NAME     = '?'
      LB_VERS     = '?'
      LB_DATE     = '?'
      LB2_NAME    = '?'
      LB2_VERS    = '?'
      LB2_DATE    = '?'
      LB_PASS     = 0
      LML_NMON    = 0
      LML_NPRSNT  = 0
      LML_IMON    = 0
      LMX_NMON    = 0
      LMS_NSYN    = 0
      LMS_NEW     = 0
      LMS_ISYN    = 0
      LDR_NDER    = 0
      LDR_IDER    = 0
      LMR_NREC    = 0
      LB_HFLAG    = 'N'
      LB_TFLAG    = 'N'
      LSO_NSYM    = 1
      LSO_SYMOP(1)= 'X,Y,Z'
      LSF_NASYMB  = 0
      DO   I=1,MAXMLIST
        LML_ISYN (I) = 0
        LML_IDER (I) = 0
        LML_IMMON(I) = 0
        LML_ILMON(I) = 0
      ENDDO
      DO   I=1,MAXMLIST
        LML_PASS (I) = 0
        LML_NATM (I) = 0
        LML_NHATM(I) = 0
        LML_MNAME(I) = '?'
        LML_MNAME2(I)= '?'
        LML_NAME (I) = '?'
        LML_FORM (I) = '?'
        LML_CODE1(I) = '?'
        LML_TYPE (I) = '?'
        LML_MODE (I) = '?'
        LML_FUSE (I) = 'N'
        LML_PRSNT(I) = 'N'
      ENDDO
      LLL_NLINK = 0
      LLL_ILINK = 0
      DO   I=1,MAXLLNK
        LLL_LNAME  (I) = '?'
        LLL_DETAIL (I) = '?'
        LLL_CODE1  (I) = '?'
        LLL_MOD1   (I) = '?'
        LLL_MON1   (I) = '?'
        LLL_FLAG1  (I) = 0
        LLL_TYPE1  (I) = '?'
        LLL_MOD2   (I) = '?'
        LLL_MON2   (I) = '?'
        LLL_FLAG2  (I) = 0
        LLL_TYPE2  (I) = '?'
        LLL_FUSE   (I) = 'N'
      ENDDO
      LDL_NMOD  = 0
      LDL_IMOD  = 0
      DO   I=1,MAXDMDF
        LDL_MNAME  (I) = '?'
        LDL_DETAIL (I) = '?'
        LDL_COMP   (I) = '?'
        LDL_TYPE   (I) = '?'
        LDL_ORDER  (I) = 0
        LDL_FUSE   (I) = 'N'
      ENDDO
      CALL INIT_CNT
C ----------------------------------
      RETURN
      END     

      SUBROUTINE CHECK_ALL_MON(MDOC,LIST,REF,ITEST
     *              ,MON,VANGLE,FILE_O
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *     ,COOR,LCOOR,SRCH,NODIST,IERR)
C -----------------------------------------------------
C
C       one monomer checking
C
C -------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      INTEGER*4 IERR,MDOC
      CHARACTER MON*8,FILE_O*(*),SRCH*1,NODIST*1,COOR*1,LCOOR*1
      integer   natommax,natom
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      integer   ntorsmax
      integer   ntors,ltors_period(ntorsmax)
      integer   ltors_atom(4,ntorsmax)
      real      ltors(2,ntorsmax)
C ---------
      CHARACTER LINE*256
      CHARACTER CH1*1,CHAR1*1,MODE*4,LIST*1,REF*1
C -----------------------------------------------
      IERR = 0
C
C     set LML_FUSE(I) = 'N'
C ----
      REF = 'N'
      DO IM=1,LML_NMON

        MON   = LML_MNAME(IM)

        WRITE(LINE,*) '=== mon:',mon,';'
        CALL MSGDOC(MDOC,LINE)

        CH1   = 'N'
        CHAR1 = ' '
        CALL SSET_FUSE(CH1,CHAR1)

        CALL LENSTR_BL(FILE_O,L)
        IF(L.GT.0.AND.FILE_O(1:1).NE.' '.AND.FILE_O(1:1).NE.',') THEN
          LMO_FILE = FILE_O
          LMO_PATH = ' '
          LMO_EXT  = 'lib'
        ELSE
          LMO_FILE = 'libcheck'
          LMO_PATH = ' '
          LMO_EXT  = 'lib'
        ENDIF
C ----
        CALL CHECK_MON(MDOC,LIST,REF,ITEST,MON,VANGLE,SRCH,NODIST
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *                            ,COOR,LCOOR,IERR)
        IF(IERR.NE.0) IERR = 0

      ENDDO
C ---
c
c      CALL WRITE_LIST_MON(MDOC,IERR)
c
 100  CONTINUE
      MON = '?'
      RETURN
      END

      SUBROUTINE WRT_LIB_MON_NEW_STYLE(MDOC,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      INCLUDE 'crd_com.fh'
C -----------------------------------
      CHARACTER LINE*256
      CHARACTER NAME*80,PATH*80,EXT*3,CHAR1*1,MON*8,HTML*1
C -----------------------------------
      M    = 99
C --------------------------
      HTML = 'Y'
      CALL WRT_LIB_LIST_NEW_STYLE(MDOC,IUN,HTML,IERR)

      IF(LLL_NLINK.GT.0) THEN
        DO I=1,LLL_NLINK
          MON = LLL_LNAME(I)
          CALL LENSTR_BL(MON,LEN)
          IF(LLL_FUSE(I).NE.'?'.AND.LEN.GT.0) THEN
            IF(HTML.EQ.'Y') THEN
              LINE = '<h2><a name="'//MON(1:LEN)//
     *                  '" id="'//MON(1:LEN)//'"></a>--- '//MON(1:LEN)//
     *                  ' ---</h2>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              LINE = '<pre>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF

            CALL WRT_DESRC_ONE_LINK(MDOC,IUN,I,IERR)

            IF(HTML.EQ.'Y') THEN
              LINE = '</pre>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF
          ENDIF
        ENDDO
      ENDIF

      IF(LDL_NMOD.GT.0) THEN

        DO I=1,LDL_NMOD
          MON = LDL_MNAME(I)
          CALL LENSTR_BL(MON,LEN)
          IF(LDL_FUSE(I).NE.'?'.AND.LEN.GT.0) THEN
            IF(HTML.EQ.'Y') THEN
              LINE = '<h2><a name="'//MON(1:LEN)//
     *                  '" id="'//MON(1:LEN)//'"></a>--- '//MON(1:LEN)//
     *        ' ---</h2>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              LINE = '<pre>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF

            CALL WRT_DESRC_ONE_MODIFICATION(MDOC,IUN,I,IERR)

            IF(HTML.EQ.'Y') THEN
              LINE = '</pre>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF
          ENDIF
        ENDDO

      ENDIF

      IF(HTML.EQ.'Y') THEN
        LINE = '</BODY>'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE = '</HTML>'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
      ENDIF

      END FILE IUN
      CLOSE(IUN)
C ----------------------------------------
      HTML = 'N'
      CALL WRT_LIB_LIST_NEW_STYLE(MDOC,IUN,HTML,IERR)

      IF(LLL_NLINK.GT.0) THEN
        DO I=1,LLL_NLINK
          MON = LLL_LNAME(I)
          CALL LENSTR_BL(MON,LEN)
          IF(LLL_FUSE(I).NE.'?'.AND.LEN.GT.0) THEN
            IF(HTML.EQ.'Y') THEN
              LINE = '<pre>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF

            CALL WRT_DESRC_ONE_LINK(MDOC,IUN,I,IERR)

            IF(HTML.EQ.'Y') THEN
              LINE = '</pre>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF
          ENDIF
        ENDDO
      ENDIF

      IF(LDL_NMOD.GT.0) THEN

        DO I=1,LDL_NMOD
          MON = LDL_MNAME(I)
          CALL LENSTR_BL(MON,LEN)
          IF(LDL_FUSE(I).NE.'?'.AND.LEN.GT.0) THEN
            IF(HTML.EQ.'Y') THEN
              LINE = '<pre>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF

            CALL WRT_DESRC_ONE_MODIFICATION(MDOC,IUN,I,IERR)

            IF(HTML.EQ.'Y') THEN
              LINE = '</pre>'
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF
          ENDIF
        ENDDO

      ENDIF

      IF(HTML.EQ.'Y') THEN
        LINE = '</BODY>'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE = '</HTML>'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
      ENDIF

      END FILE IUN
      CLOSE(IUN)
C ----------------------------------------

      IF(LML_NMON.GT.0) THEN

        DO I=1,LML_NMON
          MON = LML_MNAME(I)
          CALL LENSTR_BL(MON,LEN)
          IF(LML_FUSE(I).NE.'?'.AND.LEN.GT.0) THEN
          CHAR1 = MON(1:1)
          IMODE = -1
          CALL CHECK_LINE(IMODE,CHAR1)
C ---
C           CHECK_LINE - check and convert symbols of line.
C                 MODE  0  only check
C                      -1  convert symbols to low case.
C                       1  to upper
C ---
            IUN  = 11
            IUN  = CRO3_IUN
            NAME = MON(1:LEN)
            IF( NAME.EQ.'CON') NAME  ='CON_CON' 
            IF( NAME.EQ.'COM')  NAME ='COM_COM' 
            IF( NAME.EQ.'PRN')  NAME ='PRN_PRN' 
            PATH = CHAR1//'/'
            EXT = 'cif'
            CALL OPENFW(IUN,M,PATH,NAME,EXT,IERR) 
            IF(IERR.NE.0) THEN
              CALL MSGERR(MDOC,' ERROR: can''t open output_lib_file')
              RETURN
            ENDIF

            LINE = 
     *        '<!DOCTYPE HTML PUBLIC "-//W#C//DTD HTML 3.2 FINAL//EN">'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE = '<HTML>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE = '<HEAD>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE = '<TITLE>monomer_description</TITLE>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE = '</HEAD>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE = '<body>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE = '<pre>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            IFIRST_M = 0
            CALL WRT_TITLE_MONOMER(MDOC,IUN,I,IFIRST_M,IERR)

            CALL WRT_DESRC_ONE_MONOMER(MDOC,IUN,I,IERR)

            LINE = '</pre>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE = '</BODY>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE = '</HTML>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            END FILE IUN
            CLOSE(IUN)

          ENDIF
        ENDDO

      ENDIF
C -----------------------------------
      RETURN
      END     
C ******

      SUBROUTINE WRT_LIB_LIST_NEW_STYLE(MDOC,IUN,HTML,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------
      CHARACTER LINE*256
      CHARACTER TITLE_M*80,NAME*80,PATH*80,EXT*80,HTML*1
      CHARACTER DATA*80
      CHARACTER WATOM1*6,WATOM2*6
C -----------------------------------
      M = 99

      IUN  = 11
      IUN  = CRO3_IUN
      NAME = 'mon_lib_list'
      PATH = 'list/'
      IF(HTML.EQ.'Y') THEN
        EXT  = 'html'
      ELSE
        EXT  = 'cif'
      ENDIF

      CALL OPENFW(IUN,M,PATH,NAME,EXT,IERR) 
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: can''t open output_lib_file')
        RETURN
      ENDIF

      IF(HTML.EQ.'Y') THEN
      LINE = 
     *        '<!DOCTYPE HTML PUBLIC "-//W#C//DTD HTML 3.2 FINAL//EN">'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<HTML>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<HEAD>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<TITLE>mon_lib_list</TITLE>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '</HEAD>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<body>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<pre>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      ENDIF
C ---------------

      WRITE(LINE,'(''global_'')') 
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_lib_name   '',6X,A)') LB_NAME(1:16)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_lib_version'',6X,A)') LB_VERS(1:16)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_lib_update '',6X,A)') LB_DATE(1:16)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      IF(HTML.EQ.'Y') THEN
      LINE = '</pre>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---
      LINE = '<h2>CONTENTS</h2>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<ul>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<li><a href="#mon"><b>List of monomers</b></a>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<li><a href="#rec"><b>'//
     *       'List of recognized modified monomers</b></a>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<li><a href="#syn"><b>List of synonyms</b></a>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<li><a href="#mod"><b>List of modifications</b></a>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '<li><a href="#link"><b>List of links</b></a>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE = '</ul>'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      ENDIF
C ---
      TITLE_M = '# ---   LIST OF MONOMERS ---'

      IF(LML_NMON.GT.0) THEN
        IFIRST_M = 0
        DO L=1,LML_NMON

          IF(LML_FUSE(L).NE.'?') THEN

            IF(IFIRST_M.EQ.0) THEN
              WRITE(LINE
     *  ,'(''# ------------------------------------------------'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              IF(HTML.EQ.'Y') THEN
                LINE = '<h2><a name="mon" id="mon"></a>'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
              LINE = TITLE_M
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              IF(HTML.EQ.'Y') THEN
                LINE = '</h2>'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
            ENDIF

            CALL WRT_TITLE_MONOMER_HTML(MDOC,IUN,L,IFIRST_M,HTML,IERR)

          ENDIF
        ENDDO

        IF(IFIRST_M.NE.0) THEN
          IF(HTML.EQ.'Y') THEN
            LINE = '</pre>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
          ENDIF
        ENDIF

      ENDIF

C -----------------
      IF(LDR_NDER.GT.0) THEN
        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(HTML.EQ.'Y') THEN
          LINE = '<h2><a name="rec" id="rec"></a>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF
        WRITE(LINE
     *    ,'(''# ---   LIST OF RECOGNIZED MODIFIED MONOMERS ---'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(HTML.EQ.'Y') THEN
          LINE = '</h2>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          LINE = '<pre>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF

        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''data_deriv_list'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_deriv.comp_id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_deriv.source_comp_id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_deriv.mod_id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_deriv.name'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_deriv.group'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        DO L=1,LDR_NDER

          CALL LENSTR_BL(LDR_NAME(L),LEN)
          IF(LEN.GT.32) LEN = 32
          DATA = LDR_NAME(L)(1:LEN) 

          WRITE(LINE,410) 
     *    LDR_MNAME(L),LDR_SMNAME(L),LDR_MOD(L),DATA,LDR_TYPE(L)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
  410     FORMAT(1X,A8,1X,A8,1X,A8,1X,A32,1X,A16)
        ENDDO
        IF(HTML.EQ.'Y') THEN
          LINE = '</pre>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF
      ENDIF
C ----------
      IF(LMS_NSYN.GT.0) THEN
        IFIRST_M = 0
        IF(HTML.EQ.'Y') THEN
          LINE = '<h2><a name="syn" id="syn"></a>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ELSE
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF
        WRITE(LINE,'(''# ---   LIST OF SYNONYMS ---'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(HTML.EQ.'Y') THEN
          LINE = '</h2>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF

        IF(HTML.EQ.'Y') THEN
          LINE = '<pre>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF

        DO L=1,LMS_NSYN
          IF(LMS_ATOM(L).EQ.'.') THEN

            IF(IFIRST_M.EQ.0) THEN

C              IF(HTML.EQ.'Y') THEN
C                LINE = '<h2>'
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''# ---   LIST OF ATOM SYNONYMS ---'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                LINE = '</h2>'
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                LINE = '<pre>'
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              ENDIF
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''data_comp_synonym_list'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''loop_'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''_chem_comp_synonym.comp_id'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_synonym.comp_alternative_id'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''_chem_comp_synonym.mod_id'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              IF(HTML.EQ.'Y') THEN
C                LINE = '</pre>'
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              ENDIF
              IFIRST_M = 1
            ENDIF
C            IF(HTML.EQ.'Y') THEN
C              LINE = '<pre>'
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C            ENDIF
            WRITE(LINE,200) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),LMS_MOD(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  200       FORMAT(A8,4X,A8,1X,A8)
C            IF(HTML.EQ.'Y') THEN
C              LINE = '</pre>'
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C            ENDIF
          ENDIF
        ENDDO
  
        IF(HTML.EQ.'Y') THEN
          LINE = '</pre>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF

          IFIRST_MM = 0
          DO L=1,LMS_NSYN
            IF(LMS_ATOM(L).NE.'.') THEN
              IF(IFIRST_MM.EQ.0) THEN
                IF(IFIRST_M.EQ.0) THEN
                  IF(HTML.EQ.'Y') THEN
                    LINE = '<h2>'
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ELSE
                    WRITE(LINE,'(''#'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF
                  WRITE(LINE,'(''#'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''# ---   LIST OF ATOM SYNONYMS ---'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  IF(HTML.EQ.'Y') THEN
                    LINE = '</h2>'
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF
                ENDIF
                IF(HTML.EQ.'Y') THEN
                  LINE = '<pre>'
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_synonym_atom_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.comp_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.atom_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST_MM = 1
              ENDIF
              WATOM1 = LMS_ATOM(L)
              WATOM2 = LMS_AATOM(L)
              CALL CORR_NAME_CIF_OUT(WATOM1)
              CALL CORR_NAME_CIF_OUT(WATOM2)
              WRITE(LINE,201) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),WATOM1,WATOM2
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 201          FORMAT(A8,4X,A8,1X,A6,1X,A6)
            ENDIF
          ENDDO
          IF(HTML.EQ.'Y'.AND.IFIRST_MM.EQ.1) THEN
            LINE = '</pre>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
          ENDIF

      ENDIF
C -----------------

      IF(LLL_NLINK.GT.0) THEN
        IFIRST=0

        DO L=1,LLL_NLINK
          IF(LLL_FUSE(L).NE.'?') THEN
            IF(IFIRST.EQ.0) THEN 
              IF(HTML.EQ.'Y') THEN
                LINE = '<h2><a name="link" id="link"></a>'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ELSE
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
              WRITE(LINE,'(''# ---   LIST OF LINKS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              IF(HTML.EQ.'Y') THEN
                LINE = '</h2>'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
            ENDIF

            CALL WRT_TITLE_LINK_HTML(MDOC,IUN,L,IFIRST,HTML,IERR)

          ENDIF
        ENDDO
        IF(IFIRST.NE.0) THEN 
          IF(HTML.EQ.'Y') THEN
            LINE = '</pre>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
          ENDIF
        ENDIF
      ENDIF
C -------------------
      IF(LDL_NMOD.GT.0) THEN
        IFIRST=0
        DO L=1,LDL_NMOD
          IF(LDL_FUSE(L).NE.'?') THEN
            IF(IFIRST.EQ.0) THEN 
              IF(HTML.EQ.'Y') THEN
                LINE = '<h2><a name="mod" id="mod"></a>'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ELSE
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
              WRITE(LINE,'(''# ---   LIST OF MODIFICATIONS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              IF(HTML.EQ.'Y') THEN
                LINE = '</h2>'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
            ENDIF

            CALL WRT_TITLE_MODIFICATION_HTML(MDOC,IUN,L,IFIRST
     *                                             ,HTML,IERR)

          ENDIF
        ENDDO
        IF(IFIRST.NE.0) THEN 
          IF(HTML.EQ.'Y') THEN
            LINE = '</pre>'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
          ENDIF
        ENDIF
      ENDIF
C ----
c      IF(HTML.EQ.'Y') THEN
c      LINE = '</pre>'
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
c      LINE = '</BODY>'
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
c      LINE = '</HTML>'
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
c      ENDIF

C      END FILE IUN
C      CLOSE(IUN)




C -----------------------------------
      RETURN
      END     

      SUBROUTINE WRT_TITLE_MONOMER_HTML(MDOC,IUN,L,IFIRST_M,HTML,IERR)
C ------------------------------------------------------------
      INTEGER   MDOC,IUN,L,IFIRST_M,IERR
C ----
      CHARACTER LINE*256
      CHARACTER STR*256,CH1_1*1,CH1_2*1,CH3*3,FILE*80,MON*8
      CHARACTER CHAR1*1,HTML*1,STRING*256,LINE1*80
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ------------------------------------------------------------      
      IF(IFIRST_M.EQ.0) THEN
        IF(HTML.EQ.'Y') THEN
          LINE = '<pre>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.three_letter_code'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.group'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_all'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_nh'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.desc_level'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c        IF(HTML.EQ.'Y') THEN
c          LINE = '</pre>'
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c        ENDIF
        IFIRST_M = 1
      ENDIF
      CH3 = LML_MNAME2(L)(1:3)
      J   = LML_IATOM(L)
      NA  = 0
      NHA = 0                  
      IF(J.GT.0) THEN
        IF(LMA_NATOM.GT.0) THEN
          DO IA=J,LMA_NATOM
            IF(LMA_MNAME(IA).EQ.LML_MNAME(L)) THEN
              NA = NA+1
              IF(LMA_SYMB(IA).NE.'H   '.AND.
     *           LMA_SYMB(IA).NE.'D   ') THEN
                NHA=NHA+1
              ENDIF
            ENDIF           
          ENDDO
        ENDIF
      ENDIF

              CH1_2 = ''''
              CH1_1 = LML_PRSNT(L)
              IF(CH1_1.EQ.' ') CH1_1 = '.'
CZEB     aaa '4-HYDROXY-3,4-DIHYDRO-ZEBULARINEMIDI ' non-polymer        31  17 M
c2345678112311123456789 123456789 123456789 123456711123456789 123456112341234
c         123456789 123456789 123456789 12345611     123456789 123456112341234
              STR = LML_NAME(L)
              CALL LENSTR_BL(STR,LEN)
              IF(LEN.GT.36) LEN = 36
              IF(LEN.LT.36) THEN
                DO II=LEN+1,36
                  STR(II:II) = ' '
                ENDDO
              ENDIF

            MON = LML_MNAME(L)
            CALL LENSTR_BL(MON,LEN)
            IF(LML_FUSE(L).NE.'?'.AND.LEN.GT.0.AND.
     *              MON(1:1).NE.'?') THEN
              CHAR1 = MON(1:1)
              IMODE = -1
              CALL CHECK_LINE(IMODE,CHAR1)
C ---
C                 CHECK_LINE - check and convert symbols of line.
C                        MODE  0  only check
C                             -1  convert symbols to low case.
C                              1  to upper
C ---
              FILE = CHAR1//'/'//MON(1:LEN)//'.cif'
              CALL LENSTR_BL(FILE,LF)

              IF(HTML.EQ.'Y') THEN

                LINE = '<a href="'//FILE(1:LF)//'"><b>'//
     *                 LML_MNAME(L)//'</b></a>'

C                LINE = '<br /><a href="'//FILE(1:LF)//'"><b>'
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                LINE = LML_MNAME(L)
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                LINE = '</b></a>'
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE1,100)
     *          CH3,CH1_2,STR(1:36),CH1_2
     *         ,LML_TYPE(L),NA,NHA,CH1_1
C     *        ,LML_NATM(L),LML_NHATM(L)
  100           FORMAT(1X,A3,1X,A1,A36,A1,1X,A16,1X,I4,I4,1X,A1)

                CALL LENSTR_BL(LINE,LEN)
                STRING = LINE(1:LEN)//LINE1

                CALL WRTSTR(IUN,MDOC,STRING,IERR)
              ELSE
                WRITE(LINE,101)
     *          MON,CH3,CH1_2,STR(1:36),CH1_2
     *         ,LML_TYPE(L),NA,NHA,CH1_1
C     *        ,LML_NATM(L),LML_NHATM(L)
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
 101            FORMAT(A8,1X,A3,1X,A1,A36,A1,1X,A16,1X,I4,I4,1X,A1)
              ENDIF
            ENDIF
C ------------------------
      RETURN
      END

      SUBROUTINE WRT_TITLE_LINK_HTML(MDOC,IUN,L,IFIRST,HTML,IERR)
C -----------------------------------------------------
      INTEGER*4 MDOC,IERR,IUN,L,IFIRST
      CHARACTER LINE*256,FILE*80,LINK*8,HTML*1
      CHARACTER STRING*256,LINE1*80
C ******
C -----------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------

      IF(IFIRST.EQ.0) THEN 
        IF(HTML.EQ.'Y') THEN
          LINE = '<pre>'
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF
        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_link_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.one_letter_code'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.name'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        IF(HTML.EQ.'Y') THEN
C          LINE = '</pre>'
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        ENDIF
        IFIRST=1
      ENDIF


            LINK = LLL_LNAME(L)
            CALL LENSTR_BL(LINK,LEN)

            FILE = '../'//'link/'//LINK(1:LEN)//'.cif'
            CALL LENSTR_BL(FILE,LF)

            IF(HTML.EQ.'Y') THEN

              LINE = '<a href="#'//LINK(1:LEN)//'"><b>'//
     *         LINK//'</b></a>'       
C              LINE = '<br /><a href="#'//LINK(1:LEN)//'"><b>'
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              LINE = LINK
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              LINE = '</b></a>'
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE1,300) 
     *        LLL_MON1(L),LLL_MOD1(L),LLL_TYPE1(L)
     *        ,LLL_MON2(L),LLL_MOD2(L),LLL_TYPE2(L)
     *        ,LLL_DETAIL(L)(1:24)
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  300         FORMAT(1X,A8,1X,A8,1X,A8
     *                              ,1X,A8,1X,A8,1X,A8,1X,A24)

              CALL LENSTR_BL(LINE,LEN)
              STRING = LINE(1:LEN)//LINE1
              CALL WRTSTR(IUN,MDOC,STRING,IERR)


            ELSE
              WRITE(LINE,302) 
     *        LINK,LLL_MON1(L),LLL_MOD1(L),LLL_TYPE1(L)
     *        ,LLL_MON2(L),LLL_MOD2(L),LLL_TYPE2(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 302          FORMAT(A8,1X,A8,1X,A8,1X,A8
     *                              ,1X,A8,1X,A8,1X,A8)
              WRITE(LINE,301) LLL_DETAIL(L)(1:24)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 301          FORMAT(1X,A24)
            ENDIF

C -------------------------
      RETURN
      END

C ******
      SUBROUTINE WRT_TITLE_MODIFICATION_HTML(MDOC,IUN,L,IFIRST
     * ,HTML,IERR)
C -----------------------------------------------------
      INTEGER*4 MDOC,IERR,IUN,L,IFIRST
      CHARACTER LINE*256,MOD*8,FILE*80,HTML*1
      CHARACTER STRING*256,LINE1*80
C ******
C -----------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------


            IF(IFIRST.EQ.0) THEN 
              IF(HTML.EQ.'Y') THEN
                LINE = '<pre>'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
                WRITE(LINE,'(''#'')') 
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_mod_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.one_letter_code'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.group_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_id'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_order'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              IF(HTML.EQ.'Y') THEN
C                LINE = '</pre>'
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              ENDIF
              IFIRST=1
            ENDIF

c              WRITE(CH2,'(I2)') LDL_ORDER(L)
c              IF(LDL_ORDER(L).EQ.0) CH2='. '

            MOD  = LDL_MNAME(L)
            CALL LENSTR_BL(MOD,LEN)

            IF(HTML.EQ.'Y') THEN              

C              FILE = '../'//'mod/'//MOD(1:LEN)//'.cif'
C              CALL LENSTR_BL(FILE,LF)

              LINE = '<a href="#'//MOD(1:LEN)//'"><b>'//
     *               MOD//'</b></a>'
C              LINE = '<br /><a href="#'//MOD(1:LEN)//'"><b>'
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              LINE = MOD
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              LINE = '</b></a>'
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)

              WRITE(LINE1,400) 
     *        LDL_DETAIL(L),LDL_COMP(L),LDL_TYPE(L)
  400         FORMAT(1X,A48,1X,A8,1X,A8)
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 
              CALL LENSTR_BL(LINE,LEN)
              STRING = LINE(1:LEN)//LINE1
              CALL WRTSTR(IUN,MDOC,STRING,IERR)

            ELSE

              WRITE(LINE,401) 
     *        MOD,LDL_DETAIL(L),LDL_COMP(L),LDL_TYPE(L)
    
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  401         FORMAT(A8,1X,A48,1X,A8,1X,A8)
           ENDIF
C -------------------------
      RETURN
      END

      SUBROUTINE LIB_CREATE_INDEX2(MDOC,IMON,NMON,MEM,IERR)
C -------------------------------------------
      INTEGER MAXMPONTER
      PARAMETER (MAXMPONTER = 3500)
      INTEGER MAXMPOOL
      PARAMETER (MAXMPOOL = 1600 000)
      INTEGER   MATCH_POINTER(MAXMPONTER)
      INTEGER*2 MATCH_POOL   (MAXMPOOL)
      COMMON /COM_MATCH_POOL/ MEM_TOT,MATCH_NMON
     *                       ,MATCH_POINTER,MATCH_POOL
C ------------------------------------------
C     IP = MATCH_POINTER(I) 
C       MATCH_POOL(IP  ) = IMON 
C       MATCH_POOL(IP+1) = NATOM  
C       MATCH_POOL(IP+2) = NBOND
C
C       MATCH_POOL(IP+3) = ICONTENT(I) 
C       . . . . . 
C       MATCH_POOL(IP+17) = ICONTENT(I) 
C 'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN','MO','  '
C  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15
C  
C       IPA = IP + 17
C       MATCH_POOL(IPA+1) = IATOM
C       MATCH_POOL(IPA+2) = IATYPE
C
C       IPB = IB + 17 + 2*NATOM
C       MATCH_POOL(IPA+1) = IATOM1
C       MATCH_POOL(IPA+1) = IATOM2
C       MATCH_POOL(IPA+1) = IBTYPE
C
C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova
C
C ---------------------------------------------------------------
      INTEGER  MDOC,IERR,MEM_TOT,IMON,NMON
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER SYMB*4,MON*8,LINE*256

      INTEGER   ICONTENT(15)
      CHARACTER ATM_SYMB(15)*2
      DATA  ATM_SYMB
     */'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN'
     *,'MO','  '/
C       1    2    3    4    5    6    7    8    9    10   11   12   13
C       14   15
C ---------------------------------------------------------------------
      IERR   = 0
      IF(NMON.GE.MAXMPONTER) THEN
        WRITE(LINE,
     *  '('' ERROR: in LIB_CREATE_INDEX2: number of monomers >'',I8)')
     *  MAXMPONTER
        CALL MSGERR(MDOC,LINE)         
        IERR = 1
        RETURN
      ENDIF    
C -----
        CALL COPYL2(MDOC,IERR)
C -----
      NA     = L2A_NATOM
      IF(IMON.GT.0) THEN
        MON = LML_MNAME(IMON)
      ELSE
        MON = L1L_MNAME
      ENDIF
      IF(NA.LE.1) THEN
        RETURN
      ENDIF
      DO I=1,15
        ICONTENT(I) = 0
      ENDDO
C --------------------
      NATOM  = 0
      DO IA=1,NA
        L2A_ICR(IA) = 0 
        IF(L2A_ANAME(IA).NE.'    ') THEN
          SYMB = L2A_SYMB(IA)
          IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
            DO K=1,15
              IF(SYMB(1:2).EQ.ATM_SYMB(K)) THEN
                GO TO 100
              ENDIF             
            ENDDO
            K = 15
 100        CONTINUE
            NATOM       = NATOM + 1
            ICONTENT(K) = ICONTENT(K) + 1
            L2A_ICR(IA) = NATOM
            L2A_CONN(1,NATOM) = IA
            L2A_CONN(2,NATOM) = K
          ENDIF
        ENDIF
      ENDDO  
      IF(NATOM.LE.4)     RETURN
      IF(L2B_NBOND.LE.3) RETURN
C -------------------- 
      NBOND = 0     
      DO IA=1,NA-1
        IF(L2A_ICR(IA).GT.0) THEN 
          DO JA=IA+1,NA
            IF(L2A_ICR(JA).GT.0) THEN 
              DO IB=1,L2B_NBOND
                IF(L2B_1ATM(IB).EQ.L2A_ANAME(IA).AND.
     *             L2B_2ATM(IB).EQ.L2A_ANAME(JA)) THEN
                  NBOND = NBOND + 1
                  L2N_I1ATM (NBOND) = L2A_ICR(IA)
                  L2N_I2ATM (NBOND) = L2A_ICR(JA)
                  L2N_TYPE  (NBOND) = L2B_TYPE(IB)
                  GO TO 200
                ELSE IF(L2B_2ATM(IB).EQ.L2A_ANAME(IA).AND.
     *                  L2B_1ATM(IB).EQ.L2A_ANAME(JA)) THEN
                  NBOND = NBOND + 1
                  L2N_I1ATM (NBOND) = L2A_ICR(JA)
                  L2N_I2ATM (NBOND) = L2A_ICR(IA)
                  L2N_TYPE  (NBOND) = L2B_TYPE(IB)
                  GO TO 200
                ENDIF
              ENDDO

 200          CONTINUE
            ENDIF
          ENDDO
        ENDIF
      ENDDO
C --------------------
      IF(NATOM.LE.4) RETURN
      IF(NBOND.LE.3) RETURN      
C ----------------------------------------
      IT = MEM_TOT + 18 +NATOM*2 + NBOND*3
      IF(IT.GT.MAXMPOOL) THEN
        WRITE(LINE,
     *  '('' ERROR: in LIB_CREATE_INDEX2: Insufficient memory:'')')
        CALL MSGERR(MDOC,LINE)         
        IERR = 1
        RETURN
      ENDIF    

      NMON    = NMON + 1

      MEM_TOT = MEM_TOT + 1
      MATCH_POINTER(NMON) = MEM_TOT
      MATCH_NMON          = NMON

      MATCH_POOL(MEM_TOT) = IMON 
      MEM_TOT = MEM_TOT + 1
      MATCH_POOL(MEM_TOT) = NATOM  
      MEM_TOT = MEM_TOT + 1
      MATCH_POOL(MEM_TOT) = NBOND

      DO I=1,15
        MEM_TOT = MEM_TOT + 1 
        MATCH_POOL(MEM_TOT) = ICONTENT(I) 
      ENDDO

      DO IA=1,NATOM

        MEM_TOT = MEM_TOT + 1 
        MATCH_POOL(MEM_TOT) = L2A_CONN(1,IA) 
        MEM_TOT = MEM_TOT + 1 
        MATCH_POOL(MEM_TOT) = L2A_CONN(2,IA) 

      ENDDO

      DO IB=1,NBOND

        IT = 0

C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova

        IF(L2N_TYPE(IB)(1:4).EQ.'sing') THEN
          IT = 1
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'doub') THEN
          IT = 2
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'trip') THEN
          IT = 3
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'arom') THEN
          IT = 4
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'delo') THEN
          IT = 5
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'meta') THEN
          IT = 6
        ELSE IF((L2N_TYPE(IB)(1:4).EQ.'cova').OR.
     *          (L2N_TYPE(IB)(1:1).EQ.'.'   )    )THEN
          IT = 7
        ENDIF

        MEM_TOT = MEM_TOT + 1 
        MATCH_POOL(MEM_TOT) = L2N_I1ATM(IB) 
        MEM_TOT = MEM_TOT + 1 
        MATCH_POOL(MEM_TOT) = L2N_I2ATM(IB) 
        MEM_TOT = MEM_TOT + 1 
        MATCH_POOL(MEM_TOT) = IT 

      ENDDO
      MEM = MEM_TOT
C ---------------------
      RETURN
      END


      SUBROUTINE LIB_WRITE_INDEX2(MDOC,IUN,FORM,MEM,IERR)
C -------------------------------------------
      INTEGER MAXMPONTER
      PARAMETER (MAXMPONTER = 3500)
      INTEGER MAXMPOOL
      PARAMETER (MAXMPOOL = 1600 000)
      INTEGER   MATCH_POINTER(MAXMPONTER)
      INTEGER*2 MATCH_POOL   (MAXMPOOL)
      COMMON /COM_MATCH_POOL/ MEM_TOT,MATCH_NMON
     *                       ,MATCH_POINTER,MATCH_POOL
C ------------------------------------------
C     IP = MATCH_POINTER(I) 
C       MATCH_POOL(IP  ) = IMON 
C       MATCH_POOL(IP+1) = NATOM  
C       MATCH_POOL(IP+2) = NBOND
C
C       IPC = IP+2
C       MATCH_POOL(IPC+1)  = ICONTENT(1) 
C       . . . . . 
C       MATCH_POOL(IPC+15) = ICONTENT(15) 
C 'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN','MO','  '
C  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15
C  
C       IPA = IP + 17
C       MATCH_POOL(IPA+1) = IATOM
C       MATCH_POOL(IPA+2) = IATYPE
C
C       IPB = IP + 17 + 2*NATOM
C       MATCH_POOL(IPA+1) = IATOM1
C       MATCH_POOL(IPA+1) = IATOM2
C       MATCH_POOL(IPA+1) = IBTYPE
C
C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova
C
C ---------------------------------------------------------------
      INTEGER  MDOC,IERR,IUN
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER MON*8,FORM*1,LINE*256
C ---------------------------------------------------------------------
      IF(MATCH_NMON.LE.0.OR.MEM_TOT.LE.0) RETURN      
C ----------------------------------------
      IF(FORM.EQ.'U') THEN
        WRITE(IUN) MATCH_NMON,MEM_TOT
      ELSE
        WRITE(IUN,'(I5,I12)') MATCH_NMON,MEM_TOT
      ENDIF

      IF(FORM.EQ.'U') THEN
        WRITE(IUN) (MATCH_POINTER(IM),IM=1,MATCH_NMON)
      ELSE
        WRITE(IUN,'(10I8)') (MATCH_POINTER(IM),IM=1,MATCH_NMON)
      ENDIF

      IF(FORM.EQ.'U') THEN
        WRITE(IUN) (MATCH_POOL(IM),IM=1,MEM_TOT)
      ELSE
        WRITE(IUN,'(20I4)') (MATCH_POOL(IM),IM=1,MEM_TOT)
      ENDIF
     
C ---------------------
      RETURN
      END

      SUBROUTINE CALC_POLCRD_MN(MDOC,LIST,MON,II,N_IN,V_0,V_1
     * ,ISTART,ISTART2,DUMMY_FLAG,PRSNT,IERR)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------------
      CHARACTER MON*8
      REAL      V_1(3),V_0(3),V1(3),V2(3),V3(3),V4(4)
      REAL      VV1(3),VV2(3)
      REAL      AV(20),THETA(20),AV_TEMP(20),THETA_TEMP(20)
      REAL      TEMP (20)
      REAL      X1(3),X2(3),X3(3),X4(3)
      INTEGER   IFLAG_T(20),I4(20),I4_TEMP(20)
      CHARACTER LINE*256,CH8*8,LIST*1,DUMMY_FLAG*1,PRSNT*1
C --------------------------------------------------
      PI     = 4.0*ATAN(1.0)
      TWOPI  = 2.0*PI
      PI180  = PI/180.0
      IERR   = 0
      IFIRST = 0
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,'====CALC_POLCRD_MN==============')
        WRITE(LINE,'(''=== II,N_IN:'',2i4)') II,N_IN 
          CALL MSGDOC(MDOC,LINE)
      ENDIF

C --                                 V_1
c                                     !
c                                     !
C     I1 --> I2 --> II               V_0 -->+ start
C        v1     v2
C 
      CALL GET_VECTOR(II,V_0,V_1,V1,V2,I1,I2)
      CALL NB_VMOD(V1,AV1)
      CALL NB_VMOD(V2,AV2)
      CALL NB_VPROD(V1,V2,S)
      COSA1= S/(AV1*AV2)
      ANG1 = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
      ANG1 = PI-ANG1
C --
C ----Tabl. I4 AV THETA --------------------------------
C
      N  = N_IN
      IF(N.LE.0.AND.II.EQ.L1A_ISTART) RETURN
      NE = L1A_NEXTR(II)
      NT = N+NE
      IF(NT.LE.0) RETURN

      DO I=1,NT
        I4 (I)    = 0
        AV (I)    = 0.0
        THETA(I)  = 0.0
      ENDDO
      NH  = 0
      NHT = 0
      IF(N.GT.0) THEN
      DO I=1,N
        IA    = L1A_CONN(I,II)
        I4(I) = IA
        IF(L1A_SYMB(IA).EQ.'H   '.OR.L1A_SYMB(IA).EQ.'D   ') NH=NH+1
      ENDDO
      ENDIF

      NHT=NH

      IF(NE.GT.0) THEN
        DO I=1,NE
          I4(N+I) = L1A_IEXTR(I,II)
          IA      = I4(N+I)
          IF(L1A_SYMB(IA).EQ.'H   '.OR.L1A_SYMB(IA).EQ.'D   ') 
     *    NHT = NHT+1
        ENDDO
      ENDIF

c     IF(II.EQ.ISTART) ISTART2 = 0

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'('' def type II,I2,nt:'',3i4)') II,i2,nt 
        CALL MSGDOC(MDOC,LINE)
      ENDIF
C
C ---  define type II ---
C

      CALL DEF_TYPE_II(MDOC,LIST,MON,NT,NHT,II,I2,I4,THETA_D,IERR)


      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'('' after def type :'',f10.3)') THETA_D 
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      THETA_DG = THETA_D/PI180
C
C --- search bonds ---
C
      DO J=1,NT
        NEXT = I4(J)
        CALL SRCH_BOND(MDOC,MON,II,NEXT,AV3,LB,IERR)
        IF(IERR.NE.0) THEN
          WRITE(LINE,
     *    '(''WARNING: no bond : '',A4,'' -> '',A4)')
     *    L1A_ANAME(II),L1A_ANAME(NEXT)
          CALL MSGERR(MDOC,LINE)
          IF(IERR.EQ.3) THEN
            AVD = AV3
          ELSE
            IF(L1A_SYMB(NEXT).NE.'H   '.AND.L1A_SYMB(NEXT).NE.'D   ')
     *      THEN
              AVD = 1.45
            ELSE
              AVD = 1.0
            ENDIF
          ENDIF
          WRITE(LINE,'(''           Default =  '',F8.3)') AVD
          CALL MSGERR(MDOC,LINE)
          CH8 = 'coval'
          CALL PUT_TO_BOND_LIST(MDOC,II,NEXT,AVD,CH8,IERR)
          IF(IERR.NE.0) RETURN
          AV3  = AVD
          IERR = 0
        ENDIF
        AV(J) = AV3
      ENDDO
C
C --- search thetas ---
C
      DO J=1,NT
        NEXT = I4(J)
        IF(I2.GT.0) THEN
          CALL SRCH_ANGL(MDOC,MON,I2,II,NEXT,ANGL,LG,IERR)
          IF(IERR.NE.0) THEN
            WRITE(LINE,
     *    '(''WARNING: no angle '',A4,'' - '',A4,'' - '',A4)')
     *      L1A_ANAME(I2),L1A_ANAME(II),L1A_ANAME(NEXT)
            CALL MSGERR(MDOC,LINE)
            IF(IERR.EQ.3) THEN
              THETADG = ANGL
              THETAD  = ANGL*PI180
            ELSE
              THETAD  = THETA_D
              THETADG = THETA_DG
            ENDIF
            WRITE(LINE,
     *      '(''         Default value : '',F8.3)') THETADG
            CALL MSGERR(MDOC,LINE)
            IERR     = 0
            CALL PUT_TO_ANGLE_LIST(MDOC,I2,II,NEXT,THETADG,IERR)
            IF(IERR.NE.0) RETURN
            THETA(J) = THETAD
          ELSE
            THETA(J) = ANGL*PI180
          ENDIF
        ELSE
          THETA(J) = THETA_D
        ENDIF
      ENDDO

C
C  --- first atom ---
C
      IF(II.EQ.L1A_ISTART) THEN

        IFIRST = 1 
        IF(LIST.EQ.'T') THEN
          WRITE(LINE,
     *    '(''=== calc_polcrd,first:II,N,ne,nt'',4i4,A)')
     *    II,n,ne,nt,L1A_ANAME(II)
          CALL MSGDOC(MDOC,LINE)

          WRITE(LINE,'(''=== i4:'',5i4)')
     *    (I4(k),k=1,nt)
          WRITE(LINE,'(''===Ai4:'',5(A,1X))')
     *    (L1A_ANAME(I4(k)),k=1,nt)
          CALL MSGDOC(MDOC,LINE)
          WRITE(LINE,'(''=== av:'',5f8.3)')
     *    (av(k),k=1,nt)
          CALL MSGDOC(MDOC,LINE)

          DO K=1,NT
           TEMP(k) = THETA(k)/PI180
          ENDDO
          WRITE(LINE,'(''=== theta:'',5f8.3)')
     *    (TEMP(k),k=1,nt)
          CALL MSGDOC(MDOC,LINE)

        ENDIF

        IFORW  = L1A_IFORW(II)
        IFORWW = 0 
        IF(IFORW.GT.0) IFORWW = L1A_IFORW(IFORW)
        IF(IFORW.LE.0.OR.IFORWW.LE.0) THEN
          DO I=1,N
            IF(L1A_NDIST(I4(I)).GT.0) THEN
              IFORW  = I4(I)
              IFORWW = L1A_CONN(L1A_NDIST(I4(I)),I4(I))
              GO TO 100
            ENDIF
          ENDDO
        ENDIF
 100    CONTINUE
        IF(IFORW.LE.0) IFORW = I4(N)

        DO I=1,NT
          IF(IFORW.EQ.I4(I)) I4FORW  = I
        ENDDO         

        IF(LIST.EQ.'T') THEN
          WRITE(LINE,'(''=== iforw,iforww:'',2i4)') IFORW,IFORWW
          CALL MSGDOC(MDOC,LINE)
        ENDIF

        NEXT = IFORW
        ANG2 = 135.0*PI180
        AV3  = AV(I4FORW)
        PH   = 0.0
        CALL COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PH,V3)
        L1A_X     (NEXT)    = L1A_X(II)+V3(1)
        L1A_Y     (NEXT)    = L1A_Y(II)+V3(2)
        L1A_Z     (NEXT)    = L1A_Z(II)+V3(3)
        L1A_LENGTH(NEXT)    = AV3
        L1A_PHI   (NEXT)    = PH/PI180
        L1A_THETA (NEXT)    = ANG2/PI180
        L1A_ID_PSI(NEXT)    = 'Const'
        L1A_COOR_FLAG(NEXT) = 'Y'

        IF(LIST.EQ.'T') THEN
          WRITE(LINE,'(''= FORW = th,ph:'',2f8.3)')
     *    L1A_THETA(NEXT),L1A_PHI(NEXT)
          CALL MSGDOC(MDOC,LINE)
        ENDIF

        IF(NT.LE.1) RETURN 

        IF(IFORWW.LE.0) THEN
C         --- STAR ---
C          WRITE(LINE,'('' ERROR: star case '')')     
C          CALL MSGERR(MDOC,LINE)
C          IERR = 1
C          RETURN
          L1A_X(II) =-L1A_X(IFORW)
          L1A_Y(II) =-L1A_Y(IFORW)
          L1A_Z(II) =-L1A_Z(IFORW)
          L1A_X(IFORW) = 0.0
          L1A_Y(IFORW) = 0.0
          L1A_Z(IFORW) = 0.0
          J = 0
          DO I=1,NT
            IF(I4(I).NE.IFORW) THEN
              J          = J + 1
              I4_TEMP(J) = I4(I)
              AV_TEMP(J) = AV(I)
            ENDIF
          ENDDO
          N_OLD  = N
          NT_OLD = NT
          NE_OLD = NE
          IF(I4FORW.LE.N) N = N - 1
          NT = NT - 1
          NE = NT - N
          IF(L1A_SYMB(IFORW).EQ.'H   '.OR.
     *       L1A_SYMB(IFORW).EQ.'D   '    ) THEN 
            NHT = NHT - 1 
            NH  = NH  - 1
          ENDIF
C --- search thetas ---
C
          VV1(1) = V2(1)
          VV1(2) = V2(2)
          VV1(3) = V2(3)
          VV2(1) = L1A_X(II) 
          VV2(2) = L1A_Y(II) 
          VV2(3) = L1A_Z(II)
          AAV1   = AV2
          AAV2   = AV(I4FORW)
          II1    = I2
          II2    = IFORW 
          CALL NB_VMOD(VV1,AAV1)
          CALL NB_VMOD(VV2,AAV2)
          CALL NB_VPROD(VV1,VV2,S)
          COSA1= S/(AAV1*AAV2)
          AANG1 = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
          AANG1 = PI-AANG1
          DO J=1,NT
            NEXT = I4_TEMP(J)
            IF(II2.GT.0) THEN
              CALL SRCH_ANGL(MDOC,MON,II2,II,NEXT,ANGL,LG,IERR)
              IF(IERR.NE.0) THEN
                WRITE(LINE,
     *      '(''WARNING: no angle '',A4,'' - '',A4,'' - '',A4)')
     *          L1A_ANAME(II2),L1A_ANAME(II),L1A_ANAME(NEXT)
                CALL MSGERR(MDOC,LINE)
                IF(IERR.EQ.3) THEN
                  THETADG = ANGL
                  THETAD  = ANGL*PI180
                ELSE
                  THETAD  = THETA_D
                  THETADG = THETA_DG
                ENDIF
                WRITE(LINE,
     *          '(''         Default value : '',F8.3)') THETADG
                CALL MSGERR(MDOC,LINE)
                IERR     = 0
                CALL PUT_TO_ANGLE_LIST(MDOC,II2,II,NEXT,THETADG,IERR)
                IF(IERR.NE.0) RETURN
                THETA_TEMP(J) = THETAD
              ELSE
                THETA_TEMP(J) = ANGL*PI180
              ENDIF
            ELSE
              THETA_TEMP(J) = THETA_D
            ENDIF
          ENDDO
          CALL CMP_CRD_MN(MDOC,LIST,MON,II1,II2,II,N,NE,NT,I4_TEMP
     *     ,NH,NHT
     *     ,V_0,V_1,ITYPE,AV_TEMP,THETA_TEMP,THETA_D,VV1,VV2
     *     ,AAV1,AAV2,AANG1
     *     ,ISTART,ISTART2,DUMMY_FLAG,IFIRST,IERR)
          IF(IERR.NE.0) THEN
            CALL MSGERR(MDOC,'ERRROR: in subroutine CMP_CRD_M') 
            RETURN
          ENDIF
          N  = N_OLD  
          NT = NT_OLD 
          NE = NE_OLD 

          X3(1) = L1A_X(II)
          X3(2) = L1A_Y(II)
          X3(3) = L1A_Z(II)

          X2(1) = V_0(1)
          X2(2) = V_0(2) 
          X2(3) = V_0(3)

          X1(1) = V_1(1)
          X1(2) = V_1(2) 
          X1(3) = V_1(3) 

          DO I=1,NT
            
            X4(1) = L1A_X(I4(I))  
            X4(2) = L1A_Y(I4(I))  
            X4(3) = L1A_Z(I4(I)) 

            CALL CALC_TORS_FROM_COORDS(X1,X2,X3,X4,ANGOBS)
            
            IF(I.LE.N) THEN
              L1A_X(I4(I))      = L1A_X(I4(I)) - L1A_X(II) 
              L1A_Y(I4(I))      = L1A_Y(I4(I)) - L1A_Y(II) 
              L1A_Z(I4(I))      = L1A_Z(I4(I)) - L1A_Z(II) 
              L1A_PHI(I4(I))    = ANGOBS/PI180
              L1A_THETA(I4(I))  = THETA(I)/PI180
              L1A_ID_PSI(I4(I)) = 'CONST'
            ELSE
              IF(L1A_NDUMMY.GT.0) THEN
                DO J=1,L1A_NDUMMY
                  IF(L1A_ANAME(I4(I)).EQ.L1A_ANAME(J)) THEN
                    L1A_X(J) = L1A_X(J) - L1A_X(II) 
                    L1A_Y(J) = L1A_Y(J) - L1A_Y(II) 
                    L1A_Z(J) = L1A_Z(J) - L1A_Z(II) 
                  ENDIF
                ENDDO
              ENDIF
            ENDIF
          ENDDO
          L1A_X(II) = 0.0
          L1A_Y(II) = 0.0
          L1A_Z(II) = 0.0
        ELSE 

          CALL SRCH_ANGL(MDOC,MON,II,IFORW,IFORWW,ANG3,LG,IERR)
          IF(IERR.NE.0) THEN
            WRITE(LINE,
     *      '(''WARNING: no angle '',A4,'' - '',A4,'' - '',A4)')
     *      L1A_ANAME(II),L1A_ANAME(IFORW),L1A_ANAME(IFORWW)
            CALL MSGERR(MDOC,LINE)
            IF(IERR.EQ.3) THEN
              THETADG = ANG3
              THETAD  = ANG3*PI180
            ELSE
              THETAD  = THETA_D
              THETADG = THETA_DG
            ENDIF
            WRITE(LINE,
     *      '(''         Default value : '',F8.3)') THETADG
            CALL MSGERR(MDOC,LINE)
            IERR = 0
            CALL PUT_TO_ANGLE_LIST(MDOC,II,IFORW,IFORWW,THETADG,IERR)
            IF(IERR.NE.0) RETURN
            ANG3  = THETAD
          ELSE
            ANG3  = ANG3*PI180
            IERR = 0
          ENDIF

          CALL SRCH_BOND(MDOC,MON,IFORW,IFORWW,AV4,LB,IERR)
          IF(IERR.NE.0) THEN
            WRITE(LINE,
     *      '(''WARNING: no bond : '',A4,'' -> '',A4)')
     *      L1A_ANAME(IFORW),L1A_ANAME(IFORWW)
            CALL MSGERR(MDOC,LINE)
            IF(IERR.EQ.3) THEN
              AVD = AV4
            ELSE
              IF(L1A_SYMB(IFORWW).NE.'H   '.AND.
     *           L1A_SYMB(IFORWW).NE.'D   ') THEN
                AVD = 1.45
              ELSE
                AVD = 1.0
              ENDIF
            ENDIF
            WRITE(LINE,'(''           Default =  '',F8.3)') AVD
            CALL MSGERR(MDOC,LINE)
            CH8 = 'coval'
            CALL PUT_TO_BOND_LIST(MDOC,IFORW,IFORWW,AVD,CH8,IERR)
            IF(IERR.NE.0) RETURN
            AV4  = AVD
            IERR = 0
          ENDIF

          NEXT = IFORWW
          PH   = 0.0
          CALL COORD_4(AV2,AV3,AV4,V2,V3,ANG2,ANG3,PH,V4)
          L1A_X     (NEXT)    = L1A_X(IFORW)+V4(1)
          L1A_Y     (NEXT)    = L1A_Y(IFORW)+V4(2)
          L1A_Z     (NEXT)    = L1A_Z(IFORW)+V4(3)
          L1A_LENGTH(NEXT)    = AV4
          L1A_PHI   (NEXT)    = PH/PI180
          L1A_THETA (NEXT)    = ANG3/PI180
          L1A_ID_PSI(NEXT)    = 'Const'
          L1A_COOR_FLAG(NEXT) = 'Y'

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,'(''= FORWW = th,ph:'',2f8.3)')
     *      L1A_THETA(NEXT),L1A_PHI(NEXT)
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          IF(NT.EQ.1) RETURN

          V1(1) = L1A_X(IFORW) - L1A_X(IFORWW)
          V1(2) = L1A_Y(IFORW) - L1A_Y(IFORWW)
          V1(3) = L1A_Z(IFORW) - L1A_Z(IFORWW)

          V2(1) = L1A_X(II) - L1A_X(IFORW)
          V2(2) = L1A_Y(II) - L1A_Y(IFORW)
          V2(3) = L1A_Z(II) - L1A_Z(IFORW)

          CALL NB_VMOD(V1,AV1)
          CALL NB_VMOD(V2,AV2)
          CALL NB_VPROD(V1,V2,S)
          COSA1= S/(AV1*AV2)
          ANG1 = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
          ANG1 = PI-ANG1
          
          NT_NEW = 0
          DO I=1,NT
            IF(I4(I).NE.IFORW) THEN
              NT_NEW        = NT_NEW + 1
              I4(NT_NEW)    = I4(I)
              AV (NT_NEW)   = AV(I)
              THETA(NT_NEW) = THETA(I)
            ELSE
              IF(L1A_SYMB(I4(I)).EQ.'H   '.OR.
     *          L1A_SYMB(I4(I)).EQ.'D   ') THEN
                NHT = NHT - 1
                NH  = NH  - 1        
              ENDIF
              N = N - 1
            ENDIF
          ENDDO

          NT  = NT_NEW 

C         ISTART = IFORWW 

          CALL CMP_CRD_MN(MDOC,LIST,MON,IFORWW,IFORW,II
     *    ,N,NE,NT,I4,NH,NHT
     *    ,V_0,V_1,ITYPE,AV,THETA,THETA_D,V1,V2,AV1,AV2,ANG1
     *    ,ISTART,ISTART2,DUMMY_FLAG,IFIRST,IERR)
          IF(IERR.NE.0) THEN
            CALL MSGERR(MDOC,'ERRROR: in subroutine CMP_CRD_M') 
            RETURN
          ENDIF

C         recalc all psi (1,N) with label ='CONST'

           DO I=1,N

             X4(1) = L1A_X(I4(I))  
             X4(2) = L1A_Y(I4(I))  
             X4(3) = L1A_Z(I4(I)) 

             X3(1) = L1A_X(II)
             X3(2) = L1A_Y(II)
             X3(3) = L1A_Z(II)

             X2(1) = V_0(1)
             X2(2) = V_0(2) 
             X2(3) = V_0(3)

             X1(1) = V_1(1)
             X1(2) = V_1(2) 
             X1(3) = V_1(3) 

             CALL CALC_TORS_FROM_COORDS(X1,X2,X3,X4,ANGOBS)

             L1A_PHI(I4(I)) = ANGOBS/PI180
 
           ENDDO

        ENDIF

      ELSE 

C       10 grad = 0.175
        D    = PI - 0.175/2.0                                 
        II1 = I1
        II2 = I2
        III = II 
 400    CONTINUE

        IF(ANG1.GT.D.AND.II2.GT.0) THEN
          III = II2
          CALL GET_VECTOR(III,V_0,V_1,VV1,VV2,II1,II2)
          CALL NB_VMOD(VV1,AVV1)
          CALL NB_VMOD(VV2,AVV2)
          CALL NB_VPROD(VV1,VV2,S)
          COSA1 = S/(AVV1*AVV2)
          ANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
          ANG1  = PI-ANG1
          V1(1) = VV1(1)
          V1(2) = VV1(2)
          V1(3) = VV1(3)
          AV1   = AVV1
C         II2   = L1A_IBACK(III)   
          GO TO 400
        ENDIF

        CALL CMP_CRD_MN(MDOC,LIST,MON,I1,I2,II,N,NE,NT,I4,NH,NHT
     *   ,V_0,V_1,ITYPE,AV,THETA,THETA_D,V1,V2,AV1,AV2,ANG1
     *   ,ISTART,ISTART2,DUMMY_FLAG,IFIRST,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,'ERRROR: in subroutine CMP_CRD_M') 
          RETURN
        ENDIF
        
      ENDIF
C --
      RETURN
      END

      SUBROUTINE CMP_CRD_MN(MDOC,LIST,MON,I1,I2,II,N,NE,NT,I4,NH,NHT
     * ,V_0,V_1,ITYPE,AV,THETA,THETA_D,V1,V2,AV1,AV2,ANG1
     * ,ISTART,ISTART2,DUMMY_FLAG,IFIRST,IERR)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------------
      CHARACTER MON*8,LIST*1,DUMMY_FLAG*1
      REAL      V1(3),V2(3),V3(3),X(3),V_0(3),V_1(3),Y(3)
      REAL      AV   (20),XN(3),YN(3)
      REAL      THETA(20),PHI(20),ANGLE(20,20),PHIJ(20)
      INTEGER   IFLAG_P(20),I4(20),IR_ATM(20),IMC(10)
      REAL      X1(3),X2(3),X3(3),X4(3)
      LOGICAL   IS_IT_METAL
      EXTERNAL  IS_IT_METAL
C
      real      temp(20)

      CHARACTER LINE*256,CH8*8,SIGN*8
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------
C     I2 # 0 
C 
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,'==============================')
      ENDIF
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
      DLT   = (5.0*PI)/12.0
      IF(NT.LE.0) RETURN 
C ----------
        IF(LIST.EQ.'T') THEN
          WRITE(LINE,'(''=== cmp_crd_m:II,I2,I1,n,ne,nt:'',6i4)')
     *    II,I2,I1,n,ne,nt 
          CALL MSGDOC(MDOC,LINE)
          LINE = 'A(II):'//L1A_ANAME(II)
          IF(I2.GT.0) THEN
            LINE ='A(II):'//L1A_ANAME(II)//' BACK(I2):'//L1A_ANAME(I2)
          ENDIF 
          CALL MSGDOC(MDOC,LINE)
          WRITE(LINE,'(''I4:'',10I4)')
     *    (I4(JJJ),JJJ=1,NT)
          CALL MSGDOC(MDOC,LINE)
          WRITE(LINE,'(''v1:'',4f10.3)')
     *    av1,v1(1),v1(2),v1(3)
          CALL MSGDOC(MDOC,LINE)
          WRITE(LINE,'(''v2:'',4f10.3)')
     *    av2,v2(1),v2(2),v2(3)
          CALL MSGDOC(MDOC,LINE)
          T = ang1/pi180
          WRITE(LINE,'(''ang1,v00:'',4f10.3)')
     *    t,v_0(1),v_0(2),v_0(3)
          CALL MSGDOC(MDOC,LINE)
          WRITE(LINE,'(''v01:'',4f10.3)')
     *    av2,v_1(1),v_1(2),v_1(3)
          CALL MSGDOC(MDOC,LINE)
       ENDIF
C --
      DO I=1,NT
        IFLAG_P(I) = 0
        PHI    (I) = 0.0
      ENDDO
      THETA_DG = THETA_D/PI180
C -----
      IF(LIST.EQ.'T') THEN
        Nttt = NT
        IF(NTTT.GT.8) NTTT = 8
        DO I=1,NTTT
          TEMP(I) = THETA(I)/PI180
        ENDDO
        WRITE(LINE,'(''=== theta:'',8f8.3)')
     *  (TEMP(K),K=1,NTTT)
        CALL MSGDOC(MDOC,LINE)
      ENDIF

C --- first. phi --

      IPHI0 = 0
      PHI0  = 0.0
      II1   = 0
      DO I=1,NT
        CALL SRCH_TORS(MDOC,MON,I1,I2,II,I4(I)
     *                          ,VAL,LT,INV,IERR)
        IF(IERR.NE.0) THEN
          IERR = 0
        ELSE
          IPHI0 = I           
          VAL = VAL*PI180
          IF(VAL.GE. TWOPI) VAL = VAL - TWOPI
          IF(VAL.LE.-TWOPI) VAL = VAL + TWOPI
          IF(VAL.GT.  PI  ) VAL = VAL - TWOPI
          IF(VAL.LE. -PI  ) VAL = VAL + TWOPI
          IPHI0  = I
          PHI0   = VAL
          II1    = I1           
          IF(L1T_LABEL(LT)(1:1).EQ.'C') THEN
            IFLAG_P(I) = 3
          ELSE
            IFLAG_P(I) = 2
          ENDIF
          GO TO 100
        ENDIF

      ENDDO

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) ' L1A_NDIST(I2):',L1A_NDIST(I2)
        CALL MSGDOC(MDOC,LINE)
      ENDIF


      IF(L1A_NDIST(I2).GT.0) THEN
        DO I=1,NT
        DO J=1,L1A_NDIST(I2)
          CALL SRCH_TORS(MDOC,MON,L1A_CONN(J,I2),I2,II,I4(I)
     *                          ,VAL,LT,INV,IERR)
          IF(IERR.NE.0) THEN
            IERR = 0
          ELSE
            IPHI0 = I           
            VAL = VAL*PI180
            IF(VAL.GE. TWOPI) VAL = VAL - TWOPI
            IF(VAL.LE.-TWOPI) VAL = VAL + TWOPI
            IF(VAL.GT.  PI  ) VAL = VAL - TWOPI
            IF(VAL.LE. -PI  ) VAL = VAL + TWOPI
            IPHI0  = I
            PHI0   = VAL
            II1    = L1A_CONN(J,I2)
            IF(L1T_LABEL(LT)(1:1).EQ.'C') THEN
              IFLAG_P(I) = 3
            ELSE
              IFLAG_P(I) = 2
            ENDIF
            GO TO 100
          ENDIF

        ENDDO
        ENDDO 
      ENDIF

      IF(L1A_NEXTR(I2).GT.0) THEN
        DO I=1,NT
        DO J=1,L1A_NEXTR(I2)
          CALL SRCH_TORS(MDOC,MON,L1A_IEXTR(J,I2),I2,II,I4(I)
     *                            ,VAL,LT,INV,IERR)
          IF(IERR.NE.0) THEN
            IERR = 0
          ELSE
            IPHI0 = I           
            VAL = VAL*PI180
            IF(VAL.GE. TWOPI) VAL = VAL - TWOPI
            IF(VAL.LE.-TWOPI) VAL = VAL + TWOPI
            IF(VAL.GT.  PI  ) VAL = VAL - TWOPI
            IF(VAL.LE. -PI  ) VAL = VAL + TWOPI
            IPHI0  = I
            PHI0   = VAL
            II1    = L1A_IEXTR(J,I2)
            IF(L1T_LABEL(LT)(1:1).EQ.'C') THEN
              IFLAG_P(I) = 3
            ELSE
              IFLAG_P(I) = 2
            ENDIF
            GO TO 100
          ENDIF

        ENDDO
        ENDDO 
      ENDIF
C ---- 
C     no torsion
      IPHI0 = NT

      IF(I1.GT.0) THEN
        II1 = I1    
      ELSE
        IF(L1A_NDIST(I2).GT.0) THEN
          DO I=1,L1A_NDIST(I2)
            IF(L1A_CONN(I,I2).NE.II) THEN
              II1 = L1A_CONN(I,I2)
              GO TO 200
            ENDIF
          ENDDO
        ENDIF
        IF(L1A_NEXTR(I2).GT.0) II1 = L1A_IEXTR(1,I2)
 200    CONTINUE
      ENDIF 

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) ' II1:',ii1,iphi0
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      IF(II1.GT.0) THEN
C         
C      I1....I2--->II--->I0
C             \
C              \
C               II1
C
C          I2: chir or plan
C
        LINE = 
     *' WARNING: in CMP_CRD_MN: missing tors.:'//L1A_ANAME(I2)
     *         //' - '//L1A_ANAME(II)     
c        CALL MSGERR(MDOC,LINE)
        NV = 0
        NC = 0  
        CALL SET_VTORS(MDOC,II1,I2,II,I4(IPHI0),NV,NC,IERR)
        IF(IERR.NE.0) RETURN

        PHI0 = L1T_VAL(L1T_NTORS)*PI180
        IFLAG_P(IPHI0) = 2
        IF(L1T_LABEL(L1T_NTORS)(1:5).EQ.'CONST') IFLAG_P(IPHI0) = 3
      ELSE
        PHI0           = 0.0
        IFLAG_P(IPHI0) = 3
      ENDIF


 100  CONTINUE

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) ' i1,II1:',i1,ii1,i2,iphi0,phi0
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      IF(II1.NE.I1.AND.II1.GT.0) THEN
C       coords for I0 (II1-I2-II-I0 )

        X1(1) = L1A_X(I2) - L1A_X(II1)
        X1(2) = L1A_Y(I2) - L1A_Y(II1)
        X1(3) = L1A_Z(I2) - L1A_Z(II1)

        X2(1) = L1A_X(II) - L1A_X(I2)
        X2(2) = L1A_Y(II) - L1A_Y(I2)
        X2(3) = L1A_Z(II) - L1A_Z(I2)

        CALL NB_VMOD(X1,AX1)
        CALL NB_VMOD(X2,AX2)
        CALL NB_VPROD(X1,X2,S)
        COSA1= S/(AX1*AX2)
        AANG1 = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
        AANG1 = PI-AANG1
        AANG2 = THETA(IPHI0)

        CALL COORD_4(AX1,AX2,AV(IPHI0),X1,X2,AANG1,AANG2,PHI0,X4)

C       recalc tors for I1-I2-II-I0 

        X4(1) = L1A_X(II) + X4(1) 
        X4(2) = L1A_Y(II) + X4(2) 
        X4(3) = L1A_Z(II) + X4(3) 

        X3(1) = L1A_X(II)
        X3(2) = L1A_Y(II)
        X3(3) = L1A_Z(II)

        X2(1) = L1A_X(I2)
        X2(2) = L1A_Y(I2)
        X2(3) = L1A_Z(I2)

        IF(I1.GT.0) THEN
          X1(1) = L1A_X(I1)
          X1(2) = L1A_Y(I1)
          X1(3) = L1A_Z(I1)
        ELSE
          X1(1) =-V1(1)
          X1(2) =-V1(2) 
          X1(3) =-V1(3) 
        ENDIF

        CALL CALC_TORS_FROM_COORDS(X1,X2,X3,X4,ANGOBS)

        PHI0           = ANGOBS
        IFLAG_P(IPHI0) = 3

      ENDIF

      IF(LIST.EQ.'T') THEN
        T = PHI0/PI180
        WRITE(LINE,'('' IPHI0,I1,II1,PHI0:'',3I4,f8.3)')
     *  IPHI0,I1,II1,T
        CALL MSGDOC(MDOC,LINE)
      ENDIF

C ----
        IF(LIST.EQ.'T') THEN
          WRITE(LINE,'('' -->NT:'',I4)') NT
          CALL MSGDOC(MDOC,LINE)
        ENDIF
C ----      
      IF(IS_IT_METAL(L1A_SYMB(II))) THEN
        IB = I2          
        CALL SRCH_METAL_CHIR(MDOC,MON,II,IB,IBC,IFR,IMC
     *                                   ,ICROSS,SIGN,LC,IERR)
        IF(IERR.NE.0) THEN
          IERR = 0
          DO I=1,NT
            IB = I4(I)
            CALL SRCH_METAL_CHIR(MDOC,MON,II,IB,IBC,IFR,IMC
     *                                   ,ICROSS,SIGN,LC,IERR)
            IF(IERR.EQ.0) GO TO 500
          ENDDO
        ENDIF

 500    CONTINUE
        IF(IERR.EQ.0) THEN       

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,'(''met_chir:'',5I4)') II,ICROSS,LC,IBC,IFR
            CALL MSGDOC(MDOC,LINE)
            WRITE(LINE,'(''    IMCr:'',5I4)') 
     *      IMC(1),IMC(2),IMC(3),IMC(4),IMC(5)
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          IF(SIGN(1:4).EQ.'cros') THEN
            IF(ICROSS.EQ.2) THEN
              IB = I2
              IF(IB.NE.IBC.AND.IB.NE.IFR.AND.
     *                         IB.NE.L1C_I4ATM(LC)) IMC(2) = IB
              DO J=1,NT
                IAA=I4(J)
                IF(IAA.NE.IBC.AND.IAA.NE.IFR.AND.
     *          IAA.NE.L1C_I4ATM(LC)) IMC(2) = IAA
              ENDDO          
            ENDIF
          ELSE

          ENDIF  

          IF(I2.EQ.IBC.OR.I2.EQ.IFR) THEN
            DO I=1,NT
              IA4 = I4(I)
              IF(IA4.EQ.IBC.OR.IA4.EQ.IFR) THEN
                PH = 180.0
                GO TO 600
              ELSE IF(ICROSS.GT.0) THEN
                PH = 0.0
                DO J=1,ICROSS 
                  IF(IA4.EQ.IMC(J)) THEN 
                    PH = FLOAT((360*(J-1))/ICROSS)
                    IF(I2.EQ.IFR) PH = -PH
                    GO TO 600
                  ENDIF
                ENDDO
              ENDIF
C             not such atom(IA4) in the tors list 
 600          CONTINUE
              PHI(I) = PH*PI180 
            ENDDO
          ELSE
            JJ = 0
            DO I=1,NT
              IA4 = I4(I)
              IF(IA4.EQ.IBC.OR.IA4.EQ.IFR) THEN
                IF(IA4.EQ.IBC) PH = 0.0
                IF(IA4.EQ.IFR) PH = 180.0 
                GO TO 700
              ELSE IF(ICROSS.GT.0) THEN
                PH = 90.0
                DO J=1,ICROSS 
                  IF(IA4.EQ.IMC(J)) THEN 
                    JJ = JJ + 1
                    PH = 90.0
                    IF(JJ.GT.(ICROSS/2)) PH =-90 
                    GO TO 700
                  ENDIF
                ENDDO
              ENDIF
C             not such atom(IA4) in the tors list 
 700          CONTINUE
              PHI(I) = PH*PI180 
            ENDDO
          ENDIF  
          GO TO 400
        ENDIF      
        IERR = 0
      ENDIF

      IF(NT.EQ.1) THEN

      ELSE IF(NT.EQ.2) THEN
C
C                IPHI0
C               /
C        I2-->II
C               \
C                IPHI
C
        IPHI = 1
        IF(I4(IPHI).EQ.I4(IPHI0)) IPHI = 2
 
        CALL SRCH_CHIR(MDOC,MON,II,I2,I4(IPHI),I4(IPHI0)
     *                      ,VOL,LC,IS,IERR)
        IF(IERR.EQ.0) THEN

          IFLAG_P(IPHI) = 3
          IF(IS.EQ.-1) THEN
            PHI(IPHI) =-120.0*PI180
          ELSE
            PHI(IPHI) = 120.0*PI180
          ENDIF

        ELSE
 
          IERR          = 0          
          PHI(IPHI)     = 180.0*PI180
          IFLAG_P(IPHI) = 3
 
        ENDIF

        IF(LIST.EQ.'T') THEN
          T = PHI(IPHI)/PI180
          WRITE(LINE,'('' IPHI,LC,PHI:'',2I4,f8.3)')
     *    IPHI,LC,T
          CALL MSGDOC(MDOC,LINE)
        ENDIF

  
      ELSE IF(NT.EQ.3) THEN
C
C                IPHI0
C               /
C        I2-->II-- IPHI1
C               \
C                IPHI2
C

        IS    = 1
        IPHI1 = 1
        IF(I4(IPHI1).EQ.I4(IPHI0)) THEN
          IPHI1 = 2
          IPHI2 = 3
        ELSE
          IPHI2 = 2
          IF(I4(IPHI2).EQ.I4(IPHI0)) IPHI2 = 3
        ENDIF 

        IF(LIST.EQ.'T') THEN
          WRITE(LINE,'('' IS,IPHI1,IPHI2:'',5I4)')
     *    IS,IPHI1,IPHI2
          CALL MSGDOC(MDOC,LINE)
        ENDIF
  
        CALL SRCH_CHIR(MDOC,MON,II,I2,I4(IPHI1),I4(IPHI0)
     *                      ,VOL,LC,IS,IERR)
        IF(IERR.EQ.0) THEN

        IF(LIST.EQ.'T') THEN
          WRITE(LINE,'('' srch_chir1:'',6I4)')
     *    II,I2,I4(IPHI1),I4(IPHI0),lc,is
          CALL MSGDOC(MDOC,LINE)
        ENDIF

        ELSE
 
          IERR      = 0          
          CALL SRCH_CHIR(MDOC,MON,II,I2,I4(IPHI2),I4(IPHI0)
     *                      ,VOL,LC,ISS,IERR)
          IF(IERR.EQ.0) THEN

            IF(LIST.EQ.'T') THEN
              WRITE(LINE,'('' srch_chir2:'',6I4)')
     *        II,I2,I4(IPHI2),I4(IPHI0),lc,iss
              CALL MSGDOC(MDOC,LINE)
            ENDIF

            I     = IPHI1
            IPHI1 = IPHI2
            IPHI2 = I
            IS    = ISS
          ELSE
            IERR = 0
            CALL SRCH_CHIR(MDOC,MON,II,I2,I4(IPHI2),I4(IPHI1)
     *                      ,VOL,LC,ISS,IERR)
            IF(IERR.EQ.0) THEN

              IF(LIST.EQ.'T') THEN
                WRITE(LINE,'('' srch_chir3:'',6I4)')
     *          II,I2,I4(IPHI2),I4(IPHI1),lc,iss
                CALL MSGDOC(MDOC,LINE)
              ENDIF

              IS = ISS
            ELSE  
              IERR      = 0          
              CALL SRCH_CHIR(MDOC,MON,II,I4(IPHI0),I4(IPHI1)
     *                      ,I4(IPHI2),VOL,LC,ISS,IERR)
              IF(IERR.EQ.0) THEN

                IF(LIST.EQ.'T') THEN
                  WRITE(LINE,'('' srch_chir4:'',6I4)')
     *            II,I4(IPHI0),I4(IPHI1),I4(IPHI2),lc,iss
                  CALL MSGDOC(MDOC,LINE)
                ENDIF

                IS = ISS
              ELSE

              ENDIF
            ENDIF

          ENDIF

        ENDIF

        IF(LIST.EQ.'T') THEN
          WRITE(LINE,'('' IERR,LC,IS,IPHI1,IPHI2:'',5I4)')
     *    IERR,LC,IS,IPHI1,IPHI2
          CALL MSGDOC(MDOC,LINE)
        ENDIF

        IF(IERR.NE.0) THEN 
          NPA = 0
          IF(L1P_NPLAN.GT.0) THEN
            DO  IP=1,L1P_NPLAN
              NPA = 0
              DO  I = 1,L1P_NATOM(IP)
                IATOM = L1P_ATOM(I,IP)
                IF(L1A_ANAME(II).EQ.ATOM) THEN
                  NPA=NPA+1
                ENDIF
                IF(L1A_ANAME(I2).EQ.ATOM) THEN
                  NPA=NPA+1
                ENDIF
                IF(L1A_ANAME(I4(IPHI0)).EQ.ATOM) THEN
                  NPA=NPA+1
                ENDIF
                IF(L1A_ANAME(I4(IPHI1)).EQ.ATOM) THEN
                  NPA=NPA+1
                ENDIF
                IF(L1A_ANAME(I4(IPHI2)).EQ.ATOM) THEN
                  NPA=NPA+1
                ENDIF
              ENDDO
              IF(NPA.EQ.5) GO TO 300
            ENDDO
          ENDIF
 300      CONTINUE


          IF(LIST.EQ.'T') THEN
            WRITE(LINE,'('' NPA:'',I4)') NPA
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          IF(NPA.EQ.5) THEN
C           10 grad = 0.175
            D = PI - 0.175                                 
            IF(THETA(IPHI0).GT.D) THEN
C             ???
              THETA(IPHI1) = 0.0
              THETA(IPHI2) = 180.0*PI180 
            ELSE
              IF(THETA(IPHI1).GT.D) THEN        
                THETA(IPHI1) = 0.0
                THETA(IPHI2) = 180.0*PI180 
              ELSE
                THETA(IPHI1) = 180.0*PI180
                THETA(IPHI2) = 0.0 
              ENDIF     
            ENDIF
          ELSE
            IERR = 0
            IS   = 1
          ENDIF
        ENDIF

        IF(IERR.EQ.0) THEN 
          IFLAG_P(IPHI1) = 3
          IFLAG_P(IPHI2) = 3
          IF(IS.EQ.-1) THEN
            PHI(IPHI1) =-120.0*PI180
            PHI(IPHI2) = 120.0*PI180
          ELSE
            PHI(IPHI1) = 120.0*PI180
            PHI(IPHI2) =-120.0*PI180
          ENDIF
        ENDIF
        IERR = 0

        IF(LIST.EQ.'T') THEN
          T  = PHI(IPHI1)/PI180
          T1 = PHI(IPHI2)/PI180
          WRITE(LINE,'('' IPHI1,IPHI2,PH1,PH2:'',2I4,2f8.3)')
     *    IPHI1,IPHI2,T,T1
          CALL MSGDOC(MDOC,LINE)
        ENDIF


      ELSE IF(NT.EQ.4) THEN
        WRITE(LINE,'('' ERROR: nt = 4 for '',I6)') II     
        CALL MSGERR(MDOC,LINE)
        IERR = 1
        RETURN
      ELSE
        WRITE(LINE,'('' ERROR: nt > 4 for '',I6)') II     
        CALL MSGERR(MDOC,LINE)
        IERR = 1
        RETURN
      ENDIF 
C ----
C ----
 400  CONTINUE
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,'--coord--')
      ENDIF

      DO  J=1,NT
        AV3  = AV   (J)
        ANG2 = THETA(J)
        PH   = PHI  (J) + PHI0
        T    = PH

        CALL COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PH,V3)

        IF(J.LE.N.OR.IFIRST.GT.0) THEN
          L1A_X     (I4(J))  = L1A_X(II)+V3(1)
          L1A_Y     (I4(J))  = L1A_Y(II)+V3(2)
          L1A_Z     (I4(J))  = L1A_Z(II)+V3(3)
          L1A_LENGTH(I4(J))  = AV3
          L1A_THETA (I4(J))  = ANG2/PI180
          IF(PH.GE. TWOPI) PH = PH - TWOPI
          IF(PH.LE.-TWOPI) PH = PH + TWOPI
          IF(PH.GT.  PI  ) PH = PH - TWOPI
          IF(PH.LE. -PI  ) PH = PH + TWOPI
          L1A_PHI   (I4(J))    = PH  /PI180
          L1A_ID_PSI(I4(J))    = 'CONST'
          IF(IFLAG_P(J).EQ.2) L1A_ID_PSI(I4(J)) = 'var'
          L1A_COOR_FLAG(I4(J)) = 'Y'

          IF(LIST.EQ.'T') THEN
            kk=I4(J)
            WRITE(line,*)'-:',kk,L1A_X(kk),L1A_Y(kk),L1A_Z(kk)
            CALL MSGDOC(MDOC,LINE)
            WRITE(line,*)'-:',L1A_LENGTH(kk),L1A_THETA(kk),L1A_PHI(kk)
            CALL MSGDOC(MDOC,LINE)
          ENDIF
        ENDIF

        IF(J.GT.N) THEN
          IF(DUMMY_FLAG.EQ.'Y') THEN
            CALL ADD_DUMMY_ATOM(MDOC,LIST,I4(J),J,II,V3,AV3,ANG2
     *                         ,PH,IPHI0,IERR)
            IF(IERR.NE.0) RETURN
          ENDIF
        ENDIF

        IF(LIST.EQ.'T') THEN
          T = T/PI180
          WRITE(LINE,'(''>>>J,N,I4,II:'',4i4,2F10.3,I4)') 
     *      J,N,I4(J),II,L1A_PHI(I4(J)),T,IFLAG_P(J)
          CALL MSGERR(MDOC,LINE)
          T = ANG1/PI180
          WRITE(LINE,'(''>>>I1,I2,ANG1,AV1,AV2:'',2i4,3F10.3)') 
     *    I1,I2,T,AV1,AV2
          CALL MSGERR(MDOC,LINE)
        ENDIF
        
      ENDDO

      RETURN
      END

      SUBROUTINE CALC_TORS_FROM_COORDS(XX1,XX2,XX3,XX4,ANGOBS)
C -----------------------------------------------
C -P- CALC_TRSOBS - 
C -S-
C              IA1        IA2        IA3      IA4
C               I3 - 1 -> I2  - 2 -> I1 - 3 -> I
      REAL      ANGOBS
      REAL      XX1(3),XX2(3),XX3(3),XX4(3)
C ---
C ******
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      X1 = XX1(1)
      Y1 = XX1(2)
      Z1 = XX1(3)

      X2 = XX2(1)
      Y2 = XX2(2)
      Z2 = XX2(3)

      X3 = XX3(1)
      Y3 = XX3(2)
      Z3 = XX3(3)

      X4 = XX4(1)
      Y4 = XX4(2)
      Z4 = XX4(3)

      A3 = X4-X3
      B3 = Y4-Y3
      C3 = Z4-Z3
      A2 = X3-X2
      B2 = Y3-Y2
      C2 = Z3-Z2
      A1 = X2-X1
      B1 = Y2-Y1
      C1 = Z2-Z1
      DN1X = B1*C2-B2*C1
      DN1Y = A1*C2-A2*C1
      DN1Z = A1*B2-A2*B1
      DN2X = B2*C3-B3*C2
      DN2Y = A2*C3-A3*C2
      DN2Z = A2*B3-A3*B2
      E1   = DN1X*DN2X+DN1Y*DN2Y+DN1Z*DN2Z
      E2   = SQRT(DN1X*DN1X+DN1Y*DN1Y+DN1Z*DN1Z)
      E3   = SQRT(DN2X*DN2X+DN2Y*DN2Y+DN2Z*DN2Z)
      IF(E2.LT.1.E-9.OR.E3.LT.1.E-9) THEN
        IF(E1.GE.0.) COSG=1.
        IF(E1.LT.0.) COSG=-1.
      ELSE
        COSG = E1/(E2*E3)
      ENDIF
C---------------NOW WE ARE CALCULATING MIXED VECTORS------------------
C-----ABC=A1*(B2*C3-B3*C2)-A2*(B1*C3-B3*C1)+A3*(B1*C2-B2*C1) !-------
C------------------------------------------------------------------
      ABC    = A1*DN2X-A2*(B1*C3-B3*C1)+A3*DN1X
      SS     = ABS(1.0 - COSG*COSG)
      SING   = SIGN(1.0,ABC)*SQRT(SS)
      ANGOBS = ATAN2(SING,COSG)
      IF(ANGOBS.GT. PI ) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LE.-PI ) ANGOBS = ANGOBS + TWOPI

      RETURN
      END

      SUBROUTINE CREAT_MIN_FROM_SMILE(MDOC,LIST
     *     ,natommax,natom,latom_charge,latom_nhydr
     *     ,latom_weight,latom_name,latom_chiral
     *     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *     ,MON,NAMEI,NAMEO,IERR)
C -------------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER NAMEI*(*),NAMEO*(*)
      CHARACTER PATH*80,EXT*80
      CHARACTER LINE*1034,MON*8,LIST*1
      CHARACTER STRING*1024   
      integer   natommax,natom
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      integer   ntorsmax
      integer   ntors,ltors_period(ntorsmax)
      integer   ltors_atom(4,ntorsmax)
      real      ltors(2,ntorsmax)
C
      INTEGER   IUN,M,IMODE,LEN,L,LL,IEND,JP,IP
c ---
      INCLUDE 'crd_com.fh'
C -----------------------------------
      IERR = 0
      M    = 99
C ----------------------------------
      PATH  = ' '
      EXT   = ' '
      IUN   = CRO_IUN
      CALL OPENFR(IUN,M,PATH,NAMEI,EXT,IERR)
      CRO_IUN = IUN
      IF(IERR.NE.0) THEN
        IERR=1  
        CALL MSGERR(MDOC,' ERROR: OPEN INPUT_SMILE_FILE')
        RETURN
      ENDIF
      LEN    = 1
      IEND   = 0
      STRING = ' ' 
 100  CONTINUE
      LINE   = ' '
      READ(IUN,'(A)',END=200,ERR=900) LINE
      GO TO 110
 200  CONTINUE
      IEND = 1
 110  CONTINUE
      CALL LENSTR_BL(LINE,L)
      IF(L.GT.0) THEN
         IMODE = 0
         CALL CHECK_LINE(IMODE,LINE)
C ------------------------------------------
C -P- CHECK_LINE - check and convert symbols of line.
C               MODE  0  only check
C                    -1  convert symbols to low case.
C                     1  to upper
C ---------------------------------------------
      ENDIF
      CALL LENSTR_BL(LINE,L)
      IF(L.GT.0) THEN
        LL = LEN + L - 1
        IF(LL.GT.1024) THEN
          CALL MSGERR(MDOC,' ERROR: smile string lenght > 1024')
          IERR = 1
          RETURN 
        ENDIF
        STRING(LEN:LL) = LINE(1:L)
        LEN = LEN + L 
      ENDIF
      IF(IEND.LE.0) GO TO 100
      CLOSE(IUN)
C ----
      CALL LENSTR_BL(STRING,L)
      IF(L.LE.0) THEN
        CALL MSGERR(MDOC,
     *  ' ERROR: Empty SMILE string, please check file')
        IERR = 1
        RETURN
      ENDIF
      JP = 0
      LINE = ' '
      DO IP=1,L
        IF(STRING(IP:IP).NE.' ') THEN
          JP = JP +1
          LINE(JP:JP) = STRING(IP:IP)
        ENDIF
      ENDDO
      STRING = LINE
      CALL LENSTR_BL(STRING,L)
      IF(L.LE.0) THEN
        CALL MSGERR(MDOC,
     *  ' ERROR: Empty SMILE string, please check file')
        IERR = 1
        RETURN
      ENDIF
 
c      IF(LIST.EQ.'T') THEN
        LL = L
        IF(L.GT.69) LL = 69
        IF(L.GT.LL) THEN
          LINE = 'smile <'//STRING(1:LL)//'...'        
        ELSE
          LINE = 'smile <'//STRING(1:LL)//'>'        
        ENDIF
        CALL MSGERR(MDOC,LINE)
c      ENDIF
C ----
      CALL SMILE2DICT(MDOC,LIST,MON,STRING
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *       ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *       ,CRO_IUN,NAMEO,IERR)
C ----
      RETURN
 900  CONTINUE
      CLOSE(IUN)
      CALL MSGERR(MDOC,' ERROR: READING INPUT_SMILE_FILE')
      IERR = 1
      RETURN
      END

      SUBROUTINE SMILE2DICT(MDOC,LIST,COMP_ID,STRING
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *       ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *                      ,CRO_IUN,NAMEO,IERR)
c -------------------------
      implicit none
      INTEGER   MDOC,IERR,CRO_IUN
      CHARACTER STRING*(*),NAMEO*(*),LIST*1,COMP_ID*8
C
      integer   natommax,nbondmax,ntorsmax,nchirmax
      parameter ( nbondmax = 500 )
      parameter ( nchirmax = 100 )
      integer   natom,latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      character latom_case(natommax)
      integer   nbond,lbond1(nbondmax),lbond2(nbondmax)
      integer   lbond_flag(nbondmax)
      character lbond_order(nbondmax)*8
      integer   ntors,ltors_atom(4,ntorsmax),ltors_period(ntorsmax)
      real      ltors(2,ntorsmax)
      integer   nchir,lchir_atom(9,nchirmax)
      character lchir_sign(nchirmax)*8
C 
      CHARACTER ERR_MESSAGE*80,PATH*80,EXT*80
      INTEGER   LEN,IP,IUN,M,L
C -----------------------------------
      CALL LENSTR_BL(COMP_ID,L)
      IF(L.LE.0) THEN
        COMP_ID = 'SMILE'
      ENDIF
C ---
      CALL s2min(string,LEN,IP,err_message
     * ,natommax,nbondmax,ntorsmax,nchirmax
     * ,natom,latom_name,latom_chiral,latom_case,latom_charge
     * ,latom_nhydr,latom_weight
     * ,nbond,lbond1,lbond2,lbond_order,lbond_flag
     * ,ntors,ltors_atom,ltors_period,ltors
     * ,nchir,lchir_atom,lchir_sign,IERR)
c -------------------------
      CALL WRITE_ERR_MASSAGE(MDOC,STRING,LEN,IP
     * ,ERR_MESSAGE,IERR)
      IF(IERR.NE.0) RETURN
c -------------------------
c      NAMEO = 'libcheck_min_smile.cif'

      CALL LENSTR_BL(NAMEO,L)
      IF(L.GT.0.AND.NAMEO(1:1).NE.' '.AND.NAMEO(1:1).NE.',') THEN
      ELSE
        NAMEO = 'libcheck.lib'
      ENDIF
      PATH  = ' '
      EXT   = ' '
      IUN   = CRO_IUN
      M     = 99
      CALL OPENFW(IUN,M,PATH,NAMEO,EXT,IERR)
      CRO_IUN = IUN
      IF(IERR.NE.0) THEN
        IERR=1  
        CALL MSGERR(MDOC,' ERROR: OPEN OUTPUT_FILE_SMILE ')
        RETURN
      ENDIF

      CALL WRITE_S2MIN(MDOC,IUN,COMP_ID
     * ,natom,latom_name,latom_charge,latom_weight
     * ,nbond,lbond1,lbond2,lbond_order
     * ,ntors,ltors_atom,ltors_period,ltors
     * ,nchir,lchir_atom,lchir_sign,IERR)
C -------------------------
      RETURN
      END

      SUBROUTINE WRITE_ERR_MASSAGE(MDOC,STRING,LEN,IP
     * ,ERR_MESSAGE,IERR)
c -------------------------
      implicit none
      INTEGER   MDOC,LEN,IP,IERR
      CHARACTER STRING*(*),ERR_MESSAGE*(*)
C
      INTEGER   L,IP1,IP2,IPP
      CHARACTER LINE*256,STR*80
c -------------------------
      IF(IERR.EQ.0) RETURN
      CALL LENSTR_BL(ERR_MESSAGE,L)
      IF(L.LE.0) THEN
        LINE = 'ERROR: in s2min'
      ELSE
        LINE = 'ERROR: in s2min :'//ERR_MESSAGE(1:L)
      ENDIF
      CALL MSGDOC(MDOC,LINE)
      IF(IP.GT.0) THEN
        IP1 = IP - 5
        IP2 = IP + 5
        IF(IP1.LE.0) THEN
          IP1 = 1
        ENDIF
        IF(IP2.GT.L) THEN
          IP2 = L
        ENDIF

        LINE = '-->'//STRING(IP1:IP2)//'<--'
        CALL MSGDOC(MDOC,LINE)

        IPP = max(1,IP2 - IP1 + 1)
        IP  = max(1,IP - IP1  + 1)
        STR(1:IPP) = ' ' 
        STR(IP:IP) = '^'
        LINE = '   '//STR(1:IPP)
        CALL MSGDOC(MDOC,LINE)
        STR(IP:IP) = '!'
        LINE = '   '//STR(1:IPP)
        CALL MSGDOC(MDOC,LINE)

      ENDIF
C ---
      RETURN
      END

      SUBROUTINE WRITE_S2MIN(MDOC,IUN,COMP_ID
     * ,natom,latom_name,latom_charge,latom_weight
     * ,nbond,lbond1,lbond2,lbond_order
     * ,ntors,ltors_atom,ltors_period,ltors
     * ,nchir,lchir_atom,lchir_sign,IERR)
c -------------------------
      implicit none
      INTEGER   MDOC,IUN,IERR
      integer   natom
      real      latom_charge(*)
      real      latom_weight(*)
      character latom_name(*)*4
      integer   nbond,lbond1(*),lbond2(*)
      character lbond_order(*)*8
      integer   ntors,ltors_atom(4,*),ltors_period(*)
      real      ltors(2,*)
      integer   nchir,lchir_atom(9,*)
      character lchir_sign(*)*8
      INTEGER   I,J,ICROSS
      CHARACTER LINE*256,COMP_ID*8,SYMB*4,CH1*1,CH2*2,CHAR8*8
      CHARACTER ATOM(9)*4
c -------------------------

      WRITE(LINE,'(''data_comp_list'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.id'')')
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
c      WRITE(LINE,'(''_chem_comp.three_letter_code'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.name'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.group'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.number_atoms_all'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C      WRITE(LINE,'(''_chem_comp.number_atoms_nh'')')
C      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.desc_level'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      WRITE(LINE,100)
     *         COMP_ID,'.','.',natom,'M'

      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  100 FORMAT(A8,1X,A1,1X,A1,1X,I4,1X,A1)

C ------------

      WRITE(LINE,'(''data_comp_'',A8)') COMP_ID
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_atom.comp_id'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_atom.atom_id'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_atom.type_symbol'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_atom.partial_charge'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      DO I=1,natom

        SYMB = latom_name(I)(1:2)//'  '
        CALL CHKSMB(SYMB(2:2),CH1)
        IF(CH1.EQ.'D') SYMB(2:2) = ' '
        
        WRITE(LINE,500) 
     *                COMP_ID,latom_name(I)
     *               ,SYMB,latom_charge(I)

        CALL WRTSTR(IUN,MDOC,LINE,IERR)
  500   FORMAT(1X,A8,6X,A4,1X,A4,3X,F8.3)

      ENDDO 
C ------------
      IF(nbond.LE.0) go to 2000
      
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_bond.comp_id'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_bond.atom_id_1'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_bond.atom_id_2'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_bond.type'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      DO I=1,nbond
        WRITE(LINE,701) 
     *    COMP_ID
     *   ,latom_name(lbond1(I)),latom_name(lbond2(I))
     *   ,lbond_order(I)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
 701    FORMAT(1X,A8,1X,A4,1X,A4,4X,A8)
      ENDDO
C ------------
      IF(ntors.GT.0) THEN

        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.comp_id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.atom_id_1'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.atom_id_2'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.atom_id_3'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.atom_id_4'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.value_angle'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.value_angle_esd'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.period'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        
        DO I=1,ntors

          WRITE(CH2,'(I2)') I
          IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
          CHAR8='CONST_'//CH2

          WRITE(LINE,900) 
     *      COMP_ID,CHAR8
     *     ,latom_name(ltors_atom(1,I)),latom_name(ltors_atom(2,I))
     *     ,latom_name(ltors_atom(3,I)),latom_name(ltors_atom(4,I))
     *     ,ltors(1,I),ltors(2,i),ltors_period(I)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
  900     FORMAT(1X,A8,1X,A8,1X,A4,1X,A4,1X,A4,1X,A4,2X
     *              ,F8.3,1X,A1,1X,I3)
        ENDDO
      ENDIF
C ------------
      IF(nchir.GT.0) THEN 

        ICROSS = 0
        DO I=1,nchir
          IF(lchir_sign(I)(1:6).EQ.'cross3'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross4'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross5'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross6'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross7'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross8'    ) ICROSS = 1
        ENDDO

        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.comp_id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.atom_id_centre'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.atom_id_1'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.atom_id_2'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.atom_id_3'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.volume_sign'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(ICROSS.EQ.1) THEN
          WRITE(LINE,'(''_chem_comp_chir.atom_id_4'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_chir.atom_id_5'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_chir.atom_id_6'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_chir.atom_id_7'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_chir.atom_id_8'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF

        DO I=1,nchir

          DO J=1,9
            IF(lchir_atom(J,I).LE.0) THEN
              ATOM(J) = '.'
            ELSE
              ATOM(J) = latom_name(lchir_atom(J,I))
            ENDIF
          ENDDO

          WRITE(CH2,'(I2)') I
          IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
          CHAR8='chir_'//CH2  
          WRITE(LINE,1000) 
     *      COMP_ID,CHAR8
     *     ,ATOM(1),ATOM(2),ATOM(3),ATOM(4)
     *     ,lchir_sign(I)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1000     FORMAT(1X,A8,1X,A8,1X,A4,1X,A4,1X,A4,1X,A4,4X,A8)
          IF(ICROSS.EQ.1) THEN
            WRITE(LINE,1001) 
     *      ATOM(5),ATOM(6),ATOM(7),ATOM(8),ATOM(9)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1001       FORMAT(19X,A4,1X,A4,1X,A4,1X,A4,1X,A4)
          ENDIF
        ENDDO
      ENDIF
C ------------
 2000 CONTINUE          
      END FILE IUN
      CLOSE(IUN)
C ------------

      RETURN
      END

      subroutine s2min(string,l,ip,err_message
     * ,natommax,nbondmax,ntorsmax,nchirmax
     * ,natom,latom_name,latom_chiral,latom_case,latom_charge
     * ,latom_nhydr,latom_weight
     * ,nbond,lbond1,lbond2,lbond_order,lbond_flag
     * ,ntors,ltors_atom,ltors_period,ltors
     * ,nchir,lchir_atom,lchir_sign,ierr)
c -----------------------
      implicit none
      integer   ierr,natommax,nbondmax,ntorsmax,nchirmax
      integer   l,ip,ip_out
      character string*(*),err_message*(*)
      integer   natom,latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      character latom_case(natommax)
      integer   nbond,lbond1(nbondmax),lbond2(nbondmax)
      integer   lbond_flag(nbondmax)
      character lbond_order(nbondmax)*8
      integer   ntors,ltors_atom(4,ntorsmax),ltors_period(ntorsmax)
      real      ltors(2,ntorsmax)
      integer   nchir,lchir_atom(9,nchirmax)
      character lchir_sign(nchirmax)*8
c 
      integer   nstack_branch_max
      parameter ( nstack_branch_max = 30 )
      integer   nstack_branch,latom_branch(nstack_branch_max)
      character latom_branch_order(nstack_branch_max)*8
      integer   nstack_cycle_max
      parameter ( nstack_cycle_max = 99 )
      integer   nstack_cycle,lcycle_atom(nstack_cycle_max)
      integer   lcycle_bond(nstack_cycle_max)
      character lcycle_order(nstack_cycle_max)*8
      integer   natom_prev,icharge,nhydrogens
      integer   i,ip_last,number_value,ifirst
      integer   jb,ib,ib2,ib3,ia,ia1,ia2,ia3,ia4 
      real      atom_weight,valence,val
      character current_bond_order*8  
      character element_name*2,chirality*6,atom_case*1
      character type*1,symbol_str*1,symbol_str_prev*1
c -----------------------
C
      ierr          = 0
      err_message   = ' '
      natom         = 0
      nbond         = 0
      ntors         = 0
      nchir         = 0
      nstack_branch = 0
      nstack_cycle  = 0
      ip            = 0
      l             = 0
      symbol_str    = ' '
      symbol_str_prev = ' '
      ifirst        = 1
C
C
      natom_prev = 0
      current_bond_order = '.'
      do   i=1,nstack_cycle_max
        lcycle_atom(i) = 0
      enddo
C
      ip = 1
      call lenstr_bl(string,l)

      if(l.le.0) then
         err_message = 'Empty SMILE string'
         ierr = 1
         return
      endif

      nhydrogens = 0
C
C---start processing
C
      do while(ip.le.l) 

c       write(*,*) '--ip:',ip,l

        symbol_str_prev = symbol_str
        call element_number_flags(ip,l,ip_out,string
     *       ,symbol_str,atom_weight
     *       ,nhydrogens,icharge
     *       ,element_name,chirality,atom_case,err_message,ierr)
        if(ierr.gt.0) return

        if(element_name.ne.'  ') then

          if(natom.ge.natommax) go to 1000
          natom               = natom + 1
          latom_name(natom)   = element_name//'  '
          latom_weight(natom) = atom_weight
          latom_chiral(natom) = chirality
          latom_charge(natom) = float(icharge)
          latom_case(natom)   = atom_case
c ??? break
          if(natom_prev.le.0.and.nstack_branch.gt.0) then
            do i=nstack_branch,1,-1
              if(latom_branch(i).le.0) then
                latom_branch(i) = natom 
              else
                go to 300
              endif
            enddo
            natom_prev = natom
 300        continue
          endif
c ??? break
          if(natom_prev.gt.0) then
            if(nbond.ge.nbondmax) go to 2000
            nbond = nbond + 1
            lbond1(nbond)     = natom_prev
            lbond2(nbond)     = natom
            lbond_flag(nbond) = 0
            if(latom_case(natom).eq.'l'.and.
     &         latom_case(natom_prev).eq.'l') then
              lbond_order(nbond) = 'aromatic'
            else
              lbond_order(nbond) = current_bond_order
            endif
            current_bond_order = '.'
          endif
          natom_prev = natom
          if(nhydrogens.gt.0) then
            do i=1,nhydrogens
              if(natom.ge.natommax) go to 1000
              natom               = natom + 1
              latom_name(natom)   = 'H   '
              latom_weight(natom) = 1.0
              latom_chiral(natom) = '      '
              latom_charge(natom) = 0.0
              latom_case(natom)   = 'c'
              latom_nhydr(natom)  = 0
              if(nbond.ge.nbondmax) go to 2000
              nbond = nbond + 1
              lbond1(nbond) = natom_prev
              lbond2(nbond) = natom
              lbond_flag(nbond) = 0
              lbond_order(nbond) = 'single'
            enddo
            nhydrogens = 0
          endif
          ip = ip_out
          latom_nhydr(natom_prev) = nhydrogens
 
        else

          call CHKSMB(string(ip:ip),type)
          if(string(ip:ip).eq.'%'.or.type.eq.'D') then
            ip_last = ip
            if(string(ip:ip).eq.'%') then
              if(ip.gt.l-2) then
                err_message = 'wrong ring definition'
                ierr = 1
                return
              endif
              ip = ip + 1
              call CHKSMB(string(ip:ip),type)
              if(type.ne.'D') then
                err_message = 'wrong ring definition'
                ierr = 1
                return
              endif
              ip_last = ip + 1
              call CHKSMB(string(ip_last:ip_last),type)
              if(type.ne.'D') then
                err_message = 'wrong ring definition'
                ierr = 1
                return
              endif
            endif

            if(ip.eq.ip_last) then
              read(string(ip:ip_last),'(i1)') number_value
            else
              read(string(ip:ip_last),'(i2)') number_value
            endif

            if(number_value.gt.0.and.number_value.le.99) then
 
              if(lcycle_atom(number_value).gt.0) then
                if(nbond.ge.nbondmax) go to 2000
                nbond = nbond + 1
                lbond2(nbond) = lcycle_atom(number_value)
                lbond1(nbond) = natom_prev
                lbond_flag(nbond) = 0

                ib = lcycle_bond(number_value) 
                lbond1(ib) = lcycle_atom(number_value)
                lbond2(ib) = natom_prev

                if(latom_case(lcycle_atom(number_value)).eq.'l'.and.
     &            latom_case(natom_prev).eq.'l') then
                  lbond_order(nbond) = 'aromatic'
                else
                  lbond_order(nbond) = lcycle_order(number_value)
                  if(current_bond_order.ne.'.') then
                    if(lbond_order(nbond).eq.'.') then
                      lbond_order(nbond) = current_bond_order
                    else
                      if(current_bond_order.ne.lbond_order(nbond))then
                        err_message='ring closure bond order conflict'
                        ierr = 1
                        return
                      endif
                    endif
                  endif
                endif
                lcycle_atom(number_value) = 0
              else
                lcycle_atom(number_value) = natom_prev
                lcycle_order(number_value) = current_bond_order
                if(nbond.ge.nbondmax) go to 2000
                nbond = nbond + 1
                lbond1(nbond) = 0
                lbond2(nbond) = 0
                lbond_flag(nbond) = 1
                lbond_order(nbond) = '.'
                lcycle_bond(number_value) = nbond
                current_bond_order = '.'
              endif
            endif
            ip = ip_last + 1

            symbol_str = 'D'

          else if(string(ip:ip).eq.'(') then
            nstack_branch = nstack_branch + 1
C ??? break
c            if(natom_prev.gt.0) then
              if( current_bond_order.eq.'break') 
     *        current_bond_order = 'single'
              latom_branch(nstack_branch) = natom_prev
              latom_branch_order(nstack_branch) = current_bond_order
c            else
c              err_message = 'wrong branch definition'
c              ierr = 1
c              return
c            endif
C ??? break

            ip = ip + 1

            symbol_str = '('

          else if(string(ip:ip).eq.')') then
            if(nstack_branch.gt.0) then
              natom_prev     = latom_branch(nstack_branch)
              current_bond_order = latom_branch_order(nstack_branch)
              nstack_branch  = nstack_branch - 1
            else
              ierr = 1
              err_message = 'Branch is closed before opening'
              return
            endif
            ip = ip + 1

            symbol_str = ')'

          else if(string(ip:ip).eq.'-') then
            current_bond_order = 'single'
            ip = ip + 1
            symbol_str = 'b'
          else if(string(ip:ip).eq.'=') then
            current_bond_order = 'double'
            ip = ip + 1
            symbol_str = 'b'
          else if(string(ip:ip).eq.'#') then
            current_bond_order = 'triple'
            ip = ip + 1
            symbol_str = 'b'
          else if(string(ip:ip).eq.':') then
            current_bond_order = 'aromatic'
            ip = ip + 1
            symbol_str = 'b'
          else if(string(ip:ip).eq.'.') then
            current_bond_order = 'break'
            ip = ip + 1
c ??? break
            natom_prev = 0
C ??? break
            symbol_str = 'b'
          else if(string(ip:ip).eq.'/') then
            current_bond_order = 'trans'
            ip = ip + 1
            symbol_str = 'b'
          else if(string(ip:ip).eq.'\\') then
            current_bond_order = 'cis'
            ip = ip + 1
            symbol_str = 'b'
          else
            err_message = 'Unknown symbol in the SMILE string'
            ierr = 1
            return
          endif

        endif
    
        if(symbol_str.eq.'b'.and.symbol_str_prev.eq.'b') then
          err_message = 'not possible <bond><bond> symbols'
          ierr = 1
          return

c        else if(symbol_str.eq.'('.and.symbol_str_prev.eq.'(') then
c          err_message = 'not possible <(><(> symbols'
c          ierr = 1
c          return
c        else if(symbol_str.ne.'a'.and.ifirst.eq.1) then
c          err_message = ' first symbol not <atom> or <[>'

        else if(symbol_str.ne.'a'.and.symbol_str.ne.'('.and.
     *          ifirst.eq.1) then
          err_message = ' first symbol not <atom> or <[> or <(>'
          ierr = 1
          return
        endif   
        ifirst = 0

      enddo
C -------------------
      ip = 0
      if(natom.le.0) then
        err_message = 'natom.le.0'
        ierr = 1
        return
      endif
      if(nstack_branch.gt.0) then
        err_message = 'not all branches are closed'
        ierr = 1
        return
      endif
      do   i=1,nstack_cycle_max
        if(lcycle_atom(i).gt.0) then
          err_message = 'not all cycles are closed'
          ierr = 1
          return
        endif
      enddo
c
C---Remove breaks
      if(nbond.gt.0) then
        jb = 0
        do ib=1,nbond 
          if(lbond_order(ib).ne.'break'.and.
     *       lbond1(ib).ne.lbond2(ib)) then
            jb = jb + 1
            lbond1(jb) = lbond1(ib)
            lbond2(jb) = lbond2(ib)
            lbond_flag(jb) = lbond_flag(ib)
            lbond_order(jb) = lbond_order(ib)
            if(lbond_order(jb).eq.'.') lbond_order(jb) = 'single'
          endif
        enddo
        nbond = jb
      endif
C
C---Add H atoms
      do   ia=1,natom
        if(latom_nhydr(ia).lt.0) then
          valence = 0.0
          if(nbond.ge.1) then
            do ib=1,nbond
              if(lbond_flag(ib).eq.0.and.
     *           (lbond1(ib).eq.ia.or.lbond2(ib).eq.ia)) then
                val = 1.0
                if(lbond_order(ib).eq.'aromatic') val = 1.49
                if(lbond_order(ib).eq.'double') val = 2.0
                if(lbond_order(ib).eq.'triple') val = 3.0
                valence = valence + val
              endif
            enddo
          endif
          valence = valence - latom_charge(ia)
          nhydrogens = 1
          if(latom_name(ia).eq.'C   ') nhydrogens = 4
          if(latom_name(ia).eq.'B   ') nhydrogens = 3
          if(latom_name(ia).eq.'N   ') then
            nhydrogens = 3
            if(valence.ge.4.0) nhydrogens = 5
          endif
          if(latom_name(ia).eq.'O   ') nhydrogens = 2
          if(latom_name(ia).eq.'P   ') then
            nhydrogens = 3
            if(valence.ge.4.0) nhydrogens = 5
          endif
          if(latom_name(ia).eq.'S   ') then
            nhydrogens = 2
            if(valence.ge.3.0) nhydrogens = 4
            if(valence.ge.5.0) nhydrogens = 6
          endif

c         write(*,*) 'nh,v,ch:',nhydrogens,valence,latom_charge(ia)

          nhydrogens = float(nhydrogens) - valence + 0.1
          if(nhydrogens.ge.1) then
            do i=1,nhydrogens
              if(natom.ge.natommax) go to 1000
              natom               = natom + 1
              latom_name(natom)   = 'H   '
              latom_weight(natom) = 1.0
              latom_chiral(natom) = '      '
              latom_charge(natom) = 0.0
              latom_case(natom)   = 'c'
              latom_nhydr(natom)  = 0
              if(nbond.ge.nbondmax) go to 2000
              nbond = nbond + 1
              lbond1(nbond) = ia
              lbond2(nbond) = natom
              lbond_flag(nbond) = 0
              lbond_order(nbond) = 'single'
            enddo
          endif
        endif
      enddo
      if(natom.eq.1.or.nbond.le.0) go to 200
c
c---Process chiralities
      call get_chiralities(natom,natommax,latom_name
     *      ,latom_chiral,nbond,lbond_flag
     *      ,lbond1,lbond2,nchir,nchirmax,lchir_atom,lchir_sign
     *      ,err_message,ierr)
      if(ierr.gt.0) then
        return
      endif
c
C---Remove duplicated bond, i.e.lbond_flag() # 0
      if(nbond.gt.0) then
        jb = 0
        do ib=1,nbond 
          if(lbond_flag(ib).eq.0) then
            jb = jb + 1
            lbond1(jb) = lbond1(ib)
            lbond2(jb) = lbond2(ib)
            lbond_flag(jb) = lbond_flag(ib)
            lbond_order(jb) = lbond_order(ib)
          endif
        enddo
        nbond = jb
      endif
C
C---trans or cis. 
      ntors = 0
      do  ib=1,nbond
        if(lbond_order(ib).eq.'double') then
          ia2 = lbond1(ib)
          ia3 = lbond2(ib)
          do  ib2=1,nbond
            if(lbond1(ib2).eq.ia2) then
              ia1 = lbond2(ib2)
            else if(lbond2(ib2).eq.ia2) then
              ia1 = lbond1(ib2)
            else
              ia1 = 0
            endif            
            if(ia1.gt.0.and.(lbond_order(ib2).eq.'trans'.or.
     *            lbond_order(ib2).eq.'cis')) then
              do  ib3=1,nbond
                if(lbond1(ib3).eq.ia3) then
                  ia4 = lbond2(ib3)
                else if(lbond2(ib3).eq.ia3) then
                  ia4 = lbond1(ib3)
                else
                  ia4 = 0
                endif
                if(ia4.gt.0.and.(lbond_order(ib3).eq.'trans'.or.
     *                lbond_order(ib3).eq.'cis')) then
                  if(ntors.ge.ntorsmax) then
                    err_message = 'too many torsions'
                    ierr = 1
                    return
                  endif
                  ntors = ntors + 1
                  ltors_atom(1,ntors) = ia1
                  ltors_atom(2,ntors) = ia2
                  ltors_atom(3,ntors) = ia3
                  ltors_atom(4,ntors) = ia4
                  if(lbond_order(ib2).eq.lbond_order(ib3)) then
                    ltors(1,ntors) = 180.0
                    ltors(2,ntors) = 5.0
                  else
                    ltors(1,ntors) = 0.0
                    ltors(2,ntors) = 5.0
                  endif
                  ltors_period(ntors) = 0
                  go to 100
                endif
              enddo
            endif
          enddo
        endif
 100    continue
      enddo
      do  ib=1,nbond
        if(lbond_order(ib).eq.'trans') lbond_order(ib) = 'single'
        if(lbond_order(ib).eq.'cis'  ) lbond_order(ib) = 'single'
      enddo
c ---
 200  continue

      call set_atom_name(natom,natommax,latom_name,latom_nhydr,ierr)
      if(ierr.gt.0) then
        err_message = 'wrong atom name setting'
        return
      endif

c ---
      return
 1000 continue
      err_message = 'too many atoms'
      ierr = 1
      return
 2000 continue
      err_message = 'too many bonds'
      ierr = 1
      return
      end
C
      subroutine element_number_flags(ip,l,ip_out,string
     &       ,symbol_str,atom_weight,nhydrogens,icharge
     &       ,element_name,chirality,atom_case,err_message,ierr)
C -----------------------
      implicit none
C
      integer ip,l,ip_out
      integer ierr
      integer nhydrogens,icharge
      integer imode,jp,jp_last,ivalue,i,isign
      real    atom_weight,weight
C
      character string*(*),err_message*(*),symbol_str*1
      character element_name*2,chirality*6,atom_case*1
      character type*1
C -----------------------
      jp = ip
      if(jp.gt.l) then
        err_message = 'End of string'
        ierr = 1
        return
      endif
C
      symbol_str   = ' '
      atom_case    = 'c'
      chirality    = '      '
      icharge      = 0
      element_name = '  '
      atom_weight  = 0.0
      nhydrogens   = 0
c
      if(string(ip:ip).eq.'c'.or.string(ip:ip).eq.'n'.or.
     *   string(ip:ip).eq.'s'.or.string(ip:ip).eq.'o'    ) then
         element_name = string(ip:ip)//' '
         imode = 1
         call CHECK_LINE(imode,element_name(1:1))
C ------------------------------------------
C -P- CHECK_LINE - check and convert symbols of line.
C               MODE  0  only check
C                    -1  convert symbols to low case.
C                     1  to upper
C ---------------------------------------------
         atom_case = 'l'
         nhydrogens =-1
         ip_out = ip + 1
         symbol_str = 'a'
         return
      else if(string(ip:ip).eq.'N'.or.string(ip:ip).eq.'O'.or.
     *        string(ip:ip).eq.'P'.or.string(ip:ip).eq.'S'.or.
     *        string(ip:ip).eq.'F'.or.string(ip:ip).eq.'I'    ) then
         element_name = string(ip:ip)//' '
         atom_case = 'c'
         nhydrogens =-1
         ip_out = ip + 1
         symbol_str = 'a'
         return
      else if(string(ip:ip).eq.'B'.or.string(ip:ip).eq.'C') then
        if(ip.lt.l) then
          if(string(ip:ip+1).eq.'Br'.or.string(ip:ip+1).eq.'Cl') then
            element_name = string(ip:ip+1)
            imode = 1
            call CHECK_LINE(imode,element_name(2:2))
            atom_case = 'c'
            nhydrogens =-1
            ip_out = ip + 2
            symbol_str = 'a'
            return
          endif
        endif
        element_name = string(ip:ip)//' '
        atom_case = 'c'
        nhydrogens =-1
        ip_out = ip + 1
        symbol_str = 'a'
        return
c 
      else if(string(ip:ip).eq.'[') then
        jp = ip + 1
C
C--find out how many numbers do we have
        call get_integer(string,jp,l,ivalue,jp_last)
        if(jp_last.ge.jp) then
          atom_weight = float(ivalue)
          jp = jp_last + 1
        endif
C
C--find out how many letters do we have for the element name
        if(jp.gt.l-1) then
          err_message = 'Element name is empty'
          ierr = 1
          return
        endif
        if(string(jp:jp).eq.'c'.or.string(jp:jp).eq.'n'.or.
     *     string(jp:jp).eq.'s'.or.string(jp:jp).eq.'o'    ) then
          element_name = string(jp:jp)//' '
          imode = 1
          call CHECK_LINE(imode,element_name(1:1))
          atom_case = 'l'
          jp = jp + 1
        else 
          call CHKSMB(string(jp+1:jp+1),type)
          if(type.eq.'l') then
            element_name = string(jp:jp+1)
            jp = jp + 2
          else
            element_name = string(jp:jp)//' '
            jp = jp + 1
          endif
c         
          call check_element_name(element_name,weight,ierr)
          if(ierr.gt.0) then
            err_message = 'wrong Element name'
            return
          endif
          imode = 1
          call CHECK_LINE(imode,element_name(2:2))          
        endif
c
C--Do we have chirality.
        if(jp.lt.l.and.string(jp:jp).eq.'@') then
          jp_last = jp
          do i=jp+1,l
            if(string(i:i).eq.']'.or.
     *         string(i:i).eq.'-'.or.string(i:i).eq.'+') then
              jp_last = i-1
              go to 100 
            else if(string(i:i).eq.'H'.and.string(i:i+1).ne.'HB'.and.
     *         string(i-1:i).ne.'TH'.and.string(i-1:i).ne.'OH') then
              jp_last = i-1 
              go to 100 
            endif
          enddo  
 100      continue
          chirality = string(jp:jp_last)
          jp = jp_last + 1 
        endif
c
C--Do we have hydrogens
        if(jp.lt.l.and.string(jp:jp).eq.'H'.and.
     *                 string(jp:jp).eq.'H') then
          nhydrogens = 1
          call CHKSMB(string(jp+1:jp+1),type)
          if(type.eq.'D') then
            read(string(jp+1:jp+1),'(i1)') nhydrogens
            jp = jp + 1
          endif
          jp = jp + 1
        endif
c
C--Do we have charge
        if(jp.lt.l.and.
     *    (string(jp:jp).eq.'+'.or.string(jp:jp).eq.'-')) then
          isign = 1 
          if(string(jp:jp).eq.'-') isign = -1 
          icharge = 1
          jp = jp + 1
          if(string(jp:jp).eq.'+'.or.
     *       string(jp:jp).eq.'-'    ) then          
            icharge = 2
            jp = jp + 1
            if(jp.lt.l.and.(string(jp:jp).eq.'+'.or.
     *                      string(jp:jp).eq.'-'    )) then
              icharge = 3
              jp = jp + 1
            endif
          else
            call CHKSMB(string(jp:jp),type)
            if(type.eq.'D') then
              read(string(jp:jp),'(i1)') icharge
             jp = jp + 1
            endif
          endif
          icharge = icharge*isign 
        endif
c
C--end 
        if(jp.gt.l.or.string(jp:jp).ne.']') then
          err_message = 'There is no closing bracket for ['
          ierr = 1
        endif
        symbol_str = 'a'
        ip_out = jp + 1
      endif

      return
      end

      subroutine set_atom_name(natom,natommax,latom_name
     *                         ,latom_nhydr,ierr)
c ------------------
      implicit none
      integer   natom,ierr,natommax
      integer   latom_nhydr(natommax)
      character latom_name(natommax)*4
      integer   i,j,n,l,k,m
      character ch4*4,atom*4,atm1*4
c ------------------
      if(natom.le.1) return

      do i=1,natom
        latom_nhydr(i) = 0
      enddo
      do i=1,natom-1
         if(latom_nhydr(i).eq.0) then
            n   = 0
            ch4 = trim(adjustl(latom_name(i)))
            do j=i+1,natom
               if(ch4.eq.trim(adjustl(latom_name(j)))) then
                  n = n + 1
                  write(atom,'(i4)') n
                  atm1 = trim(adjustl(atom))
                  atom = ' '
                  atom = trim(latom_name(j))//atm1
                  latom_name(j)  = atom
                  latom_nhydr(j) = 1
               endif
            enddo
c          if(n.eq.1) then
c            call lenstr_bl(latom_name(i),l)
c            latom_name(i)(l:l) = ' '
c          endif
         endif
      enddo
c ---
      return
      end

      subroutine get_chiralities(natom,natommax,latom_name
     *      ,latom_chiral,nbond,lbond_flag
     *      ,lbond1,lbond2,nchir,nchirmax,lchir_atom,lchir_sign
     *      ,err_message,ierr)
c ------------------
      implicit none
      integer   natom,ierr,nchirmax,natommax
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      integer   nbond,lbond1(*),lbond2(*),lbond_flag(*)
      integer   nchir,lchir_atom(9,nchirmax)
      character lchir_sign(nchirmax)*8,err_message*(*)
      integer   i,l,j,iatom(9),ib,n,iorder
      character chir*6,class*2,type*1
c ------------------
c
c---  Incomplete chiralities should also be processed. Like in tetrahedral
c---  when only three naibours are present
      nchir = 0
      do i=1,natom
        call lenstr_bl(latom_chiral(i),l)
        if(l.gt.0) then

c          write(*,*) i,'chir<'//latom_chiral(i)//'>'

          chir = latom_chiral(i)
          if(l.eq.6) go to 200

          do j=1,9
            iatom(j) = 0
          enddo
          iatom(1) = i

c         back atom 
          do ib=1,nbond 
            if(lbond2(ib).eq.i.and.lbond_flag(ib).eq.0) then
              iatom(2) = lbond1(ib)
              go to 100 
            endif
          enddo
          do ib=1,nbond 
            if(lbond1(ib).eq.i) then
              iatom(2) = lbond2(ib)
              go to 100 
            endif
          enddo
          err_message = 'wrong chirality: there is no back atom'
     *                  //' <'//chir//'>'
          ierr = 1
          return
 100      continue

c         forward atoms 

          n = 1
          do ib=1,nbond 

c            write(*,*) '-',i,ib,lbond1(ib),lbond2(ib),iatom(2)

            if(lbond1(ib).eq.i.and.lbond2(ib).ne.iatom(2)) then
              n = n + 1

              if(n.gt.8) then
                err_message = 'wrong chirality: N_ neighbor_atoms > 6'
     *                  //' <'//chir//'>'
                ierr = 1
                return
              endif
              iatom(n+1) = lbond2(ib) 
            endif
          enddo
          if(n.le.1) then
            err_message = 'wrong chirality: there is no forward atom'
     *                  //' <'//chir//'>'
            ierr = 1
            return
          else if(n.lt.3) then
            err_message = 'wrong chirality: N_neighbor_atoms < 3'
     *                  //' <'//chir//'>'
            ierr = 1
            return
          endif

c         chirality class & order

          class  = '  '
          iorder = 1

c
c             n=7  PB pentagonal bipyramid
c             n=8  HB hexagonal bipyramid
c


          if(l.gt.2) then
            if(chir(2:3).eq.'TH'.or.chir(2:3).eq.'AL'.or.
     *         chir(2:3).eq.'SP'.or.chir(2:3).eq.'SQ'.or.
     *         chir(2:3).eq.'BP'.or.chir(2:3).eq.'TB'.or.
     *         chir(2:3).eq.'PB'.or.chir(2:3).eq.'HB'.or.
     *         chir(2:3).eq.'OH'                         ) then
              class = chir(2:3)
              if(class.eq.'SQ') class = 'SP'
              if(class.eq.'BP') class = 'TB'

              if(l.ge.4) then
                call CHKSMB(chir(4:4),type)
                if(type.eq.'D') then
                  if(l.eq.5) then
                    call CHKSMB(chir(5:5),type)
                    if(type.eq.'D') then
                      read(chir(4:5),'(I2)') iorder
                    else
c                     error
                      go to 200
                    endif
                  else
                    read(chir(4:4),'(I1)') iorder
                  endif
                else
c                 error
                  go to 200  
                endif
              endif
            else
c             error
              go to 200  
            endif
          else if(l.eq.2) then
            if(chir(2:2).eq.'@'.or.chir(2:2).eq.'2') then
              iorder = 2
            else if(chir(2:2).eq.'1') then
            else
c             error
              go to 200
            endif
          endif

c         default class
          if(class.eq.'  ') then
            if(n.eq.2) class = 'AL'
            if(n.eq.4.or.n.eq.3) class = 'TH'
            if(n.eq.5) class = 'TB'
            if(n.eq.6) class = 'OH'
            if(n.eq.7) class = 'PB'
            if(n.eq.8) class = 'HB'
          endif
c         check neighbor number
          if((class.eq.'AL'.and.n.ne.2).or.
     *       (class.eq.'TH'.and.n.ne.4.and.n.ne.3).or.
     *       (class.eq.'SP'.and.n.ne.4).or.
     *       (class.eq.'TB'.and.n.ne.5).or.
     *       (class.eq.'OH'.and.n.ne.6).or.
     *       (class.eq.'PB'.and.n.ne.7).or.
     *       (class.eq.'HB'.and.n.ne.8)    ) then
            err_message = 'wrong chirality: N_neighbor_atoms is wrong'
     *      //' <'//chir//'>'
            ierr = 1
            return
          endif
          if((class.eq.'TH'.and.iorder.gt.2 ).or.
     *       (class.eq.'AL'.and.iorder.gt.2 ).or.
     *       (class.eq.'SP'.and.iorder.gt.3 ).or.
     *       (class.eq.'TB'.and.iorder.gt.20).or.
     *       (class.eq.'OH'.and.iorder.gt.30).or.
     *       (iorder.le.0)                       ) then
            err_message = 'wrong chirality: iorder is wrong'
     *      //' <'//chir//'>'
            ierr = 1
            return
          endif

          if(nchir.ge.nchirmax) then
            err_message = 'too many chiralitis'
            ierr = 1
            return
          endif

          nchir = nchir + 1

          if(class.eq.'TH') then
            if(latom_name(iatom(3)).eq.'H   ') then
              j          = iatom(3)
              iatom(3)   = iatom(4)
              iatom(4) = j
              j          = iatom(4)
              iatom(4)   = iatom(5)
              iatom(5) = j
            endif
            if(iorder.eq.1) then
              lchir_sign(nchir) = 'positiv'
            else
              lchir_sign(nchir) = 'negativ'
            endif
          else
            if(class.eq.'AL') then
              lchir_sign(nchir) = 'cross0'
            else if(class.eq.'SP') then
              lchir_sign(nchir) = 'cross2'
              if(iorder.eq.2) then
                j          = iatom(3)
                iatom(3)   = iatom(n+1)
                iatom(n+1) = j
              else if(iorder.eq.3) then
                j          = iatom(4)
                iatom(4)   = iatom(n+1)
                iatom(n+1) = j
              endif
            else if(class.eq.'TB') then
              lchir_sign(nchir) = 'cross3'
            else if(class.eq.'OH') then
              lchir_sign(nchir) = 'cross4'
            else if(class.eq.'PB') then
              lchir_sign(nchir) = 'cross5'
            else if(class.eq.'HB') then
              lchir_sign(nchir) = 'cross6'
            endif
c
c           now order is central,back,forward,...
c
            j          = iatom(3)
            iatom(3)   = iatom(n+1)
            iatom(n+1) = j

          endif

          do j=1,9
            lchir_atom(j,nchir) = iatom(j)
          enddo

        endif
      enddo
      return
 200  continue
      err_message = 'wrong chirality specification'
     *  //' <'//chir//'>'
      ierr = 1
      return
      end
c
      subroutine check_element_name(element_name,weight,ierr)
c ------------------
      implicit none
      integer   ierr
      real      weight
      character element_name*2
c ---
      include 'metal.fh'
c ---
      INTEGER N_NAME2
      PARAMETER (N_NAME2 = 10)
      CHARACTER NAME2(N_NAME2)*2
      DATA NAME2/'C ','H ','O ','N ','S ','P ','B ','F ','HA','RF'/
c ---
      integer   i,imode 
      character ch2*2,type*1
c ------------------
      ch2   = element_name
      call CHKSMB(ch2(2:2),type)
      if(type.eq.'L') then
        ierr = 1
        return
      endif
      imode = 1
      call CHECK_LINE(imode,ch2(2:2))
      do i=1,N_NAME
        if(ch2.eq.NAME(i)) go to 100
      enddo 
      do i=1,N_NAME2
        if(ch2.eq.NAME2(i)) go to 100
      enddo 
      ierr = 1
 100  continue
      return
      end
c
      subroutine get_integer(string,jp,l,ivalue,jp_last)
c ------------------
      implicit none
C     
      integer   l,jp,jp_last,ivalue
      character string*(*)
c
      real      f
      integer   i,iw
      character type*1
c ------------------
      ivalue  = 0
      jp_last = 0
      do i=jp,l
        call CHKSMB(string(i:i),type)
C ------------------------------------------
C -P- CHKSMB - check symbol.
C
C  input: CHAR - one symbol.   
C  output TYPE - one symbol
C
C  if   CHAR = 'A' -- 'Z'           TYPE = 'L'    
C       CHAR = 'a' -- 'z'           TYPE = 'l'    
C       CHAR = '0' -- '9'           TYPE = 'D'    
C       CHAR = '+' or '-'           TYPE = 'S'
C       CHAR = '*' or '/' or
C              '=' or '.'           TYPE = 'O'
C       CHAR = ' '                  TYPE = 'B'
C       CHAR = any printed symbol   TYPE = 'C'
C  else             Type = '?'
C ---------------------------------------------
        if(type.eq.'D') then
          jp_last = i
        else
          go to 100
        endif
      enddo
 100  continue
      if(jp_last.ge.jp) then
        iw = jp_last - jp + 1
        call WTODIG(string(jp:jp_last),iw,f,ivalue)
C -------------------------------------------------------
C -P- WTODIG - convert string to integer and real.
C              
C              STR  - input string of characters (without blancs).
C              IW   - number of characters in the string.
C              I    - output integer value of string.
C              F    - output real value of string.
C      Subroutine returns I=0 and F=0.0 if it can't convert the string 
C      to the digits.
C      Examples right strings: "+23", "324", "-123", "-1.0", "0.23",
C                              "+2.00", "-1.2E-2", "0.3e+2", "-3E4".
C -S- 

      endif
      return
      end

      subroutine mols_bond_correction()
      implicit none

      return
      end
c
      subroutine mols_angl_correction()
      implicit none

      return
      end
c
      SUBROUTINE SMILE_TORSION_CORRECTION(MDOC
     *       ,natommax,natom,latom_charge,latom_nhydr
     *       ,latom_weight,latom_name,latom_chiral
     *     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors
     *     ,IERR)
C -----------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      integer   natommax,natom
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax),latom_weight(natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      integer   ntorsmax
      integer   ntors,ltors_period(ntorsmax),ltors_atom(4,ntorsmax)
      real      ltors(2,ntorsmax)
C ******
      INTEGER   IT,L,NC,I,IA,IB,IORDER
      REAL      VAL
      CHARACTER LINE*256,ATOM1*4,ATOM2*4,ATOM3*4,ATOM4*4
      CHARACTER LATOM1*4,LATOM2*4,LATOM3*4,LATOM4*4
C --------------------------------------------------------
      IF(L1A_NATOM.LE.3) RETURN
      if(ntors.le.0) return
      NC = 0
      IF(L1T_NTORS.GT.0) THEN
        DO L=1,L1T_NTORS
          IF(L1T_PRD(L).EQ.0) THEN
            NC = NC+1
          ENDIF
        ENDDO
      ENDIF
C ---
      DO IT=1,NTORS
C       check atom names
        DO I=1,4
          ATOM1 = latom_name(ltors_atom(I,IT))
          DO IA=1,L1A_NATOM
            IF(ATOM1.EQ.L1A_ANAME(IA))  GO TO 200
          ENDDO
          LINE = 'ERROR: in SMILE_TORSION_CORRECTION: wrong atom name' 
          CALL MSGERR(MDOC,LINE)
          IERR = 1
          RETURN
 200      CONTINUE
        ENDDO

        ATOM1 = latom_name(ltors_atom(1,IT))
        ATOM2 = latom_name(ltors_atom(2,IT))
        ATOM3 = latom_name(ltors_atom(3,IT))
        ATOM4 = latom_name(ltors_atom(4,IT))
        IF(L1T_NTORS.GT.0) THEN
c
c---  if this torsion is in the list of available torsions then use it. Keep periodicity
c---  and make with id CONST
           DO L=1,L1T_NTORS

              IF((  (ATOM2.EQ.L1T_2ATM(L)).AND.
     *             (ATOM3.EQ.L1T_3ATM(L))     ).OR.
     *             ((ATOM2.EQ.L1T_3ATM(L)).AND.
     *             (ATOM3.EQ.L1T_2ATM(L))     )) THEN
                 l1t_1atm(l) = atom1
                 l1t_2atm(l) = atom2
                 l1t_3atm(l) = atom3
                 l1t_4atm(l) = atom4
                 if(ltors(2,it).gt.0.0) then
                    l1t_val(l) = ltors(1,it)
                    l1t_dev(l) = ltors(2,it)
                 else
                    l1t_val(l) = 180.0
                    l1t_dev(l) = 20.0
                 endif
                 
                 line(1:5) = 'CONST'
                 nc = nc + 1
                 write(line(6:8),'(i3)')nc
                 if(line(6:6).eq.' ')line(6:6)='_'
                 if(line(7:7).eq.' ') line(7:7)='_'
                 l1t_label(l) = line(1:8)
                 goto 100
              endif
           ENDDO
        ENDIF
        IF(L1T_NTORS.GE.MAX1TOR) THEN
           WRITE(LINE
     *          ,'('' ERROR: number of tors. angles of monomer >'',I6)') 
     *          MAX1TOR
           CALL MSGERR(MDOC,LINE)
           CALL MSGERR(MDOC
     *          ,'         Change parameter MAX1TOR in "lib_com.fh"')
           IERR = 1
           RETURN
        ENDIF
        L1T_NTORS   = L1T_NTORS+1
        L           = L1T_NTORS
        L1T_1ATM(L) = ATOM1
        L1T_2ATM(L) = ATOM2
        L1T_3ATM(L) = ATOM3
        L1T_4ATM(L) = ATOM4
        L1T_I1ATM(L) = 0
        L1T_I2ATM(L) = 0
        L1T_I3ATM(L) = 0
        L1T_I4ATM(L) = 0
        L1T_VAL (L) = ltors(1,IT)
        L1T_DEV (L) = ltors(2,it)
        L1T_PRD (L) = 0
        L1T_VOBS(L) = 0.0
        L1T_FLAG(L) = ' '
        NC = NC + 1
        LINE(1:5) = 'CONST'
        WRITE(LINE(6:8),'(I3)') NC
        IF(LINE(6:6).EQ.' ') LINE(6:6) = '_'
        IF(LINE(7:7).EQ.' ') LINE(7:7) = '_'
        L1T_LABEL(L) = LINE(1:8)
 100    CONTINUE
      ENDDO
C ---
      RETURN
      END            
c

c ====================================================================
      subroutine pdb2lib_sub( fin, fou, coor,flag, ierr )
      implicit   none

      character  fin*(*)
      character  fou*(*)
c
      character fou1*512
      character  flag*1
      character coor*1
      character group_id*64
      character comp_id*512
      character comp_3lett*3
      integer*4  ierr

      integer*4  na, nx

      integer*4  uin
      integer*4  uou
      integer*4  ios
      logical*4  ok
      logical    ideal_use
c --------------------------------------------------------------------
      uin = 61
      uou = 62

      fou1 = 'lib_inter.lib'
      coor = 'Y'
      open(unit=uin,file=fin,status='old',iostat=ios)
      if( ios .eq. 0 )then
         group_id = 'non-polymer'
         call pdb2lib_chck( uin,ok )
         if( ok )then
            flag = 'Y'
         else
            flag = 'N'
            open(unit=uou,file=fou,status='unknown',iostat=ios)
            if( ios .eq. 0 )then
               rewind(uin)
               call pdb2lib_group(uin,group_id,comp_id,comp_3lett)
               na = 0
               nx = 0
               rewind(uin)
               ideal_use = .FALSE.
               call pdb2lib_rdent( uin, 0, na, nx, group_id,comp_id,
     &              comp_3lett,coor,ok,ideal_use )
               if( ok )then
                  rewind(uin)
                  call pdb2lib_rdent( uin, uou, na, nx, group_id,
     &                 comp_id,comp_3lett,coor,ok,ideal_use )
               endif
            endif
            close(uou)
         endif
      endif
      close(uin)
c
c---  Now read and treat carboxyls, phosphates and missing hydrogens issues

      if( ok )then
         ierr = 0
      else
         ierr = 1
      endif
      return
      end

c ====================================================================
      subroutine pdb2lib_chck( uin, ok )
      implicit   none

      integer*4  mt, nt
      parameter  ( mt = 1024 )
      character  c_t*(mt)

      integer*4  mw, nw
      parameter  ( mw = 64 )
      integer*4  t_w(mw)

      integer*4  uin
      integer*4  ios
      logical*4  ok, found

c --------------------------------------------------------------------
      ok = .true.
      found = .false.
      do while( .not. found .and. ok )
         read(uin,'(a)',iostat=ios) c_t
         ok = ios .eq. 0
         if( ok )then
            call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
C--- 16.12.2009
c           found = c_t(1:14) .eq. 'data_comp_list'
            found = (c_t(1:14) .eq. 'data_comp_list').or.
     *              (c_t(1:14) .eq. 'data_link_list').or.
     *              (c_t(1:13) .eq. 'data_mod_list')
C---
         endif
      enddo
      return
      end
c
      subroutine pdb2lib_group(uin,group_id,comp_id,comp_3lett)
      implicit none
c
c--find out if this monomer belongs to one of the predifined groups
c--   L-peptide
c--   D-peptide
c--   DNA
c--   RNA
c--   RNA/DNA
c--   L-pyranose
c--   D-pyranose
c
c---  Extract three letter compound name and its long name for further use
c
      integer uin
      character group_id*(*)
      character comp_id*(*)
      character comp_3lett*(*)
c
      integer*4  mt, nt
      parameter  ( mt = 1024 )
      character  c_t*(mt)

      integer i
      integer icount
      integer iw1,iw2,nt1
      integer*4  mw, nw
      parameter  ( mw = 64 )
      integer*4  t_w(mw)

      integer l,l1
      character chval*32
      integer ios
      logical ok
      logical found,found2,found3
      logical found_all
c
c---  body
c---------------------
      ok = .TRUE.
      found_all = .FALSE.
      icount = 0
      comp_id = '.'
      group_id = '.'
      comp_3lett = '.'
      do while(icount.lt.3.and.ok) 
         read(uin,'(a)',iostat=ios) c_t
         ok = ios.eq.0
         if(ok) then
            call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
            found = c_t(1:15).eq.'_chem_comp.type'
            found_all = found
            if(found) then
               icount = icount + 1
               chval = c_t(17:24)
               if(chval(1:1).eq.'"'.or.chval(1:1).eq.'''') then
                  do i=1,7
                     chval(i:i) = chval(i+1:i+1)
                  enddo
                  chval(8:8) = ' '
               endif
               call upc_bl(chval)
c               write(*,*)chval
c               stop
               if(chval(1:6).eq.'L-PEPT') then
                  group_id = 'L-peptide'
               else if(chval(1:6).eq.'D-PEPT') then
                  group_id = 'D-peptide'
               else if(chval(1:3).eq.'DNA') then
                  group_id = 'DNA'
               else if(chval(1:3).eq.'RNA') then
                  group_id = 'RNA'
               else if(chval(1:4).eq.'SACH') then
                  group_id = 'pyranose'
               else if(chval(1:4).eq.'D-SA') then
                  group_id = 'D-pyranose'
               else if(chval(1:4).eq.'L-SA') then
                  group_id = 'L-pyranose'
               else
                  group_id = '.'
               endif
            endif
            found = c_t(1:15).eq.'_chem_comp.name'
            found_all = found_all.and.found
            if(found) then
               icount = icount + 1
               iw1 = t_w(2)+1
               iw2 = t_w(3)-1

               comp_id = trim(adjustl(c_t(iw1:iw2)))
               l = len_trim(comp_id)
               l1 = len(comp_id)
               if(comp_id(1:1).eq.'"') then
                  if(comp_id(l:l).ne.'"') then
                     if(l.ge.l1) then
                        comp_id(l1:l1) = '"'
                     else
                        comp_id(l+1:l+1) = '"'
                     endif
                  endif
               endif
               if(comp_id(1:1).eq.'''') then
                  if(comp_id(l:l).ne.'''') then
                     if(l.ge.l1) then
                        comp_id(l1:l1) = ''''
                     else
                        comp_id(l+1:l+1) = ''''
                     endif
                  endif
               endif

            endif
            iw1 = t_w(1)+1
            iw2 = t_w(2)-1
            found = c_t(iw1:iw2).eq.'_chem_comp.three_letter_code'
            if(found) then
               icount = icount+1
               iw1 = t_w(2)+1
               comp_3lett = c_t(iw1:iw1+2)
            endif
         endif
      enddo
      if(comp_id.eq.' ') comp_id = '.'
      if(comp_3lett.eq.' ') comp_3lett = '.'
      if(group_id.eq.' ') group_id = 'non-polymer'

      return
      end

c ====================================================================
      subroutine pdb2lib_rdent( uin, uou, na, nx, group_id,comp_id,
     &     comp_3lett,coor,ok ,ideal_use)
      implicit   none

      integer*4  mt, nt, it, jt
      parameter  ( mt = 1024 )
      character  c_t*(mt)
      character  c_c*(mt)
      character coor*(*)

      integer*4  ms, is, js
      parameter  ( ms = 120 )
      character  b_s*(ms)
      character  b_so(100)*120
      character group_id*(*)
      character comp_id*(*)
      character comp_3lett*(*)

      character  c8*8

      character ideal_flag*1,model_flag*1
      logical   values_ready
      character atid_v*16,compid_v*16,atcharg_v*16,x_v*16,y_v*16,z_v*16
      character atid1_v*16,atid2_v*16,bondord_v*16
      character atsym_v*16
      character xid_v*16,yid_v*16,zid_v*16
      integer nmissing
      character amissing(1000)*8
      integer    ideal_x
      integer    n_values
      integer    found_it
      integer*4  na, nx, nb

      integer*4  iv,im,j,k
      integer*4  w_v(10)
      integer    w_w(3)

      integer na1,nx1
      integer*4  mw, nw, iw, jw
      parameter  ( mw = 64 )
      integer*4  t_w(mw)

      integer*4  uin
      integer*4  uou
      integer*4  ios
      logical ideal_use
      logical*4  ok, same
      logical ideal_missing,model_missing
c --------------------------------------------------------------------
      read(uin,'(a)',iostat=ios) c_t
      ok = ios .eq. 0
      ok = ok .and. c_t(1:13) .eq. c_t
      ok = ok .and. c_t(1:5) .eq. 'data_'
      if( ok ) c8 = c_t(6:13)
      if( ok .and. uou .gt. 0 )then
         write(uou,'(a)') '#'
         write(uou,'(a)') 'data_comp_list'
         write(uou,'(a)') 'loop_'
         write(uou,'(a)') '_chem_comp.id'
         write(uou,'(a)') '_chem_comp.three_letter_code'
         write(uou,'(a)') '_chem_comp.name'
         write(uou,'(a)') '_chem_comp.group'
         write(uou,'(a)') '_chem_comp.number_atoms_all'
         write(uou,'(a)') '_chem_comp.number_atoms_nh'
         write(uou,'(a)') '_chem_comp.desc_level'
         write(uou,'(a8,1x,a3,1x,a,1x,a,2i6,1x,a)')
     &      c8, trim(comp_3lett),trim(comp_id),
     &        trim(group_id), na, nx, 'M'
         write(uou,'(a)') '#'
         write(uou,'(a)') 'data_comp_'//c8
      endif

      ok = .TRUE.

      ideal_flag = '.'
      model_flag = '.'
      found_it = 0
      do while( ok .and. found_it.lt.2 )
         read(uin,'(a)',iostat=ios) c_t
         call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
         if(trim(adjustl(c_t(t_w(1)+1:t_w(2)))).eq.
     &     '_chem_comp.pdbx_ideal_coordinates_missing_flag') then
            ideal_flag = trim(adjustl(c_t(t_w(2):t_w(3))))
            found_it = found_it + 1
         endif
         if(trim(adjustl(c_t(t_w(1)+1:t_w(2)))).eq.
     &     '_chem_comp.pdbx_model_coordinates_missing_flag') then
            model_flag = trim(adjustl(c_t(t_w(2):t_w(3))))
            found_it = found_it + 1
         endif
         ok = ios .eq. 0
      enddo
      if(model_flag.eq.'Y'.and.ideal_flag.eq.'Y') then
         write(*,*)
     &    'WARNING: Neither ideal nor model coordinates are available'
c         stop
      endif
      if(ideal_flag.eq.'Y') then
         write(*,*)'WARNING: Ideal coordinates are missing'
         write(*,*)'Warning: Ideal values will be generated using'//
     &        ' ener_lib.cif'
         coor = 'N'
      endif
      rewind(uin)
      do while( ok .and. c_t(1:13) .ne. '_chem_comp.id' )
         read(uin,'(a)',iostat=ios) c_t
         ok = ios .eq. 0
      enddo

      if( ok ) call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
      ok = ok .and. nw .eq. 3
c      ok = ok .and. t_w(2) .eq. 14
c      ok = ok .and. t_w(3) .le. 23
      ok = ok .and. c_t(15:22) .eq. c8
      ok = ok.and.trim(c_t(t_w(2)+1:t_w(3)-1)).eq.trim(c8)
      do while( ok .and. c_t(1:16) .ne. '_chem_comp_atom.' )
         read(uin,'(a)',iostat=ios) c_t
         ok = ios .eq. 0
      enddo

      jw = 0
      do iv = 1,7
         w_v(iv) = 0
      enddo
      values_ready = .FALSE.
      n_values = 0
c
c---  If there is no loop then read the value from these lines
      do while( ok .and. c_t(1:16) .eq. '_chem_comp_atom.' )

         call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
c
         c_c = trim(adjustl(c_t(t_w(1)+1:t_w(2))))
         if(nw.gt.2) then
            values_ready = .TRUE.
         endif
         
         jw = jw + 1
         if( c_c .eq. '_chem_comp_atom.comp_id' )then
            w_v(1) = jw
            if(nw.gt.1) then
               compid_v = trim(c_t(t_w(2)+1:t_w(3)))
               n_values = n_values + 1
            endif
         else if( c_c .eq. '_chem_comp_atom.atom_id' )then
            w_v(2) = jw
            if(nw.gt.1) then
               atid_v = trim(c_t(t_w(2)+1:t_w(3)))
               n_values = n_values + 1
            endif
         else if( c_c .eq. '_chem_comp_atom.type_symbol' )then
            w_v(3) = jw
            if(nw.gt.1) then
               atsym_v = trim(c_t(t_w(2)+1:t_w(3)))
               n_values = n_values + 1
            endif
         else if( c_c .eq. '_chem_comp_atom.charge' )then
            w_v(4) = jw
            if(nw.gt.1) then
               atcharg_v = trim(c_t(t_w(2)+1:t_w(3)))
               n_values = n_values + 1
            endif
c
c---  Take ideal coordinates not these. If not found then report error. It will make testing
c---  the dictionary easier.
         else if( c_c .eq. '_chem_comp_atom.model_Cartn_x' )then
            w_v(5) = jw
            if(nw.gt.1) then
               x_v = trim(c_t(t_w(2)+1:t_w(3)))
               n_values = n_values + 1
            endif
         else if( c_c .eq. '_chem_comp_atom.model_Cartn_y' )then
            w_v(6) = jw
            if(nw.gt.1) then
               y_v = trim(c_t(t_w(2)+1:t_w(3)))
               n_values = n_values + 1
            endif
         else if( c_c .eq. '_chem_comp_atom.model_Cartn_z' )then
            w_v(7) = jw
            if(nw.gt.1) then
               z_v = trim(c_t(t_w(2)+1:t_w(3)))
               n_values = n_values + 1
            endif

         else if(c_c.eq.'_chem_comp_atom.pdbx_model_Cartn_x_ideal') then
            ideal_x = ideal_x + 1
            w_v(8) = jw
            if(nw.gt.1) then
               xid_v = trim(c_t(t_w(2)+1:t_w(3)))
               
            endif
         else if(c_c.eq.'_chem_comp_atom.pdbx_model_Cartn_y_ideal') then
            ideal_x = ideal_x + 1
            w_v(9) = jw
            if(nw.gt.1) then
               yid_v = trim(c_t(t_w(2)+1:t_w(3)))
            endif
         else if(c_c.eq.'_chem_comp_atom.pdbx_model_Cartn_z_ideal') then
            ideal_x = ideal_x + 1
            w_v(10) = jw
            if(nw.gt.1) then
               zid_v = trim(c_t(t_w(2)+1:t_w(3)))
            endif
         endif

         read(uin,'(a)',iostat=ios) c_t
         ok = ios .eq. 0
      enddo
      if(ideal_flag.eq.'N') then
c         w_v(5:7) = w_w(1:3)
         if(values_ready) then
            x_v = xid_v
            y_v = yid_v
            z_v = zid_v
         endif
      else
c
c--   Report error for testing purposes

      endif

      iv = 0
      do while( ok .and. iv .lt. 7 )
         iv = iv + 1
         ok = w_v(iv) .ne. 0
      enddo
      if( ok .and. uou .gt. 0 )then
         write(uou,'(a)') '#'
         write(uou,'(a)') 'loop_'
         write(uou,'(a)') '_chem_comp_atom.comp_id'
         write(uou,'(a)') '_chem_comp_atom.atom_id'
         write(uou,'(a)') '_chem_comp_atom.type_symbol'
         write(uou,'(a)') '_chem_comp_atom.partial_charge'
         write(uou,'(a)') '_chem_comp_atom.x'
         write(uou,'(a)') '_chem_comp_atom.y'
         write(uou,'(a)') '_chem_comp_atom.z'
c
c--If we have values then write them now
         if(values_ready) then
            write(uou,'(7(a,1x))')trim(compid_v),trim(atid_v),
     &           trim(atsym_v),trim(atcharg_v),
     &           trim(x_v),trim(y_v),trim(z_v)
         endif
      endif

c
      same = .true.
      nx1 = nx
      na1 = na
      nx = 0
      na = 0
      if( ok ) call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
c
c--This test may fail
      ideal_missing = .FALSE.
      model_missing = .FALSE.
      nmissing = 0
      do while( ok .and. nw .eq. jw + 1 )
         iw = w_v(1)
         same = same .and. c_t(t_w(iw)+1:t_w(iw+1)-1) .eq. c8
         iw = w_v(3)
         if( c_t(t_w(iw)+1:t_w(iw+1)-1) .ne. 'H' ) nx = nx + 1
         js = 0
         do iv = 1,10
            iw = w_v(iv)
            it = t_w(iw)
            jt = t_w(iw+1)
            is = js
            js = js + jt - it
            b_s(is+1:js) = c_t(it+1:jt)
            b_so(iv) = c_t(it+1:jt)
         enddo
c         write(*,*)b_so(2),b_so(3)
c
c---  Check if coordinates for an atom is missing. 
c---  Last three elements are coordinates. If it is hydrogen then remove it
         if(trim(adjustl(b_so(3))).ne.'H'.or.na1.eq.1) then
            na = na + 1
            if(trim(adjustl(b_so(5))).eq.'?'.or.
     &           trim(adjustl(b_so(6))).eq.'?'.or.
     &           trim(adjustl(b_so(7))).eq.'?') then
               model_missing = .TRUE.
            endif
            if(trim(adjustl(b_so(8))).eq.'?'.or.
     &           trim(adjustl(b_so(9))).eq.'?'.or.
     &           trim(adjustl(b_so(10))).eq.'?') then
               ideal_missing = .TRUE.
            endif
            if( uou .gt. 0 ) then
               if(ideal_use) then
                  write(uou,'(7(a,1x))') (trim(b_so(j)),j=1,4),
     &                 (trim(b_so(k)),k=8,10)
               else
                  write(uou,'(7(a,1x))')(trim(b_so(j)),j=1,7)
               endif
            endif
         else
            nmissing = nmissing + 1
            amissing(nmissing) = trim(adjustl(b_so(2)))
         endif
         read(uin,'(a)',iostat=ios) c_t
         ok = ios .eq. 0
         if( ok ) call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
      enddo
      if(model_missing.and.ideal_missing) then
         write(*,*)'WARNING: Neither model nor ideal coordinates'//
     &        ' are present for non-hydrogen atom'
         COOR = 'N'
      endif
c      if(uou.gt.0) stop
      if(.not.ideal_missing) ideal_use = .TRUE.
      ok = same .and. na .gt. 0 .and. nx .gt. 0

      do while( ok .and. c_t(1:16) .ne. '_chem_comp_bond.' )
         read(uin,'(a)',iostat=ios) c_t
         ok = ios .eq. 0
      enddo
      jw = 0
      do iv = 1,4
         w_v(iv) = 0
      enddo
c
c---  If there is no loop then read values from these loops.
      values_ready = .FALSE.
      do while( ok .and. c_t(1:16) .eq. '_chem_comp_bond.' )
         call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
         if(nw.gt.2) then
            values_ready = .TRUE.
         endif
         c_c = trim(adjustl(c_t(t_w(1)+1:t_w(2))))

         jw = jw + 1
         if( c_c .eq. '_chem_comp_bond.comp_id' )then
            w_v(1) = jw
            if(nw.gt.2) then
               compid_v = c_t(t_w(2)+1:t_w(3))
            endif
         else if( c_c .eq. '_chem_comp_bond.atom_id_1' )then
            if(nw.gt.2) then
               atid1_v = c_t(t_w(2)+1:t_w(3))
            endif
            w_v(2) = jw
         else if( c_c .eq. '_chem_comp_bond.atom_id_2' )then
            if(nw.gt.2) then
               atid2_v = c_t(t_w(2)+1:t_w(3))
            endif
            w_v(3) = jw
         else if( c_c .eq. '_chem_comp_bond.value_order' )then
            if(nw.gt.2) then
               bondord_v = adjustl(c_t(t_w(2)+1:t_w(3)))
               if(trim(bondord_v) .eq. 'SING' )then
                  bondord_v = 'single'
               else if(trim(bondord_v) .eq. 'DOUB' )then
                  bondord_v = 'double'
               else if(trim(bondord_v) .eq. 'TRIP' )then
                  bondord_v = 'triple'
               else if(trim(bondord_v) .eq. 'AROM' )then
                  bondord_v = 'aromatic'
               else if(trim(bondord_v) .eq. 'DELO' )then
                  bondord_v= 'delocal'
               endif
            endif
            w_v(4) = jw
         endif
         read(uin,'(a)',iostat=ios) c_t
         ok = ios .eq. 0
      enddo
      iv = 0
      do while( ok .and. iv .lt. 4 )
         iv = iv + 1
         ok = w_v(iv) .ne. 0
      enddo
      if( ok .and. uou .gt. 0 )then
         write(uou,'(a)') '#'
         write(uou,'(a)') 'loop_'
         write(uou,'(a)') '_chem_comp_bond.comp_id'
         write(uou,'(a)') '_chem_comp_bond.atom_id_1'
         write(uou,'(a)') '_chem_comp_bond.atom_id_2'
         write(uou,'(a)') '_chem_comp_bond.type'
c
         if(values_ready) then
            write(uou,'(4(a,1x))')trim(compid_v),trim(atid1_v),
     &           trim(atid2_v),trim(bondord_v)
         endif
      endif
c
c---If we have the values then write them now
      same = .true.
      nb = 0
      if( ok ) call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
      do while( ok .and. nw .eq. jw + 1 )
         iw = w_v(1)
         same = same .and. c_t(t_w(iw)+1:t_w(iw+1)-1) .eq. c8
         nb = nb + 1
         js = 0
         do iv = 1,4
            iw = w_v(iv)
            it = t_w(iw)
            jt = t_w(iw+1)
            is = js
            js = js + jt - it
            b_s(is+1:js) = c_t(it+1:jt)
            b_so(iv) = c_t(it+1:jt)
         enddo
         if( b_s(is:js) .eq. ' SING ' )then
            js = js + 2
            b_s(is:js) = ' single '
            b_so(4) = 'single'
         else if( b_s(is:js) .eq. ' DOUB ' )then
            js = js + 2
            b_s(is:js) = ' double '
            b_so(4) = 'double'
         else if( b_s(is:js) .eq. ' TRIP ' )then
            js = js + 2
            b_s(is:js) = ' triple '
            b_so(4) = 'triple'
         else if( b_s(is:js) .eq. ' AROM ' )then
            js = js + 4
            b_s(is:js) = ' aromatic '
            b_so(4) = 'aromatic'
         else if( b_s(is:js) .eq. ' DELO ' )then
            js = js + 3
            b_s(is:js) = ' delocal '
            b_so(4) = 'delocal'
         endif
         im = 1
         if(nmissing.gt.0) then
            do while(im.le.nmissing.and.
     &           trim(adjustl(b_so(2))).ne.trim(adjustl(amissing(im)))
     &              .and.
     &           trim(adjustl(b_so(3))).ne.trim(adjustl(amissing(im))))
               im = im + 1
            enddo
         endif
c         if(trim(adjustl(b_so(3))).eq.'H43') then
c            write(*,*)im,nmissing,amissing(nmissing)
c            stop
c         endif
         if(im.gt.nmissing) then
            if(uou .gt. 0) write(uou,'(4(a,1x))')(trim(b_so(j)),j=1,4)
         endif
         read(uin,'(a)',iostat=ios) c_t
         ok = ios .eq. 0
         if( ok ) call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
      enddo
      ok = same

      if( ok .and. uou .gt. 0 )then
         write(uou,'(a)') '#'
      endif
      return
      end

c ====================================================================
      subroutine pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
      implicit   none

      integer mt1,nt1
      integer*4  mt, nt, it
      character  c_t*(*)

      integer*4  mw, nw, iw, jw
      integer*4  t_w(mw)

      logical*4  fi, fj
      logical quote_open1,quote_open2,string_open
c --------------------------------------------------------------------
      nt = 0
      fi = .false.

c      mt1 = len_trim(c_t)
      do it = 1,mt
         fj = c_t(it:it) .ne. ' '
         if( fi .or. fj )then
            nt = nt + 1
            c_t(nt:nt) = c_t(it:it)
         endif
         fi = fj
      enddo
c      nt = min(nt,mt1)
      if(nt.lt.mt) c_t(nt+1:mt) = ' '
      c_t = trim(adjustl(c_t))
      nt = len_trim(c_t)
      jw = 1
      t_w(1) = 0
      quote_open1 = .FALSE.
      quote_open2 = .FALSE.
      string_open = .FALSE.
c      nt1 = len_trim(c_t)
      if(nt.gt.1) then
         quote_open1 = .FALSE.
         quote_open2 = .FALSE.
         do it = 1,nt
            if(c_t(it:it).eq.'''') then
               if(.not.quote_open1) then
                  if(it.eq.1) then
                     quote_open1 = .TRUE.
                  else if(c_t(it-1:it-1).eq.' '.and.
     &                    .not.quote_open2) then
                     quote_open1 = .TRUE.
                  endif
               else
                  if(it.eq.nt) then
                     quote_open1 = .FALSE.
                  else if(c_t(it+1:it+1).eq.' ') then
                     quote_open1 = .FALSE.
                  endif
               endif
            endif

            if(c_t(it:it).eq.'"') then
               if(.not.quote_open2) then
                  if(it.eq.1) then
                     quote_open2 = .TRUE.
                  else if(c_t(it-1:it-1).eq.' '.and.
     &                    .not.quote_open1) then
                     quote_open2 = .TRUE.
                  endif
               else
                  if(it.eq.nt) then
                     quote_open2 = .FALSE.
                  else if(c_t(it+1:it+1).eq.' ') then
                     quote_open2 = .FALSE.
                  endif
               endif
            endif

            if( c_t(it:it) .eq. ' '.and.
     &           .not.(quote_open1.or.quote_open2))then
               jw = jw + 1
               if( jw .le. mw ) t_w(jw) = it
            endif
         enddo
      endif

      jw = jw + 1
      t_w(jw) = nt+1
      nw = jw
      return
      end
c ====================================================================
