module atom_com
  ! ============================================================================
  !             HIERARCHY OF CRYSTAL STRUCTURE DESCRIPTION
  !
  !   Level of Hierarchy                               
  !                         variable & pointer        !     constatnt         
  !
  !   CRYSTAL - UNIT CELL - is the contents of the unit cell and is generated
  !          !              by the cryst. symmetrical operators from the 
  !          !              contents of the asymmetrical part of unit cell.
  !          !              Cell parameters, the list and the description of 
  !          !              the links between symm.related chains.
  !          !              Space group id and the cryst.symm. operators 
  !          !              define the "crystal".
  !          !  
  !          !               cell parameters            !
  !          !                                          !
  !          !               space group id and list of ! symmetry operators
  !          !               subgroups (Wyckoff symbol) !
  !          !                                          !
  !          !               list of links between      ! descriptions of links  
  !          !               symm.related chains        !
  !          !
  !          v
  !  ASYM.PART OF UNIT CELL - is the contents of asym. part of unit cell and
  !          !                consists unit structural elements - "groups"/chains/
  !          !                The list of the "groups" and list of links between
  !          !                "groups", defines the asym. part of unit cell.
  !          !
  !          !                list of chains/groups/    !
  !          !                                          !
  !          !                list of links between     ! descriptions of links
  !          !                chains                    !
  !          !                          
  !          v
  !        CHAIN/GROUP/ - is numbered set of "monomers". The list of "monomers",
  !          !            the links between monomers (for example:
  !          !            disulfide bridges, peptide bond), the description of
  !          !            some modification of monomers (for example: terminus
  !          !            of polypeptide chain) define the chain. The polymer
  !          !            is lenear covalet bonded set of monomers. A set
  !          !            of water molecule is a chain. Chain may contain only
  !          !            one monomer. 
  !          !                                        
  !          !            list of residue           !         
  !          !                                      !
  !          !            list of modifications     !descriptions of modifications
  !          !                                      !
  !          !            list of links inside chain! descriptions of links
  !          !                                      !
  !          v
  !    RESIDUE or MONOMER  - is a set of atoms connected by bonds, or a single
  !          !	          atom.
  !          !          
  !          !                                       !  descrioptions of residues
  !          !                                       !    list of atoms
  !          !                                       !    list of bonds
  !          !                                       !    list of bonds
  !          !                                       !    . . . . . . .
  !          v
  !         ATOM     - the  atom's type, their coordinates, B-factors, occupancies
  !          !         multyplicity define the atom.
  !          !                          
  !          !                atomic name             descrioptions of atoms  
  !          !                coordinates
  !          !                . . . . . . 
  ! ===================================================================

  ! ==================================================================
  !
  !   Parameters
  !
  !  symmetry,NCS,atomic types,atoms,residues,chains,
  !  links,modifications,internal angles
  !
  ! ------------------------------------------------------------------
  integer, parameter :: maxatom = 150000
  integer, parameter :: maxatsd = 1
  integer, parameter :: maxnso = 192
  integer, parameter :: maxnsf = 300
  integer, parameter :: maxns = 100
  integer, parameter :: maxresid = 100000
  integer, parameter :: maxchain = 1500
  integer, parameter :: maxmodif = maxresid
  integer, parameter :: maxlink = 3000

  ! -----------------------------------------------------------------
  !  MAXATOM   - max. number of atoms
  !  MAXATSD   - max. number of sigmas of atoms
  !  MAXNSYM   - max. number of cryst. symm. operators 
  !  MAXNSF    - max. number of atomic types 
  !  MAXNCS    - max. number of NCS operators
  !  MAXRESID  - max. number of residue /monomers/
  !  MAXCHAIN  - max. number of chains
  !  MAXMODIF  - max. number of modifications 
  !  MAXLINK   - max. number of links
  !  MAXPHI    - max. number of internal variable angles Phi
  !===================================================================

  !===================================================================
  !
  !
  !      Common arrays for informations about crystal structure.
  !
  !
  !===================================================================
  !
  !  I.  CELL and SPACE GROUP
  !           General information about structure in coordinate file:
  !           cell parameters, symmetry and NCS description,
  !           atomic scattering coefficients, matrix to frac.coord system
  !           and from.
  !
  ! ---------------------------------------------------------
  REAL      CS_CELL       (6)
  REAL      CS_ORT_TO_FRAC(3,3)
  REAL      CS_FRAC_TO_ORT(3,3)

  integer, parameter :: maxncs = 100
  REAL      CS_M_CS       (3,3,MAXNSO)
  REAL      CS_V_CS       (3  ,MAXNSO)
  REAL      CS_M_NCS      (3,3,MAXNCS)
  REAL      CS_V_NCS      (3  ,MAXNCS)

  REAL      CS_A     (5,MAXNSF)
  REAL      CS_B     (5,MAXNSF)

  REAL      CS_C     (MAXNSF)
  REAL      CS_FI    (MAXNSF)
  REAL      CS_FII   (MAXNSF)
  REAL      CS_RADIUS(MAXNSF)
  integer CS_NELEC (MAXNSF)
  integer CS_NSYM
  integer CS_NSYMOP
  integer CS_NSPGR
  integer CS_SETT
  integer CS_NUMB_CS(MAXNSO)
  integer CS_NSFATM
  integer CS_NCS
  CHARACTER CS_SPGR         *24
  CHARACTER CS_ATYPE(MAXNSF)*4
  CHARACTER CS_ELEMENT(MAXNSF)*4
  ! ------------------------------------------------------------------
  !  CS_CELL     -  Unit cell parameters  
  !
  ! ---
  !  Standard Ortogonal coord. system.         Fractional coord. system.
  !
  !    X                            | 11  12  13 |  X                 
  !    Y  (Cartesian) = FRAC_TO_ORT | 21  22  23 |  Y  (fractional)
  !    Z                            | 31  32  33 |  Z                 
  !
  !  CS_FRAC_TO_ORT 
  ! ---
  !     Fractional coord. system.         Standard Ortogonal coord. system.
  !
  !    X                             | 11  12  13 |    X              
  !    Y  (fractional) = ORT_TO_FRAC | 21  22  23 |    Y  (Cartesian)  
  !    Z                             | 31  32  33 |    Z                  
  !
  !  CS_ORT_TO_FRAC 
  ! ---  
  !   atomic scattering factors
  !
  !  CS_NSFATM
  !  CS_ELEMENT - atom's type ( full name )
  !  CS_ATYPE   - short name
  !  CS_A     
  !  CS_B     
  !  CS_C     
  !  CS_FI    
  !  CS_FII   
  !  CS_RADIUS
  ! ---  
  !    crystallographical symmetry
  !
  !  CS_NSPGR    -  Space group number
  !  CS_SETT     -  Setting number
  !  CS_SPGR     -  Symbilic name of space group,i.e. 'P 21 21 21'
  !  CS_NSYM     -  number or cryst. symmetry operators
  !-----------  CS_SYMOP    -  cryst. symm. operators, symbolic representation
  ! ---
  !  CS_NCS      -  number of non-cryst. symmetry operators
  !
  !    X                       | 11  12  13 |    X                  V_NCS(1)
  !    Y  (Cartesian) =  M_NCS | 21  22  23 |    Y  (Cartesian)  +  V_NCS(2)
  !    Z                       | 31  32  33 |    Z                  V_NCS(3)
  !       
  !  CS_M_NCS    - NCS matrix
  !  CS_V_NCS    - NCS vector
  ! ---
  !===================================================================
  !
  !  II. Additional information about structure 
  !      Information from PDB coordinate file:
  !
  ! -----------------------------------------------------------------
  !
  !---Additional common block used in refmac. Some refinement flags
  integer, parameter :: maxnsf_aa = (maxnsf+1)*maxnsf/2
  INTEGER NGAUS
  INTEGER NGAUS2
  INTEGER ATOM_REF_FLAG(MAXATOM)
  INTEGER OCCUP_REF(MAXATOM)
  REAL CS_AA(25,MAXNSF_AA)
  REAL CS_BB(25,MAXNSF_AA)

  REAL  CS_SCALE(3,3)
  REAL  CS_U(3)
  REAL  CS_TEMPER
  REAL  CS_WAVEL
  REAL  CS_RES_MIN
  REAL  CS_RES_MAX 
  REAL  CS_RFAC_ALL
  REAL  CS_RFAC_OBS
  REAL  CS_SIGMA_I
  REAL  CS_SIGMA_F 
  integer CS_MODEL_PDB
  CHARACTER CS_CD_PDB    *8
  CHARACTER CS_CD_NDB    *8
  CHARACTER CS_CD_CSD    *8
  CHARACTER CS_NAME_PDB  *80
  CHARACTER CS_DATE_PDB  *9
  CHARACTER CS_DATE_NDB  *10
  CHARACTER CS_DATE_CREAT*20
  CHARACTER CS_TITLE     *80
  CHARACTER CS_RESL_PDB  *40
  CHARACTER CS_RFAC_PDB  *40
  CHARACTER CS_PROGRAM   *40
  CHARACTER CS_METHOD    *40
  ! ------------------------------------------------------
  !   PDB scale matrix and U vectors
  !
  !       Fractional coord. system.        Ortogonal coord system of data_PDB
  !
  !        X                     | 11  12  13 |    X                  U(1)
  !        Y  (fract)   =  SCALE | 21  22  23 |    Y  (Cartesian)  +  U(2)
  !        Z                     | 31  32  33 |    Z                  U(3)
  !
  !  CS_SCALE 
  !  CS_U
  ! ---
  !  CS_MODEL_PDB -  serial number of model
  !  CS_CD_PDB    -  PDB code /_database_2.code_PDB/
  !  CS_CD_NDB    -  NDB code /_database_2.code_NDB/
  !  CS_CD_CSD    -  NDB code /_database_2.code_CSD/
  !  CS_NAME_PDB  -  PDB name /_struct_keywords.text/  (PROTEIN,DNA,RNA,...)
  !  CS_DATE_PDB  -  PDB creating date /_database_PDB_rev.data_original /
  !  CS_DATE_NDB  -  NDB creating date 
  !  CS_DATE_CREAT-  file creation date /_audit.creation_date /
  !  CS_TITLE     -  title /_struct.title '5"-D(*CP*GP*CP*G)-3",SPERMIN' /
  !  CS_RESL_PDB  -  resolution from PDB_remark
  !  CS_RFAC_PDB  -  R-factor   from PDB_remark
  !  CS_PROGRAM   -  refinement program name / _computing.structure_refinement / 
  !  CS_METHOD    -   /_expt.method 'X_RAY DIFFRACTION'/ 
  !  CS_TEMPER    -   /_diffrn.ambient_temp 293 /
  !  CS_WAVEL     -   /_diffrn_radiation.wavelength  1.5418 /
  !  CS_RES_MIN   -   /_refine.ls_d_res_low  /
  !  CS_RES_MAX   -   /_refine.ls_d_res_high /
  !  CS_RFAC_ALL  -   /_refine.ls_R_factor_all/
  !  CS_RFAC_OBS  -  t.e. with cutoff /_refine.ls_R_factor_obs/
  !  CS_SIGMA_I   -   / ? _reflns.observed_criterion  '>2sigma(I)' /
  !  CS_SIGMA_F   -
  ! ===================================================================
  !
  !  II.a  More additional information about structure 
  !
  ! -------------------------------------------------------------------
  REAL  CS_DPI
  REAL  CS_ERR_CRD_MIN
  REAL  CS_ERR_CRD_MAX
  REAL  CS_RMERG_ALL
  REAL  CS_RMERG_OBS,CS_RMERG_IOBS
  REAL  CS_RES_RMIN
  REAL  CS_RES_RMAX 
  REAL  CS_SIGMAR_I
  REAL  CS_SIGMAR_F 
  REAL  CS_RFAC_CUT
  REAL  CS_RFREE_OBS
  REAL  CS_RFREE_ALL
  ! -------------------CAT?????????????????
  REAL  CS_RFREE_CUT
  INTEGER CS_NMODEL
  CHARACTER CS_NDB_TITLE  *80
  CHARACTER CS_NAME_NDB   *80
  CHARACTER CS_INFO_FLAG  *1
  ! ------------------------------------------
  !    CS_RFAC_CUT  
  !    CS_NMODEL
  !    CS_RMEGR_ALL
  !    CS_RMERG_OBS
  !    CS_RMERG_IOBS
  !    CS_RES_RMIN  
  !    CS_RES_RMAX 
  !    CS_RFREE_ALL 
  !    CS_FREE_OBS
  !    CS_FREE_CUT
  !    CS_DPI
  !    CS_ERR_CRD_MIN
  !    CS_ERR_CRD_MAX
  !    CS_NDB_TITLE 
  !    CS_NAME_NDB
  !    CS_INFO_FLAG
  ! =================================================================
  !
  !   III. CHAIN and ASYM.PART of unit cell
  !            Information about asymm. part of unit cell and chains.
  
  integer  N_CHN_ENT
  integer  ENT_NRES_CHAIN      (MAXCHAIN)   
  integer  ENT_IRES_FIRST      (MAXCHAIN)   
  integer  ENT_IGROUP_FIRST    (MAXCHAIN)   
  integer  ENT_IRES_START_TREE (MAXCHAIN)   
  integer  ENT_IRES_END_TREE   (MAXCHAIN)   
  integer  ENT_ITERM_S_TYPE    (MAXCHAIN)
  integer  ENT_ITERM_F_TYPE    (MAXCHAIN)
  integer  ENT_ICHAIN_TYPE     (MAXCHAIN)

  CHARACTER  ENT_RES_START_TREE (MAXCHAIN)*5   
  CHARACTER  ENT_RES_END_TREE   (MAXCHAIN)*5   
  CHARACTER  ENT_TERM_S_TYPE    (MAXCHAIN)*8
  CHARACTER  ENT_TERM_F_TYPE    (MAXCHAIN)*8
  CHARACTER  ENT_CHAIN_ID       (MAXCHAIN)*4
  CHARACTER  ENT_CHAIN_TYPE     (MAXCHAIN)*16
  ! -------------------------------------------------------------------
  !  N_CHN_ENT
  !  ENT_CHAIN_TYPE
  !  ENT_CHAIN_ID
  ! -----------------------------------------------------------------
  integer ENT_NRESIDUE
  integer ENT_IRES_SERIAL  (MAXRESID  )   
  integer ENT_IRES_BACK    (MAXRESID  )   
  integer ENT_IRES_FORW    (MAXRESID  )   
  integer ENT_ICHAIN       (MAXRESID  )
  integer ENT_IRES_TYPE    (MAXRESID  )
  integer ENT_ICONN_TYPE   (MAXRESID  )
  CHARACTER ENT_MOD_ID       (MAXRESID  )*8
  CHARACTER ENT_RES_NAME     (MAXRESID  )*8
  CHARACTER ENT_RES_AUTH_NUM (MAXRESID  )*5
  CHARACTER ENT_RES_AUTH_BNUM(MAXRESID  )*5
  CHARACTER ENT_RES_AUTH_FNUM(MAXRESID  )*5
  !      -----------------------------------------------------------------------
  !  ENT_ICHAIN - pointer to ENT_CHAIN
  ! -----------------------------------------------------------------------
  integer ENT_LN_N
  integer ENT_LN_ICHAIN   (MAXLINK)
  integer ENT_LN_1IRES    (MAXLINK)
  integer ENT_LN_2IRES    (MAXLINK)
  CHARACTER ENT_LN_1RNAM    (MAXLINK)*8
  CHARACTER ENT_LN_2RNAM    (MAXLINK)*8
  CHARACTER ENT_LN_ID       (MAXLINK)*8
  CHARACTER ENT_LN_AUTH_NUM1(MAXLINK)*5
  CHARACTER ENT_LN_AUTH_NUM2(MAXLINK)*5
  CHARACTER ENT_LN_ATOM1    (MAXLINK)*5
  CHARACTER ENT_LN_ATOM2    (MAXLINK)*5
  CHARACTER ENT_LN_USED     (MAXLINK)*1
  REAL      ENT_LN_DIST     (MAXLINK)
  ! -----------------------------------------------------------------------
  !  ENT_LN_ICHN - pointer to ENT_CHAIN
  ! -----------------------------------------------------------------------
  integer  N_GRP_ASM
  integer  ASM_CHAIN_POINTER (MAXCHAIN)
  integer  ASM_GROUP_POINTER (MAXCHAIN)
  CHARACTER  ASM_GROUP_ID      (MAXCHAIN)*4
  CHARACTER  ASM_CHAIN_ID      (MAXCHAIN)*4
  ! -------------------------------------------------------------------
  !  N_GRP_ASM
  !  ASM_CHAIN_POINTER    pointer to  ENT_CHAIN
  !  ASM_GROUP_POINTER    pointer to  GROUP / in common ASYM_PART/
  !  ASM_GROUP_ID         = GROUP_ID / in common ASYM_PART/  
  !  ASM_CHAIN_ID         = ENT_CHAIN_ID
  ! -------------------------------------------------------------------
  integer N_GROUP,I_GRP
  integer I_NCS           (MAXCHAIN)   
  integer NRES_CHAIN      (MAXCHAIN)   
  integer NATM_CHAIN      (MAXCHAIN)   
  integer IATOM_FIRST     (MAXCHAIN)   
  integer IRES_FIRST      (MAXCHAIN)   
  integer IRES_START_TREE (MAXCHAIN)   
  integer IRES_END_TREE   (MAXCHAIN)   
  integer ICHAIN_GRP      (MAXCHAIN)   
  integer IGROUP_ASM      (MAXCHAIN)   
  integer MULT_FLAG       (MAXCHAIN)   
  integer ITERM_S_TYPE    (MAXCHAIN)
  integer ITERM_F_TYPE    (MAXCHAIN)
  integer ICH_TYPE        (MAXCHAIN)
  CHARACTER NCS_FLAG        (MAXCHAIN)*1
  CHARACTER GROUP_ID        (MAXCHAIN)*4
  CHARACTER CHAIN_ID        (MAXCHAIN)*4
  ! -----------------------------------------------------------------
  ! N_GROUP      - number of groups in the structure. 
  ! I_GRP        - current pointer of group.
  ! I_NCS        - pointer to NCS matrix.
  ! NRES_CHAIN   - number of residues of chain.
  ! NATM_CHAIN   - number of atoms of chain.
  ! IATOM_FIRST  - pointer to first atom in arrays of coordinats.
  ! IRES_FIRST   - pointer to first residue of chain in arrays /RESID_INF/
  ! ICHAIN_GRP   - group's number with NCS oparator = 0
  ! IGROUP_ASM   - pointer to COMMON /CIF_ASYM_PART/
  ! MULT_FLAG    - 1, 2=>1/2, 3=>1/3, 4=>1/4, 6=>1/6, 8=>1/8, 12=>1/12 
  ! ITERM_S_TYPE - pointer to type of terminus of chain / "NH3",... /
  ! ITERM_F_TYPE - pointer to type of terminus of chain / "COO",... /
  ! ICH_TYPE     - pointer to type of chain /"polymer","non-poly","solvent",.../
  ! NCS_FLAG     - <"N">,"Y","C" 
  ! GROUP_ID     - 
  ! CHAIN_ID     - 
  !===================================================================
  !
  !   IV.  Information about modifications.
  !
  ! -------------------------------------------------------------------
  integer MOD_N
  integer MOD_IRES     (MAXMODIF)
  integer MOD_ICHN     (MAXMODIF)
  CHARACTER MOD_RNAM     (MAXMODIF)*8
  CHARACTER MOD_SEQ      (MAXMODIF)*5
  CHARACTER MOD_CHN      (MAXMODIF)*4
  CHARACTER MOD_ID       (MAXMODIF)*8
  CHARACTER MOD_RNAM_NEW (MAXMODIF)*8
  CHARACTER MOD_USED     (MAXMODIF)*1
  ! -----------------------------------------------------------------
  ! MOD_N    - number of modifications.
  ! MOD_IRES - serial number of residue which was modified. 
  ! MOD_ICHN - chain's number of residue which was modified. 
  ! MOD_RNAM - standard residue name
  ! MOD_RNAM_NEW - actual residue name
  ! MOD_ID   - ID of modifications.
  !       ===================================================================
  !
  !   V.  Information about links.
  !
  ! -------------------------------------------------------------------
  integer LN_N
  integer LN_1IRES (MAXLINK)
  integer LN_1ICHN (MAXLINK)
  integer LN_2IRES (MAXLINK)
  integer LN_2ICHN (MAXLINK)
  CHARACTER LN_1RNAM (MAXLINK)*8
  CHARACTER LN_2RNAM (MAXLINK)*8
  CHARACTER LN_ID    (MAXLINK)*8
  CHARACTER LN_SEQ1  (MAXLINK)*5
  CHARACTER LN_SEQ2  (MAXLINK)*5
  CHARACTER LN_1CHN  (MAXLINK)*4
  CHARACTER LN_2CHN  (MAXLINK)*4
  CHARACTER LN_ATOM1 (MAXLINK)*5
  CHARACTER LN_ATOM2 (MAXLINK)*5
  CHARACTER LN_ALT1  (MAXLINK)*1
  CHARACTER LN_ALT2  (MAXLINK)*1
  CHARACTER LN_SYMM1 (MAXLINK)*8
  CHARACTER LN_SYMM2 (MAXLINK)*8
  CHARACTER LN_USED  (MAXLINK)*1
  CHARACTER LN_ENT   (MAXLINK)*1
  REAL      LN_DIST  (MAXLINK)
  ! -----------------------------------------------------------------------
  ! LN_N     - number of links.
  ! LN_1IRES - serial number of first residue which links with second one. 
  ! LN_1ICHN - chain's number of first residue. 
  ! LN_2IRES - serial number of second residue which links with second one. 
  ! LN_2ICHN - chain's number of second residue. 
  ! LN_1RNAM - residue's name of first residue. 
  ! LN_2RNAM - residue's name of second residue. 
  ! LINK_ID  - ID of links. For example, "SS  ".
  ! LN_SYMM2 - symmetry index of atom_2: 'nnn_ttt'
  ! ====================================================================


  ! ====================================================================
  !
  !  VI. ATOM. Part I. 
  !             Information about atoms :
  !             atom's names, types, symbols,alternative positions.
  !
  ! --------------------------------------------------------------------
  integer N_ATOM,I_ATM,N_ANISO
  integer I_ATOLD  (MAXATOM)
  integer I_RESID  (MAXATOM)
  integer ID_SF    (MAXATOM) 
  integer B_FLAG   (MAXATOM) 
  integer   corr_id  (maxatom)
  integer   belongs_chain(maxatom)
  integer   belongs_shell(maxatom)
  CHARACTER ATM_NAME (MAXATOM)*4  
  CHARACTER ATM_NAME_INP(MAXATOM)*4  
  CHARACTER ATM_CHEM (MAXATOM)*4  
  CHARACTER ATM_TYPE (MAXATOM)*1  
  CHARACTER ID_ALT   (MAXATOM)*1 
  CHARACTER ID_CORR  (MAXATOM)*1  
  CHARACTER SEG_ID   (MAXATOM)*8  
  ! ------------------------------------------------------------
  ! N_ATOM     - total number of atoms in structure.
  ! I_ATM      - current pointer
  ! I_ATOLD    - old (from file) global serial number of atom. 
  ! I_RESID    - pointer to residue.
  ! ID_ALT     - ID of alternative position.           
  ! ID_CORR    - ID of correlated alt. positions.      
  !                      
  ! ATM_NAME   - atom's name - 4 chars.                
  ! ID_SF      - pointer to arrays A,B,C,FI,FII,RADIUS 
  ! ATM_TYPE   - atom's type: "M" missing,"R" rebuild,"D" dummy, "U" unknown/ 
  !
  ! B_FLAG     - = 0 - B_iso, # 0 - U_ANISO  
  ! =============================================================
  !
  !  VII.  ATOM. Part II.
  !             Information about atomic coordinates :
  !             X Y Z, thermal factors,occupancies.
  !
  ! -------------------------------------------------------------
  REAL   XYZ_CRD    (3,MAXATOM)  
  REAL   SD_CRD     (3,MAXATSD)  
  
  REAL   U_ANISO  (6,MAXATOM)  
  REAL   SD_ANISO (6,MAXATSD)  
  
  REAL   OCCUP      (MAXATOM)  
  REAL   SD_OCC     (MAXATSD)
  integer MULT_FACTOR(MAXATOM)
  ! --------------------------------------------------------------
  ! XYZ_CRD  - coordinates.                             
  ! SD_CRD   - sd of coords.                            
  ! B_ISO    - iso.temp.factor                          
  ! SD_ISO   - sd iso.temp.factor                       
  ! OCCUP    - occupancy.                               
  ! SD_OCC   - sd occupancy.                           
  ! MULT_FACTOR  - 1, 2=>1/2, 3=>1/3, 4=>1/4, 6=>1/6, 8=>1/8, 12=>1/12 
  ! U_ANISO  - aniso.temp.factor                        
  ! SD_ANISO - sd aniso                                  
  ! N_ANISO  - number of aniso.temp.factors
  !===================================================================
  !
  !  IX. RESIDUE
  !                Information about residues.
  !
  ! -----------------------------------------------------------------
  integer N_RESIDUE,I_RESIDUE
  integer NATM_RES    (MAXRESID  )  
  integer IRES_SERIAL (MAXRESID  )   
  integer IRES_GLOBAL (MAXRESID  )   
  integer IRES_BACK   (MAXRESID  )   
  integer IRES_FORW   (MAXRESID  )   
  integer IRATM_FIRST (MAXRESID  )
  integer I_CHAIN     (MAXRESID  )
  integer IRES_TYPE   (MAXRESID  )
  integer ICONN_TYPE  (MAXRESID  )
  CHARACTER RES_NAME    (MAXRESID  )*8
  CHARACTER RES_NAME_PDB(MAXRESID  )*3
  CHARACTER RES_NUM_PDB (MAXRESID  )*12
  CHARACTER MOD_FLAG    (MAXRESID  )*1
  CHARACTER LINK_FLAG   (MAXRESID  )*1
  ! ----------------------------------------------------------------
  ! N_RESIDUE   - total number of residues in structure.
  ! I_RESIDUE   - current pointer to residue.
  ! NATM_RES    - number of atoms of each residue. 
  ! IRES_SERIAL - serial number of residue in the chain (1,2,....)
  !IRES_GLOBAL - for special application
  !IRATM_FIRST - pointer to first atom of residue.
  !I_CHAIN     - pointer to chain
  !RES_NAME    - 8 letters code of residue.            
  !RES_NAME_PDB- 3 letters code of residue from PDB file.            
  !RES_NUM_PDB -   chainID    +  residue's number + insertion code PDB 
  !              (PDB_ID + ' ')   _atom_site.auth_seq.id
  !
  !IRES_TYPE    - pointer to type of residue: "pept","DNA","RNA,"solv",...
  !     standard res types:
  !     RES_TYPE( 1) =  '.               '
  !     RES_TYPE( 2) =  'non-polymer     '
  !     RES_TYPE( 3) =  'L-peptide       '
  !     RES_TYPE( 4) =  'D-peptide       '
  !     RES_TYPE( 5) =  'DNA             '
  !     RES_TYPE( 6) =  'RNA             '
  !     RES_TYPE( 7) =  'D-pyranose      '
  !     RES_TYPE( 8) =  'L-pyranose      '
  !     RES_TYPE( 9) =  'solvent         '
  !     RES_TYPE(10) =  'polymer         '
  !     RES_TYPE(11) =  'D-furanose      '
  !     RES_TYPE(12) =  'L-furanose      '
  !     RES_TYPE(13) =  'D-saccharide    '
  !     RES_TYPE(14) =  'L-saccharide    '
  !ICONN_TYPE   - pointer to type of connectivity with previous residue:
  !                                                         "CIS","TRANS",...
  !MOD_FLAG    - flag of modification. If "Y",there is information in /MOD_INF/
  !LINK_FLAG   - flag of links. If "Y",there is information in /LINK_INF/
  !----------------------------------------------------------------
  REAL                CENTER_RES(3,MAXRESID  )
  REAL                RADIUS_RES(MAXRESID  )
  INTEGER             IFLAG_RES (MAXRESID  )
  !===================================================================
  
  
  
  !==============================================================
  !
  ! X. restraints / only numbers /. All details in rstr-com.fh
  !
  !--------------------------------------------------------------
  integer RB_NUMB
  integer RA_NUMB
  integer RT_NUMB
  integer RC_NUMB
  integer RP_NUMB
  integer RH_NUMB
  integer RV_NUMB
  !==============================================================
  
  !==============================================================
  !
  ! XI.  program and library file.
  ! 
  CHARACTER PROG_NAME_LB *8
  CHARACTER LIB_NAME     *10
  CHARACTER LIB_VERS     *10
  CHARACTER LIB_DATE     *10
  CHARACTER PROG_NAME_CRD*8
  !
  !LIB_NAME   -
  !LIB_VERS   - library information
  !LIB_DATE   -
  !==============================================================

  !==============================================================
  !
  ! XII.  CIF_types.
  !
  !-------------------------------------------------------------------
  !
  !    initialization in subroutine INIT_ATM_INF (make_subr.f)
  !
  integer            OUT_CIF_MULT,OUT_CIF_CORR,OUT_CIF_INS 
  !-------------------------------------------------------------------
  !
  !    initialization in SET_CIF_TYPES ( call start() - make_subr.f)
  !
  INTEGER, parameter ::   MAXTYPES=20
  INTEGER, parameter ::  MAXTYPES2 = maxtypes*2


  integer N_RES_TYPE
  integer N_STERM_TYPE
  integer N_FTERM_TYPE
  integer N_CONN_TYPE
  integer N_CH_TYPE

  CHARACTER RES_TYPE    (MAXTYPES )*16
  CHARACTER RES_LTYPE   (MAXTYPES )*8
  CHARACTER TERM_S_TYPE (MAXTYPES )*8
  CHARACTER TERM_F_TYPE (MAXTYPES )*8
  CHARACTER CONN_TYPE   (MAXTYPES2)*8
  CHARACTER CH_TYPE     (MAXTYPES )*8

  !     CHARACTER LINK_TP_ID   (MAXTYPES )*8
  !     CHARACTER LINK_TP_MON1 (MAXTYPES )*8
  !     CHARACTER LINK_TP_MON2 (MAXTYPES )*8
  !     CHARACTER LINK_TP_ATOM1(MAXTYPES )*4
  !     CHARACTER LINK_TP_ATOM2(MAXTYPES )*4
  !     CHARACTER LINK_TP_GRP  (MAXTYPES )*1
  !     integer N_LINK_TYPE
  !-----------------------------------------------------------------
  !N_RES_TYPE   - number of types of monomers.
  !N_STERM_TYPE - number of types of N-terminus.
  !N_FTERM_TYPE - number of types of C-terminus.
  !N_CONN_TYPE  - number of types of connections.
  !RES_TYPE    _ type of each residue: "pept","DNA","RNA,"solv",...
  !TERM_S_TYPE - type of terminus of chain: "NH3"
  !TERM_F_TYPE - type of terminus of chain: "COO"
  !CONN_TYPE   - type of connectivity with previous residue:"CIS","TRNS",...
  !===================================================================
  INTEGER, parameter :: MAXMODREC = 20
  integer   N_MOD_REC 
  integer   MOD_REC_IRTYPE(MAXMODREC)   
  CHARACTER   MOD_REC_DETAIL(MAXMODREC)*48
  CHARACTER   MOD_REC_FUNC  (MAXMODREC)*3
  CHARACTER   MOD_REC_ID    (MAXMODREC)*8
  !===================================================================

contains
  subroutine allocate_atom_blocks

  end subroutine allocate_atom_blocks

  subroutine deallocate_atom_blocks

  end subroutine deallocate_atom_blocks
end module atom_com
