module ridge
  real :: sigma_dist_r=0.0
  real :: dmax_dist_r = 4.2
  real :: sigma_pos_r = 0.0
  real :: sigma_b_r = 0.0
  real :: sigma_u_r = 0.0
  integer :: interchain_dist_r=0

contains

  subroutine ridge_pos(am,atom_ref_flag)
    implicit none
    !
    !  Ridge type restraints for atomic positions
    real, intent(inout) :: am(:)
    integer, intent(in) :: atom_ref_flag(:)
    !
    !  locals
    integer ia,ia1,n_atom,ip
    real w

    !
    ! body
    if(sigma_pos_r.le.0.0) return
    w =   1.0/sigma_pos_r**2
    n_atom = size(atom_ref_flag(:))
    do ia=1,n_atom
       if(atom_ref_flag(ia).le.0) cycle
       ia1 = atom_ref_flag(ia)/10
       if(ia1.le.0) cycle
       ip = 6*ia1-5
       am(ip:ip+2) = am(ip:ip+2) + w
    enddo
    return
  end subroutine ridge_pos

  subroutine ridge_dist(nmpos,am,n_target,n_object,nsym_dist,nw_uval,nrest_per_atom,rest_per_atom, &
       i_resid,atom_ref_flag,xyz_crd,occup,file_in)
    implicit none

    integer, intent(in) :: n_target(:),n_object(:),nsym_dist(:,:),nw_uval(:)
    integer, intent(in) :: nrest_per_atom(:),rest_per_atom(:,:)
    integer, intent(in) :: i_resid(:)
    integer, intent(in) :: atom_ref_flag(:)
    real, intent(in) :: xyz_crd(:,:),occup(:)
    integer, intent(in) :: nmpos
    real, intent(inout) :: am(:)
    character(len=*), intent(in) :: file_in
    !
    integer n_atom,max_mat,ndist
    real rs_vidl(3)
    integer ia1_l(2),ia11_l(2),isym_l(4),ir1(2),itype
    integer ipos_mat1(2)
    integer ib,iw_uval,imode,idist
    integer in_file,ierr
    integer nr_vdw
    real small_bond,bond_c,w
    real dbdx1(3),dbdx2(3)
    character chnamp1*4,chnamp2*4
    !
    !   body
    if(sigma_dist_r.le.0.0) return
    n_atom = size(xyz_crd(1,:))
    max_mat = size(am(:))
    ndist = size(n_target(:))
    small_bond = 0.01
    iw_uval = 7
    if(len_trim(file_in).le.0) return
    ierr = 0
    call open_unform_file(in_file,file_in,ierr)
    if(ierr.gt.0) return

    read(in_file)nr_vdw
    if(nr_vdw.le.0) then
       close(in_file)
       return
    endif

    do ib=1,nr_vdw
       read(in_file)ia1_l(1:2),rs_vidl(1:3),isym_l(1:4),itype
       isym_l(1) = max(1,isym_l(1))
       if(isym_l(1).gt.1.or.sum(abs(isym_l(2:4))).ne.0) cycle
       if(ia1_l(1).le.0.or.ia1_l(2).le.0) cycle
       if(atom_ref_flag(ia1_l(1)).le.0.or.atom_ref_flag(ia1_l(2)).le.0) cycle
       ir1(1:2) = i_resid(ia1_l(1:2))
       call get_chain_namepdb(chnamp1,ir1(1))
       call get_chain_namepdb(chnamp2,ir1(2))
       if(chnamp1.ne.chnamp2.and.interchain_dist_r.eq.0) cycle

       ia11_l(1:2) = atom_ref_flag(ia1_l(1:2))/10
       dbdx1(1:3) = xyz_crd(1:3,ia1_l(1))-xyz_crd(1:3,ia1_l(2))
       bond_c = sqrt(sum(dbdx1(1:3)**2))
       if(bond_c.gt.dmax_dist_r) cycle
       dbdx1(1:3) = dbdx1(1:3)/max(small_bond,bond_c)
       dbdx2(1:3) = -dbdx1(1:3)
       w = 1.0/sigma_dist_r**2
       ipos_mat1(1:2) = 6*ia11_l(1:2) - 6
       call incr_matr_diagonal(max_mat,ipos_mat1(1),am,w,dbdx1)
       call incr_matr_diagonal(max_mat,ipos_mat1(2),am,w,dbdx2)
       call find_restraint(ndist,ndist,idist,ia1_l(1),ia1_l(2),isym_l,n_atom,nrest_per_atom, &
            rest_per_atom,n_target,n_object,nsym_dist,nw_uval,iw_uval,imode)
       ipos_mat1(1) = nmpos + 9*(idist-1)

       if(imode.eq.0) then
          call incr_matr_ndiag(max_mat,ipos_mat1(1),am,w,dbdx1,dbdx2)
       else
          call incr_matr_ndiag(max_mat,ipos_mat1(1),am,w,dbdx2,dbdx1)
       endif       
    enddo
    close(in_file)

    return
  end subroutine ridge_dist

  subroutine ridge_dist2orig(sum_f,nmpos,am,v,n_target,n_object,nsym_dist,nw_uval,nrest_per_atom,rest_per_atom, &
       i_resid,atom_ref_flag,xyz_crd,occup,file_in)
    implicit none
    !
    !  this subroutine is similar to distance restraints. Only difference is that in this routine weights
    !  depend on the deviation from the "ideal" value
    real, intent(out) :: sum_f
    integer, intent(in) :: n_target(:),n_object(:),nsym_dist(:,:),nw_uval(:)
    integer, intent(in) :: nrest_per_atom(:),rest_per_atom(:,:)
    integer, intent(in) :: i_resid(:)
    integer, intent(in) :: atom_ref_flag(:)
    real, intent(in) :: xyz_crd(:,:),occup(:)
    integer, intent(in) :: nmpos
    real, intent(inout) :: am(:),v(:)
    character(len=*), intent(in) :: file_in
    !
    !  locals
    integer ierr,in_file
    integer n_atom,ndist,n_vec,n_mat,imode,iw_uval
    integer ir,nr_vdw,ip1,idist
    integer ia1_l(2),ia11_l(2),isym_l(4)
    real rs_vidl(2)
    real small_bond,bond_c,w,delta,dbondw,dbondw2,ww,ww1,w_gm
    real dbdx1(3),dbdx2(3)
    !
    !  body
    if(sigma_dist_r.le.0) return
    if(len_trim(file_in).le.0) return
    
    w = 1.0/sigma_dist_r**2
    w_gm = 0.1
    ierr = 0
    call open_unform_file(in_file,file_in,ierr)
    if(ierr.gt.0) return
    read(in_file)nr_vdw
    if(nr_vdw.le.0) then
       close(in_file)
       return
    endif
    n_atom = size(xyz_crd(1,:))
    n_mat = size(am(:))
    ndist = size(n_target(:))
    n_vec = size(v(:))

    iw_uval = 7
    sum_f = 0.0
    do ir=1,nr_vdw
       read(in_file)ia1_l(1:2),rs_vidl(1:2)
       isym_l(1) = 1
       isym_l(2:4) = 0
       if(atom_ref_flag(ia1_l(1)).le.0.or.atom_ref_flag(ia1_l(2)).le.0) cycle
       
       dbdx1(1:3) = xyz_crd(1:3,ia1_l(1))-xyz_crd(1:3,ia1_l(2))
       bond_c = sqrt(sum(dbdx1(1:3)**2))
       dbdx1 = dbdx1/max(bond_c,small_bond)
       dbdx2 = -dbdx1
       delta = rs_vidl(1)-bond_c
       dbondw = w*delta
       dbondw2 = w*delta**2
       ww = 1.0/(1.0+w_gm*dbondw2)**2
       sum_f = sum_f + 0.5*dbondw2
       ip1 = 3*(ia11_l(1)-3)
       call incr_vector(n_vec,ip1,v,dbondw,dbdx1)
       ip1 = 3*(ia11_l(2)-3)
       call incr_vector(n_vec,ip1,v,dbondw,dbdx2)
       ip1 = 6*(ia11_l(1)-6)
       ww1 = w*ww
       call incr_matr_diagonal(n_mat,ip1,am,ww1,dbdx1)
       ip1 = 6*(ia11_l(2)-6)

       call find_restraint(ndist,ndist,idist,ia1_l(1),ia1_l(2),isym_l,n_atom,nrest_per_atom, &
            rest_per_atom,n_target,n_object,nsym_dist,nw_uval,iw_uval,imode)
       ip1 = nmpos + 9*(idist-1)

       if(imode.eq.0) then
          call incr_matr_ndiag(n_mat,ip1,am,ww1,dbdx1,dbdx2)
       else
          call incr_matr_ndiag(n_mat,ip1,am,ww1,dbdx2,dbdx1)
       endif       
    enddo

    return
  end subroutine ridge_dist2orig

  subroutine ridge_uval_iso(nmtmp,am,atom_ref_flag,u_aniso)
    implicit none

    integer, intent(in) :: atom_ref_flag(:)
    real, intent(in) :: u_aniso(:,:)
    integer, intent(in) :: nmtmp
    real, intent(inout) :: am(:)
    !
    !   locals
    integer n_atom
    integer ia,ia1,l1,l2,lm
    integer, allocatable :: lposm(:)
    real biso1,dr1,wt3

    if(sigma_pos_r.le.0) return
    n_atom = size(u_aniso(1,:))
    !    call find_pos_of_u()
    wt3 = 1.0/sigma_pos_r**2
    l1 = 0
    l2 = nmtmp
    allocate(lposm(n_atom))
    lm = 1
    ia1 = 0
    do ia=1,n_atom
       if(atom_ref_flag(ia).le.0) cycle
       ia1 = ia1 + 1
       lposm(ia1) = lm
       if(u_aniso(2,ia).gt.0) then
          lm = lm + 21
       else
          lm = lm + 1
       endif
    enddo
    !
    do ia=1,n_atom
       if(atom_ref_flag(ia).le.0) cycle
       if(u_aniso(2,ia).gt.0.0) cycle
       biso1 = u_aniso(1,ia)
       dr1 = 1.0/biso1
       lm = lposm(ia)
       am(l1+lm) = am(l2+lm) + 2.0*wt3*dr1*dr1
    enddo
    deallocate(lposm)

  end subroutine ridge_uval_iso

  subroutine ridge_uval_aniso(nmtmp,am,atom_ref_flag,u_aniso)
    implicit none

    integer, intent(in) :: atom_ref_flag(:)
    real, intent(in) :: u_aniso(:,:)
    integer, intent(in) :: nmtmp
    real, intent(inout) :: am(:)

    return
  end subroutine ridge_uval_aniso

end module ridge
