module ncs_simil

contains
  subroutine ncs_similarity(fvalue,nmpos,a_mat,vect,ndis,n_target,                                  &
       n_object,nsym_dist,nw_uval,rest_pos_per_atom,rest_per_atom,xyz_crd,                             &
       atom_ref_flag,ncs_simil_file,moni_style,i_resid,res_num_pdb,res_name,atm_name,id_alt,gm_ncsr_simil_param,  &
       hnrestr,hrestr_num,hrestr_devitar,hrestr_dev,hrestr_ideal,hrestr_z,hrestr_cif,hrestr_type)
    implicit none
    !  include 'atom_com.fh'
    !  include 'models.fh'
    !  include 'celsym.fh'
    !  include 'vitals.fh'
    !  include 'monitor.fh'
    !  include 'weights.fh'
    !  include 'rharvest.fh'
    !  include 'restr_files.fh'
    
    integer ndis,nmpos
    real, intent(in) :: xyz_crd(:,:)
    integer, intent(in) :: atom_ref_flag(:)
    real :: a_mat(:),vect(:)
    integer :: rest_pos_per_atom(:),rest_per_atom(:)
    integer :: n_target(:),n_object(:),nw_uval(:),nsym_dist(:,:)
    integer :: i_resid(:)
    character(len=*) :: res_num_pdb(:)
    character(len=*) :: res_name(:)
    character(len=*) :: atm_name(:)
    character(len=*) :: id_alt(:)

    real, intent(in) :: gm_ncsr_simil_param
    real fvalue
    !
    character(len=*) :: ncs_simil_file

    character(len=*) :: moni_style

    ! 
    !    Things for harvest and cif
    integer hnrestr
    character(len=*) :: hrestr_type(:)
    character(len=*) :: hrestr_cif(:)
    integer :: hrestr_num(:)
    real :: hrestr_devitar(:)
    real :: hrestr_dev(:)
    real :: hrestr_ideal(:)
    real :: hrestr_z(:)

    integer n_atom,max_mat,max_rest
    integer ir,igr
    
    integer ifile,ierr
    integer nrests,ngroups
    integer ia1(4),ia11(4),ia12(4)
    real    sigx,weight_b,wt,wt1,w2
    real arg,expd,expdw,alogd,w1
    real x1diff(3),x2diff(3),dfdx(3,4)
    real ncs_discard
    integer nrest_ncs_total
    real rms_ncs_total
    real sigma_ncs_total
    
    integer ip,ipos_mat,i,j,idist,iw_uval,imode,nrest_l,n_all
    real delta,deltaw,deltaw1,deltaw2,delta2,dist1,dist2
    integer, allocatable ::  nrest_ncs(:)
    real,    allocatable ::  rms_ncs(:)
    real,    allocatable :: sigma_ncs(:) 

    integer nr,nr_all,nr0,k
    integer, allocatable :: ia1_l(:,:)
    real, allocatable :: sigx_l(:)
    real, allocatable :: wtb(:)
    real :: small_bond = 0.0001

    integer :: ireport
    integer :: ir1,ir2,ir3,ir4
    character(len=7) :: chnum
    character(len=4) :: chnm1,chnm2,chnm3,chnm4
    character(len=1024) :: line
    !
    !   Constats
    real*8 twopi
    !
    !---- body
    fvalue = 0.0
    ncs_discard = 20.0
    if(len_trim(ncs_simil_file).le.0) return
    call open_unform_file(ifile,ncs_simil_file,ierr)
    
    read(ifile)ngroups,n_all
    if(ngroups.le.0) then
       close(ifile)
       return
    endif
    allocate(rms_ncs(ngroups))
    allocate(nrest_ncs(ngroups))
    allocate(sigma_ncs(ngroups))
    
    rms_ncs(1:ngroups) = 0.0
    nrest_ncs(1:ngroups) = 0
    sigma_ncs(1:ngroups) = 0.0
    n_atom = size(xyz_crd(1,:))
    max_mat = size(a_mat)
    max_rest = size(n_target)
    w1 = 1.0e-1

    if(gm_ncsr_simil_param.gt.0.0) w1 = gm_ncsr_simil_param
!    w1 = 0.0
    twopi = 8.0e0*atan(1.0e0)
!    w1 = w1*sqrt(twopi)
    nrest_l = 0
    ireport = 0
    do igr=1,ngroups
       read(ifile)nrests
       nr_all = 0
       do while (nr_all.lt.nrests)
          read(ifile)nr
          if(nr.le.0) cycle
          allocate(ia1_l(4,nr))
          allocate(sigx_l(nr))
          allocate(wtb(nr))
          nr_all = nr_all + nr
          if(nr_all.gt.nrests) then
             write(*,*)'Error==> In ncs_similarity: Sum of restraints do not match'
             call ccperr(1,'Problem in ncs_similariy')
          endif
          read(ifile)(ia1_l(1:4,k),sigx_l(k),wtb(k),k=1,nr)
          mainl: do ir=1,nr
             ia1(1:4) = ia1_l(1:4,ir)
             sigx = sigx_l(ir)
             weight_b = wtb(ir)

             if(minval(abs(atom_ref_flag(ia1(1:4)))) .le. 0) cycle mainl
             ia11(1:4) = atom_ref_flag(ia1(1:4))/10
             ia12(1:4) = atom_ref_flag(ia1(1:4))-10*ia11(1:4)
             if(abs(sum(ia12(1:4))) .le. 0) cycle mainl       
       
             x1diff = xyz_crd(1:3,ia1(1))-xyz_crd(1:3,ia1(2))
             x2diff = xyz_crd(1:3,ia1(3))-xyz_crd(1:3,ia1(4))
             !
             !---Discard this pair if distances are too different???
             dist1 = sqrt(sum((x1diff**2)))
             dist2 = sqrt(sum((x2diff**2)))
             
             delta = dist2-dist1
!             delta = -delta
             !
             !    Report outliers
             if(abs(delta).gt.ncs_discard*sigx.and.moni_style.eq.'MANY'.or.moni_style(1:3).eq.'MEDI') then
                if(ireport.eq.0) then
                   call header('NCS local restraint outliers')
                   write(*,'(1x,a,f6.2,a)')'Differences between distances >',ncs_discard,'sigma will be monitored'
                   write(*,*)
                   write(*,*)'Atom identifiers: ChainName, ResdueNumber, ResidueName, AtomName, AltCode'
                   write(*,*)
                   write(*,'(2x,147a)')('-',i=1,147)
                   write(line,'(a1,9x,a10,9x,a1,9x,a11,8x,a1,1x,a6,1x,a1,9x,a11,8x,a1,8x,a12,8x,a1,1x,3(a6,1x),a)')     &
                             ':','First atom','-','Second atom',':','dist1', ':', &
                             'Third atom','-','Fourth atom',':','dist2',      &
                             'delta','sigma',':'
                   write(*,*)trim(line)
                   write(*,'(2x,147a)')('-',i=1,147)
                   ireport = 1
                endif
                ir1 = i_resid(ia1(1))
                ir2 = i_resid(ia1(2))
                ir3 = i_resid(ia1(3))
                ir4 = i_resid(ia1(4))
                call get_chain_namepdb(chnm1,ir1)
                call get_chain_namepdb(chnm2,ir2)
                call get_chain_namepdb(chnm3,ir3)
                call get_chain_namepdb(chnm4,ir4)

                write(line,'(a1,1x,12(a,1x),f6.2,1x,13(a,1x),3(f6.2,1x),a)')':',chnm1,res_num_pdb(ir1)(3:7),res_name(ir1),     &
                                    atm_name(ia1(1)),id_alt(ia1(1)),                          &   
                                    '-',chnm2,res_num_pdb(ir2)(3:7),res_name(ir2),          &
                                    atm_name(ia1(2)),id_alt(ia1(2)),':',dist1,              &
                                    ':',chnm3,res_num_pdb(ir3)(3:7),res_name(ir3),          &
                                    atm_name(ia1(3)),id_alt(ia1(3)),                          &
                                    '-',chnm4,res_num_pdb(ir4)(3:7),res_name(ir4),          &
                                    atm_name(ia1(4)),id_alt(ia1(4)),':',dist2,delta,sigx,':'
                write(*,*)trim(line)
             endif

             delta2 = delta**2
             wt = 1.0/sigx**2
!             w2 = w1
!             arg = (delta/sigx)**2/2.0
!             expd = exp(-arg)
!             expdw = w2 + expd
!             alogd = -log(expdw)
!             alogd = delta2
          ! 
          !  Should the weight depend on distances. If so then be careful. 
          !  Function may be a bit more complicated
             dfdx(1:3,1) =  x1diff(1:3)/max(small_bond,dist1)
             dfdx(1:3,2) = -dfdx(1:3,1)
             dfdx(1:3,3) = -x2diff(1:3)/max(small_bond,dist2)
             dfdx(1:3,4) = -dfdx(1:3,3)         
!             if(abs(delta).gt.1.0.and.abs(delta)/sigx.gt.20.0) then
!                wt = 0.0
!             endif
             deltaw = delta/sigx
             deltaw2 = deltaw**2
             alogd = deltaw2/(1.0+w1*deltaw2)

             fvalue = fvalue + alogd
             nrest_l = nrest_l + 1
          !---  
          !---  increment grads
!          delta = (dist2-dist1)/(dist1+dist2)
!             if(expd/expdw.le.0.5) write(*,*)expd/expdw,delta/sigx,dist1,dist2
!             deltaw = delta*exp(-abs(delta)/2.0)/(1.0e-5+exp(-abs(delta/2)))
             wt1 = wt/(1.0+w1*deltaw2)**2
             do i=1,4
                ip = 3*(ia11(i)-1)
                vect(ip+1:ip+3) = vect(ip+1:ip+3) + wt1*delta*dfdx(1:3,i)
             enddo
             !     
             !---  increment secders
             !   wt1 = max(0.0,wt*(1.0-w1*deltaw2)/(1.0+w1*deltaw2)**3)
             wt1 = wt/(1.0+w1*deltaw2)**2
             do i=1,4
                ipos_mat = 6*(ia11(i)-1)
                call incr_matr_diagonal(max_mat,ipos_mat,a_mat,wt1,dfdx(1:3,i))
             enddo
             do i=1,3
                do j=i+1,4
                   call find_restraint(max_rest,ndis,idist,ia1(i),ia1(j),              &
                        nsym_dist,n_atom,rest_pos_per_atom,rest_per_atom,          &
                        n_target,n_object,nsym_dist,nw_uval,iw_uval,imode)
                   ipos_mat = nmpos+9*(idist-1)
                   if(imode.eq.0) then
                      call incr_matr_ndiag(max_mat,ipos_mat,a_mat,wt1,dfdx(1:3,i),dfdx(1:3,j))
                   else
                      call incr_matr_ndiag(max_mat,ipos_mat,a_mat,wt1,dfdx(1:3,j),dfdx(1:3,i))
                   endif
                enddo
             enddo
          !
          !---And some stats
             rms_ncs(igr) = rms_ncs(igr) + delta2
             nrest_ncs(igr) = nrest_ncs(igr) + 1
             sigma_ncs(igr) = sigma_ncs(igr) + sigx
          enddo mainl
          deallocate(ia1_l)
          deallocate(sigx_l)
          deallocate(wtb)
       enddo
    enddo
    if(ireport.eq.1) write(*,'(2x,147a)')('-',i=1,147)

    write(*,*)
!    stop
    !    write(*,*)nrest_l,fvalue
    !
    !---Sort out ncs groups. What does it mean. Should we use one for all??
    do igr = 1,ngroups
       if(nrest_ncs(igr).gt.0) then
          hnrestr = hnrestr+1
          sigma_ncs(igr) = sigma_ncs(igr)/nrest_ncs(igr)
          hrestr_devitar(hnrestr) = sigma_ncs(igr)
          hrestr_dev(hnrestr) = sqrt(rms_ncs(igr)/nrest_ncs(igr))
          hrestr_num(hnrestr) = nrest_ncs(igr)
          write(hrestr_type(hnrestr),'(a18,i4)') 'ncsr local: group ',igr
          write(chnum,'(i6)')igr
          hrestr_cif(hnrestr) = 'r_ncsr_local_group_'//trim(adjustl(chnum))
       endif
    enddo
    nrest_ncs_total = sum(nrest_ncs(1:ngroups))
    rms_ncs_total = sum(rms_ncs(1:ngroups))
    sigma_ncs_total = sum(sigma_ncs(1:ngroups))
    if(nrest_ncs_total.gt.0) then
       rms_ncs_total = sqrt(rms_ncs_total/nrest_ncs_total)
       sigma_ncs_total = sigma_ncs_total/nrest_ncs_total
    endif
    deallocate(nrest_ncs)
    deallocate(rms_ncs)
    deallocate(sigma_ncs)
    
    close(ifile)
    return
  end subroutine ncs_similarity
  
  subroutine ncs_local_define(xyz_crd,sigx_ncs_local,dmax_ncs_local,diffmax_ncs_local,vdw_file,ncs_rest_file,  &
       ncs_simil_file,ncsr_use)
    implicit none
    !      include 'atom_com.fh'
    !      include 'restr_files.fh'
    real, intent(in) :: sigx_ncs_local,dmax_ncs_local,diffmax_ncs_local

    real, intent(in) :: xyz_crd(:,:)
    character(len=*), intent(in) :: vdw_file
    character(len=*), intent(in) :: ncs_rest_file
    character(len=*) :: ncs_simil_file
    
    !
    !---  Using correspondence between atoms create a file of local similarity.
    !--   Input file is file of ncs related atoms (there are ncs_loc number of 
    !---  different groips. Each group has nchn number of chains related with 
    !---  each other. The number of atoms related in group is ns. 
    !---  Output file contains quadruple of atoms: i1,i2,i3,i4. distance between 
    !---  i1 and i2 atoms should be similar to that between i3 and i4. 
    !
    integer n_atom
    integer igr,iw
    integer i,j,k,i1,i2,j1,ia,ja,ian,jan,ii,jj,is,il,in,ir
    integer ic,ncs_simil_pairs
    integer ifile_vdw,ifile_ncs,ifile_loc,ifile_simil
    integer ierr
    integer ncs_loc,ivdw,nvdw,chn_pairs,n_ncs_loc
    integer ns,nchn
    integer isym(4),ia1(4),vdw_type
    real rs_vidl(3),sigb,dist1,dist2
    real xx1(3),xx2(3),yy1(3),yy2(3)
    real weight_b
    !
    !---  These should come from include files
    real sigx2
    real :: sigx1
    character ncsr_use*1
    character ncs_temp*512
    character title_ncs*80
    !
    !---  Allocatables
    integer max_per_atom
    integer, allocatable :: pairs_vdw(:,:)
    integer, allocatable :: nvdw_per_atom(:)
    integer, allocatable :: vdw_per_atom(:,:)
    integer, allocatable :: pairs_ncs(:)
    integer, allocatable :: iat(:,:)
    integer, allocatable :: n_grp_ncs(:)
    real, allocatable :: sigx(:)

    integer, allocatable :: ias(:,:)
    real, allocatable :: sigx_loc(:)
    real, allocatable :: wtb(:)
    !
    !  Date and time
    character(8)  :: dt
    character(10) :: tm
    character(5)  :: zn
    integer,dimension(8) :: val_l
    real dist_cut_ncs,diff_dist_cut

    !
    !  body
    if(ncsr_use.ne.'S') return
    sigx1 = sigx_ncs_local
    if(sigx1.le.0.0) sigx1 = 0.05
    dist_cut_ncs = dmax_ncs_local
    if(dist_cut_ncs.le.0.0) dist_cut_ncs = 50.0
    diff_dist_cut = diffmax_ncs_local
    if(diff_dist_cut.le.0.0) diff_dist_cut = 50.0
    n_atom = size(xyz_crd(1,:))
    if(len_trim(vdw_file).le.0.or.len_trim(ncs_rest_file).le.0) return
    call open_unform_file(ifile_vdw,vdw_file,ierr)
    read(ifile_vdw)nvdw
    if(nvdw.le.0) then
       close(ifile_vdw)
       return
    endif
    allocate(pairs_vdw(2,nvdw))
    ivdw = 0
    do i=1,nvdw
       read(ifile_vdw)ia1(1:2),rs_vidl(1:3),isym(1:4),vdw_type
       if(isym(1).eq.1.and.sum(abs(isym(2:4))).eq.0) then
          ivdw = ivdw+1
          pairs_vdw(1:2,ivdw) = ia1(1:2)
       endif
    enddo
    close(ifile_vdw)
    nvdw = ivdw
    allocate(nvdw_per_atom(n_atom))
    nvdw_per_atom(1:n_atom) = 0
    do i=1,nvdw
       nvdw_per_atom(pairs_vdw(1,i)) = nvdw_per_atom(pairs_vdw(1,i)) + 1
       nvdw_per_atom(pairs_vdw(2,i)) = nvdw_per_atom(pairs_vdw(2,i)) + 1
    enddo
    max_per_atom = maxval(nvdw_per_atom(1:n_atom))
    allocate(vdw_per_atom(max_per_atom,n_atom))
    nvdw_per_atom(1:n_atom) = 0
    do i=1,nvdw
       i1 = pairs_vdw(1,i)
       i2 = pairs_vdw(2,i)
       nvdw_per_atom(i1) = nvdw_per_atom(i1) + 1
       vdw_per_atom(nvdw_per_atom(i1),i1) = i2
       nvdw_per_atom(i2) = nvdw_per_atom(i2) + 1
       vdw_per_atom(nvdw_per_atom(i2),i2) = i1
    enddo
    deallocate(pairs_vdw)
    !     
    call open_unform_file(ifile_ncs,ncs_rest_file,ierr)
    read(ifile_ncs)ncs_loc
    !
    !   If there is no ncs then return.
    if(ncs_loc.le.0) then
       close(ifile_ncs)
       deallocate(nvdw_per_atom)
       deallocate(vdw_per_atom)
       return
    endif
    if(len_trim(ncs_simil_file).le.0) then
       call find_unique_file_name(ncs_simil_file,'.ncs_loc')
    endif
    call open_unform_file(ifile_simil,ncs_simil_file,ierr)

    allocate(pairs_ncs(n_atom))
    igr = 0
    ncs_simil_pairs = 0
    !
    !    Find sizes
    allocate(n_grp_ncs(20000))
    n_grp_ncs = 0
    do il=1,ncs_loc
       read(ifile_ncs)ns,nchn
       allocate(iat(ns,nchn))
       allocate(sigx(ns))
       do is=1,ns
          read(ifile_ncs)iw,sigx(is),sigb,(iat(is,k),k=1,nchn),weight_b
       enddo
       do i=1,nchn-1
          do j=i+1,nchn
             igr = igr + 1
             if(igr.gt.20000) then
                write(*,*)'Too many ncs pairs in ncs_local'
                stop
             endif
             pairs_ncs(1:n_atom) = 0
             pairs_ncs(iat(1:ns,i)) = iat(1:ns,j)
             n_ncs_loc = 0
             do is=1,ns
                ian = iat(is,i)
                if(pairs_ncs(ian).gt.0) then
                   jan = pairs_ncs(ian)
                   xx1(1:3) = xyz_crd(1:3,ian)
                   yy1(1:3) = xyz_crd(1:3,jan)
                   do in=1,nvdw_per_atom(ian)
                      ii = vdw_per_atom(in,ian)
                      if(pairs_ncs(ii).gt.0.and.ii.gt.ian) then
                         jj = pairs_ncs(ii)
                         xx2(1:3) = xyz_crd(1:3,ii)
                         yy2(1:3) = xyz_crd(1:3,jj)
                         dist1 = sqrt(sum((xx1-xx2)**2))
                         dist2 = sqrt(sum((yy1-yy2)**2))
                         if(dist1.gt.dist_cut_ncs.or.dist2.gt.dist_cut_ncs) cycle
                         if(abs(dist1-dist2).gt.diff_dist_cut) cycle
                         n_ncs_loc = n_ncs_loc + 1
                      endif
                   enddo
                endif
             enddo
          enddo
          n_grp_ncs(igr)  = n_ncs_loc
          if(n_ncs_loc.gt.0) ncs_simil_pairs = ncs_simil_pairs + 1
       enddo
       deallocate(iat)
       deallocate(sigx)
    enddo
    rewind(ifile_ncs)
    read(ifile_ncs) ncs_loc
    !
    !  Calculate similar pairs and write to a file


    write(ifile_simil) ncs_simil_pairs,sum(n_grp_ncs(1:igr))
    igr = 0
    allocate(ias(4,500))
    allocate(sigx_loc(500))
    allocate(wtb(500))
    do il=1,ncs_loc
       read(ifile_ncs)ns,nchn
       allocate(iat(ns,nchn))
       allocate(sigx(ns))
       do is=1,ns
          read(ifile_ncs)iw,sigx(is),sigb,(iat(is,k),k=1,nchn),weight_b
       enddo
       do i=1,nchn-1
          do j=i+1,nchn
             igr = igr + 1
             if(n_grp_ncs(igr).le.0) cycle
             !
             !    Write info about ncs: chains or something
             write(ifile_simil) n_grp_ncs(igr)
             pairs_ncs(1:n_atom) = 0
             pairs_ncs(iat(1:ns,i)) = iat(1:ns,j)
             n_ncs_loc = 0
             ir = 0
             do is=1,ns
                ian = iat(is,i)
                if(pairs_ncs(ian).gt.0) then
                   jan = pairs_ncs(ian)
                   xx1(1:3) = xyz_crd(1:3,ian)
                   yy1(1:3) = xyz_crd(1:3,jan)
                   do in=1,nvdw_per_atom(ian)
                      ii = vdw_per_atom(in,ian)
                      if(pairs_ncs(ii).gt.0.and.ii.gt.ian) then
                         jj = pairs_ncs(ii)
                         xx2(1:3) = xyz_crd(1:3,ii)
                         yy2(1:3) = xyz_crd(1:3,jj)
                         dist1 = sqrt(sum((xx1-xx2)**2))
                         dist2 = sqrt(sum((yy1-yy2)**2))
                         if(dist1.gt.dist_cut_ncs.or.dist2.gt.dist_cut_ncs) cycle
                         if(abs(dist1-dist2).gt.diff_dist_cut) cycle
                         !if(abs(dist1-dist2).gt.sigmmax_ncs_cut*sigx1) cycle
                         sigx2 = sigx1
                         if(dist1+dist2.gt.8.0) sigx2 = sigx1*sqrt((dist1+dist2)/8.0)
                         ir = ir + 1
                         ias(1,ir) = ian
                         ias(2,ir) = ii
                         ias(3,ir) = jan
                         ias(4,ir) = jj
                         sigx_loc(ir) = sigx2
                         wtb(ir) = 1.0
                         if(ir.ge.500) then
                            write(ifile_simil)ir
                            write(ifile_simil)(ias(1:4,k),sigx_loc(k),wtb(k),k=1,ir)
                            ir = 0
                         endif
!                         write(ifile_simil)ian,ii,jan,jj,sigx2,1.0
                      endif
                   enddo
                endif
             enddo
             if(ir.gt.0) then
                write(ifile_simil)ir
                write(ifile_simil)(ias(1:4,k),sigx_loc(k),wtb(k),k=1,ir)
                ir = 0
             endif
          enddo
       enddo
       deallocate(iat)
       deallocate(sigx)
    enddo
    deallocate(n_grp_ncs)
    deallocate(ias)
    deallocate(sigx_loc)
    deallocate(wtb)
    close(ifile_ncs)
    close(ifile_simil)

    deallocate(nvdw_per_atom)
    deallocate(vdw_per_atom)
    deallocate(pairs_ncs)

    return
  end subroutine ncs_local_define
end module ncs_simil
