module coords
use atomcom


contains
  subroutine apply_transform_coord(matin)
    implicit none
    real, intent(in) ::  matin(4,4)
    !
    !  Transform input coordinates using the matrix matin
    integer i
    real xyz1(3),xyz2(3)
    real u33(3,3),u331(3,3)
    real ran(3,3)
    !
    !
    ran = matmul(matmul(cs_frac_to_ort,matin(1:3,1:3)),cs_ort_to_frac)
    
    if(n_atom.le.0) return
    
    do i=1,n_atom
       xyz1 = matmul(cs_ort_to_frac,xyz_crd(1:3,i))
       xyz2 = matmul(matin(1:3,1:3),xyz1) + matin(1:3,4)
       xyz_crd(1:3,i) = matmul(cs_frac_to_ort,xyz2)
       if(u_aniso(2,i).gt.0.0) then
          call aniso_vect2mat(u_aniso(1:6,i),u33)
          u331 = matmul(matmul(ran,u33),transpose(ran))
          call aniso_mat2vec(u331,u_aniso(1:6,i))
       endif
    enddo
    !
    !  How about TLS?
    
  end subroutine apply_transform_coord
end module coords
