module pdb2lib
  integer, private :: uin=61,uou=0

  logical, private :: ideal_use
  integer, private :: na,nx,nb

  !
  !   Compound properties
  character(len=64), private :: group_id
  character(len=64), private :: comp_id
  character(len=512), private :: comp_name
  character(len=3), private :: comp_3lett
  character(len=8), private, allocatable :: atom_name(:)
  character(len=2), private, allocatable :: atom_symb(:)
  real, private, allocatable :: atom_charge(:)
  real, private, allocatable :: xyz_model(:,:)
  real, private, allocatable :: xyz_crd(:,:)
  integer, private, allocatable :: bond_list(:,:)
  character(len=10), private, allocatable :: bond_order(:)
  logical, private, allocatable :: ideal_coor_flag(:)
  logical, private, allocatable :: atom_delete_flag(:)

  !
  !  bonding "graph"
  integer, private, allocatable :: nbond_per_atom(:)
  integer, private, allocatable :: bond_per_atom(:,:)
  integer, private, allocatable :: bond_ref_per_atom(:,:)

  !
  !  Add interfaces. Some of the subroutines are local and should not be used by other programs.
  
contains
  subroutine pdb2lib_sub( fin, fou, coor,flag, ierr )
    implicit   none
    
    character(len=*), intent(in) ::  fin
    character(len=*), intent(in) ::  fou
    !
    character(len=1), intent(out) :: flag
    character(len=1), intent(inout) :: coor
    integer, intent(out) :: ierr

    integer i,ib,ib1,nmaxbond
    integer  ios
    logical  ok
    logical rdflag
    ! --------------------------------------------------------------------
    
    ierr = 0
    coor = 'Y'
    flag = 'Y'
    open(unit=uin,file=fin,status='old',iostat=ios)
    if(ios.ne.0) then
       write(*,*)'Error==> Input dictionary file ',trim(fin),' could not be opened'
       ierr = 1
       return
    endif
    call pdb2lib_chck(ok )
    if(.not.ok) then
       close(uin)
       flag = 'Y'
       return
    endif
    flag = 'N'
    rewind(uin)
    call pdb2lib_group()

    if(comp_id.eq.'.') then
       ierr = 1
       write(*,*)'Error==> There is no comp_id in the dictionary'
       close(uin)
       return
    endif
    rdflag = .FALSE.
    rewind(uin)
    !
    !   Find the number of atoms and bonds
    call pdb2lib_readent(coor,ok,rdflag)
    if(.not.ok.or.na.le.0) then
       write(*,*)'Error==> Problem in reading input file ',trim(fin)
       close(uin)
       ierr = 1
       return
    endif


    allocate(atom_name(na))
    allocate(atom_symb(na))
    allocate(atom_charge(na))
    atom_charge(1:na) = 0.0
    allocate(xyz_crd(3,na))
    xyz_crd(1:3,1:na) = -10000.0
    allocate(xyz_model(3,na))
    xyz_model(1:3,1:na) = -10000.0
    allocate(ideal_coor_flag(na))
    ideal_coor_flag(1:na) = .TRUE.
    allocate(atom_delete_flag(na))
    atom_delete_flag(1:na) = .FALSE.
    allocate(bond_list(2,max(1,nb)))
    allocate(bond_order(max(1,nb)))
    !
    rdflag = .TRUE.
    rewind(uin)
    call pdb2lib_readent(coor,ok,rdflag)
 
    if(ok) then
       !       
       !  Do a little bit reorganisation (bonding graph)
       call strip_quotes_from_all()
       allocate(nbond_per_atom(na))
       nbond_per_atom(1:na) = 0
       do i=1,nb
          nbond_per_atom(bond_list(1,i)) = nbond_per_atom(bond_list(1,i))+1
          nbond_per_atom(bond_list(2,i)) = nbond_per_atom(bond_list(2,i))+1
       enddo
       nmaxbond = maxval(nbond_per_atom(1:na))
       allocate(bond_per_atom(nmaxbond,na))
       allocate(bond_ref_per_atom(nmaxbond,na))
       nbond_per_atom(1:na) = 0
       do i=1,nb
          nbond_per_atom(bond_list(1,i)) = nbond_per_atom(bond_list(1,i))+1
          ib1 =  nbond_per_atom(bond_list(1,i))
          bond_per_atom(ib1,bond_list(1,i)) = bond_list(2,i)
          bond_ref_per_atom(ib1,bond_list(1,i)) = i
          nbond_per_atom(bond_list(2,i)) = nbond_per_atom(bond_list(2,i))+1
          ib1 =  nbond_per_atom(bond_list(2,i))
          bond_per_atom(ib1,bond_list(2,i)) = bond_list(1,i)
          bond_ref_per_atom(ib1,bond_list(2,i)) = i
       enddo
       call treat_groups()
       call assign_missing_flags(coor)
       call treat_carboxyl_phosphates_etc()
       uou = 62
       open(unit=uou,file=fou,status='unknown',iostat=ios)
       call add_quotes_to_all()
       call pdb2lib_writeent(ierr)
       close(uou)
       deallocate(nbond_per_atom)
       deallocate(bond_per_atom)
       deallocate(bond_ref_per_atom)
    else
       write(*,*)'Hmmm ? We should not be here. Sppoky'
       ierr = 1
       
    endif
    deallocate(atom_name)
    deallocate(atom_symb)
    deallocate(atom_charge)
    deallocate(ideal_coor_flag)
    deallocate(atom_delete_flag)
    deallocate(xyz_crd)
    deallocate(xyz_model)
    deallocate(bond_list)
    deallocate(bond_order)

    close(uin)
    !    stop
    return
  end subroutine pdb2lib_sub

  !
  subroutine pdb2lib_chck( ok )
    implicit   none
    
    integer  mt, nt
    parameter  ( mt = 1024 )
    character  c_t*(mt)

    integer  mw, nw
    parameter  ( mw = 64 )
    integer  t_w(mw)

    integer  ios
    logical  ok

    ! --------------------------------------------------------------------
    ok = .true.
    do while( ok )
       read(uin,'(a)',iostat=ios) c_t
       ok = ios .eq. 0
       if( .not.ok ) exit
       c_t = trim(adjustl(c_t))
       if(c_t(1:5).eq.'data_') then
          if(c_t(1:14) .eq. 'data_comp_list'.or.c_t(1:14) .eq. 'data_link_list'.or.c_t(1:13) .eq. 'data_mod_list') then
             ok = .FALSE.
          endif
          exit
       endif
    enddo
    return
  end subroutine pdb2lib_chck
  !
  subroutine pdb2lib_group()
    implicit none
    !
    !--find out if this monomer belongs to one of the predifined groups
    !--   L-peptide
    !--   D-peptide
    !--   DNA
    !--   RNA
    !--   RNA/DNA
    !--   L-pyranose
    !--   D-pyranose
    !
    !---  Extract three letter compound name and its long name for further use

    !
    integer  mt, nt
    parameter  ( mt = 1024 )
    character  c_t*(mt)
    
    integer i
    integer icount
    integer iw1,iw2,nt1
    integer  mw, nw
    parameter  ( mw = 64 )
    integer  t_w(mw)
    
    integer l,l1
    character chval*32
    integer ios
    logical ok
    logical found,found2,found3
!
!---  body
!---------------------
    ok = .TRUE.
    icount = 0
    comp_id = '.'
    group_id = '.'
    comp_3lett = '.'
    comp_name = '.'
    do while(icount.lt.4.and.ok) 
       read(uin,'(a)',iostat=ios) c_t
       ok = ios.eq.0
       if(.not.ok) cycle
       call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
       if(c_t(1:15).eq.'_chem_comp.type') then
          icount = icount + 1
          chval = c_t(17:24)
          if(chval(1:1).eq.'"'.or.chval(1:1).eq.'''') then            
             do i=1,7
                chval(i:i) = chval(i+1:i+1)
             enddo
             chval(8:8) = ' '
          endif
          call upc_bl(chval)
          if(chval(1:6).eq.'L-PEPT') then
             group_id = 'L-peptide'
          else if(chval(1:6).eq.'D-PEPT') then
             group_id = 'D-peptide'
          else if(chval(1:3).eq.'DNA') then
             group_id = 'DNA'
          else if(chval(1:3).eq.'RNA') then
             group_id = 'RNA'
          else if(chval(1:4).eq.'SACC') then
             group_id = 'pyranose'
          else if(chval(1:4).eq.'D-SA') then
             group_id = 'D-pyranose'
          else if(chval(1:4).eq.'L-SA') then
             group_id = 'L-pyranose'
          else
             group_id = '.'
          endif
       endif
       if(c_t(1:15).eq.'_chem_comp.name') then
          icount = icount + 1
          iw1 = t_w(2)+1
          iw2 = t_w(3)-1
          
          comp_name = trim(adjustl(c_t(iw1:iw2)))
          l = len_trim(comp_id)
          l1 = len(comp_id)
          if(comp_id(1:1).eq.'"') then
             if(comp_id(l:l).ne.'"') then
                if(l.ge.l1) then
                   comp_id(l1:l1) = '"'
                else
                   comp_id(l+1:l+1) = '"'
                endif
             endif
          endif
          if(comp_id(1:1).eq.'''') then
             if(comp_id(l:l).ne.'''') then
                if(l.ge.l1) then
                   comp_id(l1:l1) = ''''
                else
                   comp_id(l+1:l+1) = ''''
                endif
             endif
          endif
          
       endif
       iw1 = t_w(1)+1
       iw2 = t_w(2)-1
       if(c_t(iw1:iw2).eq.'_chem_comp.three_letter_code') then
          icount = icount+1
          iw1 = t_w(2)+1
          comp_3lett = c_t(iw1:iw1+2)
       endif
       if(c_t(iw1:iw2).eq.'_chem_comp.id') then
          icount = icount+1
          iw1 = t_w(2)+1
          iw2 = t_w(3)-1
          comp_id = c_t(iw1:iw2)
       endif
          
    enddo
    if(comp_id.eq.' ') comp_id = '.'
    if(comp_3lett.eq.' ') comp_3lett = '.'
    if(group_id.eq.' ') group_id = 'non-polymer'
    if(comp_id.eq.'.'.and.comp_3lett.ne.'.') comp_id=comp_3lett
    return
  end subroutine pdb2lib_group
  
  ! ====================================================================
  subroutine pdb2lib_readent(coor,ok,rdflag)
    implicit   none

    logical, intent(in) :: rdflag
    character(len=1), intent(inout) :: coor
    logical, intent(out) :: ok

    integer  mt, nt, it, jt
    parameter  ( mt = 1024 )
    character  c_t*(mt)
    character  c_c*(mt)
    
    integer  ms, is, js
    parameter  ( ms = 120 )
    character  b_s*(ms)
    character  b_so(100)*120

    
    character  c8*8
    
    character ag*16
    character ideal_flag*1,model_flag*1
    integer   ideal_x
    integer   found_it

    integer  iv,im,j,k
    integer  w_v(10)
    integer  w_w(3)

    integer  mw, nw, iw, jw
    parameter  ( mw = 64 )
    integer  t_w(mw)

    integer i
    character(len=8)  atref_l1,atref_l2
    character(len=8) atom_temp
    character(len=2)  symb_temp
    integer atref_number
    real charge_temp
    real xyz_crd_temp(3),xyz_model_temp(3)
    character(len=10) bondord_v
    integer  ios
    integer  n_p,n_d
    logical  same
    logical  ideal_missing,model_missing
    !
    ! --------------------------------------------------------------------
    if(uin.le.0) return
    na = 0
    nb = 0
    ok = .FALSE.
    c8 = ' '
    read(uin,'(a)',iostat=ios) c_t
    do while(ios.eq.0)
       if(c_t(1:5) .eq. 'data_') then
          ok = .TRUE.
          c8 = c_t(6:13)
          exit
       endif
       read(uin,'(a)',iostat=ios) c_t
    enddo
    if(len_trim(c8).le.0) ok = .FALSE.
    if(.not.ok) return
    !
    ! Now we have data_ and compound name - c8. Read them
    ideal_flag = 'Y'
    model_flag = 'Y'
    found_it = 0

    do while( found_it.lt.2 .and.ios.eq.0)
       call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
       if(trim(adjustl(c_t(t_w(1)+1:t_w(2)))).eq.'_chem_comp.pdbx_ideal_coordinates_missing_flag') then
          ideal_flag = trim(adjustl(c_t(t_w(2):t_w(3))))
          found_it = found_it + 1
       endif
       if(trim(adjustl(c_t(t_w(1)+1:t_w(2)))).eq.'_chem_comp.pdbx_model_coordinates_missing_flag') then
          model_flag = trim(adjustl(c_t(t_w(2):t_w(3))))
          found_it = found_it + 1
       endif
       read(uin,'(a)',iostat=ios) c_t
    enddo

    if(model_flag.eq.'Y'.and.ideal_flag.eq.'Y') then
       write(*,*)
       write(*,*)'WARNING: Neither ideal nor model coordinates are available'
       write(*,*)'Warning: Ideal values will be generated using ener_lib.cif'
       write(*,*)
       coor = 'N'
    elseif(ideal_flag.eq.'Y') then
       write(*,*)
       write(*,*)'WARNING: Ideal coordinates are missing'
       write(*,*)'Warning: Ideal values will be generated using ener_lib.cif'
       write(*,*)
       coor = 'N'
    endif
    rewind(uin)

    ok = .TRUE.
    c_t = ' '
    do while(c_t(1:13) .ne. '_chem_comp.id' )
       read(uin,'(a)',iostat=ios) c_t
       c_t = adjustl(c_t)
       if(ios.ne.0) then
          ok = .FALSE.
          exit
       endif
    enddo
    if(.not.ok) return
    
    call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
    ok = nw .eq. 3
    ok = ok.and.trim(c_t(t_w(2)+1:t_w(3)-1)).eq.trim(c8)
    if(.not.ok) return
    do while( ok .and. c_t(1:16) .ne. '_chem_comp_atom.' )
       read(uin,'(a)',iostat=ios) c_t
       ok = ios .eq. 0
    enddo
    if(.not.ok) return

    jw = 0
    w_v(1:10) = 0
    !
    !---  If there is no loop then read the value from these lines
    do while( ok .and. c_t(1:16) .eq. '_chem_comp_atom.' )
       call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
       c_c = trim(adjustl(c_t(t_w(1)+1:t_w(2))))
       if(nw.gt.2) then
          na = 1
       endif
       if(nw.gt.2) then
          it = t_w(2)
          jt = t_w(3)
       endif
       jw = jw + 1
       if( c_c .eq. '_chem_comp_atom.comp_id' )then
          w_v(1) = jw
          if(nw.gt.2.and.rdflag) then
             comp_id = trim(c_t(t_w(2)+1:t_w(3)))
          endif
       else if( c_c .eq. '_chem_comp_atom.atom_id' )then
          w_v(2) = jw
          if(nw.gt.2.and.rdflag) then
             atom_name(1) = trim(c_t(t_w(2)+1:t_w(3)))
          endif
       else if( c_c .eq. '_chem_comp_atom.type_symbol' )then
          w_v(3) = jw
          if(nw.gt.2.and.rdflag) then
             atom_symb(1) = trim(c_t(t_w(2)+1:t_w(3)))
          endif
       else if( c_c .eq. '_chem_comp_atom.charge' )then
          w_v(4) = jw
          if(nw.gt.2.and.rdflag) then

             atom_charge(1) = getval_ch(c_t(t_w(2)+1:t_w(3)))
          endif
          !
          !---  Take ideal coordinates not these. If not found then report error. It will make testing
          !---  the dictionary easier.
       else if( c_c .eq. '_chem_comp_atom.model_Cartn_x' )then
          w_v(5) = jw
          if(nw.gt.2.and.rdflag) then
             xyz_model(1,1) = getval_ch(c_t(it+1:jt))
          endif
       else if( c_c .eq. '_chem_comp_atom.model_Cartn_y' )then
          w_v(6) = jw
          if(nw.gt.2.and.rdflag) then
             xyz_model(2,1) = getval_ch(c_t(it+1:jt))
          endif
       else if( c_c .eq. '_chem_comp_atom.model_Cartn_z' )then
          w_v(7) = jw
          if(nw.gt.2.and.rdflag) then
             xyz_model(3,1) = getval_ch(c_t(it+1:jt))
          endif
          
       else if(c_c.eq.'_chem_comp_atom.pdbx_model_Cartn_x_ideal') then
          w_v(8) = jw
          if(nw.gt.2.and.rdflag) then
             xyz_crd(1,1) = getval_ch(c_t(it+1:jt))
          endif
       else if(c_c.eq.'_chem_comp_atom.pdbx_model_Cartn_y_ideal') then
          w_v(9) = jw
          if(nw.gt.2.and.rdflag) then
             xyz_crd(2,1) = getval_ch(c_t(it+1:jt))
          endif
       else if(c_c.eq.'_chem_comp_atom.pdbx_model_Cartn_z_ideal') then
          w_v(10) = jw
          if(nw.gt.2.and.rdflag) then
             xyz_crd(3,1) = getval_ch(c_t(it+1:jt))
          endif
       endif
       
       read(uin,'(a)',iostat=ios) c_t
       ok = ios .eq. 0
    enddo
    !
    !???

    iv = 0
    ok = any(w_v(1:3).ne.0)
    if(.not.ok) return
    !
    !--This test may fail
    ideal_missing = .FALSE.
    model_missing = .FALSE.
    do while( ios.eq.0 )
       call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )     
       iw = w_v(1)
       if(c_t(t_w(iw)+1:t_w(iw+1)-1) .ne. c8) exit
       na = na + 1
       js = 0
       if(rdflag) then
          do iv = 1,10
             iw = w_v(iv)
             it = t_w(iw)
             jt = t_w(iw+1)
             b_so(iv) = c_t(it+1:jt)
             if(iv.eq.1) then
                comp_id = c_t(it+1:jt)
             elseif(iv.eq.2) then
                atom_name(na) =c_t(it+1:jt)
             elseif(iv.eq.3) then
                atom_symb(na) = c_t(it+1:jt)
             elseif(iv.eq.4.and.iw.gt.0) then
                atom_charge(na) = getval_ch(c_t(it+1:jt))
             elseif(iv.eq.5.and.iw.gt.0) then
                xyz_model(1,na) = getval_ch(c_t(it+1:jt))
             elseif(iv.eq.6.and.iw.gt.0) then
                xyz_model(2,na) = getval_ch(c_t(it+1:jt))
             elseif(iv.eq.7.and.iw.gt.0) then
                xyz_model(3,na) = getval_ch(c_t(it+1:jt))
             elseif(iv.eq.8.and.iw.gt.0) then
                xyz_crd(1,na) = getval_ch(c_t(it+1:jt))
             elseif(iv.eq.9.and.iw.gt.0) then
                xyz_crd(2,na) = getval_ch(c_t(it+1:jt))
             elseif(iv.eq.10.and.iw.gt.0) then
                xyz_crd(3,na) = getval_ch(c_t(it+1:jt))
             endif
          enddo
       endif
       read(uin,'(a)',iostat=ios) c_t
    enddo
    !
    !  For RNA/DNA OP3 must be first atom. It is bizarre but true. It will need to be fixed properly. Meanwhile just fix it.

    if(rdflag) then
       if(group_id.eq.'DNA'.or.group_id.eq.'RNA') then
          if(atom_name(1).ne.'OP3') then
             do i=1,na
                if(atom_name(i).eq.'OP3') then
                   atom_temp = atom_name(1)
                   symb_temp = atom_symb(1)
                   charge_temp = atom_charge(1)
                   xyz_crd_temp(1:3) = xyz_crd(1:3,1)
                   xyz_model_temp(1:3) = xyz_model(1:3,1)
                   
                   atom_name(1) = atom_name(i)
                   atom_symb(1) = atom_symb(i)
                   atom_charge(1) = atom_charge(i)
                   xyz_crd(1:3,1) = xyz_crd(1:3,i)
                   xyz_model(1:3,1) = xyz_model(1:3,i)
                   atom_name(i) = atom_temp
                   atom_symb(i) = symb_temp
                   atom_charge(i) = charge_temp
                   xyz_crd(1:3,i) = xyz_crd_temp(1:3)
                   xyz_model(1:3,i) = xyz_model_temp(1:3)
                   exit
                endif
             enddo
          endif
       endif
    endif


    if(.not.ideal_missing) ideal_use = .TRUE.
    ok = na .gt. 0 
    
    do while( ok .and. c_t(1:16) .ne. '_chem_comp_bond.' )
       read(uin,'(a)',iostat=ios) c_t
       ok = ios .eq. 0
    enddo
    jw = 0
    do iv = 1,4
       w_v(iv) = 0
    enddo
    !
    !---  If there is no loop then read values from these loops.
    do while( ok .and. c_t(1:16) .eq. '_chem_comp_bond.' )
       call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
       if(nw.gt.2) then
          nb = 1
       endif
       c_c = trim(adjustl(c_t(t_w(1)+1:t_w(2))))
       
       jw = jw + 1
       if( c_c .eq. '_chem_comp_bond.comp_id' )then
          w_v(1) = jw
          if(nw.gt.2.and.rdflag) then
             comp_id = c_t(t_w(2)+1:t_w(3))
          endif
       else if( c_c .eq. '_chem_comp_bond.atom_id_1' )then
          if(nw.gt.2.and.rdflag) then
             atref_l1 = c_t(t_w(2)+1:t_w(3))
             call atname_2_atnumber(atref_l1,atref_number)
             bond_list(1,1) = atref_number
          endif
          w_v(2) = jw
       else if( c_c .eq. '_chem_comp_bond.atom_id_2' )then
          if(nw.gt.2.and.rdflag) then
             atref_l2 = c_t(t_w(2)+1:t_w(3))
             call atname_2_atnumber(atref_l2,atref_number)
             bond_list(2,1) = atref_number
          endif
          w_v(3) = jw
       else if( c_c .eq. '_chem_comp_bond.value_order' )then
          if(nw.gt.2.and.rdflag) then
             bondord_v = adjustl(c_t(t_w(2)+1:t_w(3)))
             if(trim(bondord_v) .eq. 'SING' )then
                bondord_v = 'single'
             else if(trim(bondord_v) .eq. 'DOUB' )then
                bondord_v = 'double'
             else if(trim(bondord_v) .eq. 'TRIP' )then
                bondord_v = 'triple'
             else if(trim(bondord_v) .eq. 'AROM' )then
                bondord_v = 'aromatic'
             else if(trim(bondord_v) .eq. 'DELO' )then
                bondord_v= 'delocal'
             endif
             bond_order(nb) = bondord_v
          endif
          w_v(4) = jw
       endif
       read(uin,'(a)',iostat=ios) c_t
       ok = ios .eq. 0
    enddo
    iv = 0
    ok = .TRUE.
    do while( ok .and. iv .lt. 4 )
       iv = iv + 1
       ok = w_v(iv) .ne. 0
    enddo
    !
    same = .true.
    call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )

    do while( ok .and. nw .eq. jw + 1 )
       call pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
       iw = w_v(1)
       if( c_t(t_w(iw)+1:t_w(iw+1)-1) .ne. c8) exit
       nb = nb + 1
       if(rdflag) then
          do iv = 1,4
             iw = w_v(iv)
             it = t_w(iw)
             jt = t_w(iw+1)
             if(iv.eq.2) then
                atref_l1 = c_t(it+1:jt)
                call atname_2_atnumber(atref_l1,atref_number)
                bond_list(1,nb) = atref_number
             elseif(iv.eq.3) then
                atref_l2 = c_t(it+1:jt)
                call atname_2_atnumber(atref_l2,atref_number)
                bond_list(2,nb) = atref_number
             elseif(iv.eq.4) then
                bond_order(nb) = adjustl(c_t(it+1:jt))
             endif
          enddo
          if( bond_order(nb)(1:4) .eq. 'SING' )then
             bond_order(nb) = 'single'
          else if( bond_order(nb)(1:4) .eq. 'DOUB' )then
             bond_order(nb) = 'double'
          else if( bond_order(nb)(1:4) .eq. 'TRIP' )then
             bond_order(nb) = 'triple'
          else if( bond_order(nb)(1:4) .eq. 'AROM' )then
             bond_order(nb) = 'aromatic'
          else if( bond_order(nb)(1:4) .eq. 'DELO' )then
             bond_order(nb) = 'delocal'
          endif
       endif
       read(uin,'(a)',iostat=ios) c_t
       ok = ios .eq. 0
    enddo
    ok = same

    return
  end subroutine pdb2lib_readent
  !
  subroutine atname_2_atnumber(atin,numout)
    implicit none

    character(len=8), intent(in) :: atin
    integer, intent(out) :: numout
    integer i
    !
    numout = 0
    do i=1,na
       if(trim(adjustl(atin)).eq.trim(adjustl(atom_name(i)))) then
          numout = i
          exit
       endif
    enddo
       
    return
       
  end subroutine atname_2_atnumber
  !
  subroutine assign_missing_flags(coor)
    implicit none
    
    character(len=1), intent(inout) :: coor

    integer i,nmissing

    nmissing = 0
    do i=1,na
       if(any((xyz_crd(1:3,i).le.-1000.0))) then
          nmissing = nmissing + 1
       endif
    enddo

    if(nmissing.eq.na) then
       coor = 'N'
       xyz_crd(1:3,1:na) = xyz_model(1:3,1:na)
    endif

    nmissing = 0
    do i=1,na
       if(any(xyz_crd(1:3,i).le.-1000.0)) then
          nmissing = nmissing + 1
          ideal_coor_flag(i) = .FALSE.
       endif
    enddo
    if(nmissing.gt.0) xyz_crd(1:3,1:na) = -1000.0

    return
  end subroutine assign_missing_flags
  !
  subroutine treat_groups()
    implicit none

    !
    !   Locals
    integer ic,ic5,ic6
    integer i,i1,i2,i3,ib,ib1,ib2,ibr
    integer ica,icd,icn,ih,io
    logical found(8)
    logical group_flag
    logical ring5,ring6
    !
    !   Body
    if(group_id(1:5).eq.'L-pep'.or.group_id(1:5).eq.'D-pep') then
       call treat_peptides()
    elseif(group_id(1:3).eq.'RNA'.or.group_id(1:3).eq.'DNA') then
       call treat_dnarna()
    elseif(group_id(1:5).eq.'L-pyr'.or.group_id(1:5).eq.'D-pyr'.or.group_id(1:5).eq.'pyran') then
       call treat_saccharides()
    else
       group_id = 'non-polymer'
    endif
    write(*,*)
    write(*,*)'Monomer belongs to the group : ',trim(group_id)
    write(*,*)
    return

  end subroutine treat_groups
  !
  subroutine treat_peptides()
    implicit none

    integer ic,ica,io,ih,icd,icn
    integer i,ib,i1,ibr
    !
    logical group_flag
    logical found(7)
    !
    !   body
    !
    !  Basic check if can belong to peptide group. Basically, idea is, we should have something like N-CA-C(O)OXT with 
    !  C-O or C-OXT bonds being double or deloc
    !
    io = 0
    ic = 0
    ih = 0
    icd = 0
    icn = 0
    found(1:7) = .FALSE.
    group_flag = .TRUE.
    Ploop: do i=1,na
       if(atom_name(i).eq.'CA') then
          ic = 0
          if(nbond_per_atom(i).lt.2.or.nbond_per_atom(i).gt.4) then
             group_flag = .FALSE.
             exit Ploop
          endif
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_per_atom(ibr,i)
             if(atom_name(i1).eq.'N'.and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             elseif(atom_name(i1).eq.'C'.and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) then
             found(1) = .TRUE.
          else
             group_flag = .FALSE.
             exit Ploop
          endif
       elseif(atom_name(i).eq.'C') then
          if(nbond_per_atom(i).gt.3.or.nbond_per_atom(i).lt.2) then
             group_flag = .FALSE.
             exit Ploop
          endif
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if(atom_name(i1).eq.'CA'.and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             elseif(atom_name(i1).eq.'O') then
                ic = ic + 1
             elseif(atom_name(i1).eq.'OXT') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.3) found(2) = .TRUE.   
       elseif(trim(atom_name(i)).eq.'OXT') then
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             if(trim(atom_name(i1)).ne.'C'.and.trim(atom_symb(i)).ne.'H') then
                group_flag = .FALSE.
                exit Ploop
             endif
          enddo
       elseif(atom_name(i).eq.'N') then
          ica = 0
          ih = 0
          icd = 0
          icn = 0
          io = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if(atom_name(i1).eq.'CA'.and.bond_order(ibr)(1:5).eq.'singl') then
                ica = ica + 1
             elseif(atom_symb(i1).eq.'H') then
                ih = ih + 1
             elseif(atom_name(i1).eq.'CD'.and.bond_order(ibr)(1:5).eq.'singl') then
                icd = icd + 1
             elseif(atom_name(i1).eq.'CN'.and.bond_order(ibr)(1:5).eq.'singl') then
                icn = icn + 1
             else
                io = io + 1
             endif
          enddo
          if(io.gt.0.or.ica.ne.1) then
             group_flag = .FALSE.
             exit Ploop
          elseif(icd.le.1.and.icn.le.1.and.ica.eq.1) then
             found(3) = .TRUE.
          endif
       endif
    enddo Ploop
    if(any(.not.(found(1:3)))) group_flag = .FALSE.
    if(group_flag) then
       if(io.eq.0.and.icd.eq.0.and.icn.eq.0) then
          group_id = 'peptide'
       elseif(icd.eq.1) then
          do i=1,na
             if(atom_name(i).eq.'CD') then
                ic = 0
                do ib=1,nbond_per_atom(i)
                   i1 = bond_per_atom(ib,i)
                   ibr = bond_ref_per_atom(ib,i)
                   if(atom_name(i1).eq.'N'.and.bond_order(ibr)(1:5).eq.'singl') then
                      ic = ic + 1
                   elseif(atom_name(i1).eq.'CG'.and.bond_order(ibr)(1:5).eq.'singl') then
                      ic = ic + 1
                   endif
                enddo
                if(ic.eq.2) found(4) = .TRUE.
             elseif(atom_name(i).eq.'CG') then
                ic = 0
                do ib=1,nbond_per_atom(i)
                   i1 = bond_per_atom(ib,i)
                   ibr = bond_ref_per_atom(ib,i)
                   if(atom_name(i1).eq.'CD'.and.bond_order(ibr)(1:5).eq.'singl') then
                      ic = ic + 1
                   elseif(atom_name(i1).eq.'CB'.and.bond_order(ibr)(1:5).eq.'singl') then
                      ic = ic + 1
                   endif
                enddo
                if(ic.eq.2) found(5) = .TRUE.
             elseif(atom_name(i).eq.'CB') then
                ic = 0
                do ib=1,nbond_per_atom(i)
                   i1 = bond_per_atom(ib,i)
                   ibr = bond_ref_per_atom(ib,i)
                   if(atom_name(i1).eq.'CG'.and.bond_order(ibr)(1:5).eq.'singl') then
                      ic = ic + 1
                   elseif(atom_name(i1).eq.'CA'.and.bond_order(ibr)(1:5).eq.'singl') then
                      ic = ic + 1
                   endif
                enddo
                if(ic.eq.2) found(6) = .TRUE.
             endif
          enddo
          if(all(found(1:6))) then
             group_id = 'P-peptide'
          else
             group_id = 'non-polymer'
          endif
       elseif(icn.eq.1) then
          group_id = 'M-peptide'
       endif
    else
       group_id = 'non-polymer'
    endif

  end subroutine treat_peptides
  !
  subroutine treat_dnarna()
    implicit none
    
    integer i,i1,i2,ib,ib1
    logical group_flag
    logical found(8)
    !
    !  body
    group_flag = .TRUE.
    found(1:8) = .FALSE.
    Dloop: do i=1,na
       if(atom_name(i).eq.'P'.and.atom_symb(i).eq.'P') then
          found(1) = .TRUE.
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             if(atom_name(i1).eq.'O5''') then
                found(2) = .TRUE.
                if(nbond_per_atom(i1).eq.1) then
                   group_flag = .FALSE.
                   exit Dloop
                else
                   do ib1 = 1,nbond_per_atom(i1)
                      i2 = bond_per_atom(ib1,i1)
                      if(atom_name(i2).eq.'C5''') then
                         found(3) = .TRUE.
                      endif
                   enddo
                endif
             elseif(atom_name(i1).eq.'OP1'.or.atom_name(i1).eq.'OP2'.or.atom_name(i1).eq.'OP3') then
                if(nbond_per_atom(i1).eq.2) then
                   do ib1=1,nbond_per_atom(i1)
                      i2 = bond_per_atom(ib1,i1)
                      if(atom_name(i2).ne.'P'.and.atom_symb(i2).ne.'H') then
                         group_flag = .FALSE.
                         exit Dloop
                      endif
                   enddo
                endif
             endif
             if(atom_name(i1).eq.'OP1') then
                found(4) = .TRUE.
             elseif(atom_name(i1).eq.'OP2') then
                found(5) = .TRUE.
             elseif(atom_name(i1).eq.'OP3') then
                found(6) = .TRUE.
             endif
          enddo
       elseif(atom_name(i).eq.'C3''') then
          found(7) = .TRUE.
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             if(atom_name(i1).ne.'O3'''.and.atom_name(i1).ne.'C4'''.and.atom_name(i1).ne.'C2'''.and.atom_symb(i1).ne.'H') then
                group_flag = .FALSE.
                exit Dloop
             endif
          enddo
       elseif(atom_name(i).eq.'O3''') then
          found(8) = .TRUE.
       endif
    enddo Dloop
    if(any(.not.found(1:8))) group_flag = .FALSE.
    if(.not.group_flag) group_id = 'non-polymer'
    write(*,*)found(1:8)
  end subroutine treat_dnarna
  !
  subroutine treat_saccharides()
    implicit none
    !
    !   Find out if this ligand is one of the saccharides
    
    integer i,ib,ibr,i1
    integer ic
    logical ring5,ring6
    logical group_flag
    logical found(7)
    !
    !   body
    found(1:7) = .FALSE.
    group_flag = .TRUE.
    ring5 = .FALSE.
    ring6 = .FALSE.
    !
    !   Find out five or six member rings
    Sloop: do i=1,na
       if(atom_name(i).eq.'C1') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if((atom_name(i1).eq.'C2'.or.atom_name(i1).eq.'O5').and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(1) = .TRUE.
       elseif(atom_name(i).eq.'C2') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if((atom_name(i1).eq.'C1'.or.atom_name(i1).eq.'C3').and.bond_order(ibr)(1:5).eq.'singl' ) then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(2) = .TRUE.
       elseif(atom_name(i).eq.'C3') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if((atom_name(i1).eq.'C2'.or.atom_name(i1).eq.'C4').and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(3) = .TRUE.
       elseif(atom_name(i).eq.'C4') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if(atom_name(i1).eq.'C3'.and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             elseif(atom_name(i1).eq.'C5'.and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) then
             found(4) = .TRUE.
          endif
       elseif(atom_name(i).eq.'C5') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if((atom_name(i1).eq.'C4'.or.atom_name(i1).eq.'O5').and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(5) = .TRUE.
       elseif(atom_name(i).eq.'O5') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if((atom_name(i1).eq.'C5'.or.atom_name(i1).eq.'C1').and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(6) = .TRUE.
       endif
    enddo Sloop
    if(all(found(1:6))) ring6 = .TRUE.
    
    ! Is it furanose? Two types of atom naming: 1) with primes and 2) without primes
    found(1:6) = .FALSE.
    if(all(found(1:3)).and..not.ring6) then
       do i=1,na
          if(atom_name(i).eq.'C4') then
             ic = 0
             do ib=1,nbond_per_atom(i)
                i1 = bond_per_atom(ib,i)
                ibr = bond_ref_per_atom(ib,i)
                if(atom_name(i1).eq.'O4'.and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                elseif(atom_name(i1).eq.'C3'.and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                endif
             enddo
             if(ic.eq.2) found(4) = .TRUE.
          elseif(atom_name(i).eq.'O4') then
             do ib=1,nbond_per_atom(i)
                i1 = bond_per_atom(ib,i)
                ibr = bond_ref_per_atom(ib,i)
                if(atom_name(i1).eq.'C4'.and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                elseif(atom_name(i1).eq.'C1'.and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                endif
             enddo
             if(ic.eq.2) found(5) = .TRUE.
          endif
       enddo
       if(all(found(1:5))) ring5 = .TRUE.
    endif

    found(1:7) = .FALSE.
    Floop: do i=1,na
       if(atom_name(i).eq.'C1''') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if((atom_name(i1).eq.'C2'''.or.atom_name(i1).eq.'O4''').and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(1) = .TRUE.
       elseif(atom_name(i).eq.'C2''') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if((atom_name(i1).eq.'C1'''.or.atom_name(i1).eq.'C3''').and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(2) = .TRUE.
       elseif(atom_name(i).eq.'C3''') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if((atom_name(i1).eq.'C2'''.or.atom_name(i1).eq.'C4''').and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(3) = .TRUE.
       elseif(atom_name(i).eq.'C4''') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if(atom_name(i1).eq.'C3'''.and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             elseif(atom_name(i1).eq.'O4'''.and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(4) = .TRUE.
       elseif(atom_name(i).eq.'O4''') then
          ic = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)
             if((atom_name(i1).eq.'C4'''.or.atom_name(i1).eq.'C1''').and.bond_order(ibr)(1:5).eq.'singl') then
                ic = ic + 1
             endif
          enddo
          if(ic.eq.2) found(5) = .TRUE.
       endif
       if(all(found(1:5))) ring5 = .TRUE.
    enddo Floop
    group_id = 'non-polymer'
    if(ring5.and.ring6) then
       group_id = 'saccharide'
    elseif(ring5) then
       group_id = 'furanose'
    elseif(ring6) then
       group_id = 'pyranose'
    endif
    if(ring6.and..not.ring5) then
       !
       !  Does it have another six member ring: atom names should be C1', C2',C3',C4', C5' and O5'
       found(1:6) = .FALSE.
       Mloop: do i=1,na
          if(atom_name(i).eq.'C1''') then
             ic = 0
             do ib=1,nbond_per_atom(i)
                i1 = bond_per_atom(ib,i)
                ibr = bond_ref_per_atom(ib,i)
                if((atom_name(i1).eq.'C2'''.or.atom_name(i1).eq.'O5''').and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                endif
             enddo
             if(ic.eq.2) found(1) = .TRUE.
          elseif(atom_name(i).eq.'C2''') then
             ic = 0
             do ib=1,nbond_per_atom(i)
                i1 = bond_per_atom(ib,i)
                ibr = bond_ref_per_atom(ib,i)
                if((atom_name(i1).eq.'C1'''.or.atom_name(i1).eq.'C3''').and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                endif
             enddo
             if(ic.eq.2) found(2) = .TRUE.
          elseif(atom_name(i).eq.'C3''') then
             ic = 0
             do ib=1,nbond_per_atom(i)
                i1 = bond_per_atom(ib,i)
                ibr = bond_ref_per_atom(ib,i)
                if((atom_name(i1).eq.'C2'''.or.atom_name(i1).eq.'C4''').and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                endif
             enddo
             if(ic.eq.2) found(3) = .TRUE.
          elseif(atom_name(i).eq.'C4''') then
             ic = 0
             do ib=1,nbond_per_atom(i)
                i1 = bond_per_atom(ib,i)
                ibr = bond_ref_per_atom(ib,i)
                if(atom_name(i1).eq.'C3'''.and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                elseif(atom_name(i1).eq.'C5'''.and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                endif
             enddo
             if(ic.eq.2) found(4) = .TRUE.
          elseif(atom_name(i).eq.'C5''') then
             ic = 0
             do ib=1,nbond_per_atom(i)
                i1 = bond_per_atom(ib,i)
                ibr = bond_ref_per_atom(ib,i)
                if((atom_name(i1).eq.'C4'''.or.atom_name(i1).eq.'O5''').and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                endif
             enddo
             if(ic.eq.2) found(5) = .TRUE.
          elseif(atom_name(i).eq.'O5''') then
             ic = 0
             do ib=1,nbond_per_atom(i)
                i1 = bond_per_atom(ib,i)
                ibr = bond_ref_per_atom(ib,i)
                if((atom_name(i1).eq.'C5'''.or.atom_name(i1).eq.'C1''').and.bond_order(ibr)(1:5).eq.'singl') then
                   ic = ic + 1
                endif
             enddo
             if(ic.eq.2) found(6) = .TRUE.
          endif
       enddo Mloop
       !
       !   Disaccharide with two six member rings. (It should not be treated here
       if(all(found(1:6))) group_id = 'saccharide'
       
    else
       
    endif

  end subroutine treat_saccharides
  !
  subroutine treat_carboxyl_phosphates_etc()
    implicit none

    integer i,i1,i2,ib,ib1,ibr
    integer n_Csingle,n_Odouble,n_Odeloc,n_Osingle,n_Ohydr,n_noOhydr,n_Oatom
    integer n_l

    real delta(3)
    real dist_l,dist_ideal,ratio,charge_l
    real :: small_bond=0.1
    
    !  body
    do i=1,na
       if(atom_symb(i).eq.'C') then
          if(nbond_per_atom(i).ne.3) cycle
          n_Csingle = 0
          n_Odouble = 0
          n_Odeloc = 0
          n_Osingle = 0
          n_Ohydr = 0
          n_noOhydr = 0
          n_Oatom = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             ibr = bond_ref_per_atom(ib,i)

             if(atom_symb(i1).eq.'C') then
                if(bond_order(ibr)(1:5).eq.'singl') then
                   n_Csingle = n_Csingle + 1
                endif
             elseif(atom_symb(i1).eq.'O') then
                n_Oatom = n_Oatom + 1
                if(bond_order(ibr)(1:5).eq.'doubl') then
                   n_Odouble=n_Odouble+1
                elseif(bond_order(ibr)(1:5).eq.'deloc') then
                   n_Odeloc = n_Odeloc + 1
                elseif(bond_order(ibr)(1:5).eq.'singl') then
                   n_Osingle = n_Osingle+1
                   if(nbond_per_atom(i1).le.2) then
                      do ib1=1,nbond_per_atom(i1)
                         i2 = bond_per_atom(ib1,i1)
                         if(atom_symb(i2).eq.'H') then
                            n_Ohydr = n_Ohydr + 1
                         else
                            n_noOhydr = n_noOhydr + 1
                         endif
                      enddo
                   endif
                endif
             endif
          enddo
          if(n_Csingle.eq.1.and.n_Oatom.eq.2.and.                 &
               (n_Odouble.ge.1.or.n_Odeloc.ge.1).and.n_Osingle.le.1) then
             do ib=1,nbond_per_atom(i)
                i1 = bond_per_atom(ib,i)
                ibr = bond_ref_per_atom(ib,i)
                if(atom_symb(i1).eq.'O') then
                   atom_charge(i1) = -0.5
                   bond_order(ibr) = 'deloc'
                   delta = xyz_crd(1:3,i1)-xyz_crd(1:3,i)
                   dist_l = sqrt(sum(delta**2))
                   ratio = 1.251/max(dist_l,small_bond)
                   xyz_crd(1:3,i1) = xyz_crd(1:3,i) + delta*ratio
                   do ib1=1,nbond_per_atom(i1)
                      i2 = bond_per_atom(ib1,i1)
                      if(atom_symb(i2).eq.'H') then
                         atom_delete_flag(i2) = .TRUE.
                      endif
                   enddo
                endif
             enddo
          endif
       elseif(trim(atom_symb(i)).eq.'N'.and.trim(group_id).eq.'peptide') then
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             if(trim(atom_symb(i1)).eq.'H') then
                atom_delete_flag(i1) = .TRUE.
             endif
          enddo
       elseif(atom_symb(i).eq.'P') then
          if(nbond_per_atom(i).ne.4) cycle
          n_Oatom = 0
          n_noOhydr = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             if(atom_symb(i1).eq.'O') then
                n_Oatom = n_Oatom+1
                n_l = 0
                do ib1=1,nbond_per_atom(i1)
                   i2 = bond_per_atom(ib1,i1)
                   if(atom_symb(i2).ne.'H') then
                      n_l = n_l + 1
                   endif
                enddo
                if(n_l.eq.2) then
                   n_noOhydr = n_noOhydr + 1
                endif
             endif
          enddo
          if(n_Oatom.eq.4) then
             if(n_noOhydr.eq.0) then
                dist_ideal = 1.513
                charge_l = -0.75
             elseif(n_noOhydr.eq.1) then
                dist_ideal = 1.513
                charge_l = -0.666
             elseif(n_noOhydr.eq.2) then
                dist_ideal = 1.483
                charge_l = -0.5
             endif
             if(n_noOhydr.le.2) then
                do ib=1,nbond_per_atom(i)
                   i1 = bond_per_atom(ib,i)
                   ibr = bond_ref_per_atom(ib,i)
                   n_l = 0
                   do ib1 = 1,nbond_per_atom(i1)
                      i2 = bond_per_atom(ib1,i1)
                      if(atom_symb(i2).eq.'H') then
                         atom_delete_flag(i2) = .TRUE.
                      else
                         n_l = n_l + 1
                      endif
                   enddo
                   if(n_l.le.1) then
                      delta = xyz_crd(1:3,i1)-xyz_crd(1:3,i)
                      dist_l = sqrt(sum(delta**2))
                      ratio = dist_ideal/max(dist_l,small_bond)
                      bond_order(ibr) = 'deloc'
                      atom_charge(i1) = charge_l
                      xyz_crd(1:3,i1) = xyz_crd(1:3,i) +delta*ratio
                   endif
                enddo
             endif
          endif
       elseif(atom_symb(i).eq.'S') then   
          if(nbond_per_atom(i).eq.4) cycle
          n_Oatom = 0
          n_noOhydr = 0
          do ib=1,nbond_per_atom(i)
             i1 = bond_per_atom(ib,i)
             if(atom_symb(i1).eq.'O') then
                n_Oatom = n_Oatom+1
                n_l = 0
                do ib1=1,nbond_per_atom(i1)
                   i2 = bond_per_atom(ib1,i1)
                   if(atom_symb(i2).ne.'H') then
                      n_l = n_l + 1
                   endif
                enddo
                if(n_l.eq.2) then
                   n_noOhydr = n_noOhydr + 1
                endif
             endif
          enddo
          if(n_Oatom.eq.4) then
             if(n_noOhydr.eq.0) then
                dist_ideal = 1.472
                charge_l = -0.5
             elseif(n_noOhydr.eq.1) then
                dist_ideal = 1.48
                charge_l = -0.333
             endif
             if(n_noOhydr.le.1) then
                do ib=1,nbond_per_atom(i)
                   i1 = bond_per_atom(ib,i)
                   ibr = bond_ref_per_atom(ib,i)
                   n_l = 0
                   do ib1 = 1,nbond_per_atom(i1)
                      i2 = bond_per_atom(ib1,i1)
                      if(atom_symb(i2).eq.'H') then
                         atom_delete_flag(i2) = .TRUE.
                      else
                         n_l = n_l + 1
                      endif
                   enddo
                   if(n_l.le.1) then
                      delta = xyz_crd(1:3,i1)-xyz_crd(1:3,i)
                      dist_l = sqrt(sum(delta**2))
                      ratio = dist_ideal/max(dist_l,small_bond)
                      bond_order(ibr) = 'deloc'
                      xyz_crd(1:3,i1) = xyz_crd(1:3,i) +delta*ratio
                      atom_charge(i1) = charge_l
                   endif
                enddo
             endif
          endif
       endif
    enddo

  end subroutine treat_carboxyl_phosphates_etc
  !
  subroutine pdb2lib_writeent(ierr)
    implicit none

    integer, intent(out) :: ierr
    integer i

    character(len=8) :: aname1,aname2
    !
    !   body
    ierr = 0
    if(uou.le.0.or.na.le.0) then
       write(*,*)'How it could happen:',uou,na
       ierr = 1
       return
    endif
    nx = 0
    do i=1,na
       if(atom_symb(i).eq.'H') nx = nx + 1
    enddo

    write(uou,'(a)') '#'
    write(uou,'(a)') 'data_comp_list'
    write(uou,'(a)') 'loop_'
    write(uou,'(a)') '_chem_comp.id'
    write(uou,'(a)') '_chem_comp.three_letter_code'
    write(uou,'(a)') '_chem_comp.name'
    write(uou,'(a)') '_chem_comp.group'
    write(uou,'(a)') '_chem_comp.number_atoms_all'
    write(uou,'(a)') '_chem_comp.number_atoms_nh'
    write(uou,'(a)') '_chem_comp.desc_level'
    if(len_trim(comp_name).le.0) comp_name = '.'
    if(len_trim(group_id).le.0) group_id = '.'
    write(uou,'(a8,1x,a3,1x,a,1x,a,2i6,1x,a)')trim(comp_id), trim(comp_3lett),trim(comp_name),trim(group_id), na, nx, 'M'
    write(uou,'(a)') '#'
    write(uou,'(a)') 'data_comp_'//trim(adjustl(comp_id))


    write(uou,'(a)') '#'
    write(uou,'(a)') 'loop_'
    write(uou,'(a)') '_chem_comp_atom.comp_id'
    write(uou,'(a)') '_chem_comp_atom.atom_id'
    write(uou,'(a)') '_chem_comp_atom.type_symbol'
    write(uou,'(a)') '_chem_comp_atom.partial_charge'
    !    if(any(.not.ideal_coor_flag(1:na))) then
       write(uou,'(a)') '_chem_comp_atom.x'
       write(uou,'(a)') '_chem_comp_atom.y'
       write(uou,'(a)') '_chem_comp_atom.z'
       !    endif

!    if(all(ideal_coor_flag(1:na))) then
!       do i=1,na
!          write(*,*)atom_delete_flag(i)
!          if(.not.atom_delete_flag(i))then
!             write(uou,'(1x,a8,1x,a4,1x,a2,1x,f8.3,3(1x,f12.4))')                       &
!                  trim(comp_id),trim(atom_name(i)),trim(atom_symb(i)),atom_charge(i)
!          endif
!       enddo
!    else
       do i=1,na
          if(.not.atom_delete_flag(i)) then
             write(uou,'(1x,a8,1x,a8,1x,a2,1x,f8.3,3(1x,f12.4))')trim(comp_id),trim(atom_name(i)),trim(atom_symb(i)),    &
                  atom_charge(i),xyz_crd(1:3,i)
          endif
       enddo
!    endif
    
    if(nb.gt.0) then
       write(uou,'(a)') '#'
       write(uou,'(a)') 'loop_'
       write(uou,'(a)') '_chem_comp_bond.comp_id'
       write(uou,'(a)') '_chem_comp_bond.atom_id_1'
       write(uou,'(a)') '_chem_comp_bond.atom_id_2'
       write(uou,'(a)') '_chem_comp_bond.type'

       do i=1,nb
          if(.not.(atom_delete_flag(bond_list(1,i)).or.atom_delete_flag(bond_list(2,i)))) then
             aname1 = atom_name(bond_list(1,i))
             aname2 = atom_name(bond_list(2,i))
             write(uou,'(1x,a8,2(1x,a8),1x,a8)')trim(comp_id),trim(aname1),trim(aname2),trim(bond_order(i))
          endif
       enddo
    endif
    !
    !   Chiralities?

    !
    !  Smiles string also
    return
    
  end subroutine pdb2lib_writeent

  subroutine pdb2lib_rdlin( mt, nt, c_t, mw, nw, t_w )
    implicit   none
    
    integer mt1,nt1
    integer  mt, nt, it
    character  c_t*(*)
    
    integer  mw, nw, iw, jw
    integer  t_w(mw)
    
    logical  fi, fj
    logical quote_open1,quote_open2,string_open
    ! --------------------------------------------------------------------
    nt = 0
    fi = .false.

    do it = 1,mt
       fj = c_t(it:it) .ne. ' '
       if( fi .or. fj )then
          nt = nt + 1
          c_t(nt:nt) = c_t(it:it)
       endif
       fi = fj
    enddo
    if(nt.lt.mt) c_t(nt+1:mt) = ' '
    c_t = trim(adjustl(c_t))
    nt = len_trim(c_t)
    jw = 1
    t_w(1) = 0
    quote_open1 = .FALSE.
    quote_open2 = .FALSE.
    string_open = .FALSE.
    if(nt.gt.1) then
       quote_open1 = .FALSE.
       quote_open2 = .FALSE.
       do it = 1,nt
          if(c_t(it:it).eq.'''') then
             if(.not.quote_open1) then
                if(it.eq.1) then
                   quote_open1 = .TRUE.
                else if(c_t(it-1:it-1).eq.' '.and. .not.quote_open2) then
                   quote_open1 = .TRUE.
                endif
             else
                if(it.eq.nt) then
                   quote_open1 = .FALSE.
                else if(c_t(it+1:it+1).eq.' ') then
                   quote_open1 = .FALSE.
                endif
             endif
          endif

          if(c_t(it:it).eq.'"') then
             if(.not.quote_open2) then
                if(it.eq.1) then
                   quote_open2 = .TRUE.
                else if(c_t(it-1:it-1).eq.' '.and. .not.quote_open1) then
                   quote_open2 = .TRUE.
                endif
             else
                if(it.eq.nt) then
                   quote_open2 = .FALSE.
                else if(c_t(it+1:it+1).eq.' ') then
                   quote_open2 = .FALSE.
                endif
             endif
          endif

          if( c_t(it:it) .eq. ' '.and..not.(quote_open1.or.quote_open2))then
             jw = jw + 1
             if( jw .le. mw ) t_w(jw) = it
          endif
       enddo
    endif
    
    jw = jw + 1
    t_w(jw) = nt+1
    nw = jw
    return
  end subroutine pdb2lib_rdlin
  ! ====================================================================
  subroutine strip_quotes_from_all()
    implicit none
    !
    ! Strip quotes from atom names. 
    integer i,l
    !
    !   body
    do i=1,na
       l = len_trim(atom_name(i))
       if(atom_name(i)(1:1).eq.'"'.and.atom_name(i)(l:l).eq.'"') then
          atom_name(i)(1:1) = ' '
          atom_name(i)(l:l) = ' '
          atom_name(i) = trim(adjustl(atom_name(i)))
       elseif(atom_name(i)(1:1).eq.''''.and.atom_name(i)(l:l).eq.'''') then
          atom_name(i)(1:1) = ' '
          atom_name(i)(l:l) = ' '
          atom_name(i) = trim(adjustl(atom_name(i)))
       endif
    enddo
    return
  end subroutine strip_quotes_from_all
  !
  subroutine add_quotes_to_all()
    implicit none
    !
    !  Add quotes to atom names where it is necessary
    character(len=8) :: atom_loc
    integer i,j,l
    integer quote1,quote2,space1

    do i=1,na
       l = len_trim(atom_name(i))
       quote1 = 0
       quote2 = 0
       space1 = 0
       atom_loc = ' '
       do j=1,l
          if(atom_name(i)(j:j).eq.'''') then
             quote1 = quote1 + 1
          elseif(atom_name(i)(j:j).eq.'"') then
             quote2 = quote2 + 1
          elseif(atom_name(i)(j:j).eq.' '.or.atom_name(i)(j:j).eq.'#') then
             space1 = space1 + 1
          endif
       enddo
       if(quote1.gt.0.and.quote2.gt.0) then
          write(*,*)'Problem. Atom name contains double and single quotes'
          stop
       endif
       atom_loc = atom_name(i)
       if(quote1.gt.0) then
          atom_loc = '"'//trim(atom_name(i))//'"'
       elseif(quote2.gt.0) then
          atom_loc = ''''//trim(atom_name(i))//''''
       elseif(space1.gt.0) then
          atom_loc = '"'//trim(atom_name(i))//'"'
       endif
       atom_name(i) = atom_loc

    enddo
    return
  end subroutine add_quotes_to_all

  real function getval_ch(char_in)
    implicit none
    character(len=*), intent(in) :: char_in
    getval_ch = -1000.0
    if(char_in.ne.'?') then
       read(char_in,*)getval_ch
    endif

    return
  end function getval_ch



end module pdb2lib
