
C
C
      SUBROUTINE SOLVENT_MASK(DEN_in,dens_out)
C-----------------------------------------------------------------
C---------           SPACE GROUP GENERAL
C---This subroutine calculates electron density from atoms and fills
C---"asymmetric" unit of crystals. Displacement parameters are as U
C---values
C-------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
C
      REAL   DEN(N1,N2,N3)
C
C---Local variables
      REAL    XA_LIST(3,500)
      INTEGER INDSYM_LIST(500)
      REAL    XYZ(3)
      LOGICAL ERROR


C-----D1 is going to be occupancy dependent

      D1 = -1.0E32
      DO   IA=1,N_ATOM
         CALL GET_RADIUS_FOR_THIS_ATOM(IA,RD1)
         D1 = AMAX1(D1,RD1)
      ENDDO

C----Find extension limits for asymmetric unit
      D_SOLV_LIM = D1**2
      CALL ASYMLIM_FRAC(D_SOLV_LIM,XLOW,YLOW,ZLOW,XUPPER,YUPPER,ZUPPER)
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      DLIMIT = DDLIM
      CSA2        = 2.0*COSA
      CSB2        = 2.0*COSB
      CSG2        = 2.0*COSG
C ---
      D22 = SX*SY*SZ*COSZ*SING
C
C----Loop over all atoms
      NX50 = 50*NX
      NY50 = 50*NY
      NZ50 = 50*NZ
      DO     IA=1,N_ATOM
      
C---If atom has isotropic U values
        CALL GET_RADIUS_FOR_THIS_ATOM(IA,D0)
        D1 = D0**2
C
C---Add NCS here
       IF(OCCUP(IA).LE.0.0.OR.CS_ELEMENT(ID_SF(IA)).EQ.'H   '.OR.
     &    CS_ELEMENT(ID_SF(IA)).EQ.'H-1 '.OR.ATOM_REF_FLAG(IA).LE.2) 
     &        GOTO 500
C
C---List of all atoms contributing to asymmetric unit
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ,ERROR)
        CALL ATLIST1(XYZ,XA_list,XLOW,YLOW,ZLOW,XUPPER,YUPPER,
     +           ZUPPER,INDSYM_LIST,NATOM_LIST)
C
C----Loop over list of atoms which contribute to "asymmetric" unit
        DO    ILIST=1,NATOM_LIST
          
          X1 = XA_list(1,ILIST)*CS_CELL(1)
          Y1 = XA_list(2,ILIST)*CS_CELL(2)
          Z1 = XA_list(3,ILIST)*CS_CELL(3)
          XC = X1/SX
          YC = Y1/SY
          ZC = Z1/SZ
c
c--Accumulate to asymm
          call mat2mat(3,3,rsym(1,1,is),rfrac,acum/_mat,error)
          accum_tr(1:3) = accum_tr(1:3) + rsym() + itr_this()
C
          RADZ = SQRT(D1)/(SZ*COSZ)
          SZL  = ZC - RADZ
          SZU  = ZC + RADZ
          ISZL = INT(SZL+501.0)
          ISZU = INT(SZU+500.0)
          DO      IZ1 = ISZL,ISZU
             IZ  = IZ1 - 500
             IZ0 = MOD(IZ,NZ) + 1
             iz2 = iz2 + 1
         
c
             IF(IZ2.GT.N3)GO TO 300
             DZ  = IZ*SZ - Z1
             DZO = DZ*RO_UNIT(3,3)
             DZO2= DZO*DZO
             D2  = DZ*DZ
             D7  = D1 - DZO2
             IF (D7.LT.0.0)GO TO 300
             RADY   = SQRT(D7)/(SY*SING)
             ZCOSA  = DZ*COSAST/SY
             SYL    = YC - RADY - ZCOSA
             SYU    = YC + RADY - ZCOSA
             ISYL   = INT(SYL+501.0)
             ISYU   = INT(SYU+500.0)
             DZCSA2 = DZ*CSA2
             DZROX  = DZ*RO_UNIT(1,3)
             DZROY  = RO_UNIT(2,3)*DZ
             DZCSB  = DZ*COSB
             DO     IY1 = ISYL,ISYU
               IY  = IY1-500
               IY2 = MOD(IY+NY50,NY)+1
C---CHECK FOR IY2 WITHIN ASYMMETRIC UNIT
               IF(IY2.GT.N2)GO TO 290
               DY     = IY*SY-Y1
               DYO    = DY*RO_UNIT(2,2) + DZROY
               DYO2   = DYO*DYO
               DYZ    = D2+(DZCSA2+DY)*DY
               DXMIN  =-DY*COSG-DZCSB
               DSQMIN = DYZ - DXMIN**2
               D4     = D1 - DSQMIN
               IF(D4.LT.0.0) GOTO 290
               RADX     = SQRT(D4)/(SX*SING)
               XDELTA   = DXMIN/SX
               SXL      = XC - RADX + XDELTA
               SXU      = XC + RADX + XDELTA
               ISXL     = INT(SXL+501.0)
               ISXU     = INT(SXU+500.0)
               DYZROX   = DY*RO_UNIT(1,2) + DZROX
               DXO2PYO2 = DYO2 + DZO2
               
               DO      IX1 = ISXL,ISXU
                 IX   = IX1 - 500
                 IX2  = MOD(IX+NX50,NX)+1
C---CHECK FOR IX2 WITHIN ASYMMETRIC UNIT
                 IF(IX2.GT.N1)GO TO 280
                 DX   = IX*SX-X1
                 DXO  = DX*RO_UNIT(1,1) + DYZROX
                 DXO2 = DXO*DXO
                 DSQ  = DXO2 + DXO2PYO2
                 IF(DSQ.GT.D1)GO TO 280
                 if(den(ix2,iy2,iz2).lt.0.0) then
c
c---Go back and find all NCS related points and their value
                    Zor = real(iz)
                    Yor = real(iy)
                    Xor = real(ix)
                    xyz_or(1:3) = xyz_or(1:3)-tr_or(1:3)
                    call mat2mat(3,3,rort,accum_mat,accum1,error)
                    call matt2vec(3,3,accum1,xyz_or,xyz_or1,error)
c     
c---loop over NCS
                    rhos_here = den_in(ix2,iy2,iz2)
                    do   is=2,n_ncs_this
                       call mat2vec(3,3,rncs_this(1,1,i),xyz_or1,xyz2,error)
                       xyz_or1(1:3) = xyz_or1(1:3) + tncs_this(1:3,i)
                       call find_in_asym()
                       call interpolate_densty)
                       rho_here = rho_here + rho_int
                    enddo
                    rho_here = rho_here/ncs_this_number
                    den_out(ix2,iy2,iz2) = rho_here
                 endif
 280             CONTINUE
              ENDDO
 290          CONTINUE
            ENDDO
 300        CONTINUE
          ENDDO
        ENDDO
 500    CONTINUE
      ENDDO
c
c--Add remaining electron density

cd      STOP
      RETURN
      END

