module make_dists

contains
  subroutine make_dist_list(n_atom,atom_ref_flag,ndis,local_tls_pairs)
    implicit none
    include 'restr_files.fh'
    !
    !--this subroutine reads file vdw_file_0 containing list of distances
    !--and makes distance list for second derivative calculation
    integer n_atom,ndis
    integer, intent(in) :: atom_ref_flag(:)
    !
    !---  
    integer nvdw1,local_tls_pairs
    integer ifile,ifile_all,ierr,i,j,ic
    integer ir,in,is,nplane,ns,ncs_loc,nrests,nmaxatom_plane
    integer chn_pairs
    integer ipl,ndis0
    !
    integer ia1(4),is_sym(4),it,it_p
    integer ia_p(50),is_t(4,50)
    real rs_vidl(4)
    real wt
    character title*80
    character t_lab*8
    !
    integer maxrest,id,i1,i2
    integer nbonds,nangles,ntors,nchirs,nints,nplanes,nvdws
    integer ncs_all,nr_all,nr,nr0,k
    
    integer, allocatable :: pairs(:,:)
    integer, allocatable :: pairs1(:,:)
    integer, allocatable :: bonds(:,:)
    integer, allocatable :: angles(:,:)
    integer, allocatable :: torsns(:,:)
    integer, allocatable :: it_tors(:)
    integer, allocatable :: chirs(:,:)
    integer, allocatable :: no_planes(:)
    integer, allocatable :: planes(:,:)
    integer, allocatable :: intervals(:,:)
    integer, allocatable :: vdws(:,:)
    integer, allocatable :: ncss(:,:)
    
    integer nm,nmax,ia,ja1,ja2,n0,n1,n2,i3
    integer, allocatable :: nrest_per_atom(:)
    integer, allocatable :: nrest1_per_atom(:)
    integer, allocatable :: rest_per_atom(:)
    integer, allocatable :: rest1_per_atom(:,:)

    character(8)  :: dt
    character(10) :: tm
    character(5)  :: zn
    integer,dimension(8) :: val_l
                                !
                                !  body
      if(len_trim(all_pairs_file).le.0) then
         call find_unique_file_name(all_pairs_file,'.all_pairs')
      endif
      call open_unform_file(ifile_all,all_pairs_file,ierr)

                                !
                                !  First run. Find upper limit
      ndis = 0
      if(len_trim(bond_file).gt.0) then
         call open_unform_file(ifile,bond_file,ierr)
         read(ifile)nbonds
         
         allocate(bonds(2,nbonds))
         do ir=1,nbonds
            read(ifile)bonds(1:2,ir),rs_vidl(1:2),is_sym(1:4),it,wt
            ndis = ndis + 1
         enddo
         close(ifile)
      endif
                                !
                                !  Angles
      if(len_trim(angle_file).gt.0) then
         call open_unform_file(ifile,angle_file,ierr)
         read(ifile)nangles
         allocate(angles(3,nangles))
         do ir=1,nangles
            read(ifile)angles(1:3,ir),is_t(1:4,1:3),rs_vidl(1:2),wt
            ndis = ndis + 3
         enddo
         close(ifile)
      endif
                                !
                                !  torsions
      if(len_trim(tors_file).gt.0) then
         call open_unform_file(ifile,tors_file,ierr)
         read(ifile)ntors
         allocate(torsns(4,ntors))
         allocate(it_tors(ntors))
         do ir=1,ntors
            read(ifile)t_lab,torsns(1:4,ir),is_t(1:4,1:4),it_p,
     &           rs_vidl(1:2),it_tors(ir),wt
            if(it_tors(ir).ne.0) then
               ndis = ndis + 6
            endif
         enddo
         close(ifile)
      endif
                                !
                                ! We do not chiralities. They are already 
                                ! in the list of bonds and angles
                                ! Planes
                                !  chirals
      if(len_trim(chir_file).gt.0) then
         call open_unform_file(ifile,chir_file,ierr)
         read(ifile)nchirs
         allocate(chirs(4,nchirs))
         do ir=1,nchirs
            read(ifile)chirs(1:4,ir),is_t(1:4,1:4),rs_vidl(1:2),
     &           it,wt
            ndis = ndis + 6
         enddo
         close(ifile)
      endif
c
      if(len_trim(plane_file).gt.0) then
         call open_unform_file(ifile,plane_file,ierr)
         read(ifile)nplanes,nmaxatom_plane
         allocate(planes(nmaxatom_plane,nplanes))
         allocate(no_planes(nplanes))
         do ir=1,nplanes
            read(ifile)no_planes(ir),rs_vidl(1:2),
     &           (planes(ipl,ir),ipl=1,no_planes(ir)),
     &           (is_t(1:4,i),i=1,no_planes(ir)),wt
            ndis = ndis + no_planes(ir)*(no_planes(ir)-1)/2
         enddo
         close(ifile)
      endif
      if(len_trim(vdw_file).gt.0) then
         call open_unform_file(ifile,vdw_file,ierr)
         read(ifile)nvdws
         allocate(vdws(2,nvdws))
         do ir=1,nvdws
            read(ifile)vdws(1:2,ir),rs_vidl(1:3),is_sym(1:4),it
            ndis = ndis + 1
         enddo
         close(ifile)
      endif
      if(len_trim(interval_file).gt.0) then
         call open_unform_file(ifile,interval_file,ierr)
         read(ifile)nints
         allocate(intervals(4,nints))
         do ir=1,nints
            read(ifile)intervals(1:4,ir),is_t(1:4,1),rs_vidl(1:4),it,wt
            ndis = ndis + 6
         enddo
         close(ifile)
      endif
      if(len_trim(ncs_simil_file).gt.0) then
         call open_unform_file(ifile,ncs_simil_file,ierr)
         read(ifile)ncs_loc,ncs_all
         allocate(ncss(4,ncs_all))
         ir = 0
         nr0 = 0
         do in=1,ncs_loc
            read(ifile)ns
            nr_all = 0
            if(ns.gt.0) then
               do while(nr_all.lt.ns)
                  read(ifile)nr
                  nr_all = nr_all + nr
                  if(nr_all.gt.ns) then
                     write(*,*)'Error==> In make_dist_list',nr_all,ns
                     write(*,*)'Error==> Sum of restraints do not match'
                     call ccperr(1,'Problem in make_dist_list')
                  endif
                  read(ifile)(ncss(1:4,nr0+k),rs_vidl(1),wt,k=1,nr)
                  ndis = ndis + 6*nr
                  nr0 = nr0 + nr
               enddo
            endif
         enddo
         close(ifile)
      endif
                                !     
                                !---  Convert all restraints to pairs
      id = 0
      ndis_max = ndis
      allocate(pairs(2,ndis))
      if(len_trim(bond_file).gt.0) then
         do ir=1,nbonds
            id = id + 1
            pairs(1:2,id) = bonds(1:2,ir)
         enddo
         deallocate(bonds)
      endif
                                !
                                !  Angles
      if(len_trim(angle_file).gt.0) then
         do ir=1,nangles
            do i=1,2
               do j=i+1,3
                  id = id + 1
                  pairs(1,id) = angles(i,ir)
                  pairs(2,id) = angles(j,ir)
               enddo
            enddo
         enddo
         deallocate(angles)
      endif
                                !
                                !  torsions
      if(len_trim(tors_file).gt.0) then
         do ir=1,ntors
            if(it_tors(ir).ne.0) then
               do i=1,3
                  do j=i+1,4
                     id = id + 1
                     pairs(1,id) = torsns(i,ir)
                     pairs(2,id) = torsns(j,ir)
                  enddo
               enddo
            endif
         enddo
         deallocate(torsns)
         deallocate(it_tors)
      endif
                                !
                                ! We do not need chiralities. They are already 
                                ! in the list of bonds and angles
                                ! Planes
                                !  chirals
      if(len_trim(chir_file).gt.0) then
         do ir=1,nchirs
            do i=1,3
               do j=i+1,4
                  id = id + 1
                  pairs(1,id) = chirs(i,ir)
                  pairs(2,id) = chirs(j,ir)
               enddo
            enddo
         enddo
         deallocate(chirs)
      endif
c
      if(len_trim(plane_file).gt.0) then
         do ir=1,nplanes
            do i=1,no_planes(ir)-1
               do j=i+1,no_planes(ir)
                  id = id + 1
                  pairs(1,id) = planes(i,ir)
                  pairs(2,id) = planes(j,ir)
               enddo
            enddo
         enddo
         deallocate(planes)
         deallocate(no_planes)
      endif
      if(len_trim(vdw_file).gt.0) then
         do ir=1,nvdws
            id = id + 1
            pairs(1,id) = vdws(1,ir)
            pairs(2,id) = vdws(2,ir)
         enddo
         deallocate(vdws)
      endif
      if(len_trim(interval_file).gt.0) then
         do ir=1,nints
            do i=1,3
               do j=i+1,4
                  id = id + 1
                  pairs(1,id) = intervals(i,ir)
                  pairs(2,id) = intervals(j,ir)
               enddo
            enddo
         enddo
         deallocate(intervals)
      endif
      if(len_trim(ncs_simil_file).gt.0) then
         do ir = 1,ncs_all
            do i=1,3
               do j=i+1,4
                  id = id + 1
                  pairs(1,id) = ncss(i,ir)
                  pairs(2,id) = ncss(j,ir)
               enddo
            enddo
         enddo
         deallocate(ncss)
      endif

      do ir=1,ndis
         if(pairs(1,ir).gt.pairs(2,ir)) then
            it = pairs(2,ir)
            pairs(2,ir) = pairs(1,ir)
            pairs(1,ir) = it
         endif
      enddo

      call iheap_sort_0(ndis,2,pairs(1:2,1:ndis))

      if (ndis.gt.0) then
      ndis0 = 1
      ia1(1:2) = pairs(1:2,1)
      do i=2,ndis
         if(sum(abs(pairs(1:2,i)-ia1(1:2))).gt.0.and.
     &        pairs(1,i).ne.pairs(2,i)) then
            if(atom_ref_flag(pairs(1,i)).gt.0.and.
     &           atom_ref_flag(pairs(2,i)).gt.0) then
               ndis0 = ndis0 + 1
               pairs(1:2,ndis0) = pairs(1:2,i)
               ia1(1:2) = pairs(1:2,i)
            endif
         endif
      enddo
      ndis = ndis0
      endif

      allocate(nrest_per_atom(n_atom))
      nrest_per_atom(1:n_atom) = 0
      do ir=1,ndis
         nrest_per_atom(pairs(1,ir)) = nrest_per_atom(pairs(1,ir))+1
         nrest_per_atom(pairs(2,ir)) = nrest_per_atom(pairs(2,ir))+1
      enddo
      allocate(rest_per_atom(n_atom+1))
      rest_pos_per_atom(1) = 0
      do ia=1,n_atom
         rest_pos_per_atom(ia+1) = rest_pos_per_atom(ia)+
     &        nrest_per_atom(ia)
      enddo
      nmax_rests = 1.5*rest_pos_per_atom(n_atom+1)
      allocate(rest_per_atom(nmax_rests))
      write(*,*)'nmax rest ',nmax_rests
      allocate(nrest1_per_atom(n_atom))
      nrest1_per_atom(1:n_atom) = 0
      do ir=1,ndis
         ja1 = pairs(1,ir)
         ja2 = pairs(2,ir)
         nrest1_per_atom(ja1) = nrest1_per_atom(ja1) + 1
         ip1 = rest_pos_per_atom(ja1)
         rest_per_atom(ip1+nrest1_per_atom(ja1))= ja2
         ip2 = rest_pos_per_atom(ja2)
         nrest1_per_atom(ja2) = nrest1_per_atom(ja2) + 1
         rest_per_atom(ip2+nrest1_per_atom(ja2)) = ja1
      enddo

      if(local_tls_pairs.eq.1) then
C
C---  We need to add more pairs if we want to use local TLS.
         do ia=1,n_atom
            do i1=rest_pos_per_atom(ia)+1,rest_pos_per_atom(ia+1)-1 
               ja1 = rest_per_atom(i1)
               do i2=i1+1,rest_pos_per_atom(ia+1)
                  ja2 = rest_per_atom(i2)
                  do i3=rest_pos_per_atom(ja1)+1,rest_pos_per_atom(ja1+1)
                     if(ja2.eq.rest_per_atom(i3)) cycle
                  enddo
                  if(ja2.le.ja1) cycle
                  
                  if(id.ge.ndis_rests) then
                     allocate(pairs1(2,ndis_rests))
                     pairs1 = pairs
                     nm = ndis_rests
                     ndis_rests = 1.5*ndis_rests
                     deallocate(pairs)
                     allocate(pairs(2,ndis_rests))
                     pairs(1:2,1:nm))=pairs1(1:2,1:nm)
                     deallocate(pairs1)
                  endif
                  id = id + 1
                  pairs(1,id) = ja1
                  pairs(2,id) = ja2
               enddo
 30            continue
            enddo
         enddo
         ndis = id
c
c---Sort pairs again and remove redundant pairs
      endif
      nrest_per_atom = nrest1_per_atom
      deallocate(nrest1_per_atom)

      nrest_per_atom(1:n_atom) = 0
      do i=1,ndis
         nrest_per_atom(pairs(1,i))=nrest_per_atom(pairs(1,i))+1
      enddo

      write(*,*)ndis,n_atom
      write(ifile_all)ndis,n_atom
      ip1 = 1
      ip2 = ip1 + nrest_per_atom(1)-1
      if(pairs(1,1).gt.1) then
         n1 = 0
         do ia=1,pairs(1,1)-1
            write(*,*)n1
         enddo
      endif
      idis = 1
      ip1 = 0
      ip2 = 0
      do while(idis.lt.ndis)
         n1 = nrest_per_atom(pairs(1,idis))
         ip1 = ip2 + 1
         ip2 = ip1 + n1
         write(ifile_all)n1
         write(ifile_all)pairs(1:2,ir),ir=ip1,ip2)
         idis=idis + n1
         if(abs(pairs(1,idis)-pairs(1,idis-1)).gt.1) then
            do ia=pairs(1,idis-1)+1,pairs(1,idis)-1
               n1 = 0
               write(*,*)n1
            enddo
         endif
      enddo

      deallocate(nrest_per_atom)
      deallocate(rest_per_atom)
      close(ifile_all)
      deallocate(pairs)

c      stop
      return
    end subroutine make_dist_list
  end module make_dists
