C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C

      SUBROUTINE GET_SYMM_NB_NEW(MDOC,NOSPGR,ISETT,SGNAME,CS_NSYM
     *                              ,SYM,TRANS,MAXNSO,IERR)
C -------------------------------------------------------
C -P- GET_SYMM - generate cryst.symm. oparators from space group name or space
C -P-            group number.
C
C     input:  NOSPGR,ISETT,SGNAME
C
C     output: CS_NSYM,SYM,TRANS  
C             IERR
C             NOSPGR,ISETT  if SGNAME is input
C             SGNAME        if NOSPGR,ISETT are input
C -------------------------------------------------------
      IMPLICIT NONE
      INTEGER   MDOC,IERR
      INTEGER   MAXNSO
      REAL      SYM(3,3,MAXNSO)
      REAL      TRANS(3,MAXNSO)
      INTEGER   NOSPGR,ISETT,CS_NSYM
      CHARACTER SGNAME*(*)
      
      CHARACTER NAMSPG_CIFS*20,NAMPG*20

      INTEGER ISYM_UNIT,NSYMP,ISYM,J,I
C
      INTEGER NumSymmetry
      REAL RealSymmMatrx(4,4,192)
C ---------------------------------------------------------
      IERR = 0
C
C---Read symetry operators and remaining identifiers of the space
C---group
cd      write(*,*)nospgr,sgname,namspg_cifs,nampg
      if(sgname.eq.'P 1-') sgname = 'P -1'
      if(sgname.eq.'P 21 21 2 A'.or.sgname.eq.'P 21 21 2A')
     &      sgname = 'P 21 21 2 (a)'
      if(sgname.eq.'R 3(RHOM)')sgname = 'R 3'
      ISYM_UNIT = 0
      if(len_trim(sgname).gt.0) nospgr = 0
      CALL MSYMLB3(ISYM_UNIT,NOSPGR,SGNAME,NAMSPG_CIFS,
     +                   NAMPG,NSYMP,NumSymmetry,RealSymmMatrx)
C
C---Store symmetry operators in SYM and TRANS as Alexei wants
      CS_NSYM = NumSymmetry
      DO    ISYM=1,CS_NSYM
        DO   J=1,3
          DO   I=1,3
            SYM(I,J,ISYM) = RealSymmMatrx(I,J,ISYM)
          ENDDO
          TRANS(J,ISYM) = RealSymmMatrx(J,4,ISYM)
        ENDDO
      ENDDO

C -----------------------------------     
cd      CALL GET_SYMM_NB(MDOC,NOSPGR,ISETT,SGNAME,NSYM
cd     *                              ,SYM,TRANS,SYMOP,MAXNSO,IERR)
C ------------------------------------
      RETURN
      END

C ******
      SUBROUTINE OPENFR(IN,MDOC,PATH,FNAME,EXT,IERR)
C
C -P- OPENFR - open formatted file for read /with extention and path/
C
C       input:
C               IN    - unit
C               MDOC  - mode of writting messages to DOC-file
C                       0 - only term, < - 0 only file, 0 < < 99 - both
C                       >= 99 - not write  
C               PATH  - path      / may be = '    ' /
C               FNAME - file name
C               EXT   - extention / may be = '    ' /
C
C        output:
C               IERR = 0 - OK
C                    > 0 - error.
C
      IMPLICIT NONE
      INTEGER   IN,MDOC,IERR
      CHARACTER PATH*(*),FNAME*(*),EXT*(*)

      integer ifail
      INTEGER   NLE,NLN,NLP,NL
      CHARACTER FILE*256
C
C -------------------------------------------------------------
      IERR  = 0

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)

      IF(NLE.GT.0) THEN
        FILE=FNAME(1:NLN)//'.'//EXT(1:NLE)
      ELSE
        FILE=FNAME(1:NLN)
      ENDIF     
      CALL LENSTR_BL(FILE,NL)
      IF(NLP.GT.0) THEN
        FILE=PATH(1:NLP)//FILE(1:NL)
      ENDIF     

      IF(len_trim(FILE).LE.0) THEN
        CALL ERRWRT(1,'File length is 0. Cannot open for reading')
      ENDIF
      call open_form_file(in,file,ifail)
      IF(IFAIL.NE.0) THEN
        CALL MSGERR(MDOC,'Open failed in in OPENFR')
        IERR = 1
      ENDIF
      RETURN
      END

C ******
      SUBROUTINE OPENFW(IOUT,MDOC,PATH,FNAME,EXT,IERR)
C
C -P- OPENFW - open formatted file for write /with extentiom and path/
C
C       input:
C               IOUT   - unit
C               MDOC  - mode of writting messages to DOC-file
C                       0 - only term, < - 0 only file, 0 < < 99 - both
C                       >= 99 - not write  
C               PATH  - path      / may be = '    ' /
C                       ( example of PATH='blanc/temp/' )
C               FNAME - file name
C               EXT   - extention / may be = '    ' /
C
C        output:
C               IERR = 0 - OK
C                    > 0 - error.
C
      IMPLICIT NONE
      INTEGER   IOUT,MDOC,IERR
      CHARACTER PATH*(*),FNAME*(*),EXT*(*)
      INTEGER IFAIL,LL

      INTEGER   NLE,NLN,NLP,NL
      CHARACTER FILE*256,FILE1*256
C ------------------------------
      IERR = 0

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)

      IF(NLE.GT.0) THEN
        FILE1=FNAME(1:NLN)//'.'//EXT(1:NLE)
      ELSE
        FILE1=FNAME(1:NLN)
      ENDIF     
      CALL LENSTR_BL(FILE1,NL)
      IF(NLP.GT.0) THEN
        FILE=PATH(1:NLP)//FILE1(1:NL)
      ELSE
        FILE = FILE1(1:NL)
      ENDIF     

C
      IF(len_trim(FILE).LE.0) THEN
        CALL ERRWRT(1,'LENGTH of file is 0. Cannot open UNKNOW file') 
      ENDIF
      call open_form_file(iout,file,ifail)
      IF(IFAIL.NE.0) THEN
        IERR = 1
        CALL MSGERR(MDOC,'Open failed in in OPENFW')
      ENDIF
      RETURN
      END
C
      SUBROUTINE OPENUR(IN,MDOC,PATH,FNAME,EXT,IERR)
C
C -P- OPENUR - open unformatted file for read /with extentiom and path/
C
C       input:
C               IN    - unit
C               MDOC  - mode of writting messages to DOC-file
C                       0 - only term, < - 0 only file, 0 < < 99 - both
C                       >= 99 - not write
C               PATH  - path      / may be = '    ' /
C               FNAME - file name
C               EXT   - extention / may be = '    ' /
C
C        output:
C               IERR = 0 - OK
C                    > 0 - error.
C
      IMPLICIT NONE
      INTEGER   IN,MDOC,IERR
      CHARACTER PATH*(*),FNAME*(*),EXT*(*)
C ******
      INTEGER   NLE,NLN,NLP,NL
      CHARACTER FILE*256,FILE1*256,LINE*80
      CHARACTER CH1*1,TYPE*1
      INTEGER IFAIL,LL,I
C -------------------------------------------------------------
      IERR=0

      NLE = len_trim(EXT)
      NLP = len_trim(PATH)
      NLN = len_trim(FNAME)

      CH1=FNAME(1:1)
      CALL CHKSMB(CH1,TYPE)
      IF(TYPE.EQ.'?'.OR.CH1.EQ.' '.OR.CH1.EQ.',') THEN
        FNAME(1:1)=' '
      ENDIF


      IF(NLN.GT.1) THEN
        DO I=2,NLN
          IF(FNAME(I:I).EQ.',') FNAME(I:I)=' '
        ENDDO
      ENDIF
      IF(NLP.GT.1) THEN
        DO I=2,NLP
          IF(PATH(I:I).EQ.',') PATH(I:I)=' '
        ENDDO
      ENDIF
      IF(NLE.GT.1) THEN
        DO I=2,NLE
          IF(EXT(I:I).EQ.',') EXT(I:I)=' '
        ENDDO
      ENDIF

      NLE = len_trim(EXT)
      NLP = len_trim(PATH)
      NLN = len_trim(FNAME)


      IF(FNAME(1:1).EQ.' '.OR.NLN.LE.0) GO TO 9100

      IF(NLE.GT.0) THEN
        FILE1=FNAME(1:NLN)//'.'//EXT(1:NLE)
      ELSE
        FILE1=FNAME(1:NLN)
      ENDIF
      NL = len_trim(FILE1)
      IF(NLP.GT.0) THEN
        FILE=PATH(1:NLP)//FILE1(1:NL)
      ELSE
        FILE=FILE1(1:NL)
      ENDIF
      NL = len_trim(FILE)
      IF(NL.LE.0) THEN
        CALL ERRWRT(1,'File length is 0. CANNOT open file. OPENUR')
      ENDIF
      call open_unform_file(in,file,ifail)
      IF(IFAIL.GT.0) GOTO 9100
      RETURN
C ----
9100  CONTINUE
      IF(NLE.GT.65) NLE=65
      IF(NLP.GT.65) NLP=65
      IF(NLN.GT.65) NLN=65
      CALL MSGERR(MDOC,' ERR: OPEN FILE /FOR READ/ ')
      IF(NLP.GT.0) THEN
        WRITE(LINE,20) PATH(1:NLP)
 20     FORMAT('        PATH :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLN.GT.0) THEN
        WRITE(LINE,30) FNAME(1:NLN)
 30     FORMAT('        NAME :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLE.GT.0) THEN
        WRITE(LINE,40) EXT(1:NLE)
 40     FORMAT('   EXTENTION :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IERR=1
      RETURN
      END

      SUBROUTINE OPENUW(IOUT,MDOC,PATH,FNAME,EXT,IERR)
C
C -P- OPENFW - open unformatted file for write /with extentiom and path/
C
C       input:
C               IN    - unit
C               MDOC  - mode of writting messages to DOC-file
C                       0 - only term, < - 0 only file, 0 < < 99 - both
C                       >= 99 - not write
C               PATH  - path      / may be = '    ' /
C               FNAME - file name
C               EXT   - extention / may be = '    ' /
C
C        output:
C               IERR = 0 - OK
C                    > 0 - error.
C
      INTEGER   IOUT,MDOC,IERR
      CHARACTER PATH*(*),FNAME*(*),EXT*(*)
C ******
      INTEGER   NLE,NLN,NLP,NL
      CHARACTER FILE*256,FILE1*256,LINE*80
      CHARACTER CH1*1,TYPE*1
      INTEGER IFAIL,LL,I
C -------------------------------------------------------------
      IERR=0

      NLE = len_trim(EXT)
      NLP = len_trim(PATH)
      NLN = len_trim(FNAME)

      CH1=FNAME(1:1)
      CALL CHKSMB(CH1,TYPE)
      IF(TYPE.EQ.'?'.OR.CH1.EQ.' '.OR.CH1.EQ.',') THEN
        FNAME(1:1)=' '
      ENDIF


      IF(NLN.GT.1) THEN
        DO I=2,NLN
          IF(FNAME(I:I).EQ.',') FNAME(I:I)=' '
        ENDDO
      ENDIF
      IF(NLP.GT.1) THEN
        DO I=2,NLP
          IF(PATH(I:I).EQ.',') PATH(I:I)=' '
        ENDDO
      ENDIF
      IF(NLE.GT.1) THEN
        DO I=2,NLE
          IF(EXT(I:I).EQ.',') EXT(I:I)=' '
        ENDDO
      ENDIF

      NLE = len_trim(EXT)
      NLP = len_trim(PATH)
      NLN = len_trim(FNAME)


      IF(FNAME(1:1).EQ.' '.OR.NLN.LE.0) GO TO 9100

      IF(NLE.GT.0) THEN
        FILE1=FNAME(1:NLN)//'.'//EXT(1:NLE)
      ELSE
        FILE1=FNAME(1:NLN)
      ENDIF
      NL = len_trim(FILE1)
      IF(NLP.GT.0) THEN
        FILE=PATH(1:NLP)//FILE1(1:NL)
      ELSE
        FILE=FILE1(1:NL)
      ENDIF
      NL = len_trim(FILE)
      IF(NL.LE.0) THEN
        CALL ERRWRT(1,'File length is 0. Cannot open file. OPENUW')
      ENDIF
      call open_unform_file(iout,file,ifail)

      IF(IFAIL.GT.0) GOTO 9100
      RETURN
C ----
9100  CONTINUE
      IF(NLE.GT.65) NLE=65
      IF(NLP.GT.65) NLP=65
      IF(NLN.GT.65) NLN=65
      CALL MSGERR(MDOC,' ERR: OPEN FILE /FOR WRITE/ ')
      IF(NLP.GT.0) THEN
        WRITE(LINE,20) PATH(1:NLP)
 20     FORMAT('        PATH :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLN.GT.0) THEN
        WRITE(LINE,30) FNAME(1:NLN)
 30     FORMAT('        NAME :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLE.GT.0) THEN
        WRITE(LINE,40) EXT(1:NLE)
 40     FORMAT('   EXTENTION :',A,';')
        CALL MSGERR(MDOC,LINE)

      ENDIF
      IERR=1
      RETURN
      END

      SUBROUTINE GET_SFA(ASYMB
     *      ,N,NEL,A1,A2,A3,A4,B1,B2,B3,B4,C,FI,FII,RAD,IERR)
C -----------------------------------------------
C -P- GET_SFA - gets atomic scatt.factor coefficients for atomic type.
C -S-
C      REAL      A1,A2,A3,A4,B1,B2,B3,B4,C,FI,FII,RAD
C      INTEGER*4 N,NEL,IERR
C      CHARACTER ASYMB*4,CHAR4*4,TYPE*1
C ******
C ---
C      REAL      TSF_A1(94),TSF_A2(94),TSF_A3 (94),TSF_A4 (94)
C      REAL      TSF_B1(94),TSF_B2(94),TSF_B3 (94),TSF_B4 (94)
C      REAL      TSF_C (94),TSF_FI(94),TSF_FII(94),TSF_RAD(94)
C      INTEGER*4 TSF_N,TSF_NE(94)
C      CHARACTER TSF_ATOM(94)*4
C ---
C      DATA TSF_N /94/
C      DATA TSF_ATOM( 1)/'H   '/,TSF_NE( 1)/ 1/,TSF_RAD( 1)/1.50/
C     * ,TSF_A1( 1)/  0.49300/,TSF_B1( 1)/ 10.51091/
C     * ,TSF_A2( 1)/  0.32291/,TSF_B2( 1)/ 26.12573/
C     * ,TSF_A3( 1)/  0.14019/,TSF_B3( 1)/  3.14236/
C     * ,TSF_A4( 1)/  0.04081/,TSF_B4( 1)/ 57.79977/
C     * ,TSF_C ( 1)/  0.00304/
C     * ,TSF_FI( 1)/  0.00000/,TSF_FII( 1)/  0.00000/
C      DATA TSF_ATOM( 2)/'HE  '/,TSF_NE( 2)/ 2/,TSF_RAD( 2)/1.50/
C -----------------
      IMPLICIT NONE
      REAL      A1,A2,A3,A4,B1,B2,B3,B4,C,FI,FII,RAD
      INTEGER   N,NEL,IERR
      CHARACTER ASYMB*4
C
      REAL A(4),B(4),CU(2),MO(2)
      INTEGER IWT,IFAIL
C -----------------
C
      IERR = 0
      IFAIL = -1
      CALL SFREAD2(ASYMB,N,A,B,C,IWT,NEL,CU,MO,IFAIL)
      IF(IFAIL.LT.0) THEN 
        CALL MSGERR(0,' No match for ATOM ID'//ASYMB)
        IERR = 1
        RETURN
      ENDIF
C
      A1  = A(1)
      A2  = A(2)
      A3  = A(3)
      A4  = A(4)
      B1  = B(1)
      B2  = B(2)
      B3  = B(3)
      B4  = B(4)
      FI  = CU(1)
      FII = CU(2)
      RAD = 0.0
      RETURN
      END
C
      SUBROUTINE MAKE_CORRECTION_TO_CELL_DIFF(RORT,RFRAC,IERR)
      IMPLICIT NONE
C
C---This subroutine makes correction to atomic coordinates according
C---to cell dimensions. It is trial version. It at the moments only adds
C---translational component. Rotational component should also be done.
C---
C
      INCLUDE 'atom_com.fh'
      REAL RORT(3,3),RFRAC(3,3)
      INTEGER IERR
C
      REAL RORT2FRAC(3,3)
      REAL X_CENT(3),X_CORRECT(3)
      INTEGER LWORK,INFO_LAP
      REAL WORK(3)
      REAL XAX(3,3),U(3,3),VT(3,3)
      INTEGER I,IA,IX,N_ACTIVE_ATOMS
      LOGICAL ERROR
C
      IERR = 0
C
C---Calculate deformation matrix.
      ERROR = .FALSE.
      CALL MAT2MAT(3,3,RORT,RFRAC,RORT2FRAC,ERROR)
C
C---Trace of this matrix should give us an idea degree of deformation
C
      DO   I=1,3
         RORT2FRAC(I,I) = RORT2FRAC(I,I) - 1.0
      ENDDO
C
C---Find centre of gravity. Perhaps these correction should be
C---applied to each chain seperately. Discuss with Alexei
      DO   I=1,3
        X_CENT(I) = 0.0
      ENDDO
      N_ACTIVE_ATOMS = 0
      DO   IA=1,N_ATOM
        IF(OCCUP(IA).GT.0.0) THEN
          N_ACTIVE_ATOMS = N_ACTIVE_ATOMS + 1
          X_CENT(1) = X_CENT(1) + XYZ_CRD(1,IA)
          X_CENT(2) = X_CENT(2) + XYZ_CRD(2,IA)
          X_CENT(3) = X_CENT(3) + XYZ_CRD(3,IA)
        ENDIF
      ENDDO
C
      IF(N_ACTIVE_ATOMS.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      DO   I=1,3
        X_CENT(I) = X_CENT(I)/FLOAT(N_ACTIVE_ATOMS)
      ENDDO
C
      CALL MAT2VEC(3,3,RORT2FRAC,X_CENT,X_CORRECT,ERROR)
      DO   IA=1,N_ATOM
         DO  IX=1,3
           XYZ_CRD(IX,IA) = XYZ_CRD(IX,IA) + X_CORRECT(IX)
         ENDDO
      ENDDO
C
      RETURN
C
C--lapack routine for singular value decomposition
C
cd      CALL SGESVD('A','A',3, 3, XAX, 3, SINGUL, U, 3, VT, 3,
cd     $                   WORK, LWORK, INFO )
C
cd      CALL MAT2VEC(3,3,U,VT,ROTATE,ERROR)
C
C---Now apply to coordinates

      END
