      subroutine read_hklf5(nobs,ncomp,iobs,
     &     nref_comp,hkl_comp,comp_numb,ierr,input_file)
c
c---This subroutine reads hklf 5 file of observations.
c
C---Organisation
C
      implicit none
      integer ierr
      integer nobs,ncomp
      real iobs(2,nobs)
      integer nref_comp(nobs)
      integer hkl_comp(3,ncomp)
      integer comp_numb(ncomp)
      character input_file*(*)

      character*4 text
      integer num,ii,in
      integer hl,kl,ll,icomp
      real fol, sol
      integer in_file,ios
      logical eof
C
c      in_file=10
c      open(in_file,file=input_file)
      call open_form_file(in_file,input_file,ierr)
c      read(in_file,'(a4,i2)')text,num
c      if(text.ne.'HKLF'.or.num.ne.5 ) then
c        write(*,*)'HKLIN is not hklf5 file.'
c        ierr = 1
c        return
c      endif
            
      ii = 0
      nref_comp(1) = 0 
      in = 0
      eof = .FALSE.
      read(in_file,'(3I4,2F8.2,I4)',iostat=ios)hl,kl,ll,fol,sol,icomp
      if(ios.gt.0) goto 102

      do while((hl.ne.0.or.kl.ne.0.or.ll.ne.0).and.ios.eq.0)

         in = in + 1
         hkl_comp(1,in) = hl
         hkl_comp(2,in) = kl 
         hkl_comp(3,in) = ll
         comp_numb(in) = abs(icomp)
         if(icomp.gt.0) then
            ii = ii  + 1
            if(ii.gt.nobs) then
               write(*,*)'Problem in reading hklf 5 file'
               ierr = 1
               return
            endif
            iobs(1,ii) = fol
            iobs(2,ii) = sol
            nref_comp(ii+1) = in
         endif
         read(in_file,'(3I4,2F8.2,I4)',iostat=ios)hl,kl,ll,fol,sol,icomp
         if(ios.gt.0) goto 102
      enddo
      close(in_file)
      return
 102  continue
                                !
      ierr = 1
      close(in_file)
      stop 'Problem with hklf 5 file'
      return
      end

 
      subroutine read_hklf5_size(nobs,ncomp,n_twins,ierr,input_file)
c
c---This subroutine reads hklf 5 file of observations and find the size
C---of observations
c
      implicit none
      integer ierr
      integer nobs,ncomp,n_twins
      character input_file*(*)

      character*4 text
      integer num,icomp,ist
      integer hl,kl,ll
      real fol,sol      
c
      integer in_file
C
      call open_form_file(in_file,input_file,ierr)
c      read(11,'(a4,i2)')text,num
c      if(text.ne.'HKLF'.or.num.ne.5 ) then
c        write(*,*)'Incorrect file.'
c        ierr = 1
c        return
c      endif
            
      nobs = 0
      ncomp = 0
      n_twins = 1
      read(in_file,'(3I4,2F8.2,I4)',iostat=ist) hl,kl,ll,fol,sol,icomp
      if(ist.gt.0) goto 102
      do while((hl.ne.0.or.kl.ne.0.or.ll.ne.0).and.ist.eq.0)
         ncomp = ncomp + 1
         n_twins = max(n_twins,abs(icomp))
         if(icomp.gt.0) then
            nobs = nobs  + 1
         endif
         read(in_file,'(3I4,2F8.2,I4)',iostat=ist) hl,kl,ll,fol,sol,
     &        icomp
         if(ist.gt.0) goto 102
      enddo
      close(in_file)
      return
 102  write(*,*)'Error in reading HKLF 5 file'
      ierr = 1
      return
      end
