module weights
!
!---Common blocks for weighting different residuals
!
! depends on models.fh 
!
! WDSKAL      overall weight for distances
! SIGD        overall sigma for bond distances
!....
!------------------------------------------------------
  implicit none

  ! sigb_kl - weights on kullbeck-liebler divergence (bvalue restraints)
  real sigb_kl(6),sigr_kl(6)
  real sigm_enm                    !  weight on elastic network model. It is redundant now
  real dvdw_cut_min,dvdw_cut_min_x    
  real sd_ext_min, sd_ext_cut      !  weights for external restraints. minimum sigma and cutoff level for distance deviation
  real delta_ext,dmax_ext,dmin_ext  ! External restraints
  real sigma_dist_r,dmax_dist_r,sigma_pos_r,sigma_b_r  ! Weights for ridge type restraints
  real sigx_ncs_local,dmax_ncs_local,diffmax_ncs_local  ! Parameters for ncs local restraints
  real wdskal,wdskal2,wbskal,wpskal,wbs_rigid_b,sigsph,sig_rigid_b  !  Old restraints. Most of them are redundant
  real wcskal,wvskal,wtskal,wsskal,sigc,sigpp,sigpa,waskal          !
  real dinc_dummy,vdw_sdi_dummy

  real w_gm_in
  real sigd(9),sigt(4),sigb(8),sigs(6),vdw_sdi_vdw,vdw_sdi_torsion
  real vdw_sdi_hbond,vdw_sdi_metal,hbond_dinc_ad,hbond_dinc_ah
  real dinc_torsion,dinc_torsion_o,dinc_torsion_n,dinc_torsion_c,dinc_torsion_all

  integer, parameter :: maxbin=500
  integer, parameter :: maxbin_2 = 56
  integer, parameter :: nmaxp1 = 5
  integer, parameter :: nmax_sig = 6
  integer, parameter :: maxn_model_secder = 4
  ! warning: another MAXN_MODELS is defined in weights.fh (these two should be identical though)
  
  real weightxmat,weightauto
  real zb_mx,zb_mn,zb_reduce,zb_increas

  logical lexpuse,mlexpuse
  character(len=4) :: weight,sigma_refine_style,weight_adjust
  character(len=4) :: bint,refs
  real pdel,bdel,qdel
  integer nbin,nbin_ml,nbin_ml2,nbin_rad,nbin_ml1
  integer nref_ml(maxbin+1)
  real s_rad,b_rad
  real sminb(maxbin+1),smaxb(maxbin+1),sminb_ml(maxbin+1),smaxb_ml(maxbin+1),smeanb_ml(maxbin+1),smeanb2_ml(maxbin+1)
  real scale_ml(maxbin+1,nmaxp1+1),sigma_ml(maxbin+1),sigma_ml1(maxbin+1),sigma_ml_bin(maxbin+1)
  real sminb_ml2(maxbin_2+1),smaxb_ml2(maxbin_2+1),smeanb_ml2(maxbin_2+1),scale_ml2(maxbin_2+1,nmaxp1+1)
  real smeanb_rad(maxbin+1)
  real resmax,resmin,smins,smaxs,binsize_ml,stlmin_ml,stlmax_ml
  real kernel_g,kernel_g_rad

  REAL D_ML_SCALE_OVER,D_ML_B_OVER,D_ML_SCALE_BBULK,D_ML_B_BBULK
  REAL D_ML_SCALE_PART(NMAXP1),D_ML_B_PART(NMAXP1)
  REAL SIGMA_ML_SCALE_OVER,SIGMA_ML_B_OVER,SIGMA_ML_B1_OVER
  REAL SIGMA_ML_B2_OVER
  REAL SIGMA_ML_SCALE_BBULK,SIGMA_ML_B_BBULK
  REAL SMIN_TCH,SMAX_TCH
  REAL SCALE_SEC,B_SEC,B1_SEC,B2_SEC
  INTEGER N_POINTS_TABLE_S
  REAL DELTA_S_TABLE
  real SEC_TABLE_SMOOTH(10000,MAXN_MODEL_secder)
  real SEC_TABLE_SMOOTH_pp(10000,MAXN_MODEL_secder)
  !
  LOGICAL ML_BULK_REFINE_FLAG,ML_PART_REFINE_FLAG(NMAXP1)
  LOGICAL ML_SIGMA_BULK_REFINE_FLAG

  !
  !---Factor for Tasos to test
  REAL TASOSFACTOR
  !
  real SEC_DER_BIN(MAXBIN+1,MAXN_MODEL_secder)
  real SEC_DER_BIN_pp(MAXBIN+1,MAXN_MODEL_secder)
  INTEGER NREF_SEC_BIN(MAXBIN+1,MAXN_MODEL_secder)
  real w_ave
  !
  REAL SIGN(MAXBIN),SIGP(MAXBIN),SIGN2(MAXBIN),SIGN2P(MAXBIN)
  real DSIGP2(MAXBIN),SIGi(MAXBIN),SIGP12(MAXBIN),SIGH(MAXBIN)
  REAL SIGP2(MAXBIN,NMAXP1), MAX_SC_ML, MIN_SC_ML, SIGP2P(MAXBIN)
  real SIGM_N(MAXBIN_2,NMAX_SIG), SIGM_P(MAXBIN_2,NMAX_SIG)
  !
  !---Things related with local tls
  integer :: local_tls_pairs = 0
  real :: local_tls_dist=6,local_tls_weight=1.0

  contains
    subroutine initilise_weights
      implicit none

    end subroutine initilise_weights
end module weights
