c
      subroutine random_integrate

      real toler
c
      real a_sqrt1(3,3),a_sqrt2(3,3),anondiag(3,3),am_loc(3,3)

      real, allocatable :: am_cond(:,:,:)
      real, allocatable :: am(:)
      real, allocatable :: v(:)
      real, allocatable :: dv(:)

      toler = 1.0e-8
c
      CALL ANALYSE_VDW(dmin_vdw)
      call get_dist_list(ndist_l)
      call get_dist_list(ndist_l)
      ndist_l = ndist_l+2
      call find_ndist_all(ndist_l)

      qqm = 30*n_atom_tot + 90*ndist_l
      allocate(am(qqm))
      allocate(v(qqv))
      allocate(dv(qqv))
      am(1:qqm) = 0.0
      CALL RESIDVAL(F0,qqm,qqv,am,v,dv,nmodel)
c
      lm = 1
      allocate(am_cond(3,3,n_atom)
      do ia=1,n_atom
         if(atom_ref_flag(ia).gt.0) then
            am_loc(1,1) = am(lm)
            am_loc(2,2) = am(lm+1)
            am_loc(3,3) = am(lm+2)
            am_loc(1,2) = am(lm+3)
            am_loc(1,3) = am(lm+4)
            am_loc(2,3) = am(lm+5)
            am_loc(2,1) = am_loc(1,2)
            am_loc(3,1) = am_loc(1,3)
            am_loc(3,2) = am_loc(2,3)
            call inv_sqrt_mat(toler,3,am_loc,am_sqrt)
            am_cond(1:3,1:3,ia) = am_sqrt(1:3,1:3)
            am(lm:(lm+2)) = 1
            am((lm+3):(lm+5)) = 0.0
            lm = lm + 6
         endif
      enddo
      lm0 = lm
      do id=1,ndist
         ko = n_object(id)
         kt = n_target(id)
         j=0
         do i1=1,3
            do i2=1,3
               anondiag(i1,i2) = am(lm+j)
               j = j + 1
            enddo
         enddo
         am_sqrt1(1:3,1:3) = am_cond(1:3,1:3,ko)
         am_sqrt2(1:3,1:3) = am_cond(1:3,1:3,kt)
         atemp(1:3,1:3) = matmul(matmul(am_sqrt1,anondiag),am_sqrt2)
         j = 0
         do i1=1,3
            do i2= 1,3
               am(lm+j) = atemp(i1,i2)
            enddo
         enddo
         lm = lm + 9
      enddo
c
c---  Preconditioned matrix is ready for sampling
      allocate(ndist_per_atom(n_atom))
      do id=1,ndist
         ko = n_object(id)
         kt = n_target(id)
         ndist_per_atom(ko) = ndist_per_atom(ko) + 1
         ndist_per_atom(kt) = ndist_per_atom(kt) + 1
      enddo
      maxdist = max_val(ndist_per_atom(1:n_atom))
      allocate(ref_2_dist(maxdist,n_atom))
      allocate(ref_2_mat(ndist))
      lm = lm0
      do id=1,ndist
         ko = n_object(id)
         kt = n_target(id)
         ndist_per_atom(ko) = ndist_per_atom(ko) + 1
         ref_2_dist(ndist_per_atom(ko),ko) = id
         ndist_per_atom(kt) = ndist_per_atom(kt) + 1
         ref_2_dist(ndist_per_atom(kt),kt) = id
         ref_2_mat(id) = lm
         lm = lm + 9
      enddo

      allocate(xrand(3,n_atom))
      xrand(1:3,1:n_atom) = 0.0
      xyz_init(1:3,1:n_atom) = xyz_crd(1:3,1:n_atom)

      nburn = 100
      call gauss_sample(n_atom,xrand,ndist,maxdist,n_object,
     &     n_target,ndist_per_atom,ref_2_dist,ref_2_mat,am,nburn,sigma)
      do ia=1,n_atom
         xrand1(1:3) = matmul(am_cond(1:3,1:3,ia),xrand(1:3,ia))
         xyz_crd(1:3,ia) = xyz_init(1:3,ia) + xrand1(1:3)
      enddo
c
      deallocate(am_cond)
      deallocate(xrand)
      deallocate(xyz_init)
      deallocate(ndist_per_atom)
      deallocate(ref_2_dist)
      deallcate(ref_2_mat)

      return
      end
c
      subroutine gauss_sample(n_atom,xrand,ndist,maxdist,
     &     n_object,n_target,ndist_per_atom,ref_2_dist,
     &     ref_2_mat,am,n_burn,sigma)
      implicit none
c
      integer n_atom
      real xrand(3,n_atom)
      integer ndist
      integer n_object(ndist),n_target(ndist),ref_2_mat(ndist)
      integer maxdist
      integer ndist_per_atom(n_atom),ref_2_dist(maxdist,n_atom)
      real am(*)
c
c--   Parameters of random number generator
      integer n_burn,sigma
c
c---  Sampling using gauss markov random field. It is assumed that we have 
c---  sparse matrix with blocks. Each block is 3x3 matrix. Diagonal blocks are 
c---  identity matrix. 
c
c---  locals
      integer ib,ia,ic,id,id1,i1,i2
      real xmean(3),x_this(3),anondiag(3,3)
c
c---  body
      do ib=1,n_burn+1
         do ia=1,n_atom
            xmean(1:3) = 0.0
            do id=1,ndist_per_atom(ia)
               id1 = ref_2_dist(ia,id)
               if(n_target(id1).eq.ia) then
                  x_this(1:3) = xrand(1:3,n_object(id1))
                  ic = ref_2_mat(id1)
                  do i1=1,3
                     do i2=1,3
                        anondiag(i1,i2) = am(ic)
                        ic = ic + 1
                     enddo
                  enddo
               elseif(n_object(id1).eq.ia) then
                  x_this(1:3) = xrand(1:3,n_target(id1))
                  ic = ref_2_mat(id1)
                  do i1=1,3
                     do i2=1,3
                        anondiag(i2,i1) = am(ic)
                        ic = ic + 1
                     enddo
                  enddo
               endif
               xmean(1:3) = xmean(1:3) + 
     &              matmul(anondiag(1:3,1:3),x_this(1:3))
            enddo
            call random_numbers_gauss(3,x_this)
            x_this = x_this*sigma
            xrand(1:3,ia) = x_this(1:3) + xmean(1:3)
         enddo
      enddo
      
      return
      end
c
c---Basic routines
      subroutine random_vector_gauss(nrand,x_this)
      implicit none
c
c---Generate a vector of gaussian random numbers. 
      integer nrand
      real x_this(nrand)

      integer ir
      real gauss_random


      do ir=1,nrand
         x_this(ir) =  gauss_random()
      enddo

      return
      end
c
      real function gauss_random()
      implicit none
c
c---  Gaussian random number generator. It uses random_number and generates
c--   two random numbers. For gaussian random numbers Box and Miller 
c---  transformation is used
      real x
c
      real w
      real xrand(2)

      integer ihave
      real rand
      save ihave,rand
      data ihave/0/

      if(ihave.eq.0) then
         w = 2.0
         do while (w.gt.1.0) 
            call random_number(xrand)
            w = 4.0*(xrand(1)-0.5)**2+(xrand(2)-0.5)**2
         enddo
         w = sqrt((-2.0*log(w))/w)
         gauss_random = xrand(1)*w
         rand = xrand(2)*w
         ihave = 1
      else
         gauss_random = rand
         ihave = 0
      endif

      return
      end
