module map_routines
  real :: scale_map_obs=0.0
  real :: scale_map_calc=0.0
  real :: b_sharp_map = 0.0
  real :: alpha_sharp_map=0.0
  character(len=1) :: free_for_map='R'
  logical :: sharp_regul_opt=.TRUE.
  logical :: sharp_map_flag=.FALSE.

  contains
    subroutine ts_filter_parameters(fo,sigo,fc,fom,sigma,rsq)
      implicit none

      !
      !  Calculate Tikhonov (Sobolev) reguliser parameter for sharpening

      real, intent(in) :: fo(:),sigo(:),fom(:),fc(:),sigma(:),rsq(:)
      !
      !   Locals
      integer i,ir
      integer nref,nmax
      real prerr,prerr_old
      real(kind=8) :: delt2,filt1,filt2,fwt,gg1,rsqmax
      real gamma,dgamma,dmax
      real(kind=8), allocatable :: gsharp(:)
      logical observed
      !
      !   Body
      nref = size(fo)
      gamma=0.0
      prerr_old = 0.0
      do ir = 1,nref
         delt2 = fo(ir)**2-2.0*fom(ir)*fc(ir)+fc(ir)**2
         prerr_old = prerr_old + delt2
      enddo

      prerr = prerr_old+1.0
      dgamma = 0.001
      dmax = 5.0
      nmax = dmax/dgamma
      prerr_old = 0.0
      allocate(gsharp(nref))
      gsharp(1:nref) = exp(-b_sharp_map*rsq(1:nref)/4.0)
      rsqmax = maxval(rsq(1:nref))

!      open(44)
      do i=1,nmax
         !while(prerr.lt.prerr_old)
         prerr_old = prerr

         prerr = 0.0
         gamma = gamma+dgamma
         do ir=1,nref
            gg1 = gsharp(ir)**2+gamma*rsq(ir)
            filt1 = gamma*rsq(ir)/gg1
            filt2 = gsharp(ir)**2/gg1
            if(sigo(ir).gt.0.0) then
               delt2 = fo(ir)**2-2.0*fom(ir)*fo(ir)*fc(ir)+fc(ir)**2
               fwt = 2.0*fom(ir)*fo(ir)-fc(ir)
               prerr = prerr + (filt1**2*fwt**2+2.0*filt2*delt2)/nref
               !write(*,*)'Observerd ',prerr,fo(ir),sigo(ir),rsq(ir),fc(ir),fom(ir),sigma(ir)
            else
               prerr = prerr + (filt1**2*fc(ir)**2+2.0*filt2*sigma(ir))/nref
               !write(*,*)'Unobserved ',fc(ir),rsq(ir),sigma(ir)
            endif
         enddo
         !stop
         if(prerr.gt.prerr_old) then
            gamma = gamma - dgamma
            prerr = prerr_old
            exit
         endif
         !write(*,*)gamma,prerr
         !write(44,*)gamma,prerr
         !
         !   Add series termination effect
      enddo
      alpha_sharp_map = gamma
      call header('Filter parameters')
      write(*,*)'B value for sharpening   = ',b_sharp_map
      write(*,*)'Regularisation parameter = ',alpha_sharp_map
      write(*,'(2x,80a)')('-',i=1,80)
!      close(44)
      
      deallocate(gsharp)
!      stop
    end subroutine ts_filter_parameters

  end module map_routines
