C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      subroutine generate_enm_restraints
      use restr_files
      implicit none
c
      include 'atom_com.fh'
      include 'refi_flags.fh'
      include 'weights.fh'
c
c---  locals
      integer iv,ib
      integer iscrv,iscrb,ifail
      integer nr_vdw,nr_vdw1,nr_bond,nr_bond1
      real dmin_vdw
c
c--
      integer ia1(2),it_s(4),ityp
      real    rs_vidl(3)
c
c---  
      integer ib_t_gen
      integer ich1,ich2
      real dist
      real xyz_t1(3),xyz_t2(3)
      character chnm1*4,chnm2*4
c
c---  bonds
      integer, allocatable :: ia1_b(:,:)
      integer, allocatable :: ib_s(:,:)
      integer, allocatable :: ib_type(:)
      real,    allocatable :: rs_vidl_b(:,:)
c
c---  vdws
      integer, allocatable :: ia1_v(:,:)
      real,    allocatable :: rs_vidl_v(:,:)
      integer, allocatable :: iv_s(:,:)
      integer, allocatable :: ivdw_t(:)
c
c---  body
      if(.not.enm_restr_flag) return
c
c--It needs to be set outside this routine.
      ib_t_gen = 3
c
c---  It needs to be defined to some larger value
      dmin_vdw = 0.0
      call analyse_vdw(dmin_vdw)
c
c---  Flexible NCS here also? Anything else
      call flexible_ncs_pairs

      call open_unform_file(iscrv,vdw_file,ifail)
      if(ifail.gt.0) then
         call errwrt(1,'Problem with vdw_file')
      endif
      call open_unform_file(iscrb,bond_file,ifail)
      if(ifail.gt.0) then
         call errwrt(1,'Problem with bond_fole')
      endif
      read(iscrb) nr_bond
      do ib=1,nr_bond
         read(iscrb)ia1(1:2),rs_vidl(1:2),it_s(1:4),ityp
      enddo

      read(iscrv)nr_vdw
      allocate(ia1_v(2,nr_vdw))
      allocate(rs_vidl_v(3,nr_vdw))
      allocate(iv_s(4,nr_vdw))
      allocate(ivdw_t(nr_vdw))

      nr_vdw1 = 0
      nr_bond1 = nr_bond
c
c---  If atoms are not related by symmetry and they belong to the same chain
c---  and they are not mutually exclusive then add to the list of bonds
      do iv=1,nr_vdw
         read(iscrv)ia1_v(1:2,iv),rs_vidl_b(1:3,iv),iv_s(1:4,iv),
     &        ivdw_t(iv)
         if(iv_s(1,iv).eq.1.and.iv_s(2,iv).eq.0.and.iv_s(3,iv).eq.0
     &        .and.iv_s(4,iv).eq.0) then
            ich1 = i_chain(i_resid(ia1_v(1,iv)))
            ich2 = i_chain(i_resid(ia1_v(2,iv)))
            call get_asm_group_id(chnm1,ich1)
            call get_asm_group_id(chnm2,ich2)
            if(chnm1.eq.chnm2) then
c
c---Put another condition. Atoms should not be mutually exclusive. We need to work
c---  corr_id that defines mutual excusivness
c               If((corr_id(ia1_v(1,iv)).eq.0.or.
c     &              corr_id(ia1_v(2,iv)).eq.0).or.
c     &              (corr_id(ia1_v(1,iv)).eq.corr_id(ia1_v(2,iv)))) then
               if(i_resid(ia1_v(1,iv)).ne.i_resid(ia1_v(2,iv)).or.                   &
     &              i_resid(ia1_v(1,iv)).eq.i_resid(ia1_v(2,iv)).and.
     &              id_alt(ia1_v(1,iv)).eq.id_alt(ia1_v(2,iv))) then
                  xyz_t1(1:3) = xyz_crd(1:3,ia1_v(1,iv))
                  xyz_t2(1:3) = xyz_crd(1:3,ia1_v(2,iv))
                  dist = sqrt(sum((xyz_t1(1:3)-xyz_t2(1:3))**2))
                  write(iscrb)ia1_v(1:2,iv),dist,sigma_enm,ib_t_gen
                  ivdw_t(iv) = -1
               endif
            endif
         endif
         if(ivdw_t(iv).gt.0)nr_vdw1 = nr_vdw1+1
      enddo
c
c---Write remaining nondbonds
      rewind(iscrv)
      write(iscrv)nr_vdw1
      do iv=1,nr_vdw
         if(ivdw_t(iv).gt.0) then
            write(iscrv)ia1_v(1:2,iv),iv_s(1:4,iv),rs_vidl_v(1:3,iv),
     &           iv_s(1:4,iv),ivdw_t(iv)
         endif
      enddo
      close(iscrv)
      deallocate(ia1_v)
      deallocate(rs_vidl_v)
      deallocate(iv_s)
      deallocate(ivdw_t)
c
c---Read and write bonds agains
      rewind(iscrb)
      allocate(ia1_b(2,nr_bond1))
      allocate(ib_s(4,nr_bond1))
      allocate(ib_type(nr_bond1))
      allocate(rs_vidl_b(2,nr_bond1))
      rewind(iscrb)
      read(iscrb) nr_bond
      do ib=1,nr_bond1
         read(iscrb)ia1_b(1:2,ib),ib_s(1:4,ib),
     &        rs_vidl_b(1:2,iv),ib_type(iv)
      enddo
      rewind(iscrb)
      write(iscrb)nr_bond1
      do ib=1,nr_bond1
         read(iscrb)ia1_b(1:2,ib),ib_s(1:4,ib),
     &        rs_vidl_b(1:2,iv),ib_type(iv)
      enddo
      close(iscrb)
      deallocate(ia1_b)
      deallocate(ib_s)
      deallocate(ib_type)
      deallocate(rs_vidl_b)
      return
      end
c
      subroutine flexible_ncs_pairs
      implicit none

      return
      end
