C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C ******
C -P-
C -P------   SUBROUTINES DEPENDED ON SYSTEM --------------------
C -P-
C      CVX - for VMS VAX 
C      CDP - for unix system
C      CMS - for MS-DOS
C      CLN - for Linux 
C ******

      SUBROUTINE GET_PATH(MDOC,NAME,PATH,IERR)
C ----------------------------------------
C
C -P- GET_PATH - call getenv / get BLANC - path of blanc directory /
C
      CHARACTER NAME*(*),PATH*(*)
C ******
C ----------------------------------------
C     / setenv BLANC ~alexei/blanc /
C     CALL GET_PATH('BLANC',LINE)
C     LINE='~alexei/blanc' 
C ----------------------------------------
      CHARACTER LINE*256

cpjx Don't use temp_makefile_path.fh to set library path
cpjx      INCLUDE "temp_makecif_path.fh"
C ------------------------------------
      IERR=0

C -- 24.01.2010
c      CALL UGTENV(NAME,LINE)
c      CALL LENSTR_BL(LINE,LEN)
c      IF(LEN.LE.0) THEN
cpjx  MAKECIFLIB would be set in temp_makefile_path.fh
cpjx  but this is unsafe - get the path from the CLIBD_MON
cpjx  variable instead.
cpjx        PATH=MAKECIFLIB
c        CALL UGTENV('CLIBD_MON',LINE)
c        PATH=LINE(1:LENSTR(LINE))
c      ELSE
c        PATH=LINE(1:LEN)
c      ENDIF

      CALL GETENV(NAME,LINE)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.LE.0) THEN
        CALL GETENV('CLIBD_MON',LINE)
        CALL LENSTR_BL(LINE,LEN)
      ENDIF 
      PATH=LINE(1:LEN)


      RETURN
      END

C ******
      SUBROUTINE DISPL_BL(LINE)
C
C -P- DISPL_BL - write message to terminal and stop cursor at the end of line.
C
C             NOTE : for Linux ( CLN ) cursor will not stop
C                    at the end of line.
C
      CHARACTER LINE*(*)
      INTEGER*4 NL
C ----------------------------
      CALL LENSTR_BL(LINE,NL)
      IF(NL.GT.79) NL=79

CVX   WRITE(*,'(''$'',A)')   LINE(1:NL)
      WRITE(*,'('' '',A,$)') LINE(1:NL)
CMS   WRITE(*,'('' '',A,\)') LINE(1:NL)
CLN   WRITE(*,'('' '',A)')   LINE(1:NL)
      RETURN
      END
C ******

C ******
      SUBROUTINE CLOCK(IH)
C
C -P- CLOCK - get date to --> array IH()
C
C    IH(2),IH(3),IH(4),    IH(5),IH(6),IH(7)
C     sec   min  hour      day   month year
C
      INTEGER*4 IH(7)
      integer   date_time(8)
      character r(3)*12

      call date_and_time(r(1),r(2),r(3),date_time)
      ih(7) = date_time(1)
      ih(6) = date_time(2)
      ih(5) = date_time(3)
      ih(4) = date_time(5)
      ih(3) = date_time(6)
      ih(2) = date_time(7)
      ih(1) = 0
      RETURN
      END


C ===============================================================

      SUBROUTINE GETNOS(CH3)
C
C -P- GETNOS - get name of operating system
C
      CHARACTER CH3*3
C --------------------------------
CMS   CH3='MSD'      
CVX   CH3='VAX'      
      CH3='UNX'      
CLN   CH3='LIN'      
      RETURN
      END

CMS   SUBROUTINE EXIT
CMS   STOP
CMS   END

C -- 24.01.2010
C ===============================================================

      SUBROUTINE UPC_BL(STRING)
C
C---- Returns uppercase string
C
      CHARACTER STRING* (*)

      INTRINSIC LEN

      DO I = 1,LEN(STRING)
        J = ICHAR( STRING(I:I) )
        IF( 97.LE.J .AND. J.LE.122 ) STRING(I:I) = CHAR(J-32)
      END DO

      END

C ===============================================================
C ^^ 24.01.2010


