C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      subroutine rharvest(Nflag)
      use solvent_all
C
C----Prepares and write info for harvesting required by EBI
C----This routine is based on sharvest of scala.
C----
      implicit none

      INCLUDE 'atom_com.fh'
      include 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'ncs_rest.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif.fh'
      include 'rharvest.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      INCLUDE 'makecif_version.fh'

      INTEGER Nflag,KKFlag,Kharvest
      INTEGER IHFLAG
      INTEGER CHMODRET,IFAIL,IMAGE1,IMAGE2,JDO,LL,MKDIRPT,
     &        ISC,II
      LOGICAL ISITVAX,LEXISTS,ALLDONE,DOHARVEST,VAXVMS
      CHARACTER CIFTIME*50,BUFFER*256,
     +          FILENAME*256,HOMEDIR*256,Hversion*256,
     +          mkdirMode*3,chmodMode*3,ALL_CHAINS*50,CHAR_NCS*5
     
      INTEGER LEN_H,ISH,IREST,INCS,INCH,ISPAN,ITLS,IGRP1
      REAL RTD2,S_TENS(3,3),B_OVER_COOR
 
      INTEGER CHMOD,MKDIR,ICC,NB1
      EXTERNAL HCIFTIME,VAXVMS
      CHARACTER versn*10,vrdate*10

      versn = R_VERSNO
      vrdate = '24/04/2001'
      MKDIRMODE = '700'
      CHMODMODE = '755'
      RTD2 = RTODEG*RTODEG
      NB1  = NBIN + 1
c
c--- initialise      
      IF (NFLAG .eq. 0) then
         PRIVATE        = .FALSE.
         USECWD         = .false.
         NOHARVEST      = .false.
         PNAME_KEYWRD   = ' '
         DNAME_KEYWRD   = ' '
         NROWLIMIT      = 132
         GOT_PNAME = .false.
         GOT_DNAME = .false.
         HNSHELL        = -999
         NCYCLE_OVERALL = 0
         HNRESTR        = 0
         DO    ISH = 1,HMAXSHELL
            HD_SHELL_HIGH(ISH)     = -999.00
            HD_SHELL_LOW(ISH)      = -999.00
            HNREF_SHELL_ALL(ISH)   = -999
            HNREF_SHELL_OBS(ISH)   = -999
            HNREF_SHELL_WORK(ISH)  = -999
            HPERC_SHELL_REFL(ISH)  = -999.00
            HRFAC_SHELL_ALL(ISH)   = -999.00
            HRFAC_SHELL_OBS(ISH)   = -999.00
            HNREF_SHELL_FREE(ISH)  = -999
            HRFAC_SHELL_FREE(ISH)  = -999.00
            HRFAC_SHELL_WORK(ISH)  = -999.00
            HWRFAC_SHELL_ALL(ISH)  = -999.00
            HWRFAC_SHELL_OBS(ISH)  = -999.00
            HWRFAC_SHELL_WORK(ISH) = -999.00
         ENDDO
         NHREFL_WORK     = -999
         NHREFL_FREE     = -999
         HD_HIGH         = -999.00
         HD_LOW          = -999.00
         RFACTOR_WORK    = -999.00
         RFACTOR_FREE    = -999.00
         RWFACTOR_WORK   = -999.00
         RWFACTOR_FREE   = -999.00
         PERC_FREE       = -999.00
         HCORR_FOFC      = -999.00
         HCORR_FOFC_FREE = -999.00
         HESU_CRUIC      = -999.00
         HESU_FREE       = -999.00
         HESU_ML         = -999.00
         HESU_ML_B       = -999.00
C
         DO   IREST = 1,HMAXREST
           HRESTR_TYPE(IREST)     = '?'
           HRESTR_NUM(IREST)     = -999
           HRESTR_IDEAL(IREST)   = -999.00
           HRESTR_DEV(IREST)     = -999.00
           HRESTR_DEVITAR(IREST) = -999.00
           HRESTR_CRIT(IREST)    = ' ? '
           HRESTR_REJ(IREST)     = ' ? '
         ENDDO
         DO   ICC = 1,NMAX_CYCLE
           RFACTOR_VS_CYCLE(ICC) = -999.0
           LLG_VS_CYCLE(ICC)    =  -9999999.0
           LLGFREE_VS_CYCLE(ICC) =  -9999999.0
           RFREE_VS_CYCLE(ICC)   = -999.0
           BOND_VS_CYCLE(ICC)    = -999.0
           ANGLE_VS_CYCLE(ICC)   = -999.0
           CHIR_VS_CYCLE(ICC)    = -999.0
           ZBOND_VS_CYCLE(ICC)    = -999.0
           ZANGLE_VS_CYCLE(ICC)   = -999.0

         ENDDO
         RETURN
      END IF
C
C  If NOHARVEST keyword specified, switch off harvesting by setting
C  ProjectName and DataSetName to ' '
      IF (NOHARVEST) THEN
        PNAME_KEYWRD = ' '
        DNAME_KEYWRD = ' '
      ENDIF
C
      ISITVAX = VAXVMS()
C
C---- is there a projectname
C
      IF (PNAME_KEYWRD(1:1).EQ.' ') THEN
        WRITE (6,FMT=6004)
 6004   FORMAT (
     +' Harvest: NO PNAME_KEYWRD given - no deposit file created')
        DOHARVEST = .false.
        RETURN
      END IF
C
C---- is there a DNAME_KEYWRD
C
      IF (DNAME_KEYWRD(1:1).EQ.' ') THEN
        WRITE (6,FMT=6006)
 6006   FORMAT (
     +' Harvest: NO DNAME_KEYWRD given - no deposit file created')
        DOHARVEST = .false.
        RETURN
      END IF
C
C---- get correct time format
      CALL HCIFTIME(CIFTIME)
C
      IF (UseCWD) THEN
        IF ( .not. ISITVAX) THEN
          FileName = 
     +           './'//trim(DNAME_KEYWRD)//'.refmac'
        ELSE
          FileName = trim(DNAME_KEYWRD)//'.refmac'
        END IF
      ELSE
        Buffer = ' '
C
        CALL getenv('HARVESTHOME',Buffer)
C
C    If HARVESTHOME not set, default to HOME
        IF (Buffer .eq. ' ') THEN
          IF (ISITVAX) THEN
            CALL getenv('SYS$LOGIN',Buffer)
          ELSE
            CALL getenv('HOME',Buffer)
          END IF
C
          IF (Buffer .eq. ' ') THEN
            WRITE (6,FMT=6005)
 6005       FORMAT (
     +' Harvest: No HARVESTHOME or HOME environment variable found - ',
     +               'no deposit file created')
            Doharvest = .false.
            RETURN
          END IF
        END IF
C
C---- see if $HARVESTHOME/DepositFiles directory exists
C
        IF (ISITVAX) THEN
          FileName = trim(Buffer)//':[DepositFiles]'
        ELSE
          FileName = trim(Buffer)//'/DepositFiles'
        END IF
C
        CALL cmkdir(trim(FileName),mkdirMode,mkdirPT)
        IF (mkdirPT .lt. 0) THEN
            WRITE (6,FMT=6007)
 6007       FORMAT (
     +' Harvest: Cant mkdir HARVESTHOME/DepositFiles - ',
     +           'no deposit file created')
            Doharvest = .false.
            RETURN
        END IF
C
C--- world read for directory?
C
        IF (.NOT. Private) THEN
            CALL cchmod(trim(FileName),chmodMode,chmodRet)
            IF (chmodRet .ne. 0) THEN
              WRITE (6,FMT=6008)
 6008         FORMAT (
     +' Harvest: Cant chmod HARVESTHOME/DepositFiles to world',
     +               ' read - no deposit file created')
              Doharvest = .false.
              RETURN
            END IF
        END IF
C
C---- now look for ProjectName sub-directory
C
        IF (ISITVAX) THEN
          FileName = FileName(1:len_trim(FileName)-1)//'.'//
     +               trim(PNAME_KEYWRD)//']'
        ELSE
          FileName = trim(FileName)//'/'//
     +               trim(PNAME_KEYWRD)
        END IF
C
        CALL cmkdir(trim(FileName),mkdirMode,mkdirPT)
        IF (mkdirPT .lt. 0) THEN
            WRITE (6,FMT=6010) trim(PNAME_KEYWRD)
 6010       FORMAT (
     +' Harvest: Cant mkdir HARVESTHOME/DepositFiles/',a,
     +           ' - no deposit file created')
            Doharvest = .false.
            RETURN
        END IF
C
C--- world read for directory?
C
        IF (.NOT. Private) THEN
            CALL cchmod(trim(FileName),chmodMode,chmodRet)
            IF (chmodRet .ne. 0) THEN
              WRITE (6,FMT=6012) trim(FileName)
 6012         FORMAT (
     +' Harvest: Cant chmod HARVESTHOME/DepositFiles/',a,' to',
     +               ' world read - no deposit file created')
              Doharvest = .false.
              RETURN
            END IF
        END IF
C
C---- now create FileName for deposit information
C
        IF (ISITVAX) THEN
          FileName = trim(FileName)//trim(DNAME_KEYWRD)//'.refmac'
        ELSE
          FileName = trim(FileName)//'/'//trim(DNAME_KEYWRD)//'.refmac'
        END IF
      END IF
C
      Doharvest = .true.
C
C---- now open file
C
      call open_form_file(kharvest,filename,ifail)
C
C
      Hversion = 'refmac_' // trim(versn) // '  ' //trim(vrdate)
      WRITE(Kharvest,8001) trim(PNAME_KEYWRD),
     +                     trim(DNAME_KEYWRD),
     +                     trim(PNAME_KEYWRD),
     +                     trim(DNAME_KEYWRD),
     +                     trim(CIFTIME),
     +                     trim(Hversion)
 8001 FORMAT(
     +'data_',a,'[',a,']',/,
     +'_entry.id                     ',a,/,
     +'_diffrn.id                    ',a,/,
     +'_audit.creation_date          ',a,/,
     +'_software.classification      ','refinement',/,
     +'_software.contact_author      ','''','Garib N. Murshudov','''',/,
     +'_software.contact_author_email garib@ysbl.york.ac.uk',/,
     +'_software.description ','''',
     +  '(un)restrained refinement or idealisation of macromolecular',
     +  'structures','''',/,
     +'_software.name       refmac',/,
     +'_software.version ','''',a,'''',/)

      WRITE(Kharvest,'(A,A,A,A,A,/)')'_computing.structure_refinement ',
     & '''','REFMAC ',trim(versn),''''
C
      IF(SOLVMIN.EQ.'CGMA') THEN
        WRITE(Kharvest,'(A,A,A,A)')'_refine.ls_matrix_type ',
     & '''','  Method of minimisation  : Sparse Matrix ',''''
      ELSEIF(SOLVMIN.EQ.'CDIR') THEN
        WRITE(Kharvest,'(A,A,A,A)')'_refine.ls_matrix_type ',
     & '''','  Method of minimisation  : Conjugate direction ',''''
      ELSEIF(SOLVMIN.EQ.'CGRA') THEN
        WRITE(Kharvest,'(A,A,A,A)')'_refine.ls_matrix_type ',
     & '''','  Method of minimisation  : Conjugate gradients ',''''
      ENDIF
      IF(MAKE_HFLAG.EQ.'Y') THEN
        WRITE(Kharvest,'(A,A,A,A)')'_refine.details ',
     & '''','HYDROGENS HAVE BEEN ADDED IN THE RIDING POSITIONS',''''
      ENDIF
      WRITE(Kharvest,*)
C
C---B values
      CALL FIND_B_OVER_COOR(B_OVER_COOR)
       WRITE(Kharvest,'(A,F10.3)')
     & '_refine.B_iso_mean        ',B_OVER_COOR
       IF(B_LS_ANISO_OVER_FLAG) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &       '_refine.aniso_B[1][1]     ',B_LS_ANISO_OVER(1)
         WRITE(Kharvest,'(A,F10.3)')
     &       '_refine.aniso_B[2][2]     ',B_LS_ANISO_OVER(2)
        WRITE(Kharvest,'(A,F10.3)')
     &       '_refine.aniso_B[3][3]     ',B_LS_ANISO_OVER(3)
        WRITE(Kharvest,'(A,F10.3)')
     &       '_refine.aniso_B[1][2]     ',B_LS_ANISO_OVER(4)
        WRITE(Kharvest,'(A,F10.3)')
     &       '_refine.aniso_B[1][3]     ',B_LS_ANISO_OVER(5)
        WRITE(Kharvest,'(A,F10.3)')
     &       '_refine.aniso_B[2][3]     ',B_LS_ANISO_OVER(6)
       ENDIF

       WRITE(Kharvest,*)
      IF(SOLVENT_FLAG.AND.NSCOPT.EQ.1.) THEN
        WRITE(Kharvest,'(A,A,A,A)')
     &      '_refine.solvent_model_details        ',
     &                       '''','BABINET MODEL PLUS MASK',''''
      ELSEIF(.NOT.SOLVENT_FLAG.AND.NSCOPT.EQ.1) THEN
        WRITE(Kharvest,'(A,A,A,A)')
     &      '_refine.solvent_model_details        ',
     &                       '''','BABINET MODEL',''''
      ELSEIF(SOLVENT_FLAG.AND.NSCOPT.EQ.0) THEN
        WRITE(Kharvest,'(A,A,A,A)')
     &      '_refine.solvent_model_details        ',
     &                       '''','MASK BULK SOLVENT',''''
      ELSEIF(.NOT.SOLVENT_FLAG.AND.NSCOPT.EQ.0) THEN
        WRITE(Kharvest,'(A,A)')
     &      '_refine.solvent_model_details        ','NONE'
      ENDIF

      IF(SOLVENT_FLAG) THEN 
      WRITE(Kharvest,'(A,F8.3)')
     &      '_refine.solvent_vdw_probe_radii         ',PROB_VDW
      WRITE(Kharvest,'(A,F8.3)')
     &      '_refine.solvent_ion_probe_radii         ',PROB_ION
      WRITE(Kharvest,'(A,F8.3)')
     &      '_refine.solvent_shrinkage_radii         ',RADII_SHRINK
      ELSE
      WRITE(Kharvest,'(A,A)')
     &      '_refine.solvent_vdw_probe_radii         ',' ? '
      WRITE(Kharvest,'(A,A)')
     &      '_refine.solvent_ion_probe_radii         ',' ? '
      WRITE(Kharvest,'(A,A)')
     &      '_refine.solvent_shrinkage_radii         ',' ? '
      ENDIF
      WRITE(Kharvest,*)
C
C---Write overall statistics
       IF(HD_HIGH.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F9.3)')
     &      '_refine.ls_d_res_high                   ',HD_HIGH
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_d_res_high                   ',' ? '
       ENDIF
       IF(HD_LOW.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F9.3)')
     &      '_refine.ls_d_res_low                    ',HD_LOW
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_d_res_low                    ',' ? '
       ENDIF
       IF(NHREFL_WORK.NE.-999) THEN
         WRITE(Kharvest,'(A,I10)')
     &      '_refine.ls_number_reflns_R_work         ',NHREFL_WORK
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_number_reflns_R_work         ',' ?'
       ENDIF
       IF(NHREFL_FREE.NE.-999) THEN
         WRITE(Kharvest,'(A,I10)')
     &      '_refine.ls_number_reflns_R_free         ',NHREFL_FREE
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_number_reflns_R_free         ',' ?'
       ENDIF
       IF(NHREFL_WORK.NE.-999 .AND. NHREFL_FREE.NE.-999) THEN
         WRITE(Kharvest,'(A,I10)')
     &      '_refine.ls_number_reflns_obs            ',
     &      NHREFL_WORK + NHREFL_FREE
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_number_reflns_obs            ',' ?'
       ENDIF

       IF(RFACTOR_WORK.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.4)')
     &      '_refine.ls_R_factor_R_work              ',RFACTOR_WORK
       ELSE
         WRITE(Kharvest,'(A,A)')
     &   '_refine.ls_R_factor_R_work                 ','?'
       ENDIF
       IF(RFACTOR_FREE.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.4)')
     &      '_refine.ls_R_factor_R_free              ',RFACTOR_FREE
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_R_factor_R_free              ','?'
       ENDIF
       IF(HRFAC_SHELL_ALL(NB1).GT.0.0) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &      '_refine.ls_R_factor_R_all               ',
     &           HRFAC_SHELL_ALL(NB1)
       ELSE
        WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_R_factor_R_all               ','?' 
       ENDIF

       IF(RWFACTOR_FREE.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &      '_refine.ls_wR_factor_R_work             ',RWFACTOR_WORK
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_wR_factor_R_work             ','?'
       ENDIF

       IF(RWFACTOR_FREE.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &      '_refine.ls_wR_factor_R_free             ',RWFACTOR_FREE
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_wR_factor_R_free             ','?'
       ENDIF
       IF(HNSHELL.GT.0 .AND. 
     &    HPERC_SHELL_REFL(HNSHELL+1).NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &      '_refine.ls_percent_reflns_obs           ',
     &      HPERC_SHELL_REFL(HNSHELL+1)
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_percent_reflns_obs           ','?'
       ENDIF
       IF(PERC_FREE.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &      '_refine.ls_percent_reflns_R_free        ',PERC_FREE
       ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.ls_percent_reflns_R_free        ','?'
       ENDIF

      IF(HCORR_FOFC.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &      '_refine.correlation_coeff_Fo_to_Fc   ',HCORR_FOFC
      ELSE
         WRITE(Kharvest,'(A,A)')
     &      '_refine.correlation_coeff_Fo_to_Fc   ','?'
      ENDIF

      IF(HCORR_FOFC_FREE.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &   '_refine.correlation_coeff_Fo_to_Fc_free ',HCORR_FOFC_FREE
      ELSE
         WRITE(Kharvest,'(A,A)')
     &   '_refine.correlation_coeff_Fo_to_Fc_free ','?'
      ENDIF    
   
      IF(HESU_CRUIC.GT.0.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &    '_refine.pdbx_overall_ESU_R ',HESU_CRUIC
      ELSE
         WRITE(Kharvest,'(A,A)')
     &    '_refine.pdbx_overall_ESU_R ','?'
      ENDIF    

      IF(HESU_FREE.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &    '_refine.pdbx_overall_ESU_R_Free              ',HESU_FREE
      ELSE
         WRITE(Kharvest,'(A,A)')
     &    '_refine.pdbx_overall_ESU_R_Free              ','?'
      ENDIF

      IF(HESU_ML.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &    '_refine.pdbx_overall_ESU_ML                 ',HESU_ML
      ELSE
         WRITE(Kharvest,'(A,A)')
     &    '_refine.pdbx_overall_ESU_ML                 ','?'
      ENDIF

      IF(HESU_ML_B.NE.-999.00) THEN
         WRITE(Kharvest,'(A,F10.3)')
     &    '_refine.pdbx_overall_ESU_B                  ',HESU_ML_B
      ELSE
         WRITE(Kharvest,'(A,A)')
     &    '_refine.pdbx_overall_ESU_B                  ','?'
      ENDIF
      WRITE(Kharvest,*)

      IF(HNSHELL.GT.0) THEN

       WRITE(Kharvest,'(A)')'loop_'
       WRITE(Kharvest,'(A)')
     +   '    _refine_ls_shell.pdbx_total_number_of_bins_used'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.d_res_low'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.d_res_high'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.number_reflns_all'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.percent_reflns_obs'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.number_reflns_R_work'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.R_factor_R_work'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.R_factor_R_all'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.number_reflns_R_free'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.R_factor_R_free'
       WRITE(Kharvest,'(A)')'    _refine_ls_shell.wR_factor_R_work'
       WRITE(Kharvest,'(A)')
C
C---loop over shell
       LEN_H = 0
       DO   ISH=HNSHELL,1,-1
         CALL WRITE_CIFLINE_INT(Kharvest,LEN_H,HNSHELL)
         CALL WRITE_CIFLINE_REAL(Kharvest,LEN_H,HD_SHELL_LOW(ISH))
         CALL WRITE_CIFLINE_REAL(Kharvest,LEN_H,HD_SHELL_HIGH(ISH))
         CALL WRITE_CIFLINE_INT(Kharvest,LEN_H,HNREF_SHELL_ALL(ISH))
         CALL WRITE_CIFLINE_REAL(Kharvest,LEN_H,HPERC_SHELL_REFL(ISH))
         CALL WRITE_CIFLINE_INT(Kharvest,LEN_H,HNREF_SHELL_WORK(ISH))
         CALL WRITE_CIFLINE_REAL(Kharvest,LEN_H,HRFAC_SHELL_WORK(ISH))
         CALL WRITE_CIFLINE_REAL(Kharvest,LEN_H,HRFAC_SHELL_ALL(ISH))
         CALL WRITE_CIFLINE_INT(Kharvest,LEN_H,HNREF_SHELL_FREE(ISH))
         CALL WRITE_CIFLINE_REAL(Kharvest,LEN_H,HRFAC_SHELL_FREE(ISH))
         CALL WRITE_CIFLINE_REAL(Kharvest,LEN_H,HWRFAC_SHELL_WORK(ISH))
         CALL WRITE_CIFLINE_END(Kharvest,LEN_H)
       ENDDO
      ENDIF
C
       WRITE(Kharvest,'(A)')
       WRITE (Kharvest,8002) cell
 8002  FORMAT(
     +'_cell.length_a      ',f9.3,/,
     +'_cell.length_b      ',f9.3,/,
     +'_cell.length_c      ',f9.3,/,
     +'_cell.angle_alpha   ',f9.3,/,
     +'_cell.angle_beta    ',f9.3,/,
     +'_cell.angle_gamma   ',f9.3,/)
C
cd       WRITE (Kharvest,8003) NSPGRP,SPGNAM
cd 8003  FORMAT(
cd     +'_Symmetry.Int_Tables_number     ',i4,/,
cd     +'_Symmetry.space_group_name_H-M  ','''',a,'''',/)
C
cloop_
c_Symmetry_equiv.id
c_Symmetry_equiv.pos_as_xyz
c1 X,Y,Z
c2 -X,-Y,Z
c3 -X,Y,-Z
c4 X,-Y,-Z
C
      WRITE(Kharvest,'(A)')'loop_'
      WRITE(Kharvest,'(A)')'     _atom_type.symbol'
      WRITE(Kharvest,'(A)')'     _atom_type.scat_Cromer_Mann_a1'
      WRITE(Kharvest,'(A)')'     _atom_type.scat_Cromer_Mann_b1'
      WRITE(Kharvest,'(A)')'     _atom_type.scat_Cromer_Mann_a2'
      WRITE(Kharvest,'(A)')'     _atom_type.scat_Cromer_Mann_b2'
      WRITE(Kharvest,'(A)')'     _atom_type.scat_Cromer_Mann_a3'
      WRITE(Kharvest,'(A)')'     _atom_type.scat_Cromer_Mann_b3'
      WRITE(Kharvest,'(A)')'     _atom_type.scat_Cromer_Mann_a4'
      WRITE(Kharvest,'(A)')'     _atom_type.scat_Cromer_Mann_b4'
      WRITE(Kharvest,'(A)')'     _atom_type.scat_Cromer_Mann_c'
      DO    ISC = 1,CS_NSFATM
         WRITE(Kharvest,'(A4,9F8.3)')CS_ELEMENT(ISC),(CS_A(II,ISC),
     +                 CS_B(II,ISC),II=1,4),CS_A(5,ISC)
      ENDDO

       WRITE(Kharvest,*)
       WRITE(Kharvest,'(A)')'loop_'
       WRITE(Kharvest,'(A)')'    _refine_ls_restr.type'
       WRITE(Kharvest,'(A)')'    _refine_ls_restr.number'
       WRITE(Kharvest,'(A)')'    _refine_ls_restr.dev_ideal'
       WRITE(Kharvest,'(A)')'    _refine_ls_restr.dev_ideal_target'
C
C---loop over restraints

       LEN_H = 0
       DO   IREST = 1,HNRESTR
         IF(HRESTR_NUM(IREST).GT.0.AND.
     &            HRESTR_TYPE(IREST)(1:3).NE.'NCS') THEN
           WRITE(Kharvest,'(A30,I8,F9.3,F9.3)')
     &       HRESTR_CIF(IREST),HRESTR_NUM(IREST),HRESTR_DEV(IREST),
     &       HRESTR_DEVITAR(IREST)
cd           CALL WRITE_CIFLINE_CHAR(Kharvest,LEN_H,HRESTR_TYPE(IREST))
cd           CALL WRITE_CIFLINE_INT(Kharvest,LEN_H,HRESTR_NUM(IREST))
cd           CALL WRITE_CIFLINE_REAL(Kharvest,LEN_H,HRESTR_DEV(IREST))
cd           CALL WRITE_CIFLINE_REAL(Kharvest,LEN_H,HRESTR_DEVITAR(IREST))
cd           CALL WRITE_CIFLINE_END(Kharvest,LEN_H)
         ENDIF
       ENDDO
C
C---NCS
C
       IF(NUMBER_NCSR.GT.0) THEN
         WRITE(Kharvest,*)
         WRITE(Kharvest,'(A)')'loop_'
         WRITE(Kharvest,'(A)')'    _struct_ncs_dom.id'
         WRITE(Kharvest,'(A)')'    _struct_ncs_dom.details'
         LEN_H = 0
         DO  INCS=1,NUMBER_NCSR
           WRITE(CHAR_NCS,'(I3)')INCS
           ALL_CHAINS = 'Chains'
           DO INCH=1,NCS_N_CHAIN(INCS)
              ALL_CHAINS=trim(ALL_CHAINS)//' '//NCS_CHAINS(INCH,INCS)
            ENDDO 
            WRITE(Kharvest,'(I6,1X,A,A,A)')INCS,'''',
     &           trim(ALL_CHAINS),''''
         ENDDO
         WRITE(Kharvest,*)
         WRITE(Kharvest,'(A)')'loop_'
         WRITE(Kharvest,'(A)')
     +     '   _pdbx_struct_ncs_dom_lim.dom_id '
         WRITE(Kharvest,'(A)')
     +     '   _pdbx_struct_ncs_dom_lim.component_id'
         WRITE(Kharvest,'(A)')
     +     '   _pdbx_struct_ncs_dom_lim.beg_auth_asym_id'
         WRITE(Kharvest,'(A)')
     +     '   _pdbx_struct_ncs_dom_lim.beg_auth_seq_id'
         WRITE(Kharvest,'(A)')
     +     '   _pdbx_struct_ncs_dom_lim.end_auth_asym_id'
         WRITE(Kharvest,'(A)')
     +     '   _pdbx_struct_ncs_dom_lim.end_auth_seq_id'
         WRITE(Kharvest,'(A)')
     +     '   _pdbx_struct_ncs_dom_lim.refine_code'
         DO   INCS=1,NUMBER_NCSR
           DO   ISPAN=1,NCS_SPANS(INCS)
             DO   INCH=1,NCS_N_CHAIN(INCS)
               WRITE(Kharvest,'(I5,1X,I5,1X,A,1X,I7,1X,A,1X,I7,1X,I2)')
     &            INCS,ISPAN,NCS_CHAINS(INCH,INCS),
     &            NCS_IRES_FIRST(ISPAN,INCS),
     &            NCS_CHAINS(INCH,INCS),NCS_IRES_LAST(ISPAN,INCS),
     &            NCS_ICODE(ISPAN,INCS)
              ENDDO
            ENDDO
          ENDDO

         WRITE(Kharvest,*)
         WRITE(Kharvest,'(A)')'loop_'
         WRITE(Kharvest,'(A)')'   _pdbx_refine_ls_restr_ncs.dom_id'
         WRITE(Kharvest,'(A)')'   _pdbx_refine_ls_restr_ncs.type'
         WRITE(Kharvest,'(A)')
     +      '   _pdbx_refine_ls_restr_ncs.auth_asym_id'
         WRITE(Kharvest,'(A)')'   _pdbx_refine_ls_restr_ncs.number'
         WRITE(Kharvest,'(A)')'   _pdbx_refine_ls_restr_ncs.rms_dev'
         WRITE(Kharvest,'(A)')'   _pdbx_refine_ls_restr_ncs.weight'

         DO   IREST=1,HNRESTR
            IF(HRESTR_TYPE(IREST)(1:3).EQ.'NCS') THEN
              WRITE(Kharvest,'(A,1X,A,A,A,A,1X,I8,1X,F9.3,1X,F9.3)')
     &     HRESTR_TYPE(IREST)(31:32),'''',HRESTR_TYPE(IREST)(6:22),'''',
     &     ' '//HRESTR_TYPE(IREST)(39:40)//' ',
     &     HRESTR_NUM(IREST),HRESTR_DEV(IREST),HRESTR_DEVITAR(IREST)
           ENDIF
        ENDDO
       ENDIF

C
C---TLS
C
       IGRP1 = 0
       IF(NTLSGRP.GT.0) THEN
         WRITE(Kharvest,*)
         WRITE(Kharvest,'(A)')'loop_'
         WRITE(Kharvest,'(A)')'   _pdbx_refine_tls_group.id'
         WRITE(Kharvest,'(A)')'   _pdbx_refine_tls_group.refine_tls_id'
         WRITE(Kharvest,'(A)')
     &              '   _pdbx_refine_tls_group.beg_label_asym_id'
         WRITE(Kharvest,'(A)')
     &              '   _pdbx_refine_tls_group.beg_label_seq_id'
         WRITE(Kharvest,'(A)')
     &              '   _pdbx_refine_tls_group.end_label_asym_id '
         WRITE(Kharvest,'(A)')
     &              '   _pdbx_refine_tls_group.end_label_seq_id'
         WRITE(Kharvest,'(A)')
     &              '   _pdbx_refine_tls_group.selection'
         DO   ITLS=1,NTLSGRP
           DO  ISPAN=1,ITLSGRP_PIECES(ITLS)
             IGRP1 = IGRP1 + 1
             WRITE(Kharvest,'(I4,1X,I4,1X,A,1X,I7,1X,A,I7,A)')
     &             IGRP1,ITLS,TLSGRP_CHN(ISPAN,ITLS),
     &                          ITLSGRP_FROM(ISPAN,ITLS),
     &              TLSGRP_CHN(ISPAN,ITLS),
     &                          ITLSGRP_TO(ISPAN,ITLS),' ALL'
           ENDDO
         ENDDO

         WRITE(Kharvest,*)
         WRITE(Kharvest,'(A)')'loop_'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.id'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.details'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.method'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.origin_x'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.origin_y'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.origin_z'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.T[1][1]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.T[2][2]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.T[3][3]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.T[1][2]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.T[1][3]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.T[2][3]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.L[1][1]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.L[2][2]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.L[3][3]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.L[1][2]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.L[1][3]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.L[2][3]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.S[1][1]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.S[2][2]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.S[3][3]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.S[1][2]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.S[1][3]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.S[2][3]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.S[2][1]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.S[3][1]'
         WRITE(Kharvest,'(A)')'    _pdbx_refine_tls.S[3][2]'
         DO   ITLS=1,NTLSGRP
           WRITE(Kharvest,'(I4,1X,A,1X,A,3(1X,F9.4))')
     &       ITLS,'.','refined',(TLSORIGIN(II,ITLS),II=1,3)
           WRITE(Kharvest,'(6(1X,F9.4))')(TMAT(II,ITLS),II=1,6)
           WRITE(Kharvest,'(6(1X,F9.4))')(LMAT(II,ITLS)*RTD2,II=1,6)
           S_TENS(1,2) = SMAT(3,ITLS)*RTODEG
           S_TENS(1,3) = SMAT(4,ITLS)*RTODEG
           S_TENS(2,3) = SMAT(5,ITLS)*RTODEG
           S_TENS(2,1) = SMAT(6,ITLS)*RTODEG
           S_TENS(3,1) = SMAT(7,ITLS)*RTODEG
           S_TENS(3,2) = SMAT(8,ITLS)*RTODEG
           S_TENS(3,3) = -(2.0*SMAT(2,ITLS) + SMAT(1,ITLS))*
     &                              RTODEG/3.0
           S_TENS(1,1) = S_TENS(3,3) + SMAT(2,ITLS)*RTODEG
           S_TENS(2,2) = S_TENS(1,1) + SMAT(1,ITLS)*RTODEG           
           WRITE(Kharvest,'(9(1X,F8.4))')
     &                              S_TENS(1,1),S_TENS(2,2),S_TENS(3,3),
     &                              S_TENS(1,2),S_TENS(1,3),S_TENS(2,3),
     &                              S_TENS(2,1),S_TENS(3,1),S_TENS(3,2)
         ENDDO
       ENDIF
C
      CLOSE (UNIT=KHarvest)
      RETURN
      END
 
      SUBROUTINE WRITE_CIFLINE_INT(C_FILE,LEN_C,ITEM)
C
      IMPLICIT NONE
      INTEGER LEN_C,C_FILE,ITEM

      CHARACTER LINE*132
      COMMON /CWRITE/LINE
      SAVE /CWRITE/

      IF(LEN_C.LE.0) THEN
C
c----lentgh of item should be checked here
        WRITE(LINE,'(I8)')ITEM
      ELSE
C
C---Chekc if after addition of new item lentgh is more that 132
         IF(LEN_C+8.GT.132) THEN
C
            WRITE(C_FILE,'(A)')LINE(1:LEN_C)
            LEN_C = 0
            IF(ITEM.NE.-999) THEN
              WRITE(LINE,'(I8)')ITEM
            ELSE
               LINE = '   ?    '
            ENDIF
            RETURN
         ELSE
C
C----Add new item to line
           IF(ITEM.NE.-999) THEN
             WRITE(LINE(LEN_C+1:132),'(I8)')ITEM
           ELSE
             LINE = LINE(1:LEN_C)//'   ?   '
           ENDIF
         ENDIF
       ENDIF
       LEN_C = LEN_C + 8
       RETURN
       END
C
      SUBROUTINE WRITE_CIFLINE_REAL(C_FILE,LEN_C,ITEM)
C
      IMPLICIT NONE
      INTEGER LEN_C,C_FILE
      REAL    ITEM

      CHARACTER LINE*132
      COMMON /CWRITE/LINE
      SAVE /CWRITE/

      IF(LEN_C.LE.0) THEN
C
c----lentgh of item should be checked here
        WRITE(LINE,'(F9.4)')ITEM
      ELSE
C
C---Chekc if after addition of new item lentgh is more that 132
         IF(LEN_C+10.GT.132) THEN
C
            WRITE(C_FILE,'(A)')LINE(1:LEN_C)
            LEN_C = 0
            IF(ITEM.NE.-999.00) THEN
               WRITE(LINE,'(F9.3)')ITEM
             ELSE
               WRITE(LINE,'(A)')'    ?     '
             ENDIF
            RETURN
         ELSE
C
C----Add new item to line
           IF(ITEM.NE.-999.00) THEN
             WRITE(LINE(LEN_C+1:132),'(F9.3)')ITEM
           ELSE
             LINE = LINE(1:LEN_C)//'     ?    '
           ENDIF
         ENDIF
       ENDIF
       LEN_C = LEN_C + 10
       RETURN
       END
C
       SUBROUTINE WRITE_CIFLINE_END(C_FILE,LEN_C)
C
       IMPLICIT NONE
       INTEGER  C_FILE,LEN_C
       CHARACTER LINE*132
       COMMON /CWRITE/LINE
       SAVE /CWRITE/
C
       IF(LEN_C.GT.0) THEN
          WRITE(C_FILE,'(A)')LINE(1:LEN_C)
       ENDIF
       LEN_C = 0
       RETURN
       END
C
      SUBROUTINE WRITE_CIFLINE_CHAR(C_FILE,LEN_C,ITEM)
C
      IMPLICIT NONE
      INTEGER LEN_C,C_FILE
      CHARACTER    ITEM*(*)

      CHARACTER LINE*132
      COMMON /CWRITE/LINE

      INTEGER len_to_use

      SAVE /CWRITE/

C
      len_to_use = MAX(len_trim(item),40)

      IF(LEN_C.LE.0) THEN
C
c----lentgh of item should be checked here
        LINE = ''''//ITEM(1:len_to_use)//''''
        LEN_C = 0
      ELSE
C
C---Chekc if after addition of new item lentgh is more that 132
         IF(LEN_C+len_to_use.GT.132) THEN
C
            WRITE(C_FILE,'(A)')LINE(1:LEN_C)
            LINE  = ''''//ITEM(1:len_to_use)//''''
            LEN_C = 0
         ELSE
C
C----Add new item to line
           LINE = trim(LINE)//''''//ITEM(1:len_to_use)//''''
         ENDIF
       ENDIF
       LEN_C = LEN_C + len_to_use
       RETURN
       END
