C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      subroutine randomise_and_refine(nmodel)
      use weights
      use agreem
      use rharvest
      implicit none
C
C---Subroutine for refinement with diagonal approximation
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'anom.fh'
      include 'monitor.fh'
c
      integer nmodel
c
      integer ir_cycle

      real, allocatable :: xyz_init(:,:)
      real, allocatable :: uaniso_init(:,:)
c
      real degtor
      integer ia,ir,nc_temp,nzero
      real rfree_now
      real,allocatable ::  rshift(:,:)
      integer npoints
      integer hkl(3)
      real fwt,phwt,delfwt,phdelfwt,fc,phc,fo,sigo,freer,weight_now
      real fc_all,phc_all,delta(2)
      integer, allocatable :: hkl_asym(:,:)
      real, allocatable :: fwt_acc(:,:)
      real, allocatable :: delfwt_acc(:,:)
      real, allocatable :: fo_acc(:,:)
      real, allocatable :: fc_acc(:,:)
      real, allocatable :: fcall_acc(:,:)
      real, allocatable :: freer_acc(:)
c
      integer ifile_rand,ierr,ifirst
c
c      nrandom_cycle = 20
      degtor = atan(1.0)/45.0

      allocate(xyz_init(3,n_atom))
      allocate(uaniso_init(6,n_atom))
      allocate(rshift(3,n_atom))
c
      write(*,*)'Before bootstrap'
c      stop
      call refine_individual(nmodel)
      call open_unform_file(ifile_rand,'INT_REFL_FILE',ierr)
      read(ifile_rand)npoints
      ifirst = 0
c
      allocate(hkl_asym(3,npoints))
      allocate(fwt_acc(2,npoints))
      allocate(delfwt_acc(2,npoints))
      allocate(fc_acc(2,npoints))
      allocate(fcall_acc(2,npoints))
      allocate(fo_acc(2,npoints))
      allocate(freer_acc(npoints))
c      call read_and_add_fs(ifirst,npoints,hkl_asym,fwt_acc,delfwt_acc,
c     &     fc_acc,fcall_acc,fo_acc,freer_acc)

      do ir=1,npoints
         read(ifile_rand)hkl_asym(1:3,ir),freer,weight_now,fo,sigo,
     &        fc,phc,
     &        fc_all,phc_all,fwt,phwt,delfwt,phdelfwt
         phc = phc*degtor
         phwt = phwt*degtor
         phdelfwt = phdelfwt*degtor
         phc_all = phc_all*degtor
c         fwt_acc(1,ir) = fwt*cos(phwt)
c         fwt_acc(2,ir) = fwt*sin(phwt)
c         delfwt_acc(1,ir) = delfwt*cos(phdelfwt)
c         delfwt_acc(2,ir) = delfwt*sin(phdelfwt)
         fcall_acc(1,ir) = fc_all*cos(phc_all)
         fcall_acc(2,ir) = fc_all*sin(phc_all)
         fc_acc(1,ir) = fc*cos(phc)
         fc_acc(2,ir) = fc*sin(phc)
         delfwt_acc(1:2,ir) = 0.0
         fwt_acc(1:2,ir) = 0.0
c         if(sigo.gt.0.0.and.freer.gt.0) then
c            delfwt_acc(1,ir) = fo*cos(phc_all)-fcall_acc(1,ir)
c            delfwt_acc(2,ir) = fo*sin(phc_all)-fcall_acc(2,ir)
c            fwt_acc(1:2,ir) = fcall_acc(1:2,ir) + 2*delfwt_acc(1:2,ir)
c         else
c            delfwt_acc(1:2,ir) = 0.0
c            fwt_acc(1:2,ir) = fcall_acc(1:2,ir)
c         endif
         fo_acc(1,ir) = fo
         fo_acc(2,ir) = sigo
         freer_acc(ir) = freer
      enddo
      close(ifile_rand)
c
      rfree_now = rfactor_free
      xyz_init(1:3,1:n_atom) = xyz_crd_mod(1:3,1:n_atom,1)
      uaniso_init(1:6,1:n_atom) = u_aniso_mod(1:6,1:n_atom,1)
      call random_seed
      mon_style = 'FEW'
      weight_adjust = 'NO'
      do ir_cycle = 1,nrandom_cycle
         write(*,*)'------------------------------------------------'
         write(*,*)'-------                                    -----'
         write(*,*)'-------  randomisation cycle =',ir_cycle, '-----'
         write(*,*)'-------                                    -----'
         write(*,*)'------------------------------------------------'
c
c---- Make bootsrap sample of observations
         call bootsrap_sample_twin

         if(refid.ne.'UNRE') call bootstrap_sample_restraints
c
c---  This part should be changed for accurate and efficient sampling
c         call resample_xyz()

         call random_number(rshift)
         xyz_crd(1:3,1:n_atom) = xyz_init(1:3,1:n_atom) + 
     &        2.0*rshift_max*(rshift(1:3,1:n_atom)-0.5)
         u_aniso(1:6,1:n_atom) = uaniso_init(1:6,1:n_atom)
         xyz_crd_mod(1:3,1:n_atom,1) = xyz_crd(1:3,1:n_atom)
         u_aniso_mod(1:6,1:n_atom,1) = u_aniso(1:6,1:n_atom)
         linit = .FALSE.
         mlinit = .FALSE.
c         stop
         call refine_individual(nmodel)
c         if(rfactor_free.lt.rfree_now*0.9) then
c            write(*,*)'Changing coordinates ',rfactor_free,rfree_now
c            stop
c            xyz_init(1:3,1:n_atom) = xyz_crd(1:3,1:n_atom)
c            uaniso_init(1:3,1:n_atom) = u_aniso(1:3,1:n_atom)
c            rfree_now = rfactor_free
c         endif
c
c--Add structure factors together
         call open_unform_file(ifile_rand,'INT_REFL_FILE',ierr)
         read(ifile_rand)npoints
         nzero = 0
         do ir=1,npoints
         read(ifile_rand)hkl_asym(1:3,ir),freer,weight_now,fo,sigo,
     &           fc,phc,
     &        fc_all,phc_all,fwt,phwt,delfwt,phdelfwt
         if(weight_now.le.0.0) then
            weight_now = 1.0
            nzero = nzero + 1
         else
            weight_now = 0.0
         endif
            phc = phc*degtor
            phc_all = phc_all*degtor
            phwt = phwt*degtor
            phdelfwt = phdelfwt*degtor
c            fwt_acc(1,ir) = fwt_acc(1,ir) + fwt*cos(phwt)
c            fwt_acc(2,ir) = fwt_acc(2,ir) + fwt*sin(phwt)
c            delfwt_acc(1,ir) = delfwt_acc(1,ir) + delfwt*cos(phdelfwt)
c            delfwt_acc(2,ir) = delfwt_acc(2,ir) + delfwt*sin(phdelfwt)
            fcall_acc(1,ir) = fcall_acc(1,ir) + fc_all*cos(phc_all)
            fcall_acc(2,ir) = fcall_acc(2,ir) + fc_all*sin(phc_all)
            fc_acc(1,ir) = fc_acc(1,ir) + fc*cos(phc)
            fc_acc(2,ir) = fc_acc(2,ir) + fc*sin(phc)
            if(sigo.gt.0.0.and.freer.gt.0) then
               delta(1) = fo*cos(phc_all) - fc_all*cos(phc_all)
               delta(2) = fo*sin(phc_all) - fc_all*sin(phc_all)

               delfwt_acc(1:2,ir) = delfwt_acc(1:2,ir) + 
     &              weight_now*delta(1:2)
               fwt_acc(1,ir) = fwt_acc(1,ir) + 
     &              weight_now*(fc_all*cos(phc_all) + 2.0*delta(1))
               fwt_acc(2,ir) = fwt_acc(2,ir) + 
     &              weight_now*(fc_all*sin(phc_all) + 2.0*delta(2))
            else
               delta(1) = 0.0
               delta(2) = 0.0
               delfwt_acc(1:2,ir) = delfwt_acc(1:2,ir) + delta(1:2) 
               fwt_acc(1,ir) = fwt_acc(1,ir) + 0.33*fc_all*cos(phc_all)
               fwt_acc(2,ir) = fwt_acc(2,ir) + 0.33*fc_all*sin(phc_all)
            endif
            fo_acc(1,ir) = fo_acc(1,ir) + fo
            fo_acc(2,ir) = fo_acc(2,ir) + sigo
         enddo
         close(ifile_rand)
      enddo
c
c      if(rfactor_free.ge.rfree_now*0.9) then
      xyz_crd(1:3,1:n_atom) = xyz_init(1:3,1:n_atom)
      u_aniso(1:6,1:n_atom) = uaniso_init(1:6,1:n_atom)
      xyz_crd_mod(1:3,1:n_atom,1) = xyz_crd(1:3,1:n_atom)
      u_aniso_mod(1:6,1:n_atom,1) = u_aniso(1:6,1:n_atom)
c      endif
c
      nc_temp = nrandom_cycle + 1
      fwt_acc(1:2,1:npoints) = fwt_acc(1:2,1:npoints)/nc_temp
      delfwt_acc(1:2,1:npoints) = delfwt_acc(1:2,1:npoints)/nc_temp
      fc_acc(1:2,1:npoints) = fc_acc(1:2,1:npoints)/nc_temp
      fo_acc(1:2,1:npoints) = fo_acc(1:2,1:npoints)/nc_temp
      fcall_acc(1:2,1:npoints) = fcall_acc(1:2,1:npoints)/nc_temp
c
      call mtz_write_acc(npoints,hkl_asym,freer_acc,fo_acc,fc_acc,
     &     fcall_acc,
     &     fwt_acc,delfwt_acc)

      deallocate(xyz_init)
      deallocate(uaniso_init)
      deallocate(hkl_asym)
      deallocate(freer_acc)
      deallocate(fwt_acc)
      deallocate(delfwt_acc)
      deallocate(fc_acc)
      deallocate(fcall_acc)
      deallocate(fo_acc)

      return
      end

      subroutine tls_and_individual
      implicit none
      integer i,nmodel
c
      nmodel = 1
      do i=1,3
         call tls_refine
         call refine_individual(nmodel)
      enddo
      
      return
      end

      subroutine refine_individual(nmodel)
      use weights
      use agreem
      use solvent_all
C
C---Subroutine for refinement with diagonal approximation
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'anom.fh'
C
C---Local variables
      INTEGER I_INTER,I_REF_FLAG
      CHARACTER LINE*80
      CHARACTER IN_COORD_FILE*256
      integer ua, nmodel, nanom
      character string_model*3
      logical save,restore
      parameter (save=.true.)
      parameter (restore=.false.)
c
      real, allocatable :: occupancy_local(:,:,:)
c
      nanom=0
      if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras) nanom=1
      if (DPPI_mad) nanom=2
      allocate(occupancy_local(n_atom_mod_max,nmodel,nanom+1))
      call saveinit_restore_occ_for_excl(save,nmodel,n_atom_mod_max,
     &   nanom,occupancy_local,0.0)
      call set_hkon_flags(nmodel)
      if(solvent_optimise) then
         call optimise_solvent
         return
      endif
C---report about type of refinement and so on
C----------------------------------------------------
C-------------------------------------------------
C---Initialize
      IF((NTLS_CYCLE.GT.0.OR.TLS_FILE_FLAG).AND.REFID.NE.'IDEA') THEN
        UOVER_ATOM = 0.0
        CALL TLS_REFINE
      ENDIF
c
      CALL SET_HKON_FLAGS(nmodel)
C
c---Save vital parameters
      CALL SAVE_VITAL
C
C----Set refinement style
      IF(REFID.EQ.'REST') THEN
        GEOM_FLAG  = .TRUE.
        X_RAY_FLAG = .TRUE.
      ELSEIF(REFID.EQ.'UNRE') THEN
        GEOM_FLAG  = .FALSE.
        X_RAY_FLAG = .TRUE.
      ELSEIF(REFID.EQ.'IDEA') THEN
        GEOM_FLAG  = .TRUE.
        X_RAY_FLAG = .FALSE.
      ELSE
        WRITE(LINE,'(A,A)') 'There is no such option ',REFID
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(1,' False option')
      ENDIF

      IF(.NOT.X_RAY_FLAG) THEN
C
C---If we are not going to refine 
        ITEMP = 0
        NOCC  = 0
      ENDIF
      IF(.NOT.GEOM_FLAG) THEN
        NDIS = 0
        NBIS = 0
        NVDW = 0
      ENDIF
C
      NVPOS = 0
      NMPOS = 0
      NVOCC = 0
      NMOCC = 0
      NVTMP = 0
      NMTMP = 0
C
C---Number of refined parameters. It is useful for SU calculation
      NREF_PARS = 0
C
C---Find number of variables and second derivative matrix elements
C---for different type of parameters
c      IF(OCCUP_REF_FLAG)CALL AUTO_DEFINE_OCCUPANCY_GROUPS
      do im=1,nmodel
        DO    IA=1,N_ATOM_mod(im)
          I_INTER = ATOM_REF_mod_FLAG(IA,im)/10
          I_REF_FLAG = ATOM_REF_mod_FLAG(IA,im) - I_INTER*10
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            NVPOS = NVPOS + 3
            NMPOS = NMPOS + 6
            IF(I_REF_FLAG.GT.2) NREF_PARS = NREF_PARS + 3
            IF(IOCCUP.GT.0) THEN
              NVOCC = NVOCC + 1
              IF(I_REF_FLAG.GT.2) NREF_PARS = NREF_PARS + 1
              NMOCC = NMOCC + 1
            ENDIF
            IF(ITEMP.NE.0) THEN
              IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                NVTMP = NVTMP + 1
                IF(I_REF_FLAG.GT.2) NREF_PARS = NREF_PARS + 1
                NMTMP = NMTMP + 1
              ELSE
                NVTMP = NVTMP + 6
                IF(I_REF_FLAG.GT.2) NREF_PARS = NREF_PARS + 6
                NMTMP = NMTMP + 21
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      enddo
      NVALL = NVPOS + NVOCC + NVTMP   
c
C---Begin refinement cycles

c
c---  Set some more restraints to initial distances

      IF(SOLVMIN.EQ.'CGMA') THEN
         CALL CGSPARCE(nmodel)
      ELSEIF(SOLVMIN.EQ.'CGRA') THEN
          CONTINUE
         call errwrt(1,'CGRAD option is not available')
c          CALL CGRAD
      ELSEIF(SOLVMIN(1:4).EQ.'CDIR') THEN
         CONTINUE
         call errwrt(1,'CDIR option is not available')
c         CALL CDIR
      ELSE
        LINE = ' Such minimization procedure is not ready'
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(1,' Minimization method')
      ENDIF
c
c---  Restore occupancies and deallocate
      call saveinit_restore_occ_for_excl(restore,nmodel,n_atom_mod_max,
     &   nanom,occupancy_local,0.0)
      deallocate(occupancy_local)
C
      CALL RESTORE_VIT
      RETURN
      END
C
C---Following subroutines are methods of minimizations
C
      SUBROUTINE CGSPARCE(nmodel)
      use weights
      use agreem
      use rharvest
      use restr_files
      use ncs_simil
      use local_tls
      use solvent_all
      implicit none
c
c---Minimization of functional by calculation 
C---sparce matrix and solution of sparce matrix
C---linear equation by conjugate gradient method
C---See for example: Numerical Recipes in Fortran by Press et al
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'occupancy_params.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'const.fh'
      include 'mtz_things.fh'
      INCLUDE 'save_all_params.fh'
      include 'anom.fh'
      include 'twin_refmac.fh'
      include 'ncs_rest.fh'
c
      integer nmodel
c
c---  locals
      integer ncycl1
      REAL GAMMA
c
c---  Params for linmin
      real g2p,al0
      INTEGER IANALYSE_REST,IWRITE_FIRST
      REAL ALPHA
      REAL F_VALUE,STEP,f_ll
      REAL FG0,FX0
      real toler,alc,al,alb,f0,f1
      integer nv1,ncong,ierror,ndist_l,i,iposx,iposu,ia
      LOGICAL   LREFIN_SAVE,OCCUP_REF_FLAG_SAVE
      LOGICAL   HCALC_SAVE,GRADC_SAVE,solvent_flag_save
      logical all_scales_save
      LOGICAL   CONV_FLAG,GAMMA_FLAG,STEP_FLAG
      LOGICAL LINMIN_FLAG
      CHARACTER LINE*128,MON_STYLE_SAVE*4
c
                                !
                                !  Date and time
      character(8)  :: dt
      character(10) :: tm
      character(5)  :: zn
      integer,dimension(8) :: val_l

      real dmin_vdw
      integer qqm,qqv,im,n_atom_tot
      real, allocatable :: am(:)
      real, allocatable :: v(:)
      real, allocatable :: dv(:)
      integer, allocatable :: n_target(:)
      integer, allocatable :: n_object(:)
c
c---  externals
      EXTERNAL SCALE_SHIFTS_ALL,SCALE_ALL,MATMUL_ALL,INV_SCALE_ALL

C
C---Initialisation step
      NV1 = NVPOS + NVTMP

      al0 = 1.0e-2
      n_atom_tot=0
      n_atom_tot = sum(n_atom_mod(1:nmodel))
      if(itemp.eq.0) then
         qqv = 3*n_atom_tot
      else if(itemp.eq.1) then
         qqv = 4*n_atom_tot
      else
         qqv = 9*n_atom_tot
      endif
      allocate(v(qqv))
      allocate(dv(qqv))
c
      LINMIN_FLAG = .FALSE.
      GAMMA_FLAG = .FALSE.
      STEP_FLAG  = .FALSE.
      GAMMA      = 0.00
      STEP       = 0.05
      dmin_vdw = 0.0
      solvent_flag_save = solvent_flag
      IF(NTLS_CYCLE.GT.0.OR.TLS_FILE_FLAG) LINMIN_FLAG = .TRUE.

      HCALC      = .TRUE.
      GRADC      = .TRUE.
      XCALC_FLAG = .TRUE.
      IERROR     = 0

      MON_STYLE_SAVE = MON_STYLE
      OCCUP_REF_FLAG_SAVE = OCCUP_REF_FLAG
      DO    NCYCL1 = 1,NCCREF
         ncycl = ncycl1
c
c---  Adjust weights
         if(weight.eq.'AUTO'.and.trim(weight_adjust).eq.'YES') then
            if(nbond_refmac.gt.0.and.ncycle_overall.gt.0) then
               if(ncycl.eq.2) then
                  if(zbond_vs_cycle(ncycle_overall).gt.1.0) then
                     weightauto = weightauto/1.1
                  endif
               elseif(ncycl.gt.2.and.ncycle_overall.gt.1) then
                  if(zbond_vs_cycle(ncycle_overall).gt.1.0.and.
     &                 zbond_vs_cycle(ncycle_overall).gt.
     &                 zbond_vs_cycle(ncycle_overall-1)) then
                     weightauto = weightauto/1.1
                  elseif(zbond_vs_cycle(ncycle_overall).lt.0.5.and.
     &                    zbond_vs_cycle(ncycle_overall-1).lt.0.5.and.
     &                    zbond_vs_cycle(ncycle_overall).lt.
     &                    zbond_vs_cycle(ncycle_overall-1)) then
                     weightauto = weightauto*1.3
                  elseif(zbond_vs_cycle(ncycle_overall).gt.
     &                    1.5*zbond_vs_cycle(ncycle_overall-1)) then
                     weightauto = weightauto/1.1
                  elseif(zbond_vs_cycle(ncycle_overall).gt.
     &                    zbond_vs_cycle(ncycle_overall-1)) then
                  endif
               endif
            endif
         endif
         IF((NCYCL.EQ.1.AND.(mon_style_save.eq.'MEDI'.or.
     &        mon_style_save.eq.'MANY')) ) then
            mon_style = 'MANY'
         elseif (mon_style_save.ne.'MANY') then
            mon_style = 'FEW'
         else
            mon_style = mon_style_save
         endif
c     
         if(occup_refine_flag.and.mod(ncycl1,ncycle_occup).eq.0.and.
     &        ncycl1.gt.1) then
            CALL ERRWRT(-1,' ')
            WRITE(LINE,'(10x,A)')'----Group occupancy refinement----'
            CALL ERRWRT(-1,LINE)           
            call occupancy_group_refine(nmodel)
            IF(MON_STYLE.NE.'NONE') THEN
               IF(X_RAY_FLAG)CALL REPORT_XRAY_STATS
            ENDIF
         endif
c     
         CALL ERRWRT(-1,' ')
         WRITE(LINE,'(5x,A,I6)')'CGMAT cycle number = ',NCYCL
         CALL ERRWRT(-1,' ')
         CALL ERRWRT(-1,LINE)
         CALL ANALYSE_VDW(dmin_vdw)
         call ncs_local_define(xyz_crd(1:3,1:n_atom),sigx_ncs_local,
     &        dmax_ncs_local,diffmax_ncs_local,
     &        vdw_file,ncsr_file_name,ncs_simil_file,ncsr_use)
         call make_dist_list(n_atom,atom_ref_mod_flag(1:n_atom,1:1),
     &        ndist_l,local_tls_pairs)
         allocate(n_target(ndist_l))
         allocate(n_object(ndist_l))
         call get_all_pairs(ndist_l,n_target,n_object)
c
c---- Find sizes properly
         if(itemp.eq.0) then
            qqm = 6*n_atom_tot + 9*ndist_l
         elseif(itemp.eq.1) then
            qqm = 7*n_atom_tot + 10*ndist_l
         else
            qqm = 27*n_atom_tot + 45*ndist_l
         endif
         allocate(am(qqm))
         CALL RESIDVAL(F0,qqm,qqv,am,v,dv,nmodel,ndist_l,
     &        n_target,n_object)
         write(*,*)'function value ',f0
         FG0 = FGEOM
         FX0 = FXRAY
         IF(MON_STYLE.NE.'NONE') THEN
            IF(GEOM_FLAG)CALL REPORT_OVER_GEOM
            IF(X_RAY_FLAG)CALL REPORT_XRAY_STATS
         ENDIF
C     
C---- Solution of equation with sparse matrix.
         IERROR   = 0
C     
C---  First solve equation for positional parameters
         TOLER = -1.0
         NCONG = 500       
C     
C---  Condition close atoms
c         CALL CLOSE_ATOM_CONDITION(AM,nmodel,ndist_l,n_target,n_object)
C     
c     
c---  cgsol needs to be modified also
         NV1 = NVPOS+NVTMP
         dv(1:nv1) = 0.0
         CALL CGSOL_RM(NV1,NCONG,TOLER,AM(1),V(1),DV(1),ndist_l,
     &        n_target,n_object,
     +        SCALE_ALL,MATMUL_ALL,
     +        SCALE_SHIFTS_ALL,INV_SCALE_ALL,IERROR,GAMMA_FLAG,
     +        GAMMA,STEP_FLAG,STEP,nmodel)
         IF(IERROR.NE.0) THEN
            CALL ERRWRT(0,'In CGSPARCE after CGSOLVE after '//
     &           'positional refinement')
            IERROR = 1
            RETURN
         ENDIF
         IF(IERROR.NE.0) THEN
            CALL ERRWRT(0,'In CGSPARCE. CGSOLVE failed.'//
     +           ' After thermal parameter refinement')
            IERROR = 2
            RETURN
         ENDIF
C     
C---  Line minimisation should be added here.
         
C     
C---  Apply shifts using solution of normal equations
         F1  = F0
         AL  = 1.0
         ALB = 1.0
         ALC = 1.0
c     
C----------------------------------------
         CALL SAVE_ALL_PARAMS('S',nmodel)
         call bscale_to_shifts(nmodel,uover_atom,dv)
         all_scales_save = all_scales_flag
         all_scales_flag  = .FALSE.
         AL             =  1.0
         ALB            =  1.0
         HCALC_SAVE     = HCALC
         HCALC          = .FALSE.
         MON_STYLE      = 'NONE'
         GRADC_SAVE     = GRADC
         GRADC          = .FALSE.
         solvent_flag_save = solvent_flag
         solvent_flag   = .FALSE.
         CALL RESIDVAL(f0,qqm,qqv,am,v,dv,nmodel,ndist_l,
     &        n_target,n_object)
         deallocate(n_target)
         deallocate(n_object)
         deallocate(am)
         CALL SAVE_ALL_PARAMS('S',nmodel)
         
         fx0 = fxray
         fg0 = fgeom
         CALL APPLY(nmodel,AL,ALB,dv)
         CALL MAKE_U_POSITIVE(nmodel)
         if (DPPI_pl.and.nmodel.eq.2)call copy_ligand()
         if (substruct_flag) goto 20
         DO   I=1,2
            call get_all_pairs_size(ndist_l)
            allocate(n_target(ndist_l))
            allocate(n_object(ndist_l))
            call get_all_pairs(ndist_l,n_target,n_object)
            if(itemp.eq.0) then
               qqm = 6*n_atom_tot + 9*ndist_l
            elseif(itemp.eq.1) then
               qqm = 7*n_atom_tot + 10*ndist_l
            else
               qqm = 27*n_atom_tot + 45*ndist_l
            endif
            allocate(am(qqm))
            NV1 = NVPOS + NVTMP
            CALL RESIDVAL(f_ll,qqm,qqv,am,v,dv,nmodel,ndist_l,
     &        n_target,n_object)
            deallocate(am)
            deallocate(n_target)
            deallocate(n_object)
            WRITE(*,*)'fvalues ',fx0,fg0,f_ll,f0
            IF(f_ll.GT.f0) THEN
               AL  = AL/2.0
               ALB = ALB/2.0
               CALL SAVE_ALL_PARAMS('R',nmodel)
               CALL APPLY(nmodel,AL,ALB,dv)
               CALL MAKE_U_POSITIVE(nmodel)
               if (DPPI_pl.and.nmodel.eq.2) call copy_ligand()
            else
               goto 20
            ENDIF
c     
c---  do we need to finish
c        call check_end
         ENDDO
 20      CONTINUE
         CALL SAVE_OVERALL_PARAMS('R')
         
         HCALC     = HCALC_SAVE
         GRADC     = GRADC_SAVE
         solvent_flag = solvent_flag_save
         all_scales_flag = all_scales_save
         conv_flag = .FALSE.
         CALL CONVERGED_HKON(nmodel,AL,ALB,dv,CONV_FLAG)
         if (substruct_flag.and..not.ncyc_set_by_user_flag) 
     &        CALL CONVERGED_SUBSTRUCT_HKON(nmodel,ncycl1,CONV_FLAG)
         IF(CONV_FLAG) then
            GOTO 30
         endif
 100     CONTINUE
         if(allocated(am)) deallocate(am)
         if(allocated(n_target)) deallocate(n_target)
         if(allocated(n_object)) deallocate(n_object)
         MON_STYLE = MON_STYLE_SAVE
      ENDDO
 30   CONTINUE
      if(allocated(am)) deallocate(am)
      if(allocated(n_target)) deallocate(n_target)
      if(allocated(n_object)) deallocate(n_object)
      IF(NLPRGO.NE.0) THEN
         if(mon_style_save.eq.'MEDI'.or.mon_style_save.eq.'MANY') then
            mon_style = 'MANY'
         else
            mon_style = mon_style_save
         endif
         LREFIN_SAVE   = LREFIN
         LREFIN        = .FALSE.
         XCALC_FLAG    = .TRUE.
         HCALC         = .FALSE.
         GRADC         = .FALSE.
         IWRITE_FIRST  = 1
         IANALYSE_REST = 0
         IF(REFID.NE.'UNRE') THEN
            IANALYSE_REST = 1
         ENDIF
c         CALL ANALYSE_VDW(dmin_vdw)
c         call ncs_local_define(xyz_crd,dist_cut_ncs,diff_dist_cut,
c     &        vdw_file,ncsr_file_name,ncs_simil_file,ncsr_use)
         if(nccref.eq.0) then
            call make_dist_list(n_atom,atom_ref_mod_flag(1:n_atom,1:1),
     &           ndist_l,local_tls_pairs)
         endif
         call get_all_pairs_size(ndist_l)
         allocate(n_target(ndist_l))
         allocate(n_object(ndist_l))
         call get_all_pairs(ndist_l,n_target,n_object)
         
         if(itemp.eq.0) then
            qqm = 6*n_atom_tot + 9*ndist_l
         elseif(itemp.eq.1) then
            qqm = 7*n_atom_tot + 10*ndist_l
         else
            qqm = 27*n_atom_tot + 45*ndist_l
         endif
         allocate(am(qqm))
         CALL RESIDVAL(F1,qqm,qqv,am,v,dv,nmodel,ndist_l,
     &        n_target,n_object)
         deallocate(am)
         deallocate(n_target)
         deallocate(n_object)
         IF(MON_STYLE.NE.'NONE') THEN
            IF(GEOM_FLAG )CALL REPORT_OVER_GEOM
            IF(X_RAY_FLAG)CALL REPORT_XRAY_STATS
         ENDIF
         LREFIN    = LREFIN_SAVE
      ENDIF
      mon_style = mon_style_save
      OCCUP_REF_FLAG = OCCUP_REF_FLAG_SAVE
      deallocate(v)
      deallocate(dv)
      RETURN
      END
C
      subroutine copy_ligand()
c copies over the ligand atoms from 1. to 2. model. 
c necessary as a workaround until geometry is not properly implemented for more models
      implicit none
c      
      include 'atom_com.fh'
      include 'models.fh'
c
      integer ia,ia2
c
        do     IA2=1,N_ATOM_mod(2)
          do     IA=1,N_ATOM_mod(1)
            if ( ATM_NAME_INP_mod(ia,1).eq.ATM_NAME_INP_mod(ia2,2) .and.
     &           ID_ALT_mod(ia,1).eq.ID_ALT_mod(ia2,2) .and.
     &           RES_NAME_mod(I_RESID_mod(ia,1),1).eq.
     &           RES_NAME_mod(I_RESID_mod(ia2,2),2) )  then
              occup_mod(ia2,2) = occup_mod(ia,1)
              xyz_crd_mod(1:3,ia2,2) = xyz_crd_mod(1:3,ia,1)
              u_aniso_mod(1:6,ia2,2) = u_aniso_mod(1:6,ia,1)
            endif
          enddo
        enddo

      return
      end
c
      subroutine solve_unrestrained(nmodel,dv)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'vitals.fh'
      include 'refi_flags.fh'
      real dv(*)
      REAL GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
C
      real   huu_anom(3),huq_anom,hqq_anom
      REAL   H_XXD,H_UUD(3),H_UQD,H_QQD
      integer iv,ia,ierror,im,nmodel
      character at_full1*15
C
      open(20)
      iv = 0
      do im=1,nmodel
        do ia=1,n_atom_mod(im)
          if(atom_ref_mod_flag(ia,im).gt.0) then
            CALL FAST_HESSIAN_DIAGONAL(IA,im,H_XXD,H_UUD,H_UQD,H_QQD,
     &          huu_anom,huq_anom,hqq_anom)
            dv(iv+1) = gx(iv+1)/h_xxd
            dv(iv+2) = gx(iv+2)/h_xxd
            dv(iv+3) = gx(iv+3)/h_xxd
            write(20,*)gx(iv+1),gx(iv+2),gx(iv+3)
            if(abs(dv(iv+1)).gt.1.0.or.abs(dv(iv+2)).gt.1.0.or.
     &         abs(dv(iv+3)).gt.1.0) then
               call full_atom_name(ia,at_full1,ierror)
               write(*,*)at_full1,gx(iv+1),gx(iv+2),gx(iv+3)
cd             return
            endif
            iv       = iv + 3
          endif
        enddo
      enddo
C
cd      stop
      return
      end
C
C---
      SUBROUTINE SAVE_ALL_PARAMS(SAVE_RESTORE,nmodel)
      use weights
      use agreem
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'refi_flags.fh'
      include 'anom.fh'
      CHARACTER*1 SAVE_RESTORE
      integer nmodel
C
C---This subroutine saves all parameters for future use. For example
C---in linear minimisation it may be necessary
C
      INCLUDE 'save_all_params.fh'
      INTEGER IX,IA,IP,I
      integer im,Dnum
C
      Dnum=NPART+1
      if (.not.dppi_no) call return_Dnum(Dnum)
      IF(SAVE_RESTORE.EQ.'S') THEN
        do im=1,nmodel
          DO   IA = 1,N_ATOM_mod(im)
            DO IX=1,3
              XYZ_SAVE(IX,IA,im) = XYZ_CRD_mod(IX,IA,im)
            ENDDO
            DO   IX=1,6
              U_ANISO_SAVE(IX,IA,im) = U_ANISO_mod(IX,IA,im)
            ENDDO
          ENDDO
        enddo
        DO  IX=1,NBIN_ML
          SIGMA_ML_SAVE(IX) = SIGMA_ML(IX)
          DO  IP=1,Dnum
            SCALE_ML_SAVE(IX,IP) = SCALE_ML(IX,IP)
          ENDDO
        ENDDO
C
        D_ML_SCALE_OVER_SAVE = D_ML_SCALE_OVER
        D_ML_B_OVER_SAVE     = D_ML_B_OVER
        D_ML_SCALE_BBULK_SAVE = D_ML_SCALE_BBULK
        D_ML_B_BBULK_SAVE     = D_ML_B_BBULK
        DO    I=1,NMAXP1
          D_ML_SCALE_PART_SAVE(I) = D_ML_SCALE_PART(I)
          D_ML_B_PART_SAVE(I)     = D_ML_B_PART(I)
        ENDDO

        DO  IX=1,6
          B_LS_ANISO_SAVE(IX) = B_LS_ANISO_OVER(IX)
        ENDDO
        SCALE_LS_OVER_SAVE = SCALE_LS_OVER
        B_LS_OVER_SAVE     = B_LS_OVER
        SCALE_LS_BULK_SAVE = SCALE_LS_BULK
        B_LS_BULK_SAVE     = B_LS_BULK
        DO   IP=1,NPART
          SCALE_LS_PART_SAVE(IP) = SCALE_LS_PART(IP)
          B_LS_PART_SAVE(IP)     = B_LS_PART(IP)
        ENDDO
        UOVER_SAVE = UOVER_ATOM
C
C--Save scale and ML parameters
      ELSE IF(SAVE_RESTORE.EQ.'R') THEN
        do im=1,nmodel
          DO  IA=1,N_ATOM_mod(im)
            DO  IX = 1,3
              XYZ_CRD_mod(IX,IA,im) = XYZ_SAVE(IX,IA,im)
              if (im.eq.1) XYZ_CRD(IX,IA) = XYZ_SAVE(IX,IA,im)
            ENDDO
            DO   IX=1,6
              U_ANISO_mod(IX,IA,im) = U_ANISO_SAVE(IX,IA,im)
              if (im.eq.1) U_ANISO(IX,IA) = U_ANISO_SAVE(IX,IA,im)
            ENDDO
          ENDDO
        enddo
        DO  IX=1,NBIN_ML
          SIGMA_ML(IX) = SIGMA_ML_SAVE(IX)
          DO  IP=1,Dnum
            SCALE_ML(IX,IP) = SCALE_ML_SAVE(IX,IP)
          ENDDO
        ENDDO
        D_ML_SCALE_OVER = D_ML_SCALE_OVER_SAVE
        D_ML_B_OVER     = D_ML_B_OVER_SAVE
        D_ML_SCALE_BBULK = D_ML_SCALE_BBULK_SAVE
        D_ML_B_BBULK     = D_ML_B_BBULK_SAVE
        DO    I=1,NMAXP1
          D_ML_SCALE_PART(I) = D_ML_SCALE_PART_SAVE(I)
          D_ML_B_PART(I)     = D_ML_B_PART_SAVE(I)
        ENDDO
        DO  IX=1,6
          B_LS_ANISO_OVER(IX) = B_LS_ANISO_SAVE(IX)
        ENDDO
        SCALE_LS_OVER = SCALE_LS_OVER_SAVE
        B_LS_OVER     = B_LS_OVER_SAVE
        SCALE_LS_BULK = SCALE_LS_BULK_SAVE
        B_LS_BULK     = B_LS_BULK_SAVE
        DO   IP=1,NPART
          SCALE_LS_PART(IP) = SCALE_LS_PART_SAVE(IP)
          B_LS_PART(IP)     = B_LS_PART_SAVE(IP)
        ENDDO
        UOVER_ATOM = UOVER_SAVE
C
C--Restore remaining parameters
      ELSE
        CALL ERRWRT(1,'Wrong argument for SAVE_ALL_PARAMETERS')
      ENDIF
      RETURN
      END
C
C---
      SUBROUTINE SAVE_OVERALL_PARAMS(SAVE_RESTORE)
      use weights
      use agreem
                                !   
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'refi_flags.fh'
      include 'anom.fh'
      CHARACTER*1 SAVE_RESTORE
C
C---This subroutine saves overall parameters for future use. For example
C---in linear minimisation it may be necessary
C
      INCLUDE 'save_all_params.fh'
      INTEGER IX,IA,IP,I,Dnum
C
      Dnum=NPART+1
      if (.not.dppi_no) call return_Dnum(Dnum)
      IF(SAVE_RESTORE.EQ.'S') THEN
        DO  IX=1,NBIN_ML
          SIGMA_ML_SAVE(IX) = SIGMA_ML(IX)
          DO  IP=1,Dnum
            SCALE_ML_SAVE(IX,IP) = SCALE_ML(IX,IP)
          ENDDO
        ENDDO

        D_ML_SCALE_OVER_SAVE = D_ML_SCALE_OVER
        D_ML_B_OVER_SAVE     = D_ML_B_OVER
        D_ML_SCALE_BBULK_SAVE = D_ML_SCALE_BBULK
        D_ML_B_BBULK_SAVE     = D_ML_B_BBULK
        DO    I=1,NMAXP1
          D_ML_SCALE_PART_SAVE(I) = D_ML_SCALE_PART(I)
          D_ML_B_PART_SAVE(I)     = D_ML_B_PART(I)
        ENDDO

        DO  IX=1,6
          B_LS_ANISO_SAVE(IX) = B_LS_ANISO_OVER(IX)
        ENDDO
        SCALE_LS_OVER_SAVE = SCALE_LS_OVER
        B_LS_OVER_SAVE     = B_LS_OVER
        SCALE_LS_BULK_SAVE = SCALE_LS_BULK
        B_LS_BULK_SAVE     = B_LS_BULK
        DO   IP=1,NPART
          SCALE_LS_PART_SAVE(IP) = SCALE_LS_PART(IP)
          B_LS_PART_SAVE(IP)     = B_LS_PART(IP)
        ENDDO
        UOVER_SAVE = UOVER_ATOM
C
C--Save scale and ML parameters
      ELSE IF(SAVE_RESTORE.EQ.'R') THEN
        DO  IX=1,NBIN_ML
          SIGMA_ML(IX) = SIGMA_ML_SAVE(IX)
          DO  IP=1,Dnum
            SCALE_ML(IX,IP) = SCALE_ML_SAVE(IX,IP)
          ENDDO
        ENDDO
        D_ML_SCALE_OVER = D_ML_SCALE_OVER_SAVE
        D_ML_B_OVER     = D_ML_B_OVER_SAVE
        D_ML_SCALE_BBULK = D_ML_SCALE_BBULK_SAVE
        D_ML_B_BBULK     = D_ML_B_BBULK_SAVE
        DO    I=1,NMAXP1
          D_ML_SCALE_PART(I) = D_ML_SCALE_PART_SAVE(I)
          D_ML_B_PART(I)     = D_ML_B_PART_SAVE(I)
        ENDDO
        DO  IX=1,6
          B_LS_ANISO_OVER(IX) = B_LS_ANISO_SAVE(IX)
        ENDDO
        SCALE_LS_OVER = SCALE_LS_OVER_SAVE
        B_LS_OVER     = B_LS_OVER_SAVE
        SCALE_LS_BULK = SCALE_LS_BULK_SAVE
        B_LS_BULK     = B_LS_BULK_SAVE
        DO   IP=1,NPART
          SCALE_LS_PART(IP) = SCALE_LS_PART_SAVE(IP)
          B_LS_PART(IP)     = B_LS_PART_SAVE(IP)
        ENDDO
        UOVER_ATOM = UOVER_SAVE
C
C--Restore remaining parameters
      ELSE
        CALL ERRWRT(1,'Wrong argument for SAVE_ALL_PARAMETERS')
      ENDIF
      RETURN
      END
C
      SUBROUTINE RESIDVAL(F,qqm,qqv,am,v,dv,nmodel,ndist,n_target,
     &     n_object)
      use weights
      use agreem
      use rharvest
      implicit none
C
C----Calculate value of residual (X_ray + geom)
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'ncs_rest.fh'
      INCLUDE 'anom.fh'

      integer qqm,qqv,ia,ia2,im,nmodel,ia_sh,im_sh
      integer ndist
      real f
      integer n_target(ndist),n_object(ndist)
      real am(qqm),v(qqv),dv(qqv)


      REAL GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
c
      real h_xxd,h_uud(3),h_uqd,h_qqd,over_tot
      real h_uud_anom(3),h_uqd_anom,h_qqd_anom,g_now,h_now
      integer i,il,il1,wave_pos,ir,num_ref_tot,it,itx,it_sh,itx_sh
      INTEGER NV1
      integer, allocatable :: ATOM_REF_save(:)
      real, allocatable ::  ATOM_occ_save(:)
      integer, allocatable :: ATOM_ligand(:), ATOM_ligand_sw(:)
      real, allocatable :: gx_save(:), gu_save(:)
      integer ierror,ipos,n_atom_tot
      REAL ALPHA,TLS_TRACE,wg,wx
      LOGICAL LINITIAL,anom

C
C---Restore vital parameters
cd      CALL RESTORE_VIT
c
c---Initialise vectors
      n_atom_tot = sum(n_atom_mod(1:nmodel))
      gx(1:3*n_atom_tot)       = 0.
      gu1(1:6*n_atom_tot)      = 0.
      gu1_anom(1:6*n_atom_tot) = 0.
      gq(1:n_atom_tot)         = 0.
      gq_anom(1:n_atom_tot)    = 0.
      am(1:qqm)                = 0.0
      v(1:qqv)                 = 0.0

      NRESTR = 0
      anom=.false.
      if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras.or.DPPI_mad) anom=.true.
C
c---Make list of restraint for second derivatives. 

C---Call geom and refall/sfref for calculation
C---geometric and x_ray terms respectively
      F     = 0.0
      FGEOM = 0.0
      IF(GEOM_FLAG) THEN
         HNRESTR = 0
         CALL GEOM(qqm,qqv,am,v,ndist,n_target,n_object)
         F = FGEOM
      ENDIF
C
C---No X-ray. We can return now.
      IF(.NOT.X_RAY_FLAG) RETURN

c---p+l 2 models. as long as there is no geometrry for the second model we need to do trick like this:
c   1. model from pdb contains P+L, 2. model contains L only. For X-ray we need to exclude 
c   L part from 1. model now.
      if (DPPI_pl.and.nmodel.eq.2) then
        allocate(atom_ligand(n_atom_mod(2)))
        allocate(atom_ligand_sw(n_atom_mod(1)))
        allocate(atom_ref_save(n_atom_mod(2)))
        allocate(atom_occ_save(n_atom_mod(2)))
        do     IA2=1,N_ATOM_mod(2)
          atom_ligand(ia2)=0
          do     IA=1,N_ATOM_mod(1)
            if ( ATM_NAME_INP_mod(ia,1).eq.ATM_NAME_INP_mod(ia2,2) .and.
     &           ID_ALT_mod(ia,1).eq.ID_ALT_mod(ia2,2) .and.
     &           RES_NAME_mod(I_RESID_mod(ia,1),1).eq.
     &           RES_NAME_mod(I_RESID_mod(ia2,2),2) )  then
              atom_ligand(ia2)=IA
              if (.not.ligin1) then
                atom_ref_save(ia2)=ATOM_REF_mod_FLAG(IA,1)
                atom_occ_save(ia2)=OCCUP_mod(IA,1)
                ATOM_REF_mod_FLAG(IA,1)=0
                OCCUP_mod(IA,1) = 0.
              endif
c              write(*,*) 'ligand:',ia2,ia,
c     +         RES_NAME_mod(I_RESID_mod(ia,1),1),ATOM_REF_mod_FLAG(IA,1)
            endif
          enddo
        enddo
        do ia=1,n_atom_mod(1)
          atom_ligand_sw(ia) = 0
          do ia2=1,n_atom_mod(2)
            if (atom_ligand(ia2).eq.ia)   atom_ligand_sw(ia) = ia2
          enddo
        enddo
      endif
c
      do im=1,nmodel
        DO IA = 1,N_ATOM_mod(im)
          DO I = 1,6
            UANISO_OLD_mod(I,IA,im) = U_ANISO_mod(I,IA,im)
          ENDDO
        ENDDO
      enddo
      IF(NTLS_CYCLE.GT.0.OR.TLS_FILE_FLAG) THEN
        LINITIAL = .FALSE.
        CALL TLS2ANISOU(LINITIAL)
        CALL MAKE_U_POSITIVE(nmodel)
        UOVER_ATOM = 0.0
      ENDIF
      CALL REFALL(nmodel)
      if(nccref.le.0) return
C

c---Add contibution of TLS here.
      WX = 1.0
      WG = 1.0
C
C---Ncs constraints here.
C
c
c---p+l 2 models. Return back the excluded atoms. Then return back the excluded gradients.
c   Then copy 1.->2. geom and 2->1 X-ray for L in xgeomadd.
c   And finally later  apply the same shifts for L atoms in both 1 and 2.
      if (DPPI_pl.and.nmodel.eq.2.and..not.ligin1) then
        do     IA2=1,N_ATOM_mod(2)
          if (atom_ligand(ia2).ne.0) then
            ATOM_REF_mod_FLAG(atom_ligand(ia2),1) = atom_ref_save(ia2)
            OCCUP_mod(atom_ligand(ia2),1) = atom_occ_save(ia2)
          endif
        enddo
      endif
c--- now returning back the excluded gradients (inserting them into array with 0 value)
      itx = 1
      IT = 1
      it_sh=1
      itx_sh=1
      if(DPPI_pl.and.nmodel.eq.2.and..not.ligin1) then
        allocate(gx_save(3*n_atom_tot))
        allocate(gu_save(6*n_atom_tot))
        gx_save(1:3*n_atom_tot) = gx(1:3*n_atom_tot)
        gu_save(1:6*n_atom_tot) = gu1(1:6*n_atom_tot)
      	do im=1,nmodel
      	  ia2=0
      	  do ia=1,N_ATOM_mod(im)
        	if (im.eq.1) ia2 = atom_ligand_sw(ia)
        	if ( ia2.ne.0 .and. atom_ref_mod_flag(ia,im).ne.0 ) then
              gx(ITX) =  0.0
              gx(ITX+1) =  0.0
              gx(ITX+2) =  0.0
              gu1(IT)   =  0.0
              if (U_ANISO_mod(2,IA,im).gt.0.0) then
                gu1(IT+1) = 0.0
                gu1(IT+2) = 0.0
                gu1(IT+3) = 0.0
                gu1(IT+4) = 0.0
                gu1(IT+5) = 0.0
              endif
            else
              gx(itx) = gx_save(itx_sh)
              gx(itx+1) = gx_save(itx_sh+1)
              gx(itx+2) = gx_save(itx_sh+2)
              itx_sh = itx_sh + 3
              if(U_ANISO_mod(2,ia,im).EQ.0.0) then
                gu1(it) = gu_save(it_sh)
                it_sh = it_sh + 1
              else
                gu1(it)   = gu_save(it_sh)
                gu1(it+1) = gu_save(it_sh+1)
                gu1(it+2) = gu_save(it_sh+2)
                gu1(it+3) = gu_save(it_sh+3)
                gu1(it+4) = gu_save(it_sh+4)
                gu1(it+5) = gu_save(it_sh+5)
                it_sh = it_sh + 6
              endif
            endif
            itx = itx + 3
            if(U_ANISO_mod(2,IA,im).EQ.0.0) then
              IT = IT + 1
            else
              IT = IT + 6
            endif
          enddo  
        enddo
        deallocate(gx_save)
        deallocate(gu_save)
      endif
c
      CALL XGEOMADD(FXRAY,FGEOM,F,WX,WG,qqm,qqv,AM,V,
     &     ndist,n_target,n_object,GX,GU1,GQ,
     &     gu1_anom,gq_anom,nmodel,atom_ligand,atom_ligand_sw,IERROR)
c
      if (DPPI_pl.and.nmodel.eq.2) then
        deallocate(atom_ref_save)
        deallocate(atom_occ_save)
        deallocate(atom_ligand)
        deallocate(atom_ligand_sw)
      endif
c
c--Try here and see what happens.
c!!!
c         im=1
c         gover_anom = 0.0
c         hover_anom = 0.0
c         ipos=0
c         do i=1,n_atom
c          if(atom_ref_flag(i).gt.0) then
c              CALL FAST_HESSIAN_DIAGONAL(I,im,H_XXD,H_UUD,H_UQD,
c     &            H_QQD,h_uud_anom,h_uqd_anom,h_qqd_anom)
c            ipos = ipos + 1
c            gover_anom = gover_anom + gq_anom(ipos)*occup(i)
c            hover_anom = hover_anom + h_qqd_anom*occup(i)**2
c          	if (cs_anom(id_sf(i))) write(*,*)gq_anom(ipos),h_qqd_anom
c          endif
c         enddo
c         write(*,*)'anom_scale =',gover_anom/hover_anom
c            do il=1,nform_ano
c               f2prime(il,wave_pos) = 
c     &              f2prime(il,wave_pos)*(1.0+gover_anom/hover_anom)
c               write(*,*)'fpp:',f2prime(il,wave_pos)    
c            enddo
      if(anom.and.separate_anom_occ.and.occup_ref_flag) then
         ipos = 0

         wave_pos = dataset_wavenum(dataset_order(2))
         if(nform_ano.gt.0) then
c
c--We may need B values also
ccc           if (.not.substruct_flag.and.PPI.eq.'sadh') then
ccc           if (substruct_flag.and.PPI.eq.'sadh') then
c not performing anom occ refinement now
           if (1.eq.0) then
             ipos = 0
             do im=1,nmodel
               do i=1,n_atom_mod(im)
                 if(atom_ref_mod_flag(i,im).gt.0) then
                   CALL FAST_HESSIAN_DIAGONAL(I,im,H_XXD,H_UUD,H_UQD,
     &                 H_QQD,h_uud_anom,h_uqd_anom,h_qqd_anom)
                   ipos = ipos + 1
                   if(h_qqd_anom.gt.0.0) then
                     occup_anom(i) = occup_anom(i) + 
     &                    gq_anom(ipos)/h_qqd_anom
                     occup_anom_mod(i,im) = occup_anom_mod(i,im) + 
     &                    gq_anom(ipos)/h_qqd_anom
                     occup_anom(i) = min(max(0.0,occup_anom(i)),100.0)
                     occup_anom_mod(i,im) = 
     &                 min(max(0.0,occup_anom_mod(i,im)),100.0)
                     write(*,*)'occup_anom:',occup_anom(i)
                   endif
                 endif
               enddo
             enddo
           endif
         endif
      endif

      if(occup_ref_flag.and.all_scales_flag) then
ccc        if (.not.substruct_flag.and.PPI.eq.'sadh') then
        over_tot = 0.
        num_ref_tot = 0
        ipos = 1
        do im=1,nmodel
          do ia=1,n_atom_mod(im)
c           if( atom_ref_flag(i).gt.0 .and.
            if ( ATOM_REF_mod_FLAG(Ia,im)/10.gt.0 .and.
     &         (.not.occup_ref_anomonly_flag.or.
     &          cs_anom(id_sf_mod(ia,im))) ) then
              CALL FAST_HESSIAN_DIAGONAL(Ia,im,H_XXD,H_UUD,H_UQD,H_QQD,
     &                h_uud_anom,h_uqd_anom,h_qqd_anom)
cqqq - this is in order to fix slow occupancies divergence for substructure case.
cqqq - not the best thing in the world though, a better fix should be found later.
              if (ncycl.gt.2.and.substruct_flag)
c              if (ncycl.gt.2)
     &        then
                if (im.eq.1) occup(ia) = occup(ia) * scale_ls_over
                occup_mod(ia,im) = occup_mod(ia,im)* scale_ls_over
              endif
              if (h_qqd.gt.0.0.and.separate_anom_occ) then
                if (im.eq.1) occup(ia) = occup(ia) + gq(ipos)/h_qqd
                occup_mod(ia,im) = occup_mod(ia,im) + gq(ipos)/h_qqd
              elseif ( (h_qqd_anom+h_qqd).gt.0.0.and.
     &        	          .not.separate_anom_occ)  then
                occup_mod(ia,im) = occup_mod(ia,im) + 
     &             (gq_anom(ipos)+gq(ipos))/(h_qqd_anom+h_qqd)
                if (im.eq.1) occup(ia) = occup(ia) + 
     &             (gq_anom(ipos)+gq(ipos))/(h_qqd_anom+h_qqd)
              endif
              over_tot = over_tot + max(occup_mod(ia,im),1.)
              num_ref_tot = num_ref_tot + 1
              occup_mod(ia,im) = min(max(0.01,occup_mod(ia,im)),1.0)
              if (im.eq.1)  occup(ia) = min(max(0.01,occup(ia)),1.0)
              if (.not.separate_anom_occ.and.im.eq.1) 
     &          occup_anom(ia)=occup(ia)
              if (.not.separate_anom_occ) 
     &          occup_anom_mod(ia,im) = occup_mod(ia,im)
              if (verbref_5n) write(*,*)'occup:',ia,occup_mod(ia,im),
     +            gq_anom(ipos),gq(ipos),h_qqd_anom,H_QQD
            endif
            if ( ATOM_REF_mod_FLAG(Ia,im)/10.gt.0 )  ipos = ipos + 1
          enddo
        enddo
cqqq - this is in order to fix slow occupancies divergence for substructure case.
cqqq - not the best thing in the world though, a better fix should be found later.
        if (substruct_flag) then
c        if (1.eq.0) then
          over_tot = over_tot/num_ref_tot
          if (ncycl.le.2) then
            scale_llh_over=scale_llh_over*scale_ls_over
          else
            if (over_tot.gt.0.) scale_llh_over=scale_llh_over*over_tot
          endif
c      write(*,*) ncycl,over_tot,scale_ls_over,scale_llh_over
c        endif
c          write(*,*)
        endif
      endif
c      stop
c      cs_fii(1:n_atom) = cs_fii(1:n_atom)*(1+gover_ano/hover_anom)
c
c
c      stop
      do im=1,nmodel
        DO   IA=1,N_ATOM_mod(im)
          DO I=1,6
            if (im.eq.1) U_ANISO(I,IA) = UANISO_OLD_mod(I,IA,im)
            U_ANISO_mod(I,IA,im) = UANISO_OLD_mod(I,IA,im)
          ENDDO
        ENDDO
      enddo
C
C---Treat close atoms. I.e. if atoms are too close put restraints so that 
C---they will try to become same
C

c      IF(NUMBER_NCSC.GT.0) CALL NCS_CONST(QQM,QQV,AM,V,VAL,QQDEN)
c      ENDIF
C
C---Convert derivatives of U values to derivatives of S, where
C---U = S^T S + alpha I. S is triangular matrix. This reparameterisation 
C---ensures that U is positive definite. When applying shifts this fact 
C---should be remembered. This reparametrisation might change behaviour of
C---function 
cd      CALL CONVERT_DERIVS_TO_S
C
      RETURN
      END
C
      SUBROUTINE CLOSE_ATOM_CONDITION(AM,nmodel,ndist,n_target,n_object,
     &     nsym_dist)
      use weights
      use agreem
      IMPLICIT NONE
C
C---  Check and try to stabilise cases when atoms are too close
c---  each other
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'tls.fh'
C
      REAL AM(*)
      integer nmodel
      integer ndist
      integer n_target(ndist),n_object(ndist),nsym_dist(4,ndist)
C
C---  local variables
      INTEGER  I,J,K
      INTEGER ID,IA1,IA2,IA,im
      INTEGER IPOS,IA11
      INTEGER COUNT_UP
      REAL CLOSE_DIST,DIST1
      INTEGER LWORK,INFO
      integer n_atom_tot
      REAL AMAT(3,3),AMAT1(3,3),E_V(3),WORKSPACE(40)
      REAL AMAX_AM,AM_ADD
      REAL AISO_ADD
      REAL CALC_DISTANCE
      EXTERNAL CALC_DISTANCE
c
      integer, allocatable :: u_hist(:)
C
      n_atom_tot=0
      do im=1,nmodel
        n_atom_tot=n_atom_tot+n_atom_mod(im)
      enddo
      allocate(u_hist(n_atom_tot))
      LWORK = 40
      INFO  = 0
      CLOSE_DIST = 0.6
      AISO_ADD   = 800.0
C
C---Find positions of U values in the diagonal of hessian
      COUNT_UP = NMPOS + 9*NDIS
      do im=1,1
        DO   IA=1,N_ATOM_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            U_HIST(IA) = COUNT_UP
            IF(U_ANISO_mod(2,IA,im).LE.0.0) THEN
              COUNT_UP = COUNT_UP + 1
            ELSE
              COUNT_UP = COUNT_UP + 21
            ENDIF
          ENDIF
        ENDDO
      enddo
C
C---loop over distances
      DO   ID=1,NDIS
        IA1 = N_OBJECT(ID)
        IA2 = N_TARGET(ID)
        DIST1 =  CALC_DISTANCE(IA1,IA2,NSYM_DIST(1,ID))
        IF(DIST1.LE.CLOSE_DIST) THEN
C
C---  Distance between atoms is too close. Sort them out
C
          IF(IA1.EQ.IA2) THEN
C
C--   Same atoms. Only one of them
             IA11 = ATOM_REF_mod_FLAG(IA1,1)/10
             IF(IA11.GT.0) THEN
                IPOS = 6*IA11-5
                AMAT(1,1) = AM(IPOS)
                AMAT(2,2) = AM(IPOS+1)
                AMAT(3,3) = AM(IPOS+2)
                AMAT(1,2) = AM(IPOS+3)
                AMAT(1,3) = AM(IPOS+4)
                AMAT(2,3) = AM(IPOS+5)
                AMAT(2,1) = AMAT(1,2)
                AMAT(3,1) = AMAT(1,3)
                AMAT(3,2) = AMAT(2,3)
cd                WRITE(*,*) AMAT
                call seig3dim(amat,e_v,info)
                if(info.gt.0) then
                  write(*,*)'Problem in close atom condition',info
                  stop
                endif
                E_V(1) = AMAX1(E_V(1),E_V(3)*(1.0-DIST1/CLOSE_DIST)*0.8)
                E_V(2) = AMAX1(E_V(2),E_V(3)*(1.0-DIST1/CLOSE_DIST)*0.8)
                DO   I=1,3
                  DO   J=1,3
                    AMAT1(I,J) = 0.0
                    DO   K=1,3
                      AMAT1(I,J) = AMAT1(I,J) + 
     &                      AMAT(K,I)*AMAT(K,J)*E_V(K)
                    ENDDO
                  ENDDO
                ENDDO
                AM(IPOS  ) = AMAT1(1,1)
                AM(IPOS+1) = AMAT1(2,2)
                AM(IPOS+2) = AMAT1(3,3)
                AM(IPOS+3) = AMAT1(1,2)
                AM(IPOS+4) = AMAT1(1,3)
                AM(IPOS+5) = AMAT1(2,3)
C
C---U values
              IF(U_ANISO_mod(2,IA1,1).LE.0.0) THEN
C---  
c---  Do nothing. Isotropic case
cd                WRITE(*,*)AM(U_HIST(IA1))

C---Isotropic case.
cd                IF(AM(U_HIST(IA1)).GT.100.0) AISO_ADD = AM(U_HIST(IA1))
cd                AM(U_HIST(IA1)) = AM(U_HIST(IA1)) + 
cd     &                (CLOSE_DIST-DIST1)/CLOSE_DIST*AISO_ADD
              ELSE
C
C---Anisotropic case. Eigenvaluse should be analysed.
                IPOS = U_HIST(IA1)
                AMAX_AM = AISO_ADD
                AMAX_AM = -1.0E32
                DO   I=1,6
                  AMAX_AM = AMAX1(AMAX_AM,AM(IPOS+I))
                ENDDO
                AM_ADD = AMAX_AM*(CLOSE_DIST-DIST1)/CLOSE_DIST
                DO   I=1,6
                  AM(IPOS+I) = AM(IPOS+I) + AM_ADD
                ENDDO
              ENDIF
              ENDIF
          ELSE
            GOTO 100
C
C---  Different atoms. Sort out diagonal terms only.
             IA11 = ATOM_REF_mod_FLAG(IA1,1)/10
             IF(IA11.GT.0) THEN
                IPOS = 6*IA11-5
                AMAX_AM    = AMAX1(AM(IPOS),
     &                             AMAX1(AM(IPOS+1),AM(IPOS+2)))
cd                WRITE(*,*) AMAX_AM
                AM_ADD     = AMAX_AM*(CLOSE_DIST-DIST1)/CLOSE_DIST
                AM(IPOS  ) = AM(IPOS  ) + AM_ADD
                AM(IPOS+1) = AM(IPOS+1) + AM_ADD
                AM(IPOS+2) = AM(IPOS+2) + AM_ADD
C
C---U values
                IF(U_ANISO_mod(2,IA1,1).LE.0.0) THEN
C---Isotropic case. do nothing.
                 IF(AM(U_HIST(IA1)).GT.100.0) AISO_ADD = AM(U_HIST(IA1))
                  AM(U_HIST(IA1)) = AM(U_HIST(IA1)) + 
     &                (CLOSE_DIST-DIST1)/CLOSE_DIST*AISO_ADD
                ELSE
C
C---Anisotropic case.
                  IPOS = U_HIST(IA1)
cd                  AMAX_AM = AISO_ADD
                  AMAX_AM = -1.0E32
                  DO   I=1,6
                    AMAX_AM = AMAX1(AMAX_AM,AM(IPOS+I))
                  ENDDO
                  AM_ADD = AMAX_AM*(CLOSE_DIST-DIST1)/CLOSE_DIST
                  DO   I=1,6
                    AM(IPOS+I) = AM(IPOS+I) + AM_ADD
                  ENDDO
                ENDIF
              ENDIF
C
C---Second atom
              IA11 = ATOM_REF_FLAG(IA2)/10
              IF(IA11.GT.0) THEN
                IPOS = 6*IA11-5
                AMAX_AM    = AMAX1(AM(IPOS),
     &                             AMAX1(AM(IPOS+1),AM(IPOS+2)))
cd                WRITE(*,*) AMAX_AM
                AM_ADD     = AMAX_AM*(CLOSE_DIST-DIST1)/CLOSE_DIST
                AM(IPOS  ) = AM(IPOS  ) + AM_ADD
                AM(IPOS+1) = AM(IPOS+1) + AM_ADD
                AM(IPOS+2) = AM(IPOS+2) + AM_ADD
C
C---U values
                IF(U_ANISO_mod(2,IA1,1).LE.0.0) THEN
C---Isotropic case. This position might be empty. So process it.
                 IF(AM(U_HIST(IA2)).GT.100.0) AISO_ADD = AM(U_HIST(IA2))
                 AM(U_HIST(IA2)) = AM(U_HIST(IA2)) + 
     &                (CLOSE_DIST-DIST1)/CLOSE_DIST*AISO_ADD
                ELSE
C
C---Anisotropic case.
                IPOS = U_HIST(IA2)
cd                AMAX_AM = AISO_ADD
                AMAX_AM = -1.0E32
                DO   I=1,6
                  AMAX_AM = AMAX1(AMAX_AM,AM(IPOS+I))
                ENDDO
                AM_ADD = AMAX_AM*(CLOSE_DIST-DIST1)/CLOSE_DIST
                DO   I=1,6
                  AM(IPOS+I) = AM(IPOS+I) + AM_ADD
                ENDDO
              ENDIF
              ENDIF
          ENDIF
C
C---U values
C
        ENDIF
 100    CONTINUE
      ENDDO
      deallocate(u_hist)
      RETURN
      END
C
C
      REAL FUNCTION CALC_DISTANCE(IA1,IA2,NSYM_DIST)
      IMPLICIT NONE
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
C
      INTEGER I,IX
      INTEGER IS,ITX(3)
      INTEGER IA1,IA2,NSYM_DIST(4)
      integer im
      REAL XYZ_TMP(3),XYZ_TMP1(3)
      REAL XYZ1(3),XYZ2(3)
      REAL DIST1
      LOGICAL ERROR
C
      im = 1
      IS = NSYM_DIST(1)
      IF(IS.LE.0) THEN
        IS = 1
        ITX(1) = 0
        ITX(2) = 0
        ITX(3) = 0
      ELSE
        ITX(1) = NSYM_DIST(2)
        ITX(2) = NSYM_DIST(3)
        ITX(3) = NSYM_DIST(4)
      ENDIF
      IF(IS.GT.1.OR.ITX(1).NE.0.OR.ITX(2).NE.0.OR.ITX(3).NE.0) THEN
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD_mod(1,IA2,im),XYZ_TMP,
     &    ERROR)
        DO   I=1,3
          XYZ_TMP1(I) = RealSymmMatrx(I,1,IS)*XYZ_TMP(1) +
     &                  RealSymmMatrx(I,2,IS)*XYZ_TMP(2) +
     &                  RealSymmMatrx(I,3,IS)*XYZ_TMP(3) +
     &                  RealSymmMatrx(I,4,IS) + FLOAT(ITX(I))
        ENDDO 
        CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZ_TMP1,XYZ2,ERROR)
      ELSE
        DO  IX=1,3
          XYZ2(IX) = XYZ_CRD_mod(IX,IA2,im)
        ENDDO
      ENDIF
C
      DO   IX=1,3
        XYZ1(IX) = XYZ_CRD_mod(IX,IA1,im)
      ENDDO
      DIST1 = SQRT(ABS((XYZ1(1)-XYZ2(1))**2+(XYZ1(2)-XYZ2(2))**2+
     &                 (XYZ1(3)-XYZ2(3))**2))
     
      CALC_DISTANCE = DIST1

      END
      
      SUBROUTINE ADD_TLS2DERIVS(nmodel,GX,GU1)
C
C---Adds contribution of TLS to individual atomic derivatives. At the
C---moment only the fact that atoms could be refined isotropicly but
c---due to TLS they could appear anisotropicly so derivatives for anisotropic
C---atoms will be calculated and they have to be converted to isotropic
c---case. In more general case correlation between positional and thermal 
C---parameters should be taken into account also (More precisely as U values
C---are dependent on positional parameters U = U(x), derivatives of 
C---positional parameters will be affected by U)
      IMPLICIT NONE
      integer nmodel
      REAL GX(*),GU1(*)
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'tls.fh'
C
      INTEGER IA,I,IPOSV1,IPOSV2,IA1,IA11,im
      REAL DU_ISO,D2U_ISO,HUU_MAX
C
      IPOSV1 = 0
      IPOSV2 = 0
      HUU_MAX = -1.0E32
      do im=1,nmodel
        DO   IA=1,N_ATOM_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            IA1 = ATOM_REF_mod_FLAG(IA,im)/10
            IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
            IF(IA11.GE.3) THEN
              IF(UANISO_OLD_mod(2,IA,im).NE.0.0) THEN
C       
c----Atom is anisotropic copy gradients
                DO   I=1,6
                  IPOSV1 = IPOSV1 + 1
                  IPOSV2 = IPOSV2 + 1
                  GU1(IPOSV1) = GU1(IPOSV2)
                ENDDO
        
              ELSEIF (UANISO_OLD_mod(2,IA,im).LE.0.0.AND.
     &                IGROUP_mod(IA,im).GT.0) THEN
C       
c---Atom is isotropic
                DU_ISO = 
     &               (GU1(IPOSV2+1)+GU1(IPOSV2+2)+GU1(IPOSV2+3))
                IPOSV2 = IPOSV2 + 6
                IPOSV1 = IPOSV1 + 1
                GU1(IPOSV1) = DU_ISO
              ELSEIF (UANISO_OLD_mod(2,IA,im).LE.0.0) THEN
                IPOSV1 = IPOSV1 + 1
                IPOSV2 = IPOSV2 + 1
                GU1(IPOSV1) = GU1(IPOSV2)
              ENDIF
            ELSEIF (UANISO_OLD_mod(2,IA,im).LE.0.0.AND.
     &              IGROUP_mod(IA,im).EQ.0) THEN
              IPOSV1      = IPOSV1 + 1
              IPOSV2      = IPOSV2 + 1
              GU1(IPOSV1) = 0.0
            ELSEIF (UANISO_OLD_mod(2,IA,im).EQ.0.0.AND.
     &              IGROUP_mod(IA,im).NE.0) THEN
              IPOSV1      = IPOSV1 + 1
              IPOSV2      = IPOSV2 + 6
              GU1(IPOSV1) = 0.0
            ELSEIF (UANISO_OLD_mod(2,IA,im).NE.0.0) THEN
              DO   I=1,6
                IPOSV1 = IPOSV1 + 1
                IPOSV2 = IPOSV2 + 1
                GU1(IPOSV1) = 0.0
              ENDDO
            ENDIF
          ENDIF
        ENDDO
      enddo
C            
      RETURN
      END
C
      SUBROUTINE ADD_TLS2DERIVS1(nmodel,GX,GU1,HX,HUU)
C
C---Adds contribution of TLS to individual atomic derivatives. At the
C---moment only the fact that atoms could be refined isotropicly but
c---due to TLS they could appear anisotropicly so derivatives for anisotropic
C---atoms will be calculated and they have to be converted to isotropic
c---case. In more general case correlation between positional and thermal 
C---parameters should be taken into account also (More precisely as U values
C---are dependent on positional parameters U = U(x), derivatives of 
C---positional parameters will be affected by U)
      IMPLICIT NONE
      integer nmodel
      REAL GX(*),GU1(*),HX(*),HUU(*)
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'tls.fh'
C
      INTEGER IA,I,IPOSM1,IPOSM2,IPOSV1,IPOSV2,IA1,IA11,im
      REAL DU_ISO,D2U_ISO,HUU_MAX
C
cd      do im=1,nmodel
cd        DO   IA=1,N_ATOM_mod(im)
cd          DO I=1,6
cd            if (im.eq.1) U_ANISO(I,IA) = UANISO_OLD_mod(I,IA,im)
cd            U_ANISO_mod(I,IA,im) = UANISO_OLD_mod(I,IA,im)
cd          ENDDO
cd        ENDDO
cd      enddo
      IPOSM1 = 0
      IPOSM2 = 0
      IPOSV1 = 0
      IPOSV2 = 0
      HUU_MAX = -1.0E32
      do im=1,nmodel
        DO   IA=1,N_ATOM_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            IA1 = ATOM_REF_mod_FLAG(IA,im)/10
            IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
            IF(IA11.GE.3) THEN
              IF (UANISO_OLD_mod(2,IA,im).GT.0.0) THEN
C       
c----Atotom is anisotropic copy gradients and second derivatives
                DO   I=1,6
                  IPOSV1 = IPOSV1 + 1
                  IPOSV2 = IPOSV2 + 1
                  GU1(IPOSV1) = GU1(IPOSV2)
                ENDDO
                DO   I=1,21
                  IPOSM1 = IPOSM1 + 1
                  IPOSM2 = IPOSM2 + 1
                  HUU(IPOSM1) = HUU(IPOSM2)
                ENDDO
              ELSEIF (UANISO_OLD_mod(2,IA,im).LE.0.0.AND.
     &                IGROUP_mod(IA,im).GT.0) THEN
C       
c---Atomom is isotropic
                DU_ISO = 
     &               (GU1(IPOSV2+1)+GU1(IPOSV2+2)+GU1(IPOSV2+3))
                IPOSV2 = IPOSV2 + 6
                IPOSV1 = IPOSV1 + 1
                GU1(IPOSV1) = DU_ISO
                D2U_ISO = (HUU(IPOSM2+1)+HUU(IPOSM2+2)+HUU(IPOSM2+3)
     &             +2.0*(HUU(IPOSM2+7)+HUU(IPOSM2+8)+HUU(IPOSM2+12)))
                IPOSM1 = IPOSM1 + 1
                HUU(IPOSM1) = D2U_ISO
                IPOSM2 = IPOSM2 + 21
              ELSEIF(UANISO_OLD_mod(2,IA,im).LE.0.0) THEN
                IPOSV1 = IPOSV1 + 1
                IPOSV2 = IPOSV2 + 1
                IPOSM1 = IPOSM1 + 1
                IPOSM2 = IPOSM2 + 1
                GU1(IPOSV1) = GU1(IPOSV2)
                HUU(IPOSM1) = HUU(IPOSM2)
              ENDIF
            ELSEIF (UANISO_OLD_mod(2,IA,im).EQ.0.0.AND.
     &              IGROUP_mod(IA,im).EQ.0) THEN
              IPOSV1      = IPOSV1 + 1
              IPOSV2      = IPOSV2 + 1
              GU1(IPOSV1) = 0.0
              IPOSM1     = IPOSM1 + 1
              IPOSM2     = IPOSM2 + 1
              HUU(IPOSM1)=  0.0
            ELSEIF (UANISO_OLD_mod(2,IA,im).EQ.0.0.AND.
     &              IGROUP_mod(IA,im).NE.0) THEN
              IPOSV1      = IPOSV1 + 1
              IPOSV2      = IPOSV2 + 6
              GU1(IPOSV1) = 0.0
              IPOSM1     = IPOSM1 + 1
              IPOSM2     = IPOSM2 + 21
              HUU(IPOSM1)=  0.0
            ELSEIF (UANISO_OLD_mod(2,IA,im).NE.0.0) THEN
              DO   I=1,6
                IPOSV1 = IPOSV1 + 1
                IPOSV2 = IPOSV2 + 1
                GU1(IPOSV1) = 0.0
              ENDDO
              DO   I=1,21
                IPOSM1 = IPOSM1 + 1
                IPOSM2 = IPOSM2 + 1
                HUU(IPOSM1) = 0.0
              ENDDO
            ENDIF
          ENDIF
        ENDDO
      enddo
C
      RETURN
      END
C
      SUBROUTINE FINAL_CHECK_XRAY_DERIVS(nmodel,HX,HU)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'vitals.fh'
      REAL HX(*),HU(*)
      integer nmodel
C
C---Tries to make derivatives positive. It might happen with current version
      INTEGER IA1,IA11,IA,IU,IPAR,IPARU,im
      REAL HX_MAX,HU_MAX,HU_MAX1,HX_MAX1
C
      HX_MAX = -1.0E32
      HU_MAX = -1.0E32
      IPAR = 0
      IPARU = 0
      do im=1,nmodel
        DO   IA=1,N_ATOM_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
           IA1 = ATOM_REF_mod_FLAG(IA,im)/10
           IA11 = ATOM_REF_mod_FLAG(IA,im)- IA1*10
           IF(IA11.GT.2) THEN
             HX_MAX = AMAX1(HX_MAX,AMAX1(HX(IPAR+1),
     &                AMAX1(HX(IPAR+2),HX(IPAR+3))))
             IPAR = IPAR + 6
             IF(ITEMP.GT.0) THEN
               IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                 HU_MAX = AMAX1(HU_MAX,HU(IPARU+1))
                 IPARU  = IPARU + 1
               ELSE
                 HU_MAX = AMAX1(HU_MAX,AMAX1(HU(IPARU+1),
     &                    AMAX1(HU(IPARU+2),
     &                    AMAX1(HU(IPARU+3),AMAX1(HU(IPARU+4),
     &                    AMAX1(HU(IPARU+5),HU(IPARU+6)))))))
                 IPARU = IPARU + 21
               ENDIF
             ENDIF
           ELSE
             IPAR = IPAR + 6
             IF(ITEMP.GT.0) THEN
               IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                 IPARU = IPARU + 1
               ELSE
                 IPARU = IPARU + 21
               ENDIF
             ENDIF
           ENDIF
          ENDIF
        ENDDO
      enddo
C
      HX_MAX1 = HX_MAX
      HU_MAX1 = HU_MAX
      IPAR = 0
      IPARU = 0
      do im=1,nmodel
        DO   IA=1,N_ATOM_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            IA1 = ATOM_REF_mod_FLAG(IA,im)/10
            IA11 = ATOM_REF_mod_FLAG(IA,im)- IA1*10
            IF(IA11.GT.2) THEN
              IF(HX(IPAR+1).LE.0.0.OR.HX(IPAR+2).LE.0.0.OR.
     &          HX(IPAR+3).LE.0.0) THEN
                HX(IPAR+1) = HX_MAX1
                HX(IPAR+2) = HX_MAX1
                HX(IPAR+3) = HX_MAX1
                HX(IPAR+4) = 0.0
                HX(IPAR+5) = 0.0
                HX(IPAR+6) = 0.0
              ENDIF
              IPAR = IPAR + 6
              IF(ITEMP.GT.0) THEN
                IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                  IF(HU(IPARU+1).LE.0.0) HU(IPARU+1) = HU_MAX1
                  IPARU  = IPARU + 1
                ELSE
                  IF(HU(IPARU+1).LE.0.0.OR.HU(IPARU+2).LE.0.0.OR.
     &              HU(IPARU+4).LE.0.0.OR.HU(IPARU+5).LE.0.0.OR.
     &              HU(IPARU+6).LE.0.0) THEN
                    DO  IU=1,6
                      HU(IPARU+IU) = HU_MAX1
                    ENDDO
                    DO  IU=7,21
                      HU(IPARU+IU) = 0.0
                    ENDDO
                  ENDIF
                  IPARU = IPARU + 21
                ENDIF
              ENDIF
            ELSE
              IPAR = IPAR + 6
              IF(ITEMP.GT.0) THEN
                IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                  IPARU = IPARU + 1
                ELSE
                  IPARU = IPARU + 21
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      enddo

      RETURN
      END
C---
      subroutine bscale_to_shifts(nmodel,uover_atom,dv)
      implicit none
c
c---  Add overall scales to shifts.
      include 'atom_com.fh'
      include 'models.fh'
      include 'vitals.fh'
c
      integer nmodel
      real uover_atom
      real dv(*)
c
c---  locals
      integer lv,ia,im

      if(itemp.gt.0) then
         lv = nvpos + 1
         do im=1,nmodel
           do ia=1,n_atom_mod(im)
             if(atom_ref_mod_flag(ia,im).gt.0) then
               if(u_aniso_mod(2,ia,im).le.0.0) then
                  dv(lv) = dv(lv) + uover_atom
                  lv = lv + 1
               else
                  dv(lv:(lv+2)) = dv(lv:(lv+2)) + uover_atom
                  lv = lv + 6
               endif
             endif
           enddo
         enddo
      endif
c      uover_atom = 0.0
c      b_ls_over = 0.0
      return
      end
C
      SUBROUTINE APPLY(nmodel,STEP,STEPB,dv)
      IMPLICIT NONE
c
c---Subroutine applies shifts to parameters
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'occupancy_params.fh'
      include 'anom.fh'

      integer nmodel
      REAL STEP,STEPB

      integer nshft
      REAL DV(*)
      INTEGER IA,IANISO,LV,IVPOS,im
      real c1,c2
      real avdvx,avdvy,avdvz,dvx2,dvy2,dvz2
      real shift_allow_high,shift_allow_low
      real rms_shift,ave_shift,max_shift
      REAL    DVX,DVY,DVZ,DBDF
      REAL    U_DELTA(6)
      REAL    U_MIN,UEIGEN
      REAL UANISO0(3,3),UANISO1(6),EVALUE(3),WORKSPACE(20)
      INTEGER LWORK,INFO,I,II,IERROR
      integer inegatives,irefine
      real    shift_correct
C
      LWORK = 20
C
C---First analyse if U shifts are too large. If so then reduce shifts
C
      inegatives = 0
      irefine    = 0 
      shift_correct = 1.0
      IF(ITEMP.GT.0) THEN
        c2 = BDAMP*STEPB
        LV = NVPOS + 1
        do im=1,nmodel
          DO     IA=1,N_ATOM_mod(im)
            IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
              irefine = irefine + 1
              IF(U_ANISO_mod(2,IA,im).LE.0.0) THEN
C     
C---  Isotropic U-values
                DBDF = DV(LV)*c2
                IF(.NOT.(EXCLUDE_OCC_B.AND.OCCUP_REF_FLAG)) THEN
                  IF(U_ANISO_mod(1,IA,im) + DBDF.LE.BresetMin) then
                    inegatives = inegatives + 1
cd                    WRITE(*,*)U_ANISO(1,IA)+DBDF
                  ENDIF
                  LV = LV + 1
                ENDIF
              ELSE
C     
C---Anisotropic U-values
                  u_delta(1:6) = dv(lv:(lv+5))
                  lv = lv + 6
                IF(.NOT.(EXCLUDE_OCC_B.AND.OCCUP_REF_FLAG)) THEN
                  DO   IANISO=1,6
                    DBDF               = c2*U_DELTA(IANISO)
                    UANISO1(IANISO)  = U_ANISO_mod(IANISO,IA,im) + DBDF
                  ENDDO
C     
C---Make U values positive
                  UANISO0(1,1) = UANISO1(1)
                  UANISO0(2,2) = UANISO1(2)
                  UANISO0(3,3) = UANISO1(3)
                  UANISO0(1,2) = UANISO1(4)
                  UANISO0(1,3) = UANISO1(5)
                  UANISO0(2,3) = UANISO1(6)
                  UANISO0(2,1) = UANISO0(1,2)
                  UANISO0(3,1) = UANISO0(1,3)
                  UANISO0(3,2) = UANISO0(2,3)
                  call seig3dim(uaniso0,evalue,info)
cd     &                            LWORK,INFO)
                  if(info.gt.0) then
                    write(*,*)'Problem in apply',info
                    stop
                  endif
                  IF(EVALUE(1).LT.BresetMin.OR.
     &               EVALUE(2).LT.BresetMin.OR.
     &               EVALUE(3).LT.BresetMin) THEN
                    inegatives = inegatives + 1
cd                    WRITE(*,*)EVALUE(1),EVALUE(2),EVALUE(3)
                  ENDIF        
                ENDIF
              ENDIF
            ENDIF
          ENDDO
        enddo
        if(inegatives.gt.1) shift_correct = 0.5
cd        WRITE(*,*)inegatives,inegatives/irefine
      ENDIF
cd      stop

C
C--   Positional
C--
C
C---  First find maximum, average and rms shifts. They can be used to modify 
C--   shift lengths
C
      c1 = STEP*PDAMP*shift_correct
      IF(NVPOS.GT.0) THEN
        call find_avemaxrms(NVPOS,DV,ave_shift,max_shift,rms_shift)
cd        write(*,*)'average, maximum and rms ',
cd     &                   ave_shift*c1,max_shift*c1,rms_shift*c1
C
C---Now use this information for shift readjustment
        
        IVPOS = 0

        shift_allow_high = (ave_shift + 10.0*rms_shift)*c1
        shift_allow_low  = (ave_shift - 10.0*rms_shift)*c1
        shift_allow_high = amax1(0.0,amin1(shift_allow_high,0.35))
        shift_allow_low  = amin1(0.0,amax1(shift_allow_low,-0.35))
        shift_allow_high =  0.5
        shift_allow_low  = -0.5
        avdvx = 0.0
        avdvy = 0.0
        avdvz = 0.0
        dvx2  = 0.0
        dvy2  = 0.0
        dvz2  = 0.0
        nshft = 0
        do im=1,nmodel
          DO     IA=1,N_ATOM_mod(im)
            IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
              DVX           = DV(IVPOS+1)*c1
              if(DVX.gt.shift_allow_high) DVX = shift_allow_high
              if(DVX.lt.shift_allow_low ) DVX = shift_allow_low
c      if (im.eq.2.or.ia.eq.100) write(*,*)'appl',XYZ_CRD_mod(1,IA,im),
c     &  DVX,DV(IVPOS+1),c1,ivpos+1
              DVY           = DV(IVPOS+2)*c1
              if(DVY.gt.shift_allow_high) DVY = shift_allow_high
              if(DVY.lt.shift_allow_low ) DVY = shift_allow_low
              DVZ           = DV(IVPOS+3)*c1
              if(DVZ.gt.shift_allow_high) DVZ = shift_allow_high
              if(DVZ.lt.shift_allow_low ) DVZ = shift_allow_low
              IVPOS         = IVPOS + 3
              if (im.eq.1) XYZ_CRD(1,IA) = XYZ_CRD(1,IA) + DVX
              if (im.eq.1) XYZ_CRD(2,IA) = XYZ_CRD(2,IA) + DVY
              if (im.eq.1) XYZ_CRD(3,IA) = XYZ_CRD(3,IA) + DVZ
              XYZ_CRD_mod(1,IA,im) = XYZ_CRD_mod(1,IA,im) + DVX
              XYZ_CRD_mod(2,IA,im) = XYZ_CRD_mod(2,IA,im) + DVY
              XYZ_CRD_mod(3,IA,im) = XYZ_CRD_mod(3,IA,im) + DVZ
              avdvx = avdvx + dvx
              avdvy = avdvy + dvy
              avdvz = avdvz + dvz
              dvx2 = dvx2 + dvx**2
              dvy2 = dvy2 + dvy**2
              dvz2 = dvz2 + dvz**2
              nshft = nshft + 1
            ENDIF
          ENDDO
        enddo
        avdvx = avdvx/nshft
        avdvy = avdvz/nshft
        avdvz = avdvz/nshft
        dvx2  = dvx2/nshft
        dvy2  = dvy2/nshft
        dvz2  = dvz2/nshft
        dvx2 = sqrt(dvx2-avdvx*avdvx)
        dvy2 = sqrt(dvy2-avdvy*avdvy)
        dvz2 = sqrt(dvz2-avdvz*avdvz)
c        write(*,*)'averages and sigmas =',avdvx,avdvy,avdvz,
c     &       dvx2,dvy2,dvz2
      ENDIF
C
C---  Thermal
C---  Similarly for B values. Shifts should not bee too large
C---  
      c2 = BDAMP*STEPB*shift_correct
      c1 = c2*PISQ8
      IF(ITEMP.GT.0) THEN
C
C---  Find average, maximum and rms shifts. How to define tese terms for
C---  anisotropic ADPs
C
        call find_avemaxrms(NVTMP,DV(NVPOS+1),ave_shift,max_shift,
     &                              rms_shift)
c        ave_shift = ave_shift + uover_atom
cd        write(*,*)'average, maximum and rms B shifts ',
cd     *           ave_shift*c1,max_shift*c1,rms_shift*c1
C
C---  Now use this inofrmation for shift readjustment
C
        LV = NVPOS + 1
        shift_allow_high = ( ave_shift + 10.0*rms_shift)*c2
        shift_allow_low  = ( ave_shift - 10.0*rms_shift)*c2
        shift_allow_high =  20.0/PISQ8
        shift_allow_low  = -20.0/PISQ8
        do im=1,nmodel
          DO     IA=1,N_ATOM_mod(im)
            IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
              IF(U_ANISO_mod(2,IA,im).LE.0.0) THEN
C       
C---  Isotropic U-values
                DBDF = DV(LV)*c2
                IF(.NOT.(EXCLUDE_OCC_B.AND.OCCUP_REF_FLAG)) THEN
                  if(DBDF.gt.shift_allow_high) DBDF = shift_allow_high
                  if(DBDF.lt.shift_allow_low ) DBDF = shift_allow_low
c      if (cs_anom(id_sf(ia))) write(*,*) '*****',
c     +    ia,U_ANISO(1,ia)*PISQ8,DBDF,c2,DV(LV)
                   if(im.eq.1) U_ANISO(1,IA) = U_ANISO_mod(1,IA,im)+DBDF
                   if(im.eq.1) U_ANISO(1,IA) = AMAX1(BresetMin,
     *                  AMIN1(U_ANISO_mod(1,IA,im),BResetMax))
                   U_ANISO_mod(1,IA,im) = U_ANISO_mod(1,IA,im) + DBDF
                   U_ANISO_mod(1,IA,im) = AMAX1(BresetMin,
     *                  AMIN1(U_ANISO_mod(1,IA,im),BResetMax))
c      if (cs_anom(id_sf(ia))) write(*,*) '*****',
c     +    ia,U_ANISO(1,ia)*PISQ8,U_ANISO(1,ia)
                ENDIF
                LV = LV + 1
              ELSE
C       
C---Anisisotropic U-values
                u_delta(1:6) = dv(lv:(lv+5))
                lv = lv + 6
c                u_delta(1:3) = u_delta(1:3) + uover_atom
                IF(.NOT.(EXCLUDE_OCC_B.AND.OCCUP_REF_FLAG)) THEN
                  DO   IANISO=1,6
                    DBDF               = c2*U_DELTA(IANISO)
                    if(DBDF.gt.shift_allow_high) DBDF = shift_allow_high
                    if(DBDF.lt.shift_allow_low ) DBDF = shift_allow_low
                    if (im.eq.1) U_ANISO(IANISO,IA) = 
     &                           U_ANISO_mod(IANISO,IA,im) + DBDF
                    U_ANISO_mod(IANISO,IA,im) = 
     &                U_ANISO_mod(IANISO,IA,im) + DBDF
                  ENDDO
C       
C---Make U values positive
                  UANISO0(1,1) = U_ANISO_mod(1,IA,im)
                  UANISO0(2,2) = U_ANISO_mod(2,IA,im)
                  UANISO0(3,3) = U_ANISO_mod(3,IA,im)
                  UANISO0(1,2) = U_ANISO_mod(4,IA,im)
                  UANISO0(1,3) = U_ANISO_mod(5,IA,im)
                  UANISO0(2,3) = U_ANISO_mod(6,IA,im)
                  UANISO0(2,1) = UANISO0(1,2)
                  UANISO0(3,1) = UANISO0(1,3)
                  UANISO0(3,2) = UANISO0(2,3)
                  call seig3dim(uaniso0,evalue,info)
c     &                          LWORK,INFO)
                  if(info.gt.0) then
                    write(*,*)'Problem in apply 2',info
                    stop
                  endif
        
                  EVALUE(1) =AMAX1(BResetMin,AMIN1(BResetMax,EVALUE(1)))
                  EVALUE(2) =AMAX1(BResetMin,AMIN1(BResetMax,EVALUE(2)))
                  EVALUE(3) =AMAX1(BResetMin,AMIN1(BResetMax,EVALUE(3)))
                  CALL EIGEN2U(EVALUE,UANISO0,UANISO1)
                  DO    IANISO=1,6
                    if (im.eq.1) U_ANISO(IANISO,IA) = UANISO1(IANISO)
                    U_ANISO_mod(IANISO,IA,im) = UANISO1(IANISO)
                  ENDDO              
                ENDIF
              ENDIF
            ENDIF
          ENDDO
        enddo
      ENDIF
C
C---Add occupancy shifts. This routine does not know 
C---style of occupancy refineement
      return
      IF(OCCUP_REF_FLAG) THEN
        LV = NVPOS + NVTMP + 1
        do im=1,nmodel
          DO   IA=1,N_ATOM_mod(im)
            IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
              OCCUP_mod(IA,im) = AMAX1( 0.0,AMIN1(1.0,
     &                           OCCUP_mod(IA,im)+QDAMP*DV(LV)) )
              LV = LV + 1
            ENDIF
          ENDDO
        enddo
      ENDIF
c      u_anom(1:6,1:n_atom) = u_aniso(1:6,1:n_atom)
C
C---
cd      CALL CHECK_OCCUPANCIES
      RETURN
      END
C
c
      subroutine add_shift_xonly(nmodel,step,dv)

      IMPLICIT NONE
c
c---Subroutine applies shifts to parameters
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'occupancy_params.fh'
      include 'anom.fh'

      integer nmodel
      REAL STEP,STEPB

      integer nshft
      REAL DV(*)
      INTEGER IA,IANISO,LV,IVPOS,im
      real c1,c2
      real avdvx,avdvy,avdvz,dvx2,dvy2,dvz2
      real shift_allow_high,shift_allow_low
      real rms_shift,ave_shift,max_shift
      REAL    DVX,DVY,DVZ,DBDF
      REAL    U_DELTA(6)
      REAL    U_MIN,UEIGEN
      REAL UANISO0(3,3),UANISO1(6),EVALUE(3),WORKSPACE(20)
      INTEGER LWORK,INFO,I,II,IERROR
      integer inegatives,irefine
      real    shift_correct
C
      LWORK = 20
C
C---First analyse if U shifts are too large. If so then reduce shifts
C
      inegatives = 0
      irefine    = 0 
      shift_correct = 1.0


      call find_avemaxrms(NVPOS,DV,ave_shift,max_shift,rms_shift)
C---Now use this information for shift readjustment
        
      IVPOS = 0

      shift_allow_high = (ave_shift + 10.0*rms_shift)*c1
      shift_allow_low  = (ave_shift - 10.0*rms_shift)*c1
      shift_allow_high = amax1(0.0,amin1(shift_allow_high,0.35))
      shift_allow_low  = amin1(0.0,amax1(shift_allow_low,-0.35))
      shift_allow_high =  0.5
      shift_allow_low  = -0.5
      avdvx = 0.0
      avdvy = 0.0
      avdvz = 0.0
      dvx2  = 0.0
      dvy2  = 0.0
      dvz2  = 0.0
      nshft = 0
      do im=1,nmodel
         DO     IA=1,N_ATOM_mod(im)
            IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
               DVX           = DV(IVPOS+1)*c1
               if(DVX.gt.shift_allow_high) DVX = shift_allow_high
               if(DVX.lt.shift_allow_low ) DVX = shift_allow_low
c     if (im.eq.2.or.ia.eq.100) write(*,*)'appl',XYZ_CRD_mod(1,IA,im),
c     &  DVX,DV(IVPOS+1),c1,ivpos+1
               DVY           = DV(IVPOS+2)*c1
               if(DVY.gt.shift_allow_high) DVY = shift_allow_high
               if(DVY.lt.shift_allow_low ) DVY = shift_allow_low
               DVZ           = DV(IVPOS+3)*c1
               if(DVZ.gt.shift_allow_high) DVZ = shift_allow_high
               if(DVZ.lt.shift_allow_low ) DVZ = shift_allow_low
               IVPOS         = IVPOS + 3
               if (im.eq.1) XYZ_CRD(1,IA) = XYZ_CRD(1,IA) + DVX
               if (im.eq.1) XYZ_CRD(2,IA) = XYZ_CRD(2,IA) + DVY
               if (im.eq.1) XYZ_CRD(3,IA) = XYZ_CRD(3,IA) + DVZ
               XYZ_CRD_mod(1,IA,im) = XYZ_CRD_mod(1,IA,im) + DVX
               XYZ_CRD_mod(2,IA,im) = XYZ_CRD_mod(2,IA,im) + DVY
               XYZ_CRD_mod(3,IA,im) = XYZ_CRD_mod(3,IA,im) + DVZ
               avdvx = avdvx + dvx
               avdvy = avdvy + dvy
               avdvz = avdvz + dvz
               dvx2 = dvx2 + dvx**2
               dvy2 = dvy2 + dvy**2
               dvz2 = dvz2 + dvz**2
               nshft = nshft + 1
            ENDIF
         ENDDO
      enddo

      RETURN
      END
c
      SUBROUTINE CONVERGED_SUBSTRUCT_HKON(nmodel,ncycl1,CONV_FLAG)
      use rharvest
      implicit none
      integer nmodel,ncycl1,i
      LOGICAL CONV_FLAG
c
      CONV_FLAG=.true.
      if (ncycl1.lt.10) then
        CONV_FLAG=.false.
      else
        do i=ncycl1-9,ncycl1-1
          if(abs(rfactor_vs_cycle(i)-rfactor_vs_cycle(ncycl1)).gt.0.001)
     &      conv_flag=.false.
          if(abs(fom_vs_cycle(i)-fom_vs_cycle(ncycl1)).gt.0.003)
     &      conv_flag=.false.
        enddo
      endif
      end
c
      SUBROUTINE CONVERGED_HKON(nmodel,AL,ALB,dv,CONV_FLAG)
      IMPLICIT NONE
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'vitals.fh'
C
      integer nmodel
      REAL AL,ALB
      LOGICAL CONV_FLAG
C
      REAL DV(*)
      INTEGER IA,IANISO,LV,IVPOS,im
C
      REAL DPMAX,DBMAX
      real eps_conv_x,eps_conv_b
C
C--   Positional
c--   This parameter should be replaced
      eps_conv_x = 0.000001
      eps_conv_b = 0.000001
      IF(NVPOS.GT.0) THEN
        IVPOS = 0
        DPMAX = -1.0E32
        do im=1,nmodel
          DO     IA=1,N_ATOM_mod(im)
            IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
              DPMAX           = AMAX1(DPMAX,ABS(DV(IVPOS+1)*AL))
              DPMAX           = AMAX1(DPMAX,ABS(DV(IVPOS+2)*AL))
              DPMAX           = AMAX1(DPMAX,ABS(DV(IVPOS+3)*AL))
              IVPOS           = IVPOS + 3
            ENDIF
          ENDDO
        enddo
      ENDIF
cd      WRITE(*,*)'MAximum positional shift ',DPMAX
C
C---Thermal
      IF(ITEMP.GT.0) THEN
        LV = NVPOS + 1
        DBMAX = -1.0E32
        do im=1,nmodel
          DO     IA=1,N_ATOM_mod(im)
            IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
              IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
C
C---Isotropic U-values
                DBMAX = AMAX1(DBMAX,ABS(DV(LV)*ALB))
                LV = LV + 1
              ELSE
C
C---Anisotropic U-values
                DO   IANISO=1,6
                  DBMAX = AMAX1(DBMAX,ABS(ALB*DV(LV)))
                  LV              = LV + 1
                ENDDO
              ENDIF
            ENDIF
          ENDDO
        enddo
      ENDIF
C
C---
      CONV_FLAG = .FALSE.
      IF(DPMAX.LE.EPS_CONV_X.AND.DBMAX.LE.EPS_CONV_B) THEN
        CONV_FLAG = .TRUE.
      ENDIF
      RETURN
      END
C
      SUBROUTINE SAVE_VITAL
C
C----Save vital parameters
      INCLUDE 'vitals.fh'
C
      NAS = NA
      NDISS = NDIS
      NPLNS = NPLN
      NCHRS = NCHR
      NVDWS = NVDW
      NHBDS = NHBD
      NOCCS = NOCC
      NTORS = NTOR
      ITEMPS = ITEMP

      RETURN
      END
C
      SUBROUTINE RESTORE_VIT
C
C---Restore vital parameters
      INCLUDE 'vitals.fh'
C
      NA = NAS
      NDIS = NDISS
      NPLN = NPLNS
      NCHR = NCHRS
      NVDW = NVDWS
      NHBD = NHBDS
      NOCC = NOCCS
      NTOR = NTORS
      ITEMP = ITEMPS
   
      RETURN
      END
C
      SUBROUTINE GEOM(qqm,qqv,am,v,ndist,n_target,n_object)
      use weights
      use agreem
C
C---Subroutine for calculation geometric part of 
C---residulas and its derivatives
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
C
C-----replace by big_mass.fh
      integer qqm,qqv
      real am(qqm),v(qqv)

      integer ndst
      integer n_target(ndist),n_object(ndist)

C---Local variables

C---Initialisation of first and second derivative matrices should be done 
C---before this routine

C
      IF(PDEL.NE.0.0) THEN
        IMPOS = 0
        DO   IA=1,N_ATOM
          IF(ATOM_REF_FLAG(IA).GT.0) THEN
            AM(IMPOS+1) = 1.0/PDEL**2
            AM(IMPOS+2) = 1.0/PDEL**2
            AM(IMPOS+3) = 1.0/PDEL**2
            IMPOS       = IMPOS + 6
          ENDIF
        ENDDO
      ENDIF
c
c---Contribution from geometry
      CALL CALC_GEOM_CONTR(qqm,qqv,am,v,ndist,n_target,n_object)
C
      RETURN
      END
C

      SUBROUTINE HEADER(LABEL)
      CHARACTER LABEL*(*)
      CHARACTER*80 LINE
C
      L           = LEN(LABEL)
      LINE(1:4)   = '****'
      LINE(77:80) = '****'
      L = 80 - 2*4 - LEN(LABEL)
      IF(L.LT.0) THEN
       CALL ERRWRT(0, ' TOO LONG CHARACTER STRING IN HEADER')
       RETURN
      ENDIF
      LB1 = L/2
      LB2 = 4 + LB1 + LEN(LABEL)
      DO  I=5,4+LB1
        LINE(I:I)=' '
      ENDDO
      DO   I=LB2+1,76
        LINE(I:I)=' '
      ENDDO
      J=0
      DO  I=4+LB1+1,LB2
        J=J+1
        LINE(I:I)=LABEL(J:J)
      ENDDO
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,'    '//LINE)
      CALL ERRWRT(-1,' ')
      RETURN
      END
C
      subroutine optimise_solvent
      use restr_files
      use solvent_all
      implicit none

      include 'twin_refmac.fh'

      if(twin_flag) then
         call optimise_solvent_twin(refl_asym,refl_file)
      else
         call optimise_solvent_all
      endif
c      stop
      return
      end

      SUBROUTINE REFALL(nmodel)
      use solvent_all
C
C---
      IMPLICIT NONE
      integer ndens,nmodel
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      include 'twin_refmac.fh'
      include 'anom.fh'
C
      REAL GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
c
      ndens = nmodel
      if (PPI.eq.'sad'.or.PPI.eq.'sadh'.or.PPI.eq.'sras') ndens=2*ndens
      if(twin_flag) then
         call refall_twin(ndens,gx,gu1,gq,gu1_anom,gq_anom)
      else

         IF(SOLVENT_FLAG) CALL SOLVENT
         CALL REFALL1(ndens,nmodel)
      endif
      RETURN
      END
C
      SUBROUTINE REFALL1(ndens,nmodel)
      use agreem
      IMPLICIT NONE
C-----------------------------------------------------------------------
C     THIS ROUTINE DESIGNED TO EMULATE SIMILAR ROUTINES FROM THE AGARWAL
C     FFT UNCONSTRAINED REFINEMENT PACKAGE.   IT DRIVES THE SEQUENCE OF
C     FOURIER AND GRADIENT ROUTINES FOR THE CALCULATION OF LEAST-SQUARES
C     MATRIX ELEMENTS FOR PROLSQ. MODIFIED FOR ALL SPACE GROUPS
C         *********SPACE GROUP GENERAL**********
C      G.N.M. 16.09.91
C-----------------------------------------------------------------------
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh' 

      INTEGER HMAX,KMAX,LMAX
      integer ndens,nmodel
      COMMON /HKLLIM/ HMAX, KMAX, LMAX
C
      REAL ASYMLIM1,ASYMLIM2,ASYMLIM3
      INTEGER   NGX,NGY,NGZ,NMFOUR,NXY,
     &          IREMADD,IESTIM,N_LAST,NWORKSPACE,NWORKSPACE1,NREF
      INTEGER   SIZE,SIZEL
      CHARACTER LINE*128
      real umin_loc,umax_loc,grid_max
C -----------------------------------------------------
C
C---Find minimum accetable grid spacing for ffts
c      CALL FIND_U_EXTREMES(umin_loc,umax_loc)
c      grid_max = sqrt(umin_loc)
c      NX = int(cs_cell(1)/grid_max)
c      NY = int(cs_cell(2)/grid_max)
c      NZ = int(cs_cell(3)/grid_max)
      CALL GET_GRID_SPACING(FSHANN,NGX,NGY,NGZ,HMAX,KMAX,LMAX)
      CALL ASYLIM_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,IPX,IPY,IPZ,NMFOUR)
      ASYMLIM1 = 1.0/REAL(IPX)
      ASYMLIM2 = 1.0/REAL(IPY)
      ASYMLIM3 = 1.0/REAL(IPZ)
      IF(MON_STYLE.EQ.'MANY') THEN
        WRITE(LINE,'(A,3F5.2)')' Limits of asymmetric unit      :',
     +               ASYMLIM1,ASYMLIM2,ASYMLIM3
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3I5)')  ' Grid spacing to be used        : ',
     +             NX,NY,NZ
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3I5)')  ' Maximuum H,K,L                 : ',
     +             HMAX,KMAX,LMAX
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3I5)')  ' Minimum acceptable grid spacing: ',
     +             NGX,NGY,NGZ
        CALL ERRWRT(-1,LINE)
      ENDIF
c
      IF(MOD(NX,NMFOUR).NE.0.OR.MOD(NY,NMFOUR).NE.0
     +  .OR.MOD(NZ,NMFOUR).NE.0) THEN 
           CALL ERRWRT(1,' Change grid spacings ')
      ENDIF
C
C----Now allocate memory for S.F. Den and so on
      N1   = NX
      N2   = NY
      N3   = NZ/IPZ
      IF(IPZ.GT.1) N3 = N3 + 1
      SIZE = N1*N2*N3+1
      NXY  = (NX+1)*(NY+1)
c
      CALL REF_ALL(ndens,nmodel)
C
      RETURN
      END
C
C-----------------------------------------------------------------------
      SUBROUTINE REF_ALL(ndens,nmodel)
      use solvent_all
      use weights
      use agreem
      IMPLICIT NONE
C
C     THIS ROUTINE FROM THE AGARWAL FFT UNCONSTRAINED REFINEMENT
C     PACKAGE. MODIFIED FOR ALL SPACE GROUPS.
C
C----This subroutine uses semi FFT
C
C          ********SPACE GROUP GENERAL***********
C       G.N.M.  16.09.91
C-----------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'hessian_impl.fh'
      INCLUDE 'anom.fh'

      INTEGER NREF
      INTEGER HMAX, KMAX, LMAX
      COMMON /HKLLIM/ HMAX, KMAX, LMAX
      INTEGER   SZ,SZ1,SZ2
      REAL GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
      INTEGER IZERO,IPP,I,J,IQ,IA,im,LENFILENAME
      REAL    ZERO
      CHARACTER FILE_NAME*256
      integer last_cycle
      integer ir,ihh(3)
      real umin_loc,umax_loc,grid_max,umin_req
      real b_add_loc,rsq
      real lstlsq
      external lstlsq,unpack
c
      INTEGER ierror,atom_1,atom_2,k,m,n,ID
      INTEGER N_PAIRS,COUNT,RATIO,JUMP
      REAL    HPOSMED,DIST,BSUM,HBBD
      INTEGER VAL_VAR,START, wave_pos,ih,NT
      character*12 atm_name_1,atm_name_2
      REAL H_XXD,H_UUD(3),H_UQD,H_QQD
      REAL H_XX(3,3),H_UU(6,6),H_QQ,H_XB(3),H_XU(3,6),H_XQ(3),H_QX(3),
     &     H_BQ,H_QB,H_UQ(6),H_QU(6),HWZ(9),HBBZ
      REAL AVXX, AVYY, AVZZ, AVXY, AVXZ, AVYZ, AVBB, hpa, hpb
      character at_full1*12
      integer ia1,iv,i1,i2,i3,ipos,nxy1,icent,dimen
      logical anom_pp
      real H_C(3,MAXN_HEAVY),H_U(MAXN_HEAVY),H_O(MAXN_HEAVY)
c-- HEAVY_TYPE stores the heavy atom numbering of types
	  integer HEAVY_TYPE(maxform_ano)
c-- H_ELEM stores the heavy atom id's of types
      CHARACTER H_ELEM(maxform_ano)*4
c
      integer ndens,nmodel,nextra
c
      real, allocatable :: fo_map(:)
      real, allocatable :: sigo_map(:)
      real, allocatable :: fwt(:)
      real, allocatable :: fo(:)
      real, allocatable :: sigo(:)
      real, allocatable :: h_a(:)
      real, allocatable :: h_b(:)
      real, allocatable :: den(:,:,:,:)
      real, allocatable :: fc(:,:)
      real, allocatable :: phase(:,:)
      real, allocatable :: fc1(:,:)
      real, allocatable :: phase1(:,:)
      real, allocatable :: freer(:)
      integer, allocatable :: nind(:)
      integer, allocatable :: lind(:)
      real, allocatable :: pool(:,:)
      LOGICAL ERROR,add,remove
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C----Initialise
      call read_nrefl(nref)
c
      nobs = nref
      allocate(fo(nobs*(dataset_num_tot+1)))
      allocate(sigo(nobs*(dataset_num_tot+1)))
      allocate(h_a(nobs*heavy_sf_model_num+1))
      allocate(h_b(nobs*heavy_sf_model_num+1))

      allocate(freer(nobs))
      allocate(nind(nobs))
      allocate(lind(nobs))
      add   = .true.
      remove= .false.
      ZERO  = 0.0
      IZERO = 0
      SZ    = nobs
      SZ1   = SZ*(NPART+1)
      SZ2   = SZ*(dataset_num_tot+1)
      nxy1=4*nx*ny

c      FC(1:SZ1,1:ndens)=ZERO
c      PHASE(1:SZ1,1:ndens)=ZERO
      CALL INIT_VEC(SZ2,FO,ZERO)
      CALL INIT_VEC(SZ2,SIGO,ZERO)
      CALL INIT_VEC(SZ*heavy_sf_model_num,H_A,ZERO)
      CALL INIT_VEC(SZ*heavy_sf_model_num,H_B,ZERO)
      CALL INIT_VECN(SZ,NIND,IZERO)
      CALL INIT_VECN(SZ,LIND,IZERO)
C
C     GENERATE MODEL ELECTRON DENSITY MAP
C
C--Find minimum B values
C
      CALL FIND_U_EXTREMES(umin_loc,umax_loc,nmodel)
      grid_max = amax1(CS_CELL(1)/real(NX),amax1(CS_CELL(2)/real(NY),
     &                 CS_CELL(3)/real(NZ)))
      umin_req = grid_max*grid_max/1.1
c      umin_req = grid_max*grid_max*0.90909090909090909
      if(umin_loc.le.0) then
         call errwrt(0,'Problem with negative B')
      endif
C
C---If u values are too small then add some value to all atoms to avoid
      u_add_loc = 0.0
      if(umin_req.gt.umin_loc) then
         u_add_loc = umin_req - umin_loc
cd         u_add_loc = 0.0
         call add_remove_uaddloc_from_atoms(add,nmodel,u_add_loc)
      endif
      b_add_loc = u_add_loc*pisq8

      allocate(den(n1,n2,n3,ndens))
      CALL DENSTY(n1,n2,n3,ndens,nmodel,DEN)
C
C   Read refelctions (indices and observed s.f.)
      CALL RDIND(NREF,FO,SIGO,FREER,NIND)
C
C-----Reduce electron density to asymmetric unit (REDALLI) calculate 
C-----structure factors (RFFT) and read FO and SIGO and partial structure
C-----factors (RDIND1)
      CALL REDALLI(N1,N2,N3,NX,NY,NZ,ndens,ROTR,TRR,NonCubSym,DEN)
c
      allocate(fc1(nref,ndens))
      allocate(phase1(nref,ndens))
      FC1(1:nobs,1:ndens)=ZERO
      PHASE1(1:nobs,1:ndens)=ZERO
      CALL RFFT(NREF,ndens,DEN,FC1,PHASE1,NIND)
      deallocate(den)

      allocate(fc(nobs*(npart+1),ndens))
      allocate(phase(nobs*(npart+5),ndens))
      fc(1:nref,1:ndens) = fc1(1:nref,1:ndens)
      phase(1:nref,1:ndens) = phase1(1:nref,1:ndens)

      deallocate(fc1)
      deallocate(phase1)
c      deallocate(pool)
c      
      if (PPI.eq.'p+l') call return_mat_dim(dimen)
      if (PPI.eq.'sad'.or.PPI.eq.'sadh'.or.PPI.eq.'sras'
     &  .or.(PPI.eq.'p+l'.and.dimen.eq.4).or.DPPI_sir) then
c         call CALC_HEAVY(NREF,ndens,NIND,H_A,H_B,FC,PHASE,FREER)

c maybe not use H_A, H_B later?
        do ir=1,nref
          CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
          CALL CENTR(IHH,ICENT)
          ipos = ir
      	  i = 1
      	  if (DPPI_sras) then
c--- assuming we have the complete derivative model in fc(3) (not just heavy atoms or something)
c--- this will be used after more models is available...
c      	    H_A(ipos)=FC(ir,3)*cos(PHASE(ir,3))-FC(ir,1)*cos(PHASE(ir,1))
c        	H_B(ipos)=FC(ir,3)*sin(PHASE(ir,3))-FC(ir,1)*cos(PHASE(ir,1))
c--- assuming we have just heavy atoms in fc(3) 
      	    H_A(ipos)=FC(ir,3)*cos(PHASE(ir,3))
        	H_B(ipos)=FC(ir,3)*sin(PHASE(ir,3))
        	ipos = ir+nref
            i = 2
      	  endif
          if (ICENT.eq.0.and.(DPPI_sadh.or.DPPI_sras.or.DPPI_sad)) then
        	H_A(ipos) = -FC(ir,2*i)*sin(PHASE(ir,2*i))
        	H_B(ipos) = FC(ir,2*i)*cos(PHASE(ir,2*i))
      	  else
      	    H_A(ipos) = 0.
      	    H_B(ipos) = 0.
      	  endif
      	  if (DPPI_pl.or.DPPI_sir) then
      	    H_A(ipos)=FC(ir,2)*cos(PHASE(ir,2))
        	H_B(ipos)=FC(ir,2)*sin(PHASE(ir,2))
          endif
        enddo
      endif
c
c--- read in partials, store them at fc(1..nobs*npart,1), shift the model to fc(1+nobs*npart..,1)
      CALL RDIND1(NREF,ndens,FO,SIGO,FREER,FC,PHASE,NIND)
      allocate(fo_map(nref))
      allocate(sigo_map(nref))
      allocate(fwt(nref))
      call read_foweights(nref,fo_map,sigo_map,fwt)
c
cqqq - this is in order to fix slow occupancies divergence for substructure case.
cqqq - not the best thing in the world though, a better fix should be found later.
        if (substruct_flag) then
c        if (1.eq.1) then
          do ir=1,nref
            FO(IR)   = FO(IR)/scale_llh_over
            SIGO(IR) = SIGO(IR)/scale_llh_over
            do i=1,dataset_num_tot
              FO(IR+i*NOBS) = FO(IR+i*NOBS)/scale_llh_over
              SIGO(IR+i*NOBS)=SIGO(IR+i*NOBS)/scale_llh_over
            enddo
          enddo
        endif
C
C--Now remove added b values from Fs
      if (b_add_loc.ne.0.) then
        do  ir=1,nref
cd         if(sigo(ir).gt.0.0) then
          CALL UNPACK(NIND(ir),ihh(1),ihh(2),ihh(3))
          rsq = lstlsq(1,ihh(1),ihh(2),ihh(3))
          fc(NPART*NOBS+ir,1) = fc(NPART*NOBS+ir,1)*exp(rsq*b_add_loc)
          do i=2,ndens
            fc(ir,i) = fc(ir,i)*exp(rsq*b_add_loc)
          enddo
          do i=1,heavy_sf_model_num
            h_a(ir+(i-1)*NOBS) = h_a(ir+(i-1)*NOBS)*exp(rsq*b_add_loc)
            h_b(ir+(i-1)*NOBS) = h_b(ir+(i-1)*NOBS)*exp(rsq*b_add_loc)
          enddo
cd         endif
        enddo
      endif
      last_cycle = 0
      if(.not.lrefin) last_cycle = 1
      call write_reflections_r(nref,nobs,npart,ndens,fo,sigo,fc,phase,
     &     nind,scale_ls_over,b_ls_over,b_ls_aniso_over,
     &     scale_ls_part,b_ls_part,last_cycle)
C
C----Write structure factors to intermediate file
C     CALL WRTIND(NREF,FO,SIGO,FREER,PHASE,NIND)
C
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C     REPORT AGREEMENT FACTORS AND ACCUMULATE FOURIER COEFFICIENTS
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c---read weigts
c--- if partials are extra F's eg from dm (not additive to "real" F's) then put these apart for sr propi and mtzwrite
c--- later on we can continue further and convert these into extra maps, modify the maps etc
      nextra=0
      if (dm_flag) then
         nextra=npart
         if (solvent_flag) nextra=nextra-1
      endif
      allocate(   fc1(nobs*(npart-nextra+1),ndens+nextra))
      allocate(phase1(nobs*(npart-nextra+5),ndens+nextra))
      fc1(1:(npart+1)*nobs,1:ndens)=fc(1:(npart+1)*nobs,1:ndens)
      phase1(1:(npart+5)*nobs,1:ndens)=phase(1:(npart+5)*nobs,1:ndens)
      if (dm_flag) then
        fc1(1:(npart-nextra+1)*nobs, 1) = 
     &      fc(1+nextra*nobs:(npart+1)*nobs, 1)
        phase1(1:(npart-nextra+5)*nobs, 1) = 
     &      phase(1+nextra*nobs:(npart+5)*nobs, 1)
        do i=1,nextra
          ndens=ndens+1
          npart=npart-1
          fc1(1:nobs,ndens) = fc(1+(i-1)*nobs:i*nobs,1)
          phase1(1:nobs,ndens) = phase(1+(i-1)*nobs:i*nobs,1)
        enddo
      endif

      CALL PROPI(NREF,ndens,NIND,FO,SIGO,H_A,H_B,fwt,FC1,PHASE1,FREER)
C
C  Last cycle - only calculate and output SFS
      IF( .NOT.LREFIN) THEN
        call add_remove_uaddloc_from_atoms(remove,nmodel,u_add_loc)
        call write_fofc_sigma(nref,nobs,npart,ndens,fo,sigo,fc1,phase1,
     &        nind,scale_ls_over,b_ls_over,b_ls_aniso_over,
     &        scale_ls_part,b_ls_part,last_cycle)
        CALL MTZWRITE(NREF,ndens,LIND,NIND,FO,SIGO,H_A,H_B,FC1,PHASE1,
     &     FREER)
        if (PPI.eq.'sadh'.or.PPI.eq.'sad'.or.PPI.eq.'sras') then
           if (HREF_FPP_FLAG) then
             wave_pos = dataset_wavenum(dataset_order(2))
             DO    I=1,n_atom_ano
               call write_fpp(f2prime(i,wave_pos),HREF_FPP_FLAG)
             enddo
           endif
c           if (separate_anom_occ) 
c     &       call write_anomocc(occup_anom,cs_anom,id_sf,n_atom)
        endif
        goto 100
      ENDIF
c
      if (dm_flag) then
         npart=npart+nextra
         ndens=ndens-nextra
      endif
      fc(1:nobs,1:ndens)=fc1(1:nobs,1:ndens)
      phase(1:nobs,1:ndens)=phase1(1:nobs,1:ndens)
      deallocate(fc1)
      deallocate(phase1)      
C
C-----Gradient calculation using fft
      IF(GRADC) THEN
        IPP = 0
        do  ir=1,nref
           CALL UNPACK(NIND(ir),ihh(1),ihh(2),ihh(3))
           rsq = lstlsq(1,ihh(1),ihh(2),ihh(3))
           do i=1,ndens
             fc(ir,i) = fc(ir,i)*exp(rsq*b_add_loc)
           enddo
        enddo
C
C---add b vlues for the coefficients for gradient also
        allocate(den(n1,n2,n3,ndens))
        allocate(fc1(nref,ndens))
        allocate(phase1(nref,ndens))
        fc1(1:nref,1:ndens) = fc(1:nref,1:ndens)
        phase1(1:nref,1:ndens) = phase(1:nref,1:ndens)
        CALL FFT(NREF,ndens,DEN,FC1,PHASE1,NIND,IPP)
        CALL GRAD_ALL(n1,n2,n3,ndens,nmodel,DEN,GX,GU1,GQ,
     &    gu1_anom,gq_anom)
        deallocate(fc1)
        deallocate(phase1)
        deallocate(den)
      ENDIF
C
C---now remove b values from atoms
C
      call add_remove_uaddloc_from_atoms(remove,nmodel,u_add_loc)
 100  continue
      deallocate(fo_map)
      deallocate(sigo_map)
      deallocate(fwt)
      IF(HCALC) THEN

cd        CALL HDIAG_R(NREF,NIND,FO,HXX,HUU,HQQ,HQU)
cd        DO   I=1,10
cd          WRITE(*,*)(HXX(6*(I-1) + J),J=1,6),HUU(I)
cd        ENDDO
        CALL D2DA_RADIAL(NREF,NIND,nmodel,FO,SIGO)
cd        CALL HDIAG_R(NREF,NIND,FO,HXX,HUU,HQQ,HQU)
c
c        call init_hessian(nmodel)
c        do im=1,nmodel
c       print*, 'tabulation started'
c          anom_pp=.false.
c          CALL FAST_HESSIAN_TABULATION(SMINB_ML(1),SMAXB_ML(NBIN_ML),
c     &      im,anom_pp)
c          if (PPI.eq.'sad'.or.PPI.eq.'sadh'.or.PPI.eq.'sras') then
c            anom_pp=.true.
c            CALL FAST_HESSIAN_TABULATION(SMINB_ML(1),SMAXB_ML(NBIN_ML),
c     &        im,anom_pp)
c          endif
        CALL FAST_HESSIAN_TABULATION(SMINB_ML(1),SMAXB_ML(NBIN_ML),
     &      nmodel)
c        enddo
cd          print*, 'tabulation ended'
c add more models to calculate_dpi_ml and other related routines!!!
        CALL CALCULATE_DPI_ML(nmodel)
c
      ENDIF
      deallocate(fo)
      deallocate(sigo)
      deallocate(h_a)
      deallocate(h_b)
      deallocate(fc)
      deallocate(phase)
      deallocate(freer)
      deallocate(nind)
      deallocate(lind)
      RETURN
      END
C
      subroutine add_remove_uaddloc_from_atoms(add,nmodel,u_add_loc)
      implicit none
      logical add
      integer nmodel
      real u_add_loc,u_add_loc_now
      integer ia,im
c
      include 'atom_com.fh'
      include 'models.fh'
      if (u_add_loc.eq.0.) goto 999
      u_add_loc_now = u_add_loc
      if (.not.add) u_add_loc_now = -u_add_loc_now
      do im=1,nmodel
        do   ia=1,n_atom_mod(im)
          if(atom_ref_mod_flag(ia,im).gt.0) then
            if(u_aniso_mod(2,ia,im).le.0.0) then
              if (im.eq.1) u_aniso(1,ia) = u_aniso(1,ia) + u_add_loc_now
              u_aniso_mod(1,ia,im) = u_aniso_mod(1,ia,im)+ u_add_loc_now
            else
              if (im.eq.1) u_aniso(1,ia) = u_aniso(1,ia) + u_add_loc_now
              if (im.eq.1) u_aniso(2,ia) = u_aniso(2,ia) + u_add_loc_now
              if (im.eq.1) u_aniso(3,ia) = u_aniso(3,ia) + u_add_loc_now
              u_aniso_mod(1,ia,im) = u_aniso_mod(1,ia,im)+ u_add_loc_now
              u_aniso_mod(2,ia,im) = u_aniso_mod(2,ia,im)+ u_add_loc_now
              u_aniso_mod(3,ia,im) = u_aniso_mod(3,ia,im)+ u_add_loc_now
            endif
          endif
        enddo
      enddo
  999 continue
      return
      end
C
      subroutine find_u_extremes(umin,umax,nmodel)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'const.fh'
      real umin,umax
      integer ia,im,ig,il, nmodel
      real u_iso,u_all_l
C
      umax = -1.0E32
      umin =  1.0E32
      do im=1,nmodel
      do   ia=1,n_atom_mod(im)
        if(occup_mod(ia,im).gt.0..and.atom_ref_mod_flag(ia,im).gt.0)then
          il = id_sf_mod(ia,im)
          if(u_aniso_mod(2,ia,im) .le. 0.0) then
            u_iso = u_aniso_mod(1,ia,im)
          else
            u_iso = ( u_aniso_mod(1,ia,im)+u_aniso_mod(2,ia,im)+
     &                u_aniso_mod(3,ia,im) )/3.0
          endif
          do  ig=1,ngaus
            u_all_l = cs_b(ig,il)/PISQ8 + u_iso
            umin = amin1(umin,u_all_l)
            umax = amax1(umax,u_all_l)
          enddo
        endif
      enddo
      enddo
      return
      end
C
      SUBROUTINE CALCULATE_DPI_ML(nmodel)
      use rharvest
      IMPLICIT NONE
C
C---This subroutine calculates DPIs (or approximate standard uncertainties)
C---using likilohood function
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'const.fh'
C
      integer nmodel
      INTEGER IA,IA1,IA11,im
      REAL H_XXD,H_UUD(3),H_UQD,H_QQD
      real h_uud_anom(3),h_uqd_anom,h_qqd_anom
      integer n_refined
      HESU_ML   = 0.0
      HESU_ML_B = 0.0
      N_REFINED = 0
c
c!!!!! add more models stats
      do im=1,1
        DO   IA=1,N_ATOM_mod(im)
          IA1  = ATOM_REF_mod_FLAG(IA,im)/10
          IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
          IF(IA11.GE.3) THEN
            N_REFINED = N_REFINED +  1
            CALL FAST_HESSIAN_DIAGONAL(IA,im,H_XXD,H_UUD,H_UQD,H_QQD,
     &         h_uud_anom,h_uqd_anom,h_qqd_anom)
            HESU_ML   = HESU_ML   + H_XXD
            HESU_ML_B = HESU_ML_B + H_UUD(1)
          ENDIF
        ENDDO
        HESU_ML = SQRT(2.0*REAL(N_REFINED)/HESU_ML)
        HESU_ML_B = PISQ8*SQRT(2.0*REAL(N_REFINED)/HESU_ML_B)
      enddo

      END
C
      SUBROUTINE GET_GRID_SPACING(FSHANN,NGX,NGY,NGZ,HMAX,KMAX,LMAX)
C
c---Calculates grid spacing using CELL resolution,and  shannon's rate
C
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INTEGER HMAX,KMAX,LMAX
      
      SMAX   = STLMAX_input*2
cd      CALL LRCELL(1,CS_CELL)

      SHH    = 1.0/CS_CELL(1)**2
      SKK    = 1.0/CS_CELL(2)**2
      SLL    = 1.0/CS_CELL(3)**2
c      HMAX   = INT(CS_CELL(1)*SMAX)
c      KMAX   = INT(CS_CELL(2)*SMAX)
c      LMAX   = INT(CS_CELL(3)*SMAX)
C
C---SZ is size for Structure factors and so on
      RH0MAX = SMAX*CS_CELL(1)
      RK0MAX = SMAX*CS_CELL(2)
      RL0MAX = SMAX*CS_CELL(3)
      NGX    = INT(RH0MAX+SQRT(.25/SHH+RH0MAX**2))+1
      NGY    = INT(RK0MAX+SQRT(.25/SKK+RK0MAX**2))+1
      NGZ    = INT(RL0MAX+SQRT(.25/SLL+RL0MAX**2))+1
C
C----If number of grids were not given calculate them
      CALL ASYLIM_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,IPX,IPY,IPZ,NMFOUR)

C
C---Check if predefined number of grid points is less than minimum acceptable
      nx = max(nx,int(ngx*fshann))
      ny = max(ny,int(ngy*fshann))
      nz = max(nz,int(ngz*fshann))
C     
C---Now find best numbers
      CALL NXYZ235(NX,NMFOUR)
      CALL NXYZ235(NY,NMFOUR)
      CALL NXYZ235(NZ,NMFOUR)

      RETURN
      END
C
      SUBROUTINE SET_HKON_FLAGS(nmodel)
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'refi_flags.fh'
C
C---Define atoms which should be included in refinement, in geometry
C---calculation. In this version all atoms but hydrogens will be included
c---in refinement. hydrogens will be included in geometry calculation
c---and contribution of them will be taken into account in structure factor
C---calculation
      INTEGER IA1,IA,im,nmodel
      REAL    U_ISOT
C
c both ATOM_REF_FLAG and ATOM_REF_mod_FLAG are to be correctly initialized and used at this stage.
c after complete more model support ATOM_REF_FLAG can be removed.
      IA1 = 0
      do im=1,nmodel
       DO    IA=1,N_ATOM_mod(im)
        IF(OCCUP_mod(IA,im).LE.0.001) THEN
          if (im.eq.1) ATOM_REF_FLAG(IA) = 0
          ATOM_REF_mod_FLAG(IA,im) = 0
        ELSEIF(CS_ELEMENT(ID_SF_mod(IA,im)).EQ.'H   '
     +        .OR.CS_ELEMENT(ID_SF_mod(IA,im)).EQ.'H-1  ') THEN
          IA1 = IA1 + 1
          IF(.NOT.HYDROGEN_REFINE_FLAG) THEN
            if (im.eq.1) ATOM_REF_FLAG(IA) = IA1*10 + 2
            ATOM_REF_mod_FLAG(IA,im) = IA1*10 + 2
          ELSE
            IF(HYDROGEN_BVALUE.EQ.'ISOT') THEN
              if (im.eq.1) ATOM_REF_FLAG(IA) = IA1*10 + 3
              ATOM_REF_mod_FLAG(IA,im) = IA1*10 + 3
              IF(U_ANISO_mod(2,IA,im).NE.0.0) THEN
                U_ISOT = ( U_ANISO_mod(1,IA,im)+U_ANISO_mod(2,IA,im)+
     &                     U_ANISO_mod(3,IA,im) ) /3.0
                if (im.eq.1) then
                  U_ANISO(1,IA) = U_ISOT
                  U_ANISO(2,IA) = 0.0
                  U_ANISO(3,IA) = 0.0
                  U_ANISO(4,IA) = 0.0
                  U_ANISO(5,IA) = 0.0
                  U_ANISO(6,IA) = 0.0
                endif
                U_ANISO_mod(1,IA,im) = U_ISOT
                U_ANISO_mod(2,IA,im) = 0.0
                U_ANISO_mod(3,IA,im) = 0.0
                U_ANISO_mod(4,IA,im) = 0.0
                U_ANISO_mod(5,IA,im) = 0.0
                U_ANISO_mod(6,IA,im) = 0.0
              ENDIF
            ELSE
              if (im.eq.1) ATOM_REF_FLAG(IA) = IA1*10 + 4
              ATOM_REF_mod_FLAG(IA,im) = IA1*10 + 4
            ENDIF
          ENDIF
        ELSE
          IA1 = IA1 + 1
          if (im.eq.1) ATOM_REF_FLAG(IA) = IA1*10 + 4
          ATOM_REF_mod_FLAG(IA,im) = IA1*10 + 4
        ENDIF

       ENDDO
      enddo
C
C---Change style of refinement for some of preselected atoms

C
C---No occupancy refinement
      do im=1,nmodel
       DO   IA=1,N_ATOM_mod(im)
        if (im.eq.1) OCCUP_REF(IA) = 0
        OCCUP_REF_mod(IA,im) = 0
       ENDDO
      enddo
C
C---Some other checks and refinement settings should be added here
      RETURN
      END
C
      LOGICAL FUNCTION ATOM_SELECT_OCCUP(IA)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INTEGER IA

      ATOM_SELECT_OCCUP = .FALSE.
      IF(RES_NAME(I_RESID(IA))(1:3).EQ.'HOH') THEN
         ATOM_SELECT_OCCUP = .TRUE.
      ENDIF

      RETURN
      END
C
      SUBROUTINE EQUIVALENCE_CLASSES(N_EL,N_EQUIV,N_RELATE1,N_RELATE2,
     &           N_CLASSES)
      IMPLICIT NONE
C
C---Find class numbers using pairwise equivalence relations. First build
C---tree then find class numbers using that tree.
      INTEGER N_EL,N_EQUIV
      INTEGER N_RELATE1(*),N_RELATE2(*),N_CLASSES(*)
C
      INTEGER I,J,K
      INTEGER N_CLASSES1(1000)
C
C---Initialise
      DO   I=1,N_EL
        N_CLASSES(I) = I
      ENDDO
C
      DO   I=1,N_EQUIV
        J = N_RELATE1(I)
 1      CONTINUE
        IF(N_CLASSES(J).NE.J) THEN
           J = N_CLASSES(J)
           GOTO 1
        ENDIF
        K = N_RELATE2(I)
 2      CONTINUE
        IF(N_CLASSES(K).NE.K) THEN
          K = N_CLASSES(K)
          GOTO 2
        ENDIF
C
C---This step is important for future searches.
        IF(J.GT.K) THEN
          N_CLASSES(J) = K
        ELSEIF(J.LT.K) THEN
          N_CLASSES(K) = J
        ENDIF
      ENDDO
C
C---Now walk thrhough upwards and find root of all trees.
      DO   I=1,N_EL
 3      CONTINUE
        IF(N_CLASSES(I).NE.N_CLASSES(N_CLASSES(I))) THEN
          N_CLASSES(I) = N_CLASSES(N_CLASSES(I))
          GOTO 3
        ENDIF
      ENDDO
      RETURN
      END
C
      SUBROUTINE TREE_2_CLASS_NUMBER(N_EL,N_CLASSES,N_CLASS_N)
      IMPLICIT NONE
      INTEGER N_EL
      INTEGER N_CLASSES(*),N_CLASS_N(*)
C
      INTEGER NUMBER_C,I,J,K
C
C---Find the class numbers in an increasing order.
      NUMBER_C = 1
      N_CLASS_N(1) = NUMBER_C
      DO   I=2,N_EL
        DO   J=1,I-1
          IF(N_CLASSES(I).EQ.N_CLASSES(J)) THEN
            N_CLASS_N(I) = N_CLASS_N(J)
            GOTO 10
          ENDIF
        ENDDO
        NUMBER_C = NUMBER_C + 1
        N_CLASS_N(I) = NUMBER_C
 10     CONTINUE
      ENDDO
cd      WRITE(*,*)NUMBER_C,N_EL
C
      RETURN
      END
C
      subroutine d2da_radial(nref,nind,nmodel,d2df,sigo)
      use weights
      implicit none
      include 'atom_com.fh'
      include 'models.fh'

      integer nref,nmodel
      integer nind(*)
      real d2df(*),sigo(*)

      if(sigma_refine_style.eq.'BINS') then
        call d2da_radial_bin(nref,nind,nmodel,d2df,sigo)
      else
        call d2da_radial_exps(nref,nind,d2df,sigo)
      endif

      return
      end
C
      SUBROUTINE D2DA_RADIAL_BIN(NREF,NIND,nmodel,D2DF,SIGO)
      use weights
      use rharvest
C
      IMPLICIT NONE
C
C---this subroutien find average values of D2DF in resolution bins.
C---Some more things like epsilon symmetry, centricity should
C---also be added
      INTEGER NREF,nmodel
      INTEGER NIND(*)
      REAL D2DF(*),SIGO(*)
      include 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      include 'anom.fh'
      include 'refi_flags.fh'
C
      INTEGER IR,IHH(3),ISYSAB,ICENT,im
      REAL EPSI,RSQ,RHO,STL_C
      REAL   RSQ4,RSQ42,RSQ43,RSQ44,rsq3
      REAL*8 WT1
C
C--Test purposes
      INTEGER I_INTER
      REAL S0,DS
C
c---External functions and subprutines
      INTEGER IC
      REAL*8 TOLER
      REAL LSTLSQ,D2DF_WEIGHT
C
      INTEGER IBIN,IBIN_S,NBIN_RAD1
      INTEGER I,J,K
      INTEGER MAXBIN1
      INTEGER NCYCLE_TCH,ITRY,N_TRY
      INTEGER N_USED_HERE
      REAL*8 DELTA,FVALUE,FVALUE_OLD
      REAL*8 DD1,DD2,D111
      REAL*8 SHIFT_MAX,DEXP_D2
      REAL DFDSIGMA,D2FDSIGMA2
      REAL SEC_DER_C
      REAL*8 DFDS(MAXBIN+1,maxn_models),DFDS_pp(MAXBIN+1,maxn_models)
      real*8 D2FDS2(MAXBIN+1,MAXBIN+1,maxn_models)
      REAL*8 D2FDS2_pp(MAXBIN+1,MAXBIN+1,maxn_models)
      REAL*8 SHIFTS(MAXBIN+1)
      real SEC_DER_DERS(MAXBIN+1)
      integer NREF_SEC_BIN_PP(MAXBIN+1,maxn_models) 
cd      REAL*8 D_INV(40,40)
      real diff
      REAL TEMP1,TEMP2
      logical anom,process
c
cd      REAL SCALE_SEC,B_SEC
C
      EXTERNAL LSTLSQ,UNPACK,D2DF_WEIGHT
C
      MAXBIN1    = MAXBIN + 1
      NBIN_ML1   = NBIN_ML + 1
      NBIN_RAD1 = NBIN_RAD + 1
      TOLER      = 0.5E-8
      anom=.false.
      if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras.or.DPPI_mad) anom=.true.
cd      WRITE(*,*)
cd      IF(NCYCLE_OVERALL.LE.1) THEN
      do im=1,nmodel
        DO   IBIN=1,NBIN_RAD+1
          SEC_DER_BIN(IBIN,im) = 0.0
          SEC_DER_BIN_pp(IBIN,im) = 0.0
          NREF_SEC_BIN(IBIN,im) = 0
          NREF_SEC_BIN_pp(IBIN,im) = 0
        ENDDO
      enddo
      IBIN_S = 1
      DO   IR = 1,NREF
c        IF(SIGO(IR).GT.0.0.or.D2DF(IR).GT.0.0) THEN
c        process=.false.
c        do im=1,nmodel
c          IF(D2DF(IR+(im-1)*nref).GT.0.0) process=.true.
c          if (anom) then 
c            IF (SIGO(IR+(im-1)*nref).GT.0.0) process=.true.
c          endif
c        enddo
c        if (process) THEN
          CALL INDTORS(NIND(IR),RSQ)
          CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)
          STL_C = SQRT(RSQ)**3
          IF(.NOT.(STL_C.GE.SMEANB_RAD(IBIN_S).AND.
     &             STL_C.LE.SMEANB_RAD(IBIN_S+1))) THEN
            DO   IBIN=1,NBIN_RAD
              IF(STL_C.GT.SMEANB_RAD(IBIN).AND.
     &           STL_C.LE.SMEANB_RAD(IBIN+1)) 
     &                                         THEN
                IBIN_S = IBIN
                GOTO 50
              ENDIF
            ENDDO
            GOTO 60
          ENDIF
 50       CONTINUE
          do im=1,nmodel
            if (D2DF(IR+(im-1)*nref).GT.0.0) then
              DD1=D2DF(IR+(im-1)*nref)*EPSI*FLOAT(1+ICENT)/FLOAT(NSMULT)
cd            DD1 = 2.0*D2DF(IR)**2*EPSI*FLOAT(ICENT+1)
cd            DD1 = D2DF(IR)
cd*EPSI*FLOAT(ICENT+1)
              SEC_DER_BIN(IBIN_S,im) = SEC_DER_BIN(IBIN_S,im) + DD1
              NREF_SEC_BIN(IBIN_S,im) = NREF_SEC_BIN(IBIN_S,im) + 1
            endif
            if (anom.and.SIGO(IR+(im-1)*nref).GT.0.0) then
              DD1=sigo(IR+(im-1)*nref)*EPSI*FLOAT(1+ICENT)/FLOAT(NSMULT)
              SEC_DER_BIN_pp(IBIN_S,im) = SEC_DER_BIN_pp(IBIN_S,im) +DD1
              NREF_SEC_BIN_pp(IBIN_S,im) = NREF_SEC_BIN_pp(IBIN_S,im) +1
            endif
          enddo
c        ENDIF
 60     CONTINUE
      ENDDO

      do im=1,nmodel
        DO  IBIN=1,NBIN_RAD
          if (nref_sec_bin(ibin,im).gt.0) then
            if (SEC_DER_BIN(IBIN,im).gt.0) 
     &        SEC_DER_BIN(IBIN,im) = 
     &        alog(SEC_DER_BIN(IBIN,im)/NREF_SEC_BIN(IBIN,im))
          endif
cd        WRITE(*,*)SEC_DER_BIN(IBIN),NREF_SEC_BIN(IBIN)
          if (nref_sec_bin_pp(ibin,im).gt.0) then
            if (SEC_DER_BIN_pp(IBIN,im).gt.0)   
     &        SEC_DER_BIN_pp(IBIN,im) =
     &        alog(SEC_DER_BIN_pp(IBIN,im)/NREF_SEC_BIN(IBIN,im))
          endif
        ENDDO
c sort out bins with no (usable) reflections
        DO  IBIN=2,NBIN_RAD
          if (nref_sec_bin(ibin,im).le.0 .and.
     &        nref_sec_bin(ibin-1,im).gt.0 )
     &          sec_der_bin(ibin,im) = sec_der_bin(ibin-1,im)
          if (nref_sec_bin_pp(ibin,im).le.0 .and.
     &        nref_sec_bin_pp(ibin-1,im).gt.0 )
     &          sec_der_bin_pp(ibin,im) = sec_der_bin_pp(ibin-1,im)
        ENDDO
        DO  IBIN=NBIN_RAD-1,1,-1
          if (nref_sec_bin(ibin,im).le.0 .and. 
     &        nref_sec_bin(ibin+1,im).gt.0 )
     &          sec_der_bin(ibin,im) = sec_der_bin(ibin+1,im)
          if (nref_sec_bin_pp(ibin,im).le.0 .and. 
     &        nref_sec_bin_pp(ibin+1,im).gt.0 )
     &          sec_der_bin_pp(ibin,im) = sec_der_bin_pp(ibin+1,im)
        ENDDO
cd      return
C
C---  Start refining parameters of smoothining function
C
        TEMP1 = SEC_DER_BIN(1,im)
        SEC_DER_BIN(NBIN_RAD1,im) = SEC_DER_BIN(NBIN_RAD,im)
        DO   IBIN=2,NBIN_RAD
          TEMP2 = SEC_DER_BIN(IBIN,im)
          SEC_DER_BIN(IBIN,im) = (TEMP1+TEMP2)/2.0
          TEMP1 = TEMP2
        ENDDO
c now the same thing for f'' contributions 
        if (anom) then
          TEMP1 = SEC_DER_BIN_pp(1,im)
          SEC_DER_BIN_pp(NBIN_RAD1,im) = SEC_DER_BIN_pp(NBIN_RAD,im)
          DO   IBIN=2,NBIN_RAD
            TEMP2 = SEC_DER_BIN_pp(IBIN,im)
            SEC_DER_BIN_pp(IBIN,im) = (TEMP1+TEMP2)/2.0
            TEMP1 = TEMP2
          ENDDO
        endif
      enddo
c
      if(nbin_rad.eq.1) goto 100
cd      DO  IC=1,5
        do im=1,nmodel
          DO   I=1,NBIN_RAD1
            DFDS(I,im) = 0.0
            DFDS_pp(I,im) = 0.0
            DO   J=1,NBIN_RAD1
              D2FDS2(I,J,im) = 0.0
              D2FDS2_pp(I,J,im) = 0.0
            ENDDO
          ENDDO
        enddo
C
        fvalue = 0.0
        DO   IR=1,NREF
c          IF(SIGO(IR).GT.0.0.or.d2df(ir).gt.0) THEN
          process=.false.
          do im=1,nmodel
            IF(D2DF(IR+(im-1)*nref).GT.0.0) process=.true.
            if (anom) then 
              IF (SIGO(IR+(im-1)*nref).GT.0.0) process=.true.
            endif
          enddo
          if (process) THEN
            CALL INDTORS(NIND(IR),RSQ)
            CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            rsq3 = sqrt(rsq**3)
            do im=1,nmodel
              CALL SMOOTH_GAUSS_D(NBIN_RAD1,KERNEL_G_RAD,SMEANB_RAD,
     &          SEC_DER_BIN(1,im),rsq3,SEC_DER_C,SEC_DER_DERS)
cd            write(10,*)rsq3,(smeanb_rad(i),sec_der_ders(i),i=1,nbin_ml1)
              dd2 = DBLE(AMAX1(-60.0,AMIN1(120.0,SEC_DER_C)))
cd            DD1 = 2.0*(D2DF(IR)**2*EPSI*FLOAT(ICENT+1))
cd            DD1 = 2.0*D2DF(IR)*EPSI*FLOAT(ICENT+1)
              if ( D2DF(IR+(im-1)*nref).gt.0 )
     &          DD1 = DLOG( DBLE(D2DF(IR+(im-1)*nref)*
     &            EPSI*FLOAT(ICENT+1)/FLOAT(NSMULT)) )
              diff = (dd2 - dd1)
              fvalue = fvalue + diff**2
cd            DFDSIGMA   = -(DD1/SEC_DER_C-1.0/FLOAT(1+ICENT))
cd            D2FDSIGMA2 = DFDSIGMA*DFDSIGMA
cd            D2FDSIGMA2 = DD1/SEC_DER_C
cd            D2FDSIGMA2  = DD1/SEC_DER_C
              DO   I=1,NBIN_RAD1
                DFDS(I,im) = DFDS(I,im) + diff*SEC_DER_DERS(I)
                D111    = SEC_DER_DERS(I)
                DO   J=1,NBIN_RAD1
                  D2FDS2(I,J,im) = D2FDS2(I,J,im) + d111*SEC_DER_DERS(J)
                ENDDO
              ENDDO
c now the same thing for f'' contributions
              if (anom) then
                CALL SMOOTH_GAUSS_D(NBIN_RAD1,KERNEL_G_RAD,SMEANB_RAD,
     &          SEC_DER_BIN_pp(1,im),rsq3,SEC_DER_C,SEC_DER_DERS)
                dd2 = DBLE(AMAX1(-60.0,AMIN1(120.0,SEC_DER_C)))
                if ( sigo(IR+(im-1)*nref).gt.0 )
     &            DD1 = DLOG( DBLE(sigo(IR+(im-1)*nref)*
     &              EPSI*FLOAT(ICENT+1)/FLOAT(NSMULT)) )
                diff = (dd2 - dd1)
                fvalue = fvalue + diff**2
                DO   I=1,NBIN_RAD1
                  DFDS_pp(I,im) = DFDS_pp(I,im) + diff*SEC_DER_DERS(I)
                  DO   J=1,NBIN_RAD1
                    D2FDS2_pp(I,J,im) = D2FDS2_pp(I,J,im) + 
     &                SEC_DER_DERS(I)*SEC_DER_DERS(J)
                  ENDDO
                ENDDO
              endif
            enddo
c
          ENDIF
        ENDDO
c        
      do im=1,nmodel
        CALL  DEIGEN_FILTER_R90(TOLER,D2FDS2(1,1,im),NBIN_RAD1,MAXBIN1,
     &            DFDS(1,im),SHIFTS)

        DO   IBIN=1,NBIN_RAD1
          if (NREF_SEC_BIN(IBIN,im).gt.0) then
            SEC_DER_BIN(IBIN,im) = SEC_DER_BIN(IBIN,im) - SHIFTS(IBIN)
          else
            if (ibin.gt.1) SEC_DER_BIN(IBIN,im) = SEC_DER_BIN(IBIN-1,im)
          endif
        ENDDO
        
        if (anom) then
          CALL  DEIGEN_FILTER_R90(TOLER,D2FDS2_pp(1,1,im),NBIN_RAD1,
     &            MAXBIN1,DFDS_pp(1,im),SHIFTS)
          DO   IBIN=1,NBIN_RAD1
            if (NREF_SEC_BIN_pp(IBIN,im).gt.0) then
              SEC_DER_BIN_pp(IBIN,im) = 
     &          SEC_DER_BIN_pp(IBIN,im) - SHIFTS(IBIN)
            else
              if (ibin.gt.1)
     &          SEC_DER_BIN_pp(IBIN,im)=SEC_DER_BIN_pp(IBIN-1,im)
            endif
          ENDDO
        endif
      enddo
        
 100  continue
C
C---Tabulate for easy access
C
C
cd      OPEN(13,file='13.dat')
cd      write(*,*)'File opened ',N_POINTS_TABLE_S
      do im=1,nmodel
        s0 = SMEANB_RAD(1)
        DO   I=1,N_POINTS_TABLE_S+1
          CALL SMOOTH_GAUSS(NBIN_RAD1,KERNEL_G_RAD,SMEANB_RAD,
     &                SEC_DER_BIN(1,im),s0,SEC_DER_C)
          SEC_TABLE_SMOOTH(I,im) = dexp(dble(SEC_DER_C))
          if (anom) then
            CALL SMOOTH_GAUSS(NBIN_RAD1,KERNEL_G_RAD,SMEANB_RAD,
     &                SEC_DER_BIN_pp(1,im),s0,SEC_DER_C)
            SEC_TABLE_SMOOTH_pp(I,im) = dexp(dble(SEC_DER_C))
          endif
cd        WRITE(13,*)s0,SEC_DER_C
          s0 = s0 + DELTA_S_TABLE
        ENDDO
      enddo
      RETURN
      END
C
      SUBROUTINE D2DA_RADIAL_EXPS(NREF,NIND,D2DF,SIGO)
      use weights
      use rharvest
C
      IMPLICIT NONE
C
C---this subroutien find average values of D2DF in resolution bins.
C---Some more things like epsilon symmetry, centricity should
C---also be added
      INTEGER NREF
      INTEGER NIND(*)
      REAL D2DF(*),SIGO(*)
      include 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'celsym.fh'
C
      INTEGER IR,IHH(3),ISYSAB,ICENT,im
      REAL EPSI,RSQ,RHO,STL_C
      REAL   RSQ4,RSQ42,RSQ43,RSQ44,rsq3
      REAL*8 WT1
C
C--Test purposes
      INTEGER I_INTER
      REAL S0,DS
C
c---External functions and subprutines
      INTEGER IC
      INTEGER NWORKSPACE
      REAL*8 TOLER
      REAL*8 WORKSPACE(300)
      REAL LSTLSQ,D2DF_WEIGHT
C
      INTEGER IBIN,IBIN_S
      INTEGER I,J,K
      INTEGER NCYCLE_TCH,ITRY,N_TRY
      INTEGER N_USED_HERE
      REAL*8 DELTA,FVALUE,FVALUE_OLD
      REAL DD1,DD2
      REAL SHIFT_MAX,DEXP_D2
      REAL SEC_DER_C
      integer MAXCOEF
      PARAMETER (MAXCOEF = 6)
      REAL*8 DFDS(MAXCOEF),D2FDS2(MAXCOEF,MAXCOEF)
      REAL*8 SHIFTS(MAXCOEF)
      logical pp

cd      REAL SCALE_SEC,B_SEC
C
      EXTERNAL LSTLSQ,UNPACK,D2DF_WEIGHT
C
      TOLER = 1.0E-7
      NWORKSPACE = 100
        DO   I=1,4
          DFDS(I) = 0.0
          DO   J=1,4
            D2FDS2(I,J) = 0.0
          ENDDO
        ENDDO
C
        DO   IR=1,NREF
          IF(SIGO(IR).GT.0.0) THEN
            CALL INDTORS(NIND(IR),RSQ)
            CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            rsq4 = rsq/4.0
            rsq42 = rsq4*rsq4
            rsq43 = rsq42*rsq4
cd            dd2 = scale_sec-b_sec*rsq4+b1_sec*rsq42+b2_sec*rsq43
            DD1 = alog(D2DF(IR)*EPSI*FLOAT(ICENT+1)/FLOAT(NSMULT))
            dfds(1) = dfds(1) + dd1
            dfds(2) = dfds(2) - dd1*rsq4
            dfds(3) = dfds(3) + dd1*rsq42
            dfds(4) = dfds(4) + dd1*rsq43

            d2fds2(1,1) = d2fds2(1,1) + 1.0
            d2fds2(1,2) = d2fds2(1,2) - rsq4
            d2fds2(2,2) = d2fds2(2,2) + rsq4*rsq4
            d2fds2(1,3) = d2fds2(1,3) + rsq42
            d2fds2(2,3) = d2fds2(2,3) - rsq42*rsq4
            d2fds2(3,3) = d2fds2(3,3) + rsq42*rsq42
            d2fds2(1,4) = d2fds2(1,4) + rsq43
            d2fds2(2,4) = d2fds2(2,4) - rsq43*rsq4
            d2fds2(3,4) = d2fds2(3,4) + rsq43*rsq42
            d2fds2(4,4) = d2fds2(4,4) + rsq43*rsq43

          ENDIF
        ENDDO
        d2fds2(2,1) = d2fds2(1,2)
        d2fds2(3,1) = d2fds2(1,3)
        d2fds2(3,2) = d2fds2(2,3)
        d2fds2(4,1) = d2fds2(1,4)
        d2fds2(4,2) = d2fds2(2,4)
        d2fds2(4,3) = d2fds2(3,4)

        CALL  DEIGEN_FILTER_R(TOLER,D2FDS2,4,MAXCOEF,
     &            DFDS,SHIFTS,WORKSPACE,NWORKSPACE)
        scale_sec = shifts(1)
        b_sec     = shifts(2)
        b1_sec    = shifts(3)
        b2_sec    = shifts(4)


 100  continue
C
C---Tabulate for easy access
C
      im = 1
      pp = .false.
      s0 = SMEANB_RAD(1)
C
cd      OPEN(13,file='13.dat')
cd      write(*,*)'File opened ',N_POINTS_TABLE_S
      DO   I=1,N_POINTS_TABLE_S+1
        rsq4 = s0**(2.0/3.0)/4.0
        sec_table_smooth(i,im) = exp(scale_sec-rsq4*(b_sec-
     &                  rsq4*(b1_sec+rsq4*b2_sec)))
        s0 = s0 + DELTA_S_TABLE
      ENDDO
      return
cd      stop
cd      write(*,*)
      DO  I=1,NBIN_ML1
         WRITE(*,*)SEC_DER_BIN(I,im)
      ENDDO
      OPEN(13,file='13.dat')
      i_inter = -1
      DO   IR=1,NREF
        IF(SIGO(IR).GT.0.0) THEN
          CALL INDTORS(NIND(IR),RSQ)
          CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)
          s0 = sqrt(rsq)
          sec_der_c = d2df_weight(s0,i_inter,im,pp)
          DD1 = D2DF(IR)*EPSI*FLOAT(1+ICENT)/FLOAT(NSMULT)
          WRITE(13,*)RSQ,DD1,exp(SEC_DER_C)
        ENDIF
      ENDDO
C
C---  Tabulate now for future use
cd      return
      stop
C

      RETURN
      END
C
      REAL*8 FUNCTION D2DF_WEIGHT(S_CURRENT,I_INTER,im,pp)
      use weights
      IMPLICIT NONE
C
c--Calculates current value of second derivative at the given point (radial part)
C--This version uses linear interpolation. It will have to be checked and probably
C--other interpolation techniques will have to be used
C
      INTEGER I_INTER,im
      logical pp
      REAL    H_SM
      REAL S_CURRENT
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
                                !
      INTEGER I_ACCESS
      REAL*8 CURRENT_VALUE
      REAL CURRENT_VALUE1,CURRENT_VALUE2
      REAL S21,S22,S23
      REAL S_CURRENT2
      REAL SIGMA_IN1,SIGMA_IN,SCURRENT
      EXTERNAL LINTER_VALUE2,GAUSS_SMOOTH
C
cd      IF(I_INTER.LE.0) THEN
cd        H_SM = -0.1
cd        I_INTER = 1
cd      ENDIF
cd      CALL GAUSS_SMOOTH(H_SM,NBIN_RAD,SMEANB_RAD,D2DF_ML_RAD_BIN,
cd     &       S_CURRENT,CURRENT_VALUE)
cd      IF(S_RAD.LE.0.0.AND.ABS(B_RAD).GT.2.0) THEN
cd        CALL LINTER_VALUE2(NBIN_ML,SMAXB_ML,SEC_DER_BIN,
cd     &               S_CURRENT,I_INTER,CURRENT_VALUE)
cd        CURRENT_VALUE = CUR1
cd      SCURRENT = S_CURRENT/SMAX_TCH
cd      CALL CALC_TCHEB_APPROX_CLENSHW(N_COEFS,SCURRENT,TCH_COEFS,
cd     &                 SIGMA_IN)
cd      CALL CALC_TCHEB_APPROX_CLENSHW(N_COEFS,SCURRENT,
cd     &               TCH_COEFS_SIGMA1,SIGMA_IN1)
cd      ELSE
cd        CURRENT_VALUE = S_RAD*EXP(-B_RAD*S_CURRENT**2/4.0)
cd      ENDIF
      IF(SIGMA_REFINE_STYLE.EQ.'BINS') THEN
        S_CURRENT2 = S_CURRENT**3
        I_ACCESS   = NINT((S_CURRENT2-SMEANB_RAD(1))/DELTA_S_TABLE)+1
        I_ACCESS = MAX(1,MIN(N_POINTS_TABLE_S+1,I_ACCESS))
        if (.not.pp) then
          CURRENT_VALUE2 = SEC_TABLE_SMOOTH(I_ACCESS,im)
        else
          CURRENT_VALUE2 = SEC_TABLE_SMOOTH_pp(I_ACCESS,im)
        endif
        D2DF_WEIGHT = DBLE(CURRENT_VALUE2) 
      ELSE
        S21 = (S_CURRENT/2.0)**2
        S22 = S21*S21
        S23 = S22*S21
        D2DF_WEIGHT = DEXP(DBLE(SCALE_SEC-B_SEC*S21+B1_SEC*S22+
     &                     B2_SEC*S23))
      ENDIF
cd      CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SEC_DER_BIN,
cd     &              S_CURRENT2,I_INTER,CURRENT_VALUE2)
cd            CALL SMOOTH_GAUSS(NBIN_ML1,KERNEL_G,SMEANB_ML,SEC_DER_BIN,
cd     &                S_CURRENT2,CURRENT_VALUE2)
cd      S21 = (S_CURRENT/2.0)**2
cd      S22 = S21*S21
cd      S23 = S22*S21
cd      CURRENT_VALUE = DEXP(DBLE(SCALE_SEC-B_SEC*S21+B1_SEC*S22+
cd     &                     B2_SEC*S23))
cd     &       2.0*(SIGMA_IN+SIGMA_ML_SCALE_OVER-
cd     &            SIGMA_ML_B_OVER*S_CURRENT**2/4.0)))
cd      WRITE(*,*)D2DF_WEIGHT,CURRENT_VALUE2,S_CURRENT2,SMEANB_ML(1),
cd     &        SMEANB_ML(NBIN_ML1)
cd/DBLE(NSMULT)
      END
C
      subroutine write_reflections_r(nref,nobs,npart,ndens,fo,sigo,
     &     fc,phase,nind,scale_over,b_over,b_aniso_over,
     &     scale_part,b_part,last_cycle)
C
c---  Write total structure factors to an mtz file
      implicit none
      include 'celsym.fh'
      integer last_cycle
      integer nref,npart,nobs,ndens
      integer nind(nref)
      real fo(*),sigo(*)
      real fc(nobs,ndens),phase(nobs,ndens)
      real scale_over,b_over
      real b_aniso_over(6)
      real scale_part(*),b_part(*)
C
c---  locals
      integer iout_unit,ifail,ll
      integer npart1
      integer ir,ip
      integer hkl(3)
      real ss,radtodeg
      real cosa_l,sina_l,fa,fb,fap,fbp,ff,alpha,scp
      real s1,s2,s3,s11,s22,s33,s12,s13,s23,sbs
      real sc_loc,expb,expan
      character file_name*512
c
c---  mtz things
      integer   mtzout,iappnd
c      integer   isort(5)
      real      bdata(200)
      integer   nlprgo
      character lsprgo(16)*30,ctprgo(16)*1
c
      integer iout_file
c
c---Externals
      real lstlsq
      external lstlsq,unpack
C
c---  body
c
c---Find "conditional" normalisation coefficients
      call getenv('SFOUT',file_name)
      if(file_name(1:1).eq.' ') return
      radtodeg  = 180.0/(4.0*atan2(1.0,1.0))
c
c---Prepare for mtz
      mtzout = 2
      call lwopen(mtzout,'SFOUT')
      call lwtitl(mtzout,'Outut FC including solvent if availble',1)
      isort(1:3) = 1
      isort(4:5) = 0
      if(maxval(cell(4:6)).le.5.0) cell(4:6) = cell(4:6)*radtodeg
      call lwcell(mtzout,cell)
      call lwsort(mtzout,isort)
      iappnd    = 0
      nlprgo    = 5
      lsprgo(1) = 'H'
      ctprgo(1) = 'H'
      lsprgo(2) = 'K'
      ctprgo(2) = 'H'
      lsprgo(3) = 'L'
      ctprgo(3) = 'H'
      lsprgo(4) = 'FC'
      ctprgo(4) = 'F'
      lsprgo(5) = 'PHIC'
      ctprgo(5) = 'P'
      call lwassn(mtzout,lsprgo,nlprgo,ctprgo,iappnd)
      CALL LWSYMM(MTZOUT,
     +                NumSymmetry,
     +                 NumPrimSymm,
     +                  RealSymmMatrx,
     +                   Ltype,
     +                    NumSpaceGroup,
     +                     SpaceGroupName,
     +                      PointGroupName)
      do   ir=1,nref
        CALL EQUAL_MAGIC(MTZOUT,BDATA,20)
        call unpack(nind(ir),hkl(1),hkl(2),hkl(3))
        bdata(1:3) = hkl(1:3)
        ss     = lstlsq(1,hkl(1),hkl(2),hkl(3))
        cosa_l = cos(phase(ir+nobs*npart,1))
        sina_l = sin(phase(ir+nobs*npart,1))
        fa     = fc(ir+nobs*npart,1)*cosa_l
        fb     = fc(ir+nobs*npart,1)*sina_l
        if(npart.gt.0) then
           do  ip=1,npart
              scp    = scale_part(ip)*exp(-ss*b_part(ip))
              cosa_l = cos(phase(ir+nobs*(ip-1),1))
              sina_l = sin(phase(ir+nobs*(ip-1),1))
              fap    = scp*fc(ir+nobs*(ip-1),1)*cosa_l
              fbp    = scp*fc(ir+nobs*(ip-1),1)*sina_l
              fa     = fa + fap
              fb     = fb + fbp
           enddo
        endif
        ff    = sqrt(fa*fa+fb*fb)
        alpha = 0.0
        if(ff.gt.0.0)    alpha = atan2(fb,fa)*radtodeg
        if(alpha.lt.0.0) alpha = alpha + 360.0
        bdata(4) = ff
        bdata(5) = alpha
c
c--Write to an mtz file
        call lwrefl(mtzout,bdata)
      enddo
      call lwclos(mtzout,0)
      call refmac_clean_up_files
      call ccperr(0,'Normal termination: refmac/sfcalc')
      return
      end
c
c-- 
      subroutine write_fofc_sigma(nref,nobs,npart,ndens,fo,sigo,fc,
     &     phase,nind,scale_over,b_over,b_aniso_over,
     &     scale_part,b_part,last_cycle)
C
c---  Write total structure factors to an mtz file
      implicit none
      include 'celsym.fh'
      integer last_cycle
      integer nref,npart,nobs,ndens
      integer nind(nref)
      real fo(*),sigo(*)
      real fc(nobs,ndens),phase(nobs,ndens)
      real scale_over,b_over
      real b_aniso_over(6)
      real scale_part(*),b_part(*)
C     
c---  locals
      integer iout_unit,ifail,ll
      integer npart1
      integer ir,ip
      integer hkl(3)
      real ss,radtodeg
      real cosa_l,sina_l,fa,fb,fap,fbp,ff,alpha,scp
      real s1,s2,s3,s11,s22,s33,s12,s13,s23,sbs
      real sc_loc,expb,expan
      character file_name*512
c     
c---  mtz things
      integer   mtzout,iappnd
c      integer   isort(8)
      real      bdata(200)
      integer   nlprgo
      character lsprgo(20)*30,ctprgo(20)*1
c     
      integer iout_file
c     
c---  allocatables
      real, allocatable :: fobs_all(:)
      real, allocatable :: sigo_all(:)
      real, allocatable :: fcalc_all(:)
      real, allocatable :: alpha_all(:)
      real, allocatable :: sigma_all(:)
      real, allocatable :: sint2l(:)
c
c---  Externals
      real lstlsq
      external lstlsq,unpack
C
c---  body
c
c---  Find "conditional" normalisation coefficients
      call getenv('FCFOUT',file_name)
      if(file_name(1:1).eq.' '.or.last_cycle.eq.0) return
c
      allocate(fobs_all(nref))
      allocate(sigo_all(nref))
      allocate(fcalc_all(nref))
      allocate(alpha_all(nref))
      allocate(sigma_all(nref))
      allocate(sint2l(nref))
c
      radtodeg  = 180.0/(4.0*atan2(1.0,1.0))
c
c---Prepare for mtz
      mtzout = 2
      call lwopen(mtzout,'FCFOUT')
      call lwtitl(mtzout,'Outut FO FC etc.',1)
      isort(1:3) = 1
      isort(4:5) = 0
      if(maxval(cell(4:6)).le.5.0) cell(4:6) = cell(4:6)*radtodeg
      call lwcell(mtzout,cell)
      call lwsort(mtzout,isort)
      iappnd    = 0
      nlprgo    = 8
      lsprgo(1) = 'H'
      ctprgo(1) = 'H'
      lsprgo(2) = 'K'
      ctprgo(2) = 'H'
      lsprgo(3) = 'L'
      ctprgo(3) = 'H'
      lsprgo(4) = 'FO'
      ctprgo(4) = 'F'
      lsprgo(5) = 'SIGO'
      ctprgo(5) = 'Q'
      lsprgo(6) = 'Fcalc'
      ctprgo(6) = 'F'
      lsprgo(7) = 'PHIC'
      ctprgo(7) = 'P'
      lsprgo(8) = 'SIGMANORM'
      ctprgo(8) = 'W'
      call lwassn(mtzout,lsprgo,nlprgo,ctprgo,iappnd)
      CALL LWSYMM(MTZOUT,
     +                NumSymmetry,
     +                 NumPrimSymm,
     +                  RealSymmMatrx,
     +                   Ltype,
     +                    NumSpaceGroup,
     +                     SpaceGroupName,
     +                      PointGroupName)
c
      do   ir=1,nref
        call unpack(nind(ir),hkl(1),hkl(2),hkl(3))
        bdata(1:3) = hkl(1:3)
c
        ss     = lstlsq(1,hkl(1),hkl(2),hkl(3))
        sint2l(ir) = ss
        cosa_l = cos(phase(ir+nobs*npart,1))
        sina_l = sin(phase(ir+nobs*npart,1))
        fa     = fc(ir+nobs*npart,1)*cosa_l
        fb     = fc(ir+nobs*npart,1)*sina_l
        if(npart.gt.0) then
           do  ip=1,npart
              cosa_l = cos(phase(ir+nobs*(ip-1),1))
              sina_l = sin(phase(ir+nobs*(ip-1),1))
              fap    = fc(ir+nobs*(ip-1),1)*cosa_l
              fbp    = fc(ir+nobs*(ip-1),1)*sina_l
              fa     = fa + fap
              fb     = fb + fbp
           enddo
        endif
        ff    = sqrt(fa*fa+fb*fb)
        alpha = 0.0
        if(ff.gt.0.0)    alpha = atan2(fb,fa)*radtodeg
        if(alpha.lt.0.0) alpha = alpha + 360.0
        fcalc_all(ir) = ff
        alpha_all(ir) = alpha
        fcalc_all(ir) = fcalc_all(ir)
        fobs_all(ir) = fo(ir)
c/(scale_over*expan)
        sigo_all(ir) = sigo(ir)
c(scale_over*expan)
      enddo
c
c---  
      call calc_diffnorm(nref,sint2l,fobs_all,sigo_all,
     &     fcalc_all,sigma_all)
      do ir=1,nref
         CALL EQUAL_MAGIC(MTZOUT,BDATA,20)
         call unpack(nind(ir),hkl(1),hkl(2),hkl(3))
         bdata(1:3) = hkl(1:3)
         if(sigo_all(ir).gt.0.0) then
            bdata(4) = fobs_all(ir)
            bdata(5) = sigo_all(ir)
         endif
         bdata(6) = fcalc_all(ir)
         bdata(7) = alpha_all(ir)
         bdata(8) = sigma_all(ir)
         call lwrefl(mtzout,bdata)
      enddo
      call lwclos(mtzout,0)
c
      deallocate(fcalc_all)
      deallocate(fobs_all)
      deallocate(sigo_all)
      deallocate(alpha_all)
      deallocate(sigma_all)
      deallocate(sint2l)

c      call refmac_clean_up_files
c      call ccperr(0,'Normal termination: refmac/sfcalc')
      return
      end
c
      subroutine calc_diffnorm(nref,sint2l,fo,sigo,fc,sigma)
      implicit none
c
      integer nref
      real sint2l(nref)
      real fo(nref),sigo(nref)
      real fc(nref,1)
      real sigma(nref)
c
      integer maxbin_l
      parameter (maxbin_l=1000)
      real delta2
      real sigma_l(maxbin_l)
      
      integer ir,ib
      integer nbin
      integer num_bin(maxbin_l)
      real smin,smax,sdelta,delta_incr
      logical cont_flag

      smin = minval(sint2l)
      smax = maxval(sint2l)
c
      nbin = 200
      sdelta = (smax-smin)/nbin
      delta_incr = sdelta/10.0
c      stop
      cont_flag = .TRUE.
      do while(cont_flag)
c
         num_bin(1:(nbin+1)) = 0
         do ir=1,nref
            if(sigo(ir).gt.0.0) then
               ib = int((sint2l(ir)-smin)/sdelta)+1
               num_bin(ib) = num_bin(ib) + 1
            endif
         enddo
         cont_flag = .FALSE.
         if(minval(num_bin(1:nbin)).lt.60.and.nbin.gt.1) then
            sdelta = sdelta+delta_incr 
            nbin = min(nbin-1,int((smax-smin)/sdelta)+1)
            sdelta = (smax-smin)/nbin
            cont_flag = .TRUE.

         endif
      enddo

      sigma_l(1:(nbin+1)) = 0.0
      do ir=1,nref
         if(sigo(ir).gt.0.0) then
            delta2 = (fo(ir)-fc(ir,1))**2
            ib = int((sint2l(ir)-smin)/sdelta) + 1
            sigma_l(ib) = sigma_l(ib) + delta2
         endif
      enddo
      sigma_l(1:(nbin+1)) = sigma_l(1:(nbin+1))/num_bin(1:(nbin+1))
c

c
      do ir =1,nref
         ib = int((sint2l(ir)-smin)/sdelta)+1
         sigma(ir) = sqrt(sigma_l(ib))
      enddo
      end
c
      
