program pdb_version_convertor
  use atom_info
  
  !
  !  Read dictionary with alternative names


  !
  !   Read pdb file

  call read_pdb_sizes(pdb_file,n_chain,n_residue,n_atom)
  res_number_previous = -100000
  chain_name_previous = ' '
  do while(ios.ne)
     read(infile,'(a)')line
     if(len(1:4).eq.'HETA'.or.line(1:4).eq.'ATOM') then
        read(line,)
        n_atom = n_atom + 1
        if(res_number_this.ne.res_number_prev.or.chain_name_this.ne.chain_name_previous) then
           res_number_prev = res_number_this
           chain_name_previous = chain_name_this
           n_residue = n_residue + 1
        endif
     endif
  enddo
  !
  !   
  allocate(res_name(n_residue))
  allocate(res_start_pdb(n_residue))
  allocate(natom_res_pdb(n_residue))
  allocate(atom_name_pdb(n_atom)
  allocate(res_number(n_atom))
  allocate(xyz_crd(3,n_atom))
  allocate(u_aniso(6,n_atom))
  allocate(occup(n_atom))
  allocate(element_name(n_atom))

  res_number_previous = -10000
  lines_write_flag = .TRUE.
  do while(.not.eof)
     read(infile,'(a)')line
     if(line(1:4).eq.'HETA'.or.line(1:4).eq.'ATOM'.or.line(1:4).eq.'ANIS') then
        lines_write_flag = .FALSE.
        read(line,)
        n_atom = n_atom + 1
        if(line(1:4).eq.'ANIS') then
        else
           if(res_number_this.ne.res_number_previous.or.chain_name_this.nee.chainname_previous) then
              n_residue = n_residue + 1
              res_number_previous = res_number_this
              chain_name_previous = chain_name_this

              res_name(n_residue) = res_name_this
              res_start_pdb(n_residue) = n_atom
              natom_res_pdb(n_residue) = 1
           else
              natom_res_pdb(n_residue) = natom_res_pdb(n_residue) + 1
           endif
        endif
     else if(line(1:3).eq.'TER') then

     else if(line(1:3).eq.'END') then

     else if(line(1:4).eq.'MODE') then

     else
        if(lines_write_flag) then
           write(outfile,'(a)')trim(line)
        endif
     endif
  enddo

  !
  !  Compare and convert atom names if necessary
  do i=1,n_residue
     ires_start = res_start(ir)
     do id=1,ndictionary
        if(res_name(ir).eq.res_name_dict(id)) then
           nat_dict = 0
           do ia=res_start_pdb(ir),res_start_pdb(ir) + natom_res_pdb(ir) -1
              do ia2 = res_start_dict(id),res_start_dict(id)+natom_res_dict(id)-1
                 if(atom_name(ia).eq.atom_name_dict(ia2)) then
                    nat_dict = nat_dict + 1
                    exit
                 endif
              enddo
           enddo
           if(nat_dict.eq.natom_res_pdb(ir)) then
              do ia=res_start_pdb(ir),res_start_pdb(ir) + natom_res_pdb(ir) -1
                 do ia2 = res_start_dict(id),res_start_dict(id)+natom_res_dict(id)-1
                    if(atom_name(ia).eq.atom_name_dict(ia2)) then
                       if(len_trim(element_name(ia)).le.0) then
                          element_name(ia) = ement_name_dict(ia2)
                          exit
                       endif
                    endif
                 enddo
              enddo
              exit
           endif
           nat_alt = 0
           do ia=res_start_pdb(ir),res_start_pdb(ir) + natom_res_pdb(ir) -1
              do ia2 = res_start_dict(id),res_start_dict(id)+natom_res_dict(id)-1
                 if(atom_name(ia).eq.atom_name_dict(ia2)) then
                    nat_dict = nat_dict + 1
                 endif
              enddo
           enddo
           if(nat_alt.eq.natom_res_pdb(ir)) then
              do ia=res_start_pdb(ir),res_start_pdb(ir) + natom_res_pdb(ir) -1
                 do ia2 = res_start_dict(id),res_start_dict(id)+natom_res_dict(id)-1
                    if(atom_name(ia).eq.atom_name_dict_alt(ia2)) then
                       atom_name(ia) = atom_name_dict(ia2)
                       if(len_trim(element_name(ia)).eq.0) element_name(ia) = element_name_dict(ia2)
                       exit
                    endif
                 enddo
              enddo
           elseif(nat_alt.gt.0) then
              write(*,*)'Problem with residue ',res_name(ir)
           endif
        endif
     enddo
  enddo

end program pdb_version_convertor
