module dists_routines

contains
  subroutine sort_and_compress_distances(ndis_in,ndis_out,pairs,atom_ref_flag)
    implicit none
    
    integer, intent(in) ::  ndis_in
    integer, intent(out) :: ndis_out
    integer, intent(inout) :: pairs(:,:)
    integer, intent(in) :: atom_ref_flag(:)


    !
    ! locals
    integer i,ir,it
    integer ia1(2)
    !
    !  body
    if(ndis_in.le.0) return

    do ir=1,ndis_in
       if(pairs(1,ir).gt.pairs(2,ir)) then
          it = pairs(2,ir)
          pairs(2,ir) = pairs(1,ir)
          pairs(1,ir) = it
       endif
    enddo
    if(ndis_in.le.1) then
       ndis_out = ndis_in
       return
    endif

    call iheap_sort_0(ndis_in,2,pairs(1:2,1:ndis_in))

    ndis_out = 0
    ia1(1:2) = 0
    do i=1,ndis_in
       if(sum(abs(pairs(1:2,i)-ia1(1:2))).gt.0.and.pairs(1,i).ne.pairs(2,i)) then
          if(atom_ref_flag(pairs(1,i)).gt.0.and.atom_ref_flag(pairs(2,i)).gt.0) then
             ndis_out = ndis_out + 1
             pairs(1:2,ndis_out) = pairs(1:2,i)
             ia1(1:2) = pairs(1:2,i)
          endif
       endif
    enddo


    return
  end subroutine sort_and_compress_distances

end module dists_routines
