module gibbs_gm

contains
  subroutine gibbs_sampler(vn,,atom_ref_flag,am,nrest_per_atom,rest_per_atom,rest_per_atom_pos,rest_per_atom_dist,nburn_in)

    !
    !  Sampling from gauss-markov field using gibbs sampler. 
    !  Precision matrix defining the field is assumed to be sparse
    !  This subroutine first should be run with nburn_in value set to some positive value
    !  or negative value. If the value is negative then it is set to 100
    !  nburn_in is the number of dry runs.

    !
    !  It is assumed that conditioners have been applied and block diagoanl terms are 
    !  identity
    !

    integer, intent(in) :: atom_ref_flag(:)
    integer, intent(in) :: nrest_per_atom(:)
    integer, intent(in) :: rest_per_atom_pos(:)
    integer, intent(in) :: rest_per_atom(:)
    integer, intent(in) :: rest_per_atom_dist(:)
    real, intent(inout) :: vn(:)
    real, intent(in) :: am(:)
    integer, optional :: nburn_in
    
    !   
    !  locals

    integer nburn
    real rand_gauss(3)
    real, allocatable :: vo(:)
    integer, allocatable :: inds(:)
    !
    !  Diagonal terms are identity
    !
   
    n_atom = size(atom_ref_flag)
    ndist = size(no)

    if(present(nburn_in))then
       nburn=nburn_in
       if(nburn_in.lt.0) nburn = 100
    else
       nburn = 0
    endif

    nv = size(vn)
    allocate(vo(nv))
    if(nburn.gt.0) then
       vn(1:nv) = 0.0
    endif
    !
    !   Should we use coupled runs to determine nburn
    !
    lv = 1
    lm = 1
    do ic=1,nburn+1
       vo = vn
       call random_vector_gauss(nv,vn(1:nv))       
       do iaa=1,n_atom
          if(atom_ref_flag(iaa).gt.0) then
             ia = atom_ref_flag(iaa)/10
             nd_ia = nrest_per_atom(ia)
             npos = rest_per_atom_pos(ia)
             npos1 = npos+nd_ia-1
             if(nd_ia.gt.0) then
                do jad=npos,npos1
                   jaa = rest_per_atom(jad)
                   ja = atom_ref_flag(jaa)/10
                   l1 = rest_per_atom_dist(jad)
                   l = abs(l1)
                   do i=1,3
                      do j=1,3
                         amm(i,j) = am(l)
                         l = l + 1
                      enddo
                   enddo
                   if(l1.lt.0) amm = transpose(amm)
                   if(ja.lt.ia) then
                      ja1 = 3*ja-2
                      ja2 = 3*ja
                      vn(ia1:ia2) = vn(ia1:ia2) - matmul(amm(1:3,1:3),vn(ja1:ja2))
                   elseif(ja.gt.ia) then
                      ja1 = 3*ja-2
                      ja2 = 3*ja
                      vn(ia1:ia2) = vn(ia1:ia2) - matmul(amm(1:3,1:3),vo(ja1:ja2))
                   endif
                enddo
             endif
          endif
       enddo
    enddo
    deallocate(vo)

  end subroutine gibbs_sampler

  subroutine simple_atom_conditioner(am,no,nt,xcond)

    !
    !   Define block conditioners for linear equation solvers and
    !   for gibbs samplers. Conditioners are a set of 3x3 matrices
    !   that are inversion of square root of on diagonal atom matrices
    !
    real, intent(inout) :: am(:)
    real, intent(out) :: xcond(:,:)
    integer, intent(in) :: no(:)
    integer, intent(in) :: nt(:)
    !
    !   locals
    !
    integer i,j,ia,id,lm,icc,io,it,io1,it1
    integer n_atom,nm,ndist

    real(kind=8) :: eval(3),evec(3,3),xloc(3,3)
    real(kind=8) :: toler=1.0d-8
    real :: pw=0.5
    !
    !   body 
    n_atom = size(atom_ref_flag)
    nm = size(am)
    ndist = size(no)

    pw = -0.5
    lm = 1
    icc = 1
    allocate(ref_to_cond(n_atom)
    ref_to_cond(1:n_atom) = 0
    icc = 0
    !
    !   Conditioners are square root of on diagonal 3x3 matrices
    !  While conditioning save references to conditionars and make diagonal terms of 
    !  the matrix as a unit matrix
    do ia=1,n_atom
       if(atom_ref_flag(ia).gt.0)then
          icc = icc + 1
          ref_to_cond(ia) = icc
          xloc(1,1) = am(lm)
          xloc(2,2) = am(lm+1)
          xloc(3,3) = am(lm+2)
          xloc(1,2) = am(lm+3)
          xloc(1,3) = am(lm+4)
          xloc(2,3) = am(lm+5)

          xloc(2,1) = xloc(1,2)
          xloc(3,1) = xloc(1,3)
          xloc(3,2) = xloc(2,3)
          xtemp = xloc
          call deigen_filter_invert_f90_r(xloc,xout,toler,pw)
          xcond(1:3,1:3,icc) = xout(1:3,1:3)

          am(lm:lm+2) = 1.0
          am(lm+3:lm+5) = 0.0
          lm = lm + 6
          icc = icc + 1
       endif
    enddo
    !
    !   Apply conditioners
    !

    do iaa=1,n_atom
       if(atom_ref_flag(iaa).gt.0) then
          ia = atom_ref_flag(iaa)/10
          nd_ia = nrest_per_atom(iaa)
          npos = res_per_atom_pos(iaa)
          npos1 = npos+nd_ia-1
          icc = ref_to_cond(iaa)
          do jad=npos,npos1
             jaa = rest_per_atom(jad)
             ja = atom_ref_flag(jaa)/10
             icc1 = ref_to_cond(jaa)
             if(ia.lt.ja) then
                l1 = rest_per_atom_dist(jad)
                l = abs(l1)
                do i=1,3
                   do j=1,3
                      amm(i,j) = am(l)
                      l = l + 1
                   enddo
                enddo
                if(l1.lt.0) then
                   amm = matmul(matmul(xcond(1:3,1:3,icc),amm),xcond(1:3,1:3,icc1))
                else
                   amm = matmul(matmul(xcond(1:3,1:3,icc1),amm),xcond(1:3,1:3,icc))
                endif
                l=abs(l1)
                do i=1,3
                   do j=1,3
                      am(l) = amm(i,j)
                   enddo
                enddo
             endif
          enddo
       endif
    enddo
    deallocate(ref_to_cond)

  end subroutine simple_atom_conditioner

end module gibbs_gm
