module linalgebra_f90
  implicit none
  ! Fortran 90 routines to some of lapack routines and a bit more
  real(kind=8), private :: rankd=1.0d-8
  real(kind=8), private :: dfmin=tiny(rankd)
  real, private :: pw0

  contains
    subroutine deigen_filter_invert_f90_r(amat_in,amat_out,rank_in,pw)
      implicit none

      real(kind=8), optional :: rank_in
      real, optional :: pw
      real(kind=8), intent(in) :: amat_in(:,:)
      real(kind=8), intent(out) :: amat_out(:,:)
      !
      ! locals
      integer i,j,k
      integer nsize
      integer nwork,info
      real(kind=8), allocatable :: workspace(:)
      real(kind=8), allocatable :: eval(:)
      !
      !   body
      nsize = size(amat_in(:,1))
      if(nsize.eq.1) then
         if(abs(amat_in(1,1)).gt.dfmin) then
            amat_out(1,1) = amat_in(1,1)
         else
            amat_out(1,1) = 0.0
         endif
      endif

      if(present(rank_in)) then
         if(rank_in.gt.0.0) rankd = rank_in
      endif
      if(present(pw)) pw0 = pw

      nwork = (nsize+3)*nsize
      
      allocate(workspace(nwork))
      allocate(eval(nsize))
      call dsyev('V','U',nsize,amat_in,nsize,eval,workspace,nwork,info)

      do i=1,nsize
         if(eval(i).gt.max(abs(eval(nsize))*rankd,dfmin)) then
            eval(i) = eval(i)**pw0
         else
            eval(i) = 0.0
         endif
      enddo
      !
      !  Pseudo inverse
      amat_out = 0.0
      do i=1,nsize
         do k=1,nsize
            amat_out(i,k)=amat_out(i,k)+sum(amat_in(i,:)*amat_in(k,:)*eval(:))
         enddo
      enddo
      deallocate(workspace)
      deallocate(eval)
      return
    end subroutine deigen_filter_invert_f90_r
  end module linalgebra_f90
      
