module ridge
  real :: sigma_dist_r=0.0
  real :: dmax_dist_r = 4.2
  real :: sigma_pos_r = 0.0
  real :: sigma_b_r = 0.0
  real :: sigma_u_r = 0.0
  real :: sigma_uval_diff=0.0
  integer :: interchain_dist_r=0
  integer :: intersym_dist_r=0

contains

  subroutine ridge_pos(am,atom_ref_flag,atom_sigma)
    implicit none
    !
    !  Ridge type restraints for atomic positions
    real, intent(inout) :: am(:)
    real, intent(in) :: atom_sigma(:)
    integer, intent(in) :: atom_ref_flag(:)
    !
    !  locals
    integer ia,ia1,n_atom,ip
    real w

    !
    ! body
    n_atom = size(atom_ref_flag(:))
    if(maxval(atom_sigma(1:n_atom)).le.0.0) return
    !    if(sigma_pos_r.le.0.0) return
    do ia=1,n_atom
       if(atom_ref_flag(ia).le.0) cycle
       ia1 = atom_ref_flag(ia)/10
       if(atom_sigma(ia).gt.0.0) then
          w = 1.0/atom_sigma(ia)**2
          if(ia1.le.0) cycle
          ip = 6*ia1-5
          am(ip:ip+2) = am(ip:ip+2) + w
       endif
    enddo
    return
  end subroutine ridge_pos

  subroutine ridge_dist(nmpos,am,n_target,n_object,nsym_dist,nw_uval,rest_pos_per_atom,rest_per_atom, &
       i_resid,atom_ref_flag,xyz_crd,occup,cell,rot,tr,file_in)
    implicit none

    real cell(6)
    real, intent(in) :: rot(:,:,:),tr(:,:)
    integer, intent(in) :: n_target(:),n_object(:),nsym_dist(:,:),nw_uval(:)
    integer, intent(in) :: rest_pos_per_atom(:),rest_per_atom(:)
    integer, intent(in) :: i_resid(:)
    integer, intent(in) :: atom_ref_flag(:)
    real, intent(in) :: xyz_crd(:,:),occup(:)
    integer, intent(in) :: nmpos
    real, intent(inout) :: am(:)
    character(len=*), intent(in) :: file_in
    !
    integer nsym
    integer n_atom,max_mat,ndist
    real rs_vidl(3)
    integer ia1_l(2),ia11_l(2),isym_l(4),ir1(2),itype
    integer ipos_mat1(2)
    integer ib,iw_uval,imode,idist
    integer in_file,ierr
    integer nr_vdw
    real small_bond,bond_c,w
    real dbdx1(3),dbdx2(3),xyz_temp(3)
    real ort_to_frac(3,3),frac_to_ort(3,3)
    character chnamp1*4,chnamp2*4
    !
    !   body
    if(sigma_dist_r.le.0.0) return
    nsym = size(rot(1,1,:))
    n_atom = size(xyz_crd(1,:))
    max_mat = size(am(:))
    ndist = size(n_target(:))
    small_bond = 0.01
    !
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),frac_to_ort,ort_to_frac,ierr)
    iw_uval = 7
    if(len_trim(file_in).le.0) return
    ierr = 0
    call open_unform_file(in_file,file_in,ierr)
    if(ierr.gt.0) return

    read(in_file)nr_vdw
    if(nr_vdw.le.0) then
       close(in_file)
       return
    endif

    do ib=1,nr_vdw
       read(in_file)ia1_l(1:2),rs_vidl(1:3),isym_l(1:4),itype
       isym_l(1) = max(1,isym_l(1))
       if((isym_l(1).gt.1.or.sum(abs(isym_l(2:4))).ne.0).and.intersym_dist_r.eq.0) cycle
       if(ia1_l(1).le.0.or.ia1_l(2).le.0) cycle
       if(atom_ref_flag(ia1_l(1)).le.0.or.atom_ref_flag(ia1_l(2)).le.0) cycle
       ir1(1:2) = i_resid(ia1_l(1:2))
       call get_chain_namepdb(chnamp1,ir1(1))
       call get_chain_namepdb(chnamp2,ir1(2))
       if(chnamp1.ne.chnamp2.and.interchain_dist_r.eq.0) cycle

       ia11_l(1:2) = atom_ref_flag(ia1_l(1:2))/10
       if(isym_l(1).gt.1.or.sum(abs(isym_l(2:4))).ne.0) then
          xyz_temp = matmul(ort_to_frac,xyz_crd(1:3,ia1_l(2)))
          xyz_temp = matmul(rot(1:3,1:3,isym_l(1)),xyz_temp) + tr(1:3,isym_l(1))+float(isym_l(2:4))
          xyz_temp = matmul(frac_to_ort,xyz_temp)
       else
          xyz_temp = xyz_crd(1:3,ia1_l(2))
       endif
       dbdx1(1:3) = xyz_crd(1:3,ia1_l(1))-xyz_temp
       bond_c = sqrt(sum(dbdx1(1:3)**2))
       if(bond_c.gt.dmax_dist_r) cycle
       dbdx1(1:3) = dbdx1(1:3)/max(small_bond,bond_c)
       dbdx2(1:3) = -dbdx1(1:3)
       w = 1.0/sigma_dist_r**2
       ipos_mat1(1:2) = 6*ia11_l(1:2) - 6
       if(isym_l(1).gt.0) then
          xyz_temp = matmul(transpose(frac_to_ort),dbdx2)
          xyz_temp = matmul(transpose(rot(1:3,1:3,isym_l(1))),xyz_temp)
          dbdx2 = matmul(transpose(ort_to_frac),xyz_temp)
       endif
       call incr_matr_diagonal(max_mat,ipos_mat1(1),am,w,dbdx1)
       call incr_matr_diagonal(max_mat,ipos_mat1(2),am,w,dbdx2)
       call find_restraint(ndist,ndist,idist,ia1_l(1),ia1_l(2),isym_l,n_atom,rest_pos_per_atom, &
            rest_per_atom,n_target,n_object,nsym_dist,nw_uval,iw_uval,imode)
       ipos_mat1(1) = nmpos + 9*(idist-1)

       if(imode.eq.0) then
          call incr_matr_ndiag(max_mat,ipos_mat1(1),am,w,dbdx1,dbdx2)
       else
          call incr_matr_ndiag(max_mat,ipos_mat1(1),am,w,dbdx2,dbdx1)
       endif       
    enddo
    close(in_file)

    return
  end subroutine ridge_dist

  subroutine ridge_dist2orig(sum_f,nmpos,am,v,n_target,n_object,nsym_dist,nw_uval,rest_pos_per_atom,rest_per_atom, &
       i_resid,atom_ref_flag,xyz_crd,occup,file_in)
    implicit none
    !
    !  this subroutine is similar to distance restraints. Only difference is that in this routine weights
    !  depend on the deviation from the "ideal" value
    real, intent(out) :: sum_f
    integer, intent(in) :: n_target(:),n_object(:),nsym_dist(:,:),nw_uval(:)
    integer, intent(in) :: rest_pos_per_atom(:),rest_per_atom(:)
    integer, intent(in) :: i_resid(:)
    integer, intent(in) :: atom_ref_flag(:)
    real, intent(in) :: xyz_crd(:,:),occup(:)
    integer, intent(in) :: nmpos
    real, intent(inout) :: am(:),v(:)
    character(len=*), intent(in) :: file_in
    !
    !  locals
    integer ierr,in_file
    integer n_atom,ndist,n_vec,n_mat,imode,iw_uval
    integer ir,nr_vdw,ip1,idist
    integer ia1_l(2),ia11_l(2),isym_l(4)
    real rs_vidl(2)
    real small_bond,bond_c,w,delta,dbondw,dbondw2,ww,ww1,w_gm
    real dbdx1(3),dbdx2(3)
    !
    !  body
    if(sigma_dist_r.le.0) return
    if(len_trim(file_in).le.0) return
    
    w = 1.0/sigma_dist_r**2
    w_gm = 0.1
    ierr = 0
    call open_unform_file(in_file,file_in,ierr)
    if(ierr.gt.0) return
    read(in_file)nr_vdw
    if(nr_vdw.le.0) then
       close(in_file)
       return
    endif
    n_atom = size(xyz_crd(1,:))
    n_mat = size(am(:))
    ndist = size(n_target(:))
    n_vec = size(v(:))

    iw_uval = 7
    sum_f = 0.0
    do ir=1,nr_vdw
       read(in_file)ia1_l(1:2),rs_vidl(1:2)
       isym_l(1) = 1
       isym_l(2:4) = 0
       if(atom_ref_flag(ia1_l(1)).le.0.or.atom_ref_flag(ia1_l(2)).le.0) cycle
       
       dbdx1(1:3) = xyz_crd(1:3,ia1_l(1))-xyz_crd(1:3,ia1_l(2))
       bond_c = sqrt(sum(dbdx1(1:3)**2))
       dbdx1 = dbdx1/max(bond_c,small_bond)
       dbdx2 = -dbdx1
       delta = rs_vidl(1)-bond_c
       dbondw = w*delta
       dbondw2 = w*delta**2
       ww = 1.0/(1.0+w_gm*dbondw2)**2
       sum_f = sum_f + 0.5*dbondw2
       ip1 = 3*(ia11_l(1)-3)
       call incr_vector(n_vec,ip1,v,dbondw,dbdx1)
       ip1 = 3*(ia11_l(2)-3)
       call incr_vector(n_vec,ip1,v,dbondw,dbdx2)
       ip1 = 6*(ia11_l(1)-6)
       ww1 = w*ww
       call incr_matr_diagonal(n_mat,ip1,am,ww1,dbdx1)
       ip1 = 6*(ia11_l(2)-6)

       call find_restraint(ndist,ndist,idist,ia1_l(1),ia1_l(2),isym_l,n_atom,rest_pos_per_atom, &
            rest_per_atom,n_target,n_object,nsym_dist,nw_uval,iw_uval,imode)
       ip1 = nmpos + 9*(idist-1)

       if(imode.eq.0) then
          call incr_matr_ndiag(n_mat,ip1,am,ww1,dbdx1,dbdx2)
       else
          call incr_matr_ndiag(n_mat,ip1,am,ww1,dbdx2,dbdx1)
       endif       
    enddo

    return
  end subroutine ridge_dist2orig

  subroutine ridge_vector()
    implicit none

  end subroutine ridge_vector

  subroutine ridge_uval_all(nmtmp,am,atom_ref_flag,u_aniso)
    implicit none

    !
    !   Restraints U values to the current ones using the formula
    !   (B/B_current-1)^2=((B-B_current)/B_current)^2   for isotropic U ad
    !    sum_{ij} ((U_{ij}-U_current_{ij})/Uiso_current)^2
    integer, intent(in) :: atom_ref_flag(:)
    real, intent(in) :: u_aniso(:,:)
    integer, intent(in) :: nmtmp
    real, intent(inout) :: am(:)
    !
    !   locals
    integer n_atom
    integer i,ia,ia1,l1,l2,lm
    integer, allocatable :: lposm(:)
    real biso1,dr1,wt3,ww,wl

    if(sigma_u_r.le.0.0) return
    n_atom = size(u_aniso(1,:))
    wt3 = 1.0/sigma_u_r**2
    l1 = 0
    l2 = nmtmp
    allocate(lposm(n_atom))
    lm = 1
    ia1 = 0
    do ia=1,n_atom
       if(atom_ref_flag(ia).le.0) cycle
       ia1 = ia1 + 1
       lposm(ia1) = lm
       if(u_aniso(2,ia).gt.0) then
          lm = lm + 21
       else
          lm = lm + 1
       endif
    enddo
    !
    do ia=1,n_atom
       if(atom_ref_flag(ia).le.0) cycle
       lm = lposm(ia)
       if(u_aniso(2,ia).le.0.0) then
          biso1 = u_aniso(1,ia)
          dr1 = 1.0/biso1
          am(l1+lm) = am(l2+lm) + 2.0*wt3*dr1*dr1
       else
          ww = (u_aniso(1,ia)+u_aniso(2,ia)+u_aniso(3,ia))/3.0
          dr1 = 1/ww
          wl = wt3
          do i=1,6
             if(i.le.3) then
                am(l1+lm+i-1) = am(l1+lm+i-1) + wt3*dr1*dr1
             else
                 am(l1+lm+i-1) = am(l1+lm+i-1) + 2.0*wt3*dr1*dr1
              endif
          enddo
       endif
    enddo
    deallocate(lposm)

  end subroutine ridge_uval_all


  subroutine ridge_uval_aniso(nmtmp,am,atom_ref_flag,u_aniso)
    implicit none

    integer, intent(in) :: atom_ref_flag(:)
    real, intent(in) :: u_aniso(:,:)
    integer, intent(in) :: nmtmp
    real, intent(inout) :: am(:)

    return
  end subroutine ridge_uval_aniso

  subroutine ridge_uval_diff(nmtmp,am,atom_ref_flag,xyz_crd,u_aniso,n_object,n_target,nsym_dist,nw_uval,cs_cell,cs_m_cs,cs_v_cs)
    !
    !  Regulariser restraints for uvalues. Essentially it tries to keep differences between uvalues similar to the current one.
    integer nmtmp
    real cs_cell(6)
    real, intent(in) :: cs_m_cs(:,:,:),cs_v_cs(:,:)
    integer, intent(in) :: n_object(:),n_target(:),nsym_dist(:,:),nw_uval(:),atom_ref_flag(:)
    real, intent(in) :: u_aniso(:,:),xyz_crd(:,:)
    real, intent(inout) :: am(:)
    real sigma_in
    !
    !   locals
    integer ndist
    integer ierror
    integer nsym
    integer id,io,it,isym,is,iwt,io1,it1,io11,it11,lom,ltm
    real xyz(3)
    real tm(3,3)
    real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3),ro_unit(3,3),rfr_unit(3,3)
    real rsymm_ort(3,3,192)
    !
    !
    integer ian,ian1,ii,lposmo,lposmt,l2,ld,lm
    real d,Biso1,Biso2,rr
    real u1v(6),u2v(6)
    real u1(3,3),u2(3,3),u12(3,3)
    real dadu1(6,6),dadu2(6,6),d2fda2(6)
    !
    integer, allocatable :: lposm(:)
    !
    real wtt3,wtt
    ! 
    if(sigma_uval_diff.le.0.0) return
    n_atom = size(xyz_crd(1,:))
    ndist  = size(n_object(:))
    nsym   = size(cs_m_cs(1,1,:))
    call calc_ort_etc(cs_cell,cs_frac_to_ort,cs_ort_to_frac,ro_unit,rfr_unit)

    do is=1,nsym
       tm = matmul(cs_m_cs(1:3,1:3,is),rfr_unit)
       rsymm_ort(1:3,1:3,is) = matmul(ro_unit,tm)
    enddo
    allocate(lposm(n_atom))
    !
    lm  = 1
    ia1 = 0
    do ia=1,n_atom
       if(atom_ref_flag(ia).gt.0) then
          ia1 = ia1 + 1
          lposm(ia1) = lm
          if(u_aniso(2,ia).le.0.0) then
             lm = lm + 1
          else
             lm = lm + 21
          endif
       endif
    enddo
    !
    ld = 1
    l1 = 0
    l2 = nmtmp
    do id=1,ndist
       io = n_object(id)
       it = n_target(id)

       isym = nsym_dist(1,id)
       iwt = nw_uval(id)
       io1 = atom_ref_flag(io)/10
       it1 = atom_ref_flag(it)/10
       io11 = atom_ref_flag(io)-io1*10
       it11 = atom_ref_flag(it)-it1*10

       xyz = xyz_crd(1:3,io)
       if(isym.gt.1) then
          xyz = matmul(cs_ort_to_frac,xyz)
          xyz = matmul(cs_m_cs(1:3,1:3,isym),xyz)+cs_v_cs(1:3,isym) + float(nsym_dist(2:4,id))
          xyz = matmul(cs_frac_to_ort,xyz)
       endif
       d = sqrt(sum((xyz_crd(1:3,it)-xyz(1:3))**2))
       wtt3 =1.0/sigma_uval_diff**2
       wtt3 = wtt3*(3.0/max(3.0,d))**2
       wtt = wtt3/3.0

       lom = lposm(io1)
       ltm = lposm(it1)
       if(io.ne.it.and.iwt.gt.2) then
          if(u_aniso(2,io).le.0.0.and.u_aniso(2,it).le.0.0) then

          elseif(u_aniso(2,io).gt.0.0.and.u_aniso(2,it).gt.0.) then
             u1v = u_aniso(1:6,it)
             u2v = u_aniso(1:6,io)
             call aniso_vect2mat(u1v,u1)
             call aniso_vect2mat(u2v,u2)
             Biso1 = trace_r(3,u1)/3.0
             Biso2 = trace_r(3,u2)/3.0
             rr = sqrt(Biso1*Biso2)    
             u12 = u1-u2
             if(isym.gt.1) then
                tm = matmul(rsymm_ort(1:3,1:3,isym),u2)
                u2 = matmul(tm,transpose(rsymm_ort(1:3,1:3,isym)))
             endif
             dadu1(1:6,1:6) = 0.0
             do ii=1,6
                dadu1(ii,ii) = -1.0
             enddo
             dadu2 = -dadu1
             !
             dadu1 = dadu1/rr
             dadu2 = dadu2/rr
             do i=1,3
                d2fda2(i) = 1.0
                d2fda2(i+3) = 2.0
             enddo
             dfda   = wtt*dfda
             d2fda2 = wtt*d2fda2
             !
             !---  Second derivatives
             iposmt = lposm(it1)-1
             iposmo = lposm(io1)-1
             do ian=1,6
                iposmt = iposmt + 1
                iposmo = iposmo + 1
                do ii=1,6
                   am(iposmt) = am(iposmt) + d2fda2(ii)*dadu1(ii,ian)*dadu1(ii,ian)
                   am(iposmo) = am(iposmo) + d2fda2(ii)*dadu2(ii,ian)*dadu2(ii,ian)
                enddo
             enddo
             do ian=1,5
               do ian1=ian+1,6
                  iposmo = iposmo + 1
                  iposmt = iposmt + 1
                  do ii=1,6
                     am(iposmt) = am(iposmt) + d2fda2(ii)*dadu1(ii,ian)*dadu1(ii,ian1)
                     am(iposmo) = am(iposmo) + d2fda2(ii)*dadu2(ii,ian)*dadu2(ii,ian1)
                  enddo
               enddo
            enddo
            !
            !---  Nondiagonal elements
            ld0 = ld-1
            do ian1=1,6
               do ian2=1,6
                  ld0 = ld0 + 1
                  do ii=1,6
                     am(l2+ld0) = am(l2+ld0) + d2fda2(ii)*dadu1(ii,ian1)*dadu2(ii,ian2)
                  enddo
               enddo
            enddo
          endif
       endif
       if(u_aniso(2,it).le.0.0.and.u_aniso(2,io).le.0.0) then
          ld = ld + 1
       else if(u_aniso(2,it).gt.0.0.and.u_aniso(2,io).le.0.0) then 
          ld = ld + 6
       else if(u_aniso(2,it).le.0.0.and.u_aniso(2,io).gt.0.0) then 
          ld = ld + 6
       else if(u_aniso(2,it).gt.0.0.and.u_aniso(2,io).gt.0.0) then 
          ld = ld + 36
       endif
    enddo

  end subroutine ridge_uval_diff
end module ridge
