      SUBROUTINE SET_NUM(MDOC,MON,PNUM,IERR)
C -----------------------------------------------
C -P- SET_NUM - defines atom's number for atom's name.
C               check tree like sructure, extra_atoms
C               add H_atoms
C    
C        used ener_lib.cif     
C     input:
C        L1A_NATOM 
C        L1A_NHATOM 
C        L1A_COOR_FLAG()  = 'Y' or 'N'
C        L1A_X        () 
C        L1A_Y        () 
C        L1A_Z        ()
C        L1A_CHEM     ()
C        L1A_BACK     ()
C        L1A_TYPE     ()
C        L1A_FORW     ()
C        L1N_NCONN
C        L1N_1ATM     ()
C        L1N_2ATM     ()
C        L1N_TYPE     ()
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,PNUM*12
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C -------------------------------------------------------
      CHARACTER NAME*4,LINE*256
C --------------------------------------------------------
      IERR = 0
C      IF(L1A_NHATOM.EQ.L1A_NATOM) THEN
C        CALL ADD_H(MDOC,MON,IERR)
C      ENDIF
C --
      DO I=1,L1A_NATOM
        L1A_IOLD  (I) = I
        L1A_INEW  (I) = I
c       L1A_COOR_FLAG(I)='N'
        L1A_LENGTH(I) =-1.0
        L1A_THETA (I) =-1.0
        L1A_PHI   (I) = 0.0
        L1A_ID_PSI(I) = '?' 
      ENDDO
      IFLAGB = 0
      IFLAGF = 0
      IERR   = 0
C ------
      IF(L1A_NATOM.GT.1) THEN
        DO I=1,L1A_NATOM-1
          NAME = L1A_ANAME(I)
          DO J=I+1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              IF(PNUM(1:1).EQ.' ') THEN
                LINE = ' WARNING : '//MON//
     *                 ' : duplicated atom_name: '//L1A_ANAME(J)
              ELSE
                LINE = ' WARNING : '//MON//' '//PNUM//
     *                 ' : duplicated atom_name: '//L1A_ANAME(J)
              ENDIF
              CALL MSGERR(MDOC,LINE)
              IERR = 1
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C ------
      DO I=1,L1A_NATOM
C --
        NAME = L1A_BACK(I)
        IF(NAME(1:1).NE.'.') THEN
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              L1A_IBACK(I) = J
              GO TO 100
            ENDIF
          ENDDO

C         without back atom

          L1A_IBACK(I) = 0
          IF(L1A_SYMB(I)(1:2).NE.'H '.AND.L1A_SYMB(I)(1:2).NE.'D ') THEN
            IF(PNUM(1:1).EQ.' ') THEN
              LINE = ' WARNING : '//MON//
     *             ' : back_atom for '//L1A_ANAME(I)//' is absent'
            ELSE      
              LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : back_atom for '//L1A_ANAME(I)//' is absent'
            ENDIF
            CALL MSGERR(MDOC,LINE)
            IERR = 1
          ELSE
            L1A_BACK(I) = '.'
            L1A_FORW(I) = '.'
          ENDIF
  100     CONTINUE
        ELSE     
           L1A_IBACK(I) = -1
          L1A_ISTART   = I
          IFLAGB       = IFLAGB + 1
        ENDIF
C --
        CALL LENSTR_BL(L1A_FORW(I),LEN)
        IF(LEN.LE.0) L1A_FORW(I) = '.'
        NAME = L1A_FORW(I)
        IF(NAME(1:3).EQ.'END') THEN
          L1A_IFORW(I) = -1
          L1A_IFINISH  = I
          IFLAGF       = IFLAGF + 1
        ELSE IF(NAME(1:1).NE.'.') THEN
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN 
              L1A_IFORW(I) = J
              IF(L1A_BACK(J).NE.L1A_ANAME(I)) THEN
                IF(PNUM(1:1).EQ.' ') THEN
                  LINE = ' WARNING : '//MON//
     * ' : atom '//L1A_ANAME(I)//' has wrong forward_atom '//NAME
                ELSE
                  LINE = ' WARNING : '//MON//' '//PNUM//
     * ' : atom '//L1A_ANAME(I)//' has wrong forward_atom '//NAME
                ENDIF 
                CALL MSGERR(MDOC,LINE)
                IERR=1
              ENDIF
              GO TO 120
            ENDIF
          ENDDO
          L1A_IFORW(I) = 0
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *             ' : forward_atom for '//L1A_ANAME(I)//' is absent'
          ELSE   
            LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : forward_atom for '//L1A_ANAME(I)//' is absent'
          ENDIF
          CALL MSGERR(MDOC,LINE)
          IERR = 1
  120     CONTINUE
        ELSE     
          L1A_IFORW(I) = 0
        ENDIF
C ------
        L1A_NDIST(I) = 0
        L1A_NEXTR(I) = 0
        NAME         = L1A_CHEM(I)
        DO J=1,LEA_NATOM
          IF(LEA_ANAME(J).EQ.NAME) THEN
            L1A_ICHEM(I) = J
            GO TO 140
          ENDIF  
        ENDDO
        IF(LES_NSYN.GT.0) THEN
          DO J=1,LES_NSYN
            IF(LES_STYP(J).EQ.NAME) THEN
              DO JS=1,LEA_NATOM
                IF(LEA_ANAME(JS).EQ.LES_ATYP(J)) THEN
                  L1A_CHEM(I)  = LES_ATYP(J)
                  L1A_ICHEM(I) = JS
                  GO TO 140
                ENDIF  
              ENDDO
            ENDIF  
          ENDDO
        ENDIF

C       NAME='CH1 '
        NAME = L1A_SYMB(I)
        IF(L1A_SYMB(I)(1:2).NE.'H '.AND.L1A_SYMB(I)(1:2).NE.'D ') THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : unknown chemical type of atom '//L1A_ANAME(I)//
     *           ' - '//L1A_CHEM(I)
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : unknown chemical type of atom '//L1A_ANAME(I)//
     *           ' - '//L1A_CHEM(I)
        ENDIF
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,
     *'(''                 default type is - "'',A4,''"'')')
     *      NAME
        CALL MSGERR(MDOC,LINE)
        ENDIF
        DO J=1,LEA_NATOM
          IF(LEA_ANAME(J).EQ.NAME) THEN
            L1A_ICHEM(I)=J
            GO TO 140
          ENDIF  
        ENDDO
        IF(LES_NSYN.GT.0) THEN
          DO J=1,LES_NSYN
            IF(LES_STYP(J).EQ.NAME) THEN
              DO JS=1,LEA_NATOM
                IF(LEA_ANAME(JS).EQ.LES_ATYP(J)) THEN
                  L1A_CHEM(I)  = LES_ATYP(J)
                  L1A_ICHEM(I) = JS
                  GO TO 140
                ENDIF  
              ENDDO
            ENDIF  
          ENDDO
        ENDIF
        L1A_ICHEM(I) = 1
  140   CONTINUE
      ENDDO
      IF(IFLAGB.LE.0) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : first atom of the tree is absent'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : first atom of the tree is absent'
        ENDIF
        CALL MSGERR(MDOC,LINE)
        IERR = 1
      ELSE IF(IFLAGB.GT.1) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : wrong definition of first atom of the tree'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : wrong definition of first atom of the tree'
        ENDIF
        CALL MSGERR(MDOC,LINE)
        IERR = 1
      ENDIF
      IF(IFLAGF.LE.0) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : last atom of the tree is absent'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : last atom of the tree is absent'
        ENDIF
        CALL MSGERR(MDOC,LINE)
        IERR = 1
      ELSE IF(IFLAGF.GT.1) THEN
        IF(PNUM(1:1).EQ.' ') THEN
           LINE = ' WARNING : '//MON//
     *            ' : multiple definition of last atom of the tree'
        ELSE
           LINE = ' WARNING : '//MON//' '//PNUM//
     *            ' : multiple definition of last atom of the tree'
        ENDIF
        CALL MSGERR(MDOC,LINE)
        IERR = 1
      ENDIF
C -----

      IF(IERR.EQ.0) THEN
        I = L1A_IFINISH 
  700     CONTINUE
          J = L1A_IBACK(I)
          IF(J.LT.0) GO TO 710
          L1A_FORW(J)  = L1A_ANAME(I)
          L1A_IFORW(J) = I 
          I            = J
          GO TO 700
  710   CONTINUE
      ENDIF
C ---     

      DO I=1,L1A_NATOM
        DO J=1,L1A_NATOM
          IF(L1A_IBACK(J).GT.0.AND.L1A_IBACK(J).EQ.I) THEN
C     *                             L1A_TYPE(J).NE.'DUMMY') THEN
            L1A_NDIST(I)               = L1A_NDIST(I) + 1
            L1A_CONN(L1A_NDIST(I),I)   = J 
            L1A_LENCON(L1A_NDIST(I),I) = 0 
          ENDIF
        ENDDO 
      ENDDO
C ---
c      write(*,*)l1n_nconn
c      do i=1,l1n_nconn
c         write(*,*)i,l1n_1atm(i),l1n_2atm(i)
c      enddo
c      write(*,*)
c      do i=1,l1a_natom
c         write(*,*)i,l1a_aname(i)
c      enddo
      IF(L1N_NCONN.GT.0) THEN
        DO  I = 1,L1N_NCONN
          NAME = L1N_1ATM(I)
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              L1N_I1ATM(I) = J
              GO TO 500
            ENDIF
          ENDDO
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *             ' : unknown extra_atom_name - '//NAME
          ELSE
            LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : unknown extra_atom_name - '//NAME
          ENDIF
          CALL MSGERR(MDOC,LINE)
          L1N_I1ATM(I) = 0
  500     CONTINUE  
          NAME = L1N_2ATM(I)
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              L1N_I2ATM(I) = J
              GO TO 600
            ENDIF
          ENDDO
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *             ' : unknown extra_atom_name - '//NAME
          ELSE
            LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : unknown extra_atom_name - '//NAME
          ENDIF
          CALL MSGERR(MDOC,LINE)
          L1N_I2ATM(I) = 0
  600     CONTINUE  
          IF(L1N_I1ATM(I).GT.0.AND.L1N_I2ATM(I).GT.0) THEN
            J                          = L1N_I1ATM(I)
            K                          = L1N_I2ATM(I)
            L1A_NEXTR(J)               = L1A_NEXTR(J) +1
            L1A_IEXTR(L1A_NEXTR(J),J)  = K 
            L1A_NEXTR(K)               = L1A_NEXTR(K) +1
            L1A_IEXTR(L1A_NEXTR(K),K)  = J 
            IF(L1N_TYPE(K).EQ.'DUMMY') L1A_TEXTR(L1A_NEXTR(J),J) = 1
            IF(L1N_TYPE(J).EQ.'DUMMY') L1A_TEXTR(L1A_NEXTR(K),K) = 1
          ENDIF   
        ENDDO
      ENDIF
c      stop
C ---
      IF(IERR.EQ.0) CALL CONNECT(MDOC,MON,PNUM,IERR)
      IERR = 0
      RETURN
      END

C ******
      SUBROUTINE CONNECT(MDOC,MON,PNUM,IERR)
C -----------------------------------------------
C -P- CONNECT - 
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*(*)
C ---
      INCLUDE 'lib_com.fh'
C ******
      PARAMETER ( NSTLIM = 10 )
      INTEGER   NSTCK,ISTACK(NSTLIM),ICSTACK(NSTLIM)
      INTEGER   IC
      INTEGER   INEW_T(MX1ATOM),IOLD_T(MX1ATOM)
      CHARACTER LINE*256,PNUM*12,CH6*6
      character line1*80
C ---------------------------------------
      IERR=0
      DO IC=1,L1A_NATOM
        INEW_T(IC) = L1A_NDIST(IC)
        IOLD_T(IC) = L1A_IOLD (IC)
      ENDDO
C ---
      ISTART  = L1A_ISTART
      IFINISH = L1A_IFINISH
C ---
      do while(.true.)
         DO IC=1,L1A_NATOM
            IF(INEW_T(IC).EQ.0) THEN
               IF(L1A_IBACK(IC).le.0) GO TO 200
               JC = L1A_IBACK(IC)
               if(jc.gt.0) then
                  IBRN = L1A_NDIST(JC)-INEW_T(JC)+1
                  if(ibrn.le.0.or.ibrn.gt.max1brn) goto 201
                  IS   = 0
                  k0 = l1a_ndist(ic)
                  write(line1,*)k0
                  IF(k0.GT.0) THEN
                     DO K=1,k0
                        k1 = L1A_LENCON(K,IC)
                        IS = IS + k1
                     ENDDO
                  ENDIF
                  L1A_LENCON(IBRN,JC) = IS
                  L1A_CONN(IBRN,JC)   = IC
                  INEW_T(IC)          = -1
                  INEW_T(JC)          = INEW_T(JC)-1
               ENDIF
            endif
 100        CONTINUE
         ENDDO
      enddo
 201  continue
      write(*,*)'Problem in connect',ibrn,max1brn
      ierr = 1
      return
 200  CONTINUE
C ---
c      stop
      DO IC=1,L1A_NATOM
        NL = L1A_NDIST(IC)
        IF(NL.GT.1) THEN

          DO J=1,NL
            KC = L1A_CONN(J,IC)
            IF(L1A_ANAME(KC).EQ.L1A_FORW(IC)) THEN
              ITEMP           = L1A_CONN(J,IC)
              L1A_CONN(J,IC)  = L1A_CONN(NL,IC)
              L1A_CONN(NL,IC) = ITEMP
              GO TO 300
            ENDIF
          ENDDO
          IF(L1A_IFORW(IC).NE.-1) THEN 
            IF(PNUM(1:1).EQ.' ') THEN
              LINE = ' WARNING : '//MON//
     * ' : forward_atom '//L1A_FORW(IC)//' (for '//L1A_ANAME(IC)//
     *        ') is not in the table of connects'
            ELSE
              LINE = ' WARNING : '//MON//' '//PNUM//
     * ' : forward_atom '//L1A_FORW(IC)//' (for '//L1A_ANAME(IC)//
     *        ') is not in the table of con'
            ENDIF
            CALL MSGERR(MDOC,LINE)
            IERR=1
            GO TO 2000
          ENDIF 
  300     CONTINUE

          NL = NL-1
          IF(NL.GT.1) THEN
            DO J=1,NL-1
              L  = L1A_LENCON(J,IC)
              LC = L1A_CONN(J,IC)
              DO K=J+1,NL
                M  = L1A_LENCON(K,IC)
                MC = L1A_CONN(K,IC)
                IF(L1A_ANAME(LC)(1:1).EQ.'H'.AND.
     *             L1A_ANAME(MC)(1:1).NE.'H') 
     *          GO TO 600
                IF(M.LT.L.OR.
     *            (L1A_ANAME(LC)(1:1).NE.'H'.AND.
     *             L1A_ANAME(MC)(1:1).EQ.'H')) THEN
                  ITEMP          = L1A_CONN(J,IC)
                  L1A_CONN(J,IC) = L1A_CONN(K,IC)
                  L1A_CONN(K,IC) = ITEMP
                ENDIF
  600           CONTINUE
              ENDDO
            ENDDO
          ENDIF

        ENDIF
      ENDDO
C ------

      I         = ISTART
      IC        = 1
      INEW_T(I) = 1
      IOLD_T(1) = I
      J         = 2
      NSTCK     = 0
C ----------------------------
  400 CONTINUE

      N = L1A_NDIST(I)
      IF(N.LE.0.AND.NSTCK.LE.0) GO TO 500

        IF(N.EQ.0) THEN

          I     = ISTACK (NSTCK)
          IC    = ICSTACK(NSTCK)
          NSTCK = NSTCK-1

        ELSE IF(N.EQ.1) THEN

          INEXT         = L1A_CONN(1,I)
          INEW_T(INEXT) = J
          IOLD_T(J)     = INEXT
          J             = J+1
          IC            = 1
          I             = INEXT

        ELSE IF(N.GT.1) THEN

  410     CONTINUE
          INEXT         = L1A_CONN(IC,I)
          INEW_T(INEXT) = J
          IOLD_T(J)     = INEXT
          J             = J+1
          IF(IC.LT.N) THEN
            IC    = IC    + 1
            NSTCK = NSTCK + 1
            IF(NSTCK.GT.NSTLIM) THEN
              WRITE(CH6,'(I6)') NSTLIM
              IF(PNUM(1:1).EQ.' ') THEN
                LINE = ' WARNING : '//MON//
     *        ' : N-stack > '//CH6
              ELSE
                LINE = ' WARNING : '//MON//' '//PNUM//
     *        ' : N-stack > '//CH6
              ENDIF
              CALL MSGERR(MDOC,LINE)
              IERR=1
              GO TO 2000
            ENDIF
            ISTACK(NSTCK)  = I
            ICSTACK(NSTCK) = IC
          ENDIF   
          I  = INEXT
          IC = 1

        ELSE
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *    ' : bad tree structure'
          ELSE
            LINE = ' WARNING : '//MON//' '//PNUM//
     *    ' : bad tree structure'
          ENDIF
          CALL MSGERR(MDOC,LINE)
          IERR=1
          GO TO 2000
        ENDIF

      GO TO 400
C ----------------------------
  500 CONTINUE
C --- 


      DO IC=1,L1A_NATOM
        L1A_INEW(IC) = INEW_T(IC)
        L1A_IOLD(IC) = IOLD_T(IC)
      ENDDO
      RETURN
C ------------------
 2000 CONTINUE
      IF(PNUM(1:1).EQ.' ') THEN
        LINE = ' WARNING : '//MON//
     *         ' wrong tree structure /in subr. CONNECT/'
      ELSE
        LINE = ' WARNING : '//MON//' '//PNUM//
     *         ' wrong tree structure /in subr. CONNECT/'
      ENDIF
      CALL MSGERR(MDOC,LINE)
      RETURN    
      END

      SUBROUTINE SET_NUM_LIB(MDOC,LIST)
C -----------------------------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER*4 ICH4
      CHARACTER CH4*4,CH4A*4,LIST*1,LINE*256
      EQUIVALENCE (ICH4,CH4)
C --------------------------------------------------------
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(''set_num_lib:'',5i4)')
     *  L1A_NATOM,L1B_NBOND,L1G_NANGL,L1T_NTORS,L1C_NCHIR
        CALL MSGdoc(MDOC,line)
      ENDIF

      NA = L1A_NATOM
      IF(NA.GT.0) THEN
      IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          DO J=1,NA
            IF(L1B_1ATM(IB).EQ.L1A_ANAME(J)) L1B_I1ATM(IB)=J
            IF(L1B_2ATM(IB).EQ.L1A_ANAME(J)) L1B_I2ATM(IB)=J
          ENDDO
        ENDDO
      ENDIF
       
      IF(L1G_NANGL.GT.0) THEN
        DO IG=1,L1G_NANGL
          DO J=1,NA
            IF(L1G_1ATM(IG).EQ.L1A_ANAME(J)) L1G_I1ATM(IG)=J
            IF(L1G_2ATM(IG).EQ.L1A_ANAME(J)) L1G_I2ATM(IG)=J
            IF(L1G_3ATM(IG).EQ.L1A_ANAME(J)) L1G_I3ATM(IG)=J
          ENDDO
        ENDDO
      ENDIF
 
      IF(L1T_NTORS.GT.0) THEN
        DO IT=1,L1T_NTORS
          DO J=1,NA
            IF(L1T_1ATM(IT).EQ.L1A_ANAME(J)) L1T_I1ATM(IT)=J
            IF(L1T_2ATM(IT).EQ.L1A_ANAME(J)) L1T_I2ATM(IT)=J
            IF(L1T_3ATM(IT).EQ.L1A_ANAME(J)) L1T_I3ATM(IT)=J
            IF(L1T_4ATM(IT).EQ.L1A_ANAME(J)) L1T_I4ATM(IT)=J
          ENDDO
        ENDDO
      ENDIF
       
      IF(L1C_NCHIR.GT.0) THEN
        DO IC=1,L1C_NCHIR
          DO J=1,NA
            IF(L1C_1ATM(IC).EQ.L1A_ANAME(J)) L1C_I1ATM(IC)=J
            IF(L1C_2ATM(IC).EQ.L1A_ANAME(J)) L1C_I2ATM(IC)=J
            IF(L1C_3ATM(IC).EQ.L1A_ANAME(J)) L1C_I3ATM(IC)=J
            IF(L1C_4ATM(IC).EQ.L1A_ANAME(J)) L1C_I4ATM(IC)=J
            IF(L1C_5ATM(IC).EQ.L1A_ANAME(J)) L1C_I5ATM(IC)=J
            IF(L1C_6ATM(IC).EQ.L1A_ANAME(J)) L1C_I6ATM(IC)=J
            IF(L1C_7ATM(IC).EQ.L1A_ANAME(J)) L1C_I7ATM(IC)=J
            IF(L1C_8ATM(IC).EQ.L1A_ANAME(J)) L1C_I8ATM(IC)=J
            IF(L1C_9ATM(IC).EQ.L1A_ANAME(J)) L1C_I9ATM(IC)=J
          ENDDO
          CALL CALC_IVOL(IC,VOLIDL,PH1,PH2,PH3)
          L1C_VOL(IC) = VOLIDL
        ENDDO
      ENDIF

      IF(L1P_NPLAN.GT.0) THEN
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              ICH4 = L1P_ATOM(IAP,IP)
              CALL LENSTR_BL(CH4,LEN)

            IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(''set_num_lib:'',2i3,'':'',a,'':'',a,'':'',2i3)')
     *  IP,IAP,L1P_LABEL(IP),CH4,LEN,L1P_IATOM(IAP,IP)
            CALL MSGdoc(MDOC,line)
            ENDIF

              DO J=1,NA
                CH4A = L1A_ANAME(J)
                CALL LENSTR_BL(CH4A,LENA)
c               IF(LEN.LE.3) CH4A(4:4) = ' '
c               IF(LEN.LE.2) CH4A(3:3) = ' '
c               IF(LEN.LE.1) CH4A(2:2) = ' '
                IF(LEN.EQ.LENA.AND.CH4(1:LEN).EQ.CH4A(1:LEN))THEN
                  L1P_IATOM(IAP,IP)=J
                  GO TO 100
                ENDIF
              ENDDO
              L1P_IATOM(IAP,IP) = 0              
 100          CONTINUE

              IF(LIST.EQ.'T') THEN
       WRITE(LINE,'(''set_num_lib:'',2i3,'':'',a,'':'',a,'':'',2i3)')
     * IP,IAP,L1P_LABEL(IP),CH4,LENa,L1P_IATOM(IAP,IP)
              CALL MSGdoc(MDOC,line)
              ENDIF

            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF
C --
      RETURN
      END

C ******
