c
      subroutine make_residue_pairs(maxatom,n_atom,
     &     xyz_crd,occup,i_resid,maxnso,
     &     cs_nsym,cs_m_cs,cs_v_cs,cs_cell,pairs_file,ierr)


      implicit none
      integer maxatom,n_atom
      integer i_resid(n_atom)
      real xyz_crd(3,n_atom),occup(n_atom)
      integer maxnso,cs_nsym
      real cs_m_cs(3,3,maxnso),cs_v_cs(3,maxnso)
      real cs_cell(6)
      character pairs_file*(*)

c
c--Make hte list of residue pairs that are close to each other
c
      integer iscr1,ierr
      real dlim
c
      character mon1*8,mon2*8
      integer np,np1,ip,ip0,ir1,ir2,im,npairs
      integer ia1(2),symm_l(4)
      integer, allocatable :: atom_pairs(:,:)
      integer, allocatable :: resids(:,:)
c
      integer k,nr_all,nr
      integer, allocatable :: ia1_l(:,:)
      integer, allocatable :: symm_ll(:,:)
      logical found
c
      real dlim_1
c
      dlim = 3.0
c
      call find_all_contacts(dlim,
     &     maxatom,n_atom,xyz_crd(1:3,1:n_atom),occup(1:n_atom),
     &     maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &     pairs_file,ierr)
c
      call open_unform_file(iscr1,pairs_file,ierr)
      read(iscr1)npairs,dlim_1
      allocate(atom_pairs(2,npairs))
      np = 0
      nr_all = 0
      do while(nr_all.lt.npairs)
         read(iscr1)nr
         if(nr.le.0) cycle
         nr_all = nr_all + nr
         if(nr_all.gt.npairs) then
            write(*,*)'Error==> Problem with vdws'
            call ccperr(1,'Problem with find_contacts')
         endif
         allocate(ia1_l(2,nr))
         allocate(symm_ll(4,nr))
         read(iscr1)(ia1_l(1:2,k),symm_ll(1:4,k),k=1,nr)
         do k=1,nr
            ia1(1:2) = ia1_l(1:2,k)
            symm_l(1:4) = symm_ll(1:4,k)
            if(symm_l(1).eq.1.and.sum(abs(symm_l(2:4))).eq.0) then
               ir1 = i_resid(ia1(1))
               ir2 = i_resid(ia1(2))
               if(ir1.ne.ir2) then
                  np = np + 1
                  atom_pairs(1,np) = minval(ia1(1:2))
                  atom_pairs(2,np) = maxval(ia1(1:2))
               endif
            endif
         enddo
         deallocate(ia1_l)
         deallocate(symm_ll)
      enddo
      close(iscr1,status='DELETE')
c
      allocate(resids(2,np))
      do ip=1,np
         resids(1:2,ip) = i_resid(atom_pairs(1:2,ip))
      enddo
      deallocate(atom_pairs)
      call iheap_sort_0(np,2,resids(1:2,1:np))
      found = .FALSE.
      ip0 = 0
      do ip=1,np
         call get_mon_name(resids(1,ip),mon1)
         call get_mon_name(resids(2,ip),mon2)
         if(mon1.ne.'DUM'.and.mon1.ne.'HOH'.and.
     &        mon2.ne.'DUM'.and.mon2.ne.'HOH') then
            found = .TRUE.
            ip0 = ip
            goto 100
         endif
      enddo
      ip0 = np
 100  continue
      if(found) then
         np1 = 1
         resids(1:2,np1) = resids(1:2,ip0)
         do ip=ip0+1,np
            if(maxval(abs(resids(1:2,ip)-resids(1:2,np1))).gt.0) then
               ir1 = resids(1,ip)
               ir2 = resids(2,ip)
               call get_mon_name(ir1,mon1)
               if(mon1.ne.'DUM'.and.mon1.ne.'HOH') then
                  call get_mon_name(ir2,mon2)
                  if(mon2.ne.'DUM'.and.mon2.ne.'HOH') then
                     np1 = np1 + 1
                     resids(1:2,np1) = resids(1:2,ip)
                  endif
               endif
            endif
         enddo
      else
         np1 = 0
      endif
      call open_unform_file(iscr1,pairs_file,ierr)
      write(iscr1)np1
      do ip=1,np1
         write(iscr1)resids(1:2,ip)
      enddo
      close(iscr1)
      deallocate(resids)

      return
      end
c
      SUBROUTINE find_all_contacts(dlim,
     &     maxatom,n_atom,xyz_crd,occup,maxsym,nsym,rot,tr,cell,
     &     vdw_file_o,ierr)

      IMPLICIT NONE
C
C----This routine finds contact list using bricking technique which is similar
C----to hash table technique. First atoms extended so that to cover extended
C----asymmetric unit. Extension of asymmeric unit is equal to brick size.
C----After that list of atoms and pointers to atoms for each brick is assigned
C----Having this for each atom which is unique (in a sence that it is first
C----symmetry related atom which is entirely in asymmeteric unit) 27 neibouring
C----bricks are searched for possible contacts. Having find contact symmetries
C----are assigned symply by look up to the tabel R1^-1 * R2 (beacues symmetry
C----is group result of this operation should be member of the group). 
c----The results are written to vdw_file_o
C
C---- Inputs and outputs
      real dlim
      integer maxatom,n_atom
      real xyz_crd(3,maxatom),occup(maxatom)
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      character vdw_file_o*(*)
      integer ierr
c
c---  locals
      integer, allocatable :: n_sym_atoms(:)
      integer, allocatable :: first_atom(:)
      real,    allocatable :: xyzs(:,:)
      integer, allocatable :: symm_refer(:,:)
      integer, allocatable :: refer_to_atom(:)
      integer, allocatable :: atoms_in_this_brick(:,:,:) 
      integer, allocatable :: atoms_in_brick(:,:,:,:)
      integer, allocatable :: nvdw_pairs(:,:)
      integer, allocatable :: nvdw_symm(:,:)
      integer, allocatable :: index_v(:)
c
      integer ir,k,nr,nr_all,i1,i2
      integer, allocatable :: ia1_l(:,:)
      integer, allocatable :: vsymm_l(:,:)
c
      integer i,ia_refer,ia_box,ll,iscrv,ifail,it,isym1,isym2,isym3
      integer first,imodx,imody,imodz,isym_cur,itx_cur(3)
      real d,dx,d1_cut2,dxy,dsq,xyzs_transx,xyzs_transy,xyzs_transz,t
      integer ia,nmax_in_brick,nxyzs
      integer ix,iy,iz,ix_this,iy_this,iz_this,is,i_add
      integer ixmin,ixmax,iymin,iymax,izmin,izmax
      integer maxvdw,nvdw,xyz_size
      integer nvdw_t,nvdw_o,nvdw_s(4)
      integer n_first_atom
      integer iiden0
      integer nbricks(3),itx1(3),symm_loc(4)
      integer nmfour,ipxyz(3)
      real cell_asym(3),cell_asym_min(3),cell_asym_max(3)
      real cell_asym_min_frac(3),cell_asym_max_frac(3)
      real frac_xyz(3),dvdw2_frac(3)
      real d_bricks(3),d_bricks_frac(3),d_bricks_out(3)
      real ext_asym_min(3),ext_asym_max(3),ext_mn(3),ext_mx(3)
      real xyz_frac(3),xyz_frac1(3),xyz_frac2(3),xyzs_cell(3)
      real d_vdw2_frac(3)
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      integer icount
      LOGICAL ERROR
      REAL SMALL_EPS,ONE
      DATA ONE/1.0/,SMALL_EPS/1.0E-6/
C
c---  body
      ierr = 0
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     & cs_frac_to_ort,cs_ort_to_frac,ierr)
C
c---Find sizes
      call find_vdw_sizes(dlim,maxatom,n_atom,xyz_crd,occup,
     &     maxsym,nsym,rot,tr,cell,xyz_size,nmax_in_brick,ierr)
      if(ierr.gt.0) then
         write(*,*)'Error in find_all_contacts'
         return
      endif
c
c---find nbricks et al
      d_bricks(1:3) = dlim
      CALL ASYLIM_r(maxsym,nsym,rot,tr,IPXYZ(1),IPXYZ(2),IPXYZ(3),
     &     NMFOUR)
      call brick_limits(d_bricks,cell,d_bricks_out)

      cell_asym(1:3) = cell(1:3)/ipxyz(1:3)
      nbricks(1:3) = int(cell_asym(1:3)/d_bricks_out(1:3))+5
c
      allocate(first_atom(n_atom))
      allocate(n_sym_atoms(n_atom))
      allocate(xyzs(3,xyz_size))
      allocate(symm_refer(4,xyz_size))
      allocate(refer_to_atom(xyz_size))
c
      NXYZS = 0
      CELL_ASYM_MIN(1:3) = 0.0
      CELL_ASYM_MAX(1:3) = CELL(1:3)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(1:3))
      CELL_ASYM_MIN_FRAC(1:3) = CELL_ASYM_MIN(1:3)/CELL(1:3)
      CELL_ASYM_MAX_FRAC(1:3) = CELL_ASYM_MAX(1:3)/CELL(1:3)
c
      CALL GET_ORT2FRAC_COEFS(CELL,FRAC_XYZ)
      D_VDW2_FRAC(1:3)  = dlim*FRAC_XYZ(1:3)/CELL(1:3)
      EXT_ASYM_MAX(1:3) = CELL_ASYM_MAX_FRAC(1:3) + D_VDW2_FRAC(1:3)
      EXT_ASYM_MIN(1:3) = CELL_ASYM_MIN_FRAC(1:3) - D_VDW2_FRAC(1:3)
      ext_mn(1:3) = 1.0/float(ipxyz(1:3)) - d_vdw2_frac(1:3)
      ext_mx(1:3) = 1.0/float(ipxyz(1:3)) + d_vdw2_frac(1:3)
      ext_mn(1:3) = ext_asym_min(1:3)
      ext_mx(1:3) = ext_asym_max(1:3)

      DO    IA=1,N_ATOM
         if(occup(ia).gt.0.001) then
         N_SYM_ATOMS(IA) = 0
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC1,ERROR)
C
C---  Now find all symmetry related atoms which are inside the extended 
c---  asymmetric unit
         DO    IS=1,nsym
            call mat2vec(3,3,rot(1:3,1:3,is),xyz_frac1,xyz_frac2,error)
            xyz_frac(1:3) = xyz_frac2(1:3) + tr(1:3,is)
C
C---Find translation by which this atom comes to asymmetic unit          
            CALL AMOD_R(XYZ_FRAC(1),ONE,IMODX,XYZS_CELL(1))
            CALL AMOD_R(XYZ_FRAC(2),ONE,IMODY,XYZS_CELL(2))
            CALL AMOD_R(XYZ_FRAC(3),ONE,IMODZ,XYZS_CELL(3))
            DO    IZ = -1,1
               XYZS_TRANSZ = XYZS_CELL(3) + FLOAT(IZ)
               IF(XYZS_TRANSZ.LE.EXT_ASYM_MAX(3).AND.
     +              XYZS_TRANSZ.GE.EXT_ASYM_MIN(3)) THEN
                  DO   IY = -1,1
                     XYZS_TRANSY = XYZS_CELL(2) + FLOAT(IY)
                     IF(XYZS_TRANSY.LE.EXT_ASYM_MAX(2).AND.
     +                    XYZS_TRANSY.GE.EXT_ASYM_MIN(2)) THEN
                        DO    IX=-1,1
                           XYZS_TRANSX = XYZS_CELL(1) + FLOAT(IX)
                           IF(XYZS_TRANSX.LE.EXT_ASYM_MAX(1).AND.
     +                          XYZS_TRANSX.GE.EXT_ASYM_MIN(1)) THEN
C
C----Add this position to list of atoms in asymmetric unit. Make sure to 
C----remember reference to symmetry. Increase number of symmetry related atomns
C----for this particular atom.
                              N_SYM_ATOMS(IA) = N_SYM_ATOMS(IA) + 1
                              NXYZS           = NXYZS + 1
                              XYZS(1,NXYZS)   = XYZS_TRANSX
                              XYZS(2,NXYZS)   = XYZS_TRANSY
                              XYZS(3,NXYZS)   = XYZS_TRANSZ
                              SYMM_REFER(1,NXYZS)  = IS
                              SYMM_REFER(2,NXYZS)  = -IMODX + IX
                              SYMM_REFER(3,NXYZS)  = -IMODY + IY
                              SYMM_REFER(4,NXYZS)  = -IMODZ + IZ
                              REFER_TO_ATOM(NXYZS) = IA
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
         ENDDO
c
c---Find first atom inside entirely in asymmetric unit and remember its address
         FIRST_ATOM(IA) = 0
         DO    IS = 1,N_SYM_ATOMS(IA)
            I_ADD = NXYZS - IS + 1   
            IF(XYZS(1,I_ADD).LE.CELL_ASYM_MAX_FRAC(1).AND.
     &           XYZS(1,I_ADD).GE.CELL_ASYM_MIN_FRAC(1).AND.
     &           XYZS(2,I_ADD).LE.CELL_ASYM_MAX_FRAC(2).AND.
     &           XYZS(2,I_ADD).GE.CELL_ASYM_MIN_FRAC(2).AND.
     &           XYZS(3,I_ADD).LE.CELL_ASYM_MAX_FRAC(3).AND.
     &           XYZS(3,I_ADD).GE.CELL_ASYM_MIN_FRAC(3)) THEN
C
c---This atom is entirely in "asymmetric unit"
C---Promote this atom to the first in the list of symmetry related atoms for this 
C---particular atom
               N_FIRST_ATOM = NXYZS - N_SYM_ATOMS(IA) + 1
               DO   I=1,3
                  T                          = XYZS(I,I_ADD)
                  XYZS(I,I_ADD)              = XYZS(I,N_FIRST_ATOM)  
                  XYZS(I,N_FIRST_ATOM)       = T
                  IT                         = SYMM_REFER(I,I_ADD)
                  SYMM_REFER(I,I_ADD)      = SYMM_REFER(I,N_FIRST_ATOM)
                  SYMM_REFER(I,N_FIRST_ATOM) = IT
               ENDDO
               IT                         = SYMM_REFER(4,I_ADD)
               SYMM_REFER(4,I_ADD)    = SYMM_REFER(4,N_FIRST_ATOM)
               SYMM_REFER(4,N_FIRST_ATOM) = IT
               FIRST_ATOM(IA)             = N_FIRST_ATOM
               GOTO 100
            ENDIF
         ENDDO
 100     CONTINUE
         endif
      ENDDO
C     
C---  Now we have list of symmetry related atoms and references to first atoms
C---  in "asymmetric unit". Create net. I.e. For each box find references to the
C---  atoms in asymmetric unit
      d_bricks_frac(1:3) = d_bricks_out(1:3)/cell(1:3)
c
c---
      allocate(atoms_in_this_brick(nbricks(1),nbricks(2),nbricks(3)))
      allocate(atoms_in_brick(nmax_in_brick,
     &     nbricks(1),nbricks(2),nbricks(3)))
      CALL CREATE_NET(NXYZS,XYZS,NBRICKs(1),NBRICKs(2),
     +     NBRICKs(3),NMAX_in_BRICK,ATOMS_IN_THIS_BRICK,
     +     ATOMS_IN_BRICK,ext_mn,D_BRICKS_FRAC)
C
C---  Convert all atoms to orthogonal coordinates
      DO   IA=1,NXYZS
         CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZS(1:3,IA),xyz_frac,ERROR)
         xyzs(1:3,ia) = xyz_frac(1:3)
      ENDDO
c
c---   Open the output file
      call open_unform_file(iscrv,vdw_file_o,ifail)
C     
C---  Loop over first atoms in the asymmetric unit
      D1_CUT2 = dlim**2
      first = 0
      nvdw = 0
      icount = 0
      allocate(ia1_l(2,500))
      allocate(vsymm_l(4,500))
      ir = 0
      DO   IA=1,N_ATOM
         if(occup(ia).gt.0.001) then
            N_FIRST_ATOM = FIRST_ATOM(IA)
            IF(N_FIRST_ATOM.LE.0) THEN
               write(*,*)IA,XYZ_CRD(1,IA),XYZ_CRD(2,IA),XYZ_CRD(3,IA)
               write(*,*)'Disaster with machine precision.'
               write(*,*)'Disaster, Disaster!!!!!'
               stop
            endif
            CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZS(1,N_FIRST_ATOM),
     +           XYZ_FRAC,ERROR)
C     
C---  Find  brick where this atom belongs
            IX_THIS = 
     +           INT((XYZ_FRAC(1)-ext_mn(1))/D_BRICKS_FRAC(1))+1
            IY_THIS = 
     +           INT((XYZ_FRAC(2)-ext_mn(2))/D_BRICKS_FRAC(2))+1
            IZ_THIS = 
     +           INT((XYZ_FRAC(3)-ext_mn(3))/D_BRICKS_FRAC(3))+1
C     
C---  loop over 27 bricks
            ixmin = max(2,ix_this)
            ixmax = min(nbricks(1)-1,ix_this)
            iymin = max(2,iy_this)
            iymax = min(nbricks(2)-1,iy_this)
            izmin = max(2,iz_this)
            izmax = min(nbricks(3)-1,iz_this)
            DO   IX=ixmin-1,ixmax+1
               DO   IY=iymin-1,iymax+1
                  DO   IZ=izmin-1,izmax+1
C
C---  loop over atoms in this box
                     DO    IA_BOX=1,ATOMS_IN_THIS_BRICK(IX,IY,IZ)
C     
c---  Take address of atom in the brick
                        I_ADD = ATOMS_IN_BRICK(IA_BOX,IX,IY,IZ)
                        IA_REFER = REFER_TO_ATOM(I_ADD)
                        IF(IA_REFER.GE.IA.AND.
     +                       I_ADD.NE.N_FIRST_ATOM) THEN
C     
C---  Check this atom
                           DX = (XYZS(1,I_ADD)-XYZS(1,N_FIRST_ATOM))**2
                           IF(DX.LE.D1_CUT2) THEN
                              d = xyzs(2,i_add)-xyzs(2,n_first_atom)
                              DXY = DX + d**2
                              IF(DXY.LE.D1_CUT2) THEN
                                 d = xyzs(3,i_add)-xyzs(3,n_first_atom)
                                 DSQ = DXY + d**2
                                 icount = icount + 1
                                 IF(DSQ.LE.D1_CUT2) THEN         
                                    NVDW = NVDW + 1
                                    NVDW_T = IA
                                    NVDW_O = REFER_TO_ATOM(I_ADD)
                                    ISYM1 = SYMM_REFER(1,N_FIRST_ATOM)
                                    ISYM2 = SYMM_REFER(1,I_ADD)
                                    DO    IS=1,3
                                      ITX1(IS) = SYMM_REFER(IS+1,I_ADD)-
     +                                     SYMM_REFER(IS+1,N_FIRST_ATOM)
                                    ENDDO
                                    CALL SYM_FIND_r(MAXSYM,nsym,
     +                                   rot,tr,ISYM1,ISYM2,ITX1,
     +                                   ISYM_CUR,ITX_CUR,FIRST)
                                    NVDW_S(1) = ISYM_CUR
                                    NVDW_S(2:4) = ITX_CUR(1:3)
                                    ir = ir + 1
                                    ia1_l(1,ir) = nvdw_t
                                    ia1_l(2,ir) = nvdw_o
                                    vsymm_l(1:4,ir) = nvdw_s(1:4)
                                    if(ir.ge.500) then
                                       write(iscrv)ir
                                       write(iscrv)(ia1_l(1:2,k),
     &                                      vsymm_l(1:4,k),k=1,ir)
                                       ir = 0
                                    endif
c                                    write(iscrv)
c     &                                   nvdw_t,nvdw_o,nvdw_s(1:4)
                                 ENDIF
                              ENDIF
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDDO
               ENDDO
            ENDDO
         endif
      ENDDO
      if(ir.gt.0) then
         write(iscrv)ir
         write(iscrv)(ia1_l(1:2,k),
     &        vsymm_l(1:4,k),k=1,ir)
         ir = 0
      endif
      deallocate(ia1_l)
      deallocate(vsymm_l)
c
c---  deallocate
      deallocate(n_sym_atoms)
      deallocate(first_atom)
      deallocate(xyzs)
      deallocate(symm_refer)
      deallocate(refer_to_atom)
      deallocate(atoms_in_this_brick)
      deallocate(atoms_in_brick)
c
c---  write the results to the output file: vdw_file_o.
      allocate(nvdw_pairs(2,nvdw))
      allocate(nvdw_symm(4,nvdw))
      rewind(iscrv)
      iiden0 = 1
      
      nr_all = 0
      i1 = 0
      i2 = 0
      do while(nr_all.lt.nvdw)
         read(iscrv)nr
         if(nr.le.0) cycle
         nr_all = nr_all + nr
         i1 = i2 + 1
         i2 = i2 + nr
         read(iscrv)(nvdw_pairs(1:2,i),nvdw_symm(1:4,i),i=i1,i2)
         do i=i1,i2
            if(nvdw_pairs(1,i).gt.nvdw_pairs(2,i)) then
               it = nvdw_pairs(1,i)
               nvdw_pairs(1,i) = nvdw_pairs(2,i)
               nvdw_pairs(2,i) = it
               itx1 = nvdw_symm(2:4,i)
               call symm_inv_r(maxsym,nsym,
     &              rot,tr,nvdw_symm(1:4,i),symm_loc(1:4),first,ierr)
               nvdw_symm(1:4,i) = symm_loc(1:4)
            endif
         enddo
      enddo
      allocate(index_v(nvdw))
      do  i=1,nvdw
         index_v(i) = i
      enddo
      call iheap_sort_r(nvdw,2,nvdw_pairs,index_v)
      rewind(iscrv)
      write(iscrv)nvdw,dlim
      allocate(ia1_l(2,500))
      allocate(vsymm_l(4,500))
      ir = 0
      do i=1,nvdw
         ir = ir + 1
         ia1_l(1:2,ir) = nvdw_pairs(1:2,i)
         vsymm_l(1:4,ir) = nvdw_symm(1:4,index_v(i))
         if(ir.ge.500) then
            write(iscrv)ir
            write(iscrv)(ia1_l(1:2,k),vsymm_l(1:4,k),k=1,ir)
            ir = 0
         endif
c         write(iscrv)nvdw_pairs(1:2,i),nvdw_symm(1:4,index_v(i))
      enddo
      if(ir.gt.0) then
         write(iscrv)ir
         write(Iscrv)(ia1_l(1:2,k),vsymm_l(1:4,k),k=1,ir)
         ir = 0
      endif
      deallocate(ia1_l)
      deallocate(vsymm_l)

      close(iscrv)
      deallocate(index_v)
      deallocate(nvdw_pairs)
      deallocate(nvdw_symm)
c
      RETURN
      END
C
      SUBROUTINE CREATE_NET(NXYZS,XYZS,NX,NY,NZ,
     +                     N_MAX_IN_BRICK,ATOMS_IN_THIS,ATOMS_IN_BRICKS,
     +                     BOX_MIN,D_BRICKS)
      IMPLICIT NONE
C
c---This routine creates net. I.e. for each brick list of atoms belonging
C---to this brick is stored. Make sure that large box contains all atoms.
C---
      INTEGER NXYZS,NX,NY,NZ,N_MAX_IN_BRICK
      integer ATOMS_IN_THIS(NX,NY,NZ)
      integer ATOMS_IN_BRICKS(N_MAX_IN_BRICK,NX,NY,NZ)
      REAL    XYZS(3,nxyzs),BOX_MIN(3),D_BRICKS(3)
C
C---  Local variables
      INTEGER IX,IY,IZ,IA
C
c---  body
      atoms_in_this(1:nx,1:ny,1:nz) = 0
      atoms_in_bricks(1:n_max_in_brick,1:nx,1:ny,1:nz)=0
      DO   IA=1,NXYZS
        IX = INT((XYZS(1,IA)-BOX_MIN(1))/D_BRICKS(1)) + 1
        IY = INT((XYZS(2,IA)-BOX_MIN(2))/D_BRICKS(2)) + 1
        IZ = INT((XYZS(3,IA)-BOX_MIN(3))/D_BRICKS(3)) + 1
        ix = max(1,min(nx,ix))
        iy = max(1,min(ny,iy))
        iz = max(1,min(nz,iz))
        ATOMS_IN_THIS(IX,IY,IZ) = ATOMS_IN_THIS(IX,IY,IZ) + 1
        ATOMS_IN_BRICKS(ATOMS_IN_THIS(IX,IY,IZ),IX,IY,IZ) = IA
      ENDDO
      RETURN
      END
c
      SUBROUTINE find_vdw_sizes(dlim,
     &     maxatom,n_atom,xyz_crd,occup,maxsym,nsym,rot,tr,cell,
     &     xyz_size,nmax_in_brick,ierr)

      IMPLICIT NONE
C
C----This routine finds contact list using bricking technique which is similar
C----to hash table technique. First atoms extended so that to cover extended
C----asymmetric unit. Extension of asymmeric unit is equal to brick size.
C----After that list of atoms and pointers to atoms for each brick is assigned
C----Having this for each atom which is unique (in a sence that it is first
C----symmetry related atom which is entirely in asymmeteric unit) 27 neibouring
C----bricks are searched for possible contacts. Having find contact symmetries
C----are assigned symply by look up to the tabel R1^-1 * R2 (beacues symmetry
C----is group result of this operation should be member of the group). 
c----The results are written to vdw_file_o
C
C---- Inputs and outputs
      real dlim
      integer maxatom,n_atom
      real xyz_crd(3,maxatom),occup(maxatom)
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      integer xyz_size,nmax_in_brick
      integer ierr
c
c---  locals
      integer, allocatable :: n_sym_atoms(:)
      integer, allocatable :: first_atom(:)
      real   , allocatable :: xyzs(:,:)
      integer, allocatable :: symm_refer(:,:)
      integer, allocatable :: refer_to_atom(:)
      integer, allocatable :: atoms_in_this_brick(:,:,:) 
      integer, allocatable :: atoms_in_brick(:,:,:,:)
      integer, allocatable :: nvdw_target(:)
      integer, allocatable :: nvdw_object(:)
      integer, allocatable :: nvdw_symm(:,:)

      integer i,ia_refer,ia_box,ll,iscrv,ifail,it,isym1,isym2,isym3
      integer first,imodx,imody,imodz,isym_cur,itx_cur(3)
      real d,dx,d1_cut2,dxy,dsq,xyzs_transx,xyzs_transy,xyzs_transz,t
      integer ia,nxyzs
      integer ix,iy,iz,ix_this,iy_this,iz_this,is,i_add
      integer maxvdw,nvdw
      integer nvdw_t,nvdw_o,nvdw_s(4)
      integer n_first_atom
      integer nbricks(3),itx1(3)
      integer nmfour,ipxyz(3)
      real cell_asym(3),cell_asym_min(3),cell_asym_max(3)
      real cell_asym_min_frac(3),cell_asym_max_frac(3)
      real frac_xyz(3),dvdw2_frac(3)
      real d_bricks(3),d_bricks_frac(3),d_bricks_out(3)
      real ext_asym_min(3),ext_asym_max(3)
      real xyz_frac(3),xyz_frac1(3),xyz_frac2(3),xyzs_cell(3)
      real d_vdw2_frac(3)
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      LOGICAL ERROR
      REAL SMALL_EPS,ONE
      DATA ONE/1.0/,SMALL_EPS/1.0E-6/
C
c---  body
      ierr = 0
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     & cs_frac_to_ort,cs_ort_to_frac,ierr)
C
c---Find sizes
      if(ierr.gt.0) then
         write(*,*)'Error in find_all_contacts'
         return
      endif
c
c---find nbricks et al
      d_bricks(1:3) = dlim
      CALL ASYLIM_r(maxsym,nsym,rot,tr,IPXYZ(1),IPXYZ(2),IPXYZ(3),
     &     NMFOUR)
      call brick_limits(d_bricks,cell,d_bricks_out)
      cell_asym(1:3) = cell(1:3)/ipxyz(1:3)
      nbricks(1:3) = int(cell_asym(1:3)/d_bricks_out(1:3))+5
c
      call GET_XYZS_NUMBER(dlim,maxatom,n_atom,xyz_crd,occup,
     &     maxsym,nsym,rot,tr,cell,XYZ_SIZE)
      allocate(xyzs(3,xyz_size))
c
      NXYZS = 0
      CELL_ASYM_MIN(1:3) = 0.0
      CELL_ASYM_MAX(1:3) = CELL(1:3)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(1:3))
      CELL_ASYM_MIN_FRAC(1:3) = CELL_ASYM_MIN(1:3)/CELL(1:3)
      CELL_ASYM_MAX_FRAC(1:3) = CELL_ASYM_MAX(1:3)/CELL(1:3)
c
      CALL GET_ORT2FRAC_COEFS(CELL,FRAC_XYZ)
      D_VDW2_FRAC(1:3) = dlim*FRAC_XYZ(1:3)/CELL(1:3)
      EXT_ASYM_MAX(1:3) = CELL_ASYM_MAX_FRAC(1:3) + D_VDW2_FRAC(1:3)
      EXT_ASYM_MIN(1:3) = CELL_ASYM_MIN_FRAC(1:3) - D_VDW2_FRAC(1:3)
      DO    IA=1,N_ATOM
         if(occup(ia).gt.0.001) then
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC1,ERROR)
C
C---Now find all symmetry related atoms which are inside extended asymmetric 
C----unit
         DO    IS=1,nsym
            call mat2vec(3,3,rot(1:3,1:3,is),xyz_frac1,xyz_frac2,error)
            xyz_frac(1:3) = xyz_frac2(1:3) + tr(1:3,is)
C
C---Find translation by which this atom comes to asymmetic unit          
            CALL AMOD_R(XYZ_FRAC(1),ONE,IMODX,XYZS_CELL(1))
            CALL AMOD_R(XYZ_FRAC(2),ONE,IMODY,XYZS_CELL(2))
            CALL AMOD_R(XYZ_FRAC(3),ONE,IMODZ,XYZS_CELL(3))
            DO    IZ = -1,1
               XYZS_TRANSZ = XYZS_CELL(3) + FLOAT(IZ)
               IF(XYZS_TRANSZ.LE.EXT_ASYM_MAX(3).AND.
     +              XYZS_TRANSZ.GE.EXT_ASYM_MIN(3)) THEN
                  DO   IY = -1,1
                     XYZS_TRANSY = XYZS_CELL(2) + FLOAT(IY)
                     IF(XYZS_TRANSY.LE.EXT_ASYM_MAX(2).AND.
     +                    XYZS_TRANSY.GE.EXT_ASYM_MIN(2)) THEN
                        DO    IX=-1,1
                           XYZS_TRANSX = XYZS_CELL(1) + FLOAT(IX)
                           IF(XYZS_TRANSX.LE.EXT_ASYM_MAX(1).AND.
     +                          XYZS_TRANSX.GE.EXT_ASYM_MIN(1)) THEN
C
C----Add this position to list of atoms in asymmetric unit. Make sure to 
C----remember reference to symmetry. Increase number of symmetry related atomns
C----for this particular atom.
                              NXYZS           = NXYZS + 1
                              XYZS(1,NXYZS)   = XYZS_TRANSX
                              XYZS(2,NXYZS)   = XYZS_TRANSY
                              XYZS(3,NXYZS)   = XYZS_TRANSZ
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
         ENDDO
         endif
      ENDDO
C     
C---  Now we have list of symmetry related atoms and references to first atoms
C---  in "asymmetric unit". Create net. I.e. For each box find references to the
C---  atoms in asymmetric unit
      d_bricks_frac(1:3) = d_bricks_out(1:3)/cell(1:3)
c
c---
      allocate(atoms_in_this_brick(nbricks(1),nbricks(2),nbricks(3)))
      CALL CREATE_NET_size(NXYZS,XYZS,NBRICKs(1),NBRICKs(2),
     +     NBRICKs(3),NMAX_in_BRICK,ATOMS_IN_THIS_BRICK,
     +     EXT_ASYM_MIN,D_BRICKS_FRAC)
c
c---  deallocate
      deallocate(xyzs)
      deallocate(atoms_in_this_brick)
c
      RETURN
      END
C
      SUBROUTINE CREATE_NET_size(NXYZS,XYZS,NX,NY,NZ,
     +                     N_MAX_IN_BRICK,ATOMS_IN_THIS,
     +                     BOX_MIN,D_BRICKS)
      IMPLICIT NONE
C
c---This routine creates net. I.e. for each brick list of atoms belonging
C---to this brick is stored. Make sure that large box contains all atoms.
C---
      INTEGER NXYZS,NX,NY,NZ,N_MAX_IN_BRICK
      integer ATOMS_IN_THIS(NX,NY,NZ)
      REAL    XYZS(3,nxyzs),BOX_MIN(3),D_BRICKS(3)
C
C---  Local variables
      INTEGER IX,IY,IZ,IA
C
c---  body
      atoms_in_this(1:nx,1:ny,1:nz) = 0
      DO   IA=1,NXYZS
        IX = INT((XYZS(1,IA)-BOX_MIN(1))/D_BRICKS(1)) + 1
        IY = INT((XYZS(2,IA)-BOX_MIN(2))/D_BRICKS(2)) + 1
        IZ = INT((XYZS(3,IA)-BOX_MIN(3))/D_BRICKS(3)) + 1
        ix = max(1,min(nx,ix))
        iy = max(1,min(ny,iy))
        iz = max(1,min(nz,iz))
        ATOMS_IN_THIS(IX,IY,IZ) = ATOMS_IN_THIS(IX,IY,IZ) + 1
      ENDDO
      n_max_in_brick = maxval(atoms_in_this)
      RETURN
      END
c
      SUBROUTINE GET_XYZS_NUMBER(dlim,maxatom,n_atom,xyz_crd,occup,
     &     maxsym,nsym,rot,tr,cell,XYZ_SIZE)
      IMPLICIT NONE
c
c---inputs and outputs
      real dlim
      integer maxatom,n_atom
      real xyz_crd(3,maxatom),occup(maxatom)
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      integer xyz_size
c
c---  locals
      integer ierr
      real cs_ort_to_frac(3,3),cs_frac_to_ort(3,3)
      REAL D_BRICKS(3)
      INTEGER IPXYZ(3)
      INTEGER NMFOUR,I,IA,IMODX,IMODY,IMODZ,IX,IY,IZ,IS,NXYZS
      REAL CELL_ASYM_MIN(3),CELL_ASYM_MAX(3),EXT_ASYM_MAX(3)
      real xyz_frac(3),XYZ_FRAC1(3),XYZ_FRAC2(3),XYZS_CELL(3)
      real EXT_ASYM_MIN(3)
      real CELL_ASYM_MIN_FRAC(3),CELL_ASYM_MAX_FRAC(3),FRAC_XYZ(3)
      real D_VDW2_FRAC(3)
      REAL ONE,XYZS_TRANSX,XYZS_TRANSY,XYZS_TRANSZ,D_VDW2,DVDW_MAX
      REAL DVDW_MAX2
      REAL SMALL_EPS
      LOGICAL ERROR
      DATA ONE/1.0/,SMALL_EPS/1.0E-6/
C
c---  body
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     & cs_frac_to_ort,cs_ort_to_frac,ierr)
      NXYZS = 0
      CALL ASYLIM_r(maxsym,nsym,rot,tr,
     &     IPXYZ(1),IPXYZ(2),IPXYZ(3),NMFOUR)

      CELL_ASYM_MIN(1:3) = 0.0
      CELL_ASYM_MAX(1:3) = CELL(1:3)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(1:3))
      CELL_ASYM_MIN_FRAC(1:3) = CELL_ASYM_MIN(1:3)/CELL(1:3)
      CELL_ASYM_MAX_FRAC(1:3) = CELL_ASYM_MAX(1:3)/CELL(1:3)
      CALL GET_ORT2FRAC_COEFS(CELL,FRAC_XYZ)
      D_VDW2_FRAC(1:3)  = dlim*FRAC_XYZ(1:3)/CELL(1:3)
      EXT_ASYM_MAX(1:3) = CELL_ASYM_MAX_FRAC(1:3) + D_VDW2_FRAC(1:3)
      EXT_ASYM_MIN(1:3) = CELL_ASYM_MIN_FRAC(1:3) - D_VDW2_FRAC(1:3)
      DO    IA=1,N_ATOM
         if(occup(ia).gt.0.001) then
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC1,ERROR)
C     
C---  Now find all symmetry related atoms which are inside extended asymmetric 
C---- unit
         DO    IS=1,nsym
            call mat2vec(3,3,rot(1:3,1:3,is),xyz_frac1,xyz_frac2,error)
            xyz_frac(1:3) = xyz_frac2(1:3)+tr(1:3,is)
C     
C---  Find translation by which this atom comes to asymmetic unit            
            CALL AMOD_R(XYZ_FRAC(1),ONE,IMODX,XYZS_CELL(1))
            CALL AMOD_R(XYZ_FRAC(2),ONE,IMODY,XYZS_CELL(2))
            CALL AMOD_R(XYZ_FRAC(3),ONE,IMODZ,XYZS_CELL(3))
            DO    IZ = -1,1
               XYZS_TRANSZ = XYZS_CELL(3) + FLOAT(IZ)
               IF(XYZS_TRANSZ.LE.EXT_ASYM_MAX(3).AND.
     +              XYZS_TRANSZ.GE.EXT_ASYM_MIN(3)) THEN
                  DO   IY = -1,1
                     XYZS_TRANSY = XYZS_CELL(2) + FLOAT(IY)
                     IF(XYZS_TRANSY.LE.EXT_ASYM_MAX(2).AND.
     +                    XYZS_TRANSY.GE.EXT_ASYM_MIN(2)) THEN
                        DO    IX=-1,1
                           XYZS_TRANSX = XYZS_CELL(1) + FLOAT(IX)
                           IF(XYZS_TRANSX.LE.EXT_ASYM_MAX(1).AND.
     +                          XYZS_TRANSX.GE.EXT_ASYM_MIN(1)) THEN
                              NXYZS           = NXYZS + 1
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
         ENDDO
         endif
      ENDDO
      XYZ_SIZE = NXYZS
      RETURN
      END
c
      SUBROUTINE BRICK_LIMITS(D_BRICK,CELL,D_BRICK_OUT)
      IMPLICIT NONE
C
C---  Finds brick limits for a given space group, if cell 
C---  dimensions have been specified. 

C
C---  Real arrays
      REAL CELL(6),D_BRICK(3),D_BRICK_OUT(6)
C
c---  Real local arrays
      REAL ALPHA,BETA,GAMMA,COSA,SINA,COSB,SINB,COSG,SING,
     +     VOLUME
c
c---  body
C     
C---  Cell dimensions are assumed to be in radians
      ALPHA = CELL(4)
      BETA  = CELL(5)
      GAMMA = CELL(6)
      COSA  = COS(ALPHA)
      SINA  = SIN(ALPHA)
      COSB  = COS(BETA)
      SINB  = SIN(BETA)
      COSG  = COS(GAMMA)
      SING  = SIN(GAMMA)
      VOLUME = SQRT(1.-COSA*COSA-COSB*COSB-COSG*COSG+2*COSA*COSB*COSG)
C
C----Output brick size
      D_BRICK_OUT(1) = D_BRICK(1)*SINA/VOLUME
      D_BRICK_OUT(2) = D_BRICK(2)*SINB/VOLUME
      D_BRICK_OUT(3) = D_BRICK(3)*SING/VOLUME
C
      RETURN
      END
c
      subroutine remove_bonds_flexible(nvdw,nvdw_out,vdw_pairs,
     &     vdw_symm,vdw_vidl,vdw_type,n_atom,nmaxrest,nbond,
     &     nrest_per_atom,rest_per_atom,rest_per_atom_symm,
     &     bond_pairs,bond_symm,maxnso,cs_nsym,cs_m_cs,cs_v_cs,
     &     dinc_torsion_n,dinc_torsion_c,dinc_torsion_o,
     &     dinc_torsion_all,vdw_sdi_torsion,vdw_rad,id_sf,
     &     maxnsf,cs_element,ierr)
      implicit none
c
c--- remove bonds, angles from the vdw list and treat torsion angles
c---  
      integer nvdw,nvdw_out
      integer vdw_pairs(2,nvdw)
      integer vdw_symm(4,nvdw)
      integer vdw_type(nvdw)
      real    vdw_vidl(3,nvdw)
c
      integer n_atom,nmaxrest,nbond
      integer nrest_per_atom(n_atom)
      integer rest_per_atom(nmaxrest,n_atom)
      integer rest_per_atom_symm(4,nmaxrest,n_atom)
      integer bond_pairs(2,nbond)
      integer bond_symm(4,nbond)
      integer id_sf(n_atom)
      real vdw_rad(n_atom)
      integer maxnsf
      character cs_element(maxnsf)*2
c
      real dinc_torsion_n,dinc_torsion_c,dinc_torsion_o
      real dinc_torsion_all,vdw_sdi_torsion
c
      integer maxnso,cs_nsym
      real cs_m_cs(3,3,maxnso),cs_v_cs(3,maxnso)

      integer ierr
c
c--   locals
      integer nbb,naa,ntt,ntt1,nvdw1
      integer iv,ib,id,ia1,ia2,ia3,ib1,ib2,iel1,iel2
      integer iv1(2),isym1(4),isym2(4),isym3(4),isym_o1(4),isym_o2(4)
      real dinc_curr1,dinc_curr2,dinc_current
c
c---  body
      integer first
c---  vdw is in the list of bonds remove it
      first  = 0
      nbb    = 0
      naa    = 0
      ntt    = 0
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(nrest_per_atom(iv1(1)).gt.0.and.
     &        nrest_per_atom(iv1(2)).gt.0) then
c
c---  Is it a bond
            do ib=1,nrest_per_atom(iv1(1))
               if(iv1(2).eq.rest_per_atom(ib,iv1(1))) then
                  isym1(1:4)=rest_per_atom_symm(1:4,ib,iv1(1))
                  id=maxval(abs(vdw_symm(1:4,iv)-isym1(1:4)))
                  if(id.eq.0) then
                     nbb = nbb + 1
                     vdw_symm(1,iv) = -1
                     goto 100
                  endif
               endif
            enddo
 100        continue
         endif
      enddo
      nvdw1 = 0
      do  iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1 = nvdw1 +1
            vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
            vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
            vdw_vidl(1:3,nvdw1)  = vdw_vidl(1:3,iv)
            vdw_type(nvdw1)      = vdw_type(iv)
         endif
      enddo
      nvdw = nvdw1
c
c---  Is it an angle
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(nrest_per_atom(iv1(1)).gt.0.and.
     &        nrest_per_atom(iv1(2)).gt.0) then
            do   ib=1,nrest_per_atom(iv1(1))
               ia1        = rest_per_atom(ib,iv1(1))
               if(nrest_per_atom(ia1).gt.1) then
                  isym1(1:4) = rest_per_atom_symm(1:4,ib,iv1(1))
                  do ib1=1,nrest_per_atom(ia1)
                     if(rest_per_atom(ib1,ia1).eq.iv1(2)) then
                        isym2(1:4) = rest_per_atom_symm(1:4,ib1,ia1)
                        call symm_mult_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,
     &                       isym1,isym2,isym3,first)
                        id=maxval(abs(vdw_symm(1:4,iv)-isym3(1:4)))
                        if(id.eq.0) then
                           naa = naa + 1
                           vdw_symm(1,iv) = -1
                           goto 200
                        endif
                     endif
                  enddo
               endif
            enddo
 200        continue
         endif
      enddo
      nvdw1 = 0
      do  iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1 = nvdw1 +1
            vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
            vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
            vdw_vidl(1:3,nvdw1)  = vdw_vidl(1:3,iv)
            vdw_type(nvdw1)      = vdw_type(iv)
         endif
      enddo
      nvdw = nvdw1
c
c---  Torsions
      ntt1 = 0
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(nrest_per_atom(iv1(1)).gt.0.and.
     &        nrest_per_atom(iv1(2)).gt.0) then
            do ib=1,nrest_per_atom(iv1(1))
               ia1 = rest_per_atom(ib,iv1(1))
               if(nrest_per_atom(ia1).gt.1) then
                  isym1(1:4) = rest_per_atom_symm(1:4,ib,iv1(1))
                  do  ib1=1,nrest_per_atom(ia1)
                     ia2=rest_per_atom(ib1,ia1)
                     if(nrest_per_atom(ia2).gt.1) then
                        isym2(1:4) = rest_per_atom_symm(1:4,ib1,ia1)
                        do ib2=1,nrest_per_atom(ia2)
                           ia3=rest_per_atom(ib2,ia2)
                           if(ia3.eq.iv1(2)) then
                              isym3(1:4)=rest_per_atom_symm(1:4,ib2,ia2)
                              call symm_mult_r(maxnso,cs_nsym,cs_m_cs,
     &                             cs_v_cs,
     &                             isym1,isym2,isym_o1,first)
                              call symm_mult_r(maxnso,cs_nsym,cs_m_cs,
     &                             cs_v_cs,
     &                             isym_o1,isym3,isym_o2,first)
                              id=maxval(abs(vdw_symm(1:4,iv)-
     &                             isym_o2(1:4)))
                              ntt1 = ntt1 + 1
                              if(id.eq.0) then
c
c---  Torsion angle related atoms
                                 iel1 = id_sf(iv1(1))
                                 iel2 = id_sf(iv1(2))
                                 if(cs_element(iel1).eq.'O   ') then
                                    dinc_curr1=dinc_torsion_o
                                 elseif(cs_element(iel1).eq.'N   ') then
                                    dinc_curr1=dinc_torsion_n
                                 elseif(cs_element(iel1).eq.'C   ') then
                                    dinc_curr1=dinc_torsion_c
                                 else
                                    dinc_curr1=dinc_torsion_all
                                 endif
                                 if(cs_element(iel2).eq.'O   ') then
                                    dinc_curr2=dinc_torsion_o
                                 elseif(cs_element(iel2).eq.'N   ') then
                                    dinc_curr2=dinc_torsion_n
                                 elseif(cs_element(iel2).eq.'C   ') then
                                    dinc_curr2=dinc_torsion_c
                                 else
                                    dinc_curr2=dinc_torsion_all
                                 endif
                                 dinc_current=dinc_curr1+dinc_curr2
                                 vdw_type(iv) = 2
                                 vdw_vidl(1,iv) = vdw_rad(iv1(1))+
     &                                vdw_rad(iv1(2))+dinc_current
                                 vdw_vidl(3,iv)=vdw_sdi_torsion
                                 vdw_vidl(2,iv)=vdw_vidl(1,iv)
                                 ntt = ntt + 1
                                 goto 300
                              endif
                           endif
                        enddo
                     endif
                  enddo
               endif               
            enddo
 300        continue
         endif
      enddo
c
      nvdw_out = nvdw1
c
      return
      end
c
      subroutine find_max_neighbours(maxrest,n_atom,nrest_per_atom,
     &     ndist,n_target,n_object)
      implicit none

      integer ndist
      integer n_target(*),n_object(*)
      integer maxrest,n_atom
      integer nrest_per_atom(n_atom)

c
      integer it,io,id
c
      nrest_per_atom(1:n_atom) = 0
      do id=1,ndist
         it = n_target(id)
         io = n_object(id)
         nrest_per_atom(it) = nrest_per_atom(it) + 1
         nrest_per_atom(io) = nrest_per_atom(io) + 1
      enddo

      maxrest = maxval(nrest_per_atom(1:n_atom))

      return
      end
c
      subroutine find_all_neighours(maxrest,n_atom,nrest_per_atom,
     &     rest_per_atom,symm_per_atom,ndist,n_target,n_object,
     &     ndist_symm,maxsym,nsym,RealSymmMatrx)
      implicit none

      integer ndist
      integer n_target(*),n_object(*),ndist_symm(4,*)
      integer maxrest,n_atom
      integer nrest_per_atom(n_atom)
      integer rest_per_atom(maxrest,n_atom)
      integer symm_per_atom(maxrest,4,n_atom)
c
      integer maxsym,nsym
      real RealSymmMatrx(4,4,maxsym)
c
      integer is1,is2,is_out,itx1(3),itx_out(3)
      integer symm1(4),symm2(4)
c
      integer it,io,id

      integer first
      data first/0/

      nrest_per_atom(1:n_atom) = 0
      do id=1,ndist
         it = n_target(id)
         io = n_object(id)
         nrest_per_atom(it) = nrest_per_atom(it) + 1
         nrest_per_atom(io) = nrest_per_atom(io) + 1
         rest_per_atom(nrest_per_atom(it),it) = io
         rest_per_atom(nrest_per_atom(io),io) = it
         symm2(1:4) = ndist_symm(1:4,id)

         is1 = ndist_symm(1,id)
         is2 = 1
         itx1(1:3) = -ndist_symm(2:4,id)
         call sym_find_r0(maxsym,nsym,RealSymmMatrx,is1,is2,itx1,
     &        is_out,itx_out,first)
         symm1(1) = is_out
         symm1(2:4) = itx_out(1:3)

         symm_per_atom(nrest_per_atom(it),1:4,it) = symm1(1:4)
         symm_per_atom(nrest_per_atom(io),1:4,io) = symm2(1:4)
      enddo

      return
      end
