module analyse_routines

  contains

    subroutine analyse_all_params()
      use analyse_all
      implicit none

      real, allocatable :: bval_aver(:,:)
      real, allocatable :: grad_x_aver(:,:)
      real, allocatable :: grad_b_aver(:,:)

      n_residue = size(i_resid(:))
      allocate(bval_aver(2,n_residue)

      do ir=1,n_residue
         ia1 = iratm_first(ir)
         ia2 = ia1 + natm_res(ir)-1
         nside = 0
         nmain = 0
         call side_or_main()
         do ia=ia1,ia2
            bval_aver(1,ir) = bval_aver(1,ir) + biso
            if(side_flag) then
               bval_aver(2,ir) = bval_aver(2,ir) + biso
               nside = nside + 1
            else
               bval_aver(3,ir) = bval_aver(3,ir) + biso
               nmain = nmain + 1
            endif
         enddo
         if(natm_res(ir).gt.0) then
            bval_aver(1,ir) = bval_aver(1,ir)/natm_res(ir)
         endif
         if(nside.gt.0) then
            bval_aver(2,ir) = bval_aver(2,ir)/nside
         endif
         if(nmain.gt.0) then
            bval_aver(3,ir) = bval_aver(3,ir)/nmain
         endif

      enddo

      return
    end subroutine analyse_all_params
  end module analyse_routines
      
