c
c---  These are refmac dependent routines to calculate contact list etc
c
      subroutine analyse_vdw(dmin_vdw)
      implicit none

      real dmin_vdw
      call find_all_contacts_refmac
      call find_vdw_contacts_refmac

      return
      end
c
      subroutine find_all_contacts_refmac
      use weights
      use ridge
      use local_tls
      use restr_files
      use ncs_rest
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'atom_com_str.fh'
c
c---  locals
      integer l,ia,ierr,iend,im
      real dlim
c
c---  body
      im = 1
      if(len_trim(all_contacts_file).le.0) then
         call find_unique_file_name(all_contacts_file,'_ALL_CONTACTS')
      endif
c
c---  remove it later
      vdw_file_0 = all_contacts_file
c     
c---  find dlim
      dlim = dvdw_cut_min
      do ia=1,n_atom_mod(im)
         dlim = max(dlim,vdw_rad(ia))
         dlim = max(dlim,ion_rad(ia))
      enddo
      dlim = 2.0*dlim
      if(sigma_dist_r.gt.0.0) dlim = max(dlim,dmax_dist_r)
      if(ncsr_flag) dlim = max(dlim,dmax_ncs_local)
      if(local_tls_pairs.eq.1) dlim = max(dlim,local_tls_dist)

c
      call find_all_contacts(dlim,
     &     maxatom,n_atom_mod(im),xyz_crd_mod(1,1,im),occup_mod(1,im),
     &     maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &     all_contacts_file,ierr)
      if(ierr.gt.0) then
         call errwrt(1,'Problem in find_all_contacts')
      endif
c
      return
      end
c
      subroutine find_vdw_contacts_refmac
      use weights
      use agreem
      use restr_files
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'atom_com_str.fh'
      include 'refi_flags.fh'
      include 'anom.fh'
      include 'occupancy_params.fh'
c
c---  This routine uses all_contacts file and bond, angle files
c---  to produce list of potential non-bonding contacts
      integer l,is
      integer iv1(2)
      integer nvdw,nvdw1,iv,iscrv,ierr
      integer itx(3)
      real     xtm(3),xtm1(3)
c
c---occupancy problems
      character at_full*24
      integer   ia,ia1,im
      real      dsq
      real      xyz1(3),xyz2(3),xyz3(3)
c
c---  allocatable arrays
      integer, allocatable :: n_mult(:)
      integer, allocatable :: vdw_pairs(:,:)
      integer, allocatable :: vdw_symm(:,:)
      real,    allocatable :: vdw_vidl(:,:)
      integer, allocatable :: vdw_type(:)
c
      integer nsize_chain,nsize_res,nres_pairs_exclude
      integer nchain_pairs_exclude,natoms_exclude,nsize_atoms
      integer natom_pairs_exclude
      character(len=1) ins1,ins2
      integer, allocatable :: atom_pairs_exclude(:,:)
      character(len=4), allocatable :: chains_exclude(:,:)
      character(len=4), allocatable :: residue_exclude_chain(:,:)
      integer, allocatable :: residue_exclude_res(:,:)
      character(len=1), allocatable :: residue_exclude_ins(:,:)
      integer, allocatable :: atoms_exclude(:)
c
      character chnamp1*4,chnamp2*4
      integer i,j,ir1,ir2,ipr1,ipr2

      integer nr,nr_all,ir
c
c---vdw bvalues write
      integer ivdw_w,i1,i2
      real u1,u2
      character vdw_file_external*512
c
c--   occupancies
      real oc1,oc2
c
      real      dlim_l
      real      dist_cur,over_tot
      logical   error
c
c---  body
      im = 1
      call open_unform_file(iscrv,all_contacts_file,ierr)
      if(ierr.gt.0) then
         call errwrt(1,'Problem in opening all_contacts_file')
      endif
c
      read(iscrv)nvdw,dlim_l
      allocate(vdw_pairs(2,nvdw))
      allocate(vdw_symm(4,nvdw))
      allocate(vdw_vidl(3,nvdw))
      allocate(vdw_type(nvdw))
      nr_all = 0
      i1=0
      i2=0
      do while(nr_all.lt.nvdw)
         read(iscrv)nr
         if(nr.le.0) cycle
         nr_all = nr_all + nr
         if(nr_all.gt.nvdw) then
            write(*,*)'Problem in find_contacts_refmac'
            call ccperr(1,'Problem with vdw')
         endif
         i1 = i2 + 1
         i2 = i2 + nr
         read(iscrv)(vdw_pairs(1:2,iv),vdw_symm(1:4,iv),iv=i1,i2)
      enddo
      close(iscrv)
c
c---analyse occupancies and if special positions then adjust them if necessary
      allocate(n_mult(n_atom_mod(im)))
      n_mult(1:n_atom_mod(im)) = 1
      do iv=1,nvdw
         if(vdw_pairs(1,iv).eq.vdw_pairs(2,iv)) then
            ia1 = vdw_pairs(1,iv)
            xyz1(1:3) = xyz_crd_mod(1:3,ia1,im)
            is = vdw_symm(1,iv)
            xyz2(1:3) = matmul(cs_ort_to_frac(1:3,1:3),xyz1(1:3))
            xyz3(1:3) = matmul(cs_m_cs(1:3,1:3,is),xyz2(1:3))+
     &           cs_v_cs(1:3,is) + float(vdw_symm(2:4,iv))
            xyz2(1:3) = matmul(cs_frac_to_ort(1:3,1:3),xyz3(1:3))
            dsq = sum((xyz2(1:3)-xyz1(1:3))**2)
            if(dsq.lt.0.25) n_mult(ia1) = n_mult(ia1) + 1
         endif
      enddo
      over_tot=0.
      do ia=1,n_atom_mod(im)
         over_tot = over_tot + max(1.,occup_mod(ia,im)*real(n_mult(ia)))
         if(n_mult(ia).gt.0.and.(ires_type(i_resid_mod(ia,im)).eq.1.or.
     &        ires_type(i_resid_mod(ia,im)).eq.9)) then
            if(occup_mod(ia,im)*real(n_mult(ia)).gt.1.00001) then
               call full_atom_name(ia,at_full,ierr)
               call errwrt(-1,'Atom ('//trim(at_full)//')"s total'
     &              //' occupancy (occ*multipl) > 1.0. Changing it')
               occup(ia) = 1.0/real(n_mult(ia))
               occup_mod(ia,1) = 1.0/real(n_mult(ia))
               if (.not.separate_anom_occ)  then
                  occup_anom(ia) = occup(ia)
                  occup_anom_mod(ia,1) = occup_mod(ia,1)
               endif
            endif
         endif
      enddo
      if (substruct_flag) then
        over_tot=over_tot/n_atom
        if (over_tot.gt.1.) scale_llh_over=scale_llh_over*over_tot
      endif
      deallocate(n_mult)
c
c---  Remove extra pairs
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         oc1 = 1.0
         if(corr_id(iv1(1)).gt.0) oc1 = occ_grp_value(corr_id(iv1(1)))
         oc2 = 1.0
         if(corr_id(iv1(2)).gt.0) oc2 = occ_grp_value(corr_id(iv1(2)))
         if(oc1.le.0.0) oc1 = 1.0
         if(oc2.le.0.0) oc2 = 1.0
         if(occup_mod(iv1(1),im)+occup_mod(iv1(2),im).le.1.00001) then
            if(corr_id(iv1(1)).le.0.or.corr_id(iv1(2)).le.0.or.
     &        corr_id(iv1(1)).ne.corr_id(iv1(2)).or.
     &           (corr_id(iv1(1)).eq.corr_id(iv1(2)).and.
     &           (id_alt_mod(iv1(1),im).ne.id_alt_mod(iv1(2),im).or.
     &           vdw_symm(1,iv).ne.1.and.
     &           sum(abs(vdw_symm(2:4,iv))).le.0).and.
     &           occup_mod(iv1(1),im)+
     &           occup_mod(iv1(2),im).le.1.00001*oc1)) then

               vdw_symm(1,iv) = -1
            endif
         endif
      enddo
c
c---  Condense vdw pairs
      nvdw1 = 0
      do  iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1                = nvdw1 + 1
            vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
            vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
            vdw_type(nvdw1)      = 1
         endif
      enddo
c
c---write vdw pairs with bvalues
      if(vdw_write_flag) then
         call getenv('BOUT',vdw_file_external)
         if(len_trim(vdw_file_external).le.0) vdw_file_external='BOUT'
         call open_form_file(ivdw_w,vdw_file_external,ierr)
         do i=1,nvdw1
            if(vdw_symm(1,i).eq.1.and.
     &           sum(abs(vdw_symm(2:4,i))).eq.0) then
               i1 = vdw_pairs(1,i)
               i2 = vdw_pairs(2,i)

               if(u_aniso(2,i1).eq.0) then
                  u1 = u_aniso(1,i1)
               else
                  u1 = sum(u_aniso(1:3,i1))/3
               endif
               if(u_aniso(2,i2).eq.0) then
                  u2 = u_aniso(1,i2)
               else
                  u2 = sum(u_aniso(1:3,i2))/3
               endif
               write(ivdw_w,*)xyz_crd(1:3,i1),u1,xyz_crd(1:3,i2),u2
            endif
         enddo
         call refmac_clean_up_files
         call ccperr(0,'End of Refmac')
      endif

      nvdw = nvdw1
c
c--Remove user defined exclusions
      if(vdwr_exclude_flag) then
         call exclude_vdw_size(nchain_pairs_exclude,nres_pairs_exclude,
     &        natoms_exclude,natom_pairs_exclude)
         if(nchain_pairs_exclude.le.0.and.nres_pairs_exclude.le.0.and.
     &        natoms_exclude.le.0) vdwr_exclude_flag = .FALSE.
         nsize_chain = max(nchain_pairs_exclude,1)
         allocate(chains_exclude(2,nsize_chain))
         nsize_res = max(nres_pairs_exclude,1)
         allocate(residue_exclude_res(2,nsize_res))
         allocate(residue_exclude_ins(2,nsize_res))
         allocate(residue_exclude_chain(2,nsize_res))
         nsize_atoms = max(natoms_exclude,1)
         allocate(atoms_exclude(nsize_atoms))
         if(natom_pairs_exclude.gt.0) then
            allocate(atom_pairs_exclude(2,natom_pairs_exclude))
         endif
         call exclude_vdw_read(nchain_pairs_exclude,nres_pairs_exclude,
     &        natoms_exclude,
     &        chains_exclude,residue_exclude_res,residue_exclude_ins,
     &        residue_exclude_chain,
     &        atoms_exclude,natom_pairs_exclude,atom_pairs_exclude)
         do i=1,nvdw
            iv1(1) = vdw_pairs(1,i)
            iv1(2) = vdw_pairs(2,i)
            ir1 = i_resid(iv1(1))
            ir2 = i_resid(iv1(2))
            read(res_num_pdb(ir1)(3:6),'(i4)')ipr1
            read(res_num_pdb(ir2)(3:6),'(i4)')ipr2
            ins1 = res_num_pdb(ir1)(7:7)
            ins2 = res_num_pdb(ir2)(7:7)
            call get_chain_namepdb(chnamp1,i_resid(iv1(1)))
            call get_chain_namepdb(chnamp2,i_resid(iv1(2)))
            if(nchain_pairs_exclude.gt.0) then
               do j=1,nchain_pairs_exclude
                  if(chnamp1.eq.chains_exclude(1,j).and.
     &                 chnamp2.eq.chains_exclude(2,j).or.
     &                 chnamp1.eq.chains_exclude(2,j).and.
     &                 chnamp2.eq.chains_exclude(1,j)) then
                     vdw_symm(1,i) = -1
                     exit
                  endif
               enddo
            endif
            if(nres_pairs_exclude.gt.0.and.vdw_symm(1,i).gt.0) then
               do j=1,nres_pairs_exclude
                  if(  chnamp1.eq.residue_exclude_chain(1,j).and.
     &                 chnamp2.eq.residue_exclude_chain(2,j).and.
     &                 ipr1.eq.residue_exclude_res(1,j).and.
     &                 ipr2.eq.residue_exclude_res(2,j).and.
     &                 ins1.eq.residue_exclude_ins(1,j).and.
     &                 ins2.eq.residue_exclude_ins(2,j).or.
     &                 chnamp2.eq.residue_exclude_chain(1,j).and.
     &                 chnamp1.eq.residue_exclude_chain(2,j).and.
     &                 ipr2.eq.residue_exclude_res(1,j).and.
     &                 ipr1.eq.residue_exclude_res(2,j).and.
     &                 ins2.eq.residue_exclude_ins(1,j).and.
     &                 ins1.eq.residue_exclude_ins(2,j)) then  
                     vdw_symm(1,i) = -1
                     exit
                  endif
               enddo
            endif
            if(natoms_exclude.gt.0.and.vdw_symm(1,i).gt.0) then
               do j=1,natoms_exclude
                  if(iv1(1).eq.atoms_exclude(j).or.
     &                 iv1(2).eq.atoms_exclude(j)) then
                     vdw_symm(1,i) = -1
                     exit
                  endif
               enddo
            endif
            if(natom_pairs_exclude.gt.0.and.vdw_symm(1,i).gt.0) then
               do j=1,natom_pairs_exclude
                  if(iv1(1).eq.atom_pairs_exclude(1,j).and.
     &               iv1(2).eq.atom_pairs_exclude(2,j).or.
     &               iv1(1).eq.atom_pairs_exclude(2,j).and.
     &               iv1(2).eq.atom_pairs_exclude(1,j)) then
                     vdw_symm(1,i) = -1
                     exit
                  endif
               enddo
            endif
         enddo
         if(minval(vdw_symm(1,1:nvdw)).eq.-1) then
            nvdw1 = 0
            do  iv=1,nvdw
               if(vdw_symm(1,iv).gt.0) then
                  nvdw1                = nvdw1 + 1
                  vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
                  vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
                  vdw_type(nvdw1)      = 1
               endif
            enddo
            nvdw = nvdw1
         endif
         deallocate(chains_exclude)
         deallocate(residue_exclude_res)
         deallocate(residue_exclude_chain)
         if(allocated(atom_pairs_exclude))deallocate(atom_pairs_exclude)
      endif
c
c--   remove bonds and angles
      call remove_bonds_and_angles(nvdw,nvdw1,vdw_pairs(1:2,1:nvdw),
     &     vdw_symm(1:4,1:nvdw),vdw_vidl(1:3,1:nvdw),
     &     vdw_type(1:nvdw),ierr)
      if(ierr.gt.0) then
         call errwrt(1,'Problem in removing bonds from vdw')
      endif
      nvdw = nvdw1
c
c---  Now check and define if it is vdw,ion, hbond etc
      nvdw1 = 0
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         is       = vdw_symm(1,iv)
         itx(1:3) = vdw_symm(2:4,iv)
         xtm(1:3) = xyz_crd_mod(1:3,iv1(2),im)
         call mat2vec(3,3,cs_ort_to_frac,xtm,xtm1,error)
         call mat2vec(3,3,cs_m_cs(1:3,1:3,is),xtm1,xtm,error)
         xtm1(1:3) = xtm(1:3) +cs_v_cs(1:3,is)+float(itx(1:3))
         call mat2vec(3,3,cs_frac_to_ort,xtm1,xtm,error)
         dist_cur = sqrt(sum((xyz_crd_mod(1:3,iv1(1),im)-xtm(1:3))**2))
         if(vdw_type(iv).eq.1) then
            call hbond_check(iv1(1),iv1(2),vdw_type(iv),
     &           vdw_vidl(1,iv),vdw_vidl(2,iv),vdw_vidl(3,iv))
         endif
         if(vdw_type(iv).eq.1) then
            call ibond_check(iv1(1),iv1(2),vdw_type(iv),
     &           vdw_vidl(1,iv),vdw_vidl(2,iv),vdw_vidl(3,iv))
         endif
         if(vdw_type(iv).eq.1) then
            call mbond_check(iv1(1),iv1(2),vdw_type(iv),
     &           vdw_vidl(1,iv),vdw_vidl(2,iv),vdw_vidl(3,iv))
         endif
         if(vdw_type(iv).eq.1) then
            call dummy_check(iv1(1),iv1(2),vdw_type(iv),
     &           vdw_vidl(1,iv),vdw_vidl(2,iv),vdw_vidl(3,iv))
         endif
         if(vdw_type(iv).eq.1) then
            vdw_vidl(1,iv) = vdw_rad(iv1(1))+vdw_rad(iv1(2))
            vdw_vidl(2,iv) = vdw_vidl(1,iv)
            vdw_vidl(3,iv) = vdw_sdi_vdw
         endif
c         if(dist_cur.gt.vdw_vidl(2,iv)) then
c            vdw_symm(1,iv) = -1
c         endif
      enddo
      nvdw1 = 0
      do iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1                 = nvdw1 + 1
            vdw_pairs(1:2,nvdw1)  = vdw_pairs(1:2,iv)
            vdw_vidl(1:3,nvdw1)   = vdw_vidl(1:3,iv)
            vdw_symm(1:4,nvdw1)   = vdw_symm(1:4,iv)
            vdw_type(nvdw1)       = vdw_type(iv)
         endif
      enddo
c
      if(len_trim(vdw_file).le.0) then
         call find_unique_file_name(vdw_file,'_VDW_R')
      endif
      call open_unform_file(iscrv,vdw_file,ierr)
      write(iscrv)nvdw1
      do iv=1,nvdw1
        if(vdw_symm(1,iv).ne.1.or.vdw_symm(2,iv).ne.0.or.
     &        vdw_symm(3,iv).ne.0.or.vdw_symm(4,iv).ne.0) then
           vdw_type(iv) = vdw_type(iv) + 6
        endif
         write(iscrv)vdw_pairs(1:2,iv),vdw_vidl(1:3,iv),
     &        vdw_symm(1:4,iv),vdw_type(iv)
      enddo
c
c---  Now read and find number of vdws and write again
      close(iscrv)
      deallocate(vdw_pairs)
      deallocate(vdw_symm)
      deallocate(vdw_vidl)
      deallocate(vdw_type)
      return
      end
c
      subroutine exclude_vdw_size(nchain_pairs_exclude,
     &     nres_pairs_exclude,natoms_exclude,natom_pairs_exclude)
      use restr_files
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      integer nchain_pairs_exclude
      integer nres_pairs_exclude
      integer natoms_exclude
      integer natom_pairs_exclude
c
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer lend_f

      integer iscrk,ierr,n1
c
      character chnamp1*4
      integer ir,ne,i,j,jrs,im
      integer, allocatable :: ires_beg(:)
      integer, allocatable :: ires_end(:)
      character(len=4), allocatable :: chain_beg(:)
      character(len=4), allocatable :: chain_end(:)
c
c---  body
      allocate(ires_beg(n_residue))
      allocate(ires_end(n_residue))
      allocate(chain_beg(n_residue))
      allocate(chain_end(n_residue))

      im  = 1
      nchain_pairs_exclude = 0
      nres_pairs_exclude = 0
      natoms_exclude = 0
      natom_pairs_exclude = 0
      ne  = 0
      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
      read(iscrk,'(a)',iostat=lend_f) line
      do while(lend_f.ge.0)
         ntok = maxtok
         call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &        ntok,lend,lprint)
         call ccpupc(key)
         do i=1,ntok
            call ccpupc(cvalue(i))
         enddo
         if(key.eq.'VDWR') then
            itk = 2
            if(cvalue(itk).eq.'EXCL') then
               itk = itk + 1
               if(cvalue(itk).eq.'BETW') then
                  itk = itk + 1
                  if(cvalue(itk).eq.'CHAI') then
                     itk = itk + 1
                     n1= ntok-itk+1
                     nchain_pairs_exclude = 
     &                    nchain_pairs_exclude + n1*(n1-1)/2
                  elseif(cvalue(itk).eq.'RESI') then
                     nres_pairs_exclude = nres_pairs_exclude+1
                  elseif(cvalue(itk).eq.'ATOM') then
                     natom_pairs_exclude = natom_pairs_exclude + 1
                  endif
               else if(cvalue(itk).eq.'RESI') then
                  itk = itk + 1
                  if(cvalue(itk).eq.'FROM') then
                     ne = ne + 1
                     itk = itk + 1
                     ires_beg(ne) = nint(fvalue(itk))
                     itk = itk + 1
                     chain_beg(ne) = line(ibeg(itk):iend(itk))
                     itk = itk + 1
                     ires_end(ne) = -999
                     if(cvalue(itk)(1:2).eq.'TO') then
                        itk = itk + 1
                        ires_end(ne) = nint(fvalue(itk))
                        itk = itk + 1
                        chain_end(ne) = line(ibeg(itk):iend(itk))
                     endif
                  else
                     ne = ne + 1
                     itk = itk + 1
                     ires_beg(ne) = nint(fvalue(itk))
                     itk = itk + 1
                     chain_beg(ne) = line(ibeg(itk):iend(itk))
                     itk = itk + 1
                     ires_end(ne) = ires_beg(ne)
                     chain_end(ne) = chain_beg(ne)
                  endif
               elseif(cvalue(itk).eq.'ATOM') then
                  natoms_exclude = natoms_exclude + 1
               endif
            endif
         endif
         read(iscrk,'(a)',iostat=lend_f) line         
      enddo
      if(ne.gt.0) then
         do i=1,n_atom_mod(im)
            call get_chain_namepdb(chnamp1,i_resid_mod(i,im))
            ir = i_resid_mod(i,im)
            read(res_num_pdb(ir)(3:6),'(i5)')jrs
            do j=1,ne
               if(chnamp1.eq.chain_beg(j).and.jrs.ge.ires_beg(j).and.
     &              jrs.le.ires_end(j)) then
                  natoms_exclude = natoms_exclude + 1
               endif
            enddo
         enddo
      endif

      deallocate(ires_beg)
      deallocate(ires_end)
      deallocate(chain_beg)
      deallocate(chain_end)
      close(iscrk)
      return
      end
c
      subroutine exclude_vdw_read(nsize_chain,nsize_res,nsize_atoms,
     &     chains_exclude,residue_exclude_res,residue_exclude_ins,
     &     residue_exclude_chain,
     &     atoms_exclude,natom_pairs_exclude,atom_pairs_exclude)
      use restr_files
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
c
c---locals and other params
      integer nsize_chain
      integer nsize_res
      integer nsize_atoms
      character chains_exclude(2,*)*4
      character residue_exclude_chain(2,*)*4
      integer residue_exclude_res(2,*)
      character residue_exclude_ins(2,*)
      integer atoms_exclude(*)

      integer natom_pairs_exclude
      integer atom_pairs_exclude(2,*)
c
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer lend_f
      integer itk1,itk2
c
      integer iexcl
      integer nexclude_atoms
      integer iscrk,ierr,n1
      integer i,j,ich,ia,ires_l
      character chnamp1*4
      integer ir,ne,jrs,im
      integer, allocatable :: ires_beg(:)
      integer, allocatable :: ires_end(:)
      character(len=4), allocatable :: chain_beg(:)
      character(len=4), allocatable :: chain_end(:)
c
      integer maxatom_in_rest
      parameter (maxatom_in_rest = 5)
      integer   iatom_number(maxatom_in_rest)
      integer isym_out(4,maxatom_in_rest)
      integer ires_in(maxatom_in_rest)
      character ins_in(maxatom_in_rest)*1
      character atom_in(maxatom_in_rest)*4
      character alt_in(maxatom_in_rest)*1
      character chain_in(maxatom_in_rest)*4
      character symm_in1(maxatom_in_rest)*1
      integer   iat,nrest_now
c
c---For atom reader
      integer nkeywords
      character EndKeywords(100)*4
      character symm1*1
      character chain1*4,ins1*1,alt1*1,atom1*4
      integer   ires1
c
      integer ii,n2,nkeys
      character asmgrp*4
      character(len=15) full_atom_in
      character(len=15), allocatable :: full_atom_name(:)
      integer, allocatable :: index_c(:)
c
c---  body
      lprint = .FALSE.
      allocate(ires_beg(n_residue))
      allocate(ires_end(n_residue))
      allocate(chain_beg(n_residue))
      allocate(chain_end(n_residue))
c

      allocate(full_atom_name(n_atom))
      allocate(index_c(n_atom))
      do ia=1,n_atom
         ires_l = i_resid(ia)
         ich = i_chain(ires_l)
         call get_asm_group_id(asmgrp,ich)
         write(full_atom_name(ia),'(a4,a5,a4,a1)')
     &        asmgrp,res_num_pdb(ires_l)(3:7),
     &        atm_name(ia),id_alt(ia)
         index_c(ia) = ia
      enddo
      nkeys = 1
      call cheap_sort_r(n_atom,nkeys,full_atom_name,index_c)
c
c---  body
      im = 1
      ich = 0
      ne = 0
      natom_pairs_exclude = 0
      nexclude_atoms = 0
      nsize_res = 0
      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
      read(iscrk,'(a)',iostat=lend_f) line

      nkeywords = 7
      EndKeywords(1) = 'FIRS'
      EndKeywords(2) = 'SECO'
      EndKeywords(3) = 'ATRE'
      EndKeywords(4) = 'ATIN'    
      EndKeywords(5) = 'NEXT'
      EndKeywords(6) = 'FROM'
      EndKEywords(7) = 'TO'
      mainl: do while(lend_f.ge.0)
         ntok = maxtok
         call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &        ntok,lend,lprint)
         call ccpupc(key)
         do i=1,ntok
            call ccpupc(cvalue(i))
         enddo
         if(key.eq.'VDWR') then
            itk = 2
            if(cvalue(itk).eq.'EXCL') then
               itk = itk + 1
               if(cvalue(itk).eq.'BETW') then
                  itk = itk + 1
                  if(cvalue(itk).eq.'CHAI') then
                     itk = itk + 1
                     n1= ntok-itk+1
                     do i=1,n1-1
                        itk1 = itk + i-1
                        do j=i+1,n1
                           itk2 = itk + j-1
                           ich = ich + 1
                           chains_exclude(1,ich) = 
     &                          line(ibeg(itk1):iend(itk1))
                           chains_exclude(2,ich) = 
     &                          line(ibeg(itk2):iend(itk2))
                        enddo
                     enddo
                     itk = itk + n1
                  elseif(cvalue(itk).eq.'RESI') then
                     itk = itk + 1
                     nsize_res = nsize_res+1
                     iat = 0
                     do while(itk.le.ntok)
                        if(  cvalue(itk).eq.'FIRS'.or.
     &                       cvalue(itk).eq.'SECO') then
                           itk = itk + 1
                           call read_external_atom_info(ntok,nkeywords,
     &                          itk,itk_out,
     &                          ibeg,iend,ires1,ierr,cvalue,line,
     &                          chain1,ins1,atom1,alt1,symm1,
     &                          EndKeywords)
                           if(ierr.gt.0) then
                              ierr = 5
                              write(*,*)
     &             'Problem in reading residue pairs for vdw exclude'
                              write(*,*)trim(line)
                              exit mainl
                           endif
                           itk = itk_out
                           iat = iat + 1
                           if(iat.gt.2) then
                              write(*,*)
     &             'Problem in readin residue pairs for vdw exclude'
                              write(*,*)trim(line)
                              ierr = 5
                              exit mainl
                           endif
                           residue_exclude_chain(iat,nsize_res)=chain1
                           residue_exclude_res(iat,nsize_res)=ires1
                           residue_Exclude_ins(iat,nsize_res) = ins1
                        endif
                     enddo
                  elseif(cvalue(itk).eq.'ATOM') then
                     itk = itk + 1
                     iat = 0
                     do while(itk.le.ntok)
                        
                        if(  cvalue(itk).eq.'FIRS'.or.
     &                       cvalue(itk).eq.'SECO') then
                           itk = itk + 1
                           call read_external_atom_info(ntok,nkeywords,
     &                          itk,itk_out,
     &                          ibeg,iend,ires1,ierr,cvalue,line,
     &                          chain1,ins1,atom1,alt1,symm1,
     &                          EndKeywords)
                           if(ierr.gt.0) then
                              ierr = 5
                              write(*,*)
     &                       'Problem while reading external restraints'
                              write(*,*)trim(line)
                              exit mainl
                           endif
                           itk = itk_out
                           iat = iat + 1
                           if(iat.gt.maxatom_in_rest) then
                              write(*,*) 
     &                             'Too many atoms in one restraint'
                              write(*,*)'Maximum allowed = ',
     &                             maxatom_in_rest
                              write(*,*)trim(line)
                              ierr = 6
                              exit mainl
                           endif
c     
                           chain_in(iat) = chain1
                           ires_in(iat)  = ires1
                           ins_in(iat)   = ins1
                           atom_in(iat)  = atom1
                           alt_in(iat)   = alt1
                           symm_in1(iat) = symm1
                           if(symm_in1(i).eq.'Y') then
                              write(*,*)
     &                      'Removing antibumping between symmetry '//
     &                      'related atoms is not ready'
                              write(*,*)trim(line)
                              cycle mainl
                           endif
                        endif
                     enddo
                     if(iat.eq.2) then
                        iexcl = natom_pairs_exclude + 1
                        natom_pairs_exclude = iexcl
                        do i=1,2
                           write(full_atom_in,'(a4,i4,a1,a4,a1)')
     &                          chain_in(i),ires_in(i),
     &                          ins_in(i),atom_in(i),alt_in(i)
                           ii = (n_atom+1)/2
                           n1 = 1
                           n2 = n_atom
                           do while(full_atom_name(ii).ne.full_atom_in
     &                          .and.n1.le.n2)
                              if(full_atom_in.lt.
     &                             full_atom_name(ii)) then
                                 n2 = ii-1
                              else
                                 n1 = ii+1
                              endif
                              ii = (n2+n1)/2
                           enddo
                           if(n1.le.n2) then
                              atom_pairs_exclude(i,iexcl)= index_c(ii)
                           else
                              write(*,*)
     &                      'Error: At least one of the atoms from '//
     &                      'the restraints could not be found:'
                              write(*,*)'==> ',trim(line)
                              write(*,*)full_atom_in
                              stop
                              ierr = 3
                           endif
                        enddo                           
                     else
                        write(*,*)'Error==> Problem in vdwr exclude'
                        write(*,*)'Current insruction:'
                        write(*,*)trim(line)
                     endif
                  endif               
               else if(cvalue(itk).eq.'RESI') then
                  itk = itk + 1
                  ne = ne + 1
                  ires_beg(ne) = 0
                  ires_end(ne) = 0
                  chain_beg(ne) = ' '
                  chain_end(ne) = ' '
                  do while(itk.le.ntok)
                     if(cvalue(itk).eq.'FROM'.or.
     &                    cvalue(itk).eq.'TO') then
                        itk = itk + 1
                        call read_external_atom_info(ntok,nkeywords,
     &                       itk,itk_out,
     &                       ibeg,iend,ires1,ierr,cvalue,line,
     &                       chain1,ins1,atom1,alt1,symm1,
     &                       EndKeywords)
                        if(cvalue(itk).eq.'FROM') then
                           ires_beg(ne) = ires1
                           chain_beg(ne) = chain1
                        elseif(cvalue(itk).eq.'TO') then
                           ires_end(ne) = ires1
                           chain_end(ne) = chain1
                        endif
                        itk = itk_out
                     endif
                  enddo
                  if(ires_end(ne).le.0) then
                     ires_end(ne) = ires_beg(ne)
                     chain_end(ne) = chain_beg(ne)
                  endif
               elseif(cvalue(itk).eq.'ATOM') then
                  itk = itk + 1
                  call read_external_atom_info(ntok,nkeywords,
     &                 itk,itk_out,
     &                 ibeg,iend,ires1,ierr,cvalue,line,
     &                 chain1,ins1,atom1,alt1,symm1,
     &                 EndKeywords)
                  
                  natom_pairs_exclude = iexcl
                  write(full_atom_in,'(a4,i4,a1,a4,a1)')
     &                 chain_in(i),ires_in(i),
     &                 ins_in(i),atom_in(i),alt_in(i)
                  ii = (n_atom+1)/2
                  n1 = 1
                  n2 = n_atom
                  do while(full_atom_name(ii).ne.full_atom_in
     &                 .and.n1.le.n2)
                     if(full_atom_in.lt.
     &                    full_atom_name(ii)) then
                        n2 = ii-1
                     else
                        n1 = ii+1
                     endif
                     ii = (n2+n1)/2
                  enddo
                  if(n1.le.n2) then
                     nexclude_atoms = nexclude_atoms + 1
                     atoms_exclude(nexclude_atoms) = index_c(ii)
                  else
                     write(*,*)
     &                    'Error: Atom could not be found:'
                     write(*,*)'==> ',trim(line)
                     write(*,*)full_atom_in
                     stop
                     ierr = 3
                  endif
               endif                                    
            endif
         endif
         read(iscrk,'(a)',iostat=lend_f) line         
      enddo mainl
      if(ierr.gt.0) then
         write(*,*)'Error==> Problem in reading  vdw exclude keywords'
         write(*,*)'Error==> ',trim(line)
         write(*,*)'Error==> Stopping now'
         call ccperr(1,'Cannot continue')
      endif
      write(*,*)ne
      if(ne.gt.0) then
         do i=1,n_atom_mod(im)
            call get_chain_namepdb(chnamp1,i_resid_mod(i,im))
            ir = i_resid_mod(i,im)
            read(res_num_pdb(ir)(3:6),'(i5)')jrs
            do j=1,ne
               if(chnamp1.eq.chain_beg(j).and.jrs.ge.ires_beg(j).and.
     &              jrs.le.ires_end(j)) then
                  nexclude_atoms = nexclude_atoms + 1
                  atoms_exclude(nexclude_atoms) = i
               endif
            enddo
         enddo
      endif

      deallocate(ires_beg)
      deallocate(ires_end)
      deallocate(chain_beg)
      deallocate(chain_end)
      deallocate(full_atom_name)
      deallocate(index_c)
      close(iscrk)
      return
      end

c
      SUBROUTINE HBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,DVDW_MAX,
     &                   VDW_SDI)
      use weights
C
c---Checks if two atoms can make hydrogen bonds. At the moment simple check
C---is perforfmed. If one of atoms is acceptor and another one is donor
C---then they can make hydrogen bonds. This subroutine should be improved
C---considerably.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
C
      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
      IF(HB_TYPE(IV1).EQ.'A') THEN
C
C---Check second atom should be either donor or donor/acceptor or hydrogen
C---from hyrogen bond capable atom
        IF(HB_TYPE(IV2).EQ.'D'.OR.HB_TYPE(IV2).EQ.'B') THEN
C
C---These two atoms can make hydrogen bond
          DVDW_IDEAL = VDW_RAD(IV1)+VDW_RAD(IV2)+
     &                   HBOND_DINC_AD
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3
          VDW_SDI    = VDW_SDI_HBOND
        ELSEIF(HB_TYPE(IV2).EQ.'H') THEN
C
c---Second atom is hydrogen from hydrogen bond capable atom
           DVDW_IDEAL = VDW_RAD(IV1) + HBOND_DINC_AH
           DVDW_MAX   = DVDW_IDEAL
           IVDW_TYPE  = 3
           VDW_SDI    = VDW_SDI_HBOND
        ENDIF
      ENDIF
      IF(HB_TYPE(IV1).EQ.'D')THEN
C
c---First atom is donor.Second atom should be acceptor only
        IF(HB_TYPE(IV2).EQ.'A'.OR.HB_TYPE(IV2).EQ.'B') THEN
          DVDW_IDEAL = VDW_RAD(IV1)+VDW_RAD(IV2)+
     &                    HBOND_DINC_AD 
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3
          VDW_SDI    = VDW_SDI_HBOND      
        ENDIF
      ENDIF
C
      IF(HB_TYPE(IV1).EQ.'B') THEN
C
C---Firts atom can be donor or acceptor
        IF(HB_TYPE(IV2).EQ.'A'.OR.HB_TYPE(IV2).EQ.'D'.OR.
     &     HB_TYPE(IV2).EQ.'B') THEN
C
          DVDW_IDEAL = VDW_RAD(IV1)+VDW_RAD(IV2)+
     &                   HBOND_DINC_AD
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE = 3
          VDW_SDI    = VDW_SDI_HBOND
        ELSEIF(HB_TYPE(IV2).EQ.'H') THEN
C
          DVDW_IDEAL = VDW_RAD(IV1)+HBOND_DINC_AH
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3 
          VDW_SDI    = VDW_SDI_HBOND
        ENDIF
      ENDIF
C
      IF(HB_TYPE(IV1).EQ.'H') THEN
C
c---First atom is hydrogen from hydrogen bond capable atom
        IF(HB_TYPE(IV2).EQ.'A'.OR.HB_TYPE(IV2).EQ.'B') THEN
          DVDW_IDEAL = VDW_RAD(IV2) + HBOND_DINC_AH
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3
          VDW_SDI    = VDW_SDI_HBOND
        ENDIF
      ENDIF
C
      RETURN
      END
C
      SUBROUTINE IBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,
     &               DVDW_MAX,VDW_SDI)
      use weights
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
C
      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
C----No idea what to do
      RETURN
      END
C
      SUBROUTINE  MBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,DVDW_MAX,
     &             VDW_SDI)
      use weights
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
C
      INTEGER MAX_METAL
      PARAMETER (MAX_METAL = 83)
      CHARACTER METAL(MAX_METAL)*2

      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
      REAL RAD1,RAD2
      INTEGER IM
      LOGICAL METAL_FLAG

      DATA METAL/'AG','AL','AU','CA','CD','CE','CO','CR','CS','CU','EU',
     &           'FE','HG','HO','K ','LA','LI','MG','MN','MO','NA','PT',
     &           'TA','ZN','BE','SC','TI','V ','NI','RB','SR','Y ','ZR',
     &           'NB','TC','RU','RH','PD','IN','SN','TE','I ','BA','LA',
     &           'CE','PR','ND','PM','SM','GD','TB','DY','ER','TM','YB',
     &           'LU','HF','W ','RE','OS','IR','TL','PB','BI','PO','AT',
     &           'FR','RA','AC','TH','PA','U ','NP','PU','AM','CM','BK',
     &           'CF','ES','FM','MD','NO','LR'/
c---If one of atoms is metal and second one is capable of coordinating this
C---metal. At the moment no idea how to deal with it.
      METAL_FLAG = .FALSE.
      DO    IM = 1,MAX_METAL
        IF(CS_ELEMENT(ID_SF(IV1))(1:2).EQ.METAL(IM)) THEN
          METAL_FLAG = .TRUE.
          GOTO 100
        ENDIF
      ENDDO
      DO   IM=1,MAX_METAL
        IF(CS_ELEMENT(ID_SF(IV2))(1:2).EQ.METAL(IM)) THEN
          METAL_FLAG = .TRUE.
          GOTO 100
        ENDIF
      ENDDO
      RETURN
 100  CONTINUE
C
C---One of the atoms is metal. Use ionic radii of atoms. 
C---Consider putting restraints on them

      IF(ION_RAD(IV1).GT.0.0.AND.ION_RAD(IV2).GT.0.0) THEN
        RAD1 = ION_RAD(IV1)
        RAD2 = ION_RAD(IV2)
        DVDW_IDEAL = RAD1 + RAD2
        DVDW_MAX   = DVDW_IDEAL
        VDW_SDI    = VDW_SDI_METAL 
        IVDW_TYPE  = 4
      ENDIF
      RETURN
      END
C
      SUBROUTINE  DUMMY_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,DVDW_MAX,
     &             VDW_SDI)
      use weights
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
C
      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
      REAL RAD1,RAD2
C

      RAD1 = VDW_RAD(IV1)
      RAD2 = VDW_RAD(IV2)
C
      IF((ATM_NAME(IV1).EQ.'DUM'.AND.ATM_NAME(IV2).NE.'DUM').OR.
     &   (ATM_NAME(IV1).NE.'DUM'.AND.ATM_NAME(IV2).EQ.'DUM')) THEN
         DVDW_IDEAL = AMAX1(0.7,RAD1 + RAD2 + DINC_DUMMY)
         DVDW_MAX   = DVDW_IDEAL
         VDW_SDI    = VDW_SDI_DUMMY
         ivdw_type  = 5
      ENDIF
      IF(ATM_NAME(IV1).EQ.'DUM'.AND.ATM_NAME(IV2).EQ.'DUM') THEN
         DVDW_IDEAL = RAD1 + RAD2
         DVDW_MAX   = DVDW_IDEAL
         VDW_SDI    = VDW_SDI_DUMMY
         ivdw_type  = 6
      ENDIF
c
      RETURN
      END
C
      subroutine remove_bonds_and_angles(nvdw,nvdw_out,vdw_pairs,
     &     vdw_symm,vdw_vidl,vdw_type,ierr)
      use weights
      use restr_files
c
      implicit none
      include 'atom_com.fh'
      include 'atom_com_str.fh'
c
      integer nvdw,nvdw_out
      integer vdw_pairs(2,nvdw)
      integer vdw_symm(4,nvdw)
      integer vdw_type(nvdw)
      real    vdw_vidl(3,nvdw)
      real    weight_b
c
      integer ierr
c
c---  allocatable arrays
      integer, allocatable :: nrest_per_atom(:)
      integer, allocatable :: bond_pairs(:,:)
      integer, allocatable :: bond_symm(:,:)
      integer, allocatable :: rest_per_atom(:,:)
      integer, allocatable :: rest_per_atom_symm(:,:,:)
c
      integer nvdw1,nbond,nbonds
      integer iv,ib,id,first,ia1,ib1,ia2,ib2,iel1,iel2,itype_bond
      integer ia3
      integer nmaxrest
      integer j,nb_dupl,nb_now
      integer bonds_l(2)
      integer ia_l(2),iv1(2)
      integer isym1(4),isym2(4),isym3(4),isym4(4),isym_l(4)
      integer isym_o1(4),isym_o2(4)
      integer itx1(3),symm_loc(4)
      integer iscrb,iscrv

      real dinc_curr1,dinc_curr2,dinc_current,rs_vidl(2)
c     
      integer nbb,naa,ntt,ntt1
      integer iscri,nint,ii
      real rs_vidl_i(4)
      integer iend
c
      integer iadd
      real dist_l
      real xyz_l(3)
c
      real dbond,rs_sdi
      real, allocatable :: rs_vidl_mult(:,:)
c
c---- body
      if(len_trim(bond_file).le.0) return
      call open_unform_file(iscrb,bond_file,ierr)
      if(ierr.gt.0) then
         call errwrt(-1,'Problem while opening bond_file')
         return
      endif
      read(iscrb)nbonds,nb_dupl
      allocate(rs_vidl_mult(2,nb_dupl))
      nbond = 0
      allocate(nrest_per_atom(n_atom))
      nrest_per_atom(1:n_atom) = 0
      do  ib=1,nbonds
         read(iscrb,iostat=iend)nb_now
         read(iscrb,iostat=iend)ia_l(1:2),
     &        (rs_vidl_mult(1:2,j),j=1,nb_now),
     &        isym1(1:4),itype_bond,weight_b
         iadd=1
         if(itype_bond.ge.2.and.
     &        isym1(1).eq.1.and.sum(abs(isym1(2:4))).eq.0) then
            dist_l = sqrt(sum((xyz_crd(1:3,ia_l(1))-
     &           xyz_crd(1:3,ia_l(2)))**2))
            dbond = 1.0e32
            
            do j=1,nb_now
               if(abs(dbond).gt.abs(dist_l-rs_vidl_mult(1,j))) then
                  rs_vidl(1) = rs_vidl_mult(1,j)
                  dbond = dist_l-rs_vidl(1)
                  rs_vidl(2) = rs_vidl_mult(2,j)
               endif
            enddo
            if(abs(dbond).gt. sd_ext_cut*max(rs_vidl(2),sd_ext_min))then
               iadd=0
            endif
         endif
         if(iadd.eq.1) then
            nbond = nbond + 1
            nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
            nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
         endif
      enddo
c
c--   Add intervals as distances
      if(len_trim(interval_file).gt.0) then
         call open_unform_file(iscri,interval_file,ierr)
         if(ierr.gt.0) then
            call errwrt(-1,'Problem whie opening interval file')
            return
         endif
         read(iscri) nint
         do ib=1,nint
            read(iscri,iostat=iend)ia_l(1:2),isym1(1:4),rs_vidl_i(1:4),
     &           itype_bond,weight_b
            if(itype_bond.eq.1.or.itype_bond.eq.2) then
               nbond = nbond + 1
               nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
               nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
            endif
         enddo
      endif
      nmaxrest = maxval(nrest_per_atom)
      
      allocate(bond_pairs(2,nbond))
      allocate(bond_symm(4,nbond))
      allocate(rest_per_atom(nmaxrest,n_atom))
      allocate(rest_per_atom_symm(4,nmaxrest,n_atom))
      
      nrest_per_atom(1:n_atom) = 0
c
c---read and do a little bit of organisation
      rewind(iscrb)
c
      nbond = 0
      first  = 0
      read(iscrb)nbonds,nb_dupl
      do  ib=1,nbonds
         read(iscrb)nb_now
         read(iscrb,iostat=iend)ia_l(1:2),
     &        (rs_vidl_mult(1:2,j),j=1,nb_now),
     &        isym1(1:4),itype_bond,weight_b
         iadd=1
         if(itype_bond.ge.2.and.
     &        isym1(1).eq.1.and.sum(abs(isym1(2:4))).eq.0) then
            dist_l = sqrt(sum((xyz_crd(1:3,ia_l(1))-
     &           xyz_crd(1:3,ia_l(2)))**2))

            dbond = 1.0e32
            do j=1,nb_now
               if(dbond.gt.abs(dist_l-rs_vidl_mult(1,j))) then
                  dbond = abs(dist_l-rs_vidl_mult(1,j))
                  rs_sdi = rs_vidl_mult(2,j)
               endif
            enddo
            if(dbond.gt.sd_ext_cut*max(rs_sdi,sd_ext_min)) iadd = 0
c            do j=1,nb_now
c               if(abs(dist_l-rs_vidl_muly(1,j)).gt.
c     &              sd_ext_cut*max(rs_vidl(2),sd_ext_min))iadd=0
c            enddo
         endif
         if(iadd.eq.1) then
            nbond = nbond + 1
            bond_pairs(1:2,nbond) = ia_l(1:2)
            bond_symm(1:4,nbond) = isym1(1:4)
            nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
            if(ia_l(1).ne.ia_l(2)) then
               nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
            endif
            ib1 = nrest_per_atom(ia_l(1))
            ib2 = nrest_per_atom(ia_l(2))
            rest_per_atom(ib1,ia_l(1)) = ia_l(2)
            rest_per_atom_symm(1:4,ib1,ia_l(1)) = bond_symm(1:4,nbond)
            rest_per_atom(ib2,ia_l(2)) = ia_l(1)
            call symm_inv_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,
     &           bond_symm(1:4,nbond),isym1,first)
            rest_per_atom_symm(1:4,ib2,ia_l(2)) = isym1(1:4)
         endif
      enddo

      deallocate(rs_vidl_mult)
      ii = nbond
      close(iscrb)
      rewind(iscri)
      read(iscri)nint
      if(nint.gt.0) then
         do ib=1,nint
            read(iscri)bonds_l(1:2),isym1(1:4),
     &           rs_vidl_i(1:4),itype_bond,weight_b
            if(itype_bond.eq.1.or.itype_bond.eq.2) then
               ii = ii + 1
               bond_pairs(1:2,ii) = bonds_l(1:2)
               bond_symm(1:4,ii) = isym1(1:4)
               ia_l(1:2) = bond_pairs(1:2,ii)
               nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
               if(ia_l(1).ne.ia_l(2)) then
                  nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
               endif
               ib1 = nrest_per_atom(ia_l(1))
               ib2 = nrest_per_atom(ia_l(2))
               rest_per_atom(ib1,ia_l(1)) = ia_l(2)
               rest_per_atom_symm(1:4,ib1,ia_l(1)) = bond_symm(1:4,ii)
               rest_per_atom(ib2,ia_l(2)) = ia_l(1)
               call symm_inv_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,
     &              bond_symm(1:4,ii),isym1,first)
               rest_per_atom_symm(1:4,ib2,ia_l(2)) = isym1(1:4)
            endif
         enddo
      endif
      close(iscri)

c
c---  Remember that bonds and vdw have already been sorted. 
c
c---  vdw is in the list of bonds remove it
      nbb    = 0
      naa    = 0
      ntt    = 0
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(nrest_per_atom(iv1(1)).gt.0.and.
     &        nrest_per_atom(iv1(2)).gt.0) then
c
c---  Is it a bond
            do ib=1,nrest_per_atom(iv1(1))
               if(iv1(2).eq.rest_per_atom(ib,iv1(1))) then
                  isym1(1:4)=rest_per_atom_symm(1:4,ib,iv1(1))
                  id=maxval(abs(vdw_symm(1:4,iv)-isym1(1:4)))
                  if(id.eq.0) then
                     nbb = nbb + 1
                     vdw_symm(1,iv) = -1
                     goto 100
                  endif
               endif
            enddo
 100        continue
         endif
      enddo
      nvdw1 = 0
      do  iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1 = nvdw1 +1
            vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
            vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
            vdw_vidl(1:3,nvdw1)  = vdw_vidl(1:3,iv)
            vdw_type(nvdw1)      = vdw_type(iv)
         endif
      enddo
      nvdw = nvdw1
c
c---  Is it an angle
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(nrest_per_atom(iv1(1)).gt.0.and.
     &        nrest_per_atom(iv1(2)).gt.0) then
            do   ib=1,nrest_per_atom(iv1(1))
               ia1        = rest_per_atom(ib,iv1(1))
               if(nrest_per_atom(ia1).gt.1) then
                  isym1(1:4) = rest_per_atom_symm(1:4,ib,iv1(1))
                  do ib1=1,nrest_per_atom(ia1)
                     if(rest_per_atom(ib1,ia1).eq.iv1(2)) then
                        isym2(1:4) = rest_per_atom_symm(1:4,ib1,ia1)
                        call symm_mult_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,
     &                       isym1,isym2,isym3,first)
                        id=maxval(abs(vdw_symm(1:4,iv)-isym3(1:4)))
                        if(id.eq.0) then
                           naa = naa + 1
                           vdw_symm(1,iv) = -1
                           goto 200
                        endif
                     endif
                  enddo
               endif
            enddo
 200        continue
         endif
      enddo
      nvdw1 = 0
      do  iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1 = nvdw1 +1
            vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
            vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
            vdw_vidl(1:3,nvdw1)  = vdw_vidl(1:3,iv)
            vdw_type(nvdw1)      = vdw_type(iv)
         endif
      enddo
      nvdw = nvdw1
c
c---  Torsions
      ntt1 = 0
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(nrest_per_atom(iv1(1)).gt.0.and.
     &        nrest_per_atom(iv1(2)).gt.0) then
            do ib=1,nrest_per_atom(iv1(1))
               ia1 = rest_per_atom(ib,iv1(1))
               if(nrest_per_atom(ia1).gt.1) then
                  isym1(1:4) = rest_per_atom_symm(1:4,ib,iv1(1))
                  do  ib1=1,nrest_per_atom(ia1)
                     ia2=rest_per_atom(ib1,ia1)
                     if(nrest_per_atom(ia2).gt.1) then
                        isym2(1:4) = rest_per_atom_symm(1:4,ib1,ia1)
                        do ib2=1,nrest_per_atom(ia2)
                           ia3=rest_per_atom(ib2,ia2)
                           if(ia3.eq.iv1(2)) then
                              isym3(1:4)=rest_per_atom_symm(1:4,ib2,ia2)
                              call symm_mult_r(maxnso,cs_nsym,cs_m_cs,
     &                             cs_v_cs,
     &                             isym1,isym2,isym_o1,first)
                              call symm_mult_r(maxnso,cs_nsym,cs_m_cs,
     &                             cs_v_cs,
     &                             isym_o1,isym3,isym_o2,first)
                              id=maxval(abs(vdw_symm(1:4,iv)-
     &                             isym_o2(1:4)))
                              ntt1 = ntt1 + 1
                              if(id.eq.0) then
c
c---  Torsion angle related atoms
                                 iel1 = id_sf(iv1(1))
                                 iel2 = id_sf(iv1(2))
                                 if(cs_element(iel1).eq.'O   ') then
                                    dinc_curr1=dinc_torsion_o
                                 elseif(cs_element(iel1).eq.'N   ') then
                                    dinc_curr1=dinc_torsion_n
                                 elseif(cs_element(iel1).eq.'C   ') then
                                    dinc_curr1=dinc_torsion_c
                                 else
                                    dinc_curr1=dinc_torsion_all
                                 endif
                                 if(cs_element(iel2).eq.'O   ') then
                                    dinc_curr2=dinc_torsion_o
                                 elseif(cs_element(iel2).eq.'N   ') then
                                    dinc_curr2=dinc_torsion_n
                                 elseif(cs_element(iel2).eq.'C   ') then
                                    dinc_curr2=dinc_torsion_c
                                 else
                                    dinc_curr2=dinc_torsion_all
                                 endif
                                 dinc_current=dinc_curr1+dinc_curr2
                                 vdw_type(iv) = 2
                                 vdw_vidl(1,iv) = vdw_rad(iv1(1))+
     &                                vdw_rad(iv1(2))+dinc_current
                                 vdw_vidl(3,iv)=vdw_sdi_torsion
                                 vdw_vidl(2,iv)=vdw_vidl(1,iv)
                                 ntt = ntt + 1
                                 goto 300
                              endif
                           endif
                        enddo
                     endif
                  enddo
               endif               
            enddo
 300        continue
         endif
      enddo
c
c--Deallocate
      nvdw_out = nvdw1
      deallocate(nrest_per_atom)
      deallocate(bond_pairs)
      deallocate(bond_symm)
      deallocate(rest_per_atom)
      deallocate(rest_per_atom_symm)
      return
      end
c
      subroutine add_waters2chains(dlim)
      use restr_files
      implicit none
      include 'atom_com.fh'
c
c---  add ligands, metals and waters to the grops defined by peptide/RNA/DNA 
c---  chains
      integer igr,ir1,ir2,ir,ic,ia,ia1,ia2,ia3,ib1,ib2,iv,ish,n_defined
      integer in,nr,nr_all,nvdw,np,nmax_c,n_change,n_step,n_isol
      integer i,k,l,i1,i2,n_moved

      integer, allocatable :: pairs(:,:)
      integer, allocatable :: symm_flag(:)
      integer, allocatable :: nvdw_per_atom(:)
      integer, allocatable :: vdw_per_atom(:,:)
      integer, allocatable :: vdw_symm(:,:)
c
      integer is
      real dist
      real tmp(3),tmp1(3),tx(3)
      real dlim,dlim_f
      integer ifile,ierr
      character chnm1*4,chnm2*4
      logical lexists
c
c---- body
      write(*,'(100a)')('-',i=1,80)
      call header('Assign all residues to one of the chains')
      write(*,'(100a)')('-',i=1,80)

      belongs_shell(1:n_atom) = 0
      belongs_chain(1:n_atom) = 0

      n_defined = 0
      do igr=1,n_group
         if(nres_chain(igr).gt.1) then
            do ir=ires_first(igr),ires_first(igr)+nres_chain(igr)-1
               if(ires_type(ir).eq.3.or.ires_type(ir).eq.4.or.
     &              ires_type(ir).eq.5.or.ires_type(ir).eq.6) then
                  do ia=iratm_first(ir),iratm_first(ir)+natm_res(ir)-1
                     belongs_chain(ia) = igr
                     belongs_shell(ia) = 1
                     n_defined = n_defined + 1
                  enddo
               endif
            enddo
         endif
      enddo
      if(n_defined.ge.n_atom) return
c
      call check_all_contacts_file(dlim,n_atom,n_atom,
     &     xyz_crd(1:3,1:n_atom),occup(1:n_atom),
     &     cs_nsym,cs_nsym,cs_m_cs(1:3,1:3,1:cs_nsym),
     &     cs_v_cs(1:3,1:cs_nsym),
     &     cs_cell,all_contacts_file,ierr)

      call open_unform_file(ifile,all_contacts_file,ierr)
      read(ifile)nvdw,dlim_f
      close(ifile)
      allocate(pairs(2,nvdw))
      allocate(symm_flag(nvdw))

      call read_all_contacts_file(nvdw,pairs,symm_flag,
     &     all_contacts_file,ierr)

      allocate(nvdw_per_atom(n_atom))
      nvdw_per_atom(1:n_atom) = 0
      do iv=1,nvdw
         nvdw_per_atom(pairs(1,iv)) = nvdw_per_atom(pairs(1,iv))+1
         nvdw_per_atom(pairs(2,iv)) = nvdw_per_atom(pairs(2,iv))+1
      enddo

      nmax_c = maxval(nvdw_per_atom(1:n_atom))
      if(nmax_c.le.0) then
         deallocate(nvdw_per_atom)
         deallocate(pairs)
         deallocate(symm_flag)
         return
      endif
      allocate(vdw_per_atom(nmax_c,n_atom))
      allocate(vdw_symm(nmax_c,n_atom))
      nvdw_per_atom(1:n_atom) = 0
      do iv=1,nvdw
         i1 = pairs(1,iv)
         i2 = pairs(2,iv)
         nvdw_per_atom(i1) = nvdw_per_atom(i1)+1
         vdw_per_atom(nvdw_per_atom(i1),i1) = i2
         vdw_symm(nvdw_per_atom(i1),i1) = symm_flag(iv)
         nvdw_per_atom(i2) = nvdw_per_atom(i2)+1
         vdw_per_atom(nvdw_per_atom(i2),i2) = i1
         vdw_symm(nvdw_per_atom(i2),i2) = symm_flag(iv)
      enddo
c
      deallocate(pairs)
      deallocate(symm_flag)
      n_change = 1
      n_step = 0

      do while(n_change.gt.0)
         n_change = 0
         n_step = n_step + 1
         do ia=1,n_atom
            if(belongs_chain(ia).gt.0.and.
     &           belongs_shell(ia).eq.n_step) then
               do in=1,nvdw_per_atom(ia)
                  if(vdw_symm(in,ia).eq.0) then
                     ia2 = vdw_per_atom(in,ia)
                     if(belongs_chain(ia2).le.0) then
                        belongs_chain(ia2) = belongs_chain(ia)
                        belongs_shell(ia2) = n_step + 1
                        n_change = n_change + 1
                     endif
                  endif
               enddo
            endif
         enddo
         write(*,*)'The number of assigned atoms = ',n_change,
     &        ' in shell ',n_step
      enddo
c
c--   Report isolated atoms. Should we use symmetry?. Careful with monomers.
c---  they may belong to different groups
      n_change = 1
      n_moved = 0
      n_step = 0
      call header
     &     ('Move residues to the closest symmetry related molecule')
      do while(n_change.gt.0)
         n_change = 0
         n_step = n_step + 1
         write(*,*)'Round = ',n_step
         do ic=1,n_group
            ir1=ires_first(ic)
            ir2 = ir1+nres_chain(ic)-1
            do ir=ir1,ir2
               ia1=iratm_first(ir)
               ia2 = ia1 + natm_res(ir)-1
               n_defined = 0
               do ia=ia1,ia2
                  if(belongs_chain(ia).gt.0) n_defined = n_defined + 1
               enddo
               if(n_defined.eq.0) then
c
c---  No atom in the residue belongs to any chain. Try symmetry and bring to
c---  to the closest chain
                  call get_chain_namepdb(chnm1,ir)
                  write(*,*)'Residue ',chnm1,res_num_pdb(ir)(3:7),
     &                 res_name(ir), 'does not belong to any chain.',
     &                 ' Try its symmetry mates'
                  is = 0
                  do ia=ia1,ia2
                     if(nvdw_per_atom(ia).gt.0) then
                        do in=1,nvdw_per_atom(ia)
                           ia3 = vdw_per_atom(in,ia)
                           if(belongs_chain(ia3).gt.0) then
                              call find_min_symm(xyz_crd(1:3,ia3),
     &                             xyz_crd(1:3,ia),maxnso,cs_nsym,
     &                             cs_m_cs,cs_v_cs,cs_ort_to_frac,
     &                             cs_frac_to_ort,is,tx,dist)
                              goto 10
                           endif
                        enddo
                     endif
                  enddo
 10               continue
c
c---  Report this. 
                  if(is.gt.0) then
                     do ia=ia1,ia2
                        tmp(1:3)=matmul(cs_ort_to_frac,xyz_crd(1:3,ia))
                        tmp1(1:3) = matmul(cs_m_cs(1:3,1:3,is),tmp)+
     &                       cs_v_cs(1:3,is)+tx(1:3)
                        tmp(1:3) = matmul(cs_frac_to_ort,tmp1)
                        xyz_crd(1:3,ia) = tmp(1:3)
                     enddo
                     igr = belongs_chain(ia3)
                     call get_chain_namepdb(chnm2,i_resid(ia3))
                     write(*,*)'Now residue ',chnm1,
     &                    res_num_pdb(ir)(3:7),
     &                    res_name(ir),'belongs to the chain ',
     &                    igr,' with chain name: ',chnm2
                     belongs_chain(ia1:ia2) = belongs_chain(ia3)
                     belongs_shell(ia1:ia2) = belongs_shell(ia3)+1
                     n_change = n_change + 1
                  endif
               else if(n_defined.lt.natm_res(ir)) then
c
c---  Not all atoms of a residue belongs to a chain. If remaining
c---  atoms belong to the same chain then assign all other atom to this chain
c---  also
                  ish = 0
                  ib1 = 1000000
                  ib2 = -100000
                  do ia=ia1,ia2
                     if(belongs_chain(ia).gt.0) then
                        ib1 = min(ib1,belongs_chain(ia))
                        ib2 = max(ib1,belongs_chain(ia))
                        ish = belongs_shell(ia)
                     endif
                  enddo
                  if(ib1.ne.ib2) then
                     call get_chain_namepdb(chnm1,ir)
                     write(*,*)'Residue ',chnm1,res_num_pdb(ir)(3:7),
     &                    res_name(ir), 'belongs at least to two chains'
                     write(*,*)'These chains are: ',chain_id(ib1),
     &                    chain_id(ib2)
c     
c---  We have conflict. Report and sort out later
                  else
                     belongs_chain(ia1:ia2) = ib1
                     belongs_shell(ia1:ia2) = ish
                  endif
               else
c
c---  We have conflict. Report and sort out later
                  ib1 = minval(belongs_chain(ia1:ia2))
                  ib2 = maxval(belongs_chain(ia1:ia2))
                  if(ib1.ne.ib2) then
                     call get_chain_namepdb(chnm1,ir)
                     write(*,*)'Residue ',chnm1,res_num_pdb(ir)(3:7),
     &                    res_name(ir), 'belongs at least to two chains'
                     write(*,*)'These chains are: ',chain_id(ib1),
     &                    chain_id(ib2)
                  endif
               endif
            enddo
         enddo
         write(*,*)'The number of moved residues in round ',n_step,
     &        'is ',n_change
         n_moved = n_moved + n_change
         write(*,*)
      enddo
      write(*,*)'The total number of moved residues = ',n_moved
c
c--   If some of the residues have been moved then contact files may be 
c--   incorrect. Delete it
      if(n_moved.gt.0) then
         all_contacts_file = ' '
         close(ifile,status='DELETE')
      else
         close(ifile)
      endif

      call header('The list of isolated residues')
      n_isol = 0
      do ic=1,n_group
         ir1=ires_first(ic)
         ir2 = ir1+nres_chain(ic)-1
         do ir=ir1,ir2
            ia1=iratm_first(ir)
            ia2 = ia1 + natm_res(ir)-1
            n_defined = 0
            do ia=ia1,ia2
               if(belongs_chain(ia).gt.0) n_defined = n_defined + 1
            enddo
            if(n_defined.eq.0) then
               n_isol = n_isol + 1
               call get_chain_namepdb(chnm1,ir)
               write(*,*)'Warning==> Residue ',chnm1,
     &              res_num_pdb(ir)(3:7),
     &              res_name(ir),' is isolated'
            endif
         enddo
      enddo
      write(*,*)
      write(*,*)'The number of isolotated residues = ',n_isol
      write(*,'(100a)')('-',i=1,80)
      deallocate(nvdw_per_atom)
      deallocate(vdw_per_atom)
      deallocate(vdw_symm)
      return
      end
c

      subroutine check_all_contacts_file(dlim,maxatom,n_atom,xyz_crd,
     &     occup,maxsym,nsym,rot,tr,cell,all_contacts_file,ierr)
      implicit none
c
c---  Check if all contacts file does not exist or calculation limit is less
c---  than desired then do calculations again
      real dlim
      integer maxatom,n_atom
      real xyz_crd(3,maxatom),occup(maxatom)
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym),cell(6)
      integer ierr
      character*(*) all_contacts_file
c
c---  locals
      integer nvdw
      integer ifile
      real dlim_f
      logical lexists
c
c---  body
      ierr = 0

      if(len_trim(all_contacts_file).le.0) then
         call find_unique_file_name(all_contacts_file,'.contacts.tmp')
         call find_all_contacts(dlim,maxatom,n_atom,xyz_crd,
     &        occup,maxsym,nsym,rot,tr,cell,all_contacts_file,ierr)
      else
         inquire(file=all_contacts_file,exist=lexists)
         if(.not.lexists) then
            call find_all_contacts(dlim,maxatom,n_atom,xyz_crd,
     &           occup,maxsym,nsym,rot,tr,cell, all_contacts_file,ierr)
         else
            call open_unform_file(ifile,all_contacts_file,ierr)
            read(ifile)nvdw,dlim_f
            if(dlim_f.lt.dlim) then
               close(ifile,status='DELETE')
               call find_all_contacts(dlim,maxatom,n_atom,xyz_crd,occup,
     &              maxsym,nsym,rot,tr,cell,all_contacts_file,ierr)
            else
               close(ifile)
            endif
         endif
      endif

      return
      end
c
      subroutine read_all_contacts_file(nvdw,pairs,symm_flag,
     &     all_contacts_file,ierr)
      implicit none
C
c---  Read all pairs from all_contacts_file. Keep symm info as yes/no
      integer nvdw
      integer pairs(2,nvdw)
      integer symm_flag(nvdw)
      character all_contacts_file*(*)
      integer ierr
c
      integer, allocatable :: ia1_l(:,:)
      integer, allocatable :: symm_l(:,:)

      integer np,k,ir
      integer ifile,nr,nr_all,nvdw_l
      real dlim_f

      call open_unform_file(ifile,all_contacts_file,ierr)
      read(ifile)nvdw_l,dlim_f
      if(nvdw.ne.nvdw_l) then
         write(*,*)'Error==> Internal error in read_all_contacts'
         write(*,*)'It is a programming error'
         close(ifile)
         stop
      endif
      nr_all = 0
      np = 0
      do while(nr_all.lt.nvdw_l)
         read(ifile)nr
         if(nr.le.0) cycle
         nr_all = nr_all + nr
         allocate(ia1_l(2,nr))
         allocate(symm_l(4,nr))
         read(ifile)(ia1_l(1:2,ir),symm_l(1:4,ir),ir=1,nr)
         do k=1,nr
            np = np + 1
            pairs(1:2,np) = ia1_l(1:2,k)
            if(symm_l(1,k).eq.1.and.sum(abs(symm_l(2:4,k))).eq.0) then
               symm_flag(np) = 0
            else
               symm_flag(np) = 1
            endif
         enddo
         deallocate(ia1_l)
         deallocate(symm_l)
      enddo
      close(ifile)
      return
      end
