module external_restraints
  use atom
  real dist_cut_external=4.5
  
contains
  subroutine generate_from_identical_coordinates(dist_cut,external_restraint_file)
    implicit none
    
    real, intent(in) :: dist_cut
    integer, intent(out) :: ierr
    character(len=*) :: external_restraint_file

    integer npairs
    integer iscr1
    !
    ! General counters
    integer i,j

    real dist
    integer ires,ires1,ires2
    character(len=1) chnmp1,chnmp2
    character(len=4) name1,name2
    character(len=1) alt1,alt2,ins1,ins2
    !
    !  vdw info
    integer itype
    integer ia1_l(2),symm_ll(4)
    real rs_vidl(2)

    !
    !   body
    if(dist_cut.le.0.0) dist_cut = dist_cut_external
    call analyse_vdw(dist_cut)
    !

      call open_unform_file(iscr1,vdw_file,ierr)
      read(iscr1)npairs

      call open_form_file(iexte,external_restraint_file,ierr)

      do i=1,npairs
         read(iscr1)ia1_l(1:2),rs_vidl(1:2),symm_ll(1:4),itype
         !
         !   Condition: If we need this pairs. We do not need contacts via symmetry. So skip them
         if(symm_ll(1,j).ne.1.or.any(symm_ll(2:4,j).ne.0)) cycle
         if(intra_chain.and.chnmp1.ne.chnmp2) cycle
         dist = sqrt((sum(xyz_crd(1:3,ia1_l(2))-xyz_crd(1:3,ia1_l(2)))**2))
         if(dist.gt.dist_cut) cycle
         !
         !   Apply atom selection rule
         name1 = atm_name(ia1_l(1))
         ires = i_resid(ia1_l(1))
         read(res_num_pdb(ires)(3:6),*)ires1
         ins1 = res_num_pdb(ires)(7:7)
         if(ins1.eq.' ') ins1 = '.'
         alt1 = id_alt(ia1_l(1))
         if(alt1.eq.' ') alt1 = '.'
         
         name2 = atm_name(ia1_l(2))
         ires = i_resid(ia1_l(2))
         read(res_num_pdb(ires)(3:6),*)ires2
         ins2 = res_num_pdb(ires)(7:7)
         if(ins2.eq.' ') ins2 = '.'
         alt2 = id_alt(ia1_l(2)
         if(alt2.eq.' ') alt2 = '.'
         ! 
         !   loop over chains for which this restraints should be propogated
         do j=1,nchain_for_chain(ich)
            chnmp1 = chain_name(ich,j)
            chnmp2 = chnmp1
            write(iexte,*)'external distance first chain ',chnmp1,' residue ',ires1,' ins ',ins1,' atom ',name1,' alt ',alt1, &
                 ' second  chain ',,chnmp2,' residue ',ires2,' ins ',ins2,' atom ',name2,' alt ',alt2,                           &
                 ' value ',dist,' sigma ',sigma,' type 2'
         enddo
      enddo
      close(iscr1,status='DELETE')
      close(iexte)

    return
  end subroutine generate_from_coordinates
end module external_restraints
