module lowlevel
  
contains
  subroutine parse_items_refmac(maxitems,nitems,line_in,ibeg,iend,ierr)
    implicit none
    !
    !--Parse line and find start and end poitns of items
    !
    !---  inputs
    integer mdoc,maxitems,nitems
    character(len=*), intent(inout) :: line_in
    !
    !--outputs
    integer ierr
    integer ibeg(maxitems),iend(maxitems)
    !
    !---  locals
    integer l,i,is,is1
    logical things_to_do
    !
    !---body

    call correct_line(line_in)
    l = len_trim(line_in)
    nitems = 0
    if(l.le.0) return
    !
    is = 1

    things_to_do = .TRUE.
    do while(things_to_do)
       things_to_do = .FALSE.
       do  i=is,l
          if(line_in(i:i).ne.' ') then
             nitems = nitems + 1
             if(nitems.gt.maxitems) then
                write(*,*)'Error==> Too many items in the line'
                ierr = 1
                return
             endif
             ibeg(nitems) = i
             exit
          endif
       enddo
       if(i.lt.l) then
          is1 = ibeg(nitems)
          do  i=is1,l
             if(line_in(i:i).eq.' ') then
                iend(nitems) = i-1
                is = i
                things_to_do = .TRUE.
                exit
             endif
          enddo
       endif
    enddo
    if(nitems.gt.0) iend(nitems) = l
    return
  end subroutine parse_items


  subroutine correct_line(line)
    implicit none
    !
    !  Checks line and replaces all special character with spaces
    character(len=*), intent(inout) :: line
    
    integer i,j,l
    logical correct_flag

    l = len_trim(line)
    if(l.le.0) then
       line = ' '
       return
    endif
    do i=1,l
       correct_flag = .TRUE.
       do j=32,126
          if(line(i:i).eq.char(j)) then
             correct_flag = .FALSE.
             exit
          endif
       enddo
       if(correct_flag) line(i:i) = ' '
    enddo
    
    return
  end subroutine correct_line
end module lowlevel
