C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE MAKE_CORRECTION_TO_CELL_DIFF(ORT_FRAC_OLD
     *                                    ,FRAC_TO_ORT_NEW,IERR)
C ---------------------------------------------------------- 
      REAL    ORT_FRAC_OLD(3,3),FRAC_TO_ORT_NEW(3,3)
      INTEGER IERR
C ----
      INCLUDE 'atom_com.fh'
C ----
      REAL    X(3)
C ---------------------------------------------------------- 
      IERR = 0
C ----
      DO I=1,N_ATOM
        CALL NB_MVMULT(ORT_FRAC_OLD,XYZ_CRD(1,I),X)
        CALL NB_MVMULT(FRAC_TO_ORT_NEW,X,XYZ_CRD(1,I))
      ENDDO

C ----
      RETURN
      END

      SUBROUTINE START_CCP4
C --------------------------------
C     dummy subroutine
C
      RETURN
      END

      SUBROUTINE SET_UNIT_CORR
C -------------------------------
C     in make_subr.f:
C                    in SUBROUTINE START: after CALL SET_UNIT_NUMBERS  
C
C -------------------------------
      RETURN
      END

      SUBROUTINE SET_LINK_CORR
C -------------------------------
C     in make_crd.f:
C                    in SUBROUTINE PRE_DESCR  
C
C -------------------------------
      RETURN
      END
                                   
C      SUBROUTINE GET_SYMM_NB_NEW(MDOC,NOSPGR,ISETT,SGNAME,NSYM
C     *                              ,SYM,TRANS,SYMOP,MAXNSO,IERR)

      SUBROUTINE GET_SYMM_NB_NEW(MDOC,NOSPGR,ISETT,SGNAME,NSYM
     *                              ,SYM,TRANS,MAX_NSO,IERR)
C -------------------------------------------------------
C -P- GET_SYMM - generate cryst.symm. oparators from space group name or space
C -P-            group number.
C -------------------------------------------------------
      INCLUDE 'atom_com.fh'
C -------------------------------------------------------
      INTEGER   MDOC,IERR
      INTEGER   MAX_NSO
      REAL      SYM(3,3,MAX_NSO)
      REAL      TRANS(3,MAX_NSO)

C     CHARACTER SYMOP(MAXNSO)*24

      INTEGER   NOSPGR,ISETT,NSYM
      CHARACTER SGNAME*(*)
C -----------------------------------     
      PI    = 4.0*ATAN(1.0)

C      CALL GET_SYMM_NB(MDOC,NOSPGR,ISETT,SGNAME,NSYM
C     *                              ,SYM,TRANS,SYMOP,MAXNSO,IERR)

      IF(NOSPGR.GT.0) THEN

        IF(NOSPGR.GT.1000) THEN

          ISETT  = NOSPGR/1000
          NOSPGR = NOSPGR - ISETT*1000
          ISETT  = ISETT + 1
          NOSG   = NOSPGR

          IF(NOSG.EQ.3.OR.NOSG.EQ.4.OR.NOSG.EQ.146.OR.
     *       NOSG.EQ.155) THEN
            IF(ISETT.EQ.1) THEN
              ISETT = 2
            ELSE IF(ISETT.EQ.2) THEN  
              ISETT = 1
            ENDIF
          ELSE IF(NOSG.EQ.  5) THEN
            IF(ISETT.EQ.1) THEN
              ISETT = 2
            ELSE IF(ISETT.EQ.2) THEN  
              ISETT = 3
            ELSE IF(ISETT.EQ.3) THEN  
              ISETT = 4
            ELSE IF(ISETT.EQ.4) THEN  
              ISETT = 1
            ENDIF
          ENDIF
        ENDIF

        IF(NOSPGR.LT.1.OR.NOSPGR.GT.230) THEN
          CALL MSGERR(MDOC
     *    ,' WARNING: wrong card "CRYST1" of PDB_file')
          CALL MSGERR(MDOC
     *    ,'          default space group: "P 1"')
          NOSPRG = 1
        ENDIF

      ENDIF

      IF(NOSPRG.EQ.146.OR.NOSPRG.EQ.155) THEN
        T= (PI*2.0)/3.0
        IF(ABS(CS_CELL(6)-T).LE.0.0001) ISETT = 2
      ENDIF
      IF(NOSPGR.GE.3.AND.NOSPGR.LE.15.AND.ISETT.EQ.1) THEN
C       ISETT = 1
        T     = PI/2.0
        IF(ABS(CS_CELL(6)-T).LE.0.0001) ISETT = 2
      ENDIF

      CALL GET_SYMM_NB(MDOC,NOSPGR,ISETT,SGNAME,NSYM
     *                              ,SYM,TRANS,MAX_NSO,IERR)

C ------------------------------------
      RETURN
      END

C ================================================================



C      SUBROUTINE GET_SYMM_NB(MDOC,NOSPGR,ISETT,SGNAME,NSYM
C     *                              ,SYM,TRANS,SYMOP,MAXNSO,IERR)

      SUBROUTINE GET_SYMM_NB_OLD(MDOC,NOSPGR,ISETT,SGNAME,NSYM
     *                              ,SYM,TRANS,MAXNSO,IERR)
C -------------------------------------------------------
C -P- GET_SYMM - generate cryst.symm. oparators from space group name or space
C -P-            group number.
C -------------------------------------------------------

      INTEGER   MDOC,IERR
      INTEGER   MAXNSO
      REAL      SYM(3,3,MAXNSO)
      REAL      TRANS(3,MAXNSO)

C     CHARACTER SYMOP(MAXNSO)*24

      INTEGER   NOSPGR,ISETT,NSYM
      CHARACTER SGNAME*(*)
C ******
C -------------
      CHARACTER LINE*80
C -----------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COM_SYM_FREAD/ 
     *                  FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
     *                 ,WORDS,IN_STRING
      REAL      FWORDS   (NWORDSMAX)
      INTEGER*4 LEN_WORDS(NWORDSMAX)
      INTEGER*4 IWORDS   (NWORDSMAX)
      INTEGER*4 NWORDS,IFRD_ERR
      CHARACTER WORDS(NWORDSMAX)*80
      CHARACTER IN_STRING*80
C -----------------------------------
      CHARACTER SP_GR*24,SYSTEM*16,FLAG*1
      CHARACTER PATH*256,FILE*256,EXT*256,STR*80
      INTEGER   NSS,NSYMR
C ------------------------------------
      INCLUDE 'crd_com.fh'
C ------------------------------------
      IERR=0
C ---
      IF(SGNAME.EQ.'P 1'.OR.SGNAME.EQ.'P1'.OR.NOSPGR.EQ.1) GO TO 700
C --------------------------------
      FLAG = 'N'
C ------
C     open file of symlib.blc
C     IUN = 45     
      IUN = CRSM_IUN
      M   = 99
C ----------------------------
      FILE = CRG_FILE
      CALL LENSTR_BL(FILE,LEN)
      IF(LEN.GT.0.AND.FILE(1:1).NE.' '.AND.FILE(1:1).NE.',') THEN 
        PATH = CRG_PATH
        EXT  = CRG_EXT
      ELSE
        PATH = CR_LIB_PATH
        FILE = 'symlib'
        EXT  = 'blc'
      ENDIF

      CALL OPENFR(IUN,M,PATH,FILE,EXT,IERR)
      CRSM_IUN = IUN
      IF(IERR.NE.0) THEN

        CALL MSGERR(MDOC,' ERROR: can''t open file: symlib')
        GO TO 200
      ENDIF
C -------
      CALL LENSTR_BL(SGNAME,LENS)
      IF(LENS.LE.0) THEN
        IF(NOSPGR.LE.0) THEN
C         default P1
          GO TO 100
        ELSE
C         --> use space group number
          GO TO 400
        ENDIF
      ENDIF
C ------------------------------------------
C     use space group name
C
      N = 0
      DO I=1,LENS
        IF(SGNAME(I:I).NE.' ') GO TO 600
        N = N + 1 
      ENDDO
  600 CONTINUE

      IF(N.GT.0) THEN
        DO I=1,LENS-N
          SGNAME(I:I) = SGNAME(I+N:I+N)
        ENDDO
        CALL LENSTR_BL(SGNAME,LENS)
      ENDIF
C -------
      FLAG = 'N'
      IF(LENS.LT.2) GO TO 400
  300 CONTINUE

      READ(IUN,'(A)',ERR=100,END=400) IN_STRING
      CALL LENSTR_BL(IN_STRING,LEN)
      IF(IN_STRING(1:1).EQ.'#'.OR.LEN.LE.0) GO TO 300

      CALL FRD_SYM_PARM

      IF(NWORDS.LT.7) GO TO 100
C     space group number
      NSG    = IWORDS (1)
C     number of symmetry operators
      NSM    = IWORDS (2)
C     space group name
      SP_GR  = WORDS  (7)
C     alternative space group name
      STR    = WORDS  (4)
C     setting
C     ISTT   = IWORDS (5)
      ISTT   = 0
      SYSTEM = WORDS  (6)

      CALL LENSTR_BL(SP_GR,LENR)
      CALL LENSTR_BL(STR  ,LENT)

      IF(LENS.EQ.LENR.AND.SP_GR(1:LENS).EQ.SGNAME(1:LENS)) THEN
       
      ELSE IF(LENS.EQ.LENT.AND.STR(1:LENS).EQ.SGNAME(1:LENS)) THEN
       
      ELSE IF(NWORDS.GT.7) THEN

        DO I=8,NWORDS
          STR = WORDS(I)
          CALL LENSTR_BL(STR,LENT)
          IF(LENT.EQ.LENS.AND.STR(1:LENS).EQ.SGNAME(1:LENS)) GO TO 330
        ENDDO
        GO TO 310
      ELSE
        GO TO 310
      ENDIF

 330  CONTINUE
C ----
      NSYM   = NSM
      NOSPGR = NSG
      ISETT  = ISTT 
C ----
      FLAG   = 'Y'
      IF(NSYM.GT.MAXNSO) THEN
        WRITE(LINE,
     *  '('' ERROR: number of cryst. symmetry operators >'',I6)') 
     *  MAXNSO
        CALL MSGERR(MDOC,LINE)
        IERR=1
        GO TO 100
      ENDIF

  310 CONTINUE
      IF(NSM.LE.0) GO TO 100

      DO  I=1,NSM

 320    CONTINUE
        READ(IUN,'(A)',ERR=100,END=400) IN_STRING
        CALL LENSTR_BL(IN_STRING,LEN)
        IF(IN_STRING(1:1).EQ.'#'.OR.LEN.LE.0) GO TO 320

        IF(FLAG.EQ.'Y') THEN
          CALL LENSTR_BL(IN_STRING,LEN)
          LINE  = IN_STRING(1:LEN)
          NSYMR = NSYM   
          NSS   = I

C          CALL SYMFR2(MDOC,LINE,NSS,NSYMR,ISYM,IPRSYM,IERR)

C          CALL SYMFR_NB(MDOC,LINE,NSS,NSYMR,SYM,TRANS
C     *    ,SYMOP,MAXNSO,IERR)

          CALL SYMFR_NB(MDOC,LINE,NSS,NSYMR,SYM,TRANS
     *    ,MAXNSO,IERR)

          IF(IERR.GT.0) RETURN
        ENDIF
      ENDDO   
      IF(FLAG.EQ.'Y') THEN
        GO TO 500
      ENDIF
      GO TO 300
C -----------------
C     use space group number
C
  400 CONTINUE

C ----
      IF(NOSPGR.LE.0) GO TO 100      
      IF(ISETT.LE.0.OR.ISETT.GT.9) ISETT = 1
C ----
      NOSG  = NOSPGR
      IF(NOSG.LE.0.OR.NOSG.GT.999) NOSG  = 1
      ISTT = ISETT
C ----
      IF(NOSG.EQ.  3.OR.NOSG.EQ.  4.OR.NOSG.EQ.146.OR.NOSG.EQ.155) THEN
        IF(ISTT.EQ.1) THEN
          ISTT = 2
        ELSE IF(ISTT.EQ.2) THEN  
          ISTT = 1
        ENDIF
      ELSE IF(NOSG.EQ.  5) THEN
        IF(ISTT.EQ.1) THEN
          ISTT = 4
        ELSE IF(ISTT.EQ.2) THEN  
          ISTT = 1
        ELSE IF(ISTT.EQ.3) THEN  
          ISTT = 2
        ELSE IF(ISTT.EQ.4) THEN  
          ISTT = 3
        ENDIF
      ENDIF
C ---
      IF(ISTT.GT.1) NOSG = (ISTT-1)*1000 + NOSG

      REWIND IUN

  410 CONTINUE

      READ(IUN,'(A)',ERR=100,END=100) IN_STRING
      CALL LENSTR_BL(IN_STRING,LEN)
      IF(IN_STRING(1:1).EQ.'#'.OR.LEN.LE.0) GO TO 410


      CALL FRD_SYM_PARM

      IF(NWORDS.LT.7) GO TO 100
C     space group number
      NSG    = IWORDS (1)
C     number of symmetry operators
      NSM    = IWORDS (2)
C     space group name
      SP_GR  = WORDS  (7)
C     alternative space group name
      STR    = WORDS  (4)
C     setting
C     ISTT   = IWORDS (5)
C     ISTT   = 0
      SYSTEM = WORDS  (6)

      CALL LENSTR_BL(SP_GR,LENR)

      IF(NSG.EQ.NOSG) THEN
        NSYM   = NSM
        SGNAME = SP_GR(1:LENR)
        LENS   = LENR

C        ISTT   = 1
C        IF(SYSTEM(1:4).EQ.'MONO') ISTT = 2
C        IF(NSG.EQ.1003.OR.NSG.EQ.1004.OR.NSG.EQ.3005.OR.
C     *     NSG.EQ.1146.OR.NSG.EQ.1155                   ) THEN
C          ISTT = 1
C        ELSE IF(NSG.EQ.  3.OR.NSG.EQ.  4.OR.NSG.EQ.5.OR.
C     *          NSG.EQ.146.OR.NSG.EQ.155                ) THEN
C          ISTT = 2
C        ENDIF

        FLAG  = 'Y'

C        ISETT = ISTT

        IF(NSYM.GT.MAXNSO.AND.FLAG.EQ.'Y') THEN
          WRITE(LINE,
     *    '('' ERROR: number of cryst. symmetry operators >'',I6)') 
     *    MAXNSO
          CALL MSGERR(MDOC,LINE)
          IERR = 1
          GO TO 100
        ENDIF
      ENDIF

      IF(NSM.LE.0) GO TO 100

      DO  I=1,NSM

 420    CONTINUE
        READ(IUN,'(A)',ERR=100,END=100) IN_STRING
        CALL LENSTR_BL(IN_STRING,LEN)
        IF(IN_STRING(1:1).EQ.'#'.OR.LEN.LE.0) GO TO 420

        IF(FLAG.EQ.'Y') THEN
          CALL LENSTR_BL(IN_STRING,LEN)
          LINE  = IN_STRING(1:LEN)
          NSYMR = NSYM   
          NSS   = I

C         CALL SYMFR2(MDOC,LINE,NSS,NSYMR,ISYM,IPRSYM,IERR)

C          CALL SYMFR_NB(MDOC,LINE,NSS,NSYMR,SYM,TRANS,SYMOP,MAXNSO
C     *    ,IERR)

          CALL SYMFR_NB(MDOC,LINE,NSS,NSYMR,SYM,TRANS,MAXNSO
     *    ,IERR)
          IF(IERR.GT.0) RETURN
        ENDIF
      ENDDO   
      IF(FLAG.EQ.'Y') THEN
        CLOSE(IUN)
        RETURN
      ENDIF

      GO TO 410

C -----
 100  CLOSE(CRSM_IUN)

 200  CONTINUE
      IERR       = 0
      NOSPGR     = 1
      ISETT      = 1
      NSYM       = 1
      SYM(1,1,1) = 1.0
      SYM(2,1,1) = 0.0
      SYM(3,1,1) = 0.0
      TRANS(1,1) = 0.0
      SYM(1,2,1) = 0.0
      SYM(2,2,1) = 1.0
      SYM(3,2,1) = 0.0
      TRANS(2,1) = 0.0
      SYM(1,3,1) = 0.0
      SYM(2,3,1) = 0.0
      SYM(3,3,1) = 1.0
      TRANS(3,1) = 0.0

C     SYMOP(1)   = 'X,Y,Z'

      CALL LENSTR_BL(PATH,LENP)
      IF(LENP.GT.0) THEN
        IF(LENP.GT.50) LENP = 50
      ELSE
        LENP = 1
        PATH = ' '
      ENDIF 

      CALL LENSTR_BL(FILE,LEN)
      IF(LEN.GT.0) THEN
        IF(LEN.GT.12) LEN = 12
      ELSE
        LEN  = 1
        FILE = ' '
      ENDIF 

      CALL LENSTR_BL(EXT,LENE)
      IF(LENE.GT.0) THEN
        IF(LENE.GT.6) LENE = 6
      ELSE
        LENE = 1
        EXT  = ' '
      ENDIF 

      LINE = ' WARNING: can''t find space group name in the file:'
      CALL MSGERR(MDOC,LINE)
      LINE = 
     * '          '//PATH(1:LENP)//FILE(1:LEN)//'.'//EXT(1:LENE)
      CALL MSGERR(MDOC,LINE)

      CALL LENSTR_BL(SGNAME,L)
      IF(L.GT.0) THEN
        IF(L.GT.12) L = 12
      ELSE
        L      = 1
        SGNAME = ' '
      ENDIF 
      LINE = '              -->'//SGNAME(1:L)//'<--'
      CALL MSGERR(MDOC,LINE)
      CALL MSGERR(MDOC,'        default space group is "P 1"')

      SGNAME     = 'P 1'
      IERR=-1

      RETURN
  500 CONTINUE

      ISTT = NSG/1000
      NOSG = NSG - ISTT*1000
      ISTT = ISTT + 1

      IF(NOSG.EQ.3.OR.NOSG.EQ.4.OR.NOSG.EQ.146.OR.NOSG.EQ.155) THEN
        IF(ISTT.EQ.1) THEN
          ISTT = 2
        ELSE IF(ISTT.EQ.2) THEN  
          ISTT = 1
        ENDIF
      ELSE IF(NOSG.EQ.  5) THEN
        IF(ISTT.EQ.1) THEN
          ISTT = 2
        ELSE IF(ISTT.EQ.2) THEN  
          ISTT = 3
        ELSE IF(ISTT.EQ.3) THEN  
          ISTT = 4
        ELSE IF(ISTT.EQ.4) THEN  
          ISTT = 1
        ENDIF
      ENDIF

      NOSPGR = NOSG
      ISETT  = ISTT 

      CLOSE(IUN)
      RETURN
C --------------------
 700  CONTINUE
      IERR       = 0
      SGNAME     = 'P 1'
      NOSPGR     = 1
      ISETT      = 1
      NSYM       = 1
      SYM(1,1,1) = 1.0
      SYM(2,1,1) = 0.0
      SYM(3,1,1) = 0.0
      TRANS(1,1) = 0.0
      SYM(1,2,1) = 0.0
      SYM(2,2,1) = 1.0
      SYM(3,2,1) = 0.0
      TRANS(2,1) = 0.0
      SYM(1,3,1) = 0.0
      SYM(2,3,1) = 0.0
      SYM(3,3,1) = 1.0
      TRANS(3,1) = 0.0

      RETURN
      END

      SUBROUTINE GET_SYMM_NB(MDOC,NOSPGR,ISETT,SGNAME,NSYM,SYM,TRANS
     *                              ,MAXNSO,IERR)
C -------------------------------------------------------
C -P- GET_SYMM - generate cryst.symm. oparators from space group name or space
C -P-            group number.
C -------------------------------------------------------
C --
C           input
C         nsg  sett  --> nsg sett' --> nsg+sett
C          3    1         3   2        1003
C          3    2         3   1           3
C          4    1         4   2        1004
C          4    2         4   1           4
C          5    1         5   4        3005               
C          5    2         5   1           5       
C          5    3         5   2        1005  
C          5    4         5   3        2005  
C        146    1 R     146   2        1146 R
C        146    2 H     146   1         146 H
C        155    1 R     155   2        1155 R
C        155    2 H     155   1         155 H
C --------------------------------------        
C
c      ISTT = NSG/1000
c      NOSG = NSG - ISTT*1000
c      ISTT = ISTT + 1
c
c      IF(NOSG.EQ.3.OR.NOSG.EQ.4.OR.NOSG.EQ.146.OR.NOSG.EQ.155) THEN
c        IF(ISTT.EQ.1) THEN
c          ISTT = 2
c        ELSE IF(ISTT.EQ.2) THEN  
c          ISTT = 1
c        ENDIF
c      ELSE IF(NOSG.EQ.  5) THEN
c        IF(ISTT.EQ.1) THEN
c          ISTT = 2
c        ELSE IF(ISTT.EQ.2) THEN  
c          ISTT = 3
c        ELSE IF(ISTT.EQ.3) THEN  
c          ISTT = 4
c        ELSE IF(ISTT.EQ.4) THEN  
c          ISTT = 1
c        ENDIF
c      ENDIF
c
c      NOSPGR = NOSG
c      ISETT  = ISTT 
C ---
C ---
C -------------------------------------------------------
      INTEGER   MDOC,IERR,MAXNSO
C --
C     INTEGER*2 ISYM(5,3,MAXNSO)
      INTEGER   NOSPGR,ISETT,NSYM
      REAL      SYM(3,3,MAXNSO)
      REAL      TRANS(3,MAXNSO)
      CHARACTER SGNAME*(*)
C -----------------------------------
      CHARACTER LINE*80
C -----------------------------------
      CHARACTER SG_TAB*24,SG_TAB1*24,SG_TAB2*24,OP*80
      INTEGER   III,I,IS,NSS,NSYMR,N,LENS,LEN
      INTEGER   NO_CCP4,NO_TAB,NS_TAB,NSG,L
C -------------------------------------------------------
      IERR = 0
      M    = 99
C ------------------------------------
      NSYM = 0
C ------------------------------------
      CALL LENSTR_BL(SGNAME,LENS)
      IF(LENS.LE.0) THEN
        IF(NOSPGR.LE.0) THEN
C         default P1
          GO TO 100
        ELSE
C         --> use space group number
          GO TO 400
        ENDIF
      ENDIF
C ------------------------------------------
C     use space group name
C
      N = 0
      DO I=1,LENS
        IF(SGNAME(I:I).NE.' ') GO TO 600
        N = N + 1 
      ENDDO
  600 CONTINUE

      IF(N.GT.0) THEN
        DO I=1,LENS-N
          SGNAME(I:I) = SGNAME(I+N:I+N)
        ENDDO
        CALL LENSTR_BL(SGNAME,LENS)
      ENDIF
      IF(LENS.LT.2) GO TO 400
C -----------------------------------------
      III = 0
  300 CONTINUE

      III = III + 1
      IS  = 0
      CALL GET_SPACE_GROUP_INFO(III,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB,SG_TAB1,SG_TAB2,OP,IERR)
      IF(IERR.NE.0) GO TO 400

C     space group number
      NO_CCP4 = NO_TAB 
C     number of symmetry operators
      NSYM    = NS_TAB
C     space group name

      CALL LENSTR_BL(SG_TAB,LEN)
      IF(LEN.GT.0) THEN
        IF(LENS.EQ.LEN.AND.SG_TAB(1:LENS).EQ.SGNAME(1:LENS)) GO TO 500
      ENDIF
      CALL LENSTR_BL(SG_TAB1,LEN)
      IF(LEN.GT.0) THEN
        IF(LENS.EQ.LEN.AND.SG_TAB1(1:LENS).EQ.SGNAME(1:LENS)) THEN
          CALL LENSTR_BL(SG_TAB,LEN)
          IF(LEN.GT.0) SGNAME = SG_TAB(1:LEN)
          GO TO 500
        ENDIF
      ENDIF
      CALL LENSTR_BL(SG_TAB2,LEN)
      IF(LEN.GT.0) THEN
        IF(LENS.EQ.LEN.AND.SG_TAB2(1:LENS).EQ.SGNAME(1:LENS)) THEN
          CALL LENSTR_BL(SG_TAB,LEN)
          IF(LEN.GT.0) SGNAME = SG_TAB(1:LEN)
          GO TO 500
        ENDIF
      ENDIF
      GO TO 300
C ----------------------------------------------------------
C     use space group number
C
  400 CONTINUE

C ----
      CALL NSG_STAND_TO_CCP4(NOSPGR,ISETT,NO_CCP4,IERR)
      IF(IERR.NE.0) GO TO 100      

      III = 0
  410 CONTINUE

      III = III + 1
      IS  = 0
      CALL GET_SPACE_GROUP_INFO(III,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB,SG_TAB1,SG_TAB2,OP,IERR)
      IF(IERR.NE.0) GO TO 100

C     space group number
      NSG    = NO_TAB
C     number of symmetry operators
      NSYM   = NS_TAB

      IF(NSG.EQ.NO_CCP4) THEN
        CALL LENSTR_BL(SG_TAB,LENR)
        SGNAME = SG_TAB(1:LENR)
        GO TO 500
      ENDIF

      GO TO 410
C --------------------------------
 500  CONTINUE
      IF(NSYM.GT.MAXNSO) THEN
        WRITE(LINE,
     *  '('' ERROR: number of cryst. symmetry operators >'',I6)') 
     *  MAXNSO
        CALL MSGERR(MDOC,LINE)
        IERR=1
        GO TO 100
      ELSE IF(NSYM.LE.0) THEN
        WRITE(LINE,
     *  '('' ERROR: number of cryst. symmetry operators =< 0'')')
        CALL MSGERR(MDOC,LINE)
        IERR=1
        GO TO 100
      ENDIF

      NSYMR = NSYM   
      DO  IS=1,NSYM
        CALL GET_SPACE_GROUP_INFO(III,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB,SG_TAB1,SG_TAB2,OP,IERR)
        IF(IERR.NE.0) GO TO 100
        NSS   = IS
        CALL SYMFR_NB(MDOC,OP,NSS,NSYMR,SYM,TRANS
     *                                      ,MAXNSO,IERR)
C        CALL SYMFR_NB(MDOC,OP,NSS,NSYMR,ISYM,MAXNSO,IERR)
        IF(IERR.GT.0) RETURN
      ENDDO 

c      write(*,*) '--no_ccp4:',NO_CCP4

      CALL NSG_CCP4_TO_STAND(NO_CCP4,NOSPGR,ISETT,IERR)

c      write(*,*) '-- No sg :',NOSPGR,ISETT
c        CALL LENSTR_BL(SGNAME,L)
c      write(*,*) '-sgname  :',SGNAME(1:L),'>'

      RETURN
C -----------------------------
 100  CONTINUE
      NOSPGR      = 1
      ISETT       = 1
      NSYM        = 1
      SYM(1,1,1) = 1.0
      SYM(2,1,1) = 0.0
      SYM(3,1,1) = 0.0
      TRANS(1,1) = 0.0
      SYM(1,2,1) = 0.0
      SYM(2,2,1) = 1.0
      SYM(3,2,1) = 0.0
      TRANS(2,1) = 0.0
      SYM(1,3,1) = 0.0
      SYM(2,3,1) = 0.0
      SYM(3,3,1) = 1.0
      TRANS(3,1) = 0.0

      LINE = ' WARNING: can''t find space group name'
      CALL MSGERR(MDOC,LINE)
      CALL LENSTR_BL(SGNAME,L)
      IF(L.GT.0) THEN
        IF(L.GT.12) L = 12
      ELSE
        L      = 1
        SGNAME = ' '
      ENDIF 
      LINE = '              -->'//SGNAME(1:L)//'<--'
      CALL MSGERR(MDOC,LINE)
      CALL MSGERR(MDOC,'        default space group is "P 1"')

      SGNAME     = 'P 1'
      IERR=-1
      RETURN
      END


      SUBROUTINE NSG_CCP4_TO_STAND(NO_CCP4,NO_STAND,IS_STAND,IERR)
C -----------------------------------------------------------
      INTEGER NO_STAND,IS_STAND,NO_CCP4
C -----------------------------------------------------------
      IERR     = 0
      NO_STAND = 0
      IS_STAND = 0
C ----------------------
      NSG  = NO_CCP4
      ISTT = NSG/1000
      NOSG = NSG - ISTT*1000
      ISTT = ISTT + 1

      IF(NOSG.EQ.3.OR.NOSG.EQ.4.OR.NOSG.EQ.146.OR.NOSG.EQ.155) THEN
        IF(ISTT.EQ.1) THEN
          ISTT = 2
        ELSE IF(ISTT.EQ.2) THEN  
          ISTT = 1
        ENDIF
      ELSE IF(NOSG.EQ.  5) THEN
        IF(ISTT.EQ.1) THEN
          ISTT = 2
        ELSE IF(ISTT.EQ.2) THEN  
          ISTT = 3
        ELSE IF(ISTT.EQ.3) THEN  
          ISTT = 4
        ELSE IF(ISTT.EQ.4) THEN  
          ISTT = 1
        ENDIF
      ENDIF
      NO_STAND = NOSG
      IS_STAND = ISTT 
C ---
      RETURN
      END

      SUBROUTINE NSG_STAND_TO_CCP4(NO_STAND,IS_STAND,NO_CCP4,IERR)
C -----------------------------------------------------------
      INTEGER NO_STAND,IS_STAND,NO_CCP4
C -----------------------------------------------------------
      IERR    = 0
      NO_CCP4 = 0
      NOSPGR  = NO_STAND
      IF(NOSPGR.LE.0.OR.NOSPGR.GT.230) THEN
        IERR = 1
        RETURN
      ENDIF      
      ISETT  = IS_STAND      
      IF(ISETT.LE.0.OR.ISETT.GT.9) ISETT = 1
C -------
      NOSG = NOSPGR
      ISTT = ISETT
C ----
      IF(NOSG.EQ.  3.OR.NOSG.EQ.  4.OR.NOSG.EQ.146.OR.NOSG.EQ.155) THEN
        IF(ISTT.EQ.1) THEN
          ISTT = 2
        ELSE IF(ISTT.EQ.2) THEN  
          ISTT = 1
        ENDIF
      ELSE IF(NOSG.EQ.  5) THEN
        IF(ISTT.EQ.1) THEN
          ISTT = 4
        ELSE IF(ISTT.EQ.2) THEN  
          ISTT = 1
        ELSE IF(ISTT.EQ.3) THEN  
          ISTT = 2
        ELSE IF(ISTT.EQ.4) THEN  
          ISTT = 3
        ENDIF
      ENDIF
C ---
      IF(ISTT.GT.1) NOSG = (ISTT-1)*1000 + NOSG
      NO_CCP4 = NOSG
C ---
      RETURN
      END 

C      SUBROUTINE SYMFR_NB(MDOC,LINE,NS,NSYM,SYM,TRANS,SYMOP,IPRSYM
C     * ,IERR)

      SUBROUTINE SYMFR_NB(MDOC,LINE,NS,NSYM,SYM,TRANS,IPRSYM
     * ,IERR)
C -------------------------------------------------------------
      REAL      SYM(3,3,IPRSYM)
      REAL      TRANS(3,IPRSYM)

C     CHARACTER SYMOP(IPRSYM)*24

      INTEGER   NSYM
      CHARACTER LINE*(*),STR*80
C 
      REAL      ROT(3,3),TR(3)
      INTEGER   NUM(10)      
      CHARACTER INUM(10)*1,ICH*1,S_OP*24
      DATA NUM / 1,  2,  3,  4,  5,  6,  7,  8,  9,  0 /
      DATA INUM/'1','2','3','4','5','6','7','8','9','0'/
C ---------------------------------------------------------------
      IERR = 0
      I1   = 1
      IF(LINE(1:1).EQ.'S') I1=6
      ISTR = I1
      CALL LENSTR_BL(LINE,LEN)
      IFN = LEN
      IF(LEN.LE.4) THEN
        IERR=1
      ENDIF

      L = IFN-ISTR+1
      IF(L.GT.24) L = 24
      IFN  = ISTR+L-1
      S_OP = LINE(ISTR:IFN)

      IMAX = LEN
      I    = I1-1
      NOP  = 1
      DO     J=1,3
        TR(J) = 0.0
        DO     K=1,3
          ROT(J,K) = 0.0
        ENDDO
      ENDDO
  117 S      = 1.0
      T      = 0.0
      IP     = 0
      J      = 0
      NP     = 0
      ISL    = 0
      IFOUND = 0

  100 I = I + 1
      IF(I.GT.IMAX)                 GO TO 110
      ICH  = LINE(I:I)
      IF(ICH.EQ.' ')                GO TO 100
      IF(ICH.EQ.','.OR. ICH.EQ.'*') GO TO 110
      IFOUND = 1

      IF(ICH.EQ.'X')  GO TO 105
      IF(ICH.EQ.'Y')  GO TO 106
      IF(ICH.EQ.'Z')  GO TO 107

      IF(ICH.EQ.'+')  GO TO 121
      IF(ICH.EQ.'-')  GO TO 122
      IF(ICH.EQ.'/')  GO TO 123
      IF(ICH.EQ.'.')  GO TO 124

      DO     K=1,10
        IF(ICH.EQ.INUM(K))  GO TO 102
      ENDDO

      WRITE(STR,9101) ICH
9101  FORMAT(' ERR: INVALID CHARACTER...',A1)
      CALL MSGERR(MDOC,STR)
      IERR=1
      GO TO 100
C ---- DIGIT
  102 A = NUM(K)
      IF(ISL.EQ.1)  GO TO 103
      IF(IP .EQ.1)  GO TO 104
      T = A*S
      GO TO 120
  103 T = T/A
      GO TO 120
  104 NP = NP + 1
      T  = T + A/10**NP
  120 TR(NOP) = T
      GO TO 100
C --- LETTER
  105 J = 1
      GO TO 108
  106 J = 2
      GO TO 108
 107  J = 3
 108  IF(T.NE.0.0) S = T
      ROT(J,NOP) = S
      T   = 0.0
      S   = 1.0
      ISL = 0
      IP  = 0
      NP  = 0
      GO TO 100
C ----------------------
C --- + ---
  121 S = 1.0
      GO TO 130
C --- - ---
  122 S = -1.0
  130 IF(T.NE.0.0.AND.J.EQ.0) THEN
        T = 0.0
      ENDIF
      GO TO 100
C --- / ---
  123 ISL = 1
      GO TO 100
C --- . ---
  124 IP = 1
      GO TO 100

  110 CONTINUE
      IF(J.NE.0.AND.T.NE.0.0) TR(NOP) = T
      J = 0     
      IF(IFOUND.EQ.0 .AND. I.LE.IMAX) THEN
        CALL MSGERR(MDOC,' ERR: BLANK OPERATOR FIELD')
      ENDIF
      NOP = NOP + 1
      IF(NOP.LE.3.AND.I.LE.IMAX) GO TO 117
      IF(NOP.EQ.4 .AND. IFOUND.EQ.0) THEN
        CALL MSGERR(MDOC,' ERR: LAST GENERAL POSITION IS INCOMPLETE')
        IERR=1
      ENDIF
      NSYM = NS

C     CALL LENSTR_BL(S_OP,LEN)
C     SYMOP(NS) = S_OP(1:LEN)

      SYM(1,1,NS) = ROT(1,1)
      SYM(1,2,NS) = ROT(2,1)
      SYM(1,3,NS) = ROT(3,1)
      SYM(2,1,NS) = ROT(1,2)
      SYM(2,2,NS) = ROT(2,2)
      SYM(2,3,NS) = ROT(3,2)
      SYM(3,1,NS) = ROT(1,3)
      SYM(3,2,NS) = ROT(2,3)
      SYM(3,3,NS) = ROT(3,3)
      TRANS(1,NS) = TR(1)
      TRANS(2,NS) = TR(2)
      TRANS(3,NS) = TR(3)

      RETURN
      END

      SUBROUTINE FRD_SYM_PARM
C -------------------------------------------------------
C -P- FRD_PARM - free format reading of the string of characters.
C                See common /COM_SYM_FREAD/
C
C     input:     IN_STRING - input string; a word is the part of the string
C                            between two blancs or two "'".
C     output:    NWORDS    - number of words of the string
C                IWORDS    - array of integer value of each word.
C                FWORDS    - array of real value of each word.
C                WORDS     - array of words
C                LEN_WORDS - array of lengths of the words
C                IFRD_ERR  - signal of error. 
C                            0  means OK.
C                            1 - number of words > NWORDSMAX = 40
C -----------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COM_SYM_FREAD/ 
     *                  FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
     *                 ,WORDS,IN_STRING
      REAL      FWORDS   (NWORDSMAX)
      INTEGER*4 LEN_WORDS(NWORDSMAX)
      INTEGER*4 IWORDS   (NWORDSMAX)
      INTEGER*4 NWORDS,IFRD_ERR
      CHARACTER WORDS(NWORDSMAX)*80
      CHARACTER IN_STRING*80
C --------------------------------------------------------------
      REAL      FA
      INTEGER*4 NW,IS,IW,IAP,LEN,IP,IA
      CHARACTER CH*1,CK*1,STR*80
C --------------------------------------------------------------
      IFRD_ERR = 0
      NWORDS   = 0
      NW       = 0
      IW       = 0
      IS       = 0
      IAP      = 0
      CALL LENSTR_BL(IN_STRING,LEN)
      IF(LEN.LE.0) RETURN
      IF(LEN.GT.80) LEN=80
C -----------------
      DO   IP=1,LEN
        CH=IN_STRING(IP:IP)
        CALL CHKSMB(CH,CK)
        IF(CK.EQ.'?') CH=' '
        IF(CH.EQ.'''') THEN
          IAP=IAP+1
          IF(IAP.GE.2) IAP=0
        ENDIF
        IF(CH.NE.' '.OR.IAP.EQ.1) THEN
C         start of a word
          IF(IS.EQ.0) THEN
            IS=1
            NW=NW+1
            IF(NW.GT.20) THEN
              IFRD_ERR=1
              RETURN
            ENDIF
          ENDIF
          IF(CH.NE.'''') THEN
            IW=IW+1
            STR(IW:IW)=CH       
          ELSE
            IF(IW.GT.0) THEN
            ENDIF
          ENDIF
        ENDIF
        IF((CH.EQ.' '.AND.IS.EQ.1.AND.IAP.EQ.0).OR.
     *       (IP.EQ.LEN.AND.IW.NE.0)) THEN
          IF(IW.LE.0) THEN
            WORDS(NW)     = '?'
            LEN_WORDS(NW) = 1
          ELSE
            WORDS(NW)     = STR(1:IW)
            LEN_WORDS(NW) = IW
          ENDIF
          NWORDS=NW
          CALL WTODIG(STR,IW,FA,IA)
          IWORDS(NW) = IA
          FWORDS(NW) = FA
          IS         = 0
          IW         = 0
          IAP        = 0
        ENDIF
      ENDDO
C -----------------
      RETURN
      END      

      SUBROUTINE SET_DEFAULT(LINE)
C ---------------------------------------------------------------
C     SET_DEFAULT - write info about the defaults, get the defaults 
C                   and go to batch mode.  
C ---------------------------------------------------------------
      CHARACTER LINE*(*)
C ---------------------------------------------------------------
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ----------------------------------------------------------------
      PARAMETER ( KEY_MAX = 40 )
C ---
      COMMON/COMASK/ IEND,NKEY,FLAG,STOR,STOR_KEY 
      INTEGER*4 FLAG(KEY_MAX),IEND,NKEY
      CHARACTER STOR(KEY_MAX)*256,STOR_KEY(KEY_MAX)*11
C ---
      COMMON/COMASK2/ NKEY_TEST,KEY_TEST
      INTEGER*4 NKEY_TEST
      CHARACTER KEY_TEST(KEY_MAX)*11
C ---------------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMFREAD_KEYWORDS/ 
     *                  FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
     *                 ,WORDS,IN_STRING
      REAL      FWORDS   (NWORDSMAX)
      INTEGER*4 LEN_WORDS(NWORDSMAX)
      INTEGER*4 IWORDS   (NWORDSMAX)
      INTEGER*4 NWORDS,IFRD_ERR
      CHARACTER WORDS(NWORDSMAX)*256
      CHARACTER IN_STRING*256
C --------------------------------------------------------------
C ---
      INTEGER*4 NL,NLK
      CHARACTER STR*256,KEY*80,K_TEST*11,CHAR1*1,IN_STRING2*256
      CHARACTER STR1*256,S_END*256
C ---------------------------------------------------------
      IF(IBATCH.NE.0) THEN
C       It is not interactive mode 
        RETURN
      ENDIF

      CALL LENSTR_BL(LINE,NL)
      IF(NL.GT.255) NL=255
      IF(NL.LE.0) THEN
        STR(1:1) = ' '
        NL       = 1
      ELSE
        STR = LINE(1:NL)
      ENDIF

      IWD = 0
      IWB = 0

      IF(STR(1:1).EQ.'?') THEN
C       first call of dialogue
        IF(NL.GT.2) THEN
          S_END  = STR(3:NL)
          NL_END = NL-2
        ELSE
          S_END  = ' '
          NL_END = 0
        ENDIF
        NKEY = 0
        DO I=1,KEY_MAX
          FLAG(I)=0
        ENDDO

        M=0
        CALL MSGDOC(M,'#---  type "keyword   parameters" and/or ---')
        CALL MSGDOC(M,'#---  press key "CR" to run program      ---')

 200    CONTINUE
C       start loop of dialogue

        IF(BAT_MODE.EQ.0) CALL DISPL_BL('-->')

C       read input line
        READ(*,'(A)') IN_STRING
        CALL LENSTR_BL(IN_STRING,L)
        IF(L.GT.0) THEN
          IFIRST     = 0
          II         = 0
          IN_STRING2 = ' '
          DO I=1,L
            IF(IFIRST.EQ.0.AND.IN_STRING(I:I).EQ.' ') THEN
            ELSE
              IFIRST = 1
              II     = II+1
              IN_STRING2(II:II) = IN_STRING(I:I)
            ENDIF
          ENDDO
          IN_STRING = IN_STRING2
          CALL LENSTR_BL(IN_STRING,L)
          IF(L.GT.0.AND.IN_STRING(1:1).EQ.'#') GO TO 200
C         comments or empty line
        ENDIF
        IF(L.LE.0.OR.IN_STRING(1:1).EQ.' '.OR.
     *  IN_STRING(1:4).EQ.'_END'.OR.IN_STRING(1:4).EQ.'_end') 
     *  GO TO 100
C       finish of dialogue
C ----
        CALL FRD_PARM_KEYWORDS
C ----
        IF(NWORDS.LE.0) GO TO 200

C       get key_word:  'word  <...> ' or '_word <...> '    
        KEY = WORDS(1)
        NLK = LEN_WORDS(1)
        IF(NLK.GE.1) THEN
          IF(KEY(1:1).NE.'_') THEN
C           first symbol must be '_' if not add it
            KEY = '_'//KEY(1:NLK)
            NLK = NLK + 1
          ELSE
            KEY = KEY(1:NLK)
          ENDIF
        ELSE
          KEY = ' '
          NLK = 1
        ENDIF
        
        IF(NLK.GT.12) NLK=12
        IF(NLK.LE.1) GO TO 200 
C       check keyword KEY and convert to uppercase
        CALL CHECK_LINE(1,KEY(1:NLK))

C       create string of parameters STR without keyword 
        DO I=1,L
          J = I+LEN_WORDS(1)-1
          IF(IN_STRING(I:J).EQ.WORDS(1)(1:LEN_WORDS(1))) THEN
            JJ = J+1
            IF(JJ.EQ.L) GO TO 200 
            STR = IN_STRING(JJ:L)
            NL  = L-J
            GO TO 300
          ENDIF
        ENDDO
        GO TO 200

 300    CONTINUE
C       remove last symbol ':' from keywords 
        IF(KEY(NLK:NLK).EQ.':') THEN
          KEY(NLK:NLK) = ' '
          NLK          = NLK-1
        ENDIF

C       creat correct string STR : 'keyword <parameters>'
        IF(NL.GT.0) THEN
          STR=KEY(1:NLK)//' '//STR(1:NL)
        ELSE
          STR=KEY(1:NLK)
        ENDIF
        CALL LENSTR_BL(STR,NL)
        IF(NL.GT.256) NL=256
        IF(NLK.GT.1) THEN
          IF(NKEY_TEST.GT.0) THEN
C           check with possible keywords / KEY_TEST(NKEY_TEST) /               
            IMODE  = 1
            K_TEST = KEY(2:NLK)
            NLKK   = NLK-1
            CALL CHECK_LINE(IMODE,K_TEST)
            DO I=1,NKEY_TEST
              CALL LENSTR_BL(KEY_TEST(I),LEN)
              IF(LEN.EQ.NLKK) THEN
                IF(KEY_TEST(I)(1:LEN).EQ.K_TEST(1:LEN)) GO TO 310
              ENDIF
            ENDDO

            L = LEN
            IF(L.GT.11) L = 11
            STR1 = ' WARNING: no such keyword :'//K_TEST(1:L)
            IF(L.GT.0) THEN
              CALL MSGERR(M,STR1)
            ELSE
              CALL MSGERR(M,' WARNING: no such keyword')
            ENDIF

            GO TO 200

 310        CONTINUE          
          ENDIF
        ENDIF

        IF(BAT_MODE.EQ.1) THEN
          MM = 1
          IF(NL.GT.0) CALL MSGDOC(MM,STR(1:NL))
        ENDIF


        IF(NKEY.GT.0) THEN
C         check with previous keywords 
C         if there is such keywords replace stored string STOR
          DO I=1,NKEY
            CALL LENSTR_BL(STOR_KEY(I),NLSK)
            IF(NLSK.EQ.NLK.AND.KEY(1:NLK).EQ.STOR_KEY(I)(1:NLK))THEN
              STOR(I)     = STR(1:max(1,NL))
              STOR_KEY(I) = KEY(1:NLK)
              GO TO 200
            ENDIF 
          ENDDO
        ENDIF
        IF(NKEY.LT.KEY_MAX) THEN
C         store new keyword in STOR_KEY and string STR in STOR
          NKEY           = NKEY+1
          FLAG(NKEY)     = 1
          STOR(NKEY)     = STR(1:max(1,NL))
          STOR_KEY(NKEY) = KEY(1:NLK)
        ENDIF

        GO TO 200

C       end loop of dialogue
C ----------------------------------
 100    CONTINUE
C       finish of dialogue
        
        IF(BATCH_FILE.GT.0.AND.NKEY.GT.0) THEN
C         write to batch file
          DO I=1,NKEY
            STR=STOR(I)
            CALL LENSTR_BL(STR,NL)
            IF(NL.LE.0) THEN
              NL=1
              STR=' '
            ELSE
              IF(NL.GT.256) NL=256
            ENDIF
            WRITE(BATCH_FILE,'(A)',ERR=10) STR(1:max(1,NL))
          ENDDO
        ENDIF

        IBATCH = 1
        IEND   = 1
        IWB    = 1
        IWD    = 0

        IF(NL_END.EQ.0) THEN
          STR   = '_END'
          NL    = 4
        ELSE
          STR = '_END'//S_END(1:NL_END)
          NL  = NL_END + 4
        ENDIF

      ELSE
C
C       it is possible keyword if string is : 'keyword: <....>'
C         or comment string
C   
        IF(STR(1:1).NE.' ') THEN
          N  = NL
          NK = 0
          IF(NL.GT.12) N = 12
          DO I=1,N
            IF(STR(I:I).EQ.':') THEN
              IF(NK.GT.0.AND.NKEY_TEST.LT.KEY_MAX) THEN
                NKEY_TEST           = NKEY_TEST + 1
                KEY_TEST(NKEY_TEST) = STR(1:NK)
              ENDIF
              GO TO 320 
            ENDIF
            NK = NK + 1
          ENDDO
        ENDIF
 320    CONTINUE       
        STR    = '#'//STR(1:NL)
        NL     = NL+1
        IWB    = 1
        IWD    = 1
      ENDIF


      IF(BATCH_FILE.GT.0.AND.IWB.GT.0) THEN
C       write to batch file
        CALL LENSTR_BL(STR,NL)
        IF(NL.LE.0) THEN
          NL  = 1
          STR = '#'
        ELSE
          IF(NL.GT.256) NL = 256
        ENDIF
        WRITE(BATCH_FILE,'(A)',ERR=10) STR(1:NL)
      ENDIF

      IF(IWD.GT.0) THEN
        M = 0
        CALL LENSTR_BL(STR,NL)
        IF(NL.LE.0) THEN
          NL  = 1
          STR = ' '
        ELSE
          IF(NL.GT.256) NL = 256
        ENDIF
        CALL MSGDOC(M,STR(1:NL))
      ENDIF
C ---
      RETURN
 10   M = 0
      CALL MSGERR(M,' ERROR: writing to batch file')
      CALL FINISH
      END

C ******
      SUBROUTINE FRD_PARM_KEYWORDS
C -------------------------------------------------------
C -P- FRD_PARM - free format reading of the string of characters.
C                See common /COMFREAD/
C
C     input:     IN_STRING - input string; a word is the part of the string
C                            between two blancs or two "'".
C     output:    NWORDS    - number of words of the string
C                IWORDS    - array of integer value of each word.
C                FWORDS    - array of real value of each word.
C                WORDS     - array of words
C                LEN_WORDS - array of lengths of the words
C                IFRD_ERR  - signal of error. 
C                            0  means OK.
C                            1 - number of words > NWORDSMAX = 40
C -----------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMFREAD_KEYWORDS/ 
     *                  FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
     *                 ,WORDS,IN_STRING
      REAL      FWORDS   (NWORDSMAX)
      INTEGER*4 LEN_WORDS(NWORDSMAX)
      INTEGER*4 IWORDS   (NWORDSMAX)
      INTEGER*4 NWORDS,IFRD_ERR
      CHARACTER WORDS(NWORDSMAX)*256
      CHARACTER IN_STRING*256
C --------------------------------------------------------------
C ******
      REAL      FA
      INTEGER*4 NW,IS,IW,IAP,LEN,IP,IA
      CHARACTER CH*1,CK*1,STR*256
C --------------------------------------------------------------
      IFRD_ERR=0
      NWORDS  =0
      NW      =0
      IW      =0
      IS      =0
      IAP     =0
      CALL LENSTR_BL(IN_STRING,LEN)
      IF(LEN.LE.0) RETURN
      IF(LEN.GT.256) LEN=256
C -----------------
      DO   IP=1,LEN
        CH=IN_STRING(IP:IP)
        CALL CHKSMB(CH,CK)
        IF(CK.EQ.'?') CH=' '
        IF(CH.EQ.'''') THEN
          IAP=IAP+1
          IF(IAP.GE.2) IAP=0
        ENDIF
        IF(CH.NE.' '.OR.IAP.EQ.1) THEN
C         start of a word
          IF(IS.EQ.0) THEN
            IS=1
            NW=NW+1
            IF(NW.GT.20) THEN
              IFRD_ERR=1
              RETURN
            ENDIF
          ENDIF
          IF(CH.NE.'''') THEN
            IW=IW+1
            STR(IW:IW)=CH       
          ELSE
            IF(IW.GT.0) THEN
            ENDIF
          ENDIF
        ENDIF
        IF((CH.EQ.' '.AND.IS.EQ.1.AND.IAP.EQ.0).OR.
     *       (IP.EQ.LEN.AND.IW.NE.0)) THEN
          IF(IW.LE.0) THEN
            WORDS(NW)='?'
            LEN_WORDS(NW)=1
          ELSE
            WORDS(NW)=STR(1:IW)
            LEN_WORDS(NW)=IW
          ENDIF
          NWORDS=NW
          CALL WTODIG(STR,IW,FA,IA)
          IWORDS(NW)=IA
          FWORDS(NW)=FA
          IS=0
          IW=0
          IAP=0
        ENDIF
      ENDDO
C -----------------
      RETURN
      END      

      SUBROUTINE ASK(LINE)
C --------------------------------------------------------------
C     ASK - read keyword (from input LINE) and get the default (output LINE).
C --------------------------------------------------------------
      CHARACTER LINE*(*)
C ---
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ------------------------------------------------------
      PARAMETER ( KEY_MAX = 40 )
C ------------------------------------------------------
      COMMON/COMASK/ IEND,NKEY,FLAG,STOR,STOR_KEY 
      INTEGER*4 FLAG(KEY_MAX),IEND,NKEY
      CHARACTER STOR(KEY_MAX)*256,STOR_KEY(KEY_MAX)*11
C --
      COMMON/COMASK2/ NKEY_TEST,KEY_TEST
      INTEGER*4 NKEY_TEST
      CHARACTER KEY_TEST(KEY_MAX)*11
C ---------------------------------------------------------
      INTEGER*4 NL,NLA,NLK
      CHARACTER STR*256,KEYR*12,KEY*12,ANS*256
C ---------------------------------------------------------

      MDOC = 0
      ANS  = ' '
      CALL LENSTR_BL(LINE,NLK)
      IF(NLK.GT.11) NLK=11
      
C     get keyword from input line
      IF(NLK.GE.1) THEN
        IF(LINE(NLK:NLK).EQ.':') THEN
          LINE(NLK:NLK) = ' '
          NLK           = NLK-1
        ENDIF
      ENDIF

      IF(NLK.GE.1) THEN
        KEY = '_'//LINE(1:NLK)
        NLK = NLK+1
      ELSE
        KEY = ' '
        NLK = 1
      ENDIF

      CALL CHECK_LINE(1,KEY)
C     now KEY is keyword      
     

      CALL LENSTR_BL(LINE,NL)
      IF(NL.GT.254) NL = 254
      IF(NL.LE.0) THEN
        LINE(1:1) = ' '
        NL        = 1
      ENDIF

      NL          = NL + 1
      LINE(NL:NL) = ':'

      IF(IBATCH.EQ.0) THEN
C       display keyword and ask parameters in iteractive mode
        IF(BAT_MODE.EQ.0) CALL DISPL_BL(LINE(1:NL))
      ENDIF
C ---
      IF(NLK.GT.1.AND.IBATCH.GT.0) THEN
C       not iterractive mode
C       search KEY in array of stored kewords STOR_KEY

        DO K=1,KEY_MAX
          IF(FLAG(K).GT.0) THEN
            CALL LENSTR_BL(STOR_KEY(K),NLSK)
            IF(NLSK.EQ.NLK.AND.KEY(1:NLK).EQ.STOR_KEY(K)(1:NLK))THEN
              ANS = STOR(K)
              CALL LENSTR_BL(ANS,NLA)
C             FLAG(K) = 0
              FLAG(K) = -1
              NKEY    = NKEY-1
              GO TO 200
            ENDIF
          ENDIF
        ENDDO

      ENDIF

            
 100  CONTINUE
      IF(IEND.GT.0) THEN
        IT = 2*KEY_MAX 
        IF(IEND.GT.IT) GO TO 20
        ANS(1:12) = ',,,,,,,,,,,,'
        NLA       = 12
        LINE      = ANS(1:NLA)
        IEND      = IEND + 1
        RETURN
      ENDIF

      LINE=' '
      READ(*,'(A)',ERR=10,END=20) LINE
      CALL LENSTR_BL(LINE,NLA)
      IF(NLA.GT.255) NLA = 255
      IF(NLA.LE.0) THEN
        LINE(1:12) = ',,,,,,,,,,,,'
        NLA        = 12
      ENDIF

      ANS=LINE(1:NLA)

      IF(ANS(1:4).EQ.'_END'.OR.ANS(1:4).EQ.'_end') THEN
        IEND = IEND + 1
        GO TO 100
      ENDIF

      IF(BAT_MODE.EQ.1) THEN
        M = 1
c        CALL LENSTR_BL(LINE,NLA)
c        IF(NLA.GT.255) NLA = 255
        IF(NLA.GT.0) CALL MSGDOC(M,LINE(1:NLA))
      ENDIF

 200  CONTINUE

      IF(ANS(1:1).EQ.'#') THEN
C       write to batch file
        IF(BATCH_FILE.GT.0) THEN
          WRITE(BATCH_FILE,'(A)') ANS(1:NLA)
        ENDIF
        GO TO 100
      ENDIF

      IF(NLK.GT.1.AND.ANS(1:1).EQ.'_') THEN
C       IBATCH = 1
        NLKR   = 0
        IF(NLA.GT.0) THEN
          DO I=1,NLA
            IF(ANS(I:I).NE.' ') THEN
              KEYR(I:I) = ANS(I:I)
              NLKR      = NLKR + 1
            ELSE
              GO TO 300
            ENDIF
          ENDDO
        ENDIF
 300    CONTINUE

C       IF(NLA.GE.NLK) THEN
C       KEYR = ANS(1:NLK)
          CALL CHECK_LINE(1,KEYR)
          IF(KEY(1:NLK).NE.KEYR(1:NLKR)) THEN
            DO K=1,KEY_MAX
              IF(FLAG(K).EQ.0) THEN
                IF(NLA.GT.NLKR) THEN
                  STOR(K)     = KEYR(1:NLKR)//' '//ANS(NLKR+2:NLA)
                  STOR_KEY(K) = KEYR(1:NLKR)
                ELSE
                  STOR(K)     = KEYR(1:NLKR)//'   '
                  STOR_KEY(K) = KEYR(1:NLKR)
                ENDIF
                FLAG(K) = 1
                NKEY    = NKEY + 1
                GO TO 100  
              ENDIF
            ENDDO
            GO TO 100
          ENDIF
C       ENDIF
        N= NLA - (NLKR+1)
        IF(N.LE.0) THEN
          ANS(1:12) = ',,,,,,,,,,'
          N         = 12
        ELSE
          K1       = NLKR+2
          K2       = K1 +N - 1
          ANS(1:N) = ANS(K1:K2)
        ENDIF
        NLA = N
      ENDIF
      
C -----
C     remove first blancs from answer string      
      J   = 0
      IFL = 0
      DO I=1,NLA
        IF(IFL.NE.0.OR.ANS(I:I).NE.' ') THEN
          J        = J+1
          IFL      = 1
          ANS(J:J) = ANS(I:I)
        ENDIF            
      ENDDO
      NLA     = J
      NLA_ANS = NLA
C ---
C     put several symbols ',' in the end of answer string 
      LINE    = ANS(1:NLA)
      IF(NLA.LE.245) THEN
        NLA               = NLA+6
        LINE(NLA+1:NLA+6) = ',,,,,,'
      ENDIF

      IF(BATCH_FILE.GT.0.AND.IEND.EQ.0) THEN
C       write to batch file
        IF(NLK.GT.1) THEN
          WRITE(BATCH_FILE,'(A)',ERR=30)
     *     KEY(1:NLK)//' '//ANS(1:NLA_ANS)
        ELSE
          WRITE(BATCH_FILE,'(A)',ERR=30) ANS(1:NLA_ANS)
        ENDIF
      ENDIF
C ---
      RETURN
C ---------------------------------------------------------
 10   CALL MSGERR(MDOC,' ERROR: read input stream')
      GO TO 1000
 20   CALL MSGERR(MDOC,' ERROR: end of input stream')
      GO TO 1000
 30   CALL MSGERR(MDOC,' ERROR: write to batch file')
 1000 CALL FINISH
      END


C ******
      SUBROUTINE CHECK_BATCH(IBAT)
C
C -P- CHECK_BAT - return info about mode / dialogue (0) or batch (1)/.
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ******
      INTEGER*4 IBAT
C ------
      IBAT = BAT_MODE
      RETURN
      END

C ******
      SUBROUTINE SET_BATCH(IBAT)
C
C -P- CHECK_BAT - return info about mode / dialogue (0) or batch (1)/.
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ******
      INTEGER*4 IBAT
C ------
      BAT_MODE = IBAT
      RETURN
      END

C ******
      SUBROUTINE SET_DOC_UNIT(IUNIT)
C
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ******
      INTEGER*4 IUNIT
C ------
      DOC_FILE = IUNIT
      RETURN
      END

      SUBROUTINE CORR_FILE_NAME(NAMEF)
C -------------------------------------------
      CHARACTER NAMEF*(*),NAME*256
C -------------------------------------------
      CALL LENSTR_BL(NAMEF,LEN)
      IF(LEN.GT.0.AND.NAMEF(1:1).NE.','.AND.NAMEF(1:1).NE.' ') THEN
        NAME = NAMEF(1:LEN)
        DO I=LEN,1,-1
          IF(NAME(I:I).EQ.',') THEN
            NAME(I:I)=' '
          ELSE
            IF(NAME(I:I).NE.' ') GO TO 100
          ENDIF 
        ENDDO
 100    CONTINUE
      ELSE
        NAME = ' '
      ENDIF
      NAMEF = NAME
      RETURN 
      END

C ******
      SUBROUTINE CLEAR_DEF
C
C -P- CLEAR_DEF - return dialogue mode.  
C
C ******
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
      PARAMETER ( KEY_MAX = 40 )
      COMMON/COMASK/ IEND,NKEY,FLAG,STOR,STOR_KEY 
      INTEGER*4 FLAG(KEY_MAX),IEND,NKEY
      CHARACTER STOR(KEY_MAX)*256,STOR_KEY(KEY_MAX)*11
      COMMON/COMASK2/ NKEY_TEST,KEY_TEST
      INTEGER*4 NKEY_TEST
      CHARACTER KEY_TEST(KEY_MAX)*11
C -----------------------------------------------------------
C     IF(BAT_MODE.GT.0) RETURN
      IEND      = 0
      IBATCH    = 0
      NKEY      = 0
      NKEY_TEST = 0
      DO I=1,KEY_MAX
        FLAG(I) = 0
      ENDDO
      RETURN
      END

C ******
      SUBROUTINE WRT_BATCH(LINE)
C
C -P- WRT_BATCH - write message to BATCH-FILE.
C
      CHARACTER LINE*(*)
C ******
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
      INTEGER*4 NL
      CHARACTER STR*80
C ---------------------------------------------------------
      IF(BATCH_FILE.GT.0) THEN
        CALL LENSTR_BL(LINE,NL)
        IF(NL.LE.0) THEN
          NL  = 1
          STR = ' '
        ELSE
c         IF(NL.GT.79) NL=79
          STR = LINE(1:NL)
        ENDIF
        WRITE(BATCH_FILE,'(A)',ERR=10) STR(1:NL)
      ENDIF
C ---
      RETURN
 10   CALL MSGERR(MDOC,' ERROR: write to BATCH_file')
      CALL FINISH
      END

      SUBROUTINE OPENDOC(MMDOC)
C
C -P- OPENDOC   open file-document iunit=DOC_FILE  =48
C                and file-inbatch  iunit=BATCH_FILE=47
C 
C     input :    MMDOC > 0  open, get name from terminal 
C                MMDOC < 0  open, get name from /COMLIB/..,LINEL,..  
C     output:    MMDOC , =0 don't open
C
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
      INTEGER*4  MMDOC,MDOC
C ******
      CHARACTER  NAME1*80,MSG*1,MSG4*1,FNAME*80,CH1*1,TYPE*1
      CHARACTER  NAMEB*80,NAME*80
      CHARACTER  LINE*80

CMS   LOGICAL*2  EXI

      LOGICAL    EXI
C ----------------------------
      INCLUDE 'crd_com.fh'
C ---------------------------------------------------------------------
C     DOC_FILE   = 0
C     BATCH_FILE = 0
C     BAT_MODE   = 0
  10  CONTINUE
      MDOC = MMDOC      
      IF(MDOC.GE.997) THEN
        NAME1 = LINEL
        IF(MDOC.EQ.997) NAME1='#'
      ELSE
        IF(MDOC.EQ.0.OR.ABS(MDOC).GE.99) RETURN
        DOC_FILE = ABS(MDOC)
        NAME1    = ' '
        IF(MDOC.GT.0) THEN
          WRITE(*,*) 
          CALL DISPL_BL(
     *    'FILE-DOCUMENT / tape name or CR / :')
          READ(*,'(A)')  NAME1
        ELSE
          NAME1=LINEL
        ENDIF
      ENDIF
  11  CH1=NAME1(1:1)

      CALL LENSTR_BL(NAME1,LEN)

      CALL CHKSMB(CH1,TYPE)
      IF(TYPE.EQ.'?'.OR.CH1.EQ.' '.OR.CH1.EQ.',') THEN
        NAME1(1:1)=' '
      ENDIF
      CALL LENSTR_BL(NAME1,LEN)
      IF(NAME1(1:1).EQ.'#') THEN
        IF(MDOC.GT.0) THEN
          READ(*,'(A)')  NAME1
          GO TO 11           
        ELSE
          DOC_FILE   = 0
          MDOC       = 0
          BATCH_FILE = 0
          MMDOC      = MDOC
          RETURN
        ENDIF
      ENDIF

      IF(NAME1(1:1).EQ.'_') THEN
        IF(NAME1(1:4).EQ.'_DOC') THEN
C
C         IBATCH  =1
C
          BAT_MODE=1
          CALL LENSTR_BL(NAME1,LEN)
          IF(LEN.GE.6) THEN
            J=0
            LINE=' '
            DO I=6,LEN
              IF(NAME1(I:I).NE.' ') THEN
                J=J+1
                LINE(J:J)=NAME1(I:I)
              ENDIF
            ENDDO
            CALL LENSTR_BL(LINE,LEN)
            NAME1=LINE(1:LEN)

            IF(MDOC.EQ.997) THEN
            IF(NAME1(1:1).EQ.'N'.OR.NAME1(1:1).EQ.'n') THEN
              MMDOC = 0
              RETURN
            ELSE IF(NAME1(1:1).EQ.'Y'.OR.NAME1(1:1).EQ.'y') THEN
              MDOC  = 999
              MMDOC = 999
              NAME1 = PROGRAMM
            ELSE IF(NAME1(1:1).EQ.'A'.OR.NAME1(1:1).EQ.'a') THEN
              MDOC  = 998
              MMDOC = 998
              NAME1 = PROGRAMM
            ENDIF
            ENDIF
          ELSE
            NAME1 = ' '
          ENDIF
        ENDIF
      ENDIF

      IF(NAME1(1:1).NE.' ') THEN
C --
        CALL LENSTR_BL(NAME1,LEN)
        IF(LEN.GT.0.AND.NAME1(1:1).NE.','.AND.NAME1(1:1).NE.' ') THEN
          NAME=NAME1(1:LEN)
          DO I=LEN,1,-1
            IF(NAME(I:I).EQ.',') THEN
              NAME(I:I)=' '
            ELSE
              IF(NAME(I:I).NE.' ') GO TO 800
            ENDIF 
          ENDDO
 800      CONTINUE
          LINE = NAME
          CALL LENSTR_BL(LINE,LEN)
          IF(LEN.GT.4.AND.LINE(LEN-3:LEN).EQ.'.doc') THEN
            NAME1 = LINE(1:LEN-4)
          ENDIF
        ENDIF
C -------

        CALL LENSTR_BL(NAME1,NL)

        FNAME = NAME1(1:NL)//'.doc'
        NAMEB = NAME1(1:NL)//'.btc'

        IF(MDOC.GT.0) THEN   

        INQUIRE(FILE=FNAME,EXIST=EXI)
        IF(EXI) THEN
C         DOC_FILE=48
          DOC_FILE = CRDOC_IUN
          OPEN(UNIT=DOC_FILE,FILE=FNAME,ACCESS='SEQUENTIAL',ERR=20,
     *         STATUS='OLD',FORM='FORMATTED') 
 50       CONTINUE
          IF(MMDOC.GE.998) THEN
C do not keep old contents : LINE(1:1)='N'
            LINE(1:1)='N'
            IF(MMDOC.EQ.998) LINE(1:1)='Y'
          ELSE
            CALL DISPL_BL(
     *      'Do you want to keep old contents (<Y>,N) ? :')
            READ(*,'(A)') LINE
          ENDIF
          IF(LINE(1:1).EQ.'_') THEN
            IF(LINE(1:5).EQ.'_KEEP') THEN
              CALL LENSTR_BL(LINE,LEN)
              IF(LEN.GE.7) THEN
                J=0
                DO I=7,LEN
                 IF(LINE(I:I).NE.' ') THEN
                   J=J+1
                   LINE(J:J)=LINE(I:I)
                   GO TO 100 
                 ENDIF
                ENDDO
              ENDIF
            ENDIF
          ENDIF
 100      CONTINUE
          MSG=LINE(1:1)
          IF(MSG.EQ.'#') GO TO 50
          IF(MSG.EQ.'n') MSG='N'
          IF(MSG.EQ.'N') THEN
            REWIND DOC_FILE
          ELSE
            DO   I=1,32767
              READ(DOC_FILE,'(A)',END=45) LINE
            ENDDO
   45       CONTINUE             
            BACKSPACE DOC_FILE
          ENDIF 
        ELSE
   30     CONTINUE
          IF(MDOC.GE.998) THEN
            LINE(1:1)='Y'
          ELSE
            CALL DISPL_BL(
     *'Do you really want to have DOC-file (<Y>,N) ?:')
            READ(*,'(A)') LINE
          ENDIF
          IF(LINE(1:1).EQ.'_') THEN
            IF(LINE(1:5).EQ.'_KEEP') THEN
              CALL LENSTR_BL(LINE,LEN)
              IF(LEN.GE.7) THEN
                J=0
                DO I=7,LEN
                 IF(LINE(I:I).NE.' ') THEN
                   J=J+1
                   LINE(J:J)=LINE(I:I)
                   GO TO 101 
                 ENDIF
                ENDDO
              ENDIF
            ENDIF
          ENDIF
 101      CONTINUE
          MSG4 = LINE(1:1)
          IF(MSG4.EQ.'#') GO TO 30
          IF(MSG4.EQ.'n') MSG4='N'
          IF(MSG4.NE.'N') THEN
            DOC_FILE=48
            OPEN(UNIT=DOC_FILE,FILE=FNAME,ACCESS='SEQUENTIAL',ERR=20,
     *          STATUS='UNKNOWN',FORM='FORMATTED')           
          ELSE 
            DOC_FILE   = 0
            MDOC       = 0
            BATCH_FILE = 0
          ENDIF 
        ENDIF

        ENDIF

      ELSE
        DOC_FILE   = 0
        MDOC       = 0
        BATCH_FILE = 0
      ENDIF

c     IF(DOC_FILE.NE.0.AND.MMDOC.NE.999) THEN

      IF(DOC_FILE.NE.0) THEN
C       BATCH_FILE=47
        BATCH_FILE = CRBAT_IUN
        INQUIRE(FILE=NAMEB,EXIST=EXI)
        IF(EXI) THEN
          OPEN(UNIT=BATCH_FILE,FILE=NAMEB,ACCESS='SEQUENTIAL',ERR=20,
     *         STATUS='OLD',FORM='FORMATTED')           
          IF(MSG.EQ.'N') THEN
            REWIND BATCH_FILE
          ELSE  
            DO   I=1,32767
              READ(BATCH_FILE,'(A)',END=46) LINE
            ENDDO
   46       CONTINUE             
            BACKSPACE BATCH_FILE
          ENDIF
        ELSE
          OPEN(UNIT=BATCH_FILE,FILE=NAMEB,ACCESS='SEQUENTIAL',ERR=20,
     *         STATUS='UNKNOWN',FORM='FORMATTED')           
        ENDIF 
      ENDIF
      WRITE(*,*)
      MDOC  = ABS(MDOC)
      MMDOC = MDOC
      RETURN

   20 WRITE(*,*) ' ERROR: OPEN DOC_FILE or BATCH_FILE'
      IF(MMDOC.LT.997) GO TO 10
      RETURN
      END


C ******
      SUBROUTINE OPENFR(IN,MDOC,PATH,FNAME,EXT,IERR)
C
C -P- OPENFR - open formatted file for read /with extention and path/
C
C       input:
C               IN    - unit
C               MDOC  - mode of writting messages to DOC-file
C                       0 - only term, < - 0 only file, 0 < < 99 - both
C                       >= 99 - not write  
C               PATH  - path      / may be = '    ' /
C               FNAME - file name
C               EXT   - extention / may be = '    ' /
C
C        output:
C               IERR = 0 - OK
C                    > 0 - error.
C
      INTEGER*4 IN,MDOC,IERR
      CHARACTER PATH*(*),FNAME*(*),EXT*(*)
C ******
      INTEGER*4 NLE,NLN,NLP,NL
      CHARACTER FILE*256,FILE1*256,LINE*80
      CHARACTER CH1*1,TYPE*1
C -------------------------------------------------------------
      IERR=0

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)

      CH1=FNAME(1:1)
      CALL CHKSMB(CH1,TYPE)
      IF(TYPE.EQ.'?'.OR.CH1.EQ.' '.OR.CH1.EQ.',') THEN
        FNAME(1:1)=' '
      ENDIF

      IF(NLN.GT.1) THEN
        DO I=2,NLN
          IF(FNAME(I:I).EQ.',') FNAME(I:I)=' '
        ENDDO
      ENDIF
      IF(NLP.GT.1) THEN
        DO I=2,NLP
          IF(PATH(I:I).EQ.',') PATH(I:I)=' '
        ENDDO
      ENDIF
      IF(NLE.GT.1) THEN
        DO I=2,NLE
          IF(EXT(I:I).EQ.',') EXT(I:I)=' '
        ENDDO
      ENDIF

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)
   


      IF(FNAME(1:1).EQ.' '.OR.NLN.LE.0) GO TO 9100

      IF(NLE.GT.0) THEN
        FILE1=FNAME(1:NLN)//'.'//EXT(1:NLE)
      ELSE
        FILE1=FNAME(1:NLN)
      ENDIF     
      CALL LENSTR_BL(FILE1,NL)
      IF(NLP.GT.0) THEN
        FILE=PATH(1:NLP)//FILE1(1:NL)
      ELSE
        FILE=FILE1(1:NL)
      ENDIF     
      CALL LENSTR_BL(FILE,NL)

      OPEN(IN,FILE=FILE(1:NL),ACCESS='SEQUENTIAL',ERR=9100,
     *  FORM='FORMATTED',STATUS='OLD')

      IF(NL.GT.65) NL=65
      WRITE(LINE,10) FILE(1:NL)
 10   FORMAT(' INPUT FILE :',A,';')
      CALL MSGDOC(MDOC,LINE)
      RETURN
C ----
9100  CONTINUE
      IF(NLE.GT.65) NLE=65
      IF(NLP.GT.65) NLP=65
      IF(NLN.GT.65) NLN=65
      CALL MSGERR(MDOC,' ERR: OPEN FILE /FOR READ/ ')
      IF(NLP.GT.0) THEN
        WRITE(LINE,20) PATH(1:NLP)
 20     FORMAT('        PATH :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLN.GT.0) THEN
        WRITE(LINE,30) FNAME(1:NLN)
 30     FORMAT('        NAME :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLE.GT.0) THEN
        WRITE(LINE,40) EXT(1:NLE)
 40     FORMAT('   EXTENTION :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IERR=1
      RETURN
      END

C ******
      SUBROUTINE OPENUR(IN,MDOC,PATH,FNAME,EXT,IERR)
C
C -P- OPENUR - open unformatted file for read /with extentiom and path/
C
C       input:
C               IN    - unit
C               MDOC  - mode of writting messages to DOC-file
C                       0 - only term, < - 0 only file, 0 < < 99 - both
C                       >= 99 - not write  
C               PATH  - path      / may be = '    ' /
C               FNAME - file name
C               EXT   - extention / may be = '    ' /
C
C        output:
C               IERR = 0 - OK
C                    > 0 - error.
C
      INTEGER*4 IN,MDOC,IERR
      CHARACTER PATH*(*),FNAME*(*),EXT*(*)
C ******
      INTEGER*4 NLE,NLN,NLP,NL
      CHARACTER FILE*256,FILE1*256,LINE*80
      CHARACTER CH1*1,TYPE*1
C -------------------------------------------------------------
      IERR=0

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)

      CH1=FNAME(1:1)
      CALL CHKSMB(CH1,TYPE)
      IF(TYPE.EQ.'?'.OR.CH1.EQ.' '.OR.CH1.EQ.',') THEN
        FNAME(1:1)=' '
      ENDIF


      IF(NLN.GT.1) THEN
        DO I=2,NLN
          IF(FNAME(I:I).EQ.',') FNAME(I:I)=' '
        ENDDO
      ENDIF
      IF(NLP.GT.1) THEN
        DO I=2,NLP
          IF(PATH(I:I).EQ.',') PATH(I:I)=' '
        ENDDO
      ENDIF
      IF(NLE.GT.1) THEN
        DO I=2,NLE
          IF(EXT(I:I).EQ.',') EXT(I:I)=' '
        ENDDO
      ENDIF

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)
   

      IF(FNAME(1:1).EQ.' '.OR.NLN.LE.0) GO TO 9100

      IF(NLE.GT.0) THEN
        FILE1=FNAME(1:NLN)//'.'//EXT(1:NLE)
      ELSE
        FILE1=FNAME(1:NLN)
      ENDIF     
      CALL LENSTR_BL(FILE1,NL)
      IF(NLP.GT.0) THEN
        FILE=PATH(1:NLP)//FILE1(1:NL)
      ELSE
        FILE=FILE1(1:NL)
      ENDIF     
      CALL LENSTR_BL(FILE,NL)

      OPEN(IN,FILE=FILE(1:NL),ACCESS='SEQUENTIAL',ERR=9100,
     *  FORM='UNFORMATTED',STATUS='OLD')

      IF(NL.GT.65) NL=65
      WRITE(LINE,10) FILE(1:NL)
 10   FORMAT(' INPUT FILE :',A,';')
      CALL MSGDOC(MDOC,LINE)
      RETURN
C ----
9100  CONTINUE
      IF(NLE.GT.65) NLE=65
      IF(NLP.GT.65) NLP=65
      IF(NLN.GT.65) NLN=65
      CALL MSGERR(MDOC,' ERR: OPEN FILE /FOR READ/ ')
      IF(NLP.GT.0) THEN
        WRITE(LINE,20) PATH(1:NLP)
 20     FORMAT('        PATH :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLN.GT.0) THEN
        WRITE(LINE,30) FNAME(1:NLN)
 30     FORMAT('        NAME :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLE.GT.0) THEN
        WRITE(LINE,40) EXT(1:NLE)
 40     FORMAT('   EXTENTION :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IERR=1
      RETURN
      END

C ******
      SUBROUTINE OPENFW(IOUT,MDOC,PATH,FNAME,EXT,IERR)
C
C -P- OPENFW - open formatted file for write /with extentiom and path/
C
C       input:
C               IOUT   - unit
C               MDOC  - mode of writting messages to DOC-file
C                       0 - only term, < - 0 only file, 0 < < 99 - both
C                       >= 99 - not write  
C               PATH  - path      / may be = '    ' /
C                       ( example of PATH='blanc/temp/' )
C               FNAME - file name
C               EXT   - extention / may be = '    ' /
C
C        output:
C               IERR = 0 - OK
C                    > 0 - error.
C
      INTEGER*4 IOUT,MDOC,IERR
      CHARACTER PATH*(*),FNAME*(*),EXT*(*)
C ******
      INTEGER*4 NLE,NLN,NLP,NL
      CHARACTER FILE*256,FILE1*256,LINE*80
      CHARACTER CH1*1,TYPE*1
C -------------------------------------------------------------
      IERR=0

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)

      CH1=FNAME(1:1)
      CALL CHKSMB(CH1,TYPE)
      IF(TYPE.EQ.'?'.OR.CH1.EQ.' '.OR.CH1.EQ.',') THEN
        FNAME(1:1)=' '
      ENDIF


      IF(NLN.GT.1) THEN
        DO I=2,NLN
          IF(FNAME(I:I).EQ.',') FNAME(I:I)=' '
        ENDDO
      ENDIF
      IF(NLP.GT.1) THEN
        DO I=2,NLP
          IF(PATH(I:I).EQ.',') PATH(I:I)=' '
        ENDDO
      ENDIF
      IF(NLE.GT.1) THEN
        DO I=2,NLE
          IF(EXT(I:I).EQ.',') EXT(I:I)=' '
        ENDDO
      ENDIF

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)

      IF(FNAME(1:1).EQ.' '.OR.NLN.LE.0) GO TO 9100

      IF(NLE.GT.0) THEN
        FILE1=FNAME(1:NLN)//'.'//EXT(1:NLE)
      ELSE
        FILE1=FNAME(1:NLN)
      ENDIF     
      CALL LENSTR_BL(FILE1,NL)
      IF(NLP.GT.0) THEN
        FILE=PATH(1:NLP)//FILE1(1:NL)
      ELSE
        FILE=FILE1(1:NL)
      ENDIF     
      CALL LENSTR_BL(FILE,NL)

      OPEN(IOUT,FILE=FILE(1:NL),ACCESS='SEQUENTIAL',ERR=9100,
     *  FORM='FORMATTED',STATUS='UNKNOWN')

      IF(NL.GT.65) NL=65
      WRITE(LINE,10) FILE(1:NL)
 10   FORMAT(' OUTPUT FILE :',A,';')
      CALL MSGDOC(MDOC,LINE)
      RETURN
C ----
9100  CONTINUE
      IF(NLE.GT.65) NLE=65
      IF(NLP.GT.65) NLP=65
      IF(NLN.GT.65) NLN=65
      CALL MSGERR(MDOC,' ERR: OPEN FILE /FOR WRITE/ ')
      IF(NLP.GT.0) THEN
        WRITE(LINE,20) PATH(1:NLP)
 20     FORMAT('        PATH :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLN.GT.0) THEN
        WRITE(LINE,30) FNAME(1:NLN)
 30     FORMAT('        NAME :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLE.GT.0) THEN
        WRITE(LINE,40) EXT(1:NLE)
 40     FORMAT('   EXTENTION :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IERR=1
      RETURN
      END

C ******
      SUBROUTINE OPENUW(IOUT,MDOC,PATH,FNAME,EXT,IERR)
C
C -P- OPENFW - open unformatted file for write /with extentiom and path/
C
C       input:
C               IN    - unit
C               MDOC  - mode of writting messages to DOC-file
C                       0 - only term, < - 0 only file, 0 < < 99 - both
C                       >= 99 - not write  
C               PATH  - path      / may be = '    ' /
C               FNAME - file name
C               EXT   - extention / may be = '    ' /
C
C        output:
C               IERR = 0 - OK
C                    > 0 - error.
C
      INTEGER*4 IOUT,MDOC,IERR
      CHARACTER PATH*(*),FNAME*(*),EXT*(*)
C ******
      INTEGER*4 NLE,NLN,NLP,NL
      CHARACTER FILE*256,FILE1*256,LINE*80
      CHARACTER CH1*1,TYPE*1
C -------------------------------------------------------------
      IERR=0

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)

      CH1=FNAME(1:1)
      CALL CHKSMB(CH1,TYPE)
      IF(TYPE.EQ.'?'.OR.CH1.EQ.' '.OR.CH1.EQ.',') THEN
        FNAME(1:1)=' '
      ENDIF


      IF(NLN.GT.1) THEN
        DO I=2,NLN
          IF(FNAME(I:I).EQ.',') FNAME(I:I)=' '
        ENDDO
      ENDIF
      IF(NLP.GT.1) THEN
        DO I=2,NLP
          IF(PATH(I:I).EQ.',') PATH(I:I)=' '
        ENDDO
      ENDIF
      IF(NLE.GT.1) THEN
        DO I=2,NLE
          IF(EXT(I:I).EQ.',') EXT(I:I)=' '
        ENDDO
      ENDIF

      CALL LENSTR_BL(EXT,NLE)
      CALL LENSTR_BL(PATH,NLP)
      CALL LENSTR_BL(FNAME,NLN)

      IF(FNAME(1:1).EQ.' '.OR.NLN.LE.0) GO TO 9100

      IF(NLE.GT.0) THEN
        FILE1=FNAME(1:NLN)//'.'//EXT(1:NLE)
      ELSE
        FILE1=FNAME(1:NLN)
      ENDIF     
      CALL LENSTR_BL(FILE1,NL)
      IF(NLP.GT.0) THEN
        FILE=PATH(1:NLP)//FILE1(1:NL)
      ELSE
        FILE=FILE1(1:NL)
      ENDIF     
      CALL LENSTR_BL(FILE,NL)

      OPEN(IOUT,FILE=FILE(1:NL),ACCESS='SEQUENTIAL',ERR=9100,
     *  FORM='UNFORMATTED',STATUS='UNKNOWN')

      IF(NL.GT.65) NL=65
      WRITE(LINE,10) FILE(1:NL)
 10   FORMAT(' OUTPUT FILE :',A,';')
      CALL MSGDOC(MDOC,LINE)
      RETURN
C ----
9100  CONTINUE
      IF(NLE.GT.65) NLE=65
      IF(NLP.GT.65) NLP=65
      IF(NLN.GT.65) NLN=65
      CALL MSGERR(MDOC,' ERR: OPEN FILE /FOR WRITE/ ')
      IF(NLP.GT.0) THEN
        WRITE(LINE,20) PATH(1:NLP)
 20     FORMAT('        PATH :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLN.GT.0) THEN
        WRITE(LINE,30) FNAME(1:NLN)
 30     FORMAT('        NAME :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IF(NLE.GT.0) THEN
        WRITE(LINE,40) EXT(1:NLE)
 40     FORMAT('   EXTENTION :',A,';')
        CALL MSGERR(MDOC,LINE)
      ENDIF
      IERR=1
      RETURN
      END

      SUBROUTINE CLOSE_BATCH(M)
C
C -P- CLOSE_BATCH - close BATCH-file.
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
C ******
      INTEGER*4 M
      CHARACTER LINE*80
C -------------------------
      IF(BATCH_FILE.GT.0) THEN
c        WRITE(LINE,20)       
c  20    FORMAT('_END   ')
c        CALL WRT_BATCH(LINE)
        LINE='stop'
        CALL WRT_BATCH(LINE)
        END FILE BATCH_FILE
        CLOSE(BATCH_FILE)
        BATCH_FILE=0
      ENDIF
      RETURN
      END          

C ******
      SUBROUTINE CLOSE_DOC(M)
C
C -P- CLOSE_DOC - close DOC-file.
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
C ******
      INTEGER*4 M
C -------------------------
      IF(DOC_FILE.GT.0) THEN
        END FILE DOC_FILE
        CLOSE(DOC_FILE)
      ENDIF
      RETURN
      END          


      SUBROUTINE FINISH
C -----------------------------------------------------------
C     FINISH - close DOC-file.
C -----------------------------------------------------------
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ------
      INTEGER*4 M,LEN
      CHARACTER LINE*80
C ------------------------------------------------------------
      M=-1      

      CALL LENSTR_BL(PROGRAMM,LEN)
      IF(LEN.LE.0) THEN
        LEN=1
        PROGRAMM(1:1)=' '
      ELSE IF(LEN.GT.20) THEN
        LEN=20
      ENDIF
      WRITE(LINE,10) PROGRAMM(1:LEN)      
  10  FORMAT(' **** END //////// ',A,' ///////// END ****')

      CALL MSGDOC(M,LINE)
      IF(DOC_FILE.GT.0) THEN
        END FILE DOC_FILE
        CLOSE(DOC_FILE)
      ENDIF

      IF(BATCH_FILE.GT.0) THEN
c        WRITE(LINE,20)       
c  20    FORMAT('_END   ')
c        CALL WRT_BATCH(LINE)
        LINE='stop'
        CALL WRT_BATCH(LINE)
        END FILE BATCH_FILE
        CLOSE(BATCH_FILE)
      ENDIF

C      CALL EXIT
      END          
C ******
      SUBROUTINE GET_SFA(ASYMB
     *      ,N,NEL,A1,A2,A3,A4,B1,B2,B3,B4,C,FI,FII,RAD,IERR)
C -----------------------------------------------
C -P- GET_SFA - gets atomic scatt.factor coefficients for atomic type.
C -S-
      REAL      A1,A2,A3,A4,B1,B2,B3,B4,C,FI,FII,RAD
      INTEGER*4 N,NEL,IERR
      CHARACTER ASYMB*4,CHAR4*4,TYPE*1
C ******
C ---
      REAL      TSF_A1(94),TSF_A2(94),TSF_A3 (94),TSF_A4 (94)
      REAL      TSF_B1(94),TSF_B2(94),TSF_B3 (94),TSF_B4 (94)
      REAL      TSF_C (94),TSF_FI(94),TSF_FII(94),TSF_RAD(94)
      INTEGER*4 TSF_N,TSF_NE(94)
      CHARACTER TSF_ATOM(94)*4
C ---
      DATA TSF_N /94/
      DATA TSF_ATOM( 1)/'H   '/,TSF_NE( 1)/ 1/,TSF_RAD( 1)/1.50/
     * ,TSF_A1( 1)/  0.49300/,TSF_B1( 1)/ 10.51091/
     * ,TSF_A2( 1)/  0.32291/,TSF_B2( 1)/ 26.12573/
     * ,TSF_A3( 1)/  0.14019/,TSF_B3( 1)/  3.14236/
     * ,TSF_A4( 1)/  0.04081/,TSF_B4( 1)/ 57.79977/
     * ,TSF_C ( 1)/  0.00304/
     * ,TSF_FI( 1)/  0.00000/,TSF_FII( 1)/  0.00000/
      DATA TSF_ATOM( 2)/'HE  '/,TSF_NE( 2)/ 2/,TSF_RAD( 2)/1.50/
     * ,TSF_A1( 2)/  0.87340/,TSF_B1( 2)/  9.10371/
     * ,TSF_A2( 2)/  0.63090/,TSF_B2( 2)/  3.35680/
     * ,TSF_A3( 2)/  0.31120/,TSF_B3( 2)/ 22.92763/
     * ,TSF_A4( 2)/  0.17800/,TSF_B4( 2)/  0.98210/
     * ,TSF_C ( 2)/  0.00640/
     * ,TSF_FI( 2)/  0.00000/,TSF_FII( 2)/  0.00000/
      DATA TSF_ATOM( 3)/'LI  '/,TSF_NE( 3)/ 3/,TSF_RAD( 3)/1.50/
     * ,TSF_A1( 3)/  1.12820/,TSF_B1( 3)/  3.95460/
     * ,TSF_A2( 3)/  0.75080/,TSF_B2( 3)/  1.05240/
     * ,TSF_A3( 3)/  0.61750/,TSF_B3( 3)/ 85.39058/
     * ,TSF_A4( 3)/  0.46530/,TSF_B4( 3)/168.26120/
     * ,TSF_C ( 3)/  0.03770/
     * ,TSF_FI( 3)/  0.00080/,TSF_FII( 3)/  0.00030/
      DATA TSF_ATOM( 4)/'BE  '/,TSF_NE( 4)/ 4/,TSF_RAD( 4)/1.50/
     * ,TSF_A1( 4)/  1.59190/,TSF_B1( 4)/ 43.64275/
     * ,TSF_A2( 4)/  1.12780/,TSF_B2( 4)/  1.86230/
     * ,TSF_A3( 4)/  0.53910/,TSF_B3( 4)/103.48310/
     * ,TSF_A4( 4)/  0.70290/,TSF_B4( 4)/  0.54200/
     * ,TSF_C ( 4)/  0.03850/
     * ,TSF_FI( 4)/  0.00380/,TSF_FII( 4)/  0.00140/
      DATA TSF_ATOM( 5)/'B   '/,TSF_NE( 5)/ 5/,TSF_RAD( 5)/1.50/
     * ,TSF_A1( 5)/  2.05450/,TSF_B1( 5)/ 23.21852/
     * ,TSF_A2( 5)/  1.33260/,TSF_B2( 5)/  1.02100/
     * ,TSF_A3( 5)/  1.09790/,TSF_B3( 5)/ 60.34987/
     * ,TSF_A4( 5)/  0.70680/,TSF_B4( 5)/  0.14030/
     * ,TSF_C ( 5)/ -0.19320/
     * ,TSF_FI( 5)/  0.00900/,TSF_FII( 5)/  0.00390/
      DATA TSF_ATOM( 6)/'C   '/,TSF_NE( 6)/ 6/,TSF_RAD( 6)/1.90/
     * ,TSF_A1( 6)/  2.31000/,TSF_B1( 6)/ 20.84392/
     * ,TSF_A2( 6)/  1.02000/,TSF_B2( 6)/ 10.20751/
     * ,TSF_A3( 6)/  1.58860/,TSF_B3( 6)/  0.56870/
     * ,TSF_A4( 6)/  0.86500/,TSF_B4( 6)/ 51.65125/
     * ,TSF_C ( 6)/  0.21560/
     * ,TSF_FI( 6)/  0.01810/,TSF_FII( 6)/  0.00910/
      DATA TSF_ATOM( 7)/'N   '/,TSF_NE( 7)/ 7/,TSF_RAD( 7)/1.70/
     * ,TSF_A1( 7)/ 12.21261/,TSF_B1( 7)/  0.00570/
     * ,TSF_A2( 7)/  3.13220/,TSF_B2( 7)/  9.89331/
     * ,TSF_A3( 7)/  2.01250/,TSF_B3( 7)/ 28.99754/
     * ,TSF_A4( 7)/  1.16630/,TSF_B4( 7)/  0.58260/
     * ,TSF_C ( 7)/-11.52901/
     * ,TSF_FI( 7)/  0.03110/,TSF_FII( 7)/  0.01800/
      DATA TSF_ATOM( 8)/'O   '/,TSF_NE( 8)/ 8/,TSF_RAD( 8)/1.40/
     * ,TSF_A1( 8)/  3.04850/,TSF_B1( 8)/ 13.27711/
     * ,TSF_A2( 8)/  2.28680/,TSF_B2( 8)/  5.70111/
     * ,TSF_A3( 8)/  1.54630/,TSF_B3( 8)/  0.32390/
     * ,TSF_A4( 8)/  0.86700/,TSF_B4( 8)/ 32.90894/
     * ,TSF_C ( 8)/  0.25080/
     * ,TSF_FI( 8)/  0.04920/,TSF_FII( 8)/  0.03220/
      DATA TSF_ATOM( 9)/'F   '/,TSF_NE( 9)/ 9/,TSF_RAD( 9)/1.50/
     * ,TSF_A1( 9)/  3.53920/,TSF_B1( 9)/ 10.28251/
     * ,TSF_A2( 9)/  2.64120/,TSF_B2( 9)/  4.29440/
     * ,TSF_A3( 9)/  1.51700/,TSF_B3( 9)/  0.26150/
     * ,TSF_A4( 9)/  1.02430/,TSF_B4( 9)/ 26.14763/
     * ,TSF_C ( 9)/  0.27760/
     * ,TSF_FI( 9)/  0.07270/,TSF_FII( 9)/  0.05340/
      DATA TSF_ATOM(10)/'NE  '/,TSF_NE( 10)/10/,TSF_RAD(10)/1.50/
     * ,TSF_A1(10)/  3.95530/,TSF_B1(10)/  8.40421/
     * ,TSF_A2(10)/  3.11250/,TSF_B2(10)/  3.42620/
     * ,TSF_A3(10)/  1.45460/,TSF_B3(10)/  0.23060/
     * ,TSF_A4(10)/  1.12510/,TSF_B4(10)/ 21.71841/
     * ,TSF_C (10)/  0.35150/
     * ,TSF_FI(10)/  0.10190/,TSF_FII(10)/  0.08330/
      DATA TSF_ATOM(11)/'NA  '/,TSF_NE(11)/11/,TSF_RAD(11)/1.50/
     * ,TSF_A1(11)/  4.76260/,TSF_B1(11)/  3.28500/
     * ,TSF_A2(11)/  3.17360/,TSF_B2(11)/  8.84221/
     * ,TSF_A3(11)/  1.26740/,TSF_B3(11)/  0.31360/
     * ,TSF_A4(11)/  1.11280/,TSF_B4(11)/129.42410/
     * ,TSF_C (11)/  0.67600/
     * ,TSF_FI(11)/  0.13530/,TSF_FII(11)/  0.12390/
      DATA TSF_ATOM(12)/'MG  '/,TSF_NE(12)/12/,TSF_RAD(12)/1.50/
     * ,TSF_A1(12)/  5.42041/,TSF_B1(12)/  2.82750/
     * ,TSF_A2(12)/  2.17350/,TSF_B2(12)/ 79.26118/
     * ,TSF_A3(12)/  1.22690/,TSF_B3(12)/  0.38080/
     * ,TSF_A4(12)/  2.30730/,TSF_B4(12)/  7.19371/
     * ,TSF_C (12)/  0.85840/
     * ,TSF_FI(12)/  0.17190/,TSF_FII(12)/  0.17710/
      DATA TSF_ATOM(13)/'AL  '/,TSF_NE(13)/13/,TSF_RAD(13)/1.50/
     * ,TSF_A1(13)/  6.42021/,TSF_B1(13)/  3.03870/
     * ,TSF_A2(13)/  1.90020/,TSF_B2(13)/  0.74260/
     * ,TSF_A3(13)/  1.59360/,TSF_B3(13)/ 31.54724/
     * ,TSF_A4(13)/  1.96460/,TSF_B4(13)/ 85.08868/
     * ,TSF_C (13)/  1.11510/
     * ,TSF_FI(13)/  0.21300/,TSF_FII(13)/  0.24550/
      DATA TSF_ATOM(14)/'SI  '/,TSF_NE(14)/14/,TSF_RAD(14)/1.50/
     * ,TSF_A1(14)/  6.29151/,TSF_B1(14)/  2.43860/
     * ,TSF_A2(14)/  3.03530/,TSF_B2(14)/ 32.33374/
     * ,TSF_A3(14)/  1.98910/,TSF_B3(14)/  0.67850/
     * ,TSF_A4(14)/  1.54100/,TSF_B4(14)/ 81.69379/
     * ,TSF_C (14)/  1.14070/
     * ,TSF_FI(14)/  0.25410/,TSF_FII(14)/  0.33020/
      DATA TSF_ATOM(15)/'P   '/,TSF_NE(15)/15/,TSF_RAD(15)/1.80/
     * ,TSF_A1(15)/  6.43451/,TSF_B1(15)/  1.90670/
     * ,TSF_A2(15)/  4.17910/,TSF_B2(15)/ 27.15704/
     * ,TSF_A3(15)/  1.78000/,TSF_B3(15)/  0.52600/
     * ,TSF_A4(15)/  1.49080/,TSF_B4(15)/ 68.16457/
     * ,TSF_C (15)/  1.11490/
     * ,TSF_FI(15)/  0.29550/,TSF_FII(15)/  0.43350/
      DATA TSF_ATOM(16)/'S   '/,TSF_NE(16)/16/,TSF_RAD(16)/1.80/
     * ,TSF_A1(16)/  6.90531/,TSF_B1(16)/  1.46790/
     * ,TSF_A2(16)/  5.20341/,TSF_B2(16)/ 22.21512/
     * ,TSF_A3(16)/  1.43790/,TSF_B3(16)/  0.25360/
     * ,TSF_A4(16)/  1.58630/,TSF_B4(16)/ 56.17207/
     * ,TSF_C (16)/  0.86690/
     * ,TSF_FI(16)/  0.33310/,TSF_FII(16)/  0.55670/
      DATA TSF_ATOM(17)/'CL  '/,TSF_NE(17)/17/,TSF_RAD(17)/1.50/
     * ,TSF_A1(17)/ 11.46041/,TSF_B1(17)/  0.01040/
     * ,TSF_A2(17)/  7.19641/,TSF_B2(17)/  1.16620/
     * ,TSF_A3(17)/  6.25561/,TSF_B3(17)/ 18.51942/
     * ,TSF_A4(17)/  1.64550/,TSF_B4(17)/ 47.77846/
     * ,TSF_C (17)/ -9.55741/
     * ,TSF_FI(17)/  0.36390/,TSF_FII(17)/  0.70180/
      DATA TSF_ATOM(18)/'AR  '/,TSF_NE(18)/18/,TSF_RAD(18)/1.50/
     * ,TSF_A1(18)/  7.48451/,TSF_B1(18)/  0.90720/
     * ,TSF_A2(18)/  6.77231/,TSF_B2(18)/ 14.84071/
     * ,TSF_A3(18)/  0.65390/,TSF_B3(18)/ 43.89835/
     * ,TSF_A4(18)/  1.64420/,TSF_B4(18)/ 33.39293/
     * ,TSF_C (18)/  1.44450/
     * ,TSF_FI(18)/  0.38430/,TSF_FII(18)/  0.87170/
      DATA TSF_ATOM(19)/'K   '/,TSF_NE(19)/19/,TSF_RAD(19)/1.50/
     * ,TSF_A1(19)/  8.21861/,TSF_B1(19)/ 12.79491/
     * ,TSF_A2(19)/  7.43981/,TSF_B2(19)/  0.77480/
     * ,TSF_A3(19)/  1.05190/,TSF_B3(19)/213.18719/
     * ,TSF_A4(19)/  0.86590/,TSF_B4(19)/ 41.68416/
     * ,TSF_C (19)/  1.42280/
     * ,TSF_FI(19)/  0.38680/,TSF_FII(19)/  1.06570/
      DATA TSF_ATOM(20)/'CA  '/,TSF_NE(20)/20/,TSF_RAD(20)/1.50/
     * ,TSF_A1(20)/  8.62661/,TSF_B1(20)/ 10.44211/
     * ,TSF_A2(20)/  7.38731/,TSF_B2(20)/  0.65990/
     * ,TSF_A3(20)/  1.58990/,TSF_B3(20)/ 85.74849/
     * ,TSF_A4(20)/  1.02110/,TSF_B4(20)/178.43719/
     * ,TSF_C (20)/  1.37510/
     * ,TSF_FI(20)/  0.36410/,TSF_FII(20)/  1.28550/
      DATA TSF_ATOM(21)/'SC  '/,TSF_NE(21)/21/,TSF_RAD(21)/1.50/
     * ,TSF_A1(21)/  9.18901/,TSF_B1(21)/  9.02131/
     * ,TSF_A2(21)/  7.36791/,TSF_B2(21)/  0.57290/
     * ,TSF_A3(21)/  1.64090/,TSF_B3(21)/136.10809/
     * ,TSF_A4(21)/  1.46800/,TSF_B4(21)/ 51.35315/
     * ,TSF_C (21)/  1.33290/
     * ,TSF_FI(21)/  0.31190/,TSF_FII(21)/  1.53310/
      DATA TSF_ATOM(22)/'TI  '/,TSF_NE(22)/22/,TSF_RAD(22)/1.50/
     * ,TSF_A1(22)/  9.75951/,TSF_B1(22)/  7.85081/
     * ,TSF_A2(22)/  7.35581/,TSF_B2(22)/  0.50000/
     * ,TSF_A3(22)/  1.69910/,TSF_B3(22)/ 35.63383/
     * ,TSF_A4(22)/  1.90210/,TSF_B4(22)/116.10510/
     * ,TSF_C (22)/  1.28070/
     * ,TSF_FI(22)/  0.21910/,TSF_FII(22)/  1.80690/
      DATA TSF_ATOM(23)/'V   '/,TSF_NE(23)/23/,TSF_RAD(23)/1.50/
     * ,TSF_A1(23)/ 10.29711/,TSF_B1(23)/  6.86571/
     * ,TSF_A2(23)/  7.35111/,TSF_B2(23)/  0.43850/
     * ,TSF_A3(23)/  2.07030/,TSF_B3(23)/ 26.89383/
     * ,TSF_A4(23)/  2.05710/,TSF_B4(23)/102.47810/
     * ,TSF_C (23)/  1.21990/
     * ,TSF_FI(23)/  0.06870/,TSF_FII(23)/  2.10970/
      DATA TSF_ATOM(24)/'CR  '/,TSF_NE(24)/24/,TSF_RAD(24)/1.50/
     * ,TSF_A1(24)/ 10.64061/,TSF_B1(24)/  6.10381/
     * ,TSF_A2(24)/  7.35371/,TSF_B2(24)/  0.39200/
     * ,TSF_A3(24)/  3.32400/,TSF_B3(24)/ 20.26262/
     * ,TSF_A4(24)/  1.49220/,TSF_B4(24)/ 98.73999/
     * ,TSF_C (24)/  1.18320/
     * ,TSF_FI(24)/ -0.16350/,TSF_FII(24)/  2.44390/
      DATA TSF_ATOM(25)/'MN  '/,TSF_NE(25)/25/,TSF_RAD(25)/1.50/
     * ,TSF_A1(25)/ 11.28191/,TSF_B1(25)/  5.34091/
     * ,TSF_A2(25)/  7.35731/,TSF_B2(25)/  0.34320/
     * ,TSF_A3(25)/  3.01930/,TSF_B3(25)/ 17.86742/
     * ,TSF_A4(25)/  2.24410/,TSF_B4(25)/ 83.75438/
     * ,TSF_C (25)/  1.08960/
     * ,TSF_FI(25)/ -0.52990/,TSF_FII(25)/  2.80520/
      DATA TSF_ATOM(26)/'FE  '/,TSF_NE(26)/26/,TSF_RAD(26)/1.50/
     * ,TSF_A1(26)/ 11.76951/,TSF_B1(26)/  4.76111/
     * ,TSF_A2(26)/  7.35731/,TSF_B2(26)/  0.30720/
     * ,TSF_A3(26)/  3.52220/,TSF_B3(26)/ 15.35351/
     * ,TSF_A4(26)/  2.30450/,TSF_B4(26)/ 76.88058/
     * ,TSF_C (26)/  1.03690/
     * ,TSF_FI(26)/ -1.13360/,TSF_FII(26)/  3.19740/
      DATA TSF_ATOM(27)/'CO  '/,TSF_NE(27)/27/,TSF_RAD(27)/1.50/
     * ,TSF_A1(27)/ 12.28411/,TSF_B1(27)/  4.27910/
     * ,TSF_A2(27)/  7.34091/,TSF_B2(27)/  0.27840/
     * ,TSF_A3(27)/  4.00340/,TSF_B3(27)/ 13.53591/
     * ,TSF_A4(27)/  2.34880/,TSF_B4(27)/ 71.16927/
     * ,TSF_C (27)/  1.01180/
     * ,TSF_FI(27)/ -2.36530/,TSF_FII(27)/  3.61430/
      DATA TSF_ATOM(28)/'NI  '/,TSF_NE(28)/28/,TSF_RAD(28)/1.50/
     * ,TSF_A1(28)/ 12.83761/,TSF_B1(28)/  3.87850/
     * ,TSF_A2(28)/  7.29201/,TSF_B2(28)/  0.25650/
     * ,TSF_A3(28)/  4.44380/,TSF_B3(28)/ 12.17631/
     * ,TSF_A4(28)/  2.38000/,TSF_B4(28)/ 66.34216/
     * ,TSF_C (28)/  1.03410/
     * ,TSF_FI(28)/ -3.00290/,TSF_FII(28)/  0.50910/
      DATA TSF_ATOM(29)/'CU  '/,TSF_NE(29)/29/,TSF_RAD(29)/1.50/
     * ,TSF_A1(29)/ 13.33801/,TSF_B1(29)/  3.58280/
     * ,TSF_A2(29)/  7.16761/,TSF_B2(29)/  0.24700/
     * ,TSF_A3(29)/  5.61581/,TSF_B3(29)/ 11.39661/
     * ,TSF_A4(29)/  1.67350/,TSF_B4(29)/ 64.81267/
     * ,TSF_C (29)/  1.19100/
     * ,TSF_FI(29)/ -1.96460/,TSF_FII(29)/  0.58880/
      DATA TSF_ATOM(30)/'ZN  '/,TSF_NE(30)/30/,TSF_RAD(30)/1.50/
     * ,TSF_A1(30)/ 14.07431/,TSF_B1(30)/  3.26550/
     * ,TSF_A2(30)/  7.03181/,TSF_B2(30)/  0.23330/
     * ,TSF_A3(30)/  5.16521/,TSF_B3(30)/ 10.31631/
     * ,TSF_A4(30)/  2.41000/,TSF_B4(30)/ 58.70976/
     * ,TSF_C (30)/  1.30410/
     * ,TSF_FI(30)/ -1.54910/,TSF_FII(30)/  0.67780/
      DATA TSF_ATOM(31)/'GA  '/,TSF_NE(31)/31/,TSF_RAD(31)/1.50/
     * ,TSF_A1(31)/ 15.23541/,TSF_B1(31)/  3.06690/
     * ,TSF_A2(31)/  6.70061/,TSF_B2(31)/  0.24120/
     * ,TSF_A3(31)/  4.35910/,TSF_B3(31)/ 10.78051/
     * ,TSF_A4(31)/  2.96230/,TSF_B4(31)/ 61.41357/
     * ,TSF_C (31)/  1.71890/
     * ,TSF_FI(31)/ -1.28460/,TSF_FII(31)/  0.77630/
      DATA TSF_ATOM(32)/'GE  '/,TSF_NE(32)/32/,TSF_RAD(32)/1.50/
     * ,TSF_A1(32)/ 16.08162/,TSF_B1(32)/  2.85090/
     * ,TSF_A2(32)/  6.37471/,TSF_B2(32)/  0.25160/
     * ,TSF_A3(32)/  3.70680/,TSF_B3(32)/ 11.44681/
     * ,TSF_A4(32)/  3.68300/,TSF_B4(32)/ 54.76256/
     * ,TSF_C (32)/  2.13130/
     * ,TSF_FI(32)/ -1.08850/,TSF_FII(32)/  0.88550/
      DATA TSF_ATOM(33)/'AS  '/,TSF_NE(33)/33/,TSF_RAD(33)/1.50/
     * ,TSF_A1(33)/ 16.67232/,TSF_B1(33)/  2.63450/
     * ,TSF_A2(33)/  6.07011/,TSF_B2(33)/  0.26470/
     * ,TSF_A3(33)/  3.43130/,TSF_B3(33)/ 12.94791/
     * ,TSF_A4(33)/  4.27790/,TSF_B4(33)/ 47.79726/
     * ,TSF_C (33)/  2.53100/
     * ,TSF_FI(33)/ -0.93000/,TSF_FII(33)/  1.00510/
      DATA TSF_ATOM(34)/'SE  '/,TSF_NE(34)/34/,TSF_RAD(34)/1.50/
     * ,TSF_A1(34)/ 17.00063/,TSF_B1(34)/  2.40980/
     * ,TSF_A2(34)/  5.81961/,TSF_B2(34)/  0.27260/
     * ,TSF_A3(34)/  3.97310/,TSF_B3(34)/ 15.23721/
     * ,TSF_A4(34)/  4.35430/,TSF_B4(34)/ 43.81635/
     * ,TSF_C (34)/  2.84090/
     * ,TSF_FI(34)/ -0.79430/,TSF_FII(34)/  1.13720/
      DATA TSF_ATOM(35)/'BR  '/,TSF_NE(35)/35/,TSF_RAD(35)/1.50/
     * ,TSF_A1(35)/ 17.17892/,TSF_B1(35)/  2.17230/
     * ,TSF_A2(35)/  5.23581/,TSF_B2(35)/ 16.57962/
     * ,TSF_A3(35)/  5.63771/,TSF_B3(35)/  0.26090/
     * ,TSF_A4(35)/  3.98510/,TSF_B4(35)/ 41.43285/
     * ,TSF_C (35)/  2.95570/
     * ,TSF_FI(35)/ -0.67630/,TSF_FII(35)/  1.28050/
      DATA TSF_ATOM(36)/'KR  '/,TSF_NE(36)/36/,TSF_RAD(36)/1.50/
     * ,TSF_A1(36)/ 17.35551/,TSF_B1(36)/  1.93840/
     * ,TSF_A2(36)/  6.72861/,TSF_B2(36)/ 16.56232/
     * ,TSF_A3(36)/  5.54931/,TSF_B3(36)/  0.22610/
     * ,TSF_A4(36)/  3.53750/,TSF_B4(36)/ 39.39723/
     * ,TSF_C (36)/  2.82500/
     * ,TSF_FI(36)/ -0.56570/,TSF_FII(36)/  1.43850/
      DATA TSF_ATOM(37)/'RB  '/,TSF_NE(37)/37/,TSF_RAD(37)/1.50/
     * ,TSF_A1(37)/ 17.17842/,TSF_B1(37)/  1.78880/
     * ,TSF_A2(37)/  9.64351/,TSF_B2(37)/ 17.31512/
     * ,TSF_A3(37)/  5.13990/,TSF_B3(37)/  0.27480/
     * ,TSF_A4(37)/  1.52920/,TSF_B4(37)/164.93420/
     * ,TSF_C (37)/  3.48730/
     * ,TSF_FI(37)/ -0.46880/,TSF_FII(37)/  1.60790/
      DATA TSF_ATOM(38)/'SR  '/,TSF_NE(38)/38/,TSF_RAD(38)/1.50/
     * ,TSF_A1(38)/ 17.56631/,TSF_B1(38)/  1.55640/
     * ,TSF_A2(38)/  9.81841/,TSF_B2(38)/ 14.09881/
     * ,TSF_A3(38)/  5.42200/,TSF_B3(38)/  0.16640/
     * ,TSF_A4(38)/  2.66940/,TSF_B4(38)/132.37610/
     * ,TSF_C (38)/  2.50640/
     * ,TSF_FI(38)/ -0.35280/,TSF_FII(38)/  1.82000/
      DATA TSF_ATOM(39)/'Y   '/,TSF_NE(39)/39/,TSF_RAD(39)/1.50/
     * ,TSF_A1(39)/ 17.77602/,TSF_B1(39)/  1.40290/
     * ,TSF_A2(39)/ 10.29461/,TSF_B2(39)/ 12.80061/
     * ,TSF_A3(39)/  5.72630/,TSF_B3(39)/  0.12560/
     * ,TSF_A4(39)/  3.26588/,TSF_B4(39)/104.35410/
     * ,TSF_C (39)/  1.91213/
     * ,TSF_FI(39)/ -0.26700/,TSF_FII(39)/  2.02440/
      DATA TSF_ATOM(40)/'ZR  '/,TSF_NE(40)/40/,TSF_RAD(40)/1.50/
     * ,TSF_A1(40)/ 17.87653/,TSF_B1(40)/  1.27618/
     * ,TSF_A2(40)/ 10.94801/,TSF_B2(40)/ 11.91601/
     * ,TSF_A3(40)/  5.41733/,TSF_B3(40)/  0.11762/
     * ,TSF_A4(40)/  3.65721/,TSF_B4(40)/ 87.66278/
     * ,TSF_C (40)/  2.06929/
     * ,TSF_FI(40)/ -0.18620/,TSF_FII(40)/  2.24490/
      DATA TSF_ATOM(41)/'NB  '/,TSF_NE(41)/41/,TSF_RAD(41)/1.50/
     * ,TSF_A1(41)/ 17.61423/,TSF_B1(41)/  1.18865/
     * ,TSF_A2(41)/ 12.01441/,TSF_B2(41)/ 11.76601/
     * ,TSF_A3(41)/  4.04183/,TSF_B3(41)/  0.20479/
     * ,TSF_A4(41)/  3.53346/,TSF_B4(41)/ 69.79576/
     * ,TSF_C (41)/  3.75591/
     * ,TSF_FI(41)/ -0.11210/,TSF_FII(41)/  2.48260/
      DATA TSF_ATOM(42)/'MO  '/,TSF_NE(42)/42/,TSF_RAD(42)/1.50/
     * ,TSF_A1(42)/  3.70250/,TSF_B1(42)/  0.27720/
     * ,TSF_A2(42)/ 17.23563/,TSF_B2(42)/  1.09580/
     * ,TSF_A3(42)/ 12.88761/,TSF_B3(42)/ 11.00401/
     * ,TSF_A4(42)/  3.74290/,TSF_B4(42)/ 61.65846/
     * ,TSF_C (42)/  4.38750/
     * ,TSF_FI(42)/ -0.04830/,TSF_FII(42)/  2.73390/
      DATA TSF_ATOM(43)/'TC  '/,TSF_NE(43)/43/,TSF_RAD(43)/1.50/
     * ,TSF_A1(43)/ 19.13013/,TSF_B1(43)/  0.86413/
     * ,TSF_A2(43)/ 11.09481/,TSF_B2(43)/  8.14488/
     * ,TSF_A3(43)/  4.64902/,TSF_B3(43)/ 21.57072/
     * ,TSF_A4(43)/  2.71263/,TSF_B4(43)/ 86.84727/
     * ,TSF_C (43)/  5.40429/
     * ,TSF_FI(43)/  0.00570/,TSF_FII(43)/  3.00490/
      DATA TSF_ATOM(44)/'RU  '/,TSF_NE(44)/44/,TSF_RAD(44)/1.50/
     * ,TSF_A1(44)/ 19.26743/,TSF_B1(44)/  0.80852/
     * ,TSF_A2(44)/ 12.91821/,TSF_B2(44)/  8.43468/
     * ,TSF_A3(44)/  4.86337/,TSF_B3(44)/ 24.79974/
     * ,TSF_A4(44)/  1.56756/,TSF_B4(44)/ 94.29289/
     * ,TSF_C (44)/  5.37875/
     * ,TSF_FI(44)/  0.05520/,TSF_FII(44)/  3.29600/
      DATA TSF_ATOM(45)/'RH  '/,TSF_NE(45)/45/,TSF_RAD(45)/1.50/
     * ,TSF_A1(45)/ 19.29572/,TSF_B1(45)/  0.75154/
     * ,TSF_A2(45)/ 14.35011/,TSF_B2(45)/  8.21759/
     * ,TSF_A3(45)/  4.73425/,TSF_B3(45)/ 25.87494/
     * ,TSF_A4(45)/  1.28918/,TSF_B4(45)/ 98.60629/
     * ,TSF_C (45)/  5.32800/
     * ,TSF_FI(45)/  0.09270/,TSF_FII(45)/  3.60450/
      DATA TSF_ATOM(46)/'PD  '/,TSF_NE(46)/46/,TSF_RAD(46)/1.50/
     * ,TSF_A1(46)/ 19.33192/,TSF_B1(46)/  0.69866/
     * ,TSF_A2(46)/ 15.50172/,TSF_B2(46)/  7.98930/
     * ,TSF_A3(46)/  5.29537/,TSF_B3(46)/ 25.20523/
     * ,TSF_A4(46)/  0.60584/,TSF_B4(46)/ 76.89868/
     * ,TSF_C (46)/  5.26593/
     * ,TSF_FI(46)/  0.12150/,TSF_FII(46)/  3.93370/
      DATA TSF_ATOM(47)/'AG  '/,TSF_NE(47)/47/,TSF_RAD(47)/1.50/
     * ,TSF_A1(47)/ 19.28082/,TSF_B1(47)/  0.64460/
     * ,TSF_A2(47)/ 16.68852/,TSF_B2(47)/  7.47261/
     * ,TSF_A3(47)/  4.80451/,TSF_B3(47)/ 24.66054/
     * ,TSF_A4(47)/  1.04630/,TSF_B4(47)/ 99.81570/
     * ,TSF_C (47)/  5.17900/
     * ,TSF_FI(47)/  0.13060/,TSF_FII(47)/  4.28200/
      DATA TSF_ATOM(48)/'CD  '/,TSF_NE(48)/48/,TSF_RAD(48)/1.50/
     * ,TSF_A1(48)/ 19.22142/,TSF_B1(48)/  0.59460/
     * ,TSF_A2(48)/ 17.64442/,TSF_B2(48)/  6.90891/
     * ,TSF_A3(48)/  4.46100/,TSF_B3(48)/ 24.70084/
     * ,TSF_A4(48)/  1.60290/,TSF_B4(48)/ 87.48257/
     * ,TSF_C (48)/  5.06941/
     * ,TSF_FI(48)/  0.11850/,TSF_FII(48)/  4.65330/
      DATA TSF_ATOM(49)/'IN  '/,TSF_NE(49)/49/,TSF_RAD(49)/1.50/
     * ,TSF_A1(49)/ 19.16241/,TSF_B1(49)/  0.54760/
     * ,TSF_A2(49)/ 18.55962/,TSF_B2(49)/  6.37761/
     * ,TSF_A3(49)/  4.29480/,TSF_B3(49)/ 25.84993/
     * ,TSF_A4(49)/  2.03960/,TSF_B4(49)/ 92.80299/
     * ,TSF_C (49)/  4.93911/
     * ,TSF_FI(49)/  0.08220/,TSF_FII(49)/  5.04490/
      DATA TSF_ATOM(50)/'SN  '/,TSF_NE(50)/50/,TSF_RAD(50)/1.50/
     * ,TSF_A1(50)/ 19.18892/,TSF_B1(50)/  5.83031/
     * ,TSF_A2(50)/ 19.10052/,TSF_B2(50)/  0.50310/
     * ,TSF_A3(50)/  4.45850/,TSF_B3(50)/ 26.89093/
     * ,TSF_A4(50)/  2.46630/,TSF_B4(50)/ 83.95718/
     * ,TSF_C (50)/  4.78211/
     * ,TSF_FI(50)/  0.02590/,TSF_FII(50)/  5.45910/
      DATA TSF_ATOM(51)/'SB  '/,TSF_NE(51)/51/,TSF_RAD(51)/1.50/
     * ,TSF_A1(51)/ 19.64182/,TSF_B1(51)/  5.30340/
     * ,TSF_A2(51)/ 19.04552/,TSF_B2(51)/  0.46070/
     * ,TSF_A3(51)/  5.03711/,TSF_B3(51)/ 27.90744/
     * ,TSF_A4(51)/  2.68270/,TSF_B4(51)/ 75.28258/
     * ,TSF_C (51)/  4.59091/
     * ,TSF_FI(51)/ -0.05620/,TSF_FII(51)/  5.89460/
      DATA TSF_ATOM(52)/'TE  '/,TSF_NE(52)/52/,TSF_RAD(52)/1.50/
     * ,TSF_A1(52)/ 19.96442/,TSF_B1(52)/  4.81742/
     * ,TSF_A2(52)/ 19.01382/,TSF_B2(52)/  0.42089/
     * ,TSF_A3(52)/  6.14488/,TSF_B3(52)/ 28.52844/
     * ,TSF_A4(52)/  2.52390/,TSF_B4(52)/ 70.84036/
     * ,TSF_C (52)/  4.35200/
     * ,TSF_FI(52)/ -0.17590/,TSF_FII(52)/  6.35310/
      DATA TSF_ATOM(53)/'I   '/,TSF_NE(53)/53/,TSF_RAD(53)/1.50/
     * ,TSF_A1(53)/ 20.14722/,TSF_B1(53)/  4.34700/
     * ,TSF_A2(53)/ 18.99492/,TSF_B2(53)/  0.38140/
     * ,TSF_A3(53)/  7.51381/,TSF_B3(53)/ 27.76604/
     * ,TSF_A4(53)/  2.27350/,TSF_B4(53)/ 66.87767/
     * ,TSF_C (53)/  4.07120/
     * ,TSF_FI(53)/ -0.32570/,TSF_FII(53)/  6.83620/
      DATA TSF_ATOM(54)/'XE  '/,TSF_NE(54)/54/,TSF_RAD(54)/1.50/
     * ,TSF_A1(54)/ 20.29332/,TSF_B1(54)/  3.92820/
     * ,TSF_A2(54)/ 19.02982/,TSF_B2(54)/  0.34400/
     * ,TSF_A3(54)/  8.97671/,TSF_B3(54)/ 26.46594/
     * ,TSF_A4(54)/  1.99000/,TSF_B4(54)/ 64.26587/
     * ,TSF_C (54)/  3.71180/
     * ,TSF_FI(54)/ -0.51790/,TSF_FII(54)/  7.35000/
      DATA TSF_ATOM(55)/'CS  '/,TSF_NE(55)/55/,TSF_RAD(55)/1.50/
     * ,TSF_A1(55)/ 20.38922/,TSF_B1(55)/  3.56900/
     * ,TSF_A2(55)/ 19.10622/,TSF_B2(55)/  0.31070/
     * ,TSF_A3(55)/ 10.66201/,TSF_B3(55)/ 24.38794/
     * ,TSF_A4(55)/  1.49530/,TSF_B4(55)/213.90421/
     * ,TSF_C (55)/  3.33520/
     * ,TSF_FI(55)/ -0.74570/,TSF_FII(55)/  7.90520/
      DATA TSF_ATOM(56)/'BA  '/,TSF_NE(56)/56/,TSF_RAD(56)/1.50/
     * ,TSF_A1(56)/ 20.33612/,TSF_B1(56)/  3.21600/
     * ,TSF_A2(56)/ 19.29703/,TSF_B2(56)/  0.27560/
     * ,TSF_A3(56)/ 10.88801/,TSF_B3(56)/ 20.20732/
     * ,TSF_A4(56)/  2.69590/,TSF_B4(56)/167.20219/
     * ,TSF_C (56)/  2.77310/
     * ,TSF_FI(56)/ -1.04560/,TSF_FII(56)/  8.46170/
      DATA TSF_ATOM(57)/'LA  '/,TSF_NE(57)/57/,TSF_RAD(57)/1.50/
     * ,TSF_A1(57)/ 20.57802/,TSF_B1(57)/  2.94817/
     * ,TSF_A2(57)/ 19.59901/,TSF_B2(57)/  0.24448/
     * ,TSF_A3(57)/ 11.37271/,TSF_B3(57)/ 18.77261/
     * ,TSF_A4(57)/  3.28719/,TSF_B4(57)/133.12410/
     * ,TSF_C (57)/  2.14678/
     * ,TSF_FI(57)/ -1.40940/,TSF_FII(57)/  9.03760/
      DATA TSF_ATOM(58)/'CE  '/,TSF_NE(58)/58/,TSF_RAD(58)/1.50/
     * ,TSF_A1(58)/ 21.16711/,TSF_B1(58)/  2.81219/
     * ,TSF_A2(58)/ 19.76952/,TSF_B2(58)/  0.22684/
     * ,TSF_A3(58)/ 11.85131/,TSF_B3(58)/ 17.60832/
     * ,TSF_A4(58)/  3.33049/,TSF_B4(58)/127.11310/
     * ,TSF_C (58)/  1.86264/
     * ,TSF_FI(58)/ -1.84820/,TSF_FII(58)/  9.65960/
      DATA TSF_ATOM(59)/'PR  '/,TSF_NE(59)/59/,TSF_RAD(59)/1.50/
     * ,TSF_A1(59)/ 22.04402/,TSF_B1(59)/  2.77393/
     * ,TSF_A2(59)/ 19.66972/,TSF_B2(59)/  0.22209/
     * ,TSF_A3(59)/ 12.38561/,TSF_B3(59)/ 16.76692/
     * ,TSF_A4(59)/  2.82428/,TSF_B4(59)/143.64410/
     * ,TSF_C (59)/  2.05830/
     * ,TSF_FI(59)/ -2.41640/,TSF_FII(59)/ 10.28200/
      DATA TSF_ATOM(60)/'ND  '/,TSF_NE(60)/60/,TSF_RAD(60)/1.50/
     * ,TSF_A1(60)/ 22.68452/,TSF_B1(60)/  2.66248/
     * ,TSF_A2(60)/ 19.68472/,TSF_B2(60)/  0.21063/
     * ,TSF_A3(60)/ 12.77401/,TSF_B3(60)/ 15.88502/
     * ,TSF_A4(60)/  2.85137/,TSF_B4(60)/137.90311/
     * ,TSF_C (60)/  1.98486/
     * ,TSF_FI(60)/ -3.18070/,TSF_FII(60)/ 10.90790/
      DATA TSF_ATOM(61)/'PM  '/,TSF_NE(61)/61/,TSF_RAD(61)/1.50/
     * ,TSF_A1(61)/ 23.34052/,TSF_B1(61)/  2.56270/
     * ,TSF_A2(61)/ 19.60953/,TSF_B2(61)/  0.20209/
     * ,TSF_A3(61)/ 13.12351/,TSF_B3(61)/ 15.10091/
     * ,TSF_A4(61)/  2.87516/,TSF_B4(61)/132.72110/
     * ,TSF_C (61)/  2.02876/
     * ,TSF_FI(61)/ -4.05980/,TSF_FII(61)/ 11.55230/
      DATA TSF_ATOM(62)/'SM  '/,TSF_NE(62)/62/,TSF_RAD(62)/1.50/
     * ,TSF_A1(62)/ 24.00424/,TSF_B1(62)/  2.47274/
     * ,TSF_A2(62)/ 19.42583/,TSF_B2(62)/  0.19645/
     * ,TSF_A3(62)/ 13.43961/,TSF_B3(62)/ 14.39961/
     * ,TSF_A4(62)/  2.89604/,TSF_B4(62)/128.00710/
     * ,TSF_C (62)/  2.20963/
     * ,TSF_FI(62)/ -5.32360/,TSF_FII(62)/ 12.21780/
      DATA TSF_ATOM(63)/'EU  '/,TSF_NE(63)/63/,TSF_RAD(63)/1.50/
     * ,TSF_A1(63)/ 24.62744/,TSF_B1(63)/  2.38790/
     * ,TSF_A2(63)/ 19.08862/,TSF_B2(63)/  0.19420/
     * ,TSF_A3(63)/ 13.76031/,TSF_B3(63)/ 13.75461/
     * ,TSF_A4(63)/  2.92270/,TSF_B4(63)/123.17410/
     * ,TSF_C (63)/  2.57450/
     * ,TSF_FI(63)/ -8.92940/,TSF_FII(63)/ 11.18570/
      DATA TSF_ATOM(64)/'GD  '/,TSF_NE(64)/64/,TSF_RAD(64)/1.50/
     * ,TSF_A1(64)/ 25.07094/,TSF_B1(64)/  2.25341/
     * ,TSF_A2(64)/ 19.07982/,TSF_B2(64)/  0.18195/
     * ,TSF_A3(64)/ 13.85181/,TSF_B3(64)/ 12.93311/
     * ,TSF_A4(64)/  3.54545/,TSF_B4(64)/101.39810/
     * ,TSF_C (64)/  2.41960/
     * ,TSF_FI(64)/ -8.83800/,TSF_FII(64)/ 11.91570/
      DATA TSF_ATOM(65)/'TB  '/,TSF_NE(65)/65/,TSF_RAD(65)/1.50/
     * ,TSF_A1(65)/ 25.89763/,TSF_B1(65)/  2.24256/
     * ,TSF_A2(65)/ 18.21852/,TSF_B2(65)/  0.19614/
     * ,TSF_A3(65)/ 14.31671/,TSF_B3(65)/ 12.66481/
     * ,TSF_A4(65)/  2.95354/,TSF_B4(65)/115.36210/
     * ,TSF_C (65)/  3.58324/
     * ,TSF_FI(65)/ -9.14720/,TSF_FII(65)/  9.18910/
      DATA TSF_ATOM(66)/'DY  '/,TSF_NE(66)/66/,TSF_RAD(66)/1.50/
     * ,TSF_A1(66)/ 26.50703/,TSF_B1(66)/  2.18020/
     * ,TSF_A2(66)/ 17.63832/,TSF_B2(66)/  0.20217/
     * ,TSF_A3(66)/ 14.55962/,TSF_B3(66)/ 12.18991/
     * ,TSF_A4(66)/  2.96577/,TSF_B4(66)/111.87410/
     * ,TSF_C (66)/  4.29728/
     * ,TSF_FI(66)/ -9.80460/,TSF_FII(66)/  9.84770/
      DATA TSF_ATOM(67)/'HO  '/,TSF_NE(67)/67/,TSF_RAD(67)/1.50/
     * ,TSF_A1(67)/ 26.90494/,TSF_B1(67)/  2.07051/
     * ,TSF_A2(67)/ 17.29402/,TSF_B2(67)/  0.19794/
     * ,TSF_A3(67)/ 14.55831/,TSF_B3(67)/ 11.44071/
     * ,TSF_A4(67)/  3.63837/,TSF_B4(67)/ 92.65669/
     * ,TSF_C (67)/  4.56797/
     * ,TSF_FI(67)/-14.97340/,TSF_FII(67)/  3.70460/
      DATA TSF_ATOM(68)/'ER  '/,TSF_NE(68)/68/,TSF_RAD(68)/1.50/
     * ,TSF_A1(68)/ 27.65634/,TSF_B1(68)/  2.07356/
     * ,TSF_A2(68)/ 16.42853/,TSF_B2(68)/  0.22355/
     * ,TSF_A3(68)/ 14.97791/,TSF_B3(68)/ 11.36041/
     * ,TSF_A4(68)/  2.98233/,TSF_B4(68)/105.70310/
     * ,TSF_C (68)/  5.92047/
     * ,TSF_FI(68)/ -9.43670/,TSF_FII(68)/  3.93800/
      DATA TSF_ATOM(69)/'TM  '/,TSF_NE(69)/69/,TSF_RAD(69)/1.50/
     * ,TSF_A1(69)/ 28.18193/,TSF_B1(69)/  2.02859/
     * ,TSF_A2(69)/ 15.88512/,TSF_B2(69)/  0.23885/
     * ,TSF_A3(69)/ 15.15421/,TSF_B3(69)/ 10.99751/
     * ,TSF_A4(69)/  2.98706/,TSF_B4(69)/102.96110/
     * ,TSF_C (69)/  6.75622/
     * ,TSF_FI(69)/ -8.03930/,TSF_FII(69)/  4.18210/
      DATA TSF_ATOM(70)/'YB  '/,TSF_NE(70)/70/,TSF_RAD(70)/1.50/
     * ,TSF_A1(70)/ 28.66414/,TSF_B1(70)/  1.98890/
     * ,TSF_A2(70)/ 15.43451/,TSF_B2(70)/  0.25712/
     * ,TSF_A3(70)/ 15.30871/,TSF_B3(70)/ 10.66471/
     * ,TSF_A4(70)/  2.98963/,TSF_B4(70)/100.41710/
     * ,TSF_C (70)/  7.56673/
     * ,TSF_FI(70)/ -7.21080/,TSF_FII(70)/  4.43290/
      DATA TSF_ATOM(71)/'LU  '/,TSF_NE(71)/71/,TSF_RAD(71)/1.50/
     * ,TSF_A1(71)/ 28.94763/,TSF_B1(71)/  1.90182/
     * ,TSF_A2(71)/ 15.22081/,TSF_B2(71)/  9.98520/
     * ,TSF_A3(71)/ 15.10001/,TSF_B3(71)/  0.26103/
     * ,TSF_A4(71)/  3.71601/,TSF_B4(71)/ 84.32988/
     * ,TSF_C (71)/  7.97629/
     * ,TSF_FI(71)/ -6.61790/,TSF_FII(71)/  4.69370/
      DATA TSF_ATOM(72)/'HF  '/,TSF_NE(72)/72/,TSF_RAD(72)/1.50/
     * ,TSF_A1(72)/ 29.14404/,TSF_B1(72)/  1.83262/
     * ,TSF_A2(72)/ 15.17261/,TSF_B2(72)/  9.59991/
     * ,TSF_A3(72)/ 14.75861/,TSF_B3(72)/  0.27512/
     * ,TSF_A4(72)/  4.30013/,TSF_B4(72)/ 72.02908/
     * ,TSF_C (72)/  8.58155/
     * ,TSF_FI(72)/ -6.17940/,TSF_FII(72)/  4.97760/
      DATA TSF_ATOM(73)/'TA  '/,TSF_NE(73)/73/,TSF_RAD(73)/1.50/
     * ,TSF_A1(73)/ 29.20244/,TSF_B1(73)/  1.77333/
     * ,TSF_A2(73)/ 15.22931/,TSF_B2(73)/  9.37047/
     * ,TSF_A3(73)/ 14.51351/,TSF_B3(73)/  0.29598/
     * ,TSF_A4(73)/  4.76492/,TSF_B4(73)/ 63.36447/
     * ,TSF_C (73)/  9.24355/
     * ,TSF_FI(73)/ -5.79590/,TSF_FII(73)/  5.27180/
      DATA TSF_ATOM(74)/'W   '/,TSF_NE(74)/74/,TSF_RAD(74)/1.50/
     * ,TSF_A1(74)/ 29.08183/,TSF_B1(74)/  1.72029/
     * ,TSF_A2(74)/ 15.43001/,TSF_B2(74)/  9.22591/
     * ,TSF_A3(74)/ 14.43271/,TSF_B3(74)/  0.32170/
     * ,TSF_A4(74)/  5.11983/,TSF_B4(74)/ 57.05606/
     * ,TSF_C (74)/  9.88751/
     * ,TSF_FI(74)/ -5.47340/,TSF_FII(74)/  5.57740/
      DATA TSF_ATOM(75)/'RE  '/,TSF_NE(75)/75/,TSF_RAD(75)/1.50/
     * ,TSF_A1(75)/ 28.76213/,TSF_B1(75)/  1.67191/
     * ,TSF_A2(75)/ 15.71892/,TSF_B2(75)/  9.09228/
     * ,TSF_A3(75)/ 14.55641/,TSF_B3(75)/  0.35050/
     * ,TSF_A4(75)/  5.44174/,TSF_B4(75)/ 52.08615/
     * ,TSF_C (75)/ 10.47201/
     * ,TSF_FI(75)/ -5.20830/,TSF_FII(75)/  5.89230/
      DATA TSF_ATOM(76)/'OS  '/,TSF_NE(76)/76/,TSF_RAD(76)/1.50/
     * ,TSF_A1(76)/ 28.18944/,TSF_B1(76)/  1.62903/
     * ,TSF_A2(76)/ 16.15501/,TSF_B2(76)/  8.97949/
     * ,TSF_A3(76)/ 14.93051/,TSF_B3(76)/  0.38266/
     * ,TSF_A4(76)/  5.67590/,TSF_B4(76)/ 48.16475/
     * ,TSF_C (76)/ 11.00051/
     * ,TSF_FI(76)/ -4.98010/,TSF_FII(76)/  6.22160/
      DATA TSF_ATOM(77)/'IR  '/,TSF_NE(77)/77/,TSF_RAD(77)/1.50/
     * ,TSF_A1(77)/ 27.30493/,TSF_B1(77)/  1.59279/
     * ,TSF_A2(77)/ 16.72961/,TSF_B2(77)/  8.86554/
     * ,TSF_A3(77)/ 15.61152/,TSF_B3(77)/  0.41792/
     * ,TSF_A4(77)/  5.83378/,TSF_B4(77)/ 45.00114/
     * ,TSF_C (77)/ 11.47221/
     * ,TSF_FI(77)/ -4.77100/,TSF_FII(77)/  6.56670/
      DATA TSF_ATOM(78)/'PT  '/,TSF_NE(78)/78/,TSF_RAD(78)/1.50/
     * ,TSF_A1(78)/ 27.00594/,TSF_B1(78)/  1.51293/
     * ,TSF_A2(78)/ 17.76392/,TSF_B2(78)/  8.81175/
     * ,TSF_A3(78)/ 15.71312/,TSF_B3(78)/  0.42459/
     * ,TSF_A4(78)/  5.78371/,TSF_B4(78)/ 38.61034/
     * ,TSF_C (78)/ 11.68831/
     * ,TSF_FI(78)/ -4.59320/,TSF_FII(78)/  6.92640/
      DATA TSF_ATOM(79)/'AU  '/,TSF_NE(79)/79/,TSF_RAD(79)/1.50/
     * ,TSF_A1(79)/ 16.88193/,TSF_B1(79)/  0.46110/
     * ,TSF_A2(79)/ 18.59132/,TSF_B2(79)/  8.62161/
     * ,TSF_A3(79)/ 25.55824/,TSF_B3(79)/  1.48260/
     * ,TSF_A4(79)/  5.86001/,TSF_B4(79)/ 36.39563/
     * ,TSF_C (79)/ 12.06581/
     * ,TSF_FI(79)/ -4.41970/,TSF_FII(79)/  7.29800/
      DATA TSF_ATOM(80)/'HG  '/,TSF_NE(80)/80/,TSF_RAD(80)/1.50/
     * ,TSF_A1(80)/ 20.68092/,TSF_B1(80)/  0.54500/
     * ,TSF_A2(80)/ 19.04172/,TSF_B2(80)/  8.44841/
     * ,TSF_A3(80)/ 21.65752/,TSF_B3(80)/  1.57290/
     * ,TSF_A4(80)/  5.96761/,TSF_B4(80)/ 38.32463/
     * ,TSF_C (80)/ 12.60891/
     * ,TSF_FI(80)/ -4.29230/,TSF_FII(80)/  7.68490/
      DATA TSF_ATOM(81)/'TL  '/,TSF_NE(81)/81/,TSF_RAD(81)/1.50/
     * ,TSF_A1(81)/ 27.54463/,TSF_B1(81)/  0.65515/
     * ,TSF_A2(81)/ 19.15842/,TSF_B2(81)/  8.70752/
     * ,TSF_A3(81)/ 15.53802/,TSF_B3(81)/  1.96347/
     * ,TSF_A4(81)/  5.52594/,TSF_B4(81)/ 45.81496/
     * ,TSF_C (81)/ 13.17461/
     * ,TSF_FI(81)/ -4.16270/,TSF_FII(81)/  8.09000/
      DATA TSF_ATOM(82)/'PB  '/,TSF_NE(82)/82/,TSF_RAD(82)/1.50/
     * ,TSF_A1(82)/ 31.06174/,TSF_B1(82)/  0.69020/
     * ,TSF_A2(82)/ 13.06371/,TSF_B2(82)/  2.35760/
     * ,TSF_A3(82)/ 18.44202/,TSF_B3(82)/  8.61801/
     * ,TSF_A4(82)/  5.96961/,TSF_B4(82)/ 47.25795/
     * ,TSF_C (82)/ 13.41181/
     * ,TSF_FI(82)/ -4.07530/,TSF_FII(82)/  8.50600/
      DATA TSF_ATOM(83)/'BI  '/,TSF_NE(83)/83/,TSF_RAD(83)/1.50/
     * ,TSF_A1(83)/ 33.36894/,TSF_B1(83)/  0.70400/
     * ,TSF_A2(83)/ 12.95101/,TSF_B2(83)/  2.92380/
     * ,TSF_A3(83)/ 16.58772/,TSF_B3(83)/  8.79371/
     * ,TSF_A4(83)/  6.46921/,TSF_B4(83)/ 48.00935/
     * ,TSF_C (83)/ 13.57821/
     * ,TSF_FI(83)/ -4.01110/,TSF_FII(83)/  8.93100/
      DATA TSF_ATOM(84)/'PO  '/,TSF_NE(84)/84/,TSF_RAD(84)/1.50/
     * ,TSF_A1(84)/ 34.67264/,TSF_B1(84)/  0.70100/
     * ,TSF_A2(84)/ 15.47331/,TSF_B2(84)/  3.55078/
     * ,TSF_A3(84)/ 13.11381/,TSF_B3(84)/  9.55643/
     * ,TSF_A4(84)/  7.02589/,TSF_B4(84)/ 47.00455/
     * ,TSF_C (84)/ 13.67701/
     * ,TSF_FI(84)/ -3.96700/,TSF_FII(84)/  9.38340/
      DATA TSF_ATOM(85)/'AT  '/,TSF_NE(85)/85/,TSF_RAD(85)/1.50/
     * ,TSF_A1(85)/ 35.31633/,TSF_B1(85)/  0.68587/
     * ,TSF_A2(85)/ 19.02112/,TSF_B2(85)/  3.97458/
     * ,TSF_A3(85)/  9.49888/,TSF_B3(85)/ 11.38241/
     * ,TSF_A4(85)/  7.42519/,TSF_B4(85)/ 45.47156/
     * ,TSF_C (85)/ 13.71081/
     * ,TSF_FI(85)/ -3.95880/,TSF_FII(85)/  9.84330/
      DATA TSF_ATOM(86)/'RN  '/,TSF_NE(86)/86/,TSF_RAD(86)/1.50/
     * ,TSF_A1(86)/ 35.56314/,TSF_B1(86)/  0.66310/
     * ,TSF_A2(86)/ 21.28162/,TSF_B2(86)/  4.06910/
     * ,TSF_A3(86)/  8.00371/,TSF_B3(86)/ 14.04221/
     * ,TSF_A4(86)/  7.44331/,TSF_B4(86)/ 44.24734/
     * ,TSF_C (86)/ 13.69051/
     * ,TSF_FI(86)/ -3.94870/,TSF_FII(86)/ 10.31810/
      DATA TSF_ATOM(87)/'FR  '/,TSF_NE(87)/87/,TSF_RAD(87)/1.50/
     * ,TSF_A1(87)/ 35.92993/,TSF_B1(87)/  0.64645/
     * ,TSF_A2(87)/ 23.05472/,TSF_B2(87)/  4.17619/
     * ,TSF_A3(87)/ 12.14391/,TSF_B3(87)/ 23.10522/
     * ,TSF_A4(87)/  2.11253/,TSF_B4(87)/150.64510/
     * ,TSF_C (87)/ 13.72471/
     * ,TSF_FI(87)/ -3.96890/,TSF_FII(87)/ 10.80380/
      DATA TSF_ATOM(88)/'RA  '/,TSF_NE(88)/88/,TSF_RAD(88)/1.50/
     * ,TSF_A1(88)/ 35.76303/,TSF_B1(88)/  0.61634/
     * ,TSF_A2(88)/ 22.90642/,TSF_B2(88)/  3.87135/
     * ,TSF_A3(88)/ 12.47391/,TSF_B3(88)/ 19.98872/
     * ,TSF_A4(88)/  3.21097/,TSF_B4(88)/142.32510/
     * ,TSF_C (88)/ 13.62111/
     * ,TSF_FI(88)/ -4.00880/,TSF_FII(88)/ 11.29690/
      DATA TSF_ATOM(89)/'AC  '/,TSF_NE(89)/89/,TSF_RAD(89)/1.50/
     * ,TSF_A1(89)/ 35.65973/,TSF_B1(89)/  0.58909/
     * ,TSF_A2(89)/ 23.10323/,TSF_B2(89)/  3.65155/
     * ,TSF_A3(89)/ 12.59771/,TSF_B3(89)/ 18.59901/
     * ,TSF_A4(89)/  4.08655/,TSF_B4(89)/117.02010/
     * ,TSF_C (89)/ 13.52661/
     * ,TSF_FI(89)/ -4.07940/,TSF_FII(89)/ 11.79940/
      DATA TSF_ATOM(90)/'TH  '/,TSF_NE(90)/90/,TSF_RAD(90)/1.50/
     * ,TSF_A1(90)/ 35.56453/,TSF_B1(90)/  0.56336/
     * ,TSF_A2(90)/ 23.42192/,TSF_B2(90)/  3.46204/
     * ,TSF_A3(90)/ 12.74731/,TSF_B3(90)/ 17.83092/
     * ,TSF_A4(90)/  4.80704/,TSF_B4(90)/ 99.17230/
     * ,TSF_C (90)/ 13.43141/
     * ,TSF_FI(90)/ -4.14910/,TSF_FII(90)/ 12.32960/
      DATA TSF_ATOM(91)/'PA  '/,TSF_NE(91)/91/,TSF_RAD(91)/1.50/
     * ,TSF_A1(91)/ 35.88474/,TSF_B1(91)/  0.54775/
     * ,TSF_A2(91)/ 23.29482/,TSF_B2(91)/  3.41519/
     * ,TSF_A3(91)/ 14.18911/,TSF_B3(91)/ 16.92352/
     * ,TSF_A4(91)/  4.17287/,TSF_B4(91)/105.25110/
     * ,TSF_C (91)/ 13.42871/
     * ,TSF_FI(91)/ -4.24730/,TSF_FII(91)/ 12.86810/
      DATA TSF_ATOM(92)/'U   '/,TSF_NE(92)/92/,TSF_RAD(92)/1.50/
     * ,TSF_A1(92)/ 36.02284/,TSF_B1(92)/  0.52930/
     * ,TSF_A2(92)/ 23.41283/,TSF_B2(92)/  3.32530/
     * ,TSF_A3(92)/ 14.94911/,TSF_B3(92)/ 16.09273/
     * ,TSF_A4(92)/  4.18800/,TSF_B4(92)/100.61310/
     * ,TSF_C (92)/ 13.39661/
     * ,TSF_FI(92)/ -4.36380/,TSF_FII(92)/ 13.40900/
      DATA TSF_ATOM(93)/'NP  '/,TSF_NE(93)/93/,TSF_RAD(93)/1.50/
     * ,TSF_A1(93)/ 36.18744/,TSF_B1(93)/  0.51193/
     * ,TSF_A2(93)/ 23.59642/,TSF_B2(93)/  3.25396/
     * ,TSF_A3(93)/ 15.64022/,TSF_B3(93)/ 15.36222/
     * ,TSF_A4(93)/  4.18550/,TSF_B4(93)/ 97.49089/
     * ,TSF_C (93)/ 13.35731/
     * ,TSF_FI(93)/ -4.50530/,TSF_FII(93)/ 13.96660/
      DATA TSF_ATOM(94)/'PU  '/,TSF_NE(94)/94/,TSF_RAD(94)/1.50/
     * ,TSF_A1(94)/ 36.52544/,TSF_B1(94)/  0.49938/
     * ,TSF_A2(94)/ 23.80832/,TSF_B2(94)/  3.26371/
     * ,TSF_A3(94)/ 16.77072/,TSF_B3(94)/ 14.94551/
     * ,TSF_A4(94)/  3.47947/,TSF_B4(94)/105.98010/
     * ,TSF_C (94)/ 13.38121/
     * ,TSF_FI(94)/ -4.65630/,TSF_FII(94)/ 14.37290/
C -----------------------------------------------------
      IERR=0
      CHAR4 = ASYMB

      DO I=1,TSF_N
        IF(CHAR4(1:4).EQ.TSF_ATOM(I)(1:4)) GO TO 100
      ENDDO
 
      IERR = 2
      CALL CHKSMB(CHAR4(2:2),TYPE)
      IF(TYPE.EQ.'D'.OR.TYPE.EQ.'S') CHAR4(2:2) = ' '
      CHAR4(3:3) = ' '
      CHAR4(4:4) = ' '


      DO I=1,TSF_N
        IF(CHAR4(1:2).EQ.TSF_ATOM(I)(1:2)) GO TO 100
      ENDDO

      IERR = 1
      I    = 7

  100 CONTINUE
      N  = I
      NEL= TSF_NE (I)
      A1 = TSF_A1 (I)
      A2 = TSF_A2 (I)
      A3 = TSF_A3 (I)
      A4 = TSF_A4 (I)
      B1 = TSF_B1 (I)
      B2 = TSF_B2 (I)
      B3 = TSF_B3 (I)
      B4 = TSF_B4 (I)
      C  = TSF_C  (I)
      FI = TSF_FI (I)
      FII= TSF_FII(I)
      RAD= TSF_RAD(I)

      RETURN
      END

      subroutine copy_remarks_from_input(iout)
      implicit none
      integer iout

      return
      end

      SUBROUTINE WRITE_DEPOSIT_STATS(IOUT_FILE)
      IMPLICIT NONE
      INTEGER IOUT_FILE
      RETURN
      END

      SUBROUTINE WRITE_MTRIX_PDB(IOUT_FILE)
      IMPLICIT NONE
      INTEGER IOUT_FILE
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IERR    = 0
      NO_TAB  =   0
      NS_TAB  =   0
      SG_TAB1 = ' '
      SG_TAB2 = ' '
      SG_TAB3 = ' '
      OP      = ' '
C ----
      IF(I.GE.  1.AND.I.LE.30) THEN
        CALL GET_SPACE_GROUP_INFO_1(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.31.AND.I.LE.62) THEN
        CALL GET_SPACE_GROUP_INFO_11(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.63.AND.I.LE.86) THEN
        CALL GET_SPACE_GROUP_INFO_12(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.87.AND.I.LE.114) THEN
        CALL GET_SPACE_GROUP_INFO_13(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.115.AND.I.LE.130) THEN
        CALL GET_SPACE_GROUP_INFO_14(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.131.AND.I.LE.145) THEN
        CALL GET_SPACE_GROUP_INFO_2(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.146.AND.I.LE.162) THEN
        CALL GET_SPACE_GROUP_INFO_21(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.163.AND.I.LE.188) THEN
        CALL GET_SPACE_GROUP_INFO_22(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.189.AND.I.LE.202) THEN
        CALL GET_SPACE_GROUP_INFO_23(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.203.AND.I.LE.215) THEN
        CALL GET_SPACE_GROUP_INFO_24(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.216.AND.I.LE.221) THEN
        CALL GET_SPACE_GROUP_INFO_3(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.222.AND.I.LE.226) THEN
        CALL GET_SPACE_GROUP_INFO_31(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.227.AND.I.LE.230) THEN
        CALL GET_SPACE_GROUP_INFO_32(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.231.AND.I.LE.235) THEN
        CALL GET_SPACE_GROUP_INFO_33(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.236.AND.I.LE.239) THEN
        CALL GET_SPACE_GROUP_INFO_34(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.240.AND.I.LE.243) THEN
        CALL GET_SPACE_GROUP_INFO_35(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.244.AND.I.LE.245) THEN
        CALL GET_SPACE_GROUP_INFO_4(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.246.AND.I.LE.246) THEN
        CALL GET_SPACE_GROUP_INFO_41(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.247.AND.I.LE.247) THEN
        CALL GET_SPACE_GROUP_INFO_42(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.248.AND.I.LE.248) THEN
        CALL GET_SPACE_GROUP_INFO_43(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE IF(I.GE.249.AND.I.LE.250) THEN
        CALL GET_SPACE_GROUP_INFO_44(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
      ELSE
        NO_TAB  =    1
        NS_TAB  =    1
        SG_TAB1 = 'P 1'
        SG_TAB2 = 'P1'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IERR = 1
      ENDIF
C ----
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_1(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IERR    = 0
      NO_TAB  =   0
      NS_TAB  =   0
      SG_TAB1 = ' '
      SG_TAB2 = ' '
      SG_TAB3 = ' '
      OP      = ' '
C ----
      IF(I.EQ.  1) THEN
        NO_TAB  =    1
        NS_TAB  =    1
        SG_TAB1 = 'P 1'
        SG_TAB2 = 'P1'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        RETURN
      ENDIF
      IF(I.EQ.  2) THEN
        NO_TAB  =    2
        NS_TAB  =    2
        SG_TAB1 = 'P -1'
        SG_TAB2 = 'P-1'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ.  3) THEN
        NO_TAB  =    3
        NS_TAB  =    2
        SG_TAB1 = 'P 1 2 1'
        SG_TAB2 = 'P2'
        SG_TAB3 = 'P 2'
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,Y,-Z'
        RETURN
      ENDIF 
      IF(I.EQ.  4) THEN
        NO_TAB  = 1003
        NS_TAB  =    2
        SG_TAB1 = 'P 1 1 2'
        SG_TAB2 = 'P112'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        RETURN
      ENDIF
      IF(I.EQ.  5) THEN
        NO_TAB  =    4
        NS_TAB  =    2
        SG_TAB1 = 'P 1 21 1'
        SG_TAB2 = 'P21'
        SG_TAB3 = 'P 21'
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,Y+1/2,-Z'
        RETURN
      ENDIF
      IF(I.EQ.  6) THEN
        NO_TAB  = 3004
        NS_TAB  =    4
        SG_TAB1 = 'I 1 21 1'
        SG_TAB2 = 'I21'
        SG_TAB3 = 'I 21'
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,1/2+Y,-Z'
        IF(IS.EQ.  3) OP =' X+1/2,Y+1/2,Z+1/2'
        IF(IS.EQ.  4) OP =' -X+1/2,Y,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.  7) THEN
        NO_TAB  = 1004
        NS_TAB  =    2
        SG_TAB1 = 'P 1 1 21'
        SG_TAB2 = 'P1121'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.  8) THEN
        NO_TAB  = 2005
        NS_TAB  =    4
        SG_TAB1 = 'A 1 2 1'
        SG_TAB2 = 'A2'
        SG_TAB3 = 'A 2'
        IF(IS.EQ.  1) OP =' X, Y, Z'
        IF(IS.EQ.  2) OP =' -X,1/2+Y,-Z'
        IF(IS.EQ.  3) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ.  4) OP =' -X, Y,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.  9) THEN
        NO_TAB  =    5
        NS_TAB  =    4
        SG_TAB1 = 'C 1 2 1'
        SG_TAB2 = 'C2'
        SG_TAB3 = 'C 2'
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,Y,-Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X,1/2+Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 10) THEN
        NO_TAB  = 1005
        NS_TAB  =    4
        SG_TAB1 = 'C 1 21 1'
        SG_TAB2 = 'C21'
        SG_TAB3 = 'C 21'
        IF(IS.EQ.  1) OP =' X, Y, Z'
        IF(IS.EQ.  2) OP =' -X,1/2+Y,-Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X, Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 11) THEN
        NO_TAB  = 3005
        NS_TAB  =    4
        SG_TAB1 = 'B 1 1 2'
        SG_TAB2 = 'B2'
        SG_TAB3 = 'B 2'
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2+X,+Y,1/2+Z'
        IF(IS.EQ.  4) OP =' 1/2-X,-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 12) THEN
        NO_TAB  =    6
        NS_TAB  =    2
        SG_TAB1 = 'P 1 m 1'
        SG_TAB2 = 'Pm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' X,-Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 13) THEN
        NO_TAB  =    7
        NS_TAB  =    2
        SG_TAB1 = 'P 1 c 1'
        SG_TAB2 = 'Pc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' X,-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 14) THEN
        NO_TAB  =    8
        NS_TAB  =    4
        SG_TAB1 = 'C 1 m 1'
        SG_TAB2 = 'Cm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 15) THEN
        NO_TAB  =    9
        NS_TAB  =    4
        SG_TAB1 = 'C 1 c 1'
        SG_TAB2 = 'Cc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 16) THEN
        NO_TAB  =   10
        NS_TAB  =    4
        SG_TAB1 = 'P 1 2/m 1'
        SG_TAB2 = 'P2/m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' -X,-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 17) THEN
        NO_TAB  =   11
        NS_TAB  =    4
        SG_TAB1 = 'P 1 21/m 1'
        SG_TAB2 = 'P21/m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,1/2+Y,-Z'
        IF(IS.EQ.  3) OP =' -X,-Y,-Z'
        IF(IS.EQ.  4) OP =' X,1/2-Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 18) THEN
        NO_TAB  =   12
        NS_TAB  =    8
        SG_TAB1 = 'C 1 2/m 1'
        SG_TAB2 = 'C2/m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' -X,-Y,-Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  7) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 19) THEN
        NO_TAB  =   13
        NS_TAB  =    4
        SG_TAB1 = 'P 1 2/c 1'
        SG_TAB2 = 'P2/c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  3) OP =' -X,-Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 20) THEN
        NO_TAB  =   14
        NS_TAB  =    4
        SG_TAB1 = 'P 1 21/c 1'
        SG_TAB2 = 'P21/c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,-Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,1/2-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 21) THEN
        NO_TAB  =   15
        NS_TAB  =    8
        SG_TAB1 = 'C 1 2/c 1'
        SG_TAB2 = 'C2/c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  3) OP =' -X,-Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ.  7) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ.  8) OP =' 1/2+X,1/2-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 22) THEN
        NO_TAB  =   16
        NS_TAB  =    4
        SG_TAB1 = 'P 2 2 2'
        SG_TAB2 = 'P222'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 23) THEN
        NO_TAB  =   17
        NS_TAB  =    4
        SG_TAB1 = 'P 2 2 21'
        SG_TAB2 = 'P2221'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 24) THEN
        NO_TAB  = 1017
        NS_TAB  =    4
        SG_TAB1 = 'P 21 2 2'
        SG_TAB2 = 'P2122'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,Y,-Z'
        IF(IS.EQ.  3) OP =' 1/2+X,-Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2-X,-Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 25) THEN
        NO_TAB  = 2017
        NS_TAB  =    4
        SG_TAB1 = 'P 2 21 2'
        SG_TAB2 = 'P2212'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' X,1/2-Y,-Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 26) THEN
        NO_TAB  =   18
        NS_TAB  =    4
        SG_TAB1 = 'P 21 21 2'
        SG_TAB2 = 'P21212'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 27) THEN
        NO_TAB  = 1018
        NS_TAB  =    4
        SG_TAB1 = 'P 21 21 2 (a)'
        SG_TAB2 = 'P21212a'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' X+1/2,-Y,-Z'
        IF(IS.EQ.  4) OP =' -X,Y+1/2,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 28) THEN
        NO_TAB  = 2018
        NS_TAB  =    4
        SG_TAB1 = 'P 21 2 21'
        SG_TAB2 = 'P21221'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,Y,-Z'
        IF(IS.EQ.  3) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2-X,-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 29) THEN
        NO_TAB  = 3018
        NS_TAB  =    4
        SG_TAB1 = 'P 2 21 21'
        SG_TAB2 = 'P22121'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' X,-Y,-Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' -X,1/2-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 30) THEN
        NO_TAB  =   19
        NS_TAB  =    4
        SG_TAB1 = 'P 21 21 21'
        SG_TAB2 = 'P212121'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        RETURN
      ENDIF
      RETURN
      END


      SUBROUTINE GET_SPACE_GROUP_INFO_11(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ. 31) THEN
        NO_TAB  =   20
        NS_TAB  =    8
        SG_TAB1 = 'C 2 2 21'
        SG_TAB2 = 'C2221'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ.  8) OP =' 1/2+X,1/2-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 32) THEN
        NO_TAB  = 1020
        NS_TAB  =    8
        SG_TAB1 = 'C 2 2 21 (a)'
        SG_TAB2 = 'C2221a'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  4) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  6) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' X,-Y,-Z'
        IF(IS.EQ.  8) OP =' 1/2-X,Y,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ. 33) THEN
        NO_TAB  =   21
        NS_TAB  =    8
        SG_TAB1 = 'C 2 2 2'
        SG_TAB2 = 'C222'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  7) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  8) OP =' 1/2+X,1/2-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 34) THEN
        NO_TAB  = 1021
        NS_TAB  =    8
        SG_TAB1 = 'C 2 2 2 (a)'
        SG_TAB2 = 'C222a'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' X+1/2,-Y,-Z'
        IF(IS.EQ.  4) OP =' -X,Y+1/2,-Z'
        IF(IS.EQ.  5) OP =' 1/2+ X,1/2+Y,Z'
        IF(IS.EQ.  6) OP =' -X,-Y,Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,-Z'
        IF(IS.EQ.  8) OP =' 1/2-X,Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 35) THEN
        NO_TAB  =   22
        NS_TAB  =   16
        SG_TAB1 = 'F 2 2 2'
        SG_TAB2 = 'F222'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  8) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ.  9) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 16) OP =' 1/2+X,1/2-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 36) THEN
        NO_TAB  = 1022
        NS_TAB  =   16
        SG_TAB1 = 'F 2 2 2 (a)'
        SG_TAB2 = 'F222a'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' X+1/2,-Y,-Z'
        IF(IS.EQ.  4) OP =' -X,Y+1/2,-Z'
        IF(IS.EQ.  5) OP =' X,Y+1/2,Z+1/2'
        IF(IS.EQ.  6) OP =' 1/2-X,-Y,Z+1/2'
        IF(IS.EQ.  7) OP =' X+1/2,-Y+1/2,-Z+1/2'
        IF(IS.EQ.  8) OP =' -X,Y,-Z+1/2'
        IF(IS.EQ.  9) OP =' X+1/2,Y,Z+1/2'
        IF(IS.EQ. 10) OP =' -X,1/2-Y,Z+1/2'
        IF(IS.EQ. 11) OP =' X,-Y,-Z+1/2'
        IF(IS.EQ. 12) OP =' -X+1/2,Y+1/2,-Z+1/2'
        IF(IS.EQ. 13) OP =' X+1/2,Y+1/2,Z'
        IF(IS.EQ. 14) OP =' -X,-Y,Z'
        IF(IS.EQ. 15) OP =' X,-Y+1/2,-Z'
        IF(IS.EQ. 16) OP =' -X+1/2,Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 37) THEN
        NO_TAB  =   23
        NS_TAB  =    8
        SG_TAB1 = 'I 2 2 2'
        SG_TAB2 = 'I222'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,-Y,-Z'
        IF(IS.EQ.  4) OP =' -X,Y,-Z'
        IF(IS.EQ.  5) OP =' X+1/2,Y+1/2,Z+1/2'
        IF(IS.EQ.  6) OP =' -X+1/2,-Y+1/2,Z+1/2'
        IF(IS.EQ.  7) OP =' X+1/2,-Y+1/2,-Z+1/2'
        IF(IS.EQ.  8) OP =' -X+1/2,Y+1/2,-Z+1/2'
        RETURN
      ENDIF
      IF(I.EQ. 38) THEN
        NO_TAB  = 1023
        NS_TAB  =    8
        SG_TAB1 = 'I 2 2 2 (a)'
        SG_TAB2 = 'I222a'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' X+1/2,-Y,-Z'
        IF(IS.EQ.  4) OP =' -X,Y+1/2,-Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP ='  -X,-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ.  8) OP ='  X,1/2-Y,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ. 39) THEN
        NO_TAB  =   24
        NS_TAB  =    8
        SG_TAB1 = 'I 21 21 21'
        SG_TAB2 = 'I212121'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,1/2-Y,Z'
        IF(IS.EQ.  7) OP =' 1/2-X,Y,-Z'
        IF(IS.EQ.  8) OP =' X,-Y,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ. 40) THEN
        NO_TAB  =   25
        NS_TAB  =    4
        SG_TAB1 = 'P m m 2'
        SG_TAB2 = 'Pmm2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,-Y,Z'
        IF(IS.EQ.  4) OP =' -X,Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 41) THEN
        NO_TAB  =   26
        NS_TAB  =    4
        SG_TAB1 = 'P m c 21'
        SG_TAB2 = 'Pmc21'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  4) OP =' -X,Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 42) THEN
        NO_TAB  =   27
        NS_TAB  =    4
        SG_TAB1 = 'P c c 2'
        SG_TAB2 = 'Pcc2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  4) OP =' -X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 43) THEN
        NO_TAB  =   28
        NS_TAB  =    4
        SG_TAB1 = 'P m a 2'
        SG_TAB2 = 'Pma2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2+X,-Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X,Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 44) THEN
        NO_TAB  =   29
        NS_TAB  =    4
        SG_TAB1 = 'P c a 21'
        SG_TAB2 = 'Pca21'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2+X,-Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 45) THEN
        NO_TAB  =   30
        NS_TAB  =    4
        SG_TAB1 = 'P n c 2'
        SG_TAB2 = 'Pnc2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  4) OP =' -X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 46) THEN
        NO_TAB  =   31
        NS_TAB  =    4
        SG_TAB1 = 'P m n 21'
        SG_TAB2 = 'Pmn21'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ.  4) OP =' -X,Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 47) THEN
        NO_TAB  =   32
        NS_TAB  =    4
        SG_TAB1 = 'P b a 2'
        SG_TAB2 = 'Pba2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 48) THEN
        NO_TAB  =   33
        NS_TAB  =    4
        SG_TAB1 = 'P n a 21'
        SG_TAB2 = 'Pna21'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 49) THEN
        NO_TAB  =   34
        NS_TAB  =    4
        SG_TAB1 = 'P n n 2'
        SG_TAB2 = 'Pnn2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  4) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 50) THEN
        NO_TAB  =   35
        NS_TAB  =    8
        SG_TAB1 = 'C m m 2'
        SG_TAB2 = 'Cmm2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,-Y,Z'
        IF(IS.EQ.  4) OP =' -X,Y,Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 51) THEN
        NO_TAB  =   36
        NS_TAB  =    8
        SG_TAB1 = 'C m c 21'
        SG_TAB2 = 'Cmc21'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  4) OP =' -X,Y,Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 52) THEN
        NO_TAB  =   37
        NS_TAB  =    8
        SG_TAB1 = 'C c c 2'
        SG_TAB2 = 'Ccc2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  4) OP =' -X,Y,1/2+Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 53) THEN
        NO_TAB  =   38
        NS_TAB  =    8
        SG_TAB1 = 'A m m 2'
        SG_TAB2 = 'Amm2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,-Y,Z'
        IF(IS.EQ.  4) OP =' -X,Y,Z'
        IF(IS.EQ.  5) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 54) THEN
        NO_TAB  =   39
        NS_TAB  =    8
        SG_TAB1 = 'A b m 2'
        SG_TAB2 = 'Abm2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,1/2-Y,Z'
        IF(IS.EQ.  4) OP =' -X,1/2+Y,Z'
        IF(IS.EQ.  5) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 55) THEN
        NO_TAB  =   40
        NS_TAB  =    8
        SG_TAB1 = 'A m a 2'
        SG_TAB2 = 'Ama2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2+X,-Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X,Y,Z'
        IF(IS.EQ.  5) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 56) THEN
        NO_TAB  =   41
        NS_TAB  =    8
        SG_TAB1 = 'A b a 2'
        SG_TAB2 = 'Aba2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.  5) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 57) THEN
        NO_TAB  =   42
        NS_TAB  =   16
        SG_TAB1 = 'F m m 2'
        SG_TAB2 = 'Fmm2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,-Y,Z'
        IF(IS.EQ.  4) OP =' -X,Y,Z'
        IF(IS.EQ.  5) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,1/2+Y,1/2+Z'
        IF(IS.EQ.  9) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ. 12) OP =' 1/2-X,Y,1/2+Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 15) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 58) THEN
        NO_TAB  =   43
        NS_TAB  =   16
        SG_TAB1 = 'F d d 2'
        SG_TAB2 = 'Fdd2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/4+X,1/4-Y,1/4+Z'
        IF(IS.EQ.  4) OP =' 1/4-X,1/4+Y,1/4+Z'
        IF(IS.EQ.  5) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/4+X,3/4-Y,3/4+Z'
        IF(IS.EQ.  8) OP =' 1/4-X,3/4+Y,3/4+Z'
        IF(IS.EQ.  9) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 3/4+X,1/4-Y,3/4+Z'
        IF(IS.EQ. 12) OP =' 3/4-X,1/4+Y,3/4+Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 15) OP =' 3/4+X,3/4-Y,1/4+Z'
        IF(IS.EQ. 16) OP =' 3/4-X,3/4+Y,1/4+Z'
        RETURN
      ENDIF
      IF(I.EQ. 59) THEN
        NO_TAB  =   44
        NS_TAB  =    8
        SG_TAB1 = 'I m m 2'
        SG_TAB2 = 'Imm2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' X,-Y,Z'
        IF(IS.EQ.  4) OP =' -X,Y,Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 60) THEN
        NO_TAB  =   45
        NS_TAB  =    8
        SG_TAB1 = 'I b a 2'
        SG_TAB2 = 'Iba2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 61) THEN
        NO_TAB  =   46
        NS_TAB  =    8
        SG_TAB1 = 'I m a 2'
        SG_TAB2 = 'Ima2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2+X,-Y,Z'
        IF(IS.EQ.  4) OP =' 1/2-X,Y,Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 62) THEN
        NO_TAB  =   47
        NS_TAB  =    8
        SG_TAB1 = 'P 2/m 2/m 2/m'
        SG_TAB2 = 'Pmmm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' X,-Y,Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_12(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ. 63) THEN
        NO_TAB  =   48
        NS_TAB  =    8
        SG_TAB1 = 'P 2/n 2/n 2/n'
        SG_TAB2 = 'Pnnn'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 64) THEN
        NO_TAB  =   49
        NS_TAB  =    8
        SG_TAB1 = 'P 2/c 2/c 2/m'
        SG_TAB2 = 'Pccm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,-Y,1/2-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 65) THEN
        NO_TAB  =   50
        NS_TAB  =    8
        SG_TAB1 = 'P 2/b 2/a 2/n'
        SG_TAB2 = 'Pban'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 66) THEN
        NO_TAB  =   51
        NS_TAB  =    8
        SG_TAB1 = 'P 21/m 2/m 2/a'
        SG_TAB2 = 'Pmma'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,Y,-Z'
        IF(IS.EQ.  7) OP =' X,-Y,Z'
        IF(IS.EQ.  8) OP =' 1/2-X,Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 67) THEN
        NO_TAB  =   52
        NS_TAB  =    8
        SG_TAB1 = 'P 2/n 21/n 2/a'
        SG_TAB2 = 'Pnna'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,Y,-Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 68) THEN
        NO_TAB  =   53
        NS_TAB  =    8
        SG_TAB1 = 'P 2/m 2/n 21/a'
        SG_TAB2 = 'Pmna'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ.  7) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 69) THEN
        NO_TAB  =   54
        NS_TAB  =    8
        SG_TAB1 = 'P 21/c 2/c 2/a'
        SG_TAB2 = 'Pcca'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,Y,-Z'
        IF(IS.EQ.  7) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 70) THEN
        NO_TAB  =   55
        NS_TAB  =    8
        SG_TAB1 = 'P 21/b 21/a 2/m'
        SG_TAB2 = 'Pbam'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 71) THEN
        NO_TAB  =   56
        NS_TAB  =    8
        SG_TAB1 = 'P 21/c 21/c 2/n'
        SG_TAB2 = 'Pccn'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 72) THEN
        NO_TAB  =   57
        NS_TAB  =    8
        SG_TAB1 = 'P 2/b 21/c 21/m'
        SG_TAB2 = 'Pbcm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,1/2-Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 73) THEN
        NO_TAB  =   58
        NS_TAB  =    8
        SG_TAB1 = 'P 21/n 21/n 2/m'
        SG_TAB2 = 'Pnnm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 74) THEN
        NO_TAB  =   59
        NS_TAB  =    8
        SG_TAB1 = 'P 21/m 21/m 2/n'
        SG_TAB2 = 'Pmmn'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-X,Y+1/2,-Z'
        IF(IS.EQ.  4) OP =' X+1/2,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ.  6) OP =' X+1/2,Y+1/2,-Z'
        IF(IS.EQ.  7) OP =' X,-Y,Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 75) THEN
        NO_TAB  = 1059
        NS_TAB  =    8
        SG_TAB1 = 'P 21/m 21/m 2/n (2)'
        SG_TAB2 = 'Pmmn2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X+1/2,Y+1/2,-Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,Z'
        IF(IS.EQ.  8) OP =' 1/2-X,Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 76) THEN
        NO_TAB  =   60
        NS_TAB  =    8
        SG_TAB1 = 'P 21/b 2/c 21/n'
        SG_TAB2 = 'Pbcn'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ.  7) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 77) THEN
        NO_TAB  =   61
        NS_TAB  =    8
        SG_TAB1 = 'P 21/b 21/c 21/a'
        SG_TAB2 = 'Pbca'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 78) THEN
        NO_TAB  =   62
        NS_TAB  =    8
        SG_TAB1 = 'P 21/n 21/m 21/a'
        SG_TAB2 = 'Pnma'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X+1/2,-Y,Z+1/2'
        IF(IS.EQ.  3) OP =' -X,Y+1/2,-Z'
        IF(IS.EQ.  4) OP =' X+1/2,-Y+1/2,-Z+1/2'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X+1/2,Y,-Z+1/2'
        IF(IS.EQ.  7) OP =' X,-Y+1/2,Z'
        IF(IS.EQ.  8) OP =' -X+1/2,Y+1/2,Z+1/2'
        RETURN
      ENDIF
      IF(I.EQ. 79) THEN
        NO_TAB  =   63
        NS_TAB  =   16
        SG_TAB1 = 'C 2/m 2/c 21/m'
        SG_TAB2 = 'Cmcm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,1/2-Z'
        IF(IS.EQ.  7) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 80) THEN
        NO_TAB  =   64
        NS_TAB  =   16
        SG_TAB1 = 'C 2/m 2/c 21/a'
        SG_TAB2 = 'Cmca'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,1/2+Y,1/2-Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 10) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 81) THEN
        NO_TAB  =   65
        NS_TAB  =   16
        SG_TAB1 = 'C 2/m 2/m 2/m'
        SG_TAB2 = 'Cmmm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' X,-Y,Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 11) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 12) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 82) THEN
        NO_TAB  =   66
        NS_TAB  =   16
        SG_TAB1 = 'C 2/c 2/c 2/m'
        SG_TAB2 = 'Cccm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  4) OP =' X,-Y,1/2-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' -X,Y,1/2+Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 11) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 83) THEN
        NO_TAB  =   67
        NS_TAB  =   16
        SG_TAB1 = 'C 2/m 2/m 2/a'
        SG_TAB2 = 'Cmma'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,1/2+Y,-Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 10) OP =' 1/2-X,-Y,Z'
        IF(IS.EQ. 11) OP =' 1/2-X,Y,-Z'
        IF(IS.EQ. 12) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,Y,-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,-Y,Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 84) THEN
        NO_TAB  =   68
        NS_TAB  =   16
        SG_TAB1 = 'C 2/c 2/c 2/a'
        SG_TAB2 = 'Ccca'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,1/2-Y,1/2-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,Y,1/2+Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 10) OP =' -X,-Y,Z'
        IF(IS.EQ. 11) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 12) OP =' X,-Y,-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,-Y,1/2-Z'
        IF(IS.EQ. 14) OP =' X,1/2+Y,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' -X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 85) THEN
        NO_TAB  =   69
        NS_TAB  =   32
        SG_TAB1 = 'F 2/m 2/m 2/m'
        SG_TAB2 = 'Fmmm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' X,-Y,Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        IF(IS.EQ.  9) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 12) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' -X,1/2-Y,1/2-Z'
        IF(IS.EQ. 14) OP =' X,1/2+Y,1/2-Z'
        IF(IS.EQ. 15) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' -X,1/2+Y,1/2+Z'
        IF(IS.EQ. 17) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 18) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 19) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 20) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ. 21) OP =' 1/2-X,-Y,1/2-Z'
        IF(IS.EQ. 22) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ. 23) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ. 24) OP =' 1/2-X,Y,1/2+Z'
        IF(IS.EQ. 25) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 26) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 27) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 28) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 29) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 30) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ. 31) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 32) OP =' 1/2-X,1/2+Y,Z'
        RETURN
      ENDIF
      IF(I.EQ. 86) THEN
        NO_TAB  =   70
        NS_TAB  =   32
        SG_TAB1 = 'F 2/d 2/d 2/d'
        SG_TAB2 = 'Fddd'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' 1/4-X,1/4-Y,1/4-Z'
        IF(IS.EQ.  6) OP =' 1/4+X,1/4+Y,1/4-Z'
        IF(IS.EQ.  7) OP =' 1/4+X,1/4-Y,1/4+Z'
        IF(IS.EQ.  8) OP =' 1/4-X,1/4+Y,1/4+Z'
        IF(IS.EQ.  9) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 12) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/4-X,3/4-Y,3/4-Z'
        IF(IS.EQ. 14) OP =' 1/4+X,3/4+Y,3/4-Z'
        IF(IS.EQ. 15) OP =' 1/4+X,3/4-Y,3/4+Z'
        IF(IS.EQ. 16) OP =' 1/4-X,3/4+Y,3/4+Z'
        IF(IS.EQ. 17) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 18) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 19) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 20) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ. 21) OP =' 3/4-X,1/4-Y,3/4-Z'
        IF(IS.EQ. 22) OP =' 3/4+X,1/4+Y,3/4-Z'
        IF(IS.EQ. 23) OP =' 3/4+X,1/4-Y,3/4+Z'
        IF(IS.EQ. 24) OP =' 3/4-X,1/4+Y,3/4+Z'
        IF(IS.EQ. 25) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 26) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 27) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 28) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 29) OP =' 3/4-X,3/4-Y,1/4-Z'
        IF(IS.EQ. 30) OP =' 3/4+X,3/4+Y,1/4-Z'
        IF(IS.EQ. 31) OP =' 3/4+X,3/4-Y,1/4+Z'
        IF(IS.EQ. 32) OP =' 3/4-X,3/4+Y,1/4+Z'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_13(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ. 87) THEN
        NO_TAB  =   71
        NS_TAB  =   16
        SG_TAB1 = 'I 2/m 2/m 2/m'
        SG_TAB2 = 'Immm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' X,-Y,Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 88) THEN
        NO_TAB  =   72
        NS_TAB  =   16
        SG_TAB1 = 'I 2/b 2/a 2/m'
        SG_TAB2 = 'Ibam'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' -X,Y,1/2-Z'
        IF(IS.EQ. 12) OP =' X,-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 15) OP =' X,-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' -X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 89) THEN
        NO_TAB  =   73
        NS_TAB  =   16
        SG_TAB1 = 'I 21/b 21/c 21/a'
        SG_TAB2 = 'Ibca'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' -X,1/2-Y,Z'
        IF(IS.EQ. 11) OP =' 1/2-X,Y,-Z'
        IF(IS.EQ. 12) OP =' X,-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 14) OP =' X,1/2+Y,-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,-Y,Z'
        IF(IS.EQ. 16) OP =' -X,Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 90) THEN
        NO_TAB  =   74
        NS_TAB  =   16
        SG_TAB1 = 'I 21/m 21/m 21/a'
        SG_TAB2 = 'Imma'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,1/2+Y,-Z'
        IF(IS.EQ.  7) OP =' X,1/2-Y,Z'
        IF(IS.EQ.  8) OP =' -X,Y,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 91) THEN
        NO_TAB  =   75
        NS_TAB  =    4
        SG_TAB1 = 'P 4'
        SG_TAB2 = 'P4'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        RETURN
      ENDIF
      IF(I.EQ. 92) THEN
        NO_TAB  =   76
        NS_TAB  =    4
        SG_TAB1 = 'P 41'
        SG_TAB2 = 'P41'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/4+Z'
        IF(IS.EQ.  4) OP =' Y,-X,3/4+Z'
        RETURN
      ENDIF
      IF(I.EQ. 93) THEN
        NO_TAB  =   77
        NS_TAB  =    4
        SG_TAB1 = 'P 42'
        SG_TAB2 = 'P42'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 94) THEN
        NO_TAB  =   78
        NS_TAB  =    4
        SG_TAB1 = 'P 43'
        SG_TAB2 = 'P43'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,X,3/4+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/4+Z'
        RETURN
      ENDIF
      IF(I.EQ. 95) THEN
        NO_TAB  =   79
        NS_TAB  =    8
        SG_TAB1 = 'I 4'
        SG_TAB2 = 'I4'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2+Y,1/2-X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ. 96) THEN
        NO_TAB  =   80
        NS_TAB  =    8
        SG_TAB1 = 'I 41'
        SG_TAB2 = 'I41'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,1/2+X,1/4+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,-X,3/4+Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,-Y,Z'
        IF(IS.EQ.  7) OP =' 1/2-Y,X,3/4+Z'
        IF(IS.EQ.  8) OP =' Y,1/2-X,1/4+Z'
        RETURN
      ENDIF
      IF(I.EQ. 97) THEN
        NO_TAB  =   81
        NS_TAB  =    4
        SG_TAB1 = 'P -4'
        SG_TAB2 = 'P-4'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' Y,-X,-Z'
        IF(IS.EQ.  4) OP =' -Y,X,-Z'
        RETURN
      ENDIF
      IF(I.EQ. 98) THEN
        NO_TAB  =   82
        NS_TAB  =    8
        SG_TAB1 = 'I -4'
        SG_TAB2 = 'I-4'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' Y,-X,-Z'
        IF(IS.EQ.  4) OP =' -Y,X,-Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2+X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ. 99) THEN
        NO_TAB  =   83
        NS_TAB  =    8
        SG_TAB1 = 'P 4/m'
        SG_TAB2 = 'P4/m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' Y,-X,-Z'
        IF(IS.EQ.  8) OP =' -Y,X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.100) THEN
        NO_TAB  =   84
        NS_TAB  =    8
        SG_TAB1 = 'P 42/m'
        SG_TAB2 = 'P42/m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' Y,-X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,X,1/2-Z'
        RETURN
      ENDIF   
      IF(I.EQ.101) THEN
        NO_TAB  =   85
        NS_TAB  =    8
        SG_TAB1 = 'P 4/n'
        SG_TAB2 = 'P4/n'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ.  7) OP =' Y,-X,-Z'
        IF(IS.EQ.  8) OP =' -Y,X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.102) THEN
        NO_TAB  =   86
        NS_TAB  =    8
        SG_TAB1 = 'P 42/n'
        SG_TAB2 = 'P42/n'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,-X,-Z'
        IF(IS.EQ.  8) OP =' -Y,X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.103) THEN
        NO_TAB  =   87
        NS_TAB  =   16
        SG_TAB1 = 'I 4/m'
        SG_TAB2 = 'I4/m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,-Y,-Z'
        IF(IS.EQ.  6) OP =' X,Y,-Z'
        IF(IS.EQ.  7) OP =' Y,-X,-Z'
        IF(IS.EQ.  8) OP =' -Y,X,-Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 12) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2+X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.104) THEN
        NO_TAB  =   88
        NS_TAB  =   16
        SG_TAB1 = 'I 41/a'
        SG_TAB2 = 'I41/a'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,1/2+X,1/4+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,-X,3/4+Z'
        IF(IS.EQ.  5) OP =' -X,1/2-Y,1/4-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,Y,3/4-Z'
        IF(IS.EQ.  7) OP =' Y,-X,-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' -X,-Y,Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,X,3/4+Z'
        IF(IS.EQ. 12) OP =' Y,1/2-X,1/4+Z'
        IF(IS.EQ. 13) OP =' 1/2-X,-Y,3/4-Z'
        IF(IS.EQ. 14) OP =' X,1/2+Y,1/4-Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 16) OP =' -Y,X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.105) THEN
        NO_TAB  =   89
        NS_TAB  =    8
        SG_TAB1 = 'P 4 2 2'
        SG_TAB2 = 'P422'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.106) THEN
        NO_TAB  =   90
        NS_TAB  =    8
        SG_TAB1 = 'P 4 21 2'
        SG_TAB2 = 'P4212'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.107) THEN
        NO_TAB  =   91
        NS_TAB  =    8
        SG_TAB1 = 'P 41 2 2'
        SG_TAB2 = 'P4122'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/4+Z'
        IF(IS.EQ.  4) OP =' Y,-X,3/4+Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,3/4-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/4-Z'
        RETURN
      ENDIF
      IF(I.EQ.108) THEN
        NO_TAB  =   92
        NS_TAB  =    8
        SG_TAB1 = 'P 41 21 2'
        SG_TAB2 = 'P41212'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,1/4+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,3/4+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,1/4-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,3/4-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.109) THEN
        NO_TAB  =   93
        NS_TAB  =    8
        SG_TAB1 = 'P 42 2 2'
        SG_TAB2 = 'P4222'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.110) THEN
        NO_TAB  =   94
        NS_TAB  =    8
        SG_TAB1 = 'P 42 21 2'
        SG_TAB2 = 'P42212'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.111) THEN
        NO_TAB  = 1094
        NS_TAB  =    8
        SG_TAB1 = 'P 42 21 2 (a)'
        SG_TAB2 = 'P42212a'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X+1/2,1/2+Z'
        IF(IS.EQ.  4) OP =' Y+1/2,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' -X,Y+1/2,-Z'
        IF(IS.EQ.  6) OP =' X+1/2,-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2-X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.112) THEN
        NO_TAB  =   95
        NS_TAB  =    8
        SG_TAB1 = 'P 43 2 2'
        SG_TAB2 = 'P4322'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,X,3/4+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/4+Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,1/4-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,3/4-Z'
        RETURN
      ENDIF
      IF(I.EQ.113) THEN
        NO_TAB  =   96
        NS_TAB  =    8
        SG_TAB1 = 'P 43 21 2'
        SG_TAB2 = 'P43212'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,3/4+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,1/4+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,3/4-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,1/4-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.114) THEN
        NO_TAB  =   97
        NS_TAB  =   16
        SG_TAB1 = 'I 4 2 2'
        SG_TAB2 = 'I422'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 12) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2-X,1/2-Z'
        RETURN
      ENDIF
      RETURN
      END


      SUBROUTINE GET_SPACE_GROUP_INFO_14(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.115) THEN
        NO_TAB  =   98
        NS_TAB  =   16
        SG_TAB1 = 'I 41 2 2'
        SG_TAB2 = 'I4122'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,1/2+X,1/4+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,-X,3/4+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,Y,3/4-Z'
        IF(IS.EQ.  6) OP =' X,1/2-Y,1/4-Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' -X,-Y,Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,X,3/4+Z'
        IF(IS.EQ. 12) OP =' Y,1/2-X,1/4+Z'
        IF(IS.EQ. 13) OP =' -X,1/2+Y,1/4-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,-Y,3/4-Z'
        IF(IS.EQ. 15) OP =' Y,X,-Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2-X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.116) THEN
        NO_TAB  =   99
        NS_TAB  =    8
        SG_TAB1 = 'P 4 m m'
        SG_TAB2 = 'P4mm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' X,-Y,Z'
        IF(IS.EQ.  6) OP =' -X,Y,Z'
        IF(IS.EQ.  7) OP =' -Y,-X,Z'
        IF(IS.EQ.  8) OP =' Y,X,Z'
        RETURN
      ENDIF
      IF(I.EQ.117) THEN
        NO_TAB  =  100
        NS_TAB  =    8
        SG_TAB1 = 'P 4 b m'
        SG_TAB2 = 'P4bm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.  7) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ.  8) OP =' 1/2+Y,1/2+X,Z'
        RETURN
      ENDIF
      IF(I.EQ.118) THEN
        NO_TAB  =  101
        NS_TAB  =    8
        SG_TAB1 = 'P 42 c m'
        SG_TAB2 = 'P42cm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,Y,1/2+Z'
        IF(IS.EQ.  7) OP =' -Y,-X,Z'
        IF(IS.EQ.  8) OP =' Y,X,Z'
        RETURN
      ENDIF
      IF(I.EQ.119) THEN
        NO_TAB  =  102
        NS_TAB  =    8
        SG_TAB1 = 'P 42 n m'
        SG_TAB2 = 'P42nm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ.  7) OP =' -Y,-X,Z'
        IF(IS.EQ.  8) OP =' Y,X,Z'
        RETURN
      ENDIF
      IF(I.EQ.120) THEN
        NO_TAB  =  103
        NS_TAB  =    8
        SG_TAB1 = 'P 4 c c'
        SG_TAB2 = 'P4cc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,Y,1/2+Z'
        IF(IS.EQ.  7) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.  8) OP =' Y,X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.121) THEN
        NO_TAB  =  104
        NS_TAB  =    8
        SG_TAB1 = 'P 4 n c'
        SG_TAB2 = 'P4nc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.122) THEN
        NO_TAB  =  105
        NS_TAB  =    8
        SG_TAB1 = 'P 42 m c'
        SG_TAB2 = 'P42mc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' X,-Y,Z'
        IF(IS.EQ.  6) OP =' -X,Y,Z'
        IF(IS.EQ.  7) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.  8) OP =' Y,X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.123) THEN
        NO_TAB  =  106
        NS_TAB  =    8
        SG_TAB1 = 'P 42 b c'
        SG_TAB2 = 'P42bc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.  7) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.124) THEN
        NO_TAB  =  107
        NS_TAB  =   16
        SG_TAB1 = 'I 4 m m'
        SG_TAB2 = 'I4mm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' X,-Y,Z'
        IF(IS.EQ.  6) OP =' -X,Y,Z'
        IF(IS.EQ.  7) OP =' -Y,-X,Z'
        IF(IS.EQ.  8) OP =' Y,X,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 12) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.125) THEN
        NO_TAB  =  108
        NS_TAB  =   16
        SG_TAB1 = 'I 4 c m'
        SG_TAB2 = 'I4cm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,Y,1/2+Z'
        IF(IS.EQ.  7) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.  8) OP =' Y,X,1/2+Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 12) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,Z'
        RETURN
      ENDIF
      IF(I.EQ.126) THEN
        NO_TAB  =  109
        NS_TAB  =   16
        SG_TAB1 = 'I 41 m d'
        SG_TAB2 = 'I41md'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,1/2+X,1/4+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,-X,3/4+Z'
        IF(IS.EQ.  5) OP =' X,-Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ.  7) OP =' -Y,1/2-X,1/4+Z'
        IF(IS.EQ.  8) OP =' 1/2+Y,X,3/4+Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' -X,-Y,Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,X,3/4+Z'
        IF(IS.EQ. 12) OP =' Y,1/2-X,1/4+Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,-X,3/4+Z'
        IF(IS.EQ. 16) OP =' Y,1/2+X,1/4+Z'
        RETURN
      ENDIF
      IF(I.EQ.127) THEN
        NO_TAB  =  110
        NS_TAB  =   16
        SG_TAB1 = 'I 41 c d'
        SG_TAB2 = 'I41cd'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,1/2+X,1/4+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,-X,3/4+Z'
        IF(IS.EQ.  5) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.  7) OP =' -Y,1/2-X,3/4+Z'
        IF(IS.EQ.  8) OP =' 1/2+Y,X,1/4+Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' -X,-Y,Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,X,3/4+Z'
        IF(IS.EQ. 12) OP =' Y,1/2-X,1/4+Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 14) OP =' -X,Y,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,-X,1/4+Z'
        IF(IS.EQ. 16) OP =' Y,1/2+X,3/4+Z'
        RETURN
      ENDIF
      IF(I.EQ.128) THEN
        NO_TAB  =  111
        NS_TAB  =    8
        SG_TAB1 = 'P -4 2 m'
        SG_TAB2 = 'P-42m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' -Y,-X,Z'
        IF(IS.EQ.  8) OP =' Y,X,Z'
        RETURN
      ENDIF
      IF(I.EQ.129) THEN
        NO_TAB  =  112
        NS_TAB  =    8
        SG_TAB1 = 'P -4 2 c'
        SG_TAB2 = 'P-42c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  6) OP =' X,-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.  8) OP =' Y,X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.130) THEN
        NO_TAB  =  113
        NS_TAB  =    8
        SG_TAB1 = 'P -4 21 m'
        SG_TAB2 = 'P-421m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  7) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ.  8) OP =' 1/2+Y,1/2+X,Z'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_2(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.131) THEN
        NO_TAB  =  114
        NS_TAB  =    8
        SG_TAB1 = 'P -4 21 c'
        SG_TAB2 = 'P-421c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ.  8) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.132) THEN
        NO_TAB  =  115
        NS_TAB  =    8
        SG_TAB1 = 'P -4 m 2'
        SG_TAB2 = 'P-4m2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' Y,-X,-Z'
        IF(IS.EQ.  4) OP =' -Y,X,-Z'
        IF(IS.EQ.  5) OP =' X,-Y,Z'
        IF(IS.EQ.  6) OP =' -X,Y,Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.133) THEN
        NO_TAB  =  116
        NS_TAB  =    8
        SG_TAB1 = 'P -4 c 2'
        SG_TAB2 = 'P-4c2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,Y,1/2+Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.134) THEN
        NO_TAB  =  117
        NS_TAB  =    8
        SG_TAB1 = 'P -4 b 2'
        SG_TAB2 = 'P-4b2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2-X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.135) THEN
        NO_TAB  =  118
        NS_TAB  =    8
        SG_TAB1 = 'P -4 n 2'
        SG_TAB2 = 'P-4n2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2-X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.136) THEN
        NO_TAB  =  119
        NS_TAB  =   16
        SG_TAB1 = 'I -4 m 2'
        SG_TAB2 = 'I-4m2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' X,-Y,Z'
        IF(IS.EQ.  6) OP =' -X,Y,Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2-X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.137) THEN
        NO_TAB  =  120
        NS_TAB  =   16
        SG_TAB1 = 'I -4 c 2'
        SG_TAB2 = 'I-4c2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' X,-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,Y,1/2+Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2+X,-Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2-X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.138) THEN
        NO_TAB  =  121
        NS_TAB  =   16
        SG_TAB1 = 'I -4 2 m'
        SG_TAB2 = 'I-42m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' -Y,-X,Z'
        IF(IS.EQ.  8) OP =' Y,X,Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.139) THEN
        NO_TAB  =  122
        NS_TAB  =   16
        SG_TAB1 = 'I -4 2 d'
        SG_TAB2 = 'I-42d'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,-Z'
        IF(IS.EQ.  4) OP =' Y,-X,-Z'
        IF(IS.EQ.  5) OP =' 1/2-X,Y,3/4-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,-Y,3/4-Z'
        IF(IS.EQ.  7) OP =' 1/2-Y,-X,3/4+Z'
        IF(IS.EQ.  8) OP =' 1/2+Y,X,3/4+Z'
        IF(IS.EQ.  9) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 10) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 11) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 13) OP =' -X,1/2+Y,1/4-Z'
        IF(IS.EQ. 14) OP =' X,1/2-Y,1/4-Z'
        IF(IS.EQ. 15) OP =' -Y,1/2-X,1/4+Z'
        IF(IS.EQ. 16) OP =' Y,1/2+X,1/4+Z'
        RETURN
      ENDIF
      IF(I.EQ.140) THEN
        NO_TAB  =  123
        NS_TAB  =   16
        SG_TAB1 = 'P 4/m 2/m 2/m'
        SG_TAB2 = 'P4/mmm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' X,-Y,Z'
        IF(IS.EQ. 14) OP =' -X,Y,Z'
        IF(IS.EQ. 15) OP =' -Y,-X,Z'
        IF(IS.EQ. 16) OP =' Y,X,Z'
        RETURN
      ENDIF
      IF(I.EQ.141) THEN
        NO_TAB  =  124
        NS_TAB  =   16
        SG_TAB1 = 'P 4/m 2/c 2/c'
        SG_TAB2 = 'P4/mcc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  6) OP =' X,-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' X,-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,Y,1/2+Z'
        IF(IS.EQ. 15) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 16) OP =' Y,X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.142) THEN
        NO_TAB  =  125
        NS_TAB  =   16
        SG_TAB1 = 'P 4/n 2/b 2/m'
        SG_TAB2 = 'P4/nbm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-X,-Z'
        IF(IS.EQ. 12) OP =' 1/2-Y,1/2+X,-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,Z'
        RETURN
      ENDIF
      IF(I.EQ.143) THEN
        NO_TAB  =  126
        NS_TAB  =   16
        SG_TAB1 = 'P 4/n 2/n 2/c'
        SG_TAB2 = 'P4/nnc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.144) THEN
        NO_TAB  =  127
        NS_TAB  =   16
        SG_TAB1 = 'P 4/m 21/b 2/m'
        SG_TAB2 = 'P4/mbm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2-X,-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,Z'
        RETURN
      ENDIF
      IF(I.EQ.145) THEN
        NO_TAB  =  128
        NS_TAB  =   16
        SG_TAB1 = 'P 4/m 21/n 2/c'
        SG_TAB2 = 'P4/mnc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_21(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.146) THEN
        NO_TAB  =  129
        NS_TAB  =   16
        SG_TAB1 = 'P 4/n 21/m 2/m'
        SG_TAB2 = 'P4/nmm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' X,-Y,Z'
        IF(IS.EQ. 14) OP =' -X,Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,Z'
        RETURN
      ENDIF
      IF(I.EQ.147) THEN
        NO_TAB  =  130
        NS_TAB  =   16
        SG_TAB1 = 'P 4/n 2/c 2/c'
        SG_TAB2 = 'P4/ncc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ.  9) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' X,-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,Y,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.148) THEN
        NO_TAB  =  131
        NS_TAB  =   16
        SG_TAB1 = 'P 42/m 2/m 2/c'
        SG_TAB2 = 'P42/mmc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,1/2-Z'
        IF(IS.EQ. 12) OP =' -Y,X,1/2-Z'
        IF(IS.EQ. 13) OP =' X,-Y,Z'
        IF(IS.EQ. 14) OP =' -X,Y,Z'
        IF(IS.EQ. 15) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 16) OP =' Y,X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.149) THEN
        NO_TAB  =  132
        NS_TAB  =   16
        SG_TAB1 = 'P 42/m 2/c 2/m'
        SG_TAB2 = 'P42/mcm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  6) OP =' X,-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,1/2-Z'
        IF(IS.EQ. 12) OP =' -Y,X,1/2-Z'
        IF(IS.EQ. 13) OP =' X,-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,Y,1/2+Z'
        IF(IS.EQ. 15) OP =' -Y,-X,Z'
        IF(IS.EQ. 16) OP =' Y,X,Z'
        RETURN
      ENDIF
      IF(I.EQ.150) THEN
        NO_TAB  =  133
        NS_TAB  =   16
        SG_TAB1 = 'P 42/n 2/b 2/c'
        SG_TAB2 = 'P42/nbc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ.  5) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  6) OP =' X,-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2-X,-Z'
        IF(IS.EQ.  9) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 15) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 16) OP =' Y,X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.151) THEN
        NO_TAB  =  134
        NS_TAB  =   16
        SG_TAB1 = 'P 42/n 2/n 2/m'
        SG_TAB2 = 'P42/nnm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ.  9) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 15) OP =' -Y,-X,Z'
        IF(IS.EQ. 16) OP =' Y,X,Z'
        RETURN
      ENDIF
      IF(I.EQ.152) THEN
        NO_TAB  =  135
        NS_TAB  =   16
        SG_TAB1 = 'P 42/m 21/b 2/c'
        SG_TAB2 = 'P42/mbc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.  4) OP =' Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ.  8) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,1/2-Z'
        IF(IS.EQ. 12) OP =' -Y,X,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.153) THEN
        NO_TAB  =  136
        NS_TAB  =   16
        SG_TAB1 = 'P 42/m 21/n 2/m'
        SG_TAB2 = 'P42/mnm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,X+1/2,Z+1/2'
        IF(IS.EQ.  4) OP =' Y+1/2,1/2-X,Z+1/2'
        IF(IS.EQ.  5) OP =' 1/2-X,Y+1/2,1/2-Z'
        IF(IS.EQ.  6) OP =' X+1/2,1/2-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y+1/2,1/2-X,1/2-Z'
        IF(IS.EQ. 12) OP =' 1/2-Y,X+1/2,1/2-Z'
        IF(IS.EQ. 13) OP =' X+1/2,1/2-Y,Z+1/2'
        IF(IS.EQ. 14) OP =' 1/2-X,Y+1/2,Z+1/2'
        IF(IS.EQ. 15) OP =' -Y,-X,Z'
        IF(IS.EQ. 16) OP =' Y,X,Z'
        RETURN
      ENDIF
      IF(I.EQ.154) THEN
        NO_TAB  =  137
        NS_TAB  =   16
        SG_TAB1 = 'P 42/n 21/m 2/c'
        SG_TAB2 = 'P42/nmc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' X,-Y,Z'
        IF(IS.EQ. 14) OP =' -X,Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.155) THEN
        NO_TAB  =  138
        NS_TAB  =   16
        SG_TAB1 = 'P 42/n 21/c 2/m'
        SG_TAB2 = 'P42/ncm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  6) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ.  9) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' X,-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,Y,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ. 16) OP =' 1/2+Y,1/2+X,Z'
        RETURN
      ENDIF
      IF(I.EQ.156) THEN
        NO_TAB  =  139
        NS_TAB  =   32
        SG_TAB1 = 'I 4/m 2/m 2/m'
        SG_TAB2 = 'I4/mmm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,-Y,-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' X,-Y,Z'
        IF(IS.EQ. 14) OP =' -X,Y,Z'
        IF(IS.EQ. 15) OP =' -Y,-X,Z'
        IF(IS.EQ. 16) OP =' Y,X,Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 18) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 19) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 20) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 21) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 22) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 23) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ. 24) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ. 25) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 26) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 27) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 28) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 29) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 30) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 31) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 32) OP =' 1/2+Y,1/2+X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.157) THEN
        NO_TAB  =  140
        NS_TAB  =   32
        SG_TAB1 = 'I 4/m 2/c 2/m'
        SG_TAB2 = 'I4/mcm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -Y,X,Z'
        IF(IS.EQ.  4) OP =' Y,-X,Z'
        IF(IS.EQ.  5) OP =' -X,Y,1/2-Z'
        IF(IS.EQ.  6) OP =' X,-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ.  9) OP =' -X,-Y,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' -Y,X,-Z'
        IF(IS.EQ. 13) OP =' X,-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,Y,1/2+Z'
        IF(IS.EQ. 15) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 16) OP =' Y,X,1/2+Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 18) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 19) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 20) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 21) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 22) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 23) OP =' 1/2+Y,1/2+X,-Z'
        IF(IS.EQ. 24) OP =' 1/2-Y,1/2-X,-Z'
        IF(IS.EQ. 25) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 26) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 27) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 28) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 29) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 30) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 31) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ. 32) OP =' 1/2+Y,1/2+X,Z'
        RETURN
      ENDIF
      IF(I.EQ.158) THEN
        NO_TAB  =  141
        NS_TAB  =   32
        SG_TAB1 = 'I 41/a 2/m 2/d'
        SG_TAB2 = 'I41/amd'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,1/2+X,1/4+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,-X,3/4+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,Y,3/4-Z'
        IF(IS.EQ.  6) OP =' X,1/2-Y,1/4-Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,-Z'
        IF(IS.EQ.  9) OP =' -X,1/2-Y,1/4-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,Y,3/4-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,-X,3/4+Z'
        IF(IS.EQ. 16) OP =' Y,1/2+X,1/4+Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 18) OP =' -X,-Y,Z'
        IF(IS.EQ. 19) OP =' 1/2-Y,X,3/4+Z'
        IF(IS.EQ. 20) OP =' Y,1/2-X,1/4+Z'
        IF(IS.EQ. 21) OP =' -X,1/2+Y,1/4-Z'
        IF(IS.EQ. 22) OP =' 1/2+X,-Y,3/4-Z'
        IF(IS.EQ. 23) OP =' Y,X,-Z'
        IF(IS.EQ. 24) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ. 25) OP =' 1/2-X,-Y,3/4-Z'
        IF(IS.EQ. 26) OP =' X,1/2+Y,1/4-Z'
        IF(IS.EQ. 27) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 28) OP =' -Y,X,-Z'
        IF(IS.EQ. 29) OP =' X,-Y,Z'
        IF(IS.EQ. 30) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 31) OP =' -Y,1/2-X,1/4+Z'
        IF(IS.EQ. 32) OP =' 1/2+Y,X,3/4+Z'
        RETURN
      ENDIF
      IF(I.EQ.159) THEN
        NO_TAB  =  142
        NS_TAB  =   32
        SG_TAB1 = 'I 41/a 2/c 2/d'
        SG_TAB2 = 'I41/acd'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -Y,1/2+X,1/4+Z'
        IF(IS.EQ.  4) OP =' 1/2+Y,-X,3/4+Z'
        IF(IS.EQ.  5) OP =' 1/2-X,Y,1/4-Z'
        IF(IS.EQ.  6) OP =' X,1/2-Y,3/4-Z'
        IF(IS.EQ.  7) OP =' 1/2+Y,1/2+X,-Z'
        IF(IS.EQ.  8) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ.  9) OP =' -X,1/2-Y,1/4-Z'
        IF(IS.EQ. 10) OP =' 1/2+X,Y,3/4-Z'
        IF(IS.EQ. 11) OP =' Y,-X,-Z'
        IF(IS.EQ. 12) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 14) OP =' -X,Y,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2-Y,-X,1/4+Z'
        IF(IS.EQ. 16) OP =' Y,1/2+X,3/4+Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 18) OP =' -X,-Y,Z'
        IF(IS.EQ. 19) OP =' 1/2-Y,X,3/4+Z'
        IF(IS.EQ. 20) OP =' Y,1/2-X,1/4+Z'
        IF(IS.EQ. 21) OP =' -X,1/2+Y,3/4-Z'
        IF(IS.EQ. 22) OP =' 1/2+X,-Y,1/4-Z'
        IF(IS.EQ. 23) OP =' Y,X,1/2-Z'
        IF(IS.EQ. 24) OP =' 1/2-Y,1/2-X,-Z'
        IF(IS.EQ. 25) OP =' 1/2-X,-Y,3/4-Z'
        IF(IS.EQ. 26) OP =' X,1/2+Y,1/4-Z'
        IF(IS.EQ. 27) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 28) OP =' -Y,X,-Z'
        IF(IS.EQ. 29) OP =' X,-Y,1/2+Z'
        IF(IS.EQ. 30) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 31) OP =' -Y,1/2-X,3/4+Z'
        IF(IS.EQ. 32) OP =' 1/2+Y,X,1/4+Z'
        RETURN
      ENDIF
      IF(I.EQ.160) THEN
        NO_TAB  =  143
        NS_TAB  =    3
        SG_TAB1 = 'P 3'
        SG_TAB2 = 'P3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        RETURN
      ENDIF
      IF(I.EQ.161) THEN
        NO_TAB  =  144
        NS_TAB  =    3
        SG_TAB1 = 'P 31'
        SG_TAB2 = 'P31'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z+1/3'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z+2/3'
        RETURN
      ENDIF
      IF(I.EQ.162) THEN
        NO_TAB  =  145
        NS_TAB  =    3
        SG_TAB1 = 'P 32'
        SG_TAB2 = 'P32'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z+2/3'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z+1/3'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_22(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.163) THEN
        NO_TAB  =  146
        NS_TAB  =    9
        SG_TAB1 = 'H 3'
        SG_TAB2 = 'H3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' X+2/3,Y+1/3,Z+1/3'
        IF(IS.EQ.  5) OP =' -Y+2/3,X-Y+1/3,Z+1/3'
        IF(IS.EQ.  6) OP =' Y-X+2/3,-X+1/3,Z+1/3'
        IF(IS.EQ.  7) OP =' X+1/3,Y+2/3,Z+2/3'
        IF(IS.EQ.  8) OP =' -Y+1/3,X-Y+2/3,Z+2/3'
        IF(IS.EQ.  9) OP =' Y-X+1/3,-X+2/3,Z+2/3'
        RETURN
      ENDIF
      IF(I.EQ.164) THEN
        NO_TAB  = 1146
        NS_TAB  =    3
        SG_TAB1 = 'R 3'
        SG_TAB2 = 'R3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' Z,X,Y'
        IF(IS.EQ.  3) OP =' Y,Z,X'
        RETURN
      ENDIF
      IF(I.EQ.165) THEN
        NO_TAB  =  147
        NS_TAB  =    6
        SG_TAB1 = 'P -3'
        SG_TAB2 = 'P-3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  6) OP =' X-Y,X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.166) THEN
        NO_TAB  =  148
        NS_TAB  =   18
        SG_TAB1 = 'R -3'
        SG_TAB2 = 'R-3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  6) OP =' X-Y,X,-Z'
        IF(IS.EQ.  7) OP =' 2/3+X,1/3+Y,1/3+Z'
        IF(IS.EQ.  8) OP =' 2/3-Y,1/3+X-Y,1/3+Z'
        IF(IS.EQ.  9) OP =' 2/3+Y-X,1/3-X,1/3+Z'
        IF(IS.EQ. 10) OP =' 2/3-X,1/3-Y,1/3-Z'
        IF(IS.EQ. 11) OP =' 2/3+Y,1/3+Y-X,1/3-Z'
        IF(IS.EQ. 12) OP =' 2/3+X-Y,1/3+X,1/3-Z'
        IF(IS.EQ. 13) OP =' 1/3+X,2/3+Y,2/3+Z'
        IF(IS.EQ. 14) OP =' 1/3-Y,2/3+X-Y,2/3+Z'
        IF(IS.EQ. 15) OP =' 1/3+Y-X,2/3-X,2/3+Z'
        IF(IS.EQ. 16) OP =' 1/3-X,2/3-Y,2/3-Z'
        IF(IS.EQ. 17) OP =' 1/3+Y,2/3+Y-X,2/3-Z'
        IF(IS.EQ. 18) OP =' 1/3+X-Y,2/3+X,2/3-Z'
        RETURN
      ENDIF
      IF(I.EQ.167) THEN
        NO_TAB  =  149
        NS_TAB  =    6
        SG_TAB1 = 'P 3 1 2'
        SG_TAB2 = 'P312'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -Y,-X,-Z'
        IF(IS.EQ.  5) OP =' Y-X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,X-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ.168) THEN
        NO_TAB  =  150
        NS_TAB  =    6
        SG_TAB1 = 'P 3 2 1'
        SG_TAB2 = 'P321'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' Y,X,-Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.169) THEN
        NO_TAB  =  151
        NS_TAB  =    6
        SG_TAB1 = 'P 31 1 2'
        SG_TAB2 = 'P3112'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,1/3+Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,2/3+Z'
        IF(IS.EQ.  4) OP =' -Y,-X,2/3-Z'
        IF(IS.EQ.  5) OP =' Y-X,Y,1/3-Z'
        IF(IS.EQ.  6) OP =' X,X-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ.170) THEN
        NO_TAB  =  152
        NS_TAB  =    6
        SG_TAB1 = 'P 31 2 1'
        SG_TAB2 = 'P3121'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z+1/3'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z+2/3'
        IF(IS.EQ.  4) OP =' Y,X,-Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,2/3-Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,1/3-Z'
        RETURN
      ENDIF
      IF(I.EQ.171) THEN
        NO_TAB  =  153
        NS_TAB  =    6
        SG_TAB1 = 'P 32 1 2'
        SG_TAB2 = 'P3212'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,2/3+Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,1/3+Z'
        IF(IS.EQ.  4) OP =' -Y,-X,1/3-Z'
        IF(IS.EQ.  5) OP =' Y-X,Y,2/3-Z'
        IF(IS.EQ.  6) OP =' X,X-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ.172) THEN
        NO_TAB  =  154
        NS_TAB  =    6
        SG_TAB1 = 'P 32 2 1'
        SG_TAB2 = 'P3221'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z+2/3'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z+1/3'
        IF(IS.EQ.  4) OP =' Y,X,-Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,1/3-Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,2/3-Z'
        RETURN
      ENDIF
      IF(I.EQ.173) THEN
        NO_TAB  =  155
        NS_TAB  =   18
        SG_TAB1 = 'H 3 2'
        SG_TAB2 = 'H32'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' Y,X,-Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,-Z'
        IF(IS.EQ.  7) OP =' 2/3+X,1/3+Y,1/3+Z'
        IF(IS.EQ.  8) OP =' 2/3-Y,1/3+X-Y,1/3+Z'
        IF(IS.EQ.  9) OP =' 2/3+Y-X,1/3-X,1/3+Z'
        IF(IS.EQ. 10) OP =' 2/3+Y,1/3+X,1/3-Z'
        IF(IS.EQ. 11) OP =' 2/3+X-Y,1/3-Y,1/3-Z'
        IF(IS.EQ. 12) OP =' 2/3-X,1/3+Y-X,1/3-Z'
        IF(IS.EQ. 13) OP =' 1/3+X,2/3+Y,2/3+Z'
        IF(IS.EQ. 14) OP =' 1/3-Y,2/3+X-Y,2/3+Z'
        IF(IS.EQ. 15) OP =' 1/3+Y-X,2/3-X,2/3+Z'
        IF(IS.EQ. 16) OP =' 1/3+Y,2/3+X,2/3-Z'
        IF(IS.EQ. 17) OP =' 1/3+X-Y,2/3-Y,2/3-Z'
        IF(IS.EQ. 18) OP =' 1/3-X,2/3+Y-X,2/3-Z'
        RETURN
      ENDIF
      IF(I.EQ.174) THEN
        NO_TAB  = 1155
        NS_TAB  =    6
        SG_TAB1 = 'R 3 2'
        SG_TAB2 = 'R32'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' Z,X,Y'
        IF(IS.EQ.  3) OP =' Y,Z,X'
        IF(IS.EQ.  4) OP =' -Y,-X,-Z'
        IF(IS.EQ.  5) OP =' -Z,-Y,-X'
        IF(IS.EQ.  6) OP =' -X,-Z,-Y'
        RETURN
      ENDIF
      IF(I.EQ.175) THEN
        NO_TAB  =  156
        NS_TAB  =    6
        SG_TAB1 = 'P 3 m 1'
        SG_TAB2 = 'P3m1'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -Y,-X,Z'
        IF(IS.EQ.  5) OP =' Y-X,Y,Z'
        IF(IS.EQ.  6) OP =' X,X-Y,Z'
        RETURN
      ENDIF
      IF(I.EQ.176) THEN
        NO_TAB  =  157
        NS_TAB  =    6
        SG_TAB1 = 'P 3 1 m'
        SG_TAB2 = 'P31m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' Y,X,Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,Z'
        RETURN
      ENDIF
      IF(I.EQ.177) THEN
        NO_TAB  =  158
        NS_TAB  =    6
        SG_TAB1 = 'P 3 c 1'
        SG_TAB2 = 'P3c1'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' Y-X,Y,1/2+Z'
        IF(IS.EQ.  6) OP =' X,X-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.178) THEN
        NO_TAB  =  159
        NS_TAB  =    6
        SG_TAB1 = 'P 3 1 c'
        SG_TAB2 = 'P31c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' Y,X,1/2+Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,1/2+Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.179) THEN
        NO_TAB  =  160
        NS_TAB  =   18
        SG_TAB1 = 'R 3 m'
        SG_TAB2 = 'R3m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -Y,-X,Z'
        IF(IS.EQ.  5) OP =' Y-X,Y,Z'
        IF(IS.EQ.  6) OP =' X,X-Y,Z'
        IF(IS.EQ.  7) OP =' 2/3+X,1/3+Y,1/3+Z'
        IF(IS.EQ.  8) OP =' 2/3-Y,1/3+X-Y,1/3+Z'
        IF(IS.EQ.  9) OP =' 2/3+Y-X,1/3-X,1/3+Z'
        IF(IS.EQ. 10) OP =' 2/3-Y,1/3-X,1/3+Z'
        IF(IS.EQ. 11) OP =' 2/3+Y-X,1/3+Y,1/3+Z'
        IF(IS.EQ. 12) OP =' 2/3+X,1/3+X-Y,1/3+Z'
        IF(IS.EQ. 13) OP =' 1/3+X,2/3+Y,2/3+Z'
        IF(IS.EQ. 14) OP =' 1/3-Y,2/3+X-Y,2/3+Z'
        IF(IS.EQ. 15) OP =' 1/3+Y-X,2/3-X,2/3+Z'
        IF(IS.EQ. 16) OP =' 1/3-Y,2/3-X,2/3+Z'
        IF(IS.EQ. 17) OP =' 1/3+Y-X,2/3+Y,2/3+Z'
        IF(IS.EQ. 18) OP =' 1/3+X,2/3+X-Y,2/3+Z'
        RETURN
      ENDIF
      IF(I.EQ.180) THEN
        NO_TAB  =  161
        NS_TAB  =   18
        SG_TAB1 = 'R 3 c'
        SG_TAB2 = 'R3c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.  5) OP =' Y-X,Y,1/2+Z'
        IF(IS.EQ.  6) OP =' X,X-Y,1/2+Z'
        IF(IS.EQ.  7) OP =' 2/3+X,1/3+Y,1/3+Z'
        IF(IS.EQ.  8) OP =' 2/3-Y,1/3+X-Y,1/3+Z'
        IF(IS.EQ.  9) OP =' 2/3+Y-X,1/3-X,1/3+Z'
        IF(IS.EQ. 10) OP =' 2/3-Y,1/3-X,5/6+Z'
        IF(IS.EQ. 11) OP =' 2/3+Y-X,1/3+Y,5/6+Z'
        IF(IS.EQ. 12) OP =' 2/3+X,1/3+X-Y,5/6+Z'
        IF(IS.EQ. 13) OP =' 1/3+X,2/3+Y,2/3+Z'
        IF(IS.EQ. 14) OP =' 1/3-Y,2/3+X-Y,2/3+Z'
        IF(IS.EQ. 15) OP =' 1/3+Y-X,2/3-X,2/3+Z'
        IF(IS.EQ. 16) OP =' 1/3-Y,2/3-X,1/6+Z'
        IF(IS.EQ. 17) OP =' 1/3+Y-X,2/3+Y,1/6+Z'
        IF(IS.EQ. 18) OP =' 1/3+X,2/3+X-Y,1/6+Z'
        RETURN
      ENDIF
      IF(I.EQ.181) THEN
        NO_TAB  =  162
        NS_TAB  =   12
        SG_TAB1 = 'P -31 2/m'
        SG_TAB2 = 'P-31m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -Y,-X,-Z'
        IF(IS.EQ.  5) OP =' Y-X,Y,-Z'
        IF(IS.EQ.  6) OP =' X,X-Y,-Z'
        IF(IS.EQ.  7) OP =' -X,-Y,-Z'
        IF(IS.EQ.  8) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  9) OP =' X-Y,X,-Z'
        IF(IS.EQ. 10) OP =' Y,X,Z'
        IF(IS.EQ. 11) OP =' X-Y,-Y,Z'
        IF(IS.EQ. 12) OP =' -X,Y-X,Z'
        RETURN
      ENDIF
      IF(I.EQ.182) THEN
        NO_TAB  =  163
        NS_TAB  =   12
        SG_TAB1 = 'P -31 2/c'
        SG_TAB2 = 'P-31c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ.  5) OP =' Y-X,Y,1/2-Z'
        IF(IS.EQ.  6) OP =' X,X-Y,1/2-Z'
        IF(IS.EQ.  7) OP =' -X,-Y,-Z'
        IF(IS.EQ.  8) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  9) OP =' X-Y,X,-Z'
        IF(IS.EQ. 10) OP =' Y,X,1/2+Z'
        IF(IS.EQ. 11) OP =' X-Y,-Y,1/2+Z'
        IF(IS.EQ. 12) OP =' -X,Y-X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.183) THEN
        NO_TAB  =  164
        NS_TAB  =   12
        SG_TAB1 = 'P -3 2/m 1'
        SG_TAB2 = 'P-3m1'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' Y,X,-Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,-Z'
        IF(IS.EQ.  7) OP =' -X,-Y,-Z'
        IF(IS.EQ.  8) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  9) OP =' X-Y,X,-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,Z'
        IF(IS.EQ. 12) OP =' X,X-Y,Z'
        RETURN
      ENDIF
      IF(I.EQ.184) THEN
        NO_TAB  =  165
        NS_TAB  =   12
        SG_TAB1 = 'P -3 2/c 1'
        SG_TAB2 = 'P-3c1'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,1/2-Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,1/2-Z'
        IF(IS.EQ.  7) OP =' -X,-Y,-Z'
        IF(IS.EQ.  8) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  9) OP =' X-Y,X,-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,1/2+Z'
        IF(IS.EQ. 12) OP =' X,X-Y,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.185) THEN
        NO_TAB  =  166
        NS_TAB  =   36
        SG_TAB1 = 'R -3 2/m'
        SG_TAB2 = 'R-3m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' Y,X,-Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,-Z'
        IF(IS.EQ.  7) OP =' -X,-Y,-Z'
        IF(IS.EQ.  8) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  9) OP =' X-Y,X,-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,Z'
        IF(IS.EQ. 12) OP =' X,X-Y,Z'
        IF(IS.EQ. 13) OP =' 2/3+X,1/3+Y,1/3+Z'
        IF(IS.EQ. 14) OP =' 2/3-Y,1/3+X-Y,1/3+Z'
        IF(IS.EQ. 15) OP =' 2/3+Y-X,1/3-X,1/3+Z'
        IF(IS.EQ. 16) OP =' 2/3+Y,1/3+X,1/3-Z'
        IF(IS.EQ. 17) OP =' 2/3+X-Y,1/3-Y,1/3-Z'
        IF(IS.EQ. 18) OP =' 2/3-X,1/3+Y-X,1/3-Z'
        IF(IS.EQ. 19) OP =' 2/3-X,1/3-Y,1/3-Z'
        IF(IS.EQ. 20) OP =' 2/3+Y,1/3+Y-X,1/3-Z'
        IF(IS.EQ. 21) OP =' 2/3+X-Y,1/3+X,1/3-Z'
        IF(IS.EQ. 22) OP =' 2/3-Y,1/3-X,1/3+Z'
        IF(IS.EQ. 23) OP =' 2/3+Y-X,1/3+Y,1/3+Z'
        IF(IS.EQ. 24) OP =' 2/3+X,1/3+X-Y,1/3+Z'
        IF(IS.EQ. 25) OP =' 1/3+X,2/3+Y,2/3+Z'
        IF(IS.EQ. 26) OP =' 1/3-Y,2/3+X-Y,2/3+Z'
        IF(IS.EQ. 27) OP =' 1/3+Y-X,2/3-X,2/3+Z'
        IF(IS.EQ. 28) OP =' 1/3+Y,2/3+X,2/3-Z'
        IF(IS.EQ. 29) OP =' 1/3+X-Y,2/3-Y,2/3-Z'
        IF(IS.EQ. 30) OP =' 1/3-X,2/3+Y-X,2/3-Z'
        IF(IS.EQ. 31) OP =' 1/3-X,2/3-Y,2/3-Z'
        IF(IS.EQ. 32) OP =' 1/3+Y,2/3+Y-X,2/3-Z'
        IF(IS.EQ. 33) OP =' 1/3+X-Y,2/3+X,2/3-Z'
        IF(IS.EQ. 34) OP =' 1/3-Y,2/3-X,2/3+Z'
        IF(IS.EQ. 35) OP =' 1/3+Y-X,2/3+Y,2/3+Z'
        IF(IS.EQ. 36) OP =' 1/3+X,2/3+X-Y,2/3+Z'
        RETURN
      ENDIF
      IF(I.EQ.186) THEN
        NO_TAB  =  167
        NS_TAB  =   36
        SG_TAB1 = 'R -3 2/c'
        SG_TAB2 = 'R-3c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  5) OP =' X-Y,-Y,1/2-Z'
        IF(IS.EQ.  6) OP =' -X,Y-X,1/2-Z'
        IF(IS.EQ.  7) OP =' -X,-Y,-Z'
        IF(IS.EQ.  8) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  9) OP =' X-Y,X,-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,1/2+Z'
        IF(IS.EQ. 12) OP =' X,X-Y,1/2+Z'
        IF(IS.EQ. 13) OP =' 2/3+X,1/3+Y,1/3+Z'
        IF(IS.EQ. 14) OP =' 2/3-Y,1/3+X-Y,1/3+Z'
        IF(IS.EQ. 15) OP =' 2/3+Y-X,1/3-X,1/3+Z'
        IF(IS.EQ. 16) OP =' 2/3+Y,1/3+X,5/6-Z'
        IF(IS.EQ. 17) OP =' 2/3+X-Y,1/3-Y,5/6-Z'
        IF(IS.EQ. 18) OP =' 2/3-X,1/3+Y-X,5/6-Z'
        IF(IS.EQ. 19) OP =' 2/3-X,1/3-Y,1/3-Z'
        IF(IS.EQ. 20) OP =' 2/3+Y,1/3+Y-X,1/3-Z'
        IF(IS.EQ. 21) OP =' 2/3+X-Y,1/3+X,1/3-Z'
        IF(IS.EQ. 22) OP =' 2/3-Y,1/3-X,5/6+Z'
        IF(IS.EQ. 23) OP =' 2/3+Y-X,1/3+Y,5/6+Z'
        IF(IS.EQ. 24) OP =' 2/3+X,1/3+X-Y,5/6+Z'
        IF(IS.EQ. 25) OP =' 1/3+X,2/3+Y,2/3+Z'
        IF(IS.EQ. 26) OP =' 1/3-Y,2/3+X-Y,2/3+Z'
        IF(IS.EQ. 27) OP =' 1/3+Y-X,2/3-X,2/3+Z'
        IF(IS.EQ. 28) OP =' 1/3+Y,2/3+X,1/6-Z'
        IF(IS.EQ. 29) OP =' 1/3+X-Y,2/3-Y,1/6-Z'
        IF(IS.EQ. 30) OP =' 1/3-X,2/3+Y-X,1/6-Z'
        IF(IS.EQ. 31) OP =' 1/3-X,2/3-Y,2/3-Z'
        IF(IS.EQ. 32) OP =' 1/3+Y,2/3+Y-X,2/3-Z'
        IF(IS.EQ. 33) OP =' 1/3+X-Y,2/3+X,2/3-Z'
        IF(IS.EQ. 34) OP =' 1/3-Y,2/3-X,1/6+Z'
        IF(IS.EQ. 35) OP =' 1/3+Y-X,2/3+Y,1/6+Z'
        IF(IS.EQ. 36) OP =' 1/3+X,2/3+X-Y,1/6+Z'
        RETURN
      ENDIF
      IF(I.EQ.187) THEN
        NO_TAB  =  168
        NS_TAB  =    6
        SG_TAB1 = 'P 6'
        SG_TAB2 = 'P6'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,Z'
        IF(IS.EQ.  6) OP =' X-Y,X,Z'
        RETURN
      ENDIF
      IF(I.EQ.188) THEN
        NO_TAB  =  169
        NS_TAB  =    6
        SG_TAB1 = 'P 61'
        SG_TAB2 = 'P61'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z+1/3'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z+2/3'
        IF(IS.EQ.  4) OP =' -X,-Y,Z+1/2'
        IF(IS.EQ.  5) OP =' Y,Y-X,Z+5/6'
        IF(IS.EQ.  6) OP =' X-Y,X,Z+1/6'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_23(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.189) THEN
        NO_TAB  =  170
        NS_TAB  =    6
        SG_TAB1 = 'P 65'
        SG_TAB2 = 'P65'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z+2/3'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z+1/3'
        IF(IS.EQ.  4) OP =' -X,-Y,Z+1/2'
        IF(IS.EQ.  5) OP =' Y,Y-X,Z+1/6'
        IF(IS.EQ.  6) OP =' X-Y,X,Z+5/6'
        RETURN
      ENDIF
      IF(I.EQ.190) THEN
        NO_TAB  =  171
        NS_TAB  =    6
        SG_TAB1 = 'P 62'
        SG_TAB2 = 'P62'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,2/3+Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,1/3+Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,2/3+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/3+Z'
        RETURN
      ENDIF
      IF(I.EQ.191) THEN
        NO_TAB  =  172
        NS_TAB  =    6
        SG_TAB1 = 'P 64'
        SG_TAB2 = 'P64'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,1/3+Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,2/3+Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/3+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,2/3+Z'
        RETURN
      ENDIF
      IF(I.EQ.192) THEN
        NO_TAB  =  173
        NS_TAB  =    6
        SG_TAB1 = 'P 63'
        SG_TAB2 = 'P63'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/2+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.193) THEN
        NO_TAB  =  174
        NS_TAB  =    6
        SG_TAB1 = 'P -6'
        SG_TAB2 = 'P-6'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' X,Y,-Z'
        IF(IS.EQ.  5) OP =' -Y,X-Y,-Z'
        IF(IS.EQ.  6) OP =' Y-X,-X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.194) THEN
        NO_TAB  =  175
        NS_TAB  =   12
        SG_TAB1 = 'P 6/m'
        SG_TAB2 = 'P6/m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,Z'
        IF(IS.EQ.  6) OP =' X-Y,X,Z'
        IF(IS.EQ.  7) OP =' -X,-Y,-Z'
        IF(IS.EQ.  8) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  9) OP =' X-Y,X,-Z'
        IF(IS.EQ. 10) OP =' X,Y,-Z'
        IF(IS.EQ. 11) OP =' -Y,X-Y,-Z'
        IF(IS.EQ. 12) OP =' Y-X,-X,-Z'
        RETURN
      ENDIF
      IF(I.EQ.195) THEN
        NO_TAB  =  176
        NS_TAB  =   12
        SG_TAB1 = 'P 63/m'
        SG_TAB2 = 'P63/m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/2+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/2+Z'
        IF(IS.EQ.  7) OP =' -X,-Y,-Z'
        IF(IS.EQ.  8) OP =' Y,Y-X,-Z'
        IF(IS.EQ.  9) OP =' X-Y,X,-Z'
        IF(IS.EQ. 10) OP =' X,Y,1/2-Z'
        IF(IS.EQ. 11) OP =' -Y,X-Y,1/2-Z'
        IF(IS.EQ. 12) OP =' Y-X,-X,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.196) THEN
        NO_TAB  =  177
        NS_TAB  =   12
        SG_TAB1 = 'P 6 2 2'
        SG_TAB2 = 'P622'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,Z'
        IF(IS.EQ.  6) OP =' X-Y,X,Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ.197) THEN
        NO_TAB  =  178
        NS_TAB  =   12
        SG_TAB1 = 'P 61 2 2'
        SG_TAB2 = 'P6122'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,1/3+Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,2/3+Z'
        IF(IS.EQ.  4) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,5/6+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/6+Z'
        IF(IS.EQ.  7) OP =' Y,X,1/3-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,2/3-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,5/6-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,1/2-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,1/6-Z'
        RETURN
      ENDIF
      IF(I.EQ.198) THEN
        NO_TAB  =  179
        NS_TAB  =   12
        SG_TAB1 = 'P 65 2 2'
        SG_TAB2 = 'P6522'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,2/3+Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,1/3+Z'
        IF(IS.EQ.  4) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/6+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,5/6+Z'
        IF(IS.EQ.  7) OP =' Y,X,2/3-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,1/3-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,1/6-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,1/2-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,5/6-Z'
        RETURN
      ENDIF
      IF(I.EQ.199) THEN
        NO_TAB  =  180
        NS_TAB  =   12
        SG_TAB1 = 'P 62 2 2'
        SG_TAB2 = 'P6222'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,2/3+Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,1/3+Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,2/3+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/3+Z'
        IF(IS.EQ.  7) OP =' Y,X,2/3-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,1/3-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,2/3-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,1/3-Z'
        RETURN
      ENDIF
      IF(I.EQ.200) THEN
        NO_TAB  =  181
        NS_TAB  =   12
        SG_TAB1 = 'P 64 2 2'
        SG_TAB2 = 'P6422'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,1/3+Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,2/3+Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/3+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,2/3+Z'
        IF(IS.EQ.  7) OP =' Y,X,1/3-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,2/3-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,1/3-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,2/3-Z'
        RETURN
      ENDIF
      IF(I.EQ.201) THEN
        NO_TAB  =  182
        NS_TAB  =   12
        SG_TAB1 = 'P 63 2 2'
        SG_TAB2 = 'P6322'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/2+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/2+Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,1/2-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,1/2-Z'
        RETURN
      ENDIF
      IF(I.EQ.202) THEN
        NO_TAB  =  183
        NS_TAB  =   12
        SG_TAB1 = 'P 6 m m'
        SG_TAB2 = 'P6mm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,Z'
        IF(IS.EQ.  6) OP =' X-Y,X,Z'
        IF(IS.EQ.  7) OP =' -Y,-X,Z'
        IF(IS.EQ.  8) OP =' Y-X,Y,Z'
        IF(IS.EQ.  9) OP =' X,X-Y,Z'
        IF(IS.EQ. 10) OP =' Y,X,Z'
        IF(IS.EQ. 11) OP =' X-Y,-Y,Z'
        IF(IS.EQ. 12) OP =' -X,Y-X,Z'
        RETURN
      ENDIF
      RETURN
      END


      SUBROUTINE GET_SPACE_GROUP_INFO_24(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.203) THEN
        NO_TAB  =  184
        NS_TAB  =   12
        SG_TAB1 = 'P 6 c c'
        SG_TAB2 = 'P6cc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,Z'
        IF(IS.EQ.  6) OP =' X-Y,X,Z'
        IF(IS.EQ.  7) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.  8) OP =' Y-X,Y,1/2+Z'
        IF(IS.EQ.  9) OP =' X,X-Y,1/2+Z'
        IF(IS.EQ. 10) OP =' Y,X,1/2+Z'
        IF(IS.EQ. 11) OP =' X-Y,-Y,1/2+Z'
        IF(IS.EQ. 12) OP =' -X,Y-X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.204) THEN
        NO_TAB  =  185
        NS_TAB  =   12
        SG_TAB1 = 'P 63 c m'
        SG_TAB2 = 'P63cm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/2+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/2+Z'
        IF(IS.EQ.  7) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.  8) OP =' Y-X,Y,1/2+Z'
        IF(IS.EQ.  9) OP =' X,X-Y,1/2+Z'
        IF(IS.EQ. 10) OP =' Y,X,Z'
        IF(IS.EQ. 11) OP =' X-Y,-Y,Z'
        IF(IS.EQ. 12) OP =' -X,Y-X,Z'
        RETURN
      ENDIF
      IF(I.EQ.205) THEN
        NO_TAB  =  186
        NS_TAB  =   12
        SG_TAB1 = 'P 63 m c'
        SG_TAB2 = 'P63mc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/2+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/2+Z'
        IF(IS.EQ.  7) OP =' -Y,-X,Z'
        IF(IS.EQ.  8) OP =' Y-X,Y,Z'
        IF(IS.EQ.  9) OP =' X,X-Y,Z'
        IF(IS.EQ. 10) OP =' Y,X,1/2+Z'
        IF(IS.EQ. 11) OP =' X-Y,-Y,1/2+Z'
        IF(IS.EQ. 12) OP =' -X,Y-X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.206) THEN
        NO_TAB  =  187
        NS_TAB  =   12
        SG_TAB1 = 'P -6 m 2'
        SG_TAB2 = 'P-6m2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' X,Y,-Z'
        IF(IS.EQ.  5) OP =' -Y,X-Y,-Z'
        IF(IS.EQ.  6) OP =' Y-X,-X,-Z'
        IF(IS.EQ.  7) OP =' -Y,-X,Z'
        IF(IS.EQ.  8) OP =' Y-X,Y,Z'
        IF(IS.EQ.  9) OP =' X,X-Y,Z'
        IF(IS.EQ. 10) OP =' -Y,-X,-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ.207) THEN
        NO_TAB  =  188
        NS_TAB  =   12
        SG_TAB1 = 'P -6 c 2'
        SG_TAB2 = 'P-6c2'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' X,Y,1/2-Z'
        IF(IS.EQ.  5) OP =' -Y,X-Y,1/2-Z'
        IF(IS.EQ.  6) OP =' Y-X,-X,1/2-Z'
        IF(IS.EQ.  7) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.  8) OP =' Y-X,Y,1/2+Z'
        IF(IS.EQ.  9) OP =' X,X-Y,1/2+Z'
        IF(IS.EQ. 10) OP =' -Y,-X,-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,-Z'
        RETURN
      ENDIF
      IF(I.EQ.208) THEN
        NO_TAB  =  189
        NS_TAB  =   12
        SG_TAB1 = 'P -6 2 m'
        SG_TAB2 = 'P-62m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' X,Y,-Z'
        IF(IS.EQ.  5) OP =' -Y,X-Y,-Z'
        IF(IS.EQ.  6) OP =' Y-X,-X,-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,-Z'
        IF(IS.EQ. 10) OP =' Y,X,Z'
        IF(IS.EQ. 11) OP =' X-Y,-Y,Z'
        IF(IS.EQ. 12) OP =' -X,Y-X,Z'
        RETURN
      ENDIF
      IF(I.EQ.209) THEN
        NO_TAB  =  190
        NS_TAB  =   12
        SG_TAB1 = 'P -6 2 c'
        SG_TAB2 = 'P-62c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' X,Y,1/2-Z'
        IF(IS.EQ.  5) OP =' -Y,X-Y,1/2-Z'
        IF(IS.EQ.  6) OP =' Y-X,-X,1/2-Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,-Z'
        IF(IS.EQ. 10) OP =' Y,X,1/2+Z'
        IF(IS.EQ. 11) OP =' X-Y,-Y,1/2+Z'
        IF(IS.EQ. 12) OP =' -X,Y-X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.210) THEN
        NO_TAB  =  191
        NS_TAB  =   24
        SG_TAB1 = 'P 6/m 2/m 2/m'
        SG_TAB2 = 'P6/mmm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,Z'
        IF(IS.EQ.  6) OP =' X-Y,X,Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,-Z'
        IF(IS.EQ. 13) OP =' -X,-Y,-Z'
        IF(IS.EQ. 14) OP =' Y,Y-X,-Z'
        IF(IS.EQ. 15) OP =' X-Y,X,-Z'
        IF(IS.EQ. 16) OP =' X,Y,-Z'
        IF(IS.EQ. 17) OP =' Y-X,-X,-Z'
        IF(IS.EQ. 18) OP =' -Y,X-Y,-Z'
        IF(IS.EQ. 19) OP =' -Y,-X,Z'
        IF(IS.EQ. 20) OP =' Y-X,Y,Z'
        IF(IS.EQ. 21) OP =' X,X-Y,Z'
        IF(IS.EQ. 22) OP =' Y,X,Z'
        IF(IS.EQ. 23) OP =' X-Y,-Y,Z'
        IF(IS.EQ. 24) OP =' -X,Y-X,Z'
        RETURN
      ENDIF
      IF(I.EQ.211) THEN
        NO_TAB  =  192
        NS_TAB  =   24
        SG_TAB1 = 'P 6/m 2/c 2/c'
        SG_TAB2 = 'P6/mcc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,Z'
        IF(IS.EQ.  6) OP =' X-Y,X,Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,1/2-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,1/2-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,1/2-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' -X,-Y,-Z'
        IF(IS.EQ. 14) OP =' Y,Y-X,-Z'
        IF(IS.EQ. 15) OP =' X-Y,X,-Z'
        IF(IS.EQ. 16) OP =' X,Y,-Z'
        IF(IS.EQ. 17) OP =' Y-X,-X,-Z'
        IF(IS.EQ. 18) OP =' -Y,X-Y,-Z'
        IF(IS.EQ. 19) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 20) OP =' Y-X,Y,1/2+Z'
        IF(IS.EQ. 21) OP =' X,X-Y,1/2+Z'
        IF(IS.EQ. 22) OP =' Y,X,1/2+Z'
        IF(IS.EQ. 23) OP =' X-Y,-Y,1/2+Z'
        IF(IS.EQ. 24) OP =' -X,Y-X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.212) THEN
        NO_TAB  =  193
        NS_TAB  =   24
        SG_TAB1 = 'P 63/m 2/c 2/m'
        SG_TAB2 = 'P63/mcm'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/2+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/2+Z'
        IF(IS.EQ.  7) OP =' Y,X,1/2-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,1/2-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,1/2-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,-Z'
        IF(IS.EQ. 13) OP =' -X,-Y,-Z'
        IF(IS.EQ. 14) OP =' Y,Y-X,-Z'
        IF(IS.EQ. 15) OP =' X-Y,X,-Z'
        IF(IS.EQ. 16) OP =' X,Y,1/2-Z'
        IF(IS.EQ. 17) OP =' Y-X,-X,1/2-Z'
        IF(IS.EQ. 18) OP =' -Y,X-Y,1/2-Z'
        IF(IS.EQ. 19) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 20) OP =' Y-X,Y,1/2+Z'
        IF(IS.EQ. 21) OP =' X,X-Y,1/2+Z'
        IF(IS.EQ. 22) OP =' Y,X,Z'
        IF(IS.EQ. 23) OP =' X-Y,-Y,Z'
        IF(IS.EQ. 24) OP =' -X,Y-X,Z'
        RETURN
      ENDIF
      IF(I.EQ.213) THEN
        NO_TAB  =  194
        NS_TAB  =   24
        SG_TAB1 = 'P 63/m 2/m 2/c'
        SG_TAB2 = 'P63/mmc'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -Y,X-Y,Z'
        IF(IS.EQ.  3) OP =' Y-X,-X,Z'
        IF(IS.EQ.  4) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ.  5) OP =' Y,Y-X,1/2+Z'
        IF(IS.EQ.  6) OP =' X-Y,X,1/2+Z'
        IF(IS.EQ.  7) OP =' Y,X,-Z'
        IF(IS.EQ.  8) OP =' X-Y,-Y,-Z'
        IF(IS.EQ.  9) OP =' -X,Y-X,-Z'
        IF(IS.EQ. 10) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ. 11) OP =' Y-X,Y,1/2-Z'
        IF(IS.EQ. 12) OP =' X,X-Y,1/2-Z'
        IF(IS.EQ. 13) OP =' -X,-Y,-Z'
        IF(IS.EQ. 14) OP =' Y,Y-X,-Z'
        IF(IS.EQ. 15) OP =' X-Y,X,-Z'
        IF(IS.EQ. 16) OP =' X,Y,1/2-Z'
        IF(IS.EQ. 17) OP =' Y-X,-X,1/2-Z'
        IF(IS.EQ. 18) OP =' -Y,X-Y,1/2-Z'
        IF(IS.EQ. 19) OP =' -Y,-X,Z'
        IF(IS.EQ. 20) OP =' Y-X,Y,Z'
        IF(IS.EQ. 21) OP =' X,X-Y,Z'
        IF(IS.EQ. 22) OP =' Y,X,1/2+Z'
        IF(IS.EQ. 23) OP =' X-Y,-Y,1/2+Z'
        IF(IS.EQ. 24) OP =' -X,Y-X,1/2+Z'
        RETURN
      ENDIF
      IF(I.EQ.214) THEN
        NO_TAB  =  195
        NS_TAB  =   12
        SG_TAB1 = 'P 2 3'
        SG_TAB2 = 'P23'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        RETURN
      ENDIF
      IF(I.EQ.215) THEN
        NO_TAB  =  196
        NS_TAB  =   48
        SG_TAB1 = 'F 2 3'
        SG_TAB2 = 'F23'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 15) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 16) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 17) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 18) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 19) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ. 20) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ. 21) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 22) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 23) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 24) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 25) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 26) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 27) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 28) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ. 30) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ. 31) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ. 32) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ. 33) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ. 34) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 35) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ. 36) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 37) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 38) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 39) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 40) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 41) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ. 42) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ. 43) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ. 44) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ. 45) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ. 46) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ. 47) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 48) OP =' 1/2-Y,1/2-Z,X'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_3(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.216) THEN
        NO_TAB  =  197
        NS_TAB  =   24
        SG_TAB1 = 'I 2 3'
        SG_TAB2 = 'I23'
        SG_TAB3 = 'I 23'
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 14) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 16) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 17) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 18) OP =' 1/2+Z,1/2-X,1/2-Y'
        IF(IS.EQ. 19) OP =' 1/2-Z,1/2-X,1/2+Y'
        IF(IS.EQ. 20) OP =' 1/2-Z,1/2+X,1/2-Y'
        IF(IS.EQ. 21) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 22) OP =' 1/2-Y,1/2+Z,1/2-X'
        IF(IS.EQ. 23) OP =' 1/2+Y,1/2-Z,1/2-X'
        IF(IS.EQ. 24) OP =' 1/2-Y,1/2-Z,1/2+X'
        RETURN
      ENDIF
      IF(I.EQ.217) THEN
        NO_TAB  = 1197
        NS_TAB  =   24
        SG_TAB1 = 'I 2 3 (a)'
        SG_TAB2 = 'I23a'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.  3) OP =' X+1/2,-Y,-Z'
        IF(IS.EQ.  4) OP =' -X,Y+1/2,-Z'
        IF(IS.EQ.  5) OP =' Y,Z,X'
        IF(IS.EQ.  6) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ.  7) OP =' Y+1/2,-Z,-X'
        IF(IS.EQ.  8) OP =' -Y,Z+1/2,-X'
        IF(IS.EQ.  9) OP =' Z,X,Y'
        IF(IS.EQ. 10) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ. 11) OP =' Z+1/2,-X,-Y'
        IF(IS.EQ. 12) OP =' -Z,X+1/2,-Y'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,-Y,1/2+Z'
        IF(IS.EQ. 15) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 16) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 17) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 18) OP =' -Y,-Z,1/2+X'
        IF(IS.EQ. 19) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 20) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 21) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 22) OP =' -Z,-X,1/2+Y'
        IF(IS.EQ. 23) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 24) OP =' 1/2-Z,X,1/2-Y'
        RETURN
      ENDIF
      IF(I.EQ.218) THEN
        NO_TAB  =  198
        NS_TAB  =   12
        SG_TAB1 = 'P 21 3'
        SG_TAB2 = 'P213'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.  7) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.  8) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 12) OP =' 1/2-Y,-Z,1/2+X'
        RETURN
      ENDIF
      IF(I.EQ.219) THEN
        NO_TAB  =  199
        NS_TAB  =   24
        SG_TAB1 = 'I 21 3'
        SG_TAB2 = 'I213'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.  7) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.  8) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 12) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 13) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 14) OP =' -X,1/2-Y,Z'
        IF(IS.EQ. 15) OP =' 1/2-X,Y,-Z'
        IF(IS.EQ. 16) OP =' X,-Y,1/2-Z'
        IF(IS.EQ. 17) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 18) OP =' Z,-X,1/2-Y'
        IF(IS.EQ. 19) OP =' -Z,1/2-X,Y'
        IF(IS.EQ. 20) OP =' 1/2-Z,X,-Y'
        IF(IS.EQ. 21) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 22) OP =' 1/2-Y,Z,-X'
        IF(IS.EQ. 23) OP =' Y,-Z,1/2-X'
        IF(IS.EQ. 24) OP =' -Y,1/2-Z,X'
        RETURN
      ENDIF
      IF(I.EQ.220) THEN
        NO_TAB  =  200
        NS_TAB  =   24
        SG_TAB1 = 'P 2/m -3'
        SG_TAB2 = 'Pm-3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' -X,-Y,-Z'
        IF(IS.EQ. 14) OP =' X,Y,-Z'
        IF(IS.EQ. 15) OP =' X,-Y,Z'
        IF(IS.EQ. 16) OP =' -X,Y,Z'
        IF(IS.EQ. 17) OP =' -Z,-X,-Y'
        IF(IS.EQ. 18) OP =' -Z,X,Y'
        IF(IS.EQ. 19) OP =' Z,X,-Y'
        IF(IS.EQ. 20) OP =' Z,-X,Y'
        IF(IS.EQ. 21) OP =' -Y,-Z,-X'
        IF(IS.EQ. 22) OP =' Y,-Z,X'
        IF(IS.EQ. 23) OP =' -Y,Z,X'
        IF(IS.EQ. 24) OP =' Y,Z,-X'
        RETURN
      ENDIF
      IF(I.EQ.221) THEN
        NO_TAB  =  201
        NS_TAB  =   24
        SG_TAB1 = 'P 2/n -3'
        SG_TAB2 = 'Pn-3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 17) OP =' 1/2-Z,1/2-X,1/2-Y'
        IF(IS.EQ. 18) OP =' 1/2-Z,1/2+X,1/2+Y'
        IF(IS.EQ. 19) OP =' 1/2+Z,1/2+X,1/2-Y'
        IF(IS.EQ. 20) OP =' 1/2+Z,1/2-X,1/2+Y'
        IF(IS.EQ. 21) OP =' 1/2-Y,1/2-Z,1/2-X'
        IF(IS.EQ. 22) OP =' 1/2+Y,1/2-Z,1/2+X'
        IF(IS.EQ. 23) OP =' 1/2-Y,1/2+Z,1/2+X'
        IF(IS.EQ. 24) OP =' 1/2+Y,1/2+Z,1/2-X'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_31(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.222) THEN
        NO_TAB  =  202
        NS_TAB  =   96
        SG_TAB1 = 'F 2/m -3'
        SG_TAB2 = 'Fm-3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' -X,-Y,-Z'
        IF(IS.EQ. 14) OP =' X,Y,-Z'
        IF(IS.EQ. 15) OP =' X,-Y,Z'
        IF(IS.EQ. 16) OP =' -X,Y,Z'
        IF(IS.EQ. 17) OP =' -Z,-X,-Y'
        IF(IS.EQ. 18) OP =' -Z,X,Y'
        IF(IS.EQ. 19) OP =' Z,X,-Y'
        IF(IS.EQ. 20) OP =' Z,-X,Y'
        IF(IS.EQ. 21) OP =' -Y,-Z,-X'
        IF(IS.EQ. 22) OP =' Y,-Z,X'
        IF(IS.EQ. 23) OP =' -Y,Z,X'
        IF(IS.EQ. 24) OP =' Y,Z,-X'
        IF(IS.EQ. 25) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 27) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 28) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 31) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ. 32) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ. 33) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 35) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 36) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 37) OP =' -X,1/2-Y,1/2-Z'
        IF(IS.EQ. 38) OP =' X,1/2+Y,1/2-Z'
        IF(IS.EQ. 39) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ. 40) OP =' -X,1/2+Y,1/2+Z'
        IF(IS.EQ. 41) OP =' -Z,1/2-X,1/2-Y'
        IF(IS.EQ. 42) OP =' -Z,1/2+X,1/2+Y'
        IF(IS.EQ. 43) OP =' Z,1/2+X,1/2-Y'
        IF(IS.EQ. 44) OP =' Z,1/2-X,1/2+Y'
        IF(IS.EQ. 45) OP =' -Y,1/2-Z,1/2-X'
        IF(IS.EQ. 46) OP =' Y,1/2-Z,1/2+X'
        IF(IS.EQ. 47) OP =' -Y,1/2+Z,1/2+X'
        IF(IS.EQ. 48) OP =' Y,1/2+Z,1/2-X'
        IF(IS.EQ. 49) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 50) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 51) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 52) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ. 53) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ. 54) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ. 55) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ. 56) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ. 57) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ. 58) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 59) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ. 60) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 61) OP =' 1/2-X,-Y,1/2-Z'
        IF(IS.EQ. 62) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ. 63) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ. 64) OP =' 1/2-X,Y,1/2+Z'
        IF(IS.EQ. 65) OP =' 1/2-Z,-X,1/2-Y'
        IF(IS.EQ. 66) OP =' 1/2-Z,X,1/2+Y'
        IF(IS.EQ. 67) OP =' 1/2+Z,X,1/2-Y'
        IF(IS.EQ. 68) OP =' 1/2+Z,-X,1/2+Y'
        IF(IS.EQ. 69) OP =' 1/2-Y,-Z,1/2-X'
        IF(IS.EQ. 70) OP =' 1/2+Y,-Z,1/2+X'
        IF(IS.EQ. 71) OP =' 1/2-Y,Z,1/2+X'
        IF(IS.EQ. 72) OP =' 1/2+Y,Z,1/2-X'
        IF(IS.EQ. 73) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 74) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 75) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 76) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 77) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ. 78) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ. 79) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ. 80) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ. 81) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ. 82) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ. 83) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 84) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ. 85) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ. 86) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ. 87) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ. 88) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 89) OP =' 1/2-Z,1/2-X,-Y'
        IF(IS.EQ. 90) OP =' 1/2-Z,1/2+X,Y'
        IF(IS.EQ. 91) OP =' 1/2+Z,1/2+X,-Y'
        IF(IS.EQ. 92) OP =' 1/2+Z,1/2-X,Y'
        IF(IS.EQ. 93) OP =' 1/2-Y,1/2-Z,-X'
        IF(IS.EQ. 94) OP =' 1/2+Y,1/2-Z,X'
        IF(IS.EQ. 95) OP =' 1/2-Y,1/2+Z,X'
        IF(IS.EQ. 96) OP =' 1/2+Y,1/2+Z,-X'
        RETURN
      ENDIF
      IF(I.EQ.223) THEN
        NO_TAB  =  203
        NS_TAB  =   96
        SG_TAB1 = 'F 2/d -3'
        SG_TAB2 = 'Fd-3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' 1/4-X,1/4-Y,1/4-Z'
        IF(IS.EQ. 14) OP =' 1/4+X,1/4+Y,1/4-Z'
        IF(IS.EQ. 15) OP =' 1/4+X,1/4-Y,1/4+Z'
        IF(IS.EQ. 16) OP =' 1/4-X,1/4+Y,1/4+Z'
        IF(IS.EQ. 17) OP =' 1/4-Z,1/4-X,1/4-Y'
        IF(IS.EQ. 18) OP =' 1/4-Z,1/4+X,1/4+Y'
        IF(IS.EQ. 19) OP =' 1/4+Z,1/4+X,1/4-Y'
        IF(IS.EQ. 20) OP =' 1/4+Z,1/4-X,1/4+Y'
        IF(IS.EQ. 21) OP =' 1/4-Y,1/4-Z,1/4-X'
        IF(IS.EQ. 22) OP =' 1/4+Y,1/4-Z,1/4+X'
        IF(IS.EQ. 23) OP =' 1/4-Y,1/4+Z,1/4+X'
        IF(IS.EQ. 24) OP =' 1/4+Y,1/4+Z,1/4-X'
        IF(IS.EQ. 25) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 27) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 28) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 31) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ. 32) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ. 33) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 35) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 36) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 37) OP =' 1/4-X,3/4-Y,3/4-Z'
        IF(IS.EQ. 38) OP =' 1/4+X,3/4+Y,3/4-Z'
        IF(IS.EQ. 39) OP =' 1/4+X,3/4-Y,3/4+Z'
        IF(IS.EQ. 40) OP =' 1/4-X,3/4+Y,3/4+Z'
        IF(IS.EQ. 41) OP =' 1/4-Z,3/4-X,3/4-Y'
        IF(IS.EQ. 42) OP =' 1/4-Z,3/4+X,3/4+Y'
        IF(IS.EQ. 43) OP =' 1/4+Z,3/4+X,3/4-Y'
        IF(IS.EQ. 44) OP =' 1/4+Z,3/4-X,3/4+Y'
        IF(IS.EQ. 45) OP =' 1/4-Y,3/4-Z,3/4-X'
        IF(IS.EQ. 46) OP =' 1/4+Y,3/4-Z,3/4+X'
        IF(IS.EQ. 47) OP =' 1/4-Y,3/4+Z,3/4+X'
        IF(IS.EQ. 48) OP =' 1/4+Y,3/4+Z,3/4-X'
        IF(IS.EQ. 49) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 50) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 51) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 52) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ. 53) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ. 54) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ. 55) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ. 56) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ. 57) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ. 58) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 59) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ. 60) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 61) OP =' 3/4-X,1/4-Y,3/4-Z'
        IF(IS.EQ. 62) OP =' 3/4+X,1/4+Y,3/4-Z'
        IF(IS.EQ. 63) OP =' 3/4+X,1/4-Y,3/4+Z'
        IF(IS.EQ. 64) OP =' 3/4-X,1/4+Y,3/4+Z'
        IF(IS.EQ. 65) OP =' 3/4-Z,1/4-X,3/4-Y'
        IF(IS.EQ. 66) OP =' 3/4-Z,1/4+X,3/4+Y'
        IF(IS.EQ. 67) OP =' 3/4+Z,1/4+X,3/4-Y'
        IF(IS.EQ. 68) OP =' 3/4+Z,1/4-X,3/4+Y'
        IF(IS.EQ. 69) OP =' 3/4-Y,1/4-Z,3/4-X'
        IF(IS.EQ. 70) OP =' 3/4+Y,1/4-Z,3/4+X'
        IF(IS.EQ. 71) OP =' 3/4-Y,1/4+Z,3/4+X'
        IF(IS.EQ. 72) OP =' 3/4+Y,1/4+Z,3/4-X'
        IF(IS.EQ. 73) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 74) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 75) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 76) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 77) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ. 78) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ. 79) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ. 80) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ. 81) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ. 82) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ. 83) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 84) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ. 85) OP =' 3/4-X,3/4-Y,1/4-Z'
        IF(IS.EQ. 86) OP =' 3/4+X,3/4+Y,1/4-Z'
        IF(IS.EQ. 87) OP =' 3/4+X,3/4-Y,Z+1/4'
        IF(IS.EQ. 88) OP =' 3/4-X,3/4+Y,Z+1/4'
        IF(IS.EQ. 89) OP =' 3/4-Z,3/4-X,1/4-Y'
        IF(IS.EQ. 90) OP =' 3/4-Z,3/4+X,1/4+Y'
        IF(IS.EQ. 91) OP =' 3/4+Z,3/4+X,1/4-Y'
        IF(IS.EQ. 92) OP =' 3/4+Z,3/4-X,1/4+Y'
        IF(IS.EQ. 93) OP =' 3/4-Y,3/4-Z,1/4-X'
        IF(IS.EQ. 94) OP =' 3/4+Y,3/4-Z,1/4+X'
        IF(IS.EQ. 95) OP =' 3/4-Y,3/4+Z,1/4+X'
        IF(IS.EQ. 96) OP =' 3/4+Y,3/4+Z,1/4-X'
        RETURN
      ENDIF
      IF(I.EQ.224) THEN
        NO_TAB  =  204
        NS_TAB  =   48
        SG_TAB1 = 'I 2/m -3'
        SG_TAB2 = 'Im-3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' -X,-Y,-Z'
        IF(IS.EQ. 14) OP =' X,Y,-Z'
        IF(IS.EQ. 15) OP =' X,-Y,Z'
        IF(IS.EQ. 16) OP =' -X,Y,Z'
        IF(IS.EQ. 17) OP =' -Z,-X,-Y'
        IF(IS.EQ. 18) OP =' -Z,X,Y'
        IF(IS.EQ. 19) OP =' Z,X,-Y'
        IF(IS.EQ. 20) OP =' Z,-X,Y'
        IF(IS.EQ. 21) OP =' -Y,-Z,-X'
        IF(IS.EQ. 22) OP =' Y,-Z,X'
        IF(IS.EQ. 23) OP =' -Y,Z,X'
        IF(IS.EQ. 24) OP =' Y,Z,-X'
        IF(IS.EQ. 25) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 27) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 28) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' 1/2+Z,1/2-X,1/2-Y'
        IF(IS.EQ. 31) OP =' 1/2-Z,1/2-X,1/2+Y'
        IF(IS.EQ. 32) OP =' 1/2-Z,1/2+X,1/2-Y'
        IF(IS.EQ. 33) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' 1/2-Y,1/2+Z,1/2-X'
        IF(IS.EQ. 35) OP =' 1/2+Y,1/2-Z,1/2-X'
        IF(IS.EQ. 36) OP =' 1/2-Y,1/2-Z,1/2+X'
        IF(IS.EQ. 37) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 38) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 39) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 40) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 41) OP =' 1/2-Z,1/2-X,1/2-Y'
        IF(IS.EQ. 42) OP =' 1/2-Z,1/2+X,1/2+Y'
        IF(IS.EQ. 43) OP =' 1/2+Z,1/2+X,1/2-Y'
        IF(IS.EQ. 44) OP =' 1/2+Z,1/2-X,1/2+Y'
        IF(IS.EQ. 45) OP =' 1/2-Y,1/2-Z,1/2-X'
        IF(IS.EQ. 46) OP =' 1/2+Y,1/2-Z,1/2+X'
        IF(IS.EQ. 47) OP =' 1/2-Y,1/2+Z,1/2+X'
        IF(IS.EQ. 48) OP =' 1/2+Y,1/2+Z,1/2-X'
        RETURN
      ENDIF
      IF(I.EQ.225) THEN
        NO_TAB  =  205
        NS_TAB  =   24
        SG_TAB1 = 'P 21/a -3'
        SG_TAB2 = 'Pa-3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.  7) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.  8) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 12) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 13) OP =' -X,-Y,-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ. 15) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 17) OP =' -Z,-X,-Y'
        IF(IS.EQ. 18) OP =' 1/2-Z,1/2+X,Y'
        IF(IS.EQ. 19) OP =' 1/2+Z,X,1/2-Y'
        IF(IS.EQ. 20) OP =' Z,1/2-X,1/2+Y'
        IF(IS.EQ. 21) OP =' -Y,-Z,-X'
        IF(IS.EQ. 22) OP =' Y,1/2-Z,1/2+X'
        IF(IS.EQ. 23) OP =' 1/2-Y,1/2+Z,X'
        IF(IS.EQ. 24) OP =' 1/2+Y,Z,1/2-X'
        RETURN
      ENDIF
      IF(I.EQ.226) THEN
        NO_TAB  =  206
        NS_TAB  =   48
        SG_TAB1 = 'I 21/a -3'
        SG_TAB2 = 'Ia-3'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.  7) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.  8) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 12) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 13) OP =' -X,-Y,-Z'
        IF(IS.EQ. 14) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ. 15) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 17) OP =' -Z,-X,-Y'
        IF(IS.EQ. 18) OP =' 1/2-Z,1/2+X,Y'
        IF(IS.EQ. 19) OP =' 1/2+Z,X,1/2-Y'
        IF(IS.EQ. 20) OP =' Z,1/2-X,1/2+Y'
        IF(IS.EQ. 21) OP =' -Y,-Z,-X'
        IF(IS.EQ. 22) OP =' Y,1/2-Z,1/2+X'
        IF(IS.EQ. 23) OP =' 1/2-Y,1/2+Z,X'
        IF(IS.EQ. 24) OP =' 1/2+Y,Z,1/2-X'
        IF(IS.EQ. 25) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' -X,1/2-Y,Z'
        IF(IS.EQ. 27) OP =' 1/2-X,+Y,-Z'
        IF(IS.EQ. 28) OP =' X,-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' Z,-X,1/2-Y'
        IF(IS.EQ. 31) OP =' -Z,1/2-X,Y'
        IF(IS.EQ. 32) OP =' 1/2-Z,X,-Y'
        IF(IS.EQ. 33) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' 1/2-Y,Z,-X'
        IF(IS.EQ. 35) OP =' Y,-Z,1/2-X'
        IF(IS.EQ. 36) OP =' -Y,1/2-Z,X'
        IF(IS.EQ. 37) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 38) OP =' X,1/2+Y,-Z'
        IF(IS.EQ. 39) OP =' 1/2+X,-Y,Z'
        IF(IS.EQ. 40) OP =' -X,Y,1/2+Z'
        IF(IS.EQ. 41) OP =' 1/2-Z,1/2-X,1/2-Y'
        IF(IS.EQ. 42) OP =' -Z,X,1/2+Y'
        IF(IS.EQ. 43) OP =' Z,1/2+X,-Y'
        IF(IS.EQ. 44) OP =' 1/2+Z,-X,Y'
        IF(IS.EQ. 45) OP =' 1/2-Y,1/2-Z,1/2-X'
        IF(IS.EQ. 46) OP =' 1/2+Y,-Z,X'
        IF(IS.EQ. 47) OP =' -Y,Z,1/2+X'
        IF(IS.EQ. 48) OP =' Y,1/2+Z,-X'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_32(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.227) THEN
        NO_TAB  =  207
        NS_TAB  =   24
        SG_TAB1 = 'P 4 3 2'
        SG_TAB2 = 'P432'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,-Z'
        IF(IS.EQ. 14) OP =' -Y,-X,-Z'
        IF(IS.EQ. 15) OP =' Y,-X,Z'
        IF(IS.EQ. 16) OP =' -Y,X,Z'
        IF(IS.EQ. 17) OP =' X,Z,-Y'
        IF(IS.EQ. 18) OP =' -X,Z,Y'
        IF(IS.EQ. 19) OP =' -X,-Z,-Y'
        IF(IS.EQ. 20) OP =' X,-Z,Y'
        IF(IS.EQ. 21) OP =' Z,Y,-X'
        IF(IS.EQ. 22) OP =' Z,-Y,X'
        IF(IS.EQ. 23) OP =' -Z,Y,X'
        IF(IS.EQ. 24) OP =' -Z,-Y,-X'
        RETURN
      ENDIF
      IF(I.EQ.228) THEN
        NO_TAB  =  208
        NS_TAB  =   24
        SG_TAB1 = 'P 42 3 2'
        SG_TAB2 = 'P4232'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Z,1/2-Y'
        IF(IS.EQ. 18) OP =' 1/2-X,1/2+Z,1/2+Y'
        IF(IS.EQ. 19) OP =' 1/2-X,1/2-Z,1/2-Y'
        IF(IS.EQ. 20) OP =' 1/2+X,1/2-Z,1/2+Y'
        IF(IS.EQ. 21) OP =' 1/2+Z,1/2+Y,1/2-X'
        IF(IS.EQ. 22) OP =' 1/2+Z,1/2-Y,1/2+X'
        IF(IS.EQ. 23) OP =' 1/2-Z,1/2+Y,1/2+X'
        IF(IS.EQ. 24) OP =' 1/2-Z,1/2-Y,1/2-X'
        RETURN
      ENDIF
      IF(I.EQ.229) THEN
        NO_TAB  =  209
        NS_TAB  =   96
        SG_TAB1 = 'F 4 3 2'
        SG_TAB2 = 'F432'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,-Z'
        IF(IS.EQ. 14) OP =' -Y,-X,-Z'
        IF(IS.EQ. 15) OP =' Y,-X,Z'
        IF(IS.EQ. 16) OP =' -Y,X,Z'
        IF(IS.EQ. 17) OP =' X,Z,-Y'
        IF(IS.EQ. 18) OP =' -X,Z,Y'
        IF(IS.EQ. 19) OP =' -X,-Z,-Y'
        IF(IS.EQ. 20) OP =' X,-Z,Y'
        IF(IS.EQ. 21) OP =' Z,Y,-X'
        IF(IS.EQ. 22) OP =' Z,-Y,X'
        IF(IS.EQ. 23) OP =' -Z,Y,X'
        IF(IS.EQ. 24) OP =' -Z,-Y,-X'
        IF(IS.EQ. 25) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 27) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 28) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 31) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ. 32) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ. 33) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 35) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 36) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 37) OP =' Y,1/2+X,1/2-Z'
        IF(IS.EQ. 38) OP =' -Y,1/2-X,1/2-Z'
        IF(IS.EQ. 39) OP =' Y,1/2-X,1/2+Z'
        IF(IS.EQ. 40) OP =' -Y,1/2+X,1/2+Z'
        IF(IS.EQ. 41) OP =' X,1/2+Z,1/2-Y'
        IF(IS.EQ. 42) OP =' -X,1/2+Z,1/2+Y'
        IF(IS.EQ. 43) OP =' -X,1/2-Z,1/2-Y'
        IF(IS.EQ. 44) OP =' X,1/2-Z,1/2+Y'
        IF(IS.EQ. 45) OP =' Z,1/2+Y,1/2-X'
        IF(IS.EQ. 46) OP =' Z,1/2-Y,1/2+X'
        IF(IS.EQ. 47) OP =' -Z,1/2+Y,1/2+X'
        IF(IS.EQ. 48) OP =' -Z,1/2-Y,1/2-X'
        IF(IS.EQ. 49) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 50) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 51) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 52) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ. 53) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ. 54) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ. 55) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ. 56) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ. 57) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ. 58) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 59) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ. 60) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 61) OP =' 1/2+Y,X,1/2-Z'
        IF(IS.EQ. 62) OP =' 1/2-Y,-X,1/2-Z'
        IF(IS.EQ. 63) OP =' 1/2+Y,-X,1/2+Z'
        IF(IS.EQ. 64) OP =' 1/2-Y,X,1/2+Z'
        IF(IS.EQ. 65) OP =' 1/2+X,Z,1/2-Y'
        IF(IS.EQ. 66) OP =' 1/2-X,Z,1/2+Y'
        IF(IS.EQ. 67) OP =' 1/2-X,-Z,1/2-Y'
        IF(IS.EQ. 68) OP =' 1/2+X,-Z,1/2+Y'
        IF(IS.EQ. 69) OP =' 1/2+Z,Y,1/2-X'
        IF(IS.EQ. 70) OP =' 1/2+Z,-Y,1/2+X'
        IF(IS.EQ. 71) OP =' 1/2-Z,Y,1/2+X'
        IF(IS.EQ. 72) OP =' 1/2-Z,-Y,1/2-X'
        IF(IS.EQ. 73) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 74) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 75) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 76) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 77) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ. 78) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ. 79) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ. 80) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ. 81) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ. 82) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ. 83) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 84) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ. 85) OP =' 1/2+Y,1/2+X,-Z'
        IF(IS.EQ. 86) OP =' 1/2-Y,1/2-X,-Z'
        IF(IS.EQ. 87) OP =' 1/2+Y,1/2-X,Z'
        IF(IS.EQ. 88) OP =' 1/2-Y,1/2+X,Z'
        IF(IS.EQ. 89) OP =' 1/2+X,1/2+Z,-Y'
        IF(IS.EQ. 90) OP =' 1/2-X,1/2+Z,Y'
        IF(IS.EQ. 91) OP =' 1/2-X,1/2-Z,-Y'
        IF(IS.EQ. 92) OP =' 1/2+X,1/2-Z,Y'
        IF(IS.EQ. 93) OP =' 1/2+Z,1/2+Y,-X'
        IF(IS.EQ. 94) OP =' 1/2+Z,1/2-Y,X'
        IF(IS.EQ. 95) OP =' 1/2-Z,1/2+Y,X'
        IF(IS.EQ. 96) OP =' 1/2-Z,1/2-Y,-X'
        RETURN
      ENDIF
      IF(I.EQ.230) THEN
        NO_TAB  =  210
        NS_TAB  =   96
        SG_TAB1 = 'F 41 3 2'
        SG_TAB2 = 'F4132'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ.  7) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ.  8) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ. 12) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 13) OP =' 3/4+Y,1/4+X,3/4-Z'
        IF(IS.EQ. 14) OP =' 1/4-Y,1/4-X,1/4-Z'
        IF(IS.EQ. 15) OP =' 1/4+Y,3/4-X,3/4+Z'
        IF(IS.EQ. 16) OP =' 3/4-Y,3/4+X,1/4+Z'
        IF(IS.EQ. 17) OP =' 3/4+X,1/4+Z,3/4-Y'
        IF(IS.EQ. 18) OP =' 3/4-X,3/4+Z,1/4+Y'
        IF(IS.EQ. 19) OP =' 1/4-X,1/4-Z,1/4-Y'
        IF(IS.EQ. 20) OP =' 1/4+X,3/4-Z,3/4+Y'
        IF(IS.EQ. 21) OP =' 3/4+Z,1/4+Y,3/4-X'
        IF(IS.EQ. 22) OP =' 1/4+Z,3/4-Y,3/4+X'
        IF(IS.EQ. 23) OP =' 3/4-Z,3/4+Y,1/4+X'
        IF(IS.EQ. 24) OP =' 1/4-Z,1/4-Y,1/4-X'
        IF(IS.EQ. 25) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' -X,-Y,Z'
        IF(IS.EQ. 27) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 28) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 29) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ. 31) OP =' -Z,-X,Y'
        IF(IS.EQ. 32) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ. 33) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 35) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 36) OP =' -Y,-Z,X'
        IF(IS.EQ. 37) OP =' 3/4+Y,3/4+X,1/4-Z'
        IF(IS.EQ. 38) OP =' 1/4-Y,3/4-X,3/4-Z'
        IF(IS.EQ. 39) OP =' 1/4+Y,1/4-X,1/4+Z'
        IF(IS.EQ. 40) OP =' 3/4-Y,1/4+X,3/4+Z'
        IF(IS.EQ. 41) OP =' 3/4+X,3/4+Z,1/4-Y'
        IF(IS.EQ. 42) OP =' 3/4-X,1/4+Z,3/4+Y'
        IF(IS.EQ. 43) OP =' 1/4-X,3/4-Z,3/4-Y'
        IF(IS.EQ. 44) OP =' 1/4+X,1/4-Z,1/4+Y'
        IF(IS.EQ. 45) OP =' 3/4+Z,3/4+Y,1/4-X'
        IF(IS.EQ. 46) OP =' 1/4+Z,1/4-Y,1/4+X'
        IF(IS.EQ. 47) OP =' 3/4-Z,1/4+Y,3/4+X'
        IF(IS.EQ. 48) OP =' 1/4-Z,3/4-Y,3/4-X'
        IF(IS.EQ. 49) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 50) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 51) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 52) OP =' X,-Y,-Z'
        IF(IS.EQ. 53) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ. 54) OP =' Z,-X,-Y'
        IF(IS.EQ. 55) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ. 56) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ. 57) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ. 58) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 59) OP =' Y,-Z,-X'
        IF(IS.EQ. 60) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ. 61) OP =' 1/4+Y,1/4+X,1/4-Z'
        IF(IS.EQ. 62) OP =' 3/4-Y,1/4-X,3/4-Z'
        IF(IS.EQ. 63) OP =' 3/4+Y,3/4-X,1/4+Z'
        IF(IS.EQ. 64) OP =' 1/4-Y,3/4+X,3/4+Z'
        IF(IS.EQ. 65) OP =' 1/4+X,1/4+Z,1/4-Y'
        IF(IS.EQ. 66) OP =' 1/4-X,3/4+Z,3/4+Y'
        IF(IS.EQ. 67) OP =' 3/4-X,1/4-Z,3/4-Y'
        IF(IS.EQ. 68) OP =' 3/4+X,3/4-Z,1/4+Y'
        IF(IS.EQ. 69) OP =' 1/4+Z,1/4+Y,1/4-X'
        IF(IS.EQ. 70) OP =' 3/4+Z,3/4-Y,1/4+X'
        IF(IS.EQ. 71) OP =' 1/4-Z,3/4+Y,3/4+X'
        IF(IS.EQ. 72) OP =' 3/4-Z,1/4-Y,3/4-X'
        IF(IS.EQ. 73) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 74) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 75) OP =' -X,Y,-Z'
        IF(IS.EQ. 76) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 77) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ. 78) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 79) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ. 80) OP =' -Z,X,-Y'
        IF(IS.EQ. 81) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ. 82) OP =' -Y,Z,-X'
        IF(IS.EQ. 83) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 84) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 85) OP =' 1/4+Y,3/4+X,3/4-Z'
        IF(IS.EQ. 86) OP =' 3/4-Y,3/4-X,1/4-Z'
        IF(IS.EQ. 87) OP =' 3/4+Y,1/4-X,3/4+Z'
        IF(IS.EQ. 88) OP =' 1/4-Y,1/4+X,1/4+Z'
        IF(IS.EQ. 89) OP =' 1/4+X,3/4+Z,3/4-Y'
        IF(IS.EQ. 90) OP =' 1/4-X,1/4+Z,1/4+Y'
        IF(IS.EQ. 91) OP =' 3/4-X,3/4-Z,1/4-Y'
        IF(IS.EQ. 92) OP =' 3/4+X,1/4-Z,3/4+Y'
        IF(IS.EQ. 93) OP =' 1/4+Z,3/4+Y,3/4-X'
        IF(IS.EQ. 94) OP =' 3/4+Z,1/4-Y,3/4+X'
        IF(IS.EQ. 95) OP =' 1/4-Z,1/4+Y,1/4+X'
        IF(IS.EQ. 96) OP =' 3/4-Z,3/4-Y,1/4-X'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_33(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.231) THEN
        NO_TAB  =  211
        NS_TAB  =   48
        SG_TAB1 = 'I 4 3 2'
        SG_TAB2 = 'I432'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,-Z'
        IF(IS.EQ. 14) OP =' -Y,-X,-Z'
        IF(IS.EQ. 15) OP =' Y,-X,Z'
        IF(IS.EQ. 16) OP =' -Y,X,Z'
        IF(IS.EQ. 17) OP =' X,Z,-Y'
        IF(IS.EQ. 18) OP =' -X,Z,Y'
        IF(IS.EQ. 19) OP =' -X,-Z,-Y'
        IF(IS.EQ. 20) OP =' X,-Z,Y'
        IF(IS.EQ. 21) OP =' Z,Y,-X'
        IF(IS.EQ. 22) OP =' Z,-Y,X'
        IF(IS.EQ. 23) OP =' -Z,Y,X'
        IF(IS.EQ. 24) OP =' -Z,-Y,-X'
        IF(IS.EQ. 25) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 27) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 28) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' 1/2+Z,1/2-X,1/2-Y'
        IF(IS.EQ. 31) OP =' 1/2-Z,1/2-X,1/2+Y'
        IF(IS.EQ. 32) OP =' 1/2-Z,1/2+X,1/2-Y'
        IF(IS.EQ. 33) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' 1/2-Y,1/2+Z,1/2-X'
        IF(IS.EQ. 35) OP =' 1/2+Y,1/2-Z,1/2-X'
        IF(IS.EQ. 36) OP =' 1/2-Y,1/2-Z,1/2+X'
        IF(IS.EQ. 37) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ. 38) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ. 39) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 40) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 41) OP =' 1/2+X,1/2+Z,1/2-Y'
        IF(IS.EQ. 42) OP =' 1/2-X,1/2+Z,1/2+Y'
        IF(IS.EQ. 43) OP =' 1/2-X,1/2-Z,1/2-Y'
        IF(IS.EQ. 44) OP =' 1/2+X,1/2-Z,1/2+Y'
        IF(IS.EQ. 45) OP =' 1/2+Z,1/2+Y,1/2-X'
        IF(IS.EQ. 46) OP =' 1/2+Z,1/2-Y,1/2+X'
        IF(IS.EQ. 47) OP =' 1/2-Z,1/2+Y,1/2+X'
        IF(IS.EQ. 48) OP =' 1/2-Z,1/2-Y,1/2-X'
        RETURN
      ENDIF
      IF(I.EQ.232) THEN
        NO_TAB  =  212
        NS_TAB  =   24
        SG_TAB1 = 'P 43 3 2'
        SG_TAB2 = 'P4332'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.  7) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.  8) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 12) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 13) OP =' 1/4+Y,3/4+X,3/4-Z'
        IF(IS.EQ. 14) OP =' 1/4-Y,1/4-X,1/4-Z'
        IF(IS.EQ. 15) OP =' 3/4+Y,3/4-X,1/4+Z'
        IF(IS.EQ. 16) OP =' 3/4-Y,1/4+X,3/4+Z'
        IF(IS.EQ. 17) OP =' 1/4+X,3/4+Z,3/4-Y'
        IF(IS.EQ. 18) OP =' 3/4-X,1/4+Z,3/4+Y'
        IF(IS.EQ. 19) OP =' 1/4-X,1/4-Z,1/4-Y'
        IF(IS.EQ. 20) OP =' 3/4+X,3/4-Z,1/4+Y'
        IF(IS.EQ. 21) OP =' 1/4+Z,3/4+Y,3/4-X'
        IF(IS.EQ. 22) OP =' 3/4+Z,3/4-Y,1/4+X'
        IF(IS.EQ. 23) OP =' 3/4-Z,1/4+Y,3/4+X'
        IF(IS.EQ. 24) OP =' 1/4-Z,1/4-Y,1/4-X'
        RETURN
      ENDIF
      IF(I.EQ.233) THEN
        NO_TAB  =  213
        NS_TAB  =   24
        SG_TAB1 = 'P 41 3 2'
        SG_TAB2 = 'P4132'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.  7) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.  8) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 12) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 13) OP =' 3/4+Y,1/4+X,1/4-Z'
        IF(IS.EQ. 14) OP =' 3/4-Y,3/4-X,3/4-Z'
        IF(IS.EQ. 15) OP =' 1/4+Y,1/4-X,3/4+Z'
        IF(IS.EQ. 16) OP =' 1/4-Y,3/4+X,1/4+Z'
        IF(IS.EQ. 17) OP =' 3/4+X,1/4+Z,1/4-Y'
        IF(IS.EQ. 18) OP =' 1/4-X,3/4+Z,1/4+Y'
        IF(IS.EQ. 19) OP =' 3/4-X,3/4-Z,3/4-Y'
        IF(IS.EQ. 20) OP =' 1/4+X,1/4-Z,3/4+Y'
        IF(IS.EQ. 21) OP =' 3/4+Z,1/4+Y,1/4-X'
        IF(IS.EQ. 22) OP =' 1/4+Z,1/4-Y,3/4+X'
        IF(IS.EQ. 23) OP =' 1/4-Z,3/4+Y,1/4+X'
        IF(IS.EQ. 24) OP =' 3/4-Z,3/4-Y,3/4-X'
        RETURN
      ENDIF
      IF(I.EQ.234) THEN
        NO_TAB  =  214
        NS_TAB  =   48
        SG_TAB1 = 'I 41 3 2'
        SG_TAB2 = 'I4132'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.  7) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.  8) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 12) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 13) OP =' 3/4+Y,1/4+X,1/4-Z'
        IF(IS.EQ. 14) OP =' 3/4-Y,3/4-X,3/4-Z'
        IF(IS.EQ. 15) OP =' 1/4+Y,1/4-X,3/4+Z'
        IF(IS.EQ. 16) OP =' 1/4-Y,3/4+X,1/4+Z'
        IF(IS.EQ. 17) OP =' 3/4+X,1/4+Z,1/4-Y'
        IF(IS.EQ. 18) OP =' 1/4-X,3/4+Z,1/4+Y'
        IF(IS.EQ. 19) OP =' 3/4-X,3/4-Z,3/4-Y'
        IF(IS.EQ. 20) OP =' 1/4+X,1/4-Z,3/4+Y'
        IF(IS.EQ. 21) OP =' 3/4+Z,1/4+Y,1/4-X'
        IF(IS.EQ. 22) OP =' 1/4+Z,1/4-Y,3/4+X'
        IF(IS.EQ. 23) OP =' 1/4-Z,3/4+Y,1/4+X'
        IF(IS.EQ. 24) OP =' 3/4-Z,3/4-Y,3/4-X'
        IF(IS.EQ. 25) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' -X,1/2-Y,Z'
        IF(IS.EQ. 27) OP =' 1/2-X,Y,-Z'
        IF(IS.EQ. 28) OP =' X,-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' Z,-X,1/2-Y'
        IF(IS.EQ. 31) OP =' -Z,1/2-X,Y'
        IF(IS.EQ. 32) OP =' 1/2-Z,X,-Y'
        IF(IS.EQ. 33) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' 1/2-Y,Z,-X'
        IF(IS.EQ. 35) OP =' Y,-Z,1/2-X'
        IF(IS.EQ. 36) OP =' -Y,1/2-Z,X'
        IF(IS.EQ. 37) OP =' 1/4+Y,3/4+X,3/4-Z'
        IF(IS.EQ. 38) OP =' 1/4-Y,1/4-X,1/4-Z'
        IF(IS.EQ. 39) OP =' 3/4+Y,3/4-X,1/4+Z'
        IF(IS.EQ. 40) OP =' 3/4-Y,1/4+X,3/4+Z'
        IF(IS.EQ. 41) OP =' 1/4+X,3/4+Z,3/4-Y'
        IF(IS.EQ. 42) OP =' 3/4-X,1/4+Z,3/4+Y'
        IF(IS.EQ. 43) OP =' 1/4-X,1/4-Z,1/4-Y'
        IF(IS.EQ. 44) OP =' 3/4+X,3/4-Z,1/4+Y'
        IF(IS.EQ. 45) OP =' 1/4+Z,3/4+Y,3/4-X'
        IF(IS.EQ. 46) OP =' 3/4+Z,3/4-Y,1/4+X'
        IF(IS.EQ. 47) OP =' 3/4-Z,1/4+Y,3/4+X'
        IF(IS.EQ. 48) OP =' 1/4-Z,1/4-Y,1/4-X'
        RETURN
      ENDIF
      IF(I.EQ.235) THEN
        NO_TAB  =  215
        NS_TAB  =   24
        SG_TAB1 = 'P -4 3 m'
        SG_TAB2 = 'P-43m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,Z'
        IF(IS.EQ. 14) OP =' -Y,-X,Z'
        IF(IS.EQ. 15) OP =' Y,-X,-Z'
        IF(IS.EQ. 16) OP =' -Y,X,-Z'
        IF(IS.EQ. 17) OP =' X,Z,Y'
        IF(IS.EQ. 18) OP =' -X,Z,-Y'
        IF(IS.EQ. 19) OP =' -X,-Z,Y'
        IF(IS.EQ. 20) OP =' X,-Z,-Y'
        IF(IS.EQ. 21) OP =' Z,Y,X'
        IF(IS.EQ. 22) OP =' Z,-Y,-X'
        IF(IS.EQ. 23) OP =' -Z,Y,-X'
        IF(IS.EQ. 24) OP =' -Z,-Y,X'
        RETURN
      ENDIF
      RETURN
      END


      SUBROUTINE GET_SPACE_GROUP_INFO_34(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.236) THEN
        NO_TAB  =  216
        NS_TAB  =   96
        SG_TAB1 = 'F -4 3 m'
        SG_TAB2 = 'F-43m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,Z'
        IF(IS.EQ. 14) OP =' -Y,-X,Z'
        IF(IS.EQ. 15) OP =' Y,-X,-Z'
        IF(IS.EQ. 16) OP =' -Y,X,-Z'
        IF(IS.EQ. 17) OP =' X,Z,Y'
        IF(IS.EQ. 18) OP =' -X,Z,-Y'
        IF(IS.EQ. 19) OP =' -X,-Z,Y'
        IF(IS.EQ. 20) OP =' X,-Z,-Y'
        IF(IS.EQ. 21) OP =' Z,Y,X'
        IF(IS.EQ. 22) OP =' Z,-Y,-X'
        IF(IS.EQ. 23) OP =' -Z,Y,-X'
        IF(IS.EQ. 24) OP =' -Z,-Y,X'
        IF(IS.EQ. 25) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 27) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 28) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 31) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ. 32) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ. 33) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 35) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 36) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 37) OP =' Y,1/2+X,1/2+Z'
        IF(IS.EQ. 38) OP =' -Y,1/2-X,1/2+Z'
        IF(IS.EQ. 39) OP =' Y,1/2-X,1/2-Z'
        IF(IS.EQ. 40) OP =' -Y,1/2+X,1/2-Z'
        IF(IS.EQ. 41) OP =' X,1/2+Z,1/2+Y'
        IF(IS.EQ. 42) OP =' -X,1/2+Z,1/2-Y'
        IF(IS.EQ. 43) OP =' -X,1/2-Z,1/2+Y'
        IF(IS.EQ. 44) OP =' X,1/2-Z,1/2-Y'
        IF(IS.EQ. 45) OP =' Z,1/2+Y,1/2+X'
        IF(IS.EQ. 46) OP =' Z,1/2-Y,1/2-X'
        IF(IS.EQ. 47) OP =' -Z,1/2+Y,1/2-X'
        IF(IS.EQ. 48) OP =' -Z,1/2-Y,1/2+X'
        IF(IS.EQ. 49) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 50) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 51) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 52) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ. 53) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ. 54) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ. 55) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ. 56) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ. 57) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ. 58) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 59) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ. 60) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 61) OP =' 1/2+Y,X,1/2+Z'
        IF(IS.EQ. 62) OP =' 1/2-Y,-X,1/2+Z'
        IF(IS.EQ. 63) OP =' 1/2+Y,-X,1/2-Z'
        IF(IS.EQ. 64) OP =' 1/2-Y,X,1/2-Z'
        IF(IS.EQ. 65) OP =' 1/2+X,Z,1/2+Y'
        IF(IS.EQ. 66) OP =' 1/2-X,Z,1/2-Y'
        IF(IS.EQ. 67) OP =' 1/2-X,-Z,1/2+Y'
        IF(IS.EQ. 68) OP =' 1/2+X,-Z,1/2-Y'
        IF(IS.EQ. 69) OP =' 1/2+Z,Y,1/2+X'
        IF(IS.EQ. 70) OP =' 1/2+Z,-Y,1/2-X'
        IF(IS.EQ. 71) OP =' 1/2-Z,Y,1/2-X'
        IF(IS.EQ. 72) OP =' 1/2-Z,-Y,1/2+X'
        IF(IS.EQ. 73) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 74) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 75) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 76) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 77) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ. 78) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ. 79) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ. 80) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ. 81) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ. 82) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ. 83) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 84) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ. 85) OP =' 1/2+Y,1/2+X,Z'
        IF(IS.EQ. 86) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ. 87) OP =' 1/2+Y,1/2-X,-Z'
        IF(IS.EQ. 88) OP =' 1/2-Y,1/2+X,-Z'
        IF(IS.EQ. 89) OP =' 1/2+X,1/2+Z,Y'
        IF(IS.EQ. 90) OP =' 1/2-X,1/2+Z,-Y'
        IF(IS.EQ. 91) OP =' 1/2-X,1/2-Z,Y'
        IF(IS.EQ. 92) OP =' 1/2+X,1/2-Z,-Y'
        IF(IS.EQ. 93) OP =' 1/2+Z,1/2+Y,X'
        IF(IS.EQ. 94) OP =' 1/2+Z,1/2-Y,-X'
        IF(IS.EQ. 95) OP =' 1/2-Z,1/2+Y,-X'
        IF(IS.EQ. 96) OP =' 1/2-Z,1/2-Y,X'
        RETURN
      ENDIF
      IF(I.EQ.237) THEN
        NO_TAB  =  217
        NS_TAB  =   48
        SG_TAB1 = 'I -4 3 m'
        SG_TAB2 = 'I-43m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,Z'
        IF(IS.EQ. 14) OP =' -Y,-X,Z'
        IF(IS.EQ. 15) OP =' Y,-X,-Z'
        IF(IS.EQ. 16) OP =' -Y,X,-Z'
        IF(IS.EQ. 17) OP =' X,Z,Y'
        IF(IS.EQ. 18) OP =' -X,Z,-Y'
        IF(IS.EQ. 19) OP =' -X,-Z,Y'
        IF(IS.EQ. 20) OP =' X,-Z,-Y'
        IF(IS.EQ. 21) OP =' Z,Y,X'
        IF(IS.EQ. 22) OP =' Z,-Y,-X'
        IF(IS.EQ. 23) OP =' -Z,Y,-X'
        IF(IS.EQ. 24) OP =' -Z,-Y,X'
        IF(IS.EQ. 25) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 27) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 28) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' 1/2+Z,1/2-X,1/2-Y'
        IF(IS.EQ. 31) OP =' 1/2-Z,1/2-X,1/2+Y'
        IF(IS.EQ. 32) OP =' 1/2-Z,1/2+X,1/2-Y'
        IF(IS.EQ. 33) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' 1/2-Y,1/2+Z,1/2-X'
        IF(IS.EQ. 35) OP =' 1/2+Y,1/2-Z,1/2-X'
        IF(IS.EQ. 36) OP =' 1/2-Y,1/2-Z,1/2+X'
        IF(IS.EQ. 37) OP =' 1/2+Y,1/2+X,1/2+Z'
        IF(IS.EQ. 38) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 39) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 40) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 41) OP =' 1/2+X,1/2+Z,1/2+Y'
        IF(IS.EQ. 42) OP =' 1/2-X,1/2+Z,1/2-Y'
        IF(IS.EQ. 43) OP =' 1/2-X,1/2-Z,1/2+Y'
        IF(IS.EQ. 44) OP =' 1/2+X,1/2-Z,1/2-Y'
        IF(IS.EQ. 45) OP =' 1/2+Z,1/2+Y,1/2+X'
        IF(IS.EQ. 46) OP =' 1/2+Z,1/2-Y,1/2-X'
        IF(IS.EQ. 47) OP =' 1/2-Z,1/2+Y,1/2-X'
        IF(IS.EQ. 48) OP =' 1/2-Z,1/2-Y,1/2+X'
        RETURN
      ENDIF
      IF(I.EQ.238) THEN
        NO_TAB  =  218
        NS_TAB  =   24
        SG_TAB1 = 'P -4 3 n'
        SG_TAB2 = 'P-43n'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' 1/2+Y,1/2+X,1/2+Z'
        IF(IS.EQ. 14) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Z,1/2+Y'
        IF(IS.EQ. 18) OP =' 1/2-X,1/2+Z,1/2-Y'
        IF(IS.EQ. 19) OP =' 1/2-X,1/2-Z,1/2+Y'
        IF(IS.EQ. 20) OP =' 1/2+X,1/2-Z,1/2-Y'
        IF(IS.EQ. 21) OP =' 1/2+Z,1/2+Y,1/2+X'
        IF(IS.EQ. 22) OP =' 1/2+Z,1/2-Y,1/2-X'
        IF(IS.EQ. 23) OP =' 1/2-Z,1/2+Y,1/2-X'
        IF(IS.EQ. 24) OP =' 1/2-Z,1/2-Y,1/2+X'
        RETURN
      ENDIF
      IF(I.EQ.239) THEN
        NO_TAB  =  219
        NS_TAB  =   96
        SG_TAB1 = 'F -4 3 c'
        SG_TAB2 = 'F-43c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' 1/2+Y,1/2+X,1/2+Z'
        IF(IS.EQ. 14) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Z,1/2+Y'
        IF(IS.EQ. 18) OP =' 1/2-X,1/2+Z,1/2-Y'
        IF(IS.EQ. 19) OP =' 1/2-X,1/2-Z,1/2+Y'
        IF(IS.EQ. 20) OP =' 1/2+X,1/2-Z,1/2-Y'
        IF(IS.EQ. 21) OP =' 1/2+Z,1/2+Y,1/2+X'
        IF(IS.EQ. 22) OP =' 1/2+Z,1/2-Y,1/2-X'
        IF(IS.EQ. 23) OP =' 1/2-Z,1/2+Y,1/2-X'
        IF(IS.EQ. 24) OP =' 1/2-Z,1/2-Y,1/2+X'
        IF(IS.EQ. 25) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 27) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 28) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 31) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ. 32) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ. 33) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 35) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 36) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 37) OP =' 1/2+Y,X,Z'
        IF(IS.EQ. 38) OP =' 1/2-Y,-X,Z'
        IF(IS.EQ. 39) OP =' 1/2+Y,-X,-Z'
        IF(IS.EQ. 40) OP =' 1/2-Y,X,-Z'
        IF(IS.EQ. 41) OP =' 1/2+X,Z,Y'
        IF(IS.EQ. 42) OP =' 1/2-X,Z,-Y'
        IF(IS.EQ. 43) OP =' 1/2-X,-Z,Y'
        IF(IS.EQ. 44) OP =' 1/2+X,-Z,-Y'
        IF(IS.EQ. 45) OP =' 1/2+Z,Y,X'
        IF(IS.EQ. 46) OP =' 1/2+Z,-Y,-X'
        IF(IS.EQ. 47) OP =' 1/2-Z,Y,-X'
        IF(IS.EQ. 48) OP =' 1/2-Z,-Y,X'
        IF(IS.EQ. 49) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 50) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 51) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 52) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ. 53) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ. 54) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ. 55) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ. 56) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ. 57) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ. 58) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 59) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ. 60) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 61) OP =' Y,1/2+X,Z'
        IF(IS.EQ. 62) OP =' -Y,1/2-X,Z'
        IF(IS.EQ. 63) OP =' Y,1/2-X,-Z'
        IF(IS.EQ. 64) OP =' -Y,1/2+X,-Z'
        IF(IS.EQ. 65) OP =' X,1/2+Z,Y'
        IF(IS.EQ. 66) OP =' -X,1/2+Z,-Y'
        IF(IS.EQ. 67) OP =' -X,1/2-Z,Y'
        IF(IS.EQ. 68) OP =' X,1/2-Z,-Y'
        IF(IS.EQ. 69) OP =' Z,1/2+Y,X'
        IF(IS.EQ. 70) OP =' Z,1/2-Y,-X'
        IF(IS.EQ. 71) OP =' -Z,1/2+Y,-X'
        IF(IS.EQ. 72) OP =' -Z,1/2-Y,X'
        IF(IS.EQ. 73) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ. 74) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 75) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ. 76) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 77) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ. 78) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ. 79) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ. 80) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ. 81) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ. 82) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ. 83) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 84) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ. 85) OP =' Y,X,1/2+Z'
        IF(IS.EQ. 86) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 87) OP =' Y,-X,1/2-Z'
        IF(IS.EQ. 88) OP =' -Y,X,1/2-Z'
        IF(IS.EQ. 89) OP =' X,Z,1/2+Y'
        IF(IS.EQ. 90) OP =' -X,Z,1/2-Y'
        IF(IS.EQ. 91) OP =' -X,-Z,1/2+Y'
        IF(IS.EQ. 92) OP =' X,-Z,1/2-Y'
        IF(IS.EQ. 93) OP =' Z,Y,1/2+X'
        IF(IS.EQ. 94) OP =' Z,-Y,1/2-X'
        IF(IS.EQ. 95) OP =' -Z,Y,1/2-X'
        IF(IS.EQ. 96) OP =' -Z,-Y,1/2+X'
        RETURN
      ENDIF
      RETURN
      END


      SUBROUTINE GET_SPACE_GROUP_INFO_35(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.240) THEN
        NO_TAB  =  220
        NS_TAB  =   48
        SG_TAB1 = 'I -4 3 d'
        SG_TAB2 = 'I-43d'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.  7) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.  8) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 12) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 13) OP =' 1/4+Y,1/4+X,1/4+Z'
        IF(IS.EQ. 14) OP =' 1/4-Y,3/4-X,3/4+Z'
        IF(IS.EQ. 15) OP =' 3/4+Y,1/4-X,3/4-Z'
        IF(IS.EQ. 16) OP =' 3/4-Y,3/4+X,1/4-Z'
        IF(IS.EQ. 17) OP =' 1/4+X,1/4+Z,1/4+Y'
        IF(IS.EQ. 18) OP =' 3/4-X,3/4+Z,1/4-Y'
        IF(IS.EQ. 19) OP =' 1/4-X,3/4-Z,3/4+Y'
        IF(IS.EQ. 20) OP =' 3/4+X,1/4-Z,3/4-Y'
        IF(IS.EQ. 21) OP =' 1/4+Z,1/4+Y,1/4+X'
        IF(IS.EQ. 22) OP =' 3/4+Z,1/4-Y,3/4-X'
        IF(IS.EQ. 23) OP =' 3/4-Z,3/4+Y,1/4-X'
        IF(IS.EQ. 24) OP =' 1/4-Z,3/4-Y,3/4+X'
        IF(IS.EQ. 25) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 26) OP =' -X,1/2-Y,Z'
        IF(IS.EQ. 27) OP =' 1/2-X,Y,-Z'
        IF(IS.EQ. 28) OP =' X,-Y,1/2-Z'
        IF(IS.EQ. 29) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 30) OP =' Z,-X,1/2-Y'
        IF(IS.EQ. 31) OP =' -Z,1/2-X,Y'
        IF(IS.EQ. 32) OP =' 1/2-Z,X,-Y'
        IF(IS.EQ. 33) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 34) OP =' 1/2-Y,Z,-X'
        IF(IS.EQ. 35) OP =' Y,-Z,1/2-X'
        IF(IS.EQ. 36) OP =' -Y,1/2-Z,X'
        IF(IS.EQ. 37) OP =' 3/4+Y,3/4+X,3/4+Z'
        IF(IS.EQ. 38) OP =' 3/4-Y,1/4-X,1/4+Z'
        IF(IS.EQ. 39) OP =' 1/4+Y,3/4-X,1/4-Z'
        IF(IS.EQ. 40) OP =' 1/4-Y,1/4+X,3/4-Z'
        IF(IS.EQ. 41) OP =' 3/4+X,3/4+Z,3/4+Y'
        IF(IS.EQ. 42) OP =' 1/4-X,1/4+Z,3/4-Y'
        IF(IS.EQ. 43) OP =' 3/4-X,1/4-Z,1/4+Y'
        IF(IS.EQ. 44) OP =' 1/4+X,3/4-Z,1/4-Y'
        IF(IS.EQ. 45) OP =' 3/4+Z,3/4+Y,3/4+X'
        IF(IS.EQ. 46) OP =' 1/4+Z,3/4-Y,1/4-X'
        IF(IS.EQ. 47) OP =' 1/4-Z,1/4+Y,3/4-X'
        IF(IS.EQ. 48) OP =' 3/4-Z,1/4-Y,1/4+X'
        RETURN
      ENDIF
      IF(I.EQ.241) THEN
        NO_TAB  =  221
        NS_TAB  =   48
        SG_TAB1 = 'P 4/m -3 2/m'
        SG_TAB2 = 'Pm-3m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,-Z'
        IF(IS.EQ. 14) OP =' -Y,-X,-Z'
        IF(IS.EQ. 15) OP =' Y,-X,Z'
        IF(IS.EQ. 16) OP =' -Y,X,Z'
        IF(IS.EQ. 17) OP =' X,Z,-Y'
        IF(IS.EQ. 18) OP =' -X,Z,Y'
        IF(IS.EQ. 19) OP =' -X,-Z,-Y'
        IF(IS.EQ. 20) OP =' X,-Z,Y'
        IF(IS.EQ. 21) OP =' Z,Y,-X'
        IF(IS.EQ. 22) OP =' Z,-Y,X'
        IF(IS.EQ. 23) OP =' -Z,Y,X'
        IF(IS.EQ. 24) OP =' -Z,-Y,-X'
        IF(IS.EQ. 25) OP =' -X,-Y,-Z'
        IF(IS.EQ. 26) OP =' X,Y,-Z'
        IF(IS.EQ. 27) OP =' X,-Y,Z'
        IF(IS.EQ. 28) OP =' -X,Y,Z'
        IF(IS.EQ. 29) OP =' -Z,-X,-Y'
        IF(IS.EQ. 30) OP =' -Z,X,Y'
        IF(IS.EQ. 31) OP =' Z,X,-Y'
        IF(IS.EQ. 32) OP =' Z,-X,Y'
        IF(IS.EQ. 33) OP =' -Y,-Z,-X'
        IF(IS.EQ. 34) OP =' Y,-Z,X'
        IF(IS.EQ. 35) OP =' -Y,Z,X'
        IF(IS.EQ. 36) OP =' Y,Z,-X'
        IF(IS.EQ. 37) OP =' -Y,-X,Z'
        IF(IS.EQ. 38) OP =' Y,X,Z'
        IF(IS.EQ. 39) OP =' -Y,X,-Z'
        IF(IS.EQ. 40) OP =' Y,-X,-Z'
        IF(IS.EQ. 41) OP =' -X,-Z,Y'
        IF(IS.EQ. 42) OP =' X,-Z,-Y'
        IF(IS.EQ. 43) OP =' X,Z,Y'
        IF(IS.EQ. 44) OP =' -X,Z,-Y'
        IF(IS.EQ. 45) OP =' -Z,-Y,X'
        IF(IS.EQ. 46) OP =' -Z,Y,-X'
        IF(IS.EQ. 47) OP =' Z,-Y,-X'
        IF(IS.EQ. 48) OP =' Z,Y,X'
        RETURN
      ENDIF
      IF(I.EQ.242) THEN
        NO_TAB  =  222
        NS_TAB  =   48
        SG_TAB1 = 'P 4/n -3 2/n'
        SG_TAB2 = 'Pn-3n'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,-Z'
        IF(IS.EQ. 14) OP =' -Y,-X,-Z'
        IF(IS.EQ. 15) OP =' Y,-X,Z'
        IF(IS.EQ. 16) OP =' -Y,X,Z'
        IF(IS.EQ. 17) OP =' X,Z,-Y'
        IF(IS.EQ. 18) OP =' -X,Z,Y'
        IF(IS.EQ. 19) OP =' -X,-Z,-Y'
        IF(IS.EQ. 20) OP =' X,-Z,Y'
        IF(IS.EQ. 21) OP =' Z,Y,-X'
        IF(IS.EQ. 22) OP =' Z,-Y,X'
        IF(IS.EQ. 23) OP =' -Z,Y,X'
        IF(IS.EQ. 24) OP =' -Z,-Y,-X'
        IF(IS.EQ. 25) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 26) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 27) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 28) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 29) OP =' 1/2-Z,1/2-X,1/2-Y'
        IF(IS.EQ. 30) OP =' 1/2-Z,1/2+X,1/2+Y'
        IF(IS.EQ. 31) OP =' 1/2+Z,1/2+X,1/2-Y'
        IF(IS.EQ. 32) OP =' 1/2+Z,1/2-X,1/2+Y'
        IF(IS.EQ. 33) OP =' 1/2-Y,1/2-Z,1/2-X'
        IF(IS.EQ. 34) OP =' 1/2+Y,1/2-Z,1/2+X'
        IF(IS.EQ. 35) OP =' 1/2-Y,1/2+Z,1/2+X'
        IF(IS.EQ. 36) OP =' 1/2+Y,1/2+Z,1/2-X'
        IF(IS.EQ. 37) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 38) OP =' 1/2+Y,1/2+X,1/2+Z'
        IF(IS.EQ. 39) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 40) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 41) OP =' 1/2-X,1/2-Z,1/2+Y'
        IF(IS.EQ. 42) OP =' 1/2+X,1/2-Z,1/2-Y'
        IF(IS.EQ. 43) OP =' 1/2+X,1/2+Z,1/2+Y'
        IF(IS.EQ. 44) OP =' 1/2-X,1/2+Z,1/2-Y'
        IF(IS.EQ. 45) OP =' 1/2-Z,1/2-Y,1/2+X'
        IF(IS.EQ. 46) OP =' 1/2-Z,1/2+Y,1/2-X'
        IF(IS.EQ. 47) OP =' 1/2+Z,1/2-Y,1/2-X'
        IF(IS.EQ. 48) OP =' 1/2+Z,1/2+Y,1/2+X'
        RETURN
      ENDIF
      IF(I.EQ.243) THEN
        NO_TAB  =  223
        NS_TAB  =   48
        SG_TAB1 = 'P 42/m -3 2/n'
        SG_TAB2 = 'Pm-3n'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Z,1/2-Y'
        IF(IS.EQ. 18) OP =' 1/2-X,1/2+Z,1/2+Y'
        IF(IS.EQ. 19) OP =' 1/2-X,1/2-Z,1/2-Y'
        IF(IS.EQ. 20) OP =' 1/2+X,1/2-Z,1/2+Y'
        IF(IS.EQ. 21) OP =' 1/2+Z,1/2+Y,1/2-X'
        IF(IS.EQ. 22) OP =' 1/2+Z,1/2-Y,1/2+X'
        IF(IS.EQ. 23) OP =' 1/2-Z,1/2+Y,1/2+X'
        IF(IS.EQ. 24) OP =' 1/2-Z,1/2-Y,1/2-X'
        IF(IS.EQ. 25) OP =' -X,-Y,-Z'
        IF(IS.EQ. 26) OP =' X,Y,-Z'
        IF(IS.EQ. 27) OP =' X,-Y,Z'
        IF(IS.EQ. 28) OP =' -X,Y,Z'
        IF(IS.EQ. 29) OP =' -Z,-X,-Y'
        IF(IS.EQ. 30) OP =' -Z,X,Y'
        IF(IS.EQ. 31) OP =' Z,X,-Y'
        IF(IS.EQ. 32) OP =' Z,-X,Y'
        IF(IS.EQ. 33) OP =' -Y,-Z,-X'
        IF(IS.EQ. 34) OP =' Y,-Z,X'
        IF(IS.EQ. 35) OP =' -Y,Z,X'
        IF(IS.EQ. 36) OP =' Y,Z,-X'
        IF(IS.EQ. 37) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 38) OP =' 1/2+Y,1/2+X,1/2+Z'
        IF(IS.EQ. 39) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 40) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 41) OP =' 1/2-X,1/2-Z,1/2+Y'
        IF(IS.EQ. 42) OP =' 1/2+X,1/2-Z,1/2-Y'
        IF(IS.EQ. 43) OP =' 1/2+X,1/2+Z,1/2+Y'
        IF(IS.EQ. 44) OP =' 1/2-X,1/2+Z,1/2-Y'
        IF(IS.EQ. 45) OP =' 1/2-Z,1/2-Y,1/2+X'
        IF(IS.EQ. 46) OP =' 1/2-Z,1/2+Y,1/2-X'
        IF(IS.EQ. 47) OP =' 1/2+Z,1/2-Y,1/2-X'
        IF(IS.EQ. 48) OP =' 1/2+Z,1/2+Y,1/2+X'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_4(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.244) THEN
        NO_TAB  =  224
        NS_TAB  =   48
        SG_TAB1 = 'P 42/n -3 2/m'
        SG_TAB2 = 'Pn-3m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Z,1/2-Y'
        IF(IS.EQ. 18) OP =' 1/2-X,1/2+Z,1/2+Y'
        IF(IS.EQ. 19) OP =' 1/2-X,1/2-Z,1/2-Y'
        IF(IS.EQ. 20) OP =' 1/2+X,1/2-Z,1/2+Y'
        IF(IS.EQ. 21) OP =' 1/2+Z,1/2+Y,1/2-X'
        IF(IS.EQ. 22) OP =' 1/2+Z,1/2-Y,1/2+X'
        IF(IS.EQ. 23) OP =' 1/2-Z,1/2+Y,1/2+X'
        IF(IS.EQ. 24) OP =' 1/2-Z,1/2-Y,1/2-X'
        IF(IS.EQ. 25) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 26) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 27) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 28) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 29) OP =' 1/2-Z,1/2-X,1/2-Y'
        IF(IS.EQ. 30) OP =' 1/2-Z,1/2+X,1/2+Y'
        IF(IS.EQ. 31) OP =' 1/2+Z,1/2+X,1/2-Y'
        IF(IS.EQ. 32) OP =' 1/2+Z,1/2-X,1/2+Y'
        IF(IS.EQ. 33) OP =' 1/2-Y,1/2-Z,1/2-X'
        IF(IS.EQ. 34) OP =' 1/2+Y,1/2-Z,1/2+X'
        IF(IS.EQ. 35) OP =' 1/2-Y,1/2+Z,1/2+X'
        IF(IS.EQ. 36) OP =' 1/2+Y,1/2+Z,1/2-X'
        IF(IS.EQ. 37) OP =' -Y,-X,Z'
        IF(IS.EQ. 38) OP =' Y,X,Z'
        IF(IS.EQ. 39) OP =' -Y,X,-Z'
        IF(IS.EQ. 40) OP =' Y,-X,-Z'
        IF(IS.EQ. 41) OP =' -X,-Z,Y'
        IF(IS.EQ. 42) OP =' X,-Z,-Y'
        IF(IS.EQ. 43) OP =' X,Z,Y'
        IF(IS.EQ. 44) OP =' -X,Z,-Y'
        IF(IS.EQ. 45) OP =' -Z,-Y,X'
        IF(IS.EQ. 46) OP =' -Z,Y,-X'
        IF(IS.EQ. 47) OP =' Z,-Y,-X'
        IF(IS.EQ. 48) OP =' Z,Y,X'
        RETURN
      ENDIF
      IF(I.EQ.245) THEN
        NO_TAB  =  225
        NS_TAB  =  192
        SG_TAB1 = 'F 4/m -3 2/m'
        SG_TAB2 = 'Fm-3m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,-Z'
        IF(IS.EQ. 14) OP =' -Y,-X,-Z'
        IF(IS.EQ. 15) OP =' Y,-X,Z'
        IF(IS.EQ. 16) OP =' -Y,X,Z'
        IF(IS.EQ. 17) OP =' X,Z,-Y'
        IF(IS.EQ. 18) OP =' -X,Z,Y'
        IF(IS.EQ. 19) OP =' -X,-Z,-Y'
        IF(IS.EQ. 20) OP =' X,-Z,Y'
        IF(IS.EQ. 21) OP =' Z,Y,-X'
        IF(IS.EQ. 22) OP =' Z,-Y,X'
        IF(IS.EQ. 23) OP =' -Z,Y,X'
        IF(IS.EQ. 24) OP =' -Z,-Y,-X'
        IF(IS.EQ. 25) OP =' -X,-Y,-Z'
        IF(IS.EQ. 26) OP =' X,Y,-Z'
        IF(IS.EQ. 27) OP =' X,-Y,Z'
        IF(IS.EQ. 28) OP =' -X,Y,Z'
        IF(IS.EQ. 29) OP =' -Z,-X,-Y'
        IF(IS.EQ. 30) OP =' -Z,X,Y'
        IF(IS.EQ. 31) OP =' Z,X,-Y'
        IF(IS.EQ. 32) OP =' Z,-X,Y'
        IF(IS.EQ. 33) OP =' -Y,-Z,-X'
        IF(IS.EQ. 34) OP =' Y,-Z,X'
        IF(IS.EQ. 35) OP =' -Y,Z,X'
        IF(IS.EQ. 36) OP =' Y,Z,-X'
        IF(IS.EQ. 37) OP =' -Y,-X,Z'
        IF(IS.EQ. 38) OP =' Y,X,Z'
        IF(IS.EQ. 39) OP =' -Y,X,-Z'
        IF(IS.EQ. 40) OP =' Y,-X,-Z'
        IF(IS.EQ. 41) OP =' -X,-Z,Y'
        IF(IS.EQ. 42) OP =' X,-Z,-Y'
        IF(IS.EQ. 43) OP =' X,Z,Y'
        IF(IS.EQ. 44) OP =' -X,Z,-Y'
        IF(IS.EQ. 45) OP =' -Z,-Y,X'
        IF(IS.EQ. 46) OP =' -Z,Y,-X'
        IF(IS.EQ. 47) OP =' Z,-Y,-X'
        IF(IS.EQ. 48) OP =' Z,Y,X'
        IF(IS.EQ. 49) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 50) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 51) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 52) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 53) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 54) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 55) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ. 56) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ. 57) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 58) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 59) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 60) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 61) OP =' Y,1/2+X,1/2-Z'
        IF(IS.EQ. 62) OP =' -Y,1/2-X,1/2-Z'
        IF(IS.EQ. 63) OP =' Y,1/2-X,1/2+Z'
        IF(IS.EQ. 64) OP =' -Y,1/2+X,1/2+Z'
        IF(IS.EQ. 65) OP =' X,1/2+Z,1/2-Y'
        IF(IS.EQ. 66) OP =' -X,1/2+Z,1/2+Y'
        IF(IS.EQ. 67) OP =' -X,1/2-Z,1/2-Y'
        IF(IS.EQ. 68) OP =' X,1/2-Z,1/2+Y'
        IF(IS.EQ. 69) OP =' Z,1/2+Y,1/2-X'
        IF(IS.EQ. 70) OP =' Z,1/2-Y,1/2+X'
        IF(IS.EQ. 71) OP =' -Z,1/2+Y,1/2+X'
        IF(IS.EQ. 72) OP =' -Z,1/2-Y,1/2-X'
        IF(IS.EQ. 73) OP =' -X,1/2-Y,1/2-Z'
        IF(IS.EQ. 74) OP =' X,1/2+Y,1/2-Z'
        IF(IS.EQ. 75) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ. 76) OP =' -X,1/2+Y,1/2+Z'
        IF(IS.EQ. 77) OP =' -Z,1/2-X,1/2-Y'
        IF(IS.EQ. 78) OP =' -Z,1/2+X,1/2+Y'
        IF(IS.EQ. 79) OP =' Z,1/2+X,1/2-Y'
        IF(IS.EQ. 80) OP =' Z,1/2-X,1/2+Y'
        IF(IS.EQ. 81) OP =' -Y,1/2-Z,1/2-X'
        IF(IS.EQ. 82) OP =' Y,1/2-Z,1/2+X'
        IF(IS.EQ. 83) OP =' -Y,1/2+Z,1/2+X'
        IF(IS.EQ. 84) OP =' Y,1/2+Z,1/2-X'
        IF(IS.EQ. 85) OP =' -Y,1/2-X,1/2+Z'
        IF(IS.EQ. 86) OP =' Y,1/2+X,1/2+Z'
        IF(IS.EQ. 87) OP =' -Y,1/2+X,1/2-Z'
        IF(IS.EQ. 88) OP =' Y,1/2-X,1/2-Z'
        IF(IS.EQ. 89) OP =' -X,1/2-Z,1/2+Y'
        IF(IS.EQ. 90) OP =' X,1/2-Z,1/2-Y'
        IF(IS.EQ. 91) OP =' X,1/2+Z,1/2+Y'
        IF(IS.EQ. 92) OP =' -X,1/2+Z,1/2-Y'
        IF(IS.EQ. 93) OP =' -Z,1/2-Y,1/2+X'
        IF(IS.EQ. 94) OP =' -Z,1/2+Y,1/2-X'
        IF(IS.EQ. 95) OP =' Z,1/2-Y,1/2-X'
        IF(IS.EQ. 96) OP =' Z,1/2+Y,1/2+X'
        IF(IS.EQ. 97) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 98) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 99) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ.100) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ.101) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ.102) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ.103) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.104) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ.105) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ.106) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ.107) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ.108) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ.109) OP =' 1/2+Y,X,1/2-Z'
        IF(IS.EQ.110) OP =' 1/2-Y,-X,1/2-Z'
        IF(IS.EQ.111) OP =' 1/2+Y,-X,1/2+Z'
        IF(IS.EQ.112) OP =' 1/2-Y,X,1/2+Z'
        IF(IS.EQ.113) OP =' 1/2+X,Z,1/2-Y'
        IF(IS.EQ.114) OP =' 1/2-X,Z,1/2+Y'
        IF(IS.EQ.115) OP =' 1/2-X,-Z,1/2-Y'
        IF(IS.EQ.116) OP =' 1/2+X,-Z,1/2+Y'
        IF(IS.EQ.117) OP =' 1/2+Z,Y,1/2-X'
        IF(IS.EQ.118) OP =' 1/2+Z,-Y,1/2+X'
        IF(IS.EQ.119) OP =' 1/2-Z,Y,1/2+X'
        IF(IS.EQ.120) OP =' 1/2-Z,-Y,1/2-X'
        IF(IS.EQ.121) OP =' 1/2-X,-Y,1/2-Z'
        IF(IS.EQ.122) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ.123) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ.124) OP =' 1/2-X,Y,1/2+Z'
        IF(IS.EQ.125) OP =' 1/2-Z,-X,1/2-Y'
        IF(IS.EQ.126) OP =' 1/2-Z,X,1/2+Y'
        IF(IS.EQ.127) OP =' 1/2+Z,X,1/2-Y'
        IF(IS.EQ.128) OP =' 1/2+Z,-X,1/2+Y'
        IF(IS.EQ.129) OP =' 1/2-Y,-Z,1/2-X'
        IF(IS.EQ.130) OP =' 1/2+Y,-Z,1/2+X'
        IF(IS.EQ.131) OP =' 1/2-Y,Z,1/2+X'
        IF(IS.EQ.132) OP =' 1/2+Y,Z,1/2-X'
        IF(IS.EQ.133) OP =' 1/2-Y,-X,1/2+Z'
        IF(IS.EQ.134) OP =' 1/2+Y,X,1/2+Z'
        IF(IS.EQ.135) OP =' 1/2-Y,X,1/2-Z'
        IF(IS.EQ.136) OP =' 1/2+Y,-X,1/2-Z'
        IF(IS.EQ.137) OP =' 1/2-X,-Z,1/2+Y'
        IF(IS.EQ.138) OP =' 1/2+X,-Z,1/2-Y'
        IF(IS.EQ.139) OP =' 1/2+X,Z,1/2+Y'
        IF(IS.EQ.140) OP =' 1/2-X,Z,1/2-Y'
        IF(IS.EQ.141) OP =' 1/2-Z,-Y,1/2+X'
        IF(IS.EQ.142) OP =' 1/2-Z,Y,1/2-X'
        IF(IS.EQ.143) OP =' 1/2+Z,-Y,1/2-X'
        IF(IS.EQ.144) OP =' 1/2+Z,Y,1/2+X'
        IF(IS.EQ.145) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.146) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.147) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.148) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.149) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ.150) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.151) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ.152) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ.153) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ.154) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ.155) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ.156) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ.157) OP =' 1/2+Y,1/2+X,-Z'
        IF(IS.EQ.158) OP =' 1/2-Y,1/2-X,-Z'
        IF(IS.EQ.159) OP =' 1/2+Y,1/2-X,Z'
        IF(IS.EQ.160) OP =' 1/2-Y,1/2+X,Z'
        IF(IS.EQ.161) OP =' 1/2+X,1/2+Z,-Y'
        IF(IS.EQ.162) OP =' 1/2-X,1/2+Z,Y'
        IF(IS.EQ.163) OP =' 1/2-X,1/2-Z,-Y'
        IF(IS.EQ.164) OP =' 1/2+X,1/2-Z,Y'
        IF(IS.EQ.165) OP =' 1/2+Z,1/2+Y,-X'
        IF(IS.EQ.166) OP =' 1/2+Z,1/2-Y,X'
        IF(IS.EQ.167) OP =' 1/2-Z,1/2+Y,X'
        IF(IS.EQ.168) OP =' 1/2-Z,1/2-Y,-X'
        IF(IS.EQ.169) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ.170) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ.171) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.172) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.173) OP =' 1/2-Z,1/2-X,-Y'
        IF(IS.EQ.174) OP =' 1/2-Z,1/2+X,Y'
        IF(IS.EQ.175) OP =' 1/2+Z,1/2+X,-Y'
        IF(IS.EQ.176) OP =' 1/2+Z,1/2-X,Y'
        IF(IS.EQ.177) OP =' 1/2-Y,1/2-Z,-X'
        IF(IS.EQ.178) OP =' 1/2+Y,1/2-Z,X'
        IF(IS.EQ.179) OP =' 1/2-Y,1/2+Z,X'
        IF(IS.EQ.180) OP =' 1/2+Y,1/2+Z,-X'
        IF(IS.EQ.181) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ.182) OP =' 1/2+Y,1/2+X,Z'
        IF(IS.EQ.183) OP =' 1/2-Y,1/2+X,-Z'
        IF(IS.EQ.184) OP =' 1/2+Y,1/2-X,-Z'
        IF(IS.EQ.185) OP =' 1/2-X,1/2-Z,Y'
        IF(IS.EQ.186) OP =' 1/2+X,1/2-Z,-Y'
        IF(IS.EQ.187) OP =' 1/2+X,1/2+Z,Y'
        IF(IS.EQ.188) OP =' 1/2-X,1/2+Z,-Y'
        IF(IS.EQ.189) OP =' 1/2-Z,1/2-Y,X'
        IF(IS.EQ.190) OP =' 1/2-Z,1/2+Y,-X'
        IF(IS.EQ.191) OP =' 1/2+Z,1/2-Y,-X'
        IF(IS.EQ.192) OP =' 1/2+Z,1/2+Y,X'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_41(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.246) THEN
        NO_TAB  =  226
        NS_TAB  =  192
        SG_TAB1 = 'F 4/m -3 2/c'
        SG_TAB2 = 'Fm-3c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ. 14) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ. 15) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 16) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 17) OP =' 1/2+X,1/2+Z,1/2-Y'
        IF(IS.EQ. 18) OP =' 1/2-X,1/2+Z,1/2+Y'
        IF(IS.EQ. 19) OP =' 1/2-X,1/2-Z,1/2-Y'
        IF(IS.EQ. 20) OP =' 1/2+X,1/2-Z,1/2+Y'
        IF(IS.EQ. 21) OP =' 1/2+Z,1/2+Y,1/2-X'
        IF(IS.EQ. 22) OP =' 1/2+Z,1/2-Y,1/2+X'
        IF(IS.EQ. 23) OP =' 1/2-Z,1/2+Y,1/2+X'
        IF(IS.EQ. 24) OP =' 1/2-Z,1/2-Y,1/2-X'
        IF(IS.EQ. 25) OP =' -X,-Y,-Z'
        IF(IS.EQ. 26) OP =' X,Y,-Z'
        IF(IS.EQ. 27) OP =' X,-Y,Z'
        IF(IS.EQ. 28) OP =' -X,Y,Z'
        IF(IS.EQ. 29) OP =' -Z,-X,-Y'
        IF(IS.EQ. 30) OP =' -Z,X,Y'
        IF(IS.EQ. 31) OP =' Z,X,-Y'
        IF(IS.EQ. 32) OP =' Z,-X,Y'
        IF(IS.EQ. 33) OP =' -Y,-Z,-X'
        IF(IS.EQ. 34) OP =' Y,-Z,X'
        IF(IS.EQ. 35) OP =' -Y,Z,X'
        IF(IS.EQ. 36) OP =' Y,Z,-X'
        IF(IS.EQ. 37) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 38) OP =' 1/2+Y,1/2+X,1/2+Z'
        IF(IS.EQ. 39) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 40) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 41) OP =' 1/2-X,1/2-Z,1/2+Y'
        IF(IS.EQ. 42) OP =' 1/2+X,1/2-Z,1/2-Y'
        IF(IS.EQ. 43) OP =' 1/2+X,1/2+Z,1/2+Y'
        IF(IS.EQ. 44) OP =' 1/2-X,1/2+Z,1/2-Y'
        IF(IS.EQ. 45) OP =' 1/2-Z,1/2-Y,1/2+X'
        IF(IS.EQ. 46) OP =' 1/2-Z,1/2+Y,1/2-X'
        IF(IS.EQ. 47) OP =' 1/2+Z,1/2-Y,1/2-X'
        IF(IS.EQ. 48) OP =' 1/2+Z,1/2+Y,1/2+X'
        IF(IS.EQ. 49) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 50) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ. 51) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ. 52) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ. 53) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 54) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ. 55) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ. 56) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ. 57) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 58) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 59) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ. 60) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 61) OP =' 1/2+Y,X,-Z'
        IF(IS.EQ. 62) OP =' 1/2-Y,-X,-Z'
        IF(IS.EQ. 63) OP =' 1/2+Y,-X,Z'
        IF(IS.EQ. 64) OP =' 1/2-Y,X,Z'
        IF(IS.EQ. 65) OP =' 1/2+X,Z,-Y'
        IF(IS.EQ. 66) OP =' 1/2-X,Z,Y'
        IF(IS.EQ. 67) OP =' 1/2-X,-Z,-Y'
        IF(IS.EQ. 68) OP =' 1/2+X,-Z,Y'
        IF(IS.EQ. 69) OP =' 1/2+Z,Y,-X'
        IF(IS.EQ. 70) OP =' 1/2+Z,-Y,X'
        IF(IS.EQ. 71) OP =' 1/2-Z,Y,X'
        IF(IS.EQ. 72) OP =' 1/2-Z,-Y,-X'
        IF(IS.EQ. 73) OP =' -X,1/2-Y,1/2-Z'
        IF(IS.EQ. 74) OP =' X,1/2+Y,1/2-Z'
        IF(IS.EQ. 75) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ. 76) OP =' -X,1/2+Y,1/2+Z'
        IF(IS.EQ. 77) OP =' -Z,1/2-X,1/2-Y'
        IF(IS.EQ. 78) OP =' -Z,1/2+X,1/2+Y'
        IF(IS.EQ. 79) OP =' Z,1/2+X,1/2-Y'
        IF(IS.EQ. 80) OP =' Z,1/2-X,1/2+Y'
        IF(IS.EQ. 81) OP =' -Y,1/2-Z,1/2-X'
        IF(IS.EQ. 82) OP =' Y,1/2-Z,1/2+X'
        IF(IS.EQ. 83) OP =' -Y,1/2+Z,1/2+X'
        IF(IS.EQ. 84) OP =' Y,1/2+Z,1/2-X'
        IF(IS.EQ. 85) OP =' 1/2-Y,-X,Z'
        IF(IS.EQ. 86) OP =' 1/2+Y,X,Z'
        IF(IS.EQ. 87) OP =' 1/2-Y,X,-Z'
        IF(IS.EQ. 88) OP =' 1/2+Y,-X,-Z'
        IF(IS.EQ. 89) OP =' 1/2-X,-Z,Y'
        IF(IS.EQ. 90) OP =' 1/2+X,-Z,-Y'
        IF(IS.EQ. 91) OP =' 1/2+X,Z,Y'
        IF(IS.EQ. 92) OP =' 1/2-X,Z,-Y'
        IF(IS.EQ. 93) OP =' 1/2-Z,-Y,X'
        IF(IS.EQ. 94) OP =' 1/2-Z,Y,-X'
        IF(IS.EQ. 95) OP =' 1/2+Z,-Y,-X'
        IF(IS.EQ. 96) OP =' 1/2+Z,Y,X'
        IF(IS.EQ. 97) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 98) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ. 99) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ.100) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ.101) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ.102) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ.103) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.104) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ.105) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ.106) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ.107) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ.108) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ.109) OP =' Y,1/2+X,-Z'
        IF(IS.EQ.110) OP =' -Y,1/2-X,-Z'
        IF(IS.EQ.111) OP =' Y,1/2-X,Z'
        IF(IS.EQ.112) OP =' -Y,1/2+X,Z'
        IF(IS.EQ.113) OP =' X,1/2+Z,-Y'
        IF(IS.EQ.114) OP =' -X,1/2+Z,Y'
        IF(IS.EQ.115) OP =' -X,1/2-Z,-Y'
        IF(IS.EQ.116) OP =' X,1/2-Z,Y'
        IF(IS.EQ.117) OP =' Z,1/2+Y,-X'
        IF(IS.EQ.118) OP =' Z,1/2-Y,X'
        IF(IS.EQ.119) OP =' -Z,1/2+Y,X'
        IF(IS.EQ.120) OP =' -Z,1/2-Y,-X'
        IF(IS.EQ.121) OP =' 1/2-X,-Y,1/2-Z'
        IF(IS.EQ.122) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ.123) OP =' 1/2+X,-Y,1/2+Z'
        IF(IS.EQ.124) OP =' 1/2-X,Y,1/2+Z'
        IF(IS.EQ.125) OP =' 1/2-Z,-X,1/2-Y'
        IF(IS.EQ.126) OP =' 1/2-Z,X,1/2+Y'
        IF(IS.EQ.127) OP =' 1/2+Z,X,1/2-Y'
        IF(IS.EQ.128) OP =' 1/2+Z,-X,1/2+Y'
        IF(IS.EQ.129) OP =' 1/2-Y,-Z,1/2-X'
        IF(IS.EQ.130) OP =' 1/2+Y,-Z,1/2+X'
        IF(IS.EQ.131) OP =' 1/2-Y,Z,1/2+X'
        IF(IS.EQ.132) OP =' 1/2+Y,Z,1/2-X'
        IF(IS.EQ.133) OP =' -Y,1/2-X,Z'
        IF(IS.EQ.134) OP =' Y,1/2+X,Z'
        IF(IS.EQ.135) OP =' -Y,1/2+X,-Z'
        IF(IS.EQ.136) OP =' Y,1/2-X,-Z'
        IF(IS.EQ.137) OP =' -X,1/2-Z,Y'
        IF(IS.EQ.138) OP =' X,1/2-Z,-Y'
        IF(IS.EQ.139) OP =' X,1/2+Z,Y'
        IF(IS.EQ.140) OP =' -X,1/2+Z,-Y'
        IF(IS.EQ.141) OP =' -Z,1/2-Y,X'
        IF(IS.EQ.142) OP =' -Z,1/2+Y,-X'
        IF(IS.EQ.143) OP =' Z,1/2-Y,-X'
        IF(IS.EQ.144) OP =' Z,1/2+Y,X'
        IF(IS.EQ.145) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.146) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ.147) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.148) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.149) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ.150) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.151) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ.152) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ.153) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ.154) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ.155) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ.156) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ.157) OP =' Y,X,1/2-Z'
        IF(IS.EQ.158) OP =' -Y,-X,1/2-Z'
        IF(IS.EQ.159) OP =' Y,-X,1/2+Z'
        IF(IS.EQ.160) OP =' -Y,X,1/2+Z'
        IF(IS.EQ.161) OP =' X,Z,1/2-Y'
        IF(IS.EQ.162) OP =' -X,Z,1/2+Y'
        IF(IS.EQ.163) OP =' -X,-Z,1/2-Y'
        IF(IS.EQ.164) OP =' X,-Z,1/2+Y'
        IF(IS.EQ.165) OP =' Z,Y,1/2-X'
        IF(IS.EQ.166) OP =' Z,-Y,1/2+X'
        IF(IS.EQ.167) OP =' -Z,Y,1/2+X'
        IF(IS.EQ.168) OP =' -Z,-Y,1/2-X'
        IF(IS.EQ.169) OP =' 1/2-X,1/2-Y,-Z'
        IF(IS.EQ.170) OP =' 1/2+X,1/2+Y,-Z'
        IF(IS.EQ.171) OP =' 1/2+X,1/2-Y,Z'
        IF(IS.EQ.172) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ.173) OP =' 1/2-Z,1/2-X,-Y'
        IF(IS.EQ.174) OP =' 1/2-Z,1/2+X,Y'
        IF(IS.EQ.175) OP =' 1/2+Z,1/2+X,-Y'
        IF(IS.EQ.176) OP =' 1/2+Z,1/2-X,Y'
        IF(IS.EQ.177) OP =' 1/2-Y,1/2-Z,-X'
        IF(IS.EQ.178) OP =' 1/2+Y,1/2-Z,X'
        IF(IS.EQ.179) OP =' 1/2-Y,1/2+Z,X'
        IF(IS.EQ.180) OP =' 1/2+Y,1/2+Z,-X'
        IF(IS.EQ.181) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ.182) OP =' Y,X,1/2+Z'
        IF(IS.EQ.183) OP =' -Y,X,1/2-Z'
        IF(IS.EQ.184) OP =' Y,-X,1/2-Z'
        IF(IS.EQ.185) OP =' -X,-Z,1/2+Y'
        IF(IS.EQ.186) OP =' X,-Z,1/2-Y'
        IF(IS.EQ.187) OP =' X,Z,1/2+Y'
        IF(IS.EQ.188) OP =' -X,Z,1/2-Y'
        IF(IS.EQ.189) OP =' -Z,-Y,1/2+X'
        IF(IS.EQ.190) OP =' -Z,Y,1/2-X'
        IF(IS.EQ.191) OP =' Z,-Y,1/2-X'
        IF(IS.EQ.192) OP =' Z,Y,1/2+X'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_42(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.247) THEN
        NO_TAB  =  227
        NS_TAB  =  192
        SG_TAB1 = 'F 41/d -3 2/m'
        SG_TAB2 = 'Fd-3m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ.  7) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ.  8) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ. 12) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 13) OP =' 3/4+Y,1/4+X,3/4-Z'
        IF(IS.EQ. 14) OP =' 1/4-Y,1/4-X,1/4-Z'
        IF(IS.EQ. 15) OP =' 1/4+Y,3/4-X,3/4+Z'
        IF(IS.EQ. 16) OP =' 3/4-Y,3/4+X,1/4+Z'
        IF(IS.EQ. 17) OP =' 3/4+X,1/4+Z,3/4-Y'
        IF(IS.EQ. 18) OP =' 3/4-X,3/4+Z,1/4+Y'
        IF(IS.EQ. 19) OP =' 1/4-X,1/4-Z,1/4-Y'
        IF(IS.EQ. 20) OP =' 1/4+X,3/4-Z,3/4+Y'
        IF(IS.EQ. 21) OP =' 3/4+Z,1/4+Y,3/4-X'
        IF(IS.EQ. 22) OP =' 1/4+Z,3/4-Y,3/4+X'
        IF(IS.EQ. 23) OP =' 3/4-Z,3/4+Y,1/4+X'
        IF(IS.EQ. 24) OP =' 1/4-Z,1/4-Y,1/4-X'
        IF(IS.EQ. 25) OP =' 1/4-X,1/4-Y,1/4-Z'
        IF(IS.EQ. 26) OP =' 1/4+X,3/4+Y,3/4-Z'
        IF(IS.EQ. 27) OP =' 3/4+X,3/4-Y,1/4+Z'
        IF(IS.EQ. 28) OP =' 3/4-X,1/4+Y,3/4+Z'
        IF(IS.EQ. 29) OP =' 1/4-Z,1/4-X,1/4-Y'
        IF(IS.EQ. 30) OP =' 3/4-Z,1/4+X,3/4+Y'
        IF(IS.EQ. 31) OP =' 1/4+Z,3/4+X,3/4-Y'
        IF(IS.EQ. 32) OP =' 3/4+Z,3/4-X,1/4+Y'
        IF(IS.EQ. 33) OP =' 1/4-Y,1/4-Z,1/4-X'
        IF(IS.EQ. 34) OP =' 3/4+Y,3/4-Z,1/4+X'
        IF(IS.EQ. 35) OP =' 3/4-Y,1/4+Z,3/4+X'
        IF(IS.EQ. 36) OP =' 1/4+Y,3/4+Z,3/4-X'
        IF(IS.EQ. 37) OP =' 1/2-Y,-X,1/2+Z'
        IF(IS.EQ. 38) OP =' Y,X,Z'
        IF(IS.EQ. 39) OP =' -Y,1/2+X,1/2-Z'
        IF(IS.EQ. 40) OP =' 1/2+Y,1/2-X,-Z'
        IF(IS.EQ. 41) OP =' 1/2-X,-Z,1/2+Y'
        IF(IS.EQ. 42) OP =' 1/2+X,1/2-Z,-Y'
        IF(IS.EQ. 43) OP =' X,Z,Y'
        IF(IS.EQ. 44) OP =' -X,1/2+Z,1/2-Y'
        IF(IS.EQ. 45) OP =' 1/2-Z,-Y,1/2+X'
        IF(IS.EQ. 46) OP =' -Z,1/2+Y,1/2-X'
        IF(IS.EQ. 47) OP =' 1/2+Z,1/2-Y,-X'
        IF(IS.EQ. 48) OP =' Z,Y,X'
        IF(IS.EQ. 49) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 50) OP =' -X,-Y,Z'
        IF(IS.EQ. 51) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 52) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 53) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 54) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ. 55) OP =' -Z,-X,Y'
        IF(IS.EQ. 56) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ. 57) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 58) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 59) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 60) OP =' -Y,-Z,X'
        IF(IS.EQ. 61) OP =' 3/4+Y,3/4+X,1/4-Z'
        IF(IS.EQ. 62) OP =' 1/4-Y,3/4-X,3/4-Z'
        IF(IS.EQ. 63) OP =' 1/4+Y,1/4-X,1/4+Z'
        IF(IS.EQ. 64) OP =' 3/4-Y,1/4+X,3/4+Z'
        IF(IS.EQ. 65) OP =' 3/4+X,3/4+Z,1/4-Y'
        IF(IS.EQ. 66) OP =' 3/4-X,1/4+Z,3/4+Y'
        IF(IS.EQ. 67) OP =' 1/4-X,3/4-Z,3/4-Y'
        IF(IS.EQ. 68) OP =' 1/4+X,1/4-Z,1/4+Y'
        IF(IS.EQ. 69) OP =' 3/4+Z,3/4+Y,1/4-X'
        IF(IS.EQ. 70) OP =' 1/4+Z,1/4-Y,1/4+X'
        IF(IS.EQ. 71) OP =' 3/4-Z,1/4+Y,3/4+X'
        IF(IS.EQ. 72) OP =' 1/4-Z,3/4-Y,3/4-X'
        IF(IS.EQ. 73) OP =' 1/4-X,3/4-Y,3/4-Z'
        IF(IS.EQ. 74) OP =' 1/4+X,1/4+Y,1/4-Z'
        IF(IS.EQ. 75) OP =' 3/4+X,1/4-Y,3/4+Z'
        IF(IS.EQ. 76) OP =' 3/4-X,3/4+Y,1/4+Z'
        IF(IS.EQ. 77) OP =' 1/4-Z,3/4-X,3/4-Y'
        IF(IS.EQ. 78) OP =' 3/4-Z,3/4+X,1/4+Y'
        IF(IS.EQ. 79) OP =' 1/4+Z,1/4+X,1/4-Y'
        IF(IS.EQ. 80) OP =' 3/4+Z,1/4-X,3/4+Y'
        IF(IS.EQ. 81) OP =' 1/4-Y,3/4-Z,3/4-X'
        IF(IS.EQ. 82) OP =' 3/4+Y,1/4-Z,3/4+X'
        IF(IS.EQ. 83) OP =' 3/4-Y,3/4+Z,1/4+X'
        IF(IS.EQ. 84) OP =' 1/4+Y,1/4+Z,1/4-X'
        IF(IS.EQ. 85) OP =' 1/2-Y,1/2-X,Z'
        IF(IS.EQ. 86) OP =' Y,1/2+X,1/2+Z'
        IF(IS.EQ. 87) OP =' -Y,X,-Z'
        IF(IS.EQ. 88) OP =' 1/2+Y,-X,1/2-Z'
        IF(IS.EQ. 89) OP =' 1/2-X,1/2-Z,Y'
        IF(IS.EQ. 90) OP =' 1/2+X,-Z,1/2-Y'
        IF(IS.EQ. 91) OP =' X,1/2+Z,1/2+Y'
        IF(IS.EQ. 92) OP =' -X,Z,-Y'
        IF(IS.EQ. 93) OP =' 1/2-Z,1/2-Y,X'
        IF(IS.EQ. 94) OP =' -Z,Y,-X'
        IF(IS.EQ. 95) OP =' 1/2+Z,-Y,1/2-X'
        IF(IS.EQ. 96) OP =' Z,1/2+Y,1/2+X'
        IF(IS.EQ. 97) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 98) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 99) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.100) OP =' X,-Y,-Z'
        IF(IS.EQ.101) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ.102) OP =' Z,-X,-Y'
        IF(IS.EQ.103) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ.104) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.105) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ.106) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ.107) OP =' Y,-Z,-X'
        IF(IS.EQ.108) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ.109) OP =' 1/4+Y,1/4+X,1/4-Z'
        IF(IS.EQ.110) OP =' 3/4-Y,1/4-X,3/4-Z'
        IF(IS.EQ.111) OP =' 3/4+Y,3/4-X,1/4+Z'
        IF(IS.EQ.112) OP =' 1/4-Y,3/4+X,3/4+Z'
        IF(IS.EQ.113) OP =' 1/4+X,1/4+Z,1/4-Y'
        IF(IS.EQ.114) OP =' 1/4-X,3/4+Z,3/4+Y'
        IF(IS.EQ.115) OP =' 3/4-X,1/4-Z,3/4-Y'
        IF(IS.EQ.116) OP =' 3/4+X,3/4-Z,1/4+Y'
        IF(IS.EQ.117) OP =' 1/4+Z,1/4+Y,1/4-X'
        IF(IS.EQ.118) OP =' 3/4+Z,3/4-Y,1/4+X'
        IF(IS.EQ.119) OP =' 1/4-Z,3/4+Y,3/4+X'
        IF(IS.EQ.120) OP =' 3/4-Z,1/4-Y,3/4-X'
        IF(IS.EQ.121) OP =' 3/4-X,1/4-Y,3/4-Z'
        IF(IS.EQ.122) OP =' 3/4+X,3/4+Y,1/4-Z'
        IF(IS.EQ.123) OP =' 1/4+X,3/4-Y,3/4+Z'
        IF(IS.EQ.124) OP =' 1/4-X,1/4+Y,1/4+Z'
        IF(IS.EQ.125) OP =' 3/4-Z,1/4-X,3/4-Y'
        IF(IS.EQ.126) OP =' 1/4-Z,1/4+X,1/4+Y'
        IF(IS.EQ.127) OP =' 3/4+Z,3/4+X,1/4-Y'
        IF(IS.EQ.128) OP =' 1/4+Z,3/4-X,3/4+Y'
        IF(IS.EQ.129) OP =' 3/4-Y,1/4-Z,3/4-X'
        IF(IS.EQ.130) OP =' 1/4+Y,3/4-Z,3/4+X'
        IF(IS.EQ.131) OP =' 1/4-Y,1/4+Z,1/4+X'
        IF(IS.EQ.132) OP =' 3/4+Y,3/4+Z,1/4-X'
        IF(IS.EQ.133) OP =' -Y,-X,Z'
        IF(IS.EQ.134) OP =' 1/2+Y,X,1/2+Z'
        IF(IS.EQ.135) OP =' 1/2-Y,1/2+X,-Z'
        IF(IS.EQ.136) OP =' Y,1/2-X,1/2-Z'
        IF(IS.EQ.137) OP =' -X,-Z,Y'
        IF(IS.EQ.138) OP =' X,1/2-Z,1/2-Y'
        IF(IS.EQ.139) OP =' 1/2+X,Z,1/2+Y'
        IF(IS.EQ.140) OP =' 1/2-X,1/2+Z,-Y'
        IF(IS.EQ.141) OP =' -Z,-Y,X'
        IF(IS.EQ.142) OP =' 1/2-Z,1/2+Y,-X'
        IF(IS.EQ.143) OP =' Z,1/2-Y,1/2-X'
        IF(IS.EQ.144) OP =' 1/2+Z,Y,1/2+X'
        IF(IS.EQ.145) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.146) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.147) OP =' -X,Y,-Z'
        IF(IS.EQ.148) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ.149) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ.150) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ.151) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.152) OP =' -Z,X,-Y'
        IF(IS.EQ.153) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ.154) OP =' -Y,Z,-X'
        IF(IS.EQ.155) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ.156) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ.157) OP =' 1/4+Y,3/4+X,3/4-Z'
        IF(IS.EQ.158) OP =' 3/4-Y,3/4-X,1/4-Z'
        IF(IS.EQ.159) OP =' 3/4+Y,1/4-X,3/4+Z'
        IF(IS.EQ.160) OP =' 1/4-Y,1/4+X,1/4+Z'
        IF(IS.EQ.161) OP =' 1/4+X,3/4+Z,3/4-Y'
        IF(IS.EQ.162) OP =' 1/4-X,1/4+Z,1/4+Y'
        IF(IS.EQ.163) OP =' 3/4-X,3/4-Z,1/4-Y'
        IF(IS.EQ.164) OP =' 3/4+X,1/4-Z,3/4+Y'
        IF(IS.EQ.165) OP =' 1/4+Z,3/4+Y,3/4-X'
        IF(IS.EQ.166) OP =' 3/4+Z,1/4-Y,3/4+X'
        IF(IS.EQ.167) OP =' 1/4-Z,1/4+Y,1/4+X'
        IF(IS.EQ.168) OP =' 3/4-Z,3/4-Y,1/4-X'
        IF(IS.EQ.169) OP =' 3/4-X,3/4-Y,1/4-Z'
        IF(IS.EQ.170) OP =' 3/4+X,1/4+Y,3/4-Z'
        IF(IS.EQ.171) OP =' 1/4+X,1/4-Y,1/4+Z'
        IF(IS.EQ.172) OP =' 1/4-X,3/4+Y,3/4+Z'
        IF(IS.EQ.173) OP =' 3/4-Z,3/4-X,1/4-Y'
        IF(IS.EQ.174) OP =' 1/4-Z,3/4+X,3/4+Y'
        IF(IS.EQ.175) OP =' 3/4+Z,1/4+X,3/4-Y'
        IF(IS.EQ.176) OP =' 1/4+Z,1/4-X,1/4+Y'
        IF(IS.EQ.177) OP =' 3/4-Y,3/4-Z,1/4-X'
        IF(IS.EQ.178) OP =' 1/4+Y,1/4-Z,1/4+X'
        IF(IS.EQ.179) OP =' 1/4-Y,3/4+Z,3/4+X'
        IF(IS.EQ.180) OP =' 3/4+Y,1/4+Z,3/4-X'
        IF(IS.EQ.181) OP =' -Y,1/2-X,1/2+Z'
        IF(IS.EQ.182) OP =' 1/2+Y,1/2+X,Z'
        IF(IS.EQ.183) OP =' 1/2-Y,X,1/2-Z'
        IF(IS.EQ.184) OP =' Y,-X,-Z'
        IF(IS.EQ.185) OP =' -X,1/2-Z,1/2+Y'
        IF(IS.EQ.186) OP =' X,-Z,-Y'
        IF(IS.EQ.187) OP =' 1/2+X,1/2+Z,Y'
        IF(IS.EQ.188) OP =' 1/2-X,Z,1/2-Y'
        IF(IS.EQ.189) OP =' -Z,1/2-Y,1/2+X'
        IF(IS.EQ.190) OP =' 1/2-Z,Y,1/2-X'
        IF(IS.EQ.191) OP =' Z,-Y,-X'
        IF(IS.EQ.192) OP =' 1/2+Z,1/2+Y,X'
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE GET_SPACE_GROUP_INFO_43(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.248) THEN
        NO_TAB  =  228
        NS_TAB  =  192
        SG_TAB1 = 'F 41/d -3 2/c'
        SG_TAB2 = 'Fd-3c'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,1/2-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' 1/2-X,1/2+Y,-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,-Y,1/2-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,-X,1/2-Y'
        IF(IS.EQ.  7) OP =' -Z,1/2-X,1/2+Y'
        IF(IS.EQ.  8) OP =' 1/2-Z,1/2+X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' 1/2-Y,1/2+Z,-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,-Z,1/2-X'
        IF(IS.EQ. 12) OP =' -Y,1/2-Z,1/2+X'
        IF(IS.EQ. 13) OP =' 3/4+Y,1/4+X,3/4-Z'
        IF(IS.EQ. 14) OP =' 1/4-Y,1/4-X,1/4-Z'
        IF(IS.EQ. 15) OP =' 1/4+Y,3/4-X,3/4+Z'
        IF(IS.EQ. 16) OP =' 3/4-Y,3/4+X,1/4+Z'
        IF(IS.EQ. 17) OP =' 3/4+X,1/4+Z,3/4-Y'
        IF(IS.EQ. 18) OP =' 3/4-X,3/4+Z,1/4+Y'
        IF(IS.EQ. 19) OP =' 1/4-X,1/4-Z,1/4-Y'
        IF(IS.EQ. 20) OP =' 1/4+X,3/4-Z,3/4+Y'
        IF(IS.EQ. 21) OP =' 3/4+Z,1/4+Y,3/4-X'
        IF(IS.EQ. 22) OP =' 1/4+Z,3/4-Y,3/4+X'
        IF(IS.EQ. 23) OP =' 3/4-Z,3/4+Y,1/4+X'
        IF(IS.EQ. 24) OP =' 1/4-Z,1/4-Y,1/4-X'
        IF(IS.EQ. 25) OP =' 3/4-X,3/4-Y,3/4-Z'
        IF(IS.EQ. 26) OP =' 3/4+X,1/4+Y,1/4-Z'
        IF(IS.EQ. 27) OP =' 1/4+X,1/4-Y,3/4+Z'
        IF(IS.EQ. 28) OP =' 1/4-X,3/4+Y,1/4+Z'
        IF(IS.EQ. 29) OP =' 3/4-Z,3/4-X,3/4-Y'
        IF(IS.EQ. 30) OP =' 1/4-Z,3/4+X,1/4+Y'
        IF(IS.EQ. 31) OP =' 3/4+Z,1/4+X,1/4-Y'
        IF(IS.EQ. 32) OP =' 1/4+Z,1/4-X,3/4+Y'
        IF(IS.EQ. 33) OP =' 3/4-Y,3/4-Z,3/4-X'
        IF(IS.EQ. 34) OP =' 1/4+Y,1/4-Z,3/4+X'
        IF(IS.EQ. 35) OP =' 1/4-Y,3/4+Z,1/4+X'
        IF(IS.EQ. 36) OP =' 3/4+Y,1/4+Z,1/4-X'
        IF(IS.EQ. 37) OP =' -Y,1/2-X,Z'
        IF(IS.EQ. 38) OP =' 1/2+Y,1/2+X,1/2+Z'
        IF(IS.EQ. 39) OP =' 1/2-Y,X,-Z'
        IF(IS.EQ. 40) OP =' Y,-X,1/2-Z'
        IF(IS.EQ. 41) OP =' -X,1/2-Z,Y'
        IF(IS.EQ. 42) OP =' X,-Z,1/2-Y'
        IF(IS.EQ. 43) OP =' 1/2+X,1/2+Z,1/2+Y'
        IF(IS.EQ. 44) OP =' 1/2-X,Z,-Y'
        IF(IS.EQ. 45) OP =' -Z,1/2-Y,X'
        IF(IS.EQ. 46) OP =' 1/2-Z,Y,-X'
        IF(IS.EQ. 47) OP =' Z,-Y,1/2-X'
        IF(IS.EQ. 48) OP =' 1/2+Z,1/2+Y,1/2+X'
        IF(IS.EQ. 49) OP =' X,1/2+Y,1/2+Z'
        IF(IS.EQ. 50) OP =' -X,-Y,Z'
        IF(IS.EQ. 51) OP =' 1/2-X,Y,1/2-Z'
        IF(IS.EQ. 52) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ. 53) OP =' Z,1/2+X,1/2+Y'
        IF(IS.EQ. 54) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ. 55) OP =' -Z,-X,Y'
        IF(IS.EQ. 56) OP =' 1/2-Z,X,1/2-Y'
        IF(IS.EQ. 57) OP =' Y,1/2+Z,1/2+X'
        IF(IS.EQ. 58) OP =' 1/2-Y,Z,1/2-X'
        IF(IS.EQ. 59) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 60) OP =' -Y,-Z,X'
        IF(IS.EQ. 61) OP =' 3/4+Y,3/4+X,1/4-Z'
        IF(IS.EQ. 62) OP =' 1/4-Y,3/4-X,3/4-Z'
        IF(IS.EQ. 63) OP =' 1/4+Y,1/4-X,1/4+Z'
        IF(IS.EQ. 64) OP =' 3/4-Y,1/4+X,3/4+Z'
        IF(IS.EQ. 65) OP =' 3/4+X,3/4+Z,1/4-Y'
        IF(IS.EQ. 66) OP =' 3/4-X,1/4+Z,3/4+Y'
        IF(IS.EQ. 67) OP =' 1/4-X,3/4-Z,3/4-Y'
        IF(IS.EQ. 68) OP =' 1/4+X,1/4-Z,1/4+Y'
        IF(IS.EQ. 69) OP =' 3/4+Z,3/4+Y,1/4-X'
        IF(IS.EQ. 70) OP =' 1/4+Z,1/4-Y,1/4+X'
        IF(IS.EQ. 71) OP =' 3/4-Z,1/4+Y,3/4+X'
        IF(IS.EQ. 72) OP =' 1/4-Z,3/4-Y,3/4-X'
        IF(IS.EQ. 73) OP =' 3/4-X,1/4-Y,1/4-Z'
        IF(IS.EQ. 74) OP =' 3/4+X,3/4+Y,3/4-Z'
        IF(IS.EQ. 75) OP =' 1/4+X,3/4-Y,1/4+Z'
        IF(IS.EQ. 76) OP =' 1/4-X,1/4+Y,3/4+Z'
        IF(IS.EQ. 77) OP =' 3/4-Z,1/4-X,1/4-Y'
        IF(IS.EQ. 78) OP =' 1/4-Z,1/4+X,3/4+Y'
        IF(IS.EQ. 79) OP =' 3/4+Z,3/4+X,3/4-Y'
        IF(IS.EQ. 80) OP =' 1/4+Z,3/4-X,1/4+Y'
        IF(IS.EQ. 81) OP =' 3/4-Y,1/4-Z,1/4-X'
        IF(IS.EQ. 82) OP =' 1/4+Y,3/4-Z,1/4+X'
        IF(IS.EQ. 83) OP =' 1/4-Y,1/4+Z,3/4+X'
        IF(IS.EQ. 84) OP =' 3/4+Y,3/4+Z,3/4-X'
        IF(IS.EQ. 85) OP =' -Y,-X,1/2+Z'
        IF(IS.EQ. 86) OP =' 1/2+Y,X,Z'
        IF(IS.EQ. 87) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 88) OP =' Y,1/2-X,-Z'
        IF(IS.EQ. 89) OP =' -X,-Z,1/2+Y'
        IF(IS.EQ. 90) OP =' X,1/2-Z,-Y'
        IF(IS.EQ. 91) OP =' 1/2+X,Z,Y'
        IF(IS.EQ. 92) OP =' 1/2-X,1/2+Z,1/2-Y'
        IF(IS.EQ. 93) OP =' -Z,-Y,1/2+X'
        IF(IS.EQ. 94) OP =' 1/2-Z,1/2+Y,1/2-X'
        IF(IS.EQ. 95) OP =' Z,1/2-Y,-X'
        IF(IS.EQ. 96) OP =' 1/2+Z,Y,X'
        IF(IS.EQ. 97) OP =' 1/2+X,Y,1/2+Z'
        IF(IS.EQ. 98) OP =' 1/2-X,1/2-Y,Z'
        IF(IS.EQ. 99) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.100) OP =' X,-Y,-Z'
        IF(IS.EQ.101) OP =' 1/2+Z,X,1/2+Y'
        IF(IS.EQ.102) OP =' Z,-X,-Y'
        IF(IS.EQ.103) OP =' 1/2-Z,1/2-X,Y'
        IF(IS.EQ.104) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.105) OP =' 1/2+Y,Z,1/2+X'
        IF(IS.EQ.106) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ.107) OP =' Y,-Z,-X'
        IF(IS.EQ.108) OP =' 1/2-Y,1/2-Z,X'
        IF(IS.EQ.109) OP =' 1/4+Y,1/4+X,1/4-Z'
        IF(IS.EQ.110) OP =' 3/4-Y,1/4-X,3/4-Z'
        IF(IS.EQ.111) OP =' 3/4+Y,3/4-X,1/4+Z'
        IF(IS.EQ.112) OP =' 1/4-Y,3/4+X,3/4+Z'
        IF(IS.EQ.113) OP =' 1/4+X,1/4+Z,1/4-Y'
        IF(IS.EQ.114) OP =' 1/4-X,3/4+Z,3/4+Y'
        IF(IS.EQ.115) OP =' 3/4-X,1/4-Z,3/4-Y'
        IF(IS.EQ.116) OP =' 3/4+X,3/4-Z,1/4+Y'
        IF(IS.EQ.117) OP =' 1/4+Z,1/4+Y,1/4-X'
        IF(IS.EQ.118) OP =' 3/4+Z,3/4-Y,1/4+X'
        IF(IS.EQ.119) OP =' 1/4-Z,3/4+Y,3/4+X'
        IF(IS.EQ.120) OP =' 3/4-Z,1/4-Y,3/4-X'
        IF(IS.EQ.121) OP =' 1/4-X,3/4-Y,1/4-Z'
        IF(IS.EQ.122) OP =' 1/4+X,1/4+Y,3/4-Z'
        IF(IS.EQ.123) OP =' 3/4+X,1/4-Y,1/4+Z'
        IF(IS.EQ.124) OP =' 3/4-X,3/4+Y,3/4+Z'
        IF(IS.EQ.125) OP =' 1/4-Z,3/4-X,1/4-Y'
        IF(IS.EQ.126) OP =' 3/4-Z,3/4+X,3/4+Y'
        IF(IS.EQ.127) OP =' 1/4+Z,1/4+X,3/4-Y'
        IF(IS.EQ.128) OP =' 3/4+Z,1/4-X,1/4+Y'
        IF(IS.EQ.129) OP =' 1/4-Y,3/4-Z,1/4-X'
        IF(IS.EQ.130) OP =' 3/4+Y,1/4-Z,1/4+X'
        IF(IS.EQ.131) OP =' 3/4-Y,3/4+Z,3/4+X'
        IF(IS.EQ.132) OP =' 1/4+Y,1/4+Z,3/4-X'
        IF(IS.EQ.133) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ.134) OP =' Y,1/2+X,Z'
        IF(IS.EQ.135) OP =' -Y,X,1/2-Z'
        IF(IS.EQ.136) OP =' 1/2+Y,-X,-Z'
        IF(IS.EQ.137) OP =' 1/2-X,1/2-Z,1/2+Y'
        IF(IS.EQ.138) OP =' 1/2+X,-Z,-Y'
        IF(IS.EQ.139) OP =' X,1/2+Z,Y'
        IF(IS.EQ.140) OP =' -X,Z,1/2-Y'
        IF(IS.EQ.141) OP =' 1/2-Z,1/2-Y,1/2+X'
        IF(IS.EQ.142) OP =' -Z,Y,1/2-X'
        IF(IS.EQ.143) OP =' 1/2+Z,-Y,-X'
        IF(IS.EQ.144) OP =' Z,1/2+Y,X'
        IF(IS.EQ.145) OP =' 1/2+X,1/2+Y,Z'
        IF(IS.EQ.146) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.147) OP =' -X,Y,-Z'
        IF(IS.EQ.148) OP =' X,1/2-Y,1/2-Z'
        IF(IS.EQ.149) OP =' 1/2+Z,1/2+X,Y'
        IF(IS.EQ.150) OP =' Z,1/2-X,1/2-Y'
        IF(IS.EQ.151) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.152) OP =' -Z,X,-Y'
        IF(IS.EQ.153) OP =' 1/2+Y,1/2+Z,X'
        IF(IS.EQ.154) OP =' -Y,Z,-X'
        IF(IS.EQ.155) OP =' Y,1/2-Z,1/2-X'
        IF(IS.EQ.156) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ.157) OP =' 1/4+Y,3/4+X,3/4-Z'
        IF(IS.EQ.158) OP =' 3/4-Y,3/4-X,1/4-Z'
        IF(IS.EQ.159) OP =' 3/4+Y,1/4-X,3/4+Z'
        IF(IS.EQ.160) OP =' 1/4-Y,1/4+X,1/4+Z'
        IF(IS.EQ.161) OP =' 1/4+X,3/4+Z,3/4-Y'
        IF(IS.EQ.162) OP =' 1/4-X,1/4+Z,1/4+Y'
        IF(IS.EQ.163) OP =' 3/4-X,3/4-Z,1/4-Y'
        IF(IS.EQ.164) OP =' 3/4+X,1/4-Z,3/4+Y'
        IF(IS.EQ.165) OP =' 1/4+Z,3/4+Y,3/4-X'
        IF(IS.EQ.166) OP =' 3/4+Z,1/4-Y,3/4+X'
        IF(IS.EQ.167) OP =' 1/4-Z,1/4+Y,1/4+X'
        IF(IS.EQ.168) OP =' 3/4-Z,3/4-Y,1/4-X'
        IF(IS.EQ.169) OP =' 1/4-X,1/4-Y,3/4-Z'
        IF(IS.EQ.170) OP =' 1/4+X,3/4+Y,1/4-Z'
        IF(IS.EQ.171) OP =' 3/4+X,3/4-Y,3/4+Z'
        IF(IS.EQ.172) OP =' 3/4-X,1/4+Y,1/4+Z'
        IF(IS.EQ.173) OP =' 1/4-Z,1/4-X,3/4-Y'
        IF(IS.EQ.174) OP =' 3/4-Z,1/4+X,1/4+Y'
        IF(IS.EQ.175) OP =' 1/4+Z,3/4+X,1/4-Y'
        IF(IS.EQ.176) OP =' 3/4+Z,3/4-X,3/4+Y'
        IF(IS.EQ.177) OP =' 1/4-Y,1/4-Z,3/4-X'
        IF(IS.EQ.178) OP =' 3/4+Y,3/4-Z,3/4+X'
        IF(IS.EQ.179) OP =' 3/4-Y,1/4+Z,1/4+X'
        IF(IS.EQ.180) OP =' 1/4+Y,3/4+Z,1/4-X'
        IF(IS.EQ.181) OP =' 1/2-Y,-X,Z'
        IF(IS.EQ.182) OP =' Y,X,1/2+Z'
        IF(IS.EQ.183) OP =' -Y,1/2+X,-Z'
        IF(IS.EQ.184) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ.185) OP =' 1/2-X,-Z,Y'
        IF(IS.EQ.186) OP =' 1/2+X,1/2-Z,1/2-Y'
        IF(IS.EQ.187) OP =' X,Z,1/2+Y'
        IF(IS.EQ.188) OP =' -X,1/2+Z,-Y'
        IF(IS.EQ.189) OP =' 1/2-Z,-Y,X'
        IF(IS.EQ.190) OP =' -Z,1/2+Y,-X'
        IF(IS.EQ.191) OP =' 1/2+Z,1/2-Y,1/2-X'
        IF(IS.EQ.192) OP =' Z,Y,1/2+X'
        RETURN
      ENDIF
      RETURN
      END
 
      SUBROUTINE GET_SPACE_GROUP_INFO_44(I,IS,NO_TAB,NS_TAB
     *                               ,SG_TAB1,SG_TAB2,SG_TAB3,OP,IERR)
C -------------------------------------------------------------
      INTEGER   I,IS,NO_TAB,NS_TAB
      CHARACTER SG_TAB1*(*),SG_TAB2*(*),SG_TAB3*(*),OP*(*)
C ---------------------------------------------------------------
      IF(I.EQ.249) THEN
        NO_TAB  =  229
        NS_TAB  =   96
        SG_TAB1 = 'I 4/m -3 2/m'
        SG_TAB2 = 'Im-3m'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' -X,-Y,Z'
        IF(IS.EQ.  3) OP =' -X,Y,-Z'
        IF(IS.EQ.  4) OP =' X,-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' Z,-X,-Y'
        IF(IS.EQ.  7) OP =' -Z,-X,Y'
        IF(IS.EQ.  8) OP =' -Z,X,-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,Z,-X'
        IF(IS.EQ. 11) OP =' Y,-Z,-X'
        IF(IS.EQ. 12) OP =' -Y,-Z,X'
        IF(IS.EQ. 13) OP =' Y,X,-Z'
        IF(IS.EQ. 14) OP =' -Y,-X,-Z'
        IF(IS.EQ. 15) OP =' Y,-X,Z'
        IF(IS.EQ. 16) OP =' -Y,X,Z'
        IF(IS.EQ. 17) OP =' X,Z,-Y'
        IF(IS.EQ. 18) OP =' -X,Z,Y'
        IF(IS.EQ. 19) OP =' -X,-Z,-Y'
        IF(IS.EQ. 20) OP =' X,-Z,Y'
        IF(IS.EQ. 21) OP =' Z,Y,-X'
        IF(IS.EQ. 22) OP =' Z,-Y,X'
        IF(IS.EQ. 23) OP =' -Z,Y,X'
        IF(IS.EQ. 24) OP =' -Z,-Y,-X'
        IF(IS.EQ. 25) OP =' -X,-Y,-Z'
        IF(IS.EQ. 26) OP =' X,Y,-Z'
        IF(IS.EQ. 27) OP =' X,-Y,Z'
        IF(IS.EQ. 28) OP =' -X,Y,Z'
        IF(IS.EQ. 29) OP =' -Z,-X,-Y'
        IF(IS.EQ. 30) OP =' -Z,X,Y'
        IF(IS.EQ. 31) OP =' Z,X,-Y'
        IF(IS.EQ. 32) OP =' Z,-X,Y'
        IF(IS.EQ. 33) OP =' -Y,-Z,-X'
        IF(IS.EQ. 34) OP =' Y,-Z,X'
        IF(IS.EQ. 35) OP =' -Y,Z,X'
        IF(IS.EQ. 36) OP =' Y,Z,-X'
        IF(IS.EQ. 37) OP =' -Y,-X,Z'
        IF(IS.EQ. 38) OP =' Y,X,Z'
        IF(IS.EQ. 39) OP =' -Y,X,-Z'
        IF(IS.EQ. 40) OP =' Y,-X,-Z'
        IF(IS.EQ. 41) OP =' -X,-Z,Y'
        IF(IS.EQ. 42) OP =' X,-Z,-Y'
        IF(IS.EQ. 43) OP =' X,Z,Y'
        IF(IS.EQ. 44) OP =' -X,Z,-Y'
        IF(IS.EQ. 45) OP =' -Z,-Y,X'
        IF(IS.EQ. 46) OP =' -Z,Y,-X'
        IF(IS.EQ. 47) OP =' Z,-Y,-X'
        IF(IS.EQ. 48) OP =' Z,Y,X'
        IF(IS.EQ. 49) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 50) OP =' 1/2-X,1/2-Y,1/2+Z'
        IF(IS.EQ. 51) OP =' 1/2-X,1/2+Y,1/2-Z'
        IF(IS.EQ. 52) OP =' 1/2+X,1/2-Y,1/2-Z'
        IF(IS.EQ. 53) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 54) OP =' 1/2+Z,1/2-X,1/2-Y'
        IF(IS.EQ. 55) OP =' 1/2-Z,1/2-X,1/2+Y'
        IF(IS.EQ. 56) OP =' 1/2-Z,1/2+X,1/2-Y'
        IF(IS.EQ. 57) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 58) OP =' 1/2-Y,1/2+Z,1/2-X'
        IF(IS.EQ. 59) OP =' 1/2+Y,1/2-Z,1/2-X'
        IF(IS.EQ. 60) OP =' 1/2-Y,1/2-Z,1/2+X'
        IF(IS.EQ. 61) OP =' 1/2+Y,1/2+X,1/2-Z'
        IF(IS.EQ. 62) OP =' 1/2-Y,1/2-X,1/2-Z'
        IF(IS.EQ. 63) OP =' 1/2+Y,1/2-X,1/2+Z'
        IF(IS.EQ. 64) OP =' 1/2-Y,1/2+X,1/2+Z'
        IF(IS.EQ. 65) OP =' 1/2+X,1/2+Z,1/2-Y'
        IF(IS.EQ. 66) OP =' 1/2-X,1/2+Z,1/2+Y'
        IF(IS.EQ. 67) OP =' 1/2-X,1/2-Z,1/2-Y'
        IF(IS.EQ. 68) OP =' 1/2+X,1/2-Z,1/2+Y'
        IF(IS.EQ. 69) OP =' 1/2+Z,1/2+Y,1/2-X'
        IF(IS.EQ. 70) OP =' 1/2+Z,1/2-Y,1/2+X'
        IF(IS.EQ. 71) OP =' 1/2-Z,1/2+Y,1/2+X'
        IF(IS.EQ. 72) OP =' 1/2-Z,1/2-Y,1/2-X'
        IF(IS.EQ. 73) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 74) OP =' 1/2+X,1/2+Y,1/2-Z'
        IF(IS.EQ. 75) OP =' 1/2+X,1/2-Y,1/2+Z'
        IF(IS.EQ. 76) OP =' 1/2-X,1/2+Y,1/2+Z'
        IF(IS.EQ. 77) OP =' 1/2-Z,1/2-X,1/2-Y'
        IF(IS.EQ. 78) OP =' 1/2-Z,1/2+X,1/2+Y'
        IF(IS.EQ. 79) OP =' 1/2+Z,1/2+X,1/2-Y'
        IF(IS.EQ. 80) OP =' 1/2+Z,1/2-X,1/2+Y'
        IF(IS.EQ. 81) OP =' 1/2-Y,1/2-Z,1/2-X'
        IF(IS.EQ. 82) OP =' 1/2+Y,1/2-Z,1/2+X'
        IF(IS.EQ. 83) OP =' 1/2-Y,1/2+Z,1/2+X'
        IF(IS.EQ. 84) OP =' 1/2+Y,1/2+Z,1/2-X'
        IF(IS.EQ. 85) OP =' 1/2-Y,1/2-X,1/2+Z'
        IF(IS.EQ. 86) OP =' 1/2+Y,1/2+X,1/2+Z'
        IF(IS.EQ. 87) OP =' 1/2-Y,1/2+X,1/2-Z'
        IF(IS.EQ. 88) OP =' 1/2+Y,1/2-X,1/2-Z'
        IF(IS.EQ. 89) OP =' 1/2-X,1/2-Z,1/2+Y'
        IF(IS.EQ. 90) OP =' 1/2+X,1/2-Z,1/2-Y'
        IF(IS.EQ. 91) OP =' 1/2+X,1/2+Z,1/2+Y'
        IF(IS.EQ. 92) OP =' 1/2-X,1/2+Z,1/2-Y'
        IF(IS.EQ. 93) OP =' 1/2-Z,1/2-Y,1/2+X'
        IF(IS.EQ. 94) OP =' 1/2-Z,1/2+Y,1/2-X'
        IF(IS.EQ. 95) OP =' 1/2+Z,1/2-Y,1/2-X'
        IF(IS.EQ. 96) OP =' 1/2+Z,1/2+Y,1/2+X'
        RETURN
      ENDIF
      IF(I.EQ.250) THEN
        NO_TAB  =  230
        NS_TAB  =   96
        SG_TAB1 = 'I 41/a -3 2/d'
        SG_TAB2 = 'Ia-3d'
        SG_TAB3 = ' '
        IF(IS.EQ.  1) OP =' X,Y,Z'
        IF(IS.EQ.  2) OP =' 1/2-X,-Y,1/2+Z'
        IF(IS.EQ.  3) OP =' -X,1/2+Y,1/2-Z'
        IF(IS.EQ.  4) OP =' 1/2+X,1/2-Y,-Z'
        IF(IS.EQ.  5) OP =' Z,X,Y'
        IF(IS.EQ.  6) OP =' 1/2+Z,1/2-X,-Y'
        IF(IS.EQ.  7) OP =' 1/2-Z,-X,1/2+Y'
        IF(IS.EQ.  8) OP =' -Z,1/2+X,1/2-Y'
        IF(IS.EQ.  9) OP =' Y,Z,X'
        IF(IS.EQ. 10) OP =' -Y,1/2+Z,1/2-X'
        IF(IS.EQ. 11) OP =' 1/2+Y,1/2-Z,-X'
        IF(IS.EQ. 12) OP =' 1/2-Y,-Z,1/2+X'
        IF(IS.EQ. 13) OP =' 3/4+Y,1/4+X,1/4-Z'
        IF(IS.EQ. 14) OP =' 3/4-Y,3/4-X,3/4-Z'
        IF(IS.EQ. 15) OP =' 1/4+Y,1/4-X,3/4+Z'
        IF(IS.EQ. 16) OP =' 1/4-Y,3/4+X,1/4+Z'
        IF(IS.EQ. 17) OP =' 3/4+X,1/4+Z,1/4-Y'
        IF(IS.EQ. 18) OP =' 1/4-X,3/4+Z,1/4+Y'
        IF(IS.EQ. 19) OP =' 3/4-X,3/4-Z,3/4-Y'
        IF(IS.EQ. 20) OP =' 1/4+X,1/4-Z,3/4+Y'
        IF(IS.EQ. 21) OP =' 3/4+Z,1/4+Y,1/4-X'
        IF(IS.EQ. 22) OP =' 1/4+Z,1/4-Y,3/4+X'
        IF(IS.EQ. 23) OP =' 1/4-Z,3/4+Y,1/4+X'
        IF(IS.EQ. 24) OP =' 3/4-Z,3/4-Y,3/4-X'
        IF(IS.EQ. 25) OP =' -X,-Y,-Z'
        IF(IS.EQ. 26) OP =' 1/2+X,Y,1/2-Z'
        IF(IS.EQ. 27) OP =' X,1/2-Y,1/2+Z'
        IF(IS.EQ. 28) OP =' 1/2-X,1/2+Y,Z'
        IF(IS.EQ. 29) OP =' -Z,-X,-Y'
        IF(IS.EQ. 30) OP =' 1/2-Z,1/2+X,Y'
        IF(IS.EQ. 31) OP =' 1/2+Z,X,1/2-Y'
        IF(IS.EQ. 32) OP =' Z,1/2-X,1/2+Y'
        IF(IS.EQ. 33) OP =' -Y,-Z,-X'
        IF(IS.EQ. 34) OP =' Y,1/2-Z,1/2+X'
        IF(IS.EQ. 35) OP =' 1/2-Y,1/2+Z,X'
        IF(IS.EQ. 36) OP =' 1/2+Y,Z,1/2-X'
        IF(IS.EQ. 37) OP =' 1/4-Y,3/4-X,3/4+Z'
        IF(IS.EQ. 38) OP =' 1/4+Y,1/4+X,1/4+Z'
        IF(IS.EQ. 39) OP =' 3/4-Y,3/4+X,1/4-Z'
        IF(IS.EQ. 40) OP =' 3/4+Y,1/4-X,3/4-Z'
        IF(IS.EQ. 41) OP =' 1/4-X,3/4-Z,3/4+Y'
        IF(IS.EQ. 42) OP =' 3/4+X,1/4-Z,3/4-Y'
        IF(IS.EQ. 43) OP =' 1/4+X,1/4+Z,1/4+Y'
        IF(IS.EQ. 44) OP =' 3/4-X,3/4+Z,1/4-Y'
        IF(IS.EQ. 45) OP =' 1/4-Z,3/4-Y,3/4+X'
        IF(IS.EQ. 46) OP =' 3/4-Z,3/4+Y,1/4-X'
        IF(IS.EQ. 47) OP =' 3/4+Z,1/4-Y,3/4-X'
        IF(IS.EQ. 48) OP =' 1/4+Z,1/4+Y,1/4+X'
        IF(IS.EQ. 49) OP =' 1/2+X,1/2+Y,1/2+Z'
        IF(IS.EQ. 50) OP =' -X,1/2-Y,Z'
        IF(IS.EQ. 51) OP =' 1/2-X,Y,-Z'
        IF(IS.EQ. 52) OP =' X,-Y,1/2-Z'
        IF(IS.EQ. 53) OP =' 1/2+Z,1/2+X,1/2+Y'
        IF(IS.EQ. 54) OP =' Z,-X,1/2-Y'
        IF(IS.EQ. 55) OP =' -Z,1/2-X,Y'
        IF(IS.EQ. 56) OP =' 1/2-Z,X,-Y'
        IF(IS.EQ. 57) OP =' 1/2+Y,1/2+Z,1/2+X'
        IF(IS.EQ. 58) OP =' 1/2-Y,Z,-X'
        IF(IS.EQ. 59) OP =' Y,-Z,1/2-X'
        IF(IS.EQ. 60) OP =' -Y,1/2-Z,X'
        IF(IS.EQ. 61) OP =' 1/4+Y,3/4+X,3/4-Z'
        IF(IS.EQ. 62) OP =' 1/4-Y,1/4-X,1/4-Z'
        IF(IS.EQ. 63) OP =' 3/4+Y,3/4-X,1/4+Z'
        IF(IS.EQ. 64) OP =' 3/4-Y,1/4+X,3/4+Z'
        IF(IS.EQ. 65) OP =' 1/4+X,3/4+Z,3/4-Y'
        IF(IS.EQ. 66) OP =' 3/4-X,1/4+Z,3/4+Y'
        IF(IS.EQ. 67) OP =' 1/4-X,1/4-Z,1/4-Y'
        IF(IS.EQ. 68) OP =' 3/4+X,3/4-Z,1/4+Y'
        IF(IS.EQ. 69) OP =' 1/4+Z,3/4+Y,3/4-X'
        IF(IS.EQ. 70) OP =' 3/4+Z,3/4-Y,1/4+X'
        IF(IS.EQ. 71) OP =' 3/4-Z,1/4+Y,3/4+X'
        IF(IS.EQ. 72) OP =' 1/4-Z,1/4-Y,1/4-X'
        IF(IS.EQ. 73) OP =' 1/2-X,1/2-Y,1/2-Z'
        IF(IS.EQ. 74) OP =' X,1/2+Y,-Z'
        IF(IS.EQ. 75) OP =' 1/2+X,-Y,Z'
        IF(IS.EQ. 76) OP =' -X,Y,1/2+Z'
        IF(IS.EQ. 77) OP =' 1/2-Z,1/2-X,1/2-Y'
        IF(IS.EQ. 78) OP =' -Z,X,1/2+Y'
        IF(IS.EQ. 79) OP =' Z,1/2+X,-Y'
        IF(IS.EQ. 80) OP =' 1/2+Z,-X,Y'
        IF(IS.EQ. 81) OP =' 1/2-Y,1/2-Z,1/2-X'
        IF(IS.EQ. 82) OP =' 1/2+Y,-Z,X'
        IF(IS.EQ. 83) OP =' -Y,Z,1/2+X'
        IF(IS.EQ. 84) OP =' Y,1/2+Z,-X'
        IF(IS.EQ. 85) OP =' 3/4-Y,1/4-X,1/4+Z'
        IF(IS.EQ. 86) OP =' 3/4+Y,3/4+X,3/4+Z'
        IF(IS.EQ. 87) OP =' 1/4-Y,1/4+X,3/4-Z'
        IF(IS.EQ. 88) OP =' 1/4+Y,3/4-X,1/4-Z'
        IF(IS.EQ. 89) OP =' 3/4-X,1/4-Z,1/4+Y'
        IF(IS.EQ. 90) OP =' 1/4+X,3/4-Z,1/4-Y'
        IF(IS.EQ. 91) OP =' 3/4+X,3/4+Z,3/4+Y'
        IF(IS.EQ. 92) OP =' 1/4-X,1/4+Z,3/4-Y'
        IF(IS.EQ. 93) OP =' 3/4-Z,1/4-Y,1/4+X'
        IF(IS.EQ. 94) OP =' 1/4-Z,1/4+Y,3/4-X'
        IF(IS.EQ. 95) OP =' 1/4+Z,3/4-Y,1/4-X'
        IF(IS.EQ. 96) OP =' 3/4+Z,3/4+Y,3/4+X'
        RETURN
      ENDIF     
      RETURN
      END

