C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE SET_UNIT_CORR
C -------------------------------
C     in make_subr.f:
C                    in SUBROUTINE START: after CALL SET_UNIT_NUMBERS  
C
C -------------------------------
      RETURN
      END

      SUBROUTINE SET_LINK_CORR
C -------------------------------
C     in make_crd.f:
C                    in SUBROUTINE PRE_DESCR  
C
C -------------------------------
      RETURN
      END

      SUBROUTINE WRT_BATCH(LINE)
C
C -P- WRT_BATCH - dummy routine.
C
      CHARACTER LINE*(*)
C ----------------------------
      RETURN
      END

      SUBROUTINE CLOSE_BATCH(M)
C
C -P- CLOSE_BATCH - dummy routine.
C ---
      INTEGER   M
C -------------------------
      RETURN
      END

      SUBROUTINE FINISH
C -----------------------------------------------------------
C     FINISH - dummy routine.
C -----------------------------------------------------------
      RETURN
      END

      SUBROUTINE OPENDOC(MMDOC)
C ---
      IMPLICIT NONE
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER   IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER   BAT_MODE,BATCH_FILE,IBATCH
      REAL RVAL_1,RVAL_2
C ---
      INTEGER    MMDOC
C ----------------------------
cd      INCLUDE 'crd_com.fh'
C ---------------------------------------------------------------------
C     set 1 if you want to write to log-file. 

      DOC_FILE   = 0

      RETURN
      END

      SUBROUTINE CREAT_VDW_REST(MDOC,NAMEO,CUTOFF,DMIN,IERR)
C -----------------------------------------------------------
C     dummy routine for refmac
C
      INTEGER   MDOC,IERR
      REAL      CUTOFF,DMIN
      CHARACTER NAMEO*(*)
C -----------------------------------------------------------
      IERR = 0
C --------
      RETURN
      END

      subroutine write_mtrix_record(iout_file)
      use rharvest
      use ncs_rest
      use ncs_constraints


      implicit none
c
      integer iout_file
      integer in,i,j
c
      if(n_ncs_const.gt.1) then
         do in=1,n_ncs_const
            if(in.eq.1) then
               write(iout_file,'(a6,1x,i3,3f10.6,5x,f10.5,4x,i1)')
     &              'MTRIX1',in,ncs_c_rot(1,1:3,in),ncs_c_tr(1,in),1
               write(iout_file,'(a6,1x,i3,3f10.6,5x,f10.5,4x,i1)')
     &              'MTRIX2',in,ncs_c_rot(2,1:3,in),ncs_c_tr(2,in),1
               write(iout_file,'(a6,1x,i3,3f10.6,5x,f10.5,4x,i1)')
     &              'MTRIX3',in,ncs_c_rot(3,1:3,in),ncs_c_tr(3,in),1
            else
               write(iout_file,'(a6,1x,i3,3f10.6,5x,f10.5,4x)')
     &              'MTRIX1',in,ncs_c_rot(1,1:3,in),ncs_c_tr(1,in)
               write(iout_file,'(a6,1x,i3,3f10.6,5x,f10.5,4x)')
     &              'MTRIX2',in,ncs_c_rot(2,1:3,in),ncs_c_tr(2,in)
               write(iout_file,'(a6,1x,i3,3f10.6,5x,f10.5,4x)')
     &              'MTRIX3',in,ncs_c_rot(3,1:3,in),ncs_c_tr(3,in)
            endif
         enddo
      else if(number_ncsr.gt.0.and.ncsr_use.ne.'S'.and.
     &        ncsr_write_pdb.eq.'Y') then
         do i=1,number_ncsr
            do j=1,ncs_r_chains(i)
               write(iout_file,'(a6,1x,i3,3f10.6,5x,f10.5,4x,i1)')
     &              'MTRIX1',j,ncs_r_rot(1,1:3,i,j),
     &              ncs_r_tr(1,i,j),1
               write(iout_file,'(a6,1x,i3,3f10.6,5x,f10.5,4x,i1)')
     &              'MTRIX2',j,ncs_r_rot(2,1:3,i,j),
     &              ncs_r_tr(2,i,j),1
               write(iout_file,'(a6,1x,i3,3f10.6,5x,f10.5,4x,i1)')
     &              'MTRIX3',j,ncs_r_rot(3,1:3,i,j),
     &              ncs_r_tr(3,i,j),1
            enddo
         enddo
      endif
      return
      end
c
      subroutine copy_remarks_from_input(iout,irem_mn,irem_mx)
      use restr_files
      use rharvest
      implicit none
c
c---Copy some prespecified remarks from the input file to the output pdb
c---Prespecified remark numbers are in the array remark_copy
      integer iout
      integer irem_mn,irem_mx

      integer ierr,inum,in_file,istat
      logical things_to_do
      character line*256

      character char_l*80
      logical isinteger
c
c---locals
      if(nrem_copy.le.0) return

      things_to_do = .TRUE.
      call open_form_file(in_file,input_pdb_file,ierr)
      do while(things_to_do)
         read(in_file,'(a)',iostat=istat)line
cEMARK 200

         if(istat.eq.0) then
            char_l = line(1:6)
            call ccpupc(char_l)
            if(char_l(1:6).eq.'REMARK') then
               if(isinteger(line(7:10))) then
                  read(line(7:10),*)inum
                  if(inum.ge.irem_mn.and.inum.le.irem_mx) then
                     if(any(remark_copy(1:nrem_copy).eq.inum)) then
                        write(iout,'(a)')trim(line)
                     endif
                  endif
               endif
            endif
         endif
         if(istat.ne.0.or.
     &        line(1:5).eq.'CRYST'.or.
     &        line(1:4).eq.'ATOM'.or.
     &        line(1:4).eq.'SCAL') things_to_do = .FALSE.
      enddo
      close(in_file)
c      stop

      return
      end
      
      SUBROUTINE WRITE_DEPOSIT_STATS(IOUT_FILE)
      use weights
      use agreem
      use rharvest
      use solvent_all
      use ncs_rest
c
C---This subroutine writes deposition files to IOUT_FILE.
C---IOUT_FILe is normally pdb file. It will write only if
C---number of reflections is more than 0.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'makecif_version.fh'
      include 'twin_refmac.fh'
      INTEGER IOUT_FILE
C
C---Local variables
      integer i,j
      INTEGER NB1,IREST,ITLSGRP,IPIECE,INCS,IGRP,INCH,
     &        N_REFINED_ATOMS,ISPAN
      REAL B_OVER_COOR,S_TENS(3,3),RTD2
      CHARACTER ALL_CHAINS*120
      character text_twin*128
      real rot_l(3,3),tr_l(3)
C
      logical tls_exists
      real eps_l
c
c---  Copy all specified remarks less than 3
      call copy_remarks_from_input(iout_file,0,2)
C---
C----Info about program. I.e. REFMAC

      eps_l = 1.0E-7
      rtodeg = 45.0/atan2(1.0,1.0)
      RTD2 = RTODEG*RTODEG
      IF(NHREFL_WORK.LE.0) RETURN
      NB1 = NBIN + 1
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3 REFINEMENT.'
      WRITE(IOUT_FILE,'(A,A)')
     &'REMARK   3   PROGRAM     : REFMAC ',R_VERSNO
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   AUTHORS     : MURSHUDOV,VAGIN,DODSON'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---What kind of residual
      IF(REFS.EQ.'MLKF') THEN
      IF(.NOT.MIR_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    REFINEMENT TARGET : MAXIMUM LIKELIHOOD'
      ELSEIF(MIR_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    REFINEMENT TARGET : MAXIMUM LIKELIHOOD WITH PHASES' 
      ENDIF
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    REFINEMENT TARGET : LEAST-SQUARES'
      ENDIF
C
C---Info about data (overall info)
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  DATA USED IN REFINEMENT.'
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   RESOLUTION RANGE HIGH (ANGSTROMS) : ',HD_HIGH
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   RESOLUTION RANGE LOW  (ANGSTROMS) : ',HD_LOW
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   DATA CUTOFF            (SIGMA(F)) : NONE'
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   COMPLETENESS FOR RANGE        (%) : ',
     & HPERC_SHELL_REFL(NB1)
      WRITE(IOUT_FILE,'(A,I7)')
     &'REMARK   3   NUMBER OF REFLECTIONS             : ',
     &HNREF_SHELL_WORK(NB1)
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---Info about cross validation and other overall stats 
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  FIT TO DATA USED IN REFINEMENT.'
      IF(PERC_FREE.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   CROSS-VALIDATION METHOD          : THROUGHOUT'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE TEST SET SELECTION  : RANDOM'
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   CROSS-VALIDATION METHOD          : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE TEST SET SELECTION  : NULL'
      ENDIF
      WRITE(IOUT_FILE,'(A,F8.5)')
     &'REMARK   3   R VALUE     (WORKING + TEST SET) :',
     &        HRFAC_SHELL_ALL(NB1)
      WRITE(IOUT_FILE,'(A,F8.5)')
     &'REMARK   3   R VALUE            (WORKING SET) : ',
     &        RFACTOR_WORK
      IF(PERC_FREE.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F8.5)')
     &'REMARK   3   FREE R VALUE                     : ',RFACTOR_FREE
      WRITE(IOUT_FILE,'(A,F4.1)')
     &'REMARK   3   FREE R VALUE TEST SET SIZE   (%) : ',PERC_FREE
      WRITE(IOUT_FILE,'(A,I5)')
     &'REMARK   3   FREE R VALUE TEST SET COUNT      : ',NHREFL_FREE
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE                     : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE TEST SET SIZE   (%) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE TEST SET COUNT      : NULL'   
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---Info about highest resolution bin
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  FIT IN THE HIGHEST RESOLUTION BIN.'
      WRITE(IOUT_FILE,'(A,I8)')
     &'REMARK   3   TOTAL NUMBER OF BINS USED           :',HNSHELL
      WRITE(IOUT_FILE,'(A,F8.3)')
     &'REMARK   3   BIN RESOLUTION RANGE HIGH           : ',
     &                           HD_SHELL_HIGH(HNSHELL)
      WRITE(IOUT_FILE,'(A,F8.3)')
     &'REMARK   3   BIN RESOLUTION RANGE LOW            : ',
     &                           HD_SHELL_LOW(HNSHELL)
      WRITE(IOUT_FILE,'(A,I8)')
     &'REMARK   3   REFLECTION IN BIN     (WORKING SET) : ',
     &                           HNREF_SHELL_WORK(HNSHELL)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3   BIN COMPLETENESS (WORKING+TEST) (%) : ',
     &                           HPERC_SHELL_REFL(HNSHELL)
      WRITE(IOUT_FILE,'(A,F8.3)')
     &'REMARK   3   BIN R VALUE           (WORKING SET) : ',
     &                           HRFAC_SHELL_WORK(HNSHELL)
      WRITE(IOUT_FILE,'(A,I8)')
     &'REMARK   3   BIN FREE R VALUE SET COUNT          : ',
     &                           HNREF_SHELL_FREE(HNSHELL)
      WRITE(IOUT_FILE,'(A,F8.3)')
     &'REMARK   3   BIN FREE R VALUE                    : ',
     &                           HRFAC_SHELL_FREE(HNSHELL)      
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---Info about number of different atoms      
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  NUMBER OF NON-HYDROGEN ATOMS USED IN REFINEMENT.'
      CALL FIND_NREFINED_ATOMS(N_REFINED_ATOMS)
      WRITE(IOUT_FILE,'(A,I8)')
     &'REMARK   3   ALL ATOMS                : ',N_REFINED_ATOMS
cREMARK   3   NUCLEIC ACID ATOMS       : NULL
cREMARK   3   HETEROGEN ATOMS          : NULL
cREMARK   3   SOLVENT ATOMS            : NULL
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'

C
C---Info about B values, Iso and aniso.
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  B VALUES.'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FROM WILSON PLOT           (A**2) : NULL'
      CALL FIND_B_OVER_COOR(B_OVER_COOR)
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   MEAN B VALUE      (OVERALL, A**2) : ',B_OVER_COOR
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   OVERALL ANISOTROPIC B VALUE.'
C
C----IF anisotropic scaling is available
      IF(B_LS_ANISO_OVER_FLAG) THEN
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B11 (A**2) : ',B_LS_ANISO_OVER(1)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B22 (A**2) : ',B_LS_ANISO_OVER(2)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B33 (A**2) : ',B_LS_ANISO_OVER(3)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B12 (A**2) : ',B_LS_ANISO_OVER(4)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B13 (A**2) : ',B_LS_ANISO_OVER(5)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B23 (A**2) : ',B_LS_ANISO_OVER(6)
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B11 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B22 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B33 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B12 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B13 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B23 (A**2) : NULL'
      ENDIF
C
C---Some overall error estimations
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  ESTIMATED OVERALL COORDINATE ERROR.'
      IF(HESU_CRUIC.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   ESU BASED ON R VALUE                            '//
     &'(A): ',HESU_CRUIC
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ESU BASED ON R VALUE                            '//
     &'(A): NULL'
      ENDIF
      IF(HESU_FREE.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   ESU BASED ON FREE R VALUE                       '//
     &'(A): ',HESU_FREE
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ESU BASED ON FREE R VALUE                       '//
     &'(A): NULL'
      ENDIF
      IF(HESU_ML.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   ESU BASED ON MAXIMUM LIKELIHOOD                 '//
     &'(A): ',HESU_ML
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ESU BASED ON MAXIMUM LIKELIHOOD                 '//
     &'(A): NULL'
      ENDIF
      IF(HESU_ML_B.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   ESU FOR B VALUES BASED ON MAXIMUM LIKELIHOOD '//
     &'(A**2): ',HESU_ML_B
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ESU FOR B VALUES BASED ON MAXIMUM LIKELIHOOD '//
     &'(A**2): NULL'
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'

C
C---Correlation coefficients
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3 CORRELATION COEFFICIENTS.'
      IF(HCORR_FOFC.LE.1.0.AND.HCORR_FOFC.GE.-1.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   CORRELATION COEFFICIENT FO-FC      : ',HCORR_FOFC
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   CORRELATION COEFFICIENT FO-FC      : NULL'
      ENDIF
      IF(HCORR_FOFC_FREE.LE.1.0.AND.HCORR_FOFC_FREE.GE.-1.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   CORRELATION COEFFICIENT FO-FC FREE : ',
     &HCORR_FOFC_FREE
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   CORRELATION COEFFICIENT FO-FC FREE : NULL'
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---Geometric restraints
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  RMS DEVIATIONS FROM IDEAL VALUES        COUNT'
     &//'    RMS    WEIGHT'
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond distances: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   BOND LENGTHS REFINED ATOMS        (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO      
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond distances: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   BOND LENGTHS OTHERS               (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
c
c---copy all specified remarks more than 3

      ENDIF
      ENDDO  
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond angles  : refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   BOND ANGLES REFINED ATOMS   (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond angles  : others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   BOND ANGLES OTHERS          (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Torsion angles, period  1. refined')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   TORSION ANGLES, PERIOD 1    (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Torsion angles, period  2. refined')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   TORSION ANGLES, PERIOD 2    (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Torsion angles, period  3. refined')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   TORSION ANGLES, PERIOD 3    (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Torsion angles, period  4. refined')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   TORSION ANGLES, PERIOD 4    (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Chiral centres: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   CHIRAL-CENTER RESTRAINTS       (A**3):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Planar groups: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   GENERAL PLANES REFINED ATOMS      (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Planar groups: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   GENERAL PLANES OTHERS             (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'VDW repulsions: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   NON-BONDED CONTACTS REFINED ATOMS (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO 
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'VDW repulsions: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   NON-BONDED CONTACTS OTHERS        (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO      

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'VDW; torsion: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   NON-BONDED TORSION REFINED ATOMS  (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'VDW; torsion: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   NON-BONDED TORSION OTHERS         (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'HBOND: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   H-BOND (X...Y) REFINED ATOMS      (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'HBOND: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   H-BOND (X...Y) OTHERS             (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Metal-ion: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   POTENTIAL METAL-ION REFINED ATOMS (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Metal-ion: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   POTENTIAL METAL-ION OTHERS        (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'VDW repulsions; symmetry: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY VDW REFINED ATOMS        (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'VDW repulsions; symmetry: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY VDW OTHERS               (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'HBOND; symmetry: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY H-BOND REFINED ATOMS     (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'HBOND; symmetry: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY H-BOND OTHERS            (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'Metal-ion; symmetry: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY METAL-ION REFINED ATOMS  (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'Metal-ion; symmetry: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY METAL-ION OTHERS         (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  ISOTROPIC THERMAL FACTOR RESTRAINTS.     COUNT'
     &//'   RMS    WEIGHT'
C
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'M. chain bond B values: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   MAIN-CHAIN BOND REFINED ATOMS  (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:30).EQ.
     &        'M. chain bond B values: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   MAIN-CHAIN BOND OTHER ATOMS    (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'M. chain angle B values: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   MAIN-CHAIN ANGLE REFINED ATOMS (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'S. chain bond B values: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SIDE-CHAIN BOND REFINED ATOMS  (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'S. chain angle B values: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SIDE-CHAIN ANGLE REFINED ATOMS (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      IF(ITEMP.GT.1) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3 ANISOTROPIC THERMAL FACTOR RESTRAINTS.    COUNT'
     &//'   RMS   WEIGHT'
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'Rigid bond restraints')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   RIGID-BOND RESTRAINTS          (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:22).EQ.
     &        'Sphericity. Free atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SPHERICITY; FREE ATOMS         (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:24).EQ.
     &        'Sphericity. Bonded atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SPHERICITY; BONDED ATOMS       (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      ENDIF
C
C--------------Ncs restraints
      WRITE(IOUT_FILE,'(A)')
     &     'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &     'REMARK   3  NCS RESTRAINTS STATISTICS'
      IF(NUMBER_NCSR.LE.0) THEN

         WRITE(IOUT_FILE,'(A,I4)')
     &        'REMARK   3   NUMBER OF NCS GROUPS : NULL'
      elseif(ncsr_use.eq.'S') then
         call write_ncs_local_deposit(iout_file)
      ELSE
         write(iout_file,'(a)')
     &        'REMARK   3   NCS TYPE: GLOBAL'
         WRITE(IOUT_FILE,'(A,I4)')
     &        'REMARK   3   NUMBER OF DIFFERENT NCS GROUPS :',
     &        NUMBER_NCSR
         DO   INCS = 1,NUMBER_NCSR
            WRITE(IOUT_FILE,'(A)')
     &           'REMARK   3'
            WRITE(IOUT_FILE,'(A,I4)')
     &           'REMARK   3  NCS GROUP NUMBER               :',
     &           INCS
            ALL_CHAINS = ' '
            DO   INCH=1,NCS_N_CHAIN(INCS)
               IF(len_Trim(ALL_CHAINS).GT.0) THEN
                  ALL_CHAINS=trim(ALL_CHAINS)//' '//
     &                 NCS_CHAINS(INCH,INCS)
               ELSE
                  ALL_CHAINS = ' '//NCS_CHAINS(INCH,INCS)
               ENDIF
            ENDDO
            WRITE(IOUT_FILE,'(A)')
     &           'REMARK   3     CHAIN NAMES                    :'
     &           //trim(ALL_CHAINS)
            WRITE(IOUT_FILE,'(A,I4)')
     &           'REMARK   3     NUMBER OF COMPONENTS NCS GROUP : ',
     &           NCS_SPANS(INCS)
            WRITE(IOUT_FILE,'(A)')
     &'REMARK   3       COMPONENT C  SSSEQI  TO  C   SSSEQI   CODE'
            DO ISPAN = 1,NCS_SPANS(INCS)
               DO  INCH=1,NCS_N_CHAIN(INCS)
                  WRITE(IOUT_FILE,'(A,I4,5X,A,I6,7X,A,1X,I6,3X,I4)')
     &                 'REMARK   3        ',ISPAN,NCS_CHAINS(INCH,INCS),
     &                 NCS_IRES_FIRST(ISPAN,INCS),
     &                 NCS_CHAINS(INCH,INCS),
     &                 NCS_IRES_LAST(ISPAN,INCS),
     &                 NCS_ICODE(ISPAN,INCS)
               ENDDO
            ENDDO

            WRITE(IOUT_FILE,'(A)')
     &           'REMARK   3                   GROUP CHAIN        COUNT'
     &           //'   RMS     WEIGHT'
            DO   IREST = 1,HNRESTR
               IF(HRESTR_TYPE(IREST)(1:29).EQ.
     &              'NCS: tight positional , group') THEN
                  READ(HRESTR_TYPE(IREST)(30:32),'(I3)')IGRP
                  IF(IGRP.EQ.INCS) THEN
                     WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &                    'REMARK   3   TIGHT POSITIONAL  '//
     &                    HRESTR_TYPE(IREST)(30:32)//'   '//
     &                    HRESTR_TYPE(IREST)(42:43)//
     &                    '    (A): ',
     &                    HRESTR_NUM(IREST),' ; ',
     &                    HRESTR_DEV(IREST),' ; ',
     &                    HRESTR_DEVITAR(IREST)
                  ENDIF
               ENDIF
            ENDDO
            
            DO   IREST = 1,HNRESTR
               IF(HRESTR_TYPE(IREST)(1:29).EQ.
     &              'NCS: medium positional, group') THEN
                  READ(HRESTR_TYPE(IREST)(30:32),'(I3)')IGRP
                  IF(IGRP.EQ.INCS) THEN

                     WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &                    'REMARK   3   MEDIUM POSITIONAL '//
     &                    HRESTR_TYPE(IREST)(30:32)//'   '//
     &                    HRESTR_TYPE(IREST)(42:43)//
     &                    '    (A): ',
     &                    HRESTR_NUM(IREST),' ; ',
     &                    HRESTR_DEV(IREST),' ; ',
     &                    HRESTR_DEVITAR(IREST)
                  ENDIF
               ENDIF
            ENDDO

            DO   IREST = 1,HNRESTR
               IF(HRESTR_TYPE(IREST)(1:29).EQ.
     &              'NCS: loose positional , group') THEN
                  READ(HRESTR_TYPE(IREST)(30:32),'(I3)')IGRP
                  IF(IGRP.EQ.INCS) THEN
                     WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &                    'REMARK   3   LOOSE POSITIONAL  '//
     &                    HRESTR_TYPE(IREST)(30:32)//'   '//
     &                    HRESTR_TYPE(IREST)(42:43)//
     &                    '    (A): ',
     &                    HRESTR_NUM(IREST),' ; ',
     &                    HRESTR_DEV(IREST),' ; ',
     &                    HRESTR_DEVITAR(IREST)
                  ENDIF
               ENDIF
            ENDDO
C
            DO   IREST = 1,HNRESTR
               IF(HRESTR_TYPE(IREST)(1:29).EQ.
     &              'NCS: tight thermal    , group')THEN
                  READ(HRESTR_TYPE(IREST)(30:32),'(I3)')IGRP
                  IF(IGRP.EQ.INCS) THEN
                     WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &                    'REMARK   3   TIGHT THERMAL     '//
     &                    HRESTR_TYPE(IREST)(30:32)//'   '//
     &                    HRESTR_TYPE(IREST)(42:43)//
     &                    ' (A**2): ',
     &                    HRESTR_NUM(IREST),' ; ',
     &                    HRESTR_DEV(IREST),' ; ',
     &                    HRESTR_DEVITAR(IREST)
                  ENDIF
               ENDIF
            ENDDO
            
            DO   IREST = 1,HNRESTR
               IF(HRESTR_TYPE(IREST)(1:29).EQ.
     &              'NCS: medium thermal   , group')THEN
                  READ(HRESTR_TYPE(IREST)(30:32),'(I3)')IGRP
                  IF(IGRP.EQ.INCS) THEN
                     WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &                    'REMARK   3   MEDIUM THERMAL    '//
     &                    HRESTR_TYPE(IREST)(30:32)//'   '//
     &                    HRESTR_TYPE(IREST)(42:43)//
     &                    ' (A**2): ',
     &                    HRESTR_NUM(IREST),' ; ',
     &                    HRESTR_DEV(IREST),' ; ',
     &                    HRESTR_DEVITAR(IREST)
                  ENDIF
               ENDIF
            ENDDO
            DO   IREST = 1,HNRESTR
               IF(HRESTR_TYPE(IREST)(1:29).EQ.
     &              'NCS: loose thermal    , group') THEN
                  READ(HRESTR_TYPE(IREST)(30:32),'(I3)')IGRP
                  IF(IGRP.EQ.INCS) THEN
                     WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &                    'REMARK   3   LOOSE THERMAL     '//
     &                    HRESTR_TYPE(IREST)(30:32)//'   '//
     &                    HRESTR_TYPE(IREST)(42:43)//
     &                    ' (A**2): ',
     &                    HRESTR_NUM(IREST),' ; ',
     &                    HRESTR_DEV(IREST),' ; ',
     &                    HRESTR_DEVITAR(IREST)
                  ENDIF
               ENDIF
            ENDDO
         ENDDO
      ENDIF

      write(iout_file,'(a)') 'REMARK   3'
      write(iout_file,'(a)')'REMARK   3  TWIN DETAILS'
      if(ntwin_domain.le.1) then
         write(iout_file,'(a)')
     &        'REMARK   3   NUMBER OF TWIN DOMAINS  : NULL'
      else
         write(iout_file,'(a,i4)')
     &        'REMARK   3   NUMBER OF TWIN DOMAINS  : ',ntwin_domain  
         do i=1,ntwin_domain
            write(iout_file,'(a,i4)')
     &        'REMARK   3      TWIN DOMAIN   : ',i
            rot_l(1:3,1:3) = float(twin_oper(1:3,1:3,i))/12.0
            tr_l(1:3) = 0.0
            call put_symm_to_text(rot_l,tr_l,text_twin)
            write(iout_file,'(a,a)')
     &        'REMARK   3      TWIN OPERATOR : ',trim(text_twin)
            write(iout_file,'(a,f5.3)')
     &        'REMARK   3      TWIN FRACTION : ',twin_frac(i)
         enddo           
      endif

      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      IF(NTLSGRP.LE.0) THEN
         WRITE(IOUT_FILE,'(A)')
     &        'REMARK   3'
         WRITE(IOUT_FILE,'(A)')
     &        'REMARK   3  TLS DETAILS'
         WRITE(IOUT_FILE,'(A,I4)')
     &        'REMARK   3   NUMBER OF TLS GROUPS  : NULL'
      ELSE
         WRITE(IOUT_FILE,'(A)')
     &        'REMARK   3'
         WRITE(IOUT_FILE,'(A)')
     &        'REMARK   3  TLS DETAILS'
         WRITE(IOUT_FILE,'(A,I4)')
     &        'REMARK   3   NUMBER OF TLS GROUPS  : ',NTLSGRP
c
c--- We should change this remark for cases when added
         if(.not.tls_add_atoms) then
            WRITE(IOUT_FILE,'(A)')
     &      'REMARK   3   '//
     &        'ATOM RECORD CONTAINS RESIDUAL B FACTORS ONLY'
         else
            write(iout_file,'(a)')
     &      'REMARK   3   '//
     &        'ATOM RECORD CONTAINS SUM OF TLS AND RESIDUAL B FACTORS'
         endif
         DO    ITLSGRP = 1,NTLSGRP 
            WRITE(IOUT_FILE,'(A)')
     &           'REMARK   3'
            WRITE(IOUT_FILE,'(A,I5)')
     &           'REMARK   3   TLS GROUP : ',ITLSGRP
            WRITE(IOUT_FILE,'(A,I4)')
     &           'REMARK   3    NUMBER OF COMPONENTS GROUP : ',
     &           ITLSGRP_PIECES(ITLSGRP)
            WRITE(IOUT_FILE,'(A)')
     &           'REMARK   3    COMPONENTS        C SSSEQI   TO'
     &           //'  C SSSEQI'
            DO   IPIECE = 1,ITLSGRP_PIECES(ITLSGRP)
               WRITE(IOUT_FILE,'(A,3X,A1,I6,8X,A1,I6)')
     &       'REMARK   3    RESIDUE RANGE :',TLSGRP_CHN(IPIECE,ITLSGRP),
     &              ITLSGRP_FROM(IPIECE,ITLSGRP),
     &              TLSGRP_CHN(IPIECE,ITLSGRP),
     &              ITLSGRP_TO(IPIECE,ITLSGRP)
            ENDDO
            WRITE(IOUT_FILE,'(A,3F9.4)')
     &           'REMARK   3    ORIGIN FOR THE GROUP (A):',
     &           (TLSORIGIN(I,ITLSGRP),I=1,3)
            WRITE(IOUT_FILE,'(A)')
     &           'REMARK   3    T TENSOR'
            WRITE(IOUT_FILE,'(2(A,F9.4))')
     &    'REMARK   3      T11:',TMAT(1,ITLSGRP),' T22:',TMAT(2,ITLSGRP)
            WRITE(IOUT_FILE,'(2(A,F9.4))')
     &    'REMARK   3      T33:',TMAT(3,ITLSGRP),' T12:',TMAT(4,ITLSGRP)
            WRITE(IOUT_FILE,'(2(A,F9.4))')
     &    'REMARK   3      T13:',TMAT(5,ITLSGRP),' T23:',TMAT(6,ITLSGRP)

            WRITE(IOUT_FILE,'(A)')
     &           'REMARK   3    L TENSOR'
            WRITE(IOUT_FILE,'(2(A,F9.4))')
     &           'REMARK   3      L11:',LMAT(1,ITLSGRP)*RTD2,
     &           ' L22:',LMAT(2,ITLSGRP)*RTD2
            WRITE(IOUT_FILE,'(2(A,F9.4))')
     &           'REMARK   3      L33:',LMAT(3,ITLSGRP)*RTD2,
     &           ' L12:',LMAT(4,ITLSGRP)*RTD2
            WRITE(IOUT_FILE,'(2(A,F9.4))')
     &           'REMARK   3      L13:',LMAT(5,ITLSGRP)*RTD2,
     &           ' L23:',LMAT(6,ITLSGRP)*RTD2
            
            S_TENS(1,2) = SMAT(3,ITLSGRP)*RTODEG
            S_TENS(1,3) = SMAT(4,ITLSGRP)*RTODEG
            S_TENS(2,3) = SMAT(5,ITLSGRP)*RTODEG
            S_TENS(2,1) = SMAT(6,ITLSGRP)*RTODEG
            S_TENS(3,1) = SMAT(7,ITLSGRP)*RTODEG
            S_TENS(3,2) = SMAT(8,ITLSGRP)*RTODEG
            S_TENS(3,3) = -(2.0*SMAT(2,ITLSGRP) + SMAT(1,ITLSGRP))*
     &           RTODEG/3.0
            S_TENS(1,1) = S_TENS(3,3) + SMAT(2,ITLSGRP)*RTODEG
            S_TENS(2,2) = S_TENS(1,1) + SMAT(1,ITLSGRP)*RTODEG
            WRITE(IOUT_FILE,'(A)')
     &           'REMARK   3    S TENSOR'
            WRITE(IOUT_FILE,'(3(A,F9.4))')
     &           'REMARK   3      S11:',S_TENS(1,1),' S12:',S_TENS(1,2),
     &           ' S13:',S_TENS(1,3)
            WRITE(IOUT_FILE,'(3(A,F9.4))')
     &           'REMARK   3      S21:',S_TENS(2,1),' S22:',S_TENS(2,2),
     &           ' S23:',S_TENS(2,3)
            WRITE(IOUT_FILE,'(3(A,F9.4))')
     &           'REMARK   3      S31:',S_TENS(3,1),' S32:',S_TENS(3,2),
     &           ' S33:',S_TENS(3,3)
         ENDDO
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C----Info about bulk solvent modelling
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  BULK SOLVENT MODELLING.'
      IF(BULK_LS_FLAG.AND.SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   METHOD USED : BABINET MODEL WITH MASK'
      ELSEIF(.NOT.BULK_LS_FLAG.AND.SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   METHOD USED :  MASK'
      ELSEIF(.NOT.BULK_LS_FLAG.AND..NOT.SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   METHOD USED : NONE'
      ELSEIF(BULK_LS_FLAG.AND..NOT.SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   METHOD USED : BABINET MODEL'
      ENDIF

      IF(SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   PARAMETERS FOR MASK CALCULATION'
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   VDW PROBE RADIUS   : ',PROB_VDW
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   ION PROBE RADIUS   : ',PROB_ION
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   SHRINKAGE RADIUS   : ',RADII_SHRINK
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   PARAMETERS FOR MASK CACLULATION'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   VDW PROBE RADIUS   : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ION PROBE RADIUS   : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   SHRINKAGE RADIUS   : NULL'
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  OTHER REFINEMENT REMARKS:'
      IF(MAKE_HFLAG.EQ.'A') THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  HYDROGENS HAVE BEEN ADDED IN THE RIDING POSITIONS'
      elseif(make_hflag.eq.'Y') then
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  HYDROGENS HAVE BEEN USED IF PRESENT IN THE INPUT'
      else

      ENDIF
      tls_exists = .FALSE.
      if(ntlsgrp.gt.0) then
         if(maxval(abs(tmat(1:6,1:ntlsgrp)))+
     &        maxval(abs(lmat(1:6,1:ntlsgrp)))+
     &        maxval(abs(smat(1:8,1:ntlsgrp))).gt.eps_l) 
     &        tls_exists = .TRUE.
      endif
      if(tls_exists.and.tls_add_atoms) then
      write(iout_file,'(a)')
     &'REMARK   3  U VALUES      : WITH TLS ADDED'
      elseif(tls_exists) then
      write(iout_file,'(a)')
     &'REMARK   3  U VALUES      : RESIDUAL ONLY'
      else
      write(iout_file,'(a)')
     &'REMARK   3  U VALUES      : REFINED INDIVIDUALLY'
      endif

     
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'


      call copy_remarks_from_input(iout_file,4,1000)

      RETURN
      END
C
      subroutine write_ncs_local_deposit(iout_file)
      use rharvest
      use ncs_rest
      use restr_files
c
C---This subroutine writes deposition files to IOUT_FILE.
C---IOUT_FILe is normally pdb file. It will write only if
C---number of reflections is more than 0.
      IMPLICIT NONE
c
      integer iout_file

      integer ifile,ierr
      integer igr,igr1,ngroups,nr,nr_all,nrests
      integer ires_s1,ires_s2,ires_e1,ires_e2
      character res_s1*6,res_s2*6,res_e1*6,res_e2*6

      character chain1*11,chain2*11
      character ch1*1,ch2*1
      integer k
      integer, allocatable :: ia1_l(:,:)
      real, allocatable :: sigx_l(:)
      real, allocatable :: wtb(:)
c
      integer ih
c
c---body
      if(len_trim(ncs_simil_file).le.0) return
      
      call open_unform_file(ifile,ncs_simil_file,ierr)
      read(ifile)ngroups,nr_all
      if(ngroups.le.0) then
         close(ifile)
         return
      endif
      write(iout_file,'(a)')
     &     'REMARK   3   NCS TYPE: LOCAL'
      write(iout_file,'(a,i4)')
     &     'REMARK   3   NUMBER OF DIFFERENT NCS PAIRS  :',
     &     ngroups
         write(iout_file,'(a,a,a)')
     &     'REMARK   3  GROUP  CHAIN1    RANGE     ',
     &     'CHAIN2     RANGE    COUNT'
     &     ,' RMS  WEIGHT'
      do igr=1,ngroups
         read(ifile)nrests
         read(ifile)chain1,chain2
c
c---Extract chain and residue ranges
         read(chain1,'(a1,a5,a5)')ch1,res_s1,res_e1
         read(chain2,'(a1,a5,a5)')ch2,res_s2,res_e2
         do ih=1,hnrestr
            if(hrestr_type(ih)(1:18).eq. 'ncsr local: group ') then
               read(hrestr_type(ih),'(18x,i4)')igr1
               if(igr1.eq.igr) then
                  write(iout_file,
     &'(a11,i4,2x,a4,2x,a6,1x,a6,2x,a4,2x,a6,1x,a6,i6,f6.2,f6.2)')
     &                 'REMARK   3 ',igr,ch1,res_s1,res_e1,
     &                 ch2,res_s2,res_e2,HRESTR_NUM(ih),
     &                 HRESTR_DEV(ih),
     &                 HRESTR_DEVITAR(ih)
               endif
            endif
         enddo
         nr_all = 0
         do while (nr_all.lt.nrests)
            read(ifile)nr
            if(nr.le.0) cycle
            allocate(ia1_l(4,nr))
            allocate(sigx_l(nr))
            allocate(wtb(nr))
            nr_all = nr_all + nr
            read(ifile)(ia1_l(1:4,k),sigx_l(k),wtb(k),k=1,nr)
            deallocate(ia1_l)
            deallocate(sigx_l)
            deallocate(wtb)
         enddo
      enddo
      close(ifile)

      return
      end
c
      SUBROUTINE FIND_B_OVER_COOR(B_OVER_COOR)
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'const.fh'
C
      REAL B_OVER_COOR
      INTEGER IA
C
      B_OVER_COOR = 0.0
      DO   IA = 1,N_ATOM
        IF(OCCUP(IA).GT.0) THEN
          IF(U_ANISO(2,IA).EQ.0.0) THEN
            B_OVER_COOR = B_OVER_COOR + U_ANISO(1,IA)
          ELSE
            B_OVER_COOR = B_OVER_COOR + 
     &            (U_ANISO(1,IA)+U_ANISO(2,IA)+U_ANISO(3,IA))/3.0
          ENDIF
       ENDIF
      ENDDO
      B_OVER_COOR = B_OVER_COOR/FLOAT(N_ATOM)*PISQ8
      RETURN
      END
C
      SUBROUTINE FIND_NREFINED_ATOMS(N_REFINED_ATOMS)
C
      IMPLICIT NONE
      INTEGER N_REFINED_ATOMS
      INCLUDE 'atom_com.fh'
C
      INTEGER IA,I_INTER,I_1
C
      N_REFINED_ATOMS = 0
      DO    IA=1,N_ATOM
        I_INTER = ATOM_REF_FLAG(IA)/10
        I_1 = ATOM_REF_FLAG(IA) - I_INTER*10
        IF(I_1.GT.2) THEN
          N_REFINED_ATOMS = N_REFINED_ATOMS + 1
        ENDIF
      ENDDO
      RETURN
      END
