program hklf52mmcif
  implicit none

  integer itk
  !
  !   Read hklf5 file convert them to mmcif file. sort out Free reflections 
  !   also

  !
  !  Parser things
  integer npars
  parameter (npars=500)
  character line*512
  integer   iscrk
  integer   ntok
  logical   lprint,lend
  real      fvalue(500)
  integer   ibeg(500),iend(500),ityp(500),idec(500)
  character key*4
  character cvalue(500)*4
  !
  !  Symmetry
  integer maxsym,nsym,nsym_l,ispno
  real rot(3,3,192)
  real tr(3,192)
  real rsym_all(4,4,192)
  character pgnam*10,sgnm*10
  real cell(6)

  !
  !
  real res_max,res_min,free_frac
  integer i,j,k,is,ibl,ir,n_twins
  integer i1,j1,is1
  logical lattice_twin
  integer list_size
  integer nasym,ncomp,nobs,num_blocks,nel
  integer, allocatable :: hkl_asym(:,:)
  integer, allocatable :: nref_comp(:)
  integer, allocatable :: hkl_comp(:,:)
  integer, allocatable :: hkl_comp_l(:,:)
  integer, allocatable :: comp_number(:)
  integer, allocatable :: refer_2_asym(:)
  integer, allocatable :: refer_2_asym_save(:)
  integer, allocatable :: refer_2_symm(:)
  real, allocatable :: iobs(:,:)
  integer, allocatable :: freeR(:)
  integer, allocatable :: obs_block_num(:)

  real, allocatable :: randoms(:)

  integer, allocatable :: list1(:)
  integer, allocatable :: list2(:)
  integer, allocatable :: llist(:,:)
  integer, allocatable :: nf(:)
  integer, allocatable :: index_obs(:)
  integer, allocatable :: contr_refer_2_asym(:)
  integer, allocatable :: nref_block(:)
  integer, allocatable :: obs_in_this_block(:)

  integer jbegin,jend,jo_beg,jo_end,jsym,jo
  integer jobs,jnum_o,jnum
  integer max_in_block

  integer ifile_out
  character file_hklf5*512,file_mmcif*512
  character symm_op*80
  real radtodeg,degtor,cell_l(6),ast,bst,cst,cosast,cosbst,coscst
  real rsq1,rsq2,rs1,rs2,rsmin,freesum,eps_l
  integer ierr
  logical eof
  integer nabs,nmax,nmax_in_block,nexcess,ntrial

  !
  !  Body

  !
  !  ccp4 environment variables
  call ccpfyp
  maxsym = 192
  cell(1:6) = 0.0
  free_frac = 0.05
  lattice_twin = .FALSE.
  nsym = 0
  radtodeg = 180.0/(4*atan(1.0))
  degtor = 4.0*atan(1.0)/180.0

  line = ' '
  key = ' '
  ntok = npars
  pgnam = ' '
  sgnm = ' '
  ispno = 0
  call parser(key,line,ibeg,iend,ityp,fvalue,cvalue, idec,ntok,lend,lprint)
  call ccpupc(key)
  i = 0
  do while(.not.lend.and.key(1:3).ne.'END')
     do itk=1,ntok
        call ccpupc(cvalue)
     enddo
     if(key.eq.'SYMM'.or.key.eq.'SPGR') then
        CALL RDSYMM(2,LINE,IBEG,IEND,ITYP,FVALUE,NTOK,SGNM,ISPNO,PGNAM,nsym,nsym_l,rsym_all)
        rot(1:3,1:3,1:nsym) = rsym_all(1:3,1:3,1:nsym)
        tr(1:3,1:nsym) = rsym_all(1:3,4,1:nsym)
     else if(key.eq.'CELL') then
        cell(1:6) = fvalue(2:7)
!        call gtnrea(2,6,ntok,cell,ntok,ityp,fvalue)
        if(maxval(cell(4:6)).le.10.0) cell(4:6) = radtodeg*cell(4:6)
     else if(key.eq.'FREE') then
        itk = itk + 1
        if(cvalue(2).eq.'FRAC') then
           itk = itk + 1
           free_frac = fvalue(3)
           if(free_frac.gt.1.0)free_frac = free_frac/100.0
           itk = itk + 1
        else if(cvalue(2).eq.'SYMM') then
           if(cvalue(3).eq.'LATT') then
              lattice_twin = .TRUE.
           else
              lattice_twin = .FALSE.
           endif
        endif
     endif
     line = ' '
     key = ' '
     ntok = npars
     call parser(key,line,ibeg,iend,ityp,fvalue,cvalue, idec,ntok,lend,lprint)
     call ccpupc(key)
  enddo
  cell_l = cell
  if(maxval(cell(4:6)).gt.4.0) then 
     cell_l(4:6) = cell(4:6)*degtor
  endif
  call define_res_pars(cell_l,ast,bst,cst,cosast,cosbst,coscst)

  write(*,*)
  write(*,*)'The number of symmetry elements',nsym
  do i=1,nsym
     call put_symm_to_text_xyz(rot(1:3,1:3,i),tr(1:3,i),symm_op)
     write(*,'(i4,2x,a)')i,trim(symm_op)
  enddo
  write(*,*)
  !
  !  Make sure cell parameters obey symmetry of the crystal

  call ugtenv('HKLIN',file_hklf5)
  call ugtenv('HKLOUT',file_mmcif)
  call read_hklf5_size(nobs,ncomp,n_twins,ierr,file_hklf5)
  if(ierr.gt.0) then
     write(*,*)'Error==> Problem in reading hklf5 file'
     stop 1
  endif
  allocate(iobs(2,nobs))
  allocate(nref_comp(nobs+1))
  allocate(hkl_comp(3,ncomp))
  allocate(comp_number(ncomp))
  call read_hklf5(nobs,ncomp,iobs,nref_comp,hkl_comp,comp_number,ierr,file_hklf5)  
  !
  ! find maximum resolution
  call find_max_reso(ncomp,hkl_comp,cell,res_min,res_max)
  !
  !  Now generate asym list. Symmetry of asymmetric unit is either 
  !  symmetry of the crystal or lattice (it should not be done here)

  call asym_list_size(maxsym,nsym,rot,tr,cell,nasym,res_max)
  allocate(hkl_asym(3,nasym))
  call asym_list(maxsym,nsym,rot,tr,cell,nasym,res_max,hkl_asym)
  !
  !  Now generate references to the asymmetric unit
  allocate(refer_2_asym(ncomp))
  allocate(refer_2_symm(ncomp))
  allocate(hkl_comp_l(3,ncomp))
  hkl_comp_l(1:3,1:ncomp) = hkl_comp(1:3,1:ncomp)
  call find_refer2asym(maxsym,nsym,rot,tr,ncomp,hkl_comp_l,refer_2_asym,refer_2_symm,nasym,hkl_asym,ierr)      
  deallocate(hkl_comp_l)
  !
  !   Organise block of reflections related with twin and/or symmetry
  eps_l = 0.01
  nmax_in_block = 400
  ntrial = 0
  nexcess = 1
  max_in_block = 100
  do while(nexcess.gt.0)
     ntrial = ntrial + 1
     write(*,*)'ntrial =',ntrial
     eps_l = eps_l*0.8
     list_size = 0
     allocate(index_obs(nasym))
     allocate(list1(ncomp))
     allocate(list2(ncomp))
     index_obs(1:nasym) = 0
     !
     !   Consider reflections with single contributors first
     nabs = 0
     do i=1,nobs
        if(nref_comp(i+1)-nref_comp(i).eq.1) then
           nabs = nabs + 1
           !            write(*,*)refer_2_asym(j)
           j = nref_comp(i)+1
           is = refer_2_asym(j)
           if(index_obs(is).gt.0) then
              list_size = list_size + 1
              list1(list_size) = i
              list2(list_size) = index_obs(is)
           else
              index_obs(is) = i
           endif
        endif
     enddo
     do i=1,nobs
        if(nref_comp(i+1)-nref_comp(i).gt.1) then
           j1=nref_comp(i)+1
           rsmin = 1.e32
           do j=nref_comp(i)+1,nref_comp(i+1)-1
              is = refer_2_asym(j)
              call define_res(hkl_asym(1,is),hkl_asym(2,is),hkl_asym(3,is),ast,bst,cst, cosast,cosbst,coscst,rsq1)
              rs1 = sqrt(rsq1)
              do k=nref_comp(i)+2,nref_comp(i+1)
                 is1 = refer_2_asym(k)
                 call define_res(hkl_asym(1,is1),hkl_asym(2,is1),hkl_asym(3,is1),ast,bst,cst, cosast,cosbst,coscst,rsq2)
                 rs2 = sqrt(rsq2)
                 if(rsmin.gt.abs(rs2-rs1)) then
                    j1 = j
                    rsmin = abs(rs2-rs1)
                 endif
              enddo
           enddo
           if(rsmin.gt.eps_l) then
              is = refer_2_asym(j1)
              if(index_obs(is).gt.0) then
                 list_size = list_size + 1
                 list1(list_size) = i
                 list2(list_size) = index_obs(is)
              else
                 index_obs(is) = i
              endif
              cycle
           endif
                 
           !
           ! Arbitrary division. If any of the components's resolution is close 
           ! (in a sense that on the same resolution sphere) to the first one then add them as 
           ! related

           do k=nref_comp(i)+1,nref_comp(i+1)
              is = refer_2_asym(k)
              call define_res(hkl_asym(1,is),hkl_asym(2,is),hkl_asym(3,is),ast,bst,cst, cosast,cosbst,coscst,rsq2)
              rs2 = sqrt(rsq2)
              if(abs(rs1-rs2).le.eps_l) then
                 if(index_obs(is).gt.0) then
                    list_size = list_size + 1
                    list1(list_size) = i
                    list2(list_size) = index_obs(is)
                 else
                    index_obs(is) = i
                 endif
              endif
           enddo
        endif
     enddo
     deallocate(index_obs)
     
     allocate(obs_block_num(nobs))
     if(list_size.le.0) then
        num_blocks = nobs
        do i=1,nobs
           obs_block_num(i) = i
        enddo
        deallocate(list1)
        deallocate(list2)
        exit
     else
        allocate(nf(nobs))
        call find_ancestor(list1,list2,list_size,nobs,nf)
        deallocate(list1)
        deallocate(list2)
        allocate(index_obs(nobs))
        do i=1,nobs
           index_obs(i) = i
        enddo
        call iheap_sort_r(nobs,1,nf,index_obs)
        
        obs_block_num(index_obs(1)) = 1
        
        num_blocks = 0
        nel = 1
        nmax = 0
        nexcess = 0
        nmax_in_block = 0
        allocate(nref_block(nobs))
        allocate(obs_in_this_block(nobs))
        obs_in_this_block(1) = index_obs(1)
        obs_block_num(index_obs(1)) = 1
        nref_block(1) = 0
        nel = 1
        do i=1,nobs-1
           if(nf(i).ne.nf(i+1)) then
              num_blocks = num_blocks + 1
              nref_block(num_blocks+1) = i
              nmax = max(nmax,nel)
              nel = 1
           else
              nel = nel + 1
           endif
           obs_in_this_block(i+1) = index_obs(i+1)
           obs_block_num(index_obs(i+1)) = num_blocks+1
        enddo
        deallocate(nf)
        deallocate(index_obs)

        allocate(refer_2_asym_save(ncomp))
        refer_2_asym_save = refer_2_asym
        allocate(contr_refer_2_asym(max_in_block))
        do i=1,num_blocks
           jbegin = nref_block(i) + 1
           jend = nref_block(i+1)
           jnum = jbegin-jend+1
           contr_refer_2_asym(1) = refer_2_asym(nref_comp(obs_in_this_block(jbegin))+1)
           jsym = 1
           do j=jbegin,jend
              jobs = obs_in_this_block(j)
              jo_beg = nref_comp(jobs)+1
              jo_end = nref_comp(jobs+1)
              do jo=jo_beg,jo_end
                 do is=1,jsym
                    if(refer_2_asym(jo).eq.contr_refer_2_asym(is)) then
                       refer_2_asym(jo) = is
                       goto 20
                    endif
                 enddo
                 jsym = jsym + 1
                 if(jsym.gt.max_in_block) then
                    nexcess = nexcess + 1
                    nmax_in_block = jsym
                    goto 30
                 endif
                 contr_refer_2_asym(jsym) = refer_2_asym(jo)
                 refer_2_asym(jo) = jsym
20               continue
              enddo
           enddo
           nmax_in_block = max(nmax_in_block,jsym)
        enddo
30      continue

        deallocate(contr_refer_2_asym)
        deallocate(obs_in_this_block)
        deallocate(nref_block)
        if(nexcess.gt.0) then
           deallocate(obs_block_num)
        endif
     endif
     refer_2_asym = refer_2_asym_save
     deallocate(refer_2_asym_save)
  enddo
  write(*,*)'Maximum number of contributors in one block ',nmax_in_block
  write(*,*)'Maximum number of observations in one block ',nmax
  write(*,*)'Number of blocks ',num_blocks
!  stop
  !
  !
  allocate(randoms(num_blocks))
  call random_number(randoms)

  allocate(freeR(num_blocks))
  freesum = 0.0
  do i=1,num_blocks
     if(randoms(i).le.free_frac) then
        freeR(i) = 0
     else
        freeR(i) = 1
     endif
     freesum = freesum + freeR(i)
  enddo
  deallocate(randoms)

  call open_form_file(ifile_out,file_mmcif,ierr)

  write(ifile_out,'(a)')'data_mydata'
  write(ifile_out,'(a,2x,a,a,a)')'_symmetry.space_group_name_H-M','''',trim(sgnm),''''
  write(ifile_out,'(a)')'#'
  write(ifile_out,'(a,2x,f12.4)')'_cell.length_a',cell(1)
  write(ifile_out,'(a,2x,f12.4)')'_cell.length_b',cell(2)
  write(ifile_out,'(a,2x,f12.4)')'_cell.length_c',cell(3)
  write(ifile_out,'(a,2x,f12.4)')'_cell.angle_alpha',cell(4)
  write(ifile_out,'(a,2x,f12.4)')'_cell.angle_beta',cell(5)
  write(ifile_out,'(a,2x,f12.4)')'_cell.angle_gamma',cell(6)
  write(ifile_out,'(a)')'#'
  write(ifile_out,'(a)')'loop_'
  write(ifile_out,'(4x,a)')'_symmetry_equiv.id'
  write(ifile_out,'(4x,a)')'_symmetry_equiv.pos_as_xyz'
  do i=1,nsym
     call put_symm_to_text_xyz(rot(1:3,1:3,i),tr(1:3,i),symm_op)
     write(ifile_out,'(i4,1x,a,a,a)')i,'''',trim(symm_op),''''
  enddo

  !
  !  Some info about crystal orientations
  !
  !  Write cif items
  write(ifile_out,'(a1)')'#'
  write(ifile_out,'(a1)')'#'
  write(ifile_out,'(a)')'loop_'
  write(ifile_out,'(4x,a)')'_group_refln.id'
  write(ifile_out,'(4x,a)')'_group_refln.index_h'
  write(ifile_out,'(4x,a)')'_group_refln.index_k'
  write(ifile_out,'(4x,a)')'_group_refln.index_l'
  write(ifile_out,'(4x,a)')'_group_refln.comp_id'
  write(ifile_out,'(4x,a)')'_group_refln.group_obs_id'
  do i=1,nobs
     do j=nref_comp(i)+1,nref_comp(i+1)
        write(ifile_out,*)j,hkl_comp(1:3,j),comp_number(j),i
     enddo
  enddo
  !
  !  Observations
  write(ifile_out,'(a1)')'#'
  write(ifile_out,'(a1)')'#'
  write(ifile_out,'(a)')'loop_'
  write(ifile_out,'(4x,a)')'_group_obs.id'
  write(ifile_out,'(4x,a)')'_group_obs.intensity_meas'
  write(ifile_out,'(4x,a)')'_group_obs.intensity_sigma'
  write(ifile_out,'(4x,a)')'_group_obs.refinement_status'
  write(ifile_out,'(4x,a)')'_group_obs.ccp4_block_id'

  do i=1,nobs
     ibl = obs_block_num(i)
     write(ifile_out,*)i,iobs(1:2,i),freeR(ibl),ibl
  enddo

  !
  !  some info about scan, image or something else number.
  deallocate(iobs)
  deallocate(freeR)
  deallocate(hkl_comp)
  deallocate(comp_number)
  deallocate(obs_block_num)

  write(*,'(120a)')('-',i=1,100)
  write(*,'(a,2F10.3)')'Minimum and maximum resolution= ',0.5/res_min,0.5/res_max

  write(*,'(a,i10)')   'Number of observations        = ',nobs
  write(*,'(a,i10)')   'Number of twin domains        = ',n_twins
  write(*,'(a,i10)')   'Number of observation blocks  = ',num_blocks
  write(*,'(a,f10.3)') 'Fraction for free reflections = ',real(freesum)/real(num_blocks)
  write(*,'(a,6F10.4)')'Cell parameters:                ',cell
  write(*,'(a,a)')'Space group name                ',trim(sgnm)
  write(*,'(120a)')('-',i=1,100)


end program hklf52mmcif
