      subroutine wave2fs(atin,wavelength,fprime,f2prime,ierr)
      implicit none
      character atin*4
      real wavelength,fprime,f2prime
      integer ierr
c
c---  Interface for routines from Crossec from ccp4 adapted to be included in refmac
C
C     .. Parameters ..
      INTEGER NWAV
      PARAMETER (NWAV=1000)
C     ..
      DOUBLE PRECISION BB, CX, RX, SEDGE
      INTEGER ICOUNT
      CHARACTER*4 NAT
C     ..
      DOUBLE PRECISION SIGG(5)
C     ..
C     .. Local Scalars ..
      DOUBLE PRECISION AU, BE, C, C1, CORR, EDG, PI, SIGEDG, XKEV, XW,
     +                 ZX
      INTEGER I, IFL,  IS, IZ, J, K, M,
     +        MF, MM, MX, N1, NJ, NO, NORD, NX
C     ..
C     .. Local Arrays ..
      double precision xener
      double precision fprime1,f2prime1,fp1
      double precision fp(24),fpp(24)
      DOUBLE PRECISION  EG(5), EL(14),
     +                 ETERM(98), EW(14),SIG(14), SL(14),
     +                  T(32), WT(98)
      INTEGER MGAUSS(6), NORB(98)
      CHARACTER*2 ATMTAB(98)
      character c4*4,c2*2
C     ..
C     .. External Functions ..
      DOUBLE PRECISION AKNINT, GAUSS, SIGMA0, SIGMA1, SIGMA2, SIGMA3
      EXTERNAL AKNINT, GAUSS, SIGMA0, SIGMA1, SIGMA2, SIGMA3
c
      external lgndr
C     ..
C     .. Common blocks ..
      COMMON /EDGE/SEDGE
      COMMON /GAUS/CX, BB, SIGG, RX, ICOUNT
C     ..
C     .. Data statements ..

      DATA ATMTAB/'  ', '  ', 'LI', 'BE', 'B ', 'C ', 'N ', 'O ', 'F ',
     +     'NE', 'NA', 'MG', 'AL', 'SI', 'P ', 'S ', 'CL', 'AR', 'K ',
     +     'CA', 'SC', 'TI', 'V ', 'CR', 'MN', 'FE', 'CO', 'NI', 'CU',
     +     'ZN', 'GA', 'GE', 'AS', 'SE', 'BR', 'KR', 'RB', 'SR', 'Y ',
     +     'ZR', 'NB', 'MO', 'TC', 'RU', 'RH', 'PD', 'AG', 'CD', 'IN',
     +     'SN', 'SB', 'TE', 'I ', 'XE', 'CS', 'BA', 'LA', 'CE', 'PR',
     +     'ND', 'PM', 'SM', 'EU', 'GD', 'TB', 'DY', 'HO', 'ER', 'TM',
     +     'YB', 'LU', 'HF', 'TA', 'W ', 'RE', 'OS', 'IR', 'PT', 'AU',
     +     'HG', 'TL', 'PB', 'BI', 'PO', 'AT', 'RN', 'FR', 'RA', 'AC',
     +     'TH', 'PA', 'U ', 'NP', 'PU', 'AM', 'CM', 'BK', 'CF'/
      DATA (ETERM(I), I=1, 66)/.0, .0, .001, .001, .002, .003, .005,
     +     .007, .009, .011, .014, .018, .021, .026, .030, .035, .041,
     +     .047, .053, .060, .068, .075, .084, .093, .102, .113, .123,
     +     .135, .146, .159, .172, .186, .200, .215, .231, .247, .264,
     +     .282, .300, .319, .338, .359, .380, .401, .424, .447, .471,
     +     .496, .521, .547, .575, .602, .631, .660, .690, .721, .753,
     +     .786, .819, .854, .889, .925, .962, 1.0, 1.039, 1.079/
      DATA (ETERM(I), I=67, 98)/1.119, 1.161, 1.204, 1.248, 1.293,
     +     1.338, 1.385, 1.433, 1.482, 1.532, 1.583, 1.636, 1.689,
     +     1.743, 1.799, 1.856, 1.914, 1.973, 2.033, 2.095, 2.157,
     +     2.221, 2.287, 2.353, 2.421, 2.490, 2.561, 2.633, 2.707,
     +     2.782, 2.858, 2.936/
      DATA (WT(I), I=1, 54)/1.0079, 4.00260, 6.941, 9.01218, 10.81,
     +     12.011, 14.0067, 15.9994, 18.9984, 20.179, 22.98977, 24.305,
     +     26.98154, 28.0855, 30.97376, 32.06, 35.453, 39.948, 39.0983,
     +     40.08, 44.9559, 47.88, 50.9415, 51.996, 54.9380, 55.847,
     +     58.9332, 58.69, 63.546, 65.38, 69.72, 72.59, 74.9216, 78.96,
     +     79.904, 83.80, 85.4678, 87.62, 88.9059, 91.22, 92.9064,
     +     95.94, 98., 101.07, 102.9055, 106.42, 107.868, 112.41,
     +     114.82, 118.69, 121.75, 127.60, 126.9045, 131.29/
      DATA (WT(I), I=55, 98)/132.9054, 137.33, 138.9055, 140.12,
     +     140.9077, 144.24, 145., 150.36, 151.96, 157.25, 158.9254,
     +     162.50, 164.9304, 167.26, 168.9342, 173.04, 174.67, 178.49,
     +     180.9479, 183.85, 186.207, 190.2, 192.22, 195.08, 196.9655,
     +     200.59, 204.383, 207.2, 208.9804, 209., 210., 222., 223.,
     +     226.0254, 227.0278, 232.0381, 231.0359, 238.0482, 237.0482,
     +     239., 243., 247., 247., 251./
      DATA (NORB(I), I=1, 80)/0, 0, 2, 2, 3, 3, 4, 4, 4, 4, 4, 4, 5, 6,
     +     7, 7, 7, 7, 7, 7, 7, 7, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
     +     9, 9, 9, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14,
     +     14, 14, 14, 14, 17, 17, 17, 18, 18, 18, 18, 18, 18, 19, 19,
     +     19, 19, 19, 19, 19, 19, 20, 20, 20, 21, 21, 21, 21, 21, 22/
      DATA (NORB(I), I=81, 98)/22, 23, 23, 24, 24, 24, 24, 24, 24, 24,
     +     24, 24, 24, 24, 24, 24, 24, 24/
      DATA C/137.0367/
      DATA PI/3.14159265/
      DATA AU/2.80022E+7/
      DATA C1/.02721/
      DATA XKEV/12.397639/
      DATA MGAUSS/5, 0, 0, 0, 0, 0/
C
c---  body
      ierr = 0
      MX = 5
      nord = 2
      fprime1 = 0.0
      f2prime1 = 0.0
C**********  SET INPUT, OUTPUT AND X SECTION FILES*****
      call open_form_file(is,'CROSSECDATA',ierr)
      if(ierr.gt.0) return
c
C*****READ ATOMIC SYMBOL AND ATOMIC NUMBER
      do iz=1,98
         if(atin(1:2).eq.atmtab(iz)) then
            no = norb(iz)
            goto 20
         endif
      enddo
      ierr = 1
      write(*,*)'Unknown atom for fprime and f2prime calculation'
      goto 320
 20   continue
C*****READ NW VALUES OF XRAY(ANGSTROMS) AT WHICH INTERPOLATION
C*****   TO BE DONE
C
C*****CHANGE ANGSTROMS TO KEV
      xener = xkev/wavelength
      rewind is

      do j=1,no
         do k=1,mx
 70         continue
            read(is,'(a4,i4,a4,a2,1p,3e15.8)') 
     &           nat,nj,c4,c2 ,xw,ew(k),sig(k)
            if(nat(1:2).ne.atin(1:2)) goto 70
            if(nj.ne.j) then
               ierr = 1
               write(*,*)'Problem with input file'
               goto 320
            endif
         enddo
         DO  K = 1, 5
            READ (IS, '(a4,i4,a4,a2,1p,3e15.8,e15.8,i2)') 
     &           NAT, NJ, c4,c2, XW,EG(K), SIGG(K), BE, ifl
C*****READ 5 ENERGIES AND X SECTIONS FOR ORBITAL J
C*****FOR THE GAUSS INTEGRATION POINTS. BINDING ENERGY
C     AND FUNCTION TYPE ALSO
            if(nat(1:2).ne.atin(1:2).or.nj.ne.j.or.be.le.0.0) then
               ierr = 1
               write(*,*)'Problem with input file'
               goto 320
            endif
            EW(K+MX) = EG(K)
            SIG(K+MX) = SIGG(K)
         enddo
         NX = MX + 5
         sigedg = 0.0
         IF (ifl.eq.0) then
            NX = NX + 1
C*****IF=0 SO READ X SEXTION AT ENERGY=1.001*BINDING ENERGY
            READ (IS, '(a4,i4,a4,a2,1p,3e15.8)') 
     &           NAT,NJ,c4,c2, XW,EW(NX), SIG(NX)
            if(nat(1:2).ne.atin(1:2)) then
               ierr = 1
               write(*,*)'Problem with input file'
               goto 320
            endif
            EDG = EW(NX)
            SIGEDG = SIG(NX)
         endif
         BB = BE/C1
         DO  I = 1, 5
            SIGG(I) = SIGG(I)/AU
         enddo
C*****SORT ALL X SECTIONS
         CALL SORT(NX, EW, SIG)
C*****SORT THE FIVE CROSS SECTIONS AT INTEGRATION POINTS
         CALL SORT(5, EG, SIGG)
C*****CHANGE TO LOGS FOR INTERPOLATION
         DO  K = 1, NX
            SL(K) = 0.
            EL(K) = LOG(EW(K))
            IF (SIG(K).ne.0.0) then
               SL(K) = LOG(SIG(K))
            endif
         enddo
C     
         MF = 0
         ZX = LOG(xener)
C
C*****ZX=LOG OF XRAY(KEV) ENERGY
         CX = 0.
         n1 = 0
         IF (BE.le.xener) then
            IF (NORD.eq.0) then
               CALL XSECT(ZX, EL, SL, CX, NX)
               GO TO 160
            endif
            DO  M = 1, NX
               N1 = M
               IF (SL(M).NE.0.0) GO TO 150
            enddo
 150        CONTINUE
            MM = NX - N1 + 1
            CX = AKNINT(ZX, MM, NORD, EL(N1), SL(N1), T)
            CX = EXP(CX)
C
C*****CX IS THE INTERPOLATED X SECTION IN BARNS
 160        CONTINUE
            CX = CX/AU
         endif
         ICOUNT = 6
C*****RX=XRAY ENERGY IN ATOMIC UNITS
         RX = xener/C1
         IF (ifl.eq.0.and.BE.ge.xener) then
C*****SEDGE IS XSECTION IN ATOMIC UNITS AT ENERGY=1.001*BE
            SEDGE = SIGEDG/AU
            CX = 0.0
            fp(j) = GAUSS(1, SIGMA3, MGAUSS, LGNDR)*C/ (2.0*PI**2)
c            write(*,*)fp(j)
            MF = 3  
         else
            IF (ifl.EQ.0) then
               fp(j) =   GAUSS(1, SIGMA0, MGAUSS, LGNDR)*C/
     +              (2.0*PI**2)
            else if(ifl.eq.1) then
               fp(j) =   GAUSS(1, SIGMA1, MGAUSS, LGNDR)*C/
     +              (2.0*PI**2)
            else if(ifl.eq.2) then
               fp(j) =  GAUSS(1, SIGMA2, MGAUSS, LGNDR)*C/
     +              (2.0*PI**2)
            endif
         endif
         corr = 0.0
         IF (CX.NE.0.0) then
            f2prime1 = f2prime1 + C*CX*RX/ (4.0*PI) 
            corr = - CX*RX*0.5*LOG((RX+BB)/ (RX-BB))*C/
     +           (2.0*PI**2)
         endif
         IF (MF.EQ.3) then 
            corr = 
     &           0.5*SEDGE*BB**2*LOG((-BB+RX)/ (-BB-RX))/
     +           RX*C/ (2.*PI**2)
         endif
         fp(j) = fp(j) + corr
      enddo
      fprime = 0.0
      do j=1,no
         fprime = fprime + fp(j)
      enddo
      f2prime = f2prime1
      fprime = fprime - eterm(iz) 
     &     - 0.5*float(iz)*(xener/c1/137.0367**2)**2 
  320 CONTINUE
      CLOSE(UNIT=IS)
      return
      END
C
      SUBROUTINE XSECT(ZX, EL, SL, CX, NX)
C
C*****FIND EL(K) CLOSEST TO ZX
C     .. Scalar Arguments ..
      DOUBLE PRECISION CX, ZX
      INTEGER NX
C     ..
C     .. Array Arguments ..
      DOUBLE PRECISION EL(14), SL(14)
C     ..
C     .. Local Scalars ..
      DOUBLE PRECISION A0, A1, A2, DET, ER, P
      INTEGER L, LL
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC DABS, DEXP
C     ..
      ER = 1000000.
      ll = 1
      DO 10 L = 1, NX
C
        P = DABS(ZX-EL(L))
C
        IF (P.GT.ER) GO TO 10
        ER = P
        LL = L
   10 CONTINUE
      LL = LL - 1
      IF (LL.EQ.0) LL = 1
      IF (LL.EQ.12) LL = 11
      IF (SL(LL).EQ.0.) LL = LL + 1
      DET = EL(LL+2)**2* (EL(LL+1)-EL(LL)) +
     +      EL(LL+1)**2* (EL(LL)-EL(LL+2)) +
     +      EL(LL)**2* (EL(LL+2)-EL(LL+1))
      A0 = (EL(LL)**2* (SL(LL+1)*EL(LL+2)-SL(LL+2)*EL(LL+1))+
     +     EL(LL+1)**2* (SL(LL+2)*EL(LL)-SL(LL)*EL(LL+2))+
     +     EL(LL+2)**2* (SL(LL)*EL(LL+1)-SL(LL+1)*EL(LL)))/DET
      A1 = (EL(LL)**2* (SL(LL+2)-SL(LL+1))+
     +     EL(LL+1)**2* (SL(LL)-SL(LL+2))+
     +     EL(LL+2)**2* (SL(LL+1)-SL(LL)))/DET
      A2 = (SL(LL)* (EL(LL+2)-EL(LL+1))+SL(LL+1)* (EL(LL)-EL(LL+2))+
     +     SL(LL+2)* (EL(LL+1)-EL(LL)))/DET
C
      CX = EXP(A0+A1*ZX+A2*ZX**2)
C
      END
C***********************************************************************
C
      DOUBLE PRECISION FUNCTION SIGMA0(K, X)
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION X
      INTEGER K
C     ..
C     .. Scalars in Common ..
      DOUBLE PRECISION BB, CX, RX
      INTEGER ICOUNT
C     ..
C     .. Arrays in Common ..
      DOUBLE PRECISION SG(5)
C     ..
C     .. Common blocks ..
      COMMON /GAUS/CX, BB, SG, RX, ICOUNT
C     ..
      ICOUNT = ICOUNT - 1
      SIGMA0 = SG(ICOUNT)*BB**3/X**2/ (RX**2*X**2-BB**2) -
     +         BB*CX*RX**2/ (RX**2*X**2-BB**2)
      END
C***********************************************************************
C
      DOUBLE PRECISION FUNCTION SIGMA1(K, X)
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION X
      INTEGER K
C     ..
C     .. Scalars in Common ..
      DOUBLE PRECISION BB, CX, RX
      INTEGER ICOUNT
C     ..
C     .. Arrays in Common ..
      DOUBLE PRECISION SG(5)
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC DSQRT
C     ..
C     .. Common blocks ..
      COMMON /GAUS/CX, BB, SG, RX, ICOUNT
C     ..
      ICOUNT = ICOUNT - 1
C
      SIGMA1 = 0.5*BB**3*SG(ICOUNT)/ (DSQRT(X)* (RX**2*X**2-BB**2*X))
C
      END
C***********************************************************************
C
      DOUBLE PRECISION FUNCTION SIGMA2(K, X)
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION X
      INTEGER K
C     ..
C     .. Scalars in Common ..
      DOUBLE PRECISION BB, CX, RX
      INTEGER ICOUNT
C     ..
C     .. Arrays in Common ..
      DOUBLE PRECISION SG(5)
C     ..
C     .. Local Scalars ..
      DOUBLE PRECISION DENOM
C     ..
C     .. Common blocks ..
      COMMON /GAUS/CX, BB, SG, RX, ICOUNT
C     ..
      ICOUNT = ICOUNT - 1
      DENOM = X**3*RX**2 - BB**2/X
      SIGMA2 = 2.0*BB*SG(ICOUNT)*BB**2/X**4/DENOM -
     +         2.0*BB*CX*RX**2/DENOM
      END
C*****************************************************************
C
      DOUBLE PRECISION FUNCTION SIGMA3(K, X)
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION X
      INTEGER K
C     ..
C     .. Scalars in Common ..
      DOUBLE PRECISION BB, CX, RX, SEDGE
      INTEGER ICOUNT
C     ..
C     .. Arrays in Common ..
      DOUBLE PRECISION SG(5)
C     ..
C     .. Common blocks ..
      COMMON /EDGE/SEDGE
      COMMON /GAUS/CX, BB, SG, RX, ICOUNT
C     ..
      ICOUNT = ICOUNT - 1
      SIGMA3 = BB**3* (SG(ICOUNT)-SEDGE*X**2)/
     +         (X**2* (X**2*RX**2-BB**2))
      END
C***********************************************************************
      SUBROUTINE LGNDR(M, K, AA, Z)
C
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION AA, Z
      INTEGER K, M
C     ..
C     .. Local Scalars ..
      DOUBLE PRECISION T
      INTEGER I4, IA, IH, IP, IS, KK
C     ..
C     .. Local Arrays ..
      DOUBLE PRECISION A(68), X(62)
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC DSIGN, MOD
C     ..
C     .. Data statements ..
      DATA X(1)/.06943184420297/
      DATA X(2)/.33000947820757/
      DATA X(3)/.04691007703067/
      DATA X(4)/.23076534494716/
      DATA X(5)/.03376524289992/
      DATA X(6)/.16939530676687/
      DATA X(7)/.38069040695840/
      DATA X(8)/.02544604382862/
      DATA X(9)/.12923440720030/
      DATA X(10)/.29707742431130/
      DATA X(11)/.01985507175123/
      DATA X(12)/.10166676129319/
      DATA X(13)/.23723379504184/
      DATA X(14)/.40828267875217/
      DATA X(15)/.01591988024619/
      DATA X(16)/.08198444633668/
      DATA X(17)/.19331428364971/
      DATA X(18)/.33787328829809/
      DATA X(19)/.01304673574141/
      DATA X(20)/.06746831665551/
      DATA X(21)/.16029521585049/
      DATA X(22)/.28330230293537/
      DATA X(23)/.42556283050918/
      DATA X(24)/.01088567092697/
      DATA X(25)/.05646870011595/
      DATA X(26)/.13492399721298/
      DATA X(27)/.24045193539659/
      DATA X(28)/.36522842202382/
      DATA X(29)/.00921968287664/
      DATA X(30)/.04794137181476/
      DATA X(31)/.11504866290285/
      DATA X(32)/.20634102285669/
      DATA X(33)/.31608425050091/
      DATA X(34)/.43738329574426/
      DATA X(35)/.00790847264071/
      DATA X(36)/.04120080038851/
      DATA X(37)/.09921095463335/
      DATA X(38)/.17882533027983/
      DATA X(39)/.27575362448178/
      DATA X(40)/.38477084202243/
      DATA X(41)/.00685809565159/
      DATA X(42)/.03578255816821/
      DATA X(43)/.08639934246512/
      DATA X(44)/.15635354759416/
      DATA X(45)/.24237568182092/
      DATA X(46)/.34044381553605/
      DATA X(47)/.44597252564632/
      DATA X(48)/.600374098758E-2/
      DATA X(49)/.31363303799647E-1/
      DATA X(50)/.75896708294787E-1/
      DATA X(51)/.13779113431991/
      DATA X(52)/.21451391369574/
      DATA X(53)/.30292432646121/
      DATA X(54)/.39940295300128/
      DATA X(55)/.00529953250417/
      DATA X(56)/.02771248846338/
      DATA X(57)/.06718439880608/
      DATA X(58)/.12229779582250/
      DATA X(59)/.19106187779868/
      DATA X(60)/.27099161117138/
      DATA X(61)/.35919822461038/
      DATA X(62)/.45249374508118/
      DATA A(1)/.17392742256873/
      DATA A(2)/.32607257743127/
      DATA A(3)/.11846344252810/
      DATA A(4)/.23931433524968/
      DATA A(5)/.28444444444444/
      DATA A(6)/.85662246189585E-1/
      DATA A(7)/.18038078652407/
      DATA A(8)/.23395696728635/
      DATA A(9)/.06474248308443/
      DATA A(10)/.13985269574464/
      DATA A(11)/.19091502525256/
      DATA A(12)/.20897959183674/
      DATA A(13)/.05061426814519/
      DATA A(14)/.11119051722669/
      DATA A(15)/.15685332293894/
      DATA A(16)/.18134189168918/
      DATA A(17)/.04063719418079/
      DATA A(18)/.09032408034743/
      DATA A(19)/.13030534820147/
      DATA A(20)/.15617353852000/
      DATA A(21)/.16511967750063/
      DATA A(23)/.07472567457529/
      DATA A(24)/.10954318125799/
      DATA A(25)/.13463335965500/
      DATA A(26)/.14776211235738/
      DATA A(27)/.02783428355809/
      DATA A(28)/.06279018473245/
      DATA A(29)/.09314510546387/
      DATA A(30)/.11659688229599/
      DATA A(31)/.13140227225512/
      DATA A(32)/.13646254338895/
      DATA A(33)/.02358766819326/
      DATA A(34)/.05346966299766/
      DATA A(35)/.08003916427167/
      DATA A(36)/.10158371336153/
      DATA A(37)/.11674626826918/
      DATA A(38)/.12457352290670/
      DATA A(39)/.02024200238266/
      DATA A(40)/.04606074991886/
      DATA A(41)/.06943675510989/
      DATA A(42)/.08907299038097/
      DATA A(43)/.10390802376845/
      DATA A(44)/.11314159013145/
      DATA A(45)/.11627577661544/
      DATA A(46)/.01755973016588/
      DATA A(47)/.04007904357988/
      DATA A(48)/.06075928534395/
      DATA A(49)/.07860158357910/
      DATA A(50)/.09276919873897/
      DATA A(51)/.10259923186065/
      DATA A(52)/.10763192673158/
      DATA A(53)/.01537662099806/
      DATA A(54)/.03518302374405/
      DATA A(55)/.05357961023359/
      DATA A(56)/.06978533896308/
      DATA A(57)/.08313460290850/
      DATA A(58)/.09308050000778/
      DATA A(59)/.09921574266356/
      DATA A(60)/.10128912096278/
      DATA A(61)/.01357622970588/
      DATA A(62)/.03112676196932/
      DATA A(63)/.04757925584125/
      DATA A(64)/.06231448562777/
      DATA A(65)/.07479799440829/
      DATA A(66)/.08457825969750/
      DATA A(67)/.09130170752246/
      DATA A(68)/.09472530522754/
C     ..
      KK = K
      IF ((M.GT.16) .OR. (M.LT.4)) KK = 4
      IS = 0
      IH = (M+1)/2
      Z = .5
      IF (MOD(M, 2).EQ.1) IS = -1
      IP = KK
      T = 0.
      IF (IP.LE.IH) GO TO 10
      IP = M + 1 - IP
      T = -1
   10 CONTINUE
      I4 = M - 4
      IA = (I4* (M+4)+IS)/4 + IP
      AA = A(IA)
      IF ((IP.EQ.IH) .AND. (IS.LT.0)) RETURN
      IA = IA - (I4+IS)/2
C
      Z = -T + DSIGN(X(IA), T)
C
      END
C***********************************************************************
C
      DOUBLE PRECISION FUNCTION GAUSS(N, Y, M, LTBL)
      implicit none
C     .. Scalar Arguments ..
      INTEGER N
C     ..
C     .. Array Arguments ..
      INTEGER M(6)
C     ..
C     .. Function Arguments ..
      DOUBLE PRECISION Y
      EXTERNAL Y
C     ..
C     .. Subroutine Arguments ..
      EXTERNAL LTBL
C     ..
C     .. Local Scalars ..
      INTEGER J, JJ, K, KK, L, LL, NN
      CHARACTER*50 CMT
C     ..
C     .. Local Arrays ..
      DOUBLE PRECISION A(6), G(6), Z(6)
C     ..
C     .. External Subroutines ..
      EXTERNAL LABRT
C     ..
C     .. Data statements ..
      DATA CMT/'GAUSS   N NOT IN (1,6).  RESULTS   SET TO ZERO.'/
C     ..
C
      IF ((N.GT.6) .OR. (N.LT.1)) GO TO 140
      NN = N
      GO TO (110, 90, 70, 50, 30, 10) NN
   10 CONTINUE
      J = 1
      G(6) = 0.
   20 CONTINUE
      CALL LTBL(M(6), J, A(6), Z(6))
   30 CONTINUE
      K = 1
      G(5) = 0.
   40 CONTINUE
      CALL LTBL(M(5), K, A(5), Z(5))
   50 CONTINUE
      L = 1
      G(4) = 0.
   60 CONTINUE
      CALL LTBL(M(4), L, A(4), Z(4))
   70 CONTINUE
      JJ = 1
      G(3) = 0.
   80 CONTINUE
      CALL LTBL(M(3), JJ, A(3), Z(3))
   90 CONTINUE
      KK = 1
      G(2) = 0.
  100 CONTINUE
      CALL LTBL(M(2), KK, A(2), Z(2))
  110 CONTINUE
      LL = 1
      G(1) = 0.
  120 CONTINUE
      CALL LTBL(M(1), LL, A(1), Z(1))
      G(1) = G(1) + A(1)*Y(1, Z(1))
      LL = LL + 1
      IF (LL.LE.M(1)) GO TO 120
      IF (NN.EQ.1) GO TO 130
      G(2) = G(2) + A(2)*Y(2, Z(1))*G(1)
      KK = KK + 1
      IF (KK.LE.M(2)) GO TO 100
      IF (NN.EQ.2) GO TO 130
      G(3) = G(3) + A(3)*Y(3, Z(1))*G(2)
      JJ = JJ + 1
      IF (JJ.LE.M(3)) GO TO 80
      IF (NN.EQ.3) GO TO 130
      G(4) = G(4) + A(4)*Y(4, Z(1))*G(3)
      L = L + 1
      IF (L.LE.M(4)) GO TO 60
      IF (NN.EQ.4) GO TO 130
      G(5) = G(5) + A(5)*Y(5, Z(1))*G(4)
      K = K + 1
      IF (K.LE.M(5)) GO TO 40
      IF (NN.EQ.5) GO TO 130
      G(6) = G(6) + A(6)*Y(6, Z(1))*G(5)
      J = J + 1
      IF (J.LE.M(6)) GO TO 20
  130 CONTINUE
      GAUSS = G(NN)
      RETURN
  140 CONTINUE
      CALL LABRT(1, CMT, 1)
      GAUSS = 0.
      END
C**********************************************************************
      SUBROUTINE LABRT(ISW, LHOL, INX)
C
C
C     .. Scalar Arguments ..
      INTEGER INX, ISW
      CHARACTER*50 LHOL
C     ..
C     .. Local Scalars ..
      INTEGER NP
      LOGICAL PS, TS
C     ..
C     .. Data statements ..
      DATA NP/10/, PS/.TRUE./, TS/.FALSE./
C     ..
      IF ((ISW.EQ.0) .OR. (ISW.GT.5)) RETURN
      GO TO (10, 20, 30, 40, 50) ISW
   10 CONTINUE
      IF (PS .AND. (NP.GT.0)) PRINT 9000, LHOL, INX
      NP = NP - 1
CCC      IF (TS) CALL EXIT
      RETURN
   20 CONTINUE
      PS = .FALSE.
      RETURN
   30 CONTINUE
      PS = .TRUE.
      NP = INX
      RETURN
   40 CONTINUE
      TS = .TRUE.
      RETURN
   50 CONTINUE
      TS = .FALSE.
      RETURN
C
 9000 FORMAT ('0', 9X, A50, 3X, I6)
      END
C
      DOUBLE PRECISION FUNCTION AKNINT(XBAR, IN, IM, X, Y, T)
C
C AITKEN REPEATED INTERPOLATION
C
C   XBAR = ABSCISSA AT WHICH INTERPOLATION IS DESIRED
C   IABS(IN) = NO. OF VALUES IN TABLE
C              IF IN.GT.0, CHK ORDERING OF X(I).
C              IF IN.LT.0, SKIP PRECEEDING TEST.
C   IM   = DEGREE OF APPROXIMATING POLYNOMIAL
C   X    = VECTOR OF IABS(IN) VALUES OF ABSCISSA
C   Y    = VECTOR OF IABS(IN) VALUES OF ORDINATE
C   T    = TEMPORARY STORAGE VECTOR OF 4*(M+1) LOCATIONS)
C
C
C     ..
C     .. Scalar Arguments ..
      DOUBLE PRECISION XBAR
      INTEGER IM, IN
C     ..
C     .. Array Arguments ..
      DOUBLE PRECISION T(*), X(*), Y(*)
C     ..
C     .. Local Scalars ..
      DOUBLE PRECISION DXBAR, S, Z
      INTEGER I, J, JJ, K, KK, M, MEND, N
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC IABS, MAX0, MIN0
C     ..
      DXBAR = XBAR
      N = IABS(IN)
      M = IM
      IF (M.GE.N) GO TO 130
   10 CONTINUE
      K = N - 1
      IF (N.LT.2) GO TO 120
      S = X(2) - X(1)
      IF (IN.LT.0) GO TO 30
C CHK IF ORDER MONOTONIC
      IF (N.EQ.2) GO TO 30
      DO 20 I = 3, N
        Z = (X(I)-X(I-1))*S
        IF (Z.LE.0.) GO TO 110
   20 CONTINUE
   30 CONTINUE
      IF (S.LT.0.) GO TO 50
C INCREASING ORDER
      DO 40 J = 1, N
        IF (XBAR.LE.X(J)) GO TO 70
   40 CONTINUE
      J = N
      GO TO 70
C DECREASING ORDER
   50 CONTINUE
      DO 60 J = 1, N
        IF (XBAR.GE.X(J)) GO TO 70
   60 CONTINUE
      J = N
   70 CONTINUE
      K = M
      M = M + 1
      J = J - M/2
      J = MAX0(J, 1)
      J = MIN0(J, N-K)
      MEND = J + K
      DO 80 I = J, MEND
        KK = I - J + 1
        T(KK) = Y(I)
        T(KK+M) = X(I) - DXBAR
   80 CONTINUE
      DO 100 I = 1, K
        KK = I + 1
        DO 90 JJ = KK, M
          T(JJ) = (T(I)*T(JJ+M)-T(JJ)*T(I+M))/ (X(JJ+J-1)-X(I+J-1))
   90   CONTINUE
  100 CONTINUE
      AKNINT = T(M)
      RETURN
  110 CONTINUE
      PRINT 9000
 9000 FORMAT (' AKNINT X(I) NOT SEQUENCED PROPERLY')
  120 CONTINUE
      PRINT 9010
 9010 FORMAT (' AKNINT N.LT.2 YBAR RETURNED AS Y(1)')
      AKNINT = Y(1)
      RETURN
  130 CONTINUE
      PRINT 9020
 9020 FORMAT (' AKNINT WARNING ORDER OF INTERPOLATION TOO LARGE')
      M = N - 1
      GO TO 10
      END
C
      SUBROUTINE SORT(N, A, B)
C
C
C     .. Scalar Arguments ..
      INTEGER N
C     ..
C     .. Array Arguments ..
      DOUBLE PRECISION A(*), B(*)
C     ..
C     .. Local Scalars ..
      DOUBLE PRECISION X, Y
      INTEGER I, I1, J, M
C     ..
      M = N - 1
      DO 20 I = 1, M
        I1 = I + 1
        DO 10 J = I1, N
          IF (A(J).GT.A(I)) GO TO 10
          X = A(J)
          Y = A(I)
          A(I) = X
          A(J) = Y
          X = B(J)
          Y = B(I)
          B(I) = X
          B(J) = Y
   10   CONTINUE
   20 CONTINUE
      END

