      subroutine read_psuedorest
      use weights
      use restr_files
c
c---This routine reads external restraints and adds them to 
c---the bond file. 
      implicit none
      include 'atom_com.fh'
c
c---  locals
c
c---  Things for psuedo restraints
      integer ierr
      integer ia1,ia2,i1,i2,i3,i4,ibtype
      character psuedorest_file*512
      character symm_in*1
      integer   maxatom_in_rest
      parameter (maxatom_in_rest = 50)
      integer   iatom_number(maxatom_in_rest)
      integer isym_out(4,maxatom_in_rest)
      logical dist_defined,sigma_defined,type_defined,prob_defined
      integer ires_in(maxatom_in_rest)
      character ins_in(maxatom_in_rest)*1
      character atom_in(maxatom_in_rest)*4
      character alt_in(maxatom_in_rest)*1
      character chain_in(maxatom_in_rest)*4
      character symm_in1(maxatom_in_rest)*1
      integer   iat,nrest_now
      real scale_sigma_loc,sigma_min_loc,sigma_max_loc
      real dist_value,sigma_value,prob_in,dist1
      real weight_b
      integer ia_first_atom,ia_last_atom
c
c---  Things for parser
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f
c
c---  loops and others
      integer   ifile,lps,nfile
      integer   i,j,k,l,ich,ires,ia,ir_first,ir_last,ia_first,ia_last
      integer   jrs
      integer itype_in
      character alt_code*1,ins_code*1,type_in*10
      character asmgrp*4
      integer   ipsuedo,ibond,iscrk,file_in
      integer   nbonds,nbonds1,nb_out
      integer   nplans,nmaxatom_in_plane,npl,np1,ip
      integer   iplan
      integer   nchir,nch1,ic
      integer   ichir
c
      character rest_type*4
      logical   rest_flag
c
c---For atom reader
      integer nkeywords
      character EndKeywords(100)*4
      character symm1*1
      character chain1*4,ins1*1,alt1*1,atom1*4
      integer   ires1
c
c---temporary small arrays to read files
      integer ia1_t(200)
      integer is_t(4,200)
      real    rs_vidl_t(2)
      real tt1,tt2
c
c----allocatables: genera
      integer ii,n1,n2,ires_l,nkeys
      character(len=15) full_atom_in
      character(len=15), allocatable :: full_atom_name(:)
      integer, allocatable :: index_c(:)
c
c---bonds
      integer iend_b
      integer jj,nb1,ib,ib1,ibond_t,ipr,nb_dupl,nb_start,nb_end,nb_now
      integer nbonds_all,nbonds_now,nmax_dupl
      integer, allocatable :: ikeys(:,:)
      integer, allocatable :: is_bond(:,:)
      integer, allocatable :: ibond_type(:)
      real,    allocatable :: rs_vidl_b(:,:)
c
c---  chiral
      integer iangle,nangles,nan1
      integer, allocatable :: ia1_a(:,:)
      integer, allocatable :: is_a(:,:,:)
      integer, allocatable :: iangle_type(:)
      real,    allocatable :: rs_vidl_a(:,:)
c
c---  chiral
      integer ichir_sign1
      integer, allocatable :: ia1_c(:,:)
      integer, allocatable :: ichir_sign(:)
      integer, allocatable :: ichir_type(:)
      integer, allocatable :: is_c(:,:,:)
      real,    allocatable :: rs_vidl_c(:,:)    
c
c---  planes
      integer, allocatable :: ia1_p(:,:)
      integer, allocatable :: nplane(:)
      integer, allocatable :: is_p(:,:,:)
      real,    allocatable :: rs_vidl_p(:,:)
c
c---  torsions
      integer itors,ntors,nt1,itor_fl
      integer it,it_period
      character    tors_l1*8
      character*8, allocatable :: tors_labels(:)
      integer,     allocatable :: ia1_tors(:,:)
      integer,     allocatable :: is_tors(:,:,:)
      integer,     allocatable :: tors_flag(:)
      integer,     allocatable :: tors_period(:)
      integer,     allocatable :: itors_type(:)
      real,        allocatable :: rs_vidl_tors(:,:)
c
c---  interval
      integer iint,ninte
      real dmin,dmax,smin_value,smax_value
      logical dmin_defined,dmax_defined,smin_defined,smax_defined
      integer nint1
      integer, allocatable :: ia1_int(:,:)
      integer, allocatable :: is_int(:,:)
      real,    allocatable :: rs_vidl_int(:,:)
      character at_flag*1
c
c---  General
      real dist_max_external
      character use_atoms*1,side_or_main*1
      logical use_this_rest,ignore_undefined
c
c---- Body
c
c---  Index and sort full atom names for further access using binary search
      dist_max_external = 1.0e32
      allocate(full_atom_name(n_atom))
      allocate(index_c(n_atom))
      do ia=1,n_atom
         ires_l = i_resid(ia)
         ich = i_chain(ires_l)
         call get_asm_group_id(asmgrp,ich)
         write(full_atom_name(ia),'(a4,a5,a4,a1)')
     &        asmgrp,res_num_pdb(ires_l)(3:7),
     &        atm_name(ia),id_alt(ia)
         index_c(ia) = ia
      enddo
      nkeys = 1
      call cheap_sort_r(n_atom,nkeys,full_atom_name,index_c)
c
c---  Instruction may come from two sources. 1) External psuedorestraint file
c---  and 2) usual keyword file. Usual keyword would be sufficient. 
c---  Unfortunately psuedorestraint file has already been declared and out on 
c---  the web
      call getenv('PSRESTIN',psuedorest_file)
      lps = len_trim(psuedorest_file)
      if(lps.gt.0) then
         call open_form_file(ipsuedo,psuedorest_file,ierr)
         if(ierr.ne.0) then
            write(*,*)'Problem with psuedo restraint file'
         endif
      endif

      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
c---bonds
      call open_unform_file(ibond,bond_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening bond file')
      endif
c--read till the end
      nbonds = 0
      read(ibond,iostat=iend_b)nbonds,nb_dupl
      nbonds1 = nbonds
      nbonds_all = 0
      do while(iend_b.eq.0)
         read(ibond,iostat=iend_b)nb_now
         if(iend_b.eq.0) then
            read(ibond,iostat=iend_b) ia1_t(1:2),
     &           (rs_vidl_t(1:2),j=1,nb_now),i1,i2,i3,i4,ibtype,weight_b
            nbonds_all = nbonds_all + nb_now
         endif
      enddo
c
c----angles
      call open_unform_file(iangle,angle_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening bond file')
      endif
c--read till the end
      nangles = 0
      read(iangle,iostat=iend_b)nangles
      do while(iend_b.eq.0)
         read(iangle,iostat=iend_b) ia1_t(1:3),is_t(1:4,1:3),
     &        rs_vidl_t(1:2),ibtype,weight_b
      enddo
c
c---planes
      call open_unform_file(iplan,plane_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening plane file')
      endif
      nplans = 0
      read(iplan,iostat=iend_b)nplans,nmaxatom_in_plane
      do while(iend_b.eq.0)
         read(iplan,iostat=iend_b)npl,rs_vidl_t(1:2),ia1_t(1:npl),
     &        is_t(1:4,1:npl),ibtype,weight_b
      enddo
c
      call open_unform_file(ichir,chir_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening chirality file')
      endif
      nchir = 0
      read(ichir,iostat=iend_b)nchir
      do while(iend_b.eq.0) 
         read(ichir,iostat=iend_b)ia1_t(1:4),is_t(1:4,1:4),
     &        rs_vidl_t(1:2),ichir_sign1,ibtype,weight_b
      enddo
c
c---Torsion angles
      call open_unform_file(itors,tors_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening chirality file')
      endif
      ntors = 0
      read(itors,iostat=iend_b)ntors
      do while(iend_b.eq.0) 
         read(itors,iostat=iend_b)tors_l1,ia1_t(1:4),is_t(1:4,1:4),
     &        it_period,
     &        rs_vidl_t(1:2),itor_fl,ibtype,weight_b
      enddo
c
c---  angles? Why I do not know

c
c---  NMR NOE restraints
      if(interval_file(1:1).eq.' ') then
         call find_unique_file_name(interval_file,'_INT_R')
      endif
      call open_unform_file(iint,interval_file,ierr)
      if(ierr.gt.0) then
         call errwrt(1,'In read_psuedorest. Opening interval file')
      endif
      ninte = 0
      read(iint,iostat=iend_b) ninte
      if(iend_b.eq.0) then
         do  while(iend_b.eq.0)
            read(iint,iostat=iend_b)ia1_t(1:2),is_t(1:4,1),
     &           dmin,dmax,rs_vidl_t(1:1),tt1,tt2,ibtype,weight_b
         enddo
      else
         ninte = 0
         rewind(iint)
         write(iint) ninte
      endif
      nint1 = ninte
c
c--Do we need harmonic restraints?

c
c---Now read to read external restraints and add to files.

C
      lend = .TRUE.
      key  = ' '
      ierr = 0
      lend_f = 0
c
c---  If psuedo restraint file is present then use this file first
c---  Instructions from the keywords file have higher priority
      nfile = 1
      if(lps.le.0) nfile = 2
      scale_sigma_loc = 1.0
      sigma_min_loc = 0.0
      sigma_max_loc = 100.0
      if(w_gm_in.le.0.) w_gm_in = 0.1
      use_atoms = 'A'
      ignore_undefined = .FALSE.

      do ifile=nfile,2
         if(ifile.eq.1) then
            file_in = ipsuedo
         else
            file_in = iscrk
         endif
         lend_f = 0
         key    = ' '
         do while(lend_f.eq.0.and.key(1:3).ne.'END') 
c.and.ierr.eq.0)
            dist_defined = .FALSE.
            sigma_defined = .FALSE.
            type_defined  = .FALSE.
            prob_defined = .FALSE.
            dmin_defined = .FALSE.
            dmax_defined = .FALSE.
            lprint = .FALSE.
            line = ' '
            key = ' '
            symm_in ='N'
            do while(line.eq.' '.and.lend_f.eq.0)
               read(file_in,'(a)',iostat=lend_f)line
            enddo
            if(lend_f.lt.0) goto 888
            
            ntok = maxtok
            call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &           ntok,lend,lprint)
            call ccpupc(key)
            do  itk=2,ntok
               call ccpupc(cvalue(itk))
            enddo
            iat=0
            nkeywords = 15
            EndKeywords(1) = 'FIRS'
            EndKeywords(2) = 'SECO'
            EndKeywords(3) = 'ATRE'
            EndKeywords(4) = 'ATIN'
            EndKeywords(5) = 'VALU'
            EndKeywords(6) = 'SIGM'
            EndKeywords(7) = 'TYPE'
            EndKeywords(8) = 'PROB'
            EndKeywords(9) = 'DMIN'
            EndKeywords(10) = 'DMAX'
            EndKeywords(11) = 'SMIN'
            EndKeywords(12) = 'SMAX'
            EndKeywords(13) = 'NEXT'
            EndKeywords(14) = 'THIR'
            EnDKeywords(15) = 'FOUR'

            if(key.eq.'EXTE') then
               itk = 2
               rest_type = cvalue(itk)
               rest_flag = .FALSE.
               if(cvalue(itk).eq.'DIST'.or.cvalue(itk).eq.'PLAN'.or.
     &            cvalue(itk).eq.'CHIR'.or.
     &            cvalue(itk).eq.'ANGL'.or.cvalue(itk).eq.'INTE'.or.
     &            cvalue(itk).eq.'TORS') then
                  rest_flag = .TRUE.
               endif
               itype_in = 2
               if(cvalue(itk).eq.'WEIG') then
                  itk = itk + 1
                  do while(itk.le.ntok)
                     if(itype(itk).eq.2) then
                        w_gm_in = fvalue(itk)
                        itk = itk + 1
                     elseif(cvalue(itk).eq.'SCAL') then
                        itk = itk + 1
                        if(itype(itk).eq.2) then
                           scale_sigma_loc = fvalue(itk)
                           itk = itk + 1
                        endif
                     elseif(cvalue(itk).eq.'SGMN') then
                        itk = itk + 1
                        if(itype(itk).eq.2) then
                           sigma_min_loc = fvalue(itk)
                           itk = itk + 1
                        endif
                     elseif(cvalue(itk).eq.'SGMX') then
                        itk = itk + 1
                        if(itype(itk).eq.2) then
                           sigma_max_loc = fvalue(itk)
                           itk = itk + 1
                        endif
                     elseif(cvalue(itk).eq.'GMWT') then
                        itk = itk + 1
                        if(itype(itk).eq.2) then
                           w_gm_in = fvalue(itk)
                           itk = itk + 1
                        endif
                     else
                        write(*,*)itk,trim(line),ntok
                        write(*,*)'Error==> EXTE keyword interpretation'
                        call ccperr(1,'Problem with keywords')
                     endif
                  enddo
                  cycle
               elseif(cvalue(itk).eq.'MISS'.or.
     &                 cvalue(itk).eq.'UNDE') then
                  itk = itk + 1
                  if(cvalue(itk).eq.'IGNO'.or.
     &                 cvalue(itk).eq.'REJE') then
                     ignore_undefined = .TRUE.
                  else
                     ignore_undefined = .FALSE.
                  endif
                  itk = itk + 1
                  cycle
               elseif(cvalue(itk)(1:3).eq.'CUT') then
                  itk = itk + 1
                  if(itype(itk).eq.2) then
                     sd_ext_cut = fvalue(itk)
                  else
                     write(*,*)
     &                    'Warning==> The next value should be a number'
                     write(*,*)'Warning==> ',trim(line)
                     write(*,*)'Warning==>'
                  endif
               elseif(cvalue(itk).eq.'DMAX') then
                  itk = itk + 1
                  if(itype(itk).eq.2) then
                     dist_max_external=fvalue(itk)
                  else
                     write(*,*)
     &                    'Warning==> The next value should be a number'
                     write(*,*)'Warning==> ',trim(line)
                     write(*,*)'Warning==>'
                  endif
                  itk = itk + 1
                  cycle
               elseif(cvalue(itk)(1:3).eq.'USE') then
                  itk = itk + 1
                  if(cvalue(itk)(1:1).eq.'A') then
                     use_atoms = 'A'
                  else
                     use_atoms = 'M'
                  endif
                  itk = itk + 1
                  cycle
               elseif(rest_flag) then
                  itk = itk+1
                  itype_in = 1
                  do while(itk.le.ntok)
                     if(cvalue(itk).eq.'FIRS'.or.
     &                    cvalue(itk).eq.'SECO'.or.
     &                    cvalue(itk).eq.'THIR'.or.
     &                    cvalue(itk).eq.'FOUR'.or.
     &                    cvalue(itk).eq.'NEXT'.or.
     &                    cvalue(itk).eq.'ATRE'.or.
     &                    cvalue(itk).eq.'ATIN') then
                        if(cvalue(itk).eq.'FIRS') then
                           iat = 1
                        elseif(cvalue(itk).eq.'SECO') then
                           iat = 2
                        elseif(cvalue(itk).eq.'THIR') then
                           iat = 3
                        elseif(cvalue(itk).eq.'FOUR') then
                           iat = 4
                        else
                           iat = iat + 1
                        endif
                        itk = itk + 1
                        call read_external_atom_info(ntok,nkeywords,
     &                       itk,itk_out,
     &                       ibeg,iend,ires1,ierr,cvalue,line,
     &                       chain1,ins1,atom1,alt1,symm1,
     &                       EndKeywords)
                        if(ierr.gt.0) then
                           ierr = 5
                           write(*,*)
     &                       'Problem while reading external restraints'
                           goto 999
                        endif
                        itk = itk_out
                        if(iat.gt.maxatom_in_rest) then
                           write(*,*) 'Too many atoms in one restraint'
                           write(*,*)'Maximum allowed = ',
     &                          maxatom_in_rest
                           ierr = 6
                           goto 999
                        endif
c     
                        chain_in(iat) = chain1
                        ires_in(iat)  = ires1
                        ins_in(iat)   = ins1
                        atom_in(iat)  = atom1
                        alt_in(iat)   = alt1
                        symm_in1(iat) = symm1
                     else if(cvalue(itk).eq.'VALU') then
                        itk = itk+1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)dist_value
c     dist_value = fvalue(itk)
                        dist_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'DMIN') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)dmin
                        dmin_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'DMAX') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)dmax
                        dmax_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'SMIN') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)smin_value
                        smin_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'SMAX') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)smax_value
                        smax_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'SIGM') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)sigma_value
c     sigma_value = fvalue(itk)
                        sigma_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'TYPE') then
                        itk = itk + 1
                        if(itype(itk).ne.2) then
                           type_in = line(ibeg(itk):iend(itk))
                           if(type_in(1:1).eq.'O') then
                              itype_in = 0
                           elseif(type_in(1:1).eq.'F') then
                              itype_in = 2
                           endif
                        else
                           itype_in = nint(fvalue(itk))
                           if(itype_in.lt.0.or.itype_in.gt.2) then
                              itype_in = 2
                           endif
                        endif
                        type_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'PROB') then
                        itk = itk+1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)prob_in
c     prob_in = fvalue(itk)
                        prob_defined = .TRUE.
                        itk=itk+1
                     else if(cvalue(itk).eq.'SYMM') then
                        itk = itk + 1
                        if(itk.gt.ntok) then
                           ierr = 1
                           goto 999
                        endif
                        if(cvalue(itk)(1:1).eq.'Y') then
                           symm_in = 'Y'
                           itk = itk + 1
                        endif
                     else
                        itk = itk + 1
                     endif
                  enddo
               endif
               if(dmin_defined.and.dmax_defined) then
                  dist_defined = .TRUE.
               else if(dmin_defined.and..not.dmax_defined) then
                  dmax_defined = .TRUE.
                  dist_defined = .TRUE.
                  dmax = dmin
               else if(.not.dmin_defined.and.dmax_defined) then
                  dmin_defined = .TRUE.
                  dist_defined = .TRUE.
                  dmin = dmax
               endif
               if(.not.type_defined) itype_in = 2
c     
c---  Now check if everything is o.k. I.e. we have all necessary information
               if(.not.dist_defined.and.rest_type.ne.'PLAN'.and.
     &              rest_type.eq.'INTE') then
                  call errwrt(-1,'The ideal value for this restraint'//
     &                 ' must be defined')
                  ierr = 1
                  goto 999
               endif
               nrest_now = iat
               if(.not.sigma_defined) sigma_value = 0.02
               if(.not.smin_defined.and..not.smax_defined) then
                  smin_value = sigma_value
                  smax_value = sigma_value
               else if(.not.smin_defined.and.smax_defined) then
                  smin_value = smax_value
               else if(smin_defined.and..not.smax_defined) then
                  smax_value = smin_value
               endif
               if(.not.type_defined) type_in = 'External'
c     
C---  Now find atomic numbers and write to a file
               if(use_atoms.eq.'M') then
                  do i=1,nrest_now
                     call check_side_or_main(atom_in(i),side_or_main)
                     if(side_or_main.eq.'S') goto 777
                  enddo
               endif
c
c---If target distance is larger than predefined distance then do not use them
               if(rest_type.eq.'DIST') then
                  if(dist_value.gt.dist_max_external) goto 777
               endif
               use_this_rest = .TRUE.
               do i=1,nrest_now
c
c---  Apply selection rule here? List of prespecified atoms or something else?
                  if(ins_in(i).eq.'.')ins_in(i)=' '
                  write(full_atom_in,'(a4,i4,a1,a4,a1)')
     &                 chain_in(i),ires_in(i),
     &                 ins_in(i),atom_in(i),alt_in(i)
                  ii = (n_atom+1)/2
                  n1 = 1
                  n2 = n_atom
                  do while(full_atom_name(ii).ne.full_atom_in
     &                 .and.n1.le.n2)
                     if(full_atom_in.lt.full_atom_name(ii)) then
                        n2 = ii-1
                     else
                        n1 = ii+1
                     endif
                     ii = (n2+n1)/2
                  enddo
                  if(n1.le.n2) then
                     iatom_number(i) = index_c(ii)
                  else
                     if(ignore_undefined) then
                        use_this_rest = .FALSE.
                        write(*,*)
     &                   'Warning: At least one of the atoms from '//
     &                  'the restraints could not be found:'
                        write(*,*)'==> ',trim(line)
                        write(*,*)full_atom_in
                        exit
                     else
                        write(*,*)
     &                       'Error: At least one of the atoms from '//
     &                       'the restraints could not be found:'
                        write(*,*)'==> ',trim(line)
                        write(*,*)full_atom_in
                        stop
                        ierr = 3
                     endif
                  endif
               enddo
c
c---  Find out if these atoms are related (if symm defined by symmetry or) 
c---  directly. It works only for bond restraints For others bookkeeping 
c---  for symmetry related atoms is too complicated
               if(ierr.ne.3.and.use_this_rest) then
                  isym_out(1,1:nrest_now)   = 1
                  isym_out(2:4,1:nrest_now) = 0
c               if(symm_in.eq.'Y') then
c     
c--   Are we here?
                  do i=2,nrest_now
                     if(symm_in1(i).eq.'Y') then
                        call find_symm_contact(iatom_number(1),
     &                       iatom_number(i),isym_out(1:4,i))
                     endif
                  enddo
                  if(nrest_now.eq.2.and.symm_in1(2).eq.'N'.and.
     &                 symm_in.eq.'Y') then
                     call find_symm_contact(iatom_number(1),
     &                    iatom_number(2),isym_out(1:4,2))
                  endif
c
c---  Add this info into the file                     
                  if(rest_type.eq.'DIST') then
c
c---  Check if we need to use this pair in restriants.
                     if(itype_in.ge.2) then
                        if(sigma_value.gt.5.0) sigma_value=0.1
                        sigma_value = min(sigma_max_loc,
     &                       max(sigma_min_loc,sigma_value))
                        sigma_value = sigma_value/scale_sigma_loc
                     endif
                     write(ibond)1

                     write(ibond)iatom_number(1:2),dist_value,
     &                    sigma_value,isym_out(1:4,2),itype_in,
     &                    1.0
                     nbonds = nbonds + 1
                     nbonds_all = nbonds_all + 1
                  else if(rest_type.eq.'CHIR') then
                     if(nrest_now.eq.4) then
                        ichir_sign1 = 0
                        if(dist_value.gt.0.0) then
                           ichir_sign1 = 1
                        else if(dist_value.lt.0.0) then
                           dist_value = -dist_value
                           ichir_sign1 = -1
                        endif
                        write(ichir)iatom_number(1:4),
     &                       (isym_out(1:4,i),i=1,4),
     &                       dist_value,sigma_value,ichir_sign1,
     &                       itype_in,1.0
                        nchir = nchir + 1
                     endif
                  else if(rest_type.eq.'PLAN') then
                     if(nrest_now.gt.3) then
                        write(iplan)nrest_now,dist_value,sigma_value,
     &                       iatom_number(1:nrest_now),
     &                       (isym_out(1:4,i),i=1,nrest_now),itype_in,
     &                       1.0
                        nplans = nplans + 1
                     endif
                  else if(rest_type.eq.'HARM') then

                  else if(rest_type.eq.'TORS') then
                     if(nrest_now.eq.4.and.dist_defined) then
                        tors_l1 = 'user'
                        it_period = 1
                        itor_fl   = 1
                        write(itors)tors_l1,iatom_number(1:4),
     &                       (isym_out(1:4,i),i=1,4),
     &                       it_period,
     &                       dist_value,sigma_value,itor_fl,
     &                       itype_in,1.0
                        ntors = ntors + 1
                     endif
                  else if(rest_type.eq.'ANGL') then
                     if(nrest_now.eq.3) then
                        write(iangle,iostat=iend_b) iatom_number(1:3),
     &                       (isym_out(1:4,i),i=1,3),dist_value,
     &                       sigma_value,itype_in,1.0
                        nangles = nangles + 1
                     endif
                  else if(rest_type.eq.'INTE') then
                     if(nrest_now.eq.2.and.dmin_defined.and.
     &                    dmax_defined) then
                        ninte = ninte + 1
                        write(iint)iatom_number(1:2),isym_out(1:4,2),
     &                       dmin,dmax,smin_value,smax_value,
     &                       itype_in,1.0
                     endif
                  endif
               endif
            endif
 777        continue
         enddo
 888     continue
      enddo
 999  continue

      if(w_gm_in.le.0.0) w_gm_in = 0.1
      deallocate(full_atom_name)
      deallocate(index_c)
      if(psuedorest_file(1:1).ne.' ') close(ipsuedo)
      close(iscrk)
c
c---  Basepairs?

c
c---  Read and write bonds
      write(*,'(a)')'---------------------------------------'
      write(*,'(a22,3(2x,a8))')' ','Standard','External','All'
         
      rewind(ibond)
      read(ibond)nb1,nb_dupl
      if(nbonds_all.gt.0) then
         allocate(rs_vidl_b(2,nbonds_all))
         allocate(is_bond(4,nbonds_all))
         allocate(ikeys(3,nbonds_all))

         ib1 = 0
         do ib=1,nbonds
            ib1 = ib1 + 1
            read(ibond)nb_now
            read(ibond)ia1_t(1:2),(rs_vidl_b(1:2,j),j=ib1,ib1+nb_now-1),
     &           is_bond(1:4,ib1),ibond_t,weight_b
            ikeys(3,ib1) = ibond_t
            if(ia1_t(1).lt.ia1_t(2)) then
               ikeys(1:2,ib1) = ia1_t(1:2)
            else
               ikeys(2,ib1) = ia1_t(1)
               ikeys(1,ib1) = ia1_t(2)
               if(is_bond(1,ib1).ne.1.or.
     &              any(is_bond(2:4,ib1).ne.0)) then
                  call find_symm_contact(ikeys(1,ib), ikeys(2,ib),
     &                 is_bond(1:4,ib))
               endif
            endif
            
            if(nb_now.gt.1) then
               do j=ib1+1,ib1+nb_now-1
                  ikeys(1:3,j) = ikeys(1:3,ib1)
                  is_bond(1:4,j) = is_bond(1:4,ib1)
               enddo
            endif
            ib1 = ib1 + nb_now-1
         enddo
         if(ib1.ne.nbonds_all) then
            write(*,*)'Here comes a problem',ib1,nbonds_all
            stop
         endif
         
         allocate(index_c(nbonds_all))
         do ib=1,nbonds_all
            index_c(ib) = ib
         enddo
c
c---  Sort bonds with their type. If bond type is 0 or 1 then take only the 
c---  first one, otherwise take all and make decision later.

         call iheap_sort_r(nbonds_all,3,ikeys,index_c)
         nbonds_now = 0
         ib = 0
         ia1_t(1) = -1000
         ia1_t(2) = -1000
         ipr = ikeys(3,1)
         nb_start = 1
         nmax_dupl = 1
         do while(ib.lt.nbonds_all)
            ib = ib + 1
            if(any(ikeys(1:2,ib).ne.ia1_t(1:2))) then
               nbonds_now = nbonds_now+1
               ia1_t(1:2) = ikeys(1:2,ib)
               nb_start = ib
               ipr = ikeys(3,ib)
            endif
            if(ipr.gt.1) nmax_dupl = max(nmax_dupl,ib-nb_start+1)
         enddo
         rewind(ibond)
         write(ibond)nbonds_now,nmax_dupl
         nbonds_now = 0
         ib=0
         ia1_t(1) = -1000
         ia1_t(2) = -1000
         nb_start = 0
         nmax_dupl=1
         ipr = 100
         do while(ib.lt.nbonds)
            ib = ib + 1
            if(any(ikeys(1:2,ib).ne.ia1_t(1:2))) then
               if(ipr.gt.1) then
                  nb_end = ib-1
               else
                  nb_end = nb_start
               endif
               if(nb_start.gt.0) then
                  nbonds_now = nbonds_now + 1
                  write(ibond)nb_end-nb_start+1
                  write(ibond)ikeys(1:2,nb_start),
     &                 (rs_vidl_b(1:2,index_c(jj)),jj=nb_start,nb_end),
     &                 is_bond(1:4,index_c(nb_start)),
     &                 ikeys(3,nb_start),1.0
               endif
               nb_start = ib
               ia1_t(1:2) = ikeys(1:2,ib)
               ipr = ikeys(3,ib)
            endif
         enddo
         if(ipr.gt.1) then
            nb_end = ib
         else
            nb_end = nb_start
         endif
         nbonds_now = nbonds_now + 1
         write(ibond)nb_end-nb_start+1
         write(ibond)ikeys(1:2,nb_start),
     &        (rs_vidl_b(1:2,index_c(jj)),jj=nb_start,nb_end),
     &        is_bond(1:4,index_c(nb_start)),ikeys(3,nb_start),1.0
         
         deallocate(is_bond)
         deallocate(rs_vidl_b)
         deallocate(index_c)
         deallocate(ikeys)
      else
         nbonds_now = 0
      endif
      close(ibond)
      write(*,'(a22,3(2x,i8))')'Bonds:',nb1,nbonds_now-nb1,nbonds_now
c
c---angles
      if(nangles.gt.0) then
         allocate(ia1_a(3,nangles))
         allocate(rs_vidl_a(2,nangles))
         allocate(is_a(4,3,nangles))
         allocate(iangle_type(nangles))
         rewind(iangle)
         read(iangle)nan1
         do ic=1,nangles
            read(iangle)ia1_a(1:3,ic),(is_a(1:4,i,ic),i=1,3),
     &           rs_vidl_a(1:2,ic),iangle_type(ic),weight_b
         enddo
         call remove_duplicated_angles(n_atom,nangles,nb_out,
     &        ia1_a(1:3,1:nangles),
     &        rs_vidl_a(1:2,1:nangles),is_a(1:4,1:3,1:nangles),
     &        iangle_type(1:nangles),maxnso,cs_nsym,cs_m_cs,cs_v_cs)
         write(*,'(a22,3(2x,i8))')'Angles:',nan1,nangles-nan1,nb_out
         nangles = nb_out
         rewind(iangle)
         write(iangle)nangles
         do ic=1,nangles
            write(iangle)ia1_a(1:3,ic),(is_a(1:4,i,ic),i=1,3),
     &           rs_vidl_a(1:2,ic),iangle_type(ic),weight_b
         enddo
         deallocate(ia1_a)
         deallocate(rs_vidl_a)
         deallocate(is_a)
         deallocate(iangle_type)
      endif
      close(iangle)
c      stop
c
c---  Chirals
      if(nchir.gt.0) then
         allocate(ia1_c(4,nchir))
         allocate(rs_vidl_c(2,nchir))
         allocate(ichir_sign(nchir))
         allocate(is_c(4,4,nchir))
         rewind(ichir)
         read(ichir)nch1
         write(*,'(a22,3(2x,i8))')'Chirals:',nch1,nchir-nch1,nchir

         do ic=1,nchir
            read(ichir)ia1_c(1:4,ic),(is_c(1:4,i,ic),i=1,4),
     &           rs_vidl_c(1:2,ic),ichir_sign(ic),ibtype,weight_b
         enddo
         rewind(ichir)
         write(ichir)nchir
         do ic=1,nchir
            write(ichir)ia1_c(1:4,ic),(is_c(1:4,i,ic),i=1,4),
     &           rs_vidl_c(1:2,ic),ichir_sign(ic),1,weight_b
         enddo
         deallocate(ia1_c)
         deallocate(rs_vidl_c)
         deallocate(ichir_sign)
         deallocate(is_c)
      endif
      close(ichir)
c
c---  Planes
      if(nplans.gt.0) then
         allocate(ia1_p(100,nplans))
         allocate(rs_vidl_p(2,nplans))
         allocate(nplane(nplans))
         allocate(is_p(4,100,nplans))
         
         rewind(iplan)
         read(iplan)np1,nmaxatom_in_plane
         write(*,'(a22,3(2x,i8))')'Planes:',np1,nplans-np1,nplans

         do ip=1,nplans
            read(iplan)nplane(ip),rs_vidl_p(1:2,ip),
     &           ia1_p(1:nplane(ip),ip),(is_p(1:4,i,ip),i=1,nplane(ip)),
     &           ibtype,weight_b
            nmaxatom_in_plane = max(nmaxatom_in_plane,nplane(ip))
         enddo
         rewind(iplan)
         write(iplan)nplans,nmaxatom_in_plane
         do ip=1,nplans
            write(iplan)nplane(ip),rs_vidl_p(1:2,ip),
     &           ia1_p(1:nplane(ip),ip),(is_p(1:4,i,ip),i=1,nplane(ip)),
     &           1,weight_b
         enddo
         deallocate(ia1_p)
         deallocate(rs_vidl_p)
         deallocate(nplane)
         deallocate(is_p)
      endif
      close(iplan)
c
c---  torsion
      if(ntors.gt.0) then
         allocate(tors_labels(ntors))
         allocate(ia1_tors(4,ntors))
         allocate(is_tors(4,4,ntors))
         allocate(tors_flag(ntors))
         allocate(tors_period(ntors))
         allocate(rs_vidl_tors(2,ntors))
         allocate(itors_type(ntors))
         rewind(itors)
         read(itors,iostat=iend_b)nt1
         do it=1,ntors
            read(itors,iostat=iend_b)tors_labels(it),ia1_tors(1:4,it),
     &           (is_tors(1:4,i,it),i=1,4),
     &           tors_period(it),
     &           rs_vidl_tors(1:2,it),tors_flag(it),itors_type(it),
     &           weight_b
         enddo
         call remove_duplicated_tors(n_atom,ntors,nb_out,
     &        ia1_tors,rs_vidl_tors,is_tors,itors_type,tors_period,
     &        tors_flag,
     &        tors_labels,maxnso,cs_nsym,cs_m_cs,cs_v_cs)
         rewind(itors)
         write(*,'(a22,3(2x,i8))')'Torsions:',nt1,ntors-nt1,nb_out
         ntors = nb_out
         write(itors)ntors
         do it=1,ntors
            write(itors)tors_labels(it),ia1_tors(1:4,it),
     &           (is_tors(1:4,i,it),i=1,4),
     &           tors_period(it),
     &           rs_vidl_tors(1:2,it),tors_flag(it),itors_type(it),
     &           weight_b
         enddo
         deallocate(tors_labels)
         deallocate(ia1_tors)
         deallocate(is_tors)
         deallocate(tors_flag)
         deallocate(tors_period)
         deallocate(rs_vidl_tors)
      endif
      close(itors)
c
c---  hamronics???

c
c---  Intervals
      if(ninte.gt.0) then
c
c---  Sort them??
         allocate(ia1_int(2,ninte))
         allocate(is_int(4,ninte))
         allocate(rs_vidl_int(4,ninte))
         allocate(ibond_type(ninte))
         rewind(iint)
         read(iint)nt1
         write(*,'(a22,3(2x,i8))')'Intervals:',nint1,ninte-nint1,ninte
         do it=1,ninte
            read(iint)ia1_int(1:2,it),is_int(1:4,it),
     &           rs_vidl_int(1:4,it),ibond_type(it),weight_b
         enddo
         rewind(iint)
         write(iint)ninte
         do it=1,ninte
            write(iint)ia1_int(1:2,it),is_int(1:4,it),
     &           rs_vidl_int(1:4,it),ibond_type(it),1,weight_b
         enddo
         deallocate(ia1_int)
         deallocate(is_int)
         deallocate(rs_vidl_int)
         deallocate(ibond_type)
      endif
      close(iint)
      write(*,'(a)')'---------------------------------------'
      write(*,*)
c
c--   It needs to be read and sorted to remove duplicated restraints

c---  Read and remove redundant pairs.

      if(ierr.eq.0) return
c
c---  Process errors
      if(ierr.eq.1) write(*,*)'Incomplete instruction for restrtaint'
      if(ierr.eq.2) write(*,*)'Wrong data type for distance/sigma'
      if(ierr.eq.3) write(*,*)'Specified atoms(s) could not be found'
      if(ierr.eq.4) write(*,*)'Wrong instruction'
      if(ierr.eq.5) write(*,*)'Problem in reading atom record'
      if(ierr.eq.6) write(*,*)'Too many atoms per restraint'
      write(*,*)'Example of instructions:'
      write(*,*)'extr dist first residue <number> chain <name> atom'
     &//' <name> second residue <number> chain <name> atom <name>'
     &//' value <number> sigma <number>'
      write(*,*)'If alternative or insertion code are aslo present then'
     &//' they can be added using subkeywords alte or inse'
      call errwrt(1,'Cannot continue. Quitting now')
      return
      end
c
      subroutine find_symm_contact(ia1,ia2,isym_out)
      implicit none
      include 'atom_com.fh'
c
c---inputs
      integer ia1,ia2
c
c---outputs
      integer isym_out(4)
c
c---locals
      integer is,itx(3)
      real d_p,d_l
      real xyz_1(3),xyz_2(3),xyz_frac2(3),xyz_frac1(3),xyz_sym(3)
      real xyz_d(3),axyz(3),axyz_o(3)
      logical error
c
c---body
      xyz_1(1:3) = xyz_crd(1:3,ia1)
      xyz_2(1:3) = xyz_crd(1:3,ia2)
      call mat2vec(3,3,cs_ort_to_frac,xyz_2,xyz_frac2,error)
      call mat2vec(3,3,cs_ort_to_frac,xyz_1,xyz_frac1,error)
      d_p = 1.0e32
      isym_out(1) = 1
      isym_out(2:4) = 0
      do  is=1,cs_nsym
         call mat2vec(3,3,cs_m_cs(1,1,is),xyz_frac2,xyz_sym,error)
         xyz_sym(1:3) = xyz_sym(1:3) + cs_v_cs(1:3,is)
         call find_closest_xyz(xyz_frac1,xyz_sym,itx)
         axyz(1:3) = xyz_frac1(1:3) - (xyz_sym+itx(1:3))

c         xyz_d(1:3) = xyz_frac1(1:3) - xyz_sym(1:3)
c         call amod_r(xyz_d(1),1.0,itx(1),axyz(1))
c         axyz(1) = axyz(1)
c         call amod_r(xyz_d(2),1.0,itx(2),axyz(2))
c         axyz(2) = axyz(2)
c         call amod_r(xyz_d(3),1.0,itx(3),axyz(3))
c         axyz(3) = axyz(3)

         call mat2vec(3,3,cs_frac_to_ort,axyz,axyz_o,error)
         d_l = axyz_o(1)**2+axyz_o(2)**2+axyz_o(3)**2
         if(d_p.gt.d_l) then
            isym_out(1) = is
            isym_out(2:4) = itx(1:3)
            d_p = d_l
         endif
      enddo
      return
      end
c
      subroutine find_closest_xyz(xyz1,xyz2,itx)
      implicit none
c
c--Find itx(1:3) that would bring close xyz2 to xyz1
      real xyz1(3),xyz2(3)
      integer itx(3)
c
c---locals
      integer i
      real    t,t1
      real    xyz_l(3)
c
c---body
      itx(1:3) = 0
      xyz_l(1:3) = xyz2(1:3)

      do i=1,3
         do while (xyz_l(i).ge.xyz1(i))
            itx(i) = itx(i) - 1
            xyz_l(i) = xyz_l(i)-1.0
         enddo
         do while(xyz_l(i).le.xyz1(i))
            itx(i) = itx(i) + 1
            xyz_l(i) = xyz_l(i) + 1
         enddo
      
c
c--Now test two options xyz_l(i) + 1 and xyz_l(i)

         t  = abs(xyz_l(i) - xyz1(i))
         t1 = abs(xyz_l(i) - 1.0 - xyz1(i))
         if(t1.lt.t) itx(i) = itx(i) - 1
      enddo

      return
      end
c
      subroutine remove_duplicated_bonds(n_atom,nbonds,nb_out,ia1_b,
     &     rs_vidl,is_bond,ibond_type,maxsym,nsym,rot,tr)
      implicit none
c
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)

      integer n_atom,nbonds,nb_out
      integer ia1_b(2,nbonds),is_bond(4,nbonds),ibond_type(nbonds)
      real rs_vidl(2,nbonds)
c
      integer nmaxbond
      integer, allocatable :: nrest_per_atom(:)
      integer, allocatable :: rest_per_atom(:,:)
      integer, allocatable :: rest_ref_per_atom(:,:)
      integer, allocatable :: rest_per_atom_symm(:,:,:)
      integer, allocatable :: bond_flag(:)
c
      integer i,i1,ia1,ib1,ib,id,ir
      integer first
      integer iv1(2),isym1(4),isym2(4),isym3(4)
c
c---  body
      first = 0
      allocate(nrest_per_atom(n_atom))
      nrest_per_atom(1:n_atom) = 0
      do i=1,nbonds
         if(ibond_type(i).le.2) then
            nrest_per_atom(ia1_b(1,i)) = nrest_per_atom(ia1_b(1,i)) + 1
            nrest_per_atom(ia1_b(2,i)) = nrest_per_atom(ia1_b(2,i)) + 1
         endif
      enddo
      nmaxbond = maxval(nrest_per_atom(1:n_atom))
      allocate(rest_per_atom(nmaxbond,n_atom))
      allocate(rest_per_atom_symm(4,nmaxbond,n_atom))
      allocate(rest_ref_per_atom(nmaxbond,n_atom))

      nrest_per_atom(1:n_atom) = 0
      do i=1,nbonds
         if(ibond_type(i).le.2) then
            nrest_per_atom(ia1_b(1,i)) = nrest_per_atom(ia1_b(1,i)) + 1
            i1 = nrest_per_atom(ia1_b(1,i))
            rest_per_atom(i1,ia1_b(1,i)) = ia1_b(2,i)
            rest_ref_per_atom(i1,ia1_b(1,i)) = i
            rest_per_atom_symm(1:4,i1,ia1_b(1,i)) = is_bond(1:4,i)

            nrest_per_atom(ia1_b(2,i)) = nrest_per_atom(ia1_b(2,i)) + 1
            i1 = nrest_per_atom(ia1_b(2,i))
            rest_per_atom(i1,ia1_b(2,i)) = ia1_b(1,i)
            rest_ref_per_atom(i1,ia1_b(2,i)) = i
            call symm_inv_r(maxsym,nsym,rot,tr,is_bond(1:4,i),
     &           isym1,first)
            rest_per_atom_symm(1:4,i1,ia1_b(2,i)) = isym1(1:4)
         endif
      enddo
c
      allocate(bond_flag(nbonds))
      bond_flag(1:nbonds) = 1
      do i=1,nbonds
         if(ibond_type(i).gt.0.and.bond_flag(i).eq.1) then
            do ib=1,nrest_per_atom(ia1_b(1,i))
               if(ia1_b(2,i).eq.rest_per_atom(ib,ia1_b(1,i))) then
                  ir = rest_ref_per_atom(ib,ia1_b(1,i))
                  if(ir.eq.i) cycle
                  isym1(1:4)=rest_per_atom_symm(1:4,ib,ia1_b(1,i))
                  id=maxval(abs(is_bond(1:4,i)-isym1(1:4)))
                  if(id.eq.0) then
                     if(ibond_type(i).gt.ibond_type(ir)) then
                        bond_flag(i) = -1
                        exit
                     elseif(ibond_type(i).lt.ibond_type(ir)) then
                        bond_flag(ir) = -1
                        exit
                     endif
                  endif
               endif
            enddo
         endif
      enddo
c
c---  Angles
c      do i=1,nbonds
c         iv1(1:2) = ia1_b(1:2,i)
c         if(ibond_type(i).gt.0.and.bond_flag(i).gt.0.and.
c     &        nrest_per_atom(iv1(1)).gt.1.and.
c     &        nrest_per_atom(iv1(2)).gt.1) then
c            do   ib=1,nrest_per_atom(iv1(1))
c               ia1 = rest_per_atom(ib,iv1(1))
c               if(nrest_per_atom(ia1).gt.1) then
c                  isym1(1:4) = rest_per_atom_symm(1:4,ib,iv1(1))
c                  do ib1=1,nrest_per_atom(ia1)
c                     if(rest_per_atom(ib1,ia1).eq.iv1(2)) then
c                        isym2(1:4) = rest_per_atom_symm(1:4,ib1,ia1)
c                        call symm_mult_r(maxsym,nsym,rot,tr,
c     &                       isym1,isym2,isym3,first)
c                        id=maxval(abs(is_bond(1:4,i)-isym3(1:4)))
c                        if(id.eq.0) then
c                           bond_flag(i) = -1
c                           goto 200
c                        endif
c                     endif
c                  enddo
c               endif
c            enddo
c 200        continue
c         endif
c      enddo

      nb_out = 0
      do i=1,nbonds
         if(bond_flag(i).gt.0) then
            nb_out = nb_out + 1
            ia1_b(1:2,nb_out) = ia1_b(1:2,i)
            rs_vidl(1:2,nb_out) = rs_vidl(1:2,i)
            is_bond(1:4,nb_out) = is_bond(1:4,i)
            ibond_type(nb_out) = ibond_type(i)
         endif
      enddo
      deallocate(nrest_per_atom)
      deallocate(rest_per_atom)
      deallocate(rest_ref_per_atom)
      deallocate(rest_per_atom_symm)
      deallocate(bond_flag)

      return
      end
c

c
      subroutine remove_duplicated_angles(n_atom,nangles,nb_out,
     &     ia1_a,rs_vidl,is_a,iangle_type,maxnso,
     &     cs_nsym,cs_m_cs,cs_v_cs)
      implicit none
c
c---  Remove duplicated angles. Angles are removed accoriding to their types
c---  lower type has higher priority
      integer n_atom,nangles,nb_out
      integer ia1_a(3,nangles)
      integer is_a(4,3,nangles)
      integer iangle_type(nangles)
      real rs_vidl(2,nangles)

      integer maxnso,cs_nsym
      real  cs_m_cs(3,3,maxnso),cs_v_cs(3,maxnso)
c
      integer nmaxbond
      integer, allocatable :: nrest_per_atom(:)
      integer, allocatable :: rest_per_atom(:,:)
      integer, allocatable :: rest_ref_per_atom(:,:)
      integer, allocatable :: rest_per_atom_symm(:,:,:)
      integer, allocatable :: bond_flag(:)
c
      integer i,ib,ir,nmaxrest
c
c     body
c-----------------------------------------
      allocate(nrest_per_atom(n_atom))
      nrest_per_atom(1:n_atom) = 0

      do i=1,nangles
         nrest_per_atom(ia1_a(1,i)) = nrest_per_atom(ia1_a(1,i))+1
         nrest_per_atom(ia1_a(3,i)) = nrest_per_atom(ia1_a(3,i))+1
      enddo
c
      nmaxrest = maxval(nrest_per_atom(1:n_atom))
      allocate(rest_ref_per_atom(nmaxrest,n_atom))
      nrest_per_atom(1:n_atom) = 0

      do i=1,nangles
         nrest_per_atom(ia1_a(1,i)) = nrest_per_atom(ia1_a(1,i))+1
         ir = nrest_per_atom(ia1_a(1,i))
         rest_ref_per_atom(ir,ia1_a(1,i)) = i

         nrest_per_atom(ia1_a(3,i)) = nrest_per_atom(ia1_a(3,i))+1
         ir = nrest_per_atom(ia1_a(3,i))
         rest_ref_per_atom(ir,ia1_a(3,i)) = i
      enddo
      allocate(bond_flag(nangles))
      bond_flag(1:nangles) = 1

      do i=1,nangles
         if(iangle_type(i).gt.0.and.bond_flag(i).eq.1) then
            do ib=1,nrest_per_atom(ia1_a(1,i))
               ir = rest_ref_per_atom(ib,ia1_a(1,i))
               if(ir.eq.i) cycle
               if(ia1_a(2,ir).ne.ia1_a(2,i)) cycle
               if(ia1_a(1,ir).eq.ia1_a(1,i).and.
     &              ia1_a(3,ir).eq.ia1_a(3,i)) then
                  if(iangle_type(i).gt.iangle_type(ir)) then
                     bond_flag(i) = -1
                     exit
                  elseif(iangle_type(i).lt.iangle_type(ir)) then
                     bond_flag(ir) = -1
                     exit
                  endif
               elseif(ia1_a(3,ir).eq.ia1_a(1,i).and.
     &                 ia1_a(1,ir).eq.ia1_a(3,i)) then
                  if(iangle_type(i).gt.iangle_type(ir)) then
                     bond_flag(i) = -1
                     exit
                  elseif(iangle_type(i).lt.iangle_type(ir)) then
                     bond_flag(ir) = -1
                     exit
                  endif
               endif
            enddo
         endif
      enddo

      nb_out = 0
      do i=1,nangles
         if(bond_flag(i).gt.0) then
            nb_out = nb_out + 1
            ia1_a(1:3,nb_out) = ia1_a(1:3,i)
            rs_vidl(1:2,nb_out) = rs_vidl(1:2,i)
            is_a(1:4,1:3,nb_out) = is_a(1:4,1:3,i)
            iangle_type(nb_out) = iangle_type(i)
         endif
      enddo
      deallocate(nrest_per_atom)
      deallocate(rest_ref_per_atom)
      deallocate(bond_flag)

      return
      end
c
      subroutine remove_duplicated_tors(n_atom,ntors,nb_out,
     &     ia1_t,rs_vidl,is_t,itors_type,tors_period,tors_flag,
     &     tors_label,maxnso,
     &     cs_nsym,cs_m_cs,cs_v_cs)

      implicit none
c
c---  Remove duplicated angles. Angles are removed accoriding to their types
c---  lower type has higher priority
      integer n_atom,ntors,nb_out
      integer ia1_t(4,ntors)
      integer is_t(4,4,ntors)
      integer itors_type(ntors)
      integer tors_period(ntors)
      integer tors_flag(ntors)
      real rs_vidl(2,ntors)
c
      character tors_label(ntors)*(*)

      integer maxnso,cs_nsym
      real  cs_m_cs(3,3,maxnso),cs_v_cs(3,maxnso)
c
      integer nmaxbond
      integer, allocatable :: nrest_per_atom(:)
      integer, allocatable :: rest_per_atom(:,:)
      integer, allocatable :: rest_ref_per_atom(:,:)
      integer, allocatable :: rest_per_atom_symm(:,:,:)
      integer, allocatable :: bond_flag(:)
c
      integer i,ib,ir,nmaxrest
c
c     body
c-----------------------------------------
      allocate(nrest_per_atom(n_atom))
      nrest_per_atom(1:n_atom) = 0

      do i=1,ntors
         nrest_per_atom(ia1_t(1,i)) = nrest_per_atom(ia1_t(1,i))+1
         nrest_per_atom(ia1_t(4,i)) = nrest_per_atom(ia1_t(4,i))+1
      enddo
c
      nmaxrest = maxval(nrest_per_atom(1:n_atom))
      allocate(rest_ref_per_atom(nmaxrest,n_atom))
      nrest_per_atom(1:n_atom) = 0

      do i=1,ntors
         nrest_per_atom(ia1_t(1,i)) = nrest_per_atom(ia1_t(1,i))+1
         ir = nrest_per_atom(ia1_t(1,i))
         rest_ref_per_atom(ir,ia1_t(1,i)) = i

         nrest_per_atom(ia1_t(4,i)) = nrest_per_atom(ia1_t(4,i))+1
         ir = nrest_per_atom(ia1_t(4,i))
         rest_ref_per_atom(ir,ia1_t(4,i)) = i
      enddo
      allocate(bond_flag(ntors))
      bond_flag(1:ntors) = 1

      do i=1,ntors
         if(itors_type(i).gt.0.and.bond_flag(i).eq.1) then
            do ib=1,nrest_per_atom(ia1_t(1,i))
               ir = rest_ref_per_atom(ib,ia1_t(1,i))
               if(ir.eq.i) cycle
               if(ia1_t(1,ir).eq.ia1_t(1,i).and.
     &              ia1_t(4,ir).eq.ia1_t(4,i)) then
                  if(ia1_t(2,ir).eq.ia1_t(2,i).and.
     &                 ia1_t(3,ir).eq.ia1_t(3,i)) then
                     if(itors_type(i).gt.itors_type(ir)) then
                        bond_flag(i) = -1
                        exit
                     elseif(itors_type(i).lt.itors_type(ir)) then
                        bond_flag(ir) = -1
                        exit
                     endif
                  endif
               elseif(ia1_t(4,ir).eq.ia1_t(1,i).and.
     &                 ia1_t(1,ir).eq.ia1_t(4,i)) then
                  if(ia1_t(2,ir).eq.ia1_t(3,i).and.
     &                 ia1_t(3,ir).eq.ia1_t(2,i)) then
                     if(itors_type(i).gt.itors_type(ir)) then
                        bond_flag(i) = -1
                        exit
                     elseif(itors_type(i).lt.itors_type(ir)) then
                        bond_flag(ir) = -1
                        exit
                     endif
                  endif
               endif
            enddo
         endif
      enddo

      nb_out = 0
      do i=1,ntors
         if(bond_flag(i).gt.0) then
            nb_out = nb_out + 1
            ia1_t(1:4,nb_out) = ia1_t(1:4,i)
            rs_vidl(1:2,nb_out) = rs_vidl(1:2,i)
            is_t(1:4,1:4,nb_out) = is_t(1:4,1:4,i)
            itors_type(nb_out) = itors_type(i)
            tors_period(nb_out) = tors_period(i)
            tors_flag(nb_out) = tors_flag(i)
            tors_label(nb_out) = tors_label(i)
         endif
      enddo

      deallocate(nrest_per_atom)
      deallocate(rest_ref_per_atom)
      deallocate(bond_flag)

      return
      end
c
      subroutine read_external_atom_info(ntok,nkeywords,
     &                    itk_in,itk_out,
     &                    ibeg,iend,ires1,ierr,cvalue,line,
     &                    chain1,ins1,atom1,alt1,symm1,
     &                    EndKeywords)

      implicit none
c
      integer   nkeywords,ntok,itk_in,itk_out
      integer   ierr
      integer   ibeg(*),iend(*)
      integer   ires1
      character cvalue(*)*4
      character line*(*)
      character chain1*(*)
      character atom1*(*)
      character ins1*(*)
      character alt1*(*)
      character symm1*(*)
      character EndKeywords(*)*4
c
c--locals
      integer i
      integer itk
c
c---  body
      i=0
      ierr = 0
      itk    = itk_in
      atom1  = '.'
      chain1 = '.'
      alt1   = '.'
      ins1   = ' '
      ires1 = -320000
      symm1 = 'N'
      do while(itk.le.ntok-1)
         do i=1,nkeywords
            if(cvalue(itk).eq.EndKeywords(i)) goto 100
         enddo
         if(cvalue(itk).eq.'CHAI') then
            itk = itk + 1
            chain1 = line(ibeg(itk):iend(itk))
         else if(cvalue(itk).eq.'RESI') then
            itk = itk + 1
            read(line(ibeg(itk):iend(itk)),*)ires1
c     ires_in(2) = nint(fvalue(itk))
         else if(cvalue(itk)(1:3).eq.'INS') then
            itk = itk + 1
            ins1 = line(ibeg(itk):iend(itk))
            if(ins1.eq.'.') ins1 = ' '
         else if(cvalue(itk).eq.'ATOM') then
            itk = itk + 1
            atom1 = line(ibeg(itk):iend(itk))
         else if(cvalue(itk)(1:3).eq.'ALT') then
            itk = itk + 1
            alt1 = line(ibeg(itk):iend(itk))
         else if(cvalue(itk).eq.'SYMM') then
            itk = itk + 1
            if(cvalue(itk)(1:1).eq.'Y') symm1 = 'Y'
         else
            write(*,*)'Wrong keyword or value in atrecord'
            ierr = 1
         endif
         itk = itk + 1
      enddo
c
 100  continue
      itk_out = itk
c
      if(ierr.ne.0) then
c---- failure
         write(*,*)'Problem in reading atom info'
         write(*,*)'Either chain or atom or residue number '// 
     &        'has not beend defined'
      endif
      return
      end
c
      subroutine read_harm_et_al
      use restr_files
      implicit none
      include 'atom_com.fh'
c
c---  locals
      integer lps,iscrk,ipsuedo,file_in
      integer ifile,nfile
      character psuedorest_file*512

      integer iharm,ierr,iend_b
      integer nharms

      integer, allocatable :: ia1_h(:)
      real,    allocatable :: sigma_h(:)
      integer, allocatable :: rest_type(:)
c
      integer ia1_t
      real    sigma_t
c
c---  Things for parser
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f
      character rectype*4

      integer nkeywords
      character EndKeywords(200)*4
c
      integer i,irest_type
      integer ich,ir,ia,jrs
      integer ifirst,ilast
      integer ir_first,ir_last,ia_first,ia_last
      integer ires1
      character ins_code*1
      character asmgrp*4
      character chain1*4,ins1*1,alt1*1,atom1*4,symm_in*1,symm1*1
      character atom_resi*4
c
c---  body
      call getenv('PSRESTIN',psuedorest_file)
      lps = len_trim(psuedorest_file)
      if(lps.gt.0) then
         call open_form_file(ipsuedo,psuedorest_file,ierr)
         if(ierr.ne.0) then
            write(*,*)'Problem with psuedo restraint file'
         endif
      endif

      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
      if(harmonic_file(1:1).eq.' ') then
         call find_unique_file_name(harmonic_file,'_HARM_R')
      endif
      call open_unform_file(iharm,harmonic_file,ierr)
      if(ierr.gt.0) then
         call errwrt(1,'In read_psuedorest. Opening interval file')
      endif
      nharms = 0
      read(iharm,iostat=iend_b) nharms
      if(iend_b.eq.0) then
         do  while(iend_b.eq.0)
            read(iharm,iostat=iend_b)ia1_t,sigma_t,irest_type
         enddo
      else
         nharms = 0
      endif
c
      lend = .TRUE.
c
c---  If psuedo restraint file is present then use this file first
c---  Instructions from the keywords file have higher priority
      nfile = 1
      if(lps.le.0) nfile = 2
      nkeywords = 1
      EndKeywords(1) = 'SIGM'
      do ifile=nfile,2
         if(ifile.eq.1) then
            file_in = ipsuedo
         else
            file_in = iscrk
         endif
         lend_f = 0
         key    = ' '
c
        do while(lend_f.eq.0.and.key(1:3).ne.'END'.and.ierr.eq.0)
            lprint = .FALSE.
            line = ' '
            key = ' '
            symm_in ='N'
            do while(line.eq.' '.and.lend_f.eq.0)
               read(file_in,'(a)',iostat=lend_f)line
            enddo
            if(lend_f.lt.0) goto 888
            
            ntok = maxtok
            call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &           ntok,lend,lprint)
            call ccpupc(key)
            do  itk=2,ntok
               call ccpupc(cvalue(itk))
            enddo
            itk = 1
            if(key.eq.'EXTE') then
               sigma_t = 0.01
               itk = itk + 1
               if(itk.ge.NTOK) then
                  ierr = 2
                  goto 900
               endif
               if(cvalue(itk).eq.'HARM'.or.cvalue(itk).eq.'SPEC') then
                  if(cvalue(itk).eq.'HARM') then
                     irest_type = 1
                  else
                     irest_type = 2
                  endif
                  itk = itk + 1
                  do while(itk.le.ntok)
                     if(cvalue(itk).eq.'ATIN') then
                        itk = itk + 1
                        if(itk.ge.NTOK) then
                           ierr = 2
                           goto 900
                        endif
                        rectype = 'ATOM'
                        call read_external_atom_info(ntok,nkeywords,
     &                       itk,itk_out,
     &                       ibeg,iend,ires1,ierr,cvalue,line,
     &                       chain1,ins1,atom1,alt1,symm1,
     &                       EndKeywords)
                        itk = itk_out
                     else if (cvalue(itk).eq.'RESI') then
                        itk = itk + 1
                        rectype = 'RESI'
                        call read_fromto1(NTOK,ITK,CVALUE,line,ibeg,
     &                       iend,
     &                       itype,fvalue,ifirst,ilast,chain1,ierr)
                        if(cvalue(itk).eq.'ATOM') then
                           itk = itk + 1
                           atom_resi = line(ibeg(itk):iend(itk))
                           itk = itk + 1
                        else
                           atom_resi = ' '
                        endif
                     else if(cvalue(itk).eq.'SIGM') then
                        itk = itk + 1
                        sigma_t = 0.01
                        if(itk.le.ntok) then
                           if(itype(itk).eq.2) then
                              read(line(ibeg(itk):iend(itk)),*)sigma_t
                              itk = itk + 1
                           endif
                        endif
                     else
                        itk = itk + 1
                     endif
                  enddo
               endif
               if(rectype.eq.'ATOM') then
                  do  ich=1,n_group
                     call get_asm_group_id(asmgrp,ich)
                     if(chain1.eq.asmgrp) then
                        ir_first = ires_first(ich)
                        ir_last  = ir_first + nres_chain(ich)-1
                        do ir=ir_first,ir_last
                           read(res_num_pdb(ir)(3:6),*)jrs
                           ins_code = res_num_pdb(ir)(7:7)
                           if(ires1.eq.jrs.and.
     &                          ins1.eq.ins_code) then
                              ia_first = iratm_first(ir)
                              ia_last  = ia_first+natm_res(ir)-1
                              do  ia=ia_first,ia_last
                                 if(atom1.eq.atm_name(ia).and.
     &                                alt1.eq.id_alt(ia)) then
                                    write(iharm)ia,sigma_t,irest_type
                                    nharms = nharms + 1
                                    goto 200
                                 endif
                              enddo
                           endif
                        enddo
                     endif
                  enddo
               else if(rectype.eq.'RESI') then
                  do  ich=1,n_group
                     call get_asm_group_id(asmgrp,ich)
                     if(chain1.eq.asmgrp) then
                        ir_first = ires_first(ich)
                        ir_last  = ir_first + nres_chain(ich)-1
                        do ir=ir_first,ir_last
                           read(res_num_pdb(ir)(3:6),*)jrs
                           if(jrs.ge.ifirst.and.jrs.le.ilast) then
                              ia_first = iratm_first(ir)
                              ia_last  = ia_first+natm_res(ir)-1
                              do ia=ia_first,ia_last
                                 if(len_trim(atom_resi).le.0 .or.
     &                                atm_name(ia).eq.atom_resi) then
                                    write(iharm)ia,sigma_t,irest_type
                                    nharms = nharms + 1
                                 endif
                              enddo
                           endif
                        enddo
                        goto 200
                     endif
                  enddo
               endif
 200           continue
            endif
         enddo
 888     continue
      enddo
c
 900  continue
      if(nharms.gt.0) then
         allocate(ia1_h(nharms))
         allocate(sigma_h(nharms))
         allocate(rest_type(nharms))
         rewind(iharm)
         do i=1,nharms
            read(iharm)ia1_h(i),sigma_h(i),rest_type(i)
         enddo
         rewind(iharm)
         write(iharm)nharms
         do i=1,nharms
            write(iharm)ia1_h(i),sigma_h(i),rest_type(i),1.0
         enddo
         deallocate(ia1_h)
         deallocate(sigma_h)
         deallocate(rest_type)
         close(iharm)
      else
         close(iharm,status='DELETE')
         harmonic_file = ' '
      endif
      if(ierr.gt.0) then
         write(*,*)'Wrong instructions for External harmonic restraints'
         write(*,*)'Example of correct instruction:'

      endif
      if(lps.gt.0.and.ipsuedo.gt.0) close(ipsuedo)
      close(iscrk)
      return
      end
c
      subroutine read_vdw_ion_external
      use restr_files
      implicit none
      include 'atom_com.fh'
      include 'atom_com_str.fh'
c
c---  Read instructions for vdw and ion radii of specified atoms
c
c---  locals
      integer lps,ipsuedo,iscrk,ierr
      integer file_in,nfile,ifile
      character psuedorest_file*512
c
c---  Things for parser
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f
c
c---  Interpretation
      integer nkeywords,iatom_number
      character EndKeywords(100)*4
      logical vdw_defined,ion_defined
      integer ires_in
      character ins_in*1,atom_in*4,alt_in*1,chain_in*4,symm_in*1
      real      vdw_loc,ion_loc
c
c---  body
      ierr = 0
c
c---  Instruction may come from two sources. 1) External psuedorestraint file
c---  and 2) usual keyword file. Usual keyword would be sufficient. 
c---  Unfortunately psuedorestraint file has already been declared and out on 
c---  the web
      call getenv('PSRESTIN',psuedorest_file)
      lps = len_trim(psuedorest_file)
      if(lps.gt.0) then
         call open_form_file(ipsuedo,psuedorest_file,ierr)
         if(ierr.ne.0) then
            write(*,*)'Problem with psuedo restraint file'
         endif
      endif

      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
c---  If psuedo restraint file is present then use this file first
c---  Instructions from the keywords file have higher priority
      nfile = 1
      if(lps.le.0) nfile = 2
      nkeywords = 1
      EndKeywords(1) = 'SIGM'
      do ifile=nfile,2
         if(ifile.eq.1) then
            file_in = ipsuedo
         else
            file_in = iscrk
         endif
         lend_f = 0
         key    = ' '
c
         do while(lend_f.eq.0.and.key(1:3).ne.'END'.and.ierr.eq.0)
            lprint = .FALSE.
            line = ' '
            key = ' '
            symm_in ='N'
            do while(line.eq.' '.and.lend_f.eq.0)
               read(file_in,'(a)',iostat=lend_f)line
            enddo
            if(lend_f.lt.0) goto 888
            ntok = maxtok
            call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &           ntok,lend,lprint)
            call ccpupc(key)
            do  itk=2,ntok
               call ccpupc(cvalue(itk))
            enddo
            nkeywords = 2
            EndKeywords(1) = 'VDWR'
            ENDKeywords(2) = 'IONR'
            if(key.eq.'EXTE') then
               itk = 2
               if(cvalue(itk).eq.'NONB') then
                  vdw_defined = .FALSE.
                  ion_defined = .FALSE.
                  vdw_loc     = -1.0
                  ion_loc     = -1.0
                  itk = itk +1
                  do while(itk.le.ntok)
                     if(  cvalue(itk).eq.'ATRE'.or.
     &                    cvalue(itk).eq.'ATIN') then
                        itk = itk + 1
                        call read_external_atom_info(ntok,nkeywords,
     &                       itk,itk_out,
     &                       ibeg,iend,ires_in,ierr,cvalue,line,
     &                       chain_in,ins_in,atom_in,alt_in,symm_in,
     &                       EndKeywords)
                        itk = itk_out
                     elseif(cvalue(itk).eq.'VDWR') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)vdw_loc
                        vdw_defined = .TRUE.
                        itk = itk + 1
                     elseif(cvalue(itk).eq.'IONR') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)vdw_loc
                        ion_defined = .TRUE.
                        itk = itk + 1
                     endif
                  enddo
c
c--   Find the atom and change vdw and ionic radii
                  if(vdw_defined.or.ion_defined) then
                     call find_atom_number(chain_in,ins_in,ires_in,
     &                    atom_in,alt_in,iatom_number,ierr)
                     if(ierr.gt.0.or.iatom_number.le.0) then
                        write(*,*)'ERROR ==> Input atom could not be'
     &                       //' found in the list of atoms'
                        write(*,*)trim(line)
                     else
                        if(vdw_defined) then
                           vdw_rad(iatom_number) = vdw_loc
                        endif
                        if(ion_defined) then
                           ion_rad(iatom_number) = ion_loc
                        endif
                     endif
                  endif
               endif
            endif
         enddo
 888     continue
      enddo
c
 999  continue
      if(lps.gt.0.and.ipsuedo.gt.0) close(ipsuedo)
      close(iscrk)
c
      if(ierr.eq.0) return

      return
      end
c
      subroutine find_atom_number(chain_in,ins_in,ires_in,
     &     atom_in,alt_in,iatom_number,ierr)
      implicit none
      include 'atom_com.fh'
c
      integer iatom_number
      integer ires_in,ierr
      character chain_in*4,atom_in*4,ins_in*1,alt_in*1
c
c---  locals
      integer jrs,ich,ir_first,ir_last,ires,ia,ia_first,ia_last
      character ins_code*1,asmgrp*4
c
c---  body
      ierr = 0
      iatom_number = -9999
      do  ich=1,n_group
         call get_asm_group_id(asmgrp,ich)
         if(chain_in.eq.asmgrp) then
            ir_first = ires_first(ich)
            ir_last  = ir_first + nres_chain(ich)-1
            do ires=ir_first,ir_last
               read(res_num_pdb(ires)(3:6),*)jrs
               ins_code = res_num_pdb(ires)(7:7)
               if(ires_in.eq.jrs.and.
     &              ins_in.eq.ins_code) then
                  ia_first = iratm_first(ires)
                  ia_last  = ia_first+natm_res(ires)-1
                  do  ia=ia_first,ia_last
                     if(atom_in.eq.atm_name(ia).and.
     &                    alt_in.eq.id_alt(ia)) then
                        iatom_number = ia
                        goto 200
                     endif
                  enddo
               endif
            enddo
         endif
      enddo
      ierr = 1
c
c--   write something that it is not in the list
 200  continue
      return
      end
c
      subroutine define_occup_groups
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'occupancy_params.fh'
c
c---  locals
      integer i,ia,ic,igr,nocc_group_now,num_c,num_o
      real occ_av
      real, allocatable :: occ_av_grp(:)
c
c---  body
      do ia=1,n_atom
         corr_id(ia) = 0
      enddo
c

      call read_occupancy_groups
c
c---Sort out remaining occupancy groups

      nocc_group_now = maxval(corr_id(1:n_atom))
      occ_grp_value(1:nocc_group_now) = 0.0
      do ia=1,n_atom
         if(corr_id(ia).gt.0) then
            igr = corr_id(ia)
            occ_grp_value(igr) = max(occ_grp_value(igr),occup(ia))
         endif
      enddo
c      occ_grp_value(1) = 0.25
c      occ_grp_value(2) = 0.75
      if(nocc_const.gt.0) then
         num_o = 0
         allocate(occ_av_grp(nocc_group_now))
         occ_av_grp(1:nocc_group_now) = 0.0
         do ic=1,nocc_const
            num_c = nocc_const_num(ic)
            occ_av = 0.0
            do i=num_o+1,num_o+num_c
               igr = c_occ(i)
               occ_av = occ_av + occ_grp_value(igr)
            enddo
            if(num_c.gt.0.and.
     &           (occ_av.gt.1.0.or.
     &           occ_av.gt.0.and.occ_const_type(ic).eq.1)) then
               do i=num_o+1,num_o+num_c
                  igr = c_occ(i)
                  occ_grp_value(igr) = occ_grp_value(igr)/occ_av
                  occ_av_grp(igr) = occ_av
               enddo
            endif
            num_o = num_o+num_c
         enddo

c
         do ia=1,n_atom
            if(corr_id(ia).gt.0) then
               igr = corr_id(ia)
               if(occ_av_grp(igr).gt.0.0) then
                  occup(ia) = occup(ia)/occ_av_grp(igr)
                  occup_mod(ia,1) = occup(ia)
               endif
            endif
         enddo
         deallocate(occ_av_grp)
      endif

      return
      end
c
      subroutine read_occupancy_groups
      use restr_files
      implicit none
      include 'atom_com.fh'
      include 'occupancy_params.fh'
c
      integer maxtok,ntok,itk,itok
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f
c
      integer ip1,ip2
      integer ia,iscrk,ierr
      integer igr,ic,ich,iocc_pos
      integer nchain_in,ires_in,ires_in2,jrs
      character atom_in*4,alt_in*1
      integer maxchain_in
      parameter (maxchain_in=100)
      character chain_in(maxchain_in)*4
      character chnnmp*4
c     
      ierr = 0
c
c---Read instructions and decide occupancy groups. 
      call open_form_file(iscrk,keywords_file,ierr)
      call parse_capital(iscrk,maxtok,ntok,key,line,ibeg,iend,itype,
     &     fvalue,cvalue,idec,lend_f,lprint)
      do  itk=2,ntok
         call ccpupc(cvalue(itk))
      enddo
      do while(lend_f.eq.0.and.key(1:3).ne.'END') 
         itk = 1
         if(ntok.ge.5.and.key.eq.'OCCU'.and.cvalue(2).eq.'GROU'.and.
     &        cvalue(3)(1:2).eq.'ID') then
            nchain_in = 0
            chain_in=' '
            atom_in = ' '
            ires_in = -10000
            ires_in2 = -10000
            alt_in = ' '
            itk = 4
            if(itype(itk).eq.2) then
               igr = nint(fvalue(itk))
               itk = itk + 1
            else
               ierr = 1
               goto 500
            endif
            do while(itk.le.ntok)
               if(cvalue(itk).eq.'CHAI') then
                  itk = itk + 1
                  do while(cvalue(itk).ne.'RESI'.and.
     &                 cvalue(itk).ne.'ATOM'.and.
     &                 cvalue(itk)(1:3).ne.'ALT'.and.
     &                 itk.le.ntok)
                     nchain_in = nchain_in + 1
                     chain_in(nchain_in)=
     &                    trim(line(ibeg(itk):iend(itk)))
                     itk = itk + 1
                  enddo
               else if(cvalue(itk).eq.'RESI') then
                  itk = itk + 1
                  if(itype(itk).eq.2) then
                     ires_in = nint(fvalue(itk))
                     itk = itk + 1
                  else
                     if(cvalue(itk).eq.'FROM') then
                        itk = itk + 1
                        if(itype(itk).eq.2) then
                           ires_in = nint(fvalue(itk))
                           itk = itk + 1
                           if(cvalue(itk)(1:2).eq.'TO') then
                              itk = itk + 1
                              if(itype(itk).eq.2) then
                                 ires_in2 = nint(fvalue(itk))
                                 itk = itk + 1
                              else
                                 ierr = 1
                              endif
                           else
                              ierr = 1
                           endif
                        else
                           ierr = 1
                        endif
                     else
                        ierr = 1
                     endif
                     if(ierr.eq.1) goto 500
                  endif
               else if(cvalue(itk).eq.'ATOM') then
                  itk = itk + 1
                  atom_in = trim(line(ibeg(itk):iend(itk)))
                  itk = itk + 1
               else if(cvalue(itk)(1:3).eq.'ALT') then
                  itk = itk + 1
                  alt_in = trim(line(ibeg(itk):iend(itk)))
                  itk = itk + 1
               else
                  ierr = 1
                  goto 500
               endif
            enddo
 100        continue
            if(nchain_in.ge.1) then
               if(ires_in2.le.-100) ires_in2=ires_in
               do ia=1,n_atom
                  call get_chain_namepdb(chnnmp,i_resid(ia))
                  read(res_num_pdb(i_resid(ia))(3:6),*)jrs
                  do ich=1,nchain_in
                     if(chnnmp.eq.chain_in(ich)) then
                        if((ires_in.le.-100.or.ires_in.le.jrs.and.
     &                       ires_in2.ge.jrs).and.
     &                       (len_trim(atom_in).eq.0.or.atom_in
     &                       .eq.atm_name(ia)).and.
     &                       (len_trim(alt_in).eq.0.or.
     &                       alt_in.eq.id_alt(ia))) then
                           corr_id(ia) = igr
                        endif
                     endif
                  enddo
               enddo
            endif
         endif
         call parse_capital(iscrk,maxtok,ntok,key,line,ibeg,iend,itype,
     &        fvalue,cvalue,idec,lend_f,lprint)
      enddo
c
c---  Group alternatives.

c
c---  Find the number of actual occupancy groups
      rewind(iscrk)
      call parse_capital(iscrk,maxtok,ntok,key,line,ibeg,iend,itype,
     &     fvalue,cvalue,idec,lend_f,lprint)
      iocc_pos = 0
      nocc_const = 0
      nocc_const_num = 0

      do while(lend_f.eq.0.and.key(1:3).ne.'END') 
         if(key.eq.'OCCU'.and.cvalue(2).eq.'GROU'.and.
     &        cvalue(3).eq.'ALTS') then
            itk = 4
            if(itk.le.ntok) then
               nocc_const = nocc_const + 1
               nocc_const_num(nocc_const) = 0
               ic = nocc_const
               occ_const_type(ic) = 1
               if(itype(itk).ne.2) then
                  if(cvalue(itk).eq.'COMP') then
                     occ_const_type(ic) = 1
                  else if(cvalue(itk).eq.'INCO') then
                     occ_const_type(ic) = 0
                  endif
                  itk = itk + 1
               endif
               do itok=itk,ntok
                  if(itype(itok).eq.2) then
                     nocc_const_num(ic) = nocc_const_num(ic) + 1
                     iocc_pos = iocc_pos + 1
                     c_occ(iocc_pos) = nint(fvalue(itok))
                  else
                     ierr = 2
                     goto 500
                  endif
               enddo
            endif
         endif
         call parse_capital(iscrk,maxtok,ntok,key,line,ibeg,iend,itype,
     &        fvalue,cvalue,idec,lend_f,lprint)
      enddo
c
c---Read other relevant parameters: E.g. do we need to refine etc

      rewind(iscrk)
      call parse_capital(iscrk,maxtok,ntok,key,line,ibeg,iend,itype,
     &     fvalue,cvalue,idec,lend_f,lprint)
      do  itk=2,ntok
         call ccpupc(cvalue(itk))
      enddo
      do while(lend_f.eq.0.and.key(1:3).ne.'END') 
         if(key.eq.'OCCU') then
            if(cvalue(2).eq.'REFI') then
               occup_refine_flag = .TRUE.
               itk = 3
               if(cvalue(itk).eq.'NCYC') then
                  itk = itk + 1
                  if(itype(itk).eq.2) then
                     ncycle_occup = nint(fvalue(itk))
                     ncycle_occup = max(1,ncycle_occup)
                     itk  = itk + 1
                  endif
               endif
c
c--Any other thing?
            endif
         endif
         call parse_capital(iscrk,maxtok,ntok,key,line,ibeg,iend,itype,
     &     fvalue,cvalue,idec,lend_f,lprint)
      enddo
c
 500  continue
c
c---  Process errors
      if(ierr.gt.0) then
         write(*,*)'Error==> Problem reading instructions for'//
     &        ' occupancy groups'
         write(*,*)'Error==> Allowed instructions are as follows:'
         write(*,*)'OCCU GROUP ID <number> CHAINS <chain1> <chain2> '//
     &        '... RESI <residue> ATOM <atom> ALT <alt>'
         write(*,*)'              or'
         write(*,*)'OCCU GROUP ID <number> CHAINS <chain1> <chain2> '//
     &        '... RESI FROM <residue> TO <residue> '//
     &        'ATOM <atom> ALT <alt>'
         write(*,*)'OCCU GROUP ALTS COMP/INCO <group1> <group2> ...'
         write(*,*)'And if occupancy refinement is required then:'
         write(*,*)'OCCU REFI ncycle <cycle>'
         call refmac_clean_up_files
         call ccperr(1,'End of Refmac')
      endif
c
      close(iscrk)
      return
      end

      subroutine parse_capital(iscrk,maxtok,ntok,key,line,ibeg,iend,
     &     itype,fvalue,cvalue,idec,lend_f,lprint)
      implicit none
      integer iscrk

      integer maxtok,ntok
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*(*),key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f

      integer itk
c
c---  body
      lprint = .FALSE.
      read(iscrk,'(a)',iostat=lend_f)line         
      ntok = maxtok
      call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &     ntok,lend,lprint)
      call ccpupc(key)
      do  itk=2,ntok
         call ccpupc(cvalue(itk))
      enddo

      return
      end
c
