c
c---set of subroutines dealing with various operation using cell and symmetry.
c
      SUBROUTINE GET_ORT2FRAC_COEFS(CELL,FRAC_XYZ)
      IMPLICIT NONE
      REAL CELL(6),FRAC_XYZ(3)
C
c---Real local arrays
      REAL ALPHA,BETA,GAMMA,COSA,SINA,COSB,SINB,COSG,SING,
     +     VOLUME
C
C---Cell dimensions are assumed to be in radians
      ALPHA = CELL(4)
      BETA  = CELL(5)
      GAMMA = CELL(6)

      COSA = COS(ALPHA)
      SINA = SIN(ALPHA)
      COSB = COS(BETA)
      SINB = SIN(BETA)
      COSG = COS(GAMMA)
      SING = SIN(GAMMA)
      VOLUME = SQRT(1.-COSA*COSA-COSB*COSB-COSG*COSG+2*COSA*COSB*COSG)
C
C----Output brick size
      FRAC_XYZ(1) = SINA/VOLUME
      FRAC_XYZ(2) = SINB/VOLUME
      FRAC_XYZ(3) = SING/VOLUME
C
      RETURN
      END
c
      subroutine calc_ort_etc(cell,frac2ort,ort2frac,ro_unit,rfr_unit)
      implicit none
c
c---  Calculate ortogonalisation and fractionalisation matrices in cell and unit
c---  units
      real cell(6)
c
c---  outputs
      real frac2ort(3,3),ort2frac(3,3),ro_unit(3,3),rfr_unit(3,3)
c
c---  locals
      integer ierror
c
c---  body
      call nb_frorth_r(cell(1),cell(2),cell(3),cell(4),
     &     cell(5),cell(6),frac2ort,ort2frac,ierror)
      call calc_unit_frac(frac2ort,cell,ro_unit)     
      call matinv3_r(ro_unit,rfr_unit)

      return
      end
c
      SUBROUTINE get_grid_spacing_r(fshann,maxsym,nsym,cell,stlmax,
     &     rot,tr,ngrid) 
      implicit none
C
c---Calculates grid spacing using CELL, resolution, symmetry and  shannon's 
c---rate
C
c---Input
      real fshann
      integer maxsym,nsym
      real stlmax
      real cell(6)
      real rot(3,3,maxsym),tr(3,maxsym)
c
c---Output
      integer ngrid(3)
c
c----locals
      INTEGER HMAX,KMAX,LMAX
      integer ngx,ngy,ngz
      integer ipx,ipy,ipz,nmfour
      real smax
      real shh,skk,sll
      real rh0max,rk0max,rl0max
c
c---
      SMAX   = STLMAX

      SHH    = 1.0/CELL(1)**2
      SKK    = 1.0/CELL(2)**2
      SLL    = 1.0/CELL(3)**2
      HMAX   = INT(CELL(1)*SMAX)
      KMAX   = INT(CELL(2)*SMAX)
      LMAX   = INT(CELL(3)*SMAX)
C
C---SZ is size for Structure factors and so on
      RH0MAX = SMAX*CELL(1)
      RK0MAX = SMAX*CELL(2)
      RL0MAX = SMAX*CELL(3)
      NGX    = INT(RH0MAX+SQRT(.25/SHH+RH0MAX**2))+1
      NGY    = INT(RK0MAX+SQRT(.25/SKK+RK0MAX**2))+1
      NGZ    = INT(RL0MAX+SQRT(.25/SLL+RL0MAX**2))+1
C
C----If number of grids were not given calculate them
      CALL ASYLIM_r(maxsym,nsym,rot,tr,IPX,IPY,IPZ,NMFOUR)
      ngrid(1) = INT(NGX*FSHANN)
      ngrid(2) = INT(NGY*FSHANN)
      ngrid(3) = INT(NGZ*FSHANN)
C
C---Now find best numbers
      CALL NXYZ235(ngrid(1),NMFOUR)
      CALL NXYZ235(ngrid(2),NMFOUR)
      CALL NXYZ235(ngrid(3),NMFOUR)
      RETURN
      END
c
      subroutine calc_unit_frac(frac2ort,cell,frac2ort_unit)
      implicit none
      real frac2ort(3,3)
      real cell(6)
      real frac2ort_unit(3,3)
c
c---calcuates unit fractionalisation matrix using frctionalisation matrix
c---and the unit cell 

      frac2ort_unit(1,1) = frac2ort(1,1)/cell(1)
      frac2ort_unit(1,2) = frac2ort(1,2)/cell(2)
      frac2ort_unit(1,3) = frac2ort(1,3)/cell(3)
      frac2ort_unit(2,2) = frac2ort(2,2)/cell(2)
      frac2ort_unit(2,3) = frac2ort(2,3)/cell(3)
      frac2ort_unit(3,3) = frac2ort(3,3)/cell(3)
      frac2ort_unit(2,1) = 0.0
      frac2ort_unit(3,1) = 0.0
      frac2ort_unit(3,2) = 0.0 
      return
      end
c
      subroutine calc_cosa_etal(cell,cosa,cosb,cosg,sina,sinb,sing)
      implicit none
c
c---calculates cos(alpha) and others. Simple enough subroutine
c
      real cell(6)
      real cosa,cosb,cosg,sina,sinb,sing

      cosa = cos(cell(4))
      sina = sin(cell(4))
      cosb = cos(cell(5))
      sinb = sin(cell(5))
      cosg = cos(cell(6))
      sing = sin(cell(6))

      return
      end
c
      subroutine asymlim_frac_r(cell,maxsym,nsym,rot,tr,d1,
     &     xyzlow,xyzupper)
      implicit none
c
c--Using symmetry and radius of atoms find extensions to asymmetric unit
c
c
c---inputs
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      real d1
c
c---output
      real xyzlow(3),xyzupper(3)
c
c--locals
      real twopi
      real dlm
      real v
      real cosa(3),sina(3)
      integer ipxyz(3)
      integer nmfour
      integer i
c
      call calc_cosa_etal(cell,cosa(1),cosa(2),cosa(3),sina(1),sina(2),
     &     sina(3))
      call asylim_r(maxsym,nsym,rot,tr,ipxyz(1),ipxyz(2),ipxyz(3),
     &    nmfour)

      v = sqrt(1-cosa(1)**2+cosa(2)**2-cosa(3)**2+
     &     2.0*cosa(1)*cosa(2)*cosa(3))
      twopi = 8.0*atan2(1.0,1.0)
      dlm = sqrt(60.0*d1)/twopi
      do  i=1,3
        xyzlow(i) =                    -dlm*sina(i)/(v*cell(i))
        xyzupper(i) = (cell(i)/ipxyz(i)+dlm*sina(i)/v)/cell(i)
      enddo
      
      return
      end
c
      subroutine take_noncub(maxsym,nsym,nsym_non,rot,tr,
     &     rot_non,tr_non)
      implicit none
c
c--finds number of non cubic symmetries. In a way it finds number of symmeties
c--for which z is transformed to z only.
c
c---inputs
      integer maxsym
      integer nsym
      real rot(3,3,maxsym),tr(3,maxsym)
c
c---outputs
      integer nsym_non
      real rot_non(3,3,maxsym),tr_non(3,maxsym)
c
c---locals
      integer is,i,j
      real eps_loc
      data eps_loc/1.0E-6/
      
      nsym_non = 0
      do  is=1,nsym
        if(abs(rot(3,3,is)).gt.1.0-eps_loc.and.
     &        abs(rot(3,1,is)).le.eps_loc.and.
     &        abs(rot(3,2,is)).le.eps_loc) then
           nsym_non = nsym_non + 1
           do  i=1,3
              do  j=1,3
                 rot_non(i,j,nsym_non) = rot(i,j,is)
              enddo
              tr_non(i,nsym_non) = tr(i,is)
           enddo
        endif
      enddo
      return
      end
C
      subroutine asylim_r(maxsym,nsym,rot,tr,ipx,ipy,ipz,nmfour)
c
      implicit none
      integer maxsym,nsym
      integer nmfour
      integer ipx,ipy,ipz
      real rot(3,3,maxsym),tr(3,maxsym)
c
c--This routine finds limits of asymmetric unit using symmetry operators
c--It finds minimum box along z.
c--It also find multiplicity of grid using symmetry operators
c
      integer factor
      integer i,j,is
      real trmin
      integer maxsym_l
      parameter (maxsym_l = 192)
      integer orders(maxsym_l)
      real tr_loc(3,maxsym_l)
      real rot_loc(3,3),rot_loc1(3,3)
      real eps_loc
      real psi,phi,chi
c
      eps_loc = 1.0e-4
      do  is=1,nsym
        do  i=1,3
          tr_loc(i,is) = tr(i,is)
          do while(tr_loc(i,is).gt.1.0+eps_loc)
             tr_loc(i,is) = tr_loc(i,is)-1.0
          enddo
          do while(tr_loc(i,is).lt.-eps_loc)
             tr_loc(i,is) = tr_loc(i,is) + 1.0
          enddo
        enddo
      enddo
c
c--Find symmetry operators where z does not change its sign.
c
      factor = 1
      trmin = 1.0
      do   is=1,nsym
        if(abs(nint(rot(3,3,is))).eq.1.and.nint(rot(3,2,is)).eq.0.and.
     &         nint(rot(3,1,is)).eq.0) then
c
c--It is a non cube symmetry. Analyse it
          if(nint(rot(3,3,is)).le.1.0.and.
     &          abs(tr(3,is)).gt.eps_loc)then
            trmin = min(trmin,tr_loc(3,is))
          endif
          if(nint(rot(3,3,is)).eq.-1.0.and.
     &             abs(tr_loc(3,is)).le.eps_loc) then
            factor = 2
          endif
        endif
      enddo
c
      ipx = 1
      ipy = 1
      ipz = factor*nint(1/trmin)
C
C--Find multiplicity. First find the order of all symmetry operators
c
      nmfour = 2
      do  is=1,nsym
        if(abs(nint(rot(3,3,is))).eq.1.and.
     &         nint(rot(3,2,is)).eq.0.and.
     &         nint(rot(3,1,is)).eq.0) then
          call polar(rot(1,1,is),psi,phi,chi)
          do while(chi.ge.360.0+eps_loc)
            chi = chi - 360.0
          enddo
          do while(chi.le.eps_loc) 
            chi = chi + 360.0
          enddo
          if(chi.le.180.0+eps_loc) then
            orders(is) = nint(360.0/chi)
          else
            orders(is) = 1
          endif
        else
          orders(is) = 1
        endif
      enddo
      do  is=1,nsym
        if(orders(is).eq.6) then
          nmfour = 6
          goto 10
        endif
      enddo
      do  is=1,nsym
        if(orders(is).eq.4) then
          nmfour = 4
          goto 5
        endif
      enddo
 5    continue
      do  is=1,nsym
        if(orders(is).eq.3) then
          nmfour = nmfour*3
          goto 10
        endif
      enddo
 10   continue
      nmfour = max(nmfour,ipz)
c     
      return
      end
c
      SUBROUTINE NXYZ235(NX,NM)
      IMPLICIT NONE
      INTEGER NX,NM
c
c-----This subroutine changes NX so that NM becames multiplier of NX
c-----and other multipliers are 2,3,5 and returns new value of NX 
c----Make sure NM is multiplier of NX
      INTEGER N1
      INTEGER IPR,NPR
      INTEGER PRIMES(3)
cd      DATA PRIMES/2,3,5,7,11,13,17,19/
      DATA PRIMES/2,3,5/
      DATA NPR/3/

      IF(MOD(NX,NM).NE.0) NX = NX-MOD(NX,NM)+NM
1     CONTINUE
      N1 = NX/NM
2     CONTINUE
c
c-----Chek if 2,3,5 is multiplier of NX if there is another multiplier then
c-----change NX and check again
c
      IF(N1.EQ.1)RETURN
      DO  IPR=1,NPR
         IF(MOD(N1,PRIMES(IPR)).EQ.0) THEN
             N1 = N1/PRIMES(IPR)
             GOTO 2
         ENDIF
      ENDDO
      NX = NX + NM
      GOTO 1
      END 
c
      subroutine calc_epsls_centrs(nasym,maxsym,nsym,rot,hkl,epsls,
     &     centrs)
      implicit none
c
c---inputs
      integer nasym,maxsym,nsym
      integer hkl(3,nasym)
      real rot(3,3,maxsym)
c
c---outputs
      real epsls(nasym),centrs(nasym)
c
c--locals
      integer i,isysab,icent
      real eps1
      integer maxsym_l
      integer irot(3,3,192)
c
c---body
      maxsym_l = 192
      irot(1:3,1:3,1:nsym) = nint(rot(1:3,1:3,1:nsym))
      do  i=1,nasym
         call geneps_centr(hkl(1,i),maxsym_l,nsym,irot,epsls(i),icent)
         centrs(i) = real(icent)
      enddo
      return
      end
c
      subroutine geneps_centr(hkl,maxsym,nsym,irot,eps1,icent)
      implicit none
c
c--   generate epsilon and centrosymmetricity for a given hkl
      integer maxsym,nsym
      integer hkl(3),irot(3,3,maxsym)
c
c--   outputs
      real eps1
      integer icent
c
c--   locals
      integer is
      integer h0(3),h1(3),h2(3)
      logical error
c
c---  body
      eps1 = 1.0
      icent = 0
      if(nsym.gt.1) then
         call imat2vect(3,3,irot(1,1,1),hkl,h0,error)
         do   is=2,nsym
            call imat2vect(3,3,irot(1,1,is),hkl,h1,error)
            if(h0(1).eq.h1(1).and.h0(2).eq.h1(2).and.
     &           h0(3).eq.h1(3)) eps1=eps1+1.0
            h2(1:3) = h0(1:3) + h1(1:3)
            if(h2(1).eq.0.and.h2(2).eq.0.and.h2(3).eq.0) then
               icent = 1
            endif
         enddo
      endif
      return
      end
c
      subroutine define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      implicit none
      real cell(6)
      real ast,bst,cst,cosast,cosbst,coscst
C
C---Cell angles must be in radians
      real vol,volunit
      real cosa,cosb,cosc,sina,sinb,sinc

      cosa = cos(cell(4))
      cosb = cos(cell(5))
      cosc = cos(cell(6))
      sina = sin(cell(4))
      sinb = sin(cell(5))
      sinc = sin(cell(6))
      volunit = sqrt(1.0-cosa**2-cosb**2-cosc**2+2.0*cosa*cosb*cosc)
      vol = cell(1)*cell(2)*cell(3)*volunit
      ast = cell(2)*cell(3)*sina/vol
      bst = cell(1)*cell(3)*sinb/vol
      cst = cell(1)*cell(2)*sinc/vol
      cosast = (cosb*cosc-cosa)/(sinb*sinc)
      cosbst = (cosa*cosc-cosb)/(sina*sinc)
      coscst = (cosa*cosb-cosc)/(sina*sinb)
      return
      end
C
      subroutine define_res(h,k,l,ast,bst,cst,cosast,cosbst,coscst,rsq)
      implicit none
      integer h,k,l
      real ast,bst,cst,cosast,cosbst,coscst
      real rsq

      rsq = h*ast*(h*ast+2.0*(k*bst*coscst+l*cst*cosbst)) +
     &      k*bst*(k*bst+2.0*l*cst*cosast) + 
     &      l*l*cst*cst

      return
      end
C
      subroutine sysabs_symm_r(maxsym,nsym,rot,tr,h,k,l,isysabs)
      implicit none
      integer isysabs
      integer h,k,l
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
C
      integer hnew,knew,lnew
      integer is
      real del
C
      isysabs = 1
      do  is = 1,nsym
        hnew = nint(h*rot(1,1,is) + k*rot(2,1,is) + l*rot(3,1,is))
        if(hnew.ne.h) goto 200
        knew = nint(h*rot(1,2,is) + k*rot(2,2,is) + l*rot(3,2,is))
        if(knew.ne.k) goto 200
        lnew = nint(h*rot(1,3,is) + k*rot(2,3,is) + l*rot(3,3,is))
        if(lnew.ne.l) goto 200
        del = h*tr(1,is) + k*tr(2,is) + l*tr(3,is)
        if(abs(del-float(nint(del))).gt.0.05) return
 200  continue
      enddo

      isysabs = 0
      return
      end
c
      subroutine symm2int_by12_1(maxsym,nsym,sym_in,trans_in,
     &  sym_out,trans_out)
C
C---Converts rotation and translation operator to integer after
C---multiplying by 12
C
      implicit none
      integer maxsym,nsym
      real sym_in(3,3,maxsym),trans_in(3,maxsym)
      integer sym_out(3,3,maxsym),trans_out(3,maxsym)
C
      integer i,j,is
C
      do   is=1,nsym
         do  i=1,3
           do  j=1,3
              sym_out(i,j,is) = nint(sym_in(i,j,is))
           enddo
           trans_out(i,is) = nint(trans_in(i,is)*12.0)
         enddo
      enddo
      return
      end
c
      SUBROUTINE SYM_FIND_r0(MAXSYM_IN,NumSymmetry,RealSymmMatrx,ISYM1,
     +                   ISYM2,ITX1,ISYM_OUT,ITX_OUT,FIRST)
C
      IMPLICIT NONE
cd      INCLUDE 'celsym.fh'
Cc
c----This routine prepares table for inversion and multiplaction of
C----symmetry matrices. Idea is that symmetry is group. So inversion
C----and multiplicaion of two elements should belong to that group also.
C----complication arises when translation is involved. In this case
C----I don't know how to tabulate (yet). At the moment routine could be used
C----for multiplication of inversion of one symmetry operator with 
C----another symmetry operator. It could easily be extended to finding
C----inversion or multiplication of symmetry operators also.
C
C----If symmetry is (R1,T1) then its inversion is (R2,T2) Where R2 is
C----symmetry operator and T2 is -R1^(-1) T2. In last operation translational
C----part of symmetry has been removed
c
c----If R1,T1 and R2,T2 are symmetry operators then multiplication of them
C----is R3,T3, Where R3 is one of symmetry operators and T3 = R1 T2 + T1
C----In all cases care should be taken in cases of screw axis
C
c----Integer arguments
      INTEGER MAXSYM_IN,NumSymmetry
      REAL    RealSymmMatrx(4,4,MAXSYM_IN)

      INTEGER MAXSYM
      PARAMETER (MAXSYM = 192)
      INTEGER ISYM1,ISYM2,ITX1(3),ISYM_OUT,ITX_OUT(3)

      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM),
     +        SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM),
     +        IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_LOCAL(3,3,MAXSYM),TRANS_LOCAL(3,MAXSYM),
     +     SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3),TR_OUT(3)
      REAL EPS_LOCAL

      LOGICAL ERROR
      INTEGER FIRST,I,J,ISYM_INV_OUT,IS,IS1,IS2,ITTX,ITTY,ITTZ
      REAL    TTX,TTY,TTZ,DELTA,DELTA1
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      DATA EPS_LOCAL/1.0E-3/
      SAVE   /SYMM_INV/


      IF(FIRST.EQ.0) THEN
        FIRST = 1
        DO   IS=1,NumSymmetry
          DO   J=1,3
            DO   I=1,3
              SYMM_LOCAL(I,J,IS) = RealSymmMatrx(I,J,IS)
            ENDDO
            TRANS_LOCAL(J,IS) = RealSymmMatrx(J,4,IS)
          ENDDO
        ENDDO
        DO    IS=1,NumSymmetry
           CALL MATINV3_R(SYMM_LOCAL(1,1,IS),SYMM_INVERS(1,1,IS))
           CALL MAT2VEC(3,3,SYMM_INVERS(1,1,IS),TRANS_LOCAL(1,IS),
     +                  TRANS_OUT,ERROR)
          DO   I=1,3
             TRANS_OUT(I) = -TRANS_OUT(I)
          ENDDO
          
          IF(ERROR) then
             write(*,*)'In SYM_FIND after calling MATINV3'
             stop
          endif
          DO   IS1=1,NumSymmetry
            DELTA = 0.0
            DO   J=1,3
              DO   I=1,3
                DELTA = DELTA + 
     +              ABS(SYMM_INVERS(I,J,IS)-SYMM_LOCAL(I,J,IS1))
              ENDDO
            ENDDO
            IF(DELTA.LT.EPS_LOCAL) THEN
              DELTA1 = 0.0
              TTX     = TRANS_OUT(1)-TRANS_LOCAL(1,IS1)
              ITTX    = NINT(TTX)
              DELTA1  = ABS(TTX-FLOAT(ITTX))
              TTY     = TRANS_OUT(2)-TRANS_LOCAL(2,IS1)
              ITTY    = NINT(TTY)
              DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
              TTZ     = TRANS_OUT(3)-TRANS_LOCAL(3,IS1)
              ITTZ    = NINT(TTZ)
              DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
              IF(DELTA1.LT.EPS_LOCAL) THEN
                ISYM_INV(IS)     = IS1
                ITRANS_INV(1,IS) = ITTX
                ITRANS_INV(2,IS) = ITTY
                ITRANS_INV(3,IS) = ITTZ
                GOTO 10
              ENDIF
            ENDIF
          ENDDO
 10       CONTINUE
          DO   IS1=1,NumSymmetry
            CALL MAT2MAT(3,3,SYMM_LOCAL(1,1,IS),SYMM_LOCAL(1,1,IS1),
     +           SYMM_OUT,ERROR)
            CALL MAT2VEC(3,3,SYMM_LOCAL(1,1,IS),TRANS_LOCAL(1,IS1),
     +           TRANS_OUT,ERROR)
            DO   I=1,3
              TRANS_OUT(I) = TRANS_OUT(I) + TRANS_LOCAL(I,IS)
            ENDDO
            DO   IS2=1,NumSymmetry
              DELTA = 0.0
              DO   J=1,3
                DO   I=1,3
                  DELTA = DELTA + ABS(SYMM_OUT(I,J)-SYMM_LOCAL(I,J,IS2))
                ENDDO
              ENDDO
              IF(DELTA.LT.EPS_LOCAL) THEN
                DELTA1 = 0.0
                TTX     = TRANS_OUT(1)-TRANS_LOCAL(1,IS2)
                ITTX    = NINT(TTX)
                DELTA1  = ABS(TTX-FLOAT(ITTX))
                TTY     = TRANS_OUT(2)-TRANS_LOCAL(2,IS2)
                ITTY    = NINT(TTY)
                DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
                TTZ     = TRANS_OUT(3)-TRANS_LOCAL(3,IS2)
                ITTZ    = NINT(TTZ)
                DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
                IF(DELTA1.LT.EPS_LOCAL) THEN
                  SYMM_MULT(IS,IS1)         = IS2
                  SYMM_MULT_TRANS(1,IS,IS1) = ITTX
                  SYMM_MULT_TRANS(2,IS,IS1) = ITTY
                  SYMM_MULT_TRANS(3,IS,IS1) = ITTZ
                  GOTO 20
                ENDIF
              ENDIF     
            ENDDO
 20         CONTINUE
          ENDDO
        ENDDO
      ENDIF
C
C---find multiplicatation of inverse of symmetry with symmetry.
C---If symmetr is (R,T) then (R1,T1)^1 (R2,T2) = (R3,T3). 
C---Where T3 = R1^1(T2-T1)
C
C---First find Inversion matrix
      IF(ISYM1.EQ.ISYM2.AND.ITX1(1).EQ.0.AND.
     +                      ITX1(2).EQ.0.AND.
     +                      ITX1(3).EQ.0) THEN
         ISYM_OUT   = SYMM_MULT(ISYM_INV(ISYM1),ISYM2)
         ITX_OUT(1) = 0
         ITX_OUT(2) = 0
         ITX_OUT(3) = 0
         RETURN
      ENDIF
      ISYM_INV_OUT = ISYM_INV(ISYM1)

      DO    I = 1,3
        IS_TRANS(I) = ITRANS_INV(I,ISYM1)
      ENDDO
C
c---Inverse of symmetry sym1 is ISYM_INV_OUT and corresponding translation
C---is IS_TRANS
c
c---Multiply ISYM_INV_OUT to ISYM2
      ISYM_OUT = SYMM_MULT(ISYM_INV_OUT,ISYM2)
      DO    I=1,3
        IS_TRANS2(I) = SYMM_MULT_TRANS(I,ISYM_INV_OUT,ISYM2)
      ENDDO
C
c---Now find translations
      DO   I=1,3
        TR_OUT(I) = FLOAT(IS_TRANS(I) + IS_TRANS2(I))
        DO   J=1,3
           TR_OUT(I) = TR_OUT(I) + RealSymmMatrx(I,J,ISYM_INV_OUT)*
     +         FLOAT(ITX1(J)) 
         ENDDO
         ITX_OUT(I) = NINT(TR_OUT(I))
         IF(ABS(FLOAT(ITX_OUT(I))-TR_OUT(I)).GT.EPS_LOCAL) THEN
           WRITE(*,*)'ISYM1',ISYM1,ISYM2,ISYM_OUT
           WRITE(*,*)ITX1
           WRITE(*,*)TR_OUT  
           write(*,*)'Problems in SYMM_FIND'
           stop
         ENDIF
      ENDDO
      RETURN
      END
c
      SUBROUTINE SYM_FIND_r(MAXSYM_in,nsym,rot,tr,ISYM1,
     +                   ISYM2,ITX1,ISYM_OUT,ITX_OUT,FIRST)
C
      IMPLICIT NONE
cd      INCLUDE 'celsym.fh'
Cc
c----This routine prepares table for inversion and multiplaction of
C----symmetry matrices. Idea is that symmetry is group. So inversion
C----and multiplicaion of two elements should belong to that group also.
C----complication arises when translation is involved. In this case
C----I don't know how to tabulate (yet). At the moment routine could be used
C----for multiplication of inversion of one symmetry operator with 
C----another symmetry operator. It could easily be extended to finding
C----inversion or multiplication of symmetry operators also.
C
C----If symmetry is (R1,T1) then its inversion is (R2,T2) Where R2 is
C----symmetry operator and T2 is -R1^(-1) T2. In last operation translational
C----part of symmetry has been removed
c
c----If R1,T1 and R2,T2 are symmetry operators then multiplication of them
C----is R3,T3, Where R3 is one of symmetry operators and T3 = R1 T2 + T1
C----In all cases care should be taken in cases of screw axis
C
c----Integer arguments
      INTEGER maxsym_in,nsym
      REAL    rot(3,3,maxsym_in),tr(3,maxsym_in)

      INTEGER MAXSYM
      PARAMETER (MAXSYM = 192)
      INTEGER ISYM1,ISYM2,ITX1(3),ISYM_OUT,ITX_OUT(3)

      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM),
     +        SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM),
     +        IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3),TR_OUT(3)
      REAL EPS_LOCAL

      LOGICAL ERROR
      INTEGER FIRST,I,J,ISYM_INV_OUT,IS,IS1,IS2,ITTX,ITTY,ITTZ
      REAL    TTX,TTY,TTZ,DELTA,DELTA1
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      DATA EPS_LOCAL/1.0E-3/
      SAVE   /SYMM_INV/


      if(FIRST.EQ.0) then
        FIRST = 1
        call tabulate_symm_inv_mult_r(maxsym,nsym,rot,tr,
     &       symm_invers,symm_mult,itrans_inv,symm_mult_trans,isym_inv)
      endif
C     
C---find multiplicatation of inverse of symmetry with symmetry.
C---If symmetr is (R,T) then (R1,T1)^1 (R2,T2) = (R3,T3). 
C---Where T3 = R1^1(T2-T1)
C
C---First find Inversion matrix
      IF(ISYM1.EQ.ISYM2.AND.ITX1(1).EQ.0.AND.
     +                      ITX1(2).EQ.0.AND.
     +                      ITX1(3).EQ.0) THEN
         ISYM_OUT   = SYMM_MULT(ISYM_INV(ISYM1),ISYM2)
         ITX_OUT(1) = 0
         ITX_OUT(2) = 0
         ITX_OUT(3) = 0
         RETURN
      ENDIF
      ISYM_INV_OUT = ISYM_INV(ISYM1)

      is_trans(1:3) = itrans_inv(1:3,isym1)

C
c---Inverse of symmetry sym1 is ISYM_INV_OUT and corresponding translation
C---is IS_TRANS
c
c---Multiply ISYM_INV_OUT to ISYM2
      ISYM_OUT = SYMM_MULT(ISYM_INV_OUT,ISYM2)
      is_trans2(1:3) = symm_mult_trans(1:3,isym_inv_out,isym2)
C
c---Now find translations
      DO   I=1,3
        TR_OUT(I) = FLOAT(IS_TRANS(I) + IS_TRANS2(I))
        DO   J=1,3
           TR_OUT(I) = TR_OUT(I) + rot(I,J,ISYM_INV_OUT)*
     +         FLOAT(ITX1(J)) 
         ENDDO
         ITX_OUT(I) = NINT(TR_OUT(I))
         IF(ABS(FLOAT(ITX_OUT(I))-TR_OUT(I)).GT.EPS_LOCAL) THEN
           WRITE(*,*)'ISYM1',ISYM1,ISYM2,ISYM_OUT
           WRITE(*,*)ITX1
           WRITE(*,*)TR_OUT  
           write(*,*)'Problems in SYMM_FIND'
           stop
         ENDIF
      ENDDO
      RETURN
      END
c
      subroutine symm_mult_r(maxsym_in,nsym,rot,tr,isym1,isym2,
     &     isym_o,ifirst,ierr)
      implicit none
      integer maxsym_in, nsym,ifirst
      real rot(3,3,maxsym_in),tr(3,maxsym_in)
      integer isym1(4),isym2(4),isym_o(4)
      integer ierr
c

      real eps_local
      real tr_out(3)
      integer itx_out(3)
c
      integer i
c
      integer maxsym
      parameter (maxsym=192)
      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM)
      integer SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM)
      integer IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3)
      logical error
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      data eps_local/1.0e-3/
      SAVE   /SYMM_INV/
c
c---  body
      if(ifirst.eq.0) then
         ifirst = 1
         call tabulate_symm_inv_mult_r(maxsym_in,nsym,rot,tr,
     &     symm_invers,symm_mult,itrans_inv,symm_mult_trans,isym_inv)
      endif
c
c---  Now use the multiplication table to find the necessary symmetry
c---  operator
      isym_o(1) = symm_mult(isym1(1),isym2(1))
c
c---  Now find translations
      isym_o(2:4) = symm_mult_trans(1:3,isym1(1),isym2(1))+isym1(2:4)
      call mat2vec(3,3,rot(1,1,isym1(1)),float(isym2(2:4)),tr_out,error)
      itx_out(1:3) = nint(tr_out(1:3))
      if(maxval(abs(itx_out(1:3)-tr_out(1:3))).gt.eps_local) then
         write(*,*)isym1
         write(*,*)itx_out,tr_out
         write(*,*)'Problem in symmetry multiplication'
         ierr = 1
         return
      endif
      isym_o(2:4) = isym_o(2:4) + itx_out(1:3)
      return
      end
c
      subroutine symm_inv_r(maxsym_in,nsym,rot,tr,isymin,isymout,
     &     ifirst,ierr)
      implicit none
      integer ifirst
      integer maxsym_in,nsym
      real rot(3,3,maxsym_in),tr(3,maxsym_in)
      integer isymin(4),isymout(4)
      integer ierr
c
      real tr_out(3)
c
      logical error
      real eps_local
      integer maxsym
      parameter (maxsym=192)
      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM),
     +        SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM),
     +        IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3)
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      data eps_local/1.0e-3/
      SAVE   /SYMM_INV/

      if(ifirst.eq.0) then
         ifirst = 1
         call tabulate_symm_inv_mult_r(maxsym_in,nsym,rot,tr,
     &     symm_invers,symm_mult,itrans_inv,symm_mult_trans,isym_inv)

      endif
c
c---  Use inversion table to the corresponding symmetry
      isymout(1) = isym_inv(isymin(1))
c
c--Take care of translation
      call mat2vec(3,3,rot(1,1,isymout(1)),
     &     float(isymin(2:4)),tr_out,error)
      isymout(2:4) = nint(tr_out(1:3))
      if(maxval(abs(float(isymout(2:4))-tr_out(1:3))).gt.eps_local) then
         write(*,*)'Problem in symmetry inversion'
         ierr = 1
         return
      endif
      isymout(2:4)=itrans_inv(1:3,isymin(1))+isymout(2:4)
      return
      end
c
      subroutine tabulate_symm_inv_mult_r(maxsym_in,nsym,rot,tr,
     &     symm_invers,symm_mult,itrans_inv,symm_mult_trans,isym_inv)
      implicit none
c
      integer maxsym_in,nsym
      real rot(3,3,maxsym_in),tr(3,maxsym_in)
      integer isym_inv(maxsym_in),itrans_inv(3,maxsym_in)
      integer symm_mult(maxsym_in,maxsym_in)
      integer symm_mult_trans(3,maxsym_in,maxsym_in)
      real symm_invers(3,3,maxsym_in)
c
      integer maxsym
      parameter (maxsym=192)
      INTEGER IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_OUT(3,3),TRANS_OUT(3),TR_OUT(3)
     
      LOGICAL ERROR
      INTEGER FIRST,I,J,ISYM_INV_OUT,IS,IS1,IS2,ITTX,ITTY,ITTZ
      REAL    TTX,TTY,TTZ,DELTA,DELTA1
c
      real eps_local
      data eps_local/1.0e-3/
c
c---  body
      DO    IS=1,nsym
         CALL MATINV3_R(rot(1,1,IS),SYMM_INVERS(1,1,IS))
         CALL MAT2VEC(3,3,SYMM_INVERS(1,1,IS),tr(1,IS),
     &        TRANS_OUT,ERROR)
         trans_out(1:3) = -trans_out(1:3)         
         IF(ERROR) then
            write(*,*)'In SYM_FIND after calling MATINV3'
            stop
         endif
         DO   IS1=1,nsym
            delta = sum(abs(symm_invers(1:3,1:3,is)-rot(1:3,1:3,is1)))
            IF(DELTA.LT.EPS_LOCAL) THEN
               DELTA1 = 0.0
               TTX     = TRANS_OUT(1)-TR(1,IS1)
               ITTX    = NINT(TTX)
               DELTA1  = ABS(TTX-FLOAT(ITTX))
               TTY     = TRANS_OUT(2)-TR(2,IS1)
               ITTY    = NINT(TTY)
               DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
               TTZ     = TRANS_OUT(3)-TR(3,IS1)
               ITTZ    = NINT(TTZ)
               DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
               IF(DELTA1.LT.EPS_LOCAL) THEN
                  ISYM_INV(IS)     = IS1
                  ITRANS_INV(1,IS) = ITTX
                  ITRANS_INV(2,IS) = ITTY
                  ITRANS_INV(3,IS) = ITTZ
                  GOTO 10
               ENDIF
            ENDIF
         ENDDO
 10      CONTINUE
         DO   IS1=1,nsym
            CALL MAT2MAT(3,3,rot(1,1,IS),rot(1,1,IS1),
     +           SYMM_OUT,ERROR)
            CALL MAT2VEC(3,3,ROT(1,1,IS),TR(1,IS1),
     +           TRANS_OUT,ERROR)
            trans_out(1:3) = trans_out(1:3)+tr(1:3,is)
            DO   IS2=1,nsym
               delta = sum(abs(symm_out(1:3,1:3)-rot(1:3,1:3,is2)))
               IF(DELTA.LT.EPS_LOCAL) THEN
                  DELTA1 = 0.0
                  TTX     = TRANS_OUT(1)-TR(1,IS2)
                  ITTX    = NINT(TTX)
                  DELTA1  = ABS(TTX-FLOAT(ITTX))
                  TTY     = TRANS_OUT(2)-TR(2,IS2)
                  ITTY    = NINT(TTY)
                  DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
                  TTZ     = TRANS_OUT(3)-TR(3,IS2)
                  ITTZ    = NINT(TTZ)
                  DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
                  IF(DELTA1.LT.EPS_LOCAL) THEN
                     SYMM_MULT(IS,IS1)         = IS2
                     SYMM_MULT_TRANS(1,IS,IS1) = ITTX
                     SYMM_MULT_TRANS(2,IS,IS1) = ITTY
                     SYMM_MULT_TRANS(3,IS,IS1) = ITTZ
                     GOTO 20
                  ENDIF
               ENDIF     
            ENDDO
 20         CONTINUE
         ENDDO
      ENDDO
      
      return
      end
c
      subroutine get_symm_from_text(text_in,rot_out,trans_out,ierr)
      implicit none
c
c--Extract symmetry operators from text
      integer ierr
      character text_in*(*)
      real rot_out(3,3)
      real trans_out(3)
c
c---  locals
      integer i,j,l,il,i0,j0
      character text_line(3)*128
c
c---  body
      ierr = 0
      call ccpupc(text_in)
      l=len_trim(text_in)
      il = 0
      i0 = 1
      do i=1,l
         if(text_in(i:i).eq.','.or.text_in(i:i).eq.';'.or.
     &        text_in(i:i).eq.':') then
            il = il + 1
            text_line(il) = text_in(i0:(i-1))
            i0 = i+1
         endif
      enddo
      if(il.ne.3) then
         ierr = 1
         write(*,*)'Problem in get_symm_from_text'
         goto 999
      endif
      rot_out(1:3,1:3) = 0.0
      trans_out(1:3) = 0.0
      do i=1,3
         j0=1
         l = len_trim(text_line(il))
         do j=1,l
            if(text_line(il)(j:j).eq.'*')text_line(il) = ' '
         enddo
         j0=1
         do j=1,l
            if(text_line(il)(j:j).ne.' ') then
               text_line(il)(j0:j0) = text_line(il)(j:j)
               j0 = j0 + 1
            endif
         enddo
         text_line(il)(j0+1:l) = ' '
         l = len_trim(text_line(il))
         j0 = 1
         do j=1,l
            if(text_line(il)(j:j).eq.'H') then
               if(j.eq.1) then
                  rot_out(1,i) = 1.0
               else
                  if(text_line(il)(j-1:j-1).eq.'+') then
                     rot_out(1,i) = 1.0
                  elseif(text_line(il)(j-1:j-1).eq.'-') then
                     rot_out(1,i) = -1.0
                  else
                     read(text_line(il)(j0:j-1),*)rot_out(1,i)
                  endif
               endif
               j0 = j + 1
            else if(text_line(il)(j:j).eq.'K') then
               if(j.eq.1) then
                  rot_out(2,i) = 1.0
               else
                  if(text_line(il)(j-1:j-1).eq.'+') then
                     rot_out(2,i) = 1.0
                  elseif(text_line(il)(j-1:j-1).eq.'-') then
                     rot_out(2,i) = -1.0
                  else
                     read(text_line(il)(j0:j-1),*)rot_out(2,i)
                  endif
               endif
               j0 = j + 1
            else if(text_line(il)(j:j).eq.'L') then
               if(j.eq.1) then
                  rot_out(3,i) = 1.0
               else
                  if(text_line(il)(j-1:j-1).eq.'+') then
                     rot_out(3,i) = 1.0
                  elseif(text_line(il)(j-1:j-1).eq.'-') then
                     rot_out(3,i) = -1.0
                  else
                     read(text_line(il)(j0:j-1),*)rot_out(3,i)
                  endif
               endif
               j0 = j + 1
            endif
         enddo
         if(j0.lt.l) then
            read(text_line(il)(j0:l),*)trans_out(i)
         endif
      enddo
 999  continue
      return
      end
c
      subroutine put_symm_to_text(rot,tr,text_out)
      implicit none
      real rot(3,3),tr(3)
      character text_out*(*)
c
      real eps,tmp,tmp1
      integer i,j,ip,it,k
      character s1*1
      character xyz_c(3)*1,cht*10,cht1*10,cht2*10
      data xyz_c/'H','K','L'/
c
c---  body
      eps = 0.1e-3
      text_out = ' '
      ip = 1
      it = 1
      do i=1,3
         do j=1,3
            if(abs(rot(j,i)).gt.eps) then
               s1 = '-'
               if(rot(j,i).gt.0.0) s1 = '+'
               if(s1.eq.'+'.and.it.eq.1) s1 = ' '
               if(abs(abs(rot(j,i))-1.0).gt.eps) then
                  write(cht,'(f5.3)')rot(j,i)
                  tmp = abs(rot(j,i))
                  do k=2,24
                     tmp1 = tmp*k
                     if(abs(nint(tmp1)-tmp1).lt.eps) then
c                        write(*,*)rot(j,i),
                        write(cht1,'(i2)')nint(tmp1)
                        write(cht2,'(i2)')k
                        cht = trim(adjustl(cht1))//'/'//
     &                       trim(adjustl(cht2))
                        exit
                     endif
                  enddo
                  write(text_out(ip:(ip+7)),'(a1,a,a1)')
     &                 s1,trim(adjustl(cht)),xyz_c(j)
                  ip = len_trim(text_out)+1
               else
                  write(text_out(ip:(ip+1)),'(a1,a1)')s1,xyz_c(j)
                  ip = len_trim(text_out)+1
               endif
               it = 2
            endif
         enddo

         if(abs(tr(i)).gt.eps) then

            s1 = '-'
            if(tr(i).gt.0.0) s1 = '+'
            tmp = abs(tr(i))
            write(cht,'(f5.3)')abs(tr(i))
            do k=2,24
               tmp1 = tmp*real(k)
               if(abs(nint(tmp1)-tmp1).lt.eps) then
                  write(cht1,'(i2)')nint(tmp1)
                  write(cht2,'(i2)')k
                  cht = trim(adjustl(cht1))//'/'//
     &                 trim(adjustl(cht2))
                  exit
               endif
            enddo
            write(text_out(ip:(ip+5)),'(a1,a)')s1,trim(adjustl(cht))
            ip = len_trim(text_out)+1
         endif
         if(i.lt.3) then
            text_out(ip:(ip+1)) = ','
            ip = len_trim(text_out)+2
         endif
         it = 1
      enddo

      return
      end
c
c
      subroutine put_symm_to_text_xyz(rot,tr,text_out)
      implicit none
      real rot(3,3),tr(3)
      character text_out*(*)
c

      real eps,tmp,tmp1
      integer i,j,ip,it,k
      character s1*1
      character xyz_c(3)*1,cht*10,cht1*10,cht2*10
      data xyz_c/'X','Y','Z'/
c
c---  body
      eps = 0.1e-3
      text_out = ' '
      ip = 1
      it = 1
      do i=1,3
         do j=1,3
            if(abs(rot(i,j)).gt.eps) then
               s1 = '-'
               if(rot(i,j).gt.0.0) s1 = '+'
               if(s1.eq.'+'.and.it.eq.1) s1 = ' '
               if(abs(abs(rot(i,j))-1.0).gt.eps) then
                  write(cht,'(f5.3)')rot(i,j)
                  tmp = abs(rot(i,j))
                  do k=2,24
                     tmp1 = tmp*k
                     if(abs(nint(tmp1)-tmp1).lt.eps) then
                        write(cht1,'(i2)')nint(tmp1)
                        write(cht2,'(i2)')k
                        cht = trim(adjustl(cht1))//'/'//
     &                       trim(adjustl(cht2))
                        exit
                     endif
                  enddo
                  write(text_out(ip:(ip+7)),'(a1,a,a1)')
     &                 s1,trim(adjustl(cht)),xyz_c(j)
                  ip = len_trim(text_out)+1
               else
                  write(text_out(ip:(ip+1)),'(a1,a1)')s1,xyz_c(j)
                  ip = len_trim(text_out)+1
               endif
               it = 2
            endif
         enddo

         if(abs(tr(i)).gt.eps) then
            s1 = '-'
            if(tr(i).gt.0.0) s1 = '+'
            tmp = abs(tr(i))
            write(cht,'(f5.3)')abs(tr(i))
            do k=2,24
               tmp1 = tmp*real(k)
               if(abs(nint(tmp1)-tmp1).lt.eps) then
                  write(cht1,'(i2)')nint(tmp1)
                  write(cht2,'(i2)')k
                  cht = trim(adjustl(cht1))//'/'//
     &                 trim(adjustl(cht2))
                  exit
               endif
            enddo
            write(text_out(ip:(ip+5)),'(a1,a)')s1,trim(adjustl(cht))
            ip = len_trim(text_out)+1
         endif

         if(i.lt.3) then
            text_out(ip:(ip+1)) = ','
            ip = len_trim(text_out)+2
         endif
         it = 1
      enddo

      return
      end
c
      real function lstlsq_r(k,hkl)
      implicit none
      integer k
      integer hkl(3)
      real lstlsq
      external lstlsq

      lstlsq_r = lstlsq(k,hkl(1),hkl(2),hkl(3))

      end
c
      subroutine find_prim_symm(maxsym,nsym,nprim_symm,rot,tr,
     &     rot_p,tr_p)
      implicit none
      integer maxsym
      integer nsym
      real rot(1:3,1:3,maxsym),tr(3,maxsym)
      integer nprim_symm
      real rot_p(1:3,1:3,maxsym),tr_p(3,maxsym)
c
      integer is,is1
      real eps_l
      logical it_exists
c
      eps_l = 1.0e-6

      nprim_symm = 1
      rot_p(1:3,1:3,1) = rot(1:3,1:3,1)
      tr_p(1:3,1) = tr(1:3,1)
      if(nsym.le.1) return

      do is=2,nsym
         it_exists = .FALSE.
         is1 = 0
         do while(is1.lt.nprim_symm.and..not.it_exists)
            is1 = is1 + 1
            if(sum((rot(1:3,1:3,is)-
     &           rot_p(1:3,1:3,is1))**2).lt.eps_l) then
               it_exists = .TRUE.
            endif
         enddo

         if(.not.it_exists) then
            nprim_symm = nprim_symm + 1
            rot_p(1:3,1:3,nprim_symm) = rot(1:3,1:3,is)
            tr_p(1:3,nprim_symm) = tr(1:3,is)
         endif
      enddo

      return
      end
c
      subroutine find_ort_symm(cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &     rsymm_ort)
      implicit none
c
c---  Calculate symmetry operators for orthogonal system
      integer cs_nsym
      real cs_m_cs(3,3,cs_nsym),cs_v_cs(3,cs_nsym)
      real cs_cell(6)
      real rsymm_ort(3,3,cs_nsym)
c
c---  locals
      integer is,ierror
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      real ro_unit(3,3),rfr_unit(3,3),tmp(3,3)
c
c---  body
      call nb_frorth_r(cs_cell(1),cs_cell(2),cs_cell(3),cs_cell(4),
     &     cs_cell(5),cs_cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierror)
      call calc_unit_frac(cs_frac_to_ort,cs_cell,ro_unit)     
      call matinv3_r(ro_unit,rfr_unit)
      do is=1,cs_nsym
         tmp = matmul(cs_m_cs(1:3,1:3,is),rfr_unit)
         rsymm_ort(1:3,1:3,is) = matmul(ro_unit,tmp)
      enddo

      return
      end
c
      SUBROUTINE NB_FRORTH_R(A,B,C,ALPHA,BETA,GAMMA,FRTOCR,CRTOFR,IERR)
C
C -P- FRORTH - calc transformation to orthogonal angstroms from fractional
C -P-          cell FRTOCR and back - CRTOFR
C
C       ALPHA,BETA,GAMMA - in radian
C
C       orthog axes are defined to have
C       A parallel to XO   Cstar parallel to ZO
C
C                                 ! 11 21 31 !
C            Xo=[FRTOCR] Xf    RO=! 12 22 32 !
C                                 ! 13 23 33 !
C
C            Xf=[CRTOFR] Xo
C
      REAL FRTOCR(3,3),CRTOFR(3,3)
      INTEGER IERR
C ******
      IERR  = 0
C --
      SINA  = SIN(ALPHA)
      COSA  = COS(ALPHA)
      SINB  = SIN(BETA)
      COSB  = COS(BETA)
      SING  = SIN(GAMMA)
      COSG  = COS(GAMMA)
      COSBS = (COSA*COSG-COSB)/(SINA*SING)
      SINBS = SQRT(ABS(1.-COSBS*COSBS))
      COSAS = (COSG*COSB-COSA)/(SINB*SING)
      SINAS = SQRT(ABS(1.-COSAS*COSAS))
      COSGS = (COSA*COSB-COSG)/(SINA*SINB)
      SINGS = SQRT(ABS(1.-COSGS*COSGS))
C
      DO     I=1,3
      DO     J=1,3
        FRTOCR(I,J) = 0.0
      ENDDO
      ENDDO
C
      FRTOCR(1,1) = A
      FRTOCR(1,2) = B*COSG
      FRTOCR(1,3) = C*COSB
      FRTOCR(2,1) = 0.0
      FRTOCR(2,2) = B*SING
      FRTOCR(2,3) =-C*SINB*COSAS
      FRTOCR(3,1) = 0.0
      FRTOCR(3,2) = 0.0
      FRTOCR(3,3) = C*SINB*SINAS
      CALL NB_INVERT_R(FRTOCR,CRTOFR,IERR)
      RETURN
      END
C -I-
      SUBROUTINE NB_INVERT_R(S,SS,IERR)
C
C -P- NB_INVERT - invertion matrix S(3,3) , result marix SS(3,3)
C
C -------------
      REAL S(3,3),SS(3,3)
      INTEGER IERR
C -I-
C -------------------------------
      IERR=0
      DO    I=1,3
      DO    J=1,3
        SS(I,J) = 0.
      ENDDO
      ENDDO
C
      DET = 0.0

      DO    J=1,3
      DO    I=1,3
        IF(I.EQ.1) THEN
          I1=2
          I2=3
        ELSE IF(I.EQ.2) THEN
          I1=1
          I2=3
        ELSE
          I1=1
          I2=2
        ENDIF
        IF(J.EQ.1) THEN
          J1=2
          J2=3
        ELSE IF(J.EQ.2) THEN
          J1=1
          J2=3
        ELSE
          J1=1
          J2=2
        ENDIF
        SS(I,J) = (-1)**(I+J)*( S(J1,I1)*S(J2,I2)-
     *                          S(J2,I1)*S(J1,I2) )
      ENDDO
      ENDDO

      DET = S(1,1)*SS(1,1)+S(1,2)*SS(2,1)+S(1,3)*SS(3,1)

      IF(ABS(DET).LT.1.0E-30) THEN
        IERR = 1
        DET  = 0.0
      ELSE
        DET = 1./DET
      ENDIF
      DO    I=1,3
      DO    J=1,3
        SS(I,J) = DET*SS(I,J)
      ENDDO
      ENDDO

      RETURN
      END
c
      subroutine find_int_symm(cs_nsym,cs_m_cs,cs_v_cs,nx,ny,nz,
     &     irot,itr)
      implicit none
c
c---  convert symmetries to integers. For translation we assume nx,ny,nz
c---  along x,y,z respectively. it is important that factor of nx,ny,nz obey
c--   symmetry requirements. Minimum such number is 12. So if nx,ny,nz are 
c---  divisible by 12 then everything should work fine
      integer cs_nsym
      real cs_m_cs(3,3,cs_nsym),cs_v_cs(3,cs_nsym)
      integer nx,ny,nz
      integer irot(3,3,cs_nsym),itr(3,cs_nsym)

      irot(1:3,1:3,1:cs_nsym)=nint(cs_m_cs(1:3,1:3,1:cs_nsym))
      itr(1,1:cs_nsym) = nint(cs_v_cs(1,1:cs_nsym)*nx)
      itr(2,1:cs_nsym) = nint(cs_v_cs(2,1:cs_nsym)*ny)
      itr(3,1:cs_nsym) = nint(cs_v_cs(3,1:cs_nsym)*nz)

      return
      end
c
      subroutine find_min_symm(x1,x2,maxsym,nsym,rot,trans,frac,ort,
     &     is,tx,dist)
      implicit none
c
c---  Find symmetry that would give minimal distance between two atoms
      integer maxsym,nsym
      real rot(3,3,maxsym),trans(3,maxsym)
      real ort(3,3),frac(3,3)
      real x1(3),x2(3)
      real tx_prev(3)
      
      integer is
      real tx(3)
      real dist

      integer i
      real tmp(3),tmp1(3),tmp3(3),tt(3),tt0(3)
      real dist_prev,dist_cur,tt1
c
c---  body
      tmp3(1:3) = matmul(frac,x1)
      tmp(1:3) = matmul(frac,x2)
      is = 0
      dist_prev = 1.0e32
      tx_prev(1:3) = 0.0
      do i=1,nsym
         tmp1 = matmul(rot(1:3,1:3,i),tmp) + trans(1:3,i)
         tx(1) = 0.0
         do while(tmp1(1)-tmp3(1).le.0.)
            tmp1(1) = tmp1(1) + 1.0
            tx(1) = tx(1) + 1.0
         enddo
         do while(tmp1(1)-tmp3(1).gt.0.)
            tmp1(1) = tmp1(1) - 1.0
            tx(1) = tx(1) - 1.0
         enddo
         tt(1) = tmp1(1) - tmp3(1)
         tt1 = tt(1) + 1.0
         if(abs(tt(1)).gt.abs(tt1)) then
            tx(1)=tx(1)+1.0
            tt(1) = tt1
         endif
c     
c---  y coordinate
         tx(2) = 0.0
         do while(tmp1(2)-tmp3(2).le.0.)
            tmp1(2) = tmp1(2) + 1.0
            tx(2) = tx(2) + 1.0
         enddo
         do while(tmp1(2)-tmp3(2).gt.0.)
            tmp1(2) = tmp1(2) - 1.0
            tx(2) = tx(2) - 1.0
         enddo
         tt(2) = tmp1(2) - tmp3(2)
         tt1 = tt(2) + 1.0
         if(abs(tt(2)).gt.abs(tt1)) then
            tx(2)=tx(2)+1.0
            tt(2) = tt1
         endif
c     
c---  z coordinate
         tx(3) = 0.0
         do while(tmp1(3)-tmp3(3).le.0.)
            tmp1(3) = tmp1(3) + 1.0
            tx(3) = tx(3) + 1.0
         enddo
         do while(tmp1(3)-tmp3(3).gt.0.)
            tmp1(3) = tmp1(3) - 1.0
            tx(3) = tx(3) - 1.0
         enddo
         tt(3) = tmp1(3) - tmp3(3)
         tt1 = tt(3) + 1.0
         if(abs(tt(3)).gt.abs(tt1)) then
            tx(3)= tx(3)+1.0
            tt(3) = tt1
         endif
         tt0 = matmul(ort,tt)
         dist_cur = sum(tt0**2)
         if(dist_prev.gt.dist_cur) then
            is = i
            dist_prev = dist_cur
            tx_prev(1:3) = tx(1:3)
         endif
      enddo
      dist = sqrt(dist_prev)
      tx(1:3) = tx_prev(1:3)
      if(is.eq.1.and.maxval(abs(tt(1:3))).le.0.1) then
         is = 0
         tt(1:3) = 0.0
         dist = 0.0
      endif
      
      return
      end
