module map_routines
  implicit none
  real :: scale_map_obs=0.0
  real :: scale_map_calc=0.0
  real :: b_sharp_map = 0.0
  real :: alpha_sharp_map=0.0
  real :: fraction_sharp_map = 0.10
  character(len=1) :: free_for_map='R'
  character(len=1) :: sharp_map_method='I'
  integer :: sharp_map_options=3
  logical :: sharp_regul_opt=.TRUE.
  logical :: sharp_map_flag=.FALSE.
  logical :: mapc_remove_dpar = .FALSE.

  integer, private :: ngauss_integrate = 11
  logical, private :: gauss_integrate_defined=.FALSE.
  real, private :: gauss_integrate_points(11)
  real, private :: gauss_integrate_weights(11)
  real, private :: bgrid(11),bweight(11),alpha_grid(11,11),alpha_weight(11,11)
  real, private :: bmean,bsigma,alpha_sigma

  contains

    subroutine ts_filter_params_setup(fo,sigo,fc,fom,sigma,rsq,aniso_contrs)

      real, intent(in) :: fo(:),sigo(:),fom(:),fc(:),sigma(:),rsq(:)
      real, intent(in) :: aniso_contrs(:)
      !
      !   Calculate gaussian quadrature points and weights (Gauss-Hermite integration)
      integer i,j
      real alpha_cent
      real bsharp_save

      if(sharp_map_method.eq.'I') then
         if(.not.gauss_integrate_defined) then
            call gauss_coef_tab_a2inf(ngauss_integrate,-100.0,gauss_integrate_points,gauss_integrate_weights)
            gauss_integrate_defined = .TRUE.
            bmean = b_sharp_map
            bsigma = bmean/10.0
         endif
         bsharp_save = b_sharp_map
         do i=1,ngauss_integrate
            bgrid(i) = bmean+bsigma*gauss_integrate_points(i)
            bweight(i) = gauss_integrate_weights(i)
            b_sharp_map = bgrid(i)
            !write(*,*)'b value',bweight(i),bgrid(i)
            call ts_filter_parameters(fo,sigo,fc,fom,sigma,rsq,aniso_contrs)
            alpha_cent = alpha_sharp_map
            alpha_sigma = alpha_sharp_map/10.0
            do j=1,ngauss_integrate
               alpha_grid(i,j) = alpha_cent + alpha_sigma*gauss_integrate_points(j)
               alpha_weight(i,j) = gauss_integrate_weights(j)
               !write(*,*)'alpha ',alpha_weight(i,j),alpha_grid(i,j)
            enddo
         enddo
         b_sharp_map = bsharp_save
      else
         call ts_filter_parameters(fo,sigo,fc,fom,sigma,rsq,aniso_contrs)
      endif
         !stop
    end subroutine ts_filter_params_setup

    subroutine ts_weight_calc(rsq,aniso_contrs,weight_out)
      real, intent(in) :: aniso_contrs
      real, intent(in) :: rsq
      real, intent(out) :: weight_out
      !
      !   Calculate integrated sharpening parameter
      integer i,j
      real denom,wout
      real gsharp1,gsharp,weight,gs_aniso,gs_aniso2
      !
      !   body
      if(sharp_map_method.eq.'I') then
         denom = 0.0
         wout = 0.0
         do i=1,ngauss_integrate
            if(bgrid(i).gt.0.0) then
               gsharp1 = exp(-bgrid(i)*rsq/4.0)
               gs_aniso = aniso_contrs
               gs_aniso2 = gs_aniso**2
               do j=1,ngauss_integrate
                  if(alpha_grid(i,j).gt.0.0) then
                     weight = alpha_weight(i,j)*bweight(i)
                     if(sharp_map_options.eq.1) then
                        gsharp =  gs_aniso2*gsharp1/(gs_aniso2*gsharp1**2+alpha_grid(i,j)*rsq)
                     elseif(sharp_map_options.eq.2) then
                        gsharp = gs_aniso/(gs_aniso2*gsharp+alpha_grid(i,j)**rsq)
                     elseif(sharp_map_options.eq.3) then
                        gsharp = gs_aniso2*gsharp1/(gs_aniso2*gsharp1**2+alpha_grid(i,j))
                     elseif(sharp_map_options.eq.4) then
                        gsharp = gs_aniso2*gsharp1/(gs_aniso2*gsharp1**2+alpha_grid(i,j)*(1.0+rsq))
                     endif
                     wout = wout + weight*gsharp
                     denom = denom + weight
                     !write(*,*)bgrid(i),alpha_grid(i,j),gsharp
                  endif
               enddo
            endif
         enddo
      else
         gsharp1 = exp(-b_sharp_map*rsq/4.0)
         gs_aniso = aniso_contrs
         gs_aniso2 = gs_aniso**2
         if(sharp_map_options.eq.1) then
            wout = gs_aniso2*gsharp1/(gs_aniso2*gsharp1**2+alpha_sharp_map*rsq)
         elseif(sharp_map_options.eq.2) then
            wout = gs_aniso/(gsharp1+alpha_sharp_map*rsq)
         elseif(sharp_map_options.eq.3) then
            wout = gs_aniso2*gsharp1/(gs_aniso2*gsharp1**2+alpha_sharp_map)
         elseif(sharp_map_options.eq.4) then
            wout = gs_aniso2*gsharp1/(gs_aniso2*gsharp1**2+alpha_sharp_map*(1.0+rsq))

         endif
      endif
      !write(*,*)wout,denom
      weight_out = wout   !  /denom
      !stop
    end subroutine ts_weight_calc
    !
    subroutine ts_filter_parameters(fo,sigo,fc,fom,sigma,rsq,aniso_contrs)
      implicit none

      !
      !  Calculate Tikhonov (Sobolev) reguliser parameter for sharpening

      real, intent(in) :: fo(:),sigo(:),fom(:),fc(:),sigma(:),rsq(:),aniso_contrs(:)
      !
      !   Locals
      integer i,ir
      integer nref,nmax
      real prerr,prerr_old,denom,denom3
      real(kind=8) :: delt2,filt1,filt2,filt3,fwt,gg1,rsqmax
      real gamma,dgamma,dmax
      real(kind=8), allocatable :: gsharp(:)
      real gs_aniso,gs_aniso2
      logical observed
      !
      !   Body
      nref = size(fo)
      gamma=0.0
      dgamma = 0.0005
      dmax = 4.0
      nmax = dmax/dgamma
      prerr_old = 0.0
      allocate(gsharp(nref))
      gsharp(1:nref) = exp(-b_sharp_map*rsq(1:nref)/4.0)
      rsqmax = maxval(rsq(1:nref))

!      open(44)
      do i=1,nmax
         denom = 0.0
         gamma = gamma+dgamma
         do ir=1,nref
            gs_aniso = aniso_contrs(ir)
            gs_aniso2 = gs_aniso**2
            gg1 = gs_aniso2*gsharp(ir)**2+gamma*rsq(ir)

            filt1 = gamma*rsq(ir)/gg1
            filt3 = gamma*rsq(ir)/(gs_aniso2*gsharp(ir)+gamma*rsq(ir))
            if(sharp_map_options.eq.1) then
               denom = denom + filt1
            elseif(sharp_map_options.eq.2) then
               denom = denom + filt3
            elseif(sharp_map_options.eq.3) then
               denom = denom + gamma/(gs_aniso2*gsharp(ir)**2+gamma)
            elseif(sharp_map_options.eq.4) then
               denom = denom + gamma/(gs_aniso2*gsharp(ir)**2+gamma*(1+rsq(ir)))
            endif
         enddo
         if(denom/nref.ge.fraction_sharp_map) exit
      enddo
      alpha_sharp_map = gamma
      !write(*,*)'alpha ',alpha_sharp_map

      deallocate(gsharp)
!      stop
    end subroutine ts_filter_parameters


  end module map_routines
