      SUBROUTINE PRECHECK_L1_MON_DESCRIPTION(MDOC,LIST,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8,LIST*1,TREE*1
C -----------------------------------------------
      IERR = 0
      MON  = L1L_MNAME
      NA   = L1A_NATOM
      IF(NA.LE.1) RETURN
      CALL COPYL2(MDOC,IERR)
C --
      DO I=1,L2A_NATOM
        L1A_ICR(I) = I  
        L2A_ICR(I) = I  
      ENDDO
      CALL SET_NUM_L1_GM(MDOC,IERR)
      CALL SET_NUM_L2_GM(MDOC,IERR)

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' -- PRECHECK_L1_MON_DESCRIPTION --- ')
        WRITE(LINE,*) ' --- NA:',L1A_NATOM
        CALL MSGDOC(MDOC,LINE)
        IF(NA.GT.0) THEN
        DO IA=1,NA
          WRITE(LINE,*) IA,' ',L1A_ANAME(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
        WRITE(LINE,*) ' --- NB:',L1B_NBOND,L1C_NCHIR 
        CALL MSGDOC(MDOC,LINE)
        IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          WRITE(LINE,*) IB,' ',L1B_I1ATM(IB),L1B_I2ATM(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
      ENDIF
C -----
      DO IA=1,NA
        DO JA=1,NA
          J = L2A_ICR(JA) 
          DO IB=1,L2B_NBOND
            IK = 0
            IF(L2B_I1ATM(IB).EQ.J.AND.L2B_I2ATM(IB).NE.J) THEN
              IK = L2B_I2ATM(IB)
            ELSE IF(L2B_I2ATM(IB).EQ.J.AND.L2B_I1ATM(IB).NE.J) THEN
              IK = L2B_I1ATM(IB)
            ENDIF
            IF(IK.GT.0) THEN
              DO KA=1,NA
                IF(L2A_ICR(KA).EQ.IK) L2A_ICR(KA) = J  
              ENDDO
              DO JB=1,L2B_NBOND
                IF(L2B_I1ATM(JB).EQ.IK) L2B_I1ATM(JB) = J
                IF(L2B_I2ATM(JB).EQ.IK) L2B_I2ATM(JB) = J
              ENDDO
            ENDIF    
          ENDDO
        ENDDO
C --
        NPIECE = 1
        DO J=2,NA
          DO K=1,J-1
            IF(L2A_ICR(J).EQ.L2A_ICR(K)) GO TO 100
          ENDDO
          NPIECE = NPIECE + 1 
 100      CONTINUE
        ENDDO
        IF(NPIECE.LE.1) GO TO 200
C -- 
      ENDDO

C -----
C     maybe there is "dummy' connection ?
      TREE = 'N'
      DO I=1,NA
        IF(L2A_BACK(I).NE.'.') TREE = 'Y'
      ENDDO
C ---
      IF(TREE.EQ.'Y'.AND.L1L_PRSNT.NE.'M') THEN
        DO I=1,L2A_NATOM
          L2A_ICR(I) = I  
        ENDDO

        CALL SET_NUM_L2_GM(MDOC,IERR)

        DO I=1,NA
          IF(L2A_TYPE(I).EQ.'DUMMY'.AND.L2A_IBACK(I).GT.0) THEN
            IF(L2B_NBOND.GE.MAX1BND) THEN
              WRITE(LINE
     *        ,'('' ERROR: number of bonds of monomer >'',I6)') 
     *        MAX1BND
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC
     *        ,'         Change parameter MAX1BND in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF
            II          = L2A_IBACK(I)
            L2B_NBOND   = L2B_NBOND+1
            L           = L2B_NBOND
            L2B_1ATM (L)= L2A_ANAME(II)
            L2B_2ATM (L)= L2A_ANAME(I)
            L2B_I1ATM(L)= II
            L2B_I2ATM(L)= I
          ENDIF
        ENDDO

C -----
        DO IA=1,NA
          DO JA=1,NA
            J = L2A_ICR(JA) 
            DO IB=1,L2B_NBOND
              IK = 0
              IF(L2B_I1ATM(IB).EQ.J.AND.L2B_I2ATM(IB).NE.J) THEN
                IK = L2B_I2ATM(IB)
              ELSE IF(L2B_I2ATM(IB).EQ.J.AND.L2B_I1ATM(IB).NE.J) THEN
                IK = L2B_I1ATM(IB)
              ENDIF
              IF(IK.GT.0) THEN
                DO KA=1,NA
                  IF(L2A_ICR(KA).EQ.IK) L2A_ICR(KA) = J  
                ENDDO
                DO JB=1,L2B_NBOND
                  IF(L2B_I1ATM(JB).EQ.IK) L2B_I1ATM(JB) = J
                  IF(L2B_I2ATM(JB).EQ.IK) L2B_I2ATM(JB) = J
                ENDDO
              ENDIF    
            ENDDO
          ENDDO
C --
          NPIECE = 1
          DO J=2,NA
            DO K=1,J-1
              IF(L2A_ICR(J).EQ.L2A_ICR(K)) GO TO 300
            ENDDO
            NPIECE = NPIECE + 1 
 300        CONTINUE
          ENDDO
          IF(NPIECE.LE.1) GO TO 200
C -- 
        ENDDO

      ENDIF

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '---- I,NPIECE:',I,NPIECE,L1C_NCHIR 
        CALL MSGDOC(MDOC,LINE)         
        DO K=1,NA
          WRITE(LINE,*) '--',L2A_ANAME(K),K,L2A_ICR(K) 
          CALL MSGDOC(MDOC,LINE)         
        ENDDO
        CALL MSGDOC(MDOC,'-----------------')         
      ENDIF 

      NPIECE1 = NPIECE - 1
      WRITE(LINE,
     *'('' WARNING: monomer:'',A,'' not completely connected.'')') MON
      CALL MSGERR(MDOC,LINE)         
      WRITE(LINE,'(A,I4,a)')
     *   '          program will add ',NPIECE1
     *    ,' additional connections in tree structure'
      CALL MSGERR(MDOC,LINE)         

      IERR = 10

 200  CONTINUE
      JERR = 0
      IF(L1N_NCONN.GT.0) THEN
        DO I=1,L1N_NCONN
          IF(L1N_I1ATM(I).EQ.0) JERR = 1
          IF(L1N_I2ATM(I).EQ.0) JERR = 1
        ENDDO
      ENDIF
      IF(L1B_NBOND.GT.0) THEN 
        DO I=1,L1B_NBOND
          IF(L1B_I1ATM(I).EQ.0) JERR = 1 
          IF(L1B_I2ATM(I).EQ.0) JERR = 1
        ENDDO
      ENDIF

      IERR = IERR + JERR*100

      CALL COMPRESS_L1_GM(MDOC,KERR)
C -------
      RETURN
      END

C ******
      SUBROUTINE RD_MD_LINK_LIB(MDOC,IERR,IEND)
C -------------------------------------------------------
C -P- 
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IEND
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IFLAG_MON,IFLAG_MOD,IFLAG_LINK,I
      INTEGER*4 NLIB_LIM
      CHARACTER DATA*80,ITEM*80,BLOCK*8,BLOCK_OLD*8
      CHARACTER LINE*256,MOD*1,LIB*256
c
c---Things for swapping atom names and compIds
      integer itemp
      character ctemp*4
C ---
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------
C
C     CALL INIT_CNT
C
      MOD      = 'N'
      LB_PASS  = 0
      NLIB_LIM = 1

 200  CONTINUE

      LB_PASS    = LB_PASS + 1
      IERR       = 0
      IEND       = 0
      IFLAG_MON  = 0
      IFLAG_MOD  = 0
      IFLAG_LINK = 0
C ------
C     open file of mon_library
C     IUN = 10
      IUN = CRI_IUN
      M   = 99
      IF(LB_PASS.LE.NLIB_LIM) THEN
        LIB = LMI_FILE(LB_PASS)
        CALL OPENFR(IUN,M,LMI_PATH,LIB,LMI_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LIB,LEN) 
          IF(LEN.GT.50) LEN=50
          IF(LEN.LE.0) THEN
            LIB = '?'
            LEN = 1
          ENDIF
          WRITE(LINE,*) ' ERROR: can"t open (lbl):',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        CALL OPENFR(IUN,M,LMI2_PATH,LMI2_FILE,LMI2_EXT,IERR)
        IF(IERR.NE.0) THEN
          LIB = LMI2_FILE
          CALL LENSTR_BL(LMI2_FILE,LEN) 
          IF(LEN.GT.50) LEN=50
          IF(LEN.LE.0) THEN
            LIB = '?'
            LEN = 1
          ENDIF
          WRITE(LINE,*) ' ERROR: can"t open (lbl2):',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ENDIF
C      CALL OPENFR(IUN,M,LMI_PATH,LMI_FILE,LMI_EXT,IERR)
C      IF(IERR.NE.0) THEN
C        CALL MSGERR(MDOC,' ERROR: can''t open "mon_lib.cif" .')
C        RETURN
C      ENDIF
      LMI_IUN   = IUN
      IEND      = -1
      BLOCK_OLD = '   '
C -------
      IF(IEND.EQ.-1) THEN
        REWIND IUN
        IEND_CIF = -1
        IEND     = 0
      ENDIF

  300 CONTINUE   
      
      CALL GETCIF_INFO(IUN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0.OR.(IEND_CIF.NE.0.AND.IEND_CIF.NE.-2)) THEN

        IEND=1
        GO TO 400
C        CLOSE(IUN)
C        LMI_IUN=0
C        RETURN
      ENDIF

      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        CALL LENSTR_BL(DT_CIF(1),LEND) 
        DATA = DT_CIF(1)(1:LEND)
        GO TO 300
      ENDIF
      
      CALL LENSTR_BL(BLK_CIF,LENB) 
      CALL LENSTR_BL(ITL_DCMP,LDCMP)

C -- !!  BLK_CIF(1:10) = 'data_comp_XXX
C      LBB = 10
C      LS  = LBB+1
C      LF  = LBB+3

      LS  = LDCMP + 1 
      LF  = LENB

      CALL LENSTR_BL(DT_CIF(1),LEND) 
      DATA = DT_CIF(1)(1:LEND)

      IF(N_CIF.EQ.0) THEN

        CALL LENSTR_BL(ITL_DCMP,LDCM) 

C        IF(LENB.GE.LS.AND.LENB.LE.LF.AND.
C     *            BLK_CIF(1:LBB).EQ.'data_comp_') THEN
        IF(BLK_CIF(1:LDCM).EQ.ITL_DCMP(1:LDCM)) THEN

C          IF(MOD.EQ.'N'.AND.IFLAG_MOD.EQ.1.AND. 
C     *                      IFLAG_LINK.EQ.1) GO TO 400 

          LB = LENB
c          IF(LB.GT.13) LB = 13
          BLOCK = BLK_CIF(LS:LB)
c          IF(LB.LT.LF    ) BLOCK(3:3) = ' '
c          IF(LB.LT.(LF-1)) BLOCK(2:2) = ' '

          IF(BLOCK.NE.BLOCK_OLD) THEN
            IF(LML_NMON.LE.0) THEN
              CALL MSGERR(MDOC
     *        ,' ERROR: number of monomers in library = 0')
              IERR=1
              CLOSE(IUN,ERR=440)
 440          CONTINUE
              LMI_IUN=0
              RETURN
            ENDIF
            DO L=1,LML_NMON
              IF(BLOCK.EQ.LML_MNAME(L)) THEN
                BLK_FLAG=LML_FUSE(L)
                GO TO 100
              ENDIF
            ENDDO
            BLK_FLAG='N'

  100       CONTINUE
            BLOCK_OLD=BLOCK
          ENDIF
        ENDIF
        GO TO 300
      ENDIF

      CALL LENSTR_BL(DT_CIF(1),LEND) 
      DATA = DT_CIF(1)(1:LEND)

      DO I=1,N_CIF


        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

c       IF(ITEM(1:16).EQ.'_chem_comp_atom.') IFLAG_MON = 1
c       IF(ITEM(1:15).EQ.'_chem_mod_atom.')  IFLAG_MOD = 1
c       IF(ITEM(1:16).EQ.'_chem_link_bond.') IFLAG_LINK = 1
        CALL LENSTR_BL(ITL_CMPA,LCMA)
        CALL LENSTR_BL(ITL_MODA,LMDA)
        CALL LENSTR_BL(ITL_LNKB,LLNB)
        IF(ITEM(1:LCMA).EQ.ITL_CMPA(1:LCMA)) IFLAG_MON  = 1
        IF(ITEM(1:LMDA).EQ.ITL_MODA(1:LMDA)) IFLAG_MOD  = 1
        IF(ITEM(1:LLNB).EQ.ITL_LNKB(1:LLNB)) IFLAG_LINK = 1


C       DATA ITL_CMP       /'_chem_comp.                             '/
C       DATA ITL_MOD       /'_chem_mod.                              '/
C       DATA ITL_LNK       /'_chem_link.                             '/
        CALL LENSTR_BL(ITL_CMP,LCM)
        CALL LENSTR_BL(ITL_MOD,LMD)
        CALL LENSTR_BL(ITL_LNK,LLN)

        IF(BLK_CIF(1:7) .EQ.'global_') THEN         

        ELSE IF(ITEM(1:LCM-1).EQ.ITL_CMP(1:LCM-1)) THEN


C          IF(MOD.EQ.'N'.AND.IFLAG_MOD.EQ.1.AND. 
C     *                      IFLAG_LINK.EQ.1) GO TO 400 
          
C          IF(MOD.NE.'N') THEN
        
C            CALL PUT_MNLIB(MDOC,I,BLK_CIF,LENB,ITEM,LENI
C     *      ,DATA,IDATA,FDATA,LEND,IERR)

c           IF(IERR.NE.0) THEN
c             CLOSE(IUN)
c             LMI_IUN=0
c             RETURN
c           ENDIF

C          ENDIF 

        ELSE IF(ITEM(1:LMD-1).EQ.ITL_MOD(1:LMD-1)) THEN

C          IF(MOD.EQ.'M'.AND.IFLAG_MON.EQ.1) GO TO 400 

          IF(MOD.NE.'M') THEN
            CALL PUT_MDLIB(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *      ,DATA,IDATA,FDATA,LEND,IERR)

            IF(IERR.NE.0) THEN
              CLOSE(IUN,ERR=430)
 430          CONTINUE
              LMI_IUN=0
              RETURN
            ENDIF

          ENDIF

        ELSE IF(ITEM(1:LLN-1).EQ.ITL_LNK(1:LLN-1)) THEN

C          IF(MOD.EQ.'M'.AND.IFLAG_MON.EQ.1) GO TO 400 

          IF(MOD.NE.'M') THEN
            CALL PUT_LNLIB(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *      ,DATA,IDATA,FDATA,LEND,IERR)

            IF(IERR.NE.0) THEN
              CLOSE(IUN,ERR=420)
 420          CONTINUE
              LMI_IUN=0
              RETURN
            ENDIF

          ENDIF

        ENDIF

      ENDDO
      GO TO 300
C -----------------------------------
 400  CONTINUE
      CLOSE(IUN,ERR=410)
 410  CONTINUE
      LMI_IUN=0

      IF(LB_PASS.EQ.NLIB_LIM) THEN
        CALL LENSTR_BL(LMI2_FILE,LEN)
        IF(LEN.GT.0.AND.LMI2_FILE(1:1).NE.','.AND.
     *    LMI2_FILE(1:1).NE.' ') THEN
          GO TO 200
        ENDIF
      ELSE IF(LB_PASS.LT.NLIB_LIM) THEN
        GO TO 200
      ENDIF
C ----
c---  if atom orders in link are wrong try to correct them
      do ii=1,llb_nbond
         if(llb_f1atm(ii).gt.llb_f2atm(ii)) then
            itemp = llb_f1atm(ii)
            llb_f1atm(ii) = llb_f2atm(ii)
            llb_f2atm(ii) = itemp
            ctemp = llb_1atm(ii)
            llb_1atm(ii) = llb_2atm(ii)
            llb_2atm(ii) = ctemp
         endif
      enddo
      LB_PASS = 0
      RETURN
      END     

C ******
      SUBROUTINE CP_MLIB(MDOC,MON,IERR)
C -----------------------------------------------
C -P- CP_MLIB - copies monomer's information from library to special
C -P-           commons for one current monomer /L1M_LIST/,/L1M_ATOM/,... 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,MON2*8,MON3*8,MOD*8,MOD1*8,MOD2*8
C ---
      INCLUDE 'lib_com.fh'

C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomers in library = 0')
        IERR=1
        RETURN
      ENDIF

      MOD  = ' '
      MOD1 = ' '
      MOD2 = ' '
      LDR = 0 

      DO   L=1,LML_NMON
   
        IF(MON.EQ.LML_MNAME(L).AND.LML_FUSE(L).NE.'N'.AND.
     *                             LML_FUSE(L).NE.'R'     ) THEN
          MON2 = MON
          MOD  = ' '
          GO TO 100
        ENDIF
      ENDDO

      MON2 = MON

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            MON2  = LMS_MNAME(LL)
            DO L=1,LML_NMON
              IF(MON2.EQ.LML_MNAME(L).AND.LML_FUSE(L).NE.'N'.AND.
     *                                    LML_FUSE(L).NE.'R'     ) THEN
                MON  = MON2
                MOD  = LMS_MOD(LL)
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      MON = MON2

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON) THEN
            MON2 = LDR_SMNAME(LL)
            DO L=1,LML_NMON
              IF(MON2.EQ.LML_MNAME(L).AND.LML_FUSE(L).NE.'N'.AND.
     *                                    LML_FUSE(L).NE.'R'     ) THEN
                MOD1 = LDR_MOD(LL)
                LDR  = LL
                GO TO 100
              ENDIF
            ENDDO
            MON3 = MON2
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON3) THEN
                MON2  = LDR_SMNAME(LLL)
                DO L=1,LML_NMON
                  IF(MON2.EQ.LML_MNAME(L)) THEN
                    MOD2 = LDR_MOD(LL)
                    LDR  = LLL
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO

          ENDIF
        ENDDO
      ENDIF

  
      WRITE(LINE
     *  ,'('' ERR: monomer '',A8,'' not found in library..'')') MON 
      CALL MSGDOC(MDOC,LINE)
      IERR = 2
      RETURN

  100 CONTINUE

      L1L_NATM  = LML_NATM  (L)
      L1L_NHATM = LML_NHATM (L)
      L1L_MNAME = LML_MNAME (L) 
      L1L_MNAME2= LML_MNAME2(L) 

      MON2      = L1L_MNAME

      L1L_NAME  = LML_NAME (L) 
      IF(LDR.GT.0) L1L_NAME  = LDR_NAME(LDR) 
      L1L_FORM  = LML_FORM (L) 
      L1L_CODE1 = LML_CODE1(L)
      L1L_TYPE  = LML_TYPE (L)
      IF(LDR.GT.0) L1L_TYPE  = LDR_TYPE(LDR) 
      if(l1l_type(1:4).eq.'L-pe'.or.l1l_type(1:3).eq.'D-pe') then
         l1l_type = 'peptide'
      elseif(l1l_type(1:4).eq.'L-py'.or.l1l_type(1:4).eq.'D-py') then
         l1l_type = 'pyranose'
      endif

      L1L_MODE  = LML_MODE (L)

      L1L_FUSE  = LML_FUSE (L)
      L1L_PRSNT = LML_PRSNT(L)
      L1L_HFLAG = LB_HFLAG
      IA        = LML_IATOM(L)
      IN        = LML_ICONN(L)
      IB        = LML_IBOND(L)
      IG        = LML_ITHET(L)
      IT        = LML_ITORS(L)
      IP        = LML_IPLAN(L)
      IC        = LML_ICHIR(L)
      L1A_NATOM = 0
      L1A_NHATOM= 0
      L1N_NCONN = 0
      L1B_NBOND = 0
      L1G_NANGL = 0
      L1T_NTORS = 0
      L1C_NCHIR = 0
      L1P_NPLAN = 0
      L1A_NDUMMY= 0

      IF(IA.GT.0) THEN
        CALL CP_AMLIB(MDOC,MON2,IA,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IN.GT.0) THEN
        CALL CP_NMLIB(MDOC,MON2,IN,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IB.GT.0) THEN
        CALL CP_BMLIB(MDOC,MON2,IB,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IG.GT.0) THEN
        CALL CP_GMLIB(MDOC,MON2,IG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IT.GT.0) THEN
        CALL CP_TMLIB(MDOC,MON2,IT,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IP.GT.0) THEN
        CALL CP_PMLIB(MDOC,MON2,IP,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(IC.GT.0) THEN
        CALL CP_CMLIB(MDOC,MON2,IC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
c -----------------
      NA   = L1A_NATOM
      L1A_ISTART  = 0
      L1A_IFINISH = 0
      DO I=1,NA
        L1A_INEW (I) = I 
        L1A_IOLD (I) = I
        L1A_ICHEM(I) = 0              
        L1A_ICR  (I) = 0
        L1A_NDIST(I) = 0
        L1A_IBACK(I) = 0
        L1A_IFORW(I) = 0
        DO  J=1,MAX1BRN 
          L1A_CONN   (J,I) = 0
          L1A_LENCON (J,I) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_TEXTR (J,I) = 0
          L1A_IEXTR (J,I) = 0
        ENDDO
      ENDDO
c -----------------
      IF(LDL_NMOD.GT.0) THEN
        DO L=1,LDL_NMOD
          IF(L1L_MODE.EQ.LDL_MNAME(L)) THEN
            CALL MODIF(MDOC,L1L_MODE,IERR)
            GO TO 200
          ENDIF
        ENDDO
 200    CONTINUE

        IF(MOD.NE.' ') THEN
          DO L=1,LDL_NMOD
            IF(MOD.EQ.LDL_MNAME(L)) THEN
              CALL MODIF(MDOC,MOD,IERR)
              GO TO 310
            ENDIF
          ENDDO
        ENDIF
 310    CONTINUE
        IF(MOD1.NE.' ') THEN
          DO L=1,LDL_NMOD
            IF(MOD1.EQ.LDL_MNAME(L)) THEN
              CALL MODIF(MDOC,MOD1,IERR)
              GO TO 320
            ENDIF
          ENDDO
        ENDIF
 320    CONTINUE
        IF(MOD2.NE.' ') THEN
          DO L=1,LDL_NMOD
            IF(MOD2.EQ.LDL_MNAME(L)) THEN
              CALL MODIF(MDOC,MOD2,IERR)
              GO TO 330
            ENDIF
          ENDDO
        ENDIF
 330    CONTINUE

      ENDIF
 300  CONTINUE

C ---
      IF(L1B_NBOND.GE.2.AND.L1G_NANGL.LE.0) THEN
        L1L_PRSNT    = 'M'
        LML_PRSNT(L) = 'M' 
      ENDIF
C ---
      CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE_RES,IERR)

c      CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND
c     *                (MDOC,ITYPE_RES,IERR)


      IF(ITYPE_RES.EQ.3) THEN
        MOD = 'AA-STAND'
        CALL MODIF(MDOC,MOD,IERR)
        IERR = 0
      ELSE IF(ITYPE_RES.EQ.5) THEN
        MOD = 'NA-STAND'
        CALL MODIF(MDOC,MOD,IERR)
        IERR = 0
      ENDIF
c ---
      IF(L1L_PRSNT.NE.'M') THEN
        CALL CHECK_EXTRA_CONN(MDOC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_EXTRA_CONN(MDOC,IERR)
C -----------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM1*4,ATOM2*4
C -----------------------------------
      IERR = 0

      IF(L1A_NATOM.LE.2) RETURN
      IF(L1B_NBOND.LE.2) RETURN

      NBACK = 0
      DO IA=1,L1A_NATOM
        IF(L1A_BACK(IA).NE.'.'.AND.L1A_BACK(IA).NE.'n/a'.AND.
     *     L1A_BACK(IA).NE.' ') THEN
          NBACK = NBACK + 1
        ENDIF
      ENDDO

      IF(NBACK.LE.1) RETURN

      DO IB=1,L1B_NBOND
        ATOM1 = L1B_1ATM(IB)
        ATOM2 = L1B_2ATM(IB)
        DO IA=1,L1A_NATOM
          IF((ATOM1.EQ.L1A_ANAME(IA).AND.ATOM2.EQ.L1A_BACK(IA)).OR.
     *     (ATOM2.EQ.L1A_ANAME(IA).AND.ATOM1.EQ.L1A_BACK(IA)))GO TO 100
        ENDDO


        IF(L1N_NCONN.GT.0) THEN
          DO IN=1,L1N_NCONN
            IF((ATOM1.EQ.L1N_1ATM(IN).AND.ATOM2.EQ.L1N_2ATM(IN)).OR.
     *      (ATOM2.EQ.L1N_1ATM(IN).AND.ATOM1.EQ.L1N_2ATM(IN)))GO TO 100
          ENDDO
        ENDIF

        L1N_NCONN = L1N_NCONN+1

        IF(L1N_NCONN.GT.MAX1CONN) THEN
          WRITE(LINE,'(A,A8,A,I6)')
     *' ERR: number of connections in monomer ',L1L_MNAME,'>',MAX1CONN
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF

        L1N_1ATM (L1N_NCONN) = ATOM1
        L1N_2ATM (L1N_NCONN) = ATOM2
        L1N_TYPE (L1N_NCONN) = '.'

 100    CONTINUE
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_AMLIB(MDOC,MON,IA,IERR)
C -----------------------------------------------
C -P- CP_AMLIB - copy atom's information from library to special
C -P-            commons for one current monomer /L1M_ATOM/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IA,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      L1A_NATOM = 0
      IF(LMA_NATOM.LE.0.OR.LMA_NATOM.LT.IA.OR.IA.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of atoms in monomer = 0')
        IERR = 1
        RETURN
      ENDIF
      DO   L=IA,LMA_NATOM


        IF(MON.EQ.LMA_MNAME(L)) THEN

          L1A_NATOM = L1A_NATOM+1

          IF(L1A_NATOM.GT.MAX1ATM) THEN
            WRITE(LINE,'(A,A8,A,I6)')' ERR: number of atoms in monomer '
     &      ,MON,' >',MAX1ATM
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1ATM in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF

          L1A_COOR_FLAG(L1A_NATOM) = LMA_COOR_FLAG(L)
          L1A_CHARG    (L1A_NATOM) = LMA_CHARG    (L)
          IF(L1A_COOR_FLAG(L1A_NATOM).EQ.'Y') THEN
            L1A_X    (L1A_NATOM) = LMA_X    (L)
            L1A_Y    (L1A_NATOM) = LMA_Y    (L)
            L1A_Z    (L1A_NATOM) = LMA_Z    (L)
          ELSE
            L1A_X    (L1A_NATOM) = 0.0
            L1A_Y    (L1A_NATOM) = 0.0
            L1A_Z    (L1A_NATOM) = 0.0
          ENDIF

          L1A_LENGTH(L1A_NATOM) = 0.0
          L1A_THETA (L1A_NATOM) = 0.0
          L1A_PHI   (L1A_NATOM) = 0.0
          L1A_ID_PSI(L1A_NATOM) = '.'

          L1A_INEW (L1A_NATOM) = L1A_NATOM 
          L1A_IOLD (L1A_NATOM) = L1A_NATOM
          L1A_ICR  (L1A_NATOM) = 0
          L1A_NDIST(L1A_NATOM) = 0
          L1A_IBACK(L1A_NATOM) = 0
          L1A_IFORW(L1A_NATOM) = 0
          L1A_BACK (L1A_NATOM) = LMA_BACK (L)
          L1A_TYPE (L1A_NATOM) = LMA_TYPE (L)
          L1A_FORW (L1A_NATOM) = LMA_FORW (L)
          L1A_ANAME(L1A_NATOM) = LMA_ANAME(L)
          L1A_SYMB (L1A_NATOM) = LMA_SYMB (L) 
          L1A_SF_ID(L1A_NATOM) = LMA_SF_ID(L)
          L1A_CHEM (L1A_NATOM) = LMA_CHEM (L)
          IF(L1A_SYMB(L1A_NATOM)(1:2).NE.'H '.AND.
     *       L1A_SYMB(L1A_NATOM)(1:2).NE.'D '     ) THEN
            L1A_NHATOM=L1A_NHATOM + 1
          ELSE
            L1A_CHEM(L1A_NATOM) = 'H   '
          ENDIF
          L1A_ATYPE(L1A_NATOM) = 'M'
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,L1A_NATOM) = 0
            L1A_LENCON (J,L1A_NATOM) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_IEXTR (J,L1A_NATOM) = 0
            L1A_TEXTR (J,L1A_NATOM) = 0
          ENDDO
C
        ENDIF
      ENDDO  
      L1A_IGATM    = 0
      L1A_ISTART   = 0
      L1A_IFINISH  = 0
      L1A_I2START  = 0 
      L1A_I2FINISH = 0
      IF(L1A_NATOM.EQ.1) THEN
        L1A_FORW (1) = 'END'
      ENDIF
      RETURN
      END

      SUBROUTINE COUNT_NATOM_LIB(MDOC,MON,IA,NATOM,NHATOM,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IA,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256,ATOM*4,SYMB*4
C -----------------------------------
      NATOM  = 0
      NHATOM = 0
      IF(IA.LE.0) THEN
        LINE = ' ERR: monomer '//MON//' number of atoms = 0'
        CALL MSGERR(MDOC,LINE)
        IERR = 1
        RETURN
      ENDIF

      DO   L=IA,100000
        IF(MON.NE.LMA_MNAME(L)) RETURN
        ATOM  = LMA_ANAME(L)
        SYMB  = LMA_SYMB (L) 
        NATOM = NATOM + 1
        IF(SYMB(1:2).NE.'H '.AND.
     *     SYMB(1:2).NE.'D ' )
     *    NHATOM = NHATOM + 1
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_NMLIB(MDOC,MON,IN,IERR)
C -----------------------------------------------
C -P- CP_NMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IN,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      L1N_NCONN=0
      IF(LMN_NCONN.LE.0.OR.LMN_NCONN.LT.IN.OR.IN.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of atoms in monomer = 0')
        IERR = 1
        RETURN
      ENDIF
      DO   L=IN,LMN_NCONN
        IF(MON.EQ.LMN_MNAME(L)) THEN
          L1N_NCONN = L1N_NCONN+1

          IF(L1N_NCONN.GT.MAX1CONN) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     * ' ERR: number of connections in monomer ',MON,'>',MAX1CONN
            CALL MSGERR(MDOC,LINE)
            IERR=1
            RETURN
          ENDIF

          L1N_1ATM (L1N_NCONN) = LMN_1ATM (L)
          L1N_2ATM (L1N_NCONN) = LMN_2ATM (L)
          L1N_TYPE (L1N_NCONN) = LMN_TYPE (L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_BMLIB(MDOC,MON,IB,IERR)
C -----------------------------------------------
C -P- CP_BMLIB - copies bond's information from library to special
C -P-            commons for one current monomer /L1M_BOND/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IB,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1B_NBOND=0
      IF(LMB_NBOND.LE.0.OR.LMB_NBOND.LT.IB.OR.IB.LE.0) RETURN
      DO   L=IB,LMB_NBOND
        IF(MON.EQ.LMB_MNAME(L)) THEN

          L1B_NBOND = L1B_NBOND+1
          IF(L1B_NBOND.GT.MAX1BND) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     *    ' ERR: number of bonds in monomer ',MON,' >',MAX1BND
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1BND in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF

          L1B_FLAG (L1B_NBOND) = 'N'
          L1B_VOBS (L1B_NBOND) = 0.0
          L1B_EVAL (L1B_NBOND) = 0.0
          L1B_VAL  (L1B_NBOND) = LMB_VAL  (L)
          L1B_DEV  (L1B_NBOND) = LMB_DEV  (L)
          L1B_I1ATM(L1B_NBOND) = 0
          L1B_I2ATM(L1B_NBOND) = 0
          L1B_1ATM (L1B_NBOND) = LMB_1ATM (L)
          L1B_2ATM (L1B_NBOND) = LMB_2ATM (L)
          L1B_TYPE (L1B_NBOND) = LMB_TYPE (L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_GMLIB(MDOC,MON,IG,IERR)
C -----------------------------------------------
C -P- CP_GMLIB - copies angle's information from library to special
C -P-            commons for one current monomer /L1M_ANGL/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1G_NANGL=0
      IF(LMG_NANGL.LE.0.OR.LMG_NANGL.LT.IG.OR.IG.LE.0) RETURN
      DO   L=IG,LMG_NANGL
        IF(MON.EQ.LMG_MNAME(L)) THEN

          L1G_NANGL = L1G_NANGL+1
          IF(L1G_NANGL.GT.MAX1ANG) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     *  ' ERR: number of angles in monomer ',MON,' >',MAX1ANG
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1ANG in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF
          L1G_FLAG (L1G_NANGL) = 'N'
          L1G_VOBS (L1G_NANGL) = 0.0
          L1G_EVAL (L1G_NANGL) = 0.0
          L1G_VAL  (L1G_NANGL) = LMG_VAL  (L)
          L1G_DEV  (L1G_NANGL) = LMG_DEV  (L)
          L1G_I1ATM (L1G_NANGL) = 0
          L1G_I2ATM (L1G_NANGL) = 0
          L1G_I3ATM (L1G_NANGL) = 0
          L1G_1ATM (L1G_NANGL) = LMG_1ATM (L)
          L1G_2ATM (L1G_NANGL) = LMG_2ATM (L)
          L1G_3ATM (L1G_NANGL) = LMG_3ATM (L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_TMLIB(MDOC,MON,IT,IERR)
C -----------------------------------------------
C -P- CP_TMLIB - copies tortion's information from library to special
C -P-            commons for one current monomer /L1M_TORS/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IT,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1T_NTORS=0
      IF(LMT_NTORS.LE.0.OR.LMT_NTORS.LT.IT.OR.IT.LE.0) RETURN
      DO   L=IT,LMT_NTORS
        IF(MON.EQ.LMT_MNAME(L)) THEN

          L1T_NTORS = L1T_NTORS+1
          IF(L1T_NTORS.GT.MAX1TOR) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     *   ' ERR: number of torsions in monomer ',MON,' >',MAX1TOR
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1TOR in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF

          L1T_FLAG (L1T_NTORS) = 'N'
          L1T_VOBS (L1T_NTORS) = 0.0
          L1T_EVAL (L1T_NTORS) = 0.0
          L1T_VAL  (L1T_NTORS) = LMT_VAL  (L)
          L1T_DEV  (L1T_NTORS) = LMT_DEV  (L)
          L1T_I1ATM (L1T_NTORS) = 0
          L1T_I2ATM (L1T_NTORS) = 0
          L1T_I3ATM (L1T_NTORS) = 0
          L1T_I4ATM (L1T_NTORS) = 0
          L1T_1ATM (L1T_NTORS) = LMT_1ATM (L)
          L1T_2ATM (L1T_NTORS) = LMT_2ATM (L)
          L1T_3ATM (L1T_NTORS) = LMT_3ATM (L)
          L1T_4ATM (L1T_NTORS) = LMT_4ATM (L)
          L1T_PRD  (L1T_NTORS) = LMT_PRD  (L)
          L1T_LABEL(L1T_NTORS) = LMT_LABEL(L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_CMLIB(MDOC,MON,IC,IERR)
C -----------------------------------------------
C -P- CP_CMLIB - copies chiralities from library to special
C -P-            commons for one current monomer /L1M_CHIR/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IC,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1C_NCHIR=0
      IF(LMC_NCHIR.LE.0.OR.LMC_NCHIR.LT.IC.OR.IC.LE.0) RETURN
      DO   L=IC,LMC_NCHIR
        IF(MON.EQ.LMC_MNAME(L)) THEN

          L1C_NCHIR = L1C_NCHIR+1
          IF(L1C_NCHIR.GT.MAX1CHR) THEN
           WRITE(LINE,'(A,A8,A,I6)')
     *   ' ERR: number of chiral centres in monomer ',MON,' >',MAX1CHR
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1CHR in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF

          L1C_FLAG  (L1C_NCHIR) = LMC_FLAG (L)
          L1C_VOL   (L1C_NCHIR) = 0.0
          L1C_VOBS  (L1C_NCHIR) = 0.0
          L1C_EVOL  (L1C_NCHIR) = 0.0
          L1C_I1ATM (L1C_NCHIR) = 0
          L1C_I2ATM (L1C_NCHIR) = 0
          L1C_I3ATM (L1C_NCHIR) = 0
          L1C_I4ATM (L1C_NCHIR) = 0
          L1C_I5ATM (L1C_NCHIR) = 0
          L1C_I6ATM (L1C_NCHIR) = 0
          L1C_I7ATM (L1C_NCHIR) = 0
          L1C_I8ATM (L1C_NCHIR) = 0
          L1C_I9ATM (L1C_NCHIR) = 0
          L1C_1ATM  (L1C_NCHIR) = LMC_1ATM (L)
          L1C_2ATM  (L1C_NCHIR) = LMC_2ATM (L)
          L1C_3ATM  (L1C_NCHIR) = LMC_3ATM (L)
          L1C_4ATM  (L1C_NCHIR) = LMC_4ATM (L)
          L1C_5ATM  (L1C_NCHIR) = LMC_5ATM (L)
          L1C_6ATM  (L1C_NCHIR) = LMC_6ATM (L)
          L1C_7ATM  (L1C_NCHIR) = LMC_7ATM (L)
          L1C_8ATM  (L1C_NCHIR) = LMC_8ATM (L)
          L1C_9ATM  (L1C_NCHIR) = LMC_9ATM (L)
          L1C_SIGN  (L1C_NCHIR) = LMC_SIGN (L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_PMLIB(MDOC,MON,IP,IERR)
C -----------------------------------------------
C -P- CP_PMLIB - copies planarities from library to special
C -P-            commons for one current monomer /L1M_PLAN/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IP,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1P_NPLAN=0
      IF(LMP_NPLAN.LE.0.OR.LMP_NPLAN.LT.IP.OR.IP.LE.0) RETURN
      DO   L=IP,LMP_NPLAN
        IF(MON.EQ.LMP_MNAME(L)) THEN

          L1P_NPLAN = L1P_NPLAN+1
          IF(L1P_NPLAN.GT.MAX1PLN) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     *      ' ERR: number of planar groups in monomer ',MON,' >',MAX1PLN
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1PLN in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF
          IF(LMP_NATOM(L).LE.0.OR.LMP_NATOM(L).GT.MAX1APL) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     &      ' ERR: number of plan atoms in monomer ',MON,' >',MAX1APL
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1APL in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF
          L1P_NATOM (L1P_NPLAN) = LMP_NATOM(L)
          L1P_LABEL (L1P_NPLAN) = LMP_LABEL(L)
          DO   I=1,L1P_NATOM (L1P_NPLAN)
            L1P_FLAG  (I,L1P_NPLAN) = 0
            L1P_DOBS  (I,L1P_NPLAN) = 0.0
            L1P_EDEV  (I,L1P_NPLAN) = 0.0
            L1P_IATOM (I,L1P_NPLAN) = 0
            L1P_DEV   (I,L1P_NPLAN) = LMP_DEV  (I,L)
            L1P_ATOM  (I,L1P_NPLAN) = LMP_ATOM (I,L)
          ENDDO  
        ENDIF
      ENDDO  
      RETURN
      END


      SUBROUTINE COPYL2(MDOC,IERR)
C -----------------------------------------------
C -P- COPYL2 - copis information from /L1A / to /L2A / 
C -S-                               
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
C      CHARACTER LINE*256
C -----------------------------------
      IF(L1A_NATOM.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR : L1A --> L2A number of atoms =0')
        IERR = 1
        RETURN
      ENDIF       

      L2L_NATM    = L1L_NATM
      L2L_NHATM   = L1L_NHATM

      L2L_MNAME   = L1L_MNAME
      L2L_MNAME2  = L1L_MNAME2
      L2L_CODE1   = L1L_CODE1
      L2L_NAME    = L1L_NAME
      L2L_FORM    = L1L_FORM
      L2L_TYPE    = L1L_TYPE
      L2L_MODE    = L1L_MODE
      L2L_FUSE    = L1L_FUSE
      L2L_PRSNT   = L1L_PRSNT 
      L2L_HFLAG   = L1L_HFLAG 

      L2A_NATOM    = L1A_NATOM 
      L2A_NHATOM   = L1A_NHATOM
      L2A_IGATM    = L1A_IGATM  
      L2A_ISTART   = L1A_ISTART
      L2A_IFINISH  = L1A_IFINISH
      L2A_I2START  = L1A_I2START 
      L2A_I2FINISH = L1A_I2FINISH


      DO IATM=1,L1A_NATOM

        L2A_CHARG (IATM) = L1A_CHARG (IATM)
        L2A_X     (IATM) = L1A_X     (IATM)
        L2A_Y     (IATM) = L1A_Y     (IATM)
        L2A_Z     (IATM) = L1A_Z     (IATM)
        L2A_LENGTH(IATM) = L1A_LENGTH(IATM)
        L2A_THETA (IATM) = L1A_THETA (IATM)
        L2A_PHI   (IATM) = L1A_PHI   (IATM)
        L2A_NRING (IATM) = L1A_NRING (IATM)
        L2A_INEW  (IATM) = L1A_INEW  (IATM)
        L2A_IOLD  (IATM) = L1A_IOLD  (IATM)
        L2A_ICR   (IATM) = L1A_ICR   (IATM)
        L2A_IBACK (IATM) = L1A_IBACK (IATM)
        L2A_IFORW (IATM) = L1A_IFORW (IATM)
        L2A_NDIST (IATM) = L1A_NDIST (IATM)
        L2A_NEXTR (IATM) = L1A_NEXTR (IATM)
        L2A_ICHEM (IATM) = L1A_ICHEM (IATM)
        L2A_SF_ID (IATM) = L1A_SF_ID (IATM)
        L2A_ID_PSI(IATM) = L1A_ID_PSI(IATM)
        L2A_SYMB  (IATM) = L1A_SYMB  (IATM)
        L2A_ATYPE (IATM) = L1A_ATYPE (IATM)
        L2A_ANAME (IATM) = L1A_ANAME (IATM)
        L2A_TYPE  (IATM) = L1A_TYPE  (IATM)
        L2A_BACK  (IATM) = L1A_BACK  (IATM)
        L2A_FORW  (IATM) = L1A_FORW  (IATM)
        L2A_CHEM  (IATM) = L1A_CHEM  (IATM)

        L2A_COOR_FLAG(IATM) = L1A_COOR_FLAG(IATM) 
        IF(L1A_NDIST(IATM).GT.0) THEN
          DO  I=1,L1A_NDIST(IATM)
            L2A_CONN     (I,IATM) = L1A_CONN     (I,IATM)
            L2A_LENCON   (I,IATM) = L1A_LENCON   (I,IATM)
            L2A_RING_ID  (I,IATM) = L1A_RING_ID  (I,IATM)
            L2A_RING_ORD (I,IATM) = L1A_RING_ORD (I,IATM)
          ENDDO
        ENDIF

        IF(L1A_NEXTR(IATM).GT.0) THEN
          DO  I=1,L1A_NEXTR(IATM)
            L2A_IEXTR(I,IATM) = L1A_IEXTR(I,IATM)
            L2A_TEXTR(I,IATM) = L1A_TEXTR(I,IATM)
          ENDDO
        ENDIF
        

      ENDDO

      L2N_NCONN = L1N_NCONN 
      IF(L1N_NCONN.GT.0) THEN
        DO I=1,L1N_NCONN
          L2N_I1ATM (I) = L1N_I1ATM (I)
          L2N_I2ATM (I) = L1N_I2ATM (I)
          L2N_1ATM  (I) = L1N_1ATM  (I)
          L2N_2ATM  (I) = L1N_2ATM  (I)
          L2N_TYPE  (I) = L1N_TYPE  (I)
        ENDDO
      ENDIF

      L2B_NBOND = L1B_NBOND 
      IF(L1B_NBOND.GT.0) THEN 
        DO I=1,L1B_NBOND
          L2B_I1ATM (I) = L1B_I1ATM (I)
          L2B_I2ATM (I) = L1B_I2ATM (I)
          L2B_1ATM  (I) = L1B_1ATM  (I)
          L2B_2ATM  (I) = L1B_2ATM  (I)
          L2B_TYPE  (I) = L1B_TYPE  (I)
          L2B_FLAG  (I) = L1B_FLAG  (I) 
          L2B_VAL   (I) = L1B_VAL   (I)
          L2B_DEV   (I) = L1B_DEV   (I)
          L2B_VOBS  (I) = L1B_VOBS  (I) 
          L2B_EVAL  (I) = L1B_EVAL  (I)
        ENDDO
      ENDIF

      L2G_NANGL = L1G_NANGL
      IF(L1G_NANGL.GT.0) THEN
        DO I=1,L1G_NANGL
          L2G_I1ATM (I) = L1G_I1ATM (I)
          L2G_I2ATM (I) = L1G_I2ATM (I)
          L2G_I3ATM (I) = L1G_I3ATM (I)
          L2G_VAL   (I) = L1G_VAL   (I)
          L2G_VOBS  (I) = L1G_VOBS  (I)
          L2G_DEV   (I) = L1G_DEV   (I)
          L2G_EVAL  (I) = L1G_EVAL  (I) 
        ENDDO
      ENDIF

      L2T_NTORS = L1T_NTORS
      IF(L1T_NTORS.GT.0) THEN 
        DO I=1,L1T_NTORS 
          L2T_1ATM  (I) = L1T_1ATM  (I) 
          L2T_2ATM  (I) = L1T_2ATM  (I)
          L2T_3ATM  (I) = L1T_3ATM  (I)
          L2T_4ATM  (I) = L1T_4ATM  (I)
          L2T_LABEL (I) = L1T_LABEL (I)
          L2T_FLAG  (I) = L1T_FLAG  (I)
          L2T_VAL   (I) = L1T_VAL   (I)
          L2T_DEV   (I) = L1T_DEV   (I) 
          L2T_VOBS  (I) = L1T_VOBS  (I)
          L2T_EVAL  (I) = L1T_EVAL  (I)
          L2T_PRD   (I) = L1T_PRD   (I)
          L2T_I1ATM (I) = L1T_I2ATM (I)
          L2T_I2ATM (I) = L1T_I2ATM (I)
          L2T_I3ATM (I) = L1T_I3ATM (I)
          L2T_I4ATM (I) = L1T_I4ATM (I)
        ENDDO
      ENDIF


      L2C_NCHIR = L1C_NCHIR
      IF(L1C_NCHIR.GT.0) THEN
        DO I=1,L1C_NCHIR  
          L2C_I1ATM (I) = L1C_I1ATM (I) 
          L2C_I2ATM (I) = L1C_I2ATM (I)
          L2C_I3ATM (I) = L1C_I3ATM (I) 
          L2C_I4ATM (I) = L1C_I4ATM (I)
          L2C_I5ATM (I) = L1C_I5ATM (I) 
          L2C_I6ATM (I) = L1C_I6ATM (I)
          L2C_I7ATM (I) = L1C_I7ATM (I) 
          L2C_I8ATM (I) = L1C_I8ATM (I)
          L2C_I9ATM (I) = L1C_I9ATM (I)
          L2C_1ATM  (I) = L1C_1ATM  (I)  
          L2C_2ATM  (I) = L1C_2ATM  (I)
          L2C_3ATM  (I) = L1C_3ATM  (I)
          L2C_4ATM  (I) = L1C_4ATM  (I)
          L2C_5ATM  (I) = L1C_5ATM  (I)  
          L2C_6ATM  (I) = L1C_6ATM  (I)
          L2C_7ATM  (I) = L1C_7ATM  (I)
          L2C_8ATM  (I) = L1C_8ATM  (I)
          L2C_9ATM  (I) = L1C_9ATM  (I)
          L2C_SIGN  (I) = L1C_SIGN  (I)
          L2C_FLAG  (I) = L1C_FLAG  (I)
          L2C_VOL   (I) = L1C_VOL   (I)
          L2C_VOBS  (I) = L1C_VOBS  (I)
          L2C_EVOL  (I) = L1C_EVOL  (I)
        ENDDO
      ENDIF

      L2P_NPLAN = L1P_NPLAN
      IF(L1P_NPLAN.GT.0) THEN
        DO I=1, L1P_NPLAN 
          L2P_LABEL (I) = L1P_LABEL (I)
          L2P_NATOM (I) = L1P_NATOM (I)
          IF(L1P_NATOM (I).GT.0) THEN
            DO J=1,L1P_NATOM (I)
              L2P_IATOM (J,I) = L1P_IATOM (J,I)
              L2P_ATOM  (J,I) = L1P_ATOM  (J,I)
              L2P_FLAG  (J,I) = L1P_FLAG  (J,I)
              L2P_DEV   (J,I) = L1P_DEV   (J,I)
              L2P_DOBS  (J,I) = L1P_DOBS  (J,I)
              L2P_EDEV  (J,I) = L1P_EDEV  (J,I) 
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      RETURN

      END

C ******
      SUBROUTINE COPYC2(MDOC,IERR)
C -----------------------------------------------
C -P- COPYC2 - copis information from /CR1ATM/ to /CR2ATM/ 
C -S-                               
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
C      CHARACTER LINE*256
C -----------------------------------
      IF(C1_NATOM.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: C1 --> C2 number of atoms =0')
        IERR=1
        RETURN
      ENDIF       

      C2_NATOM  = C1_NATOM 
      C2_IGLOBAL= C1_IGLOBAL  
      C2_IGATM  = C1_IGATM  
      C2_ICH    = C1_ICH  
      C2_IRES   = C1_IRES 
      C2_IGRES  = C1_IGRES
      C2_RNAME  = C1_RNAME
      C2_CODE1  = C1_CODE1
      C2_PNUM   = C1_PNUM
      C2_RTYPE  = C1_RTYPE
      C2_S_TERM = C1_S_TERM
      C2_F_TERM = C1_F_TERM

      DO   IATM=1,MX1ATOM
        S2_CONN_S (IATM) = S1_CONN_S (IATM)
        S2_CONN_F (IATM) = S1_CONN_F (IATM) 
        S2_ISTART (IATM) = S1_ISTART (IATM)
        S2_IFINISH(IATM) = S1_IFINISH(IATM)
      ENDDO

      DO   IATM=1,C1_NATOM
        C2_NALT  (IATM) = C1_NALT (IATM)
        C2_ANAME (IATM) = C1_ANAME(IATM)
        C2_ANAME_INP(IATM) = C1_ANAME_INP(IATM)
        C2_IALT  (IATM) = C1_IALT (IATM)  
        DO   I=1,3
          C2_XYZ(I,IATM) = C1_XYZ (I,IATM)
          C2_CSD(I,IATM) = C1_CSD (I,IATM)
        ENDDO
        DO   I=1,6
          C2_ANIS(I,IATM) = C1_ANIS (I,IATM)
          C2_ASD (I,IATM) = C1_ASD  (I,IATM)
        ENDDO
        C2_BISO  (IATM) = C1_BISO (IATM)
        C2_OCC   (IATM) = C1_OCC  (IATM)
        C2_BSD   (IATM) = C1_BSD  (IATM)
        C2_OSD   (IATM) = C1_OSD  (IATM)
        C2_USER  (IATM) = C1_USER (IATM)
        C2_ASYMB (IATM) = C1_ASYMB(IATM)
        C2_SF_ID (IATM) = C1_SF_ID(IATM)
        C2_ATYPE (IATM) = C1_ATYPE(IATM)
        C2_ALT   (IATM) = C1_ALT  (IATM)
        C2_SEG   (IATM) = C1_SEG  (IATM)
        C2_CORR  (IATM) = C1_CORR (IATM)
        C2_BTYPE (IATM) = C1_BTYPE(IATM)
        C2_FSC   (IATM) = C1_FSC  (IATM)
        C2_FSA   (IATM) = C1_FSA  (IATM)
        C2_FUS   (IATM) = C1_FUS  (IATM)
        S2_INEW  (IATM) = S1_INEW (IATM)
        S2_IOLD  (IATM) = S1_IOLD (IATM)
        S2_ILIB  (IATM) = S1_ILIB (IATM)
        S2_ICRD  (IATM) = S1_ICRD (IATM)
        S2_IBACK (IATM) = S1_IBACK(IATM)
        S2_IFORW (IATM) = S1_IFORW(IATM)
        S2_BACK  (IATM) = S1_BACK (IATM)
        S2_FORW  (IATM) = S1_FORW (IATM)
        S2_ILIB  (IATM) = S1_ILIB (IATM)
        S2_NDIST (IATM) = S1_NDIST(IATM)
        S2_NEXTR (IATM) = S1_NEXTR(IATM)
        S2_HBT   (IATM) = S1_HBT  (IATM)
        S2_ID_PSI(IATM) = S1_ID_PSI(IATM)
        S2_VDW   (IATM) = S1_VDW  (IATM)
        S2_ION   (IATM) = S1_ION  (IATM)
        S2_CHAR  (IATM) = S1_CHAR (IATM)
        S2_CHEM  (IATM) = S1_CHEM (IATM)
        S2_ICHEM (IATM) = S1_ICHEM(IATM)
        S2_FTREE        = S1_FTREE  
        DO  I=1,MX1BRN
          S2_CONN(I,IATM)   = S1_CONN(I,IATM)
          S2_LENCON(I,IATM) = S1_LENCON(I,IATM)
        ENDDO
        DO  I=1,MX1EXT
          S2_IEXTR(I,IATM) = S1_IEXTR(I,IATM)
        ENDDO
        DO   I=1,3
          S2_DIST(IATM) = S1_DIST (IATM)
          S2_THT (IATM) = S1_THT  (IATM)
          S2_PSI (IATM) = S1_PSI  (IATM)
        ENDDO
      
      ENDDO
      RETURN
      END

C ******
      SUBROUTINE COPYC1(MDOC,IERR)
C -----------------------------------------------
C -P- COPYC1 - copis information from /CR2ATM/ to /CR1ATM/ 
C -S-                               
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
C      CHARACTER LINE*256
C -----------------------------------
      IF(C2_NATOM.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: C2 --> C1 number of atoms =0')
        IERR=1
        RETURN
      ENDIF       

      C1_NATOM  = C2_NATOM 
      C1_IGLOBAL= C2_IGLOBAL  
      C1_IGATM  = C2_IGATM  
      C1_ICH    = C2_ICH  
      C1_IRES   = C2_IRES 
      C1_IGRES  = C2_IGRES
      C1_RNAME  = C2_RNAME
      C1_CODE1  = C2_CODE1
      C1_PNUM   = C2_PNUM
      C1_RTYPE  = C2_RTYPE
      C1_S_TERM = C2_S_TERM
      C1_F_TERM = C2_F_TERM

      DO   IATM=1,MX1ATOM
        S1_CONN_S (IATM) = S2_CONN_S (IATM)
        S1_CONN_F (IATM) = S2_CONN_F (IATM) 
        S1_ISTART (IATM) = S2_ISTART (IATM)
        S1_IFINISH(IATM) = S2_IFINISH(IATM)
      ENDDO

      DO   IATM=1,C2_NATOM
        C1_NALT  (IATM) = C2_NALT (IATM)
        C1_ANAME (IATM) = C2_ANAME(IATM)
        C1_ANAME_INP(IATM) = C2_ANAME_INP(IATM)
        C1_IALT  (IATM) = C2_IALT (IATM)  
        DO   I=1,3
          C1_XYZ(I,IATM) = C2_XYZ (I,IATM)
          C1_CSD(I,IATM) = C2_CSD (I,IATM)
        ENDDO
        DO   I=1,6
          C1_ANIS(I,IATM) = C2_ANIS (I,IATM)
          C1_ASD (I,IATM) = C2_ASD  (I,IATM)
        ENDDO
        C1_BISO  (IATM) = C2_BISO (IATM)
        C1_OCC   (IATM) = C2_OCC  (IATM)
        C1_BSD   (IATM) = C2_BSD  (IATM)
        C1_OSD   (IATM) = C2_OSD  (IATM)
        C1_USER  (IATM) = C2_USER (IATM)
        C1_ASYMB (IATM) = C2_ASYMB(IATM)
        C1_SF_ID (IATM) = C2_SF_ID(IATM)
        C1_ATYPE (IATM) = C2_ATYPE(IATM)
        C1_ALT   (IATM) = C2_ALT  (IATM)
        C1_SEG   (IATM) = C2_SEG  (IATM)
        C1_CORR  (IATM) = C2_CORR (IATM)
        C1_BTYPE (IATM) = C2_BTYPE(IATM)
        C1_FSC   (IATM) = C2_FSC  (IATM)
        C1_FSA   (IATM) = C2_FSA  (IATM)
        C1_FUS   (IATM) = C2_FUS  (IATM)
        S1_INEW  (IATM) = S2_INEW (IATM)
        S1_IOLD  (IATM) = S2_IOLD (IATM)
        S1_ILIB  (IATM) = S2_ILIB (IATM)
        S1_ICRD  (IATM) = S2_ICRD (IATM)
        S1_IBACK (IATM) = S2_IBACK(IATM)
        S1_IFORW (IATM) = S2_IFORW(IATM)
        S1_BACK  (IATM) = S2_BACK (IATM)
        S1_FORW  (IATM) = S2_FORW (IATM)
        S1_ILIB  (IATM) = S2_ILIB (IATM)
        S1_NDIST (IATM) = S2_NDIST(IATM)
        S1_NEXTR (IATM) = S2_NEXTR(IATM)
        S1_HBT   (IATM) = S2_HBT  (IATM)
        S1_ID_PSI(IATM) = S2_ID_PSI(IATM)
        S1_VDW   (IATM) = S2_VDW  (IATM)
        S1_ION   (IATM) = S2_ION  (IATM)
        S1_CHAR  (IATM) = S2_CHAR (IATM)
        S1_CHEM  (IATM) = S2_CHEM (IATM)
        S1_ICHEM (IATM) = S2_ICHEM(IATM)
        S1_FTREE        = S2_FTREE  
        DO  I=1,MX1BRN
          S1_CONN(I,IATM)   = S2_CONN(I,IATM)
          S1_LENCON(I,IATM) = S2_LENCON(I,IATM)
        ENDDO
        DO  I=1,MX1EXT
          S1_IEXTR(I,IATM) = S2_IEXTR(I,IATM)
        ENDDO
        DO   I=1,3
          S1_DIST(IATM) = S2_DIST (IATM)
          S1_THT (IATM) = S2_THT  (IATM)
          S1_PSI (IATM) = S2_PSI  (IATM)
        ENDDO
      
      ENDDO
      RETURN
      END


C ******
      SUBROUTINE CPL_MLIB(MDOC,IERR)
C -----------------------------------------------
C -P- CP_MLIB - copies monomer's information to library from special
C -P-           commons for one current monomer /L1M_LIST/,/L1M_ATOM/,... 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER MON*8
C     CHARACTER MMM*8
      CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      MON  = L1L_MNAME
      IF(L1A_NATOM.LE.0) THEN
        CALL MSGERR(MDOC
     *  ,' ERR: number of atoms of monomer in library_L1 = 0')
        IERR=1
        RETURN
      ENDIF
      IF(LML_NMON.GE.MAXMLIST) THEN
C       WRITE(LINE,'(A,I6,A)')
C    *   ' ERR: number of monomers >',MAXMLIST,' /lib. limit/'
        WRITE(LINE,'(A,I6,A,I6,A)')
     *   ' ERR: number of monomers =',LML_NMON,' >',MAXMLIST,
     *   ' /lib. limit/'
        CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMLIST in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF

      L_PASS = 3

      IF(LML_NMON.GT.0) THEN

        DO   LL=1,LML_NMON

          IF(MON.EQ.LML_MNAME(LL)) THEN

            IA = LML_IATOM(LL)
            IN = LML_ICONN(LL)
            IB = LML_IBOND(LL)
            IG = LML_ITHET(LL)
            IT = LML_ITORS(LL)
            IP = LML_IPLAN(LL)
            IC = LML_ICHIR(LL)
            L_PASS = LML_PASS(LL)
  
            IF(LMA_NATOM.GT.0.AND.LMA_NATOM.GE.IA.AND.IA.GT.0) THEN
              DO   L=IA,LMA_NATOM
                IF(MON.EQ.LMA_MNAME(L)) LMA_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMN_NCONN.GT.0.AND.LMN_NCONN.GE.IN.AND.IN.GT.0) THEN
              DO   L=IN,LMN_NCONN
                IF(MON.EQ.LMN_MNAME(L)) LMN_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMB_NBOND.GT.0.AND.LMB_NBOND.GE.IB.AND.IB.GT.0) THEN
              DO   L=IB,LMB_NBOND
                IF(MON.EQ.LMB_MNAME(L)) LMB_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMG_NANGL.GT.0.AND.LMG_NANGL.GE.IG.AND.IG.GT.0) THEN
              DO   L=IG,LMG_NANGL
                IF(MON.EQ.LMG_MNAME(L)) LMG_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMT_NTORS.GT.0.AND.LMT_NTORS.GE.IT.AND.IT.GT.0) THEN
              DO   L=IT,LMT_NTORS
                IF(MON.EQ.LMT_MNAME(L)) LMT_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMC_NCHIR.GT.0.AND.LMC_NCHIR.GE.IC.AND.IC.GT.0) THEN
              DO   L=IC,LMC_NCHIR
                IF(MON.EQ.LMC_MNAME(L)) LMC_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMP_NPLAN.GT.0.AND.LMP_NPLAN.GE.IP.AND.IP.GT.0) THEN
              DO   L=IP,LMP_NPLAN
                IF(MON.EQ.LMP_MNAME(L)) LMP_MNAME(L) = '?'
              ENDDO
            ENDIF

            LML_MNAME(LL) = '???'
            LML_FUSE(LL)  = 'N'
C           LML_FUSE(LL)  = '?'
            LML_IATOM(LL) = 0
            LML_ICONN(LL) = 0
            LML_IBOND(LL) = 0
            LML_ITHET(LL) = 0
            LML_ITORS(LL) = 0
            LML_IPLAN(LL) = 0
            LML_ICHIR(LL) = 0

          ENDIF

        ENDDO  
      ENDIF

      LML_NMON     = LML_NMON+1
      LML_IMON     = LML_NMON
      L            = LML_IMON
      LML_NATM (L) = L1L_NATM
      LML_NHATM(L) = L1L_NHATM
      LML_MNAME(L) = L1L_MNAME 
      LML_MNAME2(L)= L1L_MNAME2 
      LML_NAME (L) = L1L_NAME 
      LML_FORM (L) = L1L_FORM 
      LML_CODE1(L) = L1L_CODE1
      LML_TYPE (L) = L1L_TYPE
      LML_MODE (L) = L1L_MODE
      LML_FUSE (L) = L1L_FUSE
      LML_PRSNT(L) = L1L_PRSNT
      LML_PASS(L)  = L_PASS

      LML_IATOM(L) = 0
      LML_ICONN(L) = 0
      LML_IBOND(L) = 0
      LML_ITHET(L) = 0
      LML_ITORS(L) = 0
      LML_IPLAN(L) = 0
      LML_ICHIR(L) = 0
      IA           = L1A_NATOM
      IN           = L1N_NCONN
      IB           = L1B_NBOND
      IG           = L1G_NANGL
      IT           = L1T_NTORS
      IC           = L1C_NCHIR
      IP           = L1P_NPLAN
      IF(IA.GT.0) THEN
        CALL CPL_AMLIB(MDOC,MON,IA,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IN.GT.0) THEN
        CALL CPL_NMLIB(MDOC,MON,IN,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IB.GT.0) THEN
        CALL CPL_BMLIB(MDOC,MON,IB,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IG.GT.0) THEN
        CALL CPL_GMLIB(MDOC,MON,IG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IT.GT.0) THEN
        CALL CPL_TMLIB(MDOC,MON,IT,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IP.GT.0) THEN
        CALL CPL_PMLIB(MDOC,MON,IP,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IC.GT.0) THEN
        CALL CPL_CMLIB(MDOC,MON,IC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      RETURN
      END

C ******
      SUBROUTINE CPL_AMLIB(MDOC,MON,IA,IERR)
C -----------------------------------------------
C -P- CP_AMLIB - copy atom's information from library to special
C -P-            commons for one current monomer /L1M_ATOM/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IA,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      L=LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      IAH = 0
      DO   II=1,IA
        I=L1A_IOLD(II)
        IF(LMA_NATOM.GE.MAXMATM) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of atoms for monomer ',MON,' >',MAX1ATM,
     *     ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMATM in "lib_com.fh"')
          LML_IMON = 0           
          IERR=1
          RETURN
        ENDIF
        LMA_NATOM=LMA_NATOM+1
        IF(LML_IATOM(L).EQ.0) LML_IATOM(L)=LMA_NATOM 
        LA=LMA_NATOM
        LMA_MNAME(LA)     = MON
        LMA_COOR_FLAG(LA) = L1A_COOR_FLAG(I)
        LMA_CHARG(LA)     = L1A_CHARG(I)
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
          LMA_X    (LA) = L1A_X    (I)
          LMA_Y    (LA) = L1A_Y    (I)
          LMA_Z    (LA) = L1A_Z    (I)
        ELSE
          LMA_X    (LA) = 0.0
          LMA_Y    (LA) = 0.0
          LMA_Z    (LA) = 0.0
        ENDIF
        LMA_BACK (LA) = L1A_BACK (I)
        LMA_TYPE (LA) = L1A_TYPE (I)
        LMA_FORW (LA) = L1A_FORW (I)
        LMA_ANAME(LA) = L1A_ANAME(I)
        LMA_SYMB (LA) = L1A_SYMB (I) 
        LMA_SF_ID(LA) = L1A_SF_ID(I) 
        LMA_CHEM (LA) = L1A_CHEM (I)
        IF(L1A_SYMB(I)(1:2).NE.'H '.AND.
     *    L1A_SYMB(I)(1:2).NE.'D ' )
     *    IAH = IAH + 1
      ENDDO  
      LML_NATM (L) = IA
      LML_NHATM(L) = IAH
      RETURN
      END

C ******
      SUBROUTINE CPL_NMLIB(MDOC,MON,IN,IERR)
C -----------------------------------------------
C -P- CP_NMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IN,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      L=LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IN
        IF(LMN_NCONN.GE.MAXMCNN) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of connections for monomer ',MON,' >',MAXMCNN,
     *    ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMCNN in "lib_com.fh"')
          LML_IMON = 0           
          IERR = 1
          RETURN
        ENDIF
        LMN_NCONN=LMN_NCONN+1
        IF(LML_ICONN(L).EQ.0) LML_ICONN(L)=LMN_NCONN 
        LN            = LMN_NCONN
        LMN_MNAME(LN) = MON
        LMN_1ATM (LN) = L1N_1ATM (I)
        LMN_2ATM (LN) = L1N_2ATM (I)
        LMN_TYPE (LN) = L1N_TYPE (I)
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_BMLIB(MDOC,MON,IB,IERR)
C -----------------------------------------------
C -P- CP_BMLIB - copies bond's information from library to special
C -P-            commons for one current monomer /L1M_BOND/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IB,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IB
        IF(LMB_NBOND.GE.MAXMBND) THEN
        WRITE(LINE,'(A,A8,A,I6,A)')' ERR: number of bonds for monomer '
     *    ,MON,'  >',MAXMBND,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMBND in "lib_com.fh"')
          LML_IMON = 0           
          IERR = 1
          RETURN
        ENDIF
        LMB_NBOND = LMB_NBOND+1
        IF(LML_IBOND(L).EQ.0) LML_IBOND(L) = LMB_NBOND 
        LB            = LMB_NBOND
        LMB_MNAME(LB) = MON
        LMB_VAL  (LB) = L1B_VAL  (I)
        LMB_DEV  (LB) = L1B_DEV  (I)
        LMB_1ATM (LB) = L1B_1ATM (I)
        LMB_2ATM (LB) = L1B_2ATM (I)
        LMB_TYPE (LB) = L1B_TYPE (I)
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_GMLIB(MDOC,MON,IG,IERR)
C -----------------------------------------------
C -P- CP_GMLIB - copies angle's information from library to special
C -P-            commons for one current monomer /L1M_ANGL/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IG
        IF(LMG_NANGL.GE.MAXMANG) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of angles for monomer ',MON,' >',MAXMANG,
     *    ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMANG in "lib_com.fh"')
          LML_IMON = 0           
          IERR = 1
          RETURN
        ENDIF
        LMG_NANGL = LMG_NANGL+1
        IF(LML_ITHET(L).EQ.0) LML_ITHET(L) = LMG_NANGL 
        LG            = LMG_NANGL
        LMG_MNAME(LG) = MON
        LMG_VAL  (LG) = L1G_VAL  (I)
c        write(*,*)'Now copying ',lmg_val(lg),l1g_val(i)
        LMG_DEV  (LG) = L1G_DEV  (I)
        LMG_1ATM (LG) = L1G_1ATM (I)
        LMG_2ATM (LG) = L1G_2ATM (I)
        LMG_3ATM (LG) = L1G_3ATM (I)
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_TMLIB(MDOC,MON,IT,IERR)
C -----------------------------------------------
C -P- CP_TMLIB - copies tortion's information from library to special
C -P-            commons for one current monomer /L1M_TORS/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IT,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IT
        IF(LMT_NTORS.GE.MAXMTOR) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of torsions for monomer ',MON,' >',MAXMTOR,
     *     ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMTOR in "lib_com.fh"')

          LML_IMON = 0           
          IERR = 1
          RETURN
        ENDIF
        LMT_NTORS = LMT_NTORS+1
        IF(LML_ITORS(L).EQ.0) LML_ITORS(L) = LMT_NTORS 
        LT            = LMT_NTORS
        LMT_MNAME(LT) = MON
        LMT_VAL  (LT) = L1T_VAL  (I)
        LMT_DEV  (LT) = L1T_DEV  (I)
        LMT_1ATM (LT) = L1T_1ATM (I)
        LMT_2ATM (LT) = L1T_2ATM (I)
        LMT_3ATM (LT) = L1T_3ATM (I)
        LMT_4ATM (LT) = L1T_4ATM (I)
        LMT_PRD  (LT) = L1T_PRD  (I)
        LMT_LABEL(LT) = L1T_LABEL(I)
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_CMLIB(MDOC,MON,IC,IERR)
C -----------------------------------------------
C -P- CP_CMLIB - copies chiralities from library to special
C -P-            commons for one current monomer /L1M_CHIR/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IC,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IC
        IF(LMC_NCHIR.GE.MAXMCHR) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *  ' ERR: number of chiralities for monomer ',MON,' >',MAXMCHR,
     *  ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMCHR in "lib_com.fh"')
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        LMC_NCHIR = LMC_NCHIR+1
        IF(LML_ICHIR(L).EQ.0) LML_ICHIR(L) = LMC_NCHIR 
        LC             = LMC_NCHIR
        LMC_MNAME (LC) = MON
        LMC_1ATM  (LC) = L1C_1ATM (I)
        LMC_2ATM  (LC) = L1C_2ATM (I)
        LMC_3ATM  (LC) = L1C_3ATM (I)
        LMC_4ATM  (LC) = L1C_4ATM (I)
        LMC_5ATM  (LC) = L1C_5ATM (I)
        LMC_6ATM  (LC) = L1C_6ATM (I)
        LMC_7ATM  (LC) = L1C_7ATM (I)
        LMC_8ATM  (LC) = L1C_8ATM (I)
        LMC_9ATM  (LC) = L1C_9ATM (I)
        LMC_SIGN  (LC) = L1C_SIGN (I)
        LMC_FLAG  (LC) = L1C_FLAG (I)

      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_PMLIB(MDOC,MON,IP,IERR)
C -----------------------------------------------
C -P- CP_PMLIB - copies planarities from library to special
C -P-            commons for one current monomer /L1M_PLAN/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IP,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IP
        IF(LMP_NPLAN.GE.MAXMPLN) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of plan groups for monomer ',MON,' >',
     *    LMP_NPLAN,
     *    ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMPLN in "lib_com.fh"')
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        LMP_NPLAN = LMP_NPLAN+1
        IF(LML_IPLAN(L).EQ.0) LML_IPLAN(L) = LMP_NPLAN 
        LP = LMP_NPLAN

        IF(L1P_NATOM(I).GT.MAXMAPL) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of plan atoms in monomer ',MON,' >',MAXMAPL,
     *    '  or = 0'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMAPL in "lib_com.fh"')
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        LMP_MNAME(LP) = MON
        LMP_NATOM(LP) = L1P_NATOM(I)
        LMP_LABEL(LP) = L1P_LABEL(I)
        DO   IA=1,L1P_NATOM(I)
          LMP_DEV   (IA,LP) = L1P_DEV  (IA,I)
          LMP_ATOM  (IA,LP) = L1P_ATOM (IA,I)
        ENDDO  
      ENDDO  
      RETURN
      END


C ******
      SUBROUTINE SET_FUSE_Y(MDOC,IERR)
C -----------------------------------------
C -P- SET_FUSE_Y - replacet use_flag "R" to "Y" 
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
C ******
C -----------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------
      IERR = 0
      IF(LML_NMON.LE.0) RETURN

      DO L=1,LML_NMON
        IF(LML_FUSE(L).EQ.'R') THEN
          LML_FUSE(L) = 'Y'
        ENDIF
      ENDDO

      RETURN
      END     

      SUBROUTINE CHECK_FUSE_R(MDOC,IERR)
C -----------------------------------------------
C
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER MON*8
C -----------------------------------
      IERR = 0
      IF(LML_NMON.LE.0) RETURN

      DO   LL=1,LML_NMON

        IF(LML_FUSE(LL).EQ.'R') THEN
 
          MON       = LML_MNAME(LL) 

          IA = LML_IATOM(LL)
          IN = LML_ICONN(LL)
          IB = LML_IBOND(LL)
          IG = LML_ITHET(LL)
          IT = LML_ITORS(LL)
          IP = LML_IPLAN(LL)
          IC = LML_ICHIR(LL)
  
          IF(LMA_NATOM.GT.0.AND.LMA_NATOM.GE.IA.AND.IA.GT.0) THEN
            DO   L=IA,LMA_NATOM
              IF(MON.EQ.LMA_MNAME(L)) LMA_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMN_NCONN.GT.0.AND.LMN_NCONN.GE.IN.AND.IN.GT.0) THEN
            DO   L=IN,LMN_NCONN
              IF(MON.EQ.LMN_MNAME(L)) LMN_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMB_NBOND.GT.0.AND.LMB_NBOND.GE.IB.AND.IB.GT.0) THEN
            DO   L=IB,LMB_NBOND
              IF(MON.EQ.LMB_MNAME(L)) LMB_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMG_NANGL.GT.0.AND.LMG_NANGL.GE.IG.AND.IG.GT.0) THEN
            DO   L=IG,LMG_NANGL
              IF(MON.EQ.LMG_MNAME(L)) LMG_MNAME(L) = "?"
            ENDDO
          ENDIF
          IF(LMT_NTORS.GT.0.AND.LMT_NTORS.GE.IT.AND.IT.GT.0) THEN
            DO   L=IT,LMT_NTORS
              IF(MON.EQ.LMT_MNAME(L)) LMT_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMC_NCHIR.GT.0.AND.LMC_NCHIR.GE.IC.AND.IC.GT.0) THEN
            DO   L=IC,LMC_NCHIR
              IF(MON.EQ.LMC_MNAME(L)) LMC_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMP_NPLAN.GT.0.AND.LMP_NPLAN.GE.IP.AND.IP.GT.0) THEN
            DO   L=IP,LMP_NPLAN
              IF(MON.EQ.LMP_MNAME(L)) LMP_MNAME(L) = '?'
            ENDDO
          ENDIF

          LML_IATOM(LL) = 0
          LML_ICONN(LL) = 0
          LML_IBOND(LL) = 0
          LML_ITHET(LL) = 0
          LML_ITORS(LL) = 0
          LML_IPLAN(LL) = 0
          LML_ICHIR(LL) = 0

C          LML_NATM (LL) = 0
C          LML_NHATM(LL) = 0

        ENDIF
      ENDDO
      RETURN
      END
    
C ******
      SUBROUTINE PUT_MNLIB(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PUT_MNLIB - reads monomer's library.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR = 0

      CALL LENSTR_BL(ITL_CMP ,LCMP)
      CALL LENSTR_BL(ITL_CMPA,LCMPA)
      CALL LENSTR_BL(ITL_CMPR,LCMPR)
      CALL LENSTR_BL(ITL_CMPB,LCMPB)
      CALL LENSTR_BL(ITL_CMPG,LCMPG)
      CALL LENSTR_BL(ITL_CMPT,LCMPT)
      CALL LENSTR_BL(ITL_CMPC,LCMPC)
      CALL LENSTR_BL(ITL_CMPP,LCMPP)

C     IF(ITEM(1:11).EQ.'_chem_comp.') THEN

      IF(ITEM(1:LCMP).EQ.ITL_CMP(1:LCMP)) THEN

      ELSE IF(ITEM(1:LCMPA).EQ.ITL_CMPA(1:LCMPA)) THEN
        CALL PT_MATOM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LCMPR).EQ.ITL_CMPR(1:LCMPR)) THEN
        IF(LML_IMON.GT.0) THEN
C       IF(LML_PRSNT(LML_IMON).NE.'M') THEN
        IF(LML_PRSNT(LML_IMON).NE.'M'.AND.LML_PASS(LML_IMON).LE.1) THEN
          CALL PT_CONNECT(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ENDIF
        ENDIF
      ELSE IF(ITEM(1:LCMPB).EQ.ITL_CMPB(1:LCMPB)) THEN
        CALL PT_MBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LCMPG).EQ.ITL_CMPG(1:LCMPG)) THEN
        IF(LML_IMON.GT.0) THEN
        IF(LML_PRSNT(LML_IMON).NE.'M') THEN
          CALL PT_MANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ENDIF
        ENDIF
      ELSE IF(ITEM(1:LCMPT).EQ.ITL_CMPT(1:LCMPT)) THEN
        IF(LML_IMON.GT.0) THEN
        IF(LML_PRSNT(LML_IMON).NE.'M') THEN
          CALL PT_MTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ENDIF
        ENDIF
      ELSE IF(ITEM(1:LCMPC).EQ.ITL_CMPC(1:LCMPC)) THEN
        CALL PT_MCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LCMPP).EQ.ITL_CMPP(1:LCMPP)) THEN
        IF(LML_IMON.GT.0) THEN
        IF(LML_PRSNT(LML_IMON).NE.'M') THEN
          CALL PT_MPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ENDIF
        ENDIF
      ENDIF
c
c---  sort out chiralities here

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C ---------------------------------------------
C -P- PT_MLIST - reads monomer's information: NAME,CODE1,NATOM,...
C                if LB_TFLAG = 'N' 
C                       read all, set flag LML_FUSE = 'Y' and
C                       LML_IMON = serial number of monomer in the list.
C                if LB_TFLAG = 'Y' 
C                       read only NAME if it is in the list LMB_MNAME of
C                       common/LMB_LIST/ which has been created before and
C                       if LML_fuse = 'Y'.
C                    
C                set LML_IMON = serial number of monomer in the list or
C                = 0 if this monomer's name hasn's been found in the list
C                        or if LML_FUSE was equel 'N'.
C -S-
C ---------------------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      CHARACTER LINE*256,MON*8
C ---
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------
      IERR = 0
      CALL LENSTR_BL(ITL_CMP_ID,LC_ID)
      IF(ITEM(1:LC_ID).EQ.ITL_CMP_ID(1:LC_ID)) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp.id :',DATA(1:8),
     *          ' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        IF(LB_TFLAG.EQ.'N') THEN
C         read all
          IF(LML_NMON.GE.MAXMLIST) THEN
            WRITE(LINE,'(A,I6,A)')' ERROR: number of monomers >',
     *      MAXMLIST,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LML_NMON = 0
            IERR     = 1
            RETURN
          ENDIF

          MON=DATA(1:8)

          IF(LML_NMON.GT.0) THEN
            DO IM=1,LML_NMON
              IF(MON.EQ.LML_MNAME(IM))THEN
C !!!!
                WRITE(LINE,'(A,A8)')
     *      ' WARNING: duplicated name of monomer ',MON
                CALL MSGDOC(MDOC,LINE)
                CALL MSGDOC(MDOC,
     *  '          Last entry will be used.')
                LML_IMON = IM
                GO TO 100 
              ENDIF
            ENDDO
          ENDIF

          LML_NMON = LML_NMON+1
          LML_IMON = LML_NMON

 100      CONTINUE

          II                  = LML_IMON
          LML_MNAME (II)      = MON
          LML_MNAME2(II)      = MON(1:3)
          LML_FUSE  (II)      = 'N'
          LML_PRSNT (II)      = '.'
          LML_FORM  (II)      = '.'             
          LML_NAME  (II)      = '.'             
          LML_TYPE  (II)      = '.'             
          LML_CODE1 (II)      = '.'
          LML_PASS  (II)      = LB_PASS

        ELSE
C         read only name is in the list of monomers
          MON = DATA(1:8)
          IF(LML_NMON.LE.0) THEN
            CALL MSGERR(MDOC
     *      ,' ERROR: number of monomers in the list = 0')
            IERR = 1
            RETURN
          ENDIF
          DO L=1,LML_NMON
            IF(MON.EQ.LML_MNAME(L).AND.LML_FUSE(L).EQ.'Y') THEN
              LML_IMON = L
              RETURN
            ENDIF
          ENDDO
          LML_IMON = 0           
        ENDIF
        RETURN
      ENDIF
C COMLETENESS ????
C      DATA ITL_CMP_ID    /'_chem_comp.id                           '/
C      DATA ITL_CMP_3LT   /'_chem_comp.three_letter_code            '/
C      DATA ITL_CMP_TYP   /'_chem_comp.group                        '/
C      DATA ITL_CMP_NA    /'_chem_comp.number_atoms_all             '/
C      DATA ITL_CMP_NH    /'_chem_comp.number_atoms_nh              '/
C      DATA ITL_CMP_NAM   /'_chem_comp.name                         '/
C      DATA ITL_CMP_FOR   /'_chem_comp.formula                      '/
C      DATA ITL_CMP_DSC   /'_chem_comp.desc_level                   '/
      CALL LENSTR_BL(ITL_CMP_3LT ,L3LT)
      CALL LENSTR_BL(ITL_CMP_TYP ,LTYP)
      CALL LENSTR_BL(ITL_CMP_NA  ,LNA)
      CALL LENSTR_BL(ITL_CMP_NH  ,LNH)
      CALL LENSTR_BL(ITL_CMP_NAM ,LNM)
      CALL LENSTR_BL(ITL_CMP_DSC ,LDS)

      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(12:26).EQ.'one_letter_code'  ) THEN
          LML_CODE1(LML_IMON)=DATA(1:1)
        ELSE IF(ITEM(1:L3LT).EQ.ITL_CMP_3LT(1:L3LT)) THEN
          LML_MNAME2(LML_IMON)=DATA(1:LEND)
        ELSE IF(ITEM(1:LTYP).EQ.ITL_CMP_TYP(1:LTYP)) THEN
          LML_TYPE (LML_IMON)=DATA(1:LEND)
        ELSE IF(ITEM(1:LNA).EQ.ITL_CMP_NA(1:LNA)) THEN
          LML_NATM (LML_IMON)=IDATA
        ELSE IF(ITEM(1:LNH).EQ.ITL_CMP_NH(1:LNH)) THEN
          LML_NHATM (LML_IMON)=IDATA
        ELSE IF(ITEM(1:LNM).EQ.ITL_CMP_NAM(1:LNM)) THEN
          LML_NAME(LML_IMON)=DATA(1:LEND)
        ELSE IF(ITEM(12:18).EQ.'formula') THEN
          LML_FORM(LML_IMON)=DATA(1:LEND)
        ELSE IF(ITEM(1:LDS).EQ.ITL_CMP_DSC(1:LDS)) THEN
          IF(DATA(1:1).EQ.'m') DATA(1:1) = 'M'
          if(data(1:1).ne.'M') data(1:1) = '.'
          LML_PRSNT(LML_IMON)=DATA(1:1)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MSYN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MSYN - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
C -----------------------------------
      IERR=0
     
      IST = 1
      IF(ITEM(1:24).EQ.'_chem_comp_synonym_atom.' ) THEN
        IST = 25 
      ELSE IF(ITEM(1:19).EQ.'_chem_comp_synonym.' ) THEN
        IST = 20 
      ENDIF

      IFN = IST + 6
      IF(ITEM(IST:IFN).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')
     *    ' ERR: item _chem_comp_synonym.comp_id :',DATA(1:8),
     *    ' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF

        MON = DATA(1:8)

c        IF(LML_NMON.LE.0) THEN
c          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
c          IERR = 1
c          RETURN
c        ENDIF

        IF(LML_IMON.EQ.0) LML_IMON=1

c        DO J=1,LML_NMON
c          L = (LML_IMON-1)+J
c          IF(L.GT.LML_NMON) L = L-LML_NMON
c          IF(MON.EQ.LML_MNAME(L)) THEN
c            IF(LML_FUSE(L).NE.'Y'.OR.LB_PASS.NE.LML_PASS(L)) THEN
c              LML_IMON = 0           
c              RETURN
c            ENDIF
c            LML_IMON = L

            LMS_NSYN = LMS_NSYN + 1
            IF(LMS_NSYN.GT.MAXMLIST) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERROR: read number of synonyms',MON,' >',MAXMLIST,
     *      ' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF

c            IF(LML_ISYN(L).EQ.0) LML_ISYN(L) = LMS_NSYN 

            LMS_MNAME (LMS_NSYN) = DATA(1:8)
            LMS_ATOM  (LMS_NSYN) = '.'
            LMS_AATOM (LMS_NSYN) = '.'
            LMS_AMNAME(LMS_NSYN) = '.'
            LMS_MOD   (LMS_NSYN) = '.'
            LMS_FLAG  (LMS_NSYN) = '.'
            IF(LB_PASS.GT.LB_NUMB_LIB) LMS_FLAG(LMS_NSYN) = 'N'
            LMS_ISYN             = 0

            RETURN
c          ENDIF
c        ENDDO

c        WRITE(LINE,'(
c     *  '' ERROR: item _chem_comp_synonym.comp_id :'',A8
c     *          ,'' not found in the monomer list'')') MON
c        CALL MSGERR(MDOC,LINE)
c        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
c        CALL MSGERR(MDOC,LINE)
c        LML_IMON = 0           
c        IERR     = 1
c        RETURN

      ENDIF

C COMLETENESS ????

      IFNAT = IST + 6
      IFNMD = IST + 5
      IFNAA = IST + 10
      IFNCM = IST + 10
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(IST:IFNAT).EQ.'atom_id'  ) THEN
          LMS_ATOM  (LMS_NSYN) = DATA(1:4)
        ELSE IF(ITEM(IST:IFNMD).EQ.'mod_id'   ) THEN
          LMS_MOD   (LMS_NSYN) = DATA(1:LEND)
        ELSE IF(ITEM(IST:IFNAA).EQ.'atom_altern') THEN
          LMS_AATOM (LMS_NSYN) = DATA(1:4)
        ELSE IF(ITEM(IST:IFNCM).EQ.'comp_altern') THEN
          LMS_AMNAME(LMS_NSYN) = DATA(1:8)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDER(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDER - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
C -----------------------------------
      IERR = 0           
      IF(ITEM(18:24).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')
     *     ' ERR: item _chem_comp_deriv.comp_id :',DATA(1:8),
     *     ' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDR_IDER = 0           
          IERR     = 1
          RETURN
        ENDIF

        MON =  DATA(1:8)

        IF(LDR_NDER.GE.MAXMLIST) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')' ERR: read number of derivatives '
     *      ,MON,'  >',MAXMLIST,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
          LDR_IDER = 0           
          IERR     = 1
          RETURN
        ENDIF
        LDR_NDER = LDR_NDER+1
        LDR_IDER = LDR_NDER

        LDR_MNAME (LDR_NDER) = DATA(1:8)
        LDR_TYPE  (LDR_NDER) = '.'
        LDR_NAME  (LDR_NDER) = '.'
        LDR_SMNAME(LDR_NDER) = '.'
        LDR_MOD   (LDR_NDER) = '.'
      ENDIF

C COMLETENESS ????
      IF(LDR_IDER.GT.0.AND.I.GT.1) THEN
        IF(ITEM(18:23).EQ.'mod_id'  ) THEN
          LDR_MOD    (LDR_NDER)=DATA(1:LEND)
        ELSE IF(ITEM(18:31).EQ.'source_comp_id') THEN
          LDR_SMNAME (LDR_NDER)=DATA(1:LEND)
        ELSE IF(ITEM(18:21).EQ.'name') THEN
          LDR_NAME   (LDR_NDER)=DATA(1:LEND)
        ELSE IF(ITEM(18:22).EQ.'group') THEN
          LDR_TYPE   (LDR_NDER)=DATA(1:LEND)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MATOM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MATOM - reads library information about atoms.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8,ASYMB*4,LMON*8,TYPE*1,CH1*1
C -----------------------------------
      IERR = 0
      IF(ITEM(17:23).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_atom.comp_id :',
     *    DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:LEND)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR = 1
          RETURN
        ENDIF

        IF(LML_IMON.EQ.0) LML_IMON = 1

        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          LMON = LML_MNAME(L)
          CALL LENSTR_BL(LMON,LENL)
        
          IF(MON(1:LEND).EQ.LMON(1:LENL)) THEN

            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
c            LML_NATM (L) = LML_NATM(L) +1
c            LML_NHATM(L) = LML_NHATM(L)+1
            LMA_NATOM = LMA_NATOM+1
            IF(LMA_NATOM.GT.MAXMATM) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *       ' ERR: read number of atoms for monomer ',MON,' >',MAXMATM,
     *           ' /lib.limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_IATOM(L).EQ.0) LML_IATOM(L) = LMA_NATOM 
            LMA_MNAME(LMA_NATOM) = DATA(1:LEND)
            LMA_X    (LMA_NATOM) = 0.0
            LMA_Y    (LMA_NATOM) = 0.0
            LMA_Z    (LMA_NATOM) = 0.0
            LMA_BACK (LMA_NATOM) = '.'
            LMA_TYPE (LMA_NATOM) = '.'
            LMA_FORW (LMA_NATOM) = '.'
            LMA_CHEM (LMA_NATOM) = '.'
            LMA_SYMB (LMA_NATOM) = '.'
            LMA_CHARG(LMA_NATOM) = 0.0
            LMA_COOR_FLAG(LMA_NATOM)='N'
            RETURN
          ENDIF

        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_atom.comp_id :',
     *      MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:23).EQ.'atom_id'  ) THEN
          CALL LENSTR_BL(DATA,LD)
          IF(LD.GT.4) THEN        
            DATA(4:4) = DATA(5:5) 
          ENDIF
C ---
          CALL CORR_H_ATOM_NAME(DATA)
C ---
          LMA_ANAME(LMA_NATOM) = DATA(1:4)
        ELSE IF(ITEM(17:27).EQ.'type_symbol'   ) THEN

          ASYMB = DATA(1:4)
          IT = 1
C
C         IT = 1  convert symbols to upper case.
C                   
          CALL CHECK_LINE(IT,ASYMB)             
          CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
          IF(IERR.EQ.2) THEN
            MON  =  LML_MNAME(LML_IMON)
            LINE ='          monomer:'//MON
            CALL MSGERR(MDOC,LINE)
            IERR = 0
          ENDIF
          IF(IERR.NE.0) RETURN

          LMA_SF_ID(LMA_NATOM) = INSF
          LMA_SYMB (LMA_NATOM) = ASYMB

        ELSE IF(ITEM(17:27).EQ.'type_energy'   ) THEN
          LMA_CHEM(LMA_NATOM) = DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'partial_charge') THEN
          LMA_CHARG(LMA_NATOM) = FDATA
        ELSE IF(ITEM(17:22).EQ.'charge') THEN
          LMA_CHARG(LMA_NATOM) = FDATA
        ELSE IF((ITEM(17:17).EQ.'x').OR.
     *          (ITEM(17:29).EQ.'model_Cartn_x')) THEN
          LMA_X(LMA_NATOM) = FDATA
          LMA_COOR_FLAG(LMA_NATOM) = 'Y'
          IF(DATA(1:1).EQ.'.'.AND.LEND.EQ.1)
     *           LMA_COOR_FLAG(LMA_NATOM) = 'N'
        ELSE IF((ITEM(17:17).EQ.'y').OR.
     *          (ITEM(17:29).EQ.'model_Cartn_y')) THEN
          LMA_Y(LMA_NATOM)     = FDATA
        ELSE IF((ITEM(17:17).EQ.'z').OR.
     *          (ITEM(17:29).EQ.'model_Cartn_z')) THEN
          LMA_Z(LMA_NATOM)     = FDATA
        ELSE IF(ITEM(17:20).EQ.'back') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMA_BACK (LMA_NATOM) = DATA(1:4)
        ELSE IF(ITEM(17:23).EQ.'forward') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMA_FORW (LMA_NATOM) = DATA(1:4)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     


      SUBROUTINE CORR_H_ATOM_NAME(DATA)
      implicit none
C -----------------------------------
      integer i,j,l
      CHARACTER DATA*(*),TYPE*1,CH1*1,chl*1
      character atemp*16
C -----------------------------------
c--- Remove leading spaces
c--- If the first and last characters are matching primes then remove them. 
c--- Example 'aaa' --> aaa
c---         "aaa" --> aaa
c-------------------------------------------------------------------
c
c---Remove leading spaces
      atemp = data
      l = len_trim(data)
      i = 1
      do while(data(i:i).eq.' '.and.i.le.l)
         i = i + 1
      enddo
      j=i-1
      if(j.gt.0) then
         do i=1,l-j
            data(i:i) = data(i+j:i+j)
         enddo
         data(l-j+1:l) = ' '
      endif

c---Replace matching primes with spaces.
      l = len_trim(data)
      ch1 = data(1:1)
      chl = data(l:l)
      if(ch1.eq.''''.and.chl.eq.'''') then
         data(1:1) = ' '
         data(l:l) = ' '
      else if(ch1.eq.'"'.and.chl.eq.'"') then
         data(1:1) = ' '
         data(l:l) = ' '
      endif

c---Remove leading spaces again
      l = len_trim(data)
      i = 1
      do while(data(i:i).eq.' '.and.i.le.l)
         i = i + 1
      enddo
      j=i-1
      if(j.gt.0) then
         do i=1,l-j
            data(i:i) = data(i+j:i+j)
         enddo
         data(l-j+1:l) = ' '
      endif
      RETURN
      END

C ******
      SUBROUTINE PT_CONNECT(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_CONNECT -
C -S-
C -------------------------------------------------------
C ******
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
      COMMON/COM_CONN_LIB/ MON,ATOM,BACK,FORW,TYPE,CONN      
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8,ATOM*4
      CHARACTER BACK*4,FORW*4,TYPE*8,CONN*8
C -----------------------------------
      IERR=0

      IF(ITEM(17:23).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_tree.comp_id :',
     *    DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list = 0')
          WRITE(LINE,'(A,A8,A)')'      monomer :',MON,
     *          ' not found in the monomer list'
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON = 1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON = L
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_tree.comp_id :',
     *          MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF

      IF(ITEM(17:23).EQ.'atom_id'.AND.LML_IMON.GT.0.AND.I.GT.1 ) THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _chem_comp_tree.atom_id :',
     *    DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        L    = LML_IMON
        MON  = LML_MNAME(L)
        CALL CORR_H_ATOM_NAME(DATA)
        ATOM = DATA(1:4)

        IA        = LML_IATOM(L)
        CALL COUNT_NATOM_LIB(MDOC,MON,IA,NATOM,NHATOM,IERR)
        IF(IERR.NE.0) RETURN
        LML_NATM  (L) = NATOM
        LML_NHATM (L) = NHATOM

        IF(LML_NATM(L).LE.0) THEN
          WRITE(LINE,'(A,A7,A)')
     *    ' ERR: number of atoms in the monomer ',MON,' = 0'
          CALL MSGERR(MDOC,LINE)
          IERR = 1
          RETURN
        ENDIF

        DO J=1,LML_NATM(L)
          IA = LML_IATOM(L)+J-1
          IF(ATOM.EQ.LMA_ANAME(IA)) THEN
            LMA_IATOM = IA
            RETURN
          ENDIF
        ENDDO

        WRITE(LINE,'(A,A,A)')' ERR: item _chem_comp_tree.atom_id :',
     *     ATOM,' not found in the atom list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' MON,BLOCK :'',A,A)') MON,BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN

      ENDIF

C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.2) THEN
        IF(LMA_IATOM.GT.0) THEN
          IF(ITEM(17:25).EQ.'atom_back'  ) THEN
            IF(DATA(1:3).EQ.'n/a') DATA = '.   '
            CALL CORR_H_ATOM_NAME(DATA)
            BACK=DATA(1:4)
          ELSE IF(ITEM(17:25).EQ.'back_type'  ) THEN
            TYPE=DATA(1:8)
          ELSE IF(ITEM(17:28).EQ.'atom_forward'  ) THEN
            IF(DATA(1:3).EQ.'n/a') DATA = '.   '
            CALL CORR_H_ATOM_NAME(DATA)
            FORW=DATA(1:4)
          ELSE IF(ITEM(17:28).EQ.'connect_type'  ) THEN
            CONN=DATA(1:8)
          ENDIF

C         ELSE
c          IF(ITEM(28:44).EQ.'connect_atom_id_1'  ) THEN
c            LMN_1ATM(LMN_NCONN)=DATA(1:4)
c          ELSE IF(ITEM(28:44).EQ.'connect_atom_id_2'  ) THEN
c            LMN_2ATM(LMN_NCONN)=DATA(1:4)
C          ENDIF

        ENDIF
      ENDIF

      IF(I.EQ.N_CIF.AND.LML_IMON.GT.0) THEN

        IF(CONN(1:3).EQ.'ADD') THEN
          L         = LML_IMON
          LMA_IATOM = 0
          LMN_NCONN = LMN_NCONN+1
          IF(LMN_NCONN.GT.MAXMCNN) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of connections for monomer '
     *      ,MON,'  >',MAXMCNN,'/lib.limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LML_IMON = 0           
            IERR=1
            RETURN
          ENDIF
          IF(LML_ICONN(L).EQ.0) LML_ICONN(L)=LMN_NCONN 
          LMN_MNAME(LMN_NCONN)  = MON
          LMN_1ATM (LMN_NCONN)  = ATOM
          LMN_2ATM (LMN_NCONN)  = BACK
          LMN_TYPE (LMN_NCONN)  = TYPE

        ELSE

          LMA_BACK(LMA_IATOM) = BACK
          IF(CONN(1:5).EQ.'DUMMY') THEN
            LMA_TYPE(LMA_IATOM) = CONN
          ELSE
            LMA_TYPE(LMA_IATOM) = '.'
          ENDIF
          LMA_FORW(LMA_IATOM) = FORW
          IF(CONN(1:5).EQ.'START') THEN
            LMA_BACK(LMA_IATOM) = '.'
          ELSE IF(CONN(1:3).EQ.'END') THEN
            LMA_FORW(LMA_IATOM) = 'END'
          ENDIF

        ENDIF

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MBOND - reads library information about bonds.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8,TYPE*1,CH1*1
C -----------------------------------
      IERR=0
      IF(ITEM(17:23).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_bond.comp_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON=1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
            LMB_NBOND = LMB_NBOND+1
            IF(LMB_NBOND.GT.MAXMBND) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *     ' ERR: read number of bonds for monomer '
     *        ,MON,'  >',MAXMBND,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_IBOND(L).EQ.0) LML_IBOND(L) = LMB_NBOND 
            LMB_MNAME(LMB_NBOND) = DATA(1:8)
            LMB_1ATM (LMB_NBOND) = '.'
            LMB_2ATM (LMB_NBOND) = '.'
            LMB_TYPE (LMB_NBOND) = '.'
            LMB_DEV  (LMB_NBOND) = 0.0
            LMB_VAL  (LMB_NBOND) = 0.0
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_bond.comp_id :'
     *          ,MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:25).EQ.'atom_id_1'  ) THEN
          CALL LENSTR_BL(DATA,LD)
          IF(LD.GT.4) THEN
            DATA(4:4) = DATA(5:5) 
          ENDIF
C ---
          CALL CORR_H_ATOM_NAME(DATA)
C ---
          LMB_1ATM (LMB_NBOND)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_2'  ) THEN
          CALL LENSTR_BL(DATA,LD)
          IF(LD.GT.4) THEN
            DATA(4:4) = DATA(5:5) 
          ENDIF
C ---
          CALL CORR_H_ATOM_NAME(DATA)
C ---
          LMB_2ATM (LMB_NBOND)=DATA(1:4)
        ELSE IF((ITEM(17:20).EQ.'type').OR.
     *          (ITEM(17:27).EQ.'value_order')) THEN
          IF(DATA.EQ.'SING') DATA = 'single'
          IF(DATA.EQ.'DOUB') DATA = 'double'
          IF(DATA.EQ.'TRIP') DATA = 'triple'
          IF(DATA.EQ.'AROM') DATA = 'arom'
          IF(DATA.EQ.'META') DATA = 'metal'
          IF(DATA.EQ.'DELO') DATA = 'deloc'
          LMB_TYPE (LMB_NBOND)=DATA(1:8)
        ELSE IF(ITEM(17:30).EQ.'value_dist_esd') THEN
          LMB_DEV  (LMB_NBOND)=FDATA
        ELSE IF(ITEM(17:26).EQ.'value_dist') THEN
          LMB_VAL  (LMB_NBOND)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     
C ******

      SUBROUTINE PT_MANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MANGL - read library information about angles.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
C -----------------------------------
      IERR=0
      IF(ITEM(18:24).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_angle.comp_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON = 1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
            LMG_NANGL = LMG_NANGL+1
            IF(LMG_NANGL.GT.MAXMANG) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: read number of angles for monomer '
     *        ,MON,'  >',MAXMANG,'/lib.limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_ITHET(L).EQ.0) LML_ITHET(L) = LMG_NANGL 
            LMG_MNAME(LMG_NANGL) = DATA(1:8)
            LMG_1ATM (LMG_NANGL) = '.'
            LMG_2ATM (LMG_NANGL) = '.'
            LMG_3ATM (LMG_NANGL) = '.'
            LMG_DEV  (LMG_NANGL) = 0.0
            LMG_VAL  (LMG_NANGL) = 0.0
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_angle.comp_id :'
     *          ,MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(18:26)     .EQ.'atom_id_1'  ) THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMG_1ATM (LMG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:26).EQ.'atom_id_2'  ) THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMG_2ATM (LMG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:26).EQ.'atom_id_3'  ) THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMG_3ATM (LMG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:32).EQ.'value_angle_esd') THEN
          LMG_DEV  (LMG_NANGL)=FDATA
        ELSE IF(ITEM(18:28).EQ.'value_angle') THEN
          LMG_VAL  (LMG_NANGL)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MTORS - reads library information about torsion angles.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
c
      integer ntors_namelength
c
      ntors_namelength = 8
C -----------------------------------
      IERR=0
      IF(ITEM(16:22).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_tor.comp_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON=1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
            LMT_NTORS = LMT_NTORS+1
            IF(LMT_NTORS.GT.MAXMTOR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of tors for monomer ',MON,' >'
     *        ,MAXMTOR,'/lib.limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_ITORS(L).EQ.0) LML_ITORS(L) = LMT_NTORS 
            LMT_MNAME(LMT_NTORS) = DATA(1:8)
            LMT_1ATM (LMT_NTORS) = '.'
            LMT_2ATM (LMT_NTORS) = '.'
            LMT_3ATM (LMT_NTORS) = '.'
            LMT_4ATM (LMT_NTORS) = '.'
            LMT_LABEL(LMT_NTORS) = '.'
            LMT_DEV  (LMT_NTORS) = 0.0
            LMT_VAL  (LMT_NTORS) = 0.0
            LMT_PRD  (LMT_NTORS) = 0
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_tor.comp_id :'
     *          ,MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:30).EQ.'value_angle_esd' ) THEN
          LMT_DEV  (LMT_NTORS)=FDATA
        ELSE IF(ITEM(16:26).EQ.'value_angle') THEN
          LMT_VAL  (LMT_NTORS)=FDATA
        ELSE IF(ITEM(16:21).EQ.'period') THEN
          LMT_PRD  (LMT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_1') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMT_1ATM (LMT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_2') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMT_2ATM (LMT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_3') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMT_3ATM (LMT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_4') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMT_4ATM (LMT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:17).EQ.'id') THEN
           if(len_trim(adjustl(data)).gt.ntors_namelength) then
              write(*,*)
              write(*,*)'Problem with torsion names in the library'
              write(*,*)
     &             'Torsion label is too long. Maximum allowed is: ',
     &             ntors_namelength
              write(*,*)'Monomer name: ',trim(lmt_mname(lmt_ntors)),
     &             ', torsion name: ',trim(data)
              stop 'Problem with torsion angle name'
           else
              LMT_LABEL(LMT_NTORS)=trim(adjustl(DATA))
           endif
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MPLAN - reads library information about plane_groups.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      COMMON/STTCPLN/ DEV,ISATOM,LABEL,MNAME
      REAL      DEV
      INTEGER*4 ISATOM
      integer plane_namelength
      CHARACTER LABEL*8,MNAME*8
C ---
      INTEGER*4 IATOM
      CHARACTER LINE*256,MON*8,ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -----------------------------------
      plane_namelength = 8
      IERR=0
      IF(ITEM(23:29).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')
     *   ' ERR: item _chem_comp_plane_atom.comp_id :',DATA(1:8)
     *    ,' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON=1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON = L
            MNAME    = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')
     *    ' ERR: item _chem_comp_plane_atom.comp_id :',MON
     *   ,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(23:30).EQ.     'plane_id'    ) THEN
           if(len_trim(data).gt.plane_namelength) then
              write(*,*)
              write(*,*)'Plane name in the library is too long'
              write(*,*)'Maximum allowed is ',plane_namelength
              write(*,*)'Monomer name: ',trim(mname),
     &             ' plane name: ',trim(data)
              stop 'Problem with reading monomer library'
           endif
           LABEL  = trim(adjustl(DATA))
        ELSE IF(ITEM(23:29).EQ.'atom_id') THEN
           CALL CORR_H_ATOM_NAME(DATA)
           ATOM   = DATA(1:4)
           ISATOM = IATOM
        ELSE IF(ITEM(23:30).EQ.'dist_esd') THEN
           DEV    = FDATA
        ENDIF
      ENDIF

      IF(LML_IMON.GT.0.AND.I.EQ.4) THEN
        L = LML_IMON
        IF(LML_IPLAN(L).LE.LMP_NPLAN) THEN
          IF(LML_IPLAN(L).GT.0) THEN
            DO II=LML_IPLAN(L),LMP_NPLAN
               IF(LABEL.EQ.LMP_LABEL(II)) GO TO 100
            ENDDO
          ENDIF
          LMP_NPLAN = LMP_NPLAN + 1
          IF(LMP_NPLAN.GT.MAXMPLN) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *       ' ERR: read number of plans for monomer ',MNAME,' >'
     *     ,MAXMPLN,'/lib.limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LML_IMON = 0           
            IERR     = 1
            RETURN
          ENDIF
          IF(LML_IPLAN(L).EQ.0) LML_IPLAN(L) = LMP_NPLAN
          II            = LMP_NPLAN
          LMP_NATOM(II) = 0
          LMP_MNAME(II) = MNAME
 100      CONTINUE

          LMP_NATOM(II) = LMP_NATOM(II)+1
          IF(LMP_NATOM(II).GT.MAXMAPL) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of plans atom for monomer ',MNAME,
     *      '  >',MAXMAPL,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LML_IMON = 0           
            IERR     = 1
            RETURN
          ENDIF
          LMP_LABEL(II)               = LABEL
          LMP_ATOM (LMP_NATOM(II),II) = ISATOM
          LMP_DEV  (LMP_NATOM(II),II) = DEV
        ENDIF
      ENDIF 
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MCHIR - reads library information about chiralities.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
C -----------------------------------
      IERR=0
      IF(ITEM(17:23).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_chir.comp_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON=1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
            LMC_NCHIR = LMC_NCHIR+1
            IF(LMC_NCHIR.GT.MAXMCHR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of chiralities for monomer ',
     *        MON,'  >',MAXMCHR,'/lib.limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_ICHIR(L).EQ.0) LML_ICHIR(L) = LMC_NCHIR 
            LMC_MNAME(LMC_NCHIR) = DATA(1:8)
            LMC_1ATM (LMC_NCHIR) = '.'
            LMC_2ATM (LMC_NCHIR) = '.'
            LMC_3ATM (LMC_NCHIR) = '.'
            LMC_4ATM (LMC_NCHIR) = '.'
            LMC_5ATM (LMC_NCHIR) = '.'
            LMC_6ATM (LMC_NCHIR) = '.'
            LMC_7ATM (LMC_NCHIR) = '.'
            LMC_8ATM (LMC_NCHIR) = '.'
            LMC_9ATM (LMC_NCHIR) = '.'
            LMC_SIGN (LMC_NCHIR) = '.'
            LMC_FLAG (LMC_NCHIR) = 'N'
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_chir.comp_id :',MON,
     *          ,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:27).EQ.'volume_sign'    ) THEN
          LMC_SIGN  (LMC_NCHIR)=DATA(1:8)
        ELSE IF(ITEM(17:30).EQ.'atom_id_centre') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_1ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_1') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_2ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_2') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_3ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_3') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_4ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_4') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_5ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_5') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_6ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_6') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_7ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_7') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_8ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_8') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_9ATM (LMC_NCHIR)=DATA(1:4)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     


      SUBROUTINE INIT_CNT
C -------------------------------------------------------
C -P- INIT_CNT -   initialization counters of library.
C -S-
C -------------------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
C   
      DO   I=1,MAXMATM
        LMA_CHARG(I) = 0.0
        LMA_BACK (I) = '?'
        LMA_TYPE (I) = '.'
        LMA_FORW (I) = '?'
        LMA_ANAME(I) = '?'
        LMA_SYMB (I) = '?'
        LMA_CHEM (I) = '?'
      ENDDO
      LMA_NATOM = 0
      LMN_NCONN = 0
c      LDR_NDER  = 0
      LMB_NBOND = 0
      LMG_NANGL = 0
      LMT_NTORS = 0
      LMC_NCHIR = 0
      LMP_NPLAN = 0
      LLA_NATOM = 0
      LLN_NCONN = 0
      LLB_NBOND = 0
      LLG_NANGL = 0
      LLT_NTORS = 0
      LLC_NCHIR = 0
      LLP_NPLAN = 0
      LDA_NATOM = 0
      LDN_NCONN = 0
      LDB_NBOND = 0
      LDG_NANGL = 0
      LDT_NTORS = 0
      LDC_NCHIR = 0
      LDP_NPLAN = 0
      DO   I=1,MAXMLIST
        LML_PASS (I) = 0
        LML_IATOM(I) = 0
        LML_ICONN(I) = 0
        LML_IBOND(I) = 0
        LML_ITHET(I) = 0
        LML_ITORS(I) = 0
        LML_IPLAN(I) = 0
        LML_ICHIR(I) = 0
      ENDDO
      DO   I=1,MAXLLNK
        LLL_IATOM(I) = 0
        LLL_ICONN(I) = 0
        LLL_IBOND(I) = 0
        LLL_ITHET(I) = 0
        LLL_ITORS(I) = 0
        LLL_IPLAN(I) = 0
        LLL_ICHIR(I) = 0
      ENDDO
      DO   I=1,MAXDMDF
        LDL_IATOM(I) = 0
        LDL_ICONN(I) = 0
        LDL_IBOND(I) = 0
        LDL_ITHET(I) = 0
        LDL_ITORS(I) = 0
        LDL_IPLAN(I) = 0
        LDL_ICHIR(I) = 0
      ENDDO
      RETURN
      END


C ******
