C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
C----siganscale_block
C
      SUBROUTINE ML_SCALING(NREF,ndens,hkl_asym,FO,SIGO,H_A,H_B,fwt,
     &                      FC,PHASE,FREER)
      use weights
      implicit none
      include 'refi_flags.fh'
      integer NREF,ndens
      integer hkl_asym(3,*)
      real FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      REAL H_A(*),H_B(*)
      real fwt(*)
c
      integer nworkspace
      real, allocatable :: workspace(:)
c
c---  body
      nworkspace = 10000
      allocate(workspace(nworkspace))

      if(SIGMA_REFINE_STYLE.EQ.'BINS') THEN
        CALL ML_SCALING_BINS(NREF,ndens,hkl_asym,FO,SIGO,H_A,H_B,fwt,FC,
     &        PHASE,FREER,WORKSPACE,NWORKSPACE)
      else
        CALL ML_SCALING_EXPS(NREF,ndens,hkl_asym,FO,SIGO,fwt,
     &        FC,PHASE,FREER,
     &        WORKSPACE,NWORKSPACE)
C
C---Analyse. If exps is unstable switch to bins.
C
      endif
C
      deallocate(workspace)
      RETURN
      END

      SUBROUTINE ML_SCALING_BINS(NREF,ndens,hkl_asym,FO,SIGO,
     &     H_A,H_B,fwt,FC,PHASE,FREER,WORKSPACE,NWORKSPACE)
      use weights
      use agreem
      use solvent_all
C
C---Find parameters of likelihood in bins
C
      IMPLICIT NONE
      INCLUDE 'refi_flags.fh'
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'const.fh'
      INCLUDE 'anom.fh'
C
      INTEGER NREF,NWORKSPACE,ndens
      INTEGER hkl_asym(3,*)
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      real WORKSPACE(*)
      real fwt(*)
      REAL H_A(*),H_B(*)
C
      INTEGER NMAXPART1
      PARAMETER (NMAXPART1 = NMAXPART*2 + 2)
      REAL DF(NMAXPART1,MAXBIN),DFF(NMAXPART1,NMAXPART1,MAXBIN),
     &     SHIFTS(NMAXPART1,MAXBIN),A_CALCS(NMAXPART),B_CALCS(NMAXPART),
     &     a_extra,b_extra
      integer iwei
      INTEGER I,J,IBIN,NPART1,NPART2,ICENT,NCYCS,IR,IHH(3),
     &        ISYSAB,IBIN0
      REAL RSQ,STL_C,A_ALL,B_ALL,SIGMA_IN,SIGMA,DFDA,DFDB,DFDAA,
     &     DFDBB,DFDAB,FOM,FVALUE,YO,WT1,EPSI,FVAL_ALL,
     &     F_VALUE_OLD,SCALE_NOW,FOMOVER1,DFDSIG,DFDSIG2,DFDSIGA,
     &     DFDSIGB,SCAL_SIG
      REAL DF_old(NMAXPART1,MAXBIN),DFF_old(NMAXPART1,NMAXPART1,MAXBIN)
      REAL SIGN_NOW,SIGP_NOW,SIGN2_NOW,SIGN2P_NOW,SIGP2P_NOW,SIGH_NOW
      real sigi_now, resdep, resdep_now, mind, min_ratio_in_bin
      real dfdd(NMAXPART1), dfddd(NMAXPART1,NMAXPART1), D_PAR(NMAXPART1)
      real SIGP2_NOW(NMAXPART),SIGP12_NOW
      real SP_NOW(NMAX_SIG),SN_NOW(NMAX_SIG)
      real YOP,YOM,YON,YOD,YOP2,YOM2, FVAL_OLD(MAXBIN),FVAL(MAXBIN)
      real SIGYOP,SIGYOM,SIGYON,SIGYOD,SIGYOP2,SIGYOM2
      integer in_c, out_c, in_a, out_a, is, ih, IB, ia, Dnum, i_max, ID
      integer  wavepos, wavepos2
      integer num_ref_bin(MAXBIN), num_free_bin(MAXBIN), ref_add(MAXBIN)
     &        ,used_bin(MAXBIN), min_in_bin, smallsig(MAXBIN)
      integer end_mlsc_all, end_mlsc(MAXBIN), check_newbins, bin_multi
      integer ib_new, dec, y, ipos, ip, ncycs_max, dimen, mod2
      real  shift_div, shift_min, func_ratio, max_shift
      real hl(4)
      INTEGER OMP_GET_THREAD_NUM
      character signp_exper*3
      REAL TOLER
      REAL SIM
      logical FREERCHK, scaling, scaling_save, proceed, proceed2
      logical interp
      logical rice_bin
      EXTERNAL SIM
      DATA TOLER/1.0E-6/
C
C---Some initialisation.
      ncycs_max = 100
      if (substruct_flag.and..not.dm_flag) ncycs_max = 5
      if (.not.dppi_no) call return_mat_dim(dimen)
c in case of substruct. ref., overall scale is refined first and then the other parameters, including 
c overall B (via different values in bins)
c in case we don't have substruct., no scaling is done (from some reason works better without)
      scaling = .false.
      if (substruct_flag.and.ncycl.lt.2.and..not.read_luzzd_flag)   
c      if (substruct_flag.and.ncycl.lt.2)
     &  scaling = .true.
c      if (dppi_sadh.and.dimen.gt.4) scaling=.false.
      if (.not.substruct_flag.and.ncycl.gt.1.and.DPPI_sadh)   
     &  scaling = .true.
      scaling_save = scaling
      NPART1 = NPART + 1
      NPART2 = NPART + 2
      Dnum = NPART1
      NCYCS = 0
      if (.not.dppi_no) call return_Dnum(Dnum)
      call num_inp_mod(mod2)
  999 continue
      DO   I=1,NBIN_ML
c!!!!!!!!!!!!
c          scale_ml(i,2) = scale_ml(i,2)*dm_d_blur
         NREF_ML(I) = 0
         num_free_bin(I) = 0
         num_ref_bin(I) = 0
         used_bin(I) = 0
         smallsig(i) = 0
         DO   J=1,Dnum+2
            SHIFTS(J,I) = 0.0
         ENDDO
         FVAL_OLD(I) = 1.0E32
         if (scaling.and.i.ne.1) FVAL_OLD(I)=0.
         end_mlsc(I) = -1
      ENDDO
      SCAL_SIG = 1.0E4
      SP_NOW(1:NMAX_SIG)=0.0
      SN_NOW(1:NMAX_SIG)=0.0
      hl(1:4)=0.
      check_newbins = 0 
      mind=1000.
      if (DPPI_sras) then 
        i_max=3
      else if(DPPI_sad.or.DPPI_sadh.or.DPPI_pl.or.DPPI_sir.or.DPPI_hldm)
     &then
        i_max=2 
      else if (DPPI_mad) then 
        i_max=6 
      endif
      if (dm_flag) i_max=i_max+1
C
C---Now estimate new ml parameters
      F_VALUE_OLD = 1.0E32
      if (VERBREF_5N) write(*,*) 'ref.flags:',derD2der1_flag,
     +  der2der1_flag,der2equal_flag,der2heavyder1_flag
      SCAL_SIG = 1.0E4
c      
C   there is NBIN_ML independent refinements - set of D parameters for every res. bin
      if (DPPI_no) 
     &  call DMLINIT_R1(NREF,ndens,hkl_asym,FO,SIGO,fwt,FC,PHASE,FREER)
c      if ((.not.dppi_no).and.ncycl.gt.1) then
      if (.not.dppi_no) then
        call CALC_SIGM(NREF,ndens,hkl_asym,FO,SIGO,H_A,H_B,fwt,FC,PHASE,
     +    FREER,ncycs)
      endif
      NCYCS = 0
c
c---  count the number of refls and free refls in bins (the lsusework flag has been removed from here!)
      do   IR=1,NREF  
        FREERCHK = .FALSE.
        IF( FREER_FLAG .and. (ABS(FREER(IR)-LFreeRexcludeVal).le.0.1) )
     +    FREERCHK = .true.
        CALL INDTORS(hkl_asym(1:3,IR),RSQ)
        STL_C = SQRT(RSQ)
        IF(SIGO(IR).GT.0.0)THEN
          DO   IB=1,NBIN_ML
            IF(STL_C.LE.SMAXB_ML(IB).AND.STL_C.GT.SMINB_ML(IB)) THEN
              num_ref_bin(IB) = num_ref_bin(IB) + 1
              if (FREERCHK) num_free_bin(IB) = num_free_bin(IB) + 1
            ENDIF
          ENDDO
        ENDIF
      enddo
c
c--- check the cov matrix
      interp=.false.
      if (.not.dppi_no)
     & call check_cov_mat(NREF,hkl_asym,SIGO,Dnum,D_PAR,i_max,
     &     scaling_save,
     &      interp,smallsig)
c--- if scaling then find min. of D's in bins and then copy it to all bins
      if (scaling) then
        do   IB = 1,NBIN_ML
          if (SCALE_ML(IB,1).lt.mind)  mind = SCALE_ML(IB,1)
        enddo
        do   IB = 1,NBIN_ML
          SCALE_ML(IB,1) = mind
        enddo
      endif
c
c--- only free reflections are used for direct prior phase targets
c--- ref_add(ib) stores the number of non-free reflections that are used
c--- for cases such as no freer_flag, small number of free in bin, using Rice
c perform more tests  with this stuff?
      min_in_bin = 20
      min_ratio_in_bin = 0.03
c siras seems to need more refls for more stable D refinement
      if (dppi_sras) min_ratio_in_bin = 0.1
      if (freeDref_flag) resdep = 1.
c Garib's approach - using all here
      if (DPPI_no) resdep = 100.
ccc         resdep = 100.
 10   CONTINUE
      if (verbref_5n) write(6,*) ' '
      FVAL_ALL = 0.0
      DO   IB = 1,NBIN_ML
        if (.not.DPPI_no) 
     &    call useorigrice(i_max,ib,rice_bin)
        resdep_now=resdep
        FVAL(IB) = 0.0
        if (scaling.and.IB.ne.1) end_mlsc(IB) = 1
        if (end_mlsc(IB).ne.1)  end_mlsc(IB) = -1
        ref_add(IB) = - num_free_bin(IB) +
     +    max( min_ratio_in_bin*num_ref_bin(IB), real(min_in_bin),
     +         resdep_now*num_free_bin(IB) ) 
        DO    I=1,Dnum+2
          DF(I,IB) = 0.0
          DO  J=1,Dnum+2
            DFF(J,I,IB) = 0.0
          ENDDO
        ENDDO
      ENDDO
c
      DO    I=1,NBIN_ML
        NREF_ML(I) = 0
        used_bin(i) = 0
      ENDDO
      FOMOVER1 = 0.0
      DO   IR=1,NREF
c      DO   IR=NREF,1,-1
         iwei = nint(fwt(ir))
c        FREERCHK = .FALSE.
c        IF(FREER_FLAG )THEN 
c          IF((ABS(FREER(IR)-LFreeRexcludeVal).GT.0.1))FREERCHK = .true.
c        END IF
        FREERCHK = .true.
        IF(FREER_FLAG )THEN 
          IF((ABS(FREER(IR)-LFreeRexcludeVal).le.0.1))FREERCHK = .false.
        END IF
        CALL INDTORS(hkl_asym(1:3,IR),RSQ)
        STL_C = SQRT(RSQ)
        if (check_newbins.eq.1) then
          do ib=1,NBIN_ML2
            IF ( STL_C.LE.SMAXB_ML2(IB).AND.STL_C.GT.SMINB_ML2(IB) ) 
     +        ib_new = ib
          enddo
        endif
        IBIN0 = 0
        DO   IBIN=1,NBIN_ML
          IBIN0 = IBIN0 + 1
          IF(STL_C.LE.SMAXB_ML(IBIN).AND.STL_C.GT.SMINB_ML(IBIN)) THEN
          proceed=.false.
          proceed2=.false.
          if ( substruct_flag ) then
            if (mod(ir,4).eq.0)  proceed = .true.
            do i=1,dataset_num_tot
              if (sigo(ir+nobs*(i-1)).gt.0.) proceed2=.true.
            enddo
            if (ir.eq.smallsig(ibin))  proceed = .true.
          else  
            if (.not.FREERCHK.or.ref_add(IBIN).gt.0)   proceed = .true.
c todo: reflections without native obs but other obs should be used for protein refinement also
            if (sigo(ir).gt.0.) proceed2=.true.
          endif
          if ( proceed .and. proceed2.and.fwt(ir).gt.0.0 ) then
            if (FREERCHK.or.(.not.FREER_FLAG)) 
     +             ref_add(IBIN)=ref_add(IBIN)-1
            if (end_mlsc(IBIN0).ne.-1.and..not.scaling) goto 100
            if (.not.scaling) then
              used_bin(IBIN) = used_bin(IBIN) + 1
            else
              used_bin(1) = used_bin(1) + 1
            endif
            ihh(1:3) = hkl_asym(1:3,ir)
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            CALL EXTRACT_ABS(IR,ndens,FC,PHASE,A_CALCS,B_CALCS)
            a_extra=0.
            b_extra=0.
            if (dm_flag) then
c check for NaN, get A_DM, B_DM
              if (fc(ir,ndens).ne.fc(ir,ndens)) goto 100
              if (phase(ir,ndens).ne.phase(ir,ndens)) goto 100
              a_extra=fc(ir,ndens)*cos(phase(ir,ndens))
              b_extra=fc(ir,ndens)*sin(phase(ir,ndens))
            endif
            A_ALL = 0.0
            B_ALL = 0.0
            if (.not.DPPI_no) 
     &        call useorigrice(i_max,ibin0,rice_bin)
            DO  I=1,NPART1
              if (DPPI_no) then
                SCALE_NOW = SCALE_ML(IBIN0,I) - SHIFTS(I,IBIN0)
                SCALE_NOW = AMIN1(MAX_SC_ML,AMAX1(MIN_SC_ML,SCALE_NOW))
                A_ALL = A_ALL + A_CALCS(I)*SCALE_NOW
                B_ALL = B_ALL + B_CALCS(I)*SCALE_NOW
              else
                A_ALL = A_ALL + A_CALCS(I)
                B_ALL = B_ALL + B_CALCS(I)
              endif
            ENDDO
            if ((dppi_sras.or.dppi_sir).and.mod2.lt.2) then
              A_ALL=0
              B_ALL=0
            endif
C
c---Add epsilon (centricity) here
            if (DPPI_no) then
              WT1 = REAL(1+ICENT)*EPSI
            else
              wt1 = epsi
            endif
            SIGMA_IN = SIGMA_ML(IBIN0)*WT1
            CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
            YO  = FO(IR)
            if (DPPI_sad.or.DPPI_sadh.or.DPPI_mad) then
              YOP  = FO(dataset_order(1)*NOBS+IR)
              YOM  = FO(dataset_order(2)*NOBS+IR)
              SIGYOP  = SIGO(dataset_order(1)*NOBS+IR)
              SIGYOM  = SIGO(dataset_order(2)*NOBS+IR)
            else  if (DPPI_sir.or.DPPI_mldr.or.DPPI_pl) then
              YON  = FO(dataset_order(1)*NOBS+IR)
              YOD  = FO(dataset_order(2)*NOBS+IR)
              SIGYON  = SIGO(dataset_order(1)*NOBS+IR)
              SIGYOD  = SIGO(dataset_order(2)*NOBS+IR)
            else  if (DPPI_sras) then
              YON  = FO(dataset_order(1)*NOBS+IR)
              SIGYON  = SIGO(dataset_order(1)*NOBS+IR)
              YOP  = FO(dataset_order(2)*NOBS+IR)
              YOM  = FO(dataset_order(3)*NOBS+IR)
              SIGYOP  = SIGO(dataset_order(2)*NOBS+IR)
              SIGYOM  = SIGO(dataset_order(3)*NOBS+IR)
            else if (DPPI_mad) then
              YOP2  = FO(dataset_order(3)*NOBS+IR)
              YOM2  = FO(dataset_order(4)*NOBS+IR)
              SIGYOP2  = SIGO(dataset_order(3)*NOBS+IR)
              SIGYOM2  = SIGO(dataset_order(4)*NOBS+IR)
            else if (DPPI_hldm) then
              HL(1)  = phase(nobs*(npart+1)+IR,1)
              HL(2)  = phase(nobs*(npart+2)+IR,1)
              HL(3)  = phase(nobs*(npart+3)+IR,1)
              HL(4)  = phase(nobs*(npart+4)+IR,1)
            endif
      		SIGN_NOW = SIGN(IBIN0)*WT1
      		SIGP_NOW = SIGP(IBIN0)*WT1
            if (.not.DPPI_no) then
              do i=1,i_max
                SN_NOW(i) = sigm_N(IBIN0,i)*WT1
                SP_NOW(i) = sigm_P(IBIN0,i)*WT1
                if (check_newbins.eq.1) then
                  SN_NOW(i) = sigm_N(ib_new,i)*WT1
                  SP_NOW(i) = sigm_P(ib_new,i)*WT1
                endif
C this can happen if datasets are of different resolution
                if (SN_NOW(i).lt.0.001) SN_NOW(i) = 0.
                if (SP_NOW(i).lt.0.001) SP_NOW(i) = 0.
              enddo
            endif
      		SIGN2_NOW = SIGN2(IBIN0)*WT1
      		SIGN2P_NOW = SIGN2P(IBIN0)*WT1
      		SIGP2_NOW(1) = SIGP2(IBIN0,1)*WT1
      		SIGP2_NOW(2) = SIGP2(IBIN0,2)*WT1
      		SIGP2_NOW(3) = SIGP2(IBIN0,3)*WT1
      		SIGP2P_NOW = SIGP2P(IBIN0)*WT1
c            sigi_now = sigi(ibin0)*wt1
            sigi_now = 0.
            SIGP12_NOW = SIGP12(IBIN0)*wt1
            SIGH_NOW = SIGH(IBIN0)*wt1
            do i=1,Dnum
              D_PAR(i) = SCALE_ML(IBIN0,i) - SHIFTS(i,IBIN0)
              if (check_newbins.eq.1)  D_PAR(i) = SCALE_ML2(IB_new,i)
              D_PAR(i) = AMIN1(MAX_SC_ML,AMAX1(MIN_SC_ML,D_PAR(i)))
            enddo
            if (check_newbins.eq.1)   dec = 0
c            ID = OMP_GET_THREAD_NUM()
            ID=1
  123       continue
            if (DPPI_no) then
              CALL DFUNCDAB_ML(ndens,ICENT,SIGMA,YO,A_ALL,B_ALL,IR,
     &               PHASE,DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,hl,FOM)
            else if (DPPI_sad.or.DPPI_sadh.or.DPPI_hldm) then
c        if (icent.eq.1) write(*,*) SIGN_NOW,SIGP2_NOW_2
        call SAD_DMYFUNCDD_ML(ICENT,SIGN_NOW,SN_NOW(1),SP_NOW(1),
     +  SIGP_NOW,SIGP2_NOW(1),SIGO(IR),SIGYOP,SIGYOM, YO,YOP,YOM,
     +  A_ALL,B_ALL,H_A(ir),H_B(ir),A_extra,B_extra,
     +  IR,PHASE,D_PAR(1),DFDD(1),DFDDD(1,1),NMAXPART1,
     +  FVALUE,sigi_now,sigp12_now,fom,hl(1),ID)
c      write(*,*)IR,ICENT,YOP,YOM,SIGYOP,SIGYOM,A_ALL,B_ALL,
c     &   SN_NOW(1),SN_NOW(2),SP_NOW(1),SP_NOW(2),H_A(ir),H_B(ir),FVALUE
            else if (DPPI_sir.or.DPPI_mldr.or.DPPI_pl) then
        call SIR_DMYFUNCDD_ML(ICENT,SIGN_NOW,SIGN2_NOW,SIGN2P_NOW,
     +  SN_NOW(1),SP_NOW(1),SIGP_NOW,SIGP2_NOW(1),SIGP2P_NOW,SIGO(IR),
     +  SIGYON,SIGYOD,YO,YON,YOD,A_ALL,B_ALL,H_A(ir),H_B(ir),IR,
     +  PHASE,D_PAR(1),DFDD(1),DFDDD(1,1),DFDDD(1,2),DFDDD(2,2),
     +  DFDDD(1,3),DFDDD(1,4),DFDDD(2,3),DFDDD(2,4),DFDDD(3,3),
     +  DFDDD(3,4),DFDDD(4,4),DFDDD(5,5),FVALUE,sigp12_now,sigh_now,
     +  ligin1,fom,ID)
            else if (DPPI_sras) then
c        if (substruct_flag.and.SP_NOW(2).gt.0.) SIGP_NOW = SP_NOW(2)
        call SIRAS_DMYFUNCDD_ML(ICENT,SN_NOW(1),SP_NOW(1),SIGN_NOW,
     +  SIGP_NOW,SIGP2_NOW(1),SIGYON,SIGYOP,SIGYOM,YON,YOP,YOM,
     +  A_ALL,B_ALL,H_A(ir),H_B(ir),H_A(ir+NOBS),H_B(ir+NOBS),
     +  A_extra,B_extra,IR,PHASE,D_PAR(1),DFDD(1),DFDDD(1,1),DFDDD(1,2),
     +  DFDDD(2,2),FVALUE,sigp12_now,sigh_now,fom,ID)
c      if (fvalue.lt.100)write(*,*)'high function value in D par ref:',
c     +  ir,icent,fvalue,SN_NOW(1),SN_NOW(2),SN_NOW(3),SP_NOW(1),
c     +  SP_NOW(2),SP_NOW(3),YO,YOP,YOM,SIGO(ir),SIGYOP,SIGYOM,
c     +  D_PAR(1),D_PAR(2),D_PAR(3),D_PAR(4)
c        call flush(6)
c      if (ir.le.00000)
c         write(*,*) 'fvalue & derivs: ', FVALUE,DFDD(1),DFDD(2)
            else if (DPPI_mad) then
        call MAD_DMYFUNCDD_ML(ICENT,SN_NOW(1),SP_NOW(1),SIGP2_NOW(1),
     +  SIGO(IR),SIGYOP,SIGYOM,SIGYOP2,SIGYOM2,YO,YOP,YOM,YOP2,YOM2,
     +  A_ALL,B_ALL,H_A(ir),H_B(ir),H_A(ir+NOBS),H_B(ir+NOBS),
     +  H_A(ir+2*NOBS),H_B(ir+2*NOBS),H_A(ir+3*NOBS),H_B(ir+3*NOBS),
     +  IR,PHASE,D_PAR(1),DFDD(1),DFDDD(1,1),DFDDD(1,2),DFDDD(2,2),
     +  FVALUE,sigp12_now,sigh_now,fom,ID)
            endif
c---checking D paramters in new bins as defined in def_new_bin
            if (check_newbins.eq.1) then
          	  if (dec.ge.20) then 
                if (VERBREF_5N) write(*,*) 'Problem with D parameters!'
              else
                y=0
            	do j=1,Dnum
            	  if ( (.not.dppi_sadh.or.(j.ne.1.and.j.ne.4)) .and.
c     +      	       ( abs(DFDD(j)).gt.100.or.FVALUE.gt.250 ) )  y=1
     +      	       ( FVALUE.gt.250 ) )  y=1
                enddo
                if (y.eq.1) then
                  dec = dec + 1
                  do j=1,Dnum
c scaling factor and some others not decreasing
                    if( ( (.not.dppi_sadh.and..not.dppi_sras.and.
     +                     .not.dppi_sir).or.(j.ne.1) )
     +                .and. (.not.dppi_sadh.or.j.ne.4.or.dm_flag)  
     +                .and. ((.not.dppi_sir.and..not.dppi_sras).or.
     +                        (j.ne.3.and.j.ne.4))
     +                 ) then 
c                      if (.not.dppi_sadh.or.(j.ne.1)) then
                      D_PAR(j) = D_PAR(j)*.98  
                      if (VERBREF_5N) write(*,*)'Decreasing D parameter'
     +                  ,'in',ib_new,'bin (old bin',  ibin,') - from ',
     +                  SCALE_ML2(IB_new,j),'to ',D_PAR(j)
                    endif
                  enddo
                  goto 123
                endif
            	if (dec.ge.1.and.dec.lt.20) then 
              	  do j=1,Dnum
                	SCALE_ML2(ib_new,j) = D_PAR(j)
              	  enddo
            	endif
              endif
            else
c       if (ibin.eq.9) write(*,*) ir,fvalue,fval(ibin),dfdd(2)
c      if(ir.eq.263)write(*,*)icent,yop,yom,sigyop,sigyom,sigm_n(ibin,1)
c     +  ,d_par(2)
              if (.not.scaling) then
                FVAL(IBIN)    = FVAL(IBIN) + iwei*FVALUE
                NREF_ML(IBIN) = NREF_ML(IBIN) + iwei
              else
                FVAL(1)    = FVAL(1) + iwei*FVALUE
                NREF_ML(1) = NREF_ML(1) + iwei
c                write(*,*) 'ref,value:',ir,fvalue,FVAL(1)
              endif
              FOMOVER1      = FOMOVER1 + iwei*FOM
C
C----Calculate derivatives wrt sigma and sigma,A and sigma,B, resp. D parameters
              if (DPPI_no) then 
                DO    I=1,NPART1            
                  DF(I,IBIN0) = DF(I,IBIN0) + 
     &                  iwei*(DFDA*A_CALCS(I)+DFDB*B_CALCS(I))
                  DO   J=1,NPART1
                    DFF(I,J,IBIN0) = DFF(I,J,IBIN0) + 
     &                    iwei*(DFDAA* A_CALCS(I)*A_CALCS(J) +
     &                             DFDAB*(A_CALCS(I)*B_CALCS(J) +
     &                                    A_CALCS(J)*B_CALCS(I))+ 
     &                             DFDBB* B_CALCS(I)*B_CALCS(J))
                  ENDDO
                ENDDO 
             else
                DO    I=1,DNUM
                if (.not.scaling) then
                  DF(I,IBIN0) = DF(I,IBIN0) + iwei*DFDD(I)
                else
                  DF(I,1) = DF(I,1) + iwei*DFDD(I)
                endif
ccc          	    DF(I,IBIN0) = DF(I,IBIN0) + iwei*DFDD(I)
                  DO   J=I,DNUM
                   if (derD2der1_flag) then
ccc           	       DFF(I,J,IBIN0) = DFF(I,J,IBIN0) + DFDD(I)*DFDD(J)
                     if (.not.scaling) then
                      DFF(I,J,IBIN0) = DFF(I,J,IBIN0) + 
     +                               iwei*15*(abs(DFDD(I))+abs(DFDD(J)))
                     else
                      DFF(I,J,1) = DFF(I,J,1) + 
     +                               iwei*15*(abs(DFDD(I))+abs(DFDD(J)))
                     endif
                   else
                     if (.not.scaling) then
                      DFF(I,J,IBIN0)=DFF(I,J,IBIN0)+iwei*abs(DFDDD(I,J))
                     else
                      DFF(I,J,1)=DFF(I,J,1)+iwei*abs(DFDDD(I,J))
                     endif
                   endif
                  ENDDO
                ENDDO
              endif
            endif
            GOTO 100
          ENDIF
          ENDIF
        ENDDO
 100    CONTINUE
      ENDDO
c go out of ml_sc if everything is done.
      if (check_newbins.eq.1)   goto 500

c--- bin based decision making. apply or not? continue with next cycle or not? if yes, 
c--- just decrease actual shifts or calculate new?
c--- end_mlsc(ib) meaning: 1=ref. in bin finished,-1=calculate new shift in nect cycle,0=do not calc. new shift (decrease actual)
      if (.not.scaling) then
        shift_div = 1./5.
        shift_min = 0.005
c        if (dppi_sras.and.substruct_flag) shift_min = 0.0003
        if (dppi_sras) shift_min = 0.0005
c        func_ratio = 0.9995
        func_ratio = 0.9999
        if (dppi_sras) func_ratio = .99999
      else
        shift_div = 1./2.
c        shift_min = 0.0003
        shift_min = 0.0001
        func_ratio = 1.
      endif
      do   IB=1,NBIN_ML
ccc      write(*,*) 'Function value in ',IB,' bin: ',FVAL(IB)
ccc      write(*,*) 'Last function value in ',IB,' bin: ',FVAL_OLD(IB)
      call flush(6)
        if (end_mlsc(IB).ne.1) then
          end_mlsc(IB) = 1
          if (FVAL(IB).ge.FVAL_OLD(IB)) then
      	    do  I=1,DNUM
              SHIFTS(I,IB) = SHIFTS(I,IB)*shift_div
c              if (dppi_sras.and.i.eq.3) 
c     &          SHIFTS(I,IB) = 0.
              if  (abs(SHIFTS(I,IB)).ge.shift_min)  then
                end_mlsc(IB) = 0
              endif
            enddo
          else 
            if ( FVAL(IB).lt.func_ratio*FVAL_OLD(IB)
c			.or.abs(SHIFTS(I,IB)).gt.0.01  
     +           )   end_mlsc(IB) = -1
          endif
          if (end_mlsc(IB).eq.1.and.VERBREF_5N) 
     +		write(6,'(3x,A,i3,A,i5,A,i6,A)') 'Refinement in',IB,
     +        ' bin finished      (',used_bin(IB),
     +        ' refls from',num_ref_bin(IB),' used ).'
        endif
      enddo
      end_mlsc_all = 1
      do   IB=1,NBIN_ML
        if ( end_mlsc(IB).ne.1 )  end_mlsc_all = 0
        if (end_mlsc(IB).ne.-1.or.FVAL(IB).eq.0) then
          if (FVAL_OLD(IB).lt.1e20) FVAL_ALL = FVAL_ALL + FVAL_OLD(IB)
        else
          FVAL_ALL = FVAL_ALL + FVAL(IB)
        endif
      enddo
      if (verbref_5n)
     +  write(*,*) 'Function value after',NCYCS,' cycles: ',FVAL_ALL
c
c---define and test more bins for subcf to avoid interpolation there
c---only for siras and sad at the moment 
      if ((end_mlsc_all.eq.1.or.NCYCS.eq.ncycs_max-1).and.
     &    .not.scaling) then
        if (check_newbins.eq.0.and..not.dppi_no) then
          if (write_luzzd_flag) call write_luzzd(scale_ml,Dnum,nbin_ml,
     &                               MAXBIN+1,NMAXP1+1)
          call def_new_bins(Dnum,i_max)
          check_newbins = 1
          end_mlsc_all=0
          interp = .true.
          if (.not.dppi_no) call check_cov_mat(NREF,hkl_asym,SIGO,Dnum,
     &      D_PAR,i_max,scaling_save,interp,smallsig)
        endif
        do   IBIN=1,NBIN_ML
          end_mlsc(IBIN)=0
      	  do  I=1,DNUM
            SHIFTS(I,IBIN) = 0.0
          enddo
        enddo
        if (check_newbins.eq.1) then
          goto 10
        endif
      endif
      if (end_mlsc_all.eq.1.or.NCYCS.eq.(ncycs_max-1)) goto 500
c
      F_VALUE_OLD = FVAL_ALL
      max_shift = .5
      if (scaling) max_shift = 5.
      DO   IBIN=1,NBIN_ML
        if (.not.DPPI_no) 
     &    call useorigrice(i_max,ibin,rice_bin)
        if (end_mlsc(IBIN).eq.-1) then
          FVAL_OLD(IBIN) = FVAL(IBIN)
C     
C---Apply previous shift. If have changed parameters then different application
C---will be needed
      	  DO   I=1,DNUM
        	SCALE_ML(IBIN,I) = SCALE_ML(IBIN,I)-SHIFTS(I,IBIN)
        	SCALE_ML(IBIN,I) = 
     &      	AMIN1(MAX_SC_ML,AMAX1(MIN_SC_ML,SCALE_ML(IBIN,I)))
      	  ENDDO
C
c---Calculate new shift
         if (DPPI_no) then
           CALL  EIGEN_FILTER_R(TOLER,DFF(1,1,IBIN),NPART1,NMAXPART1,
     &            DF(1,IBIN),SHIFTS(1,IBIN),WORKSPACE,NWORKSPACE)
         else
c           CALL  EIGEN_FILTER_R(TOLER,DFF(1,1,IBIN),DNum-1,NMAXPART1,
c     &            DF(1,IBIN),SHIFTS(1,IBIN),WORKSPACE,NWORKSPACE)
c         if (1.eq.0) then
ccc      write(*,*)'1.der.: ',ibin,DF(1,IBIN),DF(2,IBIN),DF(3,IBIN),
ccc     &  DF(4,IBIN),DF(5,IBIN),DF(6,IBIN)
ccc      write(*,*)'2.der.: ',ibin,DFF(1,1,IBIN),DFF(2,2,IBIN),
ccc     &  DFF(3,3,IBIN),DFF(4,4,IBIN),DFF(5,5,IBIN),DFF(6,IBIN)
          do   I=1,DNUM
            if (DFF(I,I,IBIN).gt.0.) then
              SHIFTS(I,IBIN) = DF(I,IBIN)/DFF(I,I,IBIN)
              SHIFTS(I,IBIN) = DF(I,IBIN)/DFF(I,I,IBIN)
            else
              DFF(I,I,IBIN) = amin1( DFF(I,I,IBIN), -1e-8 )
              SHIFTS(I,IBIN) = - DF(I,IBIN)/DFF(I,I,IBIN)
              SHIFTS(I,IBIN) = - DF(I,IBIN)/DFF(I,I,IBIN)
            endif
            if(SHIFTS(I,IBIN).lt.-max_shift) SHIFTS(I,IBIN) = -max_shift
            if (SHIFTS(I,IBIN).gt.max_shift) SHIFTS(I,IBIN) = max_shift
c            if ((i.eq.2..or.i.eq.3).and.scaling) SHIFTS(I,IBIN) = 0.
c            if ((i.eq.2).and.scaling) SHIFTS(I,IBIN) = 0.
            if (i.ne.1.and.scaling)
     +        SHIFTS(I,IBIN) = 0.
ccc            if ((i.eq.1.or.i.eq.4.or.i.eq.3).and..not.scaling) 
ccc            if ((i.eq.1).and..not.scaling) 
ccc     +        SHIFTS(I,IBIN) = 0.
c            if ((i.eq.1.or.i.eq.4).and..not.scaling.and.
            if ((i.eq.1).and..not.scaling.and.
     &        .not.substruct_flag .and. DPPI_sadh )
     &        SHIFTS(I,IBIN) = 0.
          enddo
          if (substruct_flag.and.dppi_sadh.and.dimen.le.4) then
            scale_ml(ibin,4) = 1.
            SHIFTS(4,IBIN) = 0.
          else if ( .not.substruct_flag.and.
     &      (DPPI_sir.or.(DPPI_sras.and.Dnum>3)) ) then
            scale_ml(ibin,1) = 1.
            SHIFTS(1,IBIN) = 0.
          endif
c!!!!!!!!!!!!!!
c          if (dm_flag.and.dm_d_blur.ne.1.0) SHIFTS(2,IBIN) = 0.
c          scale_ml(ibin,2) = 0.6
c          scale_ml(ibin,4) = 0.4
c        SHIFTS(6,IBIN) = 0.
c        SHIFTS(4,IBIN) = 0.
c        SHIFTS(2,IBIN) = 0.
c        SHIFTS(4,IBIN) = 0.
         endif
        endif
        if (scaling) then 
          scale_ml(ibin,1) = scale_ml(1,1)
          SHIFTS(1,IBIN) = SHIFTS(1,1)
        endif
c         endif
ccc        write(*,*)  '  shifts in ',IBIN,' bin: ',  SHIFTS(1,IBIN),
ccc     +    SHIFTS(2,IBIN),SHIFTS(3,IBIN),SHIFTS(4,IBIN),SHIFTS(5,IBIN),
ccc     +    SHIFTS(6,IBIN)
ccc        write(*,*)  '  scales in ',IBIN,' bin:    ', Scale_ml(IBIN,1),
ccc     +    Scale_ml(IBIN,2),Scale_ml(IBIN,3),Scale_ml(IBIN,4),
ccc     +    Scale_ml(IBIN,5),Scale_ml(IBIN,6)
ccc        call flush(6)
      ENDDO

      if (DPPI_no)
     &  CALL DMLINIT_R1(NREF,ndens,hkl_asym,FO,SIGO,fwt,FC,PHASE,FREER)
C
C---Check convergence
      NCYCS = NCYCS + 1

      IF(NCYCS.LT.ncycs_max ) GOTO 10
 500  CONTINUE

c--- if scaling is done continue with normal D ref.
      if (scaling) then
c        scale_llh_over = scale_llh_over * sqrt(scale_ml(1,1))
        if(verbref_5n)write(*,*)'overall scaling coef. : ',scale_ml(1,1)
        scaling = .false.
        goto 999
      endif
            
c      do   IBIN=1,NBIN_ML
c      SCALE_ML(iBIN,1) = SCALE_ML(iBIN,1)
c      enddo

      NBIN_ML1 = NBIN_ML + 1
      DO  J=1,DNUM+1
         SCALE_ML(NBIN_ML1,J) = SCALE_ML(NBIN_ML,J)
      ENDDO
      SIGMA_ML(NBIN_ML1) = SIGMA_ML(NBIN_ML)
cd      stop
      RETURN
      END
C
C
      subroutine useorigrice(i_max,ibin_ml,rice_bin)
      use weights
c determine whether original Rice will be used for DPPI targets. 
c this is now done in resolution bins with data missing 
c (should consider eg SAD for SIRAS with missing native etc later!)
      implicit none
      INCLUDE 'atom_com.fh'
      include 'anom.fh'
      integer ir,nobs,i_max,ibin_ml,i,num
      logical rice_bin
c      real fo(*), sigo(*)
c      
      rice_bin=.true.
c      rice_bin=.false.
      num=0
      do i=1,i_max
        if (sigm_N(IBin_ml,i).ge.0.001) num=num+1
      enddo
      if (dppi_hldm) num=num+1
      if (num.gt.1) rice_bin=.false.
      return
      end
C      
      subroutine check_cov_mat(NREF,hkl_asym,SIGO,Dnum,D_PAR,i_max,
     &  scaling_save,interp,smallsig)
      use weights
      use agreem
c--- calls procedure that checks eigenvalues of cov matrix and adjusts d par
      implicit none
c      
      INCLUDE 'atom_com.fh'
      include 'anom.fh'
      include 'refi_flags.fh'
      integer Dnum,scaling_save,NREF,i_max
      logical interp
      integer hkl_asym(3,*),smallsig(*)
      integer IB,ibin,i, NBIN_check,ihh(3),ir
      real D_PAR(*),SIGO(*)
      real RHO,RSQ,STL_C
      real SIGP2_NOW(NMAXPART),SIGP12_NOW,sigo_min(maxbin)
      real SP_NOW(NMAX_SIG),SN_NOW(NMAX_SIG),sigo2_now,sigo_now
      REAL LSTLSQ
      EXTERNAL LSTLSQ
c
      if(dppi_no) return
      SP_NOW(1:NMAX_SIG)=0.
      SN_NOW(1:NMAX_SIG)=0.
      NBIN_check = NBIN_ML
      if (interp) NBIN_check = NBIN_ML2
      sigo_min(1:nbin_check)=999999999.
      do   IR=1,NREF
        SIGO_now = SIGO(IR)
        SIGO2_now = 1.
        if (.not.DPPI_hldm) then
          SIGO_now = SIGO(dataset_order(1)*NREF+IR)
          SIGO2_now = SIGO(dataset_order(2)*NREF+IR)
        endif
        ihh(1:3) = hkl_asym(1:3,ir)
        RSQ =  LSTLSQ(1,IHH(1),IHH(2),IHH(3))
        RHO = SQRT(RSQ)
        STL_C = 2.0*RHO
        ibin=0
        do  IB=1,NBIN_check
          IF((.not.interp).and.STL_C.LE.SMAXB_ML(IB).and.
     &                         STL_C.GT.SMINB_ML(IB)) IBIN = IB
          IF ( interp.and.STL_C.LE.SMAXB_ML2(IB).and.
     &                    STL_C.GT.SMINB_ML2(IB)  )   ibin = ib
        enddo
        if (ibin.gt.0) then
          if (sigo_min(ibin).gt.sigo_now.and.sigo_now.gt.0.0001.and.
     &        SIGO2_now.gt.0.0001) then
            sigo_min(ibin)=sigo_now
            smallsig(ibin)=IR
          endif 
        endif
      enddo
      do   IB = 1,NBIN_check
c        if (DPPI_pl)   SIGP2(IB,1) = 0.0
        if (.not.interp) then
          SIGP2_now(1) = SIGP2(IB,1)
          SIGP2_now(2) = SIGP2(IB,2)
          SIGP2_now(3) = SIGP2(IB,3)
          do i=1,Dnum
            D_PAR(i) = SCALE_ML(IB,i)
          enddo
        else
          do i=1,Dnum
            D_PAR(i) = SCALE_ML2(IB,i)
          enddo
        endif
        do i=1,i_max
          SN_NOW(i) = sigm_N(IB,i)
          SP_NOW(i) = sigm_P(IB,i)
C this can happen if datasets are of different resolution
          if (SN_NOW(i).lt.0.001) SN_NOW(i) = 0.
          if (SP_NOW(i).lt.0.001) SP_NOW(i) = 0.
        enddo
ccb        call flush(6)
ccccc add MAD here
        if ( ( (DPPI_sir.or.DPPI_sad.or.DPPI_sadh.or.DPPI_sras)
c     +         .and.SN_NOW(1).gt.0..and.SN_NOW(2).gt.0. .and.
c     +         SP_NOW(1).gt.0..and.SP_NOW(2).gt.0. 
     +    ).or.DPPI_pl.or.DPPI_hldm 
c     +    .or.(DPPI_sras.and.SN_NOW(1).gt.1.and.SN_NOW(2).gt.1) )
     +     )
     +    call check_matrix(IB,SIGN(IB),SIGN2(IB),SIGN2P(IB),sigp(ib),
     +    SIGP2_now(1),SIGP2P(IB),D_PAR(1),sigi(IB),sigp12(IB),sigh(IB),
     +    VERBREF_5N,SN_NOW,SP_NOW,sigo_min(ib),scaling_save )
        do i=1,Dnum
          if (.not.interp) SCALE_ML(IB,i) = D_PAR(i)
          if (interp) SCALE_ML2(IB,i) = D_PAR(i)
        enddo
      enddo
      
      return
      end
C
C
      subroutine def_new_bins(Dnum,i_max)
      use weights
      use agreem
c--- define new bins and interpolate a few input variables in them 
c--- these will only be used in function and derivs calculation in subcf and oppro
      IMPLICIT NONE
c
      INCLUDE 'atom_com.fh'
      include 'anom.fh'
c
      integer Dnum,i_max
      integer i,j,ib,ib_new,bin_multi,i_inter
      integer nbin_ml_dppi, binstart_rice
      real temp_arr(MAXBIN_2+1,100)
      real SP_NOW(NMAX_SIG),SN_NOW(NMAX_SIG),scale_now
      logical rice_bin
c
      if(dppi_no) return
      SCALE_ML2(1:MAXBIN_2,1:Dnum) = 0.
      i_inter = -1
      if (NBIN_ML.le.4) then 
        bin_multi = 8
      else if (NBIN_ML.le.6) then 
        bin_multi = 6
      else if (NBIN_ML.le.8) then 
        bin_multi = 4
      else if (NBIN_ML.le.12) then 
        bin_multi = 3
      else if (NBIN_ML.le.16) then 
        bin_multi = 2
      else
        bin_multi = 1
      endif
      if (substruct_flag)  bin_multi = 1
      NBIN_ML2 = NBIN_ML*bin_multi
      if (bin_multi.eq.1.and..not.substruct_flag) then
c      if (bin_multi.eq.1) then
        SCALE_ML2(1:nbin_ml,1:Dnum) = SCALE_ML(1:nbin_ml,1:Dnum)
        SMINB_ML2(1:nbin_ml)=SMINB_ML(1:nbin_ml)
        SMAXB_ML2(1:nbin_ml)=SMAXB_ML(1:nbin_ml)
        SMEANB_ML2(1:nbin_ml)=SMEANB_ML(1:nbin_ml)
        return
      endif
c      
      nbin_ml_dppi = 0
      binstart_rice = 0
      do   IB=1,NBIN_ML
        call useorigrice(i_max,ib,rice_bin)
        if (.not.rice_bin) nbin_ml_dppi = ib
        if (rice_bin.and.binstart_rice.eq.0) binstart_rice = ib
      enddo
      do   IB=1,NBIN_ML
        call useorigrice(i_max,ib,rice_bin)
        if (bin_multi.gt.0) then
          do   j=1,bin_multi
            ib_new = (ib-1)*bin_multi+j
            SMINB_ML2(ib_new) = SMINB_ML(ib) + 
     &        (SMAXB_ML(ib)-SMINB_ML(ib))*(j-1)/bin_multi
            SMAXB_ML2(ib_new) = SMINB_ML(ib) + 
     &        (SMAXB_ML(ib)-SMINB_ML(ib))*j/bin_multi
            SMEANB_ML2(ib_new)=(SMINB_ML2(ib_new)+SMINB_ML2(ib_new))/2
            if (.not.rice_bin) then
              do i=1,Dnum
                CALL LINTER_VALUE2(NBIN_ML_dppi,SMEANB_ML,SCALE_ML(1,i),
     &                            SMEANB_ML2(ib_new),I_INTER,SCALE_NOW)
                SCALE_ML2(ib_new,i) = SCALE_NOW 
c                write(*,*) ib,ib_new,SCALE_ML2(ib_new,i), SCALE_NOW
              enddo
              do i=1,i_max
                CALL LINTER_VALUE2(NBIN_ML_dppi,SMEANB_ML,sigm_N(1,i),
     &                            SMEANB_ML2(ib_new),I_INTER,SN_NOW(i))
                CALL LINTER_VALUE2(NBIN_ML_dppi,SMEANB_ML,sigm_P(1,i),
     &                            SMEANB_ML2(ib_new),I_INTER,SP_NOW(i))
                temp_arr(ib_new,i) = SN_NOW(i)
                temp_arr(ib_new,i+i_max) = SP_NOW(i)
              enddo
            else
              CALL LINTER_VALUE2(NBIN_ML-binstart_rice+1,
     &          SMEANB_ML(binstart_rice),SCALE_ML(binstart_rice,2),
     &          SMEANB_ML2(ib_new),I_INTER,SCALE_NOW)
              SCALE_ML2(ib_new,2) = SCALE_NOW 
            endif
            CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,sigN(1),
     &                            SMEANB_ML2(ib_new),I_INTER,SN_NOW(1))
            CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,sigP(1),
     &                            SMEANB_ML2(ib_new),I_INTER,SP_NOW(1))
            temp_arr(ib_new,2*i_max+1) = SN_NOW(1)
            temp_arr(ib_new,2*i_max+2) = SP_NOW(1)
          enddo
        endif
      enddo
      do   IB_new=NBIN_ML2,1,-1
        call useorigrice(i_max,(ib_new-1)/bin_multi+1,rice_bin)
c            do i=1,Dnum
c              SCALE_ML(ib_new,i) = temp_arr(ib_new,i)
c            enddo
          do i=1,i_max
            if (.not.rice_bin) then
              sigm_N(ib_new,i) = temp_arr(ib_new,i)
              sigm_P(ib_new,i) = temp_arr(ib_new,i+i_max)
            else
              sigm_N(ib_new,1:i_max) = 0.
              sigm_P(ib_new,1:i_max) = 0.
            endif
          enddo
          sigN(ib_new) = temp_arr(ib_new,2*i_max+1) 
          sigP(ib_new) = temp_arr(ib_new,2*i_max+2) 
          if (dm_flag.and.rice_bin) then
            sigm_N(ib_new,i_max) = 1.
            sigm_P(ib_new,i_max) = sigP(ib_new)
          endif
      enddo
      return
      end
C
C
C
      SUBROUTINE  ML_SCALING_EXPS(NREF,ndens,hkl_asym,FO,SIGO,fwt,
     &     FC,PHASE,FREER,WORKSPACE,NWORKSPACE)
      use weights
      use agreem
      use rharvest
C
C---Find parameters of likelihood
C
      INCLUDE 'refi_flags.fh'
C
      INTEGER NREF,NWORKSPACE,ndens
      INTEGER hkl_asym(3,*)
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      real fwt(*)
      REAL WORKSPACE(*)
C
      INTEGER NMAXPART1
      PARAMETER (NMAXPART1 = 2*NMAXPART + 2)
      REAL DF(NMAXPART1),DFF(NMAXPART1,NMAXPART1),SHIFTS(NMAXPART1)
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART)
      real hlout(4)

      INTEGER I,J,IBIN,NPART1,NPART2,ICENT,NCYCS,IR,IHH(3),NR_C
      INTEGER ISYSAB,IBIN0,NPARAM,I_INTER,ICONVERGED
      REAL    ALPHA
      REAL    RSQ42,RSQ43
      REAL RSQ,STL_C,A_ALL,B_ALL,SIGMA_IN,SIGMA,DFDA,DFDB,DFDAA,
     &     DFDBB,DFDAB,FOM,FVALUE,YO,WT1,EPSI,FVAL_ALL,
     &     F_VALUE_OLD,SCALE_NOW,FOMOVER1,DFDSIG,DFDSIG2,DFDSIGA,
     &     DFDSIGB,SCAL_SIG
      REAL DADPAR(NMAXPART1),DBDPAR(NMAXPART1)
      REAL TOLER
C
C---Tchebyshev polynoms
cd      INTEGER N_COEFS
cd      REAL SMIN_TCH,SMAX_TCH
      REAL SCURRENT
cd      REAL TCH_COEFS(40)
      real delta
      REAL SIM
      LOGICAL FREERCHK
      EXTERNAL SIM
      DATA TOLER/1.0E-6/
C
C---Some initialisation.
cd      NBIN_ML = 1

      NPART1 = NPART + 1
      NPART2 = NPART + 2

      SCAL_SIG = 1.0E4
C
C---First calculate "normalised" structure factors. This "normalisation"
C---is different from normal one. Here we use "differences" for 
C---nomralisation. In effect it is normalisation using differences.
C---We use this normalisation to avoid possible overflow in estimation
C---stage
C--------------------------------------------------------------------
C---Now estimate new ml parameters
      F_VALUE_OLD = 1.0E32
cd      IF(NCYCLE_OVERALL.LE.0) THEN
      CALL DMLINIT_R2(NREF,ndens,hkl_asym,FO,SIGO,fwt,FC,PHASE,FREER)
      CALL APPROX_SIGMA_ML
      SIGMA_ML_B1_OVER      = 0.0
      SIGMA_ML_B2_OVER      = 0.0
C
C---Initialise Tchebyshev coefficient for ML SIGMA. Refine Tchebyshev
C---coefficients only for given cycles
C
C---Refine remainder as B value and scale
C
      CALL APPROX_SIGMA_ML2(NREF,ndens,hkl_asym,FO,SIGO,fwt,
     &     FC,PHASE,FREER)
C
      NCYCS = 0
      CALL FIND_NPARAM_MLGAUSS(NPARAM)
cd      write(*,*)nparam
 10   CONTINUE
      FVAL_ALL = 0.0
      DO    I=1,NPARAM
        DF(I) = 0.0E0
        SHIFTS(I) = 0.0E0
        DO  J=1,NPARAM
          DFF(J,I) = 0.0E0
        ENDDO
      ENDDO
      NR_C = 0
      FOMOVER1 = 0.0
      I_INTER  = -1
      DO   IR=1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN 
          IF((.NOT.LSUSEWORK)  .AND.
     +    (ABS(FREER(IR)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       LSUSEWORK   .AND. 
     +    (ABS(FREER(IR)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IR).GT.0.0
     &       .and.fwt(ir).gt.0.0) THEN
          CALL INDTORS(hkl_asym(1:3,IR),RSQ)
          STL_C = SQRT(RSQ)
          ihh(1:3) = hkl_asym(1:3,ir)
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)
          CALL EXTRACT_ABS(IR,ndens,FC,PHASE,A_CALCS,B_CALCS)
          CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
C
c---Add epsilon centricity here here
          WT1      = REAL(1+ICENT)*EPSI
          SIGMA_IN = 0.0
          RSQ42    = (RSQ/4.0)**2
          RSQ43    = RSQ42*RSQ/4.0
          SIGMA_IN = SIGMA_IN + SIGMA_ML_SCALE_OVER - 
     &                                SIGMA_ML_B_OVER*RSQ/4.0
     &                              + SIGMA_ML_B1_OVER*RSQ42
     &                              + SIGMA_ML_B2_OVER*RSQ43
          SIGMA_IN  = EXP(AMAX1(-30.0,AMIN1(59.0,SIGMA_IN)))*WT1
          CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
          YO  = FO(IR)
          CALL DFUNCDAB_ML(ndens,ICENT,SIGMA,YO,A_ALL,B_ALL,IR,PHASE,
     &                DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,hlout,FOM)
          FVAL_ALL      = FVAL_ALL + fwt(ir)*FVALUE
          FOMOVER1      = FOMOVER1 + fwt(ir)*FOM
          CALL DABDPAR_ML(RSQ,A_CALCS(NPART1),B_CALCS(NPART1),
     &           A_CALCS,B_CALCS,DADPAR,DBDPAR)
C
C----Calculate derivatives wrt ML scale parameters (D values)
          DO    I=1,NPARAM
            DF(I) = DF(I) + DFDA*DADPAR(I) + fwt(ir)*DFDB*DBDPAR(I)
            DO   J=1,NPARAM
              DFF(I,J) = DFF(I,J) + 
     &              fwt(ir)*(DFDAA* DADPAR(I)*DADPAR(J)+
     &                       DFDAB*(DBDPAR(I)*DADPAR(J)+
     &                               DBDPAR(J)*DADPAR(I))+
     &                        DFDBB* DBDPAR(I)*DBDPAR(J))
            ENDDO
          ENDDO
        ENDIF
 100    CONTINUE
      ENDDO
cd      write(*,*)'fvalue ',fval_all
C
c---Change variables? P = exp(T) ? It will make sure that 
C---Parameters will remain positive. Might have some other problems?
C---
      CALL  EIGEN_FILTER_R(TOLER,DFF,NPARAM,NMAXPART1,
     &            DF,SHIFTS,WORKSPACE,NWORKSPACE)
cd      write(*,*)(shifts(i),i=1,nparam)
      DO  I=1,NPARAM
        SHIFTS(I) = -SHIFTS(I)
      ENDDO
cd      CALL PRINT_ML_SCALE

      CALL LINMIN_MLGAUSS(ALPHA,FVAL_ALL,ICONVERGED,ndens,SHIFTS,
     &          NREF,hkl_asym,FO,SIGO,fwt,FC,PHASE,FREER)
cd      write(*,*)iconverged
      IF(ICONVERGED.EQ.1) THEN
C
        alpha = 1.0
        CALL APPLY_SHIFTS_ML_SCALE_PARAMS(ALPHA,SHIFTS)
C
C---Recalculate Sigmas
        CALL APPROX_SIGMA_ML2(NREF,ndens,hkl_asym,FO,SIGO,fwt,FC,PHASE,
     &                        FREER)
C
C---Check convergence
        NCYCS = NCYCS + 1
        IF(NCYCS.LT.10) GOTO 10
      ENDIF
 500  CONTINUE
cd      call print_ml_scale
cd      stop
cd      CALL APPROX_SIGMA_ML

C
cd        CALL CALC_SIGMA_ML1(NREF,hkl_asym,FO,SIGO,FC,PHASE,FREER)

cd      CALL PRINT_LS_SCALE
cd      CALL PRINT_ML_SCALE
cd      WRITE(*,*)'APPROX SIGMA ',SIGMA_ML_SCALE_OVER,SIGMA_ML_B_OVER
cd      SIGMA_ML_B_OVER = SIGMA_ML_B_OVER/1.4
cd      STOP
C
C
C---Now estimate Tchebyshev coefficients for sigma1 (E(mFo-DFc)^2).
C---It is going to be useful for map calculation and second derivative
C---calculations.
C
cd      CALL APPROX_SIGMA_TCHEB_SIGMA1(NREF,hkl_asym,FO,SIGO,FC,PHASE,FREER)
      stl_c = sminb_ml(1)
      delta = (smaxb_ml(nbin_ml)-sminb_ml(1))/1000
cd      call print_ml_scale
cd      write(*,*)sigma_ml_scale_over,sigma_ml_b_over,
cd     &          sigma_ml_b1_over,sigma_ml_b2_over
cd      stop
cd      do   i=1,1001
cd        rsq = stl_c**2
cd        RSQ42    = (RSQ/4.0)**2
cd        RSQ43    = RSQ42*RSQ/4.0
cd        sigma =   SIGMA_ML_SCALE_OVER - 
cd     &            SIGMA_ML_B_OVER*RSQ/4.0
cd     &          + SIGMA_ML_B1_OVER*RSQ42
cd     &           + SIGMA_ML_B2_OVER*RSQ43
cd        stl_c = stl_c + delta
cd        write(55,*)stl_c,sigma
cd      enddo
cd      stop
      RETURN
      END
C
      SUBROUTINE APPROX_SIGMA_ML
      use weights
      IMPLICIT NONE
C
      INTEGER I
      REAL A(2,2),B(2)
      REAL SS2
      LOGICAL ERROR

      B(1) = 0.0
      B(2) = 0.0
      A(1,1) = 0.0
      A(1,2) = 0.0
      A(2,1) = 0.0
      A(2,2) = 0.0
      DO   I=1,NBIN_ML
        A(1,1) = A(1,1) + 1
        SS2    = SMEANB_ML(I)**2/4.0
        A(1,2) = A(1,2) - SS2
        A(2,2) = A(2,2) + SS2*SS2
        B(1)   = B(1)   + ALOG(SIGMA_ML(I))
        B(2)   = B(2)   - SS2*ALOG(SIGMA_ML(I))
      ENDDO
      A(2,1) = A(1,2)

      CALL GAUSSJ(A,2,2,B,1,1,ERROR)
      SIGMA_ML_SCALE_OVER = B(1)
      SIGMA_ML_B_OVER     = B(2)
cd      WRITE(*,*)'APPROX SIGMA ',SIGMA_ML_SCALE_OVER,SIGMA_ML_B_OVER
cd      DO   I=1,NBIN_ML

cd         WRITE(*,*)SIGMA_ML(I),EXP(B(1)-B(2)*SMEANB_ML(I)**2/4.0)
cd      ENDDO
cd      WRITE(*,*)B
cd      STOP



      RETURN
      END
C
      SUBROUTINE APPROX_SIGMA_ML2(NREF,ndens,hkl_asym,FO,SIGO,fwt,
     &     FC,PHASE,FREER)
      use weights
      use agreem
      IMPLICIT NONE
C
C---Find initial values for Sigmas of likelihood function.
      INCLUDE 'refi_flags.fh'
C
      INTEGER NREF,ndens
      INTEGER hkl_asym(3,*)
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      real fwt(*)
C
      INTEGER ITRY,ISH
      INTEGER I,IREF,ICENT,ISYSAB,IBIN,IHH(3),NC,IBIN_S
      REAL WT1,WT2,STL_C,EPSI,RSQ,XX,FOM
      REAL SCURRENT
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART),Y_C,A_ALL,B_ALL
      REAL SIGMA_ML0(MAXBIN)
      REAL SIGMA1,SIGMA,SIGMA_IN

      REAL SS22,SS23
      REAL SS1,SS2,X1,X2
      REAL FVALUE,F_ALL,F_OLD
      REAL TOLER
      REAL A(4,4),B(4),SHIFTS(4)
      INTEGER NWORKSPACE
      REAL WORKSPACE(100)
      LOGICAL FREERCHK
      LOGICAL ERROR
      REAL EPS_LOC
      INTEGER NPART1
      INTEGER j
      REAL SIM
      EXTERNAL SIM
      EXTERNAL INDTORS,CENTR,EPSLON
      DATA EPS_LOC/1.0E-5/,TOLER/1.0E-6/
C
      NWORKSPACE = 100
      NC  = 0
      NPART1 = NPART + 1
 1    CONTINUE
      DO   I=1,NBIN_ML
        NREF_ML(I) = 0
        SIGMA_ML0(I) = 0.0
        SIGMA_ML1(I) = 0.0
      ENDDO
cd      SIGMA_ML_SCALE_OVER = 1.0
cd      SIGMA_ML_B_OVER     = 0.0
      F_OLD = 1.0E32
      DO   I=1,5
      FVALUE = 0.0
      A(1,1) = 0.0E0
      A(1,2) = 0.0E0
      A(2,1) = 0.0E0
      A(2,2) = 0.0E0
      A(1,3) = 0.0E0
      A(2,3) = 0.0E0
      A(3,3) = 0.0E0
      A(1,4) = 0.0E0
      A(2,4) = 0.0E0
      A(3,4) = 0.0E0
      A(4,4) = 0.0E0
      B(1)   = 0.0E0
      B(2)   = 0.0E0
      B(3)   = 0.0E0
      B(4)   = 0.0E0
cd      OPEN(12)
cd      CALL PRINT_ML_SCALE
      F_ALL = 0.0
      DO     IREF = 1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0
     &       .and.fwt(iref).gt.0.0) THEN
            CALL INDTORS(hkl_asym(1:3,IREF),RSQ)
            ihh(1:3) =  hkl_asym(1:3,iref)
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            WT1   = (1.0+REAL(ICENT))*EPSI
            STL_C = SQRT(RSQ)
            CALL EXTRACT_ABS(IREF,ndens,FC,PHASE,A_CALCS,B_CALCS)
            CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &             B_CALCS(NPART1),A_CALCS,B_CALCS)
            Y_C = SQRT(A_ALL**2 + B_ALL**2)
            SS2    = RSQ/4.0
            SS22   = SS2*SS2
            SS23   = SS22*SS2
            SIGMA_IN = 0.0
            SIGMA_IN = SIGMA_IN + SIGMA_ML_SCALE_OVER-
     &                  SIGMA_ML_B_OVER*SS2
            SIGMA_IN = SIGMA_IN + SIGMA_ML_B1_OVER*SS22
            SIGMA_IN = SIGMA_IN + SIGMA_ML_B2_OVER*SS23
            SIGMA_IN = EXP(AMAX1(-30.0,AMIN1(SIGMA_IN,59.0)))*WT1
            CALL SIGCALC_ML(ICENT,SIGO(IREF),SIGMA_IN,SIGMA)
            XX  = 2.0*FO(IREF)*Y_C/SIGMA
            IF(ICENT.EQ.0) THEN
              FOM = SIM(XX)
              CALL BESSI0(XX,X1,X2)
            ELSE
              FOM = TANH(XX)
              IF(XX.GT.60.0) THEN
                 X2 = XX
                 X1 = 0.5
              ELSE
                 X1 = COSH(XX)
                 X2 = 0.0
              ENDIF
            ENDIF
            SS1 = (FO(IREF)**2 + Y_C**2 - 2.0*FOM*FO(IREF)*Y_C)
            FVALUE = (FO(IREF)**2+Y_C**2)/SIGMA-ALOG(X1) - X2
     &                       + ALOG(SIGMA)/REAL(1+ICENT) 
            F_ALL = F_ALL + fwt(iref)*FVALUE
            WT2    = 1.0/REAL(1+ICENT)
            A(1,1) = A(1,1) + fwt(iref)*WT2
            A(1,2) = A(1,2) - fwt(iref)*SS2*WT2
            A(2,2) = A(2,2) + fwt(iref)*SS2*SS2*WT2
            A(1,3) = A(1,3) + fwt(iref)*SS22*WT2
            A(2,3) = A(2,3) - fwt(iref)*SS22*SS2*WT2
            A(3,3) = A(3,3) + fwt(iref)*SS22*SS22*WT2
            A(1,4) = A(1,4) + fwt(iref)*SS23*WT2
            A(2,4) = A(2,4) - fwt(iref)*SS23*SS2*WT2
            A(3,4) = A(3,4) + fwt(iref)*SS23*SS22*WT2
            A(4,4) = A(4,4) + fwt(iref)*SS23*SS23*WT2
            B(1)   = B(1)   + fwt(iref)*SS1/SIGMA-WT2
            B(2)   = B(2)   - fwt(iref)*SS2*(SS1/SIGMA-WT2)
            B(3)   = B(3)   + fwt(iref)*SS22*(SS1/SIGMA-WT2)
            B(4)   = B(4)   + fwt(iref)*SS23*(SS1/SIGMA-WT2)
        ENDIF
 100    CONTINUE
      ENDDO
cd      WRITE(*,*)FVALUE
      A(2,1) = A(1,2)
      A(3,1) = A(1,3)
      A(3,2) = A(2,3)
      A(4,1) = A(1,4)
      A(4,2) = A(2,4)
      A(4,3) = A(3,4)
      CALL  EIGEN_FILTER_R(TOLER,A,4,4,
     &            B,SHIFTS,WORKSPACE,NWORKSPACE)
      SIGMA_ML_SCALE_OVER = SIGMA_ML_SCALE_OVER + SHIFTS(1)
      SIGMA_ML_B_OVER     = SIGMA_ML_B_OVER     + SHIFTS(2)
      SIGMA_ML_B1_OVER    = SIGMA_ML_B1_OVER    + SHIFTS(3)
      SIGMA_ML_B2_OVER    = SIGMA_ML_B2_OVER    + SHIFTS(4)

      F_OLD = F_ALL
C
C--Calculate value
      ITRY = 0
 50   CONTINUE
      F_ALL = 0.0
      DO     IREF = 1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0
     &       .and.fwt(iref).gt.0.0) THEN
            CALL INDTORS(hkl_asym(1:3,IREF),RSQ)
            ihh(1:3) = hkl_asym(1:3,iref)
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            WT1   = (1.0+REAL(ICENT))*EPSI
            STL_C = SQRT(RSQ)
            CALL EXTRACT_ABS(IREF,ndens,FC,PHASE,A_CALCS,B_CALCS)
            CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &             B_CALCS(NPART1),A_CALCS,B_CALCS)
            Y_C = SQRT(A_ALL**2 + B_ALL**2)

            SS2    = RSQ/4.0
            SS22   = SS2*SS2
            SS23   = SS22*SS2
            SIGMA_IN = 0.0
            SIGMA_IN = SIGMA_IN + SIGMA_ML_SCALE_OVER-
     &                  SIGMA_ML_B_OVER*SS2
            SIGMA_IN = SIGMA_IN + SIGMA_ML_B1_OVER*SS22
            SIGMA_IN = SIGMA_IN + SIGMA_ML_B2_OVER*SS23

            SIGMA_IN = EXP(AMAX1(-30.0,AMIN1(SIGMA_IN,59.0)))*WT1

            CALL SIGCALC_ML(ICENT,SIGO(IREF),SIGMA_IN,SIGMA)
            XX  = 2.0*FO(IREF)*Y_C/SIGMA
            IF(ICENT.EQ.0) THEN
              FOM = SIM(XX)
              CALL BESSI0(XX,X1,X2)
            ELSE
              FOM = TANH(XX)
              IF(XX.GT.60.0) THEN
                 X2 = XX
                 X1 = 0.5
              ELSE
                 X1 = COSH(XX)
                 X2 = 0.0
              ENDIF
            ENDIF
            SS1 = (FO(IREF)**2 + Y_C**2 - 2.0*FOM*FO(IREF)*Y_C)
            FVALUE = (FO(IREF)**2+Y_C**2)/SIGMA-ALOG(X1) - X2
     &                       + ALOG(SIGMA)/REAL(1+ICENT) 
            F_ALL = F_ALL + fwt(iref)*FVALUE
        ENDIF
      ENDDO
      IF(F_ALL.GT.F_OLD) THEN
         ITRY = ITRY + 1
         DO  ISH=1,4
           SHIFTS(ISH) = SHIFTS(ISH)/2.0
         ENDDO
        SIGMA_ML_SCALE_OVER = SIGMA_ML_SCALE_OVER - SHIFTS(1)
        SIGMA_ML_B_OVER     = SIGMA_ML_B_OVER     - SHIFTS(2)
        SIGMA_ML_B1_OVER    = SIGMA_ML_B1_OVER    - SHIFTS(3)
        SIGMA_ML_B2_OVER    = SIGMA_ML_B2_OVER    - SHIFTS(4)

        IF(ITRY.LE.6) THEN
           GOTO 50
        ELSE
          SIGMA_ML_SCALE_OVER = SIGMA_ML_SCALE_OVER - SHIFTS(1)
          SIGMA_ML_B_OVER     = SIGMA_ML_B_OVER     - SHIFTS(2)
          SIGMA_ML_B1_OVER    = SIGMA_ML_B1_OVER    - SHIFTS(3)
          SIGMA_ML_B2_OVER    = SIGMA_ML_B2_OVER    - SHIFTS(4)
          GOTO 200
        ENDIF
      ENDIF
cd      STOP

cd      IF(F_ALL.GT.F_OLD) GOTO 200
cd      WRITE(*,*)F_ALL,F_OLD
      F_OLD = F_ALL

      ENDDO
 200  CONTINUE
cd      WRITE(*,*)SIGMA_ML_SCALE_OVER,SIGMA_ML_B_OVER,SIGMA_ML_B1_OVER,
cd     &          SIGMA_ML_B2_OVER
cd      STOP
C
      RETURN
      END
C
      SUBROUTINE SIGCALC_ML(ICENT,SIGMA_OBS,SIGMA_IN,SIGMA)
      use weights
      use agreem
C
C---Calculate sigma of current reflection
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'const.fh'
C
      INTEGER ICENT
      REAL SIGMA_IN,SIGMA,SIGMA_OBS
C
      REAL SIGMES
      SIGMES = 0.0
      IF(LEXPUSE)SIGMES = SIGMA_OBS
C
C---Epsilon and centricty have already been added.
      SIGMA = 2.0*SIGMES + SIGMA_IN
Cejd - Check for ridiculously small or negative SIGMA
      IF( SIGMA.LT.ZEPS)  SIGMA = ZEPS
      RETURN
      END
C
      SUBROUTINE CALC_SCALE_P(RSQ,SCALE_P)
      use weights
      IMPLICIT NONE
C
C
      REAL RSQ,SCALE_P
C
      REAL RSQ1
C
      RSQ1 = RSQ/4.0

      SCALE_P = (1.0-D_ML_SCALE_BBULK*EXP(-RSQ1*D_ML_B_BBULK))*
     &           D_ML_SCALE_OVER*EXP(-RSQ1*D_ML_B_OVER)

      RETURN
      END
C
      SUBROUTINE CALC_ASANDBS_MLGAUSS(RSQI,A_ALL,B_ALL,A_PROT,B_PROT,
     &                  A_PART,B_PART)
      use weights
C
      IMPLICIT NONE
C
C---Applies scale factor for calculated with ML to A and B.
C
      INCLUDE 'refi_flags.fh'
C
      REAL A_PART(*),B_PART(*)
      REAL A_PROT,B_PROT,RSQI,A_ALL,B_ALL
C
      INTEGER I
      REAL BBULK,DEXPP,P_AND_BULK,SCALE1,RSQ
C
      RSQ   = RSQI/4.0
      A_ALL = 0.0
      B_ALL = 0.0
C
C--Babinet's bulk if avilable
      BBULK = 1.0 - D_ML_SCALE_BBULK*EXP(-RSQ*D_ML_B_BBULK)
      DEXPP = D_ML_SCALE_OVER*EXP(-RSQ*D_ML_B_OVER)
      P_AND_BULK = DEXPP*BBULK
      A_ALL = A_PROT
      B_ALL = B_PROT
C
C---Partial structure (such as solvent) if available
      IF(NPART.GT.0) THEN
        DO   I=1,NPART
          SCALE1 = D_ML_SCALE_PART(I)*EXP(-RSQ*D_ML_B_PART(I))
          A_ALL  = A_ALL + A_PART(I)*SCALE1
          B_ALL  = B_ALL + B_PART(I)*SCALE1
        ENDDO
      ENDIF
      A_ALL = A_ALL*P_AND_BULK
      B_ALL = B_ALL*P_AND_BULK
cd      WRITE(*,*)D_ML_SCALE_OVER,D_ML_B_OVER
cd      WRITE(*,*)'In asandbs',A_ALL,B_ALL,P_AND_BULK,A_PROT,B_PROT,NPART,
cd     &           BBULK,
cd     &          DEXPP,SCALE1
      RETURN
      END
C
      SUBROUTINE FIND_NPARAM_MLGAUSS(NPARAM)
      use weights
      IMPLICIT NONE
C
      INCLUDE 'refi_flags.fh'
      INTEGER NPARAM
C
      INTEGER I
C
      NPARAM = 2
      IF(ML_BULK_REFINE_FLAG) NPARAM = NPARAM + 2
      DO   I=1,NPART
        IF(ML_PART_REFINE_FLAG(I)) NPARAM = NPARAM + 2
      ENDDO
      RETURN
      END
C
      SUBROUTINE DABDPAR_ML(RSQI,A_PROT,B_PROT,A_PART,B_PART,
     &           DADPAR,DBDPAR)
      use weights
      IMPLICIT NONE
C
      REAL RSQI,A_PROT,B_PROT
      REAL A_PART(*),B_PART(*)
      REAL DADPAR(*),DBDPAR(*)
C
      INCLUDE 'refi_flags.fh'
C
      INTEGER I,J
      REAL A_ALL,B_ALL,AC1,BC1,RSQ
      REAL EXPBULK,DEXPBULK,BBULK,EXPP,DEXPP,P_AND_BULK,EXPPART
      REAL DEXPPART
C
      RSQ     = RSQI/4.0
      EXPBULK = EXP(-RSQ*D_ML_B_BBULK)
      DEXPBULK = D_ML_SCALE_BBULK*EXPBULK
      BBULK    = 1.0 - DEXPBULK
C
      EXPP     = EXP(-RSQ*D_ML_B_OVER)
      DEXPP    = D_ML_SCALE_OVER*EXPP
      P_AND_BULK = BBULK*DEXPP
      A_ALL    = A_PROT
      B_ALL    = B_PROT
C
      J = 0
      IF(NPART.GT.0) THEN
        DO   I=1,NPART
          EXPPART  = EXP(-RSQ*D_ML_SCALE_PART(I))
          DEXPPART = D_ML_SCALE_PART(I)*EXPPART
C
          AC1           =      DEXPPART*A_PART(I)
          BC1           =      DEXPPART*B_PART(I)
          IF(ML_PART_REFINE_FLAG(I)) THEN
            DADPAR(J+1) =     EXPPART*P_AND_BULK*A_PART(I)
            DADPAR(J+2) =    -RSQ*P_AND_BULK*AC1
            DBDPAR(J+1) =     EXPPART*P_AND_BULK*B_PART(I)
            DBDPAR(J+2) =    -RSQ*P_AND_BULK*BC1
            J           =    J+2
          ENDIF
          A_ALL         = A_ALL + AC1
          B_ALL         = B_ALL + BC1
        ENDDO
      ENDIF
C
C---Protein part
      DADPAR(J+1)    = A_ALL*BBULK*EXPP
      DADPAR(J+2)    = -RSQ*A_ALL*P_AND_BULK
      DBDPAR(J+1)    = B_ALL*BBULK*EXPP
      DBDPAR(J+2)    = -RSQ*B_ALL*P_AND_BULK
      J              = J + 2
      IF(ML_BULK_REFINE_FLAG) THEN
        DADPAR(J+1) = -A_ALL*EXPBULK*DEXPP
        DADPAR(J+2) = RSQ*A_ALL*DEXPBULK*DEXPP
        DBDPAR(J+1) = -B_ALL*EXPBULK*DEXPP
        DBDPAR(J+2) = RSQ*B_ALL*DEXPBULK*DEXPP
      ENDIF
      RETURN
      END
C
      SUBROUTINE LINMIN_MLGAUSS(ALPHA,F_VALUE0,ICONVERGED,ndens,SHIFTS,
     &          NREF,hkl_asym,FO,SIGO,fwt,FC,PHASE,FREER)
      use weights
      use agreem
      IMPLICIT NONE
C
C---Simple line minimisation for ML parameters estimation. 
      include 'refi_flags.fh'
      INTEGER NREF,ICONVERGED,ndens
      INTEGER hkl_asym(3,*)
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nref*(npart+1),ndens),PHASE(nref*(npart+5),ndens)
      real fwt(*)
      REAL ALPHA,F_VALUE0
      REAL SHIFTS(*)
C
      REAL  F2,F3,F_VALUE,F_VALUE2,F_VALUE3,ALPHA2,ALPHA3,ALPHAT
      REAL  A,B
      REAL SAVE_PARAMS_ARRAY(2*NMAXPART + 4)
      INTEGER NWORK,N_TRY

      NWORK =  2*NMAXPART + 4
      ALPHA = 1.0
      CALL SAVE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
      CALL APPLY_SHIFTS_ML_SCALE_PARAMS(ALPHA,SHIFTS)
C
      ALPHA3 = 1
      ALPHA2 = ALPHA
      CALL CALC_FVALUE_ML_ALL(NREF,ndens,hkl_asym,FO,SIGO,fwt,FC,PHASE,
     &                FREER,F_VALUE)
      IF(F_VALUE.LT.F_VALUE0) THEN
        ALPHA      = ALPHA3
        ICONVERGED = 1
        CALL RESTORE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
        RETURN
      ELSE
        F_VALUE3 = F_VALUE
        N_TRY = 0
 10     CONTINUE
        ALPHA2 = ALPHA2/2.0
        N_TRY = N_TRY + 1
       
        CALL RESTORE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
        CALL APPLY_SHIFTS_ML_SCALE_PARAMS(ALPHA2,SHIFTS)
        CALL CALC_FVALUE_ML_ALL(NREF,ndens,hkl_asym,FO,SIGO,fwt,
     &       FC,PHASE,FREER,F_VALUE2)
        IF(F_VALUE2.LT.F_VALUE0) THEN
          ALPHA = ALPHA2
C
C--Find quadratic approximation (parabolic fit). If it is in the interval 
C--use it. Otherwise use this value.
          F2 = F_VALUE2 - F_VALUE0
          F3 = F_VALUE3 - F_VALUE0
          A  = 2.0*(F3*ALPHA2**2 - F2*ALPHA3**2)
          B  =      F2*ALPHA3    - F3*ALPHA2
          IF(A.NE.0.0) THEN
            ALPHAT = -B/A
          ELSE 
            ALPHAT = -1.0
          ENDIF
          ICONVERGED = 1
          CALL RESTORE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
          RETURN
        ENDIF
        ALPHA3 = ALPHA2
        IF(N_TRY.LE.3) GOTO 10
      ENDIF
      CALL RESTORE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
      ICONVERGED = 0
      RETURN
      END
C
      SUBROUTINE  CALC_FVALUE_ML_ALL(NREF,ndens,hkl_asym,FO,SIGO,fwt,FC,
     &     PHASE,FREER,F_VALUE)
      use weights
      use agreem
C
C---Calculate value of the likelihood
      IMPLICIT NONE
      INCLUDE 'refi_flags.fh'
C
      INTEGER NREF,NWORKSPACE,ndens
      INTEGER hkl_asym(3,*)
      REAL F_VALUE
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      real fwt(*)
C
      INTEGER NMAXPART1
      PARAMETER (NMAXPART1 = NMAXPART + 2)
      REAL   A_CALCS(NMAXPART),B_CALCS(NMAXPART)

      INTEGER I,J,NPART1,ICENT,IR,IHH(3),NR_C,ISYSAB,I_INTER
      REAL RSQ,STL_C,A_ALL,B_ALL,SIGMA_IN,SIGMA
      REAL SCURRENT
      REAL EPSI,WT1
      REAL FVALUE_S
      REAL TOLER
      REAL SIM
      LOGICAL FREERCHK
      EXTERNAL SIM
C
C---Calculate value of the function
      NPART1 = NPART+1
      F_VALUE = 0.0
      DO   IR=1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN 
          IF((.NOT.LSUSEWORK)  .AND.
     +    (ABS(FREER(IR)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       LSUSEWORK   .AND. 
     +    (ABS(FREER(IR)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IR).GT.0.0
     &       .and.fwt(ir).gt.0.0) THEN
          CALL INDTORS(hkl_asym(1:3,IR),RSQ)
          STL_C = SQRT(RSQ)
          ihh(1:3) = hkl_asym(1:3,ir)
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)
          CALL EXTRACT_ABS(IR,ndens,FC,PHASE,A_CALCS,B_CALCS)
          CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
C
c---Add epsilon centricity here here
          WT1      = REAL(1+ICENT)*EPSI
          SIGMA_IN = 0.0
          SIGMA_IN = SIGMA_IN + SIGMA_ML_SCALE_OVER - 
     &                                SIGMA_ML_B_OVER*RSQ/4.0
          SIGMA_IN = SIGMA_IN + SIGMA_ML_B1_OVER*(RSQ/4.0)**2
          SIGMA_IN = SIGMA_IN + SIGMA_ML_B2_OVER*(RSQ/4.0)**3
          SIGMA_IN  = EXP(AMAX1(-30.0,AMIN1(59.0,SIGMA_IN)))*WT1
          CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
          CALL CALC_FVALUE_ML(ndens,ICENT,SIGMA,FO(IR),A_ALL,B_ALL,IR,
     &                         PHASE,FVALUE_S)
          F_VALUE      = F_VALUE + fwt(ir)*FVALUE_S

        ENDIF
 100    CONTINUE
      ENDDO
C
      RETURN
      END
C
      SUBROUTINE CALC_FVALUE_ML(ndens,ICENT,SIGMA,YO,AC,BC,IR,PHASE,
     &                          FVALUE)
      use agreem
C
C---Subroutine to calculate partial derivatives of functional w.r.t. 
C---real and imagenary parts of structure factors (A,B). This subroutine
C---should be modified for intensity based likelihood
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      REAL PHASE(nobs*(npart+5),ndens)
C
C---Local common blocks
      REAL COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINCS
      COMMON /HKL_COMM/ COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
      REAL HLA,HLB,HLC,HLD,HLA1,HLB1
C
      COSC = 1.0
      SINC = 0.0
      YC   = SQRT(AC*AC+BC*BC)
      IF(YC.GT.0.0) THEN
        COSC = AC/YC
        SINC = BC/YC
      ENDIF

      APROB = 1.0
cd        YOS2  = 4.0/SIGMA**2
cd        YOS2  = 4.0*(YC**2+SIGMA)/SIGMA**2
cd        YOS2  = 4.0*(YO**2/3.0 + 2.0*YC**2/3.0)/SIGMA**2
C
C---Likelihood function. In general form of one of diagonal approximation of
C---   -loglikelihood 
C
C                         (|Fo|^2+|Fc|^2)/SIGMA - 
C   log(int(0,2pi){p(phi)exp(2.0|FO||Fc|cos(phi-phic)/sigma)|dphi+log(sigma) 
C
C                           (|Fo|^2+|Fc|^2)/SIGMA - 
C   log(sum(1,2){p(phi)exp(2.0|FO||Fc|cos(phi-phic)/sigma)|dphi+1/2 log(sigma) 
C
C----acentric and centric reflections respectively.
C----In above equations constants were ignored
      IF(YO.GT.0.0) THEN
        XX   = 2.0*YO*YC/SIGMA
        HLA   = 0.0
        HLB   = 0.0
        HLC   = 0.0
        HLD   = 0.0
        IF(MIR_FLAG) THEN
          IPOS = (NPART+1)*NOBS + IR
          HLA  = PHASE(IPOS,1)
          IPOS = IPOS+NOBS
          HLB  = PHASE(IPOS,1)
          IPOS = IPOS+NOBS
          HLC  = PHASE(IPOS,1)
          IPOS = IPOS+NOBS
          HLD  = PHASE(IPOS,1)
        ENDIF
        HLAB = SQRT(HLA*HLA+HLB*HLB)
        HLCD = SQRT(HLC*HLC+HLD*HLD)
        IF(.NOT.MIR_FLAG.OR.
     +       ((HLAB+HLCD).LT.0.00001)) THEN
C
C----No MIR/MAD or uniform distribution of phases. Use Rice distribution
C-----------------------------------------------------------------
          CALL PH_PROB_RICE_0(ICENT,XX,APROB,XC)

          IF(ICENT.EQ.0) THEN
            APROB = 2.0*APROB
          ELSE
            APROB = 2.0*APROB/SQRT(PI)
          ENDIF
C-----------------------------------------------------------------
        ELSEIF((HLAB.GT.80.00)
     +                .AND.(HLCD.LT.0.0001)) THEN
C
C---Exact phases. Use complex SFs (i.e. |Fc-Fo|^2/Sigma)
C-----------------------------------------------------------------
          COSAA   = HLA/HLAB
          SINAA   = HLB/HLAB
          XC      =  2.0*YO*YC*(COSC*COSAA - SINC*SINAA)/SIGMA
          IF(ICENT.EQ.0) THEN
            APROB   = 1.0/PI
          ELSE
            APROB   = SQRT(1.0/PI)
          ENDIF
C-----------------------------------------------------------------
        ELSEIF(HLCD.LT.0.0001) THEN
C
C---HLC = HLD = 0.0
           HLA1 = HLA + COSC*XX
           HLB1 = HLB + SINC*XX
           XX1  = SQRT(HLA1**2+HLB1**2)
           PHI_COMB  = 0.0
           COS_COMB = 1.0
           SIN_COMB = 0.0
           IF(XX1.GT.0.0) THEN
             COS_COMB = HLA1/XX1
             SIN_COMB = HLB1/XX1
           ENDIF
           CALL PH_PROB_RICE_0(ICENT,XX1,APROB,XC)
           IF(ICENT.EQ.0) THEN
             APROB = APROB*(2.0)
           ELSE
             APROB = 2.0*APROB/SQRT(PI)
          ENDIF
        ELSE
C---------------------------------------
C
C---Some phase distribution. All HLA HLB,HLC,HLD are non zero
C-----------------------------------------------------------------
C
           HLA1 = HLA + COSC*XX
           HLB1 = HLB + SINC*XX
           CALL PHASE_PROB_0(ICENT,HLA1,HLB1,HLC,HLD,APROB,XC)
           COSSQA = (1.0+COS2A)/2.0
           SINSQA = (1.0-COS2A)/2.0
           SINCOSA= SIN2A/2.0
           IF(ICENT.EQ.0) THEN
             APROB = APROB/PI
           ELSE
             APROB = APROB/SQRT(TWOPI)
           ENDIF
C-----------------------------------------------------------------
        ENDIF   
C
C----Value of functional
        FVALUE = (YO*YO+YC*YC)/SIGMA - (ALOG(APROB) + XC) + 
     &                  ALOG(SIGMA)/(REAL(ICENT)+1.0)
        IF(ICENT.EQ.0.AND.YO.GT.0.0) FVALUE = FVALUE - ALOG(YO)
      ELSE
        FVLALUE = 0.0
      ENDIF
      RETURN
      END
C
      SUBROUTINE RESTORE_ML_PARAMS(N_SAVE_ARRAY,SAVE_PARAMS_ARRAY)
      use weights
      IMPLICIT NONE
      INCLUDE 'refi_flags.fh'
C
      INTEGER N_SAVE_ARRAY
      REAL SAVE_PARAMS_ARRAY(*)
C
      INTEGER I,J
C
      IF(N_SAVE_ARRAY.LT.2*NPART+4) THEN
        CALL ERRWRT(1,'Size mismatch in SAVE_ML_PARAMS')
      ENDIF

      D_ML_SCALE_OVER = SAVE_PARAMS_ARRAY(1)
      D_ML_B_OVER     = SAVE_PARAMS_ARRAY(2)
      J = 2
      DO   I=1,NPART
        D_ML_SCALE_PART(I) = SAVE_PARAMS_ARRAY(J+1)
        D_ML_B_PART(I)     = SAVE_PARAMS_ARRAY(J+2)
        J = J + 2
      ENDDO
      D_ML_SCALE_BBULK = SAVE_PARAMS_ARRAY(J+1)
      D_ML_B_BBULK     = SAVE_PARAMS_ARRAY(J+2)
      RETURN
      END
C
      SUBROUTINE APPLY_SHIFTS_ML_SCALE_PARAMS(CC,DSHIFTS)
      use weights
      IMPLICIT NONE
C
C---This subroutine appies shifts to ML scale parameters. Shifts are 
C---multiplied by CC
C
      INCLUDE 'refi_flags.fh'
C
      REAL CC
      REAL DSHIFTS(*)
C
      INTEGER I,J
C
      J  = 0
      DO  I=1,NPART
        IF(ML_PART_REFINE_FLAG(I)) THEN
          D_ML_SCALE_PART(I) = AMAX1(0.001,D_ML_SCALE_PART(I)+
     &                             REAL(DSHIFTS(J+1))*CC)
          D_ML_B_PART(I)     = AMIN1(150.0,
     &     AMAX1(-10.0,D_ML_B_PART(I)+CC*REAL(DSHIFTS(J+2))))
          J = J + 2
        ENDIF
      ENDDO
      D_ML_SCALE_OVER = AMAX1(0.1,D_ML_SCALE_OVER + 
     &                                 REAL(DSHIFTS(J+1))*CC)
      D_ML_B_OVER     = AMIN1(150.0,
     &         AMAX1(-20.0,D_ML_B_OVER     + REAL(DSHIFTS(J+2))*CC))
cd      D_ML_B_OVER     =  D_ML_B_OVER     + DSHIFTS(J+2)*CC

      J = J + 2
      IF(ML_BULK_REFINE_FLAG) THEN
        D_ML_SCALE_BBULK = AMIN1(0.99,AMAX1(0.0,
     &                      D_ML_SCALE_BBULK + REAL(DSHIFTS(J+1))*CC))
        D_ML_B_BBULK     = AMIN1(150.0,
     &        AMAX1(-10.0,D_ML_B_BBULK    + REAL(DSHIFTS(J+2))*CC))
      ENDIF

      RETURN
      END
C
      SUBROUTINE SAVE_ML_PARAMS(N_SAVE_ARRAY,SAVE_PARAMS_ARRAY)
      use weights
      IMPLICIT NONE
      INCLUDE 'refi_flags.fh'
C
      INTEGER N_SAVE_ARRAY
      REAL SAVE_PARAMS_ARRAY(*)
C
      INTEGER I,J
C
      IF(N_SAVE_ARRAY.LT.2*NPART+4) THEN
        CALL ERRWRT(1,'Size mismatch in SAVE_ML_PARAMS')
      ENDIF


      SAVE_PARAMS_ARRAY(1) = D_ML_SCALE_OVER
      SAVE_PARAMS_ARRAY(2) = D_ML_B_OVER
      J = 2
      DO   I=1,NPART
        SAVE_PARAMS_ARRAY(J+1) = D_ML_SCALE_PART(I)
        SAVE_PARAMS_ARRAY(J+2) = D_ML_B_PART(I)
        J = J + 2
      ENDDO
      SAVE_PARAMS_ARRAY(J+1) = D_ML_SCALE_BBULK
      SAVE_PARAMS_ARRAY(J+2) = D_ML_B_BBULK
      RETURN
      END
C
      SUBROUTINE 
     +  DFUNCDAB_ML(ndens,ICENT,SIGMA,YO,AC,BC,IR,PHASE,DFDA,DFDB,
     +                    DFDAA,DFDAB,DFDBB,FVALUE,hlout,FOM)
      use agreem
C
C---Subroutine to calculate partial derivatives of functional w.r.t. 
C---real and imagenary parts of structure factors (A,B). This subroutine
C---should be modified for intensity based likelihood
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      REAL PHASE(nobs*(npart+5),ndens)
C
C---Local common blocks
      COMMON /HKL_COMM/ COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
      REAL HLA,HLB,HLC,HLD,HLA1,HLB1
      real hlout(4)
C
      COSC = 1.0
      SINC = 0.0
      YC   = SQRT(AC*AC+BC*BC)
      IF(YC.GT.0.0) THEN
        COSC = AC/YC
        SINC = BC/YC
      ENDIF

      APROB = 1.0
cd        YOS2  = 4.0/SIGMA**2
cd        YOS2  = 4.0*(YC**2+SIGMA)/SIGMA**2
cd        YOS2  = 4.0*(YO**2/3.0 + 2.0*YC**2/3.0)/SIGMA**2
C
C---Likelihood function. In general form of one of diagonal approximation of
C---   -loglikelihood 
C
C                         (|Fo|^2+|Fc|^2)/SIGMA - 
C   log(int(0,2pi){p(phi)exp(2.0|FO||Fc|cos(phi-phic)/sigma)|dphi+log(sigma) 
C
C                           (|Fo|^2+|Fc|^2)/SIGMA - 
C   log(sum(1,2){p(phi)exp(2.0|FO||Fc|cos(phi-phic)/sigma)|dphi+1/2 log(sigma) 
C
C----acentric and centric reflections respectively.
C----In above equations constants were ignored
      IF(YO.GT.0.0) THEN
      COSC2 = COSC*COSC
      SINC2 = SINC*SINC
      XX   = 2.0*YO*YC/SIGMA
      YOS2 = 4.0*YO*YO/(SIGMA*SIGMA)
      HLA   = 0.0
      HLB   = 0.0
      HLC   = 0.0
      HLD   = 0.0
      IF(MIR_FLAG) THEN
        IPOS = (NPART+1)*NOBS + IR
        HLA  = PHASE(IPOS,1)
        IPOS = IPOS+NOBS
        HLB  = PHASE(IPOS,1)
        IPOS = IPOS+NOBS
        HLC  = PHASE(IPOS,1)
        IPOS = IPOS+NOBS
        HLD  = PHASE(IPOS,1)
      ENDIF
      hlout(1) = hla + cosc*xx
      hlout(2) = hlb + sinc*xx
      hlout(3) = hlc
      hlout(4) = hld
      HLAB = SQRT(HLA*HLA+HLB*HLB)
      HLCD = SQRT(HLC*HLC+HLD*HLD)
      IF(.NOT.MIR_FLAG.OR.
     +     ((HLAB+HLCD).LT.0.00001)) THEN
C
C----No MIR/MAD or uniform distribution of phases. Use Rice distribution
C-----------------------------------------------------------------
        CALL PH_PROB_RICE(ICENT,XX,COSC,SINC,COSAA,SINAA,
     +                                   COS2A,SIN2A,APROB,XC)
        COSSQA = (1.0+COS2A)/2.0
        SINSQA = (1.0-COS2A)/2.0
        SINCOSA = SIN2A/2.0
        IF(ICENT.EQ.0) THEN
          APROB = APROB*(2.0)
        ELSE
          APROB = 2.0*APROB/SQRT(PI)
        ENDIF
C-----------------------------------------------------------------
      ELSEIF((HLAB.GT.80.00)
     +              .AND.(HLCD.LT.0.0001)) THEN
C
C---Exact phases. Use complex SFs (i.e. |Fc-Fo|^2/Sigma)
C-----------------------------------------------------------------
        COSAA   = HLA/HLAB
        SINAA   = HLB/HLAB
        COSSQA  = COSAA*COSAA
        SINSQA  = SINAA*SINAA
        SINCOSA = COSAA*SINAA
        XC      =  2.0*YO*YC*(COSC*COSAA - SINC*SINAA)/SIGMA
        IF(ICENT.EQ.0) THEN
          APROB   = 1.0/PI
        ELSE
          APROB   = SQRT(1.0/PI)
        ENDIF
C-----------------------------------------------------------------
      ELSEIF(HLCD.LT.0.0001) THEN
C
C---HLC = HLD = 0.0
         HLA1 = HLA + COSC*XX
         HLB1 = HLB + SINC*XX
         XX1  = SQRT(HLA1**2+HLB1**2)
         PHI_COMB  = 0.0
         COS_COMB = 1.0
         SIN_COMB = 0.0
         IF(XX1.GT.0.0) THEN
           COS_COMB = HLA1/XX1
           SIN_COMB = HLB1/XX1
         ENDIF
         CALL PH_PROB_RICE(ICENT,XX1,COS_COMB,SIN_COMB,COSAA,
     +                  SINAA,COS2A,SIN2A,APROB,XC)
         COSSQA = (1.0+COS2A)/2.0
         SINSQA = (1.0-COS2A)/2.0
         SINCOSA = SIN2A/2.0
         IF(ICENT.EQ.0) THEN
           APROB = APROB*(2.0)
         ELSE
           APROB = 2.0*APROB/SQRT(PI)
        ENDIF
      ELSE
C---------------------------------------
C
C---Some phase distribution. All HLA HLB,HLC,HLD are non zero
C-----------------------------------------------------------------
C
         HLA1 = HLA + COSC*XX
         HLB1 = HLB + SINC*XX
         CALL PHASE_PROB(ICENT,HLA1,HLB1,HLC,HLD,COSC,SINC,COSAA,
     +              SINAA,COS2A,SIN2A,APROB,XC)
         COSSQA = (1.0+COS2A)/2.0
         SINSQA = (1.0-COS2A)/2.0
         SINCOSA= SIN2A/2.0
         IF(ICENT.EQ.0) THEN
           APROB = APROB/PI
         ELSE
           APROB = APROB/SQRT(TWOPI)
         ENDIF
C-----------------------------------------------------------------
      ENDIF   
C
C----Value of functional
      FVALUE = (YO*YO+YC*YC)/SIGMA - (ALOG(APROB) + XC) + 
     +                  ALOG(SIGMA)/(REAL(ICENT)+1.0)
      IF(ICENT.EQ.0.AND.YO.GT.0.0) FVALUE = FVALUE - ALOG(YO)

      FOM = SQRT(COSAA*COSAA+SINAA*SINAA)
C
C--First and second derivatives
C-----------------------------------------------------------------
      DFDA = 2.0*(AC - YO*COSAA)/SIGMA
      DFDB = 2.0*(BC - YO*SINAA)/SIGMA
      DFDAA = 2.0/SIGMA - YOS2*(COSSQA -COSAA*COSAA)
      DFDBB = 2.0/SIGMA - YOS2*(SINSQA -SINAA*SINAA)
      DFDAB =  0.0      - YOS2*(SINCOSA-SINAA*COSAA)
cd        IF(DFDAA + DFDBB.LT.0.0) THEN
cd          DFDAA = 2.0/SIGMA
cd          DFDAB = 0.0
cd          DFDBB = 2.0/SIGMA
cd        ENDIF

      ELSE
        D2FDA = 2.0*AC
        D2FDB = 2.0*BC
        DFDAA = 2.0/SIGMA
        DFDBB = 2.0/SIGMA
        DFDAB = 0.0
      ENDIF
      RETURN
      END
C    
      SUBROUTINE DFUNCDSIGAB_ML(ICENT,SIGMA,YO,A_ALL,B_ALL,
     &     DFDS,D2FDS2,DFDAS,DFDBS)
      IMPLICIT NONE
C
      INTEGER ICENT
      REAL    SIGMA,YO,A_ALL,B_ALL,DFDS,D2FDS2,DFDAS,DFDBS
C
C---Consider case with no external phase info
C
C---Derivatives of functional w.r.t. sigma's
      INCLUDE 'const.fh'
C
C---Local common
      REAL COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
      COMMON /HKL_COMM/ COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
C
      REAL   XX,SIGMA2,SIGMA3,YC,YO2,YC2,YOC,COSCMA
      XX      = 2.0*YO*YC/SIGMA
      SIGMA2  = SIGMA*SIGMA
      SIGMA3  = SIGMA2*SIGMA
      YC      = SQRT(A_ALL*A_ALL + B_ALL*B_ALL)
cd      COSC    = 0.0
cd      SINC    = 0.0
cd      IF(YC.GT.EPS_LOC) THEN
cd        COSC    = A_ALL/YC
cd        SINC    = B_ALL/BC
cd      ENDIF
      YO2     = YO*YO
      YC2     = YC*YC
      YOC     = YO*YC
      COSCMA  = COSC*COSAA+SINC*SINAA
      IF(ICENT.EQ.0) THEN
C
C----acentric case
        DFDS = 1.0/SIGMA -
     +           (YO2+YC2-2.0*YO*YC*COSCMA)/SIGMA2
        D2FDS2=
     +       -1.0/SIGMA2+
     +     2.0*(YO2+YC2-2.0*YO*YC*COSCMA)/SIGMA3
        DFDAS = -2.0*(YC*COSC-YO*COSAA)/SIGMA2+
     +          XX**2*(COSC*COSC*((1.0+COS2A)/2.0-COSAA*COSAA)+
     +                COSC*SINC*(SIN2A/2.0-SINAA*COSAA))/SIGMA
        DFDBS = -2.0*(YC*SINC-YO*SINAA)/SIGMA2+
     +          XX**2*(SINC*SINC*((1.0-COS2A)/2.0-SINAA*SINAA)+
     +                COSC*SINC*(SIN2A/2.0-SINAA*COSAA))/SIGMA
      ELSE
C
C---Centric case
        DFDS   =  1.0/SIGMA  - 2.0*(YO2+YC2-2.0*YOC*COSCMA)/SIGMA2
        D2FDS2 = -2.0/SIGMA2 + 8.0*(YO2+YC2-2.0*YO*YC*COSCMA)/SIGMA3
        DFDAS = -4.0*(YC*COSC-YO*COSAA)/SIGMA2
     +          +2.0*XX**2*(COSC*COSC*((1.0+COS2A)/2.0-COSAA*COSAA)+
     +                COSC*SINC*(SIN2A/2.0-SINAA*COSAA))/SIGMA
        DFDBS = -4.0*(YC*SINC-YO*SINAA)/SIGMA2
     +          +2.0*XX**2*(SINC*SINC*((1.0-COS2A)/2.0-SINAA*SINAA)+
     +                COSC*SINC*(SIN2A/2.0-SINAA*COSAA))/SIGMA
      ENDIF
C
C---Other type of functionals (for example likelihood with phases)
C---could be added here

      RETURN
      END

      SUBROUTINE EXTRACT_ABS(IR,ndens,FC,PHASE,A_CALCS,B_CALCS)
      use agreem
C
C---Sum partial structures to get summed ones. Assuming all 
C---parameters are involved as gaussians
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
C
      INTEGER IR,ndens
      REAL A_CALCS(*),B_CALCS(*)
      REAL FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
C
      INTEGER IP,IPOS
C
      DO    IP = 1,NPART+1
        IPOS   = IR+(IP-1)*NOBS
        A_CALCS(IP) = FC(IPOS,1)*COS(PHASE(IPOS,1))
        B_CALCS(IP) = FC(IPOS,1)*SIN(PHASE(IPOS,1))
      ENDDO
      RETURN
      END
C
C
      SUBROUTINE CALC_SIGM(NREF,ndens,hkl_asym,FO,SIGO,H_A,H_B,fwt,
     &     FC,PHASE,FREER,ncycs)
      use weights
      use agreem
      use rharvest
      IMPLICIT NONE
C
C---makes calls to calculate required sigmas for cov matrix for given target using PPI
      include 'atom_com.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'anom.fh'
C
      INTEGER NREF,ndens,ncycs
      INTEGER hkl_asym(3,*)
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      REAL H_A(*),H_B(*)
      real fwt(*)
C
      INTEGER I,J,IREF,ICENT,ISYSAB,IHH(3),ih
      REAL YOS,YC_ALL,PHI_ALL,SIGOS,WT1,DY,STL_C,EPSI,RSQ,FOM
      real FOPL,FOMI,SIGOP,SIGOM
      EXTERNAL INDTORS,CENTR,EPSLON
      real shifts(nmaxpart+2,maxbin) ,resol, sumfhsq, f_now, stol2
      real RHO,COV,VARO,VARC,VAROD,A_ALL,B_ALL,YO2,YC2,YO2D,expRB
      real EC2(MAXBIN), EO2(MAXBIN), EC4(MAXBIN), EO4(MAXBIN),
     &     EO2C2(MAXBIN), A_CALCS(NMAXPART), B_CALCS(NMAXPART),
     &     EO2DO2(MAXBIN), EO2D(MAXBIN), EO4D(MAXBIN)
      integer IR,IB,NREF_IN_BIN(MAXBIN),num_bin,wavepos,wavepos2,dimen
      character signp_exper*3
c
      call return_mat_dim(dimen)
      if (DPPI_sad.or.DPPI_sadh.or.DPPI_mad) then
        signp_exper = 'sad'
      else if (DPPI_sir.or.DPPI_mldr.or.DPPI_sras.or.DPPI_pl) then
        signp_exper = 'sir'
      else if (DPPI_hldm) then
        signp_exper = ''
      else
        CALL ERRWRT(1,'The requested ref. target is not supported')
      endif
      if(DPPI_sad.or.DPPI_sadh.or.DPPI_sir.or.DPPI_mldr
     +  .or.DPPI_mad.or.DPPI_sras.or.DPPI_pl.or.DPPI_hldm)
     +  then
         call SADSIR_CALC_SIGNP(NREF,ndens,hkl_asym,FO,SIGO,
     +     FO(dataset_order(1)*NOBS+1),SIGO(dataset_order(1)*NOBS+1),
     +     FO(dataset_order(2)*NOBS+1),SIGO(dataset_order(2)*NOBS+1),
     +     H_A,H_B,FC,PHASE,FREER,SHIFTS,signp_exper,ncycs)
          wavepos = dataset_wavenum(dataset_order(2))
            if ((sigN_calc.eq.0.or.sigP_calc.eq.0).and..not.DPPI_sras) 
     +      call CALC_SIGP2(wavepos,wavepos)
            if (DPPI_sras.and.DPPI_wsad_hack) then
              wavepos2 = 2
              call CALC_SIGP2(wavepos2,wavepos2)
            endif
      endif
      if (DPPI_sad.or.DPPI_sadh.or.DPPI_pl.or.DPPI_sir.or.DPPI_hldm)then
        do    IB=1,NBIN_ML+1
          sigm_N(IB,1) = SIGN2(IB)
          sigm_P(IB,1) = SIGP2(IB,2)
          sigm_N(IB,2) = SIGN2P(IB)
          sigm_P(IB,2) = SIGP2P(IB)
          sigm_N(IB,3) = 1.0
          sigm_P(IB,3) = 0.0
          if (dm_flag) sigm_P(IB,3) = SIGP2(IB,3)
        enddo
      endif
      if (DPPI_sras) then
        do    IB=1,NBIN_ML+1
          sigm_N(IB,1) = SIGN2(IB)
          sigm_P(IB,1) = SIGP2(IB,2)
        enddo
        signp_exper='sad'
        call SADSIR_CALC_SIGNP(NREF,ndens,hkl_asym,FO,SIGO,
     +     FO(dataset_order(2)*NOBS+1),SIGO(dataset_order(2)*NOBS+1),
     +     FO(dataset_order(3)*NOBS+1),SIGO(dataset_order(3)*NOBS+1),
     +     H_A(NOBS+1),H_B(NOBS+1),FC,PHASE,FREER,SHIFTS,
     +	   signp_exper,ncycs)
          if (sigN_calc.eq.0.or.sigP_calc.eq.0) 
     +      call CALC_SIGP2(wavepos,wavepos)
        do    IB=1,NBIN_ML+1
          sigm_N(IB,2) = SIGN2(IB)
          sigm_P(IB,2) = SIGP2(IB,2)
          sigm_N(IB,3) = SIGN2P(IB)
          sigm_P(IB,3) = SIGP2P(IB)
          sigm_N(IB,4) = 1.0
          sigm_P(IB,4) = 0.0
          if (dm_flag) sigm_P(IB,4) = SIGP2(IB,3)
c to take care of siras rice
          if (dm_flag.and.sigm_P(IB,4).le.0.) sigm_P(IB,4)=sigp(ib)
        enddo
      endif
      if (DPPI_mad) then
        do    IB=1,NBIN_ML+1
          sigm_N(IB,1) = SIGN2(IB)
          sigm_P(IB,1) = SIGP2(IB,2)
          sigm_N(IB,2) = SIGN2P(IB)
          sigm_P(IB,2) = SIGP2P(IB)
        enddo
        call SADSIR_CALC_SIGNP(NREF,ndens,hkl_asym,FO,SIGO,
     +     FO(dataset_order(3)*NOBS+1),SIGO(dataset_order(3)*NOBS+1),
     +     FO(dataset_order(4)*NOBS+1),SIGO(dataset_order(4)*NOBS+1),
     +     H_A(NOBS+1),H_B(NOBS+1),FC,PHASE,FREER,SHIFTS,
     +	   signp_exper,ncycs)
        wavepos2 = dataset_wavenum(dataset_order(4))
        if (sigN_calc.eq.0.or.sigP_calc.eq.0) 
     +     call CALC_SIGP2(wavepos2,wavepos2)
        do    IB=1,NBIN_ML+1
          sigm_N(IB,3) = SIGN2(IB)
          sigm_P(IB,3) = SIGP2(IB,2)
          sigm_N(IB,4) = SIGN2P(IB)
          sigm_P(IB,4) = SIGP2P(IB)
        enddo
        signp_exper = 'mad'
        call SADSIR_CALC_SIGNP(NREF,ndens,hkl_asym,FO,SIGO,
     +    FO(dataset_order(1)*NOBS+1),SIGO(dataset_order(1)*NOBS+1),
     +    FO(dataset_order(2)*NOBS+1),SIGO(dataset_order(2)*NOBS+1),
     +    H_A,H_B,FC,PHASE,FREER,SHIFTS,signp_exper,ncycs)
        if (sigN_calc.eq.0.or.sigP_calc.eq.0) then
          do    IB=1,NBIN_ML+1
            if (sigN_calc.eq.0)   sigN2(ib) =
     +       (sigm_N(IB,1)+sigm_N(IB,2)+sigm_N(IB,3)+sigm_N(IB,4))/4
c     +       (sigm_N(IB,3)+sigm_N(IB,4))/2
            if (sigP_calc.eq.0)   sigP2(ib,2) =
     +       (sigm_P(IB,1)+sigm_P(IB,2)+sigm_P(IB,3)+sigm_P(IB,4))/4
c     +        min((sigm_P(IB,1)+sigm_P(IB,2))/2,
c     +            (sigm_P(IB,3)+sigm_P(IB,4))/2)
          enddo
          call CALC_SIGP2(wavepos,wavepos2)
        endif
c! this needs to be figured out for MAD
        do    IB=1,NBIN_ML+1
          sigm_N(IB,5) = SIGN2(IB)
          sigm_P(IB,5) = SIGP2(IB,2)-0.001*(SIGP2(IB,2)-SIGP2P(IB))
c          sigm_P(IB,5) = SIGP2(IB,2)
          sigm_N(IB,6) = SIGN2P(IB)
          sigm_P(IB,6) = SIGP2P(IB)
c          write(*,*) IB,sigm_N(IB,1),sigm_P(IB,1)
c          write(*,*) IB,sigm_N(IB,2),sigm_P(IB,2)
c          write(*,*) IB,sigm_N(IB,3),sigm_P(IB,3)
c          write(*,*) IB,sigm_N(IB,4),sigm_P(IB,4)
c          write(*,*) IB,sigm_N(IB,5),sigm_P(IB,5)
c          write(*,*) IB,sigm_N(IB,6),sigm_P(IB,6)
        enddo
      endif
C
      RETURN
      END
c
c
      SUBROUTINE DMLINIT_R(NREF,ndens,hkl_asym,FO,SIGO,H_A,H_B,fwt,
     &     FC,PHASE,FREER)
      use weights
      use agreem
      use rharvest
      IMPLICIT NONE
C
C---Find initial values for maximum likelihood refinement
      include 'atom_com.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'anom.fh'
C
      INTEGER NREF,ndens
      INTEGER hkl_asym(3,*)
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      REAL H_A(*),H_B(*)
      real fwt(*)
C
      INTEGER I,J,IREF,ICENT,ISYSAB,IHH(3),ih
      REAL YOS,YC_ALL,PHI_ALL,SIGOS,WT1,DY,STL_C,EPSI,RSQ,FOM
      real FOPL,FOMI,SIGOP,SIGOM
      EXTERNAL INDTORS,CENTR,EPSLON
      real shifts(nmaxpart+2,maxbin) ,resol, sumfhsq, f_now, stol2
      real RHO,COV,VARO,VARC,VAROD,A_ALL,B_ALL,YO2,YC2,YO2D,expRB,rat
      real EC2(MAXBIN), EO2(MAXBIN), EC4(MAXBIN), EO4(MAXBIN),
     &     EO2C2(MAXBIN), A_CALCS(NMAXPART), B_CALCS(NMAXPART),
     &     EO2DO2(MAXBIN), EO2D(MAXBIN), EO4D(MAXBIN),
     &     a_extra,b_extra
      integer IR,IB,NUM,NREF_IN_BIN(MAXBIN),num_bin,wavepos,wavepos2
      integer dimen,Dnum,ok
      character signp_exper*3
c
      MAX_SC_ML = 1000.
      MIN_SC_ML = 0.001
C
      call return_mat_dim(dimen)
      if (.not.dppi_no) call return_Dnum(Dnum)
      DO   I=1,NBIN_ML
        NREF_ML(I)     = 0
        SIGMA_ML(I)    = 1.0
        DO   J=1,NPART+1
          SCALE_ML(I,J)  = 1.0
        ENDDO
      ENDDO
c
      if (.not.DPPI_no) then
        if (read_luzzd_flag) then
          write(*,*) 'Reading Luzzati parameters from dluzz file.'
          call read_luzzd(scale_ml,Dnum,nbin_ml,MAXBIN+1,NMAXP1+1,ok)
          if (ok.eq.1) then
            goto 666
          else
            SCALE_ML(1:NBIN_ML,1:NPART+1)  = 1.0
            call errwrt(0,'Problem reading luzzd file - D''s will be '//
     &        'estimated')
            read_luzzd_flag=.false.
          endif
        endif
      DO    IB=1,NBIN_ML
        EO2(ib) = 0
        EC2(ib) = 0
        EO4(ib) = 0
        EC4(ib) = 0
        EO2C2(ib) = 0
        EO2D(ib) = 0
        EO4D(ib) = 0
        EO2DO2(ib) = 0
        NREF_IN_BIN(IB) = 0
c        sigP2P(ib) = sigP2(ib,2) + DSIGP2(Ib)
c        sigN2P(ib) = sigN2(ib) + DSIGP2(Ib)
      ENDDO
      rat=1.
      DO    IR=1,NREF
          CALL INDTORS(hkl_asym(1:3,IR),RSQ)
          RHO = SQRT(RSQ)
          ihh(1:3) = hkl_asym(1:3,ir)
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)
          WT1 = 2.0-FLOAT(ICENT)
          if (.not.DPPI_hldm) then
           FOPL = FO(dataset_order(1)*NOBS+IR)
           SIGOP = SIGO(dataset_order(1)*NOBS+IR)
           FOMI = FO(dataset_order(2)*NOBS+IR)
           SIGOM = SIGO(dataset_order(2)*NOBS+IR)
          endif
c          YOP2 = WT1/EPSI*(FOPL(IR)*FOPL(IR) + FOMI(IR)*FOMI(IR))/2
c          YOPM = WT1*FOPL(IR)*FOMI(IR)/EPSI
          DO    ib=1,NBIN_ML        
            IF(RHO.LE.SMAXB_ML(ib).AND.RHO.GE.SMINB_ML(ib)) THEN
c      write(*,*)SIGN(IB),SIGN2P(IB),sigm_N(IB,2)
              YO2 = WT1*FO(IR)*FO(IR)/EPSI 
              if (SIGN(IB).ne.0.) YO2 = YO2/SIGN(IB)
              if (DPPI_sir.or.DPPI_mldr.or.DPPI_pl)  then
                YO2D = WT1*FOMI*FOMI/EPSI 
                if (SIGN2P(IB).ne.0.) YO2D = YO2D/SIGN2P(IB)
              elseif (DPPI_sras) then
                YO2D = WT1*FOMI*FOMI/EPSI 
                if (SIGm_N(IB,2).ne.0.) YO2D = YO2D/SIGm_N(IB,2)
              endif
       		  CALL EXTRACT_ABS(IR,ndens,FC,PHASE,A_CALCS,B_CALCS)
      		  A_ALL = 0.0
      		  B_ALL = 0.0
      		  DO   I=1,NPART+1
        	    A_ALL = A_ALL + A_CALCS(I)
        	    B_ALL = B_ALL + B_CALCS(I)
              ENDDO
       		  YC2 = WT1*(A_ALL**2 + B_ALL**2)/EPSI 
       		  if (dm_flag) then
                a_extra=fc(ir,ndens)*cos(phase(ir,ndens))
                b_extra=fc(ir,ndens)*sin(phase(ir,ndens))
                YC2 = WT1*(A_extra**2 + B_extra**2)/EPSI 
              endif
       		  if (SIGP(IB).ne.0.) YC2 = YC2/SIGP(IB)
       		  if ((DPPI_sras.or.DPPI_sir).and.substruct_flag)  then
        		YC2 = WT1*(H_A(ir)**2 + H_B(ir)**2)/EPSI 
                if (SIGM_P(IB,2).ne.0.) YC2 = YC2/SIGM_P(IB,2)
              endif
              NREF_IN_BIN(ib) = NREF_IN_BIN(ib) +2-ICENT
              EO2(ib) = EO2(ib) + YO2
              EC2(ib) = EC2(ib) + YC2
              EO4(ib) = EO4(ib) + YO2*YO2
              EC4(ib) = EC4(ib) + YC2*YC2
              EO2C2(ib) = EO2C2(ib) + YO2*YC2
              if (DPPI_sir.or.DPPI_mldr.or.DPPI_sras.or.DPPI_pl) then
                EO2D(ib) = EO2D(ib) + YO2D
            	EO4D(ib) = EO4D(ib) + YO2D*YO2D
            	EO2DO2(ib) = EO2DO2(ib) + YO2D*YO2
              endif
            ENDIF
          ENDDO
      ENDDO
      DO    IB=1,NBIN_ML
        NUM = NREF_IN_BIN(IB)
        COV = ( EO2C2(IB) - EO2(IB)*EC2(IB)/NUM )/NUM
        VARO = ( EO4(IB) - EO2(IB)*EO2(IB)/NUM )/NUM
        VARC = ( EC4(IB) - EC2(IB)*EC2(IB)/NUM )/NUM
c      write(*,*) COV,VARO,VAROD,'   ',EO2DO2(IB),EO2D(IB),EO2(IB)
        if (sigp(ib).ne.0) rat = SIGN(IB)/SIGP(IB)
c      write(*,*)'debug',ib,SIGM_N(IB,1),SIGM_P(IB,1)
c        if ((DPPI_sras.or.DPPI_sir).and.SIGM_P(IB,2).ne.0
c     &    .and.substruct_flag) rat = SIGM_N(IB,2)/SIGM_P(IB,2)
        if (COV.gt.0) then
          SCALE_ML(IB,2)= sqrt(COV/sqrt(VARC*VARO))
          if ( (.not.DPPI_sras.and..not.DPPI_sir)
     &      .or..not.substruct_flag.or.dm_flag ) then
c            if(.not.substruct_flag.or.dm_model_flag) then
            if(.not.substruct_flag) then
              SCALE_ML(IB,2)=SCALE_ML(IB,2)*sqrt(rat)
            else
              SCALE_ML(IB,2)=SCALE_ML(IB,2)*sqrt(rat*.1) 
            endif
          endif
        else
          SCALE_ML(IB,2) = 0.01
        endif
        if (DPPI_sad) then 
          SCALE_ML(IB,1)  = SCALE_ML(IB,2)
        else if (DPPI_sadh.or.DPPI_hldm) then 
          SCALE_ML(IB,1)  = 1.
          if (substruct_flag.and..not.DPPI_hldm) SCALE_ML(IB,1)  = .1
          SCALE_ML(IB,3)  = 1.
          if (dimen.gt.4.or.dppi_hldm) SCALE_ML(IB,3)  = SCALE_ML(IB,2)
          SCALE_ML(IB,4)  = 1.
          if (dimen.gt.4.or.dppi_hldm) SCALE_ML(IB,4)  = .02
          SCALE_ML(IB,5)  = 1.
c      SCALE_ML(IB,5)  = SCALE_ML(IB,2)
c      SCALE_ML(IB,5)  = 5.
c          if (substruct_flag.and.dimen.gt.4) SCALE_ML(IB,5)  = 1.
          SCALE_ML(IB,6)  = 1.
          if (dppi_hldm) SCALE_ML(IB,6)  = SCALE_ML(IB,2)/2
          if (dppi_hldm) SCALE_ML(IB,2)  = SCALE_ML(IB,2)*2
        if (dimen.gt.4) SCALE_ML(IB,6)  = SCALE_ML(IB,2)
        else if (DPPI_sir.or.DPPI_mldr.or.DPPI_sras.or.DPPI_pl) then 
      	  COV = ( EO2DO2(IB) - EO2D(IB)*EO2(IB)/NUM )/NUM
      	  VARO = ( EO4D(IB) - EO2D(IB)*EO2D(IB)/NUM )/NUM
      	  VAROD = ( EO4(IB) - EO2(IB)*EO2(IB)/NUM )/NUM
      	  if (COV.gt.0) then
        	SCALE_ML(IB,1)= sqrt(COV/sqrt(VAROD*VARO)) 
      	  else
        	SCALE_ML(IB,1) = 0.01
      	  endif
        endif
        if (DPPI_sras) then 
          SCALE_ML(IB,3) = SCALE_ML(IB,1)*SCALE_ML(IB,2)
          SCALE_ML(IB,4) = SCALE_ML(IB,2)
          if (Dnum.gt.3) then
            SCALE_ML(IB,3) = SCALE_ML(IB,1)
            SCALE_ML(IB,4) = 1.
            if (substruct_flag) SCALE_ML(IB,4) = SCALE_ML(IB,2)
            SCALE_ML(IB,5) = SCALE_ML(IB,1)*SCALE_ML(IB,2)
            if (substruct_flag) SCALE_ML(IB,5) = 1.
            SCALE_ML(IB,6) = 1.
            if (Dnum.gt.6) SCALE_ML(IB,6)  = .02
            SCALE_ML(IB,7) = SCALE_ML(IB,2)
            SCALE_ML(IB,1) = 1.
            if (substruct_flag) SCALE_ML(IB,1) = .1
          endif
        endif
        if (DPPI_sir) then 
          SCALE_ML(IB,3) = SCALE_ML(IB,1)
          SCALE_ML(IB,4) = SCALE_ML(IB,2)
          SCALE_ML(IB,5) = SCALE_ML(IB,2)
          SCALE_ML(IB,1) = 1.
          if (substruct_flag) SCALE_ML(IB,1) = .1
        endif
        if (DPPI_pl) then
          SCALE_ML(IB,3)  = 1.
          if (dimen.eq.4) SCALE_ML(IB,4)  = 1.
        endif
      ENDDO
  666 continue
      DO    IB=1,NBIN_ML
        if (verbref_5N) 
     +   write(6,*) 'initial D params: ', SCALE_ML(IB,1:Dnum)
      ENDDO

      endif
C
C--If stage of refinement is early then sigma refinement is best done in bins
C
c      IF(FREER_FLAG.AND.RFACTOR_FREE.GE.0.50) THEN
c         SIGMA_REFINE_STYLE = 'BINS'
c      ELSE IF(RFACTOR_WORK.GE.0.50) THEN
c         SIGMA_REFINE_STYLE = 'BINS'
c      ENDIF
c      if (.not.DPPI_no)  SIGMA_REFINE_STYLE = 'BINS'

      RETURN
      END
C
c
      SUBROUTINE DMLINIT_R1(NREF,ndens,hkl_asym,FO,SIGO,fwt,
     &     FC,PHASE,FREER)
      use weights
      use agreem
      IMPLICIT NONE
C
C---Find initial values for maximum likelihood refinement.
      INCLUDE 'refi_flags.fh'
C
      INTEGER NREF,ndens
      INTEGER hkl_asym(3,*)
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      real fwt(*)
C
      integer iwei
      INTEGER I,IREF,ICENT,ISYSAB,IBIN,IHH(3),NC,IBIN_S
      REAL WT1,STL_C,EPSI,RSQ,XX,FOM
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART),Y_C,A_ALL,B_ALL
      REAL SIGMA_ML0(MAXBIN)
      LOGICAL FREERCHK
      REAL SIM
      EXTERNAL SIM
      EXTERNAL INDTORS,CENTR,EPSLON
C
      NC  = 0
 1    CONTINUE
      DO   I=1,NBIN_ML
        NREF_ML(I) = 0
        SIGMA_ML0(I) = 0.0
      ENDDO

      IBIN_S = 1
      DO     IREF = 1,NREF
         iwei = nint(fwt(iref))
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN 
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND. 
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0
     &       .and.fwt(iref).gt.0.0) THEN
            CALL INDTORS(hkl_asym(1:3,IREF),RSQ)
            ihh(1:3) = hkl_asym(1:3,iref)
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            WT1   = 2.0-REAL(ICENT)
            STL_C = SQRT(RSQ)
            IF(.NOT.(STL_C.GT.SMINB_ML(IBIN_S).AND.
     &               STL_C.LE.SMAXB_ML(IBIN_S))) THEN
              DO   IBIN=1,NBIN_ML
                IF(STL_C.GT.SMINB_ML(IBIN).AND.STL_C.LE.SMAXB_ML(IBIN)) 
     &                                           THEN
                  IBIN_S = IBIN
                  GOTO 50
                ENDIF
              ENDDO
              GOTO 100
            ENDIF
 50         CONTINUE
            CALL EXTRACT_ABS(IREF,ndens,FC,PHASE,A_CALCS,B_CALCS)
            A_ALL = 0.0
            B_ALL = 0.0
            DO   I=1,NPART+1
              A_ALL = A_ALL + A_CALCS(I)*SCALE_ML(IBIN_S,I)
              B_ALL = B_ALL + B_CALCS(I)*SCALE_ML(IBIN_S,I)
            ENDDO
            Y_C = SQRT(A_ALL**2 + B_ALL**2)
            XX  = FO(IREF)*Y_C/(EPSI*SIGMA_ML(IBIN_S))
            IF(ICENT.EQ.0) THEN
              FOM = SIM(2.0*XX)
            ELSE
              FOM = TANH(XX)
            ENDIF
            NREF_ML(IBIN_S) = NREF_ML(IBIN_S) + 
     &           iwei*(2-ICENT)
            SIGMA_ML0(IBIN_S) = SIGMA_ML0(IBIN_S) + 
     &           iwei*WT1*(FO(IREF)**2+Y_C**2- 
     &                          2.0*FOM*FO(IREF)*Y_C)/EPSI
        ENDIF
 100    CONTINUE
      ENDDO
      DO   I=1,NBIN_ML
        IF(NREF_ML(I).GT.0) THEN
          SIGMA_ML(I) = AMAX1(SIGMA_ML0(I)/FLOAT(NREF_ML(I)),1.0)
        ELSE
          CALL ERRWRT(1,'No reflections in resolution bin ???????')
        ENDIF
      ENDDO
      NC = NC + 1
      IF(NC.LT.20) GOTO 1
C
      RETURN
      END
C
      SUBROUTINE DMLINIT_R2(NREF,ndens,hkl_asym,FO,SIGO,fwt,
     &     FC,PHASE,FREER)
      use weights
      use agreem
      IMPLICIT NONE
C
C---Find initial values for maximum likelihood refinement.
      INCLUDE 'refi_flags.fh'
C
      INTEGER NREF,ndens
      INTEGER hkl_asym(1:3,*)
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      real fwt(*)
C
      INTEGER I,IREF,ICENT,ISYSAB,IBIN,IHH(3),NC,IBIN_S
      REAL WT1,STL_C,EPSI,RSQ,XX,FOM
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART),Y_C,A_ALL,B_ALL
      REAL SIGMA_ML0(MAXBIN)
      LOGICAL FREERCHK
      REAL SIM
      EXTERNAL SIM
      EXTERNAL INDTORS,CENTR,EPSLON
C
      NC  = 0
 1    CONTINUE
      DO   I=1,NBIN_ML
        NREF_ML(I) = 0
        SIGMA_ML0(I) = 0.0
        SIGMA_ML1(I) = 0.0
      ENDDO
 
      IBIN_S = 1
      DO     IREF = 1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0
     &       .and.fwt(iref).gt.0.0) THEN
            CALL INDTORS(hkl_asym(1:3,IREF),RSQ)
            ihh(1:3) = hkl_asym(1:3,iref)
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            WT1   = 2.0-REAL(ICENT)
            STL_C = SQRT(RSQ)
            IF(.NOT.(STL_C.GT.SMINB_ML(IBIN_S).AND.
     &               STL_C.LE.SMAXB_ML(IBIN_S))) THEN
              DO   IBIN=1,NBIN_ML
                IF(STL_C.GT.SMINB_ML(IBIN).AND.STL_C.LE.SMAXB_ML(IBIN))
     &                                           THEN
                  IBIN_S = IBIN
                  GOTO 50
                ENDIF
              ENDDO
              GOTO 100
            ENDIF
 50         CONTINUE
            CALL EXTRACT_ABS(IREF,ndens,FC,PHASE,A_CALCS,B_CALCS)
            A_ALL = 0.0
            B_ALL = 0.0
            DO   I=1,NPART+1
              A_ALL = A_ALL + A_CALCS(I)*SCALE_ML(IBIN_S,I)
              B_ALL = B_ALL + B_CALCS(I)*SCALE_ML(IBIN_S,I)
            ENDDO
            Y_C = SQRT(A_ALL**2 + B_ALL**2)
            XX  = FO(IREF)*Y_C/(EPSI*SIGMA_ML(IBIN_S))
            IF(ICENT.EQ.0) THEN
              FOM = SIM(2.0*XX)
            ELSE
              FOM = TANH(XX)
            ENDIF
            NREF_ML(IBIN_S) = NREF_ML(IBIN_S) + 
     &           nint(fwt(iref))*(2-ICENT)
            SIGMA_ML0(IBIN_S) = SIGMA_ML0(IBIN_S) +
     &        fwt(iref)*WT1*(FO(IREF)**2+Y_C**2- 
     &                       2.0*FOM*FO(IREF)*Y_C)/EPSI
            SIGMA_ML1(IBIN_S) = SIGMA_ML1(IBIN_S)+
     &           fwt(iref)*WT1*(FOM*FO(IREF)-Y_C)**2/EPSI
        ENDIF
 100    CONTINUE
      ENDDO
      DO   I=1,NBIN_ML
        IF(NREF_ML(I).GT.0) THEN
          SIGMA_ML(I)  = SIGMA_ML0(I)/REAL(NREF_ML(I))
          SIGMA_ML1(I) = SIGMA_ML1(I)/REAL(NREF_ML(I))
        ELSE
          CALL ERRWRT(1,'No reflections in resolution bin ???????')
        ENDIF
      ENDDO
      NC = NC + 1
      IF(NC.LT.10) GOTO 1
C
      RETURN
      END
C
      SUBROUTINE PH_PROB_RICE(ICENT,XX,COSC,SINC,COSAA,SINAA,
     +            COS2A,SIN2A,APROB,XC)
C
C---Calculate expected values of cosphi and sinphi assuming that 
C---distribution is Rice distribution
      INCLUDE 'const.fh'

      REAL SIM
      EXTERNAL SIM
C
      IF(ICENT.EQ.0) THEN
        FOM = SIM(XX)
      ELSE
        FOM = TANH(XX)
      ENDIF
      COSAA = COSC*FOM
      SINAA = SINC*FOM
      IF(ICENT.EQ.0) THEN
        IF(ABS(XX).GT.0.0) THEN
          CALL BESSI0(XX,APROB,XC)
          COS2A = (1.0 - 2.0*FOM/XX)*(COSC*COSC-SINC*SINC)
          SIN2A = (1.0 - 2.0*FOM/XX)*2.0*COSC*SINC
        ELSE
          XC    = 0.0
          COS2A = 0.0
          SIN2A = 0.0
        ENDIF
      ELSE
        IF(XX.LT.30.0) THEN
           APROB = COSH(XX)
           XC    = 0.0
        ELSE
           APROB = 1.0/2.0
           XC    = XX 
        ENDIF
        COS2A = COSC*COSC - SINC*SINC
        SIN2A = 2.0*SINC*COSC
      ENDIF

      RETURN
      END
C
      SUBROUTINE PH_PROB_RICE_0(ICENT,XX,APROB,XC)
C
C---Calculate expected values of cosphi and sinphi assuming that 
C---distribution is Rice distribution
      INCLUDE 'const.fh'

      REAL SIM
      EXTERNAL SIM
C
      IF(ICENT.EQ.0) THEN
        IF(ABS(XX).GT.0.0) THEN
          CALL BESSI0(XX,APROB,XC)
        ELSE
          XC    = 0.0
          APROB = 1.0
        ENDIF
      ELSE
        IF(XX.LT.60.0) THEN
           APROB = COSH(XX)
           XC    = 0.0
        ELSE
           APROB = 1.0/2.0
           XC    = XX 
        ENDIF
      ENDIF

      RETURN
      END
C
      SUBROUTINE PHASE_PROB(ICENT,HLA,HLB,HLC,HLD,COSC,SINC,COSAA,
     +             SINAA,COS2A,SIN2A,ANORM,XC)
C
      REAL HLA,HLB,HLC,HLD
C
      IF(ICENT.EQ.0) THEN
        CALL PHPROB(HLA,HLB,HLC,HLD,COSAA,SINAA,COS2A,SIN2A,ANORM,XC)
      ELSE
        CALL PHPROB_CENTR(HLA,HLB,COSAA,SINAA,ANORM,XC)
        COS2A = 2.0*COSC*COSC - 1.0
        SIN2A = 2.0*COSC*SINC 
      ENDIF
      RETURN
      END
C
      SUBROUTINE PHASE_PROB_0(ICENT,HLA,HLB,HLC,HLD,COSAA,SINAA)
C
C---Calculates weighted cos and sin from given HL A,B,C,D
      REAL HLA,HLB,HLC,HLD,COSAA,SINAA
C
      IF(ICENT.EQ.0) THEN
        CALL PHPROB_0(HLA,HLB,HLC,HLD,COSAA,SINAA)
      ELSE
        CALL PHPROB_CENTR_0(HLA,HLB,COSAA,SINAA)
      ENDIF
      RETURN
      END
C
      SUBROUTINE PHPROB(HLA,HLB,HLC,HLD,COSAA,SINAA,COS2A,SIN2A,
     +           ANORM,XC)
C
C----This subroutine calculates expected value of cos, sin, cos2, sin2
C----for acentric reflections
C----
C     Parameters 
C
C    HLA,HLB,HLC,HLD   - Hendrickson-Lattman coefficients of phase 
C                        probability distribution
C
C    COSA  = <COS(alpha)>
C    SINA  = <SIN(alpha)>
C    COS2A = <COS(2alpha)>
C    SIN2A = <SIN(2alpha)>
C
C    ANORM - normalisation coefficient of probability distribution
C
C    XC    - Value subtracted from exponentila to make it good behaved
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      REAL HLA,HLB,HLC,HLD
cd      DOUBLE PRECISION EXPARGD,COSAA1,SINAA1,COS2A1,SIN2A1,ANORM1
      REAL EXPARGD,COSAA1,SINAA1,COS2A1,SIN2A1,ANORM1

C
C---First find maximum value of argument. If it is larger than
C---largest possible value of argumenent then calculate correction 
C---to subtract from exponentional argument
      INTEGER I,IND
      REAL XC,ARGHI,HLC1,HLD1,COSP1,SINP1,COS2P1,SIN2P1,ARGC
      REAL ARG(NMAXTRIG)
      ARGHI = -1.0E32
      COSP1 = 1.0
      SINP1 = 0.0
      XX0   = SQRT(HLA*HLA + HLB*HLB)
      IF(XX0.GT.0.0) THEN
        COSP1 = HLA/XX0
        SINP1 = HLB/XX0
        COS2P1 = COSP1*COSP1 - SINP1*SINP1
        SIN2P1 = 2.0*COSP1*SINP1
      ENDIF
      HLC1 =  HLC*COS2P1 + HLD*SIN2P1
      HLD1 = -HLC*SIN2P1 + HLD*COS2P1
      DO     I=1,NMAXTRIG,NTRIGINC
        ARG(I) = XX0*COS1_TAB(I) +COS2_TAB(I)*HLC1 + 
     +                    SIN2_TAB(I)*HLD1
        IF(ARGHI.LE.ARG(I)) ARGHI = ARG(I)
      ENDDO
      XC = 0.0
      IF(ARGHI.GT.ARGMAX) XC = ARGHI - ARGMAX + 0.01
C
C---Calculate integrals
      COSAA1 = 0.0
      SINAA1 = 0.0
      COS2A1 = 0.0
      SIN2A1 = 0.0
      ANORM1 = 0.0
C
C---Calculate expected values of cos(alpha),sin(alpha),cos(2alpha),sin(2alpha)
C---and normalisation coefficients. 
      DO     I=1,NMAXTRIG,NTRIGINC
        ARGC = ARG(I)-XC
        IND = INT(ABS(ARGC)/ARGSTEP+1.5)
        IF(IND.LT.1) IND = 1
        IF(IND.GT.NMAXEXP+1) IND = NMAXEXP+1
        IF(ARGC.GE.0.0) THEN
           EXPARGD = ETAB(IND)
        ELSE IF(ARGC.LT.0.0.AND.ARGC.GT.-ARGMAX) THEN 
           EXPARGD = 1.0/ETAB(IND)
        ELSE 
          EXPARGD = 0.0
        ENDIF
        ANORM1  = ANORM1 + EXPARGD
        COSAA1  = COSAA1 + COS1_TAB(I)*EXPARGD
        SINAA1  = SINAA1 + SIN1_TAB(I)*EXPARGD
        COS2A1  = COS2A1 + COS2_TAB(I)*EXPARGD
        SIN2A1  = SIN2A1 + SIN2_TAB(I)*EXPARGD
      ENDDO
      COSAA  = (COSP1*COSAA1 - SINP1*SINAA1)/ANORM1
      SINAA  = (SINP1*COSAA1 + COSP1*SINAA1)/ANORM1
      COS2A  = (COS2P1*COS2A1 - SIN2P1*SIN2A1)/ANORM1
      SIN2A  = (SIN2P1*COS2A1 + COS2P1*SIN2A1)/ANORM1
      ANORM  = ANORM1/TWOPI*WIDTH
      RETURN
      END
C
      SUBROUTINE PHPROB_0(HLA,HLB,HLC,HLD,COSAA,SINAA)
C
C----This subroutine calculates expected value of cos, sin
C----
C     Parameters 
C
C    HLA,HLB,HLC,HLD   - Hendrickson-Lattman coefficients of phase 
C                        probability distribution
C
C    COSA  = <COS(alpha)>
C    SINA  = <SIN(alpha)>
C
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      REAL HLA,HLB,HLC,HLD
cd      DOUBLE PRECISION EXPARGD,COSAA1,SINAA1,COS2A1,SIN2A1,ANORM1
      REAL EXPARGD,COSAA1,SINAA1,ANORM1

C
C---First find maximum value of argument. If it is larger than
C---largest possible value of argumenent then calculate correction 
C---to subtract from exponentional argument
      INTEGER I,IND
      REAL XC,ARGHI,HLC1,HLD1,COSP1,SINP1,COS2P1,SIN2P1,ARGC
      REAL ARG(NMAXTRIG)
C
      ARGHI = -1.0E32
      COSP1 = 1.0
      SINP1 = 0.0
      XX0   = SQRT(HLA*HLA + HLB*HLB)
      IF(XX0.GT.0.0) THEN
        COSP1 = HLA/XX0
        SINP1 = HLB/XX0
        COS2P1 = COSP1*COSP1 - SINP1*SINP1
        SIN2P1 = 2.0*COSP1*SINP1
      ENDIF
      HLC1 =  HLC*COS2P1 + HLD*SIN2P1
      HLD1 = -HLC*SIN2P1 + HLD*COS2P1
      DO     I=1,NMAXTRIG,NTRIGINC
        ARG(I) = XX0*COS1_TAB(I) +COS2_TAB(I)*HLC1 + 
     +                    SIN2_TAB(I)*HLD1
        IF(ARGHI.LE.ARG(I)) ARGHI = ARG(I)
      ENDDO
      XC = 0.0
      IF(ARGHI.GT.ARGMAX) XC = ARGHI - ARGMAX + 0.01
C
C---Calculate integrals
      COSAA1 = 0.0
      SINAA1 = 0.0
      ANORM1 = 0.0
C
C---Calculate expected values of cos(alpha),sin(alpha)
C---and the normalisation coefficient. 
      DO     I=1,NMAXTRIG,NTRIGINC
        ARGC = ARG(I)-XC
        IND = INT(ABS(ARGC)/ARGSTEP+1.5)
        IF(IND.LT.1) IND = 1
        IF(IND.GT.NMAXEXP+1) IND = NMAXEXP+1
        IF(ARGC.GE.0.0) THEN
           EXPARGD = ETAB(IND)
        ELSE IF(ARGC.LT.0.0.AND.ARGC.GT.-ARGMAX) THEN 
           EXPARGD = 1.0/ETAB(IND)
        ELSE 
          EXPARGD = 0.0
        ENDIF
        ANORM1  = ANORM1 + EXPARGD
        COSAA1  = COSAA1 + COS1_TAB(I)*EXPARGD
        SINAA1  = SINAA1 + SIN1_TAB(I)*EXPARGD
      ENDDO
      COSAA  = (COSP1*COSAA1 - SINP1*SINAA1)/ANORM1
      SINAA  = (SINP1*COSAA1 + COSP1*SINAA1)/ANORM1
      RETURN
      END
C
      SUBROUTINE PHPROB_2(HLA,HLB,HLC,HLD,COSAA,SINAA,ANORM,XC)
C
C---same as phrpob_0 except it returns value of function also.
C
C----This subroutine calculates expected value of cos, sin
C----
C     Parameters
C
C    HLA,HLB,HLC,HLD   - Hendrickson-Lattman coefficients of phase
C                        probability distribution
C
C    COSA  = <COS(alpha)>
C    SINA  = <SIN(alpha)>
C
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      REAL HLA,HLB,HLC,HLD
cd      DOUBLE PRECISION EXPARGD,COSAA1,SINAA1,COS2A1,SIN2A1,ANORM1
      REAL EXPARGD,COSAA1,SINAA1,ANORM1

C
C---First find maximum value of argument. If it is larger than
C---largest possible value of argumenent then calculate correction
C---to subtract from exponentional argument
      INTEGER I,IND
      REAL XC,ARGHI,HLC1,HLD1,COSP1,SINP1,COS2P1,SIN2P1,ARGC
      REAL ARG(NMAXTRIG)
C
      ARGHI = -1.0E32
      COSP1 = 1.0
      SINP1 = 0.0
      XX0   = SQRT(HLA*HLA + HLB*HLB)
      IF(XX0.GT.0.0) THEN
        COSP1 = HLA/XX0
        SINP1 = HLB/XX0
        COS2P1 = COSP1*COSP1 - SINP1*SINP1
        SIN2P1 = 2.0*COSP1*SINP1
      ENDIF
      HLC1 =  HLC*COS2P1 + HLD*SIN2P1
      HLD1 = -HLC*SIN2P1 + HLD*COS2P1
      DO     I=1,NMAXTRIG,NTRIGINC
        ARG(I) = XX0*COS1_TAB(I) +COS2_TAB(I)*HLC1 +
     +                    SIN2_TAB(I)*HLD1
        IF(ARGHI.LE.ARG(I)) ARGHI = ARG(I)
      ENDDO
      XC = 0.0
      IF(ARGHI.GT.ARGMAX) XC = ARGHI - ARGMAX + 0.01
C
C---Calculate integrals
      COSAA1 = 0.0
      SINAA1 = 0.0
      ANORM1 = 0.0
C
C---Calculate expected values of cos(alpha),sin(alpha)
C---and the normalisation coefficient.
      DO     I=1,NMAXTRIG,NTRIGINC
        ARGC = ARG(I)-XC
        IND = INT(ABS(ARGC)/ARGSTEP+1.5)
        IF(IND.LT.1) IND = 1
        IF(IND.GT.NMAXEXP+1) IND = NMAXEXP+1
        IF(ARGC.GE.0.0) THEN
           EXPARGD = ETAB(IND)
        ELSE IF(ARGC.LT.0.0.AND.ARGC.GT.-ARGMAX) THEN
           EXPARGD = 1.0/ETAB(IND)
        ELSE
          EXPARGD = 0.0
        ENDIF
        ANORM1  = ANORM1 + EXPARGD
        COSAA1  = COSAA1 + COS1_TAB(I)*EXPARGD
        SINAA1  = SINAA1 + SIN1_TAB(I)*EXPARGD
      ENDDO
      COSAA  = (COSP1*COSAA1 - SINP1*SINAA1)/ANORM1
      SINAA  = (SINP1*COSAA1 + COSP1*SINAA1)/ANORM1
      ANORM  = ANORM1/TWOPI*WIDTH
      RETURN
      END
C

      SUBROUTINE PHPROB_CENTR(HLA,HLB,COSAA,SINAA,ANORM,XC)
C
C---Calculate expected values of cos(alpha),sin(alpha) for centric reflections
C---HLA and HLB  Hendrickson and Konnert coefficients
C---PH0  one of two possible values of centric phases
C---SINAA COSAA expected values of sina and cosa
      IMPLICIT NONE
      INCLUDE 'expcost.fh'
      REAL HLA,HLB,SINAA,COSAA,ANORM,XC
      REAL FOMM,XX
C
      XX    = SQRT(HLA**2+HLB**2)
      COSAA = 1.0
      SINAA = 0.0
      FOMM  = TANH(XX)
      IF(XX.GT.0.0) THEN
        COSAA = FOMM*HLA/XX
        SINAA = FOMM*HLB/XX
      ENDIF
      XC  = 0.0
      IF(XX.GT.30.0) THEN
         XC    = XX
         ANORM = 1.0/2.0
      ELSE
         XC    = 0.0
         ANORM = COSH(XX)
      ENDIF
      RETURN
      END
C
      SUBROUTINE PHPROB_CENTR_0(HLA,HLB,COSAA,SINAA)
C
C---Calculate expected values of cos(alpha),sin(alpha) for centric reflections
C---HLA and HLB  Hendrickson and Konnert coefficients
C---PH0  one of two possible values of centric phases
C---SINAA COSAA expected values of sina and cosa
      INCLUDE 'expcost.fh'
      REAL HLA,HLB
C
      XX    = SQRT(HLA**2+HLB**2)
      FOMM  = TANH(XX)
      COSAA = 1.0
      SINAA = 0.0
      IF(XX.GT.0.0) THEN
        COSAA = FOMM*HLA/XX
        SINAA = FOMM*HLB/XX
      ENDIF
      RETURN
      END
C
       SUBROUTINE APPLYSCALES(NREF,ndens,hkl_asym,IP1,NPART1,FO,SIGO,FC,
     &                        H_A,H_B)
       use agreem
C
C---Applies scale factors to amplitudes of structure factors
C---If IP1 = 0 then it will apply 1/scale(NPART1) to FO-s
C---If APPLY_SCALE_TO is equal to 'OBSE' then scale B-value of 
C---(NPART+1)-th partial structure will be applied to observed 
C---structure factors. Babinet's bulk solvent correction is not applied here.
C
      implicit none
c
      include 'atom_com.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'anom.fh'
C
      INTEGER hkl_asym(3,*),NREF,IP1,NPART1,ndens
      REAL FO(*),FC(nobs*(npart+1),ndens),SIGO(*),H_A(*),H_B(*)
      REAL S1,S2,S3,S11,S22,S33,S12,S13,S23,RSQ,SBS,EXPAN
      real sum_extra,sum_fc,sum_fo
      INTEGER IP,IREF,IPOS,IHH,IKK,ILL
C
      sum_extra=0.
      sum_fc=0.
      sum_fo=0.
       DO     IREF = 1,NREF
         CALL INDTORS(hkl_asym(1:3,IREF),RSQ)
         RSQ = RSQ/4.0
         ihh = hkl_asym(1,iref)
         ikk = hkl_asym(2,iref)
         ill = hkl_asym(3,iref)
         EXPAN = 1.0
         IF(B_LS_ANISO_OVER_FLAG) THEN
           S1 = FLOAT(IHH)*RCELL(1)
           S2 = FLOAT(IKK)*RCELL(2)
           S3 = FLOAT(ILL)*RCELL(3)
           S11 = S1*S1
           S22 = S2*S2
           S33 = S3*S3
           S12 = 2.0*S1*S2
           S13 = 2.0*S1*S3
           S23 = 2.0*S2*S3
           SBS = B_LS_ANISO_OVER(1)*S11 + B_LS_ANISO_OVER(2)*S22 + 
     &           B_LS_ANISO_OVER(3)*S33 + B_LS_ANISO_OVER(4)*S12 +
     &           B_LS_ANISO_OVER(5)*S13 + B_LS_ANISO_OVER(6)*S23
           EXPAN = EXP(-SBS)
         ENDIF
C
C---Assume. Isotropic equavalent of aniso B already has been 
C---applied to coordinates
c highly negative B usually mean problems
c cutting them gives better results (?)
c         if (B_LS_OVER.lt.0.) B_LS_OVER = 0.
         IPOS = IREF+NPART*NOBS
         fc(ipos,1) = fc(ipos,1)*exp(-RSQ*B_LS_OVER)
         ip=1
         if (dppi_sras.or.dppi_sir) ip=3
         sum_fc=sum_fc+fc(ipos,ip)
         do ip=2,ndens
           fc(iref,ip) = fc(iref,ip)*exp(-RSQ*B_LS_OVER)
         enddo
         sum_extra=sum_extra+fc(iref,ndens)
         do ip=1,heavy_sf_model_num
           H_A(IREF+(ip-1)*NOBS) = H_A(IREF+(ip-1)*NOBS)
     &         *EXP(-RSQ*B_LS_OVER) 
           H_B(IREF+(ip-1)*NOBS) = H_B(IREF+(ip-1)*NOBS)
     &         *EXP(-RSQ*B_LS_OVER) 
         enddo
         FO(IREF)   = FO(IREF)/(SCALE_LS_OVER*EXPAN) 
c     &     /SCALE_Llh_OVER
         SIGO(IREF) = SIGO(IREF)/(SCALE_LS_OVER*EXPAN) 
c     &     /SCALE_Llh_OVER
         do ip=1,dataset_num_tot
           FO(IREF+ip*NOBS) = FO(IREF+ip*NOBS)/(SCALE_LS_OVER*EXPAN) 
c     &       /SCALE_Llh_OVER
           SIGO(IREF+ip*NOBS)=SIGO(IREF+ip*NOBS)/(SCALE_LS_OVER*EXPAN)
c     &       /SCALE_Llh_OVER
         enddo
         sum_fo=sum_fo+fo(iref)
         DO    IP=1,NPART
           IPOS     = IREF + (IP-1)*NOBS
           FC(IPOS,1) = FC(IPOS,1)*SCALE_LS_PART(IP)*
     &                 EXP(-RSQ*(B_LS_PART(IP)+B_LS_OVER))
         ENDDO
       ENDDO
c do we need to make the extra f's on the same scale? 
       if (dm_flag) then
         if (sum_fo.gt.sum_fc) sum_fc=sum_fo
         fc(1:nref,ndens)=fc(1:nref,ndens)*sum_fc/sum_extra
       endif
       RETURN
       END
c
       SUBROUTINE APPLYSCALES_map(NREF,hkl_asym,FO,SIGO)
       use agreem
C
C---Applies scale factors to amplitudes of structure factors
C---If IP1 = 0 then it will apply 1/scale(NPART1) to FO-s
C---If APPLY_SCALE_TO is equal to 'OBSE' then scale B-value of 
C---(NPART+1)-th partial structure will be applied to observed 
C---structure factors. Babinet's bulk solvent correction is not applied here.
C
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
C
      INTEGER hkl_asym(3,*)
      REAL FO(*),SIGO(*)
      REAL S1,S2,S3,S11,S22,S33,S12,S13,S23,RSQ
      INTEGER IP
C
       DO     IREF = 1,NREF
         CALL INDTORS(hkl_asym(1:3,IREF),RSQ)
         RSQ = RSQ/4.0
         ihh = hkl_asym(1,iref)
         ikk = hkl_asym(2,iref)
         ill = hkl_asym(3,iref)
         EXPAN = 1.0
         IF(B_LS_ANISO_OVER_FLAG) THEN
           S1 = FLOAT(IHH)*RCELL(1)
           S2 = FLOAT(IKK)*RCELL(2)
           S3 = FLOAT(ILL)*RCELL(3)
           S11 = S1*S1
           S22 = S2*S2
           S33 = S3*S3
           S12 = 2.0*S1*S2
           S13 = 2.0*S1*S3
           S23 = 2.0*S2*S3
           SBS = B_LS_ANISO_OVER(1)*S11 + B_LS_ANISO_OVER(2)*S22 + 
     &           B_LS_ANISO_OVER(3)*S33 + B_LS_ANISO_OVER(4)*S12 +
     &           B_LS_ANISO_OVER(5)*S13 + B_LS_ANISO_OVER(6)*S23
           EXPAN = EXP(-SBS)
         ENDIF
C
C---Assume. Isotropic equavalent of aniso B already has been 
C---applied to coordinates
         FO(IREF)   = FO(IREF)/(SCALE_LS_OVER*EXPAN)
         SIGO(IREF) = SIGO(IREF)/(SCALE_LS_OVER*EXPAN)
       ENDDO
       RETURN
       END

C
c  ******************* for SAD and SIR ***************
c
      SUBROUTINE SADSIR_CALC_SIGNP(NREF,ndens,hkl_asym,FO,SIGO,
     &     FOPL,SIGOP,
     +  FOMI,SIGOM,H_A,H_B,FC,PHASE,FREER,SHIFTS,exper,ncycs)
      use weights
      use agreem
      use solvent_all
c FOPL and FOMI means FNAT and FDER for exper sir
      IMPLICIT NONE
C
C---Find sigmaN and sigmaP (and other sigmas)
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'	  
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'anom.fh'
      INTEGER NREF,ndens,ncycs
      INTEGER hkl_asym(3,*)
      REAL    FO(*),SIGO(*),FREER(*)
      real    FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
cwb      
      REAL FOPL(*),SIGOP(*),FOMI(*),SIGOM(*),H_A(*),H_B(*)
      REAL SHIFTS(NMAXPART+2,MAXBIN)
      real YC2_PART(NMAXPART+2), Y_C_PART(NMAXPART+2)
      character*(*) exper
cwe           
      REAL A_CALCS(NMAXPART+2),B_CALCS(NMAXPART+2),Y_C,A_ALL,B_ALL	  
      INTEGER I,IR,ICENT,ISYSAB,IB,IHH(3),ipos,mod2
      REAL WT1,WT2, YO2,YC2, EPSI, RHO,RSQ, RESOMIN,RESOMAX, YOP2,YOPM
      REAL YC2_D, YC2_DD, A_ALL_D, B_ALL_D, Y_C_D, SCALE_NOW, AB12
      real Y_C_P, Y_C_M, YC2PM, YC2PM_imag, YC2PP, PH_P, PH_M, PH_H
      real YOD2, YON2, YCD2, Y_C_H, YCH2, YC2PH, YC2MH, YOYDM
      real Y_C_P_2,Y_C_M_2,PH_P_2,PH_M_2, FOPL_2, FOMI_2, y_c_pr,ycpr2
      real temp(maxbin), SIG_DM(maxbin), a_extra,b_extra
      CHARACTER LINE*120
      INTEGER NREF_N_IN_BIN(100),NREF_P_IN_BIN(100),NREF_N2_IN_BIN(100),
     +  NREF_P2_IN_BIN(100), ia, ifrom, dimen, Dnum, npart2, npart1
      EXTERNAL CENTR,EPSLON
      LOGICAL FREERCHK	  
        real an_o(maxbin), an_c(maxbin)
C
      if (exper.ne.'sad'.and.exper.ne.'sir'.and.exper.ne.'mad'
     &    .and.exper.ne.'') then
        write(*,*) 'type:',exper
        call errwrt(1,'Wrong experiment type in SADSIR_CALC_SIGNP')
      endif
c
      call return_mat_dim(dimen)
      if (.not.dppi_no) call return_Dnum(Dnum)
      DO    IB=1,NBIN_ML+1
        an_o(ib) = 0.0
        an_c(ib) = 0.0
        if (.not.DPPI_sras.or.exper.eq.'sir'.or.substruct_flag) then
      	  SIGN(IB) = 0.0
      	  SIGP(IB) = 0.0
        endif
      	if (exper.ne.'mad'.or.sigN_calc.ge.1) SIGN2(IB) = 0.0	
      	SIGP2(IB,1) = 0.0
      	if (exper.ne.'mad'.or.sigP_calc.ge.1) SIGP2(IB,2) = 0.0
        if (sigP_calc.ge.1) SIGP2P(IB) = 0.0
      	if (sigN_calc.ge.1) SIGN2P(IB) = 0.0
        if (exper.eq.'sir') then
          SIGH(IB) = 0.0
        endif
        SIGP12(IB) = 0.
        sigi(ib) = 0.
        temp(ib) = 0.
        sig_dm(ib) = 0.
        NREF_N_IN_BIN(IB) = 0
      	NREF_P_IN_BIN(IB) = 0
      	NREF_N2_IN_BIN(IB) = 0	
      	NREF_P2_IN_BIN(IB) = 0
      ENDDO
      npart2=npart+2
      npart1=npart+1
C
c weight for acentrics
      WT1 = 1.0
ccc   2.0-FLOAT(ICENT)
c weight for centrics
      WT2 = 1.0
ccc   +FLOAT(ICENT)
      DO    IR=1,NREF
          CALL INDTORS(hkl_asym(1:3,IR),RSQ)
          RHO = SQRT(RSQ)
          ihh(1:3) = hkl_asym(1:3,ir)
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)
        if (exper.ne.'') then 
         if ( (fo(IR).le.0.0.or.sigo(IR).le.0.0) .and.
     +        (fomi(IR).le.0.0.or.sigom(IR).le.0.0) .and.
     +        (fopl(IR).le.0.0.or.sigop(IR).le.0.0)
     +	    ) then	 
            goto 110	  
         endif
        endif
c          if (icent.eq.1.and.exper.eq.'sad') then
          if (fomi(IR).le.0.0.or.sigom(IR).le.0.0) then
            if (exper.eq.'sad') then 
              if(ICENT.gt.0) then
                fomi(IR)  = fopl(ir)
                sigom(IR) = sigop(ir)
              else
                goto 110
              endif
            endif
          else if (fopl(IR).le.0.0.or.sigop(IR).le.0.0) then
            if (exper.eq.'sad') then 
              if(ICENT.gt.0) then
                fopl(IR)  = fomi(ir)
                sigop(IR) = sigom(ir)
              else
                goto 110
              endif
            endif
          endif
c        FREERCHK = .FALSE.
c        IF(FREER_FLAG )THEN 
c          IF((.NOT.MLUSEWORK)  .AND.
c     +    (ABS(FREER(IR)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
c          IF(       MLUSEWORK   .AND. 
c     +    (ABS(FREER(IR)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
c        END IF
c        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IR).GT.0.0) THEN		
          YO2 = WT2*FO(IR)*FO(IR)/EPSI
          if (exper.eq.'sad') then
            YOP2 = WT1/EPSI*(FOPL(IR)*FOPL(IR) + FOMI(IR)*FOMI(IR))/2
            YOPM = WT1*FOPL(IR)*FOMI(IR)/EPSI
          else if (exper.eq.'sir') then
            YON2 = WT1*FOPL(IR)*FOPL(IR)/EPSI
            YOD2 = WT1*FOMI(IR)*FOMI(IR)/EPSI
          endif            
          DO    IB=1,NBIN_ML        
            IF(RHO.LE.SMAXB_ML(IB).AND.RHO.GT.SMINB_ML(IB)) THEN
      		  CALL EXTRACT_ABS(IR,ndens,FC,PHASE,A_CALCS,B_CALCS)
c here adding the non-anomalous heavy atom contributions for siras case
              if (DPPI_sras.and.exper.eq.'sad') then
                call num_inp_mod(mod2)
c                write(*,*)'debug3',A_CALCS(NPART+1), H_A(IR-NOBS)
          	    if (.not.substruct_flag.or.mod2.eq.2) then
                  A_CALCS(NPART+1) = A_CALCS(NPART+1) + H_A(IR-NOBS)
                  B_CALCS(NPART+1) = B_CALCS(NPART+1) + H_B(IR-NOBS)
                else
                  A_CALCS(NPART+1) = H_A(IR-NOBS)
                  B_CALCS(NPART+1) = H_B(IR-NOBS)
                endif
c               write(*,*)'debug4',A_CALCS(NPART+1)
              endif
              a_extra=0.
              b_extra=0.
              if (dm_flag) then
c check for NaN, get A_DM, B_DM
               if (fc(ir,ndens).ne.fc(ir,ndens)) goto 110
               if (phase(ir,ndens).ne.phase(ir,ndens)) goto 110
               a_extra=fc(ir,ndens)*cos(phase(ir,ndens))
               b_extra=fc(ir,ndens)*sin(phase(ir,ndens))
               a_calcs(npart2)=a_extra
               b_calcs(npart2)=b_extra
              endif
      		  A_ALL = 0.0
      		  B_ALL = 0.0
              IFROM = 1
c              if (dm_flag.and.DPPI_sadh.and.dimen.gt.4) then
c                IFROM=NPART+1
c solvent not taken into account for dm of now
c                if (solvent_flag) IFROM=IFROM-1
c              endif
c              if (DPPI_sad.or.DPPI_sadh.or.DPPI_pl.or.DPPI_sras
c     +            .or.DPPI_sir)   IFROM = 1
c              if (DPPI_sad) IFROM = 1
      		  DO   I=IFROM,NPART+1
        	    A_ALL = A_ALL + A_CALCS(I)
        	    B_ALL = B_ALL + B_CALCS(I)
              ENDDO
      		  DO   I=1,NPART+2
                Y_C_PART(I) = SQRT(A_CALCS(I)**2 + B_CALCS(I)**2)
          	    YC2_PART(I) = WT1*Y_C_PART(I)*Y_C_PART(I)/EPSI
              ENDDO
      		  Y_C = SQRT(A_ALL**2 + B_ALL**2)
      		  YC2 = WT2 * Y_C * Y_C /EPSI
              if (exper.eq.'sad'.or.exper.eq.'mad') then
                Y_C_P=SQRT((A_ALL+H_A(IR))**2+(B_ALL+H_B(IR))**2)
                Y_C_M=SQRT((A_ALL-H_A(IR))**2+(B_ALL-H_B(IR))**2)
                PH_P = atan( (B_ALL+H_B(IR))/(A_ALL+H_A(IR)) )
                if ( A_ALL+H_A(IR).lt.0 )   PH_P = PH_P + PI
                PH_M = atan( (B_ALL-H_B(IR))/(A_ALL-H_A(IR)) )
                if ( A_ALL-H_A(IR).lt.0 )   PH_M = PH_M + PI
              endif
              if (exper.eq.'sad') then
                YC2PM = WT1 * Y_C_P * Y_C_M /EPSI 
     +            *cos(PH_P-PH_M)
                if (sigN_calc.lt.3) YOPM = YOPM*cos(PH_P-PH_M)
cc      write(*,*) ir,icent,rho,cos(PH_P-PH_M),
ccc      PH_P,PH_M,
cc     +  A_ALL,b_ALL,H_A(IR),H_b(IR),'***',Y_C_P,Y_C_M,FOPL(ir),FOMI(ir)
                YC2PP = WT1 * (Y_C_P*Y_C_P + Y_C_M*Y_C_M)/2 /EPSI
                if (DPPI_sadh.or.DPPI_sras) then
                  Y_C_H=SQRT(H_A(IR)**2+H_B(IR)**2)
                  PH_H = 0
                  if (H_A(IR).ne.0.)   PH_H = atan(H_B(IR)/H_A(IR))
                  if ( H_A(IR).lt.0 )  PH_H = PH_H + PI
                  YC2PH = WT1 * Y_C_P * Y_C_H * cos(PH_P-PH_H) /EPSI
                  YC2MH = WT1 * Y_C_M * Y_C_H * cos(PH_M-PH_H) /EPSI
                  YCH2 = WT1 * Y_C_H * Y_C_H /EPSI
c estimating the DM D parameter from FOM. only for SAD at the moment. SIRAS implementation etc can be tested.
c!!!!!
c                  if (DPPI_sadh.and.dm_flag) then
c                   YOYDM = WT1* (FOPL(IR)+FOMI(IR))/2 * Y_C_PART(npart2)
c     +                        * scale_ml(ib,2) /EPSI
c                  if (DPPI_sadh.and.dm_flag.and.npartall.gt.1) then
c                   YOYDM = WT1* (FOPL(IR)+FOMI(IR))/2 * Y_C_PART(npart2)
c     +                        * fc(ir,ndens-1) /EPSI
c      write(*,*)'debu',FO(IR),FOPL(IR),FOMI(IR),Y_C_PART(npart2),
c     +  fc(ir,ndens-1)
c                  endif
                endif
              else if (exper.eq.'sir') then
                Y_C_D=SQRT( (A_ALL+H_A(IR))**2 + (B_ALL+H_B(IR))**2 )
                Y_C_PR=SQRT( (A_ALL-H_A(IR))**2 + (B_ALL-H_B(IR))**2 )
                Y_C_H = SQRT( H_A(IR)**2 + H_B(IR)**2 )
      		    YCH2 = WT1 * Y_C_H * Y_C_H /EPSI
                YCD2 = WT1 * Y_C_D*Y_C_D /EPSI
                YCPR2 = WT1 * Y_C_PR*Y_C_PR /EPSI
c                YC2PM = WT1 * Y_C_P * Y_C_M /EPSI 
c     +            *cos(PH_P-PH_M)
c                if (sigN_calc.lt.3) YOPM = YOPM*cos(PH_P-PH_M)
                YC2PP = WT1 * (Y_C_P*Y_C_P + Y_C_M*Y_C_M)/2 /EPSI
              else if (exper.eq.'mad') then
                FOPL_2 = FO(dataset_order(3)*NOBS+IR)
                FOMI_2 = FO(dataset_order(4)*NOBS+IR)
                Y_C_P_2 = 
     +            SQRT((A_ALL+H_A(IR+NOBS))**2+(B_ALL+H_B(IR+NOBS))**2)
                Y_C_M_2 =
     +            SQRT((A_ALL-H_A(IR+NOBS))**2+(B_ALL-H_B(IR+NOBS))**2)
                PH_P_2=atan( (B_ALL+H_B(IR+NOBS))/(A_ALL+H_A(IR+NOBS)) )
                if ( A_ALL+H_A(IR+NOBS).lt.0 )   PH_P_2 = PH_P_2 + PI
                PH_M_2=atan( (B_ALL-H_B(IR+NOBS))/(A_ALL-H_A(IR+NOBS)) )
                if ( A_ALL-H_A(IR+NOBS).lt.0 )   PH_M_2 = PH_M_2 + PI
                YOP2 = WT1/EPSI*( FOPL(IR)*FOPL_2*cos(PH_P-PH_P_2) +
     +                            FOMI(IR)*FOMI_2*cos(PH_M-PH_M_2) )/2
                YOPM = WT1/EPSI*( FOPL(IR)*FOMI_2*cos(PH_P-PH_M_2) + 
     +                            FOMI(IR)*FOPL_2*cos(PH_M-PH_P_2) )/2
                YC2PP = WT1/EPSI*( Y_C_P*Y_C_P_2*cos(PH_P-PH_P_2) +
     +                             Y_C_M*Y_C_M_2*cos(PH_M-PH_M_2) )/2
                YC2PM = WT1/EPSI*( Y_C_P*Y_C_M_2*cos(PH_P-PH_M_2) + 
     +                             Y_C_M*Y_C_P_2*cos(PH_M-PH_P_2) )/2
              endif
             AB12=WT1*(A_CALCS(1)*A_CALCS(2)+B_CALCS(1)*B_CALCS(2))/EPSI
C
c              if (icent.eq.1) then
              if (sigo(ir).gt.0.and.fo(ir).gt.0) then
              if(.not.DPPI_sras.or.exper.eq.'sir'.or.substruct_flag)then
                SIGN(IB) = SIGN(IB) + YO2
                NREF_N_IN_BIN(IB) = NREF_N_IN_BIN(IB)+WT2
c                if (DPPI_pl.and.dimen.eq.4) then
c                  SIGP(IB) = SIGP(IB) + YCD2
                SIGP(IB) = SIGP(IB) + YC2
                NREF_P_IN_BIN(IB) = NREF_P_IN_BIN(IB)+WT2
              endif
                SIGP2(IB,1) = SIGP2(IB,1) + YC2_PART(1)
                if (dm_flag)
     +            SIGP2(IB,3) = SIGP2(IB,3) + YC2_PART(npart2)
              endif
              if (exper.ne.'') then
              if (SIGOP(IR).GT.0.0.AND.FOPL(IR).GT.0.0
     +              .and.sigo(ir).gt.0.and.fo(ir).gt.0.
     +		        .AND.SIGOM(IR).GT.0.0.AND.FOMI(IR).GT.0.0) THEN
                if (exper.eq.'sad') then
                  SIGN2(IB) = SIGN2(IB) + YOP2 
              	  if (sigN_calc.eq.1.or.sigN_calc.eq.3) 
     +          	SIGN2P(IB) = SIGN2P(IB) + YOPM
                else if (exper.eq.'mad') then
ccc the first condition may need to be adjusted 
                  if (sigN_calc.eq.1) SIGN2(IB) = SIGN2(IB) + YOP2 
              	  if (sigN_calc.eq.1.or.sigN_calc.eq.3) 
     +          	SIGN2P(IB) = SIGN2P(IB) + YOPM
                else
                  SIGN2(IB) = SIGN2(IB) + YON2 
                  if (sigN_calc.eq.1.or.sigN_calc.eq.3) 
     +              SIGN2P(IB) = SIGN2P(IB) + YOD2
                endif
                NREF_N2_IN_BIN(IB) = NREF_N2_IN_BIN(IB)+WT1
                an_o(ib) = an_o(ib) + abs(fopl(ir) - fomi(ir))
ccc              ENDIF
c              IF(Y_C.GT.0.0) THEN
c              if (icent.eq.0) then
c!!!!!
c                  if (DPPI_sadh.and.dm_flag) sig_dm(ib)=sig_dm(ib)+YOYDM
c      .and.npartall.gt.1) 
                if (exper.eq.'sad') then
                  if (sigN_calc.eq.2) temp(ib) = temp(ib) + YC2PP-YC2PM
                  if (DPPI_sadh.or.(DPPI_sras.and.Dnum>3)) then
                    SIGP2(IB,2) = SIGP2(IB,2) + YC2/WT2*WT1
ccc					/(ICENT+1)*WT1
c!!!              SIGP2(IB,2) = SIGP2(IB,2) + YC2PP
ccc          SIGP2(IB,2) = SIGP2(IB,2) + YC2PH
ccc          SIGP2(IB,1) = SIGP2(IB,1) + YC2MH
                    if (sigP_calc.ge.1) SIGP2P(IB) = SIGP2P(IB) + YCH2
                  else
                    SIGP2(IB,2) = SIGP2(IB,2) + YC2PP
                  endif
c          if (sigN_calc.eq.2) SIGN2P(IB) = SIGN2P(IB) + YC2PM
                else if (exper.eq.'mad') then
                  if (sigP_calc.ge.1) SIGP2(IB,2) = SIGP2(IB,2) + YC2PP
                  if (sigP_calc.ge.1) SIGP2P(IB) = SIGP2P(IB) + YC2PM
c                  if (sigN_calc.eq.2) SIGN2P(IB) = SIGN2P(IB) + YC2PM
                  if (sigN_calc.eq.2) temp(ib) = temp(ib) + YC2PP-YC2PM
                else 
                  if (DPPI_pl.and.dimen.eq.4.and..not.ligin1) then
                    SIGP2(IB,2) = SIGP2(IB,2) + YCPR2
                  else
c                    SIGP2(IB,2) = SIGP2(IB,2) + YC2_PART(NPART+1)
                    SIGP2(IB,2) = SIGP2(IB,2) + YC2
                  endif
                  if (sigP_calc.ge.1) then
                    if (DPPI_pl.and.dimen.eq.4) then
                      SIGP2P(IB) = SIGP2P(IB) + YCH2
                    else
                      SIGP2P(IB) = SIGP2P(IB) + YCD2
                    endif
                  endif
                  if (sigN_calc.eq.2) SIGN2P(IB) = SIGN2P(IB) + YCD2
                  SIGH(IB) = SIGH(IB) + YCH2
                endif
                endif
                SIGP12(IB) = SIGP12(IB) + AB12
                NREF_P2_IN_BIN(IB) = NREF_P2_IN_BIN(IB)+WT1
                an_c(ib) = an_c(ib) + abs(Y_C_P - Y_C_M)
c              endif
              ENDIF	    
            ENDIF
          ENDDO
c        ENDIF		  
  110   continue		
      ENDDO
c
      write(6,*)  ' '
      if (ncycl.eq.0.and.DPPI_sad)
     +write(6,*)'anom. signal: bin, observed, calculated'
      DO     IB=1,NBIN_ML
        if (ncycl.eq.0.and.DPPI_sad) then
        write(6,*) ib, an_o(ib), an_c(ib)
            an_o(NBIN_ML+1) = an_o(NBIN_ML+1) + an_o(ib)
            an_c(NBIN_ML+1) = an_c(NBIN_ML+1) + an_c(ib)
        endif
      	if(NREF_P2_IN_BIN(IB).GT.0.) then
          SIGP2(IB,1) = SIGP2(IB,1)/NREF_P2_IN_BIN(IB)
          if (exper.ne.'mad'.or.sigP_calc.ge.1) 
     +      SIGP2(IB,2) = SIGP2(IB,2)/NREF_P2_IN_BIN(IB)
          if (sigP_calc.ge.1) SIGP2P(IB) = SIGP2P(IB)/NREF_P2_IN_BIN(IB)
          if (exper.eq.'sir') then
            SIGH(IB) = SIGH(IB)/NREF_P2_IN_BIN(IB)
          endif
          SIGP12(IB) = SIGP12(IB)/NREF_P2_IN_BIN(IB)
c!!!!!
c          if (dm_flag.and.exper.eq.'sad'.and.ncycs.le.1) then
c .and.npartall.gt.1
c            SCALE_ML(IB,2) = SIG_DM(IB)/NREF_P2_IN_BIN(IB)/SIGP2(IB,1)
c      write(*,*)'debugD:',IB,SCALE_ML(IB,2),SIG_DM(IB),SIGP2(IB,1),
c     +npartall,ncycs
c          endif
        endif
      	if(NREF_N2_IN_BIN(IB).GT.0.) then
          if (exper.ne.'mad'.or.sigN_calc.ge.1) 
     +      SIGN2(IB) = SIGN2(IB)/NREF_N2_IN_BIN(IB)
          if (sigN_calc.ge.1) SIGN2P(IB) = SIGN2P(IB)/NREF_N2_IN_BIN(IB)
          if (sigN_calc.eq.2) then
c sign2p = sign2 - calc diff
            SIGN2P(IB) = SIGN2(IB) - temp(ib)/NREF_P2_IN_BIN(IB)
          endif
        endif
        if (.not.DPPI_sras.or.exper.eq.'sir'.or.substruct_flag) then
        IF(NREF_N_IN_BIN(IB).GT.0.AND.NREF_P_IN_BIN(IB).GT.0) then
           SIGN(IB) = SIGN(IB)/NREF_N_IN_BIN(IB)
           SIGP(IB) = SIGP(IB)/NREF_P_IN_BIN(IB)
           SIGP2(IB,1) = SIGP2(IB,1)/NREF_P_IN_BIN(IB)
           SIGP2(IB,3) = SIGP2(IB,3)/NREF_P_IN_BIN(IB)
        ELSE
           RESOMIN = 1/SMINB_ML(IB)
           RESOMAX = 1/SMAXB_ML(IB)
           IF(RESOMAX.NE.RESOMIN) THEN
           WRITE(LINE,'(A,I3,A,F9.3,A,F9.3,A)')
     +      ' In resolution bins ',IB ,', i.e. between resolutions ',
     +       RESOMIN,'-',RESOMAX,' too few reflections'
           CALL ERRWRT(-1,LINE)
           ENDIF
        ENDIF
        endif
      ENDDO
C
      RETURN
      END
C
C
c  used to calculate some sigma terms directly from the atomic parameters
c
      SUBROUTINE CALC_SIGP2(wave_pos,wave_pos_2)
      use weights
      use agreem
c FOPL and FOMI means FNAT and FDER for exper sir
      IMPLICIT NONE
c
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'const.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'	  
      INCLUDE 'anom.fh'
c
      real sumf2(MAXBIN), stol2, expRB, f_now
      real scale_N, scale_P, scale_Nbin(MAXBIN), scale_N2bin(MAXBIN), 
     +	   scale_Pbin(MAXBIN), scale_P2bin(MAXBIN)
      integer ibin, ia, i, j, wave_pos, wave_pos_2, IT, AIT, a_mod, hn
      integer Dnum
c
      if (.not.dppi_no) call return_Dnum(Dnum)
      hn = 1
      if (DPPI_sras.or.DPPI_sir) hn = 2
      do   IBIN=1,NBIN_ML
        stol2 = ( SMAXB_ML(IBIN) + SMINB_ML(IBIN) )/4
        stol2 = stol2*stol2

        DSIGP2(IBin) = 0
        SIGi(IBin) = 0
c         wave_pos = dataset_wavenum(dataset_order(2))*MAXN_H_TYP
        do ia = 1, n_atom_mod(hn)
          IT=ID_SF_mod(ia,hn)
          AIT=t2at(it)
ccc         do ih = 1, NUM_HEAVY
ccc           IT=HEAVY_TYPE(ih)+CS_NSFATM
          expRB=exp(-((U_ANISO_mod(1,ia,hn)-u_add_loc)*PISQ8+B_LS_OVER)*
     &      stol2)
c           expRB = exp(-(U_ANISO(1,ia)*PISQ8)*stol2)
          if ( cs_anom(ID_SF_mod(ia,hn)) .and.
     +        (DPPI_sad.or.DPPI_sadh.or.DPPI_sras.or.DPPI_mad) ) then 
            DsigP2(IBIN) = DsigP2(IBIN) + expRB*expRB*
ccc     +         OCCUP_mod(ia)*OCCUP_mod(ia)*
     +         OCCUP_anom_mod(ia,hn)*OCCUP_anom_mod(ia,hn)*
     +         2*f2prime(AIT,wave_pos)*
     +           f2prime(AIT,wave_pos_2)*CS_NSYM /real(NSMULT)
          endif
          if (DPPI_sir.or.DPPI_sras) then 
      		f_now = 0
      		do j = 1,5
          	  f_now = f_now + CS_A(j,IT)*exp( -CS_B(j,IT)*stol2 ) 
      		enddo
          	f_now = ( f_now + fprime(AIT,wave_pos) ) *OCCUP_mod(ia,hn)
             sigi(IBIN) = sigi(IBIN) + expRB*expRB*
     +         f_now*f_now*CS_NSYM   /real(NSMULT)
          endif
        enddo
c        sumf2(ibin) = 0
c        do I = 1,N_ATOM
c        if (.not.cs_anom(ID_SF(i))) then 
c          f_now = 0
c          do j = 1,4
c            f_now = f_now + 
c     +              CS_A( j,ID_SF(I) )*exp( -CS_B( j,ID_SF(I) )*stol2 )
c          enddo
c          f_now = f_now + CS_A( 5, ID_SF(I) )
c          f_now = f_now*OCCUP(I)
c          expRB = exp(-((U_ANISO(1,I)-u_add_loc)*PISQ8+B_LS_OVER)*stol2)
c          sumf2(ibin) = sumf2(ibin) + f_now*f_now*expRB*expRB*CS_NSYM
c        endif
c        enddo
      enddo
c
      if (DPPI_sras) then 
        do   IBIN=1,NBIN_ML
c          if (sigN_calc.eq.0) sigN2(ibin) = sigm_N(ibin,1) + SIGi(IBin)
c!!!!!!!!!!!!!!!
c          if (sigP_calc.eq.0) sigP2(ibin,2) = sigm_P(ibin,1) +SIGi(IBin)
          if(sigP_calc.eq.0.and.substruct_flag) sigP2(ibin,2)=SIGi(IBin)
c          if (sigP_calc.eq.0.and.npart.gt.0) sigP2(ibin,2)=sigP2(ibin,2)
c     &      + SIGP2(IBin,1) 
c          if (sigP_calc.eq.0.and.substruct_flag)
c     &      sigP2(ibin,2) = sigP2(ibin,2) - sigm_P(ibin,1)
        enddo
      endif
      if (DPPI_sir) then 
        do   IBIN=1,NBIN_ML
          if (sigN_calc.eq.0) sigN2P(ibin) = sigN2(ibin) + SIGi(IBin)
c!!!!!!!!!!!          if (sigP_calc.eq.0) sigP2P(ibin) = sigP2(ibin,2) + SIGi(IBin)          
          if (sigP_calc.eq.0) sigP2P(ibin) = SIGi(IBin)          
          if (sigP_calc.eq.0.and.substruct_flag)
     &      sigP2P(ibin) = sigP2P(ibin) - sigP2(ibin,2)
        enddo
      endif
      if (DPPI_mad.and.wave_pos.ne.wave_pos_2) then
        do   IBIN=1,NBIN_ML
          if (sigN_calc.eq.0) sigN2(ibin)= sigN2(ibin) + .5*DSIGP2(IBin)
          if (sigP_calc.eq.0)sigP2(ibin,2)=sigP2(ibin,2)+.5*DSIGP2(IBin)
        enddo
      endif
      if (DPPI_sad.or.(DPPI_sras.and.Dnum.le.3).or.DPPI_mad) then
        do   IBIN=1,NBIN_ML
          if (sigN_calc.eq.0) sigN2P(ibin) = sigN2(ibin) - DSIGP2(IBin)
          if (sigP_calc.eq.0) sigP2P(ibin) = sigP2(ibin,2)-DSIGP2(IBin)
c          sigN2P(ibin) = sigN2(ibin) - 
c     +     	  sigN2(ibin)/sigP2(ibin,2)*DSIGP2(IBin)
c          sigP2P(ibin) = 
c     +   		sigP2(ibin,2) - sigP2(ibin,2)/sigN2(ibin)*DSIGP2(IBin)
          sigi(ibin)=0
        enddo
      endif
      if (DPPI_sadh.or.(DPPI_sras.and.Dnum.gt.3)) then
        do   IBIN=1,NBIN_ML
          if (sigN_calc.eq.0) sigN2P(ibin)=sigN2(ibin) - DSIGP2(IBin)
          if (sigP_calc.eq.0) sigP2P(ibin)=.5* DSIGP2(IBin)
c!      sigP2(ibin,2) = sigP2(ibin,2) - .5*DSIGP2(IBin)
          sigi(ibin)=0
        enddo
      endif
cc        do   IBIN=1,NBIN_ML
cc      write(*,*)  'dsigp2: ',ibin,DSIGP2(IBin)
cc      enddo
c
      RETURN
      END
