module complete_hkl
  implicit none
  
contains
  subroutine calc_completeness(rot,tr,cell,res_max)
    use weights
    use agreem
    use rharvest
    
    real, intent(in) :: rot(:,:,:), tr(:,:)
    real, intent(in) :: cell(6)
    real, intent(in) :: res_max
    
    integer nref
    integer nsym
    integer nasym
    integer, allocatable :: hkl_asym(:,:)
    integer, allocatable :: freer(:)
    integer, allocatable :: hkl_obs(:,:)
    integer, allocatable :: obs_flag(:)
    integer, allocatable :: hkl_observed(:)
    integer, allocatable :: freer_observed(:)
    integer, allocatable :: index(:)
    
    integer nb1,ifree,itemp,jmn
    real ast,bst,cst,cosast,cosbst,coscst
    real pi, degtor
    real cell_l(6)
    real rsq,rho
    integer i,j,is,ir,ia
    integer hkl_l(3)

    logical freer_flag
    !
    !   body
    nsym = size(rot(1,1,:))
    nb1 = nbin+1
    nrefm(1:2,1:nb1) = 0
    nrefa(1:2,1:nb1) = 0
    !
    !    Generate all hkl of the asymmetric unit for this space group
    call asym_list_size(nsym,nsym,rot,tr,cell,nasym,res_max)
    allocate(hkl_asym(3,nasym))
    call asym_list(nsym,nsym,rot,tr,cell,nasym,res_max,hkl_asym)

    call read_nrefl(nref)
    allocate(obs_flag(nref))
    allocate(freer(nref))
    allocate(hkl_obs(3,nref))

    !
    !   Read what is in the file
    call rdind_hkl(nref,obs_flag,freer,hkl_obs)

    freer_flag = sum(freer(1:nref)).ne.nref

    call refmac_asym_unit(rot,tr,hkl_obs)

    allocate(index(nref))
    do i=1,nref
       index(i) = i
    enddo
    do ir=1,nref
       itemp = hkl_obs(1,ir)
       hkl_obs(1,ir) = hkl_obs(3,ir)
       hkl_obs(3,ir) = itemp
    enddo
    call iheap_sort_r(nref,3,hkl_obs,index)


    do ir=1,nref
       itemp = hkl_obs(1,ir)
       hkl_obs(1,ir) = hkl_obs(3,ir)
       hkl_obs(3,ir) = itemp
    enddo

    !
    !  now compare ideal "asymmetric" unit and obseved ones. 
    !  What is not observd flag and keep track of free reflections
    allocate(hkl_observed(nasym))
    allocate(freer_observed(nasym))
    hkl_observed = 0
    freer_observed = 0
    ir = 1
    ia = 1
    do while(ir.le.nref.and.ia.le.nasym)
       if(hkl_obs(3,ir).lt.hkl_asym(3,ia)) then
          ir = ir + 1
       else if(hkl_obs(3,ir).gt.hkl_asym(3,ia)) then
          ia = ia + 1
       else
          if(hkl_obs(2,ir).lt.hkl_asym(2,ia)) then
             ir = ir + 1
          else if(hkl_obs(2,ir).gt.hkl_asym(2,ia)) then
             ia = ia + 1
          else
             if(hkl_obs(1,ir).lt.hkl_asym(1,ia)) then
                ir = ir + 1
             else if(hkl_obs(1,ir).gt.hkl_asym(1,ia)) then
                ia = ia + 1
             else
                hkl_observed(ia) = obs_flag(index(ir))
                freer_observed(ia) = freer(index(ir))
                ir = ir + 1
             endif
          endif
       endif
    enddo

    deallocate(obs_flag)
    deallocate(freer)
    deallocate(index)
    deallocate(hkl_obs)
    
    !
    !   Calculate completeness
    pi = 4.0*atan(1.0)
    degtor = pi/180.0
    cell_l = cell
    if(maxval(abs(cell_l(4:6))).gt.pi) then
       cell_l(4:6) = cell_l(4:6)*degtor
    endif
    call define_res_pars(cell_l,ast,bst,cst,cosast,cosbst,coscst)

    do i=1,nasym
       jmn = 0
       if(hkl_observed(i).le.0) jmn=1
       
       ifree = 1
       if(freer_observed(i).eq.0) ifree=2
       call define_res(hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i),ast,bst,cst,cosast,cosbst,coscst,rsq) 
       rho = sqrt(rsq/4.0)
       do  j=1,nbin
          if(rho.ge.sminb(j).and.rho.le.smaxb(j)) then
             if(hkl_observed(i).gt.0) then
                nrefa(ifree,j) = nrefa(ifree,j) + 1
             else
                nrefm(ifree,j) = nrefm(ifree,j) + 1
             endif
          endif
       enddo
       if(hkl_observed(i).gt.0) then
          nrefa(ifree,nb1) = nrefa(ifree,nb1) + 1
       else
          nrefm(ifree,nb1) = nrefm(ifree,nb1) + 1
       endif
    enddo
    !
    !  finalise calculation by copying all necessary info to harvest files
    do i=1,nb1
       hnref_shell_work(i) = nrefa(1,i)
       hnref_shell_free(i) = nrefa(2,i)
       hnref_shell_obs(i) = nrefa(1,i) + nrefa(2,i)
       hnref_shell_all(i) = nrefm(1,i) + nrefm(2,i) +hnref_shell_obs(i)
       hperc_shell_refl(i) = 100.0
       if(hnref_shell_all(i).gt.0) then
          hperc_shell_refl(i) = float(hnref_shell_obs(i))/float(hnref_shell_all(i))*100.00
       endif
    enddo
    !    write(*,*)nrefm(1,nb1)+nrefm(2,nb1)
    !    write(*,*)hnref_shell_obs(nb1),hnref_shell_all(nb1)
    !    stop
    nhrefl_work = nrefa(1,nb1)
    perc_free  = 0.0
    if(freer_flag.and.nrefa(2,nb1).gt.0) then
       nhrefl_free = nrefa(2,nb1)
       if(nhrefl_work + nhrefl_free.gt.0) then
          perc_free = float(nhrefl_free)/float(nhrefl_work+nhrefl_free)*100.0
       endif
    endif

    
    deallocate(hkl_asym)
    deallocate(hkl_observed)
    deallocate(freer_observed)
    
  end subroutine calc_completeness
  
  
  subroutine refmac_asym_unit(rot,tr,hkl_list)
    implicit none
    
    !
    !   Bring hkl to the "asymmetric" unit. The same asymmetric is used by asym_list
    !   This subroutine does not consider systematic absences or any fancy things happening
    !   due to the space group symmetries (eps, centricity etc)
    real, intent(in) :: rot(:,:,:),tr(:,:)
    integer hkl_list(:,:)
    
    integer nsym,nasym
    integer hcur,kcur,lcur,hsym,ksym,lsym,iscur
    integer ir,is
    !
    !  body
    nsym = size(rot(1,1,:))
    nasym = size(hkl_list(1,:))
    
    
    do  ir=1,nasym
       hcur = hkl_list(1,ir)
       kcur = hkl_list(2,ir)
       lcur = hkl_list(3,ir)
       iscur = 1
       !
       !-- we take maximum among symmetry related ones. 
       do is=1,nsym
          lsym = nint(sum(rot(1:3,3,is)*hkl_list(1:3,ir)))
          ksym = nint(sum(rot(1:3,2,is)*hkl_list(1:3,ir)))
          hsym = nint(sum(rot(1:3,1,is)*hkl_list(1:3,ir)))
          if(lsym.gt.lcur) then
             hcur = hsym
             kcur = ksym
             lcur = lsym
             iscur = is
          else if(lsym.eq.lcur) then
             if(ksym.gt.kcur) then
                hcur = hsym
                kcur = ksym
                lcur = lsym
                iscur = is
             else if(ksym.eq.kcur) then
                if(hsym.gt.hcur) then
                   hcur = hsym
                   kcur = ksym
                   lcur = lsym
                   iscur = is
                endif
             endif
          endif
          hsym = -hsym
          ksym = -ksym
          lsym = -lsym
          if(lsym.gt.lcur) then
             hcur = hsym
             kcur = ksym
             lcur = lsym
             iscur = -is
          else if(lsym.eq.lcur) then
             if(ksym.gt.kcur) then
                hcur = hsym
                kcur = ksym
                lcur = lsym
                iscur = -is
             else if(ksym.eq.kcur) then
                if(hsym.gt.hcur) then
                   hcur = hsym
                   kcur = ksym
                   lcur = lsym
                   iscur = -is
                endif
             endif
          endif
       enddo
       hkl_list(1,ir) = hcur
       hkl_list(2,ir) = kcur
       hkl_list(3,ir) = lcur
    enddo
    
  end subroutine refmac_asym_unit
  
end module complete_hkl
