module GlebSasha
  use CellAndSymmetry

  integer nwilson
  real, allocatable :: IdealWilson(:,:)

  real, private :: biso_GS_I=0.0,scale_GS_I=1.0
  real, private :: uaniso_GS_I(6)=0.0
  integer, private :: nmax_cyle=50

  real, private :: gm_wilson_scale_outlier=0.01

contains
  subroutine scale_GlebSasha_I(hkl_asym,io)
    !
    !   Scale using Gleb & Sasha intenisity curves.
    !   We may need to use a family of curves and select best fitting
    !   Or we can parameterise curves and find the best fit using regression
    !
    integer, intent(in) :: hkl_asym(:,:)
    real, intent(in) :: io(:,:)
    !
    !  locals
    integer nref,ndata

    integer i,ir
    integer in,ios,ierr
    character(len=512) :: file_local


    integer isysab
    real s1,s2,s3
    real cc,s1,i1
    !
    !   allocatables
    real, allocatable :: epsi(:)
    integer, allocatable :: icentr(:)
    real, allocatable :: ssq(:),ss(:,:)

    real*8 toler=1.0e-8
    real*8, allocatable :: d2fdp2(:,:),dfdp(:),shifts(:)
    !
    !  Body

    nref = size(io(1,:))
    ndata = size(io(:,1))

    if(ndata.gt.2) then
       stop 'Problem: We cannot deal with multiple data at the moment'
    endif

    call ugtenv('IDEALW',file_local)
    if(len_trim(file_local).le.0.or.trim(file_local).eq.'IDEALW') then
       call ugtenv('CLIBD',file_local)
       file_local = trim(file_local)//'//ideal_wilson.txt'
    endif
    call open_form_file(in,file_local,ierr)
    
    nwilson = 0
    ios = 0
    do while(ios.eq.0) 
       read(in,*,iostat=ios)s1,i1
       if(ios.eq.0) then
          nwilson = nwilson + 1
       endif
    enddo

    allocate(IdealWilson(2,nwilson))

    rewind(in)
    do i=1,nwilson
       read(in,*)IdealWilson(1:2,i)
    enddo
    close(in)
    !
    !   Start normalisation. First step: log scaling
    call log_scale_GS(nref,hkl_asym,io,s2,i2)

    !
    !  The second step: proper scaling

    !
    !  Precalculate s, si sj,epsi,centr and all that
    allocate(epsi(nref))
    allocate(icentr(nref))
    allocate(ssq(nref))
    allocate(ss(6,nref))
    do ir=1,nref
       call centr(hkl_asym(1:3,ir),icentr(ir))
       call epslon(hkl_asym(1:3,ir),epsi(ir),isysab)
       call indtors(hklasym(1:3,ir),ssq(ir))
       ssq(ir) = ssq(ir)/4.0
       !
       !  calculate ss(i)
       s1 = float(hkl_asym(1,ir))*rcell(1)
       s2 = float(hkl_asym(2,ir))*rcell(2)
       s3 = float(hkl_asym(3,ir))*rcell(3)
       ss(1,ir) = s1*s1
       ss(2,ir) = s2*s2
       ss(3,ir) = s3*s3
       ss(4,ir) = 2.0*s1*s2
       ss(5,ir) = 2.0*s1*s3
       ss(6,ir) = 2.0*s2*s3
       ss(1:6,ir) = ss(1:6,ir)/4.0
    enddo


    sdelta = IdealWilson(1,2)-IdealWilson(1,1)
    al_min = 3.0
    npar = 2 + neig

    allocate(d2fdp2(npar,npar))
    allocate(dfdp(npar))
    allocate(shifts(npar))

    allocate(w_robust(nref))
    do icycle=1,nmax_cycle
       LL = 0.0
       do ir=1,nref
          call epslon(hkl_asym,epsi)
          call centr(hkl_asym,icent)
          
          sus = 0.0
          do i=1,6
             sus = sus + ss(i,ir)*u_aniso_gs(i)
          enddo
          call linter_value2(nwilson,IdealWilson(1,1:nwilson),IdealWilson(2,1:nwilson),ssq(ir),GS_value)
          Sigma = scale_GS*exp(-b_iso_GS*ssq(ir))*exp(-sus)*GS_Value
          SigmaEps = epsi(ir)*Sigma
          
          !
          !   We need unnormalised P(F;Fo,Sigma) and expected values of 
          !   I and I^2
          if(icentr(ir).eq.1) then
             cc  = 2.0
             an0 = -0.5
             an1 = 0.5
             an2 = 1.5
          else
             cc  = 1.0
             an0 = 0.0
             an1 = 1.0
             an2 = 2.0
          endif
          t0 = (Io(1,ir) -Io(2,ir)**2/(cc*SigmaEps))/io(2,ir)

          call laplace_t02inf(t0,an0,exp_part0,rem_part0)
          call laplace_t02inf(t0,an1,exp_part1,rem_part1)
          call laplace_t02inf(t0,an2,exp_part2,rem_part2)

          tadd = tadd/(cc*SigmaEpsi)
          exp_part0 = exp_part  + tadd
          exp_part1 = exp_part1 + tadd
          exp_part2 = exp_part2 + tadd
          
          I_exp  = exp(-exp_part1+exp_part0)*rem_part1/rem_part0
          I2_exp = exp(-exp_part2+exp_part0)*rem_part2/rem_part0
          
          dfds   =  1.0/Sigma - 1.0/(cc*epsi(ir)*Sigma**2)*I_exp
          d2fds2 = -1/Sigma**2 +2.0/(cc*epsi(ir)*Sigma**3)*I_exp+1.0/(cc*epsi(ir)*Sigma**2)**2*(I2_exp-I_exp**2)
          
          !
          !  Add weights. If I is too big or too small its contribution should be 
          !  downweightd
          dev = 1.0-1.0/(cc*epsi(ir)*Sigma)*I_exp
          w_robust(ir) = 1.0/(1+gm_wilson_scale_outlier*dev**2)**2
          LL = LL + w_robust(ir)*(log(Sigma)  + exp_part0 - log(rem_part))
          
          dfds   = w_robust(ir)*dfds
          d2fds2 = w_robust(ir)*d2fds2
          
          dsigmadk = Sigma/scale_GS
          dsigmadb = -ssq(ir)*Sigma
          do i=1,6
             dsigmadu(i) = -ss(i)*Sigma
          enddo
          dsdp(1) = dsigmadk
          dsdp(2) = dsigmadb

          
          
          do i=1,npar
             dfdp(i) = dfdp(i) + dw_robust*fds*dsigmadp(i)
             do j=1,npar
                d2fdp2(i,j) = d2fdp2(i,j) + w_robust*d2fds2*dfdp(i)*dfdp(j)
             enddo
          enddo
       enddo
       !
       !  Solve the equation
       call deigen_filter_r90(toler,d2dp2(1:npar,1:npar),npar,npar,dfdp(1:npar),shift(1:npar),ierr)
       scale_Gs = scale_GS - shift(1)
       B_iso_GS = B_iso_GS - shift(2)
       eigen_aniso(1:neig) = eigen_aniso(1:neig) - shift(3:(3+neig-1))
       !
       !   Convert eigen_aniso to U aniso
       
       !
       !   line minimisation???
       !   Robustness weights should be here
    enddo
    !
    !  Print out reflections with low weight (< 0.5?)

  end subroutine scale_GlebSasha

  subroutine random_generate_chisq(hkl_asym,fo,sigo)
    
    integer, intent(in) :: hkl_asym(:,:)
    real, intent(inout) :: fo(:),sigo(:)

    integer no
    real rand_gauss(2),ff_rand,rchisq
    integer icent
    real epsi

    no = size(fo(:))

    do io=1,no
       if(sigo(i).le.0.0) then
          
          call generate_random2_gaussian(rand_gauss))
          scale = scale_GS*exp(-biso_GS*rsq/4.0)*exp(-Uss)
          sigma_id = scale*IdealWilson(ii)*epsi
          if(icent.eq.0) then
             rchisq = rand_gauss(1)**2
             ff_rand = sqrt(rchisq*scale*IdealWilson(ii)*epsi)
          else
             rchisq = rand_gauss(1)**2+rand_gauss(2)
             ff_rand = sqrt(rchisq*scale*IdealWilson(ii)*epsi/2.0)
          endif
          fo(i) = ff_rand
          sigo(i) = sqrt(sigma_id)
       endif
    enddo

  end subroutine random_generate_chisq

  subroutine log_scale_GS(no,hkl_asym,fo,sigo)
    !
    !   log scaling: to get things started
    real ff1,rsq
    real*8 df(2),d2f(2,2),shifts(2)
    real*8 toler*8=1.0d-8

    df = 0.0
    d2f = 0.0
    s2max = s2(nwilson)
    s2min = s2(1)
    deltas = (s2max-s2min)/nwilson
    do i=1,no
       if(io(1,i).gt.0.0.and.and.io(2,i).gt.0.0) then
          call nindtors(hkl_asym(1:3,i),rsq)
          ii = nint((rsq-s2min)/detlas)
          if(ii.ge.1.and.ii.le.nwilson) then
             ff = fo(i)**2/IdealWilson(i)
             ff1 = log(ff)
             df(1) = df(1) + ff1
             df(2) = df(2) - rsq*ff1
             d2f(1,1) = d2f(1,1) + 1.0
             d2f(1,2) = d2f(1,2) - rsq*ff1
             d2f(2,2) = d2f(2,2) + rsq*rsq*ff1
          endif
       endif
    enddo
    d2f(2,1) = d2f(1,2)
    call deigen_filter_r90(toler,d2f,2,2,df,shifts,ierr)
    scale_GS = shifts(1)
    biso_GS  = shifts(2)
    
  end subroutine log_scale_GS

  subroutine scale_aniso_GS()

    df = 0
    d2f = 0
    converged = .FALSE.
    icycle = 0
    do while(.not.converged.and.icycle.lt.ncycle)
       
       do i=1,no
          call intdors(hkl_asym(1:3,i),rsq)
          ff1 = io(i)/IdealWilson(ii)
          sig1 = sigo(i)/IdealWilson(ii0
          
       enddo
       call deigen_filter()

       scale_GS =
       biso_GS = 
       uaniso_GS(1:6) = 
    enddo
  end subroutine scale_aniso_GS

  subroutine scale_aniso_GS_F()

    if(.not.initial_GS_scale) then
       call scale_aniso_GS_init
       initial_scale = .TRUE.
    endif

    np = 2+naniso

    df(1:np) = 0.0d0
    d2f(1:np,1:np) = 0.0d0

    do i=1,nref
       ssq = lstlsq(hkl_asym(1:3,i)
       call linter(ssq,)
       if() then
          write(*,*)'Problem: fix it'
          stop 'Problem'
       endif
       Fo1 = Fobs(i)/fs_GS(ii)
       Fo12 = Fo1**2
       call epslon(1,hkl_asym(1:3,i),epsi)
       call centr(1,hkl_asym(1:3,i),cc)
       df(1) = df(1) + 1/scale_GS - 1/scale_GS**2 *Fo12/(cc*epsi*Sigma_this)
       dfdsigma = 1.0/(cc*Sigma_this) - Fo12/(cc*epsi*Sigma_this)
       df(2) = df(2) -ssq *Sigma_this*dfdsigma 
       do j=1,naniso
          df(2+j) = 
       enddo
       d2f(1,1) 
       d2f(2,2) 
       d2f(1,2) 
       do j=1,naniso
          do k=j,naniso
             d2f(j,k) 
          enddo
          d2f(1,j)
          d2f(2,j)
       enddo
       call deigen()

       !  apply shifts and check for convergence
       scale_GS = 
       Biso_GS = 
       Uaniso_GS(1:6) = 
    enddo

  end subroutine scale_aniso_GS_F

  subroutine convert_F2I(io,fo)

    real, intent(in) :: io(:,:)
    real, intent(out) :: fo(:,:)
    integer nref

    nref = size(io(1,:))
    do ir=1,nref

       if(icent.eq.1) then
          cc  = 2.0
          an0 = -0.5
          an1 = 0.0
          an2 = 0.5
       else
          cc  = 1.0
          an0 = 0.0
          an1 = 0.5
          an1 = 1.0
       endif

       call laplace_t02inf(t0,an0,exp_part0,rem_part0)
       call laplace_t02inf(t0,an1,exp_part1,rem_part1)
       call laplace_t02inf(t0,an2,exp_part2,rem_part2)  
          
       F_exp  = exp(exp_part1-exp_part0)*rem_part1/rem_part0
       F2_exp = exp(exp_part2-exp_part0)*rem_part2/rem_part0       

       fo(1,ir) = F_exp
       fo(2,ir) = sqrt(F2_exp-F_exp**2)
    enddo

  end subroutine convert_F2I
       
  subroutine scale_GS_cleanup
    
    if(allocated(IdealWilson)) deallocate(IdealWislon)

  end subroutine scale_GS_cleanup
 

end module GlebSasha
