module NumIntegrate


contains
  subroutine laplace_t02inf(t0,n,exp_part,rem_part)
    !
    !   integrate int_{-t0}^{infinity} (t+t_0)^n exp(-t^2/2) dt
    !   Result is in two parts. Exponential part and remaining part
    !   Final result have the form exp(-exp_part)*rem_part

    real, intent(in) :: t0,n
    real, intent(out) :: exp_part,rem_part
    !
    !   Locals
    logical recurse_this
    integer k
    real k1,k2,t1,t10,t02,f2prime,tt
    real exp_part1,delta_exp,rem_part1,rem_part3
    real :: pi=4.0*tan(1.0)

    recurse_this = .FALSE.

    k = 0
    t02 = t0**2
    if(t02+4.0*n.lt.0.0) then
       recurse_this = .TRUE.
       k = max(0,int(-t02/4.0-n)+1)
    endif
    k1 = n+float(k)

    if(t0.le.0.0) then
       recurse_this = .TRUE.
       do while(k1.le.0.0)
          k = k + 1
          k1 = n+float(k)
       enddo
    endif
    t1 = (-t0+sqrt(t02+4*k1))/2.0

    t10 = t1+t0
    exp_part = -t1**2+log(t10)
    f2prime = 1+k1/t10**2
    tt = sqrt(f2prime/2.0)*t10
    rem_part = sqrt(pi/(2.0*f2prime))*erfc(-tt)
    !
    !  Use recursion
    !  This recursion is not always stable. So k should be very small.

    if(recurse_this) then
       k2 = k1 + 1.0
       t1 = (-t0+sqrt(t02+4*k2))/2.0
       t10 = t1+t0
       exp_part1 = -t1**2+log(t10)
       f2prime   = 1+k2/t10**2
       tt        = sqrt(f2prime/2.0)*t10
       rem_part1 = sqrt(pi/(2.0*f2prime))*erfc(-tt)
       delta_exp = exp_part1-exp_part
       rem_part1 = rem_part1*exp(-delta_exp)
       exp_part1 = exp_part
       do while(k.gt.0)
          rem_part3 = 1.0/k1*(rem_part1 - t0*rem_part)
          rem_part1 = rem_part
          rem_part  = rem_part3
          k = k-1
          k1 = k1-1.0
       enddo
    endif

    return
  end subroutine laplace_t02inf

  subroutine lablace_t02inf_ratio(t0,n1,n2,res_all)

    real, intent(in) :: t0,n1,n2
    real, intent(out) :: res_all


  end subroutine lablace_t02inf_ratio

end module NumIntegrate
