      SUBROUTINE SET_VTORS(MDOC,I1,I2,I3,I4,NV,NC,IERR)
C -----------------------------------------------
C -P- SET_VANGL - 
C -S-
      INTEGER*4 MDOC,I1,I2,I3,I4,NV,IERR
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
      INTEGER   IRING(4)
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,CHEM4*4,LINE*256
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4,ECHEM4*4
      CHARACTER RING1*3,RING2*3,RING3*3,RING4*3
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------------
      IOBS = 0
      INEW = 0
      IERR = 0
      IF(I1.LE.0 .OR.I2.LE.0 .OR.I3.LE.0 .OR.I4.LE.0 .OR.
     *   I1.EQ.I2.OR.I1.EQ.I3.OR.I1.EQ.I4.OR.I2.EQ.I3.OR.
     *               I2.EQ.I4.OR.I3.EQ.I4 ) RETURN

      IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *   L1A_COOR_FLAG(I3).EQ.'Y'.AND.L1A_COOR_FLAG(I4).EQ.'Y') THEN
        CALL CALC_TRSOBS(I1,I2,I3,I4,ANGOBS)
        IOBS = 1
      ELSE
        ANGOBS = 180.0
      ENDIF

      IF(L1T_NTORS.GE.MAX1TOR) THEN
        WRITE(LINE
     * ,'('' ERROR: number of tors. angles of monomer >'',I6)') 
     *    MAX1TOR
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1TOR in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF

      L1T_NTORS   = L1T_NTORS+1
      L           = L1T_NTORS
      L1T_1ATM(L) = L1A_ANAME(I1)
      L1T_2ATM(L) = L1A_ANAME(I2)
      L1T_3ATM(L) = L1A_ANAME(I3)
      L1T_4ATM(L) = L1A_ANAME(I4)
      L1T_I1ATM(L)= I1
      L1T_I2ATM(L)= I2
      L1T_I3ATM(L)= I3
      L1T_I4ATM(L)= I4
      L1T_VAL(L)  = ANGOBS
      L1T_VOBS(L) = ANGOBS
      L1T_FLAG(L) = 'N'
      IF(IOBS.EQ.1) L1T_FLAG(L) = 'C'
      L1T_DEV (L) = 20.0
      L1T_EVAL(L) = 0.0
      L1T_PRD (L) = 3

      CHEM1 = L1A_CHEM(I1)
      CALL CHECK_RING(CHEM1,RING1)
      CHEM2 = L1A_CHEM(I2)
      CALL CHECK_RING(CHEM2,RING2)
      CHEM3 = L1A_CHEM(I3)
      CALL CHECK_RING(CHEM3,RING3)
      CHEM4 = L1A_CHEM(I4)
      CALL CHECK_RING(CHEM4,RING4)

      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '
      IF(L1A_SYMB(I4).EQ.'H   '.OR.L1A_SYMB(I4).EQ.'D   ') CHEM4='H   '

      DO I=1,LET_NTORS
        ECHEM1 = LET_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LET_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LET_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '
        ECHEM4 = LET_4ATM(I) 
        CALL LENSTR_BL(ECHEM4,LN)
        IF(ECHEM4(1:1).EQ.'H'.AND.LN.GT.2) ECHEM4='H   '

        IF((ECHEM2.EQ.CHEM2.AND.ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM2.EQ.CHEM3.AND.ECHEM3.EQ.CHEM2)) THEN

          L1T_VAL(L) = LET_ANGLE(I) 
          L1T_EVAL(L)= LET_ANGLE(I)
          L1T_PRD(L) = LET_PRD  (I) 

          IF(LET_CONST(I).gt.20.0) THEN
            L1T_LABEL(L) = 'CONST'

            IF(RING2(1:1).EQ.'R'.AND.RING3(1:1).EQ.'R') THEN
              IF(RING2(2:2).EQ.'R'.AND.RING2(2:2).EQ.RING3(2:2)) THEN 
                L1T_VAL(L) = 180.0
                IF(RING2(3:3).EQ.'5'.AND.RING1(2:2).EQ.RING4(2:2)) 
     *          L1T_VAL(L) = 0.0
              ELSE IF(RING2(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING4(1:1).EQ.'R') THEN 
                  L1T_VAL(L) = 180.0
                ELSE
                  L1T_VAL(L) = 0.0
                ENDIF
              ELSE IF(RING3(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING1(1:1).EQ.'R') THEN 
                  L1T_VAL(L) = 180.0
                ELSE
                  L1T_VAL(L) = 0.0
                ENDIF
              ELSE
                IF(RING1(1:1).EQ.RING4(1:1)) THEN 
                  L1T_VAL(L) = 0.0
                ELSE
                  L1T_VAL(L) = 180.0
                ENDIF
              ENDIF
            ENDIF

            L1T_EVAL(L) = L1T_VAL(L)

            IF(IOBS.EQ.1) THEN
              DEL = ABS(L1T_VAL(L)-ANGOBS)
              IF(DEL.GT.90.0.AND.DEL.LT.270.0) THEN
                L1T_VAL(L) = L1T_VAL(L) + 180.0
                IF(L1T_VAL(L).GE.360.0) L1T_VAL(L) = L1T_VAL(L)-360.0
              ENDIF
            ENDIF

            L1T_PRD (L) = 0
          ELSE
c            L1T_VAL(L) = ANGOBS 
          ENDIF
          GO TO 100
        ENDIF

      ENDDO
      L1T_VAL(L) = ANGOBS
 100  CONTINUE

      IF(L1T_EVAL(L).LE.-180.0) L1T_EVAL(L) = L1T_EVAL(L) + 360.0
C --
      ID = 0 
      IF(L1T_PRD(L).NE.0.AND.L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN
          N = 0
          DO  I = 1,L1P_NATOM(IP)
            IATOM = L1P_ATOM(I,IP)
            IF(L1T_1ATM(L).EQ.ATOM) THEN
              N=N+1
              IRING(N) = L1T_I1ATM(L)
            ENDIF
            IF(L1T_2ATM(L).EQ.ATOM) THEN
              N=N+1
              IRING(N) = L1T_I2ATM(L)
            ENDIF
            IF(L1T_3ATM(L).EQ.ATOM) THEN
              N=N+1
              IRING(N) = L1T_I3ATM(L)
            ENDIF
            IF(L1T_4ATM(L).EQ.ATOM) THEN
              N=N+1
              IRING(N) = L1T_I4ATM(L)
            ENDIF
          ENDDO
          IF(N.GE.4) THEN
            L1T_PRD(L) = 0
            GO TO 200
          ELSE IF(N.EQ.3) THEN
            CALL CHECK_RING_ID(MDOC,IRING(1)
     *                        ,IRING(2),IRING(3),IRING(1),ID,PHI,IERR)
            IERR = 0
            IF(ID.GT.1) THEN
              L1T_PRD(L) = 0
              GO TO 200
            ENDIF 
          ENDIF
        ENDDO
      ENDIF
C --
 200  CONTINUE
      IF(L1T_PRD(L).GT.0) THEN
        NV = NV + 1
        WRITE(CHEM1,'(I4)') NV
        N = 4
        IF(CHEM1(1:1).EQ.' ') N=3 
        IF(CHEM1(2:2).EQ.' ') N=2 
        IF(CHEM1(3:3).EQ.' ') N=1 
        LINE(1:4)    = 'var_'
        LINE(5:N+4)  = CHEM1(5-N:4)
        L1T_LABEL(L) = LINE(1:N+4)
      ELSE
        NC = NC + 1
        WRITE(CHEM1,'(I4)') NC
        N = 4
        IF(CHEM1(1:1).EQ.' ') N=3 
        IF(CHEM1(2:2).EQ.' ') N=2 
        IF(CHEM1(3:3).EQ.' ') N=1 
        LINE(1:6) = 'CONST_'
        IF(N.GT.2) N = 2
        LINE(7:N+6)  = CHEM1(5-N:4)
        L1T_LABEL(L) = LINE(1:N+6)
        L1T_DEV (L)  = 0.0
      ENDIF

C     CALL CHECK_RING_ID(MDOC,I1,I2,I3,I4,ID,PHI,IERR)

      IF(LINE(1:5).EQ.'CONST') THEN
        IF(ABS(ID).GT.0) THEN
          L1T_VAL(L) = PHI
          IF(IOBS.EQ.0) L1T_VOBS(L) = PHI
        ENDIF
      ELSE
        IF(IOBS.EQ.0) THEN
          IF(ID.GT.0) THEN
c            L1T_VAL(L)  = PHI
            L1T_VOBS(L) = PHI
C         ENDIF
          ELSE  
            IF(L1T_VAL(L).LT.5.0) THEN
c              L1T_VAL(L) = 5.0          
            ELSE IF(L1T_VAL(L).GT.175.0) THEN
c              L1T_VAL(L) = 175.0          
            ENDIF
          ENDIF
        ENDIF
      ENDIF


      RETURN
      END            

      SUBROUTINE CHECK_RING_ID(MDOC,N1,N2,N3,N4,ID,PHI,IERR)
C -----------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LINE*256
C ---
      INCLUDE 'lib_com.fh' 
C -----------------------------------------------------
      IERR  = 0
      IRING = 0
      NR1  = L1A_NRING(N1)
      NR2  = L1A_NRING(N2)
      NR3  = L1A_NRING(N3)
      NR4  = L1A_NRING(N4)
      ID   = 0
      ID1  = 0
      ID4  = 0
      PHI  = 0.0  
      IFLAT= 0 
C ---
      IF(NR2.GT.0) THEN
        DO I2=1,NR2
          IR2 = L1A_RING_ID(I2,N2) 
          IF(NR3.GT.0) THEN
            DO I3=1,NR3
              IR3 = L1A_RING_ID(I3,N3)
              IF(IR2.EQ.IR3) THEN
                IF(L1A_RING_FLAT(I3,N3).GT.0) IFLAT = 1
                ID = 1
                IF(NR1.GT.0) THEN
                  DO I1=1,NR1
                    IR1 = L1A_RING_ID(I1,N1)
                    IF(IR1.EQ.IR2) THEN
                      ID1 = 1
                      ID  = 2
                      IF(NR4.GT.0) THEN
                        DO I4=1,NR4
                          IR4 = L1A_RING_ID(I4,N4)
                          IF(IR1.EQ.IR4) THEN
                            ID4 = 2
                            ID1 = 2
                            IRING = IR1
                            ID  = 3
                            GO TO 100
                          ENDIF
                        ENDDO
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF

                IF(NR4.GT.0) THEN
                  DO I4=1,NR4
                    IR4 = L1A_RING_ID(I4,N4)
                    IF(IR4.EQ.IR2) THEN
                      ID4 = 1
                      ID  = 2
                      IF(NR1.GT.0) THEN
                        DO I1=1,NR1
                          IR1 = L1A_RING_ID(I1,N1)
                          IF(IR1.EQ.IR4) THEN
                            ID1 = 2
                            ID4 = 2
                            IRING = IR1
                            ID  = 3
                            GO TO 100
                          ENDIF
                        ENDDO
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDIF 
            ENDDO
          ENDIF
        ENDDO
      ENDIF
  100 CONTINUE
      PHI = 0.0
      IF(ID1.EQ.1.OR.ID4.EQ.1) PHI = 180.0
      IF(IFLAT.LE.0) ID = -ID 
C ---
      RETURN
      END

      SUBROUTINE SRCH_BOND(MDOC,MON,I1,I2,VAL,LB,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VAL
      INTEGER*4 MDOC,I1,I2,LB,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
c     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4
      CHARACTER CHEM1*4,CHEM2*4
      CHARACTER ECHEM1*4,ECHEM2*4
C --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
c     M     =-ABS(MDOC)-1
      NBOND = L1B_NBOND
      IF(NBOND.LE.0.OR.I1.LE.0.OR.I2.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      DO J=1,NBOND
        IF((L1B_1ATM(J).EQ.ATOM1.AND.L1B_2ATM(J).EQ.ATOM2).OR.
     *     (L1B_1ATM(J).EQ.ATOM2.AND.L1B_2ATM(J).EQ.ATOM1)) THEN
          VAL = L1B_VAL(J) 
          LB  = J
          GO TO 100
        ENDIF
      ENDDO
      IERR = 2

      CHEM1 = L1A_CHEM(I1)
      CHEM2 = L1A_CHEM(I2)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '

      DO J=1,LEB_NBOND
        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEB_2ATM(J) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2).OR.
     *     (ECHEM1.EQ.CHEM2.AND.ECHEM2.EQ.CHEM1)) THEN
          VAL  = LEB_LENGTH(J) 
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO
      D1 = 0.0
      D2 = 0.0
      DO J=1,LEB_NBOND
        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEB_2ATM(J) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '

        IF(ECHEM1.EQ.CHEM1.AND.ECHEM2(1:1).EQ.'.') THEN
          D1 = LEB_LENGTH(J) 
        ENDIF
        IF(ECHEM1.EQ.CHEM2.AND.ECHEM2(1:1).EQ.'.') THEN
          D2 = LEB_LENGTH(J) 
        ENDIF
      ENDDO
      IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
        VAL  = (D1+D2)/2.0 
        IERR = 3
      ENDIF
 100  CONTINUE

      RETURN
      END

      SUBROUTINE SRCH_ANGL(MDOC,MON,I1,I2,I3,VAL,LG,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VAL
      INTEGER*4 MDOC,I1,I2,I3,LG,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
c     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
      LG    = 0
c     M     =-ABS(MDOC)-1  
      NANGL = L1G_NANGL
      IF(NANGL.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      ATOM3 = L1A_ANAME(I3)
      DO I=1,NANGL
        IF((L1G_1ATM(I).EQ.ATOM1.AND.L1G_2ATM(I).EQ.ATOM2.AND.
     *                               L1G_3ATM(I).EQ.ATOM3).OR.
     *     (L1G_1ATM(I).EQ.ATOM3.AND.L1G_2ATM(I).EQ.ATOM2.AND. 
     *                               L1G_3ATM(I).EQ.ATOM1)) THEN
          VAL = L1G_VAL(I) 
          LG  = I
          GO TO 100
        ENDIF
      ENDDO
      IERR  = 2
      CHEM1 = L1A_CHEM(I1)
      CHEM2 = L1A_CHEM(I2)
      CHEM3 = L1A_CHEM(I3)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '

      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2.AND.
     *                               ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM1.EQ.CHEM3.AND.ECHEM2.EQ.CHEM2.AND. 
     *                               ECHEM3.EQ.CHEM1)) THEN
          VAL  = LEG_ANGLE(I) 
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF(ECHEM1(1:1).EQ.'.'  .AND.
     *     ECHEM2     .EQ.CHEM2.AND.
     *     ECHEM3(1:1).EQ.'.') THEN
          VAL = LEG_ANGLE(I) 
          IF(VAL.GT.0.0) THEN
            IERR = 3
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
 100  CONTINUE
      RETURN
      END

      SUBROUTINE SRCH_ANGL_2(MDOC,MON,I1,I2,I3,VAL,LG,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VAL
      INTEGER*4 MDOC,I1,I2,I3,LG,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
c     M     =-ABS(MDOC)-1  
      NANGL = L2G_NANGL
      IF(NANGL.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L2A_ANAME(I1)
      ATOM2 = L2A_ANAME(I2)
      ATOM3 = L2A_ANAME(I3)
      DO I=1,NANGL
        IF((L2G_1ATM(I).EQ.ATOM1.AND.L2G_2ATM(I).EQ.ATOM2.AND.
     *                               L2G_3ATM(I).EQ.ATOM3).OR.
     *     (L2G_1ATM(I).EQ.ATOM3.AND.L2G_2ATM(I).EQ.ATOM2.AND. 
     *                               L2G_3ATM(I).EQ.ATOM1)) THEN
          VAL = L2G_VAL(I) 
          LG  = I
          GO TO 100
        ENDIF
      ENDDO
      IERR  = 2
      CHEM1 = L2A_CHEM(I1)
      CHEM2 = L2A_CHEM(I2)
      CHEM3 = L2A_CHEM(I3)
      IF(L2A_SYMB(I1).EQ.'H   '.OR.L2A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L2A_SYMB(I2).EQ.'H   '.OR.L2A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L2A_SYMB(I3).EQ.'H   '.OR.L2A_SYMB(I3).EQ.'D   ') CHEM3='H   '

      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2.AND.
     *                               ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM1.EQ.CHEM3.AND.ECHEM2.EQ.CHEM2.AND. 
     *                               ECHEM3.EQ.CHEM1)) THEN
          VAL  = LEG_ANGLE(I) 
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF(ECHEM1(1:1).EQ.'.'  .AND.
     *     ECHEM2     .EQ.CHEM2.AND.
     *     ECHEM3(1:1).EQ.'.') THEN
          VAL = LEG_ANGLE(I) 
          IF(VAL.GT.0.0) THEN
            IERR = 3
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
 100  CONTINUE
      RETURN
      END

      SUBROUTINE SRCH_ANGL_L(MDOC,MON,I1,I2,I3,IF1,IF2,IF3,VAL,LG,IERR)
C -----------------------------------------------
C      1 -- 2 --- 3
C   IF1=2      ! IF3=1
C        IF2=2 !

      REAL      VAL
      INTEGER*4 MDOC,I1,I2,I3,LG,IERR,IF1,IF2,IF3
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
c     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
c     M     =-ABS(MDOC)-1  
      NANGL = LLG_NANGL
      IF(NANGL.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      IF(IF1.EQ.1) THEN
        JF1   = 2
        ATOM1 = L1A_ANAME(I1)
      ELSE
        JF1   = 1
        ATOM1 = L2A_ANAME(I1)
      ENDIF
      IF(IF2.EQ.1) THEN
        JF2   = 2
        ATOM2 = L1A_ANAME(I2)
      ELSE
        JF2   = 1
        ATOM2 = L2A_ANAME(I2)
      ENDIF
      IF(IF3.EQ.1) THEN
        JF3   = 2
        ATOM3 = L1A_ANAME(I3)
      ELSE
        JF3   = 1
        ATOM3 = L2A_ANAME(I3)
      ENDIF
      DO I=1,NANGL
        IF((LLG_1ATM(I) .EQ.ATOM1.AND.LLG_2ATM(I) .EQ.ATOM2.AND.
     *      LLG_F1ATM(I).EQ.JF1  .AND.LLG_F2ATM(I).EQ.JF2  .AND.
     *      LLG_F3ATM(I).EQ.JF3  .AND.LLG_3ATM(I) .EQ.ATOM3     ).OR.
     *     (LLG_1ATM(I) .EQ.ATOM3.AND.LLG_2ATM(I) .EQ.ATOM2.AND. 
     *      LLG_F1ATM(I).EQ.JF3  .AND.LLG_F2ATM(I).EQ.JF2  .AND.
     *      LLG_F3ATM(I).EQ.JF1  .AND.LLG_3ATM(I) .EQ.ATOM1     )) THEN
          VAL = LLG_VAL(I) 
          LG  = I
          GO TO 100
        ENDIF
      ENDDO
      IERR  = 2
      IF(IF1.EQ.1) THEN
        CHEM1 = L1A_CHEM(I1)
        IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ')CHEM1='H   '
      ELSE
        CHEM1 = L2A_CHEM(I1)
        IF(L2A_SYMB(I1).EQ.'H   '.OR.L2A_SYMB(I1).EQ.'D   ')CHEM1='H   '
      ENDIF
      IF(IF2.EQ.1) THEN
        CHEM2 = L1A_CHEM(I2)
        IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ')CHEM2='H   '
      ELSE
        CHEM2 = L2A_CHEM(I2)
        IF(L2A_SYMB(I2).EQ.'H   '.OR.L2A_SYMB(I2).EQ.'D   ')CHEM2='H   '
      ENDIF
      IF(IF3.EQ.1) THEN
        CHEM3 = L1A_CHEM(I3)
        IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ')CHEM3='H   '
      ELSE
        CHEM3 = L2A_CHEM(I3)
        IF(L2A_SYMB(I3).EQ.'H   '.OR.L2A_SYMB(I3).EQ.'D   ')CHEM3='H   '
      ENDIF

      DO I=1,LEG_NANGL

        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2.AND.
     *                               ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM1.EQ.CHEM3.AND.ECHEM2.EQ.CHEM2.AND. 
     *                               ECHEM3.EQ.CHEM1)) THEN
          VAL  = LEG_ANGLE(I) 
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,LEG_NANGL

        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF(ECHEM1(1:1).EQ.'.'  .AND.
     *     ECHEM2     .EQ.CHEM2.AND.
     *     ECHEM3(1:1).EQ.'.') THEN
          VAL = LEG_ANGLE(I) 
          IF(VAL.GT.0.0) THEN
            IERR = 3
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
 100  CONTINUE
      RETURN
      END

      SUBROUTINE SRCH_TORS(MDOC,MON,I1,I2,I3,I4,VAL,LT,INV,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VAL
      INTEGER*4 MDOC,I1,I2,I3,I4,LT,INV,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
C     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,ATOM4*4
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,CHEM4*4
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4,ECHEM4*4
      CHARACTER RING1*3,RING2*3,RING3*3,RING4*3
C     CHARACTER LABEL*8
CC --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
      INV   = 1
C     M     =-ABS(MDOC)-1  
      NTORS = L1T_NTORS
      IF(NTORS.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0.OR.I4.LE.0) 
     *THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      ATOM3 = L1A_ANAME(I3)
      ATOM4 = L1A_ANAME(I4)
      DO I=1,NTORS
        IF(L1T_2ATM(I).EQ.ATOM2.AND.L1T_3ATM(I).EQ.ATOM3) THEN
          IF(L1T_1ATM(I).EQ.ATOM1.AND.L1T_4ATM(I).EQ.ATOM4) THEN
            VAL = L1T_VAL(I) 
            LT  = I
            INV = 1
            GO TO 100
          ENDIF
        ELSE IF(L1T_2ATM(I).EQ.ATOM3.AND.L1T_3ATM(I).EQ.ATOM2) THEN
          IF(L1T_1ATM(I).EQ.ATOM4.AND.L1T_4ATM(I).EQ.ATOM1) THEN
            VAL = L1T_VAL(I) 
            LT  = I
            INV =-1
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
      IERR=2

C      IPRD =L1T_PRD (L)
C      VAL  =L1T_VAL (L)
C      LABEL=L1T_LABEL(L)

      CHEM1 = L1A_CHEM(I1)
      CALL CHECK_RING(CHEM1,RING1)
      CHEM2 = L1A_CHEM(I2)
      CALL CHECK_RING(CHEM2,RING2)
      CHEM3 = L1A_CHEM(I3)
      CALL CHECK_RING(CHEM3,RING3)
      CHEM4 = L1A_CHEM(I4)
      CALL CHECK_RING(CHEM4,RING4)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '
      IF(L1A_SYMB(I4).EQ.'H   '.OR.L1A_SYMB(I4).EQ.'D   ') CHEM4='H   '


      DO I=1,LET_NTORS
        ECHEM1 = LET_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LET_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LET_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '
        ECHEM4 = LET_4ATM(I) 
        CALL LENSTR_BL(ECHEM4,LN)
        IF(ECHEM4(1:1).EQ.'H'.AND.LN.GT.2) ECHEM4='H   '

        IF((ECHEM2.EQ.CHEM2.AND.ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM2.EQ.CHEM3.AND.ECHEM3.EQ.CHEM2)) THEN
          VAL  = LET_ANGLE(I) 
          IPRD = LET_PRD  (I) 
          IF(LET_CONST(I).GT.2.0) THEN

C            LABEL  ='CONST'

            IPRD = 0
            IF(RING2(1:1).EQ.'R'.AND.RING3(1:1).EQ.'R') THEN
              IF(RING2(2:2).EQ.'R'.AND.RING2(2:2).EQ.RING3(2:2)) THEN 
                VAL = 180.0
                IF(RING2(3:3).EQ.'5'.AND.RING1(2:2).EQ.RING4(2:2)) 
     *          VAL = 0.0
              ELSE IF(RING2(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING4(1:1).EQ.'R') THEN 
                  VAL = 180.0
                ELSE
                  VAL = 0.0
                ENDIF
              ELSE IF(RING3(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING1(1:1).EQ.'R') THEN 
                  VAL = 180.0
                ELSE
                  VAL = 0.0
                ENDIF
              ELSE
                IF(RING1(1:1).EQ.RING4(1:1)) THEN 
                  VAL = 0.0
                ELSE
                  VAL = 180.0
                ENDIF
              ENDIF
            ENDIF
            
          ELSE

          ENDIF
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO

 100  CONTINUE

      RETURN
      END

      SUBROUTINE SRCH_CHIR(MDOC,MON,I1,I2,I3,I4,VOL,LC,IS,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VOL
      INTEGER*4 MDOC,I1,I2,I3,I4,LC,IS,IERR
      CHARACTER MON*8,SIGN*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
C     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,ATOM4*4
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1       
      IERR  = 0
      LC    = 0
      NCHIR = L1C_NCHIR
      IF(NCHIR.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0.OR.I4.LE.0) 
     *THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      ATOM3 = L1A_ANAME(I3)
      ATOM4 = L1A_ANAME(I4)
      DO I=1,NCHIR
        IF(L1C_1ATM(I).EQ.ATOM1.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *     L1C_SIGN(I)(1:4).NE.'cros'     ) THEN

          IF((L1C_2ATM(I).EQ.ATOM2.AND.L1C_3ATM(I).EQ.ATOM3.AND.
     *        L1C_4ATM(I).EQ.ATOM4).OR.
     *       (L1C_3ATM(I).EQ.ATOM2.AND.L1C_4ATM(I).EQ.ATOM3.AND.
     *        L1C_2ATM(I).EQ.ATOM4).OR.
     *       (L1C_4ATM(I).EQ.ATOM2.AND.L1C_2ATM(I).EQ.ATOM3.AND.
     *        L1C_3ATM(I).EQ.ATOM4) ) THEN
            VOL  = L1C_VOL(I) 
            SIGN = L1C_SIGN(I) 
            IF(SIGN(1:4).EQ.'both') THEN
              IF(L1C_FLAG(I).EQ.'R') SIGN = 'positiv'
              IF(L1C_FLAG(I).EQ.'L') SIGN = 'negativ'
            ENDIF
            LC   = I
            IS   = 1
            IF(SIGN(1:3).EQ.'neg') IS =-1
            GO TO 100
          ELSE IF((L1C_3ATM(I).EQ.ATOM2.AND.L1C_2ATM(I).EQ.ATOM3.AND.
     *        L1C_4ATM(I).EQ.ATOM4).OR.
     *       (L1C_2ATM(I).EQ.ATOM2.AND.L1C_4ATM(I).EQ.ATOM3.AND.
     *        L1C_3ATM(I).EQ.ATOM4).OR.
     *       (L1C_4ATM(I).EQ.ATOM2.AND.L1C_3ATM(I).EQ.ATOM3.AND.
     *        L1C_2ATM(I).EQ.ATOM4)) THEN
            VOL  = L1C_VOL(I) 
            SIGN = L1C_SIGN(I) 
            IF(SIGN(1:4).EQ.'both') THEN
              IF(L1C_FLAG(I).EQ.'R') SIGN = 'positiv'
              IF(L1C_FLAG(I).EQ.'L') SIGN = 'negativ'
            ENDIF
            LC   = I
            IS   = 1
            IF(SIGN(1:3).EQ.'neg') IS =-1
            IS = IS*(-1)
            GO TO 100
          ENDIF

        ENDIF
      ENDDO
      IERR = 2
C ---------------------------------------
 100  CONTINUE
      RETURN
      END

      SUBROUTINE SRCH_CHIR_CENTRE(MDOC,MON,I1,LC,IERR)
C -----------------------------------------------
C -P- 
C -S-
C     REAL      VOL
      INTEGER*4 MDOC,I1,LC,IERR
C     INTEGER*4 I2,I3,I4,IS
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER ATOM1*4
C     CHARACTER ATOM2*4,ATOM3*4,ATOM4*4,SIGN*8
C     CHARACTER LINE*256
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1  
      IERR  = 0
      NCHIR = L1C_NCHIR
      IF(NCHIR.LE.0.OR.I1.LE.0) THEN
        LC = 0
        RETURN
      ENDIF

      ATOM1 = L1A_ANAME(I1)
      DO I=1,NCHIR
        IF(L1C_1ATM(I).EQ.ATOM1.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *     L1C_SIGN(I)(1:4).NE.'cros'     ) THEN
          LC = I
          RETURN
        ENDIF
      ENDDO
      LC = 0
C ---------------------------------------
      RETURN
      END


      SUBROUTINE SRCH_CHIR_CENTRE_L(MDOC,LINK,ATOM,LC,IERR)
C -----------------------------------------------
C -P- 
C -S-
C     REAL      VOL
      INTEGER*4 MDOC,LC,IERR
C     INTEGER*4 I1,I2,I3,I4,IS
      CHARACTER LINK*8
C     CHARACTER SIGN*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER ATOM*4
C     CHARACTER LINE*80
C
C    *,LLC_VOL,LLC_NCHIR,LLC_F1ATM,LLC_F2ATM,LLC_F3ATM,LLC_F4ATM
C    *,LLC_1ATM,LLC_2ATM,LLC_3ATM,LLC_4ATM,LLC_LNAME,LLC_SIGN
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1  
      IERR  = 0
      NCHIR = LLC_NCHIR
      IF(NCHIR.LE.0) THEN
        LC = 0
        RETURN
      ENDIF

      DO I=1,NCHIR
        IF(LINK.EQ.LLL_LNAME(I).AND.LLC_1ATM(I).EQ.ATOM.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *     L1C_SIGN(I)(1:4).NE.'cros'     ) THEN
          LC = I
          RETURN
        ENDIF
      ENDDO
      LC = 0
C ---------------------------------------
      RETURN
      END

      SUBROUTINE SRCH_CHIR_CENTRE_2(MDOC,ATOM,LC
     *  ,ATOM2,ATOM3,ATOM4,IS,IERR)
C -----------------------------------------------
C -P- 
C -S-
      INTEGER*4 MDOC,LC,IS,IERR
C     INTEGER*4 I1,I2,I3,I4
      CHARACTER SIGN*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER ATOM*4,ATOM2*4,ATOM3*4,ATOM4*4
C     CHARACTER LINE*256
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1  
      IERR  = 0
      NCHIR = L2C_NCHIR
      IF(NCHIR.LE.0) THEN
        LC = 0
        RETURN
      ENDIF

      DO I=1,NCHIR
        IF(L2C_1ATM(I).EQ.ATOM.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *     L1C_SIGN(I)(1:4).NE.'cros'     ) THEN
          LC    = I
          ATOM2 = L2C_2ATM(I)
          ATOM3 = L2C_3ATM(I)
          ATOM4 = L2C_4ATM(I)
          SIGN  = L2C_SIGN(I) 
          IS    = 0
          IF(SIGN(1:3).EQ.'pos') IS = 1
          IF(SIGN(1:3).EQ.'neg') IS =-1
          RETURN
        ENDIF
      ENDDO
      LC = 0
C ---------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_RING(TYPE,RING)
C -----------------------------------------------
C -P-  - 
C -S-
C ******
      CHARACTER TYPE*4
      CHARACTER RING*3
C --------------------------------------------------------
      IF(TYPE(1:3).EQ.'CR5'.OR.TYPE.EQ.'CR15'.OR.TYPE.EQ.'NRD5'.OR.
     *   TYPE(1:3).EQ.'NR5'.OR.TYPE.EQ.'NR15') THEN
        RING = 'R5 '
      ELSE IF(TYPE.EQ.'NR16'.OR.TYPE.EQ.'CR16'.OR.TYPE.EQ.'NRD6'.OR.
     *     TYPE(1:3).EQ.'NR6'.OR.TYPE(1:3).EQ.'CR6') THEN
        RING = 'R6 '
      ELSE IF(TYPE.EQ.'CR66'.OR.TYPE.EQ.'NR66') THEN
        RING = 'RR6'
      ELSE IF(TYPE.EQ.'CR56'.OR.TYPE.EQ.'NR56') THEN
        RING = 'RR5'
      ELSE IF(TYPE.EQ.'CR55'.OR.TYPE.EQ.'NR55') THEN
        RING = 'RRR'
      ELSE
        RING = 'N  '
      ENDIF
      RETURN
      END

      SUBROUTINE SRCH_PLAN(MDOC,MON,I1,I2,I3,I4,LP,IERR)
C -----------------------------------------------
C 
C 
      INTEGER*4 MDOC,IERR
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,ATOM4*4,MON*8
C ---
      INCLUDE 'lib_com.fh'
C ---
C     REAL      DOBS    (MAX1APL)
C     INTEGER*4 IATM    (MAX1APL)
C     INTEGER*4 JATM    (MAX1APL)
C     CHARACTER LINE*256
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1  
      IERR  = 0
      NPLAN = L1P_NPLAN
      LP    = 0
      IF(NPLAN.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0.OR.I4.LE.0) 
     *THEN
        IERR = 1
        RETURN
      ENDIF

      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      ATOM3 = L1A_ANAME(I3)
      ATOM4 = L1A_ANAME(I4)

      DO  IP=1,NPLAN
        IF(L1P_NATOM(IP).GE.4) THEN
          N = 0
          DO  I = 1,L1P_NATOM(IP)
            IATOM  = L1P_ATOM(I,IP)
            IF(ATOM.EQ.ATOM1) N = N + 1
            IF(ATOM.EQ.ATOM2) N = N + 1
            IF(ATOM.EQ.ATOM3) N = N + 1
            IF(ATOM.EQ.ATOM4) N = N + 1
          ENDDO
          IF(N.GE.4) THEN
            LP = IP
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
  100 CONTINUE
      RETURN
      END

C ******
      SUBROUTINE PLAN_RSTR(MDOC,IERR)
C -----------------------------------------------
C -P- PLAN_RSTR -
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
      REAL      DOBS    (MAX1APL)
      INTEGER*4 IATM    (MAX1APL)
      INTEGER*4 JATM    (MAX1APL)
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------------
      IERR = 0
      IF(L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN
          IF(L1P_NATOM(IP).GE.4) THEN
            N = 0
            DO  I = 1,L1P_NATOM(IP)
              IATOM          = L1P_ATOM(I,IP)
              L1P_DOBS(I,IP) = 0.0
              DO  J = 1,L1A_NATOM
                IF(ATOM.EQ.L1A_ANAME(J)) THEN
                  IF(L1A_COOR_FLAG(J).EQ.'Y') THEN
                    N       = N + 1
                    IATM(N) = J
                    JATM(N) = I 
                  ENDIF
                  GO TO 100  
                ENDIF
              ENDDO
  100         CONTINUE
            ENDDO 
            IF(N.GE.4) THEN
              CALL CALC_PLDEV(N,IATM,DOBS)
              DO J=1,N
                JJ              = JATM(J)
                L1P_DOBS(JJ,IP) = DOBS(J)
              ENDDO
            ENDIF
          ENDIF
        ENDDO
      ENDIF
      RETURN
      END


C ******
      SUBROUTINE CALC_DOBS(I1,I2,DOBS)
C -----------------------------------------------
C -P- CALC_DOBS - 
C -S-
      REAL      DOBS
      INTEGER*4 I1,I2
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      DOBS = 0.0
      IF(I1.LE.0.OR.I2.LE.0) RETURN
      X1   = L1A_X(I1)
      Y1   = L1A_Y(I1)
      Z1   = L1A_Z(I1)
      X2   = L1A_X(I2)
      Y2   = L1A_Y(I2)
      Z2   = L1A_Z(I2)
      DX   = X1-X2
      DY   = Y1-Y2
      DZ   = Z1-Z2

      DOBS = SQRT(ABS(DX*DX+DY*DY+DZ*DZ))

      RETURN
      END

C ******
      SUBROUTINE CALC_ANGOBS(I1,I2,I3,ANGOBS)
C -----------------------------------------------
C -P- CALC_ANGOBS - 
C -S-
C                         IA1        IA2      IA3
C               I3 - 1 -> I2  - 2 -> I1 - 3 -> I
      REAL      ANGOBS
      INTEGER*4 I1,I2,I3
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------
      ANGOBS = 0.0
      IF(I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) RETURN
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      X1 = L1A_X(I1)
      Y1 = L1A_Y(I1)
      Z1 = L1A_Z(I1)
      X2 = L1A_X(I2)
      Y2 = L1A_Y(I2)
      Z2 = L1A_Z(I2)
      X3 = L1A_X(I3)
      Y3 = L1A_Y(I3)
      Z3 = L1A_Z(I3)

      A3 = X3-X2
      B3 = Y3-Y2
      C3 = Z3-Z2

      IF(I1.EQ.0) THEN
        A2 = 1.
        B2 = 0.
        C2 = 0.
      ELSE
        A2 = X2-X1
        B2 = Y2-Y1
        C2 = Z2-Z1
      ENDIF

      AMOD   = SQRT(A2*A2+B2*B2+C2*C2)*SQRT(ABS(A3*A3+B3*B3+C3*C3))
      T      = AMOD
      IF(T.LT.1.0E-8) T = 1.0
      COST   = (A3*A2+B3*B2+C3*C2)/T
      IF(COST.GT. 1.0) COST = 1.0
      IF(COST.LT.-1.0) COST =-1.0
      ANGOBS = ACOS(COST)
      ANGOBS = PI-ANGOBS
C ???
      IF(ANGOBS.GT. PI) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LT.-PI) ANGOBS = ANGOBS + TWOPI
      ANGOBS = ANGOBS/PI180

      RETURN
      END

      SUBROUTINE CALC_TRSOBS(I1,I2,I3,I4,ANGOBS)
C -----------------------------------------------
C -P- CALC_TRSOBS - 
C -S-
C              IA1        IA2        IA3      IA4
C               I3 - 1 -> I2  - 2 -> I1 - 3 -> I
C ---
      REAL      ANGOBS
      INTEGER*4 I1,I2,I3,I4
C ---
      REAL    V1(3),V2(3)      
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------
      ANGOBS = 0.0
      IF(I3.LE.0.OR.I4.LE.0) RETURN
      PI     = 4.0*ATAN(1.0)
      TWOPI  = 2.0*PI
      PI180  = PI/180.0
C ---
      X3  = L1A_X(I3)
      Y3  = L1A_Y(I3)
      Z3  = L1A_Z(I3)
      X4  = L1A_X(I4)
      Y4  = L1A_Y(I4)
      Z4  = L1A_Z(I4)
      II2 = I2 
      II1 = I1
 100  CONTINUE
      IF(II2.GT.0) THEN
        X2 = L1A_X(II2)
        Y2 = L1A_Y(II2)
        Z2 = L1A_Z(II2)
        IF(II1.GT.0) THEN 
          X1 = L1A_X(II1)
          Y1 = L1A_Y(II1)
          Z1 = L1A_Z(II1)
        ELSE
          X1 =-1.
          Y1 = 0.
          Z1 = 0.
        ENDIF
      ELSE
        X2 =-1.
        Y2 = 0.
        Z2 = 0.
        X1 =-1.
        Y1 = 1.
        Z1 = 0.
      ENDIF
      V1(1) = X2-X1
      V1(2) = Y2-Y1
      V1(3) = Z2-Z1
      V2(1) = X3-X2
      V2(2) = Y3-Y2
      V2(3) = Z3-Z2
      CALL NB_VMOD(V1,AV1)
      CALL NB_VMOD(V2,AV2)
      CALL NB_VPROD(V1,V2,S)
      COSA1 = S/(AV1*AV2)
      ANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
      ANG1  = PI-ANG1
C     10 grad = 0.175
      D    = PI - 0.175/2.0                                 
      IF(ANG1.GT.D.AND.II2.GT.0) THEN
        IB = L1A_IBACK(II2)
        IF(IB.GT.0) THEN
          II1 = L1A_IBACK(IB)
        ELSE
          II1 = 0
        ENDIF
        II2 = IB
        GO TO 100
      ENDIF
      A3   = X4-X3
      B3   = Y4-Y3
      C3   = Z4-Z3
      A2   = X3-X2
      B2   = Y3-Y2
      C2   = Z3-Z2
      A1   = X2-X1
      B1   = Y2-Y1
      C1   = Z2-Z1
      DN1X = B1*C2-B2*C1
      DN1Y = A1*C2-A2*C1
      DN1Z = A1*B2-A2*B1
      DN2X = B2*C3-B3*C2
      DN2Y = A2*C3-A3*C2
      DN2Z = A2*B3-A3*B2
      E1   = DN1X*DN2X+DN1Y*DN2Y+DN1Z*DN2Z
      E2   = SQRT(ABS(DN1X*DN1X+DN1Y*DN1Y+DN1Z*DN1Z))
      E3   = SQRT(ABS(DN2X*DN2X+DN2Y*DN2Y+DN2Z*DN2Z))
      IF(E2.LT.1.E-9.OR.E3.LT.1.E-9) THEN
        IF(E1.GE.0.) COSG = 1.
        IF(E1.LT.0.) COSG =-1.
      ELSE
        T    = E2*E3
        IF(T.LT.1.0E-8) T = 1.0
        COSG = E1/T
      ENDIF
C---------------NOW WE ARE CALCULATING MIXED VECTORS------------------
C-----ABC=A1*(B2*C3-B3*C2)-A2*(B1*C3-B3*C1)+A3*(B1*C2-B2*C1) !-------
C------------------------------------------------------------------
      ABC    = A1*DN2X-A2*(B1*C3-B3*C1)+A3*DN1X
      SS     = ABS(1.0 - COSG*COSG)
      SING   = SIGN(1.0,ABC)*SQRT(SS)
      ANGOBS = ATAN2(SING,COSG)
C ???
      IF(ANGOBS.GT. PI) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LE.-PI) ANGOBS = ANGOBS + TWOPI
      ANGOBS = ANGOBS/PI180

      RETURN
      END

C ******
      SUBROUTINE CALC_OVOL(IC,VOLOBS,IERR)
C -----------------------------------------------
C -P- CALC_VOL - 
C -S-
C                                V2 -> I3       A3  /
C               I2 - V1 -> I1  <              -----<  A1 
C                                V3 -> I4       A2  \
C
      REAL      VOLOBS
      INTEGER*4 IC
C ---
      INCLUDE 'lib_com.fh'
C ******
      REAL A(9)
      INTEGER*4 I1,I2,I3,I4
      CHARACTER NAME*4
C ---------------------------------------
      IERR   = 1
      VOLOBS = 0.0
      IF(IC.LE.0) RETURN
      IF(L1C_SIGN(IC)(1:4).EQ.'star'.OR.
     *   L1C_SIGN(IC)(1:4).EQ.'cros'     ) RETURN

      NAME   = L1C_1ATM(IC)
      DO I=1,L1A_NATOM
        IF(NAME.EQ.L1A_ANAME(I)) THEN
          I1            = I
          L1C_I1ATM(IC) = I
          GO TO 100
        ENDIF
      ENDDO
      RETURN
  100 CONTINUE    
      IF(L1A_COOR_FLAG(I1).EQ.'N') RETURN

      NAME = L1C_2ATM(IC)
      DO I=1,L1A_NATOM
        IF(NAME.EQ.L1A_ANAME(I)) THEN
          I2            = I
          L1C_I2ATM(IC) = I
          GO TO 110
        ENDIF
      ENDDO
      RETURN
  110 CONTINUE    
      IF(L1A_COOR_FLAG(I2).EQ.'N') RETURN

      NAME = L1C_3ATM(IC)
      DO I=1,L1A_NATOM
        IF(NAME.EQ.L1A_ANAME(I)) THEN
          I3            = I
          L1C_I3ATM(IC) = I
          GO TO 120
        ENDIF
      ENDDO
      RETURN
  120 CONTINUE    
      IF(L1A_COOR_FLAG(I3).EQ.'N') RETURN

      NAME = L1C_4ATM(IC)
      DO I=1,L1A_NATOM
        IF(NAME.EQ.L1A_ANAME(I)) THEN
          I4            = I
          L1C_I4ATM(IC) = I
          GO TO 130
        ENDIF
      ENDDO
      RETURN
  130 CONTINUE    
      IF(L1A_COOR_FLAG(I4).EQ.'N') RETURN
      IERR = 0

      A(1) = L1A_X(I2)-L1A_X(I1)
      A(4) = L1A_Y(I2)-L1A_Y(I1)
      A(7) = L1A_Z(I2)-L1A_Z(I1)
      A(2) = L1A_X(I3)-L1A_X(I1)
      A(5) = L1A_Y(I3)-L1A_Y(I1)
      A(8) = L1A_Z(I3)-L1A_Z(I1)
      A(3) = L1A_X(I4)-L1A_X(I1)
      A(6) = L1A_Y(I4)-L1A_Y(I1)
      A(9) = L1A_Z(I4)-L1A_Z(I1)
      VOLOBS = A(1)*(A(5)*A(9)-A(8)*A(6))
     *       - A(4)*(A(2)*A(9)-A(8)*A(3))
     *       + A(7)*(A(2)*A(6)-A(5)*A(3))

       
C     L1C_FLAG(IC)='C'

      RETURN
      END

C ******
      SUBROUTINE CALC_IVOL(IC,VOLIDL,PH1,PH2,PH3)
C -----------------------------------------------
C -P- CALC_IIVOL - 
C -S-                                           PH3    I3
C                                V2 -> I3        A3   /    
C               I2 - V1 -> I1  <             I2 -----<  A1  PH1 
C                                V3 -> I4        A2   \    
C                                               PH2    I4  
C       
      REAL      VOLIDL
      INTEGER*4 IC
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      IF(L1C_SIGN(IC)(1:4).EQ.'star'.OR.
     *   L1C_SIGN(IC)(1:4).EQ.'cros'     ) GO TO 1000

      I1    = 0
      I2    = 0
      I3    = 0

      IF(L1B_NBOND.GT.0.AND.L1G_NANGL.GT.0) THEN

        DO  IB=1,L1B_NBOND
          IF(I1.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.L1C_1ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_2ATM(IC)).OR.
     *         (L1B_1ATM(IB).EQ.L1C_2ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_1ATM(IC))    ) THEN
              V1 = L1B_VAL(IB)
              I1 = 1
            ENDIF  
          ENDIF  
          IF(I2.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.L1C_1ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_3ATM(IC)).OR.
     *         (L1B_1ATM(IB).EQ.L1C_3ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_1ATM(IC))    ) THEN
              V2 = L1B_VAL(IB)
              I2 = 1
            ENDIF  
          ENDIF  
          IF(I3.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.L1C_1ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_4ATM(IC)).OR.
     *         (L1B_1ATM(IB).EQ.L1C_4ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_1ATM(IC))    ) THEN
              V3 = L1B_VAL(IB)
              I3 = 1
            ENDIF  
          ENDIF  
          IF(I1.EQ.1.AND.I2.EQ.1.AND.I3.EQ.1) GO TO 100 
        ENDDO
        GO TO 1000

  100   CONTINUE                    

        I1 = 0
        I2 = 0
        I3 = 0
        DO  IG=1,L1G_NANGL
          IF(I1.EQ.0) THEN
            IF(L1G_1ATM(IG).EQ.L1C_3ATM(IC) .OR.
     *         L1G_1ATM(IG).EQ.L1C_4ATM(IC))  THEN
              IF(L1G_2ATM(IG).EQ.L1C_1ATM(IC)) THEN
                IF(L1G_3ATM(IG).EQ.L1C_3ATM(IC) .OR.
     *             L1G_3ATM(IG).EQ.L1C_4ATM(IC))  THEN
                  A1 = L1G_VAL(IG)*PI180
                  I1 = 1
                ENDIF
              ENDIF
            ENDIF  
          ENDIF  
          IF(I2.EQ.0) THEN
            IF(L1G_1ATM(IG).EQ.L1C_2ATM(IC) .OR.
     *         L1G_1ATM(IG).EQ.L1C_4ATM(IC))  THEN
              IF(L1G_2ATM(IG).EQ.L1C_1ATM(IC)) THEN
                IF(L1G_3ATM(IG).EQ.L1C_2ATM(IC) .OR.
     *             L1G_3ATM(IG).EQ.L1C_4ATM(IC))  THEN
                  A2 = L1G_VAL(IG)*PI180
                  I2 = 1
                ENDIF
              ENDIF
            ENDIF  
          ENDIF  
          IF(I3.EQ.0) THEN
            IF(L1G_1ATM(IG).EQ.L1C_2ATM(IC) .OR.
     *         L1G_1ATM(IG).EQ.L1C_3ATM(IC))  THEN
              IF(L1G_2ATM(IG).EQ.L1C_1ATM(IC))THEN
                IF(L1G_3ATM(IG).EQ.L1C_2ATM(IC) .OR.
     *             L1G_3ATM(IG).EQ.L1C_3ATM(IC))  THEN
                  A3 = L1G_VAL(IG)*PI180
                  I3 = 1
                ENDIF
              ENDIF
            ENDIF  
          ENDIF  
          IF(I1.EQ.1.AND.I2.EQ.1.AND.I3.EQ.1) GO TO 200 
        ENDDO
        GO TO 1000
  200   CONTINUE                    




        COA1 = COS(A1)
        COA2 = COS(A2)
        COA3 = COS(A3)

        VOLIDL=V1*V2*V3*
     *       SQRT(ABS(1.-COA1**2-COA2**2-COA3**2+2.*COA1*COA2*COA3))

        CALL GET_TORS(A3,A2,A1,PH1)
        CALL GET_TORS(A1,A3,A2,PH2)
        CALL GET_TORS(A2,A1,A3,PH3)

        IF(PH1.GT. PI) PH1 = PH1 - TWOPI
        IF(PH1.LT.-PI) PH1 = PH1 + TWOPI
        PH1 = PH1/PI180
        IF(PH2.GT. PI) PH2 = PH2 - TWOPI
        IF(PH2.LT.-PI) PH2 = PH2 + TWOPI
        PH2 = PH2/PI180
        IF(PH3.GT. PI) PH3 = PH3 - TWOPI
        IF(PH3.LT.-PI) PH3 = PH3 + TWOPI
        PH3 = PH3/PI180

        RETURN
      ENDIF

 1000 CONTINUE

      VOLIDL = 0.0
      PH1    = 0.0
      PH2    = 0.0
      PH3    = 0.0
      RETURN
      END

      SUBROUTINE CALC_I_OVOL_L(I1,I2,I3,I4,XX1,XX2,XX3,XX4
     * ,VOLOBS,PH)
C -----------------------------------------------
C -P- CALC_I_OVOL_L - 
C -S-
C                                V2 -> I3 
C               I2 - V1 -> I1  < 
C                                V3 -> I4 
C
      REAL      VOLOBS
      REAL      XX1(3),XX2(3),XX3(3),XX4(3)
      INTEGER*4 I1,I2,I3,I4
C ---
C ******
      REAL A(9)
      REAL  V1(3),V2(3),V3(3),VT(3),V12(3),V13(3)
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C ---------------------------------------
      A(1) = XX2(1)-XX1(1)
      A(4) = XX2(2)-XX1(2)
      A(7) = XX2(3)-XX1(3)
      A(2) = XX3(1)-XX1(1)
      A(5) = XX3(2)-XX1(2)
      A(8) = XX3(3)-XX1(3)
      A(3) = XX4(1)-XX1(1)
      A(6) = XX4(2)-XX1(2)
      A(9) = XX4(3)-XX1(3)

      VOLOBS = A(1)*(A(5)*A(9)-A(8)*A(6))
     *       - A(4)*(A(2)*A(9)-A(8)*A(3))
     *       + A(7)*(A(2)*A(6)-A(5)*A(3))

      PH = 0.0
      V1(1) = XX1(1) - XX2(1) 
      V1(2) = XX1(2) - XX2(2) 
      V1(3) = XX1(3) - XX2(3) 
      V2(1) = XX3(1) - XX1(1) 
      V2(2) = XX3(2) - XX1(2) 
      V2(3) = XX3(3) - XX1(3) 
      V3(1) = XX4(1) - XX1(1) 
      V3(2) = XX4(2) - XX1(2) 
      V3(3) = XX4(3) - XX1(3) 
      CALL NB_VMOD(V1,AV1)
      CALL NB_VMOD(V2,AV2)
      CALL NB_VMOD(V3,AV3)
      CALL NB_VMULT(V1,V2,V12)
      CALL NB_VMOD(V12,AV12)
      CALL NB_VMULT(V1,V3,V13)
      CALL NB_VMOD(V13,AV13)
      IF(AV12.LE.0.0.OR.AV13.LE.0.0) GO TO 200

      CALL NB_VPROD(V12,V13,ACOS23)
      T      = AV12*AV13
      IF(ABS(T).LT.1.0E-8) T = 1.0
      ACOS23 = ACOS23/T

      IF(ACOS23.GT. 1.0) ACOS23 = 1.0      
      IF(ACOS23.LT.-1.0) ACOS23 =-1.0

      PH     = ACOS(ACOS23) 

      CALL NB_VMULT(V1,V2,VT)
      CALL NB_VPROD(VT,V3,TEST)

      IF(TEST.LT.0) PH = -PH

      IF(PH.GT. PI) PH = PH - TWOPI        
      IF(PH.LE.-PI) PH = PH + TWOPI        

      PH = PH/PI180
 200  CONTINUE

      RETURN
      END

      SUBROUTINE GET_TORS(A1,A2,A12,T)
C ----------------------------------------------------
      PI     = 4.0*ATAN(1.0)
      TWOPI  = 2.0*PI
      SINA1  = SIN(A1)
      COSA1  = COS(A1)
      SINA2  = SIN(A2)
      COSA2  = COS(A2)
      COSA12 = COS(A12)
      S      = A1+A2+A12
      S      = SIN(S)
      IF(ABS(S).LT.0.002) THEN
        T = PI
      ELSE IF(ABS(SINA1).LT.0.000001.OR.ABS(SINA2).LT.0.000001) THEN
        T = 0.0
      ELSE
        COST = (COSA12-COSA1*COSA2)/(SINA1*SINA2)
        IF(COST.GT. 1.0) COST = 1.0
        IF(COST.LT.-1.0) COST =-1.0
        T = ACOS(COST)
      ENDIF
      IF(T.GT. PI) T = T - TWOPI
      IF(T.LT.-PI) T = T + TWOPI
C ---
      RETURN
      END


      SUBROUTINE SET_VOBS_TO_VIDL(MDOC,IERR)
C -----------------------------------------------
C -P- 
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C --------------------------------------------------------
C      WRITE(LINE,'('' N BOND,ANGLE,TORS:'',3I4)')
C     * L1B_NBOND,L1G_NANGL,L1T_NTORS
C      CALL MSGDOC(MDOC,LINE)

      IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          IF(L1B_VOBS(IB).GT.0.001) L1B_VAL(IB) = L1B_VOBS(IB)
          IF(L1B_TYPE(IB).EQ.'.') L1B_TYPE(IB) = 'coval'
        ENDDO 
      ENDIF
C ---
      IF(L1G_NANGL.GT.0) THEN
        DO IG=1,L1G_NANGL
           IF(L1G_VOBS(IG).GT.0.001) L1G_VAL(IG) = L1G_VOBS(IG)
        ENDDO
      ENDIF
C ---
      IF(L1T_NTORS.GT.0) THEN
        DO IT=1,L1T_NTORS
          L1T_VAL(IT) = L1T_VOBS(IT)
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PHI,V3)
C --------------------
C     in libcheck and in make_rst
C
      REAL V1(3),V2(3),V3(3),N12(3),P12(3),V23(3)
     *    ,VP3(3),VN3(3),X(3),VV1(3)
C     REAL VS(3)
C --------------------
      PI     = 4.0*ATAN(1.0)
      COSA1  = COS(ANG1)
      COSA2  = COS(ANG2)
      SINA1  = SIN(ANG1)
      SINA2  = SIN(ANG2)
      COSPHI = COS(PHI)
      SINPHI = SIN(PHI)
      VV1(1) = V1(1)
      VV1(2) = V1(2)
      VV1(3) = V1(3)
C --
      IF(ABS(SINA2).LT.0.02) THEN
        T = AV3/AMAX1(AV2,0.00001)
        IF(COSA2.GT.0.0) T =-T
        CALL NB_VSCAL(V2,T,V3)
        RETURN
      ENDIF
      IF(ABS(SINA1).LT.0.02) THEN
        VV1(1) = 1.0
        VV1(2) = 0.0
        VV1(3) = 0.0
        CALL NB_VMOD(VV1,AVV1)
        CALL NB_VMOD(V2,AVV2)
        CALL NB_VPROD(VV1,V2,S)
        COSA1 = S/(AVV1*AVV2)
        AANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
        AANG1  = PI-AANG1
        COSA1  = COS(AANG1)
        SINA1  = SIN(AANG1)
        IF(ABS(SINA1).LT.0.02) THEN
          VV1(1) = 0.0
          VV1(2) = 1.0
          VV1(3) = 0.0
          CALL NB_VMOD(VV1,AVV1)
          CALL NB_VMOD(V2,AVV2)
          CALL NB_VPROD(VV1,V2,S)
          COSA1 = S/(AVV1*AVV2)
          AANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
          AANG1  = PI-AANG1
          COSA1  = COS(AANG1)
          SINA1  = SIN(AANG1)
          IF(ABS(SINA1).LT.0.02) THEN
            VV1(1) = 0.0
            VV1(2) = 1.0
            VV1(3) = 0.0
            CALL NB_VMOD(VV1,AVV1)
            CALL NB_VMOD(V2,AVV2)
            CALL NB_VPROD(VV1,V2,S)
            COSA1 = S/(AVV1*AVV2)
            AANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
            AANG1  = PI-AANG1
            COSA1  = COS(AANG1)
            SINA1  = SIN(AANG1)
          ENDIF
        ENDIF
      ENDIF

      CALL NB_VMULT(VV1,V2,X)
      CALL NB_VUNIT(X,N12,JERR)
      CALL NB_VMULT(N12,V2,X)
      CALL NB_VUNIT(X,P12,JERR)

      AP23 = AV3*SINA2
      T = (AV3*(-COSA2))/AMAX1(AV2,0.00001)
      CALL NB_VSCAL(V2,T,V23)
      T1 = AP23*COSPHI
      CALL NB_VSCAL(P12,T1,VP3)
      T1 = AP23*SINPHI
      CALL NB_VSCAL(N12,T1,VN3)

      CALL NB_VADD(V23,VP3,X)
      CALL NB_VADD(X,VN3,V3)
C --
C --------------------------- 
      RETURN
      END

      SUBROUTINE CALC_PLDEV(N,IATM,DOBS)
C -----------------------------------------------
C -P- CALC_PLDEV - 
C -S-
      INTEGER*4 N,IATM(*)
      REAL      DOBS(*)
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      REAL      X(3,MAX1APL),DEL(MAX1APL),VM(3)
C -------------------------------------------------
      IF(N.LE.0) RETURN
      DO  I = 1,N
        II     = IATM(I)
        X(1,I) = L1A_X(II)
        X(2,I) = L1A_Y(II)
        X(3,I) = L1A_Z(II)
      ENDDO

      IF(N.GE.4) THEN

        CALL FIT_PLANE(N,X,VM,D)

        DO  I = 1,N
          DEL(I) = 0
          DO J=1,3
            DEL(I) = DEL(I)+VM(J)*X(J,I)
          ENDDO
          DOBS(I) = DEL(I)-D
        ENDDO

      ELSE

        DO  I = 1,N
          DOBS(I) = 0.0
        ENDDO

      ENDIF

      RETURN
      END      

C ******
      SUBROUTINE FIT_PLANE(N,X,VM,D)
C -P- PLAN - fit a least-squares plan to a set of points.
C -S-
C     PROCEDURE OF SCHOMAKER ET AL.(ACTA CRYST.,12,600,1959)
C
C ******
      REAL   X(3,*),XS(3),XXS(3,3),B(3,3),A(3,3)
      REAL   VM(3),VMI(3),BV(3)
      DATA   ZIP/1.0E-5/
      DATA   MM/10/
C ------------------------------------
C
C----SET UP THE A MATRIX
      SN = N
      IF(N.LE.0) STOP ' N =< 0 in subroutine "FIT_PLANE"'
C ---
      DO    I=1,3
        XS(I) = 0
        DO    K=1,N
          XS(I) = XS(I) + X(I,K)
        ENDDO
      ENDDO
C ---
      DO    I=1,3
        DO    J=1,3
          XXS(I,J) = 0
          DO    K=1,N
            XXS(I,J) = XXS(I,J) + X(I,K)*X(J,K)
          ENDDO
          A(I,J) = XXS(I,J) - XS(I)*XS(J)/SN
        ENDDO
      ENDDO
C
C----EVALUATE MATRIX B=ADJ(A)*G
C
      B(1,1) = A(2,2)*A(3,3)-A(2,3)*A(3,2)
      B(2,1) = A(3,1)*A(2,3)-A(2,1)*A(3,3)
      B(3,1) = A(2,1)*A(3,2)-A(3,1)*A(2,2)
      B(1,2) = A(3,2)*A(1,3)-A(1,2)*A(3,3)
      B(2,2) = A(1,1)*A(3,3)-A(3,1)*A(1,3)
      B(3,2) = A(3,1)*A(1,2)-A(1,1)*A(3,2)
      B(1,3) = A(1,2)*A(2,3)-A(1,3)*A(2,2)
      B(2,3) = A(2,1)*A(1,3)-A(1,1)*A(2,3)
      B(3,3) = A(1,1)*A(2,2)-A(2,1)*A(1,2)

C
C----CHOOSE THE LARGEST COLUMN VECTOR OF B AS THE INITIAL SOLUTION
C
      BV(1) = B(1,1)**2+B(2,1)**2+B(3,1)**2
      BV(2) = B(1,2)**2+B(2,2)**2+B(3,2)**2
      BV(3) = B(1,3)**2+B(2,3)**2+B(3,3)**2

      KK    = 1
      IF(BV(2).GT.BV( 1)) KK = 2
      IF(BV(3).GT.BV(KK)) KK = 3
      VM1 = B(1,KK)

      IF(ABS(VM1).LE.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

      VMI_MIN = 1E30
      DO    I=1,3
        VMI(I) = B(I,KK)/VM1
        IF(ABS(VMI(I)).LT.VMI_MIN) VMI_MON = ABS(VMI(I))
      ENDDO

      IF(VMI_MIN.LE.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

C
C----SOLVE TO CONVERGENCE BY ITERATION OF M(I)=B*M(I-1)
C
      DO    NNN=1,MM
        VM(1)  = B(1,1)*VMI(1)+B(1,2)*VMI(2)+B(1,3)*VMI(3)
        VM(2)  = B(2,1)*VMI(1)+B(2,2)*VMI(2)+B(2,3)*VMI(3)
        VM(3)  = B(3,1)*VMI(1)+B(3,2)*VMI(2)+B(3,3)*VMI(3)
        IF(ABS(VMI(1)).LT.ZIP) GO TO 110
        IF(ABS(VMI(2)).LT.ZIP) GO TO 110
        IF(ABS(VMI(3)).LT.ZIP) GO TO 110
        RATIO1 = VM(1)/VMI(1)
        RATIO2 = VM(2)/VMI(2)
        RATIO3 = VM(3)/VMI(3)
        RAT12  = ABS(RATIO2/RATIO1-1.0)
        RAT13  = ABS(RATIO3/RATIO1-1.0)
        IF(RAT12.LT.ZIP.AND.RAT13.LT.ZIP) GO TO 110
        IF(ABS(VM(1)).LT.ZIP) GO TO 110
        DO    I=1,3
          VMI(I) = VM(I)/VM(1)
        ENDDO
      ENDDO   
C
C----NORMALIZE THE SOLUTION VECTOR AND EVALUATE D(PLANE TO ORIGIN DISTAN
C
  110 ORM = 0
      DO    I=1,3
        ORM = ORM + VM(I)*VM(I)
      ENDDO

      ORM = SQRT(ABS(ORM))

      IF(ORM.LT.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

      DO     I=1,3
        VM(I) = VM(I)/ORM
      ENDDO

      D = (VM(1)*XS(1)+VM(2)*XS(2)+VM(3)*XS(3))/SN

      RETURN
      END

C ==========================================================

C ========================================================
      SUBROUTINE GRAPH_NEWL(MDOC,MOD,MON_INPUT,PROG,VANGLE,IERR)
C -----------------------------------------------
C -P-  
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,ATOM*4,PROG*(*),MOD*1,MON_INPUT*8
C     CHARACTER TYPE*8
      REAL      X(3),Y(3),C(3)
      INTEGER   IXP(2),IYP(2)
C ----
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS
C ----
      CHARACTER       NAME*256,LINE*256,PATH*1,EXT*1,MNAME*80,ACHIR(4)*4
      CHARACTER       CH30(3)*30,CH28(3)*28
      CHARACTER       CH28A(3)*28,CH28B(3)*28,CH28C(3)*28
C ---
      INCLUDE 'lib_com.fh'
C ******
      INCLUDE 'crd_com.fh'
C --------------------------------------------------------
      NA    = L1A_NATOM
      NB    = L1B_NBOND
      CALL LENSTR_BL(MON_INPUT,L)
      IF(L.GT.0.AND.MON_INPUT(1:1).NE.'?'.AND.
     *              MON_INPUT(1:1).NE.' '      ) THEN
        MON   = MON_INPUT 
      ELSE
        MON   = L1L_MNAME 
      ENDIF
      MNAME = L1L_NAME

cd      IF(NA.LE.2.OR.NB.LE.1) RETURN



      XMAX =-1.E 30
      YMAX =-1.E 30
      ZMAX =-1.E 30
      XMIN = 1.E 30
      YMIN = 1.E 30
      ZMIN = 1.E 30

      N = 0
      DO I=1,NA

        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN

          L2A_X(I) = L1A_X(I)
          L2A_Y(I) = L1A_Y(I)
          L2A_Z(I) = L1A_Z(I)

          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)

          IF(X(1).GT.XMAX) XMAX = X(1)
          IF(X(2).GT.YMAX) YMAX = X(2)
          IF(X(3).GT.ZMAX) ZMAX = X(3)

          IF(X(1).LT.XMIN) XMIN = X(1)
          IF(X(2).LT.YMIN) YMIN = X(2)
          IF(X(3).LT.ZMIN) ZMIN = X(3)
          N=N+1
        ENDIF
      ENDDO

      IF(N.LE.0) THEN
c        WRITE(LINE,'(
c     * '' WARNING: number of atoms < 1 for '',A)') MON
c        CALL MSGERR(MDOC,LINE)
c        CALL MSGERR(MDOC,
c     * '            Can not create PostScript file and CIFile')
        IERR=0
        RETURN
      ENDIF
C ---

      CALL LENSTR_BL(PROG,LP)
      CALL LENSTR_BL(MON,LM)

C      write(*,*) 'prog    :',prog
C      write(*,*) 'cro_file:',CRO_FILE      

      IF(PROG.EQ.'libcheck') THEN
        CALL LENSTR_BL(CRO_FILE,LO)
        IF(LO.GT.0.AND.CRO_FILE(1:1).NE.',') THEN 
C          IF(LO.GT.(75-LM)) LO = 75 - LM 
          IF(LO.GT.(250-LM)) LO = 250 - LM 
          NAME=CRO_FILE(1:LO)//'_'//MON(1:LM)//'.cif'
        ELSE
          NAME=PROG(1:LP)//'_'//MON(1:LM)//'.cif'
        ENDIF
C       IUN=40
        IUN = CRO2_IUN

C      write(*,*) 'prog    :',prog
C      write(*,*) 'cro_file:',CRO_FILE(1:lo)     
C      CALL LENSTR_BL(CRO_FILE,Llll)
C      write(*,*) 'name:',name(1:llll)

        M    = 99
        PATH = ' '
        EXT  = ' '
        CALL OPENFW(IUN,M,PATH,NAME,EXT,IERR)
        CRO2_IUN = IUN
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,
     *    ' WARNING: can''t open output CIFile for new monomer')
          IUN  = 0
          IERR = 0
        ENDIF

        IF(IUN.GT.0) THEN
          CALL LENSTR_BL(NAME,L)
          IF(L.GT.66) L = 66
          LINE='* CIFile  : '//NAME(1:L)
          CALL MSGDOC(MDOC,LINE)
          CALL WR_CIF_NEW(MDOC,CRO2_IUN,PROG,IERR)
        ENDIF

        CALL LENSTR_BL(CRO_FILE,LO)
        IF(LO.GT.0.AND.CRO_FILE(1:1).NE.',') THEN 
C          IF(LO.GT.(75-LM)) LO = 75 - LM 
          IF(LO.GT.(250-LM)) LO = 250 - LM 
          NAME=CRO_FILE(1:LO)//'_'//MON(1:LM)//'.pdb'
        ELSE
          NAME = PROG(1:LP)//'_'//MON(1:LM)//'.pdb'
        ENDIF

C      CALL LENSTR_BL(CRO_FILE,Llll)
C      write(*,*) 'name:',name(1:llll)

        IUN  = CRO2_IUN
        M    = 99
        PATH = ' '
        EXT  = ' '
        CALL OPENFW(IUN,M,PATH,NAME,EXT,IERR)
        CRO2_IUN = IUN
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,
     *    ' WARNING: can''t open output PDB File for new monomer')
          IUN  = 0
          IERR = 0
        ENDIF

        IF(IUN.GT.0) THEN
          CALL LENSTR_BL(NAME,L)
          IF(L.GT.66) L = 66
          LINE='* PDBfile : '//NAME(1:L)
          CALL MSGDOC(MDOC,LINE)
          CALL WR_PDB_NEW(MDOC,CRO2_IUN,PROG,IERR)
        ENDIF

      ENDIF
C ---
      IF(N.GE.3) THEN

        C(1)    = (XMAX+XMIN)/2.0  
        C(2)    = (YMAX+YMIN)/2.0
        C(3)    = (ZMAX+ZMIN)/2.0

        XB      = (XMAX-XMIN)/2.0  
        YB      = (YMAX-YMIN)/2.0
        ZB      = (ZMAX-ZMIN)/2.0


        ICHNG = 0
        IF(XB.LT.ZB.AND.XB.LT.YB) THEN
          I1 = 1
          I2 = 2
          I3 = 3          
          ICHNG = 1
        ELSE IF(YB.LT.ZB.AND.YB.LT.XB) THEN          
          I1 = 3
          I2 = 2
          I3 = 1          
          ICHNG = 2
        ENDIF

        IF(ICHNG.GT.0) THEN
          DO I=1,NA
            IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
              X(1)  = L2A_X(I)
              X(2)  = L2A_Y(I)
              X(3)  = L2A_Z(I)
              T     = X(I1)
              X(I1) = X(I2)
              X(I2) = X(I3)
              X(I3) = T
              L2A_X(I) = X(1)
              L2A_Y(I) = X(2)
              L2A_Z(I) = X(3)
            ENDIF
          ENDDO
          T     = C(I1)
          C(I1) = C(I2)
          C(I2) = C(I3)
          C(I3) = T
        ENDIF

      ELSE
        WRITE(LINE,'(A,A)')
     * ' WARNING: number of atoms < 3 for ', MON
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     * '            Can not create PostScript file')
        IERR=0
        RETURN
      ENDIF

      RAD=0.0
      DO I=1,NA
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)
          T1   = X(1)-C(1)
          T2   = X(2)-C(2)
          T3   = X(3)-C(3)
          R    = SQRT(T1*T1+T2*T2+T3*T3)
          IF(R.GT.RAD) RAD=R
          L2A_X(I) = T1
          L2A_Y(I) = T2
          L2A_Z(I) = T3
        ENDIF
      ENDDO

C --- rotation --

      ANGLE = (VANGLE*3.1415926)/180.0
      COSA  = COS(ANGLE)
      SINA  = SIN(ANGLE)
      DO I=1,NA
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)
          T1   = X(2)*COSA+X(3)*SINA
          T2   =-X(2)*SINA+X(3)*COSA
          X(2) = T1 
          X(3) = T2
          L2A_X(I) = X(1)
          L2A_Y(I) = X(2)
          L2A_Z(I) = X(3)
        ENDIF
      ENDDO

C -----
C ------------------

      NPAGE=5
      CALL LENSTR_BL(PROG,LP)
      CALL LENSTR_BL(MON,LM)
      IF(PROG.EQ.'libcheck') THEN
        CALL LENSTR_BL(CRO_FILE,LO)
        IF(LO.GT.0.AND.CRO_FILE(1:1).NE.',') THEN 
C          IF(LO.GT.(75-LM)) LO = 75 - LM 
          IF(LO.GT.(250-LM)) LO = 250 - LM 
          NAME=CRO_FILE(1:LO)//'_'//MON(1:LM)//'.ps'
        ELSE
          NAME=PROG(1:LP)//'_'//MON(1:LM)//'.ps'
        ENDIF
      ELSE
        CALL LENSTR_BL(CRPS_PATH,LPATH)
        CALL LENSTR_BL(CRPS_FILE,LFILE)
        IF(LPATH.GT.0) THEN
          LINE = CRPS_PATH(1:LPATH)//CRPS_FILE(1:LFILE)
        ELSE
          LINE = CRPS_FILE
        ENDIF
        CALL LENSTR_BL(LINE,LEN)
        CALL LENSTR_BL(CRPS_EXT,LE)
C        LLEN = 80 - (LM+LE+1)
        LLEN = 256 - (LM+LE+1)
        IF(LEN.LE.0) THEN
          LINE = 'makecif'
          LEN  = 7
        ELSE IF(LEN.GT.LLEN) THEN
          LEN = LLEN
        ENDIF
        NAME = LINE(1:LEN)//'_'//MON(1:LM)//'.'//CRPS_EXT(1:LE)
      ENDIF
      CALL OPENTX(NAME,NPAGE,IERR)
C      PATH = ' '
C      EXT  = ' '
C      MDOC = 99
C      CALL  OPENFW(IUN_PS,MDOC,PATH,FNAME,EXT,IERR)
C      IF(IERR.NE.0) GO TO 900

      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: can not open PostScript file')
        IERR=0           
        RETURN
      ENDIF
      IPEN=1
      CALL NEWPEN(IPEN)
C ---
      IBX=180
      IBY=180
      ISHX=50
      ISHY=80
      CALL SET_BOX_TX(IBX,IBY,ISHX,ISHY)
      CALL GET_BOX_TX(IBXX,IBXY,ISHX,ISHY,IX0_PS,IY0_PS
     *   ,LIM_XMIN,LIM_XMAX,LIM_YMIN,LIM_YMAX)
C -----------------------
      BORDER = 2.5
      IBX    = IBXX
      IBX2   = IBX/2
      BOX    = (RAD+BORDER)*2.0
      RADBOR = RAD+BORDER
      SCALE  = IBX/BOX
C -----------------------
C ------ title ----
C     CALL TITLE_MONL(MON)

      CALL LENSTR_BL(PROG,L)
      CALL TITLE_MONL_1(MON,MNAME)
C ---left---

      IX0 = 0
      IY0 = 0
      CALL ORITX(IX0,IY0)
      CALL DRAW_FRAME(IBX,IBX)
C -----------------
      DO L=1,NB

        I1    = L1B_I1ATM(L) 
        I2    = L1B_I2ATM(L) 
        IF(I1.GT.0.AND.I2.GT.0) THEN
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y') THEN
           
          X(1) = L2A_X(I1)
          X(2) = L2A_Y(I1)
          X(3) = L2A_Z(I1)

          CALL PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)

          Y(1) = L2A_X(I2)
          Y(2) = L2A_Y(I2)
          Y(3) = L2A_Z(I2)


          CALL PROJ_TXL(Y,RADBOR,IBX,SCALE,IYP)

          CALL MOVTXX(IXP(1),IXP(2))
          CALL VECTXX(IYP(1),IYP(2))

        ENDIF
        ENDIF
      ENDDO
C --
      IDX     =-3
      IDY     = 3
      ISIZE   = 8
      SZ_LETT = 0.5
      IMOD    = 0

      DO I=1,NA
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN

          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)
          CALL PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)
          IX   = IXP(1)+IDX
          IY   = IXP(2)+IDY
          X(1) = SZ_LETT
          X(2) = 0.0
          I0   = 0
          CALL PROJ_TXL(X,RADBOR,I0,SCALE,IXP)
          ISZ  = IXP(1)/10
          ATOM = L1A_ANAME(I)
          CALL LENSTR_BL(ATOM,LEN)
          IXX  = IX/10
          IYY  = IY/10  
          CALL TXTEXT(ATOM(1:LEN),ISZ,IXX,IYY,IMOD)
        ENDIF
      ENDDO
C ---
C ---right---

C ---
c      IBX =190
c      IBY =190
C      ISHX=50
      ISHY = ISHY+IBX
      CALL SET_BOX_TX(IBX,IBY,ISHX,ISHY)
      ANGLE = (-9.0*3.1415926)/180.0
      COSA  = COS(ANGLE)
      SINA  = SIN(ANGLE)

      IX0 = 0
      IY0 = 0
      CALL ORITX(IX0,IY0)
      CALL DRAW_FRAME(IBX,IBX)
C -----------------
      DO L=1,NB

        I1    = L1B_I1ATM(L) 
        I2    = L1B_I2ATM(L) 

        IF(I1.GT.0.AND.I2.GT.0) THEN
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y') THEN

          X(1) = L2A_X(I1)
          X(2) = L2A_Y(I1)
          X(3) = L2A_Z(I1)
          T1   = X(2)*COSA+X(3)*SINA
          T2   =-X(2)*SINA+X(3)*COSA
          X(2) = T1 
          X(3) = T2
          CALL PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)

          Y(1) = L2A_X(I2)
          Y(2) = L2A_Y(I2)
          Y(3) = L2A_Z(I2)
          T1   = Y(2)*COSA+Y(3)*SINA
          T2   =-Y(2)*SINA+Y(3)*COSA
          Y(2) = T1
          Y(3) = T2
          CALL PROJ_TXL(Y,RADBOR,IBX,SCALE,IYP)

          CALL MOVTXX(IXP(1),IXP(2))
          CALL VECTXX(IYP(1),IYP(2))
        ENDIF
        ENDIF
      ENDDO
      IDX   =-3
      IDY   = 3
      ISIZE = 8
      IMOD  = 0

      DO I=1,NA
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)
          T1   = X(2)*COSA+X(3)*SINA
          T2   =-X(2)*SINA+X(3)*COSA
          X(2) = T1
          X(3) = T2
          CALL PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)
          IX   = IXP(1)+IDX
          IY   = IXP(2)+IDY
          X(1) = SZ_LETT
          X(2) = 0.0
          I0   = 0
          CALL PROJ_TXL(X,RADBOR,I0,SCALE,IXP)
          ISZ  = IXP(1)/10
          ATOM = L1A_ANAME(I)
          CALL LENSTR_BL(ATOM,LEN)
          IXX  = IX/10
          IYY  = IY/10  
          CALL TXTEXT(ATOM(1:LEN),ISZ,IXX,IYY,IMOD)
        ENDIF
      ENDDO
C ---
C ------------------------------------------
      IMOD   = 1
      ID1    = 20
      ID2    = 15
      IDEL   = 10
      ISIZE1 = 10
      ISIZE  = 8
      IXL0   = ISHX+IBX
      IYLT   = 230
      IXLMAX = (LIM_XMAX-LIM_XMIN) - 6*IDEL
      LENY   = LIM_YMAX-LIM_YMIN
      L3     = LENY/3-10
      IY1    = 15
      IY2    = 15+L3
      IY3    = 15+L3*2
      IYL1   = IY1+50
      IYL2   = IY2+50
      IYL3   = IY3+50
 
C ---------------------------------------
      IF(NB.GT.0) THEN

      LINE = 'BONDS'
      IXL  = IXL0+ID1 
      IF(IXL.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      CALL TXTEXT(LINE,ISIZE1,IXL,IYLT,IMOD)
C ---
      IF(MOD.EQ.'L') THEN
      LINE=
     *'lib - value from library, crd - value from coords(created), chem  
     *-from ener_lib'
      ELSE
      LINE=
     *'lib - value for library, crd - value from coords, chem - from ene
     *r_lib'
      ENDIF
C ---
      IXL   = IXL+ID1
      IY1   = 60
      CALL TXTEXT(LINE,ISIZE,IXL,IY1,IMOD)

      LINE  = 'Dlib Dcrd Dchem'
      IXL   = IXL+ID2
      IF(IXL.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      IY1  = 11
      IY2  = 21+L3
      IY3  = 31+L3*2
      IYL1 = IY1+40
      IYL2 = IY2+40
      IYL3 = IY3+40
      IYY1 = IYL1+12
      IYY2 = IYL2+12
      IYY3 = IYL3+12
      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY3,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I) = ' '
        CH28(I) = ' '
      ENDDO
      N = 0
      DO L=1,NB
        I1    = L1B_I1ATM(L) 
        I2    = L1B_I2ATM(L)

        IF(I1.GT.0.AND.I2.GT.0) THEN 
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y') THEN
          N = N+1 
          WRITE(CH30(N),100) 
     *    L1A_ANAME(I1),L1A_ANAME(I2)
 100      FORMAT(A4,'-',A4)
          WRITE(CH28(N),110) 
     *    L1B_VAL(L),L1B_VOBS(L),L1B_EVAL(L) 
 110      FORMAT(3F7.3)
          IF(N.EQ.3) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
            CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
            DO I=1,3
              CH30(I) = ' '
              CH28(I) = ' '
            ENDDO
            N   = 0
            IXL = IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDIF
        ENDIF
      ENDDO
      IF(N.GT.0) THEN
        CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
        CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
        CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
        CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
        CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
        CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
        DO I=1,3
          CH30(I) = ' '
          CH28(I) = ' '
        ENDDO
        N=0
        IXL=IXL+IDEL
        IF(IXL.GT.IXLMAX) THEN
          CALL NEWPG
          CALL TITLE_MONL(MON)
          IXL=ISHX
        ENDIF
      ENDIF

      ENDIF
C ---------------------------------------
      IF(L1G_NANGL.GT.0) THEN

      LINE = 'ANGLES'
      IXL  = IXL+ID1 
      IXLP = IXL+ID1
      IF(IXLP.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      CALL TXTEXT(LINE,ISIZE1,IXL,IYLT,IMOD)
C ---
      LINE='lib crd chem'
      IY1   = 5
      IY2   = 20+L3
      IY3   = 30+L3*2
      IXL   = IXL+ID1
      IYL1  = IY1+70
      IYL2  = IY2+70
      IYL3  = IY3+70
      IYL1A = IYL1+30
      IYL1B = IYL1+55
      IYL2A = IYL2+30
      IYL2B = IYL2+55
      IYL3A = IYL3+30
      IYL3B = IYL3+55
      IYY1  = IYL1+15
      IYY2  = IYL2+15
      IYY3  = IYL3+15
      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY3,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I)  = ' '
        CH28(I)  = ' '
        CH28A(I) = ' '
        CH28B(I) = ' '
      ENDDO
      N  = 0
      NG = L1G_NANGL
      IF(NG.GT.0) THEN
      DO L=1,NG
        I1    = L1G_I1ATM(L) 
        I2    = L1G_I2ATM(L) 
        I3    = L1G_I3ATM(L)
        IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0) THEN 
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I3).EQ.'Y') THEN
          N = N+1 
          WRITE(CH30(N),200) 
     *    L1A_ANAME(I1),L1A_ANAME(I2),L1A_ANAME(I3)
 200      FORMAT(A4,'-',A4,'-',A4)
          WRITE(CH28(N),210) 
     *    L1G_VAL(L) 
 210      FORMAT(F8.2)
          IYL1A = IYL1+30
          WRITE(CH28A(N),210) 
     *    L1G_VOBS(L)
          WRITE(CH28B(N),210) 
     *    L1G_EVAL(L) 
          IF(N.EQ.3) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
            CALL TXTEXT(CH28B(1),ISIZE,IXL,IYL1B,IMOD)


            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
            CALL TXTEXT(CH28B(2),ISIZE,IXL,IYL2B,IMOD)

            CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
            CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
            CALL TXTEXT(CH28A(3),ISIZE,IXL,IYL3A,IMOD)
            CALL TXTEXT(CH28B(3),ISIZE,IXL,IYL3B,IMOD)

            DO I=1,3
              CH30(I)  = ' '
              CH28(I)  = ' '
              CH28A(I) = ' '
              CH28B(I) = ' '
            ENDDO
            N   = 0
            IXL = IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDIF
        ENDIF
      ENDDO
      IF(N.GT.0) THEN
        CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
        CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
        CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
        CALL TXTEXT(CH28B(1),ISIZE,IXL,IYL1B,IMOD)
        CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
        CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
        CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
        CALL TXTEXT(CH28B(2),ISIZE,IXL,IYL2B,IMOD)
        CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
        CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
        CALL TXTEXT(CH28A(3),ISIZE,IXL,IYL3A,IMOD)
        CALL TXTEXT(CH28B(3),ISIZE,IXL,IYL3B,IMOD)
        DO I=1,3
          CH30(I)  = ' '
          CH28(I)  = ' '
          CH28A(I) = ' '
          CH28B(I) = ' '
        ENDDO
        N   = 0
        IXL = IXL+IDEL
        IF(IXL.GT.IXLMAX) THEN
          CALL NEWPG
          CALL TITLE_MONL(MON)
          IXL = ISHX
        ENDIF
      ENDIF
      ENDIF

      ENDIF
C ---------------------------------------
      IF(L1T_NTORS.GT.0) THEN

      LINE = 'TORSION ANGLES'
      IXL  = IXL+ID1 
      IXLP = IXL+ID1
      IF(IXLP.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL = ISHX
      ENDIF
      IYL = IYLT-10
      CALL TXTEXT(LINE,ISIZE1,IXL,IYL,IMOD)
C ---
      LINE  = 'lib crd chem period'
      IXL   = IXL+ID1

      IY1 = 2
      IY2 = 4+L3


      IY1T =IY1
      IYL1 =IY1T+145
      IYL1A=IYL1+30
      IYL1B=IYL1+60
      IYL1C=IYL1+85

      IY2T =IY2+95
      IYL2 =IY2T+145
      IYL2A=IYL2+30
      IYL2B=IYL2+60
      IYL2C=IYL2+85

      IYY1 =IYL1+12
      IYY2 =IYL2+8

      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I)=' '
        CH28(I)=' '
        CH28A(I)=' '
        CH28B(I)=' '
        CH28C(I)=' '
      ENDDO
      N=0
      NT=L1T_NTORS
      IF(NT.GT.0) THEN
      DO L=1,NT
        I1    = L1T_I1ATM(L) 
        I2    = L1T_I2ATM(L) 
        I3    = L1T_I3ATM(L) 
        I4    = L1T_I4ATM(L) 
        IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0.AND.I4.GT.0) THEN
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I3).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I4).EQ.'Y') THEN
          N=N+1 
          WRITE(CH30(N),300) 
     *    L1A_ANAME(I1),L1A_ANAME(I2),L1A_ANAME(I3),L1A_ANAME(I4)
     *    ,L1T_LABEL(L)
 300      FORMAT(A4,'-',A4,'-',A4,'-',A4,' ',A8)
          WRITE(CH28(N),310) 
     *    L1T_VAL(L) 
 310      FORMAT(F8.2)
          WRITE(CH28A(N),310) 
     *    L1T_VOBS(L)
          WRITE(CH28B(N),310) 
     *    L1T_EVAL(L) 
          WRITE(CH28C(N),315) 
     *    L1T_PRD(L) 
 315      FORMAT(I4)
          IF(N.EQ.2) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1T,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
            CALL TXTEXT(CH28B(1),ISIZE,IXL,IYL1B,IMOD)
            CALL TXTEXT(CH28C(1),ISIZE,IXL,IYL1C,IMOD)

            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2T,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
            CALL TXTEXT(CH28B(2),ISIZE,IXL,IYL2B,IMOD)
            CALL TXTEXT(CH28C(2),ISIZE,IXL,IYL2C,IMOD)

            DO I=1,2
              CH30(I)=' '
              CH28(I)=' '
              CH28A(I)=' '
              CH28B(I)=' '
              CH28C(I)=' '
            ENDDO
            N=0
            IXL=IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDIF
        ENDIF
      ENDDO
      IF(N.GT.0) THEN
        CALL TXTEXT(CH30(1),ISIZE,IXL,IY1T,IMOD)
        CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
        CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
        CALL TXTEXT(CH28B(1),ISIZE,IXL,IYL1B,IMOD)
        CALL TXTEXT(CH28C(1),ISIZE,IXL,IYL1C,IMOD)

        CALL TXTEXT(CH30(2),ISIZE,IXL,IY2T,IMOD)
        CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
        CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
        CALL TXTEXT(CH28B(2),ISIZE,IXL,IYL2B,IMOD)
        CALL TXTEXT(CH28C(2),ISIZE,IXL,IYL2C,IMOD)
        DO I=1,3
          CH30(I)=' '
          CH28(I)=' '
          CH28A(I)=' '
          CH28B(I)=' '
          CH28C(I)=' '
        ENDDO
        N=0
        IXL=IXL+IDEL
        IF(IXL.GT.IXLMAX) THEN
          CALL NEWPG
          CALL TITLE_MONL(MON)
          IXL=ISHX
        ENDIF
      ENDIF
      ENDIF

      ENDIF
C ---------------------------------------
      IF(L1C_NCHIR.GT.0) THEN

      LINE='CHIRALITY'
      IXL = IXL+ID1 
      IXLP=IXL+ID1
      IF(IXLP.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      IYL=IYLT-5
      CALL TXTEXT(LINE,ISIZE1,IXL,IYL,IMOD)
C ---
      LINE='ideal crd'
      IXL   = IXL+ID1
      IY1= 5
      IY2= 17+L3
      IY3= 19+L3*2
      IYL1=IY1+95
      IYL2=IY2+95
      IYL3=IY3+95

      IYL1A=IYL1+25
      IYL2A=IYL2+25
      IYL3A=IYL3+25

      IYY1=IYL1+18
      IYY2=IYL2+18
      IYY3=IYL3+18
      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY3,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I)=' '
        CH28(I)=' '
        CH28A(I)=' '
      ENDDO
      N=0
      NC=L1C_NCHIR
      IF(NC.GT.0) THEN
      DO L=1,NC
        I1    = L1C_I1ATM(L) 
        I2    = L1C_I2ATM(L) 
        I3    = L1C_I3ATM(L) 
        I4    = L1C_I4ATM(L) 
        ICOOR = 1
        IF(I1.GT.0) THEN
          ACHIR(1) = L1A_ANAME(I1) 
          IF(L1A_COOR_FLAG(I1).NE.'Y') ICOOR = 0
        ELSE 
          ACHIR(1) = '.'  
          ICOOR = 0
        ENDIF
        IF(I2.GT.0) THEN
          ACHIR(2) = L1A_ANAME(I2) 
          IF(L1A_COOR_FLAG(I2).NE.'Y') ICOOR = 0
        ELSE 
          ACHIR(2) = '.'  
          ICOOR = 0
        ENDIF
        IF(I3.GT.0) THEN
          ACHIR(3) = L1A_ANAME(I3) 
          IF(L1A_COOR_FLAG(I3).NE.'Y') ICOOR = 0
        ELSE 
          ACHIR(3) = '.'  
          ICOOR = 0
        ENDIF
        IF(I4.GT.0) THEN
          ACHIR(4) = L1A_ANAME(I4) 
          IF(L1A_COOR_FLAG(I4).NE.'Y') ICOOR = 0
        ELSE 
          ACHIR(4) = '.'  
          ICOOR = 0
        ENDIF
       
        IF(L1C_SIGN(L)(1:4).EQ.'cros'.OR.
     *     L1C_SIGN(L)(1:4).EQ.'star'    ) ICOOR = 1

        IF(ICOOR.EQ.1) THEN
          N=N+1 
          VOL=L1C_VOL(L)
          LINE=L1C_SIGN(L)
          IF(LINE(1:3).EQ.'neg') VOL=-VOL 
          WRITE(CH30(N),400) 
     *    ACHIR(1),ACHIR(2),ACHIR(3),ACHIR(4)
 400      FORMAT(A4,'->',A4,'-',A4,'-',A4)
          WRITE(CH28(N),410) 
     *    VOL
 410      FORMAT(2F8.2)
          WRITE(CH28A(N),410) 
     *    L1C_VOBS(L)
          IF(N.EQ.3) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
            CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
            CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
            CALL TXTEXT(CH28A(3),ISIZE,IXL,IYL3A,IMOD)
            DO I=1,3
              CH30(I)=' '
              CH28(I)=' '
              CH28A(I)=' '
            ENDDO
            N=0
            IXL=IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      IF(N.GT.0) THEN
        CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
        CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
        CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
        CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
        CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
        CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
        CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
        CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
        CALL TXTEXT(CH28A(3),ISIZE,IXL,IYL3A,IMOD)
        DO I=1,3
          CH30(I)=' '
          CH28(I)=' '
          CH28A(I)=' '
        ENDDO
        N=0
        IXL=IXL+IDEL
        IF(IXL.GT.IXLMAX) THEN
          CALL NEWPG
          CALL TITLE_MONL(MON)
          IXL=ISHX
        ENDIF
      ENDIF
      ENDIF

      ENDIF
C ---------------------------------------
      IF(L1P_NPLAN.GT.0) THEN

      LINE='PLANES'
      IXL   = IXL+ID1
      IXLP=IXL+ID1
      IF(IXLP.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      CALL TXTEXT(LINE,ISIZE1,IXL,IYLT,IMOD)
C ---
      LINE='Disp_crd esd'
      IXL   = IXL+ID1
      IY1= 15
      IY2= 35+L3
      IY3= 35+L3*2
      IYL1=IY1+65
      IYL2=IY2+65
      IYL3=IY3+65
      IYY1=IYL1+5
      IYY2=IYL2+5
      IYY3=IYL3+5
      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY3,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I)=' '
        CH28(I)=' '
      ENDDO
      N=0
      NP=L1P_NPLAN
      IF(NP.GT.0) THEN
        DO IP=1,NP
        NA=L1P_NATOM(IP)
        DO IA=1,NA
          N=N+1 
          WRITE(CH30(N),500) 
     *    L1P_LABEL(IP),L1P_ATOM(IA,IP)
 500      FORMAT(A8,' ',A4)
          WRITE(CH28(N),510) 
     *    L1P_DOBS(IA,IP),L1P_DEV(IA,IP) 
 510      FORMAT(2F7.3)
          IF(N.EQ.3) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
            CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
            DO I=1,3
              CH30(I)=' '
              CH28(I)=' '
            ENDDO
            N=0
            IXL=IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDDO
        ENDDO
        IF(N.GT.0) THEN
          CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
          CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
          CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
          CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
          CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
          CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
          DO I=1,3
            CH30(I)=' '
            CH28(I)=' '
          ENDDO
          N=0
          IXL=IXL+IDEL
          IF(IXL.GT.IXLMAX) THEN
            CALL NEWPG
            CALL TITLE_MONL(MON)
            IXL=ISHX
          ENDIF
        ENDIF
      ENDIF

      ENDIF
C -----------------------------------

      CALL ENDTX

      RETURN
      END

      SUBROUTINE TITLE_MONL(MON)
      CHARACTER MON*(*),LINE*256
C -------------------------------
      IMOD  =  1
      IDEL  =  2
      ISIZE = 20
      IXL1  = 25
      IYL   = 230
      LINE  = MON
      CALL TXTEXT(LINE,ISIZE,IXL1,IYL,IMOD)
      RETURN
      END

      SUBROUTINE TITLE_MONL_1(MON,MNAME)
      CHARACTER MON*(*),LINE*256,MNAME*(*)
C -------------------------------
      CALL LENSTR_BL(MNAME,LEN)
      IF(LEN.GT.3.AND.MNAME(1:1).NE.'.') THEN
        IMOD  =  1
        ISIZE = 20
        IXL1  = 15
        IYL   = 230
        LINE  = MON
        CALL TXTEXT(LINE,ISIZE,IXL1,IYL,IMOD)
        ISIZE = 10
        IXL1  = 35
        IYL   = 220 - LEN/2
        LINE  = MNAME(1:LEN)
        CALL TXTEXT(LINE,ISIZE,IXL1,IYL,IMOD)
      ELSE
        IMOD  =  1
        ISIZE = 20
        IXL1  = 25
        IYL   = 230
        LINE  = MON
        CALL TXTEXT(LINE,ISIZE,IXL1,IYL,IMOD)
      ENDIF
      RETURN
      END

      SUBROUTINE PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)
C -----------------------------------------------
      REAL      X(3)
      INTEGER   IXP(2)
C --------------------------------------------------------
      Z0     = RADBOR*6.0
      XP     = (X(1)*Z0)/(Z0-X(3))
      YP     = (X(2)*Z0)/(Z0-X(3))
      IXP(1) = (XP*SCALE+IBX/2.0)*10.0
      IXP(2) = (YP*SCALE+IBX/2.0)*10.0
      RETURN
      END

      SUBROUTINE DRAW_FRAME(IBX,IBY)
      IT  = 0
      IT1 = 0
      CALL MOVTXX(IT,IT1)
      IT  = 0
      IT1 = IBY*10.0
      CALL VECTXX(IT,IT1)
      IT  = IBX*10.0
      IT1 = IBY*10.0
      CALL VECTXX(IT,IT1)
      IT  = IBX*10.0
      IT1 = 0
      CALL VECTXX(IT,IT1)
      IT  = 0
      IT1 = 0
      CALL VECTXX(IT,IT1)
      RETURN
      END

C ===============================================

      SUBROUTINE WR_CIF_NEW(MDOC,IUN,PROG,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,IUN
      CHARACTER MON*8,PROG*(*)
      REAL      X(3)
C ----
      CHARACTER LINE*256,TITLE*80,WATOM1*6
      CHARACTER ATOM*4,ASYMB*4,CH27*27,ATOM_FLAG*1,CH1*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'CIF_items_crd.fh'
C --------------------------------------------------------
      CH1=''''
      NA  = L1A_NATOM
      MON = L1L_MNAME
      CALL LENSTR_BL(PROG,LP)
C --
      WRITE(LINE,'(''data_structure_'',A)') MON
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C      WRITE(LINE,'(''_database_2.database_id'',2X,A)') MON
C      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---_entry.id
      CALL LENSTR_BL(ICS_ENTRY_ID,L)
      WRITE(LINE,'(A,2X,A)')
     *ICS_ENTRY_ID(1:L),MON
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---_database_2.code_PDB
      CALL LENSTR_BL(ICS_CAT_PDB,L)
      WRITE(LINE,'(A,2X,A)')
     *ICS_CAT_PDB(1:L),MON
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C --- 
      TITLE='coordinates of '//MON//' from program: '//PROG(1:LP)
      CALL LENSTR_BL(TITLE,LEN)
C --- _struct.title
      CALL LENSTR_BL(ICS_TITLE,L)
      I=LEN+L+4      
      IF(I.GT.78) LEN=78-L-4
      WRITE(LINE,'(A,2X,A,A,A)')
     * ICS_TITLE(1:L),CH1,TITLE(1:LEN),CH1
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---
      CALL LENSTR_BL(ICS_CELL_ENT,L)
      WRITE(LINE,'(A,2X,A)')
     *ICS_CELL_ENT(1:L),MON
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---
      T=100.0
      CALL LENSTR_BL(ICS_CELL1,L)
      WRITE(LINE,'(A,5X,F8.3)') 
     * ICS_CELL1(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ICS_CELL2,L)
      WRITE(LINE,'(A,5X,F8.3)') 
     * ICS_CELL2(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ICS_CELL1,L)
      WRITE(LINE,'(A,5X,F8.3)')
     * ICS_CELL3(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      T=90.0
      CALL LENSTR_BL(ICS_CELL4,L)
      WRITE(LINE,'(A,2X,F8.3)')
     * ICS_CELL4(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ICS_CELL5,L)
      WRITE(LINE,'(A,3X,F8.3)')
     * ICS_CELL5(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ICS_CELL6,L)
      WRITE(LINE,'(A,2X,F8.3)')
     * ICS_CELL6(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---
C --- _symmetry.
      CALL LENSTR_BL(ICS_SYMM_ID,L)
      WRITE(LINE,'(A,2X,A)') ICS_SYMM_ID(1:L),MON 
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C --- _symmetry.space_group_name_H-M
      CALL LENSTR_BL(ICS_SYMM_SPGR,L)
      WRITE(LINE,'(A,2X,A,A,A)') 
     * ICS_SYMM_SPGR(1:L),CH1,'P 1',CH1
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C --- _symmetry.Int_Tables_number
      CALL LENSTR_BL(ICS_SYMM_NSPGR,L)
      WRITE(LINE,'(A,2X,A)')
     * ICS_SYMM_NSPGR(1:L),'1'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C --- _symmetry.cell_setting_number
C      CALL LENSTR_BL(ICS_SYMM_SETT,L)
C      WRITE(LINE,'(A,2X,A)') 
C     *ICS_SYMM_SETT(1:L),'1'
C      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C -----------------------------------
      WRITE(LINE,'(''loop_'')') 
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---   _symmetry_equiv.id
      CALL LENSTR_BL(ICS_SYMM_EID,L)
      WRITE(LINE,'(A)') 
     *ICS_SYMM_EID(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---   _symmetry_equiv.pos_as_xyz
      CALL LENSTR_BL(ICS_SYMM_SYMOP,L)
      WRITE(LINE,'(A)')
     *ICS_SYMM_SYMOP(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---
      LINE='  1   X,Y,Z'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ------------
C --- _entity.
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _entity.id
      CALL LENSTR_BL(ICS_ENT_ID,L)
      WRITE(LINE,'(A)') ICS_ENT_ID(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _entity.type
      CALL LENSTR_BL(ICS_ENT_TYP,L)
      WRITE(LINE,'(A)') ICS_ENT_TYP(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      LINE='   AA   non-polymer'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C --- _struct_asym.
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _struct_asym.id
      CALL LENSTR_BL(ICS_ASYM_ID,L)
      WRITE(LINE,'(A)') ICS_ASYM_ID(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _struct_asym.entity_id
      CALL LENSTR_BL(ICS_ASYM_ENT,L)
      WRITE(LINE,'(A)') ICS_ASYM_ENT(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C _struct_asym.nc_symmetry_id    
c      CALL LENSTR_BL(ICS_ASYM_NCS,L)
c      WRITE(LINE,'(A)') ICS_ASYM_NCS(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C _struct_asym.nc_symmetry_flag
c      CALL LENSTR_BL(ICS_ASYM_FLAG,L)
c      WRITE(LINE,'(A)') ICS_ASYM_FLAG(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C _struct_asym.multiplicity
c      CALL LENSTR_BL(ICS_ASYM_MULT,L)
c      WRITE(LINE,'(A)') ICS_ASYM_MULT(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_struct_asym.PDB_chain_label
c      CALL LENSTR_BL(ICS_ASYM_PDB,L)
c      WRITE(LINE,'(A)') ICS_ASYM_PDB(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ----------
      LINE = '   AA   AA'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ------------
C -- _atom_site.
      CALL LENSTR_BL(ITA_ATOM_CAT,LC)
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C -- _atom_site.id
      CALL LENSTR_BL(ITA_IATOM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_IATOM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_atom_site.label_atom_id
      CALL LENSTR_BL(ITA_ATOM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ATOM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_atom_site.label_alt_id
      CALL LENSTR_BL(ITA_ALT,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ALT(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

c      CALL LENSTR_BL(ITA_ID_CORR,L)
c      WRITE(LINE,'(A,A)')
c     * ITA_ATOM_CAT(1:LC),ITA_ID_CORR(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C_atom_site.label_comp_id
      CALL LENSTR_BL( ITA_RES,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_RES(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_atom_site.label_asym_id
      CALL LENSTR_BL(ITA_ASYM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ASYM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_atom_site.label_seq_id
      CALL LENSTR_BL(ITA_ISEQ,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ISEQ(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_XYZ_CRD1,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_XYZ_CRD1(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_XYZ_CRD2,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_XYZ_CRD2(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_XYZ_CRD3,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_XYZ_CRD3(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_OCCUP,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_OCCUP(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_B_ISO,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_B_ISO(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

c_atom_site.thermal_displace_type
c      CALL LENSTR_BL(ITA_B_FLAG,L)
c      WRITE(LINE,'(A,A)')
c     * ITA_ATOM_CAT(1:LC),ITA_B_FLAG(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C_atom_site.type_symbol
      CALL LENSTR_BL(ITA_SYMB,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_SYMB(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C_atom_site.symmetry_multiplicity
c      CALL LENSTR_BL(ITA_MULT,L)
c      WRITE(LINE,'(A,A)')
c     * ITA_ATOM_CAT(1:LC),ITA_MULT(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C_atom_site.calc_flag
      CALL LENSTR_BL(ITA_CALC,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_CALC(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ----------------------------

      DO I=1,NA

        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN

          X(1) = L1A_X(I)
          X(2) = L1A_Y(I)
          X(3) = L1A_Z(I)
          WRITE(CH27,'(3(1X,F8.3))') X(1),X(2),X(3)
          ATOM_FLAG = '.'
        ELSE
          CH27='     .        .        .   '
          ATOM_FLAG = 'D'
        ENDIF
        
        WATOM1  = L1A_ANAME(I)
        CALL CORR_NAME_CIF_OUT(WATOM1)
        ASYMB = L1A_SYMB(I)

        CALL LENSTR_BL(ASYMB,LN)
C --- 9.07.03
        IF(LN.GT.3) LN = 3
        ASYMB = ' '//ASYMB(1:LN)
c ---
c        IF(LN.LE.2.AND.L1A_CHARG(I).NE.0.0) THEN
c          CHARGE  = ABS(L1A_CHARG(I)) + 0.1
c          ICHARGE = CHARGE 
c          WRITE(CH1,'(I1)') ICHARGE
c          ASYMB(LN+1:LN+1) = '+'
c          IF(L1A_CHARG(I).LT.0.0) ASYMB(LN+1:LN+1) = '-'
c          ASYMB(LN+2:LN+2) = CH1
c        ENDIF 
c ---
        WRITE(LINE,200) I,WATOM1,MON,CH27,ASYMB,ATOM_FLAG
  200   FORMAT(I5,1X,A6,' . ',A8,' AA  1',A27
     *  ,'   1.00  20.0 ',1X,A4,1X,A1)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

      ENDDO

      END FILE IUN
      CLOSE(IUN,ERR=300)
 300  CONTINUE
      RETURN
      END

      SUBROUTINE WR_PDB_NEW(MDOC,IUN,PROG,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,IUN
      CHARACTER MON*8,PROG*(*)
      REAL      X(3)
C ----
      CHARACTER LINE*256,TITLE*80,CODE*4,RES*3,CH1*1
      CHARACTER ATOM*4,ASYMB*4,ANAME*4,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C --------------------------------------------------------
      NA  = L1A_NATOM
      MON = L1L_MNAME
      CALL LENSTR_BL(PROG,LP)
      CALL LENSTR_BL(MON,LM)
C --
C ---- PDB-TITLE ----
      IF(LP.GT.10) LP = 10
C            123456789     12345678    9 123456789    123456789 ! 
      TITLE='coords of ' //MON(1:LM)//' from prog: '//PROG(1:LP)
      CALL LENSTR_BL(TITLE,LEN)
      IF(LEN.LT.40) THEN
        DO II=LEN+1,40
          TITLE(II:II) = ' '
        ENDDO
      ENDIF
      LMM  = LM
      IF(LM.GT.4) LMM = 4
      CODE = MON(1:LMM)
      IF(LM.LE.3) CODE(4:4) = ' '
      IF(LM.LE.2) CODE(3:3) = ' '
      IF(LM.LE.1) CODE(2:2) = ' '
      WRITE(LINE,140) TITLE(1:40),CODE
  140 FORMAT ('HEADER',4X,A40,9X,3X,A4)
      CALL LENSTR_BL(LINE,LN)
      IF(LN.GT.0) THEN
        WRITE(IUN,'(A)') LINE(1:LN)
      ENDIF
      IF(LM.GT.3) THEN
        WRITE(LINE,200) 
     *  'MODRES'
     *  ,MON(1:3),'A','   1 ',MON
     *  ,'RENAME  '
 200    FORMAT(A6,6X,A3,1X,A1,1X,A5,1X,A8,40X,A8)
        CALL LENSTR_BL(LINE,LN)
        WRITE(IUN,'(A)') LINE(1:LN)        
      ENDIF
C ------------
      CELL1 = 100.0
      CELL2 = 100.0
      CELL3 = 100.0
      CELL4 = 90.0
      CELL5 = 90.0
      CELL6 = 90.0
      WRITE(LINE,100) CELL1,CELL2,CELL3
     *           ,CELL4,CELL5,CELL6,'P 1'
  100 FORMAT ('CRYST1',3F9.3,3F7.2,1X,A)
      CALL LENSTR_BL(LINE,LN)
      IF(LN.GT.0) THEN
        WRITE(IUN,'(A)') LINE(1:LN)
      ENDIF
C ------------
      DO I=1,NA

        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN

          X(1) = L1A_X(I)
          X(2) = L1A_Y(I)
          X(3) = L1A_Z(I)
        
          ATOM  = L1A_ANAME(I)
          ASYMB = L1A_SYMB(I)

          CALL PDB_ANAME(ATOM,ASYMB,RES,ANAME)

          ASYMB = L1A_SYMB(I)

          CALL LENSTR_BL(ASYMB,LN)
C --- 9.07.03
          IF(LN.GT.3) LN = 3
          if(ln.eq.1) then
             ASYMB = ' '//ASYMB(1:LN)
          else
             if(asymb(2:2).eq.'+'.or.asymb(2:2).eq.'-') then
                asymb = ' '//asymb(1:ln)
             endif
          endif
C ---
c          IF(LN.LE.2.AND.L1A_CHARG(I).NE.0.0) THEN
c            CHARGE  = ABS(L1A_CHARG(I)) + 0.1
c            ICHARGE = CHARGE 
c            WRITE(CH1,'(I1)') ICHARGE
c            ASYMB(LN+1:LN+1) = '+'
c            IF(L1A_CHARG(I).LT.0.0) ASYMB(LN+1:LN+1) = '-'
c            ASYMB(LN+2:LN+2) = CH1
c            IF(LN.LE.1) THEN
c              ASYMB = ' '//ASYMB(1:LN+2)
c            ENDIF
c          ELSE
c            IF(LN.LE.1) THEN
c              ASYMB = ' '//ASYMB(1:LN+2)
c            ENDIF
c          ENDIF 
C ---
          IRES = 1
          OCC  = 1.0
          B    = 20.0
          WRITE(LINE,400) I,ANAME,CODE(1:3),IRES
     *                 ,X(1),X(2),X(3),OCC,B,ASYMB
 400  FORMAT('ATOM',1X,I6,1X,A4,1X,A3,1X,'A',I4,4X,3F8.3,2F6.2,10X,A4)
          CALL LENSTR_BL(LINE,LN)
          IF(LN.GT.0) THEN
            WRITE(IUN,'(A)') LINE(1:LN)
          ENDIF
        ENDIF
      ENDDO

      END FILE IUN
      CLOSE(IUN,ERR=300)
 300  CONTINUE
      RETURN
      END

      SUBROUTINE WRITE_TEST(MDOC,k,STR)
C --------------------------------------------
      INTEGER*4 MDOC,k
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8,STR*(*)
C ---------------------------------------------
      IF(ABS(MDOC).GE.99) RETURN
      NA     = L1A_NATOM
      MON    = L1L_MNAME

      CALL MSGDOC(MDOC,'----------')
      CALL MSGDOC(MDOC,STR)
      WRITE(LINE,*) '--',MON,'--',L1L_PRSNT,'--',k
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(a,5i5)') 
     * '--',NA,L1N_NCONN,C1_NATOM,L1A_NHATOM,L1B_NBOND       
      CALL MSGDOC(MDOC,LINE)

      CALL MSGDOC(MDOC,'--aname,atype,chem,coor_flag')
      DO I=1,NA
         WRITE(LINE,*)
     *   i,L1A_ANAME(I),'/',L1A_ATYPE(I),'/',L1A_CHEM(I)
     *  ,'/',L1A_COOR_FLAG(I),'/',L1A_X(I),L1A_Y(I),L1A_Z(I)
     *  ,L1A_NDIST(I)
        CALL MSGDOC(MDOC,LINE)
      ENDDO

      if(k.eq.1) return

      CALL MSGDOC(MDOC,'--aname,atype,ndist,conn(1,..)')
      DO I=1,NA
        nd = L1A_NDIST(I)
        if(nd.gt.12) nd=12
        if(nd.gt.0) then
          WRITE(LINE,'(i5,a,a,a,a,a,i5,12i5)')
     *    i,'/',L1A_ANAME(I),'/',L1A_ATYPE(I),'/',nd,
     *    (L1A_CONN(j,I),j=1,nd)
        else
          WRITE(LINE,'(i5,a,a,a,a,a,i8)')
     *    i,'/',L1A_ANAME(I),'/',L1A_ATYPE(I),'/',nd
        endif
        CALL MSGDOC(MDOC,LINE)
      ENDDO
      CALL MSGDOC(MDOC,'----')
      WRITE(LINE,'('' -- Nbond:'',i5)') L1B_NBOND 
        CALL MSGDOC(MDOC,LINE)

      IF(L1B_NBOND.GT.0.and.k.eq.2) THEN
        DO IB=1,L1B_NBOND 
   
          IA = L1B_I1ATM(IB) 
          JA = L1B_I2ATM(IB) 
          IF(IA.GT.0.AND.JA.GT.0) THEN        
          WRITE(LINE,*)
     *    IB,'/',L1A_ANAME(iA),'--',L1A_ANAME(JA),'/'
     *    ,L1B_VOBS(IB),L1B_TYPE(IB) 
          CALL MSGDOC(MDOC,LINE)
          ELSE
          WRITE(LINE,*) IB,' -- wrong bond'
          CALL MSGDOC(MDOC,LINE)
          ENDIF
        ENDDO
      ENDIF
      CALL MSGDOC(MDOC,'----------')

      if(k.eq.2) return
 
      LINE = '--aname,atypr,chem,ichir,ichem,iback'//
     * 'iforw,len(1),len(2),nr,rid(1),r_ord,r_flt'
      CALL MSGDOC(MDOC,LINE)
      DO I=1,NA
        nr = L1A_NRING(I)
        nri= 0
        nro= 0
        IF(NR.GT.0) THEN
          NRI = L1A_RING_ID (1,I) 
          NRO = L1A_RING_ORD(1,I)
          IFLAT = L1A_RING_FLAT(1,I)
        ENDIF
        WRITE(LINE,'(I5,A,A,A,A,A,A,I5,I5,I5,4i5,3i5)')
     *  i,L1A_ANAME(I),'/',L1A_ATYPE(I),'/',L1A_CHEM(I),'/',
     *  L1A_ICHIR(I),L1A_ICHEM(I),L1A_IBACK(I),L1A_IFORW(I)
     * ,L1A_LENCON(1,I),L1A_LENCON(2,I)
     * ,NR,NRI,NRO,IFLAT      
        CALL MSGDOC(MDOC,LINE)
      ENDDO
      CALL MSGDOC(MDOC,'----------')

      RETURN
      END

      SUBROUTINE TORSION_CORRECTION(MDOC,LIST,NRINGT,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LIST*1,FLAG*1
      CHARACTER LINE*256
      INTEGER IRING,NR,IFLAT,IATOM(6),ICHIR(6),IACHIR(6),ICONN(6)
      INTEGER NPHI(6),NCH(6),IBOND(6),IPHI(6) 
      REAL    PHI(6) 

      INTEGER MAXRING
      PARAMETER (MAXRING  = 200 )
      INTEGER IORDER(MAXRING),ISCORE(MAXRING)
C --------------------------------------------------------
      IERR = 0
C ---
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IF(L1A_NATOM.LE.3) RETURN
      IF(L1T_NTORS.LE.0) RETURN

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' --- TORSION_CORRECTION --',NRINGT
      ENDIF
C ---
      IF(L1C_NCHIR.GT.0) THEN
C     L1C_FLAG = 'N'- user def(min descr); new: 'R'or 'L' from coord;'B' both
C                     L1L_PRSNT='M'        L1L_PRSNT='M'or'N'
C       check user chiralities. From coords will be accepted.      
        DO  I = 1,L1C_NCHIR 
          IF(L1C_SIGN(I)(1:4).EQ.'star'.OR.
     *       L1C_SIGN(I)(1:4).EQ.'cros'     ) THEN
            L1C_FLAG(I) = 'X'
          ELSE 
            IF(L1C_FLAG(I).EQ.'N') THEN
              IF(L1C_SIGN(I)(1:3).EQ.'pos') THEN
                FLAG = 'R'
              ELSE IF(L1C_SIGN(I)(1:3).EQ.'neg') THEN
                FLAG = 'L'
              ELSE
                FLAG = 'B'
              ENDIF
              CALL CALC_OVOL(I,VOLOBS,IERR)
              IF(IERR.EQ.0) THEN
                IF(VOLOBS.LT.0.0) THEN
                  L1C_FLAG(I) = 'L'
                ELSE
                  L1C_FLAG(I) = 'R'
                ENDIF
              ELSE
                L1C_FLAG(I) = FLAG
              ENDIF
              IERR = 0
              IF(FLAG.NE.'B'.AND.FLAG.NE.L1C_FLAG(I)) THEN
                LINE = 
     *' WARNING: in TORSION_CORRECTION: problem with chir:'//L1C_1ATM(I)
                CALL MSGERR(MDOC,LINE)
                LINE = 
     *         '          '//'user chiralities<->from coords (accepted)' 
                CALL MSGERR(MDOC,LINE)
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDIF
C ---
      IF(NRINGT.LE.0) RETURN

C --- ring order: plan, ring6(flat),ring5(flat); ring6(flat),ring5 
C                        sp2 >4       sp2 > 2
C     Icoef       *10000     *1000     *100          *10
C     NBR( neighbor rings+1)   ---  7,6,5,4,3,2,1 ----                 
C     ISCORE() = ICOEF*NBR           

      NRT = 0
      DO IRING=1,NRINGT
        CALL GET_RING(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR       
     *                    ,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
        IF(LIST.EQ.'T') THEN
          WRITE(*,*) ' ierr --',ierr,NR
        ENDIF
        IF(IERR.EQ.2) THEN
          CALL MSGERR(MDOC,
     *    ' WARNING: not possible to do Torsion Correction')
          IERR = 0
          GO TO 500
        ENDIF
        IF(IERR.EQ.3) THEN
C         some ring with theta = 180
        ENDIF
        IF(IERR.EQ.0.AND.NRT.LT.MAXRING) THEN 
          NRT         = NRT + 1
          IORDER(NRT) = IRING
          NBR         = 0
          DO I=1,NR
            IF(IBOND(I).GT.0) NBR = NBR + 1
          ENDDO
        
          ICOEF = 1
          IF(NR.EQ.6) ICOEF = 10 
          IF(IFLAT.EQ.2) ICOEF = 10000  
          IF(IFLAT.EQ.1.AND.NR.EQ.6) ICOEF = 1000  
          IF(IFLAT.EQ.1.AND.NR.EQ.5) ICOEF = 100  
          ISCORE(NRT) = ICOEF*(NBR+1) 
        ELSE
          IERR = 0 
          IF(NRT.GE.MAXRING) GO TO 600
        ENDIF
      ENDDO
 600  CONTINUE

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' NRT --',NRT,IORDER(1)
      ENDIF

        IF(LIST.EQ.'T') THEN
          IF(L1C_NCHIR.GT.0) THEN
            DO IC=1,L1C_NCHIR
             WRITE(*,'(A,5I5,A)') 'CH:',IC,L1C_I1ATM(IC),L1C_I2ATM(IC)
     *         ,L1C_I3ATM(IC),L1C_I4ATM(IC),L1C_FLAG(IC)
            ENDDO
          ENDIF
          IF(L1T_NTORS.GT.0) THEN
            DO IT=1,L1T_NTORS
              WRITE(*,'(A,5I5,A,F8.2)') 'TR:',IT,L1T_I1ATM(IT)
     *        ,L1T_I2ATM(IT),L1T_I3ATM(IT),L1T_I4ATM(IT),L1T_FLAG(IT)
     *        ,L1T_VOBS(IT)
            ENDDO
          ENDIF
        ENDIF




      IF(NRT.LE.0) THEN
C       no rings -  5, 6
        CALL MSGERR(MDOC,
     *  ' WARNING: all rings are not 5 or 6 order')
        GO TO 500
      ENDIF

C     sort
      IF(NRT.GT.1) THEN
        DO I=1,NRT-1      
          DO J=2,NRT
            IF(ISCORE(I).LT.ISCORE(J)) THEN
              IT        = ISCORE(J) 
              ISCORE(J) = ISCORE(I)
              ISCORE(I) = IT 
              IT        = IORDER(J) 
              IORDER(J) = IORDER(I)
              IORDER(I) = IT 
            ENDIF      
          ENDDO
        ENDDO
      ENDIF
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' NRT,IORD(1) --',NRT,IORDER(1)
        WRITE(*,*) ' ----START plan-CYCLES ---'
      ENDIF
C ---
C     flat rings    
      DO JRING=1,NRT
        IRING = IORDER(JRING) 
        CALL GET_RING(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN,IPHI       
     *                    ,NCH,NPHI,IBOND,LIST,IERR)        

C        WRITE(*,*) ' --plan:',iring,iflat,ierr

        IF(IERR.NE.0.OR.IFLAT.LE.0) THEN
          IERR = 0
          GO TO 100
        ENDIF

        CALL SET_PLAN_TORS(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN
     *                   ,IPHI,NCH,NPHI,IBOND,LIST,IERR)        

        IF(IERR.NE.0) RETURN

        IF(LIST.EQ.'T') THEN
          IF(L1C_NCHIR.GT.0) THEN
            DO IC=1,L1C_NCHIR
            WRITE(*,'(A,5I5,A)') 'CH:',IC,L1C_I1ATM(IC),L1C_I2ATM(IC)
     *         ,L1C_I3ATM(IC),L1C_I4ATM(IC),L1C_FLAG(IC)
            ENDDO
          ENDIF
          IF(L1T_NTORS.GT.0) THEN
            DO IT=1,L1T_NTORS
              WRITE(*,'(A,5I5,A,F8.2)') 'TR:',IT,L1T_I1ATM(IT)
     *       ,L1T_I2ATM(IT),L1T_I3ATM(IT),L1T_I4ATM(IT),L1T_FLAG(IT)
     *       ,L1T_VOBS(IT)
            ENDDO
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO
C ---
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' ----START ring -CYCLES ---'
      ENDIF

C     non-flat rings
      DO JRING=1,NRT
        IRING = IORDER(JRING) 
        CALL GET_RING(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN,IPHI       
     *                    ,NCH,NPHI,IBOND,LIST,IERR)        

c        WRITE(*,*) ' --tors:',iring,iflat,ierr

        IF(IERR.NE.0.OR.IFLAT.GE.1) THEN
          IERR = 0
          GO TO 200
        ENDIF

        CALL SET_RING_TORS(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN
     *                   ,IPHI,NCH,NPHI,IBOND,LIST,IERR)        

        IF(IERR.NE.0) RETURN

        IF(LIST.EQ.'T') THEN
          IF(L1C_NCHIR.GT.0) THEN
            DO IC=1,L1C_NCHIR
             WRITE(*,'(A,5I5,A)') 'CH:',IC,L1C_I1ATM(IC),L1C_I2ATM(IC)
     *         ,L1C_I3ATM(IC),L1C_I4ATM(IC),L1C_FLAG(IC)
            ENDDO
          ENDIF
          IF(L1T_NTORS.GT.0) THEN
            DO IT=1,L1T_NTORS
              WRITE(*,'(A,5I5,A,F8.2)') 'TR:',IT,L1T_I1ATM(IT)
     *        ,L1T_I2ATM(IT),L1T_I3ATM(IT),L1T_I4ATM(IT),L1T_FLAG(IT)
     *        ,L1T_VOBS(IT)
            ENDDO
          ENDIF
        ENDIF


 200    CONTINUE
      ENDDO

 500  CONTINUE

      DO ITORS=1,L1T_NTORS
        I1 = L1T_I1ATM(ITORS)
        I2 = L1T_I2ATM(ITORS)
        I3 = L1T_I3ATM(ITORS)
        I4 = L1T_I4ATM(ITORS)
        IF(L1T_FLAG(ITORS).EQ.'D') THEN
c          L1T_VAL(ITORS) =  L1T_VOBS(ITORS)
          IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0.AND.I4.GT.0) THEN
          IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *       L1A_COOR_FLAG(I3).EQ.'Y'.AND.L1A_COOR_FLAG(I4).EQ.'Y') THEN
            CALL CALC_TRSOBS(I1,I2,I3,I4,VOBS)
            L1T_VOBS(ITORS) = VOBS
          ENDIF
          ENDIF         
        ENDIF         
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE GET_RING(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN
     *                   ,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     neighbor: 2-plan,1-flat, 5, 6
C                          
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*),IPHI(*)
      CHARACTER CHEM*4,LIST*1              
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0      
      NR   = 0      

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '------------> GET_RING:',IRING 
      ENDIF

C     NR IATOM()        
      DO IA=1,L1A_NATOM
        IF(L1A_NRING(IA).NE.0) THEN
          DO IRA=1,L1A_NRING(IA)
            IRING_ID = L1A_RING_ID (IRA,IA)
C           IORD     = L1A_RING_ORD(IRA,IA)
            IF(IRING_ID.EQ.IRING) THEN
              NR   = NR + 1
C             IFL      = L1A_RING_FLAT(IRA,IA)
C             IFL > 0  flat
              IF(NR.LE.6) THEN        
                IATOM(NR) = IA
              ENDIF
            ENDIF
          ENDDO
        ENDIF 
      ENDDO
      IF(NR.LT.5.OR.NR.GT.6) THEN
        IERR = 1 
        RETURN
      ENDIF 

C ---------------
C     order
      CALL GET_RING_ORDER(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN
     *                    ,IPHI,NCH,NPHI,IBOND,IERR)        
      IF(IERR.NE.0) RETURN
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '--NR:',NR        
        WRITE(*,'(A,6I5)') '--iatom:',(IATOM(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6(1X,A4))') 
     *   '--atom :',(L1A_ANAME(IATOM(JJJJ)),JJJJ=1,NR) 
      ENDIF     
C ---------------
C     flat: 2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)
C
c     (ia1,ia2--ia..) in the same plan iflat = 2
c     else   Nsp2  (ring6: sp2 >4 ; ring5: sp2 > 2) --> iflat = 1    

      IFLAT = 0

      CALL CHECK_RING_IS_PLAN(IRING,IFLAGP) 
      IF(IFLAGP.GT.0) IFLAT = IFLAGP

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,I5)') '--FLAT:',IFLAT
      ENDIF     

C ---------------
c     ICONN() = 1 met_chir
C ---------------
C      NCH()           ICHIR()             IACHIR()   
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom    
C                                                          
      CALL GET_RING_CHIR(MDOC,IRING,NR,JFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)     
      IF(IERR.NE.0) RETURN

      IF(JFLAT.GT.0.AND.IFLAT.LE.0) IFLAT = JFLAT

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '--NCH :',(NCH(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '--CHIR:',(ICHIR(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '--ACHR:',(IACHIR(JJJJ),JJJJ=1,NR) 
      ENDIF     
C
C ---------------
C     NPHI()           IPHI() 
C     tors_id         0,(+/-)1,9 

      CALL GET_RING_TORS(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '--NPHI:',(NPHI(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '--IPHI:',(IPHI(JJJJ),JJJJ=1,NR) 
      ENDIF     
C
C ---------------
C     IBOND()        
C     neighbor: 2-plan,1-flat, 5, 6

      CALL GET_RING_BOND(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '--BOND:',(IBOND(JJJJ),JJJJ=1,NR) 
      ENDIF     
C
C ---------------
      RETURN
      END

      SUBROUTINE SET_PLAN_TORS(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR
     *                  ,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat, 5, 6
C                          
C ----
C ----
      CHARACTER LIST*1,LINE*256
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0      
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '------------> SET_PLAN_TORS:',IRING 
      ENDIF

      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)

        IF(NPHI(I2).LE.0) THEN
C         there is no tors
C
          LINE = 
     *' WARNING: in TORSION_CORRECTION: missing tors.:'//L1A_ANAME(IA2)
     *         //' - '//L1A_ANAME(IA3)     
          CALL MSGERR(MDOC,LINE)
          NV = 0
          NC = 0  
          CALL SET_VTORS(MDOC,IA1,IA2,IA3,IA4,NV,NC,IERR)
          IF(IERR.NE.0) RETURN
          IPHI(I2) = 9
          NPHI(I2) = L1T_NTORS
          L1T_VOBS(L1T_NTORS) = 0.0
          IF(ICONN(I2).GT.0.OR.ICONN(I3).GT.0) L1T_VAL(L1T_NTORS)=0.0
        ENDIF

        ICHIR2 = ICHIR(I2)
        ICHIR3 = ICHIR(I3)

        IF(NPHI(I2).GT.0) THEN
          IF(IBOND(I2).GT.0) THEN
C           there is neighbor ring I2-I3
C
            CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 
 
            IF(IPHI(I2).LT.9) THEN
C             tors was defined before           
C             check ichir(i2),ichir(i3) # 9 (if(nch(i2),nch(i3) > 0)
            ELSE
C             set chir I2,I3: (RR) (LL) 
              IF(NCH(I2).GT.0.AND.NCH(I3).GT.0) THEN        
                IF(ICHIR2.EQ.9) THEN
C                 9 --> ? 
                  IF(ICHIR3.EQ.1) THEN
C                   set R - (R)
                    ICHIR2 = 1 
                  ELSE IF(ICHIR3.EQ.-1) THEN
C                   set L - (L)
                    ICHIR2 =-1 
                  ELSE
C                   set R - R (i.e 9-9) 
                    ICHIR2 = 1 
                    ICHIR3 = 1 
                  ENDIF   
                ELSE IF(ICHIR3.EQ.9) THEN
C                 9 --> ?
                  IF(ICHIR2.EQ.1) THEN
C                   set (R) - R 
                    ICHIR3 = 1 
                  ELSE IF(ICHIR3.EQ.-1) THEN
C                   set (L) - L
                    ICHIR3 =-1 
CC--              ELSE
CC--                set RR
CC--                ICHIR2 = 1 
CC--                ICHIR3 = 1 
                  ENDIF   
                ELSE IF(ICHIR2.NE.ICHIR3) THEN
C                 not possible (R-L or L-R)
C                 ?
                ENDIF
              ELSE
                IF(ICHIR2.EQ.0.AND.ICHIR3.EQ.9) THEN
C                 0 --> 9
                  IF(IBOND(I3).GT.0) THEN
                    IF(ICHIR(I4).GE.0) THEN
C                          3
C                     set  R - (R) or R - (0) or  R - (9) 
                      ICHIR3 = 1 
                    ELSE IF(ICHIR(I4).EQ.-1) THEN
C                          3
C                     set  L - (L)  
                      ICHIR3 =-1 
                    ENDIF
                  ENDIF
                ELSE IF(ICHIR2.EQ.9.AND.ICHIR3.EQ.0) THEN
C                 9 --> 0
                  IF(IBOND(I2).GT.0) THEN
                    IF(ICHIR(I1).GE.1) THEN
C                               2
C                     set  (R) -  R or (0) - R or  (9) - R 
                      ICHIR2 = 1 
                    ELSE IF(ICHIR(I1).EQ.-1) THEN
C                                 2 
C                     set  (L) -  L  
                      ICHIR2 =-1 
                    ENDIF
                  ENDIF
         
                ENDIF
              ENDIF
              IPHI(I2) = 0
            ENDIF

            CALL SET_CORRECT_CHIR(ICHIR2,ICHIR3,IBOND(I2)
     *                                     ,ICHIR(I2),ICHIR(I3))
          ENDIF
        ENDIF

c        
C                  --sp3--           --sp3--
C         check  flat ! flat   or  plan ! plan      not possible
C                  --sp2--           --sp3--
C               (or single plan)
C
      ENDDO

      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(IBOND(I2).LE.0) THEN
C         there is no neighbor ring I2-I3
          IF(ICHIR(I2).EQ.9) THEN
C           2      2     2     
C           L~(R)  R~(L) R~(R)
            IF(ICHIR(I3).EQ.1) THEN
              ICHIR(I2) =-1
            ELSE
              ICHIR(I2) = 1
            ENDIF
          ENDIF

          IF(NPHI(I2).GT.0.AND.IPHI(I2).EQ.9) THEN
C           there is tors which is not defined
C
            IPHI(I2) = 0

          ENDIF
        ENDIF
      ENDDO 

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '  NCH :',(NCH(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  CHIR:',(ICHIR(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  NPHI:',(NPHI(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  IPHI:',(IPHI(JJJJ),JJJJ=1,NR) 
      ENDIF     


      CALL CHIR_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        


      CALL TORS_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '  NCH :',(NCH(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  CHIR:',(ICHIR(JJJJ),JJJJ=1,NR) 
      ENDIF     

      RETURN
      END

      SUBROUTINE GET_CORRECT_CHIR(ICHIR1,ICHIR2,IBOND,ICH1,ICH2)
C ---- 
      INTEGER ICHIR1,ICHIR2,IBOND,ICH1,ICH2 
C ---- 
      IB = IBOND/100
      IB = IBOND - IB*100
      ICH1 = ICHIR1
      IF(IB.GT.20.AND.ICH1.NE.9) ICH1 = -ICH1
      ICH2 = ICHIR2
      IF(MOD(IB,2).EQ.0.AND.ICH2.NE.9) ICH2 = -ICH2        
C ---- 
      RETURN
      END

      SUBROUTINE SET_CORRECT_CHIR(ICH1,ICH2,IBOND,ICHIR1,ICHIR2)
C ---- 
      INTEGER ICHIR1,ICHIR2,IBOND,ICH1,ICH2 
C ---- 
      IB = IBOND/100
      IB = IBOND - IB*100
      IF(ICHIR1.EQ.9) THEN
        ICHIR1 = ICH1
        IF(IB.GT.20) ICHIR1 = -ICHIR1
      ENDIF
      IF(ICHIR2.EQ.9) THEN
        ICHIR2 = ICH2
        IF(MOD(IB,2).EQ.0) ICHIR2 = -ICHIR2       
      ENDIF
C ---- 
      RETURN
      END

      SUBROUTINE SET_RING_TORS(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR
     *                   ,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat, 5, 6
C                          
C ----
      CHARACTER LIST*1,LINE*256
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C
      INTEGER IFRAME_PS(6),IFRAME_NPS(6),IFRAME(6)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0      
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '------------> SET_RING_TORS:',IRING 
      ENDIF
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NPHI(I2).LE.0) THEN
C         there is no tors
C
          LINE = 
     *' WARNING: in TORSION_CORRECTION: missing tors.:'//L1A_ANAME(IA2)
     *         //' - '//L1A_ANAME(IA3)     
          CALL MSGERR(MDOC,LINE)
          NV = 0
          NC = 0  
          CALL SET_VTORS(MDOC,IA1,IA2,IA3,IA4,NV,NC,IERR)
          IF(IERR.NE.0) RETURN
          IPHI(I2) = 9
          NPHI(I2) = L1T_NTORS
C???        
C         L1T_VOBS(L1T_NTORS) = ? chir(i2) , cir(i3)
C???
        ENDIF
      ENDDO

      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
C ---   possible phi
        IFRAME_PS(I2) = IPHI(I2)
C ---   nonpossible phi
        IFRAME_NPS(I2) = 9
        INP = 9
c       phi -

        CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 

        IF((ICHIR2.EQ.-1.AND.ICHIR3.EQ.1).OR. 
     *     (ICHIR2.EQ.-1.AND.ICHIR3.EQ.0).OR. 
     *     (ICHIR2.EQ. 0.AND.ICHIR3.EQ.1)    ) 
     *  INP =-1
        IF(IBOND(I2).GE.100) THEN
          IF((ICHIR2.EQ. 1.AND.ICHIR3.EQ.-1).OR. 
     *       (ICHIR2.EQ. 1.AND.ICHIR3.EQ. 1).OR. 
     *       (ICHIR2.EQ.-1.AND.ICHIR3.EQ.-1).OR. 
     *       (ICHIR2.EQ. 0.AND.ICHIR3.EQ. 0)    ) 
     *    INP =-1
        ENDIF
        IF(INP.NE.9.AND.IFRAME_PS(I2).NE.9) THEN
C         error
          INP = 9
          GO TO 100
        ENDIF
        INP2 = 9
C -     phi +
        IF((ICHIR2.EQ. 1.AND.ICHIR3.EQ.-1).OR. 
     *     (ICHIR2.EQ. 1.AND.ICHIR3.EQ. 0).OR. 
     *     (ICHIR2.EQ. 0.AND.ICHIR3.EQ.-1)    ) 
     *  INP2 = 1
        IF(IBOND(I2).GE.100) THEN
          IF((ICHIR2.EQ.-1.AND.ICHIR3.EQ. 1).OR. 
     *       (ICHIR2.EQ. 1.AND.ICHIR3.EQ. 1).OR. 
     *       (ICHIR2.EQ.-1.AND.ICHIR3.EQ.-1).OR. 
     *       (ICHIR2.EQ. 0.AND.ICHIR3.EQ. 0)    ) 
     *    INP2 = 1
        ENDIF
        IF(INP2.NE.9.AND.IFRAME_PS(I2).NE.9) THEN
C         error
          INP = 9
          GO TO 100
        ENDIF
        IF(INP.NE.9) THEN
          IFRAME_PS(I2) = 0
          GO TO 100
        ELSE
          INP = INP2
        ENDIF
C -     phi 0
        INP2 = 9
        IF((ICHIR2.EQ.-1.AND.ICHIR3.EQ. 1).OR. 
     *     (ICHIR2.EQ. 1.AND.ICHIR3.EQ.-1)    ) 
     *  INP = 0
        IF(IBOND(I2).GE.100) THEN
          IF((ICHIR2.EQ. 0.AND.ICHIR3.EQ. 1).OR. 
     *       (ICHIR2.EQ. 0.AND.ICHIR3.EQ.-1).OR. 
     *       (ICHIR2.EQ. 1.AND.ICHIR3.EQ. 0).OR. 
     *       (ICHIR2.EQ.-1.AND.ICHIR3.EQ. 0)    ) 
     *    INP2 = 0
        ENDIF
        IF(INP2.NE.9.AND.IFRAME_PS(I2).NE.9) THEN
C         error
          INP = 9
          GO TO 100
        ENDIF
        INP = INP2
 100    CONTINUE
        IFRAME_NPS(I2) = INP
C ---
      ENDDO

C ---
C     number of 0
C     ?
C     ? go to?
C ----

      CALL GET_FRAME(NR,IFRAME_PS,IFRAME_NPS,IFRAME,ISCORE,ITB)

C   !  3 CYCLES FOR +, -, 0
C   !
C   V
C
C ---- 
C
C + 
C
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '-fr-p :',(IFRAME_PS(jjjj),jjjj=1,nr)
        WRITE(*,*) '-fr-np:',(IFRAME_NPS(jjjj),jjjj=1,nr)
        WRITE(*,*) '-fr   :',(IFRAME(jjjj),jjjj=1,nr)
      ENDIF

      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NPHI(I2).GT.0) THEN
C         there is tors
C
          IF(IBOND(I2).GT.0) THEN
C           there is neighbor ring I2-I3
C

            CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 

            IF(IPHI(I2).LT.9) THEN
C             tors was defined before           
C             check ichir(i2),ichir(i3) # 9 (if(nch(i2),nch(i3) > 0) 

            ELSE
C             set chir I2,I3:
              IF(IFRAME(I2).EQ.1) THEN
                IF(ICHIR2.EQ.9) ICHIR2 =-1
                IF(ICHIR3.EQ.9) ICHIR3 = 1
              ENDIF

            ENDIF
 
            CALL SET_CORRECT_CHIR(ICHIR2,ICHIR3,IBOND(I2)
     *                                     ,ICHIR(I2),ICHIR(I3))

          ENDIF 

        ENDIF
      ENDDO
C
C -
C
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NPHI(I2).GT.0) THEN
C         there is tors
C
          IF(IBOND(I2).GT.0) THEN
C           there is neighbor ring I2-I3
C

            CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 


            IF(IPHI(I2).LT.9) THEN
C             tors was defined before           
C             check ichir(i2),ichir(i3) # 9 (if(nch(i2),nch(i3) > 0) 

            ELSE
C             set chir I2,I3:
              IF(IFRAME(I2).EQ.-1) THEN
                IF(ICHIR2.EQ.9) ICHIR2 = 1
                IF(ICHIR3.EQ.9) ICHIR3 =-1
              ENDIF

            ENDIF
 
            CALL SET_CORRECT_CHIR(ICHIR2,ICHIR3,IBOND(I2)
     *                                     ,ICHIR(I2),ICHIR(I3))

          ENDIF 

        ENDIF
      ENDDO
C
C 0
C
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NPHI(I2).GT.0) THEN
C         there is tors
C
          IF(IBOND(I2).GT.0) THEN
C           there is neighbor ring I2-I3
C

            CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 
            IF(IPHI(I2).LT.9) THEN
C             tors was defined before           
C             check ichir(i2),ichir(i3) # 9 (if(nch(i2),nch(i3) > 0) 

            ELSE
C             set chir I2,I3:
              IF(IFRAME(I2).EQ. 0) THEN
                IF(ICHIR2.EQ.9.AND.ICHIR3.EQ.-1) THEN
                  ICHIR2 =-1
                ELSE IF(ICHIR3.EQ.9.AND.ICHIR2.EQ.-1) THEN
                  ICHIR3 =-1
                ELSE
                  IF(ICHIR2.EQ.9) ICHIR2 = 1
                  IF(ICHIR3.EQ.9) ICHIR3 = 1
                ENDIF
              ENDIF

              IPHI(I2) = IFRAME(I2)   
  
            ENDIF
 
            CALL SET_CORRECT_CHIR(ICHIR2,ICHIR3,IBOND(I2)
     *                                     ,ICHIR(I2),ICHIR(I3))

          ENDIF 

        ENDIF
      ENDDO
C ---
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(IBOND(I2).LE.0) THEN
C         there is no neighbor ring I2-I3
          IF(ICHIR(I2).EQ.9) THEN
C           2      2     2     
C           L~(R)  R~(L) R~(R)
            ICHIR(I2) = 1
            IF(ICHIR(I3).EQ.1) ICHIR(I2) =-1  
          ENDIF

          IF(NPHI(I2).GT.0.AND.IPHI(I2).EQ.9) THEN
C           there is tors which is not defined
C
            IFR = IFRAME(I2)

            IF((NR.EQ.6.AND.(ITB.EQ.5.OR.ITB.EQ.6)
     *                        .AND.IFRAME(I3).EQ.0).OR. 
     *         (NR.EQ.5.AND.(ITB.EQ.1.OR.ITB.EQ.2)
     *             .AND.(IFRAME(I1).EQ.0.OR.IFRAME(I3).EQ.0))) THEN
              IF(IFR.LT.0) THEN
                IFR =-2
              ELSE
                IFR = 2
              ENDIF

            ENDIF

            IPHI(I2) = IFR

          ENDIF
        ENDIF
      ENDDO 

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '  NCH :',(NCH(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  CHIR:',(ICHIR(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  ACHR:',(IACHIR(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  NPHI:',(NPHI(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  IPHI:',(IPHI(JJJJ),JJJJ=1,NR) 
      ENDIF     

      CALL CHIR_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
      CALL TORS_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        

C ---
      RETURN
      END

      SUBROUTINE GET_FRAME(NR,IFRAME_PS,IFRAME_NPS,IFRAME
     *                                           ,ISCORE,ITBEST)
C ---
      INTEGER IFRAME_PS(*),IFRAME_NPS(*),IFRAME(*)        
      INTEGER ITAB6(12,9),ITAB5(10,3)      
      DATA ITAB6/
     *   0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1,
     *   0,-1, 1, 0,-1, 1, 0,-1, 1, 0,-1, 1,
     *   0, 0, 1,-1, 1,-1, 0, 0, 1,-1, 1,-1,
     *   0, 0,-1, 1,-1, 1, 0, 0,-1, 1,-1, 1,
     *   0, 1, 0,-1, 1,-1, 0, 1, 0,-1, 1,-1,
     *   0,-1, 0, 1,-1, 1, 0,-1, 0, 1,-1, 1,
     *   1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
     *  -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
     *   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 /
C        1  2  3  4  5  6  7  8  9 10 11 12
C ---
      DATA ITAB5/
     *   0, 1,-1, 1,-1, 0, 1,-1, 1,-1,  
     *   0,-1, 1,-1, 1, 0,-1, 1,-1, 1,  
     *   0, 0, 0, 0, 0, 0, 0, 0, 0, 0 /
C        1  2  3  4  5  6  7  8  9 10 
C --------------------------------------------------
      ISCORE = 10000
      IBEST  = 0
      ITBEST = 0

c      NT = 3
C --- 2.06.03
      NT = 2
c ---
      IF(NR.EQ.6) NT = 9

      DO IT=1,NT
        DO I=1,NR
          ISC = 0
          DO J=1,NR
            IJ = I + (J-1)
            IF(NR.EQ.6) THEN
              ITAB = ITAB6(IJ,IT) 
            ELSE  
              ITAB = ITAB5(IJ,IT) 
            ENDIF
            IF(IFRAME_PS(J).NE.9) THEN   
              IF(IFRAME_PS(J).NE.ITAB) THEN   
                ISC = ISC + 1
              ENDIF
            ENDIF
            IF(IFRAME_NPS(J).NE.9) THEN   
              IF(IFRAME_NPS(J).EQ.ITAB) THEN   
                ISC = ISC + 1
              ENDIF
            ENDIF
          ENDDO
          IF(ISC.LT.ISCORE) THEN
            ISCORE = ISC
            IBEST  = I    
            ITBEST = IT
          ENDIF

        ENDDO
      ENDDO
C --- 
      DO I=1,NR
        IJ = IBEST + (I-1)
        IF(NR.EQ.6) THEN
          ITAB = ITAB6(IJ,ITBEST)       
        ELSE
          ITAB = ITAB5(IJ,ITBEST) 
        ENDIF
        IFRAME(I) = ITAB      
      ENDDO
C ---
      RETURN
      END



      SUBROUTINE GET_RING_ORDER(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat, 5, 6
C                          
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0


      IACHIR(1) = IATOM(1)
      NNR = 1
      IPP = 0

      DO NNR=1,NR
        IF(NNR.EQ.1) THEN
          IACHIR(1) = IATOM(1)
          IATOM (1) = 0 
        ELSE
          IP = IACHIR(NNR-1)
          DO IR=1,NR
            I  = IATOM(IR)
            IF(I.GT.0) THEN
              CALL CHECK_ATOM_CONN(I,IP,IFLAG)
              IF(IFLAG.EQ.1) THEN
                IACHIR(NNR) = I
                IATOM(IR)   = 0 
                GO TO 100
              ENDIF
            ENDIF
          ENDDO        
        ENDIF
 100    CONTINUE
      ENDDO

      DO I=1,NR
        IATOM(I) = IACHIR(I)
      ENDDO
C ---
C     check all thetas ( 0 or 180)
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        MMM = 99
        MON = ' '
        CALL SRCH_ANGL(MMM,MON,IA1,IA2,IA3,ANGL,LG,IERR)
        IF(IERR.NE.0.OR.ANGL.LT.10.0.OR.ANGL.GT.170.0) THEN
          IERR = 3
          RETURN
        ENDIF 
      ENDDO     
C ---
      RETURN
      END

      SUBROUTINE GET_RING_CHIR(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
      INTEGER IMC(10)        

      CHARACTER LINE*256,SIGN*8,MON*8
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0
      MON  = ' '
      DO I=1,NR
        IFLAT = 0
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        ICHIR (I2) = 0
        NCH   (I2) = 0
        IACHIR(I2) = 0
        ICONN (I2) = 0
        IF(L1C_NCHIR.LE.0) GO TO 100

        IF(IS_IT_METAL(L1A_SYMB(IA2))) THEN
          IB = 0  
          CALL SRCH_METAL_CHIR(MDOC,MON,IA2,IB,IBC,IFR,IMC
     *                                   ,ICROSS,SIGN,LC,IERR)
          IF(IERR.NE.0.AND.LC.GT.0) THEN
            IERR = 0
          ELSE 
            IF(IERR.EQ.0) THEN
              IFLAT     = 1
              ICONN(I2) = 1
            ENDIF
            IERR = 0
            GO TO 100
          ENDIF  
        ENDIF

        NC = L1A_NDIST(IA2) + L1A_NEXTR(IA2)
        IF(L1A_IBACK(IA2).GT.0) NC = NC + 1
        IF(NC.GE.3) THEN          
          NNR = 0
          IF(L1A_IBACK(IA2).GT.0) THEN
            IB  = L1A_IBACK(IA2) 
            IF(IB.NE.IA1.AND.IB.NE.IA3) THEN
              NNR = NNR + 1
              IBOND(NNR) = IB
            ENDIF
          ENDIF
          IF(L1A_NDIST(IA2).GT.0) THEN
            DO ID=1,L1A_NDIST(IA2)
              II = L1A_CONN(ID,IA2)
              IF(II.NE.IA1.AND.II.NE.IA3) THEN
                IF(L1A_SYMB(II).NE.'H   '.AND.
     *             L1A_SYMB(II).NE.'D   '     ) THEN
                  NNR = NNR + 1   
                  IBOND(NNR) = II
                ENDIF
              ENDIF
            ENDDO
          ENDIF
          IF(L1A_NEXTR(IA2).GT.0) THEN
            DO ID=1,L1A_NEXTR(IA2)
              II = L1A_IEXTR(ID,IA2)
              IF(II.NE.IA1.AND.II.NE.IA3) THEN
                IF(L1A_SYMB(II).NE.'H   '.AND.
     *             L1A_SYMB(II).NE.'D   '     ) THEN
                  NNR = NNR + 1   
                  IBOND(NNR) = II
                ENDIF
              ENDIF
            ENDDO
          ENDIF
          IA = 0
          IF(NNR.EQ.1) THEN
            IA = IBOND(1)
          ELSE IF(NNR.GT.1) THEN
            IA = IBOND(1)
            IF(L1A_NRING(IA2).GT.1) THEN 
              DO IR=1,L1A_NRING(IA2)
                IRID = L1A_RING_ID(IR,IA2)
                IF(IRID.NE.IRING) THEN
                  DO IB=1,NNR
                    IBA = IBOND(IB)
                    IF(L1A_NRING(IBA).GT.1) THEN 
                      DO JR=1,L1A_NRING(IBA)
                        JRID = L1A_RING_ID(JR,IBA)
                        IF(IRID.EQ.JRID) THEN
                          IA = IBA
                          GO TO 200
                        ENDIF
                      ENDDO
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO 
            ENDIF  
          ENDIF
 200      CONTINUE
          IF(IA.GT.0) THEN
            CALL GET_CHIR_SIGN(IA2,IA1,IA,IA3,ICH,ISIGN) 
            IF(ICH.GT.0.AND.ISIGN.EQ.0) THEN
              IERR = 2
              LINE = ' WARNING: problem with chirality:'//
     *               L1A_ANAME(IA2)
              CALL MSGERR(MDOC,LINE)
            ENDIF
            IF(ICH.EQ.0) IA = 0
            NCH   (I2) = ICH
            IACHIR(I2) = IA
            ICHIR (I2) = ISIGN          
          ENDIF 
        ENDIF
 100    CONTINUE
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE GET_CHIR_SIGN(ICN,IA1,IA2,IA3,ICHIR,ISIGN) 
C ------------------------------------------------------
      INTEGER ICN,IA1,IA2,IA3,ICHIR,ISIGN        
      INTEGER IC(3),ID(3)
C ---
      INCLUDE 'lib_com.fh'
C ------------------------------------------------------
      ICHIR = 0
      ISIGN = 0
      IF(L1C_NCHIR.LE.0) RETURN
      DO ICH=1,L1C_NCHIR
      IF(L1C_SIGN(ICH)(1:4).NE.'cros'.AND.
     *   L1C_SIGN(ICH)(1:4).NE.'star'    ) THEN
        ICC   = L1C_I1ATM(ICH)
        IC(1) = L1C_I2ATM(ICH)
        IC(2) = L1C_I3ATM(ICH)
        IC(3) = L1C_I4ATM(ICH)
        ID(1) = 0
        ID(2) = 0
        ID(3) = 0
        IF(ICC.EQ.ICN) THEN
          NZERO = 0
          IF(IA1.EQ.IC(1)) THEN
            I1    = IA1
            ID(1) = I1
          ELSE IF(IA1.EQ.IC(2)) THEN
            I1    = IA1
            ID(2) = I1
          ELSE IF(IA1.EQ.IC(3)) THEN
            I1    = IA1
            ID(3) = I1
          ELSE
            I1    = 0
            NZERO = NZERO + 1     
          ENDIF
          IF(IA2.EQ.IC(1)) THEN
            I2    = IA2
            ID(1) = I2
          ELSE IF(IA2.EQ.IC(2)) THEN
            I2    = IA2
            ID(2) = I2
          ELSE IF(IA2.EQ.IC(3)) THEN
            I2    = IA2
            ID(3) = I2
          ELSE
            I2    = 0
            NZERO = NZERO + 1     
          ENDIF
          IF(IA3.EQ.IC(1)) THEN
            I3    = IA3
            ID(1) = I3
          ELSE IF(IA3.EQ.IC(2)) THEN
            I3    = IA3
            ID(2) = I3
          ELSE IF(IA3.EQ.IC(3)) THEN
            I3    = IA3
            ID(3) = I3
          ELSE
            I3    = 0
            NZERO = NZERO + 1     
          ENDIF
          IF(NZERO.GT.1) THEN
C           error
            RETURN
          ENDIF 
          ICHIR = ICH
          IF(L1C_FLAG(ICH).EQ.'B') THEN
            ISIGN = 9
            RETURN
          ENDIF
          IF(NZERO.EQ.1) THEN
            IF(ID(1).EQ.0) IAA = IC(1)
            IF(ID(2).EQ.0) IAA = IC(2)
            IF(ID(3).EQ.0) IAA = IC(3)
            IF(I1.EQ.0) I1 = IAA 
            IF(I2.EQ.0) I2 = IAA 
            IF(I3.EQ.0) I3 = IAA           
          ENDIF
          INVER = 1 
          IF(IC(1).EQ.I1) THEN 
            IF(IC(2).EQ.I2.AND.IC(3).EQ.I3) GO TO 100
          ELSE IF(IC(1).EQ.I2) THEN 
            IF(IC(2).EQ.I3.AND.IC(3).EQ.I1) GO TO 100
          ELSE IF(IC(1).EQ.I3) THEN 
            IF(IC(2).EQ.I1.AND.IC(3).EQ.I2) GO TO 100
          ENDIF
          INVER =-1
 100      CONTINUE
          IF(NZERO.EQ.1) THEN  
            IF(INVER.EQ.1)THEN
              INVER =-1
            ELSE
              INVER = 1
            ENDIF 
          ENDIF
          ISIGN = 0
          IF(L1C_FLAG(ICH).EQ.'R') THEN
            ISIGN = 1
          ELSE IF(L1C_FLAG(ICH).EQ.'L') THEN
            ISIGN =-1
          ENDIF
          ISIGN = ISIGN*INVER
          RETURN
        ENDIF
      ENDIF
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE CHIR_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *    ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      CHARACTER LIST*1
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR= 0
C ---
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NCH(I2).GT.0) THEN
          CALL SET_CHIR_SIGN(NCH(I2),IA2,IA1,IACHIR(I2),IA3,ICHIR(I2)) 

          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '--cnt:',NCH(I2),I2,iA2
            WRITE(*,*) '-- cH:',IA1,IACHIR(I2),IA3,ICHIR(I2)
            WRITE(*,*) ' list:',L1C_I1ATM(nch(i2)),L1C_I2ATM(nch(i2))
     *      ,L1C_I3ATM(nch(i2)),L1C_I4ATM(nch(i2))
            WRITE(*,*) ' flag:',L1C_FLAG(NCH(I2))
          ENDIF

        ENDIF
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE SET_CHIR_SIGN(ICH,ICN,IA1,IA2,IA3,ISIGN) 
C ------------------------------------------------------
      INTEGER ICN,IA1,IA2,IA3,ICH,ISIGN        
      INTEGER IC(3),ID(3)
C ---
      INCLUDE 'lib_com.fh'
C ------------------------------------------------------
      IF(L1C_NCHIR.LE.0.OR.ICH.GT.L1C_NCHIR) RETURN
      IF(ISIGN.NE.1.AND.ISIGN.NE.-1) RETURN
C ---
      ICC   = L1C_I1ATM(ICH)
      IC(1) = L1C_I2ATM(ICH)
      IC(2) = L1C_I3ATM(ICH)
      IC(3) = L1C_I4ATM(ICH)
      ID(1) = 0
      ID(2) = 0
      ID(3) = 0
      IF(ICC.EQ.ICN) THEN
        NZERO = 0
        IF(IA1.EQ.IC(1)) THEN
          I1    = IA1
          ID(1) = I1
        ELSE IF(IA1.EQ.IC(2)) THEN
          I1    = IA1
          ID(2) = I1
        ELSE IF(IA1.EQ.IC(3)) THEN
          I1    = IA1
          ID(3) = I1
        ELSE
          I1    = 0
          NZERO = NZERO + 1     
        ENDIF
        IF(IA2.EQ.IC(1)) THEN
          I2    = IA2
          ID(1) = I2
        ELSE IF(IA2.EQ.IC(2)) THEN
          I2    = IA2
          ID(2) = I2
        ELSE IF(IA2.EQ.IC(3)) THEN
          I2    = IA2
          ID(3) = I2
        ELSE
          I2    = 0
          NZERO = NZERO + 1     
        ENDIF
        IF(IA3.EQ.IC(1)) THEN
          I3    = IA3
          ID(1) = I3
        ELSE IF(IA3.EQ.IC(2)) THEN
          I3    = IA3
          ID(2) = I3
        ELSE IF(IA3.EQ.IC(3)) THEN
          I3    = IA3
          ID(3) = I3
        ELSE
          I3    = 0
          NZERO = NZERO + 1     
        ENDIF
        IF(NZERO.GT.1) THEN
C         error
          RETURN
        ENDIF 
        IF(L1C_FLAG(ICH).NE.'B') RETURN
        IF(NZERO.EQ.1) THEN
          IF(ID(1).EQ.0) IAA = IC(1)
          IF(ID(2).EQ.0) IAA = IC(2)
          IF(ID(3).EQ.0) IAA = IC(3)
          IF(I1.EQ.0) I1 = IAA 
          IF(I2.EQ.0) I2 = IAA 
          IF(I3.EQ.0) I3 = IAA           
        ENDIF
        INVER = 1 
        IF(IC(1).EQ.I1) THEN 
          IF(IC(2).EQ.I2.AND.IC(3).EQ.I3) GO TO 100
        ELSE IF(IC(1).EQ.I2) THEN 
          IF(IC(2).EQ.I3.AND.IC(3).EQ.I1) GO TO 100
        ELSE IF(IC(1).EQ.I3) THEN 
          IF(IC(2).EQ.I1.AND.IC(3).EQ.I2) GO TO 100
        ENDIF
        INVER =-1
 100    CONTINUE
        IF(NZERO.EQ.1) THEN  
          IF(INVER.EQ.1)THEN
            INVER =-1
          ELSE
            INVER = 1
          ENDIF 
        ENDIF
        ISN = ISIGN*INVER
        IF(ISN.EQ.1) THEN
          L1C_FLAG(ICH) = 'R'
        ELSE IF(ISN.EQ.-1) THEN
          L1C_FLAG(ICH) = 'L'
        ENDIF
      ENDIF
C ---
      RETURN
      END

      SUBROUTINE GET_RING_BOND(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IBOND(I2) = 0
        IC1       = 0
        IC2       = 0
        IFLT      = 0
        IA_RING   = 0
        JA_RING   = 0
        IF(L1A_NRING(IA2).NE.0.AND.L1A_NRING(IA3).NE.0) THEN
          DO IR=1,L1A_NRING(IA2)
            IP = L1A_RING_ID(IR,IA2)
            IF(IP.NE.IRING) THEN
              DO JR=1,L1A_NRING(IA3)
                IF(IP.EQ.L1A_RING_ID(JR,IA3)) THEN
                  DO IA=1,L1A_NATOM
                    IF(L1A_NRING(IA).GT.0.AND.
     *                 IA.NE.IA1.AND.IA.NE.IA2.AND.IA.NE.IA3)THEN
                      DO IAR=1,L1A_NRING(IA)
                        IF(IP.EQ.L1A_RING_ID(IAR,IA)) THEN
                          CALL CHECK_ATOM_CONN(IA2,IA,IFLAG1)

                          IF(IFLAG1.EQ.1) THEN

                          DO JA=1,L1A_NATOM
                            IF(L1A_NRING(JA).GT.0.AND.JA.NE.IA.AND.
     *                        JA.NE.IA2.AND.JA.NE.IA3.AND.JA.NE.IA4)THEN
                              DO JAR=1,L1A_NRING(JA)
                                IF(IP.EQ.L1A_RING_ID(JAR,JA)) THEN
                                  CALL CHECK_ATOM_CONN(IA3,IA,IFLAG2)
                                  IF(IFLAG2.EQ.1) THEN
                                    CALL CHECK_RING_IS_PLAN(IP,IFLAGP)
                                    IF(IFLAGP.GT.0.OR.IFLT.EQ.0) THEN
                                      IFLT = IFLAGP 
                                      IA_RING = IA
                                      JA_RING = JA
                                      IC1     = 1
                                      IC2     = 1
                                      IF(IFLAGP.EQ.2) GO TO 100
                                    ENDIF  
                                  ENDIF
                                ENDIF
                              ENDDO
                            ENDIF
                          ENDDO

                          ENDIF

                        ENDIF
                      ENDDO 
                    ENDIF
                  ENDDO 
                  IC1 = 1
                  IC2 = 1
                ENDIF
              ENDDO
            ENDIF
          ENDDO
          GO TO 200
 100      CONTINUE
          IF(NCH(I2).GT.0.AND.IACHIR(I2).NE.IA_RING.AND.
     *                                      IA_RING.GT.0) IC1 = 2
          IF(NCH(I3).GT.0.AND.IACHIR(I3).NE.JA_RING.AND.
     *                                      JA_RING.GT.0) IC2 = 2
          IBOND(I2) = IFLT*100 + IC1*10 + IC2
        ENDIF
 200    CONTINUE
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE GET_RING_TORS(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IPHI(I2) = 9
        NPHI(I2) = 0
        IF(L1T_NTORS.LE.0) GO TO 100
        DO ITORS=1,L1T_NTORS
          IT1 = L1T_I1ATM(ITORS)
          IT2 = L1T_I2ATM(ITORS)
          IT3 = L1T_I3ATM(ITORS)
          IT4 = L1T_I4ATM(ITORS)
          IF((IA2.EQ.IT2.AND.IA3.EQ.IT3).OR.
     *       (IA2.EQ.IT3.AND.IA3.EQ.IT2)    ) THEN
            NPHI(I2) = ITORS
            IF(L1T_FLAG(ITORS).EQ.'C'.OR.L1T_FLAG(ITORS).EQ.'D') THEN
              IF((NCH(I2).GT.0.AND.ICHIR(I2).EQ.9).OR.
     *           (NCH(I3).GT.0.AND.ICHIR(I3).EQ.9)    ) GO TO 100
              IF(ICONN(I2).GT.0.OR.ICONN(I3).GT.0) THEN
                IPHI(I2) = 0
                GO TO 100 
              ENDIF  
              L1T_FLAG(ITORS) = 'D'
              NEG = 1
              ID1 = 0
              ID2 = 0
              IF(IT2.EQ.IA3) THEN
                NEG =-1
                IT2 = IA3
                IT3 = IA2
                IT  = IT1
                IT1 = IT4
                IT4 = IT              
              ENDIF

              CALL CONVERT_TORS_ANGLE(IT1,IA1,NCH(I2),IACHIR(I2)
     *                                         ,ICHIR(I2),ID1,IERR1)
              CALL CONVERT_TORS_ANGLE(IT4,IA4,NCH(I3),IACHIR(I3)
     *                                         ,ICHIR(I3),ID2,IERR2)
              IF(IERR1.NE.0.OR.IERR2.NE.0) GO TO 100

              ID2 = -ID2
              IF(ID2.EQ.-6) ID2 = 6
C             list --> ring 
              VOBS = ABS(L1T_VOBS(ITORS))
              IPH  = VOBS/30.0 + 0.5 
              IF(L1T_VOBS(ITORS).LT.0.0) IPH = -IPH
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
              L1T_VOBS(ITORS) = IPH*30.0             
c              IPH = IPH*NEG
              IF(IPH.EQ.-6) IPH = 6
              IPH = IPH - ID1
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
              IPH = IPH - ID2
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
              IPH = IPH/2
              IF(IPH.EQ. 3) IPH = 0
              IF(IPH.EQ. 2) IPH =-1
              IF(IPH.EQ.-2) IPH = 1
              IPHI(I2) = IPH
            ENDIF
            GO TO 100
          ENDIF
        ENDDO

 100    CONTINUE
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE TORS_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      CHARACTER LIST*1
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)

        IF(NPHI(I2).GT.0.AND.NPHI(I2).LE.L1T_NTORS) THEN
          ITORS = NPHI(I2)
          IT1 = L1T_I1ATM(ITORS)
          IT2 = L1T_I2ATM(ITORS)
          IT3 = L1T_I3ATM(ITORS)
          IT4 = L1T_I4ATM(ITORS)
          IF((IA2.EQ.IT2.AND.IA3.EQ.IT3).OR.
     *       (IA2.EQ.IT3.AND.IA3.EQ.IT2)    ) THEN
            IF(L1T_FLAG(ITORS).NE.'D'.AND.ICONN(I2).LE.0.AND.
     *                                    ICONN(I3).LE.0     ) THEN
              NEG = 1
              ID1 = 0
              ID2 = 0
              IF(IT2.EQ.IA3) THEN
                NEG =-1
                IT2 = IA3
                IT3 = IA2
                IT  = IT1
                IT1 = IT4
                IT4 = IT              
              ENDIF

              CALL CONVERT_TORS_ANGLE(IT1,IA1,NCH(I2),IACHIR(I2)
     *                                         ,ICHIR(I2),ID1,IERR1)
              CALL CONVERT_TORS_ANGLE(IT4,IA4,NCH(I3),IACHIR(I3)
     *                                         ,ICHIR(I3),ID2,IERR2)
              IF(IERR1.NE.0.OR.IERR2.NE.0) THEN
                CALL MSGERR(MDOC,
     * ' WARNING: in TORSION_CORRECTION: not all chir. are defined')
              ENDIF

              ID2 = -ID2
              IF(ID2.EQ.-6) ID2 = 6

C             ring --> list  
              IPH = IPHI(I2)
              IPH = IPH*2
              IF(IPH.EQ. 4) IPH = 1
              IF(IPH.EQ.-4) IPH =-1
              IPHH= IPH
c             IPH = IPH*NEG              
              IF(IPH.EQ.-6) IPH = 6
              IPH = IPH + ID1
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
              IPH = IPH + ID2
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
c              IPH = IPH*NEG              
              L1T_FLAG(ITORS) = 'D'
              L1T_VOBS(ITORS) = IPH*30.0

              IF(LIST.EQ.'T') THEN
              WRITE(*,*) '--i2,IA2,IPH,NEG,ich:'
     *                   ,i2,IA2,IPHH,NEG,ICHIR(I2)
              WRITE(*,*) 'IT1,IA1,IAA,ID1:',IT1,IA1,IACHIR(I2),ID1
              WRITE(*,*) 'IT4,IA4,IAA,ID2:',IT4,IA4,IACHIR(I3),ID2
              WRITE(*,*) 'IPH   -->  :',IPH
              ENDIF

            ENDIF
          ENDIF
        ENDIF
      ENDDO
C ---
      RETURN
      END


      SUBROUTINE CONVERT_TORS_ANGLE(IT,IA,NCH,IACHIR,ICHIR,ID,IERR)
C --------------------------------------------
C       
C --------------------------------------------
      IERR = 0
      ID   = 0

c     write(*,*) '-->',it,ia,iachir,ichir

      IF(IT.NE.IA) THEN
        IF(NCH.EQ.0) THEN
          ID = 6
        ELSE
          IF(IACHIR.EQ.IT) THEN
            IF(ICHIR.EQ. 1) THEN
              ID =-4
            ELSE IF(ICHIR.EQ.-1) THEN
              ID = 4
            ELSE IF(ICHIR.EQ. 9) THEN
C             ????
              IERR = 1
              ID =-4
            ELSE
              ID = 6
            ENDIF
          ELSE
            IF(ICHIR.EQ. 1) THEN
              ID = 4
            ELSE IF(ICHIR.EQ.-1) THEN
              ID =-4
            ELSE IF(ICHIR.EQ. 9) THEN
C             ????
              IERR = 1
              ID = 4
            ELSE
              ID = 6
            ENDIF
          ENDIF
        ENDIF
      ELSE
        ID = 0 
      ENDIF
C ---
      RETURN
      END

      SUBROUTINE CHECK_RING_IS_PLAN(IRING,IFLAGP)
C --------------------------------------------
      INTEGER IARING(6)
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER CHEM*4,RATOM*4
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------
      IERR   = 0      
      IFLAGP = 0
      NR     = 0        
      DO IA=1,L1A_NATOM
        IF(L1A_NRING(IA).NE.0) THEN
          DO IRA=1,L1A_NRING(IA)
            IRING_ID = L1A_RING_ID (IRA,IA)
C           IORD     = L1A_RING_ORD(IRA,IA)
C           IFL      = L1A_RING_FLAT(IRA,IA)
            IF(IRING_ID.EQ.IRING) THEN
              IF(NR.LT.6) THEN        
                NR         = NR + 1
                IARING(NR) = IA
              ENDIF
            ENDIF
          ENDDO
        ENDIF 
      ENDDO

      IF(L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN
          N = 0
          DO I=1,L1P_NATOM(IP)
            IATOM = L1P_ATOM(I,IP)
            DO IR=1,NR 
              RATOM = L1A_ANAME(IARING(IR))
              IF(RATOM.EQ.ATOM) N=N+1
            ENDDO
          ENDDO
          IF(N.GE.4.AND.N.EQ.NR) THEN
            IFLAGP = 2
            GO TO 200
          ENDIF
        ENDDO
      ENDIF

 200  CONTINUE

      IF(IFLAGP.EQ.0) THEN
        N = 0
        DO I=1,NR
          IA   = IARING(I) 
          CHEM = L1A_CHEM(IA)
          IF(L1A_SYMB(IA).EQ.'H   '.OR.L1A_SYMB(IA).EQ.'D   ') 
     *    CHEM = 'H   '
          DO IE=1,LEA_NATOM
            IF(CHEM.EQ.LEA_ANAME(IE)) THEN
              IF(LEA_SP(IE).EQ.2) THEN
                N = N + 1
                GO TO 100
              ENDIF
            ENDIF 
          ENDDO
 100      CONTINUE
        ENDDO
        IF((NR.EQ.6.AND.N.GT.4).OR.(NR.EQ.5.AND.N.GT.2)) IFLAGP=1
      ENDIF  
C ---
      RETURN
      END

      SUBROUTINE CHECK_ATOM_CONN(IA1,IA2,IFLAG)
C --------------------------------------------
C     iflag = 1 yes
C ---
      INCLUDE 'lib_com.fh'
C --------------------------------------------
      IFLAG = 0
      IF(IA1.LE.0.OR.IA2.LE.0) RETURN

      IF(L1A_IBACK(IA2).EQ.IA1) THEN
        IFLAG = 1
        GO TO 100
      ENDIF  
        
      IF(L1A_NDIST(IA2).GT.0) THEN
        DO ID=1,L1A_NDIST(IA2)
          II = L1A_CONN(ID,IA2)
          IF(II.EQ.IA1) THEN
            IFLAG = 1
            GO TO 100
          ENDIF
        ENDDO
      ENDIF 
      IF(L1A_NEXTR(IA2).GT.0) THEN
        DO IE=1,L1A_NEXTR(IA2)
          II = L1A_IEXTR(IE,IA2)
          IF(II.EQ.IA1) THEN
            IFLAG = 1
            GO TO 100
          ENDIF
        ENDDO
      ENDIF
 100  CONTINUE
C ---
      RETURN
      END

      SUBROUTINE CHECK_METAL_CHIR(MDOC,MON,IANGL,LIST,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      LOGICAL   IS_IT_METAL
      EXTERNAL  IS_IT_METAL
      INTEGER   IBOND(10),IMC(10)
      CHARACTER LINE*256,SIGN*8,MON*8,LIST*1
C --------------------------------------------------------
      IERR  = 0
      JERR  = 0
      DO I=1,10
        IBOND(I) = 0
        IMC(I)   = 0
      ENDDO
C ---
      IF(LIST.EQ.'T') THEN
        write(*,*) '---CHECK_METAL_CHIR--',L1C_NCHIR
      ENDIF

      DO IA=1,L1A_NATOM 
        IF(IS_IT_METAL(L1A_SYMB(IA))) THEN
          NC  = 0 
          NCH = 0
          IF(L1A_IBACK(IA).GT.0) THEN
            NC = NC + 1  
            IBOND(NC)  = L1A_IBACK(IA) 
            IB         = IBOND(NC) 
            IF(L1A_SYMB(IB).EQ.'H   '.OR.L1A_SYMB(IB).EQ.'D   ') 
     *      NCH = NCH + 1
          ENDIF
          IF(L1A_NDIST(IA).GT.0) THEN
            DO ID=1,L1A_NDIST(IA)
              NC = NC + 1               
              IBOND(NC) = L1A_CONN(ID,IA)
              IB        = IBOND(NC) 
              IF(L1A_SYMB(IB).EQ.'H   '.OR.L1A_SYMB(IB).EQ.'D   ') 
     *        NCH = NCH + 1
            ENDDO
          ENDIF
          IF(L1A_NEXTR(IA).GT.0) THEN
            DO ID=1,L1A_NEXTR(IA)
              NC = NC + 1               
              IBOND(NC) = L1A_IEXTR(ID,IA)
              IB        = IBOND(NC) 
              IF(L1A_SYMB(IB).EQ.'H   '.OR.L1A_SYMB(IB).EQ.'D   ') 
     *        NCH = NCH + 1
            ENDDO
          ENDIF      
          IF(NC.LE.1) GO TO 100
          IF((NC-NCH).LE.1) GO TO 100
          DO I=1,NC
            IB  = IBOND(I)
            MON = ' '
            DO K=1,10
              IMC(K) = 0
            ENDDO
            CALL SRCH_METAL_CHIR(MDOC,MON,IA,IB,IBC,IFR,IMC
     *                               ,ICROSS,SIGN,LC,IERR)  
            IF(LIST.EQ.'T') THEN
              write(*,*)'srch_m_c:',IA,IB,LC,IERR
              write(*,*)'  IBC,IFR,ICROSS:',IBC,IFR,ICROSS
              write(*,*)'  IB:',IBOND(1),IBOND(2),IBOND(3),IBOND(4)
              write(*,*)'  IM:',IMC(1),IMC(2),IMC(3),IMC(4)
            ENDIF

            IF(IERR.EQ.0) THEN
              NFOUND1 = 0
              NFOUND2 = 0
              DO J=1,NC
                IAA=IBOND(J)
                IF(IAA.EQ.IFR.OR.IAA.EQ.IBC) THEN
                  NFOUND1 = NFOUND1 + 1 
                  GO TO 200
                ENDIF
                IF(ICROSS.GT.0) THEN
                  DO K=1,ICROSS
                    IF(IAA.EQ.IMC(K)) THEN
                      NFOUND2 = NFOUND2 + 1 
                      GO TO 200
                    ENDIF
                  ENDDO
                ENDIF
 200            CONTINUE
              ENDDO
              IF(SIGN(1:4).EQ.'cros') THEN
                IF(ICROSS.EQ.2) THEN
                  DO J=1,NC
                    IAA=IBOND(J)
                    IF(IAA.NE.IBC.AND.IAA.NE.IFR.AND.
     *                            IAA.NE.L1C_I4ATM(LC)) THEN
                      IMC(2)  = IAA
                      NFOUND2 = NFOUND2 + 1                       
                    ENDIF
                  ENDDO          
                ENDIF
              ELSE

              ENDIF  

              IF((NFOUND1.GT.0.AND.SIGN(1:4).EQ.'star').OR. 
     *           (NFOUND1.LE.1.AND.ICROSS.EQ.0        ).OR. 
     *           (NFOUND2.GE.1.AND.ICROSS.EQ.0        ).OR. 
     *           (NFOUND2.LE.0.AND.ICROSS.NE.0        ).OR. 
     *            NFOUND2.GT.ICROSS                        ) THEN 
            IF(LIST.EQ.'T') THEN
              write(*,*) ' NF1,NF2,ICROSS:',NFOUND1,NFOUND2,ICROSS
            ENDIF
                JERR = 1
       LINE = ' ERROR: wrong metal chirality for:'//L1A_ANAME(IA)  
                CALL MSGERR(MDOC,LINE)
                GO TO 100
              ENDIF 

              MMM = 99
              MON = ' '  

              IF(LIST.EQ.'T') THEN
                write(*,*) '---METAL_ang--corr'
                write(*,*) '-ia,nc,icross:',ia,nc,icross
                write(*,'(a,8i4)') '-ibc,ifr,mc(1234):',ibc,ifr
     *          ,imc(1),imc(2),imc(3),imc(4),imc(5),imc(6) 
              ENDIF

              CALL METAL_ANGLE_TORS_CORRECTION(MDOC,MON,NC,IA,IBC,IFR
     *             ,IMC,ICROSS,IERR)
              JERR = IERR
              IERR = 0
              GO TO 100
            ENDIF 
            IF(LC.GT.0.AND.IERR.EQ.9) THEN
              IERR = 0
              GO TO 100
            ENDIF
            IERR = 0
          ENDDO
C         no met. chir. IERR = 0
          IF(NC.GT.1) THEN
C           ierr = 0
            LINE = ' WARNING: there is no metal chirality for:'//
     *             L1A_ANAME(IA)  
            CALL MSGERR(MDOC,LINE)

            CALL METAL_CHIR_FROM_COORD(MDOC,LIST,MON
     *                                ,IA,NC,IBOND,IERR)
            IF(IERR.LE.2.AND.IERR.NE.0) THEN
              IF(IERR.EQ.1) THEN
                LINE =               
     *' WARNING: coords are not good enough to create Chirality'
                CALL MSGERR(MDOC,LINE)
              ENDIF
C             --- IERR = 2 no coords
              IF(IANGL.EQ.1) THEN

              IF(LIST.EQ.'T') THEN
                write(*,*) '--chek_MET_chir--'
                write(*,*) '-ia,nc:',ia,nc
                write(*,'(a,6i4)') '-ibond(1234):'
     *          ,ibond(1),ibond(2),ibond(3),ibond(4)                            
              ENDIF

                CALL CHECK_DEFAULT_MET_CHIR(MDOC,MON,IA,NC
     *                                     ,IBOND,LIST,IERR)
              ENDIF
            ENDIF
            IF(IERR.NE.0) JERR = IERR
            IERR = 0  
          ENDIF 

        ENDIF
 100    CONTINUE
      ENDDO
C ----
      IERR = JERR 
C ---------------------------------------
      RETURN
      END


      SUBROUTINE METAL_ANGLE_TORS_CORRECTION(MDOC,MON,NC,IC,IBC,IFR
     *             ,IMC,ICROSS,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR,NC,IC,IBC,IFR,ICROSS
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER   IMC(*),IN(12),INP(12)
      CHARACTER LINE*256,MON*8
C --------------------------------------------------------
C     check corr. angles
      
      IF(IFR.GT.0.AND.IBC.GT.0) THEN
        VAL = 180.0
        CALL CHANGE_ANGLE_VALUE(IBC,IC,IFR,VAL)
      ENDIF

      IF(ICROSS.GT.0) THEN 
        DO I=1,ICROSS
          IA  = IMC(I)
          VAL = 90.0
          IF(IA.GT.0) THEN
            IF(IBC.GT.0) CALL CHANGE_ANGLE_VALUE(IBC,IC,IA,VAL)
            IF(IFR.GT.0) CALL CHANGE_ANGLE_VALUE(IFR,IC,IA,VAL) 
          ENDIF
        ENDDO
      ENDIF 

      IF(ICROSS.GT.1) THEN
        DELTA = 360.0/FLOAT(ICROSS)
        DO I=1,ICROSS-1
          IA = IMC(I)
          IF(IA.GT.0) THEN
            DO J=I+1,ICROSS
              JA = IMC(J)
              IF(JA.GT.0) THEN
                VAL =FLOAT((J-I))*DELTA
                IF(VAL.GT.180.0) THEN
                  VAL  = 360.0 - VAL
                ENDIF
                IVAL = VAL + 0.1
                VAL = IVAL 
                CALL CHANGE_ANGLE_VALUE(IA,IC,JA,VAL)
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF 

C     tors definition
      N = 0
      IF(IBC.GT.0) THEN
        N = N + 1 
        IN(N) = IBC
      ENDIF
      IF(IFR.GT.0) THEN
        N = N + 1 
        IN(N) = IFR
      ENDIF
      IF(ICROSS.GT.0) THEN
        DO I=1,ICROSS
          N = N + 1 
          IN(N) = IMC(I)
        ENDDO
      ENDIF
      IF(N.LE.0) RETURN

      IA1_BEST   = 0
      IA4_BEST   = 0
      IRING_BEST =-1
      PHI_BEST   = 0.0

      DO ITORS=1,L1T_NTORS
        I1 = L1T_I1ATM(ITORS)
        I2 = L1T_I2ATM(ITORS)
        I3 = L1T_I3ATM(ITORS) 
        I4 = L1T_I4ATM(ITORS) 
        IF(IC.EQ.I2.OR.IC.EQ.I3) THEN
          IF(IC.EQ.I2) THEN
            I  = I2
            I2 = I3
            I3 = I 
            I  = I4
            I4 = I1
            I1 = I
          ENDIF
          DO IP=1,N
            IF(IN(IP).EQ.I2) THEN
              IP2 = IN(IP)

              IRING_BEST =-1

              DO JP=1,N
                IF(IN(JP).NE.I2) THEN
                  IP4 = IN(JP)
                  CALL SRCH_ANGL(MDOC,MON,IP2,IC,IP4,ANG4,LG,KERR)
                  IANG4 = 1   
                  IF(ANG4.LT.10.0.OR.ANG4.GT.170.0) IANG4 = 0
                  NP = 0 
                  IF(L1A_IBACK(IP2).GT.0) THEN
                    NP = NP + 1  
                    INP(NP)  = L1A_IBACK(IP2) 
                  ENDIF
                  IF(L1A_NDIST(IP2).GT.0) THEN
                    DO ID=1,L1A_NDIST(IP2)
                      NP = NP + 1               
                      INP(NP) = L1A_CONN(ID,IP2)
                    ENDDO
                  ENDIF
                  IF(L1A_NEXTR(IP2).GT.0) THEN
                    DO ID=1,L1A_NEXTR(IP2)
                      NP = NP + 1               
                      INP(NP) = L1A_IEXTR(ID,IP2)
                    ENDDO
                  ENDIF      
                  IF(NP.GE.1) THEN
                    DO KP=1,NP
                      IF(INP(KP).NE.IC) THEN
                        IP1 = INP(KP)
                        CALL SRCH_ANGL(MDOC,MON,IP1,IP2,IC,ANG1,LG,KERR)
                        IANG1 = 1   
                        IF(ANG1.LT.10.0.OR.ANG1.GT.170.0) IANG1=0
                        IRING = 0
                        PHI   = 180.0
                        IF(IANG1.GT.0.AND.IANG4.GT.0) THEN
                          IRING = 1
                          CALL CHECK_RING_ID(MDOC,IP1,IP2,IC
     *                                      ,IP4,ID,PHI,KERR) 
                          IF(ID.EQ.3) IRING = 2
C                         plan ?        
                        ENDIF  
                        IF(IRING.GT.IRING_BEST) THEN
                          IA1_BEST   = IP1
                          IA4_BEST   = IP4
                          IRING_BEST = IRING
                          PHI_BEST   = PHI
                        ENDIF
                      ENDIF
                    ENDDO
                  ENDIF
                ENDIF
              ENDDO 

              IF(IRING_BEST.GE.0) THEN
                L1T_I1ATM(ITORS)  = IA1_BEST
                L1T_1ATM (ITORS)  = L1A_ANAME(IA1_BEST)
                L1T_I2ATM(ITORS)  = IP2
                L1T_2ATM (ITORS)  = L1A_ANAME(IP2)
                L1T_I3ATM(ITORS)  = IC
                L1T_3ATM (ITORS)  = L1A_ANAME(IC)
                L1T_I4ATM(ITORS)  = IA4_BEST
                L1T_4ATM (ITORS)  = L1A_ANAME(IA4_BEST)
                L1T_VAL  (ITORS)  = PHI_BEST
              ENDIF
            ENDIF 
          ENDDO
        ENDIF 
      ENDDO
C ---------------------------------------
      RETURN
      END

      SUBROUTINE CHANGE_ANGLE_VALUE(I1,I2,I3,VAL)
C ---------------------------------------
      INTEGER I1,I2,I3
      REAL    VAL  
C ---
      INCLUDE 'lib_com.fh'
C ---
C ---------------------------------------
      NANGL = L1G_NANGL
      IF(NANGL.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) RETURN
      DO I=1,NANGL
        IF((L1G_I1ATM(I).EQ.I1.AND.L1G_I2ATM(I).EQ.I2.AND.
     *                             L1G_I3ATM(I).EQ.I3).OR.
     *     (L1G_I1ATM(I).EQ.I3.AND.L1G_I2ATM(I).EQ.I2.AND. 
     *                             L1G_I3ATM(I).EQ.I1)) THEN

C          WRITE(*,*) '-----ANG:',I
C          WRITE(*,*) '       1:',L1G_I1ATM(I),L1G_1ATM(I)
C          WRITE(*,*) '       2:',L1G_I2ATM(I),L1G_2ATM(I)
C          WRITE(*,*) '       3:',L1G_I3ATM(I),L1G_3ATM(I)

          L1G_VAL(I) = VAL 
          RETURN
        ENDIF
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE SRCH_METAL_CHIR(MDOC,MON,IC,IB,IBC,IFR,IMC
     *                                   ,ICROSS,SIGN,LC,IERR)
C -----------------------------------------------
      INTEGER   MDOC,IC,IB,IFR,IMC(*),ICROSS,LC,IERR
      CHARACTER MON*8,SIGN*8
C ---
      INCLUDE 'lib_com.fh'
C ---
C     CHARACTER LINE*256
      CHARACTER CH1*1
C --------------------------------------------------------
      IERR   = 0
      LC     = 0
      ICROSS = 0
      IBC    = 0
      IFR    = 0
      NCHIR = L1C_NCHIR
      IF(NCHIR.LE.0.OR.IC.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      DO I=1,NCHIR
        IF(L1C_I1ATM(I).EQ.IC) THEN
          IF(L1C_SIGN(I)(1:4).EQ.'cros'.OR.
     *       L1C_SIGN(I)(1:4).EQ.'star'    ) THEN
            IF(L1C_SIGN(I)(1:4).EQ.'cros') THEN
C             L1C_SIGN = 'crossN'
              CH1 = L1C_SIGN(I)(6:6)
            ELSE 
C             L1C_SIGN = 'starN'
              CH1 = L1C_SIGN(I)(5:5)
            ENDIF
            IF(CH1.NE.'0'.AND.CH1.NE.'1'.AND.CH1.NE.'2'.AND.
     *         CH1.NE.'3'.AND.CH1.NE.'4'.AND.CH1.NE.'5'.AND.
     *         CH1.NE.'6'.AND.CH1.NE.'7'.AND.CH1.NE.'8'.AND.
     *         CH1.NE.'9') THEN
              IERR = 3
              GO TO 100
            ENDIF 
            READ(CH1,'(I1)') ICROSS
            IF(L1C_SIGN(I)(1:4).EQ.'cros') THEN
              IBC    = L1C_I2ATM(I)
              IFR    = L1C_I3ATM(I)
              IF(ICROSS.GT.0) THEN
                IMC(1) = L1C_I4ATM(I) 
                IF(ICROSS.GT.1) THEN
                  IMC(2) = L1C_I5ATM(I) 
                  IF(ICROSS.GT.2) THEN
                    IMC(3) = L1C_I6ATM(I) 
                    IF(ICROSS.GT.3) THEN
                      IMC(4) = L1C_I7ATM(I) 
                      IF(ICROSS.GT.4) THEN
                        IMC(5) = L1C_I8ATM(I) 
                        IF(ICROSS.GT.5) THEN
                          IMC(6) = L1C_I9ATM(I)
                        ENDIF 
                      ENDIF 
                    ENDIF 
                  ENDIF 
                ENDIF 
              ENDIF 
            ELSE
              IBC    = 0
              IFR    = 0               
              IMC(1) = L1C_I2ATM(I) 
              IMC(2) = L1C_I3ATM(I) 
              IMC(3) = L1C_I4ATM(I) 
              IMC(4) = L1C_I5ATM(I) 
              IMC(5) = L1C_I6ATM(I) 
              IMC(6) = L1C_I7ATM(I) 
            ENDIF 
            SIGN = L1C_SIGN(I) 
            LC   = I
            GO TO 100 
          ELSE
C           there is usual chirality
            IERR = 9
            LC   = I
            GO TO 100 
          ENDIF
        ENDIF
      ENDDO
      IERR = 2
C ---------------------------------------
 100  CONTINUE
      RETURN
      END

      SUBROUTINE CHECK_DEFAULT_MET_CHIR(MDOC,MON,IA,NC
     *                                       ,IBOND,LIST,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      REAL      A(9)
      LOGICAL   IS_IT_METAL
      EXTERNAL  IS_IT_METAL
      INTEGER   IBOND(10),IMIN(2),IMC(10),ITEMP(6),I180(2,10)
      CHARACTER LINE*256,SIGN*8,MON*8,CH1*1,LIST*1
C --------------------------------------------------------
      IERR = 0
C ---
      IF(NC.LE.1.OR.NC.GT.4) THEN
        IERR = 1
        RETURN 
      ENDIF  
C --- how many 180 90 120 ?
      ITETR = 1
      N180  = 0
      N90   = 0
      N120  = 0          
      DO I=1,10
        IMC(I) = 0 
      ENDDO
      DO I=1,NC-1 
        DO J=I+1,NC 
          CALL SRCH_ANGL(MDOC,MON,IBOND(I),IA,IBOND(J),ANG,LG,IERR)
          IF(IERR.NE.0) RETURN
          IF(ANG.GT.162.0) THEN
            N180 = N180 + 1
            IF(N180.LE.10) THEN
              I180(1,N180) = IBOND(I)
              I180(2,N180) = IBOND(J)
            ENDIF
          ENDIF
          IF(ABS(ANG-90.0).LT.10.0) THEN
            N90 = N90 + 1
          ENDIF
          IF(ABS(ANG-120.0).LT.10.0) THEN
            N120 = N120 + 1
          ENDIF
          IF(ABS(ANG-109.5).GT.5.0) ITETR = 0
        ENDDO
      ENDDO

      IF(NC.GT.2.AND.ITETR.EQ.1) GO TO 500

C ---------
      IF(NC.EQ.2) THEN
        IF(N180.EQ.1) THEN
          ICROSS = 0
          IBC    = IBOND(1)
          IFR    = IBOND(2)
          IMC(1) = 0         
        ELSE
C         OK
          RETURN
        ENDIF
      ELSE IF(NC.EQ.4.AND.N180.EQ.2.AND.N90.EQ.4) THEN
        ICROSS = 2 
        IBC = I180(1,1)
        IFR = I180(2,1)
        N = 0  
        DO I=1,NC
          IF(IBOND(I).NE.IBC.AND.IBOND(I).NE.IFR) THEN
            N = N + 1 
            IMC(N) = IBOND(I)
          ENDIF
        ENDDO
      ELSE IF(NC.EQ.3.AND.N180.EQ.1.AND.N90.EQ.2) THEN
        ICROSS = 1 
        IBC = I180(1,1)
        IFR = I180(2,1)
        N = 0  
        DO I=1,NC
          IF(IBOND(I).NE.IBC.AND.IBOND(I).NE.IFR) THEN
            N = N + 1 
            IMC(N) = IBOND(I)
          ENDIF
        ENDDO        
      ELSE IF(NC.EQ.3.AND.N120.EQ.2.AND.N180.EQ.0) THEN
        ICROSS = 3 
        IBC = 0
        IFR = 0
        IMC(1) = IBOND(1)
        IMC(2) = IBOND(2)
        IMC(3) = IBOND(3)
      ELSE
        IERR = 1 
        RETURN 
      ENDIF
C ---------
      CALL SET_METAL_CHIRALITY(MDOC,MON,ICROSS,IA,IBC,IFR,IMC,LC,IERR)
      IF(IERR.NE.0) THEN
        IERR = 3
        RETURN
      ENDIF

              IF(LIST.EQ.'T') THEN
                write(*,*) '---METAL_ang--corr'
                write(*,*) '-ia,nc,icross:',ia,nc,icross
                write(*,'(a,6i4)') '-ibc,ifr,mc(1234):',ibc,ifr
     *          ,imc(1),imc(2),imc(3),imc(4)                                
              ENDIF

      CALL METAL_ANGLE_TORS_CORRECTION(MDOC,MON,NC,IA,IBC,IFR
     *             ,IMC,ICROSS,IERR)
      IF(IERR.NE.0) THEN
        IERR = 3
        RETURN
      ENDIF
      RETURN       
C ---------
 500  CONTINUE
      N = 0
      DO I=1,NC
        IF(L1A_SYMB(IBOND(I)).NE.'H   '.AND.
     *     L1A_SYMB(IBOND(I)).NE.'D   '     ) THEN
          N = N + 1          
          IMC(N) = IBOND(I)
        ENDIF
      ENDDO
      IF(N.GE.3) THEN
        IF(L1C_NCHIR.GE.MAX1CHR) THEN
          WRITE(LINE,
     *'(''ERROR: number of chiral centres in monomer '',A,'' >'',I6)'
     *) MON,MAX1CHR
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CHR in "lib_com.fh"')
          IERR=3
          RETURN
        ENDIF
        L1C_NCHIR   = L1C_NCHIR + 1
        L1C_I1ATM(L1C_NCHIR) = IA
        L1C_1ATM (L1C_NCHIR) = L1A_ANAME(IA)
        L1C_I2ATM(L1C_NCHIR) = IMC(1)
        L1C_2ATM (L1C_NCHIR) = L1A_ANAME(IMC(1))
        L1C_I3ATM(L1C_NCHIR) = IMC(2)
        L1C_3ATM (L1C_NCHIR) = L1A_ANAME(IMC(2))
        L1C_I4ATM(L1C_NCHIR) = IMC(3)
        L1C_4ATM (L1C_NCHIR) = L1A_ANAME(IMC(3))
        L1C_I5ATM(L1C_NCHIR) = 0
        L1C_5ATM (L1C_NCHIR) = '.'
        L1C_I6ATM(L1C_NCHIR) = 0
        L1C_6ATM (L1C_NCHIR) = '.'
        L1C_I7ATM(L1C_NCHIR) = 0
        L1C_7ATM (L1C_NCHIR) = '.'
        L1C_I8ATM(L1C_NCHIR) = 0
        L1C_8ATM (L1C_NCHIR) = '.'
        L1C_I9ATM(L1C_NCHIR) = 0
        L1C_9ATM (L1C_NCHIR) = '.'
        L1C_VOL  (L1C_NCHIR) = 0.0
        L1C_VOBS (L1C_NCHIR) = 0.0
        L1C_SIGN (L1C_NCHIR) = 'both'
        L1C_FLAG (L1C_NCHIR) = 'L'
        LC  = L1C_NCHIR
        PH1 = 0.0
        PH2 = 0.0
        PH3 = 0.0
        CALL CALC_IVOL(LC,VOLIDL,PH1,PH2,PH3)
        CALL CALC_OVOL(LC,VOLOBS,IERR)
        IERR = 0
        L1C_VOL (LC) = VOLIDL
        L1C_VOBS(LC) = VOLOBS
      ENDIF
C --------
      RETURN
      END

      SUBROUTINE METAL_CHIR_FROM_COORD(MDOC,LIST,MON
     *                                   ,IA,NC,IBOND,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      REAL      A(9)
      LOGICAL   IS_IT_METAL
      EXTERNAL  IS_IT_METAL
      INTEGER   IBOND(10),IMIN(2),IMC(10),ITEMP(6),I180(2,10)
      CHARACTER LINE*256,SIGN*8,MON*8,CH1*1,LIST*1
C --------------------------------------------------------
C --------------------------------------------------------
      IERR  = 0
      DELTA = 18.0
C --- all coords ? nc > 1
      IF(NC.LE.1) RETURN 
      DO I=1,NC
c         write(*,*)l1a_x(ibond(i)),l1a_y(ibond(i)),l1a_z(ibond(i))
c        IF(L1A_COOR_FLAG(IBOND(I)).NE.'Y') THEN
c          IERR = 2
c          RETURN
c        ENDIF
      ENDDO
C --- how many 180 ?
      ITETR = 1
      N180  = 0          
      DO I=1,NC-1 
        DO J=I+1,NC 
          CALL CALC_ANGOBS(IBOND(I),IA,IBOND(J),ANG)
          IF(ANG.GT.(180.0-DELTA)) THEN
            N180 = N180 + 1
            IF(N180.LE.10) THEN
              I180(1,N180) = IBOND(I)
              I180(2,N180) = IBOND(J)
            ENDIF
          ENDIF
          IF(ABS(ANG-109.5).GT.(DELTA/3.0)) ITETR = 0
        ENDDO
      ENDDO

      IF((NC.EQ.3.OR.NC.EQ.4).AND.ITETR.EQ.1) GO TO 500

C --- find bond with all others 90
      IBC   = 0
      NSIDE = 0  
      DO I=1,NC
        N = 0
        DO J=1,NC
          IF(I.NE.J) THEN
            CALL CALC_ANGOBS(IBOND(I),IA,IBOND(J),ANG)
c            write(*,*)l1a_aname(ibond(i)),l1a_aname(ibond(j)),ang

            IF(ABS(ANG-90.0).GT.DELTA.AND.
     *             ANG.LT.(180.0-DELTA)) GO TO 100
            N = N + 1
          ENDIF
        ENDDO
        IF(IBC.EQ.0.OR.N.GT.NSIDE) THEN
          IBC   = IBOND(I)
          NSIDE = N
        ENDIF
 100    CONTINUE
      ENDDO
      IFR = 0      
      IF(IBC.GT.0.AND.N180.GT.0) THEN
        DO I=1,N180
          IF(IBC.EQ.I180(1,I)) THEN
            IFR = I180(2,I)
            GO TO 200
          ELSE IF(IBC.EQ.I180(2,I)) THEN
            IFR = I180(1,I)
            GO TO 200
          ENDIF 
        ENDDO
      ENDIF
 200  CONTINUE
C --- min_delta   
      IMIN(1) = 0 
      IMIN(2) = 0
      AMIN    = 1000.0  
      DO I=1,NC-1 
        DO J=I+1,NC 
          II = IBOND(I)
          JJ = IBOND(J)         
          IF(II.NE.IBC.AND.II.NE.IFR.AND.JJ.NE.IBC.AND.JJ.NE.IFR)THEN
            CALL CALC_ANGOBS(IBOND(I),IA,IBOND(J),ANG)
            IF(ANG.LT.AMIN) THEN
              AMIN = ANG
              IMIN(1) = II
              IMIN(2) = JJ
            ENDIF
          ENDIF
        ENDDO
      ENDDO
C ---        
      NSIDE = 0
      DO I=1,NC
        II = IBOND(I)
        IF(II.NE.IBC.AND.II.NE.IFR) NSIDE = NSIDE + 1
      ENDDO
      DO I=1,10
        IMC(I) = 0
      ENDDO
      NS180 = N180
      IF(IBC.GT.0.AND.IFR.GT.0) NS180 = NS180 -1

      IF(LIST.EQ.'T') THEN
        write(*,*) '---METAL_CHIR_FROM_COORD--',DELTA
        write(*,*) '-ia,nc,nside:',ia,nc,nside
        write(*,'(a,3i4)') '-ibc,ifr,n180:',ibc,ifr,N180,NS180
        write(*,*) '-amin:',amin,IMIN(1),IMIN(2)
        if(nc.gt.0)
     *   write(*,'(a,10i4)') '-ib:',(ibond(i),i=1,nc)
      ENDIF
C --------
      IF(NSIDE.EQ.0) THEN
        ICROSS = 0
        IF(IBC.EQ.0.AND.IFR.EQ.0) THEN
          IERR = 1
          GO TO 310
        ENDIF
        IMC(1) = 0
        GO TO 400 
      ELSE IF(NSIDE.EQ.1) THEN
        ICROSS = 1
        IF(IBC.EQ.0) THEN
          IERR = 1
          GO TO 310
        ENDIF
        DO I=1,NC
          II = IBOND(I)
          IF(II.NE.IBC.AND.II.NE.IFR) IMC(1) = IBOND(I)
        ENDDO
        GO TO 400
      ELSE 
        IF(NSIDE.EQ.2.AND.NS180.EQ.1) THEN
          ICROSS = 2
          IF(IBC.EQ.0.OR.IFR.EQ.0) THEN
            IERR = 1
            GO TO 310
          ENDIF
          GO TO 300
        ENDIF  
        IF((ABS(AMIN-90.0).LT.19.0).AND.
     *     NSIDE.LE.4                  ) THEN
          IF((NSIDE.GT.2.AND.NS180.GT.0).OR.
     *       (NSIDE.LE.2.AND.NS180.LE.0)    ) THEN
            ICROSS = 4
            GO TO 300
          ENDIF 
        ENDIF
        IF((ABS(AMIN-60.0).LT.10.0).AND.
     *     NSIDE.LE.6                  ) THEN
          IF((NSIDE.GT.3.AND.NS180.GT.0).OR.
     *       (NSIDE.LE.2.AND.NS180.LE.0)    ) THEN
            ICROSS = 6
            GO TO 300
          ENDIF 
        ENDIF
        IF((ABS(AMIN-120.0).LT.10.0).AND.
     *    NSIDE.LE.3.AND.NS180.LE.0      ) THEN
          ICROSS = 3
          GO TO 300
        ENDIF
        IF((ABS(AMIN-144.0).LT.14.0.AND.NSIDE.EQ.2).OR.
     *     (ABS(AMIN- 72.0).LT.10.0.AND.NSIDE.GE.2)    ) THEN
          IF(NSIDE.LE.5.AND.NS180.LE.0) THEN
            ICROSS = 5
            GO TO 300
          ENDIF 
        ENDIF
      ENDIF
 310  CONTINUE
C     ERROR
      IF(LIST.EQ.'T') THEN
        write(*,*) '---ierr=',ierr
        write(*,'(a,10i4)') '-ib:',(ibond(i),i=1,nc)
       DO I=1,NC-1 
          DO J=I+1,NC 
            CALL CALC_ANGOBS(IBOND(I),IA,IBOND(J),ANG)
            write(*,*) '-i,j,ang:',i,j,ang
          ENDDO
        ENDDO
      ENDIF
      IERR = 1
      RETURN
C -----------------------------
 300  CONTINUE
      IDELTA = 360/ICROSS
      IMC(1) = IMIN(1)      
      DO I=1,NC
        II = IBOND(I)
        IF(II.NE.IBC.AND.II.NE.IFR.AND.II.NE.IMC(1)) THEN
          CALL CALC_ANGOBS(IBOND(I),IA,IMC(1),ANG)
          VOL = 0.0
          IF(IBC.GT.0) THEN
            A(1) = L1A_X(IBC) - L1A_X(IA)
            A(4) = L1A_Y(IBC) - L1A_Y(IA)
            A(7) = L1A_Z(IBC) - L1A_Z(IA)
            A(2) = L1A_X(IMC(1)) - L1A_X(IA)
            A(5) = L1A_Y(IMC(1)) - L1A_Y(IA)
            A(8) = L1A_Z(IMC(1)) - L1A_Z(IA)
            A(3) = L1A_X(IBOND(I)) - L1A_X(IA)
            A(6) = L1A_Y(IBOND(I)) - L1A_Y(IA)
            A(9) = L1A_Z(IBOND(I)) - L1A_Z(IA)
            VOL =  A(1)*(A(5)*A(9)-A(8)*A(6))
     *           - A(4)*(A(2)*A(9)-A(8)*A(3))
     *           + A(7)*(A(2)*A(6)-A(5)*A(3))           
          ENDIF
          IANG = ANG/FLOAT(IDELTA) + 0.5
          IF(IANG.LT.0     ) IANG = 0
          IF(IANG.GT.ICROSS) IANG = IANG - ICROSS
          IF(VOL.LT.0.0) IANG = ICROSS - IANG
          IF(IANG.EQ.ICROSS) IANG = 0
          IANG = IANG + 1    
          IF(IANG.LE.2     ) IANG = 2
          IF(IANG.GT.ICROSS) IANG = ICROSS
          IF(IMC(IANG).GT.0) THEN
            IMC1 = 1
            IF(IANG.LT.ICROSS) IMC1 = IMC(IANG+1)
            IF(IMC(IANG-1).LE.0.AND.IANG.GT.2) THEN
              IMC(IANG-1) = II
            ELSE IF(IMC1.LE.0) THEN
              IMC(IANG+1) = II
            ELSE
              IMC(IANG) = II
            ENDIF        
          ELSE
            IMC(IANG) = II
          ENDIF
        ENDIF
      ENDDO
C ---
      IF(LIST.EQ.'T') THEN
        write(*,'(a,10i4)') '-imc:',(iMC(i),i=1,ICROSS)
      ENDIF 
      IF(IMC(2).EQ.0.AND.IMC(ICROSS).GT.0) THEN
        DO I=2,ICROSS
          J = ICROSS+2-I
          ITEMP(J) = IMC(I)
        ENDDO
        DO I=2,ICROSS
          IMC(I) = ITEMP(I)          
        ENDDO
      ENDIF
      IF(LIST.EQ.'T') THEN
        write(*,'(a,10i4)') '=imc:',(iMC(i),i=1,ICROSS)
      ENDIF 
C ---------------------------      
 400  CONTINUE
      CALL SET_METAL_CHIRALITY(MDOC,MON,ICROSS,IA,IBC,IFR,IMC,LC,IERR)
      IF(IERR.NE.0) THEN
        IERR = 3
        RETURN
      ENDIF
      CALL METAL_ANGLE_TORS_CORRECTION(MDOC,MON,NC,IC,IBC,IFR
     *             ,IMC,ICROSS,IERR)
      IF(IERR.NE.0) THEN
        IERR = 3
        RETURN
      ENDIF
      RETURN
C ---------
 500  CONTINUE
      N = 0
      DO I=1,NC
        IF(L1A_SYMB(IBOND(I)).NE.'H   '.AND.
     *     L1A_SYMB(IBOND(I)).NE.'D   '     ) THEN
          N = N + 1          
          IMC(N) = IBOND(I)
        ENDIF
      ENDDO
      IF(N.GE.3) THEN
        IF(L1C_NCHIR.GE.MAX1CHR) THEN
          WRITE(LINE,
     *'(''ERROR: number of chiral centres in monomer '',A,'' >'',I6)'
     *) MON,MAX1CHR
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CHR in "lib_com.fh"')
          IERR=3
          RETURN
        ENDIF
        L1C_NCHIR   = L1C_NCHIR + 1
        L1C_I1ATM(L1C_NCHIR) = IA
        L1C_1ATM (L1C_NCHIR) = L1A_ANAME(IA)
        L1C_I2ATM(L1C_NCHIR) = IMC(1)
        L1C_2ATM (L1C_NCHIR) = L1A_ANAME(IMC(1))
        L1C_I3ATM(L1C_NCHIR) = IMC(2)
        L1C_3ATM (L1C_NCHIR) = L1A_ANAME(IMC(2))
        L1C_I4ATM(L1C_NCHIR) = IMC(3)
        L1C_4ATM (L1C_NCHIR) = L1A_ANAME(IMC(3))
        L1C_I5ATM(L1C_NCHIR) = 0
        L1C_5ATM (L1C_NCHIR) = '.'
        L1C_I6ATM(L1C_NCHIR) = 0
        L1C_6ATM (L1C_NCHIR) = '.'
        L1C_I7ATM(L1C_NCHIR) = 0
        L1C_7ATM (L1C_NCHIR) = '.'
        L1C_I8ATM(L1C_NCHIR) = 0
        L1C_8ATM (L1C_NCHIR) = '.'
        L1C_I9ATM(L1C_NCHIR) = 0
        L1C_9ATM (L1C_NCHIR) = '.'
        L1C_VOL  (L1C_NCHIR) = 0.0
        L1C_VOBS (L1C_NCHIR) = 0.0
        L1C_SIGN (L1C_NCHIR) = 'both'
        L1C_FLAG (L1C_NCHIR) = 'L'
        LC  = L1C_NCHIR
        PH1 = 0.0
        PH2 = 0.0
        PH3 = 0.0
        CALL CALC_IVOL(LC,VOLIDL,PH1,PH2,PH3)
        CALL CALC_OVOL(LC,VOLOBS,IERR)
        IERR = 0
        L1C_VOL (LC) = VOLIDL
        L1C_VOBS(LC) = VOLOBS
      ENDIF
C --------
      RETURN
      END

      SUBROUTINE SET_METAL_CHIRALITY(MDOC,MON,ICROSS
     *                              ,IA,IBC,IFR,IMC,LC,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER   IMC(*)
      CHARACTER LINE*256,CH1*1,MON*8
C --------------------------------------------------------
      IERR = 0
      LC   = 0
      IF(L1C_NCHIR.GE.MAX1CHR) THEN
        WRITE(LINE,
     *'(''ERROR: number of chiral centres in monomer '',A,'' >'',I6)'
     *) MON,MAX1CHR
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CHR in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF
      IF(IA.LE.0) RETURN 
     
      L1C_NCHIR   = L1C_NCHIR + 1

      L1C_2ATM(L1C_NCHIR) = '.'
      L1C_3ATM(L1C_NCHIR) = '.'
      L1C_4ATM(L1C_NCHIR) = '.'
      L1C_5ATM(L1C_NCHIR) = '.'
      L1C_6ATM(L1C_NCHIR) = '.'
      L1C_7ATM(L1C_NCHIR) = '.'
      L1C_8ATM(L1C_NCHIR) = '.'
      L1C_9ATM(L1C_NCHIR) = '.'
      L1C_I2ATM(L1C_NCHIR) = 0
      L1C_I3ATM(L1C_NCHIR) = 0
      L1C_I4ATM(L1C_NCHIR) = 0
      L1C_I5ATM(L1C_NCHIR) = 0
      L1C_I6ATM(L1C_NCHIR) = 0
      L1C_I7ATM(L1C_NCHIR) = 0
      L1C_I8ATM(L1C_NCHIR) = 0
      L1C_I9ATM(L1C_NCHIR) = 0

      L1C_I1ATM(L1C_NCHIR) = IA
      L1C_1ATM (L1C_NCHIR) = L1A_ANAME(IA)
      L1C_I2ATM(L1C_NCHIR) = IBC
      IF(IBC.GT.0) L1C_2ATM (L1C_NCHIR) = L1A_ANAME(IBC)
      L1C_I3ATM(L1C_NCHIR) = IFR
      IF(IFR.GT.0) L1C_3ATM (L1C_NCHIR) = L1A_ANAME(IFR)
      L1C_I4ATM(L1C_NCHIR) = IMC(1)
      IF(IMC(1).GT.0) L1C_4ATM (L1C_NCHIR) = L1A_ANAME(IMC(1))
      IF(ICROSS.GT.2) THEN 
        L1C_I5ATM(L1C_NCHIR) = IMC(2)
        IF(IMC(2).GT.0) L1C_5ATM (L1C_NCHIR) = L1A_ANAME(IMC(2))
        L1C_I6ATM(L1C_NCHIR) = IMC(3)
        IF(IMC(3).GT.0) L1C_6ATM (L1C_NCHIR) = L1A_ANAME(IMC(3))
        L1C_I7ATM(L1C_NCHIR) = IMC(4)
        IF(IMC(4).GT.0) L1C_7ATM (L1C_NCHIR) = L1A_ANAME(IMC(4))
        L1C_I8ATM(L1C_NCHIR) = IMC(5)
        IF(IMC(5).GT.0) L1C_8ATM (L1C_NCHIR) = L1A_ANAME(IMC(5))
        L1C_I9ATM(L1C_NCHIR) = IMC(6)
        IF(IMC(6).GT.0) L1C_9ATM (L1C_NCHIR) = L1A_ANAME(IMC(6))
      ENDIF
      L1C_VOL  (L1C_NCHIR) = 0.0
      L1C_VOBS (L1C_NCHIR) = 0.0
      WRITE(CH1,'(I1)') ICROSS
      L1C_SIGN(L1C_NCHIR) = 'cross'//CH1
      L1C_FLAG(L1C_NCHIR) = 'X'
      LC = L1C_NCHIR
C --------
      RETURN
      END

      SUBROUTINE H_ATOM_COORS_REBUILD(MDOC,LIST,IMODE,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR,IMODE
C
C     IMODE = 0 generate H-atom coords (if there are only nonH-atom coors)
C           = 1 new H-atom coords
C ---
      INCLUDE 'lib_com.fh'
C ---
      REAL      V1(3),V2(3),V3(3),VV(3,12),VN(3)
      INTEGER   ICONN(12)
      CHARACTER LINE*256,LIST*1,MON*8
C --------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
      MON   = ' '
      IF(L1A_NATOM.LE.3) RETURN
C ----
      ICOOR        = 0
      COOR_SUM     = 0.0
      ICOOR_TOT    = 0
      COOR_SUM_TOT = 0.0
      DO I=1,L1A_NATOM

        IF(L1A_COOR_FLAG(I).EQ.'N'.OR.
     *     L1A_COOR_FLAG(I).EQ.'.') THEN
          ICOOR_TOT=1 
        ELSE
          COOR_SUM_TOT = COOR_SUM_TOT +  
     *           ABS(L1A_X(I)) + ABS(L1A_Y(I)) + ABS(L1A_Z(I)) 
        ENDIF

        IF(L1A_SYMB(I).NE.'H   '.AND.
     *     L1A_SYMB(I).NE.'D   '     ) THEN
          IF(L1A_COOR_FLAG(I).EQ.'N'.OR.
     *       L1A_COOR_FLAG(I).EQ.'.') THEN
            ICOOR=1 
          ELSE
            COOR_SUM = COOR_SUM +  
     *             ABS(L1A_X(I)) + ABS(L1A_Y(I)) + ABS(L1A_Z(I)) 
          ENDIF
        ENDIF
      ENDDO
      IF(COOR_SUM.LT.0.001) ICOOR = 1
      IF(COOR_SUM_TOT.LT.0.001) ICOOR_TOT = 1
C
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '>>ICOOR,ICOOR_TOT:',ICOOR,ICOOR_TOT
      ENDIF
C        nonH-atoms -  not all nonH-atoms have coords 
      IF(ICOOR.GT.0) RETURN
C        all atoms have coords 
      IF(IMODE.EQ.0.AND.ICOOR_TOT.LE.0) RETURN
      IF(L1T_NTORS.LE.0) RETURN
C ----
      DO II=1,L1A_NATOM
        IF(L1A_SYMB(II).NE.'H   '.AND.L1A_SYMB(II).NE.'D   ') THEN

          CALL SET_CONN_L(II,N,NH,ICONN)
               
          IF(LIST.EQ.'T') THEN
            write(*,*) '========>',ii,L1A_ANAME(ii),n,nh
          ENDIF 

          IF(NH.NE.(N-1)) THEN
            IERR = 4
            GO TO 300
          ENDIF
          DO J=1,N
            JA = ICONN(J)  
            IF(L1A_SYMB(JA).EQ.'H   '.OR.
     *         L1A_SYMB(JA).EQ.'D   '    ) THEN
              I = JA  
            ENDIF 
          ENDDO 

          DO IT=1,L1T_NTORS
            I1  = L1T_I1ATM(IT)
            I2  = L1T_I2ATM(IT)
            I3  = L1T_I3ATM(IT)
            I4  = L1T_I4ATM(IT)
            IF(I1.EQ.I.OR.I4.EQ.I) THEN
              IF(I1.EQ.I) THEN
                IB   = I2
                IBB  = I3
                IBBB = I4
              ELSE
                IB   = I3
                IBB  = I2
                IBBB = I1
              ENDIF
              PH  = L1T_VAL(IT) 
              PH  = PH*PI180  
              GO TO 100
            ENDIF   
          ENDDO
          IERR = 2
          GO TO 300

 100      CONTINUE

          CALL SET_CONN_L(IB,N,NH,ICONN)
         
          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '-IB,N,NH:',IB,N,NH
          ENDIF 
C ----
C         IBBB --> IBB --> IB --> I(h)
C              AV1     AV2    AV3 
C                 ANG1    ANG2
C                      PH
            
          CALL SRCH_BOND(MDOC,MON,I,IB,AV3,LB,IERR)
          IF(IERR.NE.0) GO TO 200

          CALL SRCH_BOND(MDOC,MON,IB,IBB,AV2,LB,IERR)
          IF(IERR.NE.0) GO TO 200

          CALL SRCH_BOND(MDOC,MON,IBB,IBBB,AV1,LB,IERR)
          IF(IERR.NE.0) GO TO 200

          CALL SRCH_ANGL(MDOC,MON,IB,IBB,IBBB,ANG1,LG,IERR)
          IF(IERR.NE.0) GO TO 200
          ANG1 = ANG1*PI180

          CALL SRCH_ANGL(MDOC,MON,I,IB,IBB,ANG2,LG,IERR)
          IF(IERR.NE.0) GO TO 200
          ANG2 = ANG2*PI180

          V1(1) =  L1A_X(IBB) - L1A_X(IBBB)
          V1(2) =  L1A_Y(IBB) - L1A_Y(IBBB)
          V1(3) =  L1A_Z(IBB) - L1A_Z(IBBB)

          V2(1) =  L1A_X(IB) - L1A_X(IBB)
          V2(2) =  L1A_Y(IB) - L1A_Y(IBB)
          V2(3) =  L1A_Z(IB) - L1A_Z(IBB)
 
          CALL COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PH,V3)
          L1A_X(I) = L1A_X(IB) + V3(1)
          L1A_Y(I) = L1A_Y(IB) + V3(2)
          L1A_Z(I) = L1A_Z(IB) + V3(3)
          L1A_COOR_FLAG(I) = 'Y'

          IF(LIST.EQ.'T') write(*,*) '==>',i,L1A_ANAME(i),ph 

          IF(NH.GT.1) THEN
            DELTA = TWOPI/FLOAT(NH)
            DO J=1,N
              JA = ICONN(J)  
              IF(JA.NE.I) THEN
                IF(L1A_SYMB(JA).EQ.'H   '.OR.
     *             L1A_SYMB(JA).EQ.'D   '    ) THEN
                  PH = PH + DELTA 
                  CALL COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PH,V3)
                  L1A_X(JA) = L1A_X(IB) + V3(1)
                  L1A_Y(JA) = L1A_Y(IB) + V3(2)
                  L1A_Z(JA) = L1A_Z(IB) + V3(3)
                  L1A_COOR_FLAG(JA) = 'Y'
              
          IF(LIST.EQ.'T') write(*,*) '==>',ja,L1A_ANAME(ja),ph 

                ENDIF
              ENDIF 
            ENDDO 
          ENDIF 
          GO TO 200
      
 300      CONTINUE
          IBACK = II

          IF(LIST.EQ.'T') WRITE(*,*) '=IBACK,N,NH:',IBACK,N,NH,IERR

          IF(NH.EQ.1.AND.N.GE.3) THEN          
            V3(1) = 0.0
            V3(2) = 0.0
            V3(3) = 0.0
            NN    = 0
            C     = -1.0
            DO J=1,N
              JA = ICONN(J)  

            IF(LIST.EQ.'T') then
              write(*,*) '>',J,ja,L1A_ANAME(ja),NN,L1A_SYMB(JA)
            ENDIF

              IF(L1A_SYMB(JA).EQ.'H   '.OR.
     *           L1A_SYMB(JA).EQ.'D   '    ) THEN
                JAH = JA  
              ELSE
                V1(1) = (L1A_X(IBACK) - L1A_X(JA))
                V1(2) = (L1A_Y(IBACK) - L1A_Y(JA))
                V1(3) = (L1A_Z(IBACK) - L1A_Z(JA))
                CALL NB_VMOD(V1,AV1)
                IF(AV1.GT.0.2) THEN 
                  NN       = NN + 1
                  VV(1,NN) = V1(1)/AV1
                  VV(2,NN) = V1(2)/AV1
                  VV(3,NN) = V1(3)/AV1
                ENDIF 
                V3(1) = V3(1) + V1(1)/AV1
                V3(2) = V3(2) + V1(2)/AV1
                V3(3) = V3(3) + V1(3)/AV1
              ENDIF
            ENDDO
            CALL SRCH_BOND(MDOC,MON,JAH,IBACK,AV3,LB,IERR)
            IF(IERR.NE.0) GO TO 200
            IF(NN.GE.3) THEN
              V1(1) = VV(1,2) - VV(1,1)                  
              V1(2) = VV(2,2) - VV(2,1)                  
              V1(3) = VV(3,2) - VV(3,1)                  
              V2(1) = VV(1,3) - VV(1,1)                  
              V2(2) = VV(2,3) - VV(2,1)                  
              V2(3) = VV(3,3) - VV(3,1)                  
              CALL NB_VMULT(V1,V2,VN)
              CALL NB_VMOD(VN,AVN)
              IF(AVN.GT.0.02) THEN
                CALL NB_VMOD(V3,AV1)
                IF(AV1.GT.0.01) THEN
                  CALL NB_VPROD(V3,VN,PROD)
                  C = 1.0
                  IF(PROD.LT.0.0) C = -1.0  
                  V3(1) = VN(1)*C
                  V3(2) = VN(2)*C
                  V3(3) = VN(3)*C
                ELSE
                  V3(1) = VN(1)
                  V3(2) = VN(2)
                  V3(3) = VN(3)
                ENDIF
              ENDIF
            ENDIF

            CALL NB_VMOD(V3,AV1)
            IF(AV1.LT.0.01) GO TO 200
            V3(1) = (V3(1)*AV3)/AV1
            V3(2) = (V3(2)*AV3)/AV1
            V3(3) = (V3(3)*AV3)/AV1

            L1A_X(JAH) = L1A_X(IBACK) + V3(1)
            L1A_Y(JAH) = L1A_Y(IBACK) + V3(2)
            L1A_Z(JAH) = L1A_Z(IBACK) + V3(3)
            L1A_COOR_FLAG(JAH) = 'Y'
              
            IF(LIST.EQ.'T') then
              write(*,*) '==>',jah,L1A_ANAME(jah),av1,C,NN
            ENDIF
            IERR = 0
            GO TO 200
          ELSE IF(NH.EQ.2.AND.N.EQ.4) THEN
            JJA = 0
            DO J=1,N
              JAA = ICONN(J)  
              IF(L1A_SYMB(JAA).NE.'H   '.AND.
     *           L1A_SYMB(JAA).NE.'D   '      ) THEN
                JA = JAA
                IF(JJA.LE.0) JJA = JA  
              ELSE
                JAH = JAA
              ENDIF
            ENDDO

            IF(LIST.EQ.'T') write(*,*) '  ja,jja:',ja,jja
  
C            JJA'        H
C               \       /
C                JA-->IBACK 
C                       \
C                       JJA
            V1(1) =  L1A_X(JJA)   - L1A_X(IBACK)
            V1(2) =  L1A_Y(JJA)   - L1A_Y(IBACK)
            V1(3) =  L1A_Z(JJA)   - L1A_Z(IBACK)
            V2(1) =  L1A_X(IBACK) - L1A_X(JA)
            V2(2) =  L1A_Y(IBACK) - L1A_Y(JA)
            V2(3) =  L1A_Z(IBACK) - L1A_Z(JA)
            CALL NB_VMOD(V1,AV1)
            CALL NB_VMOD(V2,AV2)
            IF(AV1.LT.0.01.OR.AV2.LT.0.01) GO TO 200
            CALL NB_VPROD(V1,V2,S)
            COSA1 = S/(AV1*AV2)
            ANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
            ANG1  = PI-ANG1
            CALL SRCH_BOND(MDOC,MON,JAH,IBACK,AV3,LB,IERR)
            IF(IERR.NE.0) GO TO 200
            ANG2  = 109.54*PI180
            DELTA = TWOPI/3.0
            PH    = (-180.0)*PI180
            DO J=1,N
              JAA = ICONN(J)  
              IF(L1A_SYMB(JAA).EQ.'H   '.OR.
     *           L1A_SYMB(JAA).EQ.'D   '    ) THEN
                PH = PH + DELTA 
                CALL COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PH,V3)
                L1A_X(JAA) = L1A_X(IBACK) + V3(1)
                L1A_Y(JAA) = L1A_Y(IBACK) + V3(2)
                L1A_Z(JAA) = L1A_Z(IBACK) + V3(3)
                L1A_COOR_FLAG(JAA) = 'Y'
              
         IF(LIST.EQ.'T') write(*,*) '==>',jaa,L1A_ANAME(jaa),ph 

              ENDIF
            ENDDO 
            IERR = 0
            GO TO 200
          ENDIF 
 200      CONTINUE
          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '>>I,IERR:',I,IERR
          ENDIF
          IERR = 0 
        ENDIF
      ENDDO
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '>>IERR:',IERR
      ENDIF
      IERR = 0
C --------
      RETURN
      END

      SUBROUTINE SET_CONN_L(IA,N,NH,ICONN)
C -----------------------------------
      INCLUDE 'lib_com.fh'
C ----------------------------------------------------------
      INTEGER     IA,N,ICONN(*)
C -----------------------------------
      N  = 0
      NH = 0
      IF(IA.LE.0) RETURN
      IF(L1A_IBACK(IA).GT.0) THEN
        N = N + 1 
        ICONN(N) = L1A_IBACK(IA)
      ENDIF
      IF(L1A_NDIST(IA).GT.0) THEN
        DO J=1,L1A_NDIST(IA)
          IC = L1A_CONN(J,IA)
          N  = N + 1 
          ICONN(N) = IC
        ENDDO
      ENDIF
      IF(L1A_NEXTR(IA).GT.0) THEN
        DO J=1,L1A_NEXTR(IA)
          IC = L1A_IEXTR(J,IA)
          N  = N + 1 
          ICONN(N) = IC
        ENDDO
      ENDIF
      IF(N.GT.0) THEN
        DO I=1,N
          IC = ICONN(I)
          IF(L1A_SYMB(IC).EQ.'H   '.OR.L1A_SYMB(IC).EQ.'D   ')
     *    NH = NH + 1
        ENDDO
      ENDIF
C ----
      RETURN
      END
