      subroutine occup_only_refine(nmodel)
cc
      use agreem
      use rharvest
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'refi_flags.fh'
      include 'occupancy_params.fh'
c
c--Very simple occupancy only refinement. Needs to be removed and 
c--made allocatable array 
c also more models won't work while geom is missing although formally here

      REAL GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
c-------------------------------------------------
      integer i,ia,ic,ip,np_occ,im
      integer nparam,nmodel
      real av_shift
      
      real, allocatable :: hqq(:)
      integer, allocatable ::occup_ref_at_flag(:,:)
      integer jrs,nat1,n_atom_tot
      character chnnmp*4
c
c---  body
      call set_hkon_flags(nmodel)
      nparam = 0
      n_atom_tot=0
      do im=1,nmodel
        do ia=1,n_atom_mod(im)
          if(atom_ref_mod_flag(ia,im).gt.0) nparam = nparam + 1
        enddo
        n_atom_tot=n_atom_tot+n_atom_mod(im)
      enddo
      
      allocate(hqq(n_atom_tot))
      allocate(occup_ref_at_flag(n_atom_mod_max,nmodel))
c
c--Assign flags
      do im=1,nmodel
        occup_ref_at_flag(1:n_atom_mod(im),im) = 0
      enddo
      write(*,*)occup_ref_atoms
      if(occup_ref_atoms.eq.'ALL') then
        av_shift = 0.0
        nat1 = 0
        do im=1,nmodel
          occup_ref_at_flag(1:n_atom_mod(im),im) = 1
          do ia=1,n_atom_mod(im)
            if(atom_ref_mod_flag(ia,im).gt.0) then
              av_shift=av_shift + occup_mod(ia,im)
              nat1 = nat1 + 1
            endif
          enddo
        enddo
        av_shift = av_shift/nat1
        occup(1:n_atom) = occup(1:n_atom)/(2.0*av_shift)
        do im=1,nmodel
          occup_mod(1:n_atom_mod(im),im) = 
     &      occup_mod(1:n_atom_mod(im),im)/(2.0*av_shift)
        enddo
      else
         write(*,*)natom_occup_refine
        if(natom_occup_refine.gt.0) then
          do im=1,nmodel
            do  ia=1,n_atom_mod(im)
               read(res_num_pdb(i_resid_mod(ia,im))(3:6),*)jrs
               call get_chain_namepdb(chnnmp,i_resid_mod(ia,im))
               do  i=1,natom_occup_refine
                  if(occup_refine_atom(i).eq.atm_name_inp(ia).and.
     &                 occup_refine_residue(i).eq.jrs.and.
     &                 occup_refine_chain(i).eq.chnnmp) then
                     occup_ref_at_flag(ia,im) = 1
                  endif
               enddo
            enddo
          enddo
        endif
c
c--Residue selection here?

      endif

      do ic=1,nccref
         call refall(nmodel)
c         ml_scale_flag = .FALSE.
         write(*,'(3x,a,i3,a, f10.3,2x,a,f10.3)')' ncycle = ',ic,
     &        ' rfactor = ',rfactor_work,' rfree = ',rfactor_free
         call hess_occup(nmodel,hqq)
         av_shift = 0.0
         np_occ   = 0
         if(occup_ref_atoms.eq.'ALL') then
            ip=0
           do im=1,nmodel
             do ia=1,n_atom_mod(im)
               if(atom_ref_mod_flag(ia,im).gt.0) then
                  ip = ip + 1
                  if(occup_ref_at_flag(ia,im).eq.1) then   
c     
c--   Is it in the list??
                     if(hqq(ip).gt.0.0) then
                        av_shift = av_shift + gq(ip)/hqq(ip)
                        np_occ = np_occ + 1
                     endif
                  endif
                endif
              enddo
            enddo
            av_shift = av_shift/np_occ
         endif
         ip=0
         do im=1,nmodel
           do ia=1,n_atom_mod(im)
             if(atom_ref_mod_flag(ia,im).gt.0) then
               ip = ip + 1
               if(occup_ref_at_flag(ia,im).eq.1) then
c     
c--   Is it in the list??
                  if(hqq(ip).gt.0.0) then
                     if (im.eq.1) occup(ia) = max(0.00,min(1.0,
     &                    occup(ia)+gq(ip)/hqq(ip)-av_shift))
                     occup_mod(ia,im) = max(0.00,min(1.0,
     &                    occup_mod(ia,im)+gq(ip)/hqq(ip)-av_shift))
c                     occup(ia) = occup(ia)+gq(ip)/hqq(ip)-av_shift

                  endif
               endif
             endif
           enddo
         enddo
      enddo

      deallocate(hqq)
      deallocate(occup_ref_at_flag)
      stop
      return
      end
c
      subroutine hess_occup(nmodel,hqq)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
c
      integer nmodel
      real hqq(*)
c
      integer ip,ia,iaa,iaa1,im
      real h_xxd,h_uud(3),h_uqd,h_qqd
      real h_uud_anom(3),h_uqd_anom,h_qqd_anom
c
c---  body
      ip=0
      do im=1,nmodel
        do ia=1,n_atom_mod(im)
           iaa = atom_ref_mod_flag(ia,im)/10
           iaa1 = atom_ref_mod_flag(ia,im)-10*iaa
           if(iaa.gt.0) then
              ip = ip + 1
              if(iaa1.gt.2) then
                 call fast_hessian_diagonal(ia,im,h_xxd,h_uud,h_uqd,
     &                h_qqd,h_uud_anom,h_uqd_anom,h_qqd_anom)
                 hqq(ip) = h_qqd
              endif
           endif
        enddo
      enddo

      return
      end
c
      subroutine occupancy_group_refine(nmodel)
      use agreem
      use rharvest
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'refi_flags.fh'
      include 'occupancy_params.fh'
c
c--Very simple occupancy group refinement. 
c
c---Augmented lagrangian could be added.
c
      REAL GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
c-------------------------------------------------
      integer i,j,ii,ia,ia1,iaa,ic,ip,np_occ,im
      integer igr,igr1,num_o,num_c,nocc_group
      real occ_sum,sigma,w,delta
      real*8 toler
      real eps_small

      integer nparam,nmodel
      real av_shift
      
      integer nwork,info
      real*8, allocatable :: hqq(:,:)
      real*8, allocatable :: gqq(:)
      real*8, allocatable :: shfts(:)
      real*8, allocatable :: work(:)

      real, allocatable :: hqq_atom(:)
      integer, allocatable ::occup_ref_at_flag(:,:)
      character chnnmp*4
c
c---  body
      if(occup_ref_atoms.eq.'ALL') then

      endif

      toler = 1.0d-8
      eps_small = 0.0001
c      call set_hkon_flags(nmodel)
      nocc_group = maxval(corr_id(1:n_atom))
      if(nocc_group.le.0) return
      if(nocc_group.gt.max_occ_group) then
         write(*,*)'Error==> Too many occupancy groups'
         write(*,*)'Error==> Maximum allowed is ',max_occ_group
         call ccperr(1,'Problem in occupancy refinement')
      endif
      allocate(hqq(nocc_group,nocc_group))
      allocate(gqq(nocc_group))
      allocate(shfts(nocc_group))
      nwork = max(100,nocc_group**2)
      allocate(work(nwork))
c
      allocate(hqq_atom(n_atom))
c

      write(*,*)
      write(*,*)'   Number of occupancy groups      = ',nocc_group
      write(*,*)'   Number of occupancy constraints = ',nocc_const
      write(*,*)'   Number of strict constraints    = ',
     &     sum(occ_const_type(1:nocc_const))
      do ii=1,ncycle_occup
         call refall(nmodel)
         
         hqq_atom(1:n_atom) = 0.0
         call hess_occup(nmodel,hqq_atom)
         gqq(1:nocc_group) = 0.0d0
         hqq(1:nocc_group,1:nocc_group) = 0.0d0
         ia1 = 0
         do ia=1,n_atom
            iaa = atom_ref_mod_flag(ia,1)/10
            if(iaa.gt.0) then
               ia1 = ia1 + 1
               if(corr_id(ia).gt.0) then
                  igr = corr_id(ia)
c     write(*,*)igr,ia1,gq(ia1)
                  gqq(igr) = gqq(igr) + gq(ia1)
                  hqq(igr,igr) = hqq(igr,igr) + hqq_atom(ia1)
               endif
            endif
         enddo
c
c---  Add quadratic constraints
         num_o = 0
         sigma = 0.01

         write(*,*)
         do ic=1,nocc_const
            num_c = nocc_const_num(ic)
c     write(*,*)num_o,num_c,occ_const_type(ic)
            if(occ_const_type(ic).eq.1) then
               w = 1.0/sigma**2
               occ_sum = 0.0
               do i=num_o+1,num_o+num_c
                  igr = c_occ(i)
                  occ_sum = occ_sum + occ_grp_value(igr)
               enddo
               delta = occ_sum-1.0
               do i=num_o+1,num_o+num_c
                  igr = c_occ(i)
c     write(*,*)'igr ',igr
                  gqq(igr) = gqq(igr) - w*delta
                  do j=num_o+1,num_o+num_c
                     igr1 = c_occ(j)
c     write(*,*)'igr1 ',igr1,w
                     hqq(igr,igr1) = hqq(igr,igr1) + w
                  enddo
               enddo
            endif 
            num_o = num_o + num_c
         enddo
c

         call deigen_filter_r(toler,hqq(1:nocc_group,1:nocc_group),
     &        nocc_group,nocc_group,gqq(1:nocc_group),
     &        shfts(1:nocc_group),
     &        work,nwork)
c     stop

         do igr=1,nocc_group
            occ_grp_value(igr) = max(eps_small,
     &           min(1.0,occ_grp_value(igr)+shfts(igr)))
         enddo
c     
c---  Enforce constraints. IF there are conflicting constraints 
c---  (i.e. the same occupancy groups may be present in several 
c---  constraints) then this procedure may fail. To deal with this 
c---  augmented lagrangian method should be implemented
         num_o = 0
         do ic=1,nocc_const
            num_c = nocc_const_num(ic)
            occ_sum = 0.0
            do i=num_o+1,num_o+num_c
               igr = c_occ(i)
               occ_sum = occ_sum + occ_grp_value(igr)
            enddo
            if(occ_const_type(ic).eq.1) then
               do i=num_o+1,num_o+num_c
                  igr = c_occ(i)
                  occ_grp_value(igr) = occ_grp_value(igr)/occ_sum
               enddo
            endif
            num_o = num_o+num_c
         enddo
         write(*,*)occ_grp_value(1:nocc_group)
c     
         do ia=1,n_atom
            if(corr_id(ia).gt.0) then
               igr = corr_id(ia)
               if(occup_mod(ia,1).gt.eps_small) then
                  occup(ia) = occ_grp_value(igr)
                  occup_mod(ia,1) = occup(ia)
               endif
            endif
         enddo
      enddo
c
c---  Make sure that constraints are obeyed

c
c---  Add shifts

      deallocate(hqq)
      deallocate(gqq)
      deallocate(shfts)
      deallocate(hqq_atom)
c      stop
      return
      end
