C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE SOLVENT
      use agreem
      implicit none
C-----------------------------------------------------------------------
C     These routines generates structure factors from the solvent region
C         *********SPACE GROUP GENERAL**********
C      G.N.M. 17.11.2007
C-----------------------------------------------------------------------
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'monitor.fh'

      COMMON /HKLLIM/ HMAX, KMAX, LMAX
      INTEGER   HMAX, KMAX, LMAX
      integer nxy,nref,ngx,ngy,ngz,nmfour
      real asymlim1,asymlim2,asymlim3
      INTEGER   FC_ADDR,PHASE_ADDR,DEN_ADDR,IND_ADDR,POOL_ADDR
      REAL FSHANN_L
      INTEGER   SIZE,ndens
      CHARACTER LINE*128

C -----------------------------------------------------
C
C---Find minimum accetable grid spacing for ffts
      NX = 0
      NY = 0
      NZ = 0
cd      FSHANN = 2.0
cd      FSHANN_L = 1.3
      FSHANN_L = FSHANN
      CALL GET_GRID_SPACING(FSHANN_L,NGX,NGY,NGZ,HMAX,KMAX,LMAX)
C   
      CALL ASYLIM_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,IPX,IPY,IPZ,NMFOUR)

c      CALL ASYLIM(CS_NSPGR,IPX,IPY,IPZ,NMFOUR)
      ASYMLIM1 = 1.0/IPX
      ASYMLIM2 = 1.0/IPY
      ASYMLIM3 = 1.0/IPZ
      IF(MON_STYLE.EQ.'MANY') THEN
        WRITE(LINE,'(A,3F5.2)')' Limits of asymmetric unit      :',
     +               ASYMLIM1,ASYMLIM2,ASYMLIM3
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3I5)')  ' Grid spacing to be used        : ',
     +             NX,NY,NZ
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3I5)')  ' Maximuum H,K,L                 : ',
     +             HMAX,KMAX,LMAX
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3I5)')  ' Minimum acceptable grid spacing: ',
     +             NGX,NGY,NGZ
        CALL ERRWRT(-1,LINE)
      ENDIF
c
      IF(MOD(NX,NMFOUR).NE.0.OR.MOD(NY,NMFOUR).NE.0
     +  .OR.MOD(NZ,NMFOUR).NE.0) THEN 
           CALL ERRWRT(1,' Change grid spacings ')
      ENDIF
C
C----Now allocate memory for S.F. Den and so on
      N1   = NX
      N2   = NY
      N3   = NZ/IPZ
      IF(IPZ.GT.1) N3 = N3 + 1
C
c
c---Deal with the atoms that do not contribute to the mask calculation
      
      CALL REF_ALL_SOLV(NREF)

      NX = 0
      NY = 0
      NZ = 0
      RETURN
      END

C-----------------------------------------------------------------------
      SUBROUTINE REF_ALL_SOLV(NREF)
      use weights
      use agreem
      use rharvest
      use solvent_all
      IMPLICIT NONE
C
C    Structure factors from solvent
C----This subroutine uses semi FFT
C
C          ********SPACE GROUP GENERAL***********
C       G.N.M.  17.11.2007
C-----------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INTEGER   SZ,NREF

C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      integer ndens,nmodel
      real, allocatable :: fc(:,:)
      real, allocatable :: phase(:,:)
      real, allocatable :: den(:,:,:,:)
      real, allocatable :: pool(:)
      integer, allocatable :: hkl_asym(:,:)


      integer i
      integer ia,iexcl,im,natom_im,nanom
      integer ires_num_loc
      character chnid_loc*4
      REAL ZERO
      real vfrac
      INTEGER IZERO
      real,   allocatable :: occupancy_save(:,:,:)
      logical save,restore
      parameter (save=.true.)
      parameter (restore=.false.)
C----Initialise
      ndens = 1
      nmodel = 1
      nanom = 0
      allocate(fc(nobs,1))
      allocate(phase(nobs,1))
      allocate(den(n1,n2,n3,1))
      allocate(hkl_asym(3,nobs))
c
      ZERO  = 0.0
      IZERO = 0
      hkl_asym(1:3,1:nobs) = 0
      fc(1:nobs,1:1) = 0.0
      phase(1:nobs,1:1) = 0.0
C
C     GENERATE SOLVENT DENSITY MAP
      CALL MASK_INIT(DEN(1:n1,1:n2,1:n3,1))
C     
C      CALL SOLVENT_ACC(ACC)
C     
C---the  atoms excluded from the refinement will be included in the mask 
c---caluclations
c
c---  allocate and store occupancies. Promote occupancy of the selected atoms
c---  to one
      allocate(occupancy_save(n_atom_mod_max,nmodel,nanom+1))
      call saveinit_restore_occ_for_excl(save,nmodel,n_atom_mod_max,
     &  nanom,occupancy_save,1.)
      call set_hkon_flags(nmodel)
      CALL SOLVENT_MASK(DEN(1:n1,1:n2,1:n3,1:nmodel))
      if(solvent_remove_islands) then
         vfrac = 8.0*2.8**3/volume
         call remove_islands(den(1:n1,1:n2,1:n3,1:nmodel),vfrac)
      endif

c      CALL WRITE_SOLVENT_MASK(DEN(1:n1,1:n2,1:n3,1))
      CALL PROT_SHRINK(DEN(1:n1,1:n2,1:n3,1))
c---ReStore and deallocate
      call saveinit_restore_occ_for_excl(restore,nmodel,n_atom_mod_max,
     &  nanom,occupancy_save,1.)

      deallocate(occupancy_save)
      call set_hkon_flags(nmodel)
c
      CALL WRITE_SOLVENT_MASK(DEN(1:n1,1:n2,1:n3,1))
      CALL READ_INDICES(NREF,hkl_asym)
      CALL REDALLI(N1,N2,N3,NX,NY,NZ,ndens,ROTR,TRR,NonCubSym,DEN)
      CALL RFFT(NREF,ndens,DEN,FC,PHASE,hkl_asym)
      deallocate(den)
      CALL PROCESS_SOLVENT(NREF,ndens,hkl_asym,FC,PHASE)
      deallocate(hkl_asym)
      CALL ADD_PARTIAL(NREF,ndens,FC,PHASE)
C
C---Adjust scale parameters
C
C---if first time then do it
      IF(NCYCLE_OVERALL.LE.0) THEN
        SCALE_LS_PART_REFINE_FLAG(NPART) = SCALE_LS_SOLVENT_MASK_FLAG
        B_LS_PART_REFINE_FLAG(NPART)     = B_LS_SOLVENT_MASK_FLAG
        SCALE_LS_PART(NPART)             = SCALE_LS_SOL_M
        B_LS_PART(NPART)                 = B_LS_SOL_M
      ENDIF
      deallocate(fc)
      deallocate(phase)
c      deallocate(den)
c      deallocate(hkl_asym)
      RETURN
      END
c
      SUBROUTINE MASK_INIT(DEN)
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
C
      INTEGER IX,IY,IZ
      REAL D22,SX,SY,SZ
      REAL DEN(N1,N2,N3)
C
C
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      COSAST = (COSA-COSB*COSG)/(SING*SING)

C ---mask initialised to D22 
      D22 = SX*SY*SZ*COSZ*SING
      den(1:n1,1:n2,1:n3) = d22
c      DO IZ = 1,N3
c        DO IY = 1,N2
c          DO IX = 1,N1
c            DEN(IX,IY,IZ) = D22
c             den(ix,iy,iz) = 1.0
c          ENDDO
c        ENDDO
c      ENDDO
C
      RETURN
      END
C
      SUBROUTINE SOLVENT_MASK(DEN)
      use ncs_constraints
      use solvent_all
C-----------------------------------------------------------------
C---------           SPACE GROUP GENERAL
C---This subroutine calculates electron density from atoms and fills
C---"asymmetric" unit of crystals. Displacement parameters are as U
C---values
C-------------------------------------------------------------------
      implicit none
      INCLUDE 'atom_com.fh'
      include 'atom_com_str.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
C
      REAL   DEN(N1,N2,N3)
C
C---Local variables
      REAL    XA_LIST(3,500)
      INTEGER INDSYM_LIST(500)
      REAL    xyz_1(3),XYZ(3)
      LOGICAL ERROR
c
      integer in
      integer ilist,natom_list
      integer ia,ix,iy,iz,ix1,iy1,iz1,ix2,iy2,iz2
      integer isxl,isxu,isyl,isyu,iszl,iszu
      integer nx50,ny50,nz50
      real x1,y1,z1,xc,yc,zc
      real d0,d2,d22,d4,d7,csa2,csb2,csg2
      real sx,sy,sz,sxl,sxu,syl,syu,szl,szu
      real xlow,xupper,ylow,yupper,zlow,zupper
      real d1,rd1,d_solv_lim,dlimit
      real dx,dy,dz,dxo,dyo,dzo,dxo2,dyo2,dzo2,dyz,dyzrox
      real dzcsb,dzsa2,dxmin,dxo2pyo2,radx,rady,radz,dzroy
      real dzrox,dzcsa2,zcosa,dsqmin,xdelta,dsq
C-----D1 is going to be occupancy dependent

      D1 = -1.0E32
      DO   IA=1,N_ATOM
         CALL GET_RADIUS_FOR_THIS_ATOM(IA,RD1)
         D1 = AMAX1(D1,RD1)
      ENDDO

C----Find extension limits for asymmetric unit
      D_SOLV_LIM = D1**2
      CALL ASYMLIM_FRAC(D_SOLV_LIM,XLOW,YLOW,ZLOW,XUPPER,YUPPER,ZUPPER)
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      DLIMIT = DDLIM
      CSA2        = 2.0*COSA
      CSB2        = 2.0*COSB
      CSG2        = 2.0*COSG
C ---
      D22 = SX*SY*SZ*COSZ*SING
C
C----Loop over all atoms
      NX50 = 50*NX
      NY50 = 50*NY
      NZ50 = 50*NZ
      DO     IA=1,N_ATOM
      
C---If atom has isotropic U values
        CALL GET_RADIUS_FOR_THIS_ATOM(IA,D0)
        D1 = D0**2
C
C---Add NCS here
        IF(OCCUP_mod(IA,1).LE.0.0.OR.
     &    CS_ELEMENT(ID_SF_mod(IA,1)).EQ.'H   '.OR.
     &    CS_ELEMENT(ID_SF_mod(IA,1)).EQ.'H-1 '.OR.
     &    ATOM_REF_mod_FLAG(IA,1).LE.2)              GOTO 500
        IF(solvent_ignore_dum.and.trim(atm_name(ia)).eq.'DUM') goto 500
C
C---List of all atoms contributing to asymmetric unit
        xyz_1 = xyz_crd_mod(1:3,ia,1)
        do in=1,n_ncs_const
           xyz_1 = matmul(ncs_c_rot(1:3,1:3,in),xyz_1)+ncs_c_tr(1:3,in)
           xyz   = matmul(cs_ort_to_frac,xyz_1)
           
c     CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD_mod(1,IA,1),XYZ,ERROR)
           CALL ATLIST1(XYZ,XA_list,XLOW,YLOW,ZLOW,XUPPER,YUPPER,
     +          ZUPPER,INDSYM_LIST,NATOM_LIST)
C     
C---- Loop over list of atoms which contribute to "asymmetric" unit
           DO    ILIST=1,NATOM_LIST
              X1 = XA_list(1,ILIST)*CS_CELL(1)
              Y1 = XA_list(2,ILIST)*CS_CELL(2)
              Z1 = XA_list(3,ILIST)*CS_CELL(3)
              XC = X1/SX
              YC = Y1/SY
              ZC = Z1/SZ
C
              RADZ = SQRT(D1)/(SZ*COSZ)
              SZL  = ZC - RADZ
              SZU  = ZC + RADZ
              ISZL = INT(SZL+501.0)
              ISZU = INT(SZU+500.0)
              DO      IZ1 = ISZL,ISZU
                 IZ  = IZ1 - 500
                 IZ2 = MOD(IZ+NZ50,NZ) + 1
                 IF(IZ2.GT.N3)GO TO 300
                 DZ  = IZ*SZ - Z1
                 DZO = DZ*RO_UNIT(3,3)
                 DZO2= DZO*DZO
                 D2  = DZ*DZ
                 D7  = D1 - DZO2
                 IF (D7.LT.0.0)GO TO 300
                 RADY   = SQRT(D7)/(SY*SING)
                 ZCOSA  = DZ*COSAST/SY
                 SYL    = YC - RADY - ZCOSA
                 SYU    = YC + RADY - ZCOSA
                 ISYL   = INT(SYL+501.0)
                 ISYU   = INT(SYU+500.0)
                 DZCSA2 = DZ*CSA2
                 DZROX  = DZ*RO_UNIT(1,3)
                 DZROY  = RO_UNIT(2,3)*DZ
                 DZCSB  = DZ*COSB
                 DO     IY1 = ISYL,ISYU
                    IY  = IY1-500
                    IY2 = MOD(IY+NY50,NY)+1
C---  CHECK FOR IY2 WITHIN ASYMMETRIC UNIT
                    IF(IY2.GT.N2)GO TO 290
                    DY     = IY*SY-Y1
                    DYO    = DY*RO_UNIT(2,2) + DZROY
                    DYO2   = DYO*DYO
                    DYZ    = D2+(DZCSA2+DY)*DY
                    DXMIN  =-DY*COSG-DZCSB
                    DSQMIN = DYZ - DXMIN**2
                    D4     = D1 - DSQMIN
                    IF(D4.LT.0.0) GOTO 290
                    RADX     = SQRT(D4)/(SX*SING)
                    XDELTA   = DXMIN/SX
                    SXL      = XC - RADX + XDELTA
                    SXU      = XC + RADX + XDELTA
                    ISXL     = INT(SXL+501.0)
                    ISXU     = INT(SXU+500.0)
                    DYZROX   = DY*RO_UNIT(1,2) + DZROX
                    DXO2PYO2 = DYO2 + DZO2
                    
                    DO      IX1 = ISXL,ISXU
                       IX   = IX1 - 500
                       IX2  = MOD(IX+NX50,NX)+1
C---  CHECK FOR IX2 WITHIN ASYMMETRIC UNIT
                       IF(IX2.GT.N1)GO TO 280
                       DX   = IX*SX-X1
                       DXO  = DX*RO_UNIT(1,1) + DYZROX
                       DXO2 = DXO*DXO
                       DSQ  = DXO2 + DXO2PYO2
                       IF(DSQ.GT.D1)GO TO 280
                       DEN(IX2,IY2,IZ2)=0.0
 280                   CONTINUE
                    ENDDO
 290                CONTINUE
                 ENDDO
 300             CONTINUE
              ENDDO
           ENDDO
        enddo
 500    CONTINUE
      ENDDO
c      STOP
      RETURN
      END
C
      subroutine remove_islands(den,vfrac)
      implicit none
      include 'celsym.fh'
      real vfrac
      real den(n1,n2,n3)
c
c---  This subroutine removes voids inside mask. 
      integer irot(3,3,192),itr(3,192)

      integer i,j,k,ix,iy,iz,is,ixx,iyy,izz
      integer ixin(3),ixs(3)
      integer, allocatable :: den_c(:,:,:)
c
      integer count1,count2,nthreashold
      integer ic,ig,ig1,ngroups,npairs,ign
      integer, allocatable :: nf(:)
      integer, allocatable :: list(:,:)
      integer, allocatable :: index_grp(:)
      integer, allocatable :: grp_new_grp(:)
      integer, allocatable :: group_links(:,:)
c
      logical changes
c
c---  body
c
c---Convert symmetry elements to integers
      do is=1,NumSymmetry
         irot(1:3,1:3,is) = nint(rot(1:3,1:3,is))
         itr(1,is) = nint(tr(1,is)*nx)
         itr(2,is) = nint(tr(2,is)*ny)
         itr(3,is) = nint(tr(3,is)*nz)
      enddo
c
c----Allocate an array for neighbourhood. 
      allocate(den_c(0:n1+1,0:n2+1,0:n3+1))
      count1 = 0
      count2 = 0
c
c---Initialise neighbourhood
      do ix=1,n1
         do iy=1,n2
            do iz=1,n3
               if(den(ix,iy,iz).le.0.0) then
                  den_c(ix,iy,iz) = -100
                  count1 = count1 + 1
               else
                  den_c(ix,iy,iz) = 0
                  count2 = count2 + 1
               endif
            enddo
         enddo
      enddo
      call idensity_extend_plane(n1,n2,n3,nx,ny,nz,den_c,
     &     NumSymmetry,rot,tr)
c
c---- Assign groups. It is attempted to assign the same group membership to 
c---- neigbouring points if they belong to the region outside of the mask
      ig = 0
      do iz=1,n3
         do iy=1,n2
            do ix=1,n1
               if(den_c(ix,iy,iz).eq.0) then
                  do izz=iz-1,iz+1
                     do iyy=iy-1,iy+1
                        do ixx=ix-1,ix+1
                           if(ixx.ne.ix.or.
     &                          iyy.ne.iy.or.
     &                          izz.ne.iz) then
                              ic = den_c(ixx,iyy,izz)
                              if(ic.gt.0) goto 10
                           endif
                        enddo
                     enddo
                  enddo
                  ig = ig + 1
                  ic = ig
 10               continue
                  ixin(1) = ix-1
                  ixin(2) = iy-1
                  ixin(3) = iz-1
                  do is=1,NumSymmetry
                     ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
                     ixs(1) = modulo(ixs(1),nx)+1
                     ixs(2) = modulo(ixs(2),ny)+1
                     ixs(3) = modulo(ixs(3),nz)+1
                     ixx = ixs(1)-nx
                     do i=1,3
                        if(ixx.le.n1+1.and.ixx.ge.0) then
                           iyy = ixs(2)-ny
                           do j=1,3
                              if(iyy.le.n2+1.and.iyy.ge.0) then
                                 izz = ixs(3)-nz
                                 do k=1,3
                                    if(izz.le.n3+1.and.izz.ge.0) then
                                       den_c(ixx,iyy,izz) = ic
                                    endif
                                    izz = izz + nz
                                 enddo
                              endif
                              iyy = iyy + ny
                           enddo
                        endif
                        ixx = ixx + nx
                     enddo
                  enddo
               endif
            enddo
         enddo
      enddo
c
c---  Generate matrix of graphs for links between neighbours
      ngroups = ig
      if(ngroups.le.0) then
         deallocate(den_c)
         return
      endif
      allocate(group_links(ngroups,ngroups))
      group_links(1:ngroups,1:ngroups) = 0
      do iz=1,n3
         do iy=1,n2
            do ix=1,n1
               if(den_c(ix,iy,iz).gt.0) then
                  ig = den_c(ix,iy,iz)
                  do izz=iz-1,iz+1
                     do iyy=iy-1,iy+1
                        do ixx=ix-1,ix+1
                           ig1 = den_c(ixx,iyy,izz)
                           if(ig1.gt.0.and.ig1.ne.ig) then
                              group_links(ig,ig1) = 1
                              group_links(ig1,ig) = 1
                           endif
                        enddo
                     enddo
                  enddo
               endif
            enddo
         enddo
      enddo
c
c---  Now use equivalence relationship to cluster regions
      count1 = 0
      do ig=1,ngroups-1
         do ig1=ig+1,ngroups
            if(group_links(ig,ig1).eq.1) count1 = count1 + 1
         enddo
      enddo
      npairs = count1
      allocate(list(2,npairs))
      count1 = 0
      do ig=1,ngroups-1
         do ig1=ig+1,ngroups
            if(group_links(ig,ig1).eq.1) then
               count1 = count1 + 1
               list(1,count1) = ig
               list(2,count1) = ig1
            endif
         enddo
      enddo
      deallocate(group_links)

      allocate(nf(ngroups))
      call find_ancestor(list(1,1:npairs),list(2,1:npairs),npairs,
     &     ngroups,nf)
      deallocate(list)

      allocate(index_grp(ngroups))
      do i=1,ngroups
         index_grp(i) = i
      enddo
      call iheap_sort_r(ngroups,1,nf,index_grp)

      count1 = 1
      allocate(grp_new_grp(ngroups))
      grp_new_grp(index_grp(1)) = 1
      do i=1,ngroups-1
         if(nf(i).ne.nf(i+1)) then
            count1 = count1 + 1
         endif
         grp_new_grp(index_grp(i+1)) = count1
      enddo
c
c---Reassign group membership. Regions linked with each other now should belong
c---  to the same group
      deallocate(nf)
      allocate(nf(count1))
      nf(1:count1) = 0
      do ix=1,n1
         do iy=1,n2
            do iz=1,n3
               if(den_c(ix,iy,iz).gt.0) then
                  ig = den_c(ix,iy,iz)
                  den_c(ix,iy,iz) = grp_new_grp(ig)
                  nf(grp_new_grp(ig)) = 
     &                 nf(grp_new_grp(ig))+1
c                  den(ix,iy,iz) = real(den_c(ix,iy,iz))
               endif
            enddo
         enddo
      enddo
c
c---Remove small regions.
      nthreashold = nint(vfrac*real(sum(nf(1:count1))))
c      write(*,*)sum(nf(1:count1)),nthreashold,count1
      do ix=1,n1
         do iy=1,n2
            do iz=1,n3
               ig = den_c(ix,iy,iz)
               if(ig.gt.0) then
                  if(nf(ig).le.nthreashold) then
                     den_c(ix,iy,iz) = -100
                     den(ix,iy,iz) = 0.0
                  endif
               endif
            enddo
         enddo
      enddo

      deallocate(den_c)
      deallocate(nf)
      deallocate(grp_new_grp)
      deallocate(index_grp)

c      stop
      return
      end
c
      subroutine smooth_mask(den)
      implicit none
      include 'celsym.fh'

      real den(n1,n2,n3)

      return
      end

c
      SUBROUTINE GET_RADIUS_FOR_THIS_ATOM(IA,D1)
      use solvent_all
      IMPLICIT NONE
      
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INTEGER IA
      REAL  D1
C
      REAL ALPHA,ALPHA1,alpha2
C
      ALPHA  = PROB_VDW
      ALPHA1 = PROB_ION
      alpha2 = prob_dum
C-----
C       IF (ACC(IA).EQ.0.0) THEN
      IF(CS_ELEMENT(ID_SF(IA)).EQ.'H ') THEN
         d1 = 1.2 + alpha
         
      ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'O ') then
         d1 = 1.28 + alpha1
      ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'C ') then
         d1 = 1.8 + alpha
      ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'N ') then
         d1 = 1.32 + alpha1
c      else if(cs_element(id_sf(ia)).eq.'P ') then
cc         d1 = 0.59 + alpha1
c      else if(cs_element(id_sf(ia)).eq.'S ') then
c         d1 = 0.4 + alpha1
      else
         d1 = 1.8 + alpha1
      ENDIF
c
c      IF(ION_RAD(IA).GT.0.0) then
c         D1 = max(1.5,ION_RAD(IA)) + ALPHA1
c      elseif(ATM_NAME(IA)(1:3).EQ.'DUM')then
c         D1 = 1.8 + alpha2
c      else
c         d1 = vdw_rad(ia) + alpha
c      endif
      
      RETURN
      END

      SUBROUTINE GET_RADIUS_FOR_THIS_ATOM1(IA,D1)
      use solvent_all
      IMPLICIT NONE
      
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INTEGER IA
      REAL  D1
C
      REAL ALPHA,ALPHA1,alpha2
C
      ALPHA  = PROB_VDW
      ALPHA1 = PROB_ION
      alpha2 = prob_dum
C-----
C       IF (ACC(IA).EQ.0.0) THEN
        IF(CS_ELEMENT(ID_SF(IA)).EQ.'H ') THEN
           d1 = 0.8+alpha
c           VDW_RAD(IA) = 1.2
c           ION_RAD(IA) = -1.0
c          VDW_RAD(IA) = 0.7
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'O ') then
           d1 = 1.28 + alpha1
c           VDW_RAD(IA) = 1.52
c           ION_RAD(IA) = 1.28
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'C ') then
           d1 = 1.6 + alpha
c           VDW_RAD(IA) = 1.8
c           ION_RAD(IA) = -1.0
c        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'N ') then
c           d1 = 1.32 + alpha1
c           VDW_RAD(IA) = 1.55
c           ION_RAD(IA) = 1.32
c        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'S ') then
c           d1 = 1.80 + alpha
c           VDW_RAD(IA) = 1.80
c           ION_RAD(IA) = 0.4
c        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'P ') then
c           d1 = 1.80 + alpha
c           VDW_RAD(IA) = 1.80
c           ION_RAD(IA) = 0.59
        ELSE
           if(ion_rad(ia).gt.0.0) then
              d1 = ion_rad(ia) + alpha1
           else
              d1 = vdw_rad(ia) + alpha
           endif
c          VDW_RAD(IA) = 1.8
c          ION_RAD(IA) = -1.0
        ENDIF

c       D1 = VDW_RAD(IA) + ALPHA
c       IF(ION_RAD(IA).GT.0.0) 
c     &      D1 = ION_RAD(IA) + ALPHA1
       IF(ATM_NAME(IA)(1:3).EQ.'DUM') D1 = 1.8 + ALPHA2
cd       WRITE(*,*)CS_ELEMENT(ID_SF(IA)),CHEM_TYPE(IA),VDW_RAD(IA),
cd     & ION_RAD(IA)
C      ELSE
C       D1 = ATOM_TYPE_ION(I_ATOM_TYPE)
C      ENDIF
C-----
c       write(*,*)cs_element(id_sf(ia)),d1,alpha
c       stop
      RETURN
      END
C
      
C
      SUBROUTINE WRITE_SOLVENT_MASK(DEN)
C
C---This routine writes mask in a ccp4 map format
      IMPLICIT NONE
C
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'const.fh'
C
      REAL DEN(N1,N2,N3)
C
      INTEGER IUN_MAP,NSEC,NW1,NU1,NU2,NV1,NV2,LSPGRP,LMODE,MU,MV,IZ
      INTEGER IU1,IU2,IV1,IV2,I
      INTEGER IUVW(3),MXYZ(3)
      REAL   CELL_LOCAL(6)
      CHARACTER TITLE*80,file_local*512
C
C--SEt up parameters for map header
      IUVW(1) = 1
      IUVW(2) = 2
      IUVW(3) = 3
      MXYZ(1) = NX
      MXYZ(2) = NY
      MXYZ(3) = NZ
      NW1     = 0
      NU1     = 0
      NU2     = N1-1
      NV1     = 0
      NV2     = N2-1
      DO    I=1,6
        CELL_LOCAL(I) = CS_CELL(I)
      ENDDO
C
C--Make sure that cell angles are in degrees
      IF(CELL_LOCAL(4).LE.5.0.AND.CELL_LOCAL(5).LE.5.0.AND.
     &   CELL_LOCAL(6).LE.5.0) THEN
        CELL_LOCAL(4) = CELL_LOCAL(4)*RTODEG
        CELL_LOCAL(5) = CELL_LOCAL(5)*RTODEG
        CELL_LOCAL(6) = CELL_LOCAL(6)*RTODEG
      ENDIF
      LSPGRP  = ISPNO
      LMODE   = 2
      NSEC    = N3
      IUN_MAP = 0
      TITLE   = 'Mask from refmac'
      call getenv('MSKOUT',file_local)
      if(len_trim(file_local).le.0) return
      CALL MWRHDL(IUN_MAP,'MSKOUT',TITLE,NSEC,IUVW,MXYZ,
     &      NW1,NU1,NU2,NV1,NV2,CELL_LOCAL,LSPGRP,LMODE)
      call msyput(0,lspgrp,iun_map)
C
      MU = N1
      MV = N2
      IU1 = 0
      IU2 = N1-1
      IV1 = 0
      IV2 = N2-1
C
C---Loop over z sections to write map
      DO    IZ = 1,N3
         CALL MWRSEC(IUN_MAP,DEN(1,1,IZ),MU,MV,IU1,IU2,IV1,IV2)
      ENDDO
      CALL MWCLOSE(IUN_MAP)
      stop
      RETURN
      END
C
      SUBROUTINE PROCESS_SOLVENT(NREF,ndens,hkl_asym,FC,PHASE)
C
      IMPLICIT NONE
C
      INCLUDE 'atom_com.fh'
C
      REAL     FC(nref,ndens),PHASE(nref,ndens),RSQ
      REAL     FWAT0,AVWAT,FWAT,INTR1,B_WAT
C-----Find this value in literature
      PARAMETER (AVWAT = 1.0)
C
      INTEGER  NREF,I,II,OX,ndens
      INTEGER  hkl_asym(3,*)
C
      return
      B_WAT = 0.0
      OX = 1
      DO II = 1,CS_NSFATM
       IF (CS_ELEMENT(II).EQ.'O   ') THEN
         OX = II
         GOTO 11
       ENDIF
      ENDDO
C
 11   CONTINUE
      FWAT0 = CS_A(1,OX) + CS_A(2,OX) + CS_A(3,OX) 
     &          + CS_A(4,OX) + CS_A(5,OX)
C
      DO II = 1, NREF
         CALL INDTORS(hkl_asym(1:3,II),RSQ)
         RSQ = RSQ/4.0
c         INTR1 = 0.0
C
c         DO I=1,4
c            INTR1 = INTR1 + CS_A(I,OX)*EXP(-CS_B(I,OX)*RSQ)
c         ENDDO
c         FWAT = CS_A(5,OX) + INTR1
C------8.0 IS FWAT FOR S=0
         FWAT   = 1.0
         FWAT0  = 1.0
         FC(II,1) = (FWAT/FWAT0)*AVWAT*FC(II,1)*EXP(-RSQ*B_WAT)
      ENDDO
C
      RETURN
      END
C
      SUBROUTINE PROT_SHRINK(DEN)
      use solvent_all
C-----------------------------------------------------------------
C---------           SPACE GROUP GENERAL
C---This subroutine calculates electron density from atoms and fills
C---"asymmetric" unit of crystals. Displacement parameters are as U
C---values
C-------------------------------------------------------------------
      implicit none
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
C
      REAL   DEN(N1,N2,N3)
C
C---Local variables
      integer i,j,k,is,ilist,natom_list
      integer ix,iy,iz,ix1,iy1,iz1,ix2,iy2,iz2,ix11,iy11,iz11
      integer ix10,iy10,iz10,n1_l,n2_l,n3_l,nmask_init,nmask_add
      integer nx50,ny50,nz50
      integer isxl,isxu,isyl,isyu,iszl,iszu
      real sxl,sxu,syl,syu,szl,szu,sxs
      REAL D22,D221,D222,D22EPS
      REAL    XA_LIST(3,500)
      INTEGER INDSYM_LIST(500)
      INTEGER IROT_L(3,3,192),ITR_L(3,192)
      INTEGER NX_L(3)
      REAL    XYZ(3)
      REAL DENS_NEIB(3,3,3)
      real xlow,xupper,ylow,yupper,zlow,zupper
      real xc,yc,zc,xc1,yc1,zc1,sx,sy,sz,zcosa,xdelta
      real x1,y1,z1
      real dsqmin,dzrox,dzcsb,dzcsa2,dyzrox,dzroy
      real dx,dy,dz,dxo,dyo,dzo,dxo2,dyo2,dzo2,dxo2pyo2
      real radx,rady,radz,dsq,dxmin,dyz
      real d1,d2,d4,d7,d_solv_lim
      real csa2,csb2,csg2
C
C-----This is the shrink radius
C
      NX_L(1) = NX
      NX_L(2) = NY
      NX_L(3) = NZ
      DO   IS=1,NumSymmetry
         DO  I=1,3
           DO  K=1,3
             IROT_L(K,I,IS) = NINT(ROT(K,I,IS))
           ENDDO
           ITR_L(I,IS) = NINT(TR(I,IS)*NX_L(I))
         ENDDO
cd         DO  I=1,3
cd           WRITE(*,*)(IROT_L(K,I,IS),K=1,3),ITR_L(I,IS)
cd         ENDDO
      ENDDO
C
      D1 = RADII_SHRINK

C----Find extension limits for asymmetric unit
      D_SOLV_LIM = D1**2
      CALL ASYMLIM_FRAC(D_SOLV_LIM,XLOW,YLOW,ZLOW,XUPPER,YUPPER,ZUPPER)
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      CSA2        = 2.0*COSA
      CSB2        = 2.0*COSB
      CSG2        = 2.0*COSG
C ---
      D22 = SX*SY*SZ*COSZ*SING
      D221 = D22*0.1
      D222 = D22*0.2
      D22EPS = D22*1.0E-3
      SXS = SX*SING
C
C----Loop over all atoms
      NX50 = 50*NX
      NY50 = 50*NY
      NZ50 = 50*NZ
      D1 = D1**2
      NMASK_INIT = 0
      NMASK_ADD  = 0
      N1_L = N1-1
      N2_L = N2-1
      N3_L = N3-1
      DO   IZ10=1,N3
        DO   IY10=1,N2
          DO   IX10=1,N1
            IF(DEN(IX10,IY10,IZ10).LT.D222) GOTO 500
cd            NMASK_INIT = NMASK_INIT + 1
            IX11 = IX10 - 1 
            IY11 = IY10 - 1
            IZ11 = IZ10 - 1
            CALL GET_NEIBOURS_MASK(IX11,IY11,IZ11,NX,NY,NZ,
     &           N1,N2,N3,
     &           NumSymmetry,IROT_L,ITR_L,DEN,DENS_NEIB)
            DO  I=1,3
              DO  J=1,3
                DO   K=1,3
                  IF(DENS_NEIB(K,J,I).LT.D222) GOTO 100
                ENDDO
              ENDDO
            ENDDO
            GOTO 500
 100        CONTINUE
            XYZ(1) = FLOAT(IX11)/FLOAT(NX)
            XYZ(2) = FLOAT(IY11)/FLOAT(NY)
            XYZ(3) = FLOAT(IZ11)/FLOAT(NZ)
C
C---List of all atoms contributing to asymmetric unit
            CALL ATLIST1(XYZ,XA_list,XLOW,YLOW,ZLOW,XUPPER,YUPPER,
     +                ZUPPER,INDSYM_LIST,NATOM_LIST)
C
C----Loop over list of atoms which contribute to "asymmetric" unit
            DO    ILIST=1,NATOM_LIST
              X1 = XA_list(1,ILIST)*CS_CELL(1)
              Y1 = XA_list(2,ILIST)*CS_CELL(2)
              Z1 = XA_list(3,ILIST)*CS_CELL(3)
              XC = X1/SX
              YC = Y1/SY
              ZC = Z1/SZ
C
              RADZ = SQRT(D1)/(SZ*COSZ)
              SZL  = ZC - RADZ
              SZU  = ZC + RADZ
              ISZL = INT(SZL+501.0)
              ISZU = INT(SZU+500.0)
              DO      IZ1 = ISZL,ISZU
                IZ  = IZ1 - 500
                IZ2 = MOD(IZ+NZ50,NZ) + 1
                IF(IZ2.GT.N3)GO TO 300
                DZ  = IZ*SZ - Z1
                DZO = DZ*RO_UNIT(3,3)
                DZO2= DZO*DZO
                D2  = DZ*DZ
                D7  = D1 - DZO2
                IF (D7.LT.0.0)GO TO 300
                RADY   = SQRT(D7)/(SY*SING)
                ZCOSA  = DZ*COSAST/SY
                SYL    = YC - RADY - ZCOSA
                SYU    = YC + RADY - ZCOSA
                ISYL   = INT(SYL+501.0)
                ISYU   = INT(SYU+500.0)
                DZCSA2 = DZ*CSA2
                DZROX  = DZ*RO_UNIT(1,3)
                DZROY  = RO_UNIT(2,3)*DZ
                DZCSB  = DZ*COSB
                DO     IY1 = ISYL,ISYU
                  IY  = IY1-500
                  IY2 = MOD(IY+NY50,NY)+1
C---CHECK FOR IY2 WITHIN ASYMMETRIC UNIT
                  IF(IY2.GT.N2)GO TO 290
                  DY     = IY*SY-Y1


                  DYZ    = D2+(DZCSA2+DY)*DY
                  DXMIN  =-DY*COSG-DZCSB
                  DSQMIN = DYZ - DXMIN**2
                  D4     = D1 - DSQMIN
                  IF(D4.LT.0.0) GOTO 290

                  DYO    = DY*RO_UNIT(2,2) + DZROY
                  DYO2   = DYO*DYO
                  DXO2PYO2 = DYO2 + DZO2
                  if(dxo2pyo2.gt.d1) cycle

                  RADX     = SQRT(D4)/SXS
                  XDELTA   = DXMIN/SX
                  XC1      = XC + XDELTA
                  SXL      = XC1 - RADX
                  SXU      = XC1 + RADX
                  ISXL     = INT(SXL+501.0)
                  ISXU     = INT(SXU+500.0)
                  DYZROX   = DY*RO_UNIT(1,2) + DZROX

                  DO      IX1 = ISXL,ISXU
                    IX   = IX1 - 500
                    IX2  = MOD(IX+NX50,NX)+1
C---CHECK FOR IX2 WITHIN ASYMMETRIC UNIT
                    IF(IX2.GT.N1)GO TO 280
                    DX   = IX*SX-X1
                    DXO  = DX*RO_UNIT(1,1) + DYZROX
                    DXO2 = DXO*DXO
                    DSQ  = DXO2 + DXO2PYO2
                    IF(DSQ.GT.D1)GO TO 280

                    IF(DEN(IX2,IY2,IZ2).LE.D22EPS) THEN
                      DEN(IX2,IY2,IZ2) = D221
cd                      NMASK_ADD = NMASK_ADD + 1
cd                      GOTO 500
                    ENDIF
C
 280                CONTINUE
                  ENDDO
 290              CONTINUE
                ENDDO
 300            CONTINUE
              ENDDO
 600          CONTINUE
            ENDDO
 500        CONTINUE
          ENDDO
        ENDDO
      ENDDO
cd      WRITE(*,*)NMASK_INIT,NMASK_ADD
cd      STOP
      DO    IZ=1,N3
        DO    IY=1,N2
          DO    IX=1,N1
            IF(DEN(IX,IY,IZ).NE.0.0) DEN(IX,IY,IZ) = D22
          ENDDO
        ENDDO
      ENDDO
      RETURN
      END
C
      SUBROUTINE GET_NEIBOURS_MASK(IX,IY,IZ,NX,NY,NZ,N1,N2,N3,
     &           NumSymmetry,IROT_L,ITR_L,DENS,DENS_NEIB)
C
      IMPLICIT NONE
      INTEGER IX,IY,IZ,NX,NY,NZ,N1,N2,N3
      INTEGER NumSymmetry
      INTEGER IROT_L(3,3,*),ITR_L(3,*)
      REAL DENS(N1,N2,N3)
      REAL DENS_NEIB(3,3,3)
C
      INTEGER IX1,IY1,IZ1,IXO,IYO,IZO,IXO1,IYO1,IZO1
      INTEGER IX2,IY2,IZ2
      INTEGER I,J,K
      LOGICAL FLAG_CALL
C
C---Centre value is definitely is inside "asymmetric unit"
C
      IX2 = IX-2
      IY2 = IY-2
      IZ2 = IZ-2
      DO K=1,3
         IZ1 = IZ2+K
         IF(IZ1.LT.0) THEN
           IZ1 = IZ1 + NZ
         ELSE IF(IZ1.GE.NZ) THEN
           IZ1 = IZ1 - NZ
         ENDIF
         FLAG_CALL = IZ1.GE.N3
         IZO1 = IZ1 + 1
         DO  J=1,3
           IY1 = IY2+J
           IF(IY1.LT.0) THEN
             IY1 = IY1 + NY
           ELSEIF(IY1.GE.NY) THEN
             IY1 = IY1 - NY
           ENDIF
           FLAG_CALL = FLAG_CALL.OR.IY1.GE.N2
           IYO1 = IY1 + 1
           DO I = 1,3
             IX1 = IX2+I
             IF(IX1.LT.0) THEN
                IX1 = IX1 + NX
             ELSE IF(IX1.GE.NX) THEN
               IX1 = IX1 - NX
             ENDIF
             FLAG_CALL = FLAG_CALL.OR.IX1.GE.N1
             IXO1 = IX1 + 1
             IF(FLAG_CALL) THEN
              CALL FIND_POSITION_IN_ASYM(IX1,IY1,IZ1,NX,NY,NZ,N1,N2,N3,
     &             NumSymmetry,IROT_L,ITR_L,IXO,IYO,IZO)
                         IXO1 = IXO + 1
                         IYO1 = IYO + 1
                         IZO1 = IZO + 1
             ENDIF
             DENS_NEIB(K,J,I) = DENS(IXO1,IYO1,IZO1)
           ENDDO
         ENDDO
      ENDDO
C
      RETURN
      END
C
      SUBROUTINE FIND_POSITION_IN_ASYM(IX1,IY1,IZ1,NX,NY,NZ,N1,N2,N3,
     &             NumSymmetry,IROT_L,ITR_L,IXO,IYO,IZO)
      IMPLICIT NONE
C
C---  Finds position of the given point in the "asymmetric" unit.
      INTEGER IXO,IYO,IZO
      INTEGER IX1,IY1,IZ1,NX,NY,NZ,N1,N2,N3
      INTEGER NumSymmetry
      INTEGER IROT_L(3,3,*),ITR_L(3,*)
C
C
      INTEGER IS
      INTEGER IX11,IY11,IZ11,IX1N,IY1N,IZ1N
C
C---If point is in the "asymmetric" unit do nothing.

cd      IF(IX1.LT.0) GOTO 10
cd      IF(IX1.GE.N1) GOTO 10
cd      IF(IY1.LT.0) GOTO 10
cd      IF(IY1.GE.N2) GOTO 10
cd      IF(IZ1.LT.0) GOTO 10
cd      IF(IZ1.GE.N3) GOTO 10
cd     &   IY1.GE.0.AND.IY1.LE.N2.AND.
cd     &   IZ1.GE.0.AND.IZ1.LE.N3) THEN
cd        IXO = IX1
cd        IYO = IY1
cd        IZO = IZ1
cd        RETURN
cd 10     CONTINUE
C
cd      IX11 = MOD(IX1 + NX,NX)
cd      IY11 = MOD(IY1 + NY,NY)
cd      IZ11 = MOD(IZ1 + NZ,NZ)

cd      IF(IX11.GE.0.AND.IX11.LT.N1.AND.
cd     &   IY11.GE.0.AND.IY11.LT.N2.AND.
cd     &   IZ11.GE.0.AND.IZ11.LT.N3) THEN
cd        IXO = IX11
cd        IYO = IY11
cd        IZO = IZ11
cd        RETURN
cd      ENDIF
C
C--It assumes that first operator is identity.
      DO   IS = 2,NumSymmetry
        IX1N = IROT_L(1,1,IS)*IX1 + 
     &         IROT_L(1,2,IS)*IY1 + 
     &         IROT_L(1,3,IS)*IZ1 + ITR_L(1,IS)
cd        if(IX1N.LT.0) THEN
cd          IX1N = IX1N + NX
cd        ELSE IF(IX1N.GT.NX) THEN
cd          IX1N = IX1N - NX
cd        ENDIF
        IX1N = MOD(IX1N + NX,NX)
        IF(IX1N.GE.N1) GOTO 100
        IY1N = IROT_L(2,1,IS)*IX1 + 
     &         IROT_L(2,2,IS)*IY1 + 
     &         IROT_L(2,3,IS)*IZ1 + ITR_L(2,IS)
        IY1N = MOD(IY1N + NY,NY)
        IF(IY1N.GE.N2) GOTO 100
        IZ1N = IROT_L(3,1,IS)*IX1 + 
     &         IROT_L(3,2,IS)*IY1 + 
     &         IROT_L(3,3,IS)*IZ1 + ITR_L(3,IS)        
        IZ1N = MOD(IZ1N + NZ,NZ)
        IF(IZ1N.GE.N3) GOTO 100
        IXO = IX1N
        IYO = IY1N
        IZO = IZ1N
        RETURN
 100    CONTINUE
      ENDDO
C
C--If we have not returned yet then there is an error. Report it
      WRITE(*,*)N1,N2,N3,NX,NY,NZ
      WRITE(*,*)NumSymmetry,IX1,IY1,IZ1
      CALL errwrt(1,'in FIND_POSITION_IN_ASYM.')
      END
