C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
      SUBROUTINE NEWENTRY_IDEALISE
      use weights
      use agreem
      use rharvest
      use CellAndSymmetry
      use refi_flags
C
C---Subroutine for refinement with diagonal approximation
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif.fh'
      include 'restr_params.fh'
C
C----These arrays should be controlled dynamicly as they depend 
C----on coordinates
c      INTEGER NE,NZZ,NWTB
c      COMMON /DISTNS/ NE( QQD),NZZ( QQD),NWTB( QQD)
C
C---Local variables
      integer ntrial
      INTEGER IA,im,nmodel
      REAL WV_SAVE,WA_SAVE
      real zbond_l,zangle_l,shift
      real xyz_shift(3)
C
C---report about type of refinement and so on
C----------------------------------------------------
C-------------------------------------------------
c 
      REFID = 'IDEA'
      MAKE_CHECK = '0'
      nmodel = 1
      CALL SET_HKON_FLAGS(nmodel)
C
c---Save vital parameters
      CALL SAVE_VITAL
      GEOM_FLAG  = .TRUE.
      X_RAY_FLAG = .FALSE.

      IF(.NOT.X_RAY_FLAG) THEN
C
C---If we are not going to refine 
        ITEMP = 0
        NOCC  = 0
      ENDIF
      IF(.NOT.GEOM_FLAG) THEN
        NDIS = 0
        NBIS = 0
        NVDW = 0
      ENDIF
C
c---Add these variables to vitals.fh
      NVPOS = 0
      NMPOS = 0
      NVOCC = 0
      NMOCC = 0
      NVTMP = 0
      NMTMP = 0
C
C---Find number of variables and second derivative matrix elements
C---for different type of parameters
      do im=1,nmodel
        DO    IA=1,N_ATOM_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            NVPOS = NVPOS + 3
            NMPOS = NMPOS + 6
            IF(IOCCUP.GT.0) THEN
              NVOCC = NVOCC + 1
              NMOCC = NMOCC + 1
            ENDIF
            IF(ITEMP.NE.0) THEN
              IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                NVTMP = NVTMP + 1
                NMTMP = NMTMP + 1
              ELSE
                NVTMP = NVTMP + 6
                NMTMP = NMTMP + 21
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      enddo
      NVALL = NVPOS + NVOCC + NVTMP   
c
C---Begin refinement cycles
C
C---Memory allocation should be done here
      IF(NCCREF.LE.5) NCCREF = 20
      zbond_l = 3.0
      zangle_l = 5.0
      shift = 0.0
      ntrial = 0
      do while((zbond_l.gt.2.0.or.zangle_l.gt.3.5).and.ntrial.le.100)
         ntrial = ntrial + 1
c
c--If the results are not good enough then add random shifts and try again

c
c---  Do more analysis: If problems are with chiralities then swap coordinates
c--   in the problem is with planarity then add shifts from centre and 
c--   perpendicular to the plane
         do ia=1,n_atom
            call random_number(harvest=xyz_shift)
            xyz_shift(1:3) = shift*(2.0*xyz_shift(1:3)-1.0)
            xyz_crd(1:3,ia) = xyz_crd(1:3,ia) + xyz_shift(1:3)
         enddo
         WV_SAVE = WVSKAL
         WVSKAL  = 40.0
         CALL CGSPARCE(nmodel)
         WVSKAL = WV_SAVE
         WA_SAVE = WASKAL
         WASKAL = 10.0
         CALL CGSPARCE(nmodel)
         WASKAL = WA_SAVE
c         wvskal = 20.0
c         wdskal = 10.0
c         dinc_torsion_c = 0.2
c         dinc_torsion_o = 0.2
c         dinc_torsion_c = 0.2
c         waskal = 0.1
         CALL CGSPARCE(nmodel)

         zbond_l = hrestr_z(1)
         if(hrestr_type(2)(1:11).eq.'Bond angles') then
            zangle_l= hrestr_z(2)
         else if(hrestr_type(3)(1:11).eq.'Bond angles') then
            zangle_l = hrestr_z(3)
         else
            zangle_l = 0.0
         endif
         shift = shift + 0.5
      enddo
         
C
      RETURN
      END
c
      subroutine set_newentry_params()
      implicit none

      include 'restr_params.fh'
c
      integer i_t
c
c---  body
c      return
      n_restrain_tors = n_restrain_tors + 1
      i_t = n_restrain_tors
      res_name_tors_restr(i_t) = '*'
      group_name_tors_restr(i_t) = '.'
      link_name_tors_restr(i_t) = '.'
      res_name_tors_name(i_t) = '*'
      res_name_tors_value(i_t) = -1.0e32
      res_name_tors_sigma(i_t) = 15.0

      return
      end
