module odbfiles
use elements
use interface2libcom



contains
  subroutine read_and_sort_odb_file(mdoc,iun,list,natommax,natom,latom_name,latom_symb,       &
       nbondmax,nbond,lbond1,lbond2,lbond_val,lbond_order,nanglemax,nangle,langle,langle_val, &
       ntorsmax,ntors,ltors_atom,ltors_val,mon,ierr)
    implicit none
    !
    !---  inputs
    integer mdoc,iun
    character mon*8,list*1
    integer   natommax,natom
    integer   ntorsmax
    integer nbondmax,nbond
    integer nanglemax,nangle,ntors
    !
    !---outputs
    integer   ierr
    character latom_name(natommax)*4
    character latom_symb(natommax)*2
    integer   ltors_atom(4,ntorsmax)
    real      ltors(ntorsmax)
    !
    integer   lbond1(nbondmax),lbond2(nbondmax),langle(3,nbondmax)
    real      lbond_val(2,nbondmax),langle_val(2,nbondmax),ltors_val(2,nbondmax)
    character lbond_order(nbondmax)*8
    !
    integer ia,ib
    !
    !  body
    call read_odb_file(iun,nbondmax,natom,latom_name,nbond,lbond1,lbond2,lbond_val,nangle,langle,langle_val, &
         ntors,ltors_atom,ltors_val,mon,ierr)
    call extract_elementname(natom,latom_name,nbond,lbond1,lbond2,lbond_val,latom_symb,ierr)
    call extract_bond_order(natom,latom_name,latom_symb,nbond,lbond1,lbond2,lbond_val,nangle,langle,         &
         langle_val,lbond_order)

  end subroutine read_and_sort_odb_file





  subroutine extract_elementname(natom,latom_name,nbond,lbond1,lbond2,lbond_val,latom_symb,ierr)
    implicit none
    !
    integer natom,nbond
    character(len=4), intent(in) :: latom_name(:)
    integer, intent(in) :: lbond1(:),lbond2(:)
    real, intent(in) :: lbond_val(:,:)
    !
    integer ierr
    character(len=2), intent(out) :: latom_symb(:)
    
    !   Bonds etc
    integer ib
    integer maxbond
    integer, allocatable :: nbonds_atom(:)
    integer, allocatable :: ref_to_atom(:,:)
    integer, allocatable :: ref_to_bond(:,:)
    integer, allocatable :: ref_to_element(:,:)
    integer, allocatable :: latom_defined(:)
    real, allocatable :: latom_bond_ave(:)
    !
    !
    integer ia,ia1,ie,ie1,ie2,in,nb1,noptions
    integer nchange_flag
    real bdiff1,bdiff2
    character*2 asymb
    !
    !   Body    

    if(natom.le.0) return

    do ia=1,natom
       latom_symb(ia) = latom_name(ia)(1:1)
    enddo
    allocate(nbonds_atom(natom)); nbonds_atom(1:natom) = 0
    allocate(latom_bond_ave(natom)); latom_bond_ave(1:natom) = 0.0
    allocate(latom_defined(natom)); latom_defined(1:natom) = 0
    allocate(ref_to_element(2,natom)); ref_to_element(1:2,1:natom) = 0
    do ib=1,nbond
       nbonds_atom(lbond1(ib)) = nbonds_atom(lbond1(ib)) + 1
       nbonds_atom(lbond2(ib)) = nbonds_atom(lbond2(ib)) + 1
       latom_bond_ave(lbond1(ib)) = latom_bond_ave(lbond1(ib))+lbond_val(1,ib)
       latom_bond_ave(lbond2(ib)) = latom_bond_ave(lbond2(ib))+lbond_val(1,ib)

    enddo
    maxbond = maxval(nbonds_atom(1:natom))
    allocate(ref_to_atom(maxbond,natom))
    allocate(ref_to_bond(maxbond,natom))
    nbonds_atom(1:natom) = 0
    do ib=1,nbond
       nbonds_atom(lbond1(ib)) = nbonds_atom(lbond1(ib)) + 1
       nb1 =  nbonds_atom(lbond1(ib))
       ref_to_atom(nb1,lbond1(ib)) = lbond2(ib)
       ref_to_bond(nb1,lbond1(ib)) = ib

       nbonds_atom(lbond2(ib)) = nbonds_atom(lbond2(ib)) + 1
       nb1 =  nbonds_atom(lbond2(ib))
       ref_to_atom(nb1,lbond2(ib)) = lbond1(ib)
       ref_to_bond(nb1,lbond2(ib)) = ib
    enddo

    do ia=1,natom
       if(nbonds_atom(ia).le.0) then
          write(*,*)'Error==> Atom ',latom_name(ia),' is isolated'
          ierr = 1
          stop
       else
          latom_bond_ave(ia) = latom_bond_ave(ia)/nbonds_atom(ia)
       endif
    enddo

    do ia=1,natom
       asymb = latom_name(ia)(1:1)
       noptions = 0
       do ie = 1,n_elements
          if(latom_bond_ave(ia).gt.diam_elements(ie)/2.0) then
             if(asymb.eq.name_elements(ie)) then
                noptions = noptions + 1
                ref_to_element(noptions,ia) = ie
                latom_symb(ia) = name_elements(ie)
             elseif(latom_name(ia)(1:2).eq.name_elements(ie)) then
                noptions = noptions + 1
                ref_to_element(noptions,ia) = ie
                latom_symb(ia) = name_elements(ie)
             endif
          endif
       enddo
       if(noptions.eq.1) latom_defined(ia) = 1
    enddo
               
    nchange_flag = 0
    if(sum(latom_defined(1:natom)).lt.natom)nchange_flag = 1
    do while(nchange_flag.gt.0)
       bdiff1 = 0.0
       bdiff2 = 0.0
       nchange_flag = 0
       do ia=1,natom
          if(latom_defined(ia).eq.0) then
             ie1 = ref_to_element(1,ia)
             ie2 = ref_to_element(2,ia)
             do in=1,nbonds_atom(ia)
                ib = ref_to_bond(in,ia)
                ia1 = ref_to_atom(in,ia)
                if(latom_defined(ia1).eq.1) then
                   bdiff1 = bdiff1 + abs(lbond_val(1,ib)-(diam_elements(ref_to_element(1,ia1))+diam_elements(ie1))/2.0)
                   bdiff2 = bdiff2 + abs(lbond_val(1,ib)-(diam_elements(ref_to_element(1,ia1))+diam_elements(ie2))/2.0)
                endif
             enddo
             if(bdiff1.le.bdiff2) then
                ref_to_element(1,ia) = ie1
                latom_symb(ia) = name_elements(ie1)
             else
                ref_to_element(1,ia) = ie2
                latom_symb(ia) = name_elements(ie2)
             endif
             nchange_flag = nchange_flag + 1
          endif
       enddo
    enddo

    if(sum(latom_defined(1:natom)).ne.natom) then
       write(*,*)'Error==> Element name could not be assigned to all atoms '
       do ia=1,natom
          if(latom_defined(ia).eq.0) then
             write(*,*)'Error==> Anissigned atom ',latom_name(ia)
          endif
       enddo
       write(*,*)
       stop
    endif

    deallocate(ref_to_element)
    deallocate(nbonds_atom)
    deallocate(ref_to_atom)
    deallocate(ref_to_bond)
    deallocate(latom_bond_ave)
    deallocate(latom_defined)

       
  end subroutine extract_elementname

  subroutine extract_bond_order(natom,latom_name,latom_symb,nbond,lbond1,lbond2,lbond_val,nangle,langle,    &
       langle_val,lbond_order)
    implicit none
    !
    integer natom,nbond,nangle
    character(len=4), intent(in) :: latom_name(:)
    character(len=2), intent(in) :: latom_symb(:)
    integer, intent(in) :: lbond1(:),lbond2(:)
    real, intent(in) :: lbond_val(:,:)
    integer, intent(in) :: langle(:,:)
    real, intent(in) :: langle_val(:,:)
    !
    character(len=8), intent(out) :: lbond_order(:)
    !
    !  Some local allocatables
    integer maxbond
    integer, allocatable :: nbonds_atom(:)
    integer, allocatable :: ref_to_atom(:,:)
    integer, allocatable :: ref_to_bond(:,:)
    !
    integer ia,ia1,ia2,ib,ib1,ib2,ilb,ilb2,in,nb1
    integer niter
    integer nchange_flag,nbond_orders
    character(len=8) :: bond_order,bond_order1
    real diff_dist,diff_prev,dist_bond,bond_length
    !
    !  body
    lbond_order(1:nbond) = '.'

    allocate(nbonds_atom(natom)); nbonds_atom(1:natom) = 0
    do ib=1,nbond
       nbonds_atom(lbond1(ib)) = nbonds_atom(lbond1(ib)) + 1
       nbonds_atom(lbond2(ib)) = nbonds_atom(lbond2(ib)) + 1
    enddo
    maxbond = maxval(nbonds_atom(1:natom))
    allocate(ref_to_atom(maxbond,natom))
    allocate(ref_to_bond(maxbond,natom))
    nbonds_atom(1:natom) = 0
    do ib=1,nbond
       nbonds_atom(lbond1(ib)) = nbonds_atom(lbond1(ib)) + 1
       nb1 =  nbonds_atom(lbond1(ib))
       ref_to_atom(nb1,lbond1(ib)) = lbond2(ib)
       ref_to_bond(nb1,lbond1(ib)) = ib

       nbonds_atom(lbond2(ib)) = nbonds_atom(lbond2(ib)) + 1
       nb1 =  nbonds_atom(lbond2(ib))
       ref_to_atom(nb1,lbond2(ib)) = lbond1(ib)
       ref_to_bond(nb1,lbond2(ib)) = ib
    enddo
    !
    do ib=1,nbond
       ia1 = lbond1(ib)
       ia2 = lbond2(ib)
       if(  latom_symb(ia1).eq.'H '.or.latom_symb(ia2).eq.'H '.or.               &
            latom_symb(ia1).eq.'F '.or.latom_symb(ia2).eq.'F '.or.               &
            latom_symb(ia1).eq.'CL'.or.latom_symb(ia2).eq.'CL'.or.               &
            latom_symb(ia1).eq.'BR'.or.latom_symb(ia2).eq.'BR'.or.               &
            latom_symb(ia1).eq.'I '.or.latom_symb(ia2).eq.'I ')        then
          lbond_order(ib) = 'single'
       endif
    enddo

    do ia=1,natom
       if(latom_symb(ia).eq.'O '.or.latom_symb(ia).eq.'S '.or.latom_symb(ia).eq.'SE') then
          if(nbonds_atom(ia).eq.2) then
             do in=1,nbonds_atom(ia)
                ib1 = ref_to_bond(ib,ia)
                lbond_order(ib1) = 'single'
             enddo
          endif
       elseif(latom_symb(ia).eq.'C ') then
          if(nbonds_atom(ia).eq.4) then
             do in=1,nbonds_atom(ia)
                ib1 = ref_to_bond(ib,ia)
                lbond_order(ib1) = 'single'
             enddo
          endif
       elseif(latom_symb(ia).eq.'N ') then
          if(nbonds_atom(ia).eq.3.or.nbonds_atom(ia).eq.4) then
             do in=1,nbonds_atom(ia)
                ib1 = ref_to_bond(ib,ia)
                lbond_order(ib1) = 'single'
             enddo
          endif
       endif
    enddo
    
    nchange_flag = 1

    niter = 0
    do while(nchange_flag.gt.0.and.niter.le.100)
       niter = niter + 1
       nchange_flag = 0
       do ib=1,nbond
          ia1 = lbond1(ib)
          ia2 = lbond2(ib)
          if(lbond_order(ib).ne.'.') continue
          bond_order = '.'
          diff_prev = 1.0e32
          do ilb=1,leb_nbond
             ib1 = leb_i1atm(ilb)
             ib2 = leb_i2atm(ilb)
             if(  latom_symb(ia1).eq.lea_ename(ib1)(1:2).and.latom_symb(ia2).eq.lea_ename(ib2).or.     &
                  latom_symb(ia1).eq.lea_ename(ib2)(1:2).and.latom_symb(ia2).eq.lea_ename(ib1))    then
                !
                !   Avoid sp1 atoms for now
                if(leb_1atm(ilb).ne.'CSP'.and.leb_2atm(ilb).ne.'CSP'.and.     &
                     leb_1atm(ilb).ne.'NS'.and.leb_2atm(ilb).ne.'NS'.or.leb_type(ilb)(1:4).eq.'trip') then
                   diff_dist = abs(lbond_val(1,ib)-leb_length(ilb))
                   if(diff_dist.lt.diff_prev) then
                      diff_prev = diff_dist
                      bond_order = leb_type(ilb)
                      bond_length = leb_length(ilb)
                   endif
                endif
             endif
          enddo
          if(bond_order.eq.'.') then
             do ilb=1,leb_nbond
                ib1 = leb_i1atm(ilb)
                if(leb_2atm(ilb).eq.'.') then
                   ib1 = leb_i1atm(ilb)
                   bond_order1 = '.'
                   if(latom_symb(ia1).eq.lea_ename(ib1)) then
                      bond_order1 = leb_type(ib1)
                      do ilb2 = 1,leb_nbond
                         if(leb_2atm(ilb2).eq.'.') then
                            if(bond_order1.eq.leb_type(ilb2)) then
                               ib2 = leb_i1atm(ilb2)
                               if(latom_symb(ia2).eq.lea_ename(ib2)) then
                                  dist_bond = (leb_length(ib1) + leb_length(ib2))/2.0
                                  diff_dist = abs(dist_bond-lbond_val(1,ib))
                                  if(diff_dist.lt.diff_prev) then
                                     bond_order = bond_order1
                                  endif
                               endif
                            endif
                         endif
                      enddo
                   endif
                endif
             enddo
          endif
          if(bond_order.ne.'.') then
             lbond_order(ib) = bond_order
             nchange_flag = nchange_flag + 1
          endif
       enddo
    enddo
    nbond_orders = 0
    do ib=1,nbond
       if(lbond_order(ib).ne.'.') then
          nbond_orders = nbond_orders+1
       else
          write(*,*)'Error==> Bond order between atoms ',latom_name(lbond1(ib)),' and ',     &
               latom_name(lbond2(ib)),'could not be identified'
       endif
    enddo
    if(nbond_orders.lt.nbond) then
       !
       !  Problem. We could not define bond orders from bond distances
       write(*,*)'Error==> Problem with bond order identification '
       stop
    endif

    deallocate(nbonds_atom)
    deallocate(ref_to_bond)
    deallocate(ref_to_atom)
  end subroutine extract_bond_order
  
  subroutine write_odb_file(odb_file,ierr)
    implicit none

    character(len=*), intent(in) :: odb_file
    integer ierr
    !
    character(len=100) :: line
    integer iout,ifail
    integer i,j,l,ia,ja,ja_end
    real esd
    logical hydr_flag
    !
    !   body
    ierr = 0
    if(lml_nmon.le.0) return
    call open_form_file(iout,odb_file,ierr)
    if(ierr.ne.0) return
    write(iout,'(a)')'!'
    write(iout,'(a)')'! odb file generated by libcheck'
    write(iout,'(a)')'! Authors: Alexei A Vagin and Garin N Murshudov'
    write(iout,'(a)')'! Citation '
    write(iout,'(a)')'! Vagin AA, Steiner RA, Lebedeb AA, Potterton L, McNicholas S, Long F and Murshudov GN'
    write(iout,'(a)')'! Refmac5 dictionary: ogranization of prior chemical knowledge and guidelines to its use'
    write(iout,'(a)')'! Acta Cryst D60:2004, pp 2184-2195'
    write(iout,'(a)')'!'

    do i=1,lml_nmon
       if(lml_fuse(i).ne.'C') cycle

       write(iout,'(a,a)')'residue ',lml_mname(i)
       line = 'atom'
       j = lml_iatom(i)
       ja = j
       ja_end = j-1
       do l=j,lma_natom
          if(lma_mname(l).ne.lml_mname(i)) exit
          ja_end = ja_end+1
          if(trim(lma_symb(l)).ne.'H') then
             if(len_trim(line).gt.70) then
                write(iout,'(a)')trim(line)//' \ '
                line = '     '//lma_aname(l)
             else
                line = trim(line)//' '//lma_aname(l)
             endif
          endif
       enddo
       write(iout,'(a)')trim(line)

       !
       line = 'connect_all'
       j = lml_iatom(i)
       do l=j,lma_natom
          if(lma_mname(l).ne.lml_mname(i)) exit
          if(trim(lma_symb(l)).ne.'H') then
             if(len_trim(line).gt.72) then
                write(iout,'(a)')trim(line)//' \ '
                line = '     '//lma_aname(l)
             else
                line = trim(line)//' '//lma_aname(l)
             endif
          endif
       enddo
       write(iout,'(a)')trim(line)
       j = lml_ibond(i)
       do l=j,lmb_nbond
          if(lmb_mname(l).ne.lml_mname(i)) exit
          !
          hydr_flag = .FALSE.
          do ia=ja,ja_end
             if(lmb_mname(l).eq.lma_mname(ia)) then
                if(lma_aname(ia).eq.lmb_1atm(l)) then
                   if(trim(lma_symb(ia)).eq.'H') then
                      hydr_flag = .TRUE.
                      exit
                   endif
                elseif(lma_aname(ia).eq.lmb_2atm(l)) then
                   if(trim(lma_symb(ia)).eq.'H') then
                      hydr_flag = .TRUE.
                      exit
                   endif
                endif
             endif
          enddo
          !  Do not add hydrogens
          if(.not.hydr_flag) write(iout,'(3a,2f8.3)')'bond_distance ',lmb_1atm(l),lmb_2atm(l),lmb_val(l),esd
       enddo
       !
       ! angles
       j = lml_ithet(i)
       do l=j,lmg_nangl
          if(lmg_mname(l).ne.lml_mname(i)) exit
          hydr_flag = .FALSE.
          do ia=ja,ja_end
             if(lmg_mname(l).eq.lma_mname(ia)) then
                if(lma_aname(ia).eq.lmg_1atm(l)) then
                   if(trim(lma_symb(ia)).eq.'H') then
                      hydr_flag = .TRUE.
                      exit
                   endif
                elseif(lma_aname(ia).eq.lmg_2atm(l)) then
                   if(trim(lma_symb(ia)).eq.'H') then
                      hydr_flag = .TRUE.
                      exit
                   endif
                elseif(lma_aname(ia).eq.lmg_3atm(l)) then
                   if(trim(lma_symb(ia)).eq.'H') then
                      hydr_flag = .TRUE.
                      exit
                   endif
                endif
             endif
          enddo
          esd = lmg_dev(l)
          if(esd.le.0.0) esd = 3.0
          if(.not.hydr_flag) write(iout,'(4a,2f7.3)')'bond_angle ',lmg_1atm(l),lmg_2atm(l),lmg_3atm(l),lmg_val(l),esd
       enddo
       !
       ! Torsion: Flexible and constants as fixed
       j = lml_itors(i)
       do l=j,lmt_ntors
          if(lmt_mname(l).ne.lml_mname(i)) exit
          hydr_flag = .FALSE.
          do ia=ja,ja_end
             if(lmt_mname(l).eq.lma_mname(ia)) then
                if(lma_aname(ia).eq.lmt_1atm(l)) then
                   if(trim(lma_symb(ia)).eq.'H') then
                      hydr_flag = .TRUE.
                      exit
                   endif
                elseif(lma_aname(ia).eq.lmt_2atm(l)) then
                   if(trim(lma_symb(ia)).eq.'H') then
                      hydr_flag = .TRUE.
                      exit
                   endif
                elseif(lma_aname(ia).eq.lmt_3atm(l)) then
                   if(trim(lma_symb(ia)).eq.'H') then
                      hydr_flag = .TRUE.
                      exit
                   endif
                elseif(lma_aname(ia).eq.lmt_4atm(l)) then
                   if(trim(lma_symb(ia)).eq.'H') then
                      hydr_flag = .TRUE.
                      exit
                   endif
                endif
             endif
          enddo
          esd = lmt_dev(l)
          if(.not.hydr_flag) then
             if(lmt_label(l)(1:5).eq.'CONST') then
                write(iout,'(5a,2f7.3)')'torsion_fixed ',lmt_1atm(l),lmt_2atm(l),lmt_3atm(l),lmt_4atm(l),lmt_val(l),esd
             else
                write(iout,'(5a,2f7.3)')'torsion_flexible ',lmt_1atm(l),lmt_2atm(l),lmt_3atm(l),lmt_4atm(l),lmt_val(l),esd
             endif
          endif
       enddo
       !
       !   Add chiralities as torsion angles
       
    enddo
    close(iout)
    return
    
  end subroutine write_odb_file


  subroutine read_odb_file(iun,nbondmax,natom,latom_name,nbond,lbond1,lbond2,lbond_val,nangle,langle,langle_val,  &
       ntors,ltors_atom,ltors_val,mon,ierr)
    implicit none
    !
    !---  inputs
    character mon*8
    integer iun
    integer natom,nbond,nangle,ntors
    integer nbondmax
    !
    !---outputs
    integer   ierr
    character(len=4), intent(out) :: latom_name(:)
    integer, intent(out) ::   ltors_atom(:,:)
    !
    integer, intent(out) :: lbond1(:),lbond2(:),langle(:,:)
    real,    intent(out) :: lbond_val(:,:),langle_val(:,:),ltors_val(:,:)
    !
    !---  locals, Another method for dynamic allocation. Programmer has less control over this.
    character*4 lbond1_ch(nbondmax),lbond2_ch(nbondmax)
    character*4 langle1_ch(nbondmax),langle2_ch(nbondmax),langle3_ch(nbondmax)
    character*4 ltors1_ch(nbondmax),ltors2_ch(nbondmax),ltors3_ch(nbondmax),ltors4_ch(nbondmax)

    integer i,l,is,is1,ia,ib,ib0,ie,ie1,ie2,ii
    integer in,nb1
    !
    integer maxitems,nitems
    parameter (maxitems = 200)
    integer ibeg(maxitems),iend(maxitems)
    character line_in*256,key*16
    character line1*256
    !

    !
    !
    integer mdoc
    integer iend_f,idef,nchange_flag,noptions
    logical found_mon,things_to_do
    character asymb*2
    real bdiff1,bdiff2
    !
    !   Body

    mdoc = 0
    rewind(iun)
    ierr = 0
    natom = 0
    nbond = 0
    nangle = 0
    ntors = 0

    things_to_do = .TRUE.
    found_mon = .FALSE.
    !
    ! Search for monomer (residue) in odb

    do while(things_to_do.and. .not.found_mon)
       read(iun,'(a)',iostat=iend_f)line_in
       if(iend_f.eq.0) then
          call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
          if(nitems.le.1) continue
          key = line_in(ibeg(1):iend(1))
          call ccpupc(key)
          if(key(1:4).eq.'RESI') then
             if(line_in(ibeg(2):iend(2)).eq.trim(mon)) then
                found_mon = .TRUE.
             endif
          endif
       else
          things_to_do = .FALSE.
       endif
    end do
    if(.not.found_mon) then
       write(*,*)'Error==> Monomomer ',trim(mon),' is not in the O sterechemistry - odb file'
       ierr = 1
    endif
    !
    !  We have the monomer we want. Start interpreting it.
    if(.not.found_mon) then
       write(*,*)'Error==> Monomer (residue) ',trim(mon),' could not be found in the list of odb monomers'
       ierr = 1
       return
    endif
    read(iun,'(a)',iostat=iend_f)line_in
    do while(things_to_do)
       l=len_trim(line_in)
       do while(line_in(l:l).eq.char(92))
          read(iun,'(a)',iostat=iend_f) line1
          if(iend_f.eq.0) then
             line_in = line_in(1:l-1)//' '//trim(line1)
          else
             line_in(l:l) = ' '
          endif
       enddo

       call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
       if(nitems.le.1) continue
       key = line_in(ibeg(1):iend(1))
       call ccpupc(key)
       if(key.eq.'RESIDUE') exit
       
       if(trim(key).eq.'ATOM') then
          do i=2,nitems
             natom = natom+1
             latom_name(natom) = line_in(ibeg(i):iend(i))
          enddo
       elseif(trim(key).eq.'BOND_DISTANCE') then
          nbond = nbond + 1
          lbond1_ch(nbond) = line_in(ibeg(2):iend(2))
          lbond2_ch(nbond) = line_in(ibeg(3):iend(3))
          read(line_in(ibeg(4):iend(5)),*)lbond_val(1:2,nbond)
       elseif(trim(key).eq.'BOND_ANGLE') then
          nangle = nangle + 1
          langle1_ch(nangle) = line_in(ibeg(2):iend(2))
          langle2_ch(nangle) = line_in(ibeg(3):iend(3))
          langle3_ch(nangle) = line_in(ibeg(4):iend(4))
          read(line_in(ibeg(5):iend(6)),*)langle_val(1:2,nangle)
       elseif(trim(key).eq.'TORSION_FIXED') then
          ntors = ntors + 1
          ltors1_ch(ntors) = line_in(ibeg(2):iend(2))
          ltors2_ch(ntors) = line_in(ibeg(3):iend(3))
          ltors3_ch(ntors) = line_in(ibeg(4):iend(4))
          ltors4_ch(ntors) = line_in(ibeg(5):iend(5))
          read(line_in(ibeg(6):iend(7)),*)ltors_val(1:2,ntors)          
       endif
       read(iun,'(a)',iostat=iend_f)line_in
    enddo
    if(nbond.gt.0) then
       do ib=1,nbond
          idef= 0
          do ia = 1,natom
             if(lbond1_ch(ib).eq.latom_name(ia)) then
                lbond1(ib) = ia
                idef = idef + 1
             endif
             if(lbond2_ch(ib).eq.latom_name(ia)) then
                lbond2(ib) = ia
                idef = idef + 1
             endif
             if(idef.eq.2) exit
          enddo
          if(idef.ne.2) then
             
          endif
       enddo
    endif
    
    if(nangle.gt.0) then
       do ib=1,nangle
          idef= 0
          do ia = 1,natom
             if(langle1_ch(ib).eq.latom_name(ia)) then
                langle(1,ib) = ia
                idef = idef + 1
             endif
             if(langle2_ch(ib).eq.latom_name(ia)) then
                langle(2,ib) = ia
                idef = idef + 1
             endif
             if(langle3_ch(ib).eq.latom_name(ia)) then
                langle(3,ib) = ia
                idef = idef + 1
             endif
             if(idef.eq.3) exit
          enddo
          if(idef.ne.3) then
             
          endif
       enddo
    endif
    
    if(ntors.gt.0) then
       do ib=1,ntors
          idef= 0
          do ia = 1,natom
             if(ltors1_ch(ib).eq.latom_name(ia)) then
                ltors_atom(1,ib) = ia
                idef = idef + 1
             endif
             if(ltors2_ch(ib).eq.latom_name(ia)) then
                ltors_atom(2,ib) = ia
                idef = idef + 1
             endif
             if(ltors3_ch(ib).eq.latom_name(ia)) then
                ltors_atom(3,ib) = ia
                idef = idef + 1
             endif
             if(ltors4_ch(ib).eq.latom_name(ia)) then
                ltors_atom(4,ib) = ia
                idef = idef + 1
             endif
             if(idef.eq.4) exit
          enddo
          if(idef.ne.4) then
             
          endif
       enddo
       
    endif

    return
  end subroutine read_odb_file

end module odbfiles
