program MultImp_collect
  use mtz_things
  use CellAndSymmetry
  use parser_things
  implicit none

  integer ifile
  character(len=3) :: ch3
  logical lexists
  integer i_fwt,i_delfwt,i_phwt,i_phdelwt
  integer, allocatable :: hkl_all(:,:)
  real, allocatable :: twofofc(:,:),fofc(:,:)
  character(len=512) :: labin_c=' ',labout_c=' '
  integer nfile
  character(len=512) :: file_root
  character(len=512) :: file_l
  real  pi,rtodeg,degtor

  integer nref

  pi = 4.0*atan(1.0)
  rtodeg = 180.0/pi
  degtor = pi/180.0
  !
  !   body
  !

  CALL CCP4_PROG_VERSION('MultImp_collect',0)
  CALL CCPFYP
  CALL MTZINI
  !   Instructions
  call read_instrs
  !
  !  Check existence of files
  if(len_trim(file_root).le.0.0) call ccperr(1,'File name is empty')
  write(*,*)
  write(*,*)' The number of input files = ',nfile
  do ifile=1,nfile
     write(ch3,'(i3)')ifile
     file_l =trim(file_root)//trim(adjustl(ch3))//'.mtz'
     write(*,*)'File no ',ifile,': ',trim(file_l)
     inquire(file=file_l,exist=lexists)
     if(.not.lexists) then
        write(*,*)'File: ',trim(file_l),' does not exist'
        call ccperr(1,'Fatal error')
     endif
  enddo
  write(*,*)
  !
  !   Read Sizes of files. In fact it is assumed that all files have 
  !
  call read_size
  if(nref.le.0) then
     write(*,*)'There is no reflection in files. File 1: ',trim(file_root)//'1.mtz'
     call ccperr(1,'Fatal error')
  endif
  write(*,*)'Number of reflections in each file ',nref

  allocate(hkl_all(3,nref))
  allocate(twofofc(2,nref))
  allocate(fofc(2,nref))

  call read_all_collect

  call write_mtz

  deallocate(hkl_all)
  deallocate(twofofc)
  deallocate(fofc)

contains  
  subroutine read_instrs
    !
    !   Parse the number of files, labin (default (FWT, PHWT), (DELFWT,PHDELWT))
    !   the number of files, root name for files. All files are assumed to be:
    !   file_root//file_number//'.mtz'
    !   These things should be command line
    !
    integer itk
    !
    !   body
    key = ' '
    line_parse = ' '
    lend = .FALSE.
    file_root = ' '
    do while(key.ne.'END' .and. .not.lend)
       line_parse = ' '
       call parser(key,line_parse,ibeg,iend,ityp,fvalue,cvalue,idec,ntok,lend,lprint)
       write(*,*)trim(line_parse)
       call ccpupc(key)
       do itk=1,ntok
          call ccpupc(cvalue(itk))
       enddo
       if(key.eq.'LABI') then 
          labin_c = line_parse
       elseif(key.eq.'LABO') then
          labout_c = line_parse
       elseif(key.eq.'NFIL') then
          nfile = nint(fvalue(2))
       elseif(key.eq.'ROOT') then
          file_root = line_parse(ibeg(2):iend(2))
       endif
    enddo
    if(len_trim(file_root).le.0) then
       call ugtenv('HKLIN',file_root)
       if(trim(file_root).eq.'HKLIN') file_root = ' '
    endif
    return

  end subroutine read_instrs

  subroutine assign_input_labels
    !
    !    Open mtz file and assign labels. Input labels are FWT etc. Output labes are FWT_tot etc
    !
    !   locals
    integer iprint,ifail,itk
    integer i,icell,ir
    integer ncol
    character*20 ff
    character ip_name*20,sigip_name*20,free_name*20,cl_tmp*20,cl_save*20
    character(len=512) :: file_in
    !
    !   body
    !
    mtzin = 1
    i_fwt     = 4
    i_phwt    = 5
    i_delfwt  = 6
    i_phdelwt = 7
    iprint =  0
    ifail  = -1

    nlprgi = 7
    lsprgi(1) = 'H'
    ctprgi(1) = 'H'
    lsprgi(2) = 'K'
    ctprgi(2) = 'H'
    lsprgi(3) = 'L'
    ctprgi(3) = 'H'
    lsprgi(4) = 'FWT'
    ctprgi(4) = 'F'
    lsprgi(5) = 'PHWT'
    ctprgi(5) = 'P'
    lsprgi(6) = 'DELFWT'
    ctprgi(6) = 'F'
    lsprgi(7) = 'PHDELWT'
    ctprgi(7) = 'P'


    if(len_trim(labin_c).le.0) then
       labin_c = 'LABIN FWT=FWT PHWT=PHWT DELFWT=DELFWT PHDELWT=PHDELWT'
    endif

    file_in = trim(file_root)//'1.mtz'
    call lropen(mtzin,file_in,iprint,ifail)

    call parser(key,labin_c,ibeg,iend,ityp,fvalue,cvalue,idec,ntok,lend,lprint)
    call lkyin(mtzin,lsprgi,nlprgi,ntok,labin_c,ibeg,iend)
    call lrassn(mtzin,lsprgi,nlprgi,lookup,ctprgi)

    if(lookup(i_fwt).le.0 .or. lookup(i_phwt).le.0 .or. lookup(i_delfwt).le.0.or.lookup(i_phdelwt).le.0) then
       call ccperr(1,'Fatal error: intensities, sigmas or freeR are absent from the input file')
    endif
    !
    !   Take datasets name 
    ndatasets = msets
    CALL LRIDX(MTZIN,PNAME,XNAME,DNAME,ISETS,DATCELL,DATWAVE,NDATASETS)
    IF (NDATASETS.GT.0) CALL LRCLID(MTZIN,CSETID,NCOL)
    setid = 0
    if(LookUp(i_fwt).ne.0) then
       setid = csetid(lookup(i_fwt))
    endif
    call lrclos(mtzin,0)


    return

  end subroutine assign_input_labels

  subroutine read_mtz_info
    
    integer i,j,is,isym_unit,nospgr,nsymp
    character namspg_cifs*20,nampg*20
    character text_now*128
    !
    integer temp_c
    real rrr(3,3,6)
    real res_max_mtz_1,res_min_mtz_1
    real, parameter :: pi = 4.0*atan(1.0)
    real, parameter :: rtodeg = 180.0/pi
    integer iprint,ifail

    character(len=512) :: file_in
    !
    !   body
    !
    !  Take all info from the mtz file

    file_in =trim(file_root)//'1.mtz'
    iprint = 0
    ifail = 01
    call lropen(mtzin,file_in,iprint,ifail)
    call lrsort(mtzin,isort)
    IF (NDATASETS.GT.0.and.setid.gt.0) THEN
       pname_out(1) = pname(1)
       dname_out(1) = dname(1)
       xname_out(1) = xname(1)
       datwave_out(1) = datwave(1)
       datcell_out(1:6,1) = datcell(1:6,1)
       csetout(5:nlprgo) = 1
       csetout(1:4) = csetid(lookup(1))

       i = 1
       do while(i.le.ndatasets.and.isets(i).ne.setid)
          i = i + 1
       enddo
       if (i.le.ndatasets) then
          pname_out(2) = pname(i)
          dname_out(2) = dname(i)
          xname_out(2) = xname(i)
          datwave_out(2) = datwave(i)
          datcell_out(1:6,2) = datcell(1:6,i)
          ndatasets_out = 2
          cell_mtz(1:6) = datcell(1:6,i)
       else
          call ccperr(1,'Problem accessing datasets in mtz')
       endif
    endif
    if (minval(cell_mtz(1:6)).le.0.0.or.setid.le.0.or.ndatasets.le.0) then
       call lrcell(mtzin,cell_mtz)
    endif
    cell(1:6) = cell_mtz(1:6)

    isym_unit = 0
    call msymlb3(isym_unit,nospgr,SpaceGroupName,namspg_cifs,nampg,nsymp,NumSymmetry,RealSymmMatrx)

    NumSpaceGroup = nospgr
    call lrsymi(mtzin,NumPrimSymm,Ltype,NumSpaceGroup,SpaceGroupName,PointGroupName)
    !CALL PGDEFN(PointGroupName,NumPrimSymm,NumSymmetry,RealSymmMatrx,LPRINT)
    !CALL PGNLAU(PointGroupName,NumLaueSymm,LaueGroupName)

    if(len_trim(SpaceGroupName).le.1)  nospgr = NumSpaceGroup
    if(trim(SpaceGroupName).eq.'R 3'.or. trim(SpaceGroupName).eq.'R3') then
       if(cell(6).le.5.0) then
          temp_c = nint(cell(6)*rtodeg)
       else
          temp_c = nint(cell(6))
       endif
       if(cell(1).eq.cell(2).and.temp_c.eq.120) then
          SpaceGroupName = 'H3'
       endif
    else if(trim(SpaceGroupName).eq.'H 3'.or.trim(SpaceGroupName).eq.'H3') then
       if(cell(1).eq.cell(2).and.cell(1).eq.cell(3).and.cell(4).eq.cell(6).and.cell(4).eq.cell(6)) then
          SpaceGroupName = 'R3'
       endif
    endif
    if(trim(SpaceGroupName).eq.'R 3 2'.or.trim(SpaceGroupName).eq.'R32') then
       if(cell(6).le.5.0) then
          temp_c = nint(cell(6)*rtodeg)
       else
          temp_c = nint(cell(6))
       endif
       if(cell(1).eq.cell(2).and.temp_c.eq.120) then
          SpaceGroupName = 'H32'
       endif
    else if(trim(SpaceGroupName).eq.'H 3 2'.or.trim(SpaceGroupName).eq.'H32') then
       if(cell(1).eq.cell(2).and.cell(1).eq.cell(3).and. cell(4).eq.cell(6).and.cell(4).eq.cell(6)) then
          SpaceGroupName = 'R32'
       endif
    endif

    call msymlb3(isym_unit,nospgr,SpaceGroupName,namspg_cifs,nampg,nsymp,NumSymmetry,RealSymmMatrx)
    
    NumSpaceGroup = nospgr
    call lrsymm(mtzin,NumSymmetry,RealSymmMatrx)
    write(*,*)
    write(*,*)'Space group                  = ',SpaceGroupName
    write(*,*)'Space group number           = ',nospgr
    write(*,*)'Number of symmetry operators = ',NumSymmetry
    write(*,*)'Space group elements '
    do is=1,NumSymmetry
       call put_symm_to_text(RealSymmMatrx(1:3,1:3,is),RealSymmMatrx(1:3,4,is),text_now)
       write(*,'(i5,2x,a)')is,trim(text_now)
    enddo
    write(*,*)
    call lrclos(mtzin,0)
    return

  end subroutine read_mtz_info


  subroutine read_size
    !
    !   Read the size: it is assumed that all files have the same size
    real ssq,adata(200)
    integer iref
    integer iprint,ifail
    logical eof
    character(len=512) :: file_l

    file_l = trim(file_root)//'1.mtz'
    iprint = 0
    ifail  = -1
    mtzin = 1
    call lropen(mtzin,file_l,iprint,ifail)
    call lrnref(mtzin,nref)
    write(*,*)mtzin,iprint,ifail,nref,trim(file_l)

    nref = 0
    call lrrefl(mtzin,ssq,adata,eof)
    do while(.not.eof)
       nref = nref + 1
       call lrrefl(mtzin,ssq,adata,eof)
    enddo
    call lrclos(mtzin,0)
    return

  end subroutine read_size

  subroutine read_all_collect
    !
    !   Read and average map coefficients. It is assumed that all files have a uniform shape,
    !   origin and hand of all phases are the same. So we only need to average.
    !   we need another routine to bring all of them to the same origin and hand
    real tmp,angle
    real ssq
    integer hkl_l(3)
    integer iref,ifile,iprint,ifail
    logical eof
    character(len=512) :: file_l
    real fwt,delfwt,phiwt,phidelwt
    !
    !   body    
    write(*,*)'To assign_input_labels'
    call assign_input_labels
    call read_mtz_info

    write(*,*)'After read_mtz_info',i_fwt,i_phwt,i_delfwt,i_phdelwt
    twofofc(1:2,1:nref) = 0.0
    fofc(1:2,1:nref) = 0.0
    mtzin = 1
    do ifile=1,nfile
       write(ch3,'(i3)')ifile
       file_l = trim(file_root)//trim(adjustl(ch3))//'.mtz'
       write(*,*)trim(file_l)

       iprint = 0
       ifail = -1
       call lropen(mtzin,file_l,iprint,ifail)
       iref = 0
       call lrrefl(mtzin,ssq,adata,eof)
       write(*,*)
       do while(.not.eof)
          iref = iref + 1
          if(iref.gt.nref) then
             write(*,*)
             write(*,*)'File no: ',ifile,' File name: ',trim(file_l)
             stop 'Error==> Too many reflections in one file'
          endif
          hkl_l = nint(adata(1:3))
          if(ifile.eq.1) then
             hkl_all(1:3,iref) = hkl_l
          elseif(maxval(abs(hkl_l-hkl_all(1:3,iref))).gt.0) then
             stop
          endif
          fwt = adata(lookup(i_fwt))
          phiwt = adata(lookup(i_phwt))
          delfwt = adata(lookup(i_delfwt))
          phidelwt = adata(lookup(i_phdelwt))
          twofofc(1,iref) = twofofc(1,iref) + fwt*cos(degtor*phiwt)
          twofofc(2,iref) = twofofc(2,iref) + fwt*sin(degtor*phiwt)
          fofc(1,iref) = fofc(1,iref) + delfwt*cos(degtor*phidelwt)
          fofc(2,iref) = fofc(2,iref) + delfwt*sin(degtor*phidelwt)
          call lrrefl(mtzin,ssq,adata,eof)
       enddo
       call lrclos(mtzin,0)
    enddo
    twofofc(1:2,1:nref) = twofofc(1:2,1:nref)/nfile
    fofc(1:2,1:nref)    = fofc(1:2,1:nref)/nfile
    do iref=1,nref
       tmp = sqrt(twofofc(1,iref)**2+twofofc(2,iref)**2)
       angle = 0.0
       if(tmp.gt.0.0)angle = rtodeg*atan2(twofofc(2,iref),twofofc(1,iref))
       twofofc(1,iref) = tmp
       twofofc(2,iref) = angle
       tmp = sqrt(fofc(1,iref)**2+fofc(2,iref)**2)
       angle = 0.0
       if(tmp.gt.0.0)angle = rtodeg*atan2(fofc(2,iref),fofc(1,iref))
       fofc(1,iref) = tmp
       fofc(2,iref) = angle
       !write(*,*)hkl_all(1:3,iref),twofofc(1:2,iref),fofc(1:2,iref)
    enddo
    return
  end subroutine read_all_collect

  subroutine write_mtz

    real bdata(200)
    integer iref

    call write_mtz_info

    write(*,*)'Aftet mtz info'
    do iref=1,nref

       call equal_magic(mtzout,bdata,nlprgo)
       bdata(1:3) = hkl_all(1:3,iref)
       bdata(4) = twofofc(1,iref)
       bdata(5) = twofofc(2,iref)
       bdata(6) = fofc(1,iref)
       bdata(7) = fofc(2,iref)
       call lwrefl(mtzout,bdata)
    enddo
    call lwclos(mtzout,0)

  end subroutine write_mtz

  subroutine write_mtz_info
    !
    !   locals
    integer i
    integer isetid
    integer :: iappnd = 0
    integer icol
    !
    !   body
    !
    !   Sort out output file. We will write 21 output files
    ctprgo(1:3) = 'H'
    lsprgo(1) = 'H'
    lsprgo(2) = 'K'
    lsprgo(3) = 'L'
    lsprgo(4) = 'FWT_tot'
    ctprgo(4) = 'F'
    lsprgo(5) = 'PHWT_tot'
    ctprgo(5) = 'P'
    lsprgo(6) = 'DELFWT_tot'
    ctprgo(6) = 'F'
    lsprgo(7) = 'PHDELWT_tot'
    ctprgo(7) = 'P'

    write(*,*)trim(labout_c)
    if(len_trim(labout_c).le.0) then
       labout_c = 'LABOUT'
       labout_c = trim(labout_c)//' FWT_tot=FWT_tot PHWT_tot=PHWT_tot'
       labout_c = trim(labout_c)//' DELFWT_tot=DELFWT_tot PHDELWT_tot=PHDELWT_tot'
    endif

    write(*,*)mtzout,' open'
    call lwopen(mtzout,'HKLOUT')
    ntok  = 200
    write(*,*)'To parser',trim(labout_c)
    call parser(key,labout_c,ibeg,iend,ityp,fvalue,cvalue,idec,ntok,lend,.FALSE.)
    nlprgo = 7
    write(*,*)'lkyout',nlprgo
    call lkyout(mtzout,lsprgo,nlprgo,ntok,labout_c,ibeg,iend)
    do i=1,nlprgo
       write(*,*)lsprgo(i)
    enddo
    write(*,*)'After lkyout '
    call lwassn(mtzout,lsprgo,nlprgo,ctprgo,0)
    write(*,*)'After lwassn'
    call lwclab(mtzout,lsprgo,nlprgo,ctprgo,0)

    write(*,*)mtzout,cell,isort

    CALL LWCELL(MTZOUT,CELL)
    CALL LWSORT(MTZOUT,ISORT)
    write(*,*)'lwsort '
    !
    !NumPrimSymm = NumSymmetry/NSMULT
    !            ******************************
    CALL LWSYMM(MTZOUT,NumSymmetry,NumPrimSymm,RealSymmMatrx,Ltype,NumSpaceGroup,SpaceGroupName,PointGroupName)
    ! Store the project name and dataset name in the mtz header:
    write(*,*)'After lwsymm'
    IF (NDATASETS_out.GT.0) THEN
       DO ISET = 1,NDATASETS_out
          CALL LWIDX(MTZOUT,PNAME_out(ISET),XNAME_out(ISET),DNAME_out(ISET),DATCELL_out(1,ISET),DATWAVE_out(ISET))
       ENDDO
       do  icol=1,nlprgo
          isetid = csetout(icol)+1
          xname_col(icol) = xname_out(isetid)
          dname_col(icol) = dname_out(isetid)
       enddo
       CALL LWIDASX(MTZOUT,NLPRGO,XNAME_col,DNAME_col,0)
    ENDIF
    write(*,*)'End of write_mtz_info'
  end subroutine write_mtz_info

end program MultImp_collect
  
